/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.transform;

import gnu.xml.transform.Stylesheet;
import gnu.xml.transform.TemplateNode;
import gnu.xml.xpath.Expr;
import java.util.ArrayList;
import java.util.Collections;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

abstract class AbstractNumberNode
extends TemplateNode {
    static final int ALPHABETIC = 0;
    static final int TRADITIONAL = 1;
    final TemplateNode format;
    final String lang;
    final int letterValue;
    final String groupingSeparator;
    final int groupingSize;
    static final int[] roman_numbers = new int[]{1, 5, 10, 50, 100, 500, 1000};
    static final char[] roman_chars = new char[]{'i', 'v', 'x', 'l', 'c', 'd', 'm'};

    AbstractNumberNode(TemplateNode format, String lang, int letterValue, String groupingSeparator, int groupingSize) {
        this.format = format;
        this.lang = lang;
        this.letterValue = letterValue;
        this.groupingSeparator = groupingSeparator;
        this.groupingSize = groupingSize;
    }

    void doApply(Stylesheet stylesheet, QName mode, Node context, int pos, int len, Node parent, Node nextSibling) throws TransformerException {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        DocumentFragment fragment = doc.createDocumentFragment();
        this.format.apply(stylesheet, mode, context, pos, len, fragment, null);
        String f = Expr._string(context, Collections.singleton(fragment));
        String value = this.format(f, this.compute(stylesheet, context, pos, len));
        Text text = doc.createTextNode(value);
        if (nextSibling != null) {
            parent.insertBefore(text, nextSibling);
        } else {
            parent.appendChild(text);
        }
        if (this.next != null) {
            this.next.apply(stylesheet, mode, context, pos, len, parent, nextSibling);
        }
    }

    /*
     * Unable to fully structure code
     */
    String format(String format, int[] number) {
        if (number.length == 0) {
            return "";
        }
        start = 0;
        end = 0;
        len = format.length();
        tokens = new ArrayList<String>(number.length * 2 + 1);
        types = new ArrayList<Boolean>(tokens.size());
        ** GOTO lbl27
        {
            ++end;
            do {
                if (end < len && !AbstractNumberNode.isAlphanumeric(format.charAt(end))) continue block0;
                if (end > start) {
                    tokens.add(format.substring(start, end));
                    types.add(Boolean.FALSE);
                }
                start = end;
                while (end < len && AbstractNumberNode.isAlphanumeric(format.charAt(end))) {
                    ++end;
                }
                if (end > start) {
                    tokens.add(format.substring(start, end));
                    types.add(Boolean.TRUE);
                }
                start = end;
lbl27:
                // 2 sources

            } while (end < len);
        }
        buf = new StringBuffer();
        len = tokens.size();
        pos = 0;
        i = 0;
        while (i < len) {
            token = i < 0 ? "." : (String)tokens.get(i);
            v0 = alpha = i < 0 ? true : (Boolean)types.get(i);
            if (!alpha) {
                buf.append(token);
            } else {
                if (pos < number.length) {
                    this.format(buf, number[pos++], token);
                    if ((i + 1 == len || i + 2 == len) && pos < number.length) {
                        i -= 2;
                    }
                }
                if (pos == number.length && i < len - 2 && ((Boolean)types.get((i = len - 2) + 1)).booleanValue()) {
                    ++i;
                }
            }
            ++i;
        }
        return buf.toString();
    }

    void format(StringBuffer buf, int number, String formatToken) {
        int len = formatToken.length();
        char c = formatToken.charAt(len - 1);
        if (Character.digit(c, 10) == 1) {
            int i = len - 2;
            while (i >= 0) {
                if (formatToken.charAt(i) != c - '\u0001') {
                    this.format(buf, number, "1");
                    return;
                }
                --i;
            }
            String val = Integer.toString(number);
            int d = len - val.length();
            while (d > 0) {
                buf.append('0');
                --d;
            }
            buf.append(val);
        } else if ("A".equals(formatToken)) {
            buf.append(AbstractNumberNode.alphabetic('@', number));
        } else if ("a".equals(formatToken)) {
            buf.append(AbstractNumberNode.alphabetic('`', number));
        } else if ("i".equals(formatToken)) {
            buf.append(AbstractNumberNode.roman(false, number));
        } else if ("I".equals(formatToken)) {
            buf.append(AbstractNumberNode.roman(true, number));
        } else {
            this.format(buf, number, "1");
        }
    }

    static final boolean isAlphanumeric(char c) {
        switch (Character.getType(c)) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    static final String alphabetic(char offset, int number) {
        StringBuffer buf = new StringBuffer();
        while (number > 0) {
            int r = number % 26;
            number /= 26;
            buf.insert(0, (char)(offset + r));
        }
        return buf.toString();
    }

    /*
     * Unable to fully structure code
     */
    static final String roman(boolean upper, int number) {
        buf = new StringBuffer();
        pos = AbstractNumberNode.roman_numbers.length - 1;
        while (pos >= 0) {
            block5: {
                block4: {
                    f = number / AbstractNumberNode.roman_numbers[pos];
                    if (f != 0) {
                        number %= f * AbstractNumberNode.roman_numbers[pos];
                    }
                    if (f > 4 && f < 9) {
                        buf.append(AbstractNumberNode.roman_chars[pos + 1]);
                        f -= 5;
                    }
                    if (f != 4) break block4;
                    buf.append(AbstractNumberNode.roman_chars[pos]);
                    buf.append(AbstractNumberNode.roman_chars[pos + 1]);
                    break block5;
                }
                if (f != 9) ** GOTO lbl27
                buf.append(AbstractNumberNode.roman_chars[pos]);
                buf.append(AbstractNumberNode.roman_chars[pos + 2]);
                break block5;
lbl-1000:
                // 1 sources

                {
                    buf.append(AbstractNumberNode.roman_chars[pos]);
                    --f;
lbl27:
                    // 2 sources

                    ** while (f > 0)
                }
            }
            pos -= 2;
        }
        return upper != false ? buf.toString().toUpperCase() : buf.toString();
    }

    abstract int[] compute(Stylesheet var1, Node var2, int var3, int var4) throws TransformerException;

    public boolean references(QName var) {
        if (this.format.references(var)) {
            return true;
        }
        return super.references(var);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("number");
        buf.append('[');
        buf.append("format=");
        buf.append(this.format);
        buf.append(']');
        return buf.toString();
    }
}

