/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.validation.datatype;

import gnu.xml.validation.datatype.AtomicSimpleType;
import gnu.xml.validation.datatype.TypeLibrary;
import javax.xml.namespace.QName;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;

final class GMonthType
extends AtomicSimpleType {
    static final int[] CONSTRAINING_FACETS = new int[]{4, 5, 6, 7, 8, 10, 9};

    GMonthType() {
        super(new QName("http://www.w3.org/2001/XMLSchema", "gMonth"), TypeLibrary.ANY_SIMPLE_TYPE);
    }

    public int[] getConstrainingFacets() {
        return CONSTRAINING_FACETS;
    }

    public void checkValid(String value, ValidationContext context) throws DatatypeException {
        int len = value.length();
        int state = 0;
        int start = 0;
        int i = 0;
        while (i < len) {
            char c = value.charAt(i);
            if (c < '0' || c > '9') {
                block0 : switch (state) {
                    case 0: {
                        if (c == '-') {
                            switch (i) {
                                case 0: {
                                    break block0;
                                }
                                case 1: {
                                    state = 1;
                                    start = i + 1;
                                    break block0;
                                }
                            }
                            throw new DatatypeException(i, "illegal GMonth value");
                        }
                    }
                    default: {
                        throw new DatatypeException(i, "illegal GMonth value");
                    }
                }
            }
            ++i;
        }
        switch (state) {
            case 1: {
                if (len - start == 2) break;
                throw new DatatypeException("illegal GMonth value");
            }
            default: {
                throw new DatatypeException("illegal GMonth value");
            }
        }
    }

    public Object createValue(String literal, ValidationContext context) {
        try {
            GMonth ret = new GMonth();
            ret.month = Integer.parseInt(literal.substring(2));
            return ret;
        }
        catch (Exception exception) {
            return null;
        }
    }

    static class GMonth
    implements Comparable {
        int month;

        GMonth() {
        }

        public int hashCode() {
            return this.month;
        }

        public boolean equals(Object other) {
            if (other instanceof GMonth) {
                return ((GMonth)other).month == this.month;
            }
            return false;
        }

        public int compareTo(Object other) {
            if (other instanceof GMonth) {
                GMonth gm = (GMonth)other;
                if (gm.month == this.month) {
                    return 0;
                }
                return this.month < gm.month ? -1 : 1;
            }
            return 0;
        }
    }
}

