/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.validation.datatype;

import gnu.xml.validation.datatype.EnumerationFacet;
import gnu.xml.validation.datatype.FractionDigitsFacet;
import gnu.xml.validation.datatype.LengthFacet;
import gnu.xml.validation.datatype.MaxExclusiveFacet;
import gnu.xml.validation.datatype.MaxInclusiveFacet;
import gnu.xml.validation.datatype.MaxLengthFacet;
import gnu.xml.validation.datatype.MinExclusiveFacet;
import gnu.xml.validation.datatype.MinInclusiveFacet;
import gnu.xml.validation.datatype.MinLengthFacet;
import gnu.xml.validation.datatype.PatternFacet;
import gnu.xml.validation.datatype.SimpleType;
import gnu.xml.validation.datatype.TotalDigitsFacet;
import gnu.xml.validation.datatype.WhiteSpaceFacet;
import java.util.LinkedHashSet;
import java.util.regex.Pattern;
import org.relaxng.datatype.Datatype;
import org.relaxng.datatype.DatatypeBuilder;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;

public class TypeBuilder
implements DatatypeBuilder {
    final SimpleType type;

    TypeBuilder(SimpleType type) {
        this.type = type;
        type.facets = new LinkedHashSet();
    }

    public void addParameter(String name, String value, ValidationContext context) throws DatatypeException {
        if ("length".equals(name)) {
            this.type.facets.add(this.parseLengthFacet(value));
        } else if ("minLength".equals(name)) {
            this.type.facets.add(this.parseMinLengthFacet(value));
        } else if ("maxLength".equals(name)) {
            this.type.facets.add(this.parseMaxLengthFacet(value));
        } else if ("pattern".equals(name)) {
            this.type.facets.add(this.parsePatternFacet(value));
        } else if ("enumeration".equals(name)) {
            this.type.facets.add(this.parseEnumerationFacet(value));
        } else if ("whiteSpace".equals(name)) {
            this.type.facets.add(this.parseWhiteSpaceFacet(value));
        } else if ("maxInclusive".equals(name)) {
            this.type.facets.add(this.parseMaxInclusiveFacet(value, context));
        } else if ("maxExclusive".equals(name)) {
            this.type.facets.add(this.parseMaxExclusiveFacet(value, context));
        } else if ("minExclusive".equals(name)) {
            this.type.facets.add(this.parseMinExclusiveFacet(value, context));
        } else if ("minInclusive".equals(name)) {
            this.type.facets.add(this.parseMinInclusiveFacet(value, context));
        } else if ("totalDigits".equals(name)) {
            this.type.facets.add(this.parseTotalDigitsFacet(value));
        } else if ("fractionDigits".equals(name)) {
            this.type.facets.add(this.parseFractionDigitsFacet(value));
        }
    }

    LengthFacet parseLengthFacet(String value) throws DatatypeException {
        int si = value.indexOf(32);
        boolean fixed = false;
        if (si != -1) {
            if (!"FIXED".equalsIgnoreCase(value.substring(si + 1))) {
                throw new DatatypeException("second argument must be FIXED if present");
            }
            fixed = true;
            value = value.substring(0, si);
        }
        return new LengthFacet(Integer.parseInt(value), fixed, null);
    }

    MinLengthFacet parseMinLengthFacet(String value) throws DatatypeException {
        int si = value.indexOf(32);
        boolean fixed = false;
        if (si != -1) {
            if (!"FIXED".equalsIgnoreCase(value.substring(si + 1))) {
                throw new DatatypeException("second argument must be FIXED if present");
            }
            fixed = true;
            value = value.substring(0, si);
        }
        return new MinLengthFacet(Integer.parseInt(value), fixed, null);
    }

    MaxLengthFacet parseMaxLengthFacet(String value) throws DatatypeException {
        int si = value.indexOf(32);
        boolean fixed = false;
        if (si != -1) {
            if (!"FIXED".equalsIgnoreCase(value.substring(si + 1))) {
                throw new DatatypeException("second argument must be FIXED if present");
            }
            fixed = true;
            value = value.substring(0, si);
        }
        return new MaxLengthFacet(Integer.parseInt(value), fixed, null);
    }

    PatternFacet parsePatternFacet(String value) throws DatatypeException {
        return new PatternFacet(Pattern.compile(value), null);
    }

    EnumerationFacet parseEnumerationFacet(String value) throws DatatypeException {
        return new EnumerationFacet(value, null);
    }

    WhiteSpaceFacet parseWhiteSpaceFacet(String value) throws DatatypeException {
        int si = value.indexOf(32);
        boolean fixed = false;
        if (si != -1) {
            if (!"FIXED".equalsIgnoreCase(value.substring(si + 1))) {
                throw new DatatypeException("second argument must be FIXED if present");
            }
            fixed = true;
            value = value.substring(0, si);
        }
        if ("preserve".equals(value)) {
            return new WhiteSpaceFacet(0, fixed, null);
        }
        if ("replace".equals(value)) {
            return new WhiteSpaceFacet(1, fixed, null);
        }
        if ("collapse".equals(value)) {
            return new WhiteSpaceFacet(2, fixed, null);
        }
        throw new DatatypeException("argument must be preserve, replace, or collapse");
    }

    MaxInclusiveFacet parseMaxInclusiveFacet(String value, ValidationContext context) throws DatatypeException {
        int si = value.indexOf(32);
        boolean fixed = false;
        if (si != -1) {
            if (!"FIXED".equalsIgnoreCase(value.substring(si + 1))) {
                throw new DatatypeException("second argument must be FIXED if present");
            }
            fixed = true;
            value = value.substring(0, si);
        }
        return new MaxInclusiveFacet(this.type.createValue(value, context), fixed, null);
    }

    MaxExclusiveFacet parseMaxExclusiveFacet(String value, ValidationContext context) throws DatatypeException {
        int si = value.indexOf(32);
        boolean fixed = false;
        if (si != -1) {
            if (!"FIXED".equalsIgnoreCase(value.substring(si + 1))) {
                throw new DatatypeException("second argument must be FIXED if present");
            }
            fixed = true;
            value = value.substring(0, si);
        }
        return new MaxExclusiveFacet(this.type.createValue(value, context), fixed, null);
    }

    MinExclusiveFacet parseMinExclusiveFacet(String value, ValidationContext context) throws DatatypeException {
        int si = value.indexOf(32);
        boolean fixed = false;
        if (si != -1) {
            if (!"FIXED".equalsIgnoreCase(value.substring(si + 1))) {
                throw new DatatypeException("second argument must be FIXED if present");
            }
            fixed = true;
            value = value.substring(0, si);
        }
        return new MinExclusiveFacet(this.type.createValue(value, context), fixed, null);
    }

    MinInclusiveFacet parseMinInclusiveFacet(String value, ValidationContext context) throws DatatypeException {
        int si = value.indexOf(32);
        boolean fixed = false;
        if (si != -1) {
            if (!"FIXED".equalsIgnoreCase(value.substring(si + 1))) {
                throw new DatatypeException("second argument must be FIXED if present");
            }
            fixed = true;
            value = value.substring(0, si);
        }
        return new MinInclusiveFacet(this.type.createValue(value, context), fixed, null);
    }

    TotalDigitsFacet parseTotalDigitsFacet(String value) throws DatatypeException {
        int val;
        int si = value.indexOf(32);
        boolean fixed = false;
        if (si != -1) {
            if (!"FIXED".equalsIgnoreCase(value.substring(si + 1))) {
                throw new DatatypeException("second argument must be FIXED if present");
            }
            fixed = true;
            value = value.substring(0, si);
        }
        if ((val = Integer.parseInt(value)) < 0) {
            throw new DatatypeException("value must be a positiveInteger");
        }
        return new TotalDigitsFacet(val, fixed, null);
    }

    FractionDigitsFacet parseFractionDigitsFacet(String value) throws DatatypeException {
        int val;
        int si = value.indexOf(32);
        boolean fixed = false;
        if (si != -1) {
            if (!"FIXED".equalsIgnoreCase(value.substring(si + 1))) {
                throw new DatatypeException("second argument must be FIXED if present");
            }
            fixed = true;
            value = value.substring(0, si);
        }
        if ((val = Integer.parseInt(value)) < 0) {
            throw new DatatypeException("value must be a positiveInteger");
        }
        return new FractionDigitsFacet(val, fixed, null);
    }

    public Datatype createDatatype() {
        return this.type;
    }
}

