/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.event.KeyEvent;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AWTKeyStroke
implements Serializable {
    private static final long serialVersionUID = -6430539691155161871L;
    private static final int MODIFIERS_MASK = 16367;
    private static final LinkedHashMap<AWTKeyStroke, AWTKeyStroke> cache = new LinkedHashMap<AWTKeyStroke, AWTKeyStroke>(11, 0.75f, true){
        private static final int MAX_CACHE_SIZE = 2048;

        @Override
        protected boolean removeEldestEntry(Map.Entry<AWTKeyStroke, AWTKeyStroke> eldest) {
            return this.size() > 2048;
        }
    };
    private static AWTKeyStroke recent;
    private static Constructor ctor;
    static final HashMap<String, Object> vktable;
    private char keyChar;
    int keyCode;
    private int modifiers;
    private boolean onKeyRelease;

    static {
        vktable = new HashMap();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Field[] fields = KeyEvent.class.getFields();
                int i = fields.length;
                try {
                    while (--i >= 0) {
                        Field f = fields[i];
                        String name = f.getName();
                        if (!name.startsWith("VK_")) continue;
                        vktable.put(name.substring(3), f.get(null));
                    }
                }
                catch (Exception e) {
                    throw (Error)new InternalError().initCause(e);
                }
                return null;
            }
        });
    }

    protected AWTKeyStroke() {
        this.keyChar = (char)65535;
    }

    protected AWTKeyStroke(char keyChar, int keyCode, int modifiers, boolean onKeyRelease) {
        this.keyChar = keyChar;
        this.keyCode = keyCode;
        this.modifiers = modifiers;
        this.onKeyRelease = onKeyRelease;
    }

    protected static void registerSubclass(final Class<?> subclass) {
        if (subclass == null) {
            throw new IllegalArgumentException();
        }
        if (subclass.equals(ctor == null ? AWTKeyStroke.class : ctor.getDeclaringClass())) {
            return;
        }
        if (subclass.equals(AWTKeyStroke.class)) {
            cache.clear();
            recent = null;
            ctor = null;
            return;
        }
        try {
            ctor = (Constructor)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
                    Constructor c = subclass.getDeclaredConstructor(null);
                    c.setAccessible(true);
                    AWTKeyStroke cfr_ignored_0 = (AWTKeyStroke)c.newInstance(null);
                    return c;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (RuntimeException)new IllegalArgumentException().initCause(e.getCause());
        }
        cache.clear();
        recent = null;
    }

    public static AWTKeyStroke getAWTKeyStroke(char keyChar) {
        return AWTKeyStroke.getAWTKeyStroke(keyChar, 0, 0, false);
    }

    public static AWTKeyStroke getAWTKeyStroke(Character keyChar, int modifiers) {
        if (keyChar == null) {
            throw new IllegalArgumentException();
        }
        return AWTKeyStroke.getAWTKeyStroke(keyChar.charValue(), 0, AWTKeyStroke.extend(modifiers), false);
    }

    public static AWTKeyStroke getAWTKeyStroke(int keyCode, int modifiers, boolean release) {
        return AWTKeyStroke.getAWTKeyStroke('\uffff', keyCode, AWTKeyStroke.extend(modifiers), release);
    }

    public static AWTKeyStroke getAWTKeyStroke(int keyCode, int modifiers) {
        return AWTKeyStroke.getAWTKeyStroke('\uffff', keyCode, AWTKeyStroke.extend(modifiers), false);
    }

    public static AWTKeyStroke getAWTKeyStrokeForEvent(KeyEvent event) {
        switch (event.id) {
            case 400: {
                return AWTKeyStroke.getAWTKeyStroke(event.getKeyChar(), 0, AWTKeyStroke.extend(event.getModifiersEx()), false);
            }
            case 401: {
                return AWTKeyStroke.getAWTKeyStroke('\uffff', event.getKeyCode(), AWTKeyStroke.extend(event.getModifiersEx()), false);
            }
            case 402: {
                return AWTKeyStroke.getAWTKeyStroke('\uffff', event.getKeyCode(), AWTKeyStroke.extend(event.getModifiersEx()), true);
            }
        }
        return null;
    }

    public static AWTKeyStroke getAWTKeyStroke(String s) {
        Integer code;
        if (s == null) {
            throw new IllegalArgumentException("null argument");
        }
        StringTokenizer t = new StringTokenizer(s, " ");
        if (!t.hasMoreTokens()) {
            throw new IllegalArgumentException("no tokens '" + s + "'");
        }
        int modifiers = 0;
        boolean released = false;
        String token = null;
        do {
            if ("shift".equals(token = t.nextToken())) {
                modifiers |= 1;
                modifiers |= 0x40;
                continue;
            }
            if ("ctrl".equals(token) || "control".equals(token)) {
                modifiers |= 2;
                modifiers |= 0x80;
                continue;
            }
            if ("meta".equals(token)) {
                modifiers |= 4;
                modifiers |= 0x100;
                continue;
            }
            if ("alt".equals(token)) {
                modifiers |= 8;
                modifiers |= 0x200;
                continue;
            }
            if ("button1".equals(token)) {
                modifiers |= 0x400;
                continue;
            }
            if ("button2".equals(token)) {
                modifiers |= 0x800;
                continue;
            }
            if ("button3".equals(token)) {
                modifiers |= 0x1000;
                continue;
            }
            if ("typed".equals(token)) {
                if (t.hasMoreTokens()) {
                    token = t.nextToken();
                    if (!t.hasMoreTokens() && token.length() == 1) {
                        return AWTKeyStroke.getAWTKeyStroke(token.charAt(0), 0, modifiers, false);
                    }
                }
                throw new IllegalArgumentException("Invalid 'typed' argument '" + s + "'");
            }
            if ("pressed".equals(token)) {
                if (!t.hasMoreTokens()) break;
                token = t.nextToken();
                break;
            }
            if (!"released".equals(token)) break;
            released = true;
            if (!t.hasMoreTokens()) break;
            token = t.nextToken();
            break;
        } while (t.hasMoreTokens());
        if ((code = (Integer)vktable.get(token)) == null) {
            throw new IllegalArgumentException("Unknown token '" + token + "' in '" + s + "'");
        }
        if (t.hasMoreTokens()) {
            throw new IllegalArgumentException("Too many tokens: " + s);
        }
        return AWTKeyStroke.getAWTKeyStroke('\uffff', code, modifiers, released);
    }

    public final char getKeyChar() {
        return this.keyChar;
    }

    public final int getKeyCode() {
        return this.keyCode;
    }

    public final int getModifiers() {
        return this.modifiers;
    }

    public final boolean isOnKeyRelease() {
        return this.onKeyRelease;
    }

    public final int getKeyEventType() {
        return this.keyCode == 0 ? 400 : (this.onKeyRelease ? 402 : 401);
    }

    public int hashCode() {
        return (this.keyChar + '\u0001') * (this.keyCode + 1) * (this.modifiers + 1) * 2 + (this.onKeyRelease ? 1 : 2);
    }

    public final boolean equals(Object o) {
        if (!(o instanceof AWTKeyStroke)) {
            return false;
        }
        AWTKeyStroke s = (AWTKeyStroke)o;
        return this == o || this.keyChar == s.keyChar && this.keyCode == s.keyCode && this.modifiers == s.modifiers && this.onKeyRelease == s.onKeyRelease;
    }

    public String toString() {
        if (this.keyCode == 0) {
            return "keyChar " + KeyEvent.getKeyModifiersText(this.modifiers) + this.keyChar;
        }
        return "keyCode " + KeyEvent.getKeyModifiersText(this.modifiers) + KeyEvent.getKeyText(this.keyCode) + (this.onKeyRelease ? "-R" : "-P");
    }

    protected Object readResolve() throws ObjectStreamException {
        AWTKeyStroke s = cache.get(this);
        if (s != null) {
            return s;
        }
        cache.put(this, this);
        return this;
    }

    private static AWTKeyStroke getAWTKeyStroke(char keyChar, int keyCode, int modifiers, boolean release) {
        AWTKeyStroke stroke = recent;
        if (stroke != null && stroke.keyChar == keyChar && stroke.keyCode == keyCode && stroke.modifiers == modifiers && stroke.onKeyRelease == release) {
            return stroke;
        }
        Constructor c = ctor;
        if (c == null) {
            stroke = new AWTKeyStroke(keyChar, keyCode, modifiers, release);
        } else {
            try {
                stroke = (AWTKeyStroke)c.newInstance(null);
                stroke.keyChar = keyChar;
                stroke.keyCode = keyCode;
                stroke.modifiers = modifiers;
                stroke.onKeyRelease = release;
            }
            catch (Exception e) {
                throw (Error)new InternalError().initCause(e);
            }
        }
        AWTKeyStroke cached = cache.get(stroke);
        if (cached == null) {
            cache.put(stroke, stroke);
        } else {
            stroke = cached;
        }
        recent = stroke;
        return recent;
    }

    private static int extend(int mod) {
        if ((mod & 0x41) != 0) {
            mod |= 0x41;
        }
        if ((mod & 0x82) != 0) {
            mod |= 0x82;
        }
        if ((mod & 0x104) != 0) {
            mod |= 0x104;
        }
        if ((mod & 0x208) != 0) {
            mod |= 0x208;
        }
        if ((mod & 0x2020) != 0) {
            mod |= 0x2020;
        }
        if ((mod & 0x10) != 0) {
            mod |= 0x400;
        }
        return mod & 0x3FEF;
    }
}

