/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTError;
import java.awt.Adjustable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Point;
import java.awt.ScrollPaneAdjustable;
import java.awt.peer.ScrollPanePeer;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;

public class ScrollPane
extends Container
implements Accessible {
    public static final int SCROLLBARS_AS_NEEDED = 0;
    public static final int SCROLLBARS_ALWAYS = 1;
    public static final int SCROLLBARS_NEVER = 2;
    private static transient long next_scrollpane_number;
    private static final long serialVersionUID = 7956609840827222915L;
    private ScrollPaneAdjustable hAdjustable;
    private ScrollPaneAdjustable vAdjustable;
    private int scrollbarDisplayPolicy;
    private Point scrollPosition = new Point(0, 0);
    private boolean wheelScrollingEnabled;

    public ScrollPane() {
        this(0);
    }

    public ScrollPane(int scrollbarDisplayPolicy) {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        this.scrollbarDisplayPolicy = scrollbarDisplayPolicy;
        if (scrollbarDisplayPolicy != 1 && scrollbarDisplayPolicy != 0 && scrollbarDisplayPolicy != 2) {
            throw new IllegalArgumentException("Bad scrollbarDisplayPolicy: " + scrollbarDisplayPolicy);
        }
        if (scrollbarDisplayPolicy != 2) {
            this.hAdjustable = new ScrollPaneAdjustable(this, 0);
            this.vAdjustable = new ScrollPaneAdjustable(this, 1);
        }
        this.wheelScrollingEnabled = true;
        this.setSize(100, 100);
    }

    public int getScrollbarDisplayPolicy() {
        return this.scrollbarDisplayPolicy;
    }

    public Adjustable getHAdjustable() {
        return this.hAdjustable;
    }

    public Adjustable getVAdjustable() {
        return this.vAdjustable;
    }

    public Dimension getViewportSize() {
        Dimension viewsize = this.getSize();
        Insets insets = this.getInsets();
        viewsize.width -= insets.left + insets.right;
        viewsize.height -= insets.top + insets.bottom;
        Component[] list2 = this.getComponents();
        if (list2 == null || list2.length <= 0) {
            return viewsize;
        }
        Dimension dim = list2[0].getPreferredSize();
        if (dim.width <= 0 && dim.height <= 0) {
            return viewsize;
        }
        int vScrollbarWidth = this.getVScrollbarWidth();
        int hScrollbarHeight = this.getHScrollbarHeight();
        if (this.scrollbarDisplayPolicy == 1) {
            viewsize.width -= vScrollbarWidth;
            viewsize.height -= hScrollbarHeight;
            return viewsize;
        }
        if (this.scrollbarDisplayPolicy == 2) {
            return viewsize;
        }
        boolean mayNeedVertical = false;
        boolean mayNeedHorizontal = false;
        boolean needVertical = false;
        boolean needHorizontal = false;
        if (dim.height > viewsize.height) {
            needVertical = true;
        } else if (dim.height > viewsize.height - hScrollbarHeight) {
            mayNeedVertical = true;
        }
        if (dim.width > viewsize.width) {
            needHorizontal = true;
        } else if (dim.width > viewsize.width - vScrollbarWidth) {
            mayNeedHorizontal = true;
        }
        if (needVertical && mayNeedHorizontal) {
            needHorizontal = true;
        }
        if (needHorizontal && mayNeedVertical) {
            needVertical = true;
        }
        if (needHorizontal) {
            viewsize.height -= hScrollbarHeight;
        }
        if (needVertical) {
            viewsize.width -= vScrollbarWidth;
        }
        return viewsize;
    }

    public int getHScrollbarHeight() {
        ScrollPanePeer spp = (ScrollPanePeer)this.getPeer();
        if (spp != null) {
            return spp.getHScrollbarHeight();
        }
        return 0;
    }

    public int getVScrollbarWidth() {
        ScrollPanePeer spp = (ScrollPanePeer)this.getPeer();
        if (spp != null) {
            return spp.getVScrollbarWidth();
        }
        return 0;
    }

    public Point getScrollPosition() {
        if (this.getComponentCount() == 0) {
            throw new NullPointerException();
        }
        int x = 0;
        int y = 0;
        Adjustable v = this.getVAdjustable();
        Adjustable h = this.getHAdjustable();
        if (v != null) {
            y = v.getValue();
        }
        if (h != null) {
            x = h.getValue();
        }
        return new Point(x, y);
    }

    public void setScrollPosition(Point scrollPosition) throws IllegalArgumentException {
        this.setScrollPosition(scrollPosition.x, scrollPosition.y);
    }

    public void setScrollPosition(int x, int y) {
        ScrollPanePeer spp;
        if (this.getComponentCount() == 0) {
            throw new NullPointerException("child is null");
        }
        if (x > (int)((double)this.getComponent(0).getWidth() - this.getViewportSize().getWidth())) {
            x = (int)((double)this.getComponent(0).getWidth() - this.getViewportSize().getWidth());
        }
        if (y > (int)((double)this.getComponent(0).getHeight() - this.getViewportSize().getHeight())) {
            y = (int)((double)this.getComponent(0).getHeight() - this.getViewportSize().getHeight());
        }
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        Adjustable h = this.getHAdjustable();
        Adjustable v = this.getVAdjustable();
        if (h != null) {
            h.setValue(x);
        }
        if (v != null) {
            v.setValue(y);
        }
        if ((spp = (ScrollPanePeer)this.getPeer()) != null) {
            spp.setScrollPosition(x, y);
        }
    }

    public void addNotify() {
        if (this.peer != null) {
            return;
        }
        this.setPeer(this.getToolkit().createScrollPane(this));
        super.addNotify();
        Component[] list2 = this.getComponents();
        if (list2 != null && list2.length > 0 && list2[0].isLightweight()) {
            Panel panel = new Panel();
            panel.setLayout(new BorderLayout());
            panel.add(list2[0], "Center");
            this.add(panel);
        }
    }

    public void removeNotify() {
        super.removeNotify();
    }

    protected final void addImpl(Component component, Object constraints, int index) {
        Component[] list2 = this.getComponents();
        if (list2 != null && list2.length > 0) {
            this.remove(list2[0]);
        }
        super.addImpl(component, constraints, index);
    }

    public void doLayout() {
        this.layout();
    }

    public void layout() {
        Component[] list2 = this.getComponents();
        if (list2 != null && list2.length > 0) {
            ScrollPanePeer peer;
            Dimension dim = list2[0].getPreferredSize();
            Dimension vp = this.getViewportSize();
            if (dim.width < vp.width) {
                dim.width = vp.width;
            }
            if (dim.height < vp.height) {
                dim.height = vp.height;
            }
            if ((peer = (ScrollPanePeer)this.getPeer()) != null) {
                peer.childResized(dim.width, dim.height);
            }
            list2[0].setSize(dim);
            Point p = this.getScrollPosition();
            if (p.x > dim.width) {
                p.x = dim.width;
            }
            if (p.y > dim.height) {
                p.y = dim.height;
            }
            this.setScrollPosition(p);
            list2[0].setLocation(new Point());
        }
    }

    public final void setLayout(LayoutManager layoutManager) {
        throw new AWTError("ScrollPane controls layout");
    }

    public void printComponents(Graphics graphics) {
        super.printComponents(graphics);
    }

    public String paramString() {
        Insets insets = this.getInsets();
        return String.valueOf(this.getName()) + "," + this.getX() + "," + this.getY() + "," + this.getWidth() + "x" + this.getHeight() + "," + this.getIsValidString() + "," + "ScrollPosition=(" + this.scrollPosition.x + "," + this.scrollPosition.y + ")," + "Insets=(" + insets.top + "," + insets.left + "," + insets.bottom + "," + insets.right + ")," + "ScrollbarDisplayPolicy=" + this.getScrollbarDisplayPolicyString() + "," + "wheelScrollingEnabled=" + this.isWheelScrollingEnabled();
    }

    private String getScrollbarDisplayPolicyString() {
        if (this.getScrollbarDisplayPolicy() == 0) {
            return "as-needed";
        }
        if (this.getScrollbarDisplayPolicy() == 1) {
            return "always";
        }
        return "never";
    }

    private String getIsValidString() {
        if (this.isValid()) {
            return "valid";
        }
        return "invalid";
    }

    protected boolean eventTypeEnabled(int type) {
        if (type == 507) {
            return this.wheelScrollingEnabled;
        }
        return super.eventTypeEnabled(type);
    }

    public boolean isWheelScrollingEnabled() {
        return this.wheelScrollingEnabled;
    }

    public void setWheelScrollingEnabled(boolean enable) {
        this.wheelScrollingEnabled = enable;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTScrollPane();
        }
        return this.accessibleContext;
    }

    String generateName() {
        return "scrollpane" + ScrollPane.getUniqueLong();
    }

    private static synchronized long getUniqueLong() {
        return next_scrollpane_number++;
    }

    protected class AccessibleAWTScrollPane
    extends Container.AccessibleAWTContainer {
        private static final long serialVersionUID = 6100703663886637L;

        protected AccessibleAWTScrollPane() {
            super(ScrollPane.this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.SCROLL_PANE;
        }
    }
}

