/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import gnu.classpath.SystemProperties;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.LoggingMXBean;
import java.util.logging.LoggingPermission;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogManager {
    public static final String LOGGING_MXBEAN_NAME = "java.util.logging:type=Logging";
    private static LogManager logManager;
    private static LoggingMXBean loggingBean;
    private Map<String, WeakReference<Logger>> loggers;
    private Properties properties;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(LogManager.class);
    private static final String MANAGER_PROPERTY = "java.util.logging.manager";
    private static final String CONFIG_PROPERTY = "java.util.logging.config.class";
    private static final LoggingPermission controlPermission;

    static {
        controlPermission = new LoggingPermission("control", null);
    }

    protected LogManager() {
        this.loggers = new HashMap<String, WeakReference<Logger>>();
    }

    public static synchronized LogManager getLogManager() {
        if (logManager == null) {
            logManager = LogManager.makeLogManager();
            LogManager.initLogManager();
        }
        return logManager;
    }

    private static LogManager makeLogManager() {
        String managerClassName = SystemProperties.getProperty(MANAGER_PROPERTY);
        LogManager manager = (LogManager)LogManager.createInstance(managerClassName, LogManager.class, MANAGER_PROPERTY);
        if (manager == null) {
            manager = new LogManager();
        }
        return manager;
    }

    private static void initLogManager() {
        LogManager manager = LogManager.getLogManager();
        Logger.root.setLevel(Level.INFO);
        manager.addLogger(Logger.root);
        Object configurator = LogManager.createInstance(System.getProperty(CONFIG_PROPERTY), Object.class, CONFIG_PROPERTY);
        try {
            if (configurator == null) {
                manager.readConfiguration();
            }
        }
        catch (IOException iOException) {}
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        listener.getClass();
        this.pcs.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public synchronized boolean addLogger(Logger logger) {
        String name = logger.getName();
        WeakReference<Logger> ref = this.loggers.get(name);
        if (ref != null) {
            if (ref.get() != null) {
                return false;
            }
            this.loggers.remove(ref);
        }
        if (name != null && !name.equals("")) {
            this.checkAccess();
        }
        Logger parent = this.findAncestor(logger);
        this.loggers.put(name, new WeakReference<Logger>(logger));
        if (parent != logger.getParent()) {
            logger.setParent(parent);
        }
        Level logLevel = logger.getLevel();
        String searchName = name;
        String parentName = parent != null ? parent.getName() : "";
        while (logLevel == null && !searchName.equals(parentName)) {
            logLevel = LogManager.getLevelProperty(String.valueOf(searchName) + ".level", logLevel);
            int index = searchName.lastIndexOf(46);
            searchName = index > -1 ? searchName.substring(0, index) : "";
        }
        logger.setLevel(logLevel);
        Iterator<String> iter = this.loggers.keySet().iterator();
        while (iter.hasNext()) {
            Logger possChild = (Logger)this.loggers.get(iter.next()).get();
            if (possChild == null || possChild == logger || possChild.getParent() != parent || !possChild.getName().startsWith(name) || possChild.getName().charAt(name.length()) != '.') continue;
            possChild.setParent(logger);
        }
        return true;
    }

    private synchronized Logger findAncestor(Logger child) {
        String childName = child.getName();
        int childNameLength = childName.length();
        Logger best = Logger.root;
        int bestNameLength = 0;
        if (child == Logger.root) {
            return null;
        }
        for (String candName : this.loggers.keySet()) {
            Logger cand;
            int candNameLength = candName.length();
            if (candNameLength <= bestNameLength || childNameLength <= candNameLength || !childName.startsWith(candName) || childName.charAt(candNameLength) != '.' || (cand = (Logger)this.loggers.get(candName).get()) == null || cand == child) continue;
            bestNameLength = candName.length();
            best = cand;
        }
        return best;
    }

    public synchronized Logger getLogger(String name) {
        name.getClass();
        WeakReference<Logger> ref = this.loggers.get(name);
        if (ref != null) {
            return (Logger)ref.get();
        }
        return null;
    }

    public synchronized Enumeration<String> getLoggerNames() {
        return Collections.enumeration((Collection)this.loggers.keySet());
    }

    public synchronized void reset() throws SecurityException {
        this.checkAccess();
        this.properties = new Properties();
        Iterator<WeakReference<Logger>> iter = this.loggers.values().iterator();
        while (iter.hasNext()) {
            WeakReference<Logger> ref = iter.next();
            if (ref == null) continue;
            Logger logger = (Logger)ref.get();
            if (logger == null) {
                iter.remove();
                continue;
            }
            if (logger == Logger.root) continue;
            logger.resetLogger();
            logger.setLevel(null);
        }
        Logger.root.setLevel(Level.INFO);
        Logger.root.resetLogger();
    }

    public synchronized void readConfiguration() throws IOException, SecurityException {
        InputStream inputStream;
        String path = System.getProperty("java.util.logging.config.file");
        if (path == null || path.length() == 0) {
            String url = String.valueOf(System.getProperty("gnu.classpath.home.url")) + "/logging.properties";
            try {
                inputStream = new URL(url).openStream();
            }
            catch (Exception exception) {
                inputStream = null;
            }
            if (inputStream == null) {
                String defaultConfig = "handlers = java.util.logging.ConsoleHandler   \n.level=INFO \n";
                inputStream = new ByteArrayInputStream(defaultConfig.getBytes());
            }
        } else {
            inputStream = new FileInputStream(path);
        }
        try {
            this.readConfiguration(inputStream);
        }
        finally {
            ((InputStream)inputStream).close();
        }
    }

    public synchronized void readConfiguration(InputStream inputStream) throws IOException, SecurityException {
        this.checkAccess();
        Properties newProperties = new Properties();
        newProperties.load(inputStream);
        this.reset();
        this.properties = newProperties;
        Enumeration<?> keys = newProperties.propertyNames();
        while (keys.hasMoreElements()) {
            String key = ((String)keys.nextElement()).trim();
            String value = newProperties.getProperty(key);
            if (value == null) continue;
            value = value.trim();
            if ("handlers".equals(key)) {
                StringTokenizer tokenizer = new StringTokenizer(value, " \t\n\r\f,");
                while (tokenizer.hasMoreTokens()) {
                    String handlerName = tokenizer.nextToken();
                    Handler handler = (Handler)LogManager.createInstance(handlerName, Handler.class, key);
                    if (handler == null) continue;
                    Logger.root.addHandler(handler);
                }
            }
            if (!key.endsWith(".level")) continue;
            String loggerName = key.substring(0, key.length() - 6);
            Logger logger = this.getLogger(loggerName);
            if (logger == null) {
                logger = Logger.getLogger(loggerName);
                this.addLogger(logger);
            }
            Level level = null;
            try {
                level = Level.parse(value);
            }
            catch (IllegalArgumentException e) {
                LogManager.warn("bad level '" + value + "'", e);
            }
            if (level == null) continue;
            logger.setLevel(level);
        }
        this.pcs.firePropertyChange(null, null, null);
    }

    public synchronized String getProperty(String name) {
        if (this.properties != null) {
            return this.properties.getProperty(name);
        }
        return null;
    }

    static int getIntProperty(String name, int defaultValue) {
        try {
            return Integer.parseInt(LogManager.getLogManager().getProperty(name));
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    static int getIntPropertyClamped(String name, int defaultValue, int minValue, int maxValue) {
        int val = LogManager.getIntProperty(name, defaultValue);
        if (val < minValue || val > maxValue) {
            val = defaultValue;
        }
        return val;
    }

    static boolean getBooleanProperty(String name, boolean defaultValue) {
        try {
            return Boolean.valueOf(LogManager.getLogManager().getProperty(name));
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    static Level getLevelProperty(String propertyName, Level defaultValue) {
        try {
            String value = LogManager.getLogManager().getProperty(propertyName);
            if (value != null) {
                return Level.parse(LogManager.getLogManager().getProperty(propertyName));
            }
            return defaultValue;
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    static final Class getClassProperty(String propertyName, Class defaultValue) {
        String propertyValue = logManager.getProperty(propertyName);
        if (propertyValue != null) {
            try {
                return LogManager.locateClass(propertyValue);
            }
            catch (ClassNotFoundException e) {
                LogManager.warn(String.valueOf(propertyName) + " = " + propertyValue, e);
            }
        }
        return defaultValue;
    }

    static final Object getInstanceProperty(String propertyName, Class ofClass, Class defaultClass) {
        Class klass = LogManager.getClassProperty(propertyName, defaultClass);
        if (klass == null) {
            return null;
        }
        try {
            Object obj = klass.newInstance();
            if (ofClass.isInstance(obj)) {
                return obj;
            }
        }
        catch (InstantiationException e) {
            LogManager.warn(String.valueOf(propertyName) + " = " + klass.getName(), e);
        }
        catch (IllegalAccessException e) {
            LogManager.warn(String.valueOf(propertyName) + " = " + klass.getName(), e);
        }
        if (defaultClass == null) {
            return null;
        }
        try {
            return defaultClass.newInstance();
        }
        catch (InstantiationException ex) {
            throw new RuntimeException(ex.getMessage());
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    public void checkAccess() throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(controlPermission);
        }
    }

    private static final Object createInstance(String className, Class type, String property) {
        Class klass = null;
        if (className == null || className.length() == 0) {
            return null;
        }
        try {
            klass = LogManager.locateClass(className);
            if (type.isAssignableFrom(klass)) {
                return klass.newInstance();
            }
            LogManager.warn(property, className, "not an instance of " + type.getName());
        }
        catch (ClassNotFoundException e) {
            LogManager.warn(property, className, "class not found", e);
        }
        catch (IllegalAccessException e) {
            LogManager.warn(property, className, "illegal access", e);
        }
        catch (InstantiationException e) {
            LogManager.warn(property, className, e);
        }
        catch (LinkageError e) {
            LogManager.warn(property, className, "linkage error", e);
        }
        return null;
    }

    private static final void warn(String property, String klass, Throwable t) {
        LogManager.warn(property, klass, null, t);
    }

    private static final void warn(String property, String klass, String msg) {
        LogManager.warn(property, klass, msg, null);
    }

    private static final void warn(String property, String klass, String msg, Throwable t) {
        LogManager.warn("error instantiating '" + klass + "' referenced by " + property + (msg == null ? "" : ", " + msg), t);
    }

    private static final void warn(String msg, Throwable t) {
        System.err.println("WARNING: " + msg);
        if (t != null) {
            t.printStackTrace(System.err);
        }
    }

    private static Class locateClass(String name) throws ClassNotFoundException {
        Thread t = Thread.currentThread();
        ClassLoader loader = t == null ? null : t.getContextClassLoader();
        try {
            return Class.forName(name, true, loader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            loader = ClassLoader.getSystemClassLoader();
            return Class.forName(name, true, loader);
        }
    }

    public static synchronized LoggingMXBean getLoggingMXBean() {
        if (loggingBean == null) {
            loggingBean = new LoggingMXBean(){

                public String getLoggerLevel(String logger) {
                    LogManager mgr = LogManager.getLogManager();
                    Logger l = mgr.getLogger(logger);
                    if (l == null) {
                        return null;
                    }
                    Level lev = l.getLevel();
                    if (lev == null) {
                        return "";
                    }
                    return lev.getName();
                }

                public List getLoggerNames() {
                    LogManager mgr = LogManager.getLogManager();
                    return Collections.list(mgr.getLoggerNames());
                }

                public String getParentLoggerName(String logger) {
                    LogManager mgr = LogManager.getLogManager();
                    Logger l = mgr.getLogger(logger);
                    if (l == null) {
                        return null;
                    }
                    if ((l = l.getParent()) == null) {
                        return "";
                    }
                    return l.getName();
                }

                public void setLoggerLevel(String logger, String level) {
                    LogManager mgr = LogManager.getLogManager();
                    Logger l = mgr.getLogger(logger);
                    if (l == null) {
                        throw new IllegalArgumentException("no logger named " + logger);
                    }
                    Level newLevel = level == null ? null : Level.parse(level);
                    l.setLevel(newLevel);
                }
            };
        }
        return loggingBean;
    }
}

