/*
 * Decompiled with CFR 0.152.
 */
package java.util.prefs;

import gnu.java.util.prefs.EventDispatcher;
import gnu.java.util.prefs.NodeWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.TreeSet;
import java.util.prefs.BackingStoreException;
import java.util.prefs.NodeChangeEvent;
import java.util.prefs.NodeChangeListener;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;

public abstract class AbstractPreferences
extends Preferences {
    protected final Object lock = new Object();
    protected boolean newNode = false;
    private final AbstractPreferences parent;
    private final String name;
    private boolean removed = false;
    private HashMap<String, AbstractPreferences> childCache = new HashMap();
    private ArrayList<NodeChangeListener> nodeListeners;
    private ArrayList<PreferenceChangeListener> preferenceListeners;

    protected AbstractPreferences(AbstractPreferences parent, String name) {
        if (name == null || name.length() > 80 || parent == null && name.length() != 0 || parent != null && name.length() == 0 || name.indexOf(47) != -1) {
            throw new IllegalArgumentException("Illegal name argument '" + name + "' (parent is " + (parent == null ? "" : "not ") + "null)");
        }
        this.parent = parent;
        this.name = name;
    }

    public String absolutePath() {
        if (this.parent == null) {
            return "/";
        }
        return String.valueOf(this.parent.path()) + '/' + this.name;
    }

    private String path() {
        if (this.parent == null) {
            return "";
        }
        return String.valueOf(this.parent.path()) + '/' + this.name;
    }

    public boolean isUserNode() {
        AbstractPreferences root = this;
        while (root.parent != null) {
            root = root.parent;
        }
        return root == Preferences.userRoot();
    }

    public String name() {
        return this.name;
    }

    public String toString() {
        return String.valueOf(this.isUserNode() ? "User" : "System") + " Preference Node: " + this.absolutePath();
    }

    protected final AbstractPreferences[] cachedChildren() {
        Collection<AbstractPreferences> vals = this.childCache.values();
        return vals.toArray(new AbstractPreferences[vals.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] childrenNames() throws BackingStoreException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isRemoved()) {
                throw new IllegalStateException("Node removed");
            }
            TreeSet<String> childrenNames = new TreeSet<String>();
            childrenNames.addAll((Collection)this.childCache.keySet());
            String[] names = this.childrenNamesSpi();
            int i = 0;
            while (i < names.length) {
                childrenNames.add(names[i]);
                ++i;
            }
            String[] children = new String[childrenNames.size()];
            childrenNames.toArray(children);
            return children;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Preferences node(String path) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isRemoved()) {
                throw new IllegalStateException("Node removed");
            }
            if (!path.startsWith("/")) {
                if (path.indexOf("//") != -1 || path.endsWith("/")) {
                    throw new IllegalArgumentException(path);
                }
                return this.getNode(path);
            }
        }
        Preferences root = this.isUserNode() ? AbstractPreferences.userRoot() : AbstractPreferences.systemRoot();
        return root.node(path.substring(1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Preferences getNode(String path) {
        String childPath;
        String childName;
        if (path.length() == 0) {
            return this;
        }
        int nextSlash = path.indexOf(47);
        if (nextSlash == -1) {
            childName = path;
            childPath = "";
        } else {
            childName = path.substring(0, nextSlash);
            childPath = path.substring(nextSlash + 1);
        }
        AbstractPreferences child = this.childCache.get(childName);
        if (child == null) {
            if (childName.length() > 80) {
                throw new IllegalArgumentException(childName);
            }
            child = this.childSpi(childName);
            this.childCache.put(childName, child);
            if (child.newNode && this.nodeListeners != null) {
                this.fire(new NodeChangeEvent(this, child), true);
            }
        }
        Object object = child.lock;
        synchronized (object) {
            return child.getNode(childPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean nodeExists(String path) throws BackingStoreException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isRemoved() && path.length() != 0) {
                throw new IllegalStateException("Node removed");
            }
            if (!path.startsWith("/")) {
                if (path.indexOf("//") != -1 || path.endsWith("/")) {
                    throw new IllegalArgumentException(path);
                }
                return this.existsNode(path);
            }
        }
        Preferences root = this.isUserNode() ? AbstractPreferences.userRoot() : AbstractPreferences.systemRoot();
        return root.nodeExists(path.substring(1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean existsNode(String path) throws BackingStoreException {
        String childPath;
        String childName;
        if (path.length() == 0) {
            return !this.isRemoved();
        }
        int nextSlash = path.indexOf(47);
        if (nextSlash == -1) {
            childName = path;
            childPath = "";
        } else {
            childName = path.substring(0, nextSlash);
            childPath = path.substring(nextSlash + 1);
        }
        AbstractPreferences child = this.childCache.get(childName);
        if (child == null) {
            if (childName.length() > 80) {
                throw new IllegalArgumentException(childName);
            }
            child = this.getChild(childName);
            if (child == null) {
                return false;
            }
            this.childCache.put(childName, child);
        }
        Object object = child.lock;
        synchronized (object) {
            return child.existsNode(childPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractPreferences getChild(String name) throws BackingStoreException {
        Object object = this.lock;
        synchronized (object) {
            String[] names = this.childrenNamesSpi();
            int i = 0;
            while (i < names.length) {
                if (name.equals(names[i])) {
                    return this.childSpi(name);
                }
                ++i;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isRemoved() {
        Object object = this.lock;
        synchronized (object) {
            return this.removed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Preferences parent() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isRemoved()) {
                throw new IllegalStateException("Node removed");
            }
            return this.parent;
        }
    }

    public void exportNode(OutputStream os) throws BackingStoreException, IOException {
        NodeWriter nodeWriter = new NodeWriter(this, os);
        nodeWriter.writePrefs();
    }

    public void exportSubtree(OutputStream os) throws BackingStoreException, IOException {
        NodeWriter nodeWriter = new NodeWriter(this, os);
        nodeWriter.writePrefsTree();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] keys() throws BackingStoreException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isRemoved()) {
                throw new IllegalStateException("Node removed");
            }
            return this.keysSpi();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String key, String defaultVal) {
        if (key.length() > 80) {
            throw new IllegalArgumentException(key);
        }
        Object object = this.lock;
        synchronized (object) {
            String value;
            if (this.isRemoved()) {
                throw new IllegalStateException("Node removed");
            }
            try {
                value = this.getSpi(key);
            }
            catch (ThreadDeath death) {
                throw death;
            }
            catch (Throwable throwable) {
                value = null;
            }
            if (value != null) {
                return value;
            }
            return defaultVal;
        }
    }

    public boolean getBoolean(String key, boolean defaultVal) {
        String value = this.get(key, null);
        if ("true".equalsIgnoreCase(value)) {
            return true;
        }
        if ("false".equalsIgnoreCase(value)) {
            return false;
        }
        return defaultVal;
    }

    public byte[] getByteArray(String key, byte[] defaultVal) {
        String value = this.get(key, null);
        byte[] b = null;
        if (value != null) {
            b = AbstractPreferences.decode64(value);
        }
        if (b != null) {
            return b;
        }
        return defaultVal;
    }

    private static byte[] decode64(String s) {
        ByteArrayOutputStream bs = new ByteArrayOutputStream(s.length() / 4 * 3);
        char[] c = new char[s.length()];
        s.getChars(0, s.length(), c, 0);
        int endchar = -1;
        int j = 0;
        while (j < c.length && endchar == -1) {
            if (c[j] >= 'A' && c[j] <= 'Z') {
                int n = j;
                c[n] = (char)(c[n] - 65);
            } else if (c[j] >= 'a' && c[j] <= 'z') {
                c[j] = (char)(c[j] + 26 - 97);
            } else if (c[j] >= '0' && c[j] <= '9') {
                c[j] = (char)(c[j] + 52 - 48);
            } else if (c[j] == '+') {
                c[j] = 62;
            } else if (c[j] == '/') {
                c[j] = 63;
            } else if (c[j] == '=') {
                endchar = j;
            } else {
                return null;
            }
            ++j;
        }
        int remaining = endchar == -1 ? c.length : endchar;
        int i = 0;
        while (remaining > 0) {
            byte b0 = (byte)(c[i] << 2);
            if (remaining >= 2) {
                b0 = (byte)(b0 + ((c[i + 1] & 0x30) >> 4));
            }
            bs.write(b0);
            if (remaining >= 3) {
                byte b1 = (byte)((c[i + 1] & 0xF) << 4);
                b1 = (byte)(b1 + (byte)((c[i + 2] & 0x3C) >> 2));
                bs.write(b1);
            }
            if (remaining >= 4) {
                byte b2 = (byte)((c[i + 2] & 3) << 6);
                b2 = (byte)(b2 + c[i + 3]);
                bs.write(b2);
            }
            i += 4;
            remaining -= 4;
        }
        return bs.toByteArray();
    }

    public double getDouble(String key, double defaultVal) {
        String value = this.get(key, null);
        if (value != null) {
            try {
                return Double.parseDouble(value);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return defaultVal;
    }

    public float getFloat(String key, float defaultVal) {
        String value = this.get(key, null);
        if (value != null) {
            try {
                return Float.parseFloat(value);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return defaultVal;
    }

    public int getInt(String key, int defaultVal) {
        String value = this.get(key, null);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return defaultVal;
    }

    public long getLong(String key, long defaultVal) {
        String value = this.get(key, null);
        if (value != null) {
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return defaultVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String key, String value) {
        if (key.length() > 80 || value.length() > 8192) {
            throw new IllegalArgumentException("key (" + key.length() + ")" + " or value (" + value.length() + ")" + " to large");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.isRemoved()) {
                throw new IllegalStateException("Node removed");
            }
            this.putSpi(key, value);
            if (this.preferenceListeners != null) {
                this.fire(new PreferenceChangeEvent(this, key, value));
            }
        }
    }

    public void putBoolean(String key, boolean value) {
        this.put(key, Boolean.toString(value));
    }

    public void putByteArray(String key, byte[] value) {
        this.put(key, AbstractPreferences.encode64(value));
    }

    private static String encode64(byte[] b) {
        StringBuffer sb = new StringBuffer(b.length / 3 * 4);
        int i = 0;
        int remaining = b.length;
        char[] c = new char[4];
        while (remaining > 0) {
            c[0] = (char)((b[i] & 0xFC) >> 2);
            c[1] = (char)((b[i] & 3) << 4);
            if (remaining >= 2) {
                c[1] = (char)(c[1] + (char)((b[i + 1] & 0xF0) >> 4));
                c[2] = (char)((b[i + 1] & 0xF) << 2);
                if (remaining >= 3) {
                    c[2] = (char)(c[2] + (char)((b[i + 2] & 0xC0) >> 6));
                    c[3] = (char)(b[i + 2] & 0x3F);
                } else {
                    c[3] = 64;
                }
            } else {
                c[2] = 64;
                c[3] = 64;
            }
            int j = 0;
            while (j < 4) {
                if (c[j] < '\u001a') {
                    int n = j;
                    c[n] = (char)(c[n] + 65);
                } else {
                    c[j] = c[j] < '4' ? (int)(c[j] - 26 + 97) : (c[j] < '>' ? (int)(c[j] - 52 + 48) : (c[j] == '>' ? 43 : (c[j] == '?' ? 47 : 61)));
                }
                ++j;
            }
            sb.append(c);
            i += 3;
            remaining -= 3;
        }
        return sb.toString();
    }

    public void putDouble(String key, double value) {
        this.put(key, Double.toString(value));
    }

    public void putFloat(String key, float value) {
        this.put(key, Float.toString(value));
    }

    public void putInt(String key, int value) {
        this.put(key, Integer.toString(value));
    }

    public void putLong(String key, long value) {
        this.put(key, Long.toString(value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String key) {
        if (key.length() > 80) {
            throw new IllegalArgumentException(key);
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.isRemoved()) {
                throw new IllegalStateException("Node removed");
            }
            this.removeSpi(key);
            if (this.preferenceListeners != null) {
                this.fire(new PreferenceChangeEvent(this, key, null));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws BackingStoreException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isRemoved()) {
                throw new IllegalStateException("Node Removed");
            }
            String[] keys = this.keys();
            int i = 0;
            while (i < keys.length) {
                this.removeSpi(keys[i]);
                ++i;
            }
        }
    }

    public void flush() throws BackingStoreException {
        this.flushNode(false);
    }

    public void sync() throws BackingStoreException {
        this.flushNode(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushNode(boolean sync) throws BackingStoreException {
        String[] keys = null;
        Object object = this.lock;
        synchronized (object) {
            if (sync) {
                this.syncSpi();
            } else {
                this.flushSpi();
            }
            keys = this.childCache.keySet().toArray(new String[0]);
        }
        if (keys != null) {
            int i = 0;
            while (i < keys.length) {
                AbstractPreferences subNode;
                Object object2 = this.lock;
                synchronized (object2) {
                    subNode = this.childCache.get(keys[i]);
                }
                if (subNode != null) {
                    subNode.flushNode(sync);
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNode() throws BackingStoreException {
        if (this.parent == null) {
            throw new UnsupportedOperationException("Cannot remove root node");
        }
        Object object = this.parent.lock;
        synchronized (object) {
            Object object2 = this.lock;
            synchronized (object2) {
                if (this.isRemoved()) {
                    throw new IllegalStateException("Node Removed");
                }
                this.purge();
            }
            this.parent.childCache.remove(this.name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purge() throws BackingStoreException {
        String[] children = this.childrenNamesSpi();
        int i = 0;
        while (i < children.length) {
            if (this.childCache.get(children[i]) == null) {
                this.childCache.put(children[i], this.childSpi(children[i]));
            }
            ++i;
        }
        for (AbstractPreferences node2 : this.childCache.values()) {
            Object object = node2.lock;
            synchronized (object) {
                node2.purge();
            }
        }
        this.childCache.clear();
        this.removeNodeSpi();
        this.removed = true;
        if (this.nodeListeners != null) {
            this.fire(new NodeChangeEvent(this.parent, this), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNodeChangeListener(NodeChangeListener listener) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isRemoved()) {
                throw new IllegalStateException("node has been removed");
            }
            if (listener == null) {
                throw new NullPointerException("listener is null");
            }
            if (this.nodeListeners == null) {
                this.nodeListeners = new ArrayList();
            }
            this.nodeListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPreferenceChangeListener(PreferenceChangeListener listener) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isRemoved()) {
                throw new IllegalStateException("node has been removed");
            }
            if (listener == null) {
                throw new NullPointerException("listener is null");
            }
            if (this.preferenceListeners == null) {
                this.preferenceListeners = new ArrayList();
            }
            this.preferenceListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNodeChangeListener(NodeChangeListener listener) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isRemoved()) {
                throw new IllegalStateException("node has been removed");
            }
            if (listener == null) {
                throw new NullPointerException("listener is null");
            }
            if (this.nodeListeners != null) {
                this.nodeListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePreferenceChangeListener(PreferenceChangeListener listener) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isRemoved()) {
                throw new IllegalStateException("node has been removed");
            }
            if (listener == null) {
                throw new NullPointerException("listener is null");
            }
            if (this.preferenceListeners != null) {
                this.preferenceListeners.remove(listener);
            }
        }
    }

    private void fire(final PreferenceChangeEvent event) {
        for (final PreferenceChangeListener l : this.preferenceListeners) {
            EventDispatcher.dispatch(new Runnable(){

                public void run() {
                    l.preferenceChange(event);
                }
            });
        }
    }

    private void fire(final NodeChangeEvent event, final boolean added) {
        for (final NodeChangeListener l : this.nodeListeners) {
            EventDispatcher.dispatch(new Runnable(){

                public void run() {
                    if (added) {
                        l.childAdded(event);
                    } else {
                        l.childRemoved(event);
                    }
                }
            });
        }
    }

    protected abstract String[] childrenNamesSpi() throws BackingStoreException;

    protected abstract AbstractPreferences childSpi(String var1);

    protected abstract String[] keysSpi() throws BackingStoreException;

    protected abstract String getSpi(String var1);

    protected abstract void putSpi(String var1, String var2);

    protected abstract void removeSpi(String var1);

    protected abstract void flushSpi() throws BackingStoreException;

    protected abstract void syncSpi() throws BackingStoreException;

    protected abstract void removeNodeSpi() throws BackingStoreException;
}

