/*
 * Decompiled with CFR 0.152.
 */
package javax.accessibility;

import java.util.Vector;
import javax.accessibility.AccessibleRelation;

public class AccessibleRelationSet {
    protected Vector<AccessibleRelation> relations = new Vector();

    public AccessibleRelationSet() {
    }

    public AccessibleRelationSet(AccessibleRelation[] relations) {
        this.addAll(relations);
    }

    public boolean add(AccessibleRelation relation) {
        AccessibleRelation old = this.get(relation.key);
        if (old == null) {
            return this.relations.add(relation);
        }
        if (old.targets.length == 0) {
            old.targets = relation.targets;
        } else if (relation.targets.length != 0) {
            Object[] t = new Object[old.targets.length + relation.targets.length];
            System.arraycopy(old.targets, 0, t, 0, old.targets.length);
            System.arraycopy(relation.targets, 0, t, old.targets.length, relation.targets.length);
            old.targets = t;
        }
        return true;
    }

    public void addAll(AccessibleRelation[] array) {
        int i = array.length;
        while (--i >= 0) {
            this.add(array[i]);
        }
    }

    public boolean remove(AccessibleRelation relation) {
        return this.relations.remove(relation);
    }

    public void clear() {
        this.relations.clear();
    }

    public int size() {
        return this.relations.size();
    }

    public boolean contains(String key) {
        int i = this.relations.size();
        while (--i >= 0) {
            if (!this.relations.get((int)i).key.equals(key)) continue;
            return true;
        }
        return false;
    }

    public AccessibleRelation get(String key) {
        int i = this.relations.size();
        while (--i >= 0) {
            AccessibleRelation r = this.relations.get(i);
            if (!r.key.equals(key)) continue;
            return r;
        }
        return null;
    }

    public AccessibleRelation[] toArray() {
        AccessibleRelation[] result = new AccessibleRelation[this.relations.size()];
        this.relations.toArray((S[])result);
        return result;
    }

    public String toString() {
        int i = this.relations.size();
        if (i == 0) {
            return "";
        }
        StringBuffer b = new StringBuffer(i * 10);
        while (--i >= 0) {
            b.append(this.relations.get(i)).append(',');
        }
        return b.substring(0, b.length() - 1);
    }
}

