/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.security.Permission;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class MBeanPermission
extends Permission {
    private static final long serialVersionUID = -2416928705275160661L;
    private String actions;
    private transient Set actionSet;
    private static final Set validSet = new HashSet();

    static {
        validSet.add("addNotificationListener");
        validSet.add("getAttribute");
        validSet.add("getClassLoader");
        validSet.add("getClassLoaderFor");
        validSet.add("getClassLoaderRepository");
        validSet.add("getDomains");
        validSet.add("getMBeanInfo");
        validSet.add("getObjectInstance");
        validSet.add("instantiate");
        validSet.add("invoke");
        validSet.add("isInstanceOf");
        validSet.add("queryMBeans");
        validSet.add("queryNames");
        validSet.add("registerMBean");
        validSet.add("removeNotificationListener");
        validSet.add("setAttribute");
        validSet.add("unregisterMBean");
    }

    public MBeanPermission(String name, String actions) {
        super(name);
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("The supplied name was null or empty.");
        }
        if (actions == null || actions.length() == 0) {
            throw new IllegalArgumentException("The supplied action list was null or empty.");
        }
        this.actions = actions;
        this.updateActionSet();
    }

    public MBeanPermission(String className, String member, ObjectName name, String actions) {
        this(String.valueOf(className == null ? "-" : className) + "#" + (member == null ? "-" : member) + "[" + (name == null ? "-" : name.toString()) + "]", actions);
    }

    public boolean equals(Object obj) {
        if (obj instanceof MBeanPermission) {
            MBeanPermission p = (MBeanPermission)obj;
            return p.getName().equals(this.getName()) && p.getActions().equals(this.actions);
        }
        return false;
    }

    public String getActions() {
        Iterator it = this.actionSet.iterator();
        StringBuilder builder = new StringBuilder();
        while (it.hasNext()) {
            builder.append(it.next());
            if (!it.hasNext()) continue;
            builder.append(",");
        }
        return builder.toString();
    }

    public int hashCode() {
        return this.getName().hashCode() + this.actions.hashCode();
    }

    public boolean implies(Permission p) {
        if (p instanceof MBeanPermission) {
            MBeanPermission mp = (MBeanPermission)p;
            NameHolder pName = new NameHolder(mp.getName());
            NameHolder name = new NameHolder(this.getName());
            if (!name.equals(pName)) {
                return false;
            }
            for (String nextAction : mp.getActionSet()) {
                boolean found = this.actions.contains(nextAction);
                if (!found && nextAction.equals("queryNames")) {
                    found = this.actions.contains("queryMBeans");
                }
                if (found) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    Set getActionSet() {
        return this.actionSet;
    }

    private void updateActionSet() {
        String[] actionsArray = this.actions.split(",");
        this.actionSet = new TreeSet();
        int a = 0;
        while (a < actionsArray.length) {
            this.actionSet.add(actionsArray[a].trim());
            ++a;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.updateActionSet();
        this.checkActions();
    }

    private void checkActions() {
        for (String action : this.actionSet) {
            if (validSet.contains(action)) continue;
            throw new IllegalArgumentException("Invalid action " + action + " found.");
        }
    }

    private class NameHolder {
        private String className;
        private String member;
        private ObjectName objectName;

        public NameHolder(String name) {
            String objectName = null;
            int memberIndex = name.indexOf("#");
            int onIndex = name.indexOf("[");
            if (onIndex == -1) {
                if (memberIndex == -1) {
                    this.className = name;
                } else {
                    this.className = name.substring(0, memberIndex);
                    this.member = name.substring(memberIndex + 1);
                }
            } else if (memberIndex == -1) {
                this.className = name.substring(0, onIndex);
                objectName = name.substring(onIndex + 1, name.length() - 1);
            } else {
                this.className = name.substring(0, memberIndex);
                this.member = name.substring(memberIndex + 1, onIndex);
                objectName = name.substring(onIndex + 1, name.length() - 1);
            }
            if (this.className.equals("-")) {
                this.className = null;
            }
            if (this.member.equals("-")) {
                this.member = null;
            }
            if (objectName == null || objectName.equals("-")) {
                this.objectName = null;
            } else {
                try {
                    this.objectName = new ObjectName(objectName);
                }
                catch (MalformedObjectNameException e) {
                    throw (Error)new InternalError("Invalid object name.").initCause(e);
                }
            }
        }

        public boolean equals(Object obj) {
            if (obj instanceof NameHolder) {
                int wcIndex;
                NameHolder nh = (NameHolder)obj;
                boolean cn = false;
                String ocn = nh.getClassName();
                cn = ocn == null || this.className.equals("*") ? true : ((wcIndex = this.className.indexOf("*")) != -1 ? ocn.startsWith(this.className.substring(0, wcIndex)) : ocn.equals(this.className));
                boolean m = false;
                String om = nh.getMember();
                m = om == null || this.member.equals("*") ? true : om.equals(this.member);
                boolean on = false;
                ObjectName oon = nh.getObjectName();
                on = oon == null ? true : (this.objectName.isPattern() ? this.objectName.apply(oon) : oon.equals(this.objectName));
                return cn && m && on;
            }
            return false;
        }

        public String getClassName() {
            return this.className;
        }

        public String getMember() {
            return this.member;
        }

        public ObjectName getObjectName() {
            return this.objectName;
        }
    }
}

