/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import gnu.javax.swing.text.html.css.BorderWidth;
import gnu.javax.swing.text.html.css.CSSColor;
import gnu.javax.swing.text.html.css.CSSParser;
import gnu.javax.swing.text.html.css.CSSParserCallback;
import gnu.javax.swing.text.html.css.FontSize;
import gnu.javax.swing.text.html.css.FontStyle;
import gnu.javax.swing.text.html.css.FontWeight;
import gnu.javax.swing.text.html.css.Length;
import gnu.javax.swing.text.html.css.Selector;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.border.Border;
import javax.swing.event.ChangeListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.View;
import javax.swing.text.html.CSS;
import javax.swing.text.html.CSSBorder;
import javax.swing.text.html.HTML;
import javax.swing.text.html.MultiStyle;
import javax.swing.text.html.ParagraphView;
import javax.swing.text.html.ViewAttributeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StyleSheet
extends StyleContext {
    URL base;
    int baseFontSize = 4;
    private ArrayList linked;
    ArrayList css = new ArrayList();
    private HashMap resolvedStyles = new HashMap();

    public Style getRule(HTML.Tag t, Element e) {
        AttributeSet atts;
        ArrayList<Element> path = new ArrayList<Element>();
        Element el = e;
        while (el != null) {
            path.add(el);
            el = el.getParentElement();
        }
        StringBuilder selector = new StringBuilder();
        int count = path.size();
        int i = count - 1;
        while (i > 0) {
            el = (Element)path.get(i);
            atts = el.getAttributes();
            Object name = atts.getAttribute(StyleConstants.NameAttribute);
            selector.append(name.toString());
            if (atts.isDefined(HTML.Attribute.ID)) {
                selector.append('#');
                selector.append(atts.getAttribute(HTML.Attribute.ID));
            }
            if (atts.isDefined(HTML.Attribute.CLASS)) {
                selector.append('.');
                selector.append(atts.getAttribute(HTML.Attribute.CLASS));
            }
            if (atts.isDefined(HTML.Attribute.DYNAMIC_CLASS)) {
                selector.append(':');
                selector.append(atts.getAttribute(HTML.Attribute.DYNAMIC_CLASS));
            }
            if (atts.isDefined(HTML.Attribute.PSEUDO_CLASS)) {
                selector.append(':');
                selector.append(atts.getAttribute(HTML.Attribute.PSEUDO_CLASS));
            }
            selector.append(' ');
            --i;
        }
        selector.append(t.toString());
        el = (Element)path.get(0);
        atts = el.getAttributes();
        if (el.isLeaf()) {
            Object o = atts.getAttribute(t);
            atts = o instanceof AttributeSet ? (AttributeSet)o : null;
        }
        if (atts != null) {
            if (atts.isDefined(HTML.Attribute.ID)) {
                selector.append('#');
                selector.append(atts.getAttribute(HTML.Attribute.ID));
            }
            if (atts.isDefined(HTML.Attribute.CLASS)) {
                selector.append('.');
                selector.append(atts.getAttribute(HTML.Attribute.CLASS));
            }
            if (atts.isDefined(HTML.Attribute.DYNAMIC_CLASS)) {
                selector.append(':');
                selector.append(atts.getAttribute(HTML.Attribute.DYNAMIC_CLASS));
            }
            if (atts.isDefined(HTML.Attribute.PSEUDO_CLASS)) {
                selector.append(':');
                selector.append(atts.getAttribute(HTML.Attribute.PSEUDO_CLASS));
            }
        }
        return this.getResolvedStyle(selector.toString(), path, t);
    }

    private Style getResolvedStyle(String selector, List path, HTML.Tag tag) {
        Style style = (Style)this.resolvedStyles.get(selector);
        if (style == null) {
            style = this.resolveStyle(selector, path, tag);
        }
        return style;
    }

    private Style resolveStyle(String selector, List path, HTML.Tag tag) {
        int count = path.size();
        String[] tags = new String[count];
        Map[] attributes = new Map[count];
        int i = 0;
        while (i < count) {
            Element el = (Element)path.get(i);
            AttributeSet atts = el.getAttributes();
            if (i == 0 && el.isLeaf()) {
                Object o = atts.getAttribute(tag);
                atts = o instanceof AttributeSet ? (AttributeSet)o : null;
            }
            if (atts != null) {
                HTML.Tag t = (HTML.Tag)atts.getAttribute(StyleConstants.NameAttribute);
                tags[i] = t != null ? t.toString() : null;
                attributes[i] = this.attributeSetToMap(atts);
            } else {
                tags[i] = null;
                attributes[i] = null;
            }
            ++i;
        }
        tags[0] = tag.toString();
        return this.resolveStyle(selector, tags, attributes);
    }

    private Style resolveStyle(String selector, String[] tags, Map[] attributes) {
        int cfr_ignored_0 = tags.length;
        ArrayList<CSSStyle> styles = new ArrayList<CSSStyle>();
        for (CSSStyle style : this.css) {
            if (!style.selector.matches(tags, attributes)) continue;
            styles.add(style);
        }
        if (this.linked != null) {
            int i = this.linked.size() - 1;
            while (i >= 0) {
                StyleSheet ss = (StyleSheet)this.linked.get(i);
                int j = ss.css.size() - 1;
                while (j >= 0) {
                    CSSStyle style = (CSSStyle)ss.css.get(j);
                    if (style.selector.matches(tags, attributes)) {
                        styles.add(style);
                    }
                    --j;
                }
                --i;
            }
        }
        Collections.sort(styles);
        Style[] styleArray = new Style[styles.size()];
        styleArray = styles.toArray(styleArray);
        MultiStyle resolved = new MultiStyle(selector, styles.toArray(styleArray));
        this.resolvedStyles.put(selector, resolved);
        return resolved;
    }

    public Style getRule(String selector) {
        CSSStyle best = null;
        for (CSSStyle style : this.css) {
            if (style.compareTo(best) >= 0) continue;
            best = style;
        }
        return best;
    }

    public void addRule(String rule) {
        CSSStyleSheetParserCallback cb = new CSSStyleSheetParserCallback(200000);
        StringReader in = new StringReader(rule);
        CSSParser parser = new CSSParser(in, cb);
        try {
            parser.parse();
        }
        catch (IOException iOException) {}
        this.resolvedStyles.clear();
    }

    public AttributeSet getDeclaration(String decl) {
        if (decl == null) {
            return SimpleAttributeSet.EMPTY;
        }
        return null;
    }

    public void loadRules(Reader in, URL ref) throws IOException {
        CSSStyleSheetParserCallback cb = new CSSStyleSheetParserCallback(0);
        CSSParser parser = new CSSParser(in, cb);
        parser.parse();
    }

    public AttributeSet getViewAttributes(View v) {
        return new ViewAttributeSet(v, this);
    }

    @Override
    public void removeStyle(String nm) {
        super.removeStyle(nm);
    }

    public void addStyleSheet(StyleSheet ss) {
        if (this.linked == null) {
            this.linked = new ArrayList();
        }
        this.linked.add(ss);
    }

    public void removeStyleSheet(StyleSheet ss) {
        if (this.linked != null) {
            this.linked.remove(ss);
        }
    }

    public StyleSheet[] getStyleSheets() {
        StyleSheet[] linkedSS;
        if (this.linked != null) {
            linkedSS = new StyleSheet[this.linked.size()];
            linkedSS = this.linked.toArray(linkedSS);
        } else {
            linkedSS = null;
        }
        return linkedSS;
    }

    public void importStyleSheet(URL url) {
        try {
            InputStream in = url.openStream();
            BufferedReader r = new BufferedReader(new InputStreamReader(in));
            CSSStyleSheetParserCallback cb = new CSSStyleSheetParserCallback(200000);
            CSSParser parser = new CSSParser(r, cb);
            parser.parse();
        }
        catch (IOException iOException) {}
    }

    public void setBase(URL base) {
        this.base = base;
    }

    public URL getBase() {
        return this.base;
    }

    public void addCSSAttribute(MutableAttributeSet attr, CSS.Attribute key, String value) {
        Object val = CSS.getValue(key, value);
        CSS.addInternal(attr, key, value);
        attr.addAttribute(key, val);
    }

    public boolean addCSSAttributeFromHTML(MutableAttributeSet attr, CSS.Attribute key, String value) {
        attr.addAttribute(key, value);
        return attr.containsAttribute(key, value);
    }

    public AttributeSet translateHTMLToCSS(AttributeSet htmlAttrSet) {
        HTML.Tag tag;
        AttributeSet cssAttr = htmlAttrSet.copyAttributes();
        Object o = htmlAttrSet.getAttribute(HTML.Attribute.ALIGN);
        if (o != null) {
            cssAttr = this.addAttribute(cssAttr, CSS.Attribute.TEXT_ALIGN, o);
        }
        if ((o = htmlAttrSet.getAttribute(HTML.Attribute.WIDTH)) != null) {
            cssAttr = this.addAttribute(cssAttr, CSS.Attribute.WIDTH, new Length(o.toString()));
        }
        if ((o = htmlAttrSet.getAttribute(HTML.Attribute.HEIGHT)) != null) {
            cssAttr = this.addAttribute(cssAttr, CSS.Attribute.HEIGHT, new Length(o.toString()));
        }
        if ((o = htmlAttrSet.getAttribute(HTML.Attribute.NOWRAP)) != null) {
            cssAttr = this.addAttribute(cssAttr, CSS.Attribute.WHITE_SPACE, "nowrap");
        }
        if ((o = htmlAttrSet.getAttribute(HTML.Attribute.CELLSPACING)) != null) {
            cssAttr = this.addAttribute(cssAttr, CSS.Attribute.BORDER_SPACING, new Length(o.toString()));
        }
        if (((tag = (HTML.Tag)htmlAttrSet.getAttribute(StyleConstants.NameAttribute)) == HTML.Tag.TD || tag == HTML.Tag.TH) && htmlAttrSet instanceof Element) {
            Element el = (Element)((Object)htmlAttrSet);
            AttributeSet tableAttrs = el.getParentElement().getParentElement().getAttributes();
            o = tableAttrs.getAttribute(HTML.Attribute.CELLPADDING);
            if (o != null) {
                Length l = new Length(o.toString());
                cssAttr = this.addAttribute(cssAttr, CSS.Attribute.PADDING_BOTTOM, l);
                cssAttr = this.addAttribute(cssAttr, CSS.Attribute.PADDING_LEFT, l);
                cssAttr = this.addAttribute(cssAttr, CSS.Attribute.PADDING_RIGHT, l);
                cssAttr = this.addAttribute(cssAttr, CSS.Attribute.PADDING_TOP, l);
            }
            o = tableAttrs.getAttribute(HTML.Attribute.BORDER);
            cssAttr = this.translateBorder(cssAttr, o);
        }
        o = cssAttr.getAttribute(HTML.Attribute.BORDER);
        cssAttr = this.translateBorder(cssAttr, o);
        return cssAttr;
    }

    private AttributeSet translateBorder(AttributeSet cssAttr, Object o) {
        BorderWidth l;
        if (o != null && (l = new BorderWidth(o.toString())).getValue() > 0.0f) {
            cssAttr = this.addAttribute(cssAttr, CSS.Attribute.BORDER_WIDTH, l);
            cssAttr = this.addAttribute(cssAttr, CSS.Attribute.BORDER_STYLE, "solid");
            cssAttr = this.addAttribute(cssAttr, CSS.Attribute.BORDER_COLOR, new CSSColor("black"));
        }
        return cssAttr;
    }

    @Override
    public AttributeSet addAttribute(AttributeSet old, Object key, Object value) {
        return super.addAttribute(old, key, value);
    }

    @Override
    public AttributeSet addAttributes(AttributeSet old, AttributeSet attr) {
        return super.addAttributes(old, attr);
    }

    @Override
    public AttributeSet removeAttribute(AttributeSet old, Object key) {
        return super.removeAttribute(old, key);
    }

    @Override
    public AttributeSet removeAttributes(AttributeSet old, AttributeSet attrs) {
        return super.removeAttributes(old, attrs);
    }

    @Override
    public AttributeSet removeAttributes(AttributeSet old, Enumeration<?> names) {
        return super.removeAttributes(old, names);
    }

    @Override
    protected StyleContext.SmallAttributeSet createSmallAttributeSet(AttributeSet a) {
        return super.createSmallAttributeSet(a);
    }

    @Override
    protected MutableAttributeSet createLargeAttributeSet(AttributeSet a) {
        return super.createLargeAttributeSet(a);
    }

    @Override
    public Font getFont(AttributeSet a) {
        FontStyle fStyle;
        String v;
        int realSize = this.getFontSize(a);
        Object valign = a.getAttribute(CSS.Attribute.VERTICAL_ALIGN);
        if (valign != null && ((v = valign.toString()).contains("sup") || v.contains("sub"))) {
            realSize -= 2;
        }
        String family = "SansSerif";
        int style = 0;
        FontWeight weight = (FontWeight)a.getAttribute(CSS.Attribute.FONT_WEIGHT);
        if (weight != null) {
            style |= weight.getValue();
        }
        if ((fStyle = (FontStyle)a.getAttribute(CSS.Attribute.FONT_STYLE)) != null) {
            style |= fStyle.getValue();
        }
        return new Font(family, style, realSize);
    }

    float getEMBase(AttributeSet atts) {
        Font font = this.getFont(atts);
        FontRenderContext ctx = new FontRenderContext(null, false, false);
        Rectangle2D bounds = font.getStringBounds("M", ctx);
        return (float)bounds.getWidth();
    }

    float getEXBase(AttributeSet atts) {
        Font font = this.getFont(atts);
        FontRenderContext ctx = new FontRenderContext(null, false, false);
        Rectangle2D bounds = font.getStringBounds("x", ctx);
        return (float)bounds.getHeight();
    }

    private int getFontSize(AttributeSet atts) {
        int size = 12;
        if (atts.isDefined(CSS.Attribute.FONT_SIZE)) {
            FontSize fs = (FontSize)atts.getAttribute(CSS.Attribute.FONT_SIZE);
            if (fs.isRelative()) {
                int parSize = 12;
                AttributeSet resolver = atts.getResolveParent();
                if (resolver != null) {
                    parSize = this.getFontSize(resolver);
                }
                size = fs.getValue(parSize);
            } else {
                size = fs.getValue();
            }
        } else {
            AttributeSet resolver = atts.getResolveParent();
            if (resolver != null) {
                size = this.getFontSize(resolver);
            }
        }
        return size;
    }

    @Override
    public Color getForeground(AttributeSet a) {
        CSSColor c = (CSSColor)a.getAttribute(CSS.Attribute.COLOR);
        Color color = null;
        if (c != null) {
            color = c.getValue();
        }
        return color;
    }

    @Override
    public Color getBackground(AttributeSet a) {
        CSSColor c = (CSSColor)a.getAttribute(CSS.Attribute.BACKGROUND_COLOR);
        Color color = null;
        if (c != null) {
            color = c.getValue();
        }
        return color;
    }

    public BoxPainter getBoxPainter(AttributeSet a) {
        return new BoxPainter(a, this);
    }

    public ListPainter getListPainter(AttributeSet a) {
        return new ListPainter(a, this);
    }

    public void setBaseFontSize(int sz) {
        if (sz <= 7 && sz >= 1) {
            this.baseFontSize = sz;
        }
    }

    public void setBaseFontSize(String size) {
        size.trim();
        int temp = 0;
        try {
            if (size.length() == 2) {
                int i = new Integer(size.substring(1));
                if (size.startsWith("+")) {
                    temp = this.baseFontSize + i;
                } else if (size.startsWith("-")) {
                    temp = this.baseFontSize - i;
                }
            } else if (size.length() == 1) {
                temp = new Integer(size.substring(0));
            }
            if (temp <= 7 && temp >= 1) {
                this.baseFontSize = temp;
            }
        }
        catch (NumberFormatException numberFormatException) {}
    }

    public static int getIndexOfSize(float pt) {
        return 0;
    }

    public float getPointSize(int index) {
        return 0.0f;
    }

    public float getPointSize(String size) {
        return 0.0f;
    }

    public Color stringToColor(String colorName) {
        return CSSColor.convertValue(colorName);
    }

    private Map attributeSetToMap(AttributeSet atts) {
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration<?> keys = atts.getAttributeNames();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = atts.getAttribute(key);
            map.put(key.toString(), value.toString());
        }
        return map;
    }

    public static class BoxPainter
    implements Serializable {
        private float leftInset;
        private float rightInset;
        private float topInset;
        private float bottomInset;
        private Border border;
        private float leftPadding;
        private float rightPadding;
        private float topPadding;
        private float bottomPadding;
        private Color background;

        BoxPainter(AttributeSet as, StyleSheet ss) {
            float emBase = ss.getEMBase(as);
            float exBase = ss.getEXBase(as);
            Length l = (Length)as.getAttribute(CSS.Attribute.MARGIN_LEFT);
            if (l != null) {
                l.setFontBases(emBase, exBase);
                this.leftInset = l.getValue();
            }
            if ((l = (Length)as.getAttribute(CSS.Attribute.MARGIN_RIGHT)) != null) {
                l.setFontBases(emBase, exBase);
                this.rightInset = l.getValue();
            }
            if ((l = (Length)as.getAttribute(CSS.Attribute.MARGIN_TOP)) != null) {
                l.setFontBases(emBase, exBase);
                this.topInset = l.getValue();
            }
            if ((l = (Length)as.getAttribute(CSS.Attribute.MARGIN_BOTTOM)) != null) {
                l.setFontBases(emBase, exBase);
                this.bottomInset = l.getValue();
            }
            if ((l = (Length)as.getAttribute(CSS.Attribute.PADDING_LEFT)) != null) {
                l.setFontBases(emBase, exBase);
                this.leftPadding = l.getValue();
            }
            if ((l = (Length)as.getAttribute(CSS.Attribute.PADDING_RIGHT)) != null) {
                l.setFontBases(emBase, exBase);
                this.rightPadding = l.getValue();
            }
            if ((l = (Length)as.getAttribute(CSS.Attribute.PADDING_TOP)) != null) {
                l.setFontBases(emBase, exBase);
                this.topPadding = l.getValue();
            }
            if ((l = (Length)as.getAttribute(CSS.Attribute.PADDING_BOTTOM)) != null) {
                l.setFontBases(emBase, exBase);
                this.bottomPadding = l.getValue();
            }
            this.border = new CSSBorder(as, ss);
            this.background = ss.getBackground(as);
        }

        public float getInset(int size, View v) {
            float inset;
            switch (size) {
                case 1: {
                    inset = this.topInset;
                    if (this.border != null) {
                        inset += (float)this.border.getBorderInsets(null).top;
                    }
                    inset += this.topPadding;
                    break;
                }
                case 3: {
                    inset = this.bottomInset;
                    if (this.border != null) {
                        inset += (float)this.border.getBorderInsets(null).bottom;
                    }
                    inset += this.bottomPadding;
                    break;
                }
                case 2: {
                    inset = this.leftInset;
                    if (this.border != null) {
                        inset += (float)this.border.getBorderInsets(null).left;
                    }
                    inset += this.leftPadding;
                    break;
                }
                case 4: {
                    inset = this.rightInset;
                    if (this.border != null) {
                        inset += (float)this.border.getBorderInsets(null).right;
                    }
                    inset += this.rightPadding;
                    break;
                }
                default: {
                    inset = 0.0f;
                }
            }
            return inset;
        }

        public void paint(Graphics g, float x, float y, float w, float h, View v) {
            int inX = (int)(x + this.leftInset);
            int inY = (int)(y + this.topInset);
            int inW = (int)(w - this.leftInset - this.rightInset);
            int inH = (int)(h - this.topInset - this.bottomInset);
            if (this.background != null) {
                g.setColor(this.background);
                g.fillRect(inX, inY, inW, inH);
            }
            if (this.border != null) {
                this.border.paintBorder(null, g, inX, inY, inW, inH);
            }
        }
    }

    private class CSSStyle
    extends SimpleAttributeSet
    implements Style,
    Comparable {
        static final int PREC_UA = 0;
        static final int PREC_NORM = 100000;
        static final int PREC_AUTHOR_NORMAL = 200000;
        static final int PREC_AUTHOR_IMPORTANT = 300000;
        static final int PREC_USER_IMPORTANT = 400000;
        private int precedence;
        Selector selector;

        CSSStyle(int prec, Selector sel) {
            this.precedence = prec;
            this.selector = sel;
        }

        public String getName() {
            return null;
        }

        public void addChangeListener(ChangeListener listener) {
        }

        public void removeChangeListener(ChangeListener listener) {
        }

        public int compareTo(Object o) {
            CSSStyle other = (CSSStyle)o;
            return other.precedence + other.selector.getSpecificity() - this.precedence - this.selector.getSpecificity();
        }
    }

    class CSSStyleSheetParserCallback
    implements CSSParserCallback {
        private CSSStyle[] styles;
        private int precedence;

        CSSStyleSheetParserCallback(int prec) {
            this.precedence = prec;
        }

        public void startStatement(Selector[] sel) {
            this.styles = new CSSStyle[sel.length];
            int i = 0;
            while (i < sel.length) {
                this.styles[i] = new CSSStyle(this.precedence, sel[i]);
                ++i;
            }
        }

        public void endStatement() {
            int i = 0;
            while (i < this.styles.length) {
                StyleSheet.this.css.add(this.styles[i]);
                ++i;
            }
            this.styles = null;
        }

        public void declaration(String property, String value) {
            CSS.Attribute cssAtt = CSS.getAttribute(property);
            Object val = CSS.getValue(cssAtt, value);
            int i = 0;
            while (i < this.styles.length) {
                CSSStyle style = this.styles[i];
                CSS.addInternal(style, cssAtt, value);
                if (cssAtt != null) {
                    style.addAttribute(cssAtt, val);
                }
                ++i;
            }
        }
    }

    public static class ListPainter
    implements Serializable {
        private AttributeSet attributes;
        private StyleSheet styleSheet;
        private String type;
        private final Rectangle tmpRect = new Rectangle();

        ListPainter(AttributeSet as, StyleSheet ss) {
            this.attributes = as;
            this.styleSheet = ss;
            this.type = (String)as.getAttribute(CSS.Attribute.LIST_STYLE_TYPE);
        }

        public void paint(Graphics g, float x, float y, float w, float h, View v, int item) {
            View itemView = v.getView(item);
            AttributeSet viewAtts = itemView.getAttributes();
            Object tag = viewAtts.getAttribute(StyleConstants.NameAttribute);
            if (tag != null && tag == HTML.Tag.LI) {
                Shape a1;
                Rectangle r1;
                ParagraphView par;
                Shape a;
                View v1;
                g.setColor(Color.BLACK);
                int centerX = (int)(x - 12.0f);
                int centerY = -1;
                this.tmpRect.setBounds((int)x, (int)y, (int)w, (int)h);
                if (itemView.getViewCount() > 0 && (v1 = itemView.getView(0)) instanceof ParagraphView && v1.getViewCount() > 0 && (a = (par = (ParagraphView)v1).getChildAllocation(0, r1 = (a1 = itemView.getChildAllocation(0, this.tmpRect)) instanceof Rectangle ? (Rectangle)a1 : a1.getBounds())) != null) {
                    Rectangle r = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
                    centerY = r.height / 2 + r.y;
                }
                if (centerY == -1) {
                    centerY = (int)(h / 2.0f + y);
                }
                g.fillOval(centerX - 3, centerY - 3, 6, 6);
            }
        }
    }
}

