/* $Id: linux_logo.h,v 1.1 1997/04/16 17:51:24 jj Exp $
 * include/asm-m68k/linux_logo.h: This is a linux logo
 *                                 to be displayed on boot.
 *
 * Copyright (C) 1996 Larry Ewing (lewing@isc.tamu.edu)
 * Copyright (C) 1996 Jakub Jelinek (jj@sunsite.mff.cuni.cz)
 *
 * You can put anything here, but:
 * LINUX_LOGO_COLORS has to be less than 224
 * image size has to be 80x80
 * values have to start from 0x20
 * (i.e. RGB(linux_logo_red[0],
 *	     linux_logo_green[0],
 *	     linux_logo_blue[0]) is color 0x20)
 * BW image has to be 80x80 as well, with MS bit
 * on the left
 * Serial_console ascii image can be any size,
 * but should contain %s to display the version
 */
 
#include <linux/init.h>
#include <linux/version.h>

#define linux_logo_banner "Linux/m68k version " UTS_RELEASE

#define LINUX_LOGO_COLORS 221

#ifdef INCLUDE_LINUX_LOGO_DATA
unsigned char linux_logo_red[] __initdata = {
  0xF3, 0xF6, 0xF8, 0xF7, 0xEF, 0xE7, 0xE5, 0xE3,
  0xCA, 0xD4, 0xDD, 0xC8, 0xC7, 0xC4, 0xC2, 0xE5,
  0xF1, 0xED, 0xEE, 0xE6, 0xC6, 0xDA, 0xDD, 0xE5,
  0xD9, 0xC6, 0xE3, 0xD0, 0xC6, 0xBA, 0xB0, 0xB6,
  0xBB, 0xBE, 0xB9, 0xB8, 0xB3, 0xB2, 0xB0, 0xAD,
  0xAC, 0xA9, 0xA8, 0xA6, 0xA4, 0xA1, 0xA0, 0x9D,
  0xA0, 0x9F, 0x9E, 0x9C, 0x9B, 0x99, 0x9A, 0x99,
  0x98, 0x95, 0x96, 0x94, 0x93, 0x92, 0x8F, 0x8D,
  0x8C, 0x8A, 0x87, 0x86, 0x83, 0x81, 0x0D, 0x03,
  0x66, 0x44, 0x24, 0x08, 0xD6, 0xE6, 0xE9, 0xE6,
  0xE7, 0xCA, 0xDC, 0xDB, 0xD5, 0xD0, 0xC9, 0xE2,
  0xD5, 0xC6, 0xC4, 0xB3, 0xB2, 0xB9, 0xA9, 0x9A,
  0xB2, 0x9D, 0xE8, 0xEC, 0xF5, 0xF5, 0xF4, 0xF4,
  0xEC, 0xEE, 0xF0, 0xF5, 0xE0, 0xD6, 0xC5, 0xC2,
  0xD9, 0xD5, 0xD8, 0xD6, 0xF6, 0xF4, 0xED, 0xEC,
  0xEB, 0xF1, 0xF6, 0xF5, 0xF5, 0xEE, 0xEF, 0xEC,
  0xE7, 0xE3, 0xE6, 0xD6, 0xDD, 0xC3, 0xD6, 0xD7,
  0xCD, 0xCA, 0xC3, 0xAC, 0x95, 0x99, 0xB7, 0xA3,
  0x8B, 0x88, 0x95, 0x8A, 0x94, 0xD2, 0xCC, 0xC4,
  0xA8, 0x8E, 0x8F, 0xAE, 0xB8, 0xAC, 0xB6, 0xB4,
  0xAD, 0xA5, 0xA0, 0x9B, 0x8B, 0xA3, 0x94, 0x87,
  0x85, 0x89, 0x53, 0x80, 0x7D, 0x7C, 0x7A, 0x78,
  0x76, 0x71, 0x73, 0x6E, 0x6B, 0x67, 0x65, 0x62,
  0x4B, 0x5B, 0x5F, 0x53, 0x56, 0x52, 0x4F, 0x46,
  0x42, 0x0F, 0x75, 0x78, 0x7D, 0x72, 0x5F, 0x6E,
  0x7A, 0x75, 0x6A, 0x58, 0x48, 0x4F, 0x00, 0x2B,
  0x37, 0x3E, 0x32, 0x33, 0x25, 0x2C, 0x3B, 0x11,
  0x1D, 0x14, 0x06, 0x02, 0x00
};

unsigned char linux_logo_green[] __initdata = {
  0xF3, 0xF6, 0xF8, 0xF7, 0xEF, 0xE7, 0xE5, 0xE3,
  0xCA, 0xD4, 0xDD, 0xC8, 0xC7, 0xC4, 0xC2, 0xD3,
  0xDA, 0xD4, 0xD7, 0xCC, 0xC1, 0xCC, 0xCB, 0xC9,
  0xC5, 0xBC, 0xBC, 0xBB, 0xB7, 0xA5, 0xB0, 0xB6,
  0xBB, 0xBE, 0xB9, 0xB8, 0xB3, 0xB2, 0xAD, 0xAD,
  0xAC, 0xA9, 0xA8, 0xA6, 0xA4, 0xA1, 0xA0, 0x95,
  0xA0, 0x9F, 0x9E, 0x9C, 0x9B, 0x99, 0x9A, 0x99,
  0x98, 0x95, 0x96, 0x94, 0x93, 0x92, 0x8F, 0x8D,
  0x8C, 0x8A, 0x87, 0x86, 0x83, 0x81, 0x08, 0x02,
  0x53, 0x2E, 0x19, 0x06, 0xC6, 0xC8, 0xCF, 0xBD,
  0xB3, 0xB6, 0xB4, 0xAB, 0xA5, 0xA3, 0x9B, 0xB6,
  0xA7, 0x99, 0x92, 0xA4, 0x9E, 0x9D, 0x98, 0x8C,
  0x8A, 0x86, 0xCD, 0xCC, 0xC9, 0xD7, 0xCA, 0xC4,
  0xCA, 0xC3, 0xC7, 0xC3, 0xC8, 0xB4, 0x91, 0x8E,
  0x8A, 0x82, 0x87, 0x85, 0xBD, 0xBF, 0xB6, 0xBC,
  0xAE, 0xB7, 0xBC, 0xB8, 0xBF, 0xB6, 0xBC, 0xB5,
  0xAB, 0xA6, 0xAD, 0xB2, 0xA5, 0x87, 0x9C, 0x96,
  0x95, 0x8E, 0x87, 0x8F, 0x86, 0x86, 0x8E, 0x80,
  0x7A, 0x70, 0x7B, 0x78, 0x78, 0x7F, 0x77, 0x6F,
  0x70, 0x76, 0x59, 0x77, 0x68, 0x64, 0x7B, 0x7C,
  0x75, 0x6D, 0x77, 0x69, 0x65, 0x5F, 0x5B, 0x54,
  0x4F, 0x5B, 0x39, 0x80, 0x7D, 0x7C, 0x7A, 0x78,
  0x76, 0x71, 0x73, 0x6E, 0x6B, 0x67, 0x65, 0x62,
  0x4B, 0x5B, 0x5F, 0x53, 0x56, 0x52, 0x4F, 0x46,
  0x42, 0x0B, 0x69, 0x66, 0x64, 0x57, 0x4A, 0x4E,
  0x55, 0x4B, 0x46, 0x3B, 0x30, 0x33, 0x00, 0x2B,
  0x37, 0x3E, 0x32, 0x33, 0x25, 0x2C, 0x29, 0x0D,
  0x1D, 0x14, 0x06, 0x02, 0x00
};

unsigned char linux_logo_blue[] __initdata = {
  0xF3, 0xF6, 0xF8, 0xF7, 0xEF, 0xEE, 0xE5, 0xDE,
  0xD7, 0xD3, 0xDD, 0xC8, 0xC7, 0xC4, 0xC2, 0xB5,
  0xB0, 0xA6, 0xAC, 0x9B, 0xB5, 0xB5, 0xAE, 0x84,
  0x90, 0xA9, 0x81, 0x8D, 0x96, 0x86, 0xB0, 0xB6,
  0xBB, 0xBE, 0xB9, 0xB8, 0xB3, 0xB2, 0xA7, 0xAD,
  0xAC, 0xA9, 0xA8, 0xA6, 0xA4, 0xA1, 0xA5, 0x87,
  0xA0, 0x9F, 0x9E, 0x9C, 0x9B, 0x9A, 0x9A, 0x99,
  0x98, 0x95, 0x96, 0x94, 0x93, 0x92, 0x8F, 0x8D,
  0x8C, 0x8A, 0x87, 0x86, 0x83, 0x81, 0xC8, 0xD7,
  0x9B, 0x8E, 0x8C, 0xB2, 0x77, 0x77, 0x4E, 0x77,
  0x69, 0x71, 0x78, 0x6B, 0x65, 0x66, 0x64, 0x59,
  0x5C, 0x5A, 0x48, 0x72, 0x7B, 0x6B, 0x67, 0x6E,
  0x42, 0x5B, 0x29, 0x36, 0x25, 0x10, 0x17, 0x14,
  0x19, 0x16, 0x13, 0x0E, 0x08, 0x2E, 0x2E, 0x3D,
  0x24, 0x24, 0x24, 0x24, 0x13, 0x12, 0x14, 0x14,
  0x0E, 0x08, 0x0D, 0x0F, 0x08, 0x0D, 0x0E, 0x08,
  0x08, 0x0C, 0x06, 0x06, 0x07, 0x16, 0x07, 0x0E,
  0x08, 0x0A, 0x07, 0x0D, 0x2D, 0x3E, 0x09, 0x4E,
  0x68, 0x52, 0x56, 0x58, 0x4B, 0x22, 0x20, 0x20,
  0x27, 0x39, 0x28, 0x19, 0x1E, 0x1E, 0x08, 0x06,
  0x07, 0x09, 0x08, 0x08, 0x05, 0x1D, 0x1F, 0x17,
  0x18, 0x06, 0x79, 0x80, 0x7D, 0x7C, 0x7A, 0x78,
  0x76, 0x71, 0x73, 0x6E, 0x6B, 0x68, 0x65, 0x62,
  0x4B, 0x5B, 0x5F, 0x55, 0x56, 0x52, 0x4F, 0x46,
  0x42, 0x5A, 0x14, 0x23, 0x3D, 0x2B, 0x21, 0x14,
  0x06, 0x04, 0x03, 0x07, 0x09, 0x13, 0x2A, 0x3A,
  0x37, 0x3E, 0x32, 0x33, 0x25, 0x2C, 0x07, 0x09,
  0x1D, 0x14, 0x06, 0x02, 0x00
};

unsigned char linux_logo[] __initdata = {
  0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57,
  0x57, 0x57, 0x58, 0x57, 0x57, 0x57, 0x57, 0x57,
  0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x58, 0x57,
  0x58, 0x58, 0x59, 0x5C, 0x5D, 0x5F, 0x60, 0x61,
  0x62, 0x61, 0x61, 0x62, 0x62, 0x62, 0x63, 0x63,
  0x61, 0x61, 0x61, 0x61, 0x61, 0x60, 0x5E, 0x5E,
  0x5E, 0x5D, 0x5D, 0x5C, 0x5D, 0x5B, 0x58, 0x58,
  0x58, 0x57, 0x58, 0x57, 0x57, 0x57, 0x57, 0x58,
  0x57, 0x57, 0x58, 0x57, 0x57, 0x58, 0x57, 0x57,
  0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57,
  0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57,
  0x57, 0x57, 0x58, 0x57, 0x57, 0x57, 0x57, 0x57,
  0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x58, 0x57,
  0x54, 0x56, 0x57, 0x67, 0xFC, 0xFC, 0xFC, 0xFC,
  0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0x67, 0x4C,
  0x4A, 0x49, 0x4A, 0x49, 0x4A, 0x49, 0x49, 0x4A,
  0x4A, 0x4B, 0x4B, 0x4B, 0x4C, 0x50, 0x51, 0x52,
  0x54, 0x54, 0x56, 0x57, 0x57, 0x57, 0x57, 0x58,
  0x57, 0x57, 0x58, 0x57, 0x57, 0x58, 0x57, 0x57,
  0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57,
  0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57,
  0x57, 0x57, 0x58, 0x57, 0x57, 0x57, 0x57, 0x57,
  0x57, 0x57, 0x57, 0x57, 0x58, 0x56, 0x56, 0x53,
  0x52, 0x53, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC,
  0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFB, 0xFB, 0xFB,
  0x4B, 0x4B, 0x4B, 0x4A, 0x49, 0x4A, 0x4A, 0x49,
  0x49, 0x49, 0x48, 0x49, 0x49, 0x4A, 0x4A, 0x4B,
  0x4C, 0x4D, 0x52, 0x54, 0x56, 0x55, 0x57, 0x58,
  0x57, 0x57, 0x58, 0x57, 0x57, 0x58, 0x57, 0x57,
  0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57,
  0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57,
  0x57, 0x57, 0x58, 0x57, 0x57, 0x57, 0x57, 0x57,
  0x57, 0x57, 0x55, 0x54, 0x53, 0x52, 0x51, 0x50,
  0x50, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC,
  0xFC, 0xFC, 0xFC, 0xFC, 0xF8, 0xF0, 0xF4, 0xFB,
  0xFC, 0x67, 0x53, 0x50, 0x4D, 0x4C, 0x4C, 0x4C,
  0x4B, 0x4A, 0x4A, 0x48, 0x49, 0x48, 0x48, 0x49,
  0x49, 0x49, 0x4B, 0x4C, 0x50, 0x52, 0x53, 0x56,
  0x57, 0x57, 0x58, 0x57, 0x57, 0x58, 0x57, 0x57,
  0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57,
  0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57,
  0x57, 0x57, 0x58, 0x57, 0x57, 0x57, 0x57, 0x57,
  0x55, 0x54, 0x53, 0x51, 0x51, 0x50, 0x4C, 0x4D,
  0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC,
  0xFC, 0xFC, 0xFC, 0xFC, 0xF4, 0xD2, 0xD7, 0xF5,
  0xFC, 0xFC, 0x5D, 0x5D, 0x5C, 0x5C, 0x59, 0x58,
  0x58, 0x56, 0x52, 0x4C, 0x4B, 0x4A, 0x4A, 0x48,
  0x48, 0x48, 0x48, 0x48, 0x49, 0x4B, 0x4D, 0x51,
  0x54, 0x56, 0x58, 0x57, 0x57, 0x58, 0x57, 0x57,
  0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57,
  0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57,
  0x57, 0x57, 0x58, 0x57, 0x57, 0x57, 0x55, 0x54,
  0x53, 0x52, 0x51, 0x4D, 0x4D, 0x4D, 0x50, 0x50,
  0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC,
  0xFC, 0xFC, 0xFC, 0xFC, 0xF4, 0x64, 0xD9, 0xF5,
  0xF9, 0xFC, 0xFC, 0x64, 0x63, 0x62, 0x61, 0x61,
  0x61, 0x60, 0x5E, 0x5B, 0x5A, 0x54, 0x52, 0x4C,
  0x4B, 0x49, 0x49, 0x47, 0x47, 0x48, 0x49, 0x4B,
  0x4C, 0x51, 0x53, 0x56, 0x57, 0x58, 0x57, 0x57,
  0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57,
  0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57,
  0x57, 0x57, 0x58, 0x57, 0x57, 0x55, 0x53, 0x53,
  0x51, 0x50, 0x50, 0x50, 0x50, 0x50, 0x53, 0xFC,
  0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC,
  0xFC, 0xFC, 0xFC, 0xFC, 0xF4, 0xF5, 0xF9, 0xFC,
  0xFC, 0xFC, 0xFC, 0x64, 0x64, 0x64, 0x64, 0x64,
  0x64, 0x64, 0x64, 0x63, 0x61, 0x61, 0x5E, 0x59,
  0x55, 0x52, 0x4C, 0x4A, 0x49, 0x47, 0x48, 0x48,
  0x49, 0x4B, 0x4D, 0x51, 0x54, 0x57, 0x57, 0x57,
  0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57,
  0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57,
  0x57, 0x57, 0x58, 0x55, 0x54, 0x54, 0x52, 0x51,
  0x51, 0x51, 0x51, 0x51, 0x53, 0x54, 0x59, 0xFC,
  0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC,
  0xFC, 0xFC, 0xFC, 0xFC, 0xF7, 0xFC, 0xFC, 0xFC,
  0xFC, 0xFC, 0xFC, 0xFC, 0x60, 0x60, 0x60, 0x61,
  0x62, 0x63, 0x64, 0x64, 0x65, 0x65, 0x64, 0x63,
  0x61, 0x5E, 0x59, 0x56, 0x4D, 0x4B, 0x48, 0x48,
  0x48, 0x48, 0x49, 0x4B, 0x50, 0x53, 0x56, 0x56,
  0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57,
  0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57,
  0x57, 0x57, 0x56, 0x54, 0x53, 0x52, 0x51, 0x51,
  0x51, 0x52, 0x53, 0x55, 0x59, 0x5D, 0x5E, 0xFC,
  0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC,
  0xFC, 0xFC, 0xFC, 0xFB, 0xFB, 0xFB, 0xFC, 0xFC,
  0xFC, 0xFC, 0xFC, 0xFC, 0x4C, 0x4E, 0x51, 0x52,
  0x57, 0x5A, 0x5E, 0x60, 0x61, 0x63, 0x65, 0xCB,
  0x64, 0x64, 0x63, 0x60, 0x5C, 0x57, 0x50, 0x4B,
  0x48, 0x47, 0x47, 0x47, 0x4A, 0x4C, 0x52, 0x53,
  0x54, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57,
  0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57,
  0x55, 0x54, 0x53, 0x53, 0x51, 0x52, 0x52, 0x53,
  0x53, 0x57, 0x5A, 0x5D, 0x5E, 0x5E, 0x60, 0xFC,
  0xFC, 0xFC, 0xFB, 0xF9, 0xFC, 0xFC, 0xFC, 0xFC,
  0xFC, 0xFC, 0xFC, 0xFA, 0xF9, 0xF5, 0xFB, 0xFC,
  0xFC, 0xFC, 0xFC, 0xFC, 0xFB, 0x45, 0x3F, 0x3F,
  0x45, 0x48, 0x4B, 0x4D, 0x54, 0x5A, 0x5E, 0x61,
  0x63, 0xCB, 0xCB, 0x65, 0x64, 0x62, 0x5E, 0x57,
  0x50, 0x4B, 0x48, 0x47, 0x47, 0x48, 0x4B, 0x4D,
  0x51, 0x56, 0x56, 0x57, 0x57, 0x57, 0x57, 0x57,
  0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x55,
  0x54, 0x54, 0x53, 0x53, 0x52, 0x53, 0x54, 0x57,
  0x59, 0x5C, 0x5E, 0x5E, 0x5E, 0x5E, 0x5E, 0xFC,
  0xFC, 0xFA, 0xFC, 0xFA, 0xE0, 0xFC, 0xFC, 0xFC,
  0xFB, 0xFB, 0xFB, 0xDF, 0xD8, 0xF9, 0xE0, 0xFC,
  0xFC, 0xFC, 0xFC, 0xFC, 0xFB, 0x4C, 0x4A, 0x48,
  0x48, 0x3E, 0x44, 0x43, 0x3F, 0x47, 0x4B, 0x52,
  0x5A, 0x5E, 0x62, 0x64, 0xCB, 0xCB, 0x64, 0x61,
  0x5E, 0x57, 0x4D, 0x49, 0x47, 0x47, 0x48, 0x4A,
  0x4C, 0x52, 0x54, 0x56, 0x57, 0x57, 0x57, 0x57,
  0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x55,
  0x54, 0x53, 0x53, 0x54, 0x54, 0x55, 0x58, 0x5B,
  0x5C, 0x5D, 0x5E, 0x5D, 0x5D, 0x5B, 0x58, 0xFC,
  0xFC, 0xD8, 0x4C, 0x60, 0xFC, 0xF5, 0xFC, 0xFC,
  0xFC, 0xF7, 0x5F, 0x48, 0x48, 0x2C, 0xF8, 0xF9,
  0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0x4B, 0x4A, 0x49,
  0x49, 0x49, 0x49, 0x47, 0x3E, 0x44, 0x42, 0x3F,
  0x3E, 0x4B, 0x54, 0x5C, 0x61, 0x64, 0xCB, 0xCB,
  0x64, 0x61, 0x5D, 0x53, 0x4B, 0x49, 0x47, 0x47,
  0x49, 0x4B, 0x50, 0x53, 0x56, 0x57, 0x57, 0x57,
  0x57, 0x57, 0x57, 0x57, 0x57, 0x55, 0x55, 0x54,
  0x53, 0x53, 0x54, 0x56, 0x58, 0x5A, 0x5B, 0x5D,
  0x5D, 0x5D, 0x5C, 0x5A, 0x54, 0x52, 0x4C, 0xFC,
  0xF7, 0x4E, 0x2D, 0x29, 0x4E, 0xFC, 0xFC, 0xFC,
  0xFB, 0x5F, 0x26, 0x24, 0x20, 0x2E, 0x65, 0xFC,
  0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0x45, 0x3F, 0x45,
  0x3E, 0x47, 0x47, 0x47, 0x47, 0x47, 0x3E, 0x44,
  0x43, 0x40, 0x44, 0x49, 0x51, 0x5C, 0x62, 0x64,
  0xCB, 0xCB, 0x63, 0x60, 0x58, 0x50, 0x49, 0x48,
  0x48, 0x48, 0x4A, 0x4D, 0x53, 0x54, 0x57, 0x57,
  0x57, 0x57, 0x57, 0x57, 0x55, 0x54, 0x54, 0x54,
  0x54, 0x54, 0x55, 0x57, 0x59, 0x5B, 0x5C, 0x5D,
  0x5C, 0x5A, 0x54, 0x51, 0x4C, 0x4C, 0x54, 0xFC,
  0xF9, 0x23, 0xDB, 0x2D, 0x23, 0xFA, 0xFB, 0xFA,
  0xF5, 0x27, 0x21, 0xD9, 0xF8, 0x20, 0x21, 0xFB,
  0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0x5D, 0x58, 0x55,
  0x50, 0x48, 0x45, 0x43, 0x44, 0x44, 0x45, 0x45,
  0x3E, 0x3F, 0x43, 0x41, 0x3F, 0x48, 0x52, 0x5D,
  0x63, 0x65, 0xCB, 0x65, 0x61, 0x5D, 0x52, 0x4B,
  0x48, 0x47, 0x47, 0x49, 0x4C, 0x51, 0x54, 0x57,
  0x57, 0x57, 0x57, 0x57, 0x55, 0x54, 0x54, 0x54,
  0x54, 0x58, 0x5A, 0x59, 0x5B, 0x5B, 0x5B, 0x5A,
  0x55, 0x52, 0x4D, 0x4D, 0x55, 0x5B, 0x5D, 0xFC,
  0xF1, 0xF9, 0xFC, 0xD4, 0x21, 0xCC, 0xF7, 0xF8,
  0xF2, 0x21, 0xD9, 0xFC, 0xF2, 0xFB, 0x21, 0x45,
  0xFC, 0xFC, 0xFC, 0xFC, 0xFB, 0xD1, 0xD0, 0xCD,
  0xCC, 0x63, 0x5E, 0x58, 0x50, 0x47, 0x43, 0x3F,
  0x3F, 0x3F, 0x3F, 0x3F, 0x40, 0x41, 0x3F, 0x4A,
  0x56, 0x5E, 0x64, 0xCB, 0x65, 0x63, 0x5E, 0x56,
  0x4C, 0x48, 0x47, 0x47, 0x49, 0x4C, 0x51, 0x54,
  0x58, 0x57, 0x57, 0x57, 0x57, 0x55, 0x54, 0x54,
  0x57, 0x5A, 0x5A, 0x5C, 0x5B, 0x5A, 0x58, 0x54,
  0x51, 0x4C, 0x55, 0x5D, 0x5D, 0x5B, 0x54, 0xFC,
  0xF0, 0xF9, 0xFC, 0x65, 0x45, 0xCD, 0xFB, 0xFB,
  0xF8, 0x26, 0xFB, 0xFC, 0xFC, 0xFC, 0x21, 0x27,
  0xFB, 0xFC, 0xFC, 0xFC, 0xFB, 0xD7, 0x35, 0x34,
  0x2F, 0x35, 0x36, 0x2F, 0x2F, 0x36, 0x2F, 0x2F,
  0x36, 0x36, 0x35, 0x35, 0x43, 0x42, 0x41, 0x2E,
  0x45, 0x4C, 0x5B, 0x62, 0x65, 0xCC, 0x64, 0x60,
  0x58, 0x4D, 0x49, 0x47, 0x47, 0x49, 0x4C, 0x51,
  0x58, 0x57, 0x57, 0x57, 0x57, 0x57, 0x55, 0x57,
  0x58, 0x5A, 0x5A, 0x5B, 0x5A, 0x55, 0x54, 0x51,
  0x53, 0x5C, 0x5D, 0x5D, 0x54, 0x4B, 0x4D, 0xFC,
  0xFC, 0x44, 0xFC, 0xFB, 0x7B, 0xAB, 0xA8, 0xAE,
  0xAB, 0x7F, 0xFC, 0xFC, 0xFB, 0xFB, 0x22, 0x2A,
  0xFC, 0xFC, 0xFC, 0xFC, 0x36, 0x2F, 0x30, 0x30,
  0x32, 0x30, 0x32, 0x30, 0x30, 0x30, 0x30, 0x30,
  0x30, 0x30, 0x30, 0x30, 0x2F, 0x2F, 0x40, 0x41,
  0x2E, 0x40, 0x48, 0x56, 0x5F, 0x64, 0xCC, 0x65,
  0x61, 0x59, 0x50, 0x49, 0x47, 0x47, 0x49, 0x4C,
  0x5A, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x58,
  0x5A, 0x5A, 0x5A, 0x58, 0x55, 0x52, 0x51, 0x5A,
  0x5D, 0x5D, 0x57, 0x4C, 0x51, 0x54, 0x5D, 0xFC,
  0xFC, 0x2A, 0xFC, 0xC9, 0xAA, 0x8B, 0x8A, 0x8C,
  0xAB, 0x8C, 0x8C, 0xFB, 0xFB, 0x23, 0x20, 0xF1,
  0xFC, 0xFC, 0xFC, 0x3B, 0x33, 0x33, 0x32, 0x32,
  0x31, 0x32, 0x30, 0x32, 0x32, 0x32, 0x32, 0x30,
  0x31, 0x31, 0x31, 0x32, 0x33, 0x33, 0x3C, 0x41,
  0x41, 0x2E, 0x2D, 0x45, 0x4D, 0x5D, 0x63, 0xCC,
  0x65, 0x62, 0x5D, 0x51, 0x49, 0x47, 0x47, 0x4A,
  0x59, 0x57, 0x57, 0x57, 0x57, 0x58, 0x58, 0x58,
  0x5A, 0x5A, 0x58, 0x55, 0x53, 0x53, 0x5C, 0x5E,
  0x59, 0x51, 0x4E, 0x54, 0x59, 0x5E, 0x62, 0xFC,
  0xFC, 0xDB, 0xAA, 0xA1, 0x95, 0x9C, 0x8C, 0x88,
  0x82, 0x83, 0x83, 0x8C, 0x88, 0xAE, 0xB9, 0xFB,
  0xFC, 0xFC, 0xFC, 0x3C, 0x3B, 0x72, 0x38, 0x33,
  0x33, 0x33, 0x31, 0x33, 0x31, 0x31, 0x31, 0x31,
  0x33, 0x33, 0x38, 0x33, 0x72, 0x3B, 0x44, 0x2E,
  0x41, 0x2E, 0x2E, 0x2D, 0x43, 0x4B, 0x5B, 0x63,
  0xCB, 0xCC, 0x63, 0x5D, 0x51, 0x49, 0x47, 0x49,
  0x5C, 0x58, 0x57, 0x57, 0x57, 0x57, 0x58, 0x58,
  0x58, 0x58, 0x57, 0x53, 0x58, 0x5D, 0x5E, 0x55,
  0x51, 0x53, 0x58, 0x5E, 0x60, 0x63, 0x64, 0xFC,
  0xFC, 0xC0, 0xA6, 0x9D, 0x8B, 0x9C, 0x8C, 0x8C,
  0x6E, 0x83, 0x88, 0x8C, 0x8C, 0x8C, 0x83, 0xE8,
  0xFB, 0xFC, 0xFC, 0xFC, 0x33, 0x70, 0x70, 0x6F,
  0x6F, 0x6F, 0x6F, 0x3A, 0x6F, 0x6D, 0x6F, 0x6F,
  0x70, 0x6F, 0x6F, 0x70, 0x6F, 0x32, 0x5A, 0x48,
  0x41, 0x2D, 0x2D, 0x2D, 0x2C, 0x41, 0x49, 0x5A,
  0x62, 0xCB, 0xCB, 0x63, 0x5D, 0x50, 0x49, 0x4A,
  0x5C, 0x58, 0x58, 0x57, 0x55, 0x57, 0x57, 0x57,
  0x57, 0x55, 0x56, 0x59, 0x5E, 0x5C, 0x52, 0x53,
  0x55, 0x5B, 0x5E, 0x61, 0x63, 0x64, 0x63, 0xFC,
  0xE8, 0xBF, 0xA4, 0x99, 0x9C, 0x8C, 0x88, 0x88,
  0x6E, 0x88, 0x8C, 0x8C, 0x8C, 0xC2, 0xA6, 0xC4,
  0xFC, 0xFC, 0xFC, 0xFC, 0x36, 0x3A, 0x6F, 0x70,
  0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70,
  0x70, 0x70, 0x70, 0x70, 0x37, 0x32, 0xCD, 0x5E,
  0x4C, 0x43, 0x2C, 0x2D, 0x2D, 0x2C, 0x2E, 0x47,
  0x57, 0x61, 0x65, 0xCC, 0x63, 0x5C, 0x50, 0x4D,
  0x5C, 0x5A, 0x57, 0x55, 0x55, 0x55, 0x58, 0x58,
  0x55, 0x54, 0x5B, 0x5E, 0x5D, 0x53, 0x53, 0x55,
  0x5D, 0x5E, 0x61, 0x61, 0x61, 0x61, 0x5E, 0xFC,
  0xEA, 0xBE, 0xA4, 0x9B, 0x8B, 0x85, 0x8C, 0x6E,
  0x8C, 0x8C, 0x8C, 0xA3, 0xAA, 0xA4, 0xA4, 0xE9,
  0xFB, 0xFC, 0xFC, 0xFC, 0x36, 0x6D, 0x70, 0x73,
  0x70, 0x70, 0x70, 0x73, 0x73, 0x73, 0x73, 0x70,
  0x70, 0x70, 0x73, 0x70, 0x37, 0x38, 0xD1, 0xCF,
  0x61, 0x4D, 0x44, 0x2C, 0x2D, 0x2E, 0x2C, 0x2E,
  0x3E, 0x56, 0x61, 0xCB, 0xCC, 0x62, 0x5B, 0x57,
  0x59, 0x58, 0x55, 0x54, 0x54, 0x55, 0x58, 0x58,
  0x58, 0x5B, 0x5E, 0x5B, 0x53, 0x55, 0x55, 0x5C,
  0x5E, 0x61, 0x61, 0x60, 0x5D, 0x5A, 0x4E, 0xFC,
  0xFC, 0xEA, 0xAA, 0x9C, 0x8A, 0x85, 0x82, 0x8C,
  0x8C, 0xA8, 0xEB, 0xA8, 0xA4, 0xA4, 0xAA, 0xFC,
  0xFC, 0xFC, 0x64, 0xFB, 0x39, 0x31, 0x72, 0x78,
  0x73, 0x78, 0x73, 0x74, 0x74, 0x74, 0x74, 0x73,
  0x78, 0x70, 0x73, 0x73, 0x33, 0xCC, 0xD2, 0xD1,
  0xCE, 0x62, 0x53, 0x3F, 0x2D, 0x2D, 0x41, 0x2C,
  0x2E, 0x3E, 0x56, 0x62, 0xCB, 0xCB, 0x61, 0x5D,
  0x54, 0x54, 0x54, 0x54, 0x56, 0x58, 0x58, 0x58,
  0x5C, 0x5E, 0x5A, 0x55, 0x58, 0x58, 0x5B, 0x5E,
  0x61, 0x5E, 0x5D, 0x5A, 0x52, 0x55, 0xCD, 0xFC,
  0xFC, 0x34, 0xC9, 0xE8, 0xA8, 0xAE, 0xC2, 0xE8,
  0xC3, 0xA6, 0xA7, 0xA6, 0xAA, 0x78, 0x2E, 0x42,
  0xFC, 0xFC, 0xD2, 0x64, 0xF8, 0x31, 0x72, 0x73,
  0x73, 0x73, 0x73, 0x74, 0x75, 0x75, 0x74, 0x73,
  0x73, 0x73, 0x73, 0x72, 0x33, 0x5C, 0x64, 0xD2,
  0xD1, 0xCF, 0x63, 0x54, 0x3F, 0x2C, 0x41, 0x41,
  0x2C, 0x2E, 0x47, 0x58, 0x63, 0xCB, 0xCB, 0x62,
  0x52, 0x53, 0x53, 0x56, 0x58, 0x58, 0x5A, 0x5B,
  0x5E, 0x5A, 0x57, 0x58, 0x58, 0x58, 0x60, 0x60,
  0x5D, 0x5A, 0x55, 0x4E, 0x64, 0xD2, 0xD1, 0xFC,
  0xFC, 0x41, 0x3E, 0xC1, 0xC0, 0xA3, 0xA6, 0xA7,
  0xA7, 0xA9, 0xAA, 0xB8, 0x2E, 0x3F, 0x2C, 0x41,
  0xFC, 0xFC, 0xF7, 0xCE, 0xCD, 0x36, 0x72, 0x73,
  0x74, 0x75, 0x78, 0x75, 0x75, 0x75, 0x74, 0x74,
  0x74, 0x74, 0x78, 0x72, 0x6D, 0x49, 0x59, 0xCB,
  0xD1, 0xD1, 0xD2, 0xCB, 0x56, 0x3F, 0x2C, 0x41,
  0x40, 0x2D, 0x2E, 0x49, 0x5B, 0x64, 0xCC, 0x64,
  0x51, 0x53, 0x53, 0x55, 0x58, 0x59, 0x5B, 0x5E,
  0x59, 0x58, 0x58, 0x58, 0x55, 0x60, 0x60, 0x5C,
  0x5A, 0x53, 0x5B, 0xD0, 0xD3, 0xD3, 0xD3, 0xFB,
  0xFC, 0x40, 0x41, 0x45, 0xC4, 0xC0, 0xBE, 0xBE,
  0xC1, 0xC0, 0x3C, 0x47, 0x2E, 0x21, 0x22, 0x20,
  0x65, 0xFC, 0xFC, 0xFC, 0xFC, 0x6D, 0x72, 0x75,
  0x78, 0x76, 0x75, 0x79, 0x76, 0x76, 0x76, 0x76,
  0x75, 0x75, 0x75, 0x72, 0x6D, 0x2E, 0x48, 0x5D,
  0xCE, 0xD1, 0xD4, 0xD3, 0xCB, 0x56, 0x43, 0x2C,
  0x42, 0x43, 0x2E, 0x2E, 0x4A, 0x5D, 0x64, 0x64,
  0x50, 0x52, 0x56, 0x58, 0x5C, 0x5D, 0x5E, 0x5D,
  0x5A, 0x58, 0x58, 0x55, 0x61, 0x60, 0x58, 0x58,
  0x4E, 0x61, 0xD1, 0xD4, 0xD4, 0xD1, 0xEE, 0xFC,
  0xFC, 0x2B, 0x29, 0x2E, 0x3F, 0xB0, 0xAD, 0x81,
  0x46, 0x2D, 0x46, 0x2C, 0x24, 0x22, 0x22, 0x23,
  0x25, 0xFC, 0xFC, 0xFC, 0xFC, 0x6E, 0x73, 0x76,
  0x76, 0x79, 0x79, 0x79, 0x76, 0x76, 0x79, 0x76,
  0x79, 0x79, 0x79, 0x74, 0x3F, 0x41, 0x2C, 0x48,
  0x5F, 0xCF, 0xD5, 0xD7, 0xD6, 0xCD, 0x57, 0x40,
  0x2E, 0x3F, 0x44, 0x2E, 0x41, 0x4C, 0x60, 0x61,
  0x51, 0x53, 0x58, 0x5C, 0x5D, 0x5E, 0x5D, 0x5C,
  0x58, 0x57, 0x54, 0x5F, 0x5E, 0x55, 0x55, 0x52,
  0x64, 0xD4, 0xD5, 0xD4, 0xD1, 0x5D, 0xFA, 0xFB,
  0xF4, 0x21, 0x24, 0x41, 0x40, 0x44, 0x2E, 0x2E,
  0x42, 0x41, 0x2A, 0x24, 0x22, 0x22, 0x22, 0x22,
  0x23, 0xD9, 0xFC, 0xFC, 0xFC, 0xFC, 0xE5, 0xB8,
  0x8F, 0x8F, 0x7A, 0x8F, 0x7A, 0x8F, 0x7A, 0x8F,
  0x8F, 0x8F, 0xB8, 0xE5, 0x3F, 0x3E, 0x43, 0x2C,
  0x48, 0x61, 0xD1, 0xD7, 0xD9, 0xD7, 0xD0, 0x57,
  0x41, 0x2E, 0x3E, 0x44, 0x2D, 0x40, 0x52, 0x5D,
  0x53, 0x55, 0x59, 0x5D, 0x5E, 0x5E, 0x5D, 0x5A,
  0x57, 0x53, 0x5E, 0x5E, 0x54, 0x53, 0x54, 0x65,
  0xD5, 0xD6, 0xD4, 0xCE, 0x53, 0xFB, 0xF9, 0xFC,
  0x24, 0x22, 0x23, 0x23, 0x41, 0x42, 0x2E, 0x40,
  0x2B, 0x21, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x23, 0x23, 0xFC, 0xFC, 0xFC, 0xFC, 0xE7, 0xBD,
  0xB5, 0x93, 0x93, 0x93, 0x93, 0x93, 0x93, 0x93,
  0x93, 0xB5, 0xC6, 0xEB, 0x2D, 0x47, 0x4A, 0x47,
  0x2C, 0x3E, 0x61, 0xD4, 0xDC, 0xDC, 0xDA, 0xCF,
  0x54, 0x41, 0x41, 0x3E, 0x45, 0x2C, 0x3F, 0x4A,
  0x58, 0x5A, 0x5C, 0x5F, 0x60, 0x5E, 0x5D, 0x57,
  0x51, 0x5D, 0x5D, 0x51, 0x53, 0x53, 0xCB, 0xD5,
  0xD6, 0xD5, 0x63, 0x55, 0xFC, 0xFC, 0xFC, 0x2C,
  0x23, 0x22, 0x23, 0x22, 0x20, 0x2D, 0x2C, 0x26,
  0x21, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x21, 0xF0, 0xFC, 0xFC, 0xFC, 0xE2, 0xC6,
  0xB5, 0x93, 0x93, 0x93, 0x93, 0x93, 0x93, 0x93,
  0x93, 0x93, 0xC7, 0xE3, 0x3E, 0x2E, 0x49, 0x52,
  0x4C, 0x41, 0x44, 0x62, 0xD6, 0xDE, 0xDE, 0xD9,
  0xD0, 0x51, 0x2E, 0x40, 0x47, 0x44, 0x2C, 0x42,
  0x5D, 0x5D, 0x5F, 0x60, 0x60, 0x5D, 0x57, 0x51,
  0x58, 0x5D, 0x4E, 0x52, 0x55, 0x64, 0xD5, 0xD6,
  0xD4, 0x61, 0x59, 0x6B, 0xFC, 0xFC, 0xFC, 0x21,
  0x23, 0x22, 0x23, 0x22, 0x23, 0x21, 0x23, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x21, 0x24, 0xFC, 0xFC, 0xFC, 0xE2, 0xC7,
  0xB5, 0x90, 0x93, 0x93, 0x93, 0x90, 0x93, 0x93,
  0x90, 0xB5, 0xC8, 0xE4, 0x5F, 0x45, 0x2E, 0x4D,
  0x57, 0x57, 0x44, 0x43, 0x63, 0xDA, 0xDF, 0xDF,
  0xD9, 0xCE, 0x4C, 0x2C, 0x3F, 0x3E, 0x40, 0x40,
  0x60, 0x5E, 0x61, 0x61, 0x5E, 0x5B, 0x53, 0x52,
  0x5C, 0x52, 0x52, 0x55, 0x61, 0xD4, 0xD5, 0xD1,
  0x5E, 0x5B, 0x5C, 0xFB, 0xFC, 0xFC, 0x2A, 0x21,
  0x23, 0x22, 0x23, 0x22, 0x22, 0x22, 0x23, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0xFB, 0xFC, 0xFC, 0xB3, 0xC8,
  0xB5, 0x90, 0x92, 0xB5, 0x93, 0x93, 0xB5, 0x93,
  0x92, 0xB5, 0xC8, 0xB9, 0xD0, 0x5E, 0x44, 0x40,
  0x52, 0x58, 0x57, 0x48, 0x40, 0x63, 0xD9, 0xE0,
  0xE0, 0xD9, 0xCB, 0x49, 0x2D, 0x3F, 0x45, 0x3F,
  0x63, 0x61, 0x62, 0x60, 0x5E, 0x55, 0x4D, 0x59,
  0x53, 0x4E, 0x54, 0x5D, 0xD2, 0xD4, 0xD2, 0x5E,
  0x5C, 0x5D, 0xFC, 0xFC, 0xFC, 0xF8, 0x29, 0x23,
  0x23, 0x23, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x23, 0x22, 0x22, 0x23, 0x23, 0x23, 0x22, 0x22,
  0x22, 0x22, 0x22, 0xF0, 0xFC, 0xFC, 0xB3, 0xC7,
  0xB5, 0x93, 0xB5, 0x93, 0x93, 0x91, 0x93, 0x93,
  0x91, 0xB5, 0xC7, 0xAD, 0xD6, 0xD2, 0x5E, 0x3F,
  0x3F, 0x57, 0x57, 0x58, 0x4A, 0x41, 0x64, 0xDC,
  0xF1, 0xDF, 0xDA, 0x61, 0x45, 0x2E, 0x43, 0x47,
  0xCB, 0x63, 0x62, 0x5F, 0x58, 0x51, 0x53, 0x54,
  0x4C, 0x52, 0x5C, 0xCD, 0xD3, 0xD2, 0x60, 0x5D,
  0x5D, 0xFB, 0xFC, 0xFC, 0xFC, 0xDB, 0x49, 0x24,
  0x21, 0x23, 0x23, 0x22, 0x26, 0x26, 0x2A, 0x24,
  0x22, 0x23, 0x22, 0x21, 0x24, 0x26, 0x26, 0x2A,
  0x29, 0x2B, 0x24, 0x25, 0xFC, 0xFC, 0xB3, 0xC5,
  0x91, 0x91, 0x92, 0x91, 0x92, 0x92, 0x93, 0x93,
  0x91, 0x93, 0xC6, 0xAD, 0xDC, 0xD9, 0xD4, 0x60,
  0x43, 0x45, 0x58, 0x58, 0x57, 0x4B, 0x43, 0xCC,
  0xDD, 0xF1, 0xD8, 0xD5, 0x5D, 0x43, 0x41, 0x47,
  0xCD, 0x63, 0x62, 0x5D, 0x54, 0x4C, 0x55, 0x4B,
  0x51, 0x58, 0x62, 0xD0, 0xD0, 0x62, 0x5D, 0x5D,
  0x67, 0xFC, 0xFC, 0xFC, 0xFC, 0x58, 0x4E, 0x28,
  0x2A, 0x20, 0x23, 0x22, 0x23, 0x2A, 0x23, 0x22,
  0x22, 0x22, 0x23, 0x23, 0x25, 0x2A, 0x2E, 0x2D,
  0x2E, 0x2E, 0x2E, 0x23, 0xFA, 0xFC, 0xB2, 0xBD,
  0xB5, 0x90, 0x91, 0x93, 0x92, 0x90, 0x91, 0x93,
  0x92, 0x91, 0xBD, 0xAD, 0xDE, 0xE0, 0xD8, 0xD7,
  0x61, 0x40, 0x48, 0x58, 0x58, 0x58, 0x48, 0x44,
  0xCF, 0xDE, 0xE0, 0xDD, 0xD0, 0x52, 0x41, 0x45,
  0xCD, 0x63, 0x61, 0x58, 0x4D, 0x51, 0x4C, 0x4B,
  0x54, 0x5D, 0xCC, 0xCE, 0x63, 0x61, 0x5D, 0x5D,
  0xFB, 0xFC, 0xFC, 0xFC, 0xFC, 0x4B, 0x27, 0x21,
  0x22, 0x22, 0x23, 0x22, 0x22, 0x24, 0x23, 0x22,
  0x22, 0x22, 0x23, 0x22, 0x23, 0x23, 0x22, 0x20,
  0x27, 0x2B, 0x41, 0x2B, 0x23, 0xFC, 0xB2, 0xB6,
  0x93, 0x90, 0x92, 0xB5, 0x92, 0x90, 0xB5, 0x90,
  0x92, 0x93, 0xBC, 0xAD, 0xDC, 0xF1, 0xF3, 0xF0,
  0xD9, 0x61, 0x41, 0x4A, 0x58, 0x57, 0x57, 0x44,
  0x49, 0xD2, 0xDD, 0xD8, 0xDA, 0x63, 0x4A, 0x45,
  0xCC, 0x63, 0x5E, 0x52, 0x4B, 0x4C, 0x49, 0x51,
  0x5C, 0x61, 0xCD, 0x65, 0x63, 0x5E, 0x4E, 0xCF,
  0xFB, 0xFB, 0xF0, 0xFC, 0xD2, 0x2A, 0x22, 0x23,
  0x22, 0x22, 0x23, 0x22, 0x22, 0x21, 0x22, 0x22,
  0x22, 0x22, 0x23, 0x22, 0x23, 0x23, 0x22, 0x22,
  0x23, 0x22, 0x26, 0x41, 0x27, 0xF9, 0x81, 0xB7,
  0xB5, 0x91, 0x92, 0xB5, 0x91, 0xB5, 0x93, 0xB5,
  0x93, 0xB6, 0xB7, 0xB9, 0xCB, 0xD8, 0xF3, 0xF2,
  0xF2, 0xDB, 0x61, 0x2D, 0x51, 0x58, 0x57, 0x58,
  0x41, 0x51, 0xD4, 0xDB, 0xDC, 0xD1, 0x5B, 0x4C,
  0xCB, 0x62, 0x59, 0x4C, 0x4A, 0x49, 0x4B, 0x55,
  0x60, 0x64, 0xCC, 0x64, 0x5E, 0x55, 0x60, 0xE1,
  0xFB, 0xF8, 0xFC, 0xFC, 0x21, 0x22, 0x22, 0x23,
  0x22, 0x22, 0x23, 0x22, 0x22, 0x21, 0x22, 0x22,
  0x22, 0x22, 0x23, 0x22, 0x23, 0x23, 0x22, 0x22,
  0x23, 0x22, 0x21, 0x24, 0x2D, 0x21, 0xB4, 0xBB,
  0xB6, 0xB5, 0xB6, 0xB7, 0xB7, 0xB7, 0xB7, 0xB6,
  0xB6, 0xB6, 0xBB, 0xB9, 0x45, 0xCB, 0xDF, 0xF3,
  0xF3, 0xF3, 0xDB, 0x5E, 0x2C, 0x51, 0x58, 0x58,
  0x52, 0x2D, 0x5C, 0xD4, 0xD9, 0xD5, 0x63, 0x58,
  0x64, 0x60, 0x53, 0x49, 0x4A, 0x49, 0x52, 0x5C,
  0x63, 0xCD, 0xCD, 0x63, 0x5C, 0x4E, 0x65, 0xFC,
  0xFC, 0xF5, 0xFC, 0xD2, 0x23, 0x22, 0x22, 0x23,
  0x22, 0x22, 0x23, 0x22, 0x22, 0x21, 0x22, 0x22,
  0x22, 0x22, 0x23, 0x22, 0x23, 0x23, 0x22, 0x22,
  0x23, 0x22, 0x21, 0x22, 0x25, 0x29, 0xB3, 0xC7,
  0xB5, 0xB6, 0xB6, 0xB6, 0xB6, 0xB6, 0xB6, 0xB6,
  0xB6, 0xB5, 0xC7, 0xAD, 0x57, 0x3F, 0xCB, 0xF0,
  0xF3, 0xF3, 0xF2, 0xD9, 0x58, 0x41, 0x4C, 0x58,
  0x57, 0x47, 0x42, 0x62, 0xD4, 0xD4, 0xCC, 0x60,
  0x63, 0x5D, 0x50, 0x47, 0x48, 0x4B, 0x58, 0x60,
  0xCC, 0xCE, 0xCD, 0x60, 0x53, 0x5C, 0x62, 0xFB,
  0xF9, 0xFC, 0xFC, 0x21, 0x23, 0x22, 0x22, 0x23,
  0x22, 0x22, 0x23, 0x23, 0x23, 0x21, 0x22, 0x22,
  0x22, 0x22, 0x23, 0x22, 0x23, 0x23, 0x22, 0x22,
  0x23, 0x22, 0x23, 0x23, 0x22, 0x23, 0x81, 0xC7,
  0xB7, 0xB7, 0xBC, 0xB7, 0xBC, 0xBC, 0xBC, 0xB7,
  0xB7, 0xB7, 0xC8, 0x80, 0x58, 0x57, 0x40, 0xCE,
  0xF3, 0xF2, 0xF2, 0xF0, 0xD5, 0x4C, 0x3F, 0x4B,
  0x52, 0x50, 0x2D, 0x4B, 0x64, 0xD2, 0xCC, 0x61,
  0x60, 0x58, 0x4A, 0x47, 0x47, 0x4C, 0x59, 0x64,
  0xD0, 0xD0, 0x64, 0x59, 0x49, 0x5D, 0xFB, 0xFC,
  0xD9, 0xFC, 0xD6, 0x23, 0x22, 0x22, 0x22, 0x23,
  0x22, 0x22, 0x23, 0x23, 0x21, 0x21, 0x22, 0x22,
  0x22, 0x22, 0x23, 0x22, 0x23, 0x23, 0x22, 0x22,
  0x23, 0x22, 0x23, 0x23, 0x22, 0x23, 0xB4, 0xC8,
  0xBD, 0xB7, 0xBD, 0xBC, 0xBD, 0xC5, 0xBC, 0xC5,
  0xBC, 0xBD, 0xC7, 0xAC, 0x58, 0x57, 0x58, 0x2C,
  0xD1, 0xF0, 0xF3, 0xF3, 0xE0, 0xCD, 0x45, 0x3E,
  0x48, 0x4B, 0x3F, 0x41, 0x56, 0x64, 0x65, 0x62,
  0x5D, 0x52, 0x47, 0x48, 0x48, 0x53, 0x60, 0xCC,
  0xD2, 0xD0, 0x63, 0x52, 0x4E, 0x53, 0xFB, 0xFB,
  0xFC, 0xFC, 0x23, 0x23, 0x22, 0x23, 0x22, 0x23,
  0x22, 0x22, 0x23, 0x23, 0x20, 0x21, 0x22, 0x22,
  0x22, 0x22, 0x23, 0x22, 0x23, 0x23, 0x22, 0x22,
  0x23, 0x22, 0x23, 0x22, 0x23, 0x22, 0xB4, 0xC7,
  0xC5, 0xBC, 0xC5, 0xBD, 0xC5, 0xC5, 0xBD, 0xC5,
  0xBC, 0xC6, 0xC7, 0xB9, 0x58, 0x57, 0x58, 0x57,
  0x2D, 0xD4, 0xF1, 0xF2, 0xF0, 0xD9, 0x5D, 0x47,
  0x48, 0x3F, 0x42, 0x2C, 0x48, 0x5C, 0x5F, 0x60,
  0x58, 0x50, 0x47, 0x4A, 0x49, 0x55, 0x63, 0xD0,
  0xD2, 0xCD, 0x5D, 0x49, 0x4E, 0xE1, 0xFC, 0xF0,
  0xFC, 0xF8, 0x22, 0x22, 0x22, 0x23, 0x22, 0x23,
  0x22, 0x22, 0x23, 0x20, 0x21, 0x21, 0x22, 0x22,
  0x22, 0x22, 0x23, 0x22, 0x23, 0x23, 0x23, 0x22,
  0x23, 0x22, 0x23, 0x23, 0x23, 0x22, 0xC4, 0xC8,
  0xBD, 0xBD, 0xC6, 0xBD, 0xC6, 0xC6, 0xC5, 0xC6,
  0xBD, 0xC6, 0xC7, 0xE4, 0x54, 0x57, 0x58, 0x57,
  0x57, 0x43, 0xD7, 0xE0, 0xF1, 0xD8, 0xCD, 0x4B,
  0x4A, 0x47, 0x42, 0x2C, 0x3F, 0x4D, 0x58, 0x5C,
  0x52, 0x4B, 0x48, 0x4B, 0x4A, 0x58, 0xCB, 0xD3,
  0xD2, 0xCD, 0x58, 0x47, 0x4A, 0xFC, 0xFC, 0xFB,
  0xFC, 0x2B, 0x22, 0x22, 0x22, 0x23, 0x22, 0x23,
  0x22, 0x22, 0x23, 0x26, 0x21, 0x21, 0x23, 0x22,
  0x22, 0x22, 0x23, 0x22, 0x23, 0x23, 0x22, 0x23,
  0x22, 0x23, 0x22, 0x23, 0x22, 0x23, 0xE5, 0xC8,
  0xBA, 0xC5, 0xC6, 0xC6, 0xC6, 0xC7, 0xC6, 0xC7,
  0xC5, 0xC6, 0xC8, 0xE5, 0x2E, 0x54, 0x58, 0x57,
  0x57, 0x4C, 0x4D, 0xDA, 0xD8, 0xD8, 0xD4, 0x5C,
  0x4B, 0x4B, 0x3F, 0x42, 0x44, 0x4A, 0x51, 0x58,
  0x4B, 0x48, 0x4B, 0x51, 0x4D, 0x5F, 0xD0, 0xD1,
  0xD0, 0x64, 0x51, 0x44, 0x6B, 0xFC, 0xFB, 0xFC,
  0xFC, 0x21, 0x23, 0x22, 0x22, 0x23, 0x22, 0x23,
  0x22, 0x22, 0x23, 0x26, 0x21, 0x23, 0x23, 0x22,
  0x22, 0x22, 0x23, 0x22, 0x23, 0x23, 0x22, 0x23,
  0x22, 0x23, 0x22, 0x23, 0x23, 0x23, 0xE5, 0xED,
  0xE7, 0xBA, 0xC8, 0xC6, 0xC6, 0xC6, 0xC6, 0xC7,
  0xC7, 0xE5, 0xED, 0xE6, 0x61, 0x41, 0x52, 0x58,
  0x58, 0x57, 0x45, 0x5E, 0xD7, 0xDD, 0xD5, 0x60,
  0x4B, 0x4C, 0x48, 0x4D, 0x4D, 0x50, 0x4D, 0x56,
  0x4A, 0x3E, 0x53, 0x53, 0x52, 0x63, 0xD3, 0xD0,
  0xCE, 0x60, 0x4A, 0x45, 0xFC, 0xFC, 0xF7, 0xFC,
  0xFC, 0x21, 0x23, 0x23, 0x22, 0x23, 0x22, 0x23,
  0x22, 0x23, 0x21, 0x2A, 0x20, 0x23, 0x23, 0x22,
  0x22, 0x22, 0x23, 0x22, 0x23, 0x23, 0x22, 0x22,
  0x23, 0x22, 0x23, 0x22, 0x21, 0x23, 0xEB, 0xF6,
  0xF6, 0xED, 0xED, 0xED, 0xED, 0xED, 0xED, 0xED,
  0xF6, 0xF6, 0xF6, 0xE6, 0xDB, 0x58, 0x45, 0x4B,
  0x58, 0x57, 0x4D, 0x4B, 0x64, 0xD4, 0xD0, 0x5C,
  0x48, 0x51, 0x4C, 0x5D, 0x5E, 0x5C, 0x56, 0x59,
  0x3E, 0x4A, 0x58, 0x54, 0x52, 0x65, 0xD3, 0xD0,
  0xCF, 0x5D, 0x48, 0xFC, 0xFC, 0xFC, 0xFA, 0xFC,
  0xFC, 0x21, 0x22, 0x23, 0x22, 0x23, 0x22, 0x23,
  0x22, 0x23, 0x21, 0x2A, 0x21, 0x23, 0x23, 0x22,
  0x22, 0x22, 0x23, 0x22, 0x23, 0x23, 0x22, 0x22,
  0x23, 0x22, 0x23, 0x22, 0x21, 0x4F, 0xE6, 0xC6,
  0xC6, 0xBD, 0xC6, 0xBD, 0xBD, 0xBD, 0xBD, 0xC6,
  0xC5, 0xBA, 0xC7, 0xE6, 0xF2, 0xD4, 0x49, 0x4B,
  0x3E, 0x4D, 0x52, 0x3E, 0x52, 0x63, 0x64, 0x56,
  0x48, 0x54, 0x4D, 0x61, 0xCC, 0xCC, 0x60, 0x60,
  0x47, 0x4D, 0x5C, 0x53, 0x58, 0xCF, 0xD1, 0xCF,
  0xD0, 0x59, 0x45, 0xFC, 0xFC, 0xFC, 0xEF, 0xF9,
  0xFC, 0x21, 0x23, 0x22, 0x23, 0x22, 0x23, 0x22,
  0x23, 0x22, 0x23, 0x2A, 0x21, 0x23, 0x23, 0x22,
  0x22, 0x22, 0x23, 0x22, 0x23, 0x23, 0x22, 0x22,
  0x23, 0x22, 0x23, 0x22, 0x23, 0x4F, 0xE4, 0xB9,
  0xAF, 0x80, 0x80, 0x8E, 0x8E, 0x8E, 0x8E, 0x8F,
  0x80, 0xB4, 0xB9, 0xE4, 0x7F, 0xDE, 0x61, 0x52,
  0x54, 0x48, 0x3F, 0x43, 0x4D, 0x56, 0x59, 0x4B,
  0x3E, 0x58, 0x53, 0x61, 0xD3, 0xD4, 0xCF, 0xCD,
  0x4C, 0x58, 0x5F, 0x53, 0x5E, 0xD3, 0xD0, 0xCE,
  0xCE, 0x52, 0x3F, 0xFC, 0xFC, 0xFC, 0xF7, 0x65,
  0xFA, 0x22, 0x23, 0x22, 0x23, 0x22, 0x23, 0x22,
  0x23, 0x22, 0x21, 0x2A, 0x23, 0x23, 0x23, 0x22,
  0x22, 0x22, 0x23, 0x22, 0x23, 0x23, 0x22, 0x22,
  0x23, 0x22, 0x23, 0x22, 0x21, 0xB1, 0xE4, 0xE6,
  0x7C, 0xB1, 0x7C, 0xB1, 0xB2, 0xB2, 0xB3, 0x3D,
  0xB3, 0x3C, 0xE5, 0xB3, 0xB0, 0xF1, 0xD0, 0x58,
  0x5D, 0x4D, 0x40, 0x41, 0x48, 0x51, 0x4C, 0x3F,
  0x3F, 0x4D, 0x5A, 0x5A, 0xD5, 0xD9, 0xD7, 0xD4,
  0x57, 0x5E, 0x61, 0x4C, 0x63, 0xD4, 0xCF, 0xCE,
  0xCB, 0x4D, 0x4A, 0xFC, 0xFC, 0xFC, 0xFC, 0xF0,
  0xFB, 0x22, 0x23, 0x22, 0x23, 0x22, 0x23, 0x22,
  0x23, 0x22, 0x23, 0x2A, 0x21, 0x23, 0x23, 0x22,
  0x22, 0x22, 0x23, 0x22, 0x23, 0x23, 0x22, 0x22,
  0x22, 0x23, 0x22, 0x23, 0x23, 0xB1, 0x81, 0x7D,
  0x39, 0x35, 0x35, 0x36, 0x36, 0x36, 0x36, 0x36,
  0x36, 0x36, 0x7C, 0xB2, 0xB0, 0xDF, 0xD2, 0x57,
  0x60, 0x59, 0x5B, 0x59, 0x52, 0x4C, 0x4A, 0x40,
  0x42, 0x4A, 0x53, 0x4D, 0xD2, 0xDE, 0xDE, 0xD9,
  0x5E, 0x5E, 0x60, 0x4A, 0xCD, 0xD1, 0xCF, 0xCE,
  0x63, 0x49, 0x5C, 0xFB, 0xE8, 0x89, 0x9F, 0xFC,
  0xD6, 0x21, 0x21, 0x23, 0x22, 0x22, 0x23, 0x22,
  0x23, 0x22, 0x21, 0x2A, 0x22, 0x23, 0x23, 0x22,
  0x22, 0x22, 0x23, 0x22, 0x23, 0x23, 0x22, 0x22,
  0x22, 0x23, 0x22, 0x23, 0x23, 0x22, 0x7F, 0xB9,
  0x71, 0x6C, 0x38, 0x38, 0x33, 0x33, 0x33, 0x38,
  0x38, 0x71, 0xAD, 0xE4, 0xD3, 0xDA, 0xCC, 0x52,
  0x63, 0x60, 0xCE, 0xD4, 0xCF, 0x60, 0x4C, 0x40,
  0x3F, 0x45, 0x4B, 0x5A, 0xCB, 0xD8, 0xDE, 0xDC,
  0x5E, 0x5E, 0x5F, 0x4C, 0xD2, 0xD2, 0xCF, 0xCF,
  0x61, 0x45, 0x5E, 0xA7, 0x9D, 0x95, 0x8B, 0x99,
  0xFC, 0x41, 0x21, 0x23, 0x23, 0x22, 0x23, 0x22,
  0x23, 0x22, 0x23, 0x2A, 0x23, 0x23, 0x23, 0x22,
  0x22, 0x22, 0x23, 0x22, 0x23, 0x23, 0x22, 0x22,
  0x22, 0x22, 0x23, 0x22, 0x23, 0x77, 0x77, 0xF6,
  0xFC, 0x7D, 0x7D, 0x7E, 0x7E, 0x7E, 0x7E, 0x7D,
  0x7D, 0xFC, 0x47, 0x64, 0xD0, 0xD0, 0x5D, 0x4B,
  0x62, 0xCC, 0xD1, 0xDE, 0xDE, 0xD4, 0x5E, 0x43,
  0x3F, 0x3E, 0x48, 0x53, 0x58, 0xDB, 0xD8, 0xDC,
  0x5E, 0x5E, 0x5E, 0x53, 0xD4, 0xD2, 0xD0, 0xD0,
  0x5E, 0x49, 0xA7, 0xA6, 0x89, 0x95, 0x8B, 0x9C,
  0x9C, 0xFB, 0xD4, 0x22, 0x22, 0x22, 0x22, 0x23,
  0x22, 0x23, 0x23, 0x2A, 0x22, 0x23, 0x23, 0x22,
  0x22, 0x22, 0x23, 0x22, 0x23, 0x23, 0x22, 0x23,
  0x23, 0x22, 0x23, 0x23, 0x98, 0x8C, 0x8C, 0x88,
  0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xF8,
  0xE9, 0x9C, 0x48, 0x5C, 0xD0, 0xCB, 0x48, 0x49,
  0x5B, 0xCB, 0xCD, 0xE0, 0xF1, 0xDD, 0xD0, 0x4A,
  0x41, 0x47, 0x45, 0x4C, 0x48, 0xD7, 0xDE, 0xDC,
  0x5E, 0x5E, 0x5A, 0x58, 0xD1, 0xD0, 0xD0, 0xD2,
  0x5C, 0x55, 0xA7, 0xA6, 0x87, 0x86, 0x89, 0x94,
  0x9C, 0xA9, 0xFC, 0xF4, 0x22, 0x23, 0x22, 0x23,
  0x22, 0x23, 0x22, 0x2A, 0x21, 0x23, 0x23, 0x22,
  0x22, 0x22, 0x23, 0x22, 0x23, 0x23, 0x22, 0x23,
  0x22, 0x23, 0x22, 0x23, 0xA4, 0x89, 0x8C, 0xAA,
  0xFB, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xF7,
  0x85, 0x88, 0x8D, 0x59, 0x64, 0x63, 0x47, 0x3E,
  0x4C, 0x60, 0x61, 0xE0, 0xF0, 0xDF, 0xD9, 0x5D,
  0x2E, 0x3E, 0x3E, 0x47, 0x4D, 0xCD, 0xDE, 0xDC,
  0x5D, 0x5C, 0x51, 0x5D, 0xD1, 0xD2, 0xD2, 0xD4,
  0x5A, 0xBE, 0xA7, 0x98, 0x8A, 0x8A, 0xA0, 0x8B,
  0x86, 0x86, 0xF7, 0xFC, 0xF7, 0x26, 0x23, 0x23,
  0x22, 0x22, 0x22, 0x22, 0x21, 0x22, 0x23, 0x22,
  0x22, 0x22, 0x23, 0x22, 0x23, 0x23, 0x22, 0x23,
  0x22, 0x21, 0x21, 0x21, 0xA1, 0x98, 0x9F, 0xBF,
  0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xA7,
  0x8C, 0x86, 0x8D, 0x59, 0x5E, 0x5D, 0x3F, 0x3E,
  0x47, 0x53, 0x63, 0xD9, 0xF0, 0xF1, 0xDE, 0xD0,
  0x43, 0x3E, 0x47, 0x45, 0x4A, 0x5B, 0xDC, 0xDA,
  0x5D, 0x59, 0x49, 0x5F, 0xD1, 0xD2, 0xD3, 0xB9,
  0xA5, 0xA7, 0x98, 0x9B, 0x96, 0x9D, 0x89, 0x89,
  0x8B, 0x9C, 0x9D, 0xFC, 0xFC, 0xFC, 0x26, 0x22,
  0x23, 0x23, 0x22, 0x22, 0x21, 0x22, 0x23, 0x22,
  0x22, 0x22, 0x23, 0x22, 0x23, 0x23, 0x22, 0x23,
  0x22, 0x22, 0x29, 0x2D, 0x99, 0x99, 0xA2, 0xAA,
  0xC4, 0xFB, 0xFC, 0xFC, 0xFC, 0xF6, 0xBF, 0xA2,
  0x9C, 0x9C, 0x8E, 0xDC, 0xCD, 0x51, 0x41, 0x3E,
  0x45, 0x49, 0x58, 0xCD, 0xE0, 0xE0, 0xD8, 0xDA,
  0x4C, 0x4A, 0x45, 0x45, 0x48, 0x47, 0xDA, 0xDA,
  0x5C, 0x58, 0x44, 0x69, 0xA9, 0x98, 0xA4, 0xA6,
  0xA1, 0xA4, 0x99, 0x9E, 0x9D, 0x8B, 0x8A, 0x97,
  0x87, 0x9A, 0x8A, 0xC2, 0xFC, 0xFC, 0xFC, 0x4D,
  0x21, 0x21, 0x23, 0x22, 0x21, 0x22, 0x23, 0x22,
  0x22, 0x22, 0x23, 0x22, 0x23, 0x23, 0x23, 0x22,
  0x21, 0x22, 0x2D, 0x34, 0xA4, 0xA2, 0xA2, 0xA9,
  0xBF, 0xC0, 0xC3, 0xC1, 0xC0, 0xBE, 0xA6, 0x9D,
  0x99, 0x87, 0xA2, 0xF1, 0xDC, 0x64, 0x42, 0x45,
  0x47, 0x3E, 0x49, 0x4C, 0xDD, 0xDF, 0xD8, 0xDB,
  0x5E, 0x4C, 0x48, 0x45, 0x45, 0x41, 0xD1, 0xD6,
  0x5A, 0x55, 0x3F, 0xA7, 0xA1, 0x98, 0x9F, 0x99,
  0x9F, 0x9D, 0x9A, 0x95, 0x8B, 0x97, 0x89, 0x8A,
  0x88, 0x94, 0x9C, 0x8C, 0xFC, 0xFC, 0xFC, 0xFC,
  0xF4, 0x21, 0x23, 0x22, 0x21, 0x22, 0x23, 0x22,
  0x22, 0x22, 0x23, 0x22, 0x23, 0x23, 0x22, 0x23,
  0x23, 0x23, 0x2C, 0x2C, 0xA8, 0xA2, 0xA4, 0xA4,
  0xA9, 0xAA, 0xAA, 0xAA, 0xA9, 0xA6, 0x98, 0x9C,
  0x8B, 0x88, 0x98, 0x8D, 0xD8, 0xD6, 0x4E, 0x47,
  0x47, 0x49, 0x47, 0x3F, 0xDA, 0xDD, 0xDE, 0xDD,
  0xCC, 0x4A, 0x4B, 0x3E, 0x45, 0x43, 0x61, 0xD4,
  0x56, 0x51, 0x44, 0xA4, 0x9B, 0x8B, 0x9C, 0x9A,
  0xA0, 0xA2, 0x98, 0x98, 0x8B, 0x8B, 0x98, 0x98,
  0x84, 0x8B, 0x94, 0x8A, 0xA4, 0xFC, 0xFC, 0xFC,
  0xFC, 0xF2, 0x21, 0x22, 0x21, 0x22, 0x23, 0x22,
  0x22, 0x22, 0x23, 0x22, 0x23, 0x23, 0x23, 0x23,
  0x23, 0x22, 0x2C, 0x2D, 0xC0, 0xA4, 0xA2, 0xA4,
  0xA4, 0xA6, 0xA6, 0xA6, 0xA4, 0xA2, 0x9F, 0x89,
  0x8B, 0x9C, 0x9C, 0x8B, 0x68, 0xDB, 0x5F, 0x4B,
  0x3E, 0x49, 0x4B, 0x3E, 0xCC, 0xDA, 0xDC, 0xDD,
  0xD3, 0x49, 0x52, 0x48, 0x45, 0x45, 0x53, 0xD0,
  0x51, 0x4A, 0x44, 0xA4, 0x9B, 0x8B, 0x9C, 0xA0,
  0x9B, 0x86, 0x89, 0x98, 0x89, 0x8A, 0x96, 0x8A,
  0x9C, 0x89, 0x89, 0x9C, 0x8C, 0xF6, 0xFC, 0xFC,
  0xFC, 0xFC, 0x21, 0x22, 0x21, 0x22, 0x23, 0x22,
  0x22, 0x22, 0x22, 0x23, 0x22, 0x21, 0x22, 0x23,
  0x22, 0x21, 0x2B, 0x34, 0xC0, 0xA8, 0xA4, 0xA2,
  0xA2, 0x98, 0xA1, 0xA0, 0x98, 0x9F, 0x95, 0x8A,
  0x94, 0xA1, 0x8A, 0x84, 0x9B, 0x68, 0xCC, 0x49,
  0x4A, 0x47, 0x4C, 0x4B, 0x51, 0xD3, 0xDA, 0xDC,
  0xD5, 0x56, 0x56, 0x4A, 0x3E, 0x45, 0x48, 0x63,
  0x4A, 0x47, 0x3E, 0xA7, 0x98, 0x9D, 0x9E, 0x8B,
  0x95, 0x9B, 0x89, 0x86, 0x9B, 0x8B, 0x89, 0x84,
  0x9A, 0xA1, 0x95, 0x9A, 0x8C, 0xA4, 0xFC, 0xFC,
  0xFC, 0xFA, 0x23, 0x22, 0x21, 0x22, 0x23, 0x22,
  0x22, 0x22, 0x22, 0x23, 0x22, 0x21, 0x22, 0x23,
  0x21, 0x23, 0x2C, 0xF6, 0xBF, 0xA9, 0xA2, 0x99,
  0x9D, 0x9D, 0x9D, 0x9D, 0x9D, 0x9B, 0x87, 0x8B,
  0x9C, 0x86, 0x9C, 0x8A, 0x87, 0x87, 0x89, 0x51,
  0x54, 0x47, 0x4B, 0x50, 0x4B, 0xCF, 0xD6, 0xDC,
  0xD5, 0x60, 0x54, 0x52, 0x48, 0x45, 0x40, 0x5A,
  0x45, 0x43, 0x47, 0xA7, 0x98, 0x9B, 0x95, 0x95,
  0x9A, 0x87, 0x98, 0x98, 0x8A, 0x86, 0x87, 0x9E,
  0x9B, 0x95, 0x9D, 0x9D, 0x99, 0x85, 0xA6, 0xFA,
  0xF2, 0x21, 0x23, 0x22, 0x21, 0x22, 0x23, 0x22,
  0x22, 0x22, 0x22, 0x23, 0x22, 0x21, 0x22, 0x22,
  0x21, 0x24, 0xFB, 0xF7, 0xBF, 0xA6, 0xA2, 0x99,
  0x97, 0x89, 0x86, 0x89, 0x9C, 0x96, 0x9E, 0x94,
  0x89, 0x99, 0x98, 0x89, 0x9E, 0x9B, 0x89, 0x8B,
  0x58, 0x4B, 0x4A, 0x52, 0x48, 0xCC, 0xD3, 0xDA,
  0xD3, 0x65, 0x4C, 0x58, 0x49, 0x3E, 0x2E, 0x4D,
  0x40, 0x41, 0x45, 0xA9, 0xA1, 0x9B, 0x9E, 0x9C,
  0x95, 0x8A, 0x94, 0x89, 0x96, 0x87, 0x9C, 0x9A,
  0x84, 0x9D, 0x9C, 0x9E, 0x9A, 0x9C, 0x9D, 0xBB,
  0x23, 0x23, 0x22, 0x22, 0x21, 0x22, 0x23, 0x22,
  0x22, 0x22, 0x22, 0x23, 0x22, 0x21, 0x23, 0x23,
  0x24, 0xFC, 0xFC, 0xF6, 0xBF, 0xA6, 0x9F, 0x99,
  0x89, 0x95, 0x87, 0x94, 0x9D, 0x9E, 0x97, 0x9E,
  0x95, 0x9B, 0x89, 0x95, 0x95, 0x9B, 0x89, 0x87,
  0x5D, 0x56, 0x3E, 0x51, 0x3E, 0x60, 0xCF, 0xD3,
  0xD2, 0xCD, 0x5C, 0x49, 0x4B, 0x3E, 0x2C, 0x48,
  0x3E, 0x43, 0x3E, 0xA9, 0xA1, 0x9B, 0x97, 0x94,
  0x95, 0x9A, 0x9C, 0x87, 0x87, 0x9B, 0x9C, 0x95,
  0x9D, 0x89, 0x9A, 0x89, 0x9E, 0x9E, 0x8C, 0xA6,
  0x20, 0x23, 0x23, 0x22, 0x23, 0x22, 0x23, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x21, 0x21, 0x20, 0x40,
  0xFC, 0xFC, 0xFC, 0xEC, 0xBE, 0xA4, 0x9F, 0x99,
  0x95, 0x9F, 0xA0, 0x88, 0x9D, 0x8B, 0x97, 0x95,
  0x87, 0x95, 0x96, 0x95, 0x97, 0x94, 0x94, 0x98,
  0xD3, 0x4C, 0x47, 0x4D, 0x42, 0x4C, 0x60, 0xCC,
  0xCE, 0xD0, 0x65, 0x4B, 0x47, 0x44, 0x2B, 0x45,
  0x4B, 0x47, 0x49, 0xA7, 0xA1, 0x9A, 0x97, 0x89,
  0x95, 0x97, 0x97, 0x9E, 0x89, 0x95, 0x89, 0x9C,
  0x87, 0x95, 0x97, 0x99, 0x95, 0x99, 0x9F, 0xA4,
  0xC4, 0x21, 0x21, 0x23, 0x21, 0x23, 0x23, 0x23,
  0x23, 0x23, 0x23, 0x23, 0x21, 0x20, 0xFC, 0xFC,
  0xFC, 0xFC, 0xFC, 0xEA, 0xAA, 0xA6, 0xA2, 0x99,
  0x8B, 0x9A, 0x95, 0x9E, 0x9E, 0x9A, 0x94, 0x87,
  0x94, 0x94, 0x89, 0x94, 0x9B, 0x9B, 0xA7, 0xDC,
  0xDB, 0x65, 0x2E, 0x3E, 0x43, 0x44, 0x49, 0x58,
  0x63, 0xD3, 0xD3, 0x5E, 0x42, 0x42, 0x2D, 0x40,
  0x54, 0x4C, 0x4A, 0xA7, 0xA0, 0x99, 0x9B, 0x94,
  0xA0, 0x8A, 0x9B, 0x9D, 0x87, 0x95, 0x94, 0x8B,
  0x8A, 0x98, 0x9C, 0x8A, 0x9B, 0x99, 0xA2, 0xA6,
  0xBF, 0xEC, 0x2A, 0x20, 0x21, 0x23, 0x21, 0x20,
  0x20, 0x20, 0x20, 0x4C, 0xF9, 0xFC, 0xFC, 0xFC,
  0xFC, 0xFC, 0xFC, 0xEB, 0xAA, 0xA4, 0x9F, 0x9C,
  0x8B, 0x9B, 0x88, 0x84, 0x9E, 0x9D, 0x96, 0x94,
  0x94, 0x9A, 0x9B, 0x9B, 0xA4, 0xD5, 0xCD, 0xDE,
  0xF1, 0xDA, 0x4C, 0x2D, 0x41, 0x2B, 0x42, 0x4C,
  0x5E, 0xD4, 0xD7, 0xCD, 0x49, 0x2E, 0x2E, 0x41,
  0x5E, 0x57, 0xA7, 0xA6, 0xA7, 0xA4, 0xA2, 0x98,
  0x9D, 0x9C, 0xA1, 0x99, 0x9D, 0x88, 0x8B, 0x9C,
  0x8A, 0x9C, 0x9C, 0x94, 0x9C, 0x89, 0xA0, 0xA6,
  0xAA, 0xEB, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC,
  0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC,
  0xFC, 0xFC, 0xFB, 0xE9, 0xAA, 0xA6, 0xA2, 0x8B,
  0x8B, 0x8A, 0x86, 0x9B, 0x9C, 0x98, 0xA0, 0x9B,
  0x9B, 0x84, 0xA7, 0xB4, 0x61, 0xD1, 0xD2, 0xE0,
  0xF1, 0xDC, 0x61, 0x2D, 0x2E, 0x3F, 0x56, 0x62,
  0x5D, 0xD4, 0xD9, 0xD3, 0x54, 0x41, 0x41, 0x44,
  0xCB, 0x60, 0x52, 0xA9, 0xA9, 0xA9, 0xA7, 0xA6,
  0xA6, 0xA4, 0xA4, 0xA2, 0xA2, 0x9D, 0x95, 0x89,
  0x9C, 0x8A, 0x9E, 0x9C, 0x8A, 0x9E, 0xA0, 0xA8,
  0xC0, 0xE9, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC,
  0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC,
  0xFC, 0xFC, 0xFC, 0xE9, 0xAA, 0xA6, 0xA0, 0x99,
  0x9C, 0x8B, 0x9A, 0x84, 0x9B, 0x9B, 0x98, 0x98,
  0xA9, 0xB9, 0x49, 0x57, 0xCB, 0xD4, 0xD3, 0xF1,
  0xD8, 0xDA, 0xCE, 0x3F, 0x41, 0x4B, 0x5D, 0xCB,
  0x5E, 0xD6, 0xDB, 0xD6, 0x5D, 0x43, 0x3F, 0x49,
  0xD1, 0xCC, 0x4F, 0xDD, 0xC3, 0xBB, 0xBF, 0xAA,
  0xAA, 0xA9, 0xAA, 0xA8, 0xA8, 0xA6, 0xA6, 0xA2,
  0x9C, 0x9F, 0x9B, 0x9A, 0x9D, 0xA2, 0xA8, 0xAA,
  0xC1, 0xEA, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC,
  0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC,
  0xFC, 0xFC, 0xFC, 0xEA, 0xC0, 0xAA, 0xA6, 0xA2,
  0xA2, 0x99, 0xA0, 0xA0, 0xA4, 0xA7, 0xA9, 0xC0,
  0x67, 0x49, 0x54, 0x60, 0xD0, 0xD4, 0xCC, 0xDF,
  0xD9, 0xD5, 0xD2, 0x3E, 0x47, 0x56, 0x60, 0xCD,
  0x5D, 0xD9, 0xD9, 0xD6, 0x61, 0x3F, 0x47, 0x52,
  0xD6, 0xD3, 0x62, 0x4D, 0x40, 0x4A, 0x57, 0xCA,
  0xC3, 0xC1, 0xC1, 0xC0, 0xBF, 0xBF, 0xAA, 0xAA,
  0xA6, 0xA4, 0xA4, 0xA4, 0xA6, 0xA8, 0xBE, 0xC1,
  0xC9, 0xEB, 0xFB, 0xFB, 0xFC, 0xFC, 0xFC, 0xFC,
  0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC,
  0xFC, 0xFC, 0xFC, 0xEB, 0xC3, 0xC0, 0xAA, 0xA8,
  0xA6, 0xA6, 0xA6, 0xA9, 0xAA, 0xC0, 0xE8, 0xD0,
  0xD2, 0x4C, 0x5E, 0x64, 0xD0, 0xD1, 0x5F, 0xD9,
  0xD5, 0xD1, 0xD0, 0x48, 0x52, 0x5C, 0x64, 0xCD,
  0x5C, 0xDC, 0xD7, 0xD5, 0x62, 0x3F, 0x4C, 0x53,
  0xDA, 0xD7, 0xCE, 0x56, 0x40, 0x4B, 0x52, 0x56,
  0xCE, 0xDF, 0x6A, 0xEB, 0xE9, 0xC9, 0xC3, 0xC0,
  0xC0, 0xBF, 0xBE, 0xAA, 0xBF, 0xC0, 0xC3, 0xC9,
  0xEA, 0xF6, 0xEE, 0x58, 0x57, 0x5E, 0xD6, 0xD0,
  0xD2, 0x61, 0xCB, 0xD6, 0xD6, 0xD4, 0xDF, 0xF3,
  0xF2, 0xDD, 0xD7, 0xEB, 0xC9, 0xC1, 0xC0, 0xBF,
  0xAA, 0xAA, 0xAA, 0xBE, 0xC3, 0xF0, 0xD2, 0xD2,
  0xD2, 0x51, 0x62, 0xCC, 0xD0, 0xCC, 0x61, 0xD3,
  0xCF, 0xCE, 0xD2, 0x48, 0x5A, 0x61, 0xCC, 0xCE,
  0x5F, 0xD9, 0xD5, 0xD1, 0x63, 0x44, 0x56, 0x56,
  0xDC, 0xD9, 0xD4, 0x5E, 0x42, 0x4A, 0x4C, 0x57,
  0x5D, 0xD8, 0xE0, 0xD8, 0xDC, 0xCB, 0x66, 0xEC,
  0xE8, 0xC3, 0xC3, 0xC3, 0xC3, 0xC9, 0xE8, 0xEA,
  0xF6, 0x50, 0x3E, 0x58, 0x57, 0x5A, 0xD6, 0xD4,
  0xCC, 0x4B, 0x53, 0x5C, 0x64, 0xD1, 0xDF, 0xF3,
  0xF1, 0xDE, 0xD9, 0xF6, 0xEB, 0xC9, 0xC1, 0xC1,
  0xC0, 0xC0, 0xC1, 0xC9, 0xF0, 0xD6, 0xCD, 0xD6,
  0xD3, 0x53, 0xCB, 0xCF, 0xCD, 0x5F, 0x5F, 0xCE,
  0xCF, 0xCD, 0xD0, 0x47, 0x5F, 0xCB, 0xCE, 0xCD,
  0x63, 0xD6, 0xD3, 0xD1, 0x63, 0x3F, 0x58, 0x58,
  0xDB, 0xDC, 0xDA, 0x65, 0x3E, 0x49, 0x49, 0x4D,
  0x49, 0xDC, 0xDF, 0xE0, 0xDE, 0xD5, 0x47, 0x47,
  0x46, 0x6B, 0xEB, 0xEA, 0xE9, 0xEA, 0xEB, 0xF6,
  0xD0, 0x57, 0x57, 0x47, 0x47, 0x5B, 0xD4, 0xD4,
  0xCD, 0x44, 0x3E, 0x4B, 0x50, 0x4B, 0x51, 0xD5,
  0xDB, 0xD8, 0xDE, 0x4B, 0xF6, 0xF6, 0xEA, 0xE9,
  0xE8, 0xEA, 0xEB, 0x67, 0x5E, 0xCC, 0xD6, 0xDC,
  0xD5, 0x58, 0xCE, 0xCE, 0x62, 0x50, 0xCC, 0xD3,
  0xD2, 0xCD, 0xCD, 0x4B, 0x64, 0xCE, 0xCE, 0x64,
  0xCC, 0xD3, 0xD2, 0xD2, 0x61, 0x47, 0x5D, 0x5C,
  0xDD, 0xDD, 0xD9, 0xD1, 0x4C, 0x47, 0x49, 0x4A,
  0x4B, 0xD1, 0xD8, 0xE0, 0xDF, 0xDD, 0x5D, 0x4A,
  0x48, 0x52, 0x51, 0x3F, 0xF6, 0xEC, 0xE0, 0xE0,
  0xD3, 0x5E, 0x5F, 0x50, 0x4B, 0x50, 0xCB, 0xCE,
  0x64, 0x45, 0x4C, 0x57, 0x57, 0x58, 0x52, 0xD6,
  0xD3, 0xDE, 0xDF, 0xD1, 0x3E, 0x4B, 0xF6, 0xF6,
  0xEC, 0x66, 0x53, 0x43, 0x56, 0xD1, 0xD9, 0xDE,
  0xD4, 0x5E, 0xCE, 0xCC, 0x5B, 0x2C, 0xD4, 0xD5,
  0xD2, 0xD0, 0x63, 0x5D, 0xCD, 0xD0, 0xCD, 0x5E,
  0xD0, 0xCF, 0xCE, 0xD2, 0x5E, 0x50, 0x60, 0x5D,
  0xDE, 0xDD, 0xDC, 0xD7, 0x5D, 0x45, 0x47, 0x3E,
  0x4B, 0x5E, 0xDE, 0xDF, 0xE0, 0xD8, 0xCF, 0x3E,
  0x45, 0x51, 0x58, 0x42, 0xCB, 0xDA, 0xDE, 0xD8,
  0xD2, 0x61, 0xCC, 0xCF, 0xD6, 0xDA, 0xDA, 0xD5,
  0xD0, 0x50, 0x44, 0x57, 0x57, 0x58, 0x45, 0xD1,
  0xD1, 0xD7, 0xDF, 0xDF, 0xD7, 0xCF, 0x64, 0x60,
  0xCE, 0xCE, 0xCE, 0x63, 0xCF, 0xDA, 0xDE, 0xD9,
  0xCF, 0x63, 0xCD, 0x63, 0x4D, 0x4B, 0xD6, 0xD5,
  0xCE, 0xD3, 0x60, 0xCB, 0xD0, 0xD0, 0x65, 0x47,
  0xD0, 0xCC, 0xCC, 0xD1, 0x59, 0x5D, 0x63, 0x5E,
  0xDD, 0xDD, 0xDE, 0xDC, 0xCB, 0x40, 0x48, 0x45,
  0x3E, 0x3E, 0xD9, 0xDF, 0xE0, 0xDF, 0xDA, 0x51,
  0x4C, 0x48, 0x56, 0x4C, 0x5B, 0xD2, 0xDA, 0xDB,
  0xCB, 0x5F, 0xD0, 0xCC, 0xDC, 0xF0, 0xF3, 0xE0,
  0xDD, 0xCC, 0x41, 0x50, 0x57, 0x57, 0x4B, 0x5D,
  0xD3, 0xD1, 0xDE, 0xDF, 0xDE, 0xD7, 0xD0, 0xD0,
  0xD5, 0xD6, 0xD6, 0xCE, 0xD7, 0xDC, 0xDA, 0xD5,
  0x60, 0x63, 0x64, 0x5E, 0x47, 0x61, 0xD5, 0xD2,
  0xCF, 0xD0, 0x59, 0xCD, 0xD1, 0xCF, 0x61, 0x4D,
  0xCC, 0xCE, 0xCD, 0xD0, 0x52, 0x61, 0x64, 0x60,
  0xDA, 0xDE, 0xDE, 0xDD, 0xD1, 0x4B, 0x4A, 0x45,
  0x3E, 0x41, 0xCD, 0xDE, 0xE0, 0xF1, 0xDE, 0x63,
  0x4A, 0x4A, 0x4A, 0x4B, 0x50, 0xCB, 0xD4, 0xD7,
  0x5E, 0x54, 0x62, 0xD3, 0xD4, 0xF0, 0xF3, 0xF3,
  0xF2, 0xDE, 0x61, 0x40, 0x49, 0x56, 0x4D, 0x3E,
  0x4B, 0xCE, 0xD9, 0xD8, 0xD9, 0xD5, 0xCF, 0xD2,
  0xD6, 0xD6, 0xD1, 0xD1, 0xD7, 0xD5, 0xCF, 0xD0,
  0x54, 0x64, 0x63, 0x56, 0x2C, 0xCB, 0xD1, 0xCC,
  0xD3, 0xCD, 0x54, 0xCF, 0xD1, 0xCE, 0x5E, 0x5C,
  0xCE, 0xCE, 0xCE, 0xCB, 0x4B, 0x63, 0xCC, 0x61,
  0xD4, 0xDC, 0xDE, 0xDE, 0xDA, 0x5D, 0x45, 0x45,
  0x48, 0x3F, 0x52, 0xD9, 0xD8, 0xDF, 0xDF, 0xD2,
  0x52, 0x4B, 0x3E, 0x2E, 0x47, 0x60, 0xCF, 0xD3,
  0x59, 0x48, 0x50, 0x5E, 0xCC, 0xDE, 0xF2, 0xF2,
  0xF3, 0xF3, 0xDD, 0x5D, 0x3E, 0x48, 0x47, 0x47,
  0x58, 0xD1, 0xDA, 0xDA, 0xD5, 0xD1, 0xCD, 0xD2,
  0xD3, 0xCF, 0xD3, 0xD1, 0xCD, 0xD3, 0xD2, 0x5E,
  0x52, 0x64, 0x60, 0x4B, 0x45, 0x61, 0xCD, 0xD3,
  0xD3, 0x64, 0x61, 0xD0, 0xD0, 0x64, 0x45, 0x63,
  0xD0, 0xCE, 0xD0, 0x60, 0x56, 0xCB, 0xCC, 0x62,
  0xCE, 0xDA, 0xDE, 0xD8, 0xDD, 0xCC, 0x45, 0x49,
  0x3E, 0x47, 0x42, 0xD1, 0xDC, 0xD8, 0xD8, 0xD3,
  0x5D, 0x4C, 0x49, 0x3F, 0x47, 0x59, 0xCD, 0xCF,
  0x59, 0x2E, 0x48, 0x47, 0x52, 0x63, 0xF0, 0xF2,
  0xF3, 0xF3, 0xF2, 0xDA, 0x52, 0x4B, 0x52, 0x58,
  0x5E, 0x63, 0xD0, 0xD0, 0xD0, 0xCF, 0xCE, 0xCE,
  0xCF, 0x65, 0x61, 0xD6, 0xD6, 0xD6, 0xCB, 0x4B,
  0x61, 0x62, 0x5D, 0x43, 0x4B, 0x61, 0xD0, 0xD4,
  0xD1, 0x61, 0xCE, 0xD2, 0xCD, 0x5E, 0x4A, 0xCE,
  0xD0, 0xCC, 0xD0, 0x59, 0x61, 0xCC, 0xCC, 0x62,
  0xD1, 0xD5, 0xDE, 0xD8, 0xDD, 0xCF, 0x4B, 0x4A,
  0x45, 0x3E, 0x2D, 0xCB, 0xDC, 0xDE, 0xD8, 0xD5,
  0x60, 0x54, 0x51, 0x4C, 0x4D, 0x5C, 0xCC, 0xCE,
  0x5A, 0x2C, 0x50, 0x53, 0x3E, 0x59, 0xD8, 0xF3,
  0xF2, 0xF3, 0xF3, 0xE0, 0x5E, 0x4A, 0x4C, 0x53,
  0x5E, 0x63, 0xCC, 0xCC, 0xCC, 0xCD, 0xCF, 0xD3,
  0x62, 0x53, 0xD6, 0xD6, 0xD6, 0xD6, 0x5B, 0x48,
  0x64, 0x63, 0x59, 0x44, 0x57, 0x63, 0xD2, 0xD3,
  0xD0, 0x5E, 0xD0, 0xD1, 0xCB, 0x58, 0x4C, 0xCF,
  0xCF, 0xCE, 0xCE, 0x57, 0x63, 0xCC, 0xCD, 0x57,
};

unsigned char linux_logo_bw[] __initdata = {
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x00, 0x3F,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x1F,
  0xFE, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFE, 0x3F, 0xFF, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFE, 0x7F, 0xFF, 0xC7, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xFF, 0xFF, 0xC3,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xFF,
  0xFB, 0xE3, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFD, 0xFF, 0xFF, 0xE1, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xF9, 0xFF, 0xFF, 0xF1, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xF9, 0xFF, 0xFF, 0xF1,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF9, 0xFF,
  0xFF, 0xF8, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xF9, 0xFF, 0xFF, 0xF8, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xF9, 0xCF, 0xC3, 0xF8, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xF9, 0x87, 0x81, 0xF9,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF9, 0xA7,
  0x99, 0xF9, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xF9, 0xF3, 0xBC, 0xF9, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xF9, 0xE3, 0xBC, 0xF9, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xF9, 0xB0, 0x3C, 0xF9,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF9, 0xB0,
  0x19, 0xF0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xF9, 0xC0, 0x03, 0xF0, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xF9, 0x80, 0x01, 0xF8, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xF9, 0x80, 0x01, 0xF8,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF9, 0x80,
  0x01, 0xF8, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xF9, 0xC0, 0x21, 0xD8, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xF9, 0xB1, 0x80, 0xEC, 0xC0, 0x1F,
  0xFF, 0xFF, 0xFF, 0xFF, 0xF1, 0x90, 0x00, 0xE4,
  0x00, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xF1, 0x8C,
  0xC0, 0x7C, 0x04, 0x81, 0xFF, 0xFF, 0xFF, 0xFF,
  0xE3, 0x80, 0x00, 0x7C, 0x40, 0x11, 0xFF, 0xFF,
  0xFF, 0xFF, 0xE3, 0x80, 0x00, 0x7F, 0xD2, 0x29,
  0xFF, 0xFF, 0xFF, 0xFF, 0x87, 0x00, 0x00, 0x3F,
  0x80, 0x19, 0xFF, 0xFF, 0xFF, 0xFF, 0x0E, 0x00,
  0x00, 0x3F, 0x80, 0x19, 0xFF, 0xFF, 0xFF, 0xFF,
  0x1E, 0x00, 0x00, 0x1F, 0x80, 0x19, 0xFF, 0xFF,
  0xFF, 0xFE, 0x1C, 0x00, 0x00, 0x1E, 0x80, 0x19,
  0xFF, 0xFF, 0xFF, 0xFE, 0x3C, 0x00, 0x00, 0x1E,
  0x80, 0x11, 0xFF, 0xFF, 0xFF, 0xFC, 0x7C, 0x00,
  0x00, 0x0F, 0x80, 0x11, 0xFF, 0xFF, 0xFF, 0xFC,
  0xF8, 0x00, 0x00, 0x0E, 0x80, 0x11, 0xFF, 0xFF,
  0xFF, 0xFC, 0xF8, 0x00, 0x00, 0x06, 0x00, 0x11,
  0xFF, 0xFF, 0xFF, 0xF8, 0xF8, 0x00, 0x00, 0x06,
  0x00, 0x01, 0xFF, 0xFF, 0xFF, 0xF9, 0xF0, 0x00,
  0x00, 0x02, 0x00, 0x09, 0xFF, 0xFF, 0xFF, 0xF1,
  0xF0, 0x00, 0x00, 0x02, 0x80, 0x10, 0xFF, 0xFF,
  0xFF, 0xF1, 0xE0, 0x00, 0x00, 0x00, 0x97, 0x10,
  0xFF, 0xFF, 0xFF, 0xE3, 0xE0, 0x00, 0x00, 0x00,
  0xDF, 0xF0, 0xFF, 0xFF, 0xFF, 0xE3, 0xC0, 0x00,
  0x00, 0x00, 0xFF, 0xF8, 0xFF, 0xFF, 0xFF, 0xC7,
  0xC0, 0x00, 0x00, 0x01, 0xFF, 0xF8, 0xFF, 0xFF,
  0xFF, 0xC7, 0x80, 0x00, 0x00, 0x01, 0xFF, 0xF8,
  0xFF, 0xFF, 0xFF, 0x8F, 0x80, 0x00, 0x00, 0x01,
  0xFF, 0xF8, 0xFF, 0xFF, 0xFF, 0x8F, 0x80, 0x00,
  0x00, 0x01, 0xFF, 0xF8, 0xFF, 0xFF, 0xFF, 0x9F,
  0x80, 0x00, 0x00, 0x01, 0xFF, 0xF8, 0xFF, 0xFF,
  0xFF, 0x9F, 0x80, 0x00, 0x00, 0x01, 0x80, 0x18,
  0xFF, 0xFF, 0xFF, 0x9E, 0x80, 0x00, 0x00, 0x03,
  0xA8, 0x11, 0xFF, 0xFF, 0xFF, 0x9F, 0x80, 0x00,
  0x00, 0x02, 0x00, 0x01, 0xFF, 0xFF, 0xFF, 0x99,
  0x80, 0x00, 0x00, 0x00, 0x00, 0x09, 0xFF, 0xFF,
  0xFF, 0x00, 0x80, 0x00, 0x00, 0x01, 0xC0, 0x01,
  0xFF, 0xFF, 0xFE, 0x20, 0x60, 0x00, 0x00, 0x00,
  0xFF, 0xC3, 0xFF, 0xFF, 0xF8, 0x00, 0x30, 0x00,
  0x00, 0x00, 0xFF, 0x0F, 0xFF, 0xFF, 0xC0, 0x40,
  0x38, 0x00, 0x00, 0x00, 0xFE, 0x47, 0xFF, 0xFF,
  0x81, 0x00, 0x1C, 0x00, 0x00, 0x00, 0xFC, 0x23,
  0xFF, 0xFF, 0x90, 0x00, 0x1E, 0x00, 0x00, 0x00,
  0x78, 0x11, 0xFF, 0xFF, 0x80, 0x00, 0x0F, 0x80,
  0x00, 0x00, 0x00, 0x01, 0xFF, 0xFF, 0x80, 0x00,
  0x07, 0xC0, 0x00, 0x00, 0x00, 0x08, 0xFF, 0xFF,
  0xC0, 0x00, 0x07, 0xC0, 0x00, 0x00, 0x00, 0x04,
  0x7F, 0xFF, 0x80, 0x00, 0x03, 0xC0, 0x00, 0x10,
  0x00, 0x00, 0x1F, 0xFF, 0x80, 0x00, 0x01, 0x80,
  0x00, 0x30, 0x00, 0x00, 0x0F, 0xFF, 0x80, 0x00,
  0x00, 0x00, 0x00, 0x70, 0x00, 0x01, 0x4F, 0xFF,
  0x80, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00,
  0x0F, 0xFF, 0xC0, 0x00, 0x00, 0x80, 0x03, 0xF0,
  0x00, 0x00, 0x8F, 0xFF, 0x80, 0x00, 0x00, 0x40,
  0x0F, 0xF0, 0x00, 0x04, 0x1F, 0xFF, 0x80, 0x00,
  0x00, 0x7F, 0xFF, 0xF0, 0x00, 0x10, 0x1F, 0xFF,
  0xC0, 0x00, 0x00, 0x7F, 0xFF, 0xF0, 0x00, 0x40,
  0xFF, 0xFF, 0x98, 0x00, 0x00, 0xFF, 0xFF, 0xF0,
  0x00, 0x83, 0xFF, 0xFF, 0x81, 0xE0, 0x01, 0xFF,
  0xFF, 0xF8, 0x02, 0x07, 0xFF, 0xFF, 0x80, 0x3F,
  0x07, 0xE0, 0x00, 0x1C, 0x0C, 0x1F, 0xFF, 0xFF,
  0xF8, 0x03, 0xFF, 0x80, 0x00, 0x1F, 0x78, 0x1F,
  0xFF, 0xFF, 0xFF, 0x80, 0x7F, 0x00, 0x07, 0x0F,
  0xF0, 0x7F, 0xFF, 0xFF, 0xFF, 0xFE, 0x0C, 0x07,
  0xFF, 0x83, 0xC0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0x00, 0x1F, 0xFF, 0xC0, 0x03, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x07, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
};

unsigned char linux_logo16_red[] __initdata = {
    0x00, 0x90, 0xb0, 0x9c, 0xf7, 0x35, 0x83, 0xa5,
    0x65, 0x8f, 0x98, 0xc9, 0xdb, 0xe1, 0xe7, 0xf8
};

unsigned char linux_logo16_green[] __initdata = {
    0x00, 0x90, 0xb0, 0x9c, 0xf7, 0x2e, 0x83, 0xa5,
    0x65, 0x6e, 0x98, 0x89, 0xbf, 0xac, 0xda, 0xf8
};

unsigned char linux_logo16_blue[] __initdata = {
    0x00, 0x90, 0xaf, 0x9c, 0xf7, 0x2b, 0x82, 0xa5,
    0x65, 0x41, 0x97, 0x1e, 0x60, 0x29, 0xa5, 0xf8
};

unsigned char linux_logo16[] __initdata = {
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xa1, 0x11, 0x11,
    0x61, 0x16, 0x66, 0x66, 0x11, 0x11, 0x11, 0x11,
    0x11, 0x11, 0x1a, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
    0xaa, 0xaa, 0xaa, 0xaa, 0x33, 0xa8, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x87, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x73, 0x33, 0x33, 0x3a, 0xaa, 0xaa,
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
    0xaa, 0xaa, 0xa3, 0x33, 0x33, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x27, 0x77, 0x77, 0x77, 0x33, 0x3a, 0xaa,
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
    0xaa, 0xa3, 0x33, 0x33, 0x30, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x55, 0x50, 0x08, 0x33, 0x77, 0x77,
    0x77, 0x72, 0x72, 0x27, 0x77, 0x77, 0x33, 0x33,
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
    0xa3, 0x33, 0x33, 0x77, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x58, 0x85, 0x00, 0x11, 0x11, 0xaa,
    0xa3, 0x37, 0x77, 0x72, 0x22, 0x22, 0x77, 0x73,
    0x33, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xa3,
    0x33, 0x37, 0x77, 0x33, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x56, 0x85, 0x00, 0x06, 0x66, 0x11,
    0x11, 0x1a, 0xa3, 0x37, 0x77, 0x72, 0x22, 0x77,
    0x73, 0x33, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x33,
    0x33, 0x33, 0x33, 0x30, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x55, 0x00, 0x00, 0x06, 0x66, 0x66,
    0x66, 0x66, 0x11, 0x1a, 0xa3, 0x77, 0x72, 0x22,
    0x77, 0x73, 0x3a, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x33, 0x33,
    0x33, 0x33, 0x33, 0xa0, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11,
    0x66, 0x66, 0x66, 0x66, 0x11, 0xa3, 0x77, 0x22,
    0x22, 0x77, 0x33, 0x33, 0xaa, 0xaa, 0xaa, 0xaa,
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x33, 0x33, 0x33,
    0x33, 0x3a, 0xa1, 0x10, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x77, 0x33,
    0xaa, 0x11, 0x16, 0x66, 0x66, 0x61, 0x1a, 0x37,
    0x22, 0x22, 0x77, 0x33, 0x3a, 0xaa, 0xaa, 0xaa,
    0xaa, 0xaa, 0xaa, 0xaa, 0xa3, 0x33, 0x33, 0x33,
    0x3a, 0xa1, 0x11, 0x10, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x02, 0x22,
    0x22, 0x77, 0x3a, 0x11, 0x66, 0x66, 0x66, 0x1a,
    0x37, 0x22, 0x22, 0x77, 0x33, 0x3a, 0xaa, 0xaa,
    0xaa, 0xaa, 0xaa, 0xaa, 0x33, 0x33, 0x33, 0x3a,
    0xa1, 0x11, 0x11, 0x10, 0x00, 0x00, 0x50, 0x00,
    0x00, 0x05, 0x80, 0x50, 0x00, 0x00, 0x07, 0x72,
    0x22, 0x22, 0x22, 0x73, 0xa1, 0x66, 0x66, 0x61,
    0x1a, 0x77, 0x22, 0x27, 0x73, 0x33, 0xaa, 0xaa,
    0xaa, 0xaa, 0xaa, 0xaa, 0x33, 0x33, 0x3a, 0xaa,
    0x11, 0x11, 0x1a, 0xa0, 0x08, 0x71, 0x05, 0x00,
    0x00, 0x12, 0x22, 0x50, 0x00, 0x00, 0x07, 0x77,
    0x77, 0x72, 0x22, 0x22, 0x27, 0x31, 0x16, 0x66,
    0x61, 0x13, 0x77, 0x22, 0x77, 0x33, 0x3a, 0xaa,
    0xaa, 0xaa, 0xaa, 0xa3, 0x33, 0x33, 0xaa, 0xa1,
    0x11, 0x1a, 0x33, 0x70, 0x07, 0x2e, 0x70, 0x00,
    0x01, 0x44, 0x42, 0x60, 0x00, 0x00, 0x02, 0x22,
    0x22, 0x22, 0x22, 0x22, 0x22, 0x27, 0x31, 0x66,
    0x66, 0x61, 0xa3, 0x72, 0x22, 0x77, 0x33, 0xaa,
    0xaa, 0xaa, 0xa3, 0x33, 0x33, 0xaa, 0xaa, 0x11,
    0x1a, 0x33, 0x77, 0x30, 0x04, 0x82, 0x40, 0x00,
    0x54, 0x48, 0x54, 0x40, 0x00, 0x00, 0x01, 0xaa,
    0x32, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x31,
    0x66, 0x66, 0x11, 0x37, 0x22, 0x27, 0x73, 0x3a,
    0xaa, 0xaa, 0xa3, 0x33, 0x3a, 0xaa, 0xaa, 0xaa,
    0xa3, 0x77, 0xaa, 0x10, 0x50, 0x08, 0x46, 0x05,
    0x54, 0x80, 0x50, 0x42, 0x00, 0x00, 0x08, 0x66,
    0x66, 0x1a, 0x32, 0x22, 0x22, 0x22, 0x22, 0x27,
    0x31, 0x66, 0x66, 0x13, 0x72, 0x22, 0x77, 0x33,
    0xaa, 0xaa, 0xaa, 0x33, 0xaa, 0xa1, 0xaa, 0xa3,
    0x37, 0xa1, 0x1a, 0x30, 0x50, 0x06, 0x26, 0x00,
    0x54, 0x00, 0x00, 0x44, 0x00, 0x00, 0x08, 0xe2,
    0xee, 0xee, 0xee, 0xee, 0xee, 0xee, 0x22, 0x22,
    0x27, 0xa6, 0x66, 0x61, 0xa7, 0x72, 0x27, 0x73,
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x33,
    0x31, 0x11, 0x37, 0x70, 0x02, 0x00, 0xab, 0xbb,
    0xb6, 0x00, 0x00, 0xf4, 0x00, 0x00, 0xee, 0xee,
    0xee, 0xee, 0xee, 0xee, 0xee, 0xee, 0xee, 0x22,
    0x22, 0x23, 0x16, 0x66, 0x1a, 0x37, 0x22, 0x77,
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xa3, 0x3a,
    0x11, 0xa7, 0x33, 0x10, 0x04, 0x09, 0xbd, 0xdd,
    0xbd, 0xd0, 0x04, 0x45, 0x00, 0x0e, 0xee, 0xee,
    0xee, 0xee, 0xee, 0xee, 0xee, 0xee, 0xee, 0x22,
    0x22, 0x22, 0x71, 0x66, 0x66, 0x13, 0x72, 0x27,
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x33, 0x11,
    0xa3, 0x73, 0xa1, 0x60, 0x08, 0xbd, 0xdd, 0xdd,
    0xdd, 0xdd, 0xdb, 0x90, 0x00, 0x02, 0xec, 0xee,
    0xee, 0xee, 0xee, 0xee, 0xee, 0xee, 0xce, 0x22,
    0x22, 0x22, 0x27, 0xa6, 0x66, 0x61, 0x37, 0x27,
    0x1a, 0xaa, 0xaa, 0xaa, 0xaa, 0xa3, 0xa1, 0x1a,
    0x33, 0xa1, 0x16, 0x60, 0x0b, 0xbd, 0xdd, 0xdd,
    0xcd, 0xdd, 0xdd, 0xd9, 0x00, 0x00, 0xec, 0xcc,
    0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xce, 0xa2,
    0x22, 0x22, 0x22, 0x7a, 0x66, 0x66, 0x13, 0x77,
    0x1a, 0xaa, 0xaa, 0xaa, 0xaa, 0x3a, 0x11, 0x33,
    0xaa, 0x11, 0x66, 0x60, 0x9b, 0xdd, 0xdd, 0xdd,
    0xcd, 0xdd, 0xdb, 0xb9, 0x00, 0x00, 0xec, 0xcc,
    0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xee, 0x61,
    0x72, 0x22, 0x22, 0x22, 0xa1, 0x66, 0x61, 0x37,
    0x1a, 0xaa, 0xaa, 0xaa, 0xa3, 0xa1, 0x13, 0x3a,
    0x11, 0x11, 0x11, 0x10, 0x5b, 0xdd, 0xdd, 0xdc,
    0xdd, 0xdd, 0xbd, 0xd9, 0x00, 0x00, 0xec, 0xcc,
    0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xee, 0x86,
    0x17, 0x22, 0x22, 0x22, 0x23, 0x16, 0x66, 0xaa,
    0xaa, 0xa3, 0x3a, 0xaa, 0xaa, 0x1a, 0x3a, 0xa1,
    0x11, 0x11, 0x1a, 0x70, 0x05, 0xbd, 0xdd, 0xdd,
    0xdb, 0x5b, 0xdd, 0xb0, 0x00, 0x60, 0x2e, 0xcc,
    0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xe6, 0x88,
    0x66, 0x32, 0x22, 0x22, 0x22, 0x36, 0x66, 0x11,
    0x33, 0x33, 0x3a, 0xaa, 0x11, 0xaa, 0xaa, 0xa1,
    0x11, 0x1a, 0x3a, 0x60, 0x02, 0x99, 0xbb, 0xb9,
    0x9b, 0xbb, 0xbc, 0x22, 0x00, 0x86, 0x5e, 0xcc,
    0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xe1, 0x68,
    0x86, 0x63, 0x22, 0x22, 0x22, 0x2a, 0x66, 0x66,
    0x33, 0x33, 0xaa, 0xaa, 0x1a, 0xaa, 0xaa, 0x11,
    0x1a, 0xa7, 0x68, 0x80, 0x02, 0x2b, 0xbd, 0xbb,
    0xbb, 0xb9, 0x22, 0x22, 0x00, 0x06, 0x6e, 0xcc,
    0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xc7, 0xa6,
    0x88, 0x86, 0x32, 0x22, 0x22, 0x27, 0xa6, 0x66,
    0x33, 0x3a, 0xaa, 0xa1, 0xaa, 0xaa, 0xa1, 0x11,
    0xa3, 0xa6, 0x88, 0x80, 0x02, 0x22, 0x9b, 0xbb,
    0xbb, 0x22, 0x24, 0xf4, 0x60, 0x00, 0x0c, 0xcc,
    0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xc2, 0x21,
    0x68, 0x88, 0x63, 0x22, 0x22, 0x22, 0x71, 0x66,
    0x33, 0x3a, 0x11, 0x11, 0xaa, 0xaa, 0x11, 0xaa,
    0x71, 0x88, 0x88, 0x00, 0x02, 0xe2, 0x26, 0x99,
    0x22, 0x22, 0x4f, 0xf4, 0x40, 0x00, 0x0c, 0xcc,
    0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x22, 0x22,
    0x16, 0x88, 0x86, 0xa2, 0x22, 0x22, 0x27, 0x11,
    0x33, 0xa1, 0x11, 0x11, 0xaa, 0x31, 0x1a, 0xa3,
    0x68, 0x88, 0x81, 0x00, 0x54, 0x42, 0x22, 0x22,
    0x22, 0x44, 0xff, 0xff, 0x48, 0x00, 0x00, 0x99,
    0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0x99, 0x22, 0x22,
    0x21, 0x88, 0x88, 0x6a, 0x22, 0x22, 0x22, 0x31,
    0x3a, 0xa1, 0x11, 0x1a, 0xa3, 0x11, 0x33, 0x36,
    0x88, 0x86, 0x30, 0x00, 0x4f, 0x44, 0x22, 0x22,
    0x24, 0xff, 0xff, 0xff, 0x44, 0x00, 0x00, 0x99,
    0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0x95, 0x22, 0x72,
    0x22, 0x18, 0x88, 0x86, 0x32, 0x22, 0x22, 0x27,
    0xaa, 0x11, 0x11, 0x1a, 0x31, 0x13, 0x33, 0x68,
    0x88, 0x6a, 0x00, 0x02, 0x4f, 0x4f, 0x42, 0x24,
    0x4f, 0xff, 0xff, 0xff, 0xf4, 0x50, 0x00, 0x99,
    0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0x99, 0x22, 0x73,
    0x72, 0x26, 0x88, 0x88, 0x63, 0x22, 0x22, 0x22,
    0x11, 0x11, 0x11, 0xa3, 0xa1, 0x73, 0xa6, 0x88,
    0x81, 0xa5, 0x00, 0x04, 0x4f, 0x4f, 0x44, 0x4f,
    0xff, 0xff, 0xff, 0xff, 0xf4, 0x40, 0x00, 0x99,
    0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0x99, 0x12, 0x27,
    0xaa, 0x22, 0x68, 0x55, 0x86, 0x72, 0x22, 0x22,
    0x11, 0x11, 0x1a, 0x33, 0x13, 0x3a, 0x18, 0x88,
    0x1a, 0x10, 0x00, 0x44, 0x4f, 0x4f, 0xff, 0x4f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x99,
    0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0x99, 0x61, 0x22,
    0x3a, 0xa2, 0x26, 0x85, 0x58, 0x67, 0x22, 0x22,
    0x61, 0x61, 0x1a, 0x7a, 0x37, 0x31, 0x88, 0x81,
    0x11, 0x00, 0x05, 0xe4, 0x44, 0xff, 0xff, 0xff,
    0x4f, 0xf4, 0x44, 0xff, 0xff, 0xf5, 0x00, 0x99,
    0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0x99, 0x88, 0x12,
    0x2a, 0xaa, 0x72, 0x68, 0x55, 0x81, 0x22, 0x22,
    0x66, 0x61, 0xa3, 0x33, 0x73, 0x16, 0x88, 0x11,
    0x10, 0x00, 0x08, 0x74, 0x44, 0x4f, 0x44, 0x44,
    0xf4, 0xf4, 0x44, 0x44, 0xe2, 0x44, 0x00, 0x99,
    0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0x99, 0x88, 0x81,
    0x22, 0xaa, 0xa7, 0x26, 0x85, 0x88, 0x12, 0x22,
    0x66, 0x61, 0x37, 0xa7, 0x3a, 0x66, 0x66, 0x11,
    0x80, 0x00, 0x0a, 0x72, 0x44, 0x4f, 0x44, 0x4f,
    0xff, 0x44, 0x44, 0x22, 0x22, 0x24, 0x00, 0x99,
    0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0x99, 0x85, 0x88,
    0x12, 0x2a, 0xaa, 0x22, 0x68, 0x58, 0x63, 0x22,
    0x66, 0x1a, 0x73, 0x77, 0x31, 0x66, 0x61, 0x11,
    0x00, 0x00, 0x07, 0x44, 0xff, 0x4f, 0xf4, 0x4f,
    0xff, 0x4f, 0x44, 0xf4, 0x42, 0x22, 0x40, 0x9b,
    0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xb9, 0x85, 0x55,
    0x81, 0x27, 0xaa, 0xa2, 0x78, 0x88, 0x86, 0x72,
    0x66, 0x13, 0x77, 0x73, 0x11, 0x66, 0x61, 0x76,
    0x00, 0x50, 0x84, 0xf4, 0xff, 0x4f, 0xf4, 0xff,
    0xff, 0x4f, 0x44, 0xff, 0x4f, 0x42, 0x40, 0x9b,
    0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xb9, 0x68, 0x55,
    0x58, 0x12, 0x3a, 0xaa, 0x23, 0x88, 0x88, 0xa7,
    0x66, 0xa7, 0x77, 0x7a, 0x16, 0x66, 0x1a, 0x15,
    0x05, 0x00, 0x4f, 0xf4, 0xff, 0x4f, 0xf4, 0xff,
    0xff, 0x4f, 0x44, 0xff, 0x4f, 0x44, 0x24, 0x9b,
    0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xb9, 0x26, 0x55,
    0x55, 0x81, 0x23, 0xaa, 0x32, 0x18, 0x88, 0x6a,
    0x61, 0x37, 0x77, 0x31, 0x66, 0x66, 0x17, 0x60,
    0x05, 0x08, 0x4f, 0xf4, 0xff, 0x4f, 0xf4, 0xff,
    0xff, 0x4f, 0x44, 0xff, 0x4f, 0x4f, 0x4e, 0x99,
    0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0x99, 0xa2, 0x65,
    0x55, 0x58, 0xa2, 0x7a, 0xa2, 0x26, 0x88, 0x61,
    0x61, 0x32, 0x27, 0xa1, 0x66, 0x61, 0x31, 0x60,
    0x00, 0x04, 0x4f, 0xf4, 0xff, 0x44, 0x44, 0xff,
    0xff, 0x4f, 0x44, 0xff, 0x4f, 0x44, 0xf4, 0x99,
    0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0x9b, 0xaa, 0x26,
    0x55, 0x55, 0x87, 0x27, 0x33, 0x27, 0x68, 0x61,
    0x1a, 0x72, 0x27, 0xa6, 0x66, 0x6a, 0x71, 0x00,
    0x80, 0x84, 0xff, 0xf4, 0xff, 0x44, 0x44, 0xff,
    0xff, 0x4f, 0x44, 0xff, 0x4f, 0x44, 0xf4, 0x99,
    0x9b, 0x9b, 0x99, 0xb9, 0xb9, 0x99, 0xaa, 0xa2,
    0x85, 0x55, 0x56, 0x22, 0x27, 0x22, 0x36, 0x66,
    0x13, 0x22, 0x23, 0x16, 0x86, 0x63, 0x73, 0x00,
    0x00, 0x44, 0xf4, 0xf4, 0xff, 0x44, 0x44, 0xff,
    0xff, 0x4f, 0x44, 0xff, 0x4f, 0x4f, 0x4f, 0x99,
    0x9b, 0x99, 0x99, 0x99, 0xb9, 0x99, 0xaa, 0xaa,
    0x28, 0x55, 0x58, 0x12, 0x22, 0x22, 0x21, 0x11,
    0xa3, 0x27, 0x7a, 0x66, 0x86, 0x17, 0x75, 0x05,
    0x05, 0xff, 0xf4, 0xf4, 0xff, 0x44, 0x44, 0xff,
    0xff, 0x4f, 0x44, 0x4f, 0x4f, 0x44, 0x4f, 0x99,
    0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x3a, 0xaa,
    0xa2, 0x85, 0x58, 0x67, 0x72, 0x22, 0x27, 0xa1,
    0x37, 0x27, 0x7a, 0x68, 0x86, 0xa2, 0x70, 0x00,
    0x02, 0xff, 0xf4, 0xf4, 0xff, 0x44, 0x44, 0x4f,
    0xff, 0x4f, 0x44, 0xf4, 0xf4, 0xf4, 0xf4, 0x99,
    0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x23, 0xaa,
    0xa7, 0x78, 0x88, 0x81, 0x77, 0x22, 0x27, 0x3a,
    0x72, 0x73, 0x71, 0x68, 0x66, 0x32, 0x50, 0x00,
    0x04, 0x4f, 0xf4, 0xf4, 0xff, 0x44, 0x44, 0x4f,
    0xff, 0x4f, 0x44, 0xf4, 0xf4, 0xf4, 0x44, 0x95,
    0x99, 0x99, 0x99, 0x99, 0x99, 0x55, 0x12, 0x3a,
    0xaa, 0x21, 0x88, 0x81, 0x77, 0x27, 0x73, 0x73,
    0x72, 0x33, 0x36, 0x86, 0x61, 0x72, 0x00, 0x00,
    0x04, 0x44, 0xf4, 0xf4, 0xf4, 0x44, 0x44, 0x4f,
    0xff, 0x4f, 0x44, 0xff, 0x4f, 0x4f, 0x44, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x8a, 0x27,
    0xaa, 0x77, 0x68, 0x61, 0x23, 0x71, 0x11, 0x3a,
    0x27, 0xa3, 0x36, 0x86, 0x61, 0x20, 0x00, 0x00,
    0x04, 0xf4, 0xf4, 0xf4, 0xf4, 0x44, 0x44, 0x4f,
    0xff, 0x4f, 0x44, 0xff, 0x4f, 0x4f, 0x41, 0x59,
    0x99, 0x99, 0x99, 0x99, 0x99, 0x95, 0x58, 0x77,
    0x27, 0x32, 0x36, 0x63, 0x23, 0x71, 0x66, 0x11,
    0x27, 0x13, 0xa6, 0x86, 0x6a, 0x20, 0x00, 0x50,
    0x04, 0x4f, 0x4f, 0x4f, 0x4f, 0x44, 0x44, 0x4f,
    0xff, 0x4f, 0x44, 0xff, 0x4f, 0x4f, 0x41, 0x99,
    0x9b, 0xbb, 0xbb, 0xbb, 0xb9, 0x99, 0x68, 0x13,
    0x32, 0x22, 0x73, 0xa7, 0x2a, 0x31, 0x88, 0x66,
    0x7a, 0x13, 0x18, 0x66, 0x63, 0x20, 0x00, 0x06,
    0x0f, 0x4f, 0x4f, 0x4f, 0x4f, 0x44, 0x44, 0x4f,
    0xff, 0x4f, 0x44, 0xff, 0x4f, 0x4f, 0x49, 0x95,
    0xa9, 0xa9, 0x99, 0x97, 0x92, 0x99, 0x65, 0x6a,
    0x17, 0x22, 0x23, 0x72, 0x27, 0xaa, 0x88, 0x88,
    0xa1, 0x17, 0x68, 0x66, 0x67, 0x70, 0x00, 0x05,
    0x0f, 0x4f, 0x4f, 0x4f, 0x4f, 0x44, 0x44, 0x4f,
    0xff, 0x4f, 0x44, 0xff, 0xf4, 0xf4, 0x49, 0x9c,
    0x2e, 0xee, 0xee, 0xee, 0xee, 0xa9, 0x65, 0x8a,
    0x1a, 0xaa, 0x37, 0x72, 0x27, 0x37, 0x88, 0x88,
    0x11, 0x17, 0x68, 0x66, 0x67, 0x10, 0x9d, 0xd0,
    0x84, 0x44, 0xff, 0x4f, 0x4f, 0x44, 0xf4, 0x4f,
    0xff, 0x4f, 0x44, 0xff, 0xf4, 0xf4, 0x4f, 0x69,
    0xcc, 0xee, 0xee, 0xee, 0xec, 0x99, 0x88, 0x63,
    0x61, 0x68, 0x61, 0x72, 0x22, 0x7a, 0x68, 0x88,
    0x11, 0x17, 0x88, 0x66, 0x12, 0x1b, 0xdd, 0xdd,
    0x02, 0x44, 0x4f, 0x4f, 0x4f, 0x44, 0x44, 0x4f,
    0xff, 0x4f, 0x44, 0xff, 0xff, 0x4f, 0x4c, 0xc5,
    0x0c, 0xc1, 0x11, 0x1c, 0xc0, 0x26, 0x66, 0x17,
    0x66, 0x88, 0x88, 0x12, 0x22, 0x23, 0xa8, 0x88,
    0x11, 0x13, 0x88, 0x66, 0x17, 0xbb, 0xdd, 0xdd,
    0xd0, 0x8f, 0xff, 0xf4, 0xf4, 0x44, 0xf4, 0x4f,
    0xff, 0x4f, 0x44, 0xf4, 0x4f, 0x44, 0xdd, 0xdd,
    0x00, 0x00, 0x00, 0x05, 0x9d, 0x21, 0x66, 0x27,
    0xa6, 0x65, 0x58, 0x67, 0x22, 0x27, 0x28, 0x88,
    0x11, 0xaa, 0x86, 0x68, 0x1a, 0xbb, 0xdd, 0xdd,
    0xdb, 0x05, 0xf4, 0xf4, 0xf4, 0xf4, 0x44, 0x4f,
    0xff, 0x4f, 0x44, 0xf4, 0xf4, 0xf4, 0xdd, 0xdb,
    0x00, 0x00, 0x00, 0x00, 0xdd, 0xda, 0x66, 0x22,
    0x71, 0x15, 0x55, 0x81, 0x22, 0x22, 0x76, 0x88,
    0x11, 0x31, 0x88, 0x88, 0xab, 0xbd, 0xdd, 0xdd,
    0xdd, 0x00, 0x04, 0x44, 0xff, 0xff, 0x4f, 0x4f,
    0xff, 0x4f, 0x44, 0xf4, 0xf4, 0x44, 0xdd, 0xdb,
    0x00, 0x00, 0x00, 0x0b, 0xdd, 0xda, 0x11, 0x22,
    0x23, 0x68, 0x55, 0x86, 0x22, 0x22, 0x7a, 0x88,
    0x1a, 0x71, 0x88, 0x89, 0xbb, 0xdd, 0xdd, 0xdd,
    0xdd, 0xd0, 0x00, 0x4f, 0x44, 0xff, 0x4f, 0x4f,
    0xff, 0x4f, 0x44, 0xf4, 0xff, 0xe2, 0xdd, 0xdb,
    0x90, 0x00, 0x05, 0xbd, 0xdd, 0xb8, 0x63, 0x22,
    0x27, 0xa6, 0x55, 0x88, 0x77, 0x22, 0x22, 0x88,
    0x1a, 0x28, 0xbd, 0xdb, 0xdd, 0xdd, 0xdd, 0xdd,
    0xdd, 0xdb, 0x00, 0x07, 0x44, 0x4f, 0x4f, 0x4f,
    0xff, 0x4f, 0x44, 0x4f, 0x4f, 0x22, 0xdd, 0xdb,
    0xbb, 0x9b, 0xbb, 0xbd, 0xdd, 0xd5, 0x86, 0x22,
    0x22, 0x77, 0x85, 0x88, 0x17, 0x22, 0x22, 0x88,
    0xaa, 0x2b, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd,
    0xdd, 0xdd, 0x00, 0x00, 0x54, 0x4f, 0x4f, 0x4f,
    0xff, 0x4f, 0x44, 0xf4, 0x44, 0x22, 0xbd, 0xdd,
    0xbb, 0xbb, 0xbb, 0xdd, 0xdd, 0xdd, 0x88, 0x72,
    0x27, 0x22, 0x88, 0x88, 0x67, 0x72, 0x22, 0x18,
    0x33, 0x2d, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd,
    0xdd, 0xdd, 0xd0, 0x00, 0x05, 0x4f, 0x4f, 0x4f,
    0xff, 0x4f, 0x44, 0x44, 0x4f, 0x22, 0xbd, 0xdd,
    0xdb, 0xbb, 0xdd, 0xdd, 0xdd, 0xdd, 0x88, 0x17,
    0x27, 0x72, 0x68, 0x88, 0x87, 0x32, 0x22, 0x36,
    0x37, 0x2d, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd,
    0xdd, 0xdd, 0xd5, 0x00, 0x00, 0x4f, 0x4f, 0x4f,
    0xff, 0xf4, 0xf4, 0xf4, 0xf4, 0x22, 0xbb, 0xdd,
    0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xd8, 0x67,
    0x72, 0x77, 0x38, 0x88, 0x83, 0x37, 0x22, 0x26,
    0x72, 0x2b, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd,
    0xdd, 0xdd, 0xdd, 0x00, 0x00, 0x4f, 0x4f, 0x4f,
    0xff, 0xf4, 0xf4, 0xf4, 0x44, 0x25, 0xbb, 0xdd,
    0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xd3,
    0x32, 0x73, 0x76, 0x88, 0x81, 0x33, 0x22, 0x2a,
    0x22, 0x2b, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd,
    0xdd, 0xdd, 0xdd, 0xb0, 0x54, 0x4f, 0x4f, 0x4f,
    0xff, 0xf4, 0xf4, 0xff, 0x44, 0x00, 0xbb, 0xdd,
    0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd,
    0xa7, 0x73, 0x26, 0x88, 0x86, 0x7a, 0x72, 0x27,
    0x22, 0x2b, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd,
    0xdd, 0xdd, 0xdd, 0xdb, 0x44, 0xff, 0x4f, 0x4f,
    0xff, 0xf4, 0xf4, 0x44, 0x40, 0x05, 0xbb, 0xdd,
    0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd,
    0x13, 0x23, 0x21, 0x68, 0x86, 0x17, 0x72, 0x22,
    0x22, 0x2b, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd,
    0xdd, 0xdd, 0xdd, 0xdb, 0x44, 0x4f, 0x4f, 0x4f,
    0xff, 0xff, 0x44, 0x42, 0x00, 0x05, 0xbd, 0xdd,
    0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd,
    0x87, 0x27, 0x27, 0x16, 0x66, 0x67, 0x22, 0x22,
    0x72, 0x7b, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd,
    0xdd, 0xdd, 0xdd, 0xdd, 0x94, 0x44, 0x44, 0x44,
    0x44, 0x44, 0x44, 0x00, 0x00, 0x05, 0xbb, 0xdd,
    0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xb8,
    0x86, 0x22, 0x22, 0x7a, 0x68, 0x81, 0x22, 0x22,
    0x37, 0x7b, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd,
    0xdd, 0xdd, 0xdd, 0xdb, 0xb5, 0x44, 0x44, 0x44,
    0x44, 0x47, 0x00, 0x00, 0x00, 0x05, 0xbd, 0xdd,
    0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xd8, 0x68,
    0x58, 0x72, 0x22, 0x27, 0x18, 0x86, 0x72, 0x22,
    0x1a, 0xbb, 0xbd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd,
    0xdd, 0xdd, 0xdd, 0xdb, 0xb5, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0xbb, 0xdd,
    0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xb9, 0x18, 0x85,
    0x58, 0x12, 0x22, 0x36, 0x18, 0x88, 0x32, 0x22,
    0x61, 0x3b, 0xbb, 0xbb, 0xbd, 0xdd, 0xdd, 0xdd,
    0xdd, 0xdd, 0xdd, 0xdb, 0xb9, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0xbb, 0xdd,
    0xdd, 0xdd, 0xdd, 0xdd, 0xb9, 0x7a, 0x68, 0x85,
    0x88, 0x62, 0x27, 0x16, 0x18, 0x88, 0x12, 0x27,
    0x86, 0x18, 0x9b, 0xbb, 0xbb, 0xbb, 0xbb, 0xbd,
    0xdd, 0xdd, 0xdd, 0xbb, 0xb5, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0xbb, 0xbd,
    0xdd, 0xdd, 0xdb, 0xbb, 0x87, 0x31, 0x68, 0x65,
    0x88, 0x82, 0x23, 0x16, 0x18, 0x88, 0x12, 0x23,
    0x88, 0x67, 0x27, 0xa8, 0x9b, 0xbb, 0xbb, 0xbb,
    0xbd, 0xdd, 0xbb, 0xbb, 0x95, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x9b, 0xbb,
    0xbb, 0xbb, 0xbb, 0x96, 0x87, 0x16, 0x68, 0x18,
    0x88, 0x62, 0x31, 0x66, 0x18, 0x88, 0x62, 0x73,
    0x88, 0x63, 0x27, 0x33, 0x65, 0x55, 0x99, 0x9b,
    0xbb, 0xbb, 0xbb, 0x99, 0x55, 0x0a, 0xa1, 0x86,
    0x81, 0x68, 0x88, 0x55, 0x58, 0x85, 0x9b, 0xbb,
    0xbb, 0xbb, 0x95, 0x88, 0x83, 0x66, 0x66, 0x18,
    0x66, 0x82, 0xa1, 0x66, 0x18, 0x88, 0x62, 0x33,
    0x88, 0x81, 0x27, 0x7a, 0x18, 0x58, 0x86, 0x85,
    0x99, 0x99, 0x99, 0x95, 0x53, 0x2a, 0xaa, 0x88,
    0x67, 0x31, 0x68, 0x55, 0x58, 0x85, 0x59, 0xbb,
    0xbb, 0xb9, 0x58, 0x68, 0x83, 0x66, 0x61, 0x16,
    0x66, 0x62, 0x16, 0x66, 0x68, 0x88, 0x62, 0xaa,
    0x88, 0x86, 0x27, 0x77, 0x78, 0x55, 0x88, 0x22,
    0x25, 0x55, 0x95, 0x55, 0x6a, 0xa2, 0x2a, 0x88,
    0x62, 0x27, 0x37, 0x38, 0x88, 0x87, 0x55, 0x59,
    0x95, 0x58, 0x16, 0x88, 0x8a, 0x66, 0x63, 0x68,
    0x86, 0x67, 0x66, 0x66, 0x68, 0x88, 0x12, 0x11,
    0x88, 0x88, 0x72, 0x77, 0x78, 0x85, 0x58, 0x17,
    0x23, 0x32, 0x55, 0x55, 0x81, 0x13, 0x73, 0x66,
    0x62, 0x7a, 0xaa, 0x38, 0x88, 0x58, 0x27, 0x55,
    0x58, 0x32, 0x38, 0x88, 0x81, 0x66, 0xa2, 0x88,
    0x86, 0x61, 0x66, 0x61, 0x66, 0x68, 0x13, 0x11,
    0x88, 0x88, 0x12, 0x22, 0x71, 0x85, 0x58, 0x62,
    0x23, 0xa2, 0x68, 0x88, 0x81, 0x66, 0x88, 0x88,
    0x63, 0x2a, 0xaa, 0x28, 0x88, 0x55, 0x86, 0x61,
    0x66, 0x66, 0x68, 0x88, 0x66, 0x66, 0x77, 0x88,
    0x68, 0x16, 0x66, 0x62, 0x66, 0x68, 0xa1, 0x61,
    0x88, 0x88, 0x62, 0x22, 0x22, 0x85, 0x55, 0x83,
    0x72, 0x37, 0xa8, 0x88, 0x61, 0x66, 0x85, 0x55,
    0x86, 0x23, 0xaa, 0x71, 0x88, 0x85, 0x88, 0x66,
    0x88, 0x86, 0x88, 0x88, 0x16, 0x61, 0x21, 0x88,
    0x66, 0xa6, 0x86, 0x17, 0x66, 0x66, 0x31, 0x61,
    0x88, 0x88, 0x87, 0x72, 0x22, 0x68, 0x55, 0x86,
    0x77, 0x77, 0x36, 0x88, 0x13, 0x68, 0x85, 0x55,
    0x58, 0x12, 0x73, 0x72, 0x76, 0x88, 0x88, 0x68,
    0x88, 0x88, 0x88, 0x66, 0x36, 0x63, 0x26, 0x86,
    0x86, 0x36, 0x86, 0x11, 0x66, 0x66, 0x76, 0x61,
    0x88, 0x88, 0x81, 0x22, 0x22, 0x38, 0x85, 0x58,
    0x37, 0x22, 0x21, 0x68, 0xa2, 0x31, 0x68, 0x55,
    0x55, 0x81, 0x22, 0x22, 0xa8, 0x88, 0x88, 0x68,
    0x86, 0x88, 0x68, 0x81, 0x36, 0x17, 0x21, 0x68,
    0x86, 0x16, 0x66, 0x26, 0x66, 0x61, 0x36, 0x66,
    0x68, 0x88, 0x86, 0x27, 0x22, 0x28, 0x88, 0x88,
    0x17, 0x72, 0x2a, 0x66, 0xa2, 0x22, 0x36, 0x55,
    0x55, 0x58, 0x37, 0x3a, 0x16, 0x66, 0x66, 0x66,
    0x66, 0x18, 0x88, 0x67, 0x16, 0x12, 0x71, 0x68,
    0x81, 0x68, 0x61, 0x76, 0x66, 0x6a, 0x16, 0x66,
    0x88, 0x88, 0x86, 0x77, 0x22, 0x26, 0x88, 0x88,
    0x13, 0x37, 0x71, 0x66, 0xa2, 0x33, 0x2a, 0x85,
    0x55, 0x55, 0x17, 0x73, 0x16, 0x66, 0x66, 0x68,
    0x63, 0x88, 0x88, 0xa2, 0x66, 0xa2, 0xa6, 0x88,
    0x61, 0x68, 0x6a, 0x76, 0x66, 0x6a, 0x66, 0x6a
};

#else

/* prototypes only */
extern unsigned char linux_logo_red[];
extern unsigned char linux_logo_green[];
extern unsigned char linux_logo_blue[];
extern unsigned char linux_logo[];
extern unsigned char linux_logo_bw[];
extern unsigned char linux_logo16_red[];
extern unsigned char linux_logo16_green[];
extern unsigned char linux_logo16_blue[];
extern unsigned char linux_logo16[];

#endif
