#ifndef SPI_BCM53XX_H
#define SPI_BCM53XX_H

#define B53SPI_BSPI_REVISION_ID			0x000
#define B53SPI_BSPI_SCRATCH			0x004
#define B53SPI_BSPI_MAST_N_BOOT_CTRL		0x008
#define B53SPI_BSPI_BUSY_STATUS			0x00c
#define B53SPI_BSPI_INTR_STATUS			0x010
#define B53SPI_BSPI_B0_STATUS			0x014
#define B53SPI_BSPI_B0_CTRL			0x018
#define B53SPI_BSPI_B1_STATUS			0x01c
#define B53SPI_BSPI_B1_CTRL			0x020
#define B53SPI_BSPI_STRAP_OVERRIDE_CTRL		0x024
#define B53SPI_BSPI_FLEX_MODE_ENABLE		0x028
#define B53SPI_BSPI_BITS_PER_CYCLE		0x02c
#define B53SPI_BSPI_BITS_PER_PHASE		0x030
#define B53SPI_BSPI_CMD_AND_MODE_BYTE		0x034
#define B53SPI_BSPI_BSPI_FLASH_UPPER_ADDR_BYTE	0x038
#define B53SPI_BSPI_BSPI_XOR_VALUE		0x03c
#define B53SPI_BSPI_BSPI_XOR_ENABLE		0x040
#define B53SPI_BSPI_BSPI_PIO_MODE_ENABLE	0x044
#define B53SPI_BSPI_BSPI_PIO_IODIR		0x048
#define B53SPI_BSPI_BSPI_PIO_DATA		0x04c

/* RAF */
#define B53SPI_RAF_START_ADDR			0x100
#define B53SPI_RAF_NUM_WORDS			0x104
#define B53SPI_RAF_CTRL				0x108
#define B53SPI_RAF_FULLNESS			0x10c
#define B53SPI_RAF_WATERMARK			0x110
#define B53SPI_RAF_STATUS			0x114
#define B53SPI_RAF_READ_DATA			0x118
#define B53SPI_RAF_WORD_CNT			0x11c
#define B53SPI_RAF_CURR_ADDR			0x120

/* MSPI */
#define B53SPI_MSPI_SPCR0_LSB			0x200
#define B53SPI_MSPI_SPCR0_MSB			0x204
#define B53SPI_MSPI_SPCR1_LSB			0x208
#define B53SPI_MSPI_SPCR1_MSB			0x20c
#define B53SPI_MSPI_NEWQP			0x210
#define B53SPI_MSPI_ENDQP			0x214
#define B53SPI_MSPI_SPCR2			0x218
#define  B53SPI_MSPI_SPCR2_SPE			0x00000040
#define  B53SPI_MSPI_SPCR2_CONT_AFTER_CMD	0x00000080
#define B53SPI_MSPI_MSPI_STATUS			0x220
#define  B53SPI_MSPI_MSPI_STATUS_SPIF		0x00000001
#define B53SPI_MSPI_CPTQP			0x224
#define B53SPI_MSPI_TXRAM			0x240 /* 32 registers, up to 0x2b8 */
#define B53SPI_MSPI_RXRAM			0x2c0 /* 32 registers, up to 0x33c */
#define B53SPI_MSPI_CDRAM			0x340 /* 16 registers, up to 0x37c */
#define  B53SPI_CDRAM_PCS_PCS0			0x00000001
#define  B53SPI_CDRAM_PCS_PCS1			0x00000002
#define  B53SPI_CDRAM_PCS_PCS2			0x00000004
#define  B53SPI_CDRAM_PCS_PCS3			0x00000008
#define  B53SPI_CDRAM_PCS_DISABLE_ALL		0x0000000f
#define  B53SPI_CDRAM_PCS_DSCK			0x00000010
#define  B53SPI_CDRAM_BITSE			0x00000040
#define  B53SPI_CDRAM_CONT			0x00000080
#define B53SPI_MSPI_WRITE_LOCK			0x380
#define B53SPI_MSPI_DISABLE_FLUSH_GEN		0x384

/* Interrupt */
#define B53SPI_INTR_RAF_LR_FULLNESS_REACHED	0x3a0
#define B53SPI_INTR_RAF_LR_TRUNCATED		0x3a4
#define B53SPI_INTR_RAF_LR_IMPATIENT		0x3a8
#define B53SPI_INTR_RAF_LR_SESSION_DONE		0x3ac
#define B53SPI_INTR_RAF_LR_OVERREAD		0x3b0
#define B53SPI_INTR_MSPI_DONE			0x3b4
#define B53SPI_INTR_MSPI_HALT_SET_TRANSACTION_DONE	0x3b8

#endif /* SPI_BCM53XX_H */
