/*
 * SH7724 Pinmux
 *
 * Copyright (C) 2009 Renesas Solutions Corp.
 *
 * Kuninori Morimoto <morimoto.kuninori@renesas.com>
 *
 * Based on SH7723 Pinmux
 *  Copyright (C) 2008  Magnus Damm
 *
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 */

#include <linux/init.h>
#include <linux/kernel.h>
#include <cpu/sh7724.h>

#include "sh_pfc.h"

enum {
	PINMUX_RESERVED = 0,

	PINMUX_DATA_BEGIN,
	PTA7_DATA, PTA6_DATA, PTA5_DATA, PTA4_DATA,
	PTA3_DATA, PTA2_DATA, PTA1_DATA, PTA0_DATA,
	PTB7_DATA, PTB6_DATA, PTB5_DATA, PTB4_DATA,
	PTB3_DATA, PTB2_DATA, PTB1_DATA, PTB0_DATA,
	PTC7_DATA, PTC6_DATA, PTC5_DATA, PTC4_DATA,
	PTC3_DATA, PTC2_DATA, PTC1_DATA, PTC0_DATA,
	PTD7_DATA, PTD6_DATA, PTD5_DATA, PTD4_DATA,
	PTD3_DATA, PTD2_DATA, PTD1_DATA, PTD0_DATA,
	PTE7_DATA, PTE6_DATA, PTE5_DATA, PTE4_DATA,
	PTE3_DATA, PTE2_DATA, PTE1_DATA, PTE0_DATA,
	PTF7_DATA, PTF6_DATA, PTF5_DATA, PTF4_DATA,
	PTF3_DATA, PTF2_DATA, PTF1_DATA, PTF0_DATA,
			      PTG5_DATA, PTG4_DATA,
	PTG3_DATA, PTG2_DATA, PTG1_DATA, PTG0_DATA,
	PTH7_DATA, PTH6_DATA, PTH5_DATA, PTH4_DATA,
	PTH3_DATA, PTH2_DATA, PTH1_DATA, PTH0_DATA,
	PTJ7_DATA, PTJ6_DATA, PTJ5_DATA,
	PTJ3_DATA, PTJ2_DATA, PTJ1_DATA, PTJ0_DATA,
	PTK7_DATA, PTK6_DATA, PTK5_DATA, PTK4_DATA,
	PTK3_DATA, PTK2_DATA, PTK1_DATA, PTK0_DATA,
	PTL7_DATA, PTL6_DATA, PTL5_DATA, PTL4_DATA,
	PTL3_DATA, PTL2_DATA, PTL1_DATA, PTL0_DATA,
	PTM7_DATA, PTM6_DATA, PTM5_DATA, PTM4_DATA,
	PTM3_DATA, PTM2_DATA, PTM1_DATA, PTM0_DATA,
	PTN7_DATA, PTN6_DATA, PTN5_DATA, PTN4_DATA,
	PTN3_DATA, PTN2_DATA, PTN1_DATA, PTN0_DATA,
	PTQ7_DATA, PTQ6_DATA, PTQ5_DATA, PTQ4_DATA,
	PTQ3_DATA, PTQ2_DATA, PTQ1_DATA, PTQ0_DATA,
	PTR7_DATA, PTR6_DATA, PTR5_DATA, PTR4_DATA,
	PTR3_DATA, PTR2_DATA, PTR1_DATA, PTR0_DATA,
		   PTS6_DATA, PTS5_DATA, PTS4_DATA,
	PTS3_DATA, PTS2_DATA, PTS1_DATA, PTS0_DATA,
	PTT7_DATA, PTT6_DATA, PTT5_DATA, PTT4_DATA,
	PTT3_DATA, PTT2_DATA, PTT1_DATA, PTT0_DATA,
	PTU7_DATA, PTU6_DATA, PTU5_DATA, PTU4_DATA,
	PTU3_DATA, PTU2_DATA, PTU1_DATA, PTU0_DATA,
	PTV7_DATA, PTV6_DATA, PTV5_DATA, PTV4_DATA,
	PTV3_DATA, PTV2_DATA, PTV1_DATA, PTV0_DATA,
	PTW7_DATA, PTW6_DATA, PTW5_DATA, PTW4_DATA,
	PTW3_DATA, PTW2_DATA, PTW1_DATA, PTW0_DATA,
	PTX7_DATA, PTX6_DATA, PTX5_DATA, PTX4_DATA,
	PTX3_DATA, PTX2_DATA, PTX1_DATA, PTX0_DATA,
	PTY7_DATA, PTY6_DATA, PTY5_DATA, PTY4_DATA,
	PTY3_DATA, PTY2_DATA, PTY1_DATA, PTY0_DATA,
	PTZ7_DATA, PTZ6_DATA, PTZ5_DATA, PTZ4_DATA,
	PTZ3_DATA, PTZ2_DATA, PTZ1_DATA, PTZ0_DATA,
	PINMUX_DATA_END,

	PINMUX_INPUT_BEGIN,
	PTA7_IN, PTA6_IN, PTA5_IN, PTA4_IN,
	PTA3_IN, PTA2_IN, PTA1_IN, PTA0_IN,
	PTB7_IN, PTB6_IN, PTB5_IN, PTB4_IN,
	PTB3_IN, PTB2_IN, PTB1_IN, PTB0_IN,
	PTC7_IN, PTC6_IN, PTC5_IN, PTC4_IN,
	PTC3_IN, PTC2_IN, PTC1_IN, PTC0_IN,
	PTD7_IN, PTD6_IN, PTD5_IN, PTD4_IN,
	PTD3_IN, PTD2_IN, PTD1_IN, PTD0_IN,
	PTE7_IN, PTE6_IN, PTE5_IN, PTE4_IN,
	PTE3_IN, PTE2_IN, PTE1_IN, PTE0_IN,
	PTF7_IN, PTF6_IN, PTF5_IN, PTF4_IN,
	PTF3_IN, PTF2_IN, PTF1_IN, PTF0_IN,
	PTH7_IN, PTH6_IN, PTH5_IN, PTH4_IN,
	PTH3_IN, PTH2_IN, PTH1_IN, PTH0_IN,
	PTJ3_IN, PTJ2_IN, PTJ1_IN, PTJ0_IN,
	PTK7_IN, PTK6_IN, PTK5_IN, PTK4_IN,
	PTK3_IN, PTK2_IN, PTK1_IN, PTK0_IN,
	PTL7_IN, PTL6_IN, PTL5_IN, PTL4_IN,
	PTL3_IN, PTL2_IN, PTL1_IN, PTL0_IN,
	PTM7_IN, PTM6_IN, PTM5_IN, PTM4_IN,
	PTM3_IN, PTM2_IN, PTM1_IN, PTM0_IN,
	PTN7_IN, PTN6_IN, PTN5_IN, PTN4_IN,
	PTN3_IN, PTN2_IN, PTN1_IN, PTN0_IN,
	PTQ7_IN, PTQ6_IN, PTQ5_IN, PTQ4_IN,
	PTQ3_IN, PTQ2_IN, PTQ1_IN, PTQ0_IN,
	PTR7_IN, PTR6_IN, PTR5_IN, PTR4_IN,
	PTR3_IN, PTR2_IN, PTR1_IN, PTR0_IN,
		 PTS6_IN, PTS5_IN, PTS4_IN,
	PTS3_IN, PTS2_IN, PTS1_IN, PTS0_IN,
	PTT7_IN, PTT6_IN, PTT5_IN, PTT4_IN,
	PTT3_IN, PTT2_IN, PTT1_IN, PTT0_IN,
	PTU7_IN, PTU6_IN, PTU5_IN, PTU4_IN,
	PTU3_IN, PTU2_IN, PTU1_IN, PTU0_IN,
	PTV7_IN, PTV6_IN, PTV5_IN, PTV4_IN,
	PTV3_IN, PTV2_IN, PTV1_IN, PTV0_IN,
	PTW7_IN, PTW6_IN, PTW5_IN, PTW4_IN,
	PTW3_IN, PTW2_IN, PTW1_IN, PTW0_IN,
	PTX7_IN, PTX6_IN, PTX5_IN, PTX4_IN,
	PTX3_IN, PTX2_IN, PTX1_IN, PTX0_IN,
	PTY7_IN, PTY6_IN, PTY5_IN, PTY4_IN,
	PTY3_IN, PTY2_IN, PTY1_IN, PTY0_IN,
	PTZ7_IN, PTZ6_IN, PTZ5_IN, PTZ4_IN,
	PTZ3_IN, PTZ2_IN, PTZ1_IN, PTZ0_IN,
	PINMUX_INPUT_END,

	PINMUX_OUTPUT_BEGIN,
	PTA7_OUT, PTA6_OUT, PTA5_OUT, PTA4_OUT,
	PTA3_OUT, PTA2_OUT, PTA1_OUT, PTA0_OUT,
	PTB7_OUT, PTB6_OUT, PTB5_OUT, PTB4_OUT,
	PTB3_OUT, PTB2_OUT, PTB1_OUT, PTB0_OUT,
	PTC7_OUT, PTC6_OUT, PTC5_OUT, PTC4_OUT,
	PTC3_OUT, PTC2_OUT, PTC1_OUT, PTC0_OUT,
	PTD7_OUT, PTD6_OUT, PTD5_OUT, PTD4_OUT,
	PTD3_OUT, PTD2_OUT, PTD1_OUT, PTD0_OUT,
	PTE7_OUT, PTE6_OUT, PTE5_OUT, PTE4_OUT,
	PTE3_OUT, PTE2_OUT, PTE1_OUT, PTE0_OUT,
	PTF7_OUT, PTF6_OUT, PTF5_OUT, PTF4_OUT,
	PTF3_OUT, PTF2_OUT, PTF1_OUT, PTF0_OUT,
			    PTG5_OUT, PTG4_OUT,
	PTG3_OUT, PTG2_OUT, PTG1_OUT, PTG0_OUT,
	PTH7_OUT, PTH6_OUT, PTH5_OUT, PTH4_OUT,
	PTH3_OUT, PTH2_OUT, PTH1_OUT, PTH0_OUT,
	PTJ7_OUT, PTJ6_OUT, PTJ5_OUT,
	PTJ3_OUT, PTJ2_OUT, PTJ1_OUT, PTJ0_OUT,
	PTK7_OUT, PTK6_OUT, PTK5_OUT, PTK4_OUT,
	PTK3_OUT, PTK2_OUT, PTK1_OUT, PTK0_OUT,
	PTL7_OUT, PTL6_OUT, PTL5_OUT, PTL4_OUT,
	PTL3_OUT, PTL2_OUT, PTL1_OUT, PTL0_OUT,
	PTM7_OUT, PTM6_OUT, PTM5_OUT, PTM4_OUT,
	PTM3_OUT, PTM2_OUT, PTM1_OUT, PTM0_OUT,
	PTN7_OUT, PTN6_OUT, PTN5_OUT, PTN4_OUT,
	PTN3_OUT, PTN2_OUT, PTN1_OUT, PTN0_OUT,
	PTQ7_OUT, PTQ6_OUT, PTQ5_OUT, PTQ4_OUT,
	PTQ3_OUT, PTQ2_OUT, PTQ1_OUT, PTQ0_OUT,
	PTR7_OUT, PTR6_OUT, PTR5_OUT, PTR4_OUT,
			    PTR1_OUT, PTR0_OUT,
		  PTS6_OUT, PTS5_OUT, PTS4_OUT,
	PTS3_OUT, PTS2_OUT, PTS1_OUT, PTS0_OUT,
	PTT7_OUT, PTT6_OUT, PTT5_OUT, PTT4_OUT,
	PTT3_OUT, PTT2_OUT, PTT1_OUT, PTT0_OUT,
	PTU7_OUT, PTU6_OUT, PTU5_OUT, PTU4_OUT,
	PTU3_OUT, PTU2_OUT, PTU1_OUT, PTU0_OUT,
	PTV7_OUT, PTV6_OUT, PTV5_OUT, PTV4_OUT,
	PTV3_OUT, PTV2_OUT, PTV1_OUT, PTV0_OUT,
	PTW7_OUT, PTW6_OUT, PTW5_OUT, PTW4_OUT,
	PTW3_OUT, PTW2_OUT, PTW1_OUT, PTW0_OUT,
	PTX7_OUT, PTX6_OUT, PTX5_OUT, PTX4_OUT,
	PTX3_OUT, PTX2_OUT, PTX1_OUT, PTX0_OUT,
	PTY7_OUT, PTY6_OUT, PTY5_OUT, PTY4_OUT,
	PTY3_OUT, PTY2_OUT, PTY1_OUT, PTY0_OUT,
	PTZ7_OUT, PTZ6_OUT, PTZ5_OUT, PTZ4_OUT,
	PTZ3_OUT, PTZ2_OUT, PTZ1_OUT, PTZ0_OUT,
	PINMUX_OUTPUT_END,

	PINMUX_FUNCTION_BEGIN,
	PTA7_FN, PTA6_FN, PTA5_FN, PTA4_FN,
	PTA3_FN, PTA2_FN, PTA1_FN, PTA0_FN,
	PTB7_FN, PTB6_FN, PTB5_FN, PTB4_FN,
	PTB3_FN, PTB2_FN, PTB1_FN, PTB0_FN,
	PTC7_FN, PTC6_FN, PTC5_FN, PTC4_FN,
	PTC3_FN, PTC2_FN, PTC1_FN, PTC0_FN,
	PTD7_FN, PTD6_FN, PTD5_FN, PTD4_FN,
	PTD3_FN, PTD2_FN, PTD1_FN, PTD0_FN,
	PTE7_FN, PTE6_FN, PTE5_FN, PTE4_FN,
	PTE3_FN, PTE2_FN, PTE1_FN, PTE0_FN,
	PTF7_FN, PTF6_FN, PTF5_FN, PTF4_FN,
	PTF3_FN, PTF2_FN, PTF1_FN, PTF0_FN,
			  PTG5_FN, PTG4_FN,
	PTG3_FN, PTG2_FN, PTG1_FN, PTG0_FN,
	PTH7_FN, PTH6_FN, PTH5_FN, PTH4_FN,
	PTH3_FN, PTH2_FN, PTH1_FN, PTH0_FN,
	PTJ7_FN, PTJ6_FN, PTJ5_FN,
	PTJ3_FN, PTJ2_FN, PTJ1_FN, PTJ0_FN,
	PTK7_FN, PTK6_FN, PTK5_FN, PTK4_FN,
	PTK3_FN, PTK2_FN, PTK1_FN, PTK0_FN,
	PTL7_FN, PTL6_FN, PTL5_FN, PTL4_FN,
	PTL3_FN, PTL2_FN, PTL1_FN, PTL0_FN,
	PTM7_FN, PTM6_FN, PTM5_FN, PTM4_FN,
	PTM3_FN, PTM2_FN, PTM1_FN, PTM0_FN,
	PTN7_FN, PTN6_FN, PTN5_FN, PTN4_FN,
	PTN3_FN, PTN2_FN, PTN1_FN, PTN0_FN,
	PTQ7_FN, PTQ6_FN, PTQ5_FN, PTQ4_FN,
	PTQ3_FN, PTQ2_FN, PTQ1_FN, PTQ0_FN,
	PTR7_FN, PTR6_FN, PTR5_FN, PTR4_FN,
	PTR3_FN, PTR2_FN, PTR1_FN, PTR0_FN,
		 PTS6_FN, PTS5_FN, PTS4_FN,
	PTS3_FN, PTS2_FN, PTS1_FN, PTS0_FN,
	PTT7_FN, PTT6_FN, PTT5_FN, PTT4_FN,
	PTT3_FN, PTT2_FN, PTT1_FN, PTT0_FN,
	PTU7_FN, PTU6_FN, PTU5_FN, PTU4_FN,
	PTU3_FN, PTU2_FN, PTU1_FN, PTU0_FN,
	PTV7_FN, PTV6_FN, PTV5_FN, PTV4_FN,
	PTV3_FN, PTV2_FN, PTV1_FN, PTV0_FN,
	PTW7_FN, PTW6_FN, PTW5_FN, PTW4_FN,
	PTW3_FN, PTW2_FN, PTW1_FN, PTW0_FN,
	PTX7_FN, PTX6_FN, PTX5_FN, PTX4_FN,
	PTX3_FN, PTX2_FN, PTX1_FN, PTX0_FN,
	PTY7_FN, PTY6_FN, PTY5_FN, PTY4_FN,
	PTY3_FN, PTY2_FN, PTY1_FN, PTY0_FN,
	PTZ7_FN, PTZ6_FN, PTZ5_FN, PTZ4_FN,
	PTZ3_FN, PTZ2_FN, PTZ1_FN, PTZ0_FN,


	PSA15_0, PSA15_1,
	PSA14_0, PSA14_1,
	PSA13_0, PSA13_1,
	PSA12_0, PSA12_1,
	PSA10_0, PSA10_1,
	PSA9_0,  PSA9_1,
	PSA8_0,  PSA8_1,
	PSA7_0,  PSA7_1,
	PSA6_0,  PSA6_1,
	PSA5_0,  PSA5_1,
	PSA3_0,  PSA3_1,
	PSA2_0,  PSA2_1,
	PSA1_0,  PSA1_1,
	PSA0_0,  PSA0_1,

	PSB14_0, PSB14_1,
	PSB13_0, PSB13_1,
	PSB12_0, PSB12_1,
	PSB11_0, PSB11_1,
	PSB10_0, PSB10_1,
	PSB9_0,  PSB9_1,
	PSB8_0,  PSB8_1,
	PSB7_0,  PSB7_1,
	PSB6_0,  PSB6_1,
	PSB5_0,  PSB5_1,
	PSB4_0,  PSB4_1,
	PSB3_0,  PSB3_1,
	PSB2_0,  PSB2_1,
	PSB1_0,  PSB1_1,
	PSB0_0,  PSB0_1,

	PSC15_0, PSC15_1,
	PSC14_0, PSC14_1,
	PSC13_0, PSC13_1,
	PSC12_0, PSC12_1,
	PSC11_0, PSC11_1,
	PSC10_0, PSC10_1,
	PSC9_0,  PSC9_1,
	PSC8_0,  PSC8_1,
	PSC7_0,  PSC7_1,
	PSC6_0,  PSC6_1,
	PSC5_0,  PSC5_1,
	PSC4_0,  PSC4_1,
	PSC2_0,  PSC2_1,
	PSC1_0,  PSC1_1,
	PSC0_0,  PSC0_1,

	PSD15_0, PSD15_1,
	PSD14_0, PSD14_1,
	PSD13_0, PSD13_1,
	PSD12_0, PSD12_1,
	PSD11_0, PSD11_1,
	PSD10_0, PSD10_1,
	PSD9_0,  PSD9_1,
	PSD8_0,  PSD8_1,
	PSD7_0,  PSD7_1,
	PSD6_0,  PSD6_1,
	PSD5_0,  PSD5_1,
	PSD4_0,  PSD4_1,
	PSD3_0,  PSD3_1,
	PSD2_0,  PSD2_1,
	PSD1_0,  PSD1_1,
	PSD0_0,  PSD0_1,

	PSE15_0, PSE15_1,
	PSE14_0, PSE14_1,
	PSE13_0, PSE13_1,
	PSE12_0, PSE12_1,
	PSE11_0, PSE11_1,
	PSE10_0, PSE10_1,
	PSE9_0,  PSE9_1,
	PSE8_0,  PSE8_1,
	PSE7_0,  PSE7_1,
	PSE6_0,  PSE6_1,
	PSE5_0,  PSE5_1,
	PSE4_0,  PSE4_1,
	PSE3_0,  PSE3_1,
	PSE2_0,  PSE2_1,
	PSE1_0,  PSE1_1,
	PSE0_0,  PSE0_1,
	PINMUX_FUNCTION_END,

	PINMUX_MARK_BEGIN,
	/*PTA*/
	D23_MARK,	KEYOUT2_MARK,		IDED15_MARK,
	D22_MARK,	KEYOUT1_MARK,		IDED14_MARK,
	D21_MARK,	KEYOUT0_MARK,		IDED13_MARK,
	D20_MARK,	KEYIN4_MARK,		IDED12_MARK,
	D19_MARK,	KEYIN3_MARK,		IDED11_MARK,
	D18_MARK,	KEYIN2_MARK,		IDED10_MARK,
	D17_MARK,	KEYIN1_MARK,		IDED9_MARK,
	D16_MARK,	KEYIN0_MARK,		IDED8_MARK,

	/*PTB*/
	D31_MARK,	TPUTO1_MARK,		IDEA1_MARK,
	D30_MARK,	TPUTO0_MARK,		IDEA0_MARK,
	D29_MARK,				IODREQ_MARK,
	D28_MARK,				IDECS0_MARK,
	D27_MARK,				IDECS1_MARK,
	D26_MARK,	KEYOUT5_IN5_MARK,	IDEIORD_MARK,
	D25_MARK,	KEYOUT4_IN6_MARK,	IDEIOWR_MARK,
	D24_MARK,	KEYOUT3_MARK,		IDEINT_MARK,

	/*PTC*/
	LCDD7_MARK,
	LCDD6_MARK,
	LCDD5_MARK,
	LCDD4_MARK,
	LCDD3_MARK,
	LCDD2_MARK,
	LCDD1_MARK,
	LCDD0_MARK,

	/*PTD*/
	LCDD15_MARK,
	LCDD14_MARK,
	LCDD13_MARK,
	LCDD12_MARK,
	LCDD11_MARK,
	LCDD10_MARK,
	LCDD9_MARK,
	LCDD8_MARK,

	/*PTE*/
	FSIMCKB_MARK,
	FSIMCKA_MARK,
	LCDD21_MARK,	SCIF2_L_TXD_MARK,
	LCDD20_MARK,	SCIF4_SCK_MARK,
	LCDD19_MARK,	SCIF4_RXD_MARK,
	LCDD18_MARK,	SCIF4_TXD_MARK,
	LCDD17_MARK,
	LCDD16_MARK,

	/*PTF*/
	LCDVSYN_MARK,
	LCDDISP_MARK,	LCDRS_MARK,
	LCDHSYN_MARK,	LCDCS_MARK,
	LCDDON_MARK,
	LCDDCK_MARK,	LCDWR_MARK,
	LCDVEPWC_MARK,	SCIF0_TXD_MARK,
	LCDD23_MARK,	SCIF2_L_SCK_MARK,
	LCDD22_MARK,	SCIF2_L_RXD_MARK,

	/*PTG*/
	AUDCK_MARK,
	AUDSYNC_MARK,
	AUDATA3_MARK,
	AUDATA2_MARK,
	AUDATA1_MARK,
	AUDATA0_MARK,

	/*PTH*/
	VIO0_VD_MARK,
	VIO0_CLK_MARK,
	VIO0_D7_MARK,
	VIO0_D6_MARK,
	VIO0_D5_MARK,
	VIO0_D4_MARK,
	VIO0_D3_MARK,
	VIO0_D2_MARK,

	/*PTJ*/
	PDSTATUS_MARK,
	STATUS2_MARK,
	STATUS0_MARK,
	A25_MARK,		BS_MARK,
	A24_MARK,
	A23_MARK,
	A22_MARK,

	/*PTK*/
	VIO1_D5_MARK,	VIO0_D13_MARK,	IDED5_MARK,
	VIO1_D4_MARK,	VIO0_D12_MARK,	IDED4_MARK,
	VIO1_D3_MARK,	VIO0_D11_MARK,	IDED3_MARK,
	VIO1_D2_MARK,	VIO0_D10_MARK,	IDED2_MARK,
	VIO1_D1_MARK,	VIO0_D9_MARK,	IDED1_MARK,
	VIO1_D0_MARK,	VIO0_D8_MARK,	IDED0_MARK,
	VIO0_FLD_MARK,
	VIO0_HD_MARK,

	/*PTL*/
	DV_D5_MARK,	SCIF3_V_SCK_MARK,	RMII_RXD0_MARK,
	DV_D4_MARK,	SCIF3_V_RXD_MARK,	RMII_RXD1_MARK,
	DV_D3_MARK,	SCIF3_V_TXD_MARK,	RMII_REF_CLK_MARK,
	DV_D2_MARK,	SCIF1_SCK_MARK,		RMII_TX_EN_MARK,
	DV_D1_MARK,	SCIF1_RXD_MARK,		RMII_TXD0_MARK,
	DV_D0_MARK,	SCIF1_TXD_MARK,		RMII_TXD1_MARK,
	DV_D15_MARK,
	DV_D14_MARK,	MSIOF0_MCK_MARK,

	/*PTM*/
	DV_D13_MARK,	MSIOF0_TSCK_MARK,
	DV_D12_MARK,	MSIOF0_RXD_MARK,
	DV_D11_MARK,	MSIOF0_TXD_MARK,
	DV_D10_MARK,	MSIOF0_TSYNC_MARK,
	DV_D9_MARK,	MSIOF0_SS1_MARK,	MSIOF0_RSCK_MARK,
	DV_D8_MARK,	MSIOF0_SS2_MARK,	MSIOF0_RSYNC_MARK,
	LCDVCPWC_MARK,	SCIF0_RXD_MARK,
	LCDRD_MARK,	SCIF0_SCK_MARK,

	/*PTN*/
	VIO0_D1_MARK,
	VIO0_D0_MARK,
	DV_CLKI_MARK,
	DV_CLK_MARK,	SCIF2_V_SCK_MARK,
	DV_VSYNC_MARK,	SCIF2_V_RXD_MARK,
	DV_HSYNC_MARK,	SCIF2_V_TXD_MARK,
	DV_D7_MARK,	SCIF3_V_CTS_MARK,	RMII_RX_ER_MARK,
	DV_D6_MARK,	SCIF3_V_RTS_MARK,	RMII_CRS_DV_MARK,

	/*PTQ*/
	D7_MARK,
	D6_MARK,
	D5_MARK,
	D4_MARK,
	D3_MARK,
	D2_MARK,
	D1_MARK,
	D0_MARK,

	/*PTR*/
	CS6B_CE1B_MARK,
	CS6A_CE2B_MARK,
	CS5B_CE1A_MARK,
	CS5A_CE2A_MARK,
	IOIS16_MARK,		LCDLCLK_MARK,
	WAIT_MARK,
	WE3_ICIOWR_MARK,	TPUTO3_MARK,	TPUTI3_MARK,
	WE2_ICIORD_MARK,	TPUTO2_MARK,	IDEA2_MARK,

	/*PTS*/
	VIO_CKO_MARK,
	VIO1_FLD_MARK,	TPUTI2_MARK,		IDEIORDY_MARK,
	VIO1_HD_MARK,	SCIF5_SCK_MARK,
	VIO1_VD_MARK,	SCIF5_RXD_MARK,
	VIO1_CLK_MARK,	SCIF5_TXD_MARK,
	VIO1_D7_MARK,	VIO0_D15_MARK,		IDED7_MARK,
	VIO1_D6_MARK,	VIO0_D14_MARK,		IDED6_MARK,

	/*PTT*/
	D15_MARK,
	D14_MARK,
	D13_MARK,
	D12_MARK,
	D11_MARK,
	D10_MARK,
	D9_MARK,
	D8_MARK,

	/*PTU*/
	DMAC_DACK0_MARK,
	DMAC_DREQ0_MARK,
	FSIOASD_MARK,
	FSIIABCK_MARK,
	FSIIALRCK_MARK,
	FSIOABCK_MARK,
	FSIOALRCK_MARK,
	CLKAUDIOAO_MARK,

	/*PTV*/
	FSIIBSD_MARK,		MSIOF1_SS2_MARK,	MSIOF1_RSYNC_MARK,
	FSIOBSD_MARK,		MSIOF1_SS1_MARK,	MSIOF1_RSCK_MARK,
	FSIIBBCK_MARK,		MSIOF1_RXD_MARK,
	FSIIBLRCK_MARK,		MSIOF1_TSYNC_MARK,
	FSIOBBCK_MARK,		MSIOF1_TSCK_MARK,
	FSIOBLRCK_MARK,		MSIOF1_TXD_MARK,
	CLKAUDIOBO_MARK,	MSIOF1_MCK_MARK,
	FSIIASD_MARK,

	/*PTW*/
	MMC_D7_MARK,		SDHI1CD_MARK,		IODACK_MARK,
	MMC_D6_MARK,		SDHI1WP_MARK,		IDERST_MARK,
	MMC_D5_MARK,		SDHI1D3_MARK,		EXBUF_ENB_MARK,
	MMC_D4_MARK,		SDHI1D2_MARK,		DIRECTION_MARK,
	MMC_D3_MARK,		SDHI1D1_MARK,
	MMC_D2_MARK,		SDHI1D0_MARK,
	MMC_D1_MARK,		SDHI1CMD_MARK,
	MMC_D0_MARK,		SDHI1CLK_MARK,

	/*PTX*/
	DMAC_DACK1_MARK,	IRDA_OUT_MARK,
	DMAC_DREQ1_MARK,	IRDA_IN_MARK,
	TSIF_TS0_SDAT_MARK,				LNKSTA_MARK,
	TSIF_TS0_SCK_MARK,				MDIO_MARK,
	TSIF_TS0_SDEN_MARK,				MDC_MARK,
	TSIF_TS0_SPSYNC_MARK,
	MMC_CLK_MARK,
	MMC_CMD_MARK,

	/*PTY*/
	SDHI0CD_MARK,
	SDHI0WP_MARK,
	SDHI0D3_MARK,
	SDHI0D2_MARK,
	SDHI0D1_MARK,
	SDHI0D0_MARK,
	SDHI0CMD_MARK,
	SDHI0CLK_MARK,

	/*PTZ*/
	INTC_IRQ7_MARK,		SCIF3_I_CTS_MARK,
	INTC_IRQ6_MARK,		SCIF3_I_RTS_MARK,
	INTC_IRQ5_MARK,		SCIF3_I_SCK_MARK,
	INTC_IRQ4_MARK,		SCIF3_I_RXD_MARK,
	INTC_IRQ3_MARK,		SCIF3_I_TXD_MARK,
	INTC_IRQ2_MARK,
	INTC_IRQ1_MARK,
	INTC_IRQ0_MARK,
	PINMUX_MARK_END,
};

static const u16 pinmux_data[] = {
	/* PTA GPIO */
	PINMUX_DATA(PTA7_DATA, PTA7_IN, PTA7_OUT),
	PINMUX_DATA(PTA6_DATA, PTA6_IN, PTA6_OUT),
	PINMUX_DATA(PTA5_DATA, PTA5_IN, PTA5_OUT),
	PINMUX_DATA(PTA4_DATA, PTA4_IN, PTA4_OUT),
	PINMUX_DATA(PTA3_DATA, PTA3_IN, PTA3_OUT),
	PINMUX_DATA(PTA2_DATA, PTA2_IN, PTA2_OUT),
	PINMUX_DATA(PTA1_DATA, PTA1_IN, PTA1_OUT),
	PINMUX_DATA(PTA0_DATA, PTA0_IN, PTA0_OUT),

	/* PTB GPIO */
	PINMUX_DATA(PTB7_DATA, PTB7_IN, PTB7_OUT),
	PINMUX_DATA(PTB6_DATA, PTB6_IN, PTB6_OUT),
	PINMUX_DATA(PTB5_DATA, PTB5_IN, PTB5_OUT),
	PINMUX_DATA(PTB4_DATA, PTB4_IN, PTB4_OUT),
	PINMUX_DATA(PTB3_DATA, PTB3_IN, PTB3_OUT),
	PINMUX_DATA(PTB2_DATA, PTB2_IN, PTB2_OUT),
	PINMUX_DATA(PTB1_DATA, PTB1_IN, PTB1_OUT),
	PINMUX_DATA(PTB0_DATA, PTB0_IN, PTB0_OUT),

	/* PTC GPIO */
	PINMUX_DATA(PTC7_DATA, PTC7_IN, PTC7_OUT),
	PINMUX_DATA(PTC6_DATA, PTC6_IN, PTC6_OUT),
	PINMUX_DATA(PTC5_DATA, PTC5_IN, PTC5_OUT),
	PINMUX_DATA(PTC4_DATA, PTC4_IN, PTC4_OUT),
	PINMUX_DATA(PTC3_DATA, PTC3_IN, PTC3_OUT),
	PINMUX_DATA(PTC2_DATA, PTC2_IN, PTC2_OUT),
	PINMUX_DATA(PTC1_DATA, PTC1_IN, PTC1_OUT),
	PINMUX_DATA(PTC0_DATA, PTC0_IN, PTC0_OUT),

	/* PTD GPIO */
	PINMUX_DATA(PTD7_DATA, PTD7_IN, PTD7_OUT),
	PINMUX_DATA(PTD6_DATA, PTD6_IN, PTD6_OUT),
	PINMUX_DATA(PTD5_DATA, PTD5_IN, PTD5_OUT),
	PINMUX_DATA(PTD4_DATA, PTD4_IN, PTD4_OUT),
	PINMUX_DATA(PTD3_DATA, PTD3_IN, PTD3_OUT),
	PINMUX_DATA(PTD2_DATA, PTD2_IN, PTD2_OUT),
	PINMUX_DATA(PTD1_DATA, PTD1_IN, PTD1_OUT),
	PINMUX_DATA(PTD0_DATA, PTD0_IN, PTD0_OUT),

	/* PTE GPIO */
	PINMUX_DATA(PTE7_DATA, PTE7_IN, PTE7_OUT),
	PINMUX_DATA(PTE6_DATA, PTE6_IN, PTE6_OUT),
	PINMUX_DATA(PTE5_DATA, PTE5_IN, PTE5_OUT),
	PINMUX_DATA(PTE4_DATA, PTE4_IN, PTE4_OUT),
	PINMUX_DATA(PTE3_DATA, PTE3_IN, PTE3_OUT),
	PINMUX_DATA(PTE2_DATA, PTE2_IN, PTE2_OUT),
	PINMUX_DATA(PTE1_DATA, PTE1_IN, PTE1_OUT),
	PINMUX_DATA(PTE0_DATA, PTE0_IN, PTE0_OUT),

	/* PTF GPIO */
	PINMUX_DATA(PTF7_DATA, PTF7_IN, PTF7_OUT),
	PINMUX_DATA(PTF6_DATA, PTF6_IN, PTF6_OUT),
	PINMUX_DATA(PTF5_DATA, PTF5_IN, PTF5_OUT),
	PINMUX_DATA(PTF4_DATA, PTF4_IN, PTF4_OUT),
	PINMUX_DATA(PTF3_DATA, PTF3_IN, PTF3_OUT),
	PINMUX_DATA(PTF2_DATA, PTF2_IN, PTF2_OUT),
	PINMUX_DATA(PTF1_DATA, PTF1_IN, PTF1_OUT),
	PINMUX_DATA(PTF0_DATA, PTF0_IN, PTF0_OUT),

	/* PTG GPIO */
	PINMUX_DATA(PTG5_DATA, PTG5_OUT),
	PINMUX_DATA(PTG4_DATA, PTG4_OUT),
	PINMUX_DATA(PTG3_DATA, PTG3_OUT),
	PINMUX_DATA(PTG2_DATA, PTG2_OUT),
	PINMUX_DATA(PTG1_DATA, PTG1_OUT),
	PINMUX_DATA(PTG0_DATA, PTG0_OUT),

	/* PTH GPIO */
	PINMUX_DATA(PTH7_DATA, PTH7_IN, PTH7_OUT),
	PINMUX_DATA(PTH6_DATA, PTH6_IN, PTH6_OUT),
	PINMUX_DATA(PTH5_DATA, PTH5_IN, PTH5_OUT),
	PINMUX_DATA(PTH4_DATA, PTH4_IN, PTH4_OUT),
	PINMUX_DATA(PTH3_DATA, PTH3_IN, PTH3_OUT),
	PINMUX_DATA(PTH2_DATA, PTH2_IN, PTH2_OUT),
	PINMUX_DATA(PTH1_DATA, PTH1_IN, PTH1_OUT),
	PINMUX_DATA(PTH0_DATA, PTH0_IN, PTH0_OUT),

	/* PTJ GPIO */
	PINMUX_DATA(PTJ7_DATA, PTJ7_OUT),
	PINMUX_DATA(PTJ6_DATA, PTJ6_OUT),
	PINMUX_DATA(PTJ5_DATA, PTJ5_OUT),
	PINMUX_DATA(PTJ3_DATA, PTJ3_IN, PTJ3_OUT),
	PINMUX_DATA(PTJ2_DATA, PTJ2_IN, PTJ2_OUT),
	PINMUX_DATA(PTJ1_DATA, PTJ1_IN, PTJ1_OUT),
	PINMUX_DATA(PTJ0_DATA, PTJ0_IN, PTJ0_OUT),

	/* PTK GPIO */
	PINMUX_DATA(PTK7_DATA, PTK7_IN, PTK7_OUT),
	PINMUX_DATA(PTK6_DATA, PTK6_IN, PTK6_OUT),
	PINMUX_DATA(PTK5_DATA, PTK5_IN, PTK5_OUT),
	PINMUX_DATA(PTK4_DATA, PTK4_IN, PTK4_OUT),
	PINMUX_DATA(PTK3_DATA, PTK3_IN, PTK3_OUT),
	PINMUX_DATA(PTK2_DATA, PTK2_IN, PTK2_OUT),
	PINMUX_DATA(PTK1_DATA, PTK1_IN, PTK1_OUT),
	PINMUX_DATA(PTK0_DATA, PTK0_IN, PTK0_OUT),

	/* PTL GPIO */
	PINMUX_DATA(PTL7_DATA, PTL7_IN, PTL7_OUT),
	PINMUX_DATA(PTL6_DATA, PTL6_IN, PTL6_OUT),
	PINMUX_DATA(PTL5_DATA, PTL5_IN, PTL5_OUT),
	PINMUX_DATA(PTL4_DATA, PTL4_IN, PTL4_OUT),
	PINMUX_DATA(PTL3_DATA, PTL3_IN, PTL3_OUT),
	PINMUX_DATA(PTL2_DATA, PTL2_IN, PTL2_OUT),
	PINMUX_DATA(PTL1_DATA, PTL1_IN, PTL1_OUT),
	PINMUX_DATA(PTL0_DATA, PTL0_IN, PTL0_OUT),

	/* PTM GPIO */
	PINMUX_DATA(PTM7_DATA, PTM7_IN, PTM7_OUT),
	PINMUX_DATA(PTM6_DATA, PTM6_IN, PTM6_OUT),
	PINMUX_DATA(PTM5_DATA, PTM5_IN, PTM5_OUT),
	PINMUX_DATA(PTM4_DATA, PTM4_IN, PTM4_OUT),
	PINMUX_DATA(PTM3_DATA, PTM3_IN, PTM3_OUT),
	PINMUX_DATA(PTM2_DATA, PTM2_IN, PTM2_OUT),
	PINMUX_DATA(PTM1_DATA, PTM1_IN, PTM1_OUT),
	PINMUX_DATA(PTM0_DATA, PTM0_IN, PTM0_OUT),

	/* PTN GPIO */
	PINMUX_DATA(PTN7_DATA, PTN7_IN, PTN7_OUT),
	PINMUX_DATA(PTN6_DATA, PTN6_IN, PTN6_OUT),
	PINMUX_DATA(PTN5_DATA, PTN5_IN, PTN5_OUT),
	PINMUX_DATA(PTN4_DATA, PTN4_IN, PTN4_OUT),
	PINMUX_DATA(PTN3_DATA, PTN3_IN, PTN3_OUT),
	PINMUX_DATA(PTN2_DATA, PTN2_IN, PTN2_OUT),
	PINMUX_DATA(PTN1_DATA, PTN1_IN, PTN1_OUT),
	PINMUX_DATA(PTN0_DATA, PTN0_IN, PTN0_OUT),

	/* PTQ GPIO */
	PINMUX_DATA(PTQ7_DATA, PTQ7_IN, PTQ7_OUT),
	PINMUX_DATA(PTQ6_DATA, PTQ6_IN, PTQ6_OUT),
	PINMUX_DATA(PTQ5_DATA, PTQ5_IN, PTQ5_OUT),
	PINMUX_DATA(PTQ4_DATA, PTQ4_IN, PTQ4_OUT),
	PINMUX_DATA(PTQ3_DATA, PTQ3_IN, PTQ3_OUT),
	PINMUX_DATA(PTQ2_DATA, PTQ2_IN, PTQ2_OUT),
	PINMUX_DATA(PTQ1_DATA, PTQ1_IN, PTQ1_OUT),
	PINMUX_DATA(PTQ0_DATA, PTQ0_IN, PTQ0_OUT),

	/* PTR GPIO */
	PINMUX_DATA(PTR7_DATA, PTR7_IN, PTR7_OUT),
	PINMUX_DATA(PTR6_DATA, PTR6_IN, PTR6_OUT),
	PINMUX_DATA(PTR5_DATA, PTR5_IN, PTR5_OUT),
	PINMUX_DATA(PTR4_DATA, PTR4_IN, PTR4_OUT),
	PINMUX_DATA(PTR3_DATA, PTR3_IN),
	PINMUX_DATA(PTR2_DATA, PTR2_IN),
	PINMUX_DATA(PTR1_DATA, PTR1_IN, PTR1_OUT),
	PINMUX_DATA(PTR0_DATA, PTR0_IN, PTR0_OUT),

	/* PTS GPIO */
	PINMUX_DATA(PTS6_DATA, PTS6_IN, PTS6_OUT),
	PINMUX_DATA(PTS5_DATA, PTS5_IN, PTS5_OUT),
	PINMUX_DATA(PTS4_DATA, PTS4_IN, PTS4_OUT),
	PINMUX_DATA(PTS3_DATA, PTS3_IN, PTS3_OUT),
	PINMUX_DATA(PTS2_DATA, PTS2_IN, PTS2_OUT),
	PINMUX_DATA(PTS1_DATA, PTS1_IN, PTS1_OUT),
	PINMUX_DATA(PTS0_DATA, PTS0_IN, PTS0_OUT),

	/* PTT GPIO */
	PINMUX_DATA(PTT7_DATA, PTT7_IN, PTT7_OUT),
	PINMUX_DATA(PTT6_DATA, PTT6_IN, PTT6_OUT),
	PINMUX_DATA(PTT5_DATA, PTT5_IN, PTT5_OUT),
	PINMUX_DATA(PTT4_DATA, PTT4_IN, PTT4_OUT),
	PINMUX_DATA(PTT3_DATA, PTT3_IN, PTT3_OUT),
	PINMUX_DATA(PTT2_DATA, PTT2_IN, PTT2_OUT),
	PINMUX_DATA(PTT1_DATA, PTT1_IN, PTT1_OUT),
	PINMUX_DATA(PTT0_DATA, PTT0_IN, PTT0_OUT),

	/* PTU GPIO */
	PINMUX_DATA(PTU7_DATA, PTU7_IN, PTU7_OUT),
	PINMUX_DATA(PTU6_DATA, PTU6_IN, PTU6_OUT),
	PINMUX_DATA(PTU5_DATA, PTU5_IN, PTU5_OUT),
	PINMUX_DATA(PTU4_DATA, PTU4_IN, PTU4_OUT),
	PINMUX_DATA(PTU3_DATA, PTU3_IN, PTU3_OUT),
	PINMUX_DATA(PTU2_DATA, PTU2_IN, PTU2_OUT),
	PINMUX_DATA(PTU1_DATA, PTU1_IN, PTU1_OUT),
	PINMUX_DATA(PTU0_DATA, PTU0_IN, PTU0_OUT),

	/* PTV GPIO */
	PINMUX_DATA(PTV7_DATA, PTV7_IN, PTV7_OUT),
	PINMUX_DATA(PTV6_DATA, PTV6_IN, PTV6_OUT),
	PINMUX_DATA(PTV5_DATA, PTV5_IN, PTV5_OUT),
	PINMUX_DATA(PTV4_DATA, PTV4_IN, PTV4_OUT),
	PINMUX_DATA(PTV3_DATA, PTV3_IN, PTV3_OUT),
	PINMUX_DATA(PTV2_DATA, PTV2_IN, PTV2_OUT),
	PINMUX_DATA(PTV1_DATA, PTV1_IN, PTV1_OUT),
	PINMUX_DATA(PTV0_DATA, PTV0_IN, PTV0_OUT),

	/* PTW GPIO */
	PINMUX_DATA(PTW7_DATA, PTW7_IN, PTW7_OUT),
	PINMUX_DATA(PTW6_DATA, PTW6_IN, PTW6_OUT),
	PINMUX_DATA(PTW5_DATA, PTW5_IN, PTW5_OUT),
	PINMUX_DATA(PTW4_DATA, PTW4_IN, PTW4_OUT),
	PINMUX_DATA(PTW3_DATA, PTW3_IN, PTW3_OUT),
	PINMUX_DATA(PTW2_DATA, PTW2_IN, PTW2_OUT),
	PINMUX_DATA(PTW1_DATA, PTW1_IN, PTW1_OUT),
	PINMUX_DATA(PTW0_DATA, PTW0_IN, PTW0_OUT),

	/* PTX GPIO */
	PINMUX_DATA(PTX7_DATA, PTX7_IN, PTX7_OUT),
	PINMUX_DATA(PTX6_DATA, PTX6_IN, PTX6_OUT),
	PINMUX_DATA(PTX5_DATA, PTX5_IN, PTX5_OUT),
	PINMUX_DATA(PTX4_DATA, PTX4_IN, PTX4_OUT),
	PINMUX_DATA(PTX3_DATA, PTX3_IN, PTX3_OUT),
	PINMUX_DATA(PTX2_DATA, PTX2_IN, PTX2_OUT),
	PINMUX_DATA(PTX1_DATA, PTX1_IN, PTX1_OUT),
	PINMUX_DATA(PTX0_DATA, PTX0_IN, PTX0_OUT),

	/* PTY GPIO */
	PINMUX_DATA(PTY7_DATA, PTY7_IN, PTY7_OUT),
	PINMUX_DATA(PTY6_DATA, PTY6_IN, PTY6_OUT),
	PINMUX_DATA(PTY5_DATA, PTY5_IN, PTY5_OUT),
	PINMUX_DATA(PTY4_DATA, PTY4_IN, PTY4_OUT),
	PINMUX_DATA(PTY3_DATA, PTY3_IN, PTY3_OUT),
	PINMUX_DATA(PTY2_DATA, PTY2_IN, PTY2_OUT),
	PINMUX_DATA(PTY1_DATA, PTY1_IN, PTY1_OUT),
	PINMUX_DATA(PTY0_DATA, PTY0_IN, PTY0_OUT),

	/* PTZ GPIO */
	PINMUX_DATA(PTZ7_DATA, PTZ7_IN, PTZ7_OUT),
	PINMUX_DATA(PTZ6_DATA, PTZ6_IN, PTZ6_OUT),
	PINMUX_DATA(PTZ5_DATA, PTZ5_IN, PTZ5_OUT),
	PINMUX_DATA(PTZ4_DATA, PTZ4_IN, PTZ4_OUT),
	PINMUX_DATA(PTZ3_DATA, PTZ3_IN, PTZ3_OUT),
	PINMUX_DATA(PTZ2_DATA, PTZ2_IN, PTZ2_OUT),
	PINMUX_DATA(PTZ1_DATA, PTZ1_IN, PTZ1_OUT),
	PINMUX_DATA(PTZ0_DATA, PTZ0_IN, PTZ0_OUT),

	/* PTA FN */
	PINMUX_DATA(D23_MARK,	PSA15_0, PSA14_0, PTA7_FN),
	PINMUX_DATA(D22_MARK,	PSA15_0, PSA14_0, PTA6_FN),
	PINMUX_DATA(D21_MARK,	PSA15_0, PSA14_0, PTA5_FN),
	PINMUX_DATA(D20_MARK,	PSA15_0, PSA14_0, PTA4_FN),
	PINMUX_DATA(D19_MARK,	PSA15_0, PSA14_0, PTA3_FN),
	PINMUX_DATA(D18_MARK,	PSA15_0, PSA14_0, PTA2_FN),
	PINMUX_DATA(D17_MARK,	PSA15_0, PSA14_0, PTA1_FN),
	PINMUX_DATA(D16_MARK,	PSA15_0, PSA14_0, PTA0_FN),

	PINMUX_DATA(KEYOUT2_MARK,	PSA15_0, PSA14_1, PTA7_FN),
	PINMUX_DATA(KEYOUT1_MARK,	PSA15_0, PSA14_1, PTA6_FN),
	PINMUX_DATA(KEYOUT0_MARK,	PSA15_0, PSA14_1, PTA5_FN),
	PINMUX_DATA(KEYIN4_MARK,	PSA15_0, PSA14_1, PTA4_FN),
	PINMUX_DATA(KEYIN3_MARK,	PSA15_0, PSA14_1, PTA3_FN),
	PINMUX_DATA(KEYIN2_MARK,	PSA15_0, PSA14_1, PTA2_FN),
	PINMUX_DATA(KEYIN1_MARK,	PSA15_0, PSA14_1, PTA1_FN),
	PINMUX_DATA(KEYIN0_MARK,	PSA15_0, PSA14_1, PTA0_FN),

	PINMUX_DATA(IDED15_MARK,	PSA15_1, PSA14_0, PTA7_FN),
	PINMUX_DATA(IDED14_MARK,	PSA15_1, PSA14_0, PTA6_FN),
	PINMUX_DATA(IDED13_MARK,	PSA15_1, PSA14_0, PTA5_FN),
	PINMUX_DATA(IDED12_MARK,	PSA15_1, PSA14_0, PTA4_FN),
	PINMUX_DATA(IDED11_MARK,	PSA15_1, PSA14_0, PTA3_FN),
	PINMUX_DATA(IDED10_MARK,	PSA15_1, PSA14_0, PTA2_FN),
	PINMUX_DATA(IDED9_MARK,		PSA15_1, PSA14_0, PTA1_FN),
	PINMUX_DATA(IDED8_MARK,		PSA15_1, PSA14_0, PTA0_FN),

	/* PTB FN */
	PINMUX_DATA(D31_MARK,		PSE15_0, PSE14_0, PTB7_FN),
	PINMUX_DATA(D30_MARK,		PSE15_0, PSE14_0, PTB6_FN),
	PINMUX_DATA(D29_MARK,		PSE11_0,          PTB5_FN),
	PINMUX_DATA(D28_MARK,		PSE11_0,          PTB4_FN),
	PINMUX_DATA(D27_MARK,		PSE11_0,          PTB3_FN),
	PINMUX_DATA(D26_MARK,		PSA15_0, PSA14_0, PTB2_FN),
	PINMUX_DATA(D25_MARK,		PSA15_0, PSA14_0, PTB1_FN),
	PINMUX_DATA(D24_MARK,		PSA15_0, PSA14_0, PTB0_FN),

	PINMUX_DATA(IDEA1_MARK,		PSE15_1, PSE14_0, PTB7_FN),
	PINMUX_DATA(IDEA0_MARK,		PSE15_1, PSE14_0, PTB6_FN),
	PINMUX_DATA(IODREQ_MARK,	PSE11_1,          PTB5_FN),
	PINMUX_DATA(IDECS0_MARK,	PSE11_1,          PTB4_FN),
	PINMUX_DATA(IDECS1_MARK,	PSE11_1,          PTB3_FN),
	PINMUX_DATA(IDEIORD_MARK,	PSA15_1, PSA14_0, PTB2_FN),
	PINMUX_DATA(IDEIOWR_MARK,	PSA15_1, PSA14_0, PTB1_FN),
	PINMUX_DATA(IDEINT_MARK,	PSA15_1, PSA14_0, PTB0_FN),

	PINMUX_DATA(TPUTO1_MARK,	PSE15_0, PSE14_1, PTB7_FN),
	PINMUX_DATA(TPUTO0_MARK,	PSE15_0, PSE14_1, PTB6_FN),

	PINMUX_DATA(KEYOUT5_IN5_MARK,	PSA15_0, PSA14_1, PTB2_FN),
	PINMUX_DATA(KEYOUT4_IN6_MARK,	PSA15_0, PSA14_1, PTB1_FN),
	PINMUX_DATA(KEYOUT3_MARK,	PSA15_0, PSA14_1, PTB0_FN),

	/* PTC FN */
	PINMUX_DATA(LCDD7_MARK, PSD5_0, PTC7_FN),
	PINMUX_DATA(LCDD6_MARK, PSD5_0, PTC6_FN),
	PINMUX_DATA(LCDD5_MARK, PSD5_0, PTC5_FN),
	PINMUX_DATA(LCDD4_MARK, PSD5_0, PTC4_FN),
	PINMUX_DATA(LCDD3_MARK, PSD5_0, PTC3_FN),
	PINMUX_DATA(LCDD2_MARK, PSD5_0, PTC2_FN),
	PINMUX_DATA(LCDD1_MARK, PSD5_0, PTC1_FN),
	PINMUX_DATA(LCDD0_MARK, PSD5_0, PTC0_FN),

	/* PTD FN */
	PINMUX_DATA(LCDD15_MARK, PSD5_0, PTD7_FN),
	PINMUX_DATA(LCDD14_MARK, PSD5_0, PTD6_FN),
	PINMUX_DATA(LCDD13_MARK, PSD5_0, PTD5_FN),
	PINMUX_DATA(LCDD12_MARK, PSD5_0, PTD4_FN),
	PINMUX_DATA(LCDD11_MARK, PSD5_0, PTD3_FN),
	PINMUX_DATA(LCDD10_MARK, PSD5_0, PTD2_FN),
	PINMUX_DATA(LCDD9_MARK,  PSD5_0, PTD1_FN),
	PINMUX_DATA(LCDD8_MARK,  PSD5_0, PTD0_FN),

	/* PTE FN */
	PINMUX_DATA(FSIMCKB_MARK, PTE7_FN),
	PINMUX_DATA(FSIMCKA_MARK, PTE6_FN),

	PINMUX_DATA(LCDD21_MARK,	PSC5_0, PSC4_0, PTE5_FN),
	PINMUX_DATA(LCDD20_MARK,	PSD3_0, PSD2_0, PTE4_FN),
	PINMUX_DATA(LCDD19_MARK,	PSA3_0, PSA2_0, PTE3_FN),
	PINMUX_DATA(LCDD18_MARK,	PSA3_0, PSA2_0, PTE2_FN),
	PINMUX_DATA(LCDD17_MARK,	PSD5_0,         PTE1_FN),
	PINMUX_DATA(LCDD16_MARK,	PSD5_0,         PTE0_FN),

	PINMUX_DATA(SCIF2_L_TXD_MARK,	PSC5_0, PSC4_1, PTE5_FN),
	PINMUX_DATA(SCIF4_SCK_MARK,	PSD3_0, PSD2_1, PTE4_FN),
	PINMUX_DATA(SCIF4_RXD_MARK,	PSA3_0, PSA2_1, PTE3_FN),
	PINMUX_DATA(SCIF4_TXD_MARK,	PSA3_0, PSA2_1, PTE2_FN),

	/* PTF FN */
	PINMUX_DATA(LCDVSYN_MARK,	PSD8_0,          PTF7_FN),
	PINMUX_DATA(LCDDISP_MARK,	PSD10_0, PSD9_0, PTF6_FN),
	PINMUX_DATA(LCDHSYN_MARK,	PSD10_0, PSD9_0, PTF5_FN),
	PINMUX_DATA(LCDDON_MARK,	PSD8_0,          PTF4_FN),
	PINMUX_DATA(LCDDCK_MARK,	PSD10_0, PSD9_0, PTF3_FN),
	PINMUX_DATA(LCDVEPWC_MARK,	PSA6_0,          PTF2_FN),
	PINMUX_DATA(LCDD23_MARK,	PSC7_0,  PSC6_0, PTF1_FN),
	PINMUX_DATA(LCDD22_MARK,	PSC5_0,  PSC4_0, PTF0_FN),

	PINMUX_DATA(LCDRS_MARK,		PSD10_0, PSD9_1, PTF6_FN),
	PINMUX_DATA(LCDCS_MARK,		PSD10_0, PSD9_1, PTF5_FN),
	PINMUX_DATA(LCDWR_MARK,		PSD10_0, PSD9_1, PTF3_FN),

	PINMUX_DATA(SCIF0_TXD_MARK,	PSA6_1,          PTF2_FN),
	PINMUX_DATA(SCIF2_L_SCK_MARK,	PSC7_0,  PSC6_1, PTF1_FN),
	PINMUX_DATA(SCIF2_L_RXD_MARK,	PSC5_0,  PSC4_1, PTF0_FN),

	/* PTG FN */
	PINMUX_DATA(AUDCK_MARK,   PTG5_FN),
	PINMUX_DATA(AUDSYNC_MARK, PTG4_FN),
	PINMUX_DATA(AUDATA3_MARK, PTG3_FN),
	PINMUX_DATA(AUDATA2_MARK, PTG2_FN),
	PINMUX_DATA(AUDATA1_MARK, PTG1_FN),
	PINMUX_DATA(AUDATA0_MARK, PTG0_FN),

	/* PTH FN */
	PINMUX_DATA(VIO0_VD_MARK,  PTH7_FN),
	PINMUX_DATA(VIO0_CLK_MARK, PTH6_FN),
	PINMUX_DATA(VIO0_D7_MARK,  PTH5_FN),
	PINMUX_DATA(VIO0_D6_MARK,  PTH4_FN),
	PINMUX_DATA(VIO0_D5_MARK,  PTH3_FN),
	PINMUX_DATA(VIO0_D4_MARK,  PTH2_FN),
	PINMUX_DATA(VIO0_D3_MARK,  PTH1_FN),
	PINMUX_DATA(VIO0_D2_MARK,  PTH0_FN),

	/* PTJ FN */
	PINMUX_DATA(PDSTATUS_MARK,	PTJ7_FN),
	PINMUX_DATA(STATUS2_MARK,	PTJ6_FN),
	PINMUX_DATA(STATUS0_MARK,	PTJ5_FN),
	PINMUX_DATA(A25_MARK,		PSA8_0, PTJ3_FN),
	PINMUX_DATA(BS_MARK,		PSA8_1, PTJ3_FN),
	PINMUX_DATA(A24_MARK,		PTJ2_FN),
	PINMUX_DATA(A23_MARK,		PTJ1_FN),
	PINMUX_DATA(A22_MARK,		PTJ0_FN),

	/* PTK FN */
	PINMUX_DATA(VIO1_D5_MARK,	PSB7_0, PSB6_0, PTK7_FN),
	PINMUX_DATA(VIO1_D4_MARK,	PSB7_0, PSB6_0, PTK6_FN),
	PINMUX_DATA(VIO1_D3_MARK,	PSB7_0, PSB6_0, PTK5_FN),
	PINMUX_DATA(VIO1_D2_MARK,	PSB7_0, PSB6_0, PTK4_FN),
	PINMUX_DATA(VIO1_D1_MARK,	PSB7_0, PSB6_0, PTK3_FN),
	PINMUX_DATA(VIO1_D0_MARK,	PSB7_0, PSB6_0, PTK2_FN),

	PINMUX_DATA(VIO0_D13_MARK,	PSB7_0, PSB6_1, PTK7_FN),
	PINMUX_DATA(VIO0_D12_MARK,	PSB7_0, PSB6_1, PTK6_FN),
	PINMUX_DATA(VIO0_D11_MARK,	PSB7_0, PSB6_1, PTK5_FN),
	PINMUX_DATA(VIO0_D10_MARK,	PSB7_0, PSB6_1, PTK4_FN),
	PINMUX_DATA(VIO0_D9_MARK,	PSB7_0, PSB6_1, PTK3_FN),
	PINMUX_DATA(VIO0_D8_MARK,	PSB7_0, PSB6_1, PTK2_FN),

	PINMUX_DATA(IDED5_MARK,		PSB7_1, PSB6_0, PTK7_FN),
	PINMUX_DATA(IDED4_MARK,		PSB7_1, PSB6_0, PTK6_FN),
	PINMUX_DATA(IDED3_MARK,		PSB7_1, PSB6_0, PTK5_FN),
	PINMUX_DATA(IDED2_MARK,		PSB7_1, PSB6_0, PTK4_FN),
	PINMUX_DATA(IDED1_MARK,		PSB7_1, PSB6_0, PTK3_FN),
	PINMUX_DATA(IDED0_MARK,		PSB7_1, PSB6_0, PTK2_FN),

	PINMUX_DATA(VIO0_FLD_MARK,	PTK1_FN),
	PINMUX_DATA(VIO0_HD_MARK,	PTK0_FN),

	/* PTL FN */
	PINMUX_DATA(DV_D5_MARK,		PSB9_0, PSB8_0, PTL7_FN),
	PINMUX_DATA(DV_D4_MARK,		PSB9_0, PSB8_0, PTL6_FN),
	PINMUX_DATA(DV_D3_MARK,		PSE7_0, PSE6_0, PTL5_FN),
	PINMUX_DATA(DV_D2_MARK,		PSC9_0, PSC8_0, PTL4_FN),
	PINMUX_DATA(DV_D1_MARK,		PSC9_0, PSC8_0, PTL3_FN),
	PINMUX_DATA(DV_D0_MARK,		PSC9_0, PSC8_0, PTL2_FN),
	PINMUX_DATA(DV_D15_MARK,	PSD4_0,         PTL1_FN),
	PINMUX_DATA(DV_D14_MARK,	PSE5_0, PSE4_0, PTL0_FN),

	PINMUX_DATA(SCIF3_V_SCK_MARK,	PSB9_0, PSB8_1, PTL7_FN),
	PINMUX_DATA(SCIF3_V_RXD_MARK,	PSB9_0, PSB8_1, PTL6_FN),
	PINMUX_DATA(SCIF3_V_TXD_MARK,	PSE7_0, PSE6_1, PTL5_FN),
	PINMUX_DATA(SCIF1_SCK_MARK,	PSC9_0, PSC8_1, PTL4_FN),
	PINMUX_DATA(SCIF1_RXD_MARK,	PSC9_0, PSC8_1, PTL3_FN),
	PINMUX_DATA(SCIF1_TXD_MARK,	PSC9_0, PSC8_1, PTL2_FN),

	PINMUX_DATA(RMII_RXD0_MARK,	PSB9_1, PSB8_0, PTL7_FN),
	PINMUX_DATA(RMII_RXD1_MARK,	PSB9_1, PSB8_0, PTL6_FN),
	PINMUX_DATA(RMII_REF_CLK_MARK,	PSE7_1, PSE6_0, PTL5_FN),
	PINMUX_DATA(RMII_TX_EN_MARK,	PSC9_1, PSC8_0, PTL4_FN),
	PINMUX_DATA(RMII_TXD0_MARK,	PSC9_1, PSC8_0, PTL3_FN),
	PINMUX_DATA(RMII_TXD1_MARK,	PSC9_1, PSC8_0, PTL2_FN),

	PINMUX_DATA(MSIOF0_MCK_MARK,	PSE5_0, PSE4_1, PTL0_FN),

	/* PTM FN */
	PINMUX_DATA(DV_D13_MARK,	PSC13_0, PSC12_0, PTM7_FN),
	PINMUX_DATA(DV_D12_MARK,	PSC13_0, PSC12_0, PTM6_FN),
	PINMUX_DATA(DV_D11_MARK,	PSC13_0, PSC12_0, PTM5_FN),
	PINMUX_DATA(DV_D10_MARK,	PSC13_0, PSC12_0, PTM4_FN),
	PINMUX_DATA(DV_D9_MARK,		PSC11_0, PSC10_0, PTM3_FN),
	PINMUX_DATA(DV_D8_MARK,		PSC11_0, PSC10_0, PTM2_FN),

	PINMUX_DATA(MSIOF0_TSCK_MARK,	PSC13_0, PSC12_1, PTM7_FN),
	PINMUX_DATA(MSIOF0_RXD_MARK,	PSC13_0, PSC12_1, PTM6_FN),
	PINMUX_DATA(MSIOF0_TXD_MARK,	PSC13_0, PSC12_1, PTM5_FN),
	PINMUX_DATA(MSIOF0_TSYNC_MARK,	PSC13_0, PSC12_1, PTM4_FN),
	PINMUX_DATA(MSIOF0_SS1_MARK,	PSC11_0, PSC10_1, PTM3_FN),
	PINMUX_DATA(MSIOF0_RSCK_MARK,	PSC11_1, PSC10_0, PTM3_FN),
	PINMUX_DATA(MSIOF0_SS2_MARK,	PSC11_0, PSC10_1, PTM2_FN),
	PINMUX_DATA(MSIOF0_RSYNC_MARK,	PSC11_1, PSC10_0, PTM2_FN),

	PINMUX_DATA(LCDVCPWC_MARK,	PSA6_0, PTM1_FN),
	PINMUX_DATA(LCDRD_MARK,		PSA7_0, PTM0_FN),

	PINMUX_DATA(SCIF0_RXD_MARK,	PSA6_1, PTM1_FN),
	PINMUX_DATA(SCIF0_SCK_MARK,	PSA7_1, PTM0_FN),

	/* PTN FN */
	PINMUX_DATA(VIO0_D1_MARK,	PTN7_FN),
	PINMUX_DATA(VIO0_D0_MARK,	PTN6_FN),

	PINMUX_DATA(DV_CLKI_MARK,	PSD11_0,          PTN5_FN),
	PINMUX_DATA(DV_CLK_MARK,	PSD13_0, PSD12_0, PTN4_FN),
	PINMUX_DATA(DV_VSYNC_MARK,	PSD15_0, PSD14_0, PTN3_FN),
	PINMUX_DATA(DV_HSYNC_MARK,	PSB5_0,  PSB4_0,  PTN2_FN),
	PINMUX_DATA(DV_D7_MARK,		PSB3_0,  PSB2_0,  PTN1_FN),
	PINMUX_DATA(DV_D6_MARK,		PSB1_0,  PSB0_0,  PTN0_FN),

	PINMUX_DATA(SCIF2_V_SCK_MARK,	PSD13_0, PSD12_1, PTN4_FN),
	PINMUX_DATA(SCIF2_V_RXD_MARK,	PSD15_0, PSD14_1, PTN3_FN),
	PINMUX_DATA(SCIF2_V_TXD_MARK,	PSB5_0,  PSB4_1,  PTN2_FN),
	PINMUX_DATA(SCIF3_V_CTS_MARK,	PSB3_0,  PSB2_1,  PTN1_FN),
	PINMUX_DATA(SCIF3_V_RTS_MARK,	PSB1_0,  PSB0_1,  PTN0_FN),

	PINMUX_DATA(RMII_RX_ER_MARK,	PSB3_1, PSB2_0, PTN1_FN),
	PINMUX_DATA(RMII_CRS_DV_MARK,	PSB1_1, PSB0_0, PTN0_FN),

	/* PTQ FN */
	PINMUX_DATA(D7_MARK, PTQ7_FN),
	PINMUX_DATA(D6_MARK, PTQ6_FN),
	PINMUX_DATA(D5_MARK, PTQ5_FN),
	PINMUX_DATA(D4_MARK, PTQ4_FN),
	PINMUX_DATA(D3_MARK, PTQ3_FN),
	PINMUX_DATA(D2_MARK, PTQ2_FN),
	PINMUX_DATA(D1_MARK, PTQ1_FN),
	PINMUX_DATA(D0_MARK, PTQ0_FN),

	/* PTR FN */
	PINMUX_DATA(CS6B_CE1B_MARK,	                PTR7_FN),
	PINMUX_DATA(CS6A_CE2B_MARK,	                PTR6_FN),
	PINMUX_DATA(CS5B_CE1A_MARK,	                PTR5_FN),
	PINMUX_DATA(CS5A_CE2A_MARK,	                PTR4_FN),
	PINMUX_DATA(IOIS16_MARK,	PSA5_0,         PTR3_FN),
	PINMUX_DATA(WAIT_MARK,		                PTR2_FN),
	PINMUX_DATA(WE3_ICIOWR_MARK,	PSA1_0, PSA0_0, PTR1_FN),
	PINMUX_DATA(WE2_ICIORD_MARK,	PSD1_0, PSD0_0, PTR0_FN),

	PINMUX_DATA(LCDLCLK_MARK,	PSA5_1,         PTR3_FN),

	PINMUX_DATA(IDEA2_MARK,		PSD1_1, PSD0_0, PTR0_FN),

	PINMUX_DATA(TPUTO3_MARK,	PSA1_0, PSA0_1, PTR1_FN),
	PINMUX_DATA(TPUTI3_MARK,	PSA1_1, PSA0_0, PTR1_FN),
	PINMUX_DATA(TPUTO2_MARK,	PSD1_0, PSD0_1, PTR0_FN),

	/* PTS FN */
	PINMUX_DATA(VIO_CKO_MARK,	PTS6_FN),

	PINMUX_DATA(TPUTI2_MARK,	PSE9_0, PSE8_1, PTS5_FN),

	PINMUX_DATA(IDEIORDY_MARK,	PSE9_1, PSE8_0, PTS5_FN),

	PINMUX_DATA(VIO1_FLD_MARK,	PSE9_0, PSE8_0, PTS5_FN),
	PINMUX_DATA(VIO1_HD_MARK,	PSA10_0,        PTS4_FN),
	PINMUX_DATA(VIO1_VD_MARK,	PSA9_0,         PTS3_FN),
	PINMUX_DATA(VIO1_CLK_MARK,	PSA9_0,         PTS2_FN),
	PINMUX_DATA(VIO1_D7_MARK,	PSB7_0, PSB6_0, PTS1_FN),
	PINMUX_DATA(VIO1_D6_MARK,	PSB7_0, PSB6_0, PTS0_FN),

	PINMUX_DATA(SCIF5_SCK_MARK,	PSA10_1, PTS4_FN),
	PINMUX_DATA(SCIF5_RXD_MARK,	PSA9_1,  PTS3_FN),
	PINMUX_DATA(SCIF5_TXD_MARK,	PSA9_1,  PTS2_FN),

	PINMUX_DATA(VIO0_D15_MARK,	PSB7_0, PSB6_1, PTS1_FN),
	PINMUX_DATA(VIO0_D14_MARK,	PSB7_0, PSB6_1, PTS0_FN),

	PINMUX_DATA(IDED7_MARK,		PSB7_1, PSB6_0, PTS1_FN),
	PINMUX_DATA(IDED6_MARK,		PSB7_1, PSB6_0, PTS0_FN),

	/* PTT FN */
	PINMUX_DATA(D15_MARK, PTT7_FN),
	PINMUX_DATA(D14_MARK, PTT6_FN),
	PINMUX_DATA(D13_MARK, PTT5_FN),
	PINMUX_DATA(D12_MARK, PTT4_FN),
	PINMUX_DATA(D11_MARK, PTT3_FN),
	PINMUX_DATA(D10_MARK, PTT2_FN),
	PINMUX_DATA(D9_MARK,  PTT1_FN),
	PINMUX_DATA(D8_MARK,  PTT0_FN),

	/* PTU FN */
	PINMUX_DATA(DMAC_DACK0_MARK, PTU7_FN),
	PINMUX_DATA(DMAC_DREQ0_MARK, PTU6_FN),

	PINMUX_DATA(FSIOASD_MARK,	PSE1_0, PTU5_FN),
	PINMUX_DATA(FSIIABCK_MARK,	PSE1_0, PTU4_FN),
	PINMUX_DATA(FSIIALRCK_MARK,	PSE1_0, PTU3_FN),
	PINMUX_DATA(FSIOABCK_MARK,	PSE1_0, PTU2_FN),
	PINMUX_DATA(FSIOALRCK_MARK,	PSE1_0, PTU1_FN),
	PINMUX_DATA(CLKAUDIOAO_MARK,	PSE0_0, PTU0_FN),

	/* PTV FN */
	PINMUX_DATA(FSIIBSD_MARK,	PSD7_0,  PSD6_0,  PTV7_FN),
	PINMUX_DATA(FSIOBSD_MARK,	PSD7_0,  PSD6_0,  PTV6_FN),
	PINMUX_DATA(FSIIBBCK_MARK,	PSC15_0, PSC14_0, PTV5_FN),
	PINMUX_DATA(FSIIBLRCK_MARK,	PSC15_0, PSC14_0, PTV4_FN),
	PINMUX_DATA(FSIOBBCK_MARK,	PSC15_0, PSC14_0, PTV3_FN),
	PINMUX_DATA(FSIOBLRCK_MARK,	PSC15_0, PSC14_0, PTV2_FN),
	PINMUX_DATA(CLKAUDIOBO_MARK,	PSE3_0,  PSE2_0,  PTV1_FN),
	PINMUX_DATA(FSIIASD_MARK,	PSE10_0,          PTV0_FN),

	PINMUX_DATA(MSIOF1_SS2_MARK,	PSD7_0,  PSD6_1,  PTV7_FN),
	PINMUX_DATA(MSIOF1_RSYNC_MARK,	PSD7_1,  PSD6_0,  PTV7_FN),
	PINMUX_DATA(MSIOF1_SS1_MARK,	PSD7_0,  PSD6_1,  PTV6_FN),
	PINMUX_DATA(MSIOF1_RSCK_MARK,	PSD7_1,  PSD6_0,  PTV6_FN),
	PINMUX_DATA(MSIOF1_RXD_MARK,	PSC15_0, PSC14_1, PTV5_FN),
	PINMUX_DATA(MSIOF1_TSYNC_MARK,	PSC15_0, PSC14_1, PTV4_FN),
	PINMUX_DATA(MSIOF1_TSCK_MARK,	PSC15_0, PSC14_1, PTV3_FN),
	PINMUX_DATA(MSIOF1_TXD_MARK,	PSC15_0, PSC14_1, PTV2_FN),
	PINMUX_DATA(MSIOF1_MCK_MARK,	PSE3_0,  PSE2_1,  PTV1_FN),

	/* PTW FN */
	PINMUX_DATA(MMC_D7_MARK,	PSE13_0, PSE12_0, PTW7_FN),
	PINMUX_DATA(MMC_D6_MARK,	PSE13_0, PSE12_0, PTW6_FN),
	PINMUX_DATA(MMC_D5_MARK,	PSE13_0, PSE12_0, PTW5_FN),
	PINMUX_DATA(MMC_D4_MARK,	PSE13_0, PSE12_0, PTW4_FN),
	PINMUX_DATA(MMC_D3_MARK,	PSA13_0,          PTW3_FN),
	PINMUX_DATA(MMC_D2_MARK,	PSA13_0,          PTW2_FN),
	PINMUX_DATA(MMC_D1_MARK,	PSA13_0,          PTW1_FN),
	PINMUX_DATA(MMC_D0_MARK,	PSA13_0,          PTW0_FN),

	PINMUX_DATA(SDHI1CD_MARK,	PSE13_0, PSE12_1, PTW7_FN),
	PINMUX_DATA(SDHI1WP_MARK,	PSE13_0, PSE12_1, PTW6_FN),
	PINMUX_DATA(SDHI1D3_MARK,	PSE13_0, PSE12_1, PTW5_FN),
	PINMUX_DATA(SDHI1D2_MARK,	PSE13_0, PSE12_1, PTW4_FN),
	PINMUX_DATA(SDHI1D1_MARK,	PSA13_1,          PTW3_FN),
	PINMUX_DATA(SDHI1D0_MARK,	PSA13_1,          PTW2_FN),
	PINMUX_DATA(SDHI1CMD_MARK,	PSA13_1,          PTW1_FN),
	PINMUX_DATA(SDHI1CLK_MARK,	PSA13_1,          PTW0_FN),

	PINMUX_DATA(IODACK_MARK,	PSE13_1, PSE12_0, PTW7_FN),
	PINMUX_DATA(IDERST_MARK,	PSE13_1, PSE12_0, PTW6_FN),
	PINMUX_DATA(EXBUF_ENB_MARK,	PSE13_1, PSE12_0, PTW5_FN),
	PINMUX_DATA(DIRECTION_MARK,	PSE13_1, PSE12_0, PTW4_FN),

	/* PTX FN */
	PINMUX_DATA(DMAC_DACK1_MARK,	PSA12_0, PTX7_FN),
	PINMUX_DATA(DMAC_DREQ1_MARK,	PSA12_0, PTX6_FN),

	PINMUX_DATA(IRDA_OUT_MARK,	PSA12_1, PTX7_FN),
	PINMUX_DATA(IRDA_IN_MARK,	PSA12_1, PTX6_FN),

	PINMUX_DATA(TSIF_TS0_SDAT_MARK,	PSC0_0, PTX5_FN),
	PINMUX_DATA(TSIF_TS0_SCK_MARK,	PSC1_0, PTX4_FN),
	PINMUX_DATA(TSIF_TS0_SDEN_MARK,	PSC2_0, PTX3_FN),
	PINMUX_DATA(TSIF_TS0_SPSYNC_MARK,       PTX2_FN),

	PINMUX_DATA(LNKSTA_MARK,	PSC0_1, PTX5_FN),
	PINMUX_DATA(MDIO_MARK,		PSC1_1, PTX4_FN),
	PINMUX_DATA(MDC_MARK,		PSC2_1, PTX3_FN),

	PINMUX_DATA(MMC_CLK_MARK, PTX1_FN),
	PINMUX_DATA(MMC_CMD_MARK, PTX0_FN),

	/* PTY FN */
	PINMUX_DATA(SDHI0CD_MARK,  PTY7_FN),
	PINMUX_DATA(SDHI0WP_MARK,  PTY6_FN),
	PINMUX_DATA(SDHI0D3_MARK,  PTY5_FN),
	PINMUX_DATA(SDHI0D2_MARK,  PTY4_FN),
	PINMUX_DATA(SDHI0D1_MARK,  PTY3_FN),
	PINMUX_DATA(SDHI0D0_MARK,  PTY2_FN),
	PINMUX_DATA(SDHI0CMD_MARK, PTY1_FN),
	PINMUX_DATA(SDHI0CLK_MARK, PTY0_FN),

	/* PTZ FN */
	PINMUX_DATA(INTC_IRQ7_MARK,	PSB10_0, PTZ7_FN),
	PINMUX_DATA(INTC_IRQ6_MARK,	PSB11_0, PTZ6_FN),
	PINMUX_DATA(INTC_IRQ5_MARK,	PSB12_0, PTZ5_FN),
	PINMUX_DATA(INTC_IRQ4_MARK,	PSB13_0, PTZ4_FN),
	PINMUX_DATA(INTC_IRQ3_MARK,	PSB14_0, PTZ3_FN),
	PINMUX_DATA(INTC_IRQ2_MARK,	         PTZ2_FN),
	PINMUX_DATA(INTC_IRQ1_MARK,	         PTZ1_FN),
	PINMUX_DATA(INTC_IRQ0_MARK,	         PTZ0_FN),

	PINMUX_DATA(SCIF3_I_CTS_MARK,	PSB10_1, PTZ7_FN),
	PINMUX_DATA(SCIF3_I_RTS_MARK,	PSB11_1, PTZ6_FN),
	PINMUX_DATA(SCIF3_I_SCK_MARK,	PSB12_1, PTZ5_FN),
	PINMUX_DATA(SCIF3_I_RXD_MARK,	PSB13_1, PTZ4_FN),
	PINMUX_DATA(SCIF3_I_TXD_MARK,	PSB14_1, PTZ3_FN),
};

static const struct sh_pfc_pin pinmux_pins[] = {
	/* PTA */
	PINMUX_GPIO(PTA7),
	PINMUX_GPIO(PTA6),
	PINMUX_GPIO(PTA5),
	PINMUX_GPIO(PTA4),
	PINMUX_GPIO(PTA3),
	PINMUX_GPIO(PTA2),
	PINMUX_GPIO(PTA1),
	PINMUX_GPIO(PTA0),

	/* PTB */
	PINMUX_GPIO(PTB7),
	PINMUX_GPIO(PTB6),
	PINMUX_GPIO(PTB5),
	PINMUX_GPIO(PTB4),
	PINMUX_GPIO(PTB3),
	PINMUX_GPIO(PTB2),
	PINMUX_GPIO(PTB1),
	PINMUX_GPIO(PTB0),

	/* PTC */
	PINMUX_GPIO(PTC7),
	PINMUX_GPIO(PTC6),
	PINMUX_GPIO(PTC5),
	PINMUX_GPIO(PTC4),
	PINMUX_GPIO(PTC3),
	PINMUX_GPIO(PTC2),
	PINMUX_GPIO(PTC1),
	PINMUX_GPIO(PTC0),

	/* PTD */
	PINMUX_GPIO(PTD7),
	PINMUX_GPIO(PTD6),
	PINMUX_GPIO(PTD5),
	PINMUX_GPIO(PTD4),
	PINMUX_GPIO(PTD3),
	PINMUX_GPIO(PTD2),
	PINMUX_GPIO(PTD1),
	PINMUX_GPIO(PTD0),

	/* PTE */
	PINMUX_GPIO(PTE7),
	PINMUX_GPIO(PTE6),
	PINMUX_GPIO(PTE5),
	PINMUX_GPIO(PTE4),
	PINMUX_GPIO(PTE3),
	PINMUX_GPIO(PTE2),
	PINMUX_GPIO(PTE1),
	PINMUX_GPIO(PTE0),

	/* PTF */
	PINMUX_GPIO(PTF7),
	PINMUX_GPIO(PTF6),
	PINMUX_GPIO(PTF5),
	PINMUX_GPIO(PTF4),
	PINMUX_GPIO(PTF3),
	PINMUX_GPIO(PTF2),
	PINMUX_GPIO(PTF1),
	PINMUX_GPIO(PTF0),

	/* PTG */
	PINMUX_GPIO(PTG5),
	PINMUX_GPIO(PTG4),
	PINMUX_GPIO(PTG3),
	PINMUX_GPIO(PTG2),
	PINMUX_GPIO(PTG1),
	PINMUX_GPIO(PTG0),

	/* PTH */
	PINMUX_GPIO(PTH7),
	PINMUX_GPIO(PTH6),
	PINMUX_GPIO(PTH5),
	PINMUX_GPIO(PTH4),
	PINMUX_GPIO(PTH3),
	PINMUX_GPIO(PTH2),
	PINMUX_GPIO(PTH1),
	PINMUX_GPIO(PTH0),

	/* PTJ */
	PINMUX_GPIO(PTJ7),
	PINMUX_GPIO(PTJ6),
	PINMUX_GPIO(PTJ5),
	PINMUX_GPIO(PTJ3),
	PINMUX_GPIO(PTJ2),
	PINMUX_GPIO(PTJ1),
	PINMUX_GPIO(PTJ0),

	/* PTK */
	PINMUX_GPIO(PTK7),
	PINMUX_GPIO(PTK6),
	PINMUX_GPIO(PTK5),
	PINMUX_GPIO(PTK4),
	PINMUX_GPIO(PTK3),
	PINMUX_GPIO(PTK2),
	PINMUX_GPIO(PTK1),
	PINMUX_GPIO(PTK0),

	/* PTL */
	PINMUX_GPIO(PTL7),
	PINMUX_GPIO(PTL6),
	PINMUX_GPIO(PTL5),
	PINMUX_GPIO(PTL4),
	PINMUX_GPIO(PTL3),
	PINMUX_GPIO(PTL2),
	PINMUX_GPIO(PTL1),
	PINMUX_GPIO(PTL0),

	/* PTM */
	PINMUX_GPIO(PTM7),
	PINMUX_GPIO(PTM6),
	PINMUX_GPIO(PTM5),
	PINMUX_GPIO(PTM4),
	PINMUX_GPIO(PTM3),
	PINMUX_GPIO(PTM2),
	PINMUX_GPIO(PTM1),
	PINMUX_GPIO(PTM0),

	/* PTN */
	PINMUX_GPIO(PTN7),
	PINMUX_GPIO(PTN6),
	PINMUX_GPIO(PTN5),
	PINMUX_GPIO(PTN4),
	PINMUX_GPIO(PTN3),
	PINMUX_GPIO(PTN2),
	PINMUX_GPIO(PTN1),
	PINMUX_GPIO(PTN0),

	/* PTQ */
	PINMUX_GPIO(PTQ7),
	PINMUX_GPIO(PTQ6),
	PINMUX_GPIO(PTQ5),
	PINMUX_GPIO(PTQ4),
	PINMUX_GPIO(PTQ3),
	PINMUX_GPIO(PTQ2),
	PINMUX_GPIO(PTQ1),
	PINMUX_GPIO(PTQ0),

	/* PTR */
	PINMUX_GPIO(PTR7),
	PINMUX_GPIO(PTR6),
	PINMUX_GPIO(PTR5),
	PINMUX_GPIO(PTR4),
	PINMUX_GPIO(PTR3),
	PINMUX_GPIO(PTR2),
	PINMUX_GPIO(PTR1),
	PINMUX_GPIO(PTR0),

	/* PTS */
	PINMUX_GPIO(PTS6),
	PINMUX_GPIO(PTS5),
	PINMUX_GPIO(PTS4),
	PINMUX_GPIO(PTS3),
	PINMUX_GPIO(PTS2),
	PINMUX_GPIO(PTS1),
	PINMUX_GPIO(PTS0),

	/* PTT */
	PINMUX_GPIO(PTT7),
	PINMUX_GPIO(PTT6),
	PINMUX_GPIO(PTT5),
	PINMUX_GPIO(PTT4),
	PINMUX_GPIO(PTT3),
	PINMUX_GPIO(PTT2),
	PINMUX_GPIO(PTT1),
	PINMUX_GPIO(PTT0),

	/* PTU */
	PINMUX_GPIO(PTU7),
	PINMUX_GPIO(PTU6),
	PINMUX_GPIO(PTU5),
	PINMUX_GPIO(PTU4),
	PINMUX_GPIO(PTU3),
	PINMUX_GPIO(PTU2),
	PINMUX_GPIO(PTU1),
	PINMUX_GPIO(PTU0),

	/* PTV */
	PINMUX_GPIO(PTV7),
	PINMUX_GPIO(PTV6),
	PINMUX_GPIO(PTV5),
	PINMUX_GPIO(PTV4),
	PINMUX_GPIO(PTV3),
	PINMUX_GPIO(PTV2),
	PINMUX_GPIO(PTV1),
	PINMUX_GPIO(PTV0),

	/* PTW */
	PINMUX_GPIO(PTW7),
	PINMUX_GPIO(PTW6),
	PINMUX_GPIO(PTW5),
	PINMUX_GPIO(PTW4),
	PINMUX_GPIO(PTW3),
	PINMUX_GPIO(PTW2),
	PINMUX_GPIO(PTW1),
	PINMUX_GPIO(PTW0),

	/* PTX */
	PINMUX_GPIO(PTX7),
	PINMUX_GPIO(PTX6),
	PINMUX_GPIO(PTX5),
	PINMUX_GPIO(PTX4),
	PINMUX_GPIO(PTX3),
	PINMUX_GPIO(PTX2),
	PINMUX_GPIO(PTX1),
	PINMUX_GPIO(PTX0),

	/* PTY */
	PINMUX_GPIO(PTY7),
	PINMUX_GPIO(PTY6),
	PINMUX_GPIO(PTY5),
	PINMUX_GPIO(PTY4),
	PINMUX_GPIO(PTY3),
	PINMUX_GPIO(PTY2),
	PINMUX_GPIO(PTY1),
	PINMUX_GPIO(PTY0),

	/* PTZ */
	PINMUX_GPIO(PTZ7),
	PINMUX_GPIO(PTZ6),
	PINMUX_GPIO(PTZ5),
	PINMUX_GPIO(PTZ4),
	PINMUX_GPIO(PTZ3),
	PINMUX_GPIO(PTZ2),
	PINMUX_GPIO(PTZ1),
	PINMUX_GPIO(PTZ0),
};

#define PINMUX_FN_BASE	ARRAY_SIZE(pinmux_pins)

static const struct pinmux_func pinmux_func_gpios[] = {
	/* BSC */
	GPIO_FN(D31),
	GPIO_FN(D30),
	GPIO_FN(D29),
	GPIO_FN(D28),
	GPIO_FN(D27),
	GPIO_FN(D26),
	GPIO_FN(D25),
	GPIO_FN(D24),
	GPIO_FN(D23),
	GPIO_FN(D22),
	GPIO_FN(D21),
	GPIO_FN(D20),
	GPIO_FN(D19),
	GPIO_FN(D18),
	GPIO_FN(D17),
	GPIO_FN(D16),
	GPIO_FN(D15),
	GPIO_FN(D14),
	GPIO_FN(D13),
	GPIO_FN(D12),
	GPIO_FN(D11),
	GPIO_FN(D10),
	GPIO_FN(D9),
	GPIO_FN(D8),
	GPIO_FN(D7),
	GPIO_FN(D6),
	GPIO_FN(D5),
	GPIO_FN(D4),
	GPIO_FN(D3),
	GPIO_FN(D2),
	GPIO_FN(D1),
	GPIO_FN(D0),
	GPIO_FN(A25),
	GPIO_FN(A24),
	GPIO_FN(A23),
	GPIO_FN(A22),
	GPIO_FN(CS6B_CE1B),
	GPIO_FN(CS6A_CE2B),
	GPIO_FN(CS5B_CE1A),
	GPIO_FN(CS5A_CE2A),
	GPIO_FN(WE3_ICIOWR),
	GPIO_FN(WE2_ICIORD),
	GPIO_FN(IOIS16),
	GPIO_FN(WAIT),
	GPIO_FN(BS),

	/* KEYSC */
	GPIO_FN(KEYOUT5_IN5),
	GPIO_FN(KEYOUT4_IN6),
	GPIO_FN(KEYIN4),
	GPIO_FN(KEYIN3),
	GPIO_FN(KEYIN2),
	GPIO_FN(KEYIN1),
	GPIO_FN(KEYIN0),
	GPIO_FN(KEYOUT3),
	GPIO_FN(KEYOUT2),
	GPIO_FN(KEYOUT1),
	GPIO_FN(KEYOUT0),

	/* ATAPI */
	GPIO_FN(IDED15),
	GPIO_FN(IDED14),
	GPIO_FN(IDED13),
	GPIO_FN(IDED12),
	GPIO_FN(IDED11),
	GPIO_FN(IDED10),
	GPIO_FN(IDED9),
	GPIO_FN(IDED8),
	GPIO_FN(IDED7),
	GPIO_FN(IDED6),
	GPIO_FN(IDED5),
	GPIO_FN(IDED4),
	GPIO_FN(IDED3),
	GPIO_FN(IDED2),
	GPIO_FN(IDED1),
	GPIO_FN(IDED0),
	GPIO_FN(IDEA2),
	GPIO_FN(IDEA1),
	GPIO_FN(IDEA0),
	GPIO_FN(IDEIOWR),
	GPIO_FN(IODREQ),
	GPIO_FN(IDECS0),
	GPIO_FN(IDECS1),
	GPIO_FN(IDEIORD),
	GPIO_FN(DIRECTION),
	GPIO_FN(EXBUF_ENB),
	GPIO_FN(IDERST),
	GPIO_FN(IODACK),
	GPIO_FN(IDEINT),
	GPIO_FN(IDEIORDY),

	/* TPU */
	GPIO_FN(TPUTO3),
	GPIO_FN(TPUTO2),
	GPIO_FN(TPUTO1),
	GPIO_FN(TPUTO0),
	GPIO_FN(TPUTI3),
	GPIO_FN(TPUTI2),

	/* LCDC */
	GPIO_FN(LCDD23),
	GPIO_FN(LCDD22),
	GPIO_FN(LCDD21),
	GPIO_FN(LCDD20),
	GPIO_FN(LCDD19),
	GPIO_FN(LCDD18),
	GPIO_FN(LCDD17),
	GPIO_FN(LCDD16),
	GPIO_FN(LCDD15),
	GPIO_FN(LCDD14),
	GPIO_FN(LCDD13),
	GPIO_FN(LCDD12),
	GPIO_FN(LCDD11),
	GPIO_FN(LCDD10),
	GPIO_FN(LCDD9),
	GPIO_FN(LCDD8),
	GPIO_FN(LCDD7),
	GPIO_FN(LCDD6),
	GPIO_FN(LCDD5),
	GPIO_FN(LCDD4),
	GPIO_FN(LCDD3),
	GPIO_FN(LCDD2),
	GPIO_FN(LCDD1),
	GPIO_FN(LCDD0),
	GPIO_FN(LCDVSYN),
	GPIO_FN(LCDDISP),
	GPIO_FN(LCDRS),
	GPIO_FN(LCDHSYN),
	GPIO_FN(LCDCS),
	GPIO_FN(LCDDON),
	GPIO_FN(LCDDCK),
	GPIO_FN(LCDWR),
	GPIO_FN(LCDVEPWC),
	GPIO_FN(LCDVCPWC),
	GPIO_FN(LCDRD),
	GPIO_FN(LCDLCLK),

	/* SCIF0 */
	GPIO_FN(SCIF0_TXD),
	GPIO_FN(SCIF0_RXD),
	GPIO_FN(SCIF0_SCK),

	/* SCIF1 */
	GPIO_FN(SCIF1_SCK),
	GPIO_FN(SCIF1_RXD),
	GPIO_FN(SCIF1_TXD),

	/* SCIF2 */
	GPIO_FN(SCIF2_L_TXD),
	GPIO_FN(SCIF2_L_SCK),
	GPIO_FN(SCIF2_L_RXD),
	GPIO_FN(SCIF2_V_TXD),
	GPIO_FN(SCIF2_V_SCK),
	GPIO_FN(SCIF2_V_RXD),

	/* SCIF3 */
	GPIO_FN(SCIF3_V_SCK),
	GPIO_FN(SCIF3_V_RXD),
	GPIO_FN(SCIF3_V_TXD),
	GPIO_FN(SCIF3_V_CTS),
	GPIO_FN(SCIF3_V_RTS),
	GPIO_FN(SCIF3_I_SCK),
	GPIO_FN(SCIF3_I_RXD),
	GPIO_FN(SCIF3_I_TXD),
	GPIO_FN(SCIF3_I_CTS),
	GPIO_FN(SCIF3_I_RTS),

	/* SCIF4 */
	GPIO_FN(SCIF4_SCK),
	GPIO_FN(SCIF4_RXD),
	GPIO_FN(SCIF4_TXD),

	/* SCIF5 */
	GPIO_FN(SCIF5_SCK),
	GPIO_FN(SCIF5_RXD),
	GPIO_FN(SCIF5_TXD),

	/* FSI */
	GPIO_FN(FSIMCKB),
	GPIO_FN(FSIMCKA),
	GPIO_FN(FSIOASD),
	GPIO_FN(FSIIABCK),
	GPIO_FN(FSIIALRCK),
	GPIO_FN(FSIOABCK),
	GPIO_FN(FSIOALRCK),
	GPIO_FN(CLKAUDIOAO),
	GPIO_FN(FSIIBSD),
	GPIO_FN(FSIOBSD),
	GPIO_FN(FSIIBBCK),
	GPIO_FN(FSIIBLRCK),
	GPIO_FN(FSIOBBCK),
	GPIO_FN(FSIOBLRCK),
	GPIO_FN(CLKAUDIOBO),
	GPIO_FN(FSIIASD),

	/* AUD */
	GPIO_FN(AUDCK),
	GPIO_FN(AUDSYNC),
	GPIO_FN(AUDATA3),
	GPIO_FN(AUDATA2),
	GPIO_FN(AUDATA1),
	GPIO_FN(AUDATA0),

	/* VIO */
	GPIO_FN(VIO_CKO),

	/* VIO0 */
	GPIO_FN(VIO0_D15),
	GPIO_FN(VIO0_D14),
	GPIO_FN(VIO0_D13),
	GPIO_FN(VIO0_D12),
	GPIO_FN(VIO0_D11),
	GPIO_FN(VIO0_D10),
	GPIO_FN(VIO0_D9),
	GPIO_FN(VIO0_D8),
	GPIO_FN(VIO0_D7),
	GPIO_FN(VIO0_D6),
	GPIO_FN(VIO0_D5),
	GPIO_FN(VIO0_D4),
	GPIO_FN(VIO0_D3),
	GPIO_FN(VIO0_D2),
	GPIO_FN(VIO0_D1),
	GPIO_FN(VIO0_D0),
	GPIO_FN(VIO0_VD),
	GPIO_FN(VIO0_CLK),
	GPIO_FN(VIO0_FLD),
	GPIO_FN(VIO0_HD),

	/* VIO1 */
	GPIO_FN(VIO1_D7),
	GPIO_FN(VIO1_D6),
	GPIO_FN(VIO1_D5),
	GPIO_FN(VIO1_D4),
	GPIO_FN(VIO1_D3),
	GPIO_FN(VIO1_D2),
	GPIO_FN(VIO1_D1),
	GPIO_FN(VIO1_D0),
	GPIO_FN(VIO1_FLD),
	GPIO_FN(VIO1_HD),
	GPIO_FN(VIO1_VD),
	GPIO_FN(VIO1_CLK),

	/* Eth */
	GPIO_FN(RMII_RXD0),
	GPIO_FN(RMII_RXD1),
	GPIO_FN(RMII_TXD0),
	GPIO_FN(RMII_TXD1),
	GPIO_FN(RMII_REF_CLK),
	GPIO_FN(RMII_TX_EN),
	GPIO_FN(RMII_RX_ER),
	GPIO_FN(RMII_CRS_DV),
	GPIO_FN(LNKSTA),
	GPIO_FN(MDIO),
	GPIO_FN(MDC),

	/* System */
	GPIO_FN(PDSTATUS),
	GPIO_FN(STATUS2),
	GPIO_FN(STATUS0),

	/* VOU */
	GPIO_FN(DV_D15),
	GPIO_FN(DV_D14),
	GPIO_FN(DV_D13),
	GPIO_FN(DV_D12),
	GPIO_FN(DV_D11),
	GPIO_FN(DV_D10),
	GPIO_FN(DV_D9),
	GPIO_FN(DV_D8),
	GPIO_FN(DV_D7),
	GPIO_FN(DV_D6),
	GPIO_FN(DV_D5),
	GPIO_FN(DV_D4),
	GPIO_FN(DV_D3),
	GPIO_FN(DV_D2),
	GPIO_FN(DV_D1),
	GPIO_FN(DV_D0),
	GPIO_FN(DV_CLKI),
	GPIO_FN(DV_CLK),
	GPIO_FN(DV_VSYNC),
	GPIO_FN(DV_HSYNC),

	/* MSIOF0 */
	GPIO_FN(MSIOF0_RXD),
	GPIO_FN(MSIOF0_TXD),
	GPIO_FN(MSIOF0_MCK),
	GPIO_FN(MSIOF0_TSCK),
	GPIO_FN(MSIOF0_SS1),
	GPIO_FN(MSIOF0_SS2),
	GPIO_FN(MSIOF0_TSYNC),
	GPIO_FN(MSIOF0_RSCK),
	GPIO_FN(MSIOF0_RSYNC),

	/* MSIOF1 */
	GPIO_FN(MSIOF1_RXD),
	GPIO_FN(MSIOF1_TXD),
	GPIO_FN(MSIOF1_MCK),
	GPIO_FN(MSIOF1_TSCK),
	GPIO_FN(MSIOF1_SS1),
	GPIO_FN(MSIOF1_SS2),
	GPIO_FN(MSIOF1_TSYNC),
	GPIO_FN(MSIOF1_RSCK),
	GPIO_FN(MSIOF1_RSYNC),

	/* DMAC */
	GPIO_FN(DMAC_DACK0),
	GPIO_FN(DMAC_DREQ0),
	GPIO_FN(DMAC_DACK1),
	GPIO_FN(DMAC_DREQ1),

	/* SDHI0 */
	GPIO_FN(SDHI0CD),
	GPIO_FN(SDHI0WP),
	GPIO_FN(SDHI0CMD),
	GPIO_FN(SDHI0CLK),
	GPIO_FN(SDHI0D3),
	GPIO_FN(SDHI0D2),
	GPIO_FN(SDHI0D1),
	GPIO_FN(SDHI0D0),

	/* SDHI1 */
	GPIO_FN(SDHI1CD),
	GPIO_FN(SDHI1WP),
	GPIO_FN(SDHI1CMD),
	GPIO_FN(SDHI1CLK),
	GPIO_FN(SDHI1D3),
	GPIO_FN(SDHI1D2),
	GPIO_FN(SDHI1D1),
	GPIO_FN(SDHI1D0),

	/* MMC */
	GPIO_FN(MMC_D7),
	GPIO_FN(MMC_D6),
	GPIO_FN(MMC_D5),
	GPIO_FN(MMC_D4),
	GPIO_FN(MMC_D3),
	GPIO_FN(MMC_D2),
	GPIO_FN(MMC_D1),
	GPIO_FN(MMC_D0),
	GPIO_FN(MMC_CLK),
	GPIO_FN(MMC_CMD),

	/* IrDA */
	GPIO_FN(IRDA_OUT),
	GPIO_FN(IRDA_IN),

	/* TSIF */
	GPIO_FN(TSIF_TS0_SDAT),
	GPIO_FN(TSIF_TS0_SCK),
	GPIO_FN(TSIF_TS0_SDEN),
	GPIO_FN(TSIF_TS0_SPSYNC),

	/* IRQ */
	GPIO_FN(INTC_IRQ7),
	GPIO_FN(INTC_IRQ6),
	GPIO_FN(INTC_IRQ5),
	GPIO_FN(INTC_IRQ4),
	GPIO_FN(INTC_IRQ3),
	GPIO_FN(INTC_IRQ2),
	GPIO_FN(INTC_IRQ1),
	GPIO_FN(INTC_IRQ0),
};

static const struct pinmux_cfg_reg pinmux_config_regs[] = {
	{ PINMUX_CFG_REG("PACR", 0xa4050100, 16, 2) {
		PTA7_FN, PTA7_OUT, 0, PTA7_IN,
		PTA6_FN, PTA6_OUT, 0, PTA6_IN,
		PTA5_FN, PTA5_OUT, 0, PTA5_IN,
		PTA4_FN, PTA4_OUT, 0, PTA4_IN,
		PTA3_FN, PTA3_OUT, 0, PTA3_IN,
		PTA2_FN, PTA2_OUT, 0, PTA2_IN,
		PTA1_FN, PTA1_OUT, 0, PTA1_IN,
		PTA0_FN, PTA0_OUT, 0, PTA0_IN }
	},
	{ PINMUX_CFG_REG("PBCR", 0xa4050102, 16, 2) {
		PTB7_FN, PTB7_OUT, 0, PTB7_IN,
		PTB6_FN, PTB6_OUT, 0, PTB6_IN,
		PTB5_FN, PTB5_OUT, 0, PTB5_IN,
		PTB4_FN, PTB4_OUT, 0, PTB4_IN,
		PTB3_FN, PTB3_OUT, 0, PTB3_IN,
		PTB2_FN, PTB2_OUT, 0, PTB2_IN,
		PTB1_FN, PTB1_OUT, 0, PTB1_IN,
		PTB0_FN, PTB0_OUT, 0, PTB0_IN }
	},
	{ PINMUX_CFG_REG("PCCR", 0xa4050104, 16, 2) {
		PTC7_FN, PTC7_OUT, 0, PTC7_IN,
		PTC6_FN, PTC6_OUT, 0, PTC6_IN,
		PTC5_FN, PTC5_OUT, 0, PTC5_IN,
		PTC4_FN, PTC4_OUT, 0, PTC4_IN,
		PTC3_FN, PTC3_OUT, 0, PTC3_IN,
		PTC2_FN, PTC2_OUT, 0, PTC2_IN,
		PTC1_FN, PTC1_OUT, 0, PTC1_IN,
		PTC0_FN, PTC0_OUT, 0, PTC0_IN }
	},
	{ PINMUX_CFG_REG("PDCR", 0xa4050106, 16, 2) {
		PTD7_FN, PTD7_OUT, 0, PTD7_IN,
		PTD6_FN, PTD6_OUT, 0, PTD6_IN,
		PTD5_FN, PTD5_OUT, 0, PTD5_IN,
		PTD4_FN, PTD4_OUT, 0, PTD4_IN,
		PTD3_FN, PTD3_OUT, 0, PTD3_IN,
		PTD2_FN, PTD2_OUT, 0, PTD2_IN,
		PTD1_FN, PTD1_OUT, 0, PTD1_IN,
		PTD0_FN, PTD0_OUT, 0, PTD0_IN }
	},
	{ PINMUX_CFG_REG("PECR", 0xa4050108, 16, 2) {
		PTE7_FN, PTE7_OUT, 0, PTE7_IN,
		PTE6_FN, PTE6_OUT, 0, PTE6_IN,
		PTE5_FN, PTE5_OUT, 0, PTE5_IN,
		PTE4_FN, PTE4_OUT, 0, PTE4_IN,
		PTE3_FN, PTE3_OUT, 0, PTE3_IN,
		PTE2_FN, PTE2_OUT, 0, PTE2_IN,
		PTE1_FN, PTE1_OUT, 0, PTE1_IN,
		PTE0_FN, PTE0_OUT, 0, PTE0_IN }
	},
	{ PINMUX_CFG_REG("PFCR", 0xa405010a, 16, 2) {
		PTF7_FN, PTF7_OUT, 0, PTF7_IN,
		PTF6_FN, PTF6_OUT, 0, PTF6_IN,
		PTF5_FN, PTF5_OUT, 0, PTF5_IN,
		PTF4_FN, PTF4_OUT, 0, PTF4_IN,
		PTF3_FN, PTF3_OUT, 0, PTF3_IN,
		PTF2_FN, PTF2_OUT, 0, PTF2_IN,
		PTF1_FN, PTF1_OUT, 0, PTF1_IN,
		PTF0_FN, PTF0_OUT, 0, PTF0_IN }
	},
	{ PINMUX_CFG_REG("PGCR", 0xa405010c, 16, 2) {
		0, 0, 0, 0,
		0, 0, 0, 0,
		PTG5_FN, PTG5_OUT, 0, 0,
		PTG4_FN, PTG4_OUT, 0, 0,
		PTG3_FN, PTG3_OUT, 0, 0,
		PTG2_FN, PTG2_OUT, 0, 0,
		PTG1_FN, PTG1_OUT, 0, 0,
		PTG0_FN, PTG0_OUT, 0, 0 }
	},
	{ PINMUX_CFG_REG("PHCR", 0xa405010e, 16, 2) {
		PTH7_FN, PTH7_OUT, 0, PTH7_IN,
		PTH6_FN, PTH6_OUT, 0, PTH6_IN,
		PTH5_FN, PTH5_OUT, 0, PTH5_IN,
		PTH4_FN, PTH4_OUT, 0, PTH4_IN,
		PTH3_FN, PTH3_OUT, 0, PTH3_IN,
		PTH2_FN, PTH2_OUT, 0, PTH2_IN,
		PTH1_FN, PTH1_OUT, 0, PTH1_IN,
		PTH0_FN, PTH0_OUT, 0, PTH0_IN }
	},
	{ PINMUX_CFG_REG("PJCR", 0xa4050110, 16, 2) {
		PTJ7_FN, PTJ7_OUT, 0, 0,
		PTJ6_FN, PTJ6_OUT, 0, 0,
		PTJ5_FN, PTJ5_OUT, 0, 0,
		0, 0, 0, 0,
		PTJ3_FN, PTJ3_OUT, 0, PTJ3_IN,
		PTJ2_FN, PTJ2_OUT, 0, PTJ2_IN,
		PTJ1_FN, PTJ1_OUT, 0, PTJ1_IN,
		PTJ0_FN, PTJ0_OUT, 0, PTJ0_IN }
	},
	{ PINMUX_CFG_REG("PKCR", 0xa4050112, 16, 2) {
		PTK7_FN, PTK7_OUT, 0, PTK7_IN,
		PTK6_FN, PTK6_OUT, 0, PTK6_IN,
		PTK5_FN, PTK5_OUT, 0, PTK5_IN,
		PTK4_FN, PTK4_OUT, 0, PTK4_IN,
		PTK3_FN, PTK3_OUT, 0, PTK3_IN,
		PTK2_FN, PTK2_OUT, 0, PTK2_IN,
		PTK1_FN, PTK1_OUT, 0, PTK1_IN,
		PTK0_FN, PTK0_OUT, 0, PTK0_IN }
	},
	{ PINMUX_CFG_REG("PLCR", 0xa4050114, 16, 2) {
		PTL7_FN, PTL7_OUT, 0, PTL7_IN,
		PTL6_FN, PTL6_OUT, 0, PTL6_IN,
		PTL5_FN, PTL5_OUT, 0, PTL5_IN,
		PTL4_FN, PTL4_OUT, 0, PTL4_IN,
		PTL3_FN, PTL3_OUT, 0, PTL3_IN,
		PTL2_FN, PTL2_OUT, 0, PTL2_IN,
		PTL1_FN, PTL1_OUT, 0, PTL1_IN,
		PTL0_FN, PTL0_OUT, 0, PTL0_IN }
	},
	{ PINMUX_CFG_REG("PMCR", 0xa4050116, 16, 2) {
		PTM7_FN, PTM7_OUT, 0, PTM7_IN,
		PTM6_FN, PTM6_OUT, 0, PTM6_IN,
		PTM5_FN, PTM5_OUT, 0, PTM5_IN,
		PTM4_FN, PTM4_OUT, 0, PTM4_IN,
		PTM3_FN, PTM3_OUT, 0, PTM3_IN,
		PTM2_FN, PTM2_OUT, 0, PTM2_IN,
		PTM1_FN, PTM1_OUT, 0, PTM1_IN,
		PTM0_FN, PTM0_OUT, 0, PTM0_IN }
	},
	{ PINMUX_CFG_REG("PNCR", 0xa4050118, 16, 2) {
		PTN7_FN, PTN7_OUT, 0, PTN7_IN,
		PTN6_FN, PTN6_OUT, 0, PTN6_IN,
		PTN5_FN, PTN5_OUT, 0, PTN5_IN,
		PTN4_FN, PTN4_OUT, 0, PTN4_IN,
		PTN3_FN, PTN3_OUT, 0, PTN3_IN,
		PTN2_FN, PTN2_OUT, 0, PTN2_IN,
		PTN1_FN, PTN1_OUT, 0, PTN1_IN,
		PTN0_FN, PTN0_OUT, 0, PTN0_IN }
	},
	{ PINMUX_CFG_REG("PQCR", 0xa405011a, 16, 2) {
		PTQ7_FN, PTQ7_OUT, 0, PTQ7_IN,
		PTQ6_FN, PTQ6_OUT, 0, PTQ6_IN,
		PTQ5_FN, PTQ5_OUT, 0, PTQ5_IN,
		PTQ4_FN, PTQ4_OUT, 0, PTQ4_IN,
		PTQ3_FN, PTQ3_OUT, 0, PTQ3_IN,
		PTQ2_FN, PTQ2_OUT, 0, PTQ2_IN,
		PTQ1_FN, PTQ1_OUT, 0, PTQ1_IN,
		PTQ0_FN, PTQ0_OUT, 0, PTQ0_IN }
	},
	{ PINMUX_CFG_REG("PRCR", 0xa405011c, 16, 2) {
		PTR7_FN, PTR7_OUT, 0, PTR7_IN,
		PTR6_FN, PTR6_OUT, 0, PTR6_IN,
		PTR5_FN, PTR5_OUT, 0, PTR5_IN,
		PTR4_FN, PTR4_OUT, 0, PTR4_IN,
		PTR3_FN, 0,        0, PTR3_IN,
		PTR2_FN, 0,        0, PTR2_IN,
		PTR1_FN, PTR1_OUT, 0, PTR1_IN,
		PTR0_FN, PTR0_OUT, 0, PTR0_IN }
	},
	{ PINMUX_CFG_REG("PSCR", 0xa405011e, 16, 2) {
		0, 0, 0, 0,
		PTS6_FN, PTS6_OUT, 0, PTS6_IN,
		PTS5_FN, PTS5_OUT, 0, PTS5_IN,
		PTS4_FN, PTS4_OUT, 0, PTS4_IN,
		PTS3_FN, PTS3_OUT, 0, PTS3_IN,
		PTS2_FN, PTS2_OUT, 0, PTS2_IN,
		PTS1_FN, PTS1_OUT, 0, PTS1_IN,
		PTS0_FN, PTS0_OUT, 0, PTS0_IN }
	},
	{ PINMUX_CFG_REG("PTCR", 0xa4050140, 16, 2) {
		PTT7_FN, PTT7_OUT, 0, PTT7_IN,
		PTT6_FN, PTT6_OUT, 0, PTT6_IN,
		PTT5_FN, PTT5_OUT, 0, PTT5_IN,
		PTT4_FN, PTT4_OUT, 0, PTT4_IN,
		PTT3_FN, PTT3_OUT, 0, PTT3_IN,
		PTT2_FN, PTT2_OUT, 0, PTT2_IN,
		PTT1_FN, PTT1_OUT, 0, PTT1_IN,
		PTT0_FN, PTT0_OUT, 0, PTT0_IN }
	},
	{ PINMUX_CFG_REG("PUCR", 0xa4050142, 16, 2) {
		PTU7_FN, PTU7_OUT, 0, PTU7_IN,
		PTU6_FN, PTU6_OUT, 0, PTU6_IN,
		PTU5_FN, PTU5_OUT, 0, PTU5_IN,
		PTU4_FN, PTU4_OUT, 0, PTU4_IN,
		PTU3_FN, PTU3_OUT, 0, PTU3_IN,
		PTU2_FN, PTU2_OUT, 0, PTU2_IN,
		PTU1_FN, PTU1_OUT, 0, PTU1_IN,
		PTU0_FN, PTU0_OUT, 0, PTU0_IN }
	},
	{ PINMUX_CFG_REG("PVCR", 0xa4050144, 16, 2) {
		PTV7_FN, PTV7_OUT, 0, PTV7_IN,
		PTV6_FN, PTV6_OUT, 0, PTV6_IN,
		PTV5_FN, PTV5_OUT, 0, PTV5_IN,
		PTV4_FN, PTV4_OUT, 0, PTV4_IN,
		PTV3_FN, PTV3_OUT, 0, PTV3_IN,
		PTV2_FN, PTV2_OUT, 0, PTV2_IN,
		PTV1_FN, PTV1_OUT, 0, PTV1_IN,
		PTV0_FN, PTV0_OUT, 0, PTV0_IN }
	},
	{ PINMUX_CFG_REG("PWCR", 0xa4050146, 16, 2) {
		PTW7_FN, PTW7_OUT, 0, PTW7_IN,
		PTW6_FN, PTW6_OUT, 0, PTW6_IN,
		PTW5_FN, PTW5_OUT, 0, PTW5_IN,
		PTW4_FN, PTW4_OUT, 0, PTW4_IN,
		PTW3_FN, PTW3_OUT, 0, PTW3_IN,
		PTW2_FN, PTW2_OUT, 0, PTW2_IN,
		PTW1_FN, PTW1_OUT, 0, PTW1_IN,
		PTW0_FN, PTW0_OUT, 0, PTW0_IN }
	},
	{ PINMUX_CFG_REG("PXCR", 0xa4050148, 16, 2) {
		PTX7_FN, PTX7_OUT, 0, PTX7_IN,
		PTX6_FN, PTX6_OUT, 0, PTX6_IN,
		PTX5_FN, PTX5_OUT, 0, PTX5_IN,
		PTX4_FN, PTX4_OUT, 0, PTX4_IN,
		PTX3_FN, PTX3_OUT, 0, PTX3_IN,
		PTX2_FN, PTX2_OUT, 0, PTX2_IN,
		PTX1_FN, PTX1_OUT, 0, PTX1_IN,
		PTX0_FN, PTX0_OUT, 0, PTX0_IN }
	},
	{ PINMUX_CFG_REG("PYCR", 0xa405014a, 16, 2) {
		PTY7_FN, PTY7_OUT, 0, PTY7_IN,
		PTY6_FN, PTY6_OUT, 0, PTY6_IN,
		PTY5_FN, PTY5_OUT, 0, PTY5_IN,
		PTY4_FN, PTY4_OUT, 0, PTY4_IN,
		PTY3_FN, PTY3_OUT, 0, PTY3_IN,
		PTY2_FN, PTY2_OUT, 0, PTY2_IN,
		PTY1_FN, PTY1_OUT, 0, PTY1_IN,
		PTY0_FN, PTY0_OUT, 0, PTY0_IN }
	},
	{ PINMUX_CFG_REG("PZCR", 0xa405014c, 16, 2) {
		PTZ7_FN, PTZ7_OUT, 0, PTZ7_IN,
		PTZ6_FN, PTZ6_OUT, 0, PTZ6_IN,
		PTZ5_FN, PTZ5_OUT, 0, PTZ5_IN,
		PTZ4_FN, PTZ4_OUT, 0, PTZ4_IN,
		PTZ3_FN, PTZ3_OUT, 0, PTZ3_IN,
		PTZ2_FN, PTZ2_OUT, 0, PTZ2_IN,
		PTZ1_FN, PTZ1_OUT, 0, PTZ1_IN,
		PTZ0_FN, PTZ0_OUT, 0, PTZ0_IN }
	},
	{ PINMUX_CFG_REG("PSELA", 0xa405014e, 16, 1) {
		PSA15_0, PSA15_1,
		PSA14_0, PSA14_1,
		PSA13_0, PSA13_1,
		PSA12_0, PSA12_1,
		0, 0,
		PSA10_0, PSA10_1,
		PSA9_0,  PSA9_1,
		PSA8_0,  PSA8_1,
		PSA7_0,  PSA7_1,
		PSA6_0,  PSA6_1,
		PSA5_0,  PSA5_1,
		0, 0,
		PSA3_0,  PSA3_1,
		PSA2_0,  PSA2_1,
		PSA1_0,  PSA1_1,
		PSA0_0,  PSA0_1}
	},
	{ PINMUX_CFG_REG("PSELB", 0xa4050150, 16, 1) {
		0, 0,
		PSB14_0, PSB14_1,
		PSB13_0, PSB13_1,
		PSB12_0, PSB12_1,
		PSB11_0, PSB11_1,
		PSB10_0, PSB10_1,
		PSB9_0,  PSB9_1,
		PSB8_0,  PSB8_1,
		PSB7_0,  PSB7_1,
		PSB6_0,  PSB6_1,
		PSB5_0,  PSB5_1,
		PSB4_0,  PSB4_1,
		PSB3_0,  PSB3_1,
		PSB2_0,  PSB2_1,
		PSB1_0,  PSB1_1,
		PSB0_0,  PSB0_1}
	},
	{ PINMUX_CFG_REG("PSELC", 0xa4050152, 16, 1) {
		PSC15_0, PSC15_1,
		PSC14_0, PSC14_1,
		PSC13_0, PSC13_1,
		PSC12_0, PSC12_1,
		PSC11_0, PSC11_1,
		PSC10_0, PSC10_1,
		PSC9_0,  PSC9_1,
		PSC8_0,  PSC8_1,
		PSC7_0,  PSC7_1,
		PSC6_0,  PSC6_1,
		PSC5_0,  PSC5_1,
		PSC4_0,  PSC4_1,
		0, 0,
		PSC2_0,  PSC2_1,
		PSC1_0,  PSC1_1,
		PSC0_0,  PSC0_1}
	},
	{ PINMUX_CFG_REG("PSELD", 0xa4050154, 16, 1) {
		PSD15_0, PSD15_1,
		PSD14_0, PSD14_1,
		PSD13_0, PSD13_1,
		PSD12_0, PSD12_1,
		PSD11_0, PSD11_1,
		PSD10_0, PSD10_1,
		PSD9_0,  PSD9_1,
		PSD8_0,  PSD8_1,
		PSD7_0,  PSD7_1,
		PSD6_0,  PSD6_1,
		PSD5_0,  PSD5_1,
		PSD4_0,  PSD4_1,
		PSD3_0,  PSD3_1,
		PSD2_0,  PSD2_1,
		PSD1_0,  PSD1_1,
		PSD0_0,  PSD0_1}
	},
	{ PINMUX_CFG_REG("PSELE", 0xa4050156, 16, 1) {
		PSE15_0, PSE15_1,
		PSE14_0, PSE14_1,
		PSE13_0, PSE13_1,
		PSE12_0, PSE12_1,
		PSE11_0, PSE11_1,
		PSE10_0, PSE10_1,
		PSE9_0,  PSE9_1,
		PSE8_0,  PSE8_1,
		PSE7_0,  PSE7_1,
		PSE6_0,  PSE6_1,
		PSE5_0,  PSE5_1,
		PSE4_0,  PSE4_1,
		PSE3_0,  PSE3_1,
		PSE2_0,  PSE2_1,
		PSE1_0,  PSE1_1,
		PSE0_0,  PSE0_1}
	},
	{}
};

static const struct pinmux_data_reg pinmux_data_regs[] = {
	{ PINMUX_DATA_REG("PADR", 0xa4050120, 8) {
		PTA7_DATA, PTA6_DATA, PTA5_DATA, PTA4_DATA,
		PTA3_DATA, PTA2_DATA, PTA1_DATA, PTA0_DATA }
	},
	{ PINMUX_DATA_REG("PBDR", 0xa4050122, 8) {
		PTB7_DATA, PTB6_DATA, PTB5_DATA, PTB4_DATA,
		PTB3_DATA, PTB2_DATA, PTB1_DATA, PTB0_DATA }
	},
	{ PINMUX_DATA_REG("PCDR", 0xa4050124, 8) {
		PTC7_DATA, PTC6_DATA, PTC5_DATA, PTC4_DATA,
		PTC3_DATA, PTC2_DATA, PTC1_DATA, PTC0_DATA }
	},
	{ PINMUX_DATA_REG("PDDR", 0xa4050126, 8) {
		PTD7_DATA, PTD6_DATA, PTD5_DATA, PTD4_DATA,
		PTD3_DATA, PTD2_DATA, PTD1_DATA, PTD0_DATA }
	},
	{ PINMUX_DATA_REG("PEDR", 0xa4050128, 8) {
		PTE7_DATA, PTE6_DATA, PTE5_DATA, PTE4_DATA,
		PTE3_DATA, PTE2_DATA, PTE1_DATA, PTE0_DATA }
	},
	{ PINMUX_DATA_REG("PFDR", 0xa405012a, 8) {
		PTF7_DATA, PTF6_DATA, PTF5_DATA, PTF4_DATA,
		PTF3_DATA, PTF2_DATA, PTF1_DATA, PTF0_DATA }
	},
	{ PINMUX_DATA_REG("PGDR", 0xa405012c, 8) {
		0,         0,         PTG5_DATA, PTG4_DATA,
		PTG3_DATA, PTG2_DATA, PTG1_DATA, PTG0_DATA }
	},
	{ PINMUX_DATA_REG("PHDR", 0xa405012e, 8) {
		PTH7_DATA, PTH6_DATA, PTH5_DATA, PTH4_DATA,
		PTH3_DATA, PTH2_DATA, PTH1_DATA, PTH0_DATA }
	},
	{ PINMUX_DATA_REG("PJDR", 0xa4050130, 8) {
		PTJ7_DATA, PTJ6_DATA, PTJ5_DATA, 0,
		PTJ3_DATA, PTJ2_DATA, PTJ1_DATA, PTJ0_DATA }
	},
	{ PINMUX_DATA_REG("PKDR", 0xa4050132, 8) {
		PTK7_DATA, PTK6_DATA, PTK5_DATA, PTK4_DATA,
		PTK3_DATA, PTK2_DATA, PTK1_DATA, PTK0_DATA }
	},
	{ PINMUX_DATA_REG("PLDR", 0xa4050134, 8) {
		PTL7_DATA, PTL6_DATA, PTL5_DATA, PTL4_DATA,
		PTL3_DATA, PTL2_DATA, PTL1_DATA, PTL0_DATA }
	},
	{ PINMUX_DATA_REG("PMDR", 0xa4050136, 8) {
		PTM7_DATA, PTM6_DATA, PTM5_DATA, PTM4_DATA,
		PTM3_DATA, PTM2_DATA, PTM1_DATA, PTM0_DATA }
	},
	{ PINMUX_DATA_REG("PNDR", 0xa4050138, 8) {
		PTN7_DATA, PTN6_DATA, PTN5_DATA, PTN4_DATA,
		PTN3_DATA, PTN2_DATA, PTN1_DATA, PTN0_DATA }
	},
	{ PINMUX_DATA_REG("PQDR", 0xa405013a, 8) {
		PTQ7_DATA, PTQ6_DATA, PTQ5_DATA, PTQ4_DATA,
		PTQ3_DATA, PTQ2_DATA, PTQ1_DATA, PTQ0_DATA }
	},
	{ PINMUX_DATA_REG("PRDR", 0xa405013c, 8) {
		PTR7_DATA, PTR6_DATA, PTR5_DATA, PTR4_DATA,
		PTR3_DATA, PTR2_DATA, PTR1_DATA, PTR0_DATA }
	},
	{ PINMUX_DATA_REG("PSDR", 0xa405013e, 8) {
		0,         PTS6_DATA, PTS5_DATA, PTS4_DATA,
		PTS3_DATA, PTS2_DATA, PTS1_DATA, PTS0_DATA }
	},
	{ PINMUX_DATA_REG("PTDR", 0xa4050160, 8) {
		PTT7_DATA, PTT6_DATA, PTT5_DATA, PTT4_DATA,
		PTT3_DATA, PTT2_DATA, PTT1_DATA, PTT0_DATA }
	},
	{ PINMUX_DATA_REG("PUDR", 0xa4050162, 8) {
		PTU7_DATA, PTU6_DATA, PTU5_DATA, PTU4_DATA,
		PTU3_DATA, PTU2_DATA, PTU1_DATA, PTU0_DATA }
	},
	{ PINMUX_DATA_REG("PVDR", 0xa4050164, 8) {
		PTV7_DATA, PTV6_DATA, PTV5_DATA, PTV4_DATA,
		PTV3_DATA, PTV2_DATA, PTV1_DATA, PTV0_DATA }
	},
	{ PINMUX_DATA_REG("PWDR", 0xa4050166, 8) {
		PTW7_DATA, PTW6_DATA, PTW5_DATA, PTW4_DATA,
		PTW3_DATA, PTW2_DATA, PTW1_DATA, PTW0_DATA }
	},
	{ PINMUX_DATA_REG("PXDR", 0xa4050168, 8) {
		PTX7_DATA, PTX6_DATA, PTX5_DATA, PTX4_DATA,
		PTX3_DATA, PTX2_DATA, PTX1_DATA, PTX0_DATA }
	},
	{ PINMUX_DATA_REG("PYDR", 0xa405016a, 8) {
		PTY7_DATA, PTY6_DATA, PTY5_DATA, PTY4_DATA,
		PTY3_DATA, PTY2_DATA, PTY1_DATA, PTY0_DATA }
	},
	{ PINMUX_DATA_REG("PZDR", 0xa405016c, 8) {
		PTZ7_DATA, PTZ6_DATA, PTZ5_DATA, PTZ4_DATA,
		PTZ3_DATA, PTZ2_DATA, PTZ1_DATA, PTZ0_DATA }
	},
	{ },
};

const struct sh_pfc_soc_info sh7724_pinmux_info = {
	.name = "sh7724_pfc",
	.input = { PINMUX_INPUT_BEGIN, PINMUX_INPUT_END },
	.output = { PINMUX_OUTPUT_BEGIN, PINMUX_OUTPUT_END },
	.function = { PINMUX_FUNCTION_BEGIN, PINMUX_FUNCTION_END },

	.pins = pinmux_pins,
	.nr_pins = ARRAY_SIZE(pinmux_pins),
	.func_gpios = pinmux_func_gpios,
	.nr_func_gpios = ARRAY_SIZE(pinmux_func_gpios),

	.cfg_regs = pinmux_config_regs,
	.data_regs = pinmux_data_regs,

	.gpio_data = pinmux_data,
	.gpio_data_size = ARRAY_SIZE(pinmux_data),
};
