// SPDX-License-Identifier: GPL-2.0

// Generated by scripts/atomic/gen-atomic-instrumented.sh
// DO NOT MODIFY THIS FILE DIRECTLY

/*
 * This file provides wrappers with KASAN instrumentation for atomic operations.
 * To use this functionality an arch's atomic.h file needs to define all
 * atomic operations with arch_ prefix (e.g. arch_atomic_read()) and include
 * this file at the end. This file provides atomic_read() that forwards to
 * arch_atomic_read() for actual atomic operation.
 * Note: if an arch atomic operation is implemented by means of other atomic
 * operations (e.g. atomic_read()/atomic_cmpxchg() loop), then it needs to use
 * arch_ variants (i.e. arch_atomic_read()/arch_atomic_cmpxchg()) to avoid
 * double instrumentation.
 */
#ifndef _LINUX_ATOMIC_INSTRUMENTED_H
#define _LINUX_ATOMIC_INSTRUMENTED_H

#include <linux/build_bug.h>
#include <linux/compiler.h>
#include <linux/instrumented.h>

static __always_inline int
atomic_read(const atomic_t *v)
{
	instrument_atomic_read(v, sizeof(*v));
	return arch_atomic_read(v);
}

static __always_inline int
atomic_read_acquire(const atomic_t *v)
{
	instrument_atomic_read(v, sizeof(*v));
	return arch_atomic_read_acquire(v);
}

static __always_inline void
atomic_set(atomic_t *v, int i)
{
	instrument_atomic_write(v, sizeof(*v));
	arch_atomic_set(v, i);
}

static __always_inline void
atomic_set_release(atomic_t *v, int i)
{
	kcsan_release();
	instrument_atomic_write(v, sizeof(*v));
	arch_atomic_set_release(v, i);
}

static __always_inline void
atomic_add(int i, atomic_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	arch_atomic_add(i, v);
}

static __always_inline int
atomic_add_return(int i, atomic_t *v)
{
	kcsan_mb();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_add_return(i, v);
}

static __always_inline int
atomic_add_return_acquire(int i, atomic_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_add_return_acquire(i, v);
}

static __always_inline int
atomic_add_return_release(int i, atomic_t *v)
{
	kcsan_release();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_add_return_release(i, v);
}

static __always_inline int
atomic_add_return_relaxed(int i, atomic_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_add_return_relaxed(i, v);
}

static __always_inline int
atomic_fetch_add(int i, atomic_t *v)
{
	kcsan_mb();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_fetch_add(i, v);
}

static __always_inline int
atomic_fetch_add_acquire(int i, atomic_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_fetch_add_acquire(i, v);
}

static __always_inline int
atomic_fetch_add_release(int i, atomic_t *v)
{
	kcsan_release();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_fetch_add_release(i, v);
}

static __always_inline int
atomic_fetch_add_relaxed(int i, atomic_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_fetch_add_relaxed(i, v);
}

static __always_inline void
atomic_sub(int i, atomic_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	arch_atomic_sub(i, v);
}

static __always_inline int
atomic_sub_return(int i, atomic_t *v)
{
	kcsan_mb();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_sub_return(i, v);
}

static __always_inline int
atomic_sub_return_acquire(int i, atomic_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_sub_return_acquire(i, v);
}

static __always_inline int
atomic_sub_return_release(int i, atomic_t *v)
{
	kcsan_release();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_sub_return_release(i, v);
}

static __always_inline int
atomic_sub_return_relaxed(int i, atomic_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_sub_return_relaxed(i, v);
}

static __always_inline int
atomic_fetch_sub(int i, atomic_t *v)
{
	kcsan_mb();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_fetch_sub(i, v);
}

static __always_inline int
atomic_fetch_sub_acquire(int i, atomic_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_fetch_sub_acquire(i, v);
}

static __always_inline int
atomic_fetch_sub_release(int i, atomic_t *v)
{
	kcsan_release();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_fetch_sub_release(i, v);
}

static __always_inline int
atomic_fetch_sub_relaxed(int i, atomic_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_fetch_sub_relaxed(i, v);
}

static __always_inline void
atomic_inc(atomic_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	arch_atomic_inc(v);
}

static __always_inline int
atomic_inc_return(atomic_t *v)
{
	kcsan_mb();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_inc_return(v);
}

static __always_inline int
atomic_inc_return_acquire(atomic_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_inc_return_acquire(v);
}

static __always_inline int
atomic_inc_return_release(atomic_t *v)
{
	kcsan_release();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_inc_return_release(v);
}

static __always_inline int
atomic_inc_return_relaxed(atomic_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_inc_return_relaxed(v);
}

static __always_inline int
atomic_fetch_inc(atomic_t *v)
{
	kcsan_mb();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_fetch_inc(v);
}

static __always_inline int
atomic_fetch_inc_acquire(atomic_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_fetch_inc_acquire(v);
}

static __always_inline int
atomic_fetch_inc_release(atomic_t *v)
{
	kcsan_release();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_fetch_inc_release(v);
}

static __always_inline int
atomic_fetch_inc_relaxed(atomic_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_fetch_inc_relaxed(v);
}

static __always_inline void
atomic_dec(atomic_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	arch_atomic_dec(v);
}

static __always_inline int
atomic_dec_return(atomic_t *v)
{
	kcsan_mb();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_dec_return(v);
}

static __always_inline int
atomic_dec_return_acquire(atomic_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_dec_return_acquire(v);
}

static __always_inline int
atomic_dec_return_release(atomic_t *v)
{
	kcsan_release();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_dec_return_release(v);
}

static __always_inline int
atomic_dec_return_relaxed(atomic_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_dec_return_relaxed(v);
}

static __always_inline int
atomic_fetch_dec(atomic_t *v)
{
	kcsan_mb();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_fetch_dec(v);
}

static __always_inline int
atomic_fetch_dec_acquire(atomic_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_fetch_dec_acquire(v);
}

static __always_inline int
atomic_fetch_dec_release(atomic_t *v)
{
	kcsan_release();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_fetch_dec_release(v);
}

static __always_inline int
atomic_fetch_dec_relaxed(atomic_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_fetch_dec_relaxed(v);
}

static __always_inline void
atomic_and(int i, atomic_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	arch_atomic_and(i, v);
}

static __always_inline int
atomic_fetch_and(int i, atomic_t *v)
{
	kcsan_mb();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_fetch_and(i, v);
}

static __always_inline int
atomic_fetch_and_acquire(int i, atomic_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_fetch_and_acquire(i, v);
}

static __always_inline int
atomic_fetch_and_release(int i, atomic_t *v)
{
	kcsan_release();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_fetch_and_release(i, v);
}

static __always_inline int
atomic_fetch_and_relaxed(int i, atomic_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_fetch_and_relaxed(i, v);
}

static __always_inline void
atomic_andnot(int i, atomic_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	arch_atomic_andnot(i, v);
}

static __always_inline int
atomic_fetch_andnot(int i, atomic_t *v)
{
	kcsan_mb();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_fetch_andnot(i, v);
}

static __always_inline int
atomic_fetch_andnot_acquire(int i, atomic_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_fetch_andnot_acquire(i, v);
}

static __always_inline int
atomic_fetch_andnot_release(int i, atomic_t *v)
{
	kcsan_release();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_fetch_andnot_release(i, v);
}

static __always_inline int
atomic_fetch_andnot_relaxed(int i, atomic_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_fetch_andnot_relaxed(i, v);
}

static __always_inline void
atomic_or(int i, atomic_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	arch_atomic_or(i, v);
}

static __always_inline int
atomic_fetch_or(int i, atomic_t *v)
{
	kcsan_mb();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_fetch_or(i, v);
}

static __always_inline int
atomic_fetch_or_acquire(int i, atomic_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_fetch_or_acquire(i, v);
}

static __always_inline int
atomic_fetch_or_release(int i, atomic_t *v)
{
	kcsan_release();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_fetch_or_release(i, v);
}

static __always_inline int
atomic_fetch_or_relaxed(int i, atomic_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_fetch_or_relaxed(i, v);
}

static __always_inline void
atomic_xor(int i, atomic_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	arch_atomic_xor(i, v);
}

static __always_inline int
atomic_fetch_xor(int i, atomic_t *v)
{
	kcsan_mb();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_fetch_xor(i, v);
}

static __always_inline int
atomic_fetch_xor_acquire(int i, atomic_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_fetch_xor_acquire(i, v);
}

static __always_inline int
atomic_fetch_xor_release(int i, atomic_t *v)
{
	kcsan_release();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_fetch_xor_release(i, v);
}

static __always_inline int
atomic_fetch_xor_relaxed(int i, atomic_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_fetch_xor_relaxed(i, v);
}

static __always_inline int
atomic_xchg(atomic_t *v, int i)
{
	kcsan_mb();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_xchg(v, i);
}

static __always_inline int
atomic_xchg_acquire(atomic_t *v, int i)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_xchg_acquire(v, i);
}

static __always_inline int
atomic_xchg_release(atomic_t *v, int i)
{
	kcsan_release();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_xchg_release(v, i);
}

static __always_inline int
atomic_xchg_relaxed(atomic_t *v, int i)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_xchg_relaxed(v, i);
}

static __always_inline int
atomic_cmpxchg(atomic_t *v, int old, int new)
{
	kcsan_mb();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_cmpxchg(v, old, new);
}

static __always_inline int
atomic_cmpxchg_acquire(atomic_t *v, int old, int new)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_cmpxchg_acquire(v, old, new);
}

static __always_inline int
atomic_cmpxchg_release(atomic_t *v, int old, int new)
{
	kcsan_release();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_cmpxchg_release(v, old, new);
}

static __always_inline int
atomic_cmpxchg_relaxed(atomic_t *v, int old, int new)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_cmpxchg_relaxed(v, old, new);
}

static __always_inline bool
atomic_try_cmpxchg(atomic_t *v, int *old, int new)
{
	kcsan_mb();
	instrument_atomic_read_write(v, sizeof(*v));
	instrument_atomic_read_write(old, sizeof(*old));
	return arch_atomic_try_cmpxchg(v, old, new);
}

static __always_inline bool
atomic_try_cmpxchg_acquire(atomic_t *v, int *old, int new)
{
	instrument_atomic_read_write(v, sizeof(*v));
	instrument_atomic_read_write(old, sizeof(*old));
	return arch_atomic_try_cmpxchg_acquire(v, old, new);
}

static __always_inline bool
atomic_try_cmpxchg_release(atomic_t *v, int *old, int new)
{
	kcsan_release();
	instrument_atomic_read_write(v, sizeof(*v));
	instrument_atomic_read_write(old, sizeof(*old));
	return arch_atomic_try_cmpxchg_release(v, old, new);
}

static __always_inline bool
atomic_try_cmpxchg_relaxed(atomic_t *v, int *old, int new)
{
	instrument_atomic_read_write(v, sizeof(*v));
	instrument_atomic_read_write(old, sizeof(*old));
	return arch_atomic_try_cmpxchg_relaxed(v, old, new);
}

static __always_inline bool
atomic_sub_and_test(int i, atomic_t *v)
{
	kcsan_mb();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_sub_and_test(i, v);
}

static __always_inline bool
atomic_dec_and_test(atomic_t *v)
{
	kcsan_mb();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_dec_and_test(v);
}

static __always_inline bool
atomic_inc_and_test(atomic_t *v)
{
	kcsan_mb();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_inc_and_test(v);
}

static __always_inline bool
atomic_add_negative(int i, atomic_t *v)
{
	kcsan_mb();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_add_negative(i, v);
}

static __always_inline int
atomic_fetch_add_unless(atomic_t *v, int a, int u)
{
	kcsan_mb();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_fetch_add_unless(v, a, u);
}

static __always_inline bool
atomic_add_unless(atomic_t *v, int a, int u)
{
	kcsan_mb();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_add_unless(v, a, u);
}

static __always_inline bool
atomic_inc_not_zero(atomic_t *v)
{
	kcsan_mb();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_inc_not_zero(v);
}

static __always_inline bool
atomic_inc_unless_negative(atomic_t *v)
{
	kcsan_mb();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_inc_unless_negative(v);
}

static __always_inline bool
atomic_dec_unless_positive(atomic_t *v)
{
	kcsan_mb();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_dec_unless_positive(v);
}

static __always_inline int
atomic_dec_if_positive(atomic_t *v)
{
	kcsan_mb();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_dec_if_positive(v);
}

static __always_inline s64
atomic64_read(const atomic64_t *v)
{
	instrument_atomic_read(v, sizeof(*v));
	return arch_atomic64_read(v);
}

static __always_inline s64
atomic64_read_acquire(const atomic64_t *v)
{
	instrument_atomic_read(v, sizeof(*v));
	return arch_atomic64_read_acquire(v);
}

static __always_inline void
atomic64_set(atomic64_t *v, s64 i)
{
	instrument_atomic_write(v, sizeof(*v));
	arch_atomic64_set(v, i);
}

static __always_inline void
atomic64_set_release(atomic64_t *v, s64 i)
{
	kcsan_release();
	instrument_atomic_write(v, sizeof(*v));
	arch_atomic64_set_release(v, i);
}

static __always_inline void
atomic64_add(s64 i, atomic64_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	arch_atomic64_add(i, v);
}

static __always_inline s64
atomic64_add_return(s64 i, atomic64_t *v)
{
	kcsan_mb();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic64_add_return(i, v);
}

static __always_inline s64
atomic64_add_return_acquire(s64 i, atomic64_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic64_add_return_acquire(i, v);
}

static __always_inline s64
atomic64_add_return_release(s64 i, atomic64_t *v)
{
	kcsan_release();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic64_add_return_release(i, v);
}

static __always_inline s64
atomic64_add_return_relaxed(s64 i, atomic64_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic64_add_return_relaxed(i, v);
}

static __always_inline s64
atomic64_fetch_add(s64 i, atomic64_t *v)
{
	kcsan_mb();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic64_fetch_add(i, v);
}

static __always_inline s64
atomic64_fetch_add_acquire(s64 i, atomic64_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic64_fetch_add_acquire(i, v);
}

static __always_inline s64
atomic64_fetch_add_release(s64 i, atomic64_t *v)
{
	kcsan_release();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic64_fetch_add_release(i, v);
}

static __always_inline s64
atomic64_fetch_add_relaxed(s64 i, atomic64_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic64_fetch_add_relaxed(i, v);
}

static __always_inline void
atomic64_sub(s64 i, atomic64_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	arch_atomic64_sub(i, v);
}

static __always_inline s64
atomic64_sub_return(s64 i, atomic64_t *v)
{
	kcsan_mb();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic64_sub_return(i, v);
}

static __always_inline s64
atomic64_sub_return_acquire(s64 i, atomic64_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic64_sub_return_acquire(i, v);
}

static __always_inline s64
atomic64_sub_return_release(s64 i, atomic64_t *v)
{
	kcsan_release();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic64_sub_return_release(i, v);
}

static __always_inline s64
atomic64_sub_return_relaxed(s64 i, atomic64_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic64_sub_return_relaxed(i, v);
}

static __always_inline s64
atomic64_fetch_sub(s64 i, atomic64_t *v)
{
	kcsan_mb();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic64_fetch_sub(i, v);
}

static __always_inline s64
atomic64_fetch_sub_acquire(s64 i, atomic64_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic64_fetch_sub_acquire(i, v);
}

static __always_inline s64
atomic64_fetch_sub_release(s64 i, atomic64_t *v)
{
	kcsan_release();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic64_fetch_sub_release(i, v);
}

static __always_inline s64
atomic64_fetch_sub_relaxed(s64 i, atomic64_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic64_fetch_sub_relaxed(i, v);
}

static __always_inline void
atomic64_inc(atomic64_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	arch_atomic64_inc(v);
}

static __always_inline s64
atomic64_inc_return(atomic64_t *v)
{
	kcsan_mb();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic64_inc_return(v);
}

static __always_inline s64
atomic64_inc_return_acquire(atomic64_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic64_inc_return_acquire(v);
}

static __always_inline s64
atomic64_inc_return_release(atomic64_t *v)
{
	kcsan_release();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic64_inc_return_release(v);
}

static __always_inline s64
atomic64_inc_return_relaxed(atomic64_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic64_inc_return_relaxed(v);
}

static __always_inline s64
atomic64_fetch_inc(atomic64_t *v)
{
	kcsan_mb();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic64_fetch_inc(v);
}

static __always_inline s64
atomic64_fetch_inc_acquire(atomic64_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic64_fetch_inc_acquire(v);
}

static __always_inline s64
atomic64_fetch_inc_release(atomic64_t *v)
{
	kcsan_release();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic64_fetch_inc_release(v);
}

static __always_inline s64
atomic64_fetch_inc_relaxed(atomic64_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic64_fetch_inc_relaxed(v);
}

static __always_inline void
atomic64_dec(atomic64_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	arch_atomic64_dec(v);
}

static __always_inline s64
atomic64_dec_return(atomic64_t *v)
{
	kcsan_mb();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic64_dec_return(v);
}

static __always_inline s64
atomic64_dec_return_acquire(atomic64_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic64_dec_return_acquire(v);
}

static __always_inline s64
atomic64_dec_return_release(atomic64_t *v)
{
	kcsan_release();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic64_dec_return_release(v);
}

static __always_inline s64
atomic64_dec_return_relaxed(atomic64_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic64_dec_return_relaxed(v);
}

static __always_inline s64
atomic64_fetch_dec(atomic64_t *v)
{
	kcsan_mb();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic64_fetch_dec(v);
}

static __always_inline s64
atomic64_fetch_dec_acquire(atomic64_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic64_fetch_dec_acquire(v);
}

static __always_inline s64
atomic64_fetch_dec_release(atomic64_t *v)
{
	kcsan_release();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic64_fetch_dec_release(v);
}

static __always_inline s64
atomic64_fetch_dec_relaxed(atomic64_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic64_fetch_dec_relaxed(v);
}

static __always_inline void
atomic64_and(s64 i, atomic64_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	arch_atomic64_and(i, v);
}

static __always_inline s64
atomic64_fetch_and(s64 i, atomic64_t *v)
{
	kcsan_mb();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic64_fetch_and(i, v);
}

static __always_inline s64
atomic64_fetch_and_acquire(s64 i, atomic64_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic64_fetch_and_acquire(i, v);
}

static __always_inline s64
atomic64_fetch_and_release(s64 i, atomic64_t *v)
{
	kcsan_release();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic64_fetch_and_release(i, v);
}

static __always_inline s64
atomic64_fetch_and_relaxed(s64 i, atomic64_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic64_fetch_and_relaxed(i, v);
}

static __always_inline void
atomic64_andnot(s64 i, atomic64_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	arch_atomic64_andnot(i, v);
}

static __always_inline s64
atomic64_fetch_andnot(s64 i, atomic64_t *v)
{
	kcsan_mb();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic64_fetch_andnot(i, v);
}

static __always_inline s64
atomic64_fetch_andnot_acquire(s64 i, atomic64_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic64_fetch_andnot_acquire(i, v);
}

static __always_inline s64
atomic64_fetch_andnot_release(s64 i, atomic64_t *v)
{
	kcsan_release();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic64_fetch_andnot_release(i, v);
}

static __always_inline s64
atomic64_fetch_andnot_relaxed(s64 i, atomic64_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic64_fetch_andnot_relaxed(i, v);
}

static __always_inline void
atomic64_or(s64 i, atomic64_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	arch_atomic64_or(i, v);
}

static __always_inline s64
atomic64_fetch_or(s64 i, atomic64_t *v)
{
	kcsan_mb();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic64_fetch_or(i, v);
}

static __always_inline s64
atomic64_fetch_or_acquire(s64 i, atomic64_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic64_fetch_or_acquire(i, v);
}

static __always_inline s64
atomic64_fetch_or_release(s64 i, atomic64_t *v)
{
	kcsan_release();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic64_fetch_or_release(i, v);
}

static __always_inline s64
atomic64_fetch_or_relaxed(s64 i, atomic64_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic64_fetch_or_relaxed(i, v);
}

static __always_inline void
atomic64_xor(s64 i, atomic64_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	arch_atomic64_xor(i, v);
}

static __always_inline s64
atomic64_fetch_xor(s64 i, atomic64_t *v)
{
	kcsan_mb();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic64_fetch_xor(i, v);
}

static __always_inline s64
atomic64_fetch_xor_acquire(s64 i, atomic64_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic64_fetch_xor_acquire(i, v);
}

static __always_inline s64
atomic64_fetch_xor_release(s64 i, atomic64_t *v)
{
	kcsan_release();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic64_fetch_xor_release(i, v);
}

static __always_inline s64
atomic64_fetch_xor_relaxed(s64 i, atomic64_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic64_fetch_xor_relaxed(i, v);
}

static __always_inline s64
atomic64_xchg(atomic64_t *v, s64 i)
{
	kcsan_mb();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic64_xchg(v, i);
}

static __always_inline s64
atomic64_xchg_acquire(atomic64_t *v, s64 i)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic64_xchg_acquire(v, i);
}

static __always_inline s64
atomic64_xchg_release(atomic64_t *v, s64 i)
{
	kcsan_release();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic64_xchg_release(v, i);
}

static __always_inline s64
atomic64_xchg_relaxed(atomic64_t *v, s64 i)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic64_xchg_relaxed(v, i);
}

static __always_inline s64
atomic64_cmpxchg(atomic64_t *v, s64 old, s64 new)
{
	kcsan_mb();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic64_cmpxchg(v, old, new);
}

static __always_inline s64
atomic64_cmpxchg_acquire(atomic64_t *v, s64 old, s64 new)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic64_cmpxchg_acquire(v, old, new);
}

static __always_inline s64
atomic64_cmpxchg_release(atomic64_t *v, s64 old, s64 new)
{
	kcsan_release();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic64_cmpxchg_release(v, old, new);
}

static __always_inline s64
atomic64_cmpxchg_relaxed(atomic64_t *v, s64 old, s64 new)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic64_cmpxchg_relaxed(v, old, new);
}

static __always_inline bool
atomic64_try_cmpxchg(atomic64_t *v, s64 *old, s64 new)
{
	kcsan_mb();
	instrument_atomic_read_write(v, sizeof(*v));
	instrument_atomic_read_write(old, sizeof(*old));
	return arch_atomic64_try_cmpxchg(v, old, new);
}

static __always_inline bool
atomic64_try_cmpxchg_acquire(atomic64_t *v, s64 *old, s64 new)
{
	instrument_atomic_read_write(v, sizeof(*v));
	instrument_atomic_read_write(old, sizeof(*old));
	return arch_atomic64_try_cmpxchg_acquire(v, old, new);
}

static __always_inline bool
atomic64_try_cmpxchg_release(atomic64_t *v, s64 *old, s64 new)
{
	kcsan_release();
	instrument_atomic_read_write(v, sizeof(*v));
	instrument_atomic_read_write(old, sizeof(*old));
	return arch_atomic64_try_cmpxchg_release(v, old, new);
}

static __always_inline bool
atomic64_try_cmpxchg_relaxed(atomic64_t *v, s64 *old, s64 new)
{
	instrument_atomic_read_write(v, sizeof(*v));
	instrument_atomic_read_write(old, sizeof(*old));
	return arch_atomic64_try_cmpxchg_relaxed(v, old, new);
}

static __always_inline bool
atomic64_sub_and_test(s64 i, atomic64_t *v)
{
	kcsan_mb();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic64_sub_and_test(i, v);
}

static __always_inline bool
atomic64_dec_and_test(atomic64_t *v)
{
	kcsan_mb();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic64_dec_and_test(v);
}

static __always_inline bool
atomic64_inc_and_test(atomic64_t *v)
{
	kcsan_mb();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic64_inc_and_test(v);
}

static __always_inline bool
atomic64_add_negative(s64 i, atomic64_t *v)
{
	kcsan_mb();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic64_add_negative(i, v);
}

static __always_inline s64
atomic64_fetch_add_unless(atomic64_t *v, s64 a, s64 u)
{
	kcsan_mb();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic64_fetch_add_unless(v, a, u);
}

static __always_inline bool
atomic64_add_unless(atomic64_t *v, s64 a, s64 u)
{
	kcsan_mb();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic64_add_unless(v, a, u);
}

static __always_inline bool
atomic64_inc_not_zero(atomic64_t *v)
{
	kcsan_mb();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic64_inc_not_zero(v);
}

static __always_inline bool
atomic64_inc_unless_negative(atomic64_t *v)
{
	kcsan_mb();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic64_inc_unless_negative(v);
}

static __always_inline bool
atomic64_dec_unless_positive(atomic64_t *v)
{
	kcsan_mb();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic64_dec_unless_positive(v);
}

static __always_inline s64
atomic64_dec_if_positive(atomic64_t *v)
{
	kcsan_mb();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic64_dec_if_positive(v);
}

static __always_inline long
atomic_long_read(const atomic_long_t *v)
{
	instrument_atomic_read(v, sizeof(*v));
	return arch_atomic_long_read(v);
}

static __always_inline long
atomic_long_read_acquire(const atomic_long_t *v)
{
	instrument_atomic_read(v, sizeof(*v));
	return arch_atomic_long_read_acquire(v);
}

static __always_inline void
atomic_long_set(atomic_long_t *v, long i)
{
	instrument_atomic_write(v, sizeof(*v));
	arch_atomic_long_set(v, i);
}

static __always_inline void
atomic_long_set_release(atomic_long_t *v, long i)
{
	kcsan_release();
	instrument_atomic_write(v, sizeof(*v));
	arch_atomic_long_set_release(v, i);
}

static __always_inline void
atomic_long_add(long i, atomic_long_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	arch_atomic_long_add(i, v);
}

static __always_inline long
atomic_long_add_return(long i, atomic_long_t *v)
{
	kcsan_mb();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_long_add_return(i, v);
}

static __always_inline long
atomic_long_add_return_acquire(long i, atomic_long_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_long_add_return_acquire(i, v);
}

static __always_inline long
atomic_long_add_return_release(long i, atomic_long_t *v)
{
	kcsan_release();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_long_add_return_release(i, v);
}

static __always_inline long
atomic_long_add_return_relaxed(long i, atomic_long_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_long_add_return_relaxed(i, v);
}

static __always_inline long
atomic_long_fetch_add(long i, atomic_long_t *v)
{
	kcsan_mb();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_long_fetch_add(i, v);
}

static __always_inline long
atomic_long_fetch_add_acquire(long i, atomic_long_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_long_fetch_add_acquire(i, v);
}

static __always_inline long
atomic_long_fetch_add_release(long i, atomic_long_t *v)
{
	kcsan_release();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_long_fetch_add_release(i, v);
}

static __always_inline long
atomic_long_fetch_add_relaxed(long i, atomic_long_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_long_fetch_add_relaxed(i, v);
}

static __always_inline void
atomic_long_sub(long i, atomic_long_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	arch_atomic_long_sub(i, v);
}

static __always_inline long
atomic_long_sub_return(long i, atomic_long_t *v)
{
	kcsan_mb();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_long_sub_return(i, v);
}

static __always_inline long
atomic_long_sub_return_acquire(long i, atomic_long_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_long_sub_return_acquire(i, v);
}

static __always_inline long
atomic_long_sub_return_release(long i, atomic_long_t *v)
{
	kcsan_release();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_long_sub_return_release(i, v);
}

static __always_inline long
atomic_long_sub_return_relaxed(long i, atomic_long_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_long_sub_return_relaxed(i, v);
}

static __always_inline long
atomic_long_fetch_sub(long i, atomic_long_t *v)
{
	kcsan_mb();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_long_fetch_sub(i, v);
}

static __always_inline long
atomic_long_fetch_sub_acquire(long i, atomic_long_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_long_fetch_sub_acquire(i, v);
}

static __always_inline long
atomic_long_fetch_sub_release(long i, atomic_long_t *v)
{
	kcsan_release();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_long_fetch_sub_release(i, v);
}

static __always_inline long
atomic_long_fetch_sub_relaxed(long i, atomic_long_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_long_fetch_sub_relaxed(i, v);
}

static __always_inline void
atomic_long_inc(atomic_long_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	arch_atomic_long_inc(v);
}

static __always_inline long
atomic_long_inc_return(atomic_long_t *v)
{
	kcsan_mb();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_long_inc_return(v);
}

static __always_inline long
atomic_long_inc_return_acquire(atomic_long_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_long_inc_return_acquire(v);
}

static __always_inline long
atomic_long_inc_return_release(atomic_long_t *v)
{
	kcsan_release();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_long_inc_return_release(v);
}

static __always_inline long
atomic_long_inc_return_relaxed(atomic_long_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_long_inc_return_relaxed(v);
}

static __always_inline long
atomic_long_fetch_inc(atomic_long_t *v)
{
	kcsan_mb();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_long_fetch_inc(v);
}

static __always_inline long
atomic_long_fetch_inc_acquire(atomic_long_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_long_fetch_inc_acquire(v);
}

static __always_inline long
atomic_long_fetch_inc_release(atomic_long_t *v)
{
	kcsan_release();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_long_fetch_inc_release(v);
}

static __always_inline long
atomic_long_fetch_inc_relaxed(atomic_long_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_long_fetch_inc_relaxed(v);
}

static __always_inline void
atomic_long_dec(atomic_long_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	arch_atomic_long_dec(v);
}

static __always_inline long
atomic_long_dec_return(atomic_long_t *v)
{
	kcsan_mb();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_long_dec_return(v);
}

static __always_inline long
atomic_long_dec_return_acquire(atomic_long_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_long_dec_return_acquire(v);
}

static __always_inline long
atomic_long_dec_return_release(atomic_long_t *v)
{
	kcsan_release();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_long_dec_return_release(v);
}

static __always_inline long
atomic_long_dec_return_relaxed(atomic_long_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_long_dec_return_relaxed(v);
}

static __always_inline long
atomic_long_fetch_dec(atomic_long_t *v)
{
	kcsan_mb();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_long_fetch_dec(v);
}

static __always_inline long
atomic_long_fetch_dec_acquire(atomic_long_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_long_fetch_dec_acquire(v);
}

static __always_inline long
atomic_long_fetch_dec_release(atomic_long_t *v)
{
	kcsan_release();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_long_fetch_dec_release(v);
}

static __always_inline long
atomic_long_fetch_dec_relaxed(atomic_long_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_long_fetch_dec_relaxed(v);
}

static __always_inline void
atomic_long_and(long i, atomic_long_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	arch_atomic_long_and(i, v);
}

static __always_inline long
atomic_long_fetch_and(long i, atomic_long_t *v)
{
	kcsan_mb();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_long_fetch_and(i, v);
}

static __always_inline long
atomic_long_fetch_and_acquire(long i, atomic_long_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_long_fetch_and_acquire(i, v);
}

static __always_inline long
atomic_long_fetch_and_release(long i, atomic_long_t *v)
{
	kcsan_release();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_long_fetch_and_release(i, v);
}

static __always_inline long
atomic_long_fetch_and_relaxed(long i, atomic_long_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_long_fetch_and_relaxed(i, v);
}

static __always_inline void
atomic_long_andnot(long i, atomic_long_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	arch_atomic_long_andnot(i, v);
}

static __always_inline long
atomic_long_fetch_andnot(long i, atomic_long_t *v)
{
	kcsan_mb();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_long_fetch_andnot(i, v);
}

static __always_inline long
atomic_long_fetch_andnot_acquire(long i, atomic_long_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_long_fetch_andnot_acquire(i, v);
}

static __always_inline long
atomic_long_fetch_andnot_release(long i, atomic_long_t *v)
{
	kcsan_release();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_long_fetch_andnot_release(i, v);
}

static __always_inline long
atomic_long_fetch_andnot_relaxed(long i, atomic_long_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_long_fetch_andnot_relaxed(i, v);
}

static __always_inline void
atomic_long_or(long i, atomic_long_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	arch_atomic_long_or(i, v);
}

static __always_inline long
atomic_long_fetch_or(long i, atomic_long_t *v)
{
	kcsan_mb();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_long_fetch_or(i, v);
}

static __always_inline long
atomic_long_fetch_or_acquire(long i, atomic_long_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_long_fetch_or_acquire(i, v);
}

static __always_inline long
atomic_long_fetch_or_release(long i, atomic_long_t *v)
{
	kcsan_release();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_long_fetch_or_release(i, v);
}

static __always_inline long
atomic_long_fetch_or_relaxed(long i, atomic_long_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_long_fetch_or_relaxed(i, v);
}

static __always_inline void
atomic_long_xor(long i, atomic_long_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	arch_atomic_long_xor(i, v);
}

static __always_inline long
atomic_long_fetch_xor(long i, atomic_long_t *v)
{
	kcsan_mb();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_long_fetch_xor(i, v);
}

static __always_inline long
atomic_long_fetch_xor_acquire(long i, atomic_long_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_long_fetch_xor_acquire(i, v);
}

static __always_inline long
atomic_long_fetch_xor_release(long i, atomic_long_t *v)
{
	kcsan_release();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_long_fetch_xor_release(i, v);
}

static __always_inline long
atomic_long_fetch_xor_relaxed(long i, atomic_long_t *v)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_long_fetch_xor_relaxed(i, v);
}

static __always_inline long
atomic_long_xchg(atomic_long_t *v, long i)
{
	kcsan_mb();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_long_xchg(v, i);
}

static __always_inline long
atomic_long_xchg_acquire(atomic_long_t *v, long i)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_long_xchg_acquire(v, i);
}

static __always_inline long
atomic_long_xchg_release(atomic_long_t *v, long i)
{
	kcsan_release();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_long_xchg_release(v, i);
}

static __always_inline long
atomic_long_xchg_relaxed(atomic_long_t *v, long i)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_long_xchg_relaxed(v, i);
}

static __always_inline long
atomic_long_cmpxchg(atomic_long_t *v, long old, long new)
{
	kcsan_mb();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_long_cmpxchg(v, old, new);
}

static __always_inline long
atomic_long_cmpxchg_acquire(atomic_long_t *v, long old, long new)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_long_cmpxchg_acquire(v, old, new);
}

static __always_inline long
atomic_long_cmpxchg_release(atomic_long_t *v, long old, long new)
{
	kcsan_release();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_long_cmpxchg_release(v, old, new);
}

static __always_inline long
atomic_long_cmpxchg_relaxed(atomic_long_t *v, long old, long new)
{
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_long_cmpxchg_relaxed(v, old, new);
}

static __always_inline bool
atomic_long_try_cmpxchg(atomic_long_t *v, long *old, long new)
{
	kcsan_mb();
	instrument_atomic_read_write(v, sizeof(*v));
	instrument_atomic_read_write(old, sizeof(*old));
	return arch_atomic_long_try_cmpxchg(v, old, new);
}

static __always_inline bool
atomic_long_try_cmpxchg_acquire(atomic_long_t *v, long *old, long new)
{
	instrument_atomic_read_write(v, sizeof(*v));
	instrument_atomic_read_write(old, sizeof(*old));
	return arch_atomic_long_try_cmpxchg_acquire(v, old, new);
}

static __always_inline bool
atomic_long_try_cmpxchg_release(atomic_long_t *v, long *old, long new)
{
	kcsan_release();
	instrument_atomic_read_write(v, sizeof(*v));
	instrument_atomic_read_write(old, sizeof(*old));
	return arch_atomic_long_try_cmpxchg_release(v, old, new);
}

static __always_inline bool
atomic_long_try_cmpxchg_relaxed(atomic_long_t *v, long *old, long new)
{
	instrument_atomic_read_write(v, sizeof(*v));
	instrument_atomic_read_write(old, sizeof(*old));
	return arch_atomic_long_try_cmpxchg_relaxed(v, old, new);
}

static __always_inline bool
atomic_long_sub_and_test(long i, atomic_long_t *v)
{
	kcsan_mb();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_long_sub_and_test(i, v);
}

static __always_inline bool
atomic_long_dec_and_test(atomic_long_t *v)
{
	kcsan_mb();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_long_dec_and_test(v);
}

static __always_inline bool
atomic_long_inc_and_test(atomic_long_t *v)
{
	kcsan_mb();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_long_inc_and_test(v);
}

static __always_inline bool
atomic_long_add_negative(long i, atomic_long_t *v)
{
	kcsan_mb();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_long_add_negative(i, v);
}

static __always_inline long
atomic_long_fetch_add_unless(atomic_long_t *v, long a, long u)
{
	kcsan_mb();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_long_fetch_add_unless(v, a, u);
}

static __always_inline bool
atomic_long_add_unless(atomic_long_t *v, long a, long u)
{
	kcsan_mb();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_long_add_unless(v, a, u);
}

static __always_inline bool
atomic_long_inc_not_zero(atomic_long_t *v)
{
	kcsan_mb();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_long_inc_not_zero(v);
}

static __always_inline bool
atomic_long_inc_unless_negative(atomic_long_t *v)
{
	kcsan_mb();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_long_inc_unless_negative(v);
}

static __always_inline bool
atomic_long_dec_unless_positive(atomic_long_t *v)
{
	kcsan_mb();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_long_dec_unless_positive(v);
}

static __always_inline long
atomic_long_dec_if_positive(atomic_long_t *v)
{
	kcsan_mb();
	instrument_atomic_read_write(v, sizeof(*v));
	return arch_atomic_long_dec_if_positive(v);
}

#define xchg(ptr, ...) \
({ \
	typeof(ptr) __ai_ptr = (ptr); \
	kcsan_mb(); \
	instrument_atomic_write(__ai_ptr, sizeof(*__ai_ptr)); \
	arch_xchg(__ai_ptr, __VA_ARGS__); \
})

#define xchg_acquire(ptr, ...) \
({ \
	typeof(ptr) __ai_ptr = (ptr); \
	instrument_atomic_write(__ai_ptr, sizeof(*__ai_ptr)); \
	arch_xchg_acquire(__ai_ptr, __VA_ARGS__); \
})

#define xchg_release(ptr, ...) \
({ \
	typeof(ptr) __ai_ptr = (ptr); \
	kcsan_release(); \
	instrument_atomic_write(__ai_ptr, sizeof(*__ai_ptr)); \
	arch_xchg_release(__ai_ptr, __VA_ARGS__); \
})

#define xchg_relaxed(ptr, ...) \
({ \
	typeof(ptr) __ai_ptr = (ptr); \
	instrument_atomic_write(__ai_ptr, sizeof(*__ai_ptr)); \
	arch_xchg_relaxed(__ai_ptr, __VA_ARGS__); \
})

#define cmpxchg(ptr, ...) \
({ \
	typeof(ptr) __ai_ptr = (ptr); \
	kcsan_mb(); \
	instrument_atomic_write(__ai_ptr, sizeof(*__ai_ptr)); \
	arch_cmpxchg(__ai_ptr, __VA_ARGS__); \
})

#define cmpxchg_acquire(ptr, ...) \
({ \
	typeof(ptr) __ai_ptr = (ptr); \
	instrument_atomic_write(__ai_ptr, sizeof(*__ai_ptr)); \
	arch_cmpxchg_acquire(__ai_ptr, __VA_ARGS__); \
})

#define cmpxchg_release(ptr, ...) \
({ \
	typeof(ptr) __ai_ptr = (ptr); \
	kcsan_release(); \
	instrument_atomic_write(__ai_ptr, sizeof(*__ai_ptr)); \
	arch_cmpxchg_release(__ai_ptr, __VA_ARGS__); \
})

#define cmpxchg_relaxed(ptr, ...) \
({ \
	typeof(ptr) __ai_ptr = (ptr); \
	instrument_atomic_write(__ai_ptr, sizeof(*__ai_ptr)); \
	arch_cmpxchg_relaxed(__ai_ptr, __VA_ARGS__); \
})

#define cmpxchg64(ptr, ...) \
({ \
	typeof(ptr) __ai_ptr = (ptr); \
	kcsan_mb(); \
	instrument_atomic_write(__ai_ptr, sizeof(*__ai_ptr)); \
	arch_cmpxchg64(__ai_ptr, __VA_ARGS__); \
})

#define cmpxchg64_acquire(ptr, ...) \
({ \
	typeof(ptr) __ai_ptr = (ptr); \
	instrument_atomic_write(__ai_ptr, sizeof(*__ai_ptr)); \
	arch_cmpxchg64_acquire(__ai_ptr, __VA_ARGS__); \
})

#define cmpxchg64_release(ptr, ...) \
({ \
	typeof(ptr) __ai_ptr = (ptr); \
	kcsan_release(); \
	instrument_atomic_write(__ai_ptr, sizeof(*__ai_ptr)); \
	arch_cmpxchg64_release(__ai_ptr, __VA_ARGS__); \
})

#define cmpxchg64_relaxed(ptr, ...) \
({ \
	typeof(ptr) __ai_ptr = (ptr); \
	instrument_atomic_write(__ai_ptr, sizeof(*__ai_ptr)); \
	arch_cmpxchg64_relaxed(__ai_ptr, __VA_ARGS__); \
})

#define try_cmpxchg(ptr, oldp, ...) \
({ \
	typeof(ptr) __ai_ptr = (ptr); \
	typeof(oldp) __ai_oldp = (oldp); \
	kcsan_mb(); \
	instrument_atomic_write(__ai_ptr, sizeof(*__ai_ptr)); \
	instrument_atomic_write(__ai_oldp, sizeof(*__ai_oldp)); \
	arch_try_cmpxchg(__ai_ptr, __ai_oldp, __VA_ARGS__); \
})

#define try_cmpxchg_acquire(ptr, oldp, ...) \
({ \
	typeof(ptr) __ai_ptr = (ptr); \
	typeof(oldp) __ai_oldp = (oldp); \
	instrument_atomic_write(__ai_ptr, sizeof(*__ai_ptr)); \
	instrument_atomic_write(__ai_oldp, sizeof(*__ai_oldp)); \
	arch_try_cmpxchg_acquire(__ai_ptr, __ai_oldp, __VA_ARGS__); \
})

#define try_cmpxchg_release(ptr, oldp, ...) \
({ \
	typeof(ptr) __ai_ptr = (ptr); \
	typeof(oldp) __ai_oldp = (oldp); \
	kcsan_release(); \
	instrument_atomic_write(__ai_ptr, sizeof(*__ai_ptr)); \
	instrument_atomic_write(__ai_oldp, sizeof(*__ai_oldp)); \
	arch_try_cmpxchg_release(__ai_ptr, __ai_oldp, __VA_ARGS__); \
})

#define try_cmpxchg_relaxed(ptr, oldp, ...) \
({ \
	typeof(ptr) __ai_ptr = (ptr); \
	typeof(oldp) __ai_oldp = (oldp); \
	instrument_atomic_write(__ai_ptr, sizeof(*__ai_ptr)); \
	instrument_atomic_write(__ai_oldp, sizeof(*__ai_oldp)); \
	arch_try_cmpxchg_relaxed(__ai_ptr, __ai_oldp, __VA_ARGS__); \
})

#define cmpxchg_local(ptr, ...) \
({ \
	typeof(ptr) __ai_ptr = (ptr); \
	instrument_atomic_write(__ai_ptr, sizeof(*__ai_ptr)); \
	arch_cmpxchg_local(__ai_ptr, __VA_ARGS__); \
})

#define cmpxchg64_local(ptr, ...) \
({ \
	typeof(ptr) __ai_ptr = (ptr); \
	instrument_atomic_write(__ai_ptr, sizeof(*__ai_ptr)); \
	arch_cmpxchg64_local(__ai_ptr, __VA_ARGS__); \
})

#define sync_cmpxchg(ptr, ...) \
({ \
	typeof(ptr) __ai_ptr = (ptr); \
	kcsan_mb(); \
	instrument_atomic_write(__ai_ptr, sizeof(*__ai_ptr)); \
	arch_sync_cmpxchg(__ai_ptr, __VA_ARGS__); \
})

#define cmpxchg_double(ptr, ...) \
({ \
	typeof(ptr) __ai_ptr = (ptr); \
	kcsan_mb(); \
	instrument_atomic_write(__ai_ptr, 2 * sizeof(*__ai_ptr)); \
	arch_cmpxchg_double(__ai_ptr, __VA_ARGS__); \
})


#define cmpxchg_double_local(ptr, ...) \
({ \
	typeof(ptr) __ai_ptr = (ptr); \
	instrument_atomic_write(__ai_ptr, 2 * sizeof(*__ai_ptr)); \
	arch_cmpxchg_double_local(__ai_ptr, __VA_ARGS__); \
})

#endif /* _LINUX_ATOMIC_INSTRUMENTED_H */
// 87c974b93032afd42143613434d1a7788fa598f9
