/* SPDX-License-Identifier: GPL-2.0 */
/* niu.h: Definitions for Neptune ethernet driver.
 *
 * Copyright (C) 2007 David S. Miller (davem@davemloft.net)
 */

#ifndef _NIU_H
#define _NIU_H

#define PIO			0x000000UL
#define FZC_PIO			0x080000UL
#define FZC_MAC			0x180000UL
#define FZC_IPP			0x280000UL
#define FFLP			0x300000UL
#define FZC_FFLP		0x380000UL
#define PIO_VADDR		0x400000UL
#define ZCP			0x500000UL
#define FZC_ZCP			0x580000UL
#define DMC			0x600000UL
#define FZC_DMC			0x680000UL
#define TXC			0x700000UL
#define FZC_TXC			0x780000UL
#define PIO_LDSV		0x800000UL
#define PIO_PIO_LDGIM		0x900000UL
#define PIO_IMASK0		0xa00000UL
#define PIO_IMASK1		0xb00000UL
#define FZC_PROM		0xc80000UL
#define FZC_PIM			0xd80000UL

#define LDSV0(LDG)		(PIO_LDSV + 0x00000UL + (LDG) * 0x2000UL)
#define LDSV1(LDG)		(PIO_LDSV + 0x00008UL + (LDG) * 0x2000UL)
#define LDSV2(LDG)		(PIO_LDSV + 0x00010UL + (LDG) * 0x2000UL)

#define LDG_IMGMT(LDG)		(PIO_LDSV + 0x00018UL + (LDG) * 0x2000UL)
#define  LDG_IMGMT_ARM		0x0000000080000000ULL
#define  LDG_IMGMT_TIMER	0x000000000000003fULL

#define LD_IM0(IDX)		(PIO_IMASK0 + 0x00000UL + (IDX) * 0x2000UL)
#define  LD_IM0_MASK		0x0000000000000003ULL

#define LD_IM1(IDX)		(PIO_IMASK1 + 0x00000UL + (IDX) * 0x2000UL)
#define  LD_IM1_MASK		0x0000000000000003ULL

#define LDG_TIMER_RES		(FZC_PIO + 0x00008UL)
#define  LDG_TIMER_RES_VAL	0x00000000000fffffULL

#define DIRTY_TID_CTL		(FZC_PIO + 0x00010UL)
#define  DIRTY_TID_CTL_NPTHRED	0x00000000003f0000ULL
#define  DIRTY_TID_CTL_RDTHRED	0x00000000000003f0ULL
#define  DIRTY_TID_CTL_DTIDCLR	0x0000000000000002ULL
#define  DIRTY_TID_CTL_DTIDENAB	0x0000000000000001ULL

#define DIRTY_TID_STAT		(FZC_PIO + 0x00018UL)
#define  DIRTY_TID_STAT_NPWSTAT	0x0000000000003f00ULL
#define  DIRTY_TID_STAT_RDSTAT	0x000000000000003fULL

#define RST_CTL			(FZC_PIO + 0x00038UL)
#define  RST_CTL_MAC_RST3	0x0000000000400000ULL
#define  RST_CTL_MAC_RST2	0x0000000000200000ULL
#define  RST_CTL_MAC_RST1	0x0000000000100000ULL
#define  RST_CTL_MAC_RST0	0x0000000000080000ULL
#define  RST_CTL_ACK_TO_EN	0x0000000000000800ULL
#define  RST_CTL_ACK_TO_VAL	0x00000000000007feULL

#define SMX_CFIG_DAT		(FZC_PIO + 0x00040UL)
#define  SMX_CFIG_DAT_RAS_DET	0x0000000080000000ULL
#define  SMX_CFIG_DAT_RAS_INJ	0x0000000040000000ULL
#define  SMX_CFIG_DAT_XACT_TO	0x000000000fffffffULL

#define SMX_INT_STAT		(FZC_PIO + 0x00048UL)
#define  SMX_INT_STAT_STAT	0x00000000ffffffffULL

#define SMX_CTL			(FZC_PIO + 0x00050UL)
#define  SMX_CTL_CTL		0x00000000ffffffffULL

#define SMX_DBG_VEC		(FZC_PIO + 0x00058UL)
#define  SMX_DBG_VEC_VEC	0x00000000ffffffffULL

#define PIO_DBG_SEL		(FZC_PIO + 0x00060UL)
#define  PIO_DBG_SEL_SEL	0x000000000000003fULL

#define PIO_TRAIN_VEC		(FZC_PIO + 0x00068UL)
#define  PIO_TRAIN_VEC_VEC	0x00000000ffffffffULL

#define PIO_ARB_CTL		(FZC_PIO + 0x00070UL)
#define  PIO_ARB_CTL_CTL	0x00000000ffffffffULL

#define PIO_ARB_DBG_VEC		(FZC_PIO + 0x00078UL)
#define  PIO_ARB_DBG_VEC_VEC	0x00000000ffffffffULL

#define SYS_ERR_MASK		(FZC_PIO + 0x00090UL)
#define  SYS_ERR_MASK_META2	0x0000000000000400ULL
#define  SYS_ERR_MASK_META1	0x0000000000000200ULL
#define  SYS_ERR_MASK_PEU	0x0000000000000100ULL
#define  SYS_ERR_MASK_TXC	0x0000000000000080ULL
#define  SYS_ERR_MASK_RDMC	0x0000000000000040ULL
#define  SYS_ERR_MASK_TDMC	0x0000000000000020ULL
#define  SYS_ERR_MASK_ZCP	0x0000000000000010ULL
#define  SYS_ERR_MASK_FFLP	0x0000000000000008ULL
#define  SYS_ERR_MASK_IPP	0x0000000000000004ULL
#define  SYS_ERR_MASK_MAC	0x0000000000000002ULL
#define  SYS_ERR_MASK_SMX	0x0000000000000001ULL

#define SYS_ERR_STAT			(FZC_PIO + 0x00098UL)
#define  SYS_ERR_STAT_META2		0x0000000000000400ULL
#define  SYS_ERR_STAT_META1		0x0000000000000200ULL
#define  SYS_ERR_STAT_PEU		0x0000000000000100ULL
#define  SYS_ERR_STAT_TXC		0x0000000000000080ULL
#define  SYS_ERR_STAT_RDMC		0x0000000000000040ULL
#define  SYS_ERR_STAT_TDMC		0x0000000000000020ULL
#define  SYS_ERR_STAT_ZCP		0x0000000000000010ULL
#define  SYS_ERR_STAT_FFLP		0x0000000000000008ULL
#define  SYS_ERR_STAT_IPP		0x0000000000000004ULL
#define  SYS_ERR_STAT_MAC		0x0000000000000002ULL
#define  SYS_ERR_STAT_SMX		0x0000000000000001ULL

#define SID(LDG)			(FZC_PIO + 0x10200UL + (LDG) * 8UL)
#define  SID_FUNC			0x0000000000000060ULL
#define  SID_FUNC_SHIFT			5
#define  SID_VECTOR			0x000000000000001fULL
#define  SID_VECTOR_SHIFT		0

#define LDG_NUM(LDN)			(FZC_PIO + 0x20000UL + (LDN) * 8UL)

#define XMAC_PORT0_OFF			(FZC_MAC + 0x000000)
#define XMAC_PORT1_OFF			(FZC_MAC + 0x006000)
#define BMAC_PORT2_OFF			(FZC_MAC + 0x00c000)
#define BMAC_PORT3_OFF			(FZC_MAC + 0x010000)

/* XMAC registers, offset from np->mac_regs  */

#define XTXMAC_SW_RST			0x00000UL
#define  XTXMAC_SW_RST_REG_RS		0x0000000000000002ULL
#define  XTXMAC_SW_RST_SOFT_RST		0x0000000000000001ULL

#define XRXMAC_SW_RST			0x00008UL
#define  XRXMAC_SW_RST_REG_RS		0x0000000000000002ULL
#define  XRXMAC_SW_RST_SOFT_RST		0x0000000000000001ULL

#define XTXMAC_STATUS			0x00020UL
#define  XTXMAC_STATUS_FRAME_CNT_EXP	0x0000000000000800ULL
#define  XTXMAC_STATUS_BYTE_CNT_EXP	0x0000000000000400ULL
#define  XTXMAC_STATUS_TXFIFO_XFR_ERR	0x0000000000000010ULL
#define  XTXMAC_STATUS_TXMAC_OFLOW	0x0000000000000008ULL
#define  XTXMAC_STATUS_MAX_PSIZE_ERR	0x0000000000000004ULL
#define  XTXMAC_STATUS_TXMAC_UFLOW	0x0000000000000002ULL
#define  XTXMAC_STATUS_FRAME_XMITED	0x0000000000000001ULL

#define XRXMAC_STATUS			0x00028UL
#define  XRXMAC_STATUS_RXHIST7_CNT_EXP	0x0000000000100000ULL
#define  XRXMAC_STATUS_LCL_FLT_STATUS	0x0000000000080000ULL
#define  XRXMAC_STATUS_RFLT_DET		0x0000000000040000ULL
#define  XRXMAC_STATUS_LFLT_CNT_EXP	0x0000000000020000ULL
#define  XRXMAC_STATUS_PHY_MDINT	0x0000000000010000ULL
#define  XRXMAC_STATUS_ALIGNERR_CNT_EXP	0x0000000000010000ULL
#define  XRXMAC_STATUS_RXFRAG_CNT_EXP	0x0000000000008000ULL
#define  XRXMAC_STATUS_RXMULTF_CNT_EXP	0x0000000000004000ULL
#define  XRXMAC_STATUS_RXBCAST_CNT_EXP	0x0000000000002000ULL
#define  XRXMAC_STATUS_RXHIST6_CNT_EXP	0x0000000000001000ULL
#define  XRXMAC_STATUS_RXHIST5_CNT_EXP	0x0000000000000800ULL
#define  XRXMAC_STATUS_RXHIST4_CNT_EXP	0x0000000000000400ULL
#define  XRXMAC_STATUS_RXHIST3_CNT_EXP	0x0000000000000200ULL
#define  XRXMAC_STATUS_RXHIST2_CNT_EXP	0x0000000000000100ULL
#define  XRXMAC_STATUS_RXHIST1_CNT_EXP	0x0000000000000080ULL
#define  XRXMAC_STATUS_RXOCTET_CNT_EXP	0x0000000000000040ULL
#define  XRXMAC_STATUS_CVIOLERR_CNT_EXP	0x0000000000000020ULL
#define  XRXMAC_STATUS_LENERR_CNT_EXP	0x0000000000000010ULL
#define  XRXMAC_STATUS_CRCERR_CNT_EXP	0x0000000000000008ULL
#define  XRXMAC_STATUS_RXUFLOW		0x0000000000000004ULL
#define  XRXMAC_STATUS_RXOFLOW		0x0000000000000002ULL
#define  XRXMAC_STATUS_FRAME_RCVD	0x0000000000000001ULL

#define XMAC_FC_STAT			0x00030UL
#define  XMAC_FC_STAT_RX_RCV_PAUSE_TIME	0x00000000ffff0000ULL
#define  XMAC_FC_STAT_TX_MAC_NPAUSE	0x0000000000000004ULL
#define  XMAC_FC_STAT_TX_MAC_PAUSE	0x0000000000000002ULL
#define  XMAC_FC_STAT_RX_MAC_RPAUSE	0x0000000000000001ULL

#define XTXMAC_STAT_MSK			0x00040UL
#define  XTXMAC_STAT_MSK_FRAME_CNT_EXP	0x0000000000000800ULL
#define  XTXMAC_STAT_MSK_BYTE_CNT_EXP	0x0000000000000400ULL
#define  XTXMAC_STAT_MSK_TXFIFO_XFR_ERR	0x0000000000000010ULL
#define  XTXMAC_STAT_MSK_TXMAC_OFLOW	0x0000000000000008ULL
#define  XTXMAC_STAT_MSK_MAX_PSIZE_ERR	0x0000000000000004ULL
#define  XTXMAC_STAT_MSK_TXMAC_UFLOW	0x0000000000000002ULL
#define  XTXMAC_STAT_MSK_FRAME_XMITED	0x0000000000000001ULL

#define XRXMAC_STAT_MSK				0x00048UL
#define  XRXMAC_STAT_MSK_LCL_FLT_STAT_MSK	0x0000000000080000ULL
#define  XRXMAC_STAT_MSK_RFLT_DET		0x0000000000040000ULL
#define  XRXMAC_STAT_MSK_LFLT_CNT_EXP		0x0000000000020000ULL
#define  XRXMAC_STAT_MSK_PHY_MDINT		0x0000000000010000ULL
#define  XRXMAC_STAT_MSK_RXFRAG_CNT_EXP		0x0000000000008000ULL
#define  XRXMAC_STAT_MSK_RXMULTF_CNT_EXP	0x0000000000004000ULL
#define  XRXMAC_STAT_MSK_RXBCAST_CNT_EXP	0x0000000000002000ULL
#define  XRXMAC_STAT_MSK_RXHIST6_CNT_EXP	0x0000000000001000ULL
#define  XRXMAC_STAT_MSK_RXHIST5_CNT_EXP	0x0000000000000800ULL
#define  XRXMAC_STAT_MSK_RXHIST4_CNT_EXP	0x0000000000000400ULL
#define  XRXMAC_STAT_MSK_RXHIST3_CNT_EXP	0x0000000000000200ULL
#define  XRXMAC_STAT_MSK_RXHIST2_CNT_EXP	0x0000000000000100ULL
#define  XRXMAC_STAT_MSK_RXHIST1_CNT_EXP	0x0000000000000080ULL
#define  XRXMAC_STAT_MSK_RXOCTET_CNT_EXP	0x0000000000000040ULL
#define  XRXMAC_STAT_MSK_CVIOLERR_CNT_EXP	0x0000000000000020ULL
#define  XRXMAC_STAT_MSK_LENERR_CNT_EXP		0x0000000000000010ULL
#define  XRXMAC_STAT_MSK_CRCERR_CNT_EXP		0x0000000000000008ULL
#define  XRXMAC_STAT_MSK_RXUFLOW_CNT_EXP	0x0000000000000004ULL
#define  XRXMAC_STAT_MSK_RXOFLOW_CNT_EXP	0x0000000000000002ULL
#define  XRXMAC_STAT_MSK_FRAME_RCVD		0x0000000000000001ULL

#define XMAC_FC_MSK			0x00050UL
#define  XMAC_FC_MSK_TX_MAC_NPAUSE	0x0000000000000004ULL
#define  XMAC_FC_MSK_TX_MAC_PAUSE	0x0000000000000002ULL
#define  XMAC_FC_MSK_RX_MAC_RPAUSE	0x0000000000000001ULL

#define XMAC_CONFIG			0x00060UL
#define  XMAC_CONFIG_SEL_CLK_25MHZ	0x0000000080000000ULL
#define  XMAC_CONFIG_1G_PCS_BYPASS	0x0000000040000000ULL
#define  XMAC_CONFIG_10G_XPCS_BYPASS	0x0000000020000000ULL
#define  XMAC_CONFIG_MODE_MASK		0x0000000018000000ULL
#define  XMAC_CONFIG_MODE_XGMII		0x0000000000000000ULL
#define  XMAC_CONFIG_MODE_GMII		0x0000000008000000ULL
#define  XMAC_CONFIG_MODE_MII		0x0000000010000000ULL
#define  XMAC_CONFIG_LFS_DISABLE	0x0000000004000000ULL
#define  XMAC_CONFIG_LOOPBACK		0x0000000002000000ULL
#define  XMAC_CONFIG_TX_OUTPUT_EN	0x0000000001000000ULL
#define  XMAC_CONFIG_SEL_POR_CLK_SRC	0x0000000000800000ULL
#define  XMAC_CONFIG_LED_POLARITY	0x0000000000400000ULL
#define  XMAC_CONFIG_FORCE_LED_ON	0x0000000000200000ULL
#define  XMAC_CONFIG_PASS_FLOW_CTRL	0x0000000000100000ULL
#define  XMAC_CONFIG_RCV_PAUSE_ENABLE	0x0000000000080000ULL
#define  XMAC_CONFIG_MAC2IPP_PKT_CNT_EN	0x0000000000040000ULL
#define  XMAC_CONFIG_STRIP_CRC		0x0000000000020000ULL
#define  XMAC_CONFIG_ADDR_FILTER_EN	0x0000000000010000ULL
#define  XMAC_CONFIG_HASH_FILTER_EN	0x0000000000008000ULL
#define  XMAC_CONFIG_RX_CODEV_CHK_DIS	0x0000000000004000ULL
#define  XMAC_CONFIG_RESERVED_MULTICAST	0x0000000000002000ULL
#define  XMAC_CONFIG_RX_CRC_CHK_DIS	0x0000000000001000ULL
#define  XMAC_CONFIG_ERR_CHK_DIS	0x0000000000000800ULL
#define  XMAC_CONFIG_PROMISC_GROUP	0x0000000000000400ULL
#define  XMAC_CONFIG_PROMISCUOUS	0x0000000000000200ULL
#define  XMAC_CONFIG_RX_MAC_ENABLE	0x0000000000000100ULL
#define  XMAC_CONFIG_WARNING_MSG_EN	0x0000000000000080ULL
#define  XMAC_CONFIG_ALWAYS_NO_CRC	0x0000000000000008ULL
#define  XMAC_CONFIG_VAR_MIN_IPG_EN	0x0000000000000004ULL
#define  XMAC_CONFIG_STRETCH_MODE	0x0000000000000002ULL
#define  XMAC_CONFIG_TX_ENABLE		0x0000000000000001ULL

#define XMAC_IPG			0x00080UL
#define  XMAC_IPG_STRETCH_CONST		0x0000000000e00000ULL
#define  XMAC_IPG_STRETCH_CONST_SHIFT	21
#define  XMAC_IPG_STRETCH_RATIO		0x00000000001f0000ULL
#define  XMAC_IPG_STRETCH_RATIO_SHIFT	16
#define  XMAC_IPG_IPG_MII_GMII		0x000000000000ff00ULL
#define  XMAC_IPG_IPG_MII_GMII_SHIFT	8
#define  XMAC_IPG_IPG_XGMII		0x0000000000000007ULL
#define  XMAC_IPG_IPG_XGMII_SHIFT	0

#define IPG_12_15_XGMII			3
#define IPG_16_19_XGMII			4
#define IPG_20_23_XGMII			5
#define IPG_12_MII_GMII			10
#define IPG_13_MII_GMII			11
#define IPG_14_MII_GMII			12
#define IPG_15_MII_GMII			13
#define IPG_16_MII_GMII			14

#define XMAC_MIN			0x00088UL
#define  XMAC_MIN_RX_MIN_PKT_SIZE	0x000000003ff00000ULL
#define  XMAC_MIN_RX_MIN_PKT_SIZE_SHFT	20
#define  XMAC_MIN_SLOT_TIME		0x000000000003fc00ULL
#define  XMAC_MIN_SLOT_TIME_SHFT	10
#define  XMAC_MIN_TX_MIN_PKT_SIZE	0x00000000000003ffULL
#define  XMAC_MIN_TX_MIN_PKT_SIZE_SHFT	0

#define XMAC_MAX			0x00090UL
#define  XMAC_MAX_FRAME_SIZE		0x0000000000003fffULL
#define  XMAC_MAX_FRAME_SIZE_SHFT	0

#define XMAC_ADDR0			0x000a0UL
#define  XMAC_ADDR0_ADDR0		0x000000000000ffffULL

#define XMAC_ADDR1			0x000a8UL
#define  XMAC_ADDR1_ADDR1		0x000000000000ffffULL

#define XMAC_ADDR2			0x000b0UL
#define  XMAC_ADDR2_ADDR2		0x000000000000ffffULL

#define XMAC_ADDR_CMPEN			0x00208UL
#define  XMAC_ADDR_CMPEN_EN15		0x0000000000008000ULL
#define  XMAC_ADDR_CMPEN_EN14		0x0000000000004000ULL
#define  XMAC_ADDR_CMPEN_EN13		0x0000000000002000ULL
#define  XMAC_ADDR_CMPEN_EN12		0x0000000000001000ULL
#define  XMAC_ADDR_CMPEN_EN11		0x0000000000000800ULL
#define  XMAC_ADDR_CMPEN_EN10		0x0000000000000400ULL
#define  XMAC_ADDR_CMPEN_EN9		0x0000000000000200ULL
#define  XMAC_ADDR_CMPEN_EN8		0x0000000000000100ULL
#define  XMAC_ADDR_CMPEN_EN7		0x0000000000000080ULL
#define  XMAC_ADDR_CMPEN_EN6		0x0000000000000040ULL
#define  XMAC_ADDR_CMPEN_EN5		0x0000000000000020ULL
#define  XMAC_ADDR_CMPEN_EN4		0x0000000000000010ULL
#define  XMAC_ADDR_CMPEN_EN3		0x0000000000000008ULL
#define  XMAC_ADDR_CMPEN_EN2		0x0000000000000004ULL
#define  XMAC_ADDR_CMPEN_EN1		0x0000000000000002ULL
#define  XMAC_ADDR_CMPEN_EN0		0x0000000000000001ULL

#define XMAC_NUM_ALT_ADDR		16

#define XMAC_ALT_ADDR0(NUM)		(0x00218UL + (NUM)*0x18UL)
#define  XMAC_ALT_ADDR0_ADDR0		0x000000000000ffffULL

#define XMAC_ALT_ADDR1(NUM)		(0x00220UL + (NUM)*0x18UL)
#define  XMAC_ALT_ADDR1_ADDR1		0x000000000000ffffULL

#define XMAC_ALT_ADDR2(NUM)		(0x00228UL + (NUM)*0x18UL)
#define  XMAC_ALT_ADDR2_ADDR2		0x000000000000ffffULL

#define XMAC_ADD_FILT0			0x00818UL
#define  XMAC_ADD_FILT0_FILT0		0x000000000000ffffULL

#define XMAC_ADD_FILT1			0x00820UL
#define  XMAC_ADD_FILT1_FILT1		0x000000000000ffffULL

#define XMAC_ADD_FILT2			0x00828UL
#define  XMAC_ADD_FILT2_FILT2		0x000000000000ffffULL

#define XMAC_ADD_FILT12_MASK		0x00830UL
#define  XMAC_ADD_FILT12_MASK_VAL	0x00000000000000ffULL

#define XMAC_ADD_FILT00_MASK		0x00838UL
#define  XMAC_ADD_FILT00_MASK_VAL	0x000000000000ffffULL

#define XMAC_HASH_TBL(NUM)		(0x00840UL + (NUM) * 0x8UL)
#define XMAC_HASH_TBL_VAL		0x000000000000ffffULL

#define XMAC_NUM_HOST_INFO		20

#define XMAC_HOST_INFO(NUM)		(0x00900UL + (NUM) * 0x8UL)

#define XMAC_PA_DATA0			0x00b80UL
#define XMAC_PA_DATA0_VAL		0x00000000ffffffffULL

#define XMAC_PA_DATA1			0x00b88UL
#define XMAC_PA_DATA1_VAL		0x00000000ffffffffULL

#define XMAC_DEBUG_SEL			0x00b90UL
#define  XMAC_DEBUG_SEL_XMAC		0x0000000000000078ULL
#define  XMAC_DEBUG_SEL_MAC		0x0000000000000007ULL

#define XMAC_TRAIN_VEC			0x00b98UL
#define  XMAC_TRAIN_VEC_VAL		0x00000000ffffffffULL

#define RXMAC_BT_CNT			0x00100UL
#define  RXMAC_BT_CNT_COUNT		0x00000000ffffffffULL

#define RXMAC_BC_FRM_CNT		0x00108UL
#define  RXMAC_BC_FRM_CNT_COUNT		0x00000000001fffffULL

#define RXMAC_MC_FRM_CNT		0x00110UL
#define  RXMAC_MC_FRM_CNT_COUNT		0x00000000001fffffULL

#define RXMAC_FRAG_CNT			0x00118UL
#define  RXMAC_FRAG_CNT_COUNT		0x00000000001fffffULL

#define RXMAC_HIST_CNT1			0x00120UL
#define  RXMAC_HIST_CNT1_COUNT		0x00000000001fffffULL

#define RXMAC_HIST_CNT2			0x00128UL
#define  RXMAC_HIST_CNT2_COUNT		0x00000000001fffffULL

#define RXMAC_HIST_CNT3			0x00130UL
#define  RXMAC_HIST_CNT3_COUNT		0x00000000000fffffULL

#define RXMAC_HIST_CNT4			0x00138UL
#define  RXMAC_HIST_CNT4_COUNT		0x000000000007ffffULL

#define RXMAC_HIST_CNT5			0x00140UL
#define  RXMAC_HIST_CNT5_COUNT		0x000000000003ffffULL

#define RXMAC_HIST_CNT6			0x00148UL
#define  RXMAC_HIST_CNT6_COUNT		0x000000000000ffffULL

#define RXMAC_MPSZER_CNT		0x00150UL
#define  RXMAC_MPSZER_CNT_COUNT		0x00000000000000ffULL

#define RXMAC_CRC_ER_CNT		0x00158UL
#define  RXMAC_CRC_ER_CNT_COUNT		0x00000000000000ffULL

#define RXMAC_CD_VIO_CNT		0x00160UL
#define  RXMAC_CD_VIO_CNT_COUNT		0x00000000000000ffULL

#define RXMAC_ALIGN_ERR_CNT		0x00168UL
#define  RXMAC_ALIGN_ERR_CNT_COUNT	0x00000000000000ffULL

#define TXMAC_FRM_CNT			0x00170UL
#define  TXMAC_FRM_CNT_COUNT		0x00000000ffffffffULL

#define TXMAC_BYTE_CNT			0x00178UL
#define  TXMAC_BYTE_CNT_COUNT		0x00000000ffffffffULL

#define LINK_FAULT_CNT			0x00180UL
#define  LINK_FAULT_CNT_COUNT		0x00000000000000ffULL

#define RXMAC_HIST_CNT7			0x00188UL
#define  RXMAC_HIST_CNT7_COUNT		0x0000000007ffffffULL

#define XMAC_SM_REG			0x001a8UL
#define  XMAC_SM_REG_STATE		0x00000000ffffffffULL

#define XMAC_INTER1			0x001b0UL
#define  XMAC_INTERN1_SIGNALS1		0x00000000ffffffffULL

#define XMAC_INTER2			0x001b8UL
#define  XMAC_INTERN2_SIGNALS2		0x00000000ffffffffULL

/* BMAC registers, offset from np->mac_regs  */

#define BTXMAC_SW_RST			0x00000UL
#define  BTXMAC_SW_RST_RESET		0x0000000000000001ULL

#define BRXMAC_SW_RST			0x00008UL
#define  BRXMAC_SW_RST_RESET		0x0000000000000001ULL

#define BMAC_SEND_PAUSE			0x00010UL
#define  BMAC_SEND_PAUSE_SEND		0x0000000000010000ULL
#define  BMAC_SEND_PAUSE_TIME		0x000000000000ffffULL

#define BTXMAC_STATUS			0x00020UL
#define  BTXMAC_STATUS_XMIT		0x0000000000000001ULL
#define  BTXMAC_STATUS_UNDERRUN		0x0000000000000002ULL
#define  BTXMAC_STATUS_MAX_PKT_ERR	0x0000000000000004ULL
#define  BTXMAC_STATUS_BYTE_CNT_EXP	0x0000000000000400ULL
#define  BTXMAC_STATUS_FRAME_CNT_EXP	0x0000000000000800ULL

#define BRXMAC_STATUS			0x00028UL
#define  BRXMAC_STATUS_RX_PKT		0x0000000000000001ULL
#define  BRXMAC_STATUS_OVERFLOW		0x0000000000000002ULL
#define  BRXMAC_STATUS_FRAME_CNT_EXP	0x0000000000000004ULL
#define  BRXMAC_STATUS_ALIGN_ERR_EXP	0x0000000000000008ULL
#define  BRXMAC_STATUS_CRC_ERR_EXP	0x0000000000000010ULL
#define  BRXMAC_STATUS_LEN_ERR_EXP	0x0000000000000020ULL

#define BMAC_CTRL_STATUS		0x00030UL
#define  BMAC_CTRL_STATUS_PAUSE_RECV	0x0000000000000001ULL
#define  BMAC_CTRL_STATUS_PAUSE		0x0000000000000002ULL
#define  BMAC_CTRL_STATUS_NOPAUSE	0x0000000000000004ULL
#define  BMAC_CTRL_STATUS_TIME		0x00000000ffff0000ULL
#define  BMAC_CTRL_STATUS_TIME_SHIFT	16

#define BTXMAC_STATUS_MASK		0x00040UL
#define BRXMAC_STATUS_MASK		0x00048UL
#define BMAC_CTRL_STATUS_MASK		0x00050UL

#define BTXMAC_CONFIG			0x00060UL
#define  BTXMAC_CONFIG_ENABLE		0x0000000000000001ULL
#define  BTXMAC_CONFIG_FCS_DISABLE	0x0000000000000002ULL

#define BRXMAC_CONFIG			0x00068UL
#define  BRXMAC_CONFIG_DISCARD_DIS	0x0000000000000080ULL
#define  BRXMAC_CONFIG_ADDR_FILT_EN	0x0000000000000040ULL
#define  BRXMAC_CONFIG_HASH_FILT_EN	0x0000000000000020ULL
#define  BRXMAC_CONFIG_PROMISC_GRP	0x0000000000000010ULL
#define  BRXMAC_CONFIG_PROMISC		0x0000000000000008ULL
#define  BRXMAC_CONFIG_STRIP_FCS	0x0000000000000004ULL
#define  BRXMAC_CONFIG_STRIP_PAD	0x0000000000000002ULL
#define  BRXMAC_CONFIG_ENABLE		0x0000000000000001ULL

#define BMAC_CTRL_CONFIG		0x00070UL
#define  BMAC_CTRL_CONFIG_TX_PAUSE_EN	0x0000000000000001ULL
#define  BMAC_CTRL_CONFIG_RX_PAUSE_EN	0x0000000000000002ULL
#define  BMAC_CTRL_CONFIG_PASS_CTRL	0x0000000000000004ULL

#define BMAC_XIF_CONFIG			0x00078UL
#define  BMAC_XIF_CONFIG_TX_OUTPUT_EN	0x0000000000000001ULL
#define  BMAC_XIF_CONFIG_MII_LOOPBACK	0x0000000000000002ULL
#define  BMAC_XIF_CONFIG_GMII_MODE	0x0000000000000008ULL
#define  BMAC_XIF_CONFIG_LINK_LED	0x0000000000000020ULL
#define  BMAC_XIF_CONFIG_LED_POLARITY	0x0000000000000040ULL
#define  BMAC_XIF_CONFIG_25MHZ_CLOCK	0x0000000000000080ULL

#define BMAC_MIN_FRAME			0x000a0UL
#define  BMAC_MIN_FRAME_VAL		0x00000000000003ffULL

#define BMAC_MAX_FRAME			0x000a8UL
#define  BMAC_MAX_FRAME_MAX_BURST	0x000000003fff0000ULL
#define  BMAC_MAX_FRAME_MAX_BURST_SHIFT	16
#define  BMAC_MAX_FRAME_MAX_FRAME	0x0000000000003fffULL
#define  BMAC_MAX_FRAME_MAX_FRAME_SHIFT	0

#define BMAC_PREAMBLE_SIZE		0x000b0UL
#define  BMAC_PREAMBLE_SIZE_VAL		0x00000000000003ffULL

#define BMAC_CTRL_TYPE			0x000c8UL

#define BMAC_ADDR0			0x00100UL
#define  BMAC_ADDR0_ADDR0		0x000000000000ffffULL

#define BMAC_ADDR1			0x00108UL
#define  BMAC_ADDR1_ADDR1		0x000000000000ffffULL

#define BMAC_ADDR2			0x00110UL
#define  BMAC_ADDR2_ADDR2		0x000000000000ffffULL

#define BMAC_NUM_ALT_ADDR		6

#define BMAC_ALT_ADDR0(NUM)		(0x00118UL + (NUM)*0x18UL)
#define  BMAC_ALT_ADDR0_ADDR0		0x000000000000ffffULL

#define BMAC_ALT_ADDR1(NUM)		(0x00120UL + (NUM)*0x18UL)
#define  BMAC_ALT_ADDR1_ADDR1		0x000000000000ffffULL

#define BMAC_ALT_ADDR2(NUM)		(0x00128UL + (NUM)*0x18UL)
#define  BMAC_ALT_ADDR2_ADDR2		0x000000000000ffffULL

#define BMAC_FC_ADDR0			0x00268UL
#define  BMAC_FC_ADDR0_ADDR0		0x000000000000ffffULL

#define BMAC_FC_ADDR1			0x00270UL
#define  BMAC_FC_ADDR1_ADDR1		0x000000000000ffffULL

#define BMAC_FC_ADDR2			0x00278UL
#define  BMAC_FC_ADDR2_ADDR2		0x000000000000ffffULL

#define BMAC_ADD_FILT0			0x00298UL
#define  BMAC_ADD_FILT0_FILT0		0x000000000000ffffULL

#define BMAC_ADD_FILT1			0x002a0UL
#define  BMAC_ADD_FILT1_FILT1		0x000000000000ffffULL

#define BMAC_ADD_FILT2			0x002a8UL
#define  BMAC_ADD_FILT2_FILT2		0x000000000000ffffULL

#define BMAC_ADD_FILT12_MASK		0x002b0UL
#define  BMAC_ADD_FILT12_MASK_VAL	0x00000000000000ffULL

#define BMAC_ADD_FILT00_MASK		0x002b8UL
#define  BMAC_ADD_FILT00_MASK_VAL	0x000000000000ffffULL

#define BMAC_HASH_TBL(NUM)		(0x002c0UL + (NUM) * 0x8UL)
#define BMAC_HASH_TBL_VAL		0x000000000000ffffULL

#define BRXMAC_FRAME_CNT		0x00370
#define  BRXMAC_FRAME_CNT_COUNT		0x000000000000ffffULL

#define BRXMAC_MAX_LEN_ERR_CNT		0x00378

#define BRXMAC_ALIGN_ERR_CNT		0x00380
#define  BRXMAC_ALIGN_ERR_CNT_COUNT	0x000000000000ffffULL

#define BRXMAC_CRC_ERR_CNT		0x00388
#define  BRXMAC_ALIGN_ERR_CNT_COUNT	0x000000000000ffffULL

#define BRXMAC_CODE_VIOL_ERR_CNT	0x00390
#define  BRXMAC_CODE_VIOL_ERR_CNT_COUNT	0x000000000000ffffULL

#define BMAC_STATE_MACHINE		0x003a0

#define BMAC_ADDR_CMPEN			0x003f8UL
#define  BMAC_ADDR_CMPEN_EN15		0x0000000000008000ULL
#define  BMAC_ADDR_CMPEN_EN14		0x0000000000004000ULL
#define  BMAC_ADDR_CMPEN_EN13		0x0000000000002000ULL
#define  BMAC_ADDR_CMPEN_EN12		0x0000000000001000ULL
#define  BMAC_ADDR_CMPEN_EN11		0x0000000000000800ULL
#define  BMAC_ADDR_CMPEN_EN10		0x0000000000000400ULL
#define  BMAC_ADDR_CMPEN_EN9		0x0000000000000200ULL
#define  BMAC_ADDR_CMPEN_EN8		0x0000000000000100ULL
#define  BMAC_ADDR_CMPEN_EN7		0x0000000000000080ULL
#define  BMAC_ADDR_CMPEN_EN6		0x0000000000000040ULL
#define  BMAC_ADDR_CMPEN_EN5		0x0000000000000020ULL
#define  BMAC_ADDR_CMPEN_EN4		0x0000000000000010ULL
#define  BMAC_ADDR_CMPEN_EN3		0x0000000000000008ULL
#define  BMAC_ADDR_CMPEN_EN2		0x0000000000000004ULL
#define  BMAC_ADDR_CMPEN_EN1		0x0000000000000002ULL
#define  BMAC_ADDR_CMPEN_EN0		0x0000000000000001ULL

#define BMAC_NUM_HOST_INFO		9

#define BMAC_HOST_INFO(NUM)		(0x00400UL + (NUM) * 0x8UL)

#define BTXMAC_BYTE_CNT			0x00448UL
#define  BTXMAC_BYTE_CNT_COUNT		0x00000000ffffffffULL

#define BTXMAC_FRM_CNT			0x00450UL
#define  BTXMAC_FRM_CNT_COUNT		0x00000000ffffffffULL

#define BRXMAC_BYTE_CNT			0x00458UL
#define  BRXMAC_BYTE_CNT_COUNT		0x00000000ffffffffULL

#define HOST_INFO_MPR			0x0000000000000100ULL
#define HOST_INFO_MACRDCTBLN		0x0000000000000007ULL

/* XPCS registers, offset from np->regs + np->xpcs_off  */

#define XPCS_CONTROL1			(FZC_MAC + 0x00000UL)
#define  XPCS_CONTROL1_RESET		0x0000000000008000ULL
#define  XPCS_CONTROL1_LOOPBACK		0x0000000000004000ULL
#define  XPCS_CONTROL1_SPEED_SELECT3	0x0000000000002000ULL
#define  XPCS_CONTROL1_CSR_LOW_PWR	0x0000000000000800ULL
#define  XPCS_CONTROL1_CSR_SPEED1	0x0000000000000040ULL
#define  XPCS_CONTROL1_CSR_SPEED0	0x000000000000003cULL

#define XPCS_STATUS1			(FZC_MAC + 0x00008UL)
#define  XPCS_STATUS1_CSR_FAULT		0x0000000000000080ULL
#define  XPCS_STATUS1_CSR_RXLNK_STAT	0x0000000000000004ULL
#define  XPCS_STATUS1_CSR_LPWR_ABLE	0x0000000000000002ULL

#define XPCS_DEVICE_IDENTIFIER		(FZC_MAC + 0x00010UL)
#define  XPCS_DEVICE_IDENTIFIER_VAL	0x00000000ffffffffULL

#define XPCS_SPEED_ABILITY		(FZC_MAC + 0x00018UL)
#define  XPCS_SPEED_ABILITY_10GIG	0x0000000000000001ULL

#define XPCS_DEV_IN_PKG			(FZC_MAC + 0x00020UL)
#define  XPCS_DEV_IN_PKG_CSR_VEND2	0x0000000080000000ULL
#define  XPCS_DEV_IN_PKG_CSR_VEND1	0x0000000040000000ULL
#define  XPCS_DEV_IN_PKG_DTE_XS		0x0000000000000020ULL
#define  XPCS_DEV_IN_PKG_PHY_XS		0x0000000000000010ULL
#define  XPCS_DEV_IN_PKG_PCS		0x0000000000000008ULL
#define  XPCS_DEV_IN_PKG_WIS		0x0000000000000004ULL
#define  XPCS_DEV_IN_PKG_PMD_PMA	0x0000000000000002ULL
#define  XPCS_DEV_IN_PKG_CLS22		0x0000000000000001ULL

#define XPCS_CONTROL2			(FZC_MAC + 0x00028UL)
#define  XPCS_CONTROL2_CSR_PSC_SEL	0x0000000000000003ULL

#define XPCS_STATUS2			(FZC_MAC + 0x00030UL)
#define  XPCS_STATUS2_CSR_DEV_PRES	0x000000000000c000ULL
#define  XPCS_STATUS2_CSR_TX_FAULT	0x0000000000000800ULL
#define  XPCS_STATUS2_CSR_RCV_FAULT	0x0000000000000400ULL
#define  XPCS_STATUS2_TEN_GBASE_W	0x0000000000000004ULL
#define  XPCS_STATUS2_TEN_GBASE_X	0x0000000000000002ULL
#define  XPCS_STATUS2_TEN_GBASE_R	0x0000000000000001ULL

#define XPCS_PKG_ID			(FZC_MAC + 0x00038UL)
#define  XPCS_PKG_ID_VAL		0x00000000ffffffffULL

#define XPCS_STATUS(IDX)		(FZC_MAC + 0x00040UL)
#define  XPCS_STATUS_CSR_LANE_ALIGN	0x0000000000001000ULL
#define  XPCS_STATUS_CSR_PATTEST_CAP	0x0000000000000800ULL
#define  XPCS_STATUS_CSR_LANE3_SYNC	0x0000000000000008ULL
#define  XPCS_STATUS_CSR_LANE2_SYNC	0x0000000000000004ULL
#define  XPCS_STATUS_CSR_LANE1_SYNC	0x0000000000000002ULL
#define  XPCS_STATUS_CSR_LANE0_SYNC	0x0000000000000001ULL

#define XPCS_TEST_CONTROL		(FZC_MAC + 0x00048UL)
#define  XPCS_TEST_CONTROL_TXTST_EN	0x0000000000000004ULL
#define  XPCS_TEST_CONTROL_TPAT_SEL	0x0000000000000003ULL

#define XPCS_CFG_VENDOR1		(FZC_MAC + 0x00050UL)
#define  XPCS_CFG_VENDOR1_DBG_IOTST	0x0000000000000080ULL
#define  XPCS_CFG_VENDOR1_DBG_SEL	0x0000000000000078ULL
#define  XPCS_CFG_VENDOR1_BYPASS_DET	0x0000000000000004ULL
#define  XPCS_CFG_VENDOR1_TXBUF_EN	0x0000000000000002ULL
#define  XPCS_CFG_VENDOR1_XPCS_EN	0x0000000000000001ULL

#define XPCS_DIAG_VENDOR2		(FZC_MAC + 0x00058UL)
#define  XPCS_DIAG_VENDOR2_SSM_LANE3	0x0000000001e00000ULL
#define  XPCS_DIAG_VENDOR2_SSM_LANE2	0x00000000001e0000ULL
#define  XPCS_DIAG_VENDOR2_SSM_LANE1	0x000000000001e000ULL
#define  XPCS_DIAG_VENDOR2_SSM_LANE0	0x0000000000001e00ULL
#define  XPCS_DIAG_VENDOR2_EBUF_SM	0x00000000000001feULL
#define  XPCS_DIAG_VENDOR2_RCV_SM	0x0000000000000001ULL

#define XPCS_MASK1			(FZC_MAC + 0x00060UL)
#define  XPCS_MASK1_FAULT_MASK		0x0000000000000080ULL
#define  XPCS_MASK1_RXALIGN_STAT_MSK	0x0000000000000004ULL

#define XPCS_PKT_COUNT			(FZC_MAC + 0x00068UL)
#define  XPCS_PKT_COUNT_TX		0x00000000ffff0000ULL
#define  XPCS_PKT_COUNT_RX		0x000000000000ffffULL

#define XPCS_TX_SM			(FZC_MAC + 0x00070UL)
#define  XPCS_TX_SM_VAL			0x000000000000000fULL

#define XPCS_DESKEW_ERR_CNT		(FZC_MAC + 0x00078UL)
#define  XPCS_DESKEW_ERR_CNT_VAL	0x00000000000000ffULL

#define XPCS_SYMERR_CNT01		(FZC_MAC + 0x00080UL)
#define  XPCS_SYMERR_CNT01_LANE1	0x00000000ffff0000ULL
#define  XPCS_SYMERR_CNT01_LANE0	0x000000000000ffffULL

#define XPCS_SYMERR_CNT23		(FZC_MAC + 0x00088UL)
#define  XPCS_SYMERR_CNT23_LANE3	0x00000000ffff0000ULL
#define  XPCS_SYMERR_CNT23_LANE2	0x000000000000ffffULL

#define XPCS_TRAINING_VECTOR		(FZC_MAC + 0x00090UL)
#define  XPCS_TRAINING_VECTOR_VAL	0x00000000ffffffffULL

/* PCS registers, offset from np->regs + np->pcs_off  */

#define PCS_MII_CTL			(FZC_MAC + 0x00000UL)
#define  PCS_MII_CTL_RST		0x0000000000008000ULL
#define  PCS_MII_CTL_10_100_SPEED	0x0000000000002000ULL
#define  PCS_MII_AUTONEG_EN		0x0000000000001000ULL
#define  PCS_MII_PWR_DOWN		0x0000000000000800ULL
#define  PCS_MII_ISOLATE		0x0000000000000400ULL
#define  PCS_MII_AUTONEG_RESTART	0x0000000000000200ULL
#define  PCS_MII_DUPLEX			0x0000000000000100ULL
#define  PCS_MII_COLL_TEST		0x0000000000000080ULL
#define  PCS_MII_1000MB_SPEED		0x0000000000000040ULL

#define PCS_MII_STAT			(FZC_MAC + 0x00008UL)
#define  PCS_MII_STAT_EXT_STATUS	0x0000000000000100ULL
#define  PCS_MII_STAT_AUTONEG_DONE	0x0000000000000020ULL
#define  PCS_MII_STAT_REMOTE_FAULT	0x0000000000000010ULL
#define  PCS_MII_STAT_AUTONEG_ABLE	0x0000000000000008ULL
#define  PCS_MII_STAT_LINK_STATUS	0x0000000000000004ULL
#define  PCS_MII_STAT_JABBER_DET	0x0000000000000002ULL
#define  PCS_MII_STAT_EXT_CAP		0x0000000000000001ULL

#define PCS_MII_ADV			(FZC_MAC + 0x00010UL)
#define  PCS_MII_ADV_NEXT_PAGE		0x0000000000008000ULL
#define  PCS_MII_ADV_ACK		0x0000000000004000ULL
#define  PCS_MII_ADV_REMOTE_FAULT	0x0000000000003000ULL
#define  PCS_MII_ADV_ASM_DIR		0x0000000000000100ULL
#define  PCS_MII_ADV_PAUSE		0x0000000000000080ULL
#define  PCS_MII_ADV_HALF_DUPLEX	0x0000000000000040ULL
#define  PCS_MII_ADV_FULL_DUPLEX	0x0000000000000020ULL

#define PCS_MII_PARTNER			(FZC_MAC + 0x00018UL)
#define  PCS_MII_PARTNER_NEXT_PAGE	0x0000000000008000ULL
#define  PCS_MII_PARTNER_ACK		0x0000000000004000ULL
#define  PCS_MII_PARTNER_REMOTE_FAULT	0x0000000000002000ULL
#define  PCS_MII_PARTNER_PAUSE		0x0000000000000180ULL
#define  PCS_MII_PARTNER_HALF_DUPLEX	0x0000000000000040ULL
#define  PCS_MII_PARTNER_FULL_DUPLEX	0x0000000000000020ULL

#define PCS_CONF			(FZC_MAC + 0x00020UL)
#define  PCS_CONF_MASK			0x0000000000000040ULL
#define  PCS_CONF_10MS_TMR_OVERRIDE	0x0000000000000020ULL
#define  PCS_CONF_JITTER_STUDY		0x0000000000000018ULL
#define  PCS_CONF_SIGDET_ACTIVE_LOW	0x0000000000000004ULL
#define  PCS_CONF_SIGDET_OVERRIDE	0x0000000000000002ULL
#define  PCS_CONF_ENABLE		0x0000000000000001ULL

#define PCS_STATE			(FZC_MAC + 0x00028UL)
#define  PCS_STATE_D_PARTNER_FAIL	0x0000000020000000ULL
#define  PCS_STATE_D_WAIT_C_CODES_ACK	0x0000000010000000ULL
#define  PCS_STATE_D_SYNC_LOSS		0x0000000008000000ULL
#define  PCS_STATE_D_NO_GOOD_C_CODES	0x0000000004000000ULL
#define  PCS_STATE_D_SERDES		0x0000000002000000ULL
#define  PCS_STATE_D_BREAKLINK_C_CODES	0x0000000001000000ULL
#define  PCS_STATE_L_SIGDET		0x0000000000400000ULL
#define  PCS_STATE_L_SYNC_LOSS		0x0000000000200000ULL
#define  PCS_STATE_L_C_CODES		0x0000000000100000ULL
#define  PCS_STATE_LINK_CFG_STATE	0x000000000001e000ULL
#define  PCS_STATE_SEQ_DET_STATE	0x0000000000001800ULL
#define  PCS_STATE_WORD_SYNC_STATE	0x0000000000000700ULL
#define  PCS_STATE_NO_IDLE		0x000000000000000fULL

#define PCS_INTERRUPT			(FZC_MAC + 0x00030UL)
#define  PCS_INTERRUPT_LSTATUS		0x0000000000000004ULL

#define PCS_DPATH_MODE			(FZC_MAC + 0x000a0UL)
#define  PCS_DPATH_MODE_PCS		0x0000000000000000ULL
#define  PCS_DPATH_MODE_MII		0x0000000000000002ULL
#define  PCS_DPATH_MODE_LINKUP_F_ENAB	0x0000000000000001ULL

#define PCS_PKT_CNT			(FZC_MAC + 0x000c0UL)
#define  PCS_PKT_CNT_RX			0x0000000007ff0000ULL
#define  PCS_PKT_CNT_TX			0x00000000000007ffULL

#define MIF_BB_MDC			(FZC_MAC + 0x16000UL)
#define  MIF_BB_MDC_CLK			0x0000000000000001ULL

#define MIF_BB_MDO			(FZC_MAC + 0x16008UL)
#define  MIF_BB_MDO_DAT			0x0000000000000001ULL

#define MIF_BB_MDO_EN			(FZC_MAC + 0x16010UL)
#define  MIF_BB_MDO_EN_VAL		0x0000000000000001ULL

#define MIF_FRAME_OUTPUT		(FZC_MAC + 0x16018UL)
#define  MIF_FRAME_OUTPUT_ST		0x00000000c0000000ULL
#define  MIF_FRAME_OUTPUT_ST_SHIFT	30
#define  MIF_FRAME_OUTPUT_OP_ADDR	0x0000000000000000ULL
#define  MIF_FRAME_OUTPUT_OP_WRITE	0x0000000010000000ULL
#define  MIF_FRAME_OUTPUT_OP_READ_INC	0x0000000020000000ULL
#define  MIF_FRAME_OUTPUT_OP_READ	0x0000000030000000ULL
#define  MIF_FRAME_OUTPUT_OP_SHIFT	28
#define  MIF_FRAME_OUTPUT_PORT		0x000000000f800000ULL
#define  MIF_FRAME_OUTPUT_PORT_SHIFT	23
#define  MIF_FRAME_OUTPUT_REG		0x00000000007c0000ULL
#define  MIF_FRAME_OUTPUT_REG_SHIFT	18
#define  MIF_FRAME_OUTPUT_TA		0x0000000000030000ULL
#define  MIF_FRAME_OUTPUT_TA_SHIFT	16
#define  MIF_FRAME_OUTPUT_DATA		0x000000000000ffffULL
#define  MIF_FRAME_OUTPUT_DATA_SHIFT	0

#define MDIO_ADDR_OP(port, dev, reg) \
	((0 << MIF_FRAME_OUTPUT_ST_SHIFT) | \
	 MIF_FRAME_OUTPUT_OP_ADDR | \
	 (port << MIF_FRAME_OUTPUT_PORT_SHIFT) | \
	 (dev << MIF_FRAME_OUTPUT_REG_SHIFT) | \
	 (0x2 << MIF_FRAME_OUTPUT_TA_SHIFT) | \
	 (reg << MIF_FRAME_OUTPUT_DATA_SHIFT))

#define MDIO_READ_OP(port, dev) \
	((0 << MIF_FRAME_OUTPUT_ST_SHIFT) | \
	 MIF_FRAME_OUTPUT_OP_READ | \
	 (port << MIF_FRAME_OUTPUT_PORT_SHIFT) | \
	 (dev << MIF_FRAME_OUTPUT_REG_SHIFT) | \
	 (0x2 << MIF_FRAME_OUTPUT_TA_SHIFT))

#define MDIO_WRITE_OP(port, dev, data) \
	((0 << MIF_FRAME_OUTPUT_ST_SHIFT) | \
	 MIF_FRAME_OUTPUT_OP_WRITE | \
	 (port << MIF_FRAME_OUTPUT_PORT_SHIFT) | \
	 (dev << MIF_FRAME_OUTPUT_REG_SHIFT) | \
	 (0x2 << MIF_FRAME_OUTPUT_TA_SHIFT) | \
	 (data << MIF_FRAME_OUTPUT_DATA_SHIFT))

#define MII_READ_OP(port, reg) \
	((1 << MIF_FRAME_OUTPUT_ST_SHIFT) | \
	 (2 << MIF_FRAME_OUTPUT_OP_SHIFT) | \
	 (port << MIF_FRAME_OUTPUT_PORT_SHIFT) | \
	 (reg << MIF_FRAME_OUTPUT_REG_SHIFT) | \
	 (0x2 << MIF_FRAME_OUTPUT_TA_SHIFT))

#define MII_WRITE_OP(port, reg, data) \
	((1 << MIF_FRAME_OUTPUT_ST_SHIFT) | \
	 (1 << MIF_FRAME_OUTPUT_OP_SHIFT) | \
	 (port << MIF_FRAME_OUTPUT_PORT_SHIFT) | \
	 (reg << MIF_FRAME_OUTPUT_REG_SHIFT) | \
	 (0x2 << MIF_FRAME_OUTPUT_TA_SHIFT) | \
	 (data << MIF_FRAME_OUTPUT_DATA_SHIFT))

#define MIF_CONFIG			(FZC_MAC + 0x16020UL)
#define  MIF_CONFIG_ATCA_GE		0x0000000000010000ULL
#define  MIF_CONFIG_INDIRECT_MODE	0x0000000000008000ULL
#define  MIF_CONFIG_POLL_PRT_PHYADDR	0x0000000000003c00ULL
#define  MIF_CONFIG_POLL_DEV_REG_ADDR	0x00000000000003e0ULL
#define  MIF_CONFIG_BB_MODE		0x0000000000000010ULL
#define  MIF_CONFIG_POLL_EN		0x0000000000000008ULL
#define  MIF_CONFIG_BB_SER_SEL		0x0000000000000006ULL
#define  MIF_CONFIG_MANUAL_MODE		0x0000000000000001ULL

#define MIF_POLL_STATUS			(FZC_MAC + 0x16028UL)
#define  MIF_POLL_STATUS_DATA		0x00000000ffff0000ULL
#define  MIF_POLL_STATUS_STAT		0x000000000000ffffULL

#define MIF_POLL_MASK			(FZC_MAC + 0x16030UL)
#define  MIF_POLL_MASK_VAL		0x000000000000ffffULL

#define MIF_SM				(FZC_MAC + 0x16038UL)
#define  MIF_SM_PORT_ADDR		0x00000000001f0000ULL
#define  MIF_SM_MDI_1			0x0000000000004000ULL
#define  MIF_SM_MDI_0			0x0000000000002400ULL
#define  MIF_SM_MDCLK			0x0000000000001000ULL
#define  MIF_SM_MDO_EN			0x0000000000000800ULL
#define  MIF_SM_MDO			0x0000000000000400ULL
#define  MIF_SM_MDI			0x0000000000000200ULL
#define  MIF_SM_CTL			0x00000000000001c0ULL
#define  MIF_SM_EX			0x000000000000003fULL

#define MIF_STATUS			(FZC_MAC + 0x16040UL)
#define  MIF_STATUS_MDINT1		0x0000000000000020ULL
#define  MIF_STATUS_MDINT0		0x0000000000000010ULL

#define MIF_MASK			(FZC_MAC + 0x16048UL)
#define  MIF_MASK_MDINT1		0x0000000000000020ULL
#define  MIF_MASK_MDINT0		0x0000000000000010ULL
#define  MIF_MASK_PEU_ERR		0x0000000000000008ULL
#define  MIF_MASK_YC			0x0000000000000004ULL
#define  MIF_MASK_XGE_ERR0		0x0000000000000002ULL
#define  MIF_MASK_MIF_INIT_DONE		0x0000000000000001ULL

#define ENET_SERDES_RESET		(FZC_MAC + 0x14000UL)
#define  ENET_SERDES_RESET_1		0x0000000000000002ULL
#define  ENET_SERDES_RESET_0		0x0000000000000001ULL

#define ENET_SERDES_CFG			(FZC_MAC + 0x14008UL)
#define  ENET_SERDES_BE_LOOPBACK	0x0000000000000002ULL
#define  ENET_SERDES_CFG_FORCE_RDY	0x0000000000000001ULL

#define ENET_SERDES_0_PLL_CFG		(FZC_MAC + 0x14010UL)
#define  ENET_SERDES_PLL_FBDIV0		0x0000000000000001ULL
#define  ENET_SERDES_PLL_FBDIV1		0x0000000000000002ULL
#define  ENET_SERDES_PLL_FBDIV2		0x0000000000000004ULL
#define  ENET_SERDES_PLL_HRATE0		0x0000000000000008ULL
#define  ENET_SERDES_PLL_HRATE1		0x0000000000000010ULL
#define  ENET_SERDES_PLL_HRATE2		0x0000000000000020ULL
#define  ENET_SERDES_PLL_HRATE3		0x0000000000000040ULL

#define ENET_SERDES_0_CTRL_CFG		(FZC_MAC + 0x14018UL)
#define  ENET_SERDES_CTRL_SDET_0	0x0000000000000001ULL
#define  ENET_SERDES_CTRL_SDET_1	0x0000000000000002ULL
#define  ENET_SERDES_CTRL_SDET_2	0x0000000000000004ULL
#define  ENET_SERDES_CTRL_SDET_3	0x0000000000000008ULL
#define  ENET_SERDES_CTRL_EMPH_0	0x0000000000000070ULL
#define  ENET_SERDES_CTRL_EMPH_0_SHIFT	4
#define  ENET_SERDES_CTRL_EMPH_1	0x0000000000000380ULL
#define  ENET_SERDES_CTRL_EMPH_1_SHIFT	7
#define  ENET_SERDES_CTRL_EMPH_2	0x0000000000001c00ULL
#define  ENET_SERDES_CTRL_EMPH_2_SHIFT	10
#define  ENET_SERDES_CTRL_EMPH_3	0x000000000000e000ULL
#define  ENET_SERDES_CTRL_EMPH_3_SHIFT	13
#define  ENET_SERDES_CTRL_LADJ_0	0x0000000000070000ULL
#define  ENET_SERDES_CTRL_LADJ_0_SHIFT	16
#define  ENET_SERDES_CTRL_LADJ_1	0x0000000000380000ULL
#define  ENET_SERDES_CTRL_LADJ_1_SHIFT	19
#define  ENET_SERDES_CTRL_LADJ_2	0x0000000001c00000ULL
#define  ENET_SERDES_CTRL_LADJ_2_SHIFT	22
#define  ENET_SERDES_CTRL_LADJ_3	0x000000000e000000ULL
#define  ENET_SERDES_CTRL_LADJ_3_SHIFT	25
#define  ENET_SERDES_CTRL_RXITERM_0	0x0000000010000000ULL
#define  ENET_SERDES_CTRL_RXITERM_1	0x0000000020000000ULL
#define  ENET_SERDES_CTRL_RXITERM_2	0x0000000040000000ULL
#define  ENET_SERDES_CTRL_RXITERM_3	0x0000000080000000ULL

#define ENET_SERDES_0_TEST_CFG		(FZC_MAC + 0x14020UL)
#define  ENET_SERDES_TEST_MD_0		0x0000000000000003ULL
#define  ENET_SERDES_TEST_MD_0_SHIFT	0
#define  ENET_SERDES_TEST_MD_1		0x000000000000000cULL
#define  ENET_SERDES_TEST_MD_1_SHIFT	2
#define  ENET_SERDES_TEST_MD_2		0x0000000000000030ULL
#define  ENET_SERDES_TEST_MD_2_SHIFT	4
#define  ENET_SERDES_TEST_MD_3		0x00000000000000c0ULL
#define  ENET_SERDES_TEST_MD_3_SHIFT	6

#define ENET_TEST_MD_NO_LOOPBACK	0x0
#define ENET_TEST_MD_EWRAP		0x1
#define ENET_TEST_MD_PAD_LOOPBACK	0x2
#define ENET_TEST_MD_REV_LOOPBACK	0x3

#define ENET_SERDES_1_PLL_CFG		(FZC_MAC + 0x14028UL)
#define ENET_SERDES_1_CTRL_CFG		(FZC_MAC + 0x14030UL)
#define ENET_SERDES_1_TEST_CFG		(FZC_MAC + 0x14038UL)

#define ENET_RGMII_CFG_REG		(FZC_MAC + 0x14040UL)

#define ESR_INT_SIGNALS			(FZC_MAC + 0x14800UL)
#define  ESR_INT_SIGNALS_ALL		0x00000000ffffffffULL
#define  ESR_INT_SIGNALS_P0_BITS	0x0000000033e0000fULL
#define  ESR_INT_SIGNALS_P1_BITS	0x000000000c1f00f0ULL
#define  ESR_INT_SRDY0_P0		0x0000000020000000ULL
#define  ESR_INT_DET0_P0		0x0000000010000000ULL
#define  ESR_INT_SRDY0_P1		0x0000000008000000ULL
#define  ESR_INT_DET0_P1		0x0000000004000000ULL
#define  ESR_INT_XSRDY_P0		0x0000000002000000ULL
#define  ESR_INT_XDP_P0_CH3		0x0000000001000000ULL
#define  ESR_INT_XDP_P0_CH2		0x0000000000800000ULL
#define  ESR_INT_XDP_P0_CH1		0x0000000000400000ULL
#define  ESR_INT_XDP_P0_CH0		0x0000000000200000ULL
#define  ESR_INT_XSRDY_P1		0x0000000000100000ULL
#define  ESR_INT_XDP_P1_CH3		0x0000000000080000ULL
#define  ESR_INT_XDP_P1_CH2		0x0000000000040000ULL
#define  ESR_INT_XDP_P1_CH1		0x0000000000020000ULL
#define  ESR_INT_XDP_P1_CH0		0x0000000000010000ULL
#define  ESR_INT_SLOSS_P1_CH3		0x0000000000000080ULL
#define  ESR_INT_SLOSS_P1_CH2		0x0000000000000040ULL
#define  ESR_INT_SLOSS_P1_CH1		0x0000000000000020ULL
#define  ESR_INT_SLOSS_P1_CH0		0x0000000000000010ULL
#define  ESR_INT_SLOSS_P0_CH3		0x0000000000000008ULL
#define  ESR_INT_SLOSS_P0_CH2		0x0000000000000004ULL
#define  ESR_INT_SLOSS_P0_CH1		0x0000000000000002ULL
#define  ESR_INT_SLOSS_P0_CH0		0x0000000000000001ULL

#define ESR_DEBUG_SEL			(FZC_MAC + 0x14808UL)
#define  ESR_DEBUG_SEL_VAL		0x000000000000003fULL

/* SerDes registers behind MIF */
#define NIU_ESR_DEV_ADDR		0x1e
#define ESR_BASE			0x0000

#define ESR_RXTX_COMM_CTRL_L		(ESR_BASE + 0x0000)
#define ESR_RXTX_COMM_CTRL_H		(ESR_BASE + 0x0001)

#define ESR_RXTX_RESET_CTRL_L		(ESR_BASE + 0x0002)
#define ESR_RXTX_RESET_CTRL_H		(ESR_BASE + 0x0003)

#define ESR_RX_POWER_CTRL_L		(ESR_BASE + 0x0004)
#define ESR_RX_POWER_CTRL_H		(ESR_BASE + 0x0005)

#define ESR_TX_POWER_CTRL_L		(ESR_BASE + 0x0006)
#define ESR_TX_POWER_CTRL_H		(ESR_BASE + 0x0007)

#define ESR_MISC_POWER_CTRL_L		(ESR_BASE + 0x0008)
#define ESR_MISC_POWER_CTRL_H		(ESR_BASE + 0x0009)

#define ESR_RXTX_CTRL_L(CHAN)		(ESR_BASE + 0x0080 + (CHAN) * 0x10)
#define ESR_RXTX_CTRL_H(CHAN)		(ESR_BASE + 0x0081 + (CHAN) * 0x10)
#define  ESR_RXTX_CTRL_BIASCNTL		0x80000000
#define  ESR_RXTX_CTRL_RESV1		0x7c000000
#define  ESR_RXTX_CTRL_TDENFIFO		0x02000000
#define  ESR_RXTX_CTRL_TDWS20		0x01000000
#define  ESR_RXTX_CTRL_VMUXLO		0x00c00000
#define  ESR_RXTX_CTRL_VMUXLO_SHIFT	22
#define  ESR_RXTX_CTRL_VPULSELO		0x00300000
#define  ESR_RXTX_CTRL_VPULSELO_SHIFT	20
#define  ESR_RXTX_CTRL_RESV2		0x000f0000
#define  ESR_RXTX_CTRL_RESV3		0x0000c000
#define  ESR_RXTX_CTRL_RXPRESWIN	0x00003000
#define  ESR_RXTX_CTRL_RXPRESWIN_SHIFT	12
#define  ESR_RXTX_CTRL_RESV4		0x00000800
#define  ESR_RXTX_CTRL_RISEFALL		0x00000700
#define  ESR_RXTX_CTRL_RISEFALL_SHIFT	8
#define  ESR_RXTX_CTRL_RESV5		0x000000fe
#define  ESR_RXTX_CTRL_ENSTRETCH	0x00000001

#define ESR_RXTX_TUNING_L(CHAN)		(ESR_BASE + 0x0082 + (CHAN) * 0x10)
#define ESR_RXTX_TUNING_H(CHAN)		(ESR_BASE + 0x0083 + (CHAN) * 0x10)

#define ESR_RX_SYNCCHAR_L(CHAN)		(ESR_BASE + 0x0084 + (CHAN) * 0x10)
#define ESR_RX_SYNCCHAR_H(CHAN)		(ESR_BASE + 0x0085 + (CHAN) * 0x10)

#define ESR_RXTX_TEST_L(CHAN)		(ESR_BASE + 0x0086 + (CHAN) * 0x10)
#define ESR_RXTX_TEST_H(CHAN)		(ESR_BASE + 0x0087 + (CHAN) * 0x10)

#define ESR_GLUE_CTRL0_L(CHAN)		(ESR_BASE + 0x0088 + (CHAN) * 0x10)
#define ESR_GLUE_CTRL0_H(CHAN)		(ESR_BASE + 0x0089 + (CHAN) * 0x10)
#define  ESR_GLUE_CTRL0_RESV1		0xf8000000
#define  ESR_GLUE_CTRL0_BLTIME		0x07000000
#define  ESR_GLUE_CTRL0_BLTIME_SHIFT	24
#define  ESR_GLUE_CTRL0_RESV2		0x00ff0000
#define  ESR_GLUE_CTRL0_RXLOS_TEST	0x00008000
#define  ESR_GLUE_CTRL0_RESV3		0x00004000
#define  ESR_GLUE_CTRL0_RXLOSENAB	0x00002000
#define  ESR_GLUE_CTRL0_FASTRESYNC	0x00001000
#define  ESR_GLUE_CTRL0_SRATE		0x00000f00
#define  ESR_GLUE_CTRL0_SRATE_SHIFT	8
#define  ESR_GLUE_CTRL0_THCNT		0x000000ff
#define  ESR_GLUE_CTRL0_THCNT_SHIFT	0

#define BLTIME_64_CYCLES		0
#define BLTIME_128_CYCLES		1
#define BLTIME_256_CYCLES		2
#define BLTIME_300_CYCLES		3
#define BLTIME_384_CYCLES		4
#define BLTIME_512_CYCLES		5
#define BLTIME_1024_CYCLES		6
#define BLTIME_2048_CYCLES		7

#define ESR_GLUE_CTRL1_L(CHAN)		(ESR_BASE + 0x008a + (CHAN) * 0x10)
#define ESR_GLUE_CTRL1_H(CHAN)		(ESR_BASE + 0x008b + (CHAN) * 0x10)
#define ESR_RXTX_TUNING1_L(CHAN)	(ESR_BASE + 0x00c2 + (CHAN) * 0x10)
#define ESR_RXTX_TUNING1_H(CHAN)	(ESR_BASE + 0x00c2 + (CHAN) * 0x10)
#define ESR_RXTX_TUNING2_L(CHAN)	(ESR_BASE + 0x0102 + (CHAN) * 0x10)
#define ESR_RXTX_TUNING2_H(CHAN)	(ESR_BASE + 0x0102 + (CHAN) * 0x10)
#define ESR_RXTX_TUNING3_L(CHAN)	(ESR_BASE + 0x0142 + (CHAN) * 0x10)
#define ESR_RXTX_TUNING3_H(CHAN)	(ESR_BASE + 0x0142 + (CHAN) * 0x10)

#define NIU_ESR2_DEV_ADDR		0x1e
#define ESR2_BASE			0x8000

#define ESR2_TI_PLL_CFG_L		(ESR2_BASE + 0x000)
#define ESR2_TI_PLL_CFG_H		(ESR2_BASE + 0x001)
#define  PLL_CFG_STD			0x00000c00
#define  PLL_CFG_STD_SHIFT		10
#define  PLL_CFG_LD			0x00000300
#define  PLL_CFG_LD_SHIFT		8
#define  PLL_CFG_MPY			0x0000001e
#define  PLL_CFG_MPY_SHIFT		1
#define  PLL_CFG_MPY_4X		0x0
#define  PLL_CFG_MPY_5X		0x00000002
#define  PLL_CFG_MPY_6X		0x00000004
#define  PLL_CFG_MPY_8X		0x00000008
#define  PLL_CFG_MPY_10X		0x0000000a
#define  PLL_CFG_MPY_12X		0x0000000c
#define  PLL_CFG_MPY_12P5X		0x0000000e
#define  PLL_CFG_ENPLL			0x00000001

#define ESR2_TI_PLL_STS_L		(ESR2_BASE + 0x002)
#define ESR2_TI_PLL_STS_H		(ESR2_BASE + 0x003)
#define  PLL_STS_LOCK			0x00000001

#define ESR2_TI_PLL_TEST_CFG_L		(ESR2_BASE + 0x004)
#define ESR2_TI_PLL_TEST_CFG_H		(ESR2_BASE + 0x005)
#define  PLL_TEST_INVPATT		0x00004000
#define  PLL_TEST_RATE			0x00003000
#define  PLL_TEST_RATE_SHIFT		12
#define  PLL_TEST_CFG_ENBSAC		0x00000400
#define  PLL_TEST_CFG_ENBSRX		0x00000200
#define  PLL_TEST_CFG_ENBSTX		0x00000100
#define  PLL_TEST_CFG_LOOPBACK_PAD	0x00000040
#define  PLL_TEST_CFG_LOOPBACK_CML_DIS	0x00000080
#define  PLL_TEST_CFG_LOOPBACK_CML_EN	0x000000c0
#define  PLL_TEST_CFG_CLKBYP		0x00000030
#define  PLL_TEST_CFG_CLKBYP_SHIFT	4
#define  PLL_TEST_CFG_EN_RXPATT		0x00000008
#define  PLL_TEST_CFG_EN_TXPATT		0x00000004
#define  PLL_TEST_CFG_TPATT		0x00000003
#define  PLL_TEST_CFG_TPATT_SHIFT	0

#define ESR2_TI_PLL_TX_CFG_L(CHAN)	(ESR2_BASE + 0x100 + (CHAN) * 4)
#define ESR2_TI_PLL_TX_CFG_H(CHAN)	(ESR2_BASE + 0x101 + (CHAN) * 4)
#define  PLL_TX_CFG_RDTCT		0x00600000
#define  PLL_TX_CFG_RDTCT_SHIFT		21
#define  PLL_TX_CFG_ENIDL		0x00100000
#define  PLL_TX_CFG_BSTX		0x00020000
#define  PLL_TX_CFG_ENFTP		0x00010000
#define  PLL_TX_CFG_DE			0x0000f000
#define  PLL_TX_CFG_DE_SHIFT		12
#define  PLL_TX_CFG_SWING_125MV		0x00000000
#define  PLL_TX_CFG_SWING_250MV		0x00000200
#define  PLL_TX_CFG_SWING_500MV		0x00000400
#define  PLL_TX_CFG_SWING_625MV		0x00000600
#define  PLL_TX_CFG_SWING_750MV		0x00000800
#define  PLL_TX_CFG_SWING_1000MV	0x00000a00
#define  PLL_TX_CFG_SWING_1250MV	0x00000c00
#define  PLL_TX_CFG_SWING_1375MV	0x00000e00
#define  PLL_TX_CFG_CM			0x00000100
#define  PLL_TX_CFG_INVPAIR		0x00000080
#define  PLL_TX_CFG_RATE		0x00000060
#define  PLL_TX_CFG_RATE_SHIFT		5
#define  PLL_TX_CFG_RATE_FULL		0x0
#define  PLL_TX_CFG_RATE_HALF		0x20
#define  PLL_TX_CFG_RATE_QUAD		0x40
#define  PLL_TX_CFG_BUSWIDTH		0x0000001c
#define  PLL_TX_CFG_BUSWIDTH_SHIFT	2
#define  PLL_TX_CFG_ENTEST		0x00000002
#define  PLL_TX_CFG_ENTX		0x00000001

#define ESR2_TI_PLL_TX_STS_L(CHAN)	(ESR2_BASE + 0x102 + (CHAN) * 4)
#define ESR2_TI_PLL_TX_STS_H(CHAN)	(ESR2_BASE + 0x103 + (CHAN) * 4)
#define  PLL_TX_STS_RDTCTIP		0x00000002
#define  PLL_TX_STS_TESTFAIL		0x00000001

#define ESR2_TI_PLL_RX_CFG_L(CHAN)	(ESR2_BASE + 0x120 + (CHAN) * 4)
#define ESR2_TI_PLL_RX_CFG_H(CHAN)	(ESR2_BASE + 0x121 + (CHAN) * 4)
#define  PLL_RX_CFG_BSINRXN		0x02000000
#define  PLL_RX_CFG_BSINRXP		0x01000000
#define  PLL_RX_CFG_EQ_MAX_LF		0x00000000
#define  PLL_RX_CFG_EQ_LP_ADAPTIVE	0x00080000
#define  PLL_RX_CFG_EQ_LP_1084MHZ	0x00400000
#define  PLL_RX_CFG_EQ_LP_805MHZ	0x00480000
#define  PLL_RX_CFG_EQ_LP_573MHZ	0x00500000
#define  PLL_RX_CFG_EQ_LP_402MHZ	0x00580000
#define  PLL_RX_CFG_EQ_LP_304MHZ	0x00600000
#define  PLL_RX_CFG_EQ_LP_216MHZ	0x00680000
#define  PLL_RX_CFG_EQ_LP_156MHZ	0x00700000
#define  PLL_RX_CFG_EQ_LP_135MHZ	0x00780000
#define  PLL_RX_CFG_EQ_SHIFT		19
#define  PLL_RX_CFG_CDR			0x00070000
#define  PLL_RX_CFG_CDR_SHIFT		16
#define  PLL_RX_CFG_LOS_DIS		0x00000000
#define  PLL_RX_CFG_LOS_HTHRESH		0x00004000
#define  PLL_RX_CFG_LOS_LTHRESH		0x00008000
#define  PLL_RX_CFG_ALIGN_DIS		0x00000000
#define  PLL_RX_CFG_ALIGN_ENA		0x00001000
#define  PLL_RX_CFG_ALIGN_JOG		0x00002000
#define  PLL_RX_CFG_TERM_VDDT		0x00000000
#define  PLL_RX_CFG_TERM_0P8VDDT	0x00000100
#define  PLL_RX_CFG_TERM_FLOAT		0x00000300
#define  PLL_RX_CFG_INVPAIR		0x00000080
#define  PLL_RX_CFG_RATE		0x00000060
#define  PLL_RX_CFG_RATE_SHIFT		5
#define  PLL_RX_CFG_RATE_FULL		0x0
#define  PLL_RX_CFG_RATE_HALF		0x20
#define  PLL_RX_CFG_RATE_QUAD		0x40
#define  PLL_RX_CFG_BUSWIDTH		0x0000001c
#define  PLL_RX_CFG_BUSWIDTH_SHIFT	2
#define  PLL_RX_CFG_ENTEST		0x00000002
#define  PLL_RX_CFG_ENRX		0x00000001

#define ESR2_TI_PLL_RX_STS_L(CHAN)	(ESR2_BASE + 0x122 + (CHAN) * 4)
#define ESR2_TI_PLL_RX_STS_H(CHAN)	(ESR2_BASE + 0x123 + (CHAN) * 4)
#define  PLL_RX_STS_CRCIDTCT		0x00000200
#define  PLL_RX_STS_CWDTCT		0x00000100
#define  PLL_RX_STS_BSRXN		0x00000020
#define  PLL_RX_STS_BSRXP		0x00000010
#define  PLL_RX_STS_LOSDTCT		0x00000008
#define  PLL_RX_STS_ODDCG		0x00000004
#define  PLL_RX_STS_SYNC		0x00000002
#define  PLL_RX_STS_TESTFAIL		0x00000001

#define ENET_VLAN_TBL(IDX)		(FZC_FFLP + 0x00000UL + (IDX) * 8UL)
#define  ENET_VLAN_TBL_PARITY1		0x0000000000020000ULL
#define  ENET_VLAN_TBL_PARITY0		0x0000000000010000ULL
#define  ENET_VLAN_TBL_VPR		0x0000000000000008ULL
#define  ENET_VLAN_TBL_VLANRDCTBLN	0x0000000000000007ULL
#define  ENET_VLAN_TBL_SHIFT(PORT)	((PORT) * 4)

#define ENET_VLAN_TBL_NUM_ENTRIES	4096

#define FFLP_VLAN_PAR_ERR		(FZC_FFLP + 0x0800UL)
#define  FFLP_VLAN_PAR_ERR_ERR		0x0000000080000000ULL
#define  FFLP_VLAN_PAR_ERR_M_ERR	0x0000000040000000ULL
#define  FFLP_VLAN_PAR_ERR_ADDR		0x000000003ffc0000ULL
#define  FFLP_VLAN_PAR_ERR_DATA		0x000000000003ffffULL

#define L2_CLS(IDX)			(FZC_FFLP + 0x20000UL + (IDX) * 8UL)
#define  L2_CLS_VLD			0x0000000000010000ULL
#define  L2_CLS_ETYPE			0x000000000000ffffULL
#define  L2_CLS_ETYPE_SHIFT		0

#define L3_CLS(IDX)			(FZC_FFLP + 0x20010UL + (IDX) * 8UL)
#define  L3_CLS_VALID			0x0000000002000000ULL
#define  L3_CLS_IPVER			0x0000000001000000ULL
#define  L3_CLS_PID			0x0000000000ff0000ULL
#define  L3_CLS_PID_SHIFT		16
#define  L3_CLS_TOSMASK			0x000000000000ff00ULL
#define  L3_CLS_TOSMASK_SHIFT		8
#define  L3_CLS_TOS			0x00000000000000ffULL
#define  L3_CLS_TOS_SHIFT		0

#define TCAM_KEY(IDX)			(FZC_FFLP + 0x20030UL + (IDX) * 8UL)
#define  TCAM_KEY_DISC			0x0000000000000008ULL
#define  TCAM_KEY_TSEL			0x0000000000000004ULL
#define  TCAM_KEY_IPADDR		0x0000000000000001ULL

#define TCAM_KEY_0			(FZC_FFLP + 0x20090UL)
#define  TCAM_KEY_0_KEY			0x00000000000000ffULL /* bits 192-199 */

#define TCAM_KEY_1			(FZC_FFLP + 0x20098UL)
#define  TCAM_KEY_1_KEY			0xffffffffffffffffULL /* bits 128-191 */

#define TCAM_KEY_2			(FZC_FFLP + 0x200a0UL)
#define  TCAM_KEY_2_KEY			0xffffffffffffffffULL /* bits 64-127 */

#define TCAM_KEY_3			(FZC_FFLP + 0x200a8UL)
#define  TCAM_KEY_3_KEY			0xffffffffffffffffULL /* bits 0-63 */

#define TCAM_KEY_MASK_0			(FZC_FFLP + 0x200b0UL)
#define  TCAM_KEY_MASK_0_KEY_SEL	0x00000000000000ffULL /* bits 192-199 */

#define TCAM_KEY_MASK_1			(FZC_FFLP + 0x200b8UL)
#define  TCAM_KEY_MASK_1_KEY_SEL	0xffffffffffffffffULL /* bits 128-191 */

#define TCAM_KEY_MASK_2			(FZC_FFLP + 0x200c0UL)
#define  TCAM_KEY_MASK_2_KEY_SEL	0xffffffffffffffffULL /* bits 64-127 */

#define TCAM_KEY_MASK_3			(FZC_FFLP + 0x200c8UL)
#define  TCAM_KEY_MASK_3_KEY_SEL	0xffffffffffffffffULL /* bits 0-63 */

#define TCAM_CTL			(FZC_FFLP + 0x200d0UL)
#define  TCAM_CTL_RWC			0x00000000001c0000ULL
#define  TCAM_CTL_RWC_TCAM_WRITE	0x0000000000000000ULL
#define  TCAM_CTL_RWC_TCAM_READ		0x0000000000040000ULL
#define  TCAM_CTL_RWC_TCAM_COMPARE	0x0000000000080000ULL
#define  TCAM_CTL_RWC_RAM_WRITE		0x0000000000100000ULL
#define  TCAM_CTL_RWC_RAM_READ		0x0000000000140000ULL
#define  TCAM_CTL_STAT			0x0000000000020000ULL
#define  TCAM_CTL_MATCH			0x0000000000010000ULL
#define  TCAM_CTL_LOC			0x00000000000003ffULL

#define TCAM_ERR			(FZC_FFLP + 0x200d8UL)
#define  TCAM_ERR_ERR			0x0000000080000000ULL
#define  TCAM_ERR_P_ECC			0x0000000040000000ULL
#define  TCAM_ERR_MULT			0x0000000020000000ULL
#define  TCAM_ERR_ADDR			0x0000000000ff0000ULL
#define  TCAM_ERR_SYNDROME		0x000000000000ffffULL

#define HASH_LOOKUP_ERR_LOG1		(FZC_FFLP + 0x200e0UL)
#define  HASH_LOOKUP_ERR_LOG1_ERR	0x0000000000000008ULL
#define  HASH_LOOKUP_ERR_LOG1_MULT_LK	0x0000000000000004ULL
#define  HASH_LOOKUP_ERR_LOG1_CU	0x0000000000000002ULL
#define  HASH_LOOKUP_ERR_LOG1_MULT_BIT	0x0000000000000001ULL

#define HASH_LOOKUP_ERR_LOG2		(FZC_FFLP + 0x200e8UL)
#define  HASH_LOOKUP_ERR_LOG2_H1	0x000000007ffff800ULL
#define  HASH_LOOKUP_ERR_LOG2_SUBAREA	0x0000000000000700ULL
#define  HASH_LOOKUP_ERR_LOG2_SYNDROME	0x00000000000000ffULL

#define FFLP_CFG_1			(FZC_FFLP + 0x20100UL)
#define  FFLP_CFG_1_TCAM_DIS		0x0000000004000000ULL
#define  FFLP_CFG_1_PIO_DBG_SEL		0x0000000003800000ULL
#define  FFLP_CFG_1_PIO_FIO_RST		0x0000000000400000ULL
#define  FFLP_CFG_1_PIO_FIO_LAT		0x0000000000300000ULL
#define  FFLP_CFG_1_CAMLAT		0x00000000000f0000ULL
#define  FFLP_CFG_1_CAMLAT_SHIFT	16
#define  FFLP_CFG_1_CAMRATIO		0x000000000000f000ULL
#define  FFLP_CFG_1_CAMRATIO_SHIFT	12
#define  FFLP_CFG_1_FCRAMRATIO		0x0000000000000f00ULL
#define  FFLP_CFG_1_FCRAMRATIO_SHIFT	8
#define  FFLP_CFG_1_FCRAMOUTDR_MASK	0x00000000000000f0ULL
#define  FFLP_CFG_1_FCRAMOUTDR_NORMAL	0x0000000000000000ULL
#define  FFLP_CFG_1_FCRAMOUTDR_STRONG	0x0000000000000050ULL
#define  FFLP_CFG_1_FCRAMOUTDR_WEAK	0x00000000000000a0ULL
#define  FFLP_CFG_1_FCRAMQS		0x0000000000000008ULL
#define  FFLP_CFG_1_ERRORDIS		0x0000000000000004ULL
#define  FFLP_CFG_1_FFLPINITDONE	0x0000000000000002ULL
#define  FFLP_CFG_1_LLCSNAP		0x0000000000000001ULL

#define DEFAULT_FCRAMRATIO		10

#define DEFAULT_TCAM_LATENCY		4
#define DEFAULT_TCAM_ACCESS_RATIO	10

#define TCP_CFLAG_MSK			(FZC_FFLP + 0x20108UL)
#define  TCP_CFLAG_MSK_MASK		0x0000000000000fffULL

#define FCRAM_REF_TMR			(FZC_FFLP + 0x20110UL)
#define  FCRAM_REF_TMR_MAX		0x00000000ffff0000ULL
#define  FCRAM_REF_TMR_MAX_SHIFT	16
#define  FCRAM_REF_TMR_MIN		0x000000000000ffffULL
#define  FCRAM_REF_TMR_MIN_SHIFT	0

#define DEFAULT_FCRAM_REFRESH_MAX	512
#define DEFAULT_FCRAM_REFRESH_MIN	512

#define FCRAM_FIO_ADDR			(FZC_FFLP + 0x20118UL)
#define  FCRAM_FIO_ADDR_ADDR		0x00000000000000ffULL

#define FCRAM_FIO_DAT			(FZC_FFLP + 0x20120UL)
#define  FCRAM_FIO_DAT_DATA		0x000000000000ffffULL

#define FCRAM_ERR_TST0			(FZC_FFLP + 0x20128UL)
#define  FCRAM_ERR_TST0_SYND		0x00000000000000ffULL

#define FCRAM_ERR_TST1			(FZC_FFLP + 0x20130UL)
#define  FCRAM_ERR_TST1_DAT		0x00000000ffffffffULL

#define FCRAM_ERR_TST2			(FZC_FFLP + 0x20138UL)
#define  FCRAM_ERR_TST2_DAT		0x00000000ffffffffULL

#define FFLP_ERR_MASK			(FZC_FFLP + 0x20140UL)
#define  FFLP_ERR_MASK_HSH_TBL_DAT	0x00000000000007f8ULL
#define  FFLP_ERR_MASK_HSH_TBL_LKUP	0x0000000000000004ULL
#define  FFLP_ERR_MASK_TCAM		0x0000000000000002ULL
#define  FFLP_ERR_MASK_VLAN		0x0000000000000001ULL

#define FFLP_DBG_TRAIN_VCT		(FZC_FFLP + 0x20148UL)
#define  FFLP_DBG_TRAIN_VCT_VECTOR	0x00000000ffffffffULL

#define FCRAM_PHY_RD_LAT		(FZC_FFLP + 0x20150UL)
#define  FCRAM_PHY_RD_LAT_LAT		0x00000000000000ffULL

/* Ethernet TCAM format */
#define TCAM_ETHKEY0_RESV1		0xffffffffffffff00ULL
#define TCAM_ETHKEY0_CLASS_CODE		0x00000000000000f8ULL
#define TCAM_ETHKEY0_CLASS_CODE_SHIFT	3
#define TCAM_ETHKEY0_RESV2		0x0000000000000007ULL
#define TCAM_ETHKEY1_FRAME_BYTE0_7(NUM)	(0xff << ((7 - NUM) * 8))
#define TCAM_ETHKEY2_FRAME_BYTE8	0xff00000000000000ULL
#define TCAM_ETHKEY2_FRAME_BYTE8_SHIFT	56
#define TCAM_ETHKEY2_FRAME_BYTE9	0x00ff000000000000ULL
#define TCAM_ETHKEY2_FRAME_BYTE9_SHIFT	48
#define TCAM_ETHKEY2_FRAME_BYTE10	0x0000ff0000000000ULL
#define TCAM_ETHKEY2_FRAME_BYTE10_SHIFT	40
#define TCAM_ETHKEY2_FRAME_RESV		0x000000ffffffffffULL
#define TCAM_ETHKEY3_FRAME_RESV		0xffffffffffffffffULL

/* IPV4 TCAM format */
#define TCAM_V4KEY0_RESV1		0xffffffffffffff00ULL
#define TCAM_V4KEY0_CLASS_CODE		0x00000000000000f8ULL
#define TCAM_V4KEY0_CLASS_CODE_SHIFT	3
#define TCAM_V4KEY0_RESV2		0x0000000000000007ULL
#define TCAM_V4KEY1_L2RDCNUM		0xf800000000000000ULL
#define TCAM_V4KEY1_L2RDCNUM_SHIFT	59
#define TCAM_V4KEY1_NOPORT		0x0400000000000000ULL
#define TCAM_V4KEY1_RESV		0x03ffffffffffffffULL
#define TCAM_V4KEY2_RESV		0xffff000000000000ULL
#define TCAM_V4KEY2_TOS			0x0000ff0000000000ULL
#define TCAM_V4KEY2_TOS_SHIFT		40
#define TCAM_V4KEY2_PROTO		0x000000ff00000000ULL
#define TCAM_V4KEY2_PROTO_SHIFT		32
#define TCAM_V4KEY2_PORT_SPI		0x00000000ffffffffULL
#define TCAM_V4KEY2_PORT_SPI_SHIFT	0
#define TCAM_V4KEY3_SADDR		0xffffffff00000000ULL
#define TCAM_V4KEY3_SADDR_SHIFT		32
#define TCAM_V4KEY3_DADDR		0x00000000ffffffffULL
#define TCAM_V4KEY3_DADDR_SHIFT		0

/* IPV6 TCAM format */
#define TCAM_V6KEY0_RESV1		0xffffffffffffff00ULL
#define TCAM_V6KEY0_CLASS_CODE		0x00000000000000f8ULL
#define TCAM_V6KEY0_CLASS_CODE_SHIFT	3
#define TCAM_V6KEY0_RESV2		0x0000000000000007ULL
#define TCAM_V6KEY1_L2RDCNUM		0xf800000000000000ULL
#define TCAM_V6KEY1_L2RDCNUM_SHIFT	59
#define TCAM_V6KEY1_NOPORT		0x0400000000000000ULL
#define TCAM_V6KEY1_RESV		0x03ff000000000000ULL
#define TCAM_V6KEY1_TOS			0x0000ff0000000000ULL
#define TCAM_V6KEY1_TOS_SHIFT		40
#define TCAM_V6KEY1_NEXT_HDR		0x000000ff00000000ULL
#define TCAM_V6KEY1_NEXT_HDR_SHIFT	32
#define TCAM_V6KEY1_PORT_SPI		0x00000000ffffffffULL
#define TCAM_V6KEY1_PORT_SPI_SHIFT	0
#define TCAM_V6KEY2_ADDR_HIGH		0xffffffffffffffffULL
#define TCAM_V6KEY3_ADDR_LOW		0xffffffffffffffffULL

#define TCAM_ASSOCDATA_SYNDROME		0x000003fffc000000ULL
#define TCAM_ASSOCDATA_SYNDROME_SHIFT	26
#define TCAM_ASSOCDATA_ZFID		0x0000000003ffc000ULL
#define TCAM_ASSOCDATA_ZFID_SHIFT	14
#define TCAM_ASSOCDATA_V4_ECC_OK	0x0000000000002000ULL
#define TCAM_ASSOCDATA_DISC		0x0000000000001000ULL
#define TCAM_ASSOCDATA_TRES_MASK	0x0000000000000c00ULL
#define TCAM_ASSOCDATA_TRES_USE_L2RDC	0x0000000000000000ULL
#define TCAM_ASSOCDATA_TRES_USE_OFFSET	0x0000000000000400ULL
#define TCAM_ASSOCDATA_TRES_OVR_RDC	0x0000000000000800ULL
#define TCAM_ASSOCDATA_TRES_OVR_RDC_OFF	0x0000000000000c00ULL
#define TCAM_ASSOCDATA_RDCTBL		0x0000000000000380ULL
#define TCAM_ASSOCDATA_RDCTBL_SHIFT	7
#define TCAM_ASSOCDATA_OFFSET		0x000000000000007cULL
#define TCAM_ASSOCDATA_OFFSET_SHIFT	2
#define TCAM_ASSOCDATA_ZFVLD		0x0000000000000002ULL
#define TCAM_ASSOCDATA_AGE		0x0000000000000001ULL

#define FLOW_KEY(IDX)			(FZC_FFLP + 0x40000UL + (IDX) * 8UL)
#define  FLOW_KEY_PORT			0x0000000000000200ULL
#define  FLOW_KEY_L2DA			0x0000000000000100ULL
#define  FLOW_KEY_VLAN			0x0000000000000080ULL
#define  FLOW_KEY_IPSA			0x0000000000000040ULL
#define  FLOW_KEY_IPDA			0x0000000000000020ULL
#define  FLOW_KEY_PROTO			0x0000000000000010ULL
#define  FLOW_KEY_L4_0			0x000000000000000cULL
#define  FLOW_KEY_L4_0_SHIFT		2
#define  FLOW_KEY_L4_1			0x0000000000000003ULL
#define  FLOW_KEY_L4_1_SHIFT		0

#define  FLOW_KEY_L4_NONE		0x0
#define  FLOW_KEY_L4_RESV		0x1
#define  FLOW_KEY_L4_BYTE12		0x2
#define  FLOW_KEY_L4_BYTE56		0x3

#define H1POLY				(FZC_FFLP + 0x40060UL)
#define  H1POLY_INITVAL			0x00000000ffffffffULL

#define H2POLY				(FZC_FFLP + 0x40068UL)
#define  H2POLY_INITVAL			0x000000000000ffffULL

#define FLW_PRT_SEL(IDX)		(FZC_FFLP + 0x40070UL + (IDX) * 8UL)
#define  FLW_PRT_SEL_EXT		0x0000000000010000ULL
#define  FLW_PRT_SEL_MASK		0x0000000000001f00ULL
#define  FLW_PRT_SEL_MASK_SHIFT		8
#define  FLW_PRT_SEL_BASE		0x000000000000001fULL
#define  FLW_PRT_SEL_BASE_SHIFT		0

#define HASH_TBL_ADDR(IDX)		(FFLP + 0x00000UL + (IDX) * 8192UL)
#define  HASH_TBL_ADDR_AUTOINC		0x0000000000800000ULL
#define  HASH_TBL_ADDR_ADDR		0x00000000007fffffULL

#define HASH_TBL_DATA(IDX)		(FFLP + 0x00008UL + (IDX) * 8192UL)
#define  HASH_TBL_DATA_DATA		0xffffffffffffffffULL

/* FCRAM hash table entries are up to 8 64-bit words in size.
 * The layout of each entry is determined by the settings in the
 * first word, which is the header.
 *
 * The indexing is controllable per partition (there is one partition
 * per RDC group, thus a total of eight) using the BASE and MASK fields
 * of FLW_PRT_SEL above.
 */
#define FCRAM_SIZE			0x800000
#define FCRAM_NUM_PARTITIONS		8

/* Generic HASH entry header, used for all non-optimized formats.  */
#define HASH_HEADER_FMT			0x8000000000000000ULL
#define HASH_HEADER_EXT			0x4000000000000000ULL
#define HASH_HEADER_VALID		0x2000000000000000ULL
#define HASH_HEADER_RESVD		0x1000000000000000ULL
#define HASH_HEADER_L2_DADDR		0x0ffffffffffff000ULL
#define HASH_HEADER_L2_DADDR_SHIFT	12
#define HASH_HEADER_VLAN		0x0000000000000fffULL
#define HASH_HEADER_VLAN_SHIFT		0

/* Optimized format, just a header with a special layout defined below.
 * Set FMT and EXT both to zero to indicate this layout is being used.
 */
#define HASH_OPT_HEADER_FMT		0x8000000000000000ULL
#define HASH_OPT_HEADER_EXT		0x4000000000000000ULL
#define HASH_OPT_HEADER_VALID		0x2000000000000000ULL
#define HASH_OPT_HEADER_RDCOFF		0x1f00000000000000ULL
#define HASH_OPT_HEADER_RDCOFF_SHIFT	56
#define HASH_OPT_HEADER_HASH2		0x00ffff0000000000ULL
#define HASH_OPT_HEADER_HASH2_SHIFT	40
#define HASH_OPT_HEADER_RESVD		0x000000ff00000000ULL
#define HASH_OPT_HEADER_USERINFO	0x00000000ffffffffULL
#define HASH_OPT_HEADER_USERINFO_SHIFT	0

/* Port and protocol word used for ipv4 and ipv6 layouts.  */
#define HASH_PORT_DPORT			0xffff000000000000ULL
#define HASH_PORT_DPORT_SHIFT		48
#define HASH_PORT_SPORT			0x0000ffff00000000ULL
#define HASH_PORT_SPORT_SHIFT		32
#define HASH_PORT_PROTO			0x00000000ff000000ULL
#define HASH_PORT_PROTO_SHIFT		24
#define HASH_PORT_PORT_OFF		0x0000000000c00000ULL
#define HASH_PORT_PORT_OFF_SHIFT	22
#define HASH_PORT_PORT_RESV		0x00000000003fffffULL

/* Action word used for ipv4 and ipv6 layouts.  */
#define HASH_ACTION_RESV1		0xe000000000000000ULL
#define HASH_ACTION_RDCOFF		0x1f00000000000000ULL
#define HASH_ACTION_RDCOFF_SHIFT	56
#define HASH_ACTION_ZFVALID		0x0080000000000000ULL
#define HASH_ACTION_RESV2		0x0070000000000000ULL
#define HASH_ACTION_ZFID		0x000fff0000000000ULL
#define HASH_ACTION_ZFID_SHIFT		40
#define HASH_ACTION_RESV3		0x000000ff00000000ULL
#define HASH_ACTION_USERINFO		0x00000000ffffffffULL
#define HASH_ACTION_USERINFO_SHIFT	0

/* IPV4 address word.  Addresses are in network endian. */
#define HASH_IP4ADDR_SADDR		0xffffffff00000000ULL
#define HASH_IP4ADDR_SADDR_SHIFT	32
#define HASH_IP4ADDR_DADDR		0x00000000ffffffffULL
#define HASH_IP4ADDR_DADDR_SHIFT	0

/* IPV6 address layout is 4 words, first two are saddr, next two
 * are daddr.  Addresses are in network endian.
 */

struct fcram_hash_opt {
	u64	header;
};

/* EXT=1, FMT=0 */
struct fcram_hash_ipv4 {
	u64	header;
	u64	addrs;
	u64	ports;
	u64	action;
};

/* EXT=1, FMT=1 */
struct fcram_hash_ipv6 {
	u64	header;
	u64	addrs[4];
	u64	ports;
	u64	action;
};

#define HASH_TBL_DATA_LOG(IDX)		(FFLP + 0x00010UL + (IDX) * 8192UL)
#define  HASH_TBL_DATA_LOG_ERR		0x0000000080000000ULL
#define  HASH_TBL_DATA_LOG_ADDR		0x000000007fffff00ULL
#define  HASH_TBL_DATA_LOG_SYNDROME	0x00000000000000ffULL

#define RX_DMA_CK_DIV			(FZC_DMC + 0x00000UL)
#define  RX_DMA_CK_DIV_CNT		0x000000000000ffffULL

#define DEF_RDC(IDX)			(FZC_DMC + 0x00008UL + (IDX) * 0x8UL)
#define  DEF_RDC_VAL			0x000000000000001fULL

#define PT_DRR_WT(IDX)			(FZC_DMC + 0x00028UL + (IDX) * 0x8UL)
#define  PT_DRR_WT_VAL			0x000000000000ffffULL

#define PT_DRR_WEIGHT_DEFAULT_10G	0x0400
#define PT_DRR_WEIGHT_DEFAULT_1G	0x0066

#define PT_USE(IDX)			(FZC_DMC + 0x00048UL + (IDX) * 0x8UL)
#define  PT_USE_CNT			0x00000000000fffffULL

#define RED_RAN_INIT			(FZC_DMC + 0x00068UL)
#define  RED_RAN_INIT_OPMODE		0x0000000000010000ULL
#define  RED_RAN_INIT_VAL		0x000000000000ffffULL

#define RX_ADDR_MD			(FZC_DMC + 0x00070UL)
#define  RX_ADDR_MD_DBG_PT_MUX_SEL	0x000000000000000cULL
#define  RX_ADDR_MD_RAM_ACC		0x0000000000000002ULL
#define  RX_ADDR_MD_MODE32		0x0000000000000001ULL

#define RDMC_PRE_PAR_ERR		(FZC_DMC + 0x00078UL)
#define  RDMC_PRE_PAR_ERR_ERR		0x0000000000008000ULL
#define  RDMC_PRE_PAR_ERR_MERR		0x0000000000004000ULL
#define  RDMC_PRE_PAR_ERR_ADDR		0x00000000000000ffULL

#define RDMC_SHA_PAR_ERR		(FZC_DMC + 0x00080UL)
#define  RDMC_SHA_PAR_ERR_ERR		0x0000000000008000ULL
#define  RDMC_SHA_PAR_ERR_MERR		0x0000000000004000ULL
#define  RDMC_SHA_PAR_ERR_ADDR		0x00000000000000ffULL

#define RDMC_MEM_ADDR			(FZC_DMC + 0x00088UL)
#define  RDMC_MEM_ADDR_PRE_SHAD		0x0000000000000100ULL
#define  RDMC_MEM_ADDR_ADDR		0x00000000000000ffULL

#define RDMC_MEM_DAT0			(FZC_DMC + 0x00090UL)
#define  RDMC_MEM_DAT0_DATA		0x00000000ffffffffULL /* bits 31:0 */

#define RDMC_MEM_DAT1			(FZC_DMC + 0x00098UL)
#define  RDMC_MEM_DAT1_DATA		0x00000000ffffffffULL /* bits 63:32 */

#define RDMC_MEM_DAT2			(FZC_DMC + 0x000a0UL)
#define  RDMC_MEM_DAT2_DATA		0x00000000ffffffffULL /* bits 95:64 */

#define RDMC_MEM_DAT3			(FZC_DMC + 0x000a8UL)
#define  RDMC_MEM_DAT3_DATA		0x00000000ffffffffULL /* bits 127:96 */

#define RDMC_MEM_DAT4			(FZC_DMC + 0x000b0UL)
#define  RDMC_MEM_DAT4_DATA		0x00000000000fffffULL /* bits 147:128 */

#define RX_CTL_DAT_FIFO_STAT			(FZC_DMC + 0x000b8UL)
#define  RX_CTL_DAT_FIFO_STAT_ID_MISMATCH	0x0000000000000100ULL
#define  RX_CTL_DAT_FIFO_STAT_ZCP_EOP_ERR	0x00000000000000f0ULL
#define  RX_CTL_DAT_FIFO_STAT_IPP_EOP_ERR	0x000000000000000fULL

#define RX_CTL_DAT_FIFO_MASK			(FZC_DMC + 0x000c0UL)
#define  RX_CTL_DAT_FIFO_MASK_ID_MISMATCH	0x0000000000000100ULL
#define  RX_CTL_DAT_FIFO_MASK_ZCP_EOP_ERR	0x00000000000000f0ULL
#define  RX_CTL_DAT_FIFO_MASK_IPP_EOP_ERR	0x000000000000000fULL

#define RDMC_TRAINING_VECTOR			(FZC_DMC + 0x000c8UL)
#define  RDMC_TRAINING_VECTOR_TRAINING_VECTOR	0x00000000ffffffffULL

#define RX_CTL_DAT_FIFO_STAT_DBG		(FZC_DMC + 0x000d0UL)
#define  RX_CTL_DAT_FIFO_STAT_DBG_ID_MISMATCH	0x0000000000000100ULL
#define  RX_CTL_DAT_FIFO_STAT_DBG_ZCP_EOP_ERR	0x00000000000000f0ULL
#define  RX_CTL_DAT_FIFO_STAT_DBG_IPP_EOP_ERR	0x000000000000000fULL

#define RDC_TBL(TBL,SLOT)		(FZC_ZCP + 0x10000UL + \
					 (TBL) * (8UL * 16UL) + \
					 (SLOT) * 8UL)
#define  RDC_TBL_RDC			0x000000000000000fULL

#define RX_LOG_PAGE_VLD(IDX)		(FZC_DMC + 0x20000UL + (IDX) * 0x40UL)
#define  RX_LOG_PAGE_VLD_FUNC		0x000000000000000cULL
#define  RX_LOG_PAGE_VLD_FUNC_SHIFT	2
#define  RX_LOG_PAGE_VLD_PAGE1		0x0000000000000002ULL
#define  RX_LOG_PAGE_VLD_PAGE0		0x0000000000000001ULL

#define RX_LOG_MASK1(IDX)		(FZC_DMC + 0x20008UL + (IDX) * 0x40UL)
#define  RX_LOG_MASK1_MASK		0x00000000ffffffffULL

#define RX_LOG_VAL1(IDX)		(FZC_DMC + 0x20010UL + (IDX) * 0x40UL)
#define  RX_LOG_VAL1_VALUE		0x00000000ffffffffULL

#define RX_LOG_MASK2(IDX)		(FZC_DMC + 0x20018UL + (IDX) * 0x40UL)
#define  RX_LOG_MASK2_MASK		0x00000000ffffffffULL

#define RX_LOG_VAL2(IDX)		(FZC_DMC + 0x20020UL + (IDX) * 0x40UL)
#define  RX_LOG_VAL2_VALUE		0x00000000ffffffffULL

#define RX_LOG_PAGE_RELO1(IDX)		(FZC_DMC + 0x20028UL + (IDX) * 0x40UL)
#define  RX_LOG_PAGE_RELO1_RELO		0x00000000ffffffffULL

#define RX_LOG_PAGE_RELO2(IDX)		(FZC_DMC + 0x20030UL + (IDX) * 0x40UL)
#define  RX_LOG_PAGE_RELO2_RELO		0x00000000ffffffffULL

#define RX_LOG_PAGE_HDL(IDX)		(FZC_DMC + 0x20038UL + (IDX) * 0x40UL)
#define  RX_LOG_PAGE_HDL_HANDLE		0x00000000000fffffULL

#define TX_LOG_PAGE_VLD(IDX)		(FZC_DMC + 0x40000UL + (IDX) * 0x200UL)
#define  TX_LOG_PAGE_VLD_FUNC		0x000000000000000cULL
#define  TX_LOG_PAGE_VLD_FUNC_SHIFT	2
#define  TX_LOG_PAGE_VLD_PAGE1		0x0000000000000002ULL
#define  TX_LOG_PAGE_VLD_PAGE0		0x0000000000000001ULL

#define TX_LOG_MASK1(IDX)		(FZC_DMC + 0x40008UL + (IDX) * 0x200UL)
#define  TX_LOG_MASK1_MASK		0x00000000ffffffffULL

#define TX_LOG_VAL1(IDX)		(FZC_DMC + 0x40010UL + (IDX) * 0x200UL)
#define  TX_LOG_VAL1_VALUE		0x00000000ffffffffULL

#define TX_LOG_MASK2(IDX)		(FZC_DMC + 0x40018UL + (IDX) * 0x200UL)
#define  TX_LOG_MASK2_MASK		0x00000000ffffffffULL

#define TX_LOG_VAL2(IDX)		(FZC_DMC + 0x40020UL + (IDX) * 0x200UL)
#define  TX_LOG_VAL2_VALUE		0x00000000ffffffffULL

#define TX_LOG_PAGE_RELO1(IDX)		(FZC_DMC + 0x40028UL + (IDX) * 0x200UL)
#define  TX_LOG_PAGE_RELO1_RELO		0x00000000ffffffffULL

#define TX_LOG_PAGE_RELO2(IDX)		(FZC_DMC + 0x40030UL + (IDX) * 0x200UL)
#define  TX_LOG_PAGE_RELO2_RELO		0x00000000ffffffffULL

#define TX_LOG_PAGE_HDL(IDX)		(FZC_DMC + 0x40038UL + (IDX) * 0x200UL)
#define  TX_LOG_PAGE_HDL_HANDLE		0x00000000000fffffULL

#define TX_ADDR_MD			(FZC_DMC + 0x45000UL)
#define  TX_ADDR_MD_MODE32		0x0000000000000001ULL

#define RDC_RED_PARA(IDX)		(FZC_DMC + 0x30000UL + (IDX) * 0x40UL)
#define  RDC_RED_PARA_THRE_SYN		0x00000000fff00000ULL
#define  RDC_RED_PARA_THRE_SYN_SHIFT	20
#define  RDC_RED_PARA_WIN_SYN		0x00000000000f0000ULL
#define  RDC_RED_PARA_WIN_SYN_SHIFT	16
#define  RDC_RED_PARA_THRE		0x000000000000fff0ULL
#define  RDC_RED_PARA_THRE_SHIFT	4
#define  RDC_RED_PARA_WIN		0x000000000000000fULL
#define  RDC_RED_PARA_WIN_SHIFT		0

#define RED_DIS_CNT(IDX)		(FZC_DMC + 0x30008UL + (IDX) * 0x40UL)
#define  RED_DIS_CNT_OFLOW		0x0000000000010000ULL
#define  RED_DIS_CNT_COUNT		0x000000000000ffffULL

#define IPP_CFIG			(FZC_IPP + 0x00000UL)
#define  IPP_CFIG_SOFT_RST		0x0000000080000000ULL
#define  IPP_CFIG_IP_MAX_PKT		0x0000000001ffff00ULL
#define  IPP_CFIG_IP_MAX_PKT_SHIFT	8
#define  IPP_CFIG_FFLP_CS_PIO_W		0x0000000000000080ULL
#define  IPP_CFIG_PFIFO_PIO_W		0x0000000000000040ULL
#define  IPP_CFIG_DFIFO_PIO_W		0x0000000000000020ULL
#define  IPP_CFIG_CKSUM_EN		0x0000000000000010ULL
#define  IPP_CFIG_DROP_BAD_CRC		0x0000000000000008ULL
#define  IPP_CFIG_DFIFO_ECC_EN		0x0000000000000004ULL
#define  IPP_CFIG_DEBUG_BUS_OUT_EN	0x0000000000000002ULL
#define  IPP_CFIG_IPP_ENABLE		0x0000000000000001ULL

#define IPP_PKT_DIS			(FZC_IPP + 0x00020UL)
#define  IPP_PKT_DIS_COUNT		0x0000000000003fffULL

#define IPP_BAD_CS_CNT			(FZC_IPP + 0x00028UL)
#define  IPP_BAD_CS_CNT_COUNT		0x0000000000003fffULL

#define IPP_ECC				(FZC_IPP + 0x00030UL)
#define  IPP_ECC_COUNT			0x00000000000000ffULL

#define IPP_INT_STAT			(FZC_IPP + 0x00040UL)
#define  IPP_INT_STAT_SOP_MISS		0x0000000080000000ULL
#define  IPP_INT_STAT_EOP_MISS		0x0000000040000000ULL
#define  IPP_INT_STAT_DFIFO_UE		0x0000000030000000ULL
#define  IPP_INT_STAT_DFIFO_CE		0x000000000c000000ULL
#define  IPP_INT_STAT_DFIFO_ECC		0x0000000003000000ULL
#define  IPP_INT_STAT_DFIFO_ECC_IDX	0x00000000007ff000ULL
#define  IPP_INT_STAT_PFIFO_PERR	0x0000000000000800ULL
#define  IPP_INT_STAT_ECC_ERR_MAX	0x0000000000000400ULL
#define  IPP_INT_STAT_PFIFO_ERR_IDX	0x00000000000003f0ULL
#define  IPP_INT_STAT_PFIFO_OVER	0x0000000000000008ULL
#define  IPP_INT_STAT_PFIFO_UND		0x0000000000000004ULL
#define  IPP_INT_STAT_BAD_CS_MX		0x0000000000000002ULL
#define  IPP_INT_STAT_PKT_DIS_MX	0x0000000000000001ULL
#define  IPP_INT_STAT_ALL		0x00000000ff7fffffULL

#define IPP_MSK				(FZC_IPP + 0x00048UL)
#define  IPP_MSK_ECC_ERR_MX		0x0000000000000080ULL
#define  IPP_MSK_DFIFO_EOP_SOP		0x0000000000000040ULL
#define  IPP_MSK_DFIFO_UC		0x0000000000000020ULL
#define  IPP_MSK_PFIFO_PAR		0x0000000000000010ULL
#define  IPP_MSK_PFIFO_OVER		0x0000000000000008ULL
#define  IPP_MSK_PFIFO_UND		0x0000000000000004ULL
#define  IPP_MSK_BAD_CS			0x0000000000000002ULL
#define  IPP_MSK_PKT_DIS_CNT		0x0000000000000001ULL
#define  IPP_MSK_ALL			0x00000000000000ffULL

#define IPP_PFIFO_RD0			(FZC_IPP + 0x00060UL)
#define  IPP_PFIFO_RD0_DATA		0x00000000ffffffffULL /* bits 31:0 */

#define IPP_PFIFO_RD1			(FZC_IPP + 0x00068UL)
#define  IPP_PFIFO_RD1_DATA		0x00000000ffffffffULL /* bits 63:32 */

#define IPP_PFIFO_RD2			(FZC_IPP + 0x00070UL)
#define  IPP_PFIFO_RD2_DATA		0x00000000ffffffffULL /* bits 95:64 */

#define IPP_PFIFO_RD3			(FZC_IPP + 0x00078UL)
#define  IPP_PFIFO_RD3_DATA		0x00000000ffffffffULL /* bits 127:96 */

#define IPP_PFIFO_RD4			(FZC_IPP + 0x00080UL)
#define  IPP_PFIFO_RD4_DATA		0x00000000ffffffffULL /* bits 145:128 */

#define IPP_PFIFO_WR0			(FZC_IPP + 0x00088UL)
#define  IPP_PFIFO_WR0_DATA		0x00000000ffffffffULL /* bits 31:0 */

#define IPP_PFIFO_WR1			(FZC_IPP + 0x00090UL)
#define  IPP_PFIFO_WR1_DATA		0x00000000ffffffffULL /* bits 63:32 */

#define IPP_PFIFO_WR2			(FZC_IPP + 0x00098UL)
#define  IPP_PFIFO_WR2_DATA		0x00000000ffffffffULL /* bits 95:64 */

#define IPP_PFIFO_WR3			(FZC_IPP + 0x000a0UL)
#define  IPP_PFIFO_WR3_DATA		0x00000000ffffffffULL /* bits 127:96 */

#define IPP_PFIFO_WR4			(FZC_IPP + 0x000a8UL)
#define  IPP_PFIFO_WR4_DATA		0x00000000ffffffffULL /* bits 145:128 */

#define IPP_PFIFO_RD_PTR		(FZC_IPP + 0x000b0UL)
#define  IPP_PFIFO_RD_PTR_PTR		0x000000000000003fULL

#define IPP_PFIFO_WR_PTR		(FZC_IPP + 0x000b8UL)
#define  IPP_PFIFO_WR_PTR_PTR		0x000000000000007fULL

#define IPP_DFIFO_RD0			(FZC_IPP + 0x000c0UL)
#define  IPP_DFIFO_RD0_DATA		0x00000000ffffffffULL /* bits 31:0 */

#define IPP_DFIFO_RD1			(FZC_IPP + 0x000c8UL)
#define  IPP_DFIFO_RD1_DATA		0x00000000ffffffffULL /* bits 63:32 */

#define IPP_DFIFO_RD2			(FZC_IPP + 0x000d0UL)
#define  IPP_DFIFO_RD2_DATA		0x00000000ffffffffULL /* bits 95:64 */

#define IPP_DFIFO_RD3			(FZC_IPP + 0x000d8UL)
#define  IPP_DFIFO_RD3_DATA		0x00000000ffffffffULL /* bits 127:96 */

#define IPP_DFIFO_RD4			(FZC_IPP + 0x000e0UL)
#define  IPP_DFIFO_RD4_DATA		0x00000000ffffffffULL /* bits 145:128 */

#define IPP_DFIFO_WR0			(FZC_IPP + 0x000e8UL)
#define  IPP_DFIFO_WR0_DATA		0x00000000ffffffffULL /* bits 31:0 */

#define IPP_DFIFO_WR1			(FZC_IPP + 0x000f0UL)
#define  IPP_DFIFO_WR1_DATA		0x00000000ffffffffULL /* bits 63:32 */

#define IPP_DFIFO_WR2			(FZC_IPP + 0x000f8UL)
#define  IPP_DFIFO_WR2_DATA		0x00000000ffffffffULL /* bits 95:64 */

#define IPP_DFIFO_WR3			(FZC_IPP + 0x00100UL)
#define  IPP_DFIFO_WR3_DATA		0x00000000ffffffffULL /* bits 127:96 */

#define IPP_DFIFO_WR4			(FZC_IPP + 0x00108UL)
#define  IPP_DFIFO_WR4_DATA		0x00000000ffffffffULL /* bits 145:128 */

#define IPP_DFIFO_RD_PTR		(FZC_IPP + 0x00110UL)
#define  IPP_DFIFO_RD_PTR_PTR		0x0000000000000fffULL

#define IPP_DFIFO_WR_PTR		(FZC_IPP + 0x00118UL)
#define  IPP_DFIFO_WR_PTR_PTR		0x0000000000000fffULL

#define IPP_SM				(FZC_IPP + 0x00120UL)
#define  IPP_SM_SM			0x00000000ffffffffULL

#define IPP_CS_STAT			(FZC_IPP + 0x00128UL)
#define  IPP_CS_STAT_BCYC_CNT		0x00000000ff000000ULL
#define  IPP_CS_STAT_IP_LEN		0x0000000000fff000ULL
#define  IPP_CS_STAT_CS_FAIL		0x0000000000000800ULL
#define  IPP_CS_STAT_TERM		0x0000000000000400ULL
#define  IPP_CS_STAT_BAD_NUM		0x0000000000000200ULL
#define  IPP_CS_STAT_CS_STATE		0x00000000000001ffULL

#define IPP_FFLP_CS_INFO		(FZC_IPP + 0x00130UL)
#define  IPP_FFLP_CS_INFO_PKT_ID	0x0000000000003c00ULL
#define  IPP_FFLP_CS_INFO_L4_PROTO	0x0000000000000300ULL
#define  IPP_FFLP_CS_INFO_V4_HD_LEN	0x00000000000000f0ULL
#define  IPP_FFLP_CS_INFO_L3_VER	0x000000000000000cULL
#define  IPP_FFLP_CS_INFO_L2_OP		0x0000000000000003ULL

#define IPP_DBG_SEL			(FZC_IPP + 0x00138UL)
#define  IPP_DBG_SEL_SEL		0x000000000000000fULL

#define IPP_DFIFO_ECC_SYND		(FZC_IPP + 0x00140UL)
#define  IPP_DFIFO_ECC_SYND_SYND	0x000000000000ffffULL

#define IPP_DFIFO_EOP_RD_PTR		(FZC_IPP + 0x00148UL)
#define  IPP_DFIFO_EOP_RD_PTR_PTR	0x0000000000000fffULL

#define IPP_ECC_CTL			(FZC_IPP + 0x00150UL)
#define  IPP_ECC_CTL_DIS_DBL		0x0000000080000000ULL
#define  IPP_ECC_CTL_COR_DBL		0x0000000000020000ULL
#define  IPP_ECC_CTL_COR_SNG		0x0000000000010000ULL
#define  IPP_ECC_CTL_COR_ALL		0x0000000000000400ULL
#define  IPP_ECC_CTL_COR_1		0x0000000000000100ULL
#define  IPP_ECC_CTL_COR_LST		0x0000000000000004ULL
#define  IPP_ECC_CTL_COR_SND		0x0000000000000002ULL
#define  IPP_ECC_CTL_COR_FSR		0x0000000000000001ULL

#define NIU_DFIFO_ENTRIES		1024
#define ATLAS_P0_P1_DFIFO_ENTRIES	2048
#define ATLAS_P2_P3_DFIFO_ENTRIES	1024

#define ZCP_CFIG			(FZC_ZCP + 0x00000UL)
#define  ZCP_CFIG_ZCP_32BIT_MODE	0x0000000001000000ULL
#define  ZCP_CFIG_ZCP_DEBUG_SEL		0x0000000000ff0000ULL
#define  ZCP_CFIG_DMA_TH		0x000000000000ffe0ULL
#define  ZCP_CFIG_ECC_CHK_DIS		0x0000000000000010ULL
#define  ZCP_CFIG_PAR_CHK_DIS		0x0000000000000008ULL
#define  ZCP_CFIG_DIS_BUFF_RSP_IF	0x0000000000000004ULL
#define  ZCP_CFIG_DIS_BUFF_REQ_IF	0x0000000000000002ULL
#define  ZCP_CFIG_ZC_ENABLE		0x0000000000000001ULL

#define ZCP_INT_STAT			(FZC_ZCP + 0x00008UL)
#define  ZCP_INT_STAT_RRFIFO_UNDERRUN	0x0000000000008000ULL
#define  ZCP_INT_STAT_RRFIFO_OVERRUN	0x0000000000004000ULL
#define  ZCP_INT_STAT_RSPFIFO_UNCOR_ERR	0x0000000000001000ULL
#define  ZCP_INT_STAT_BUFFER_OVERFLOW	0x0000000000000800ULL
#define  ZCP_INT_STAT_STAT_TBL_PERR	0x0000000000000400ULL
#define  ZCP_INT_STAT_DYN_TBL_PERR	0x0000000000000200ULL
#define  ZCP_INT_STAT_BUF_TBL_PERR	0x0000000000000100ULL
#define  ZCP_INT_STAT_TT_PROGRAM_ERR	0x0000000000000080ULL
#define  ZCP_INT_STAT_RSP_TT_INDEX_ERR	0x0000000000000040ULL
#define  ZCP_INT_STAT_SLV_TT_INDEX_ERR	0x0000000000000020ULL
#define  ZCP_INT_STAT_ZCP_TT_INDEX_ERR	0x0000000000000010ULL
#define  ZCP_INT_STAT_CFIFO_ECC3	0x0000000000000008ULL
#define  ZCP_INT_STAT_CFIFO_ECC2	0x0000000000000004ULL
#define  ZCP_INT_STAT_CFIFO_ECC1	0x0000000000000002ULL
#define  ZCP_INT_STAT_CFIFO_ECC0	0x0000000000000001ULL
#define  ZCP_INT_STAT_ALL		0x000000000000ffffULL

#define ZCP_INT_MASK			(FZC_ZCP + 0x00010UL)
#define  ZCP_INT_MASK_RRFIFO_UNDERRUN	0x0000000000008000ULL
#define  ZCP_INT_MASK_RRFIFO_OVERRUN	0x0000000000004000ULL
#define  ZCP_INT_MASK_LOJ		0x0000000000002000ULL
#define  ZCP_INT_MASK_RSPFIFO_UNCOR_ERR	0x0000000000001000ULL
#define  ZCP_INT_MASK_BUFFER_OVERFLOW	0x0000000000000800ULL
#define  ZCP_INT_MASK_STAT_TBL_PERR	0x0000000000000400ULL
#define  ZCP_INT_MASK_DYN_TBL_PERR	0x0000000000000200ULL
#define  ZCP_INT_MASK_BUF_TBL_PERR	0x0000000000000100ULL
#define  ZCP_INT_MASK_TT_PROGRAM_ERR	0x0000000000000080ULL
#define  ZCP_INT_MASK_RSP_TT_INDEX_ERR	0x0000000000000040ULL
#define  ZCP_INT_MASK_SLV_TT_INDEX_ERR	0x0000000000000020ULL
#define  ZCP_INT_MASK_ZCP_TT_INDEX_ERR	0x0000000000000010ULL
#define  ZCP_INT_MASK_CFIFO_ECC3	0x0000000000000008ULL
#define  ZCP_INT_MASK_CFIFO_ECC2	0x0000000000000004ULL
#define  ZCP_INT_MASK_CFIFO_ECC1	0x0000000000000002ULL
#define  ZCP_INT_MASK_CFIFO_ECC0	0x0000000000000001ULL
#define  ZCP_INT_MASK_ALL		0x000000000000ffffULL

#define BAM4BUF				(FZC_ZCP + 0x00018UL)
#define  BAM4BUF_LOJ			0x0000000080000000ULL
#define  BAM4BUF_EN_CK			0x0000000040000000ULL
#define  BAM4BUF_IDX_END0		0x000000003ff00000ULL
#define  BAM4BUF_IDX_ST0		0x00000000000ffc00ULL
#define  BAM4BUF_OFFSET0		0x00000000000003ffULL

#define BAM8BUF				(FZC_ZCP + 0x00020UL)
#define  BAM8BUF_LOJ			0x0000000080000000ULL
#define  BAM8BUF_EN_CK			0x0000000040000000ULL
#define  BAM8BUF_IDX_END1		0x000000003ff00000ULL
#define  BAM8BUF_IDX_ST1		0x00000000000ffc00ULL
#define  BAM8BUF_OFFSET1		0x00000000000003ffULL

#define BAM16BUF			(FZC_ZCP + 0x00028UL)
#define  BAM16BUF_LOJ			0x0000000080000000ULL
#define  BAM16BUF_EN_CK			0x0000000040000000ULL
#define  BAM16BUF_IDX_END2		0x000000003ff00000ULL
#define  BAM16BUF_IDX_ST2		0x00000000000ffc00ULL
#define  BAM16BUF_OFFSET2		0x00000000000003ffULL

#define BAM32BUF			(FZC_ZCP + 0x00030UL)
#define  BAM32BUF_LOJ			0x0000000080000000ULL
#define  BAM32BUF_EN_CK			0x0000000040000000ULL
#define  BAM32BUF_IDX_END3		0x000000003ff00000ULL
#define  BAM32BUF_IDX_ST3		0x00000000000ffc00ULL
#define  BAM32BUF_OFFSET3		0x00000000000003ffULL

#define DST4BUF				(FZC_ZCP + 0x00038UL)
#define  DST4BUF_DS_OFFSET0		0x00000000000003ffULL

#define DST8BUF				(FZC_ZCP + 0x00040UL)
#define  DST8BUF_DS_OFFSET1		0x00000000000003ffULL

#define DST16BUF			(FZC_ZCP + 0x00048UL)
#define  DST16BUF_DS_OFFSET2		0x00000000000003ffULL

#define DST32BUF			(FZC_ZCP + 0x00050UL)
#define  DST32BUF_DS_OFFSET3		0x00000000000003ffULL

#define ZCP_RAM_DATA0			(FZC_ZCP + 0x00058UL)
#define  ZCP_RAM_DATA0_DAT0		0x00000000ffffffffULL

#define ZCP_RAM_DATA1			(FZC_ZCP + 0x00060UL)
#define  ZCP_RAM_DAT10_DAT1		0x00000000ffffffffULL

#define ZCP_RAM_DATA2			(FZC_ZCP + 0x00068UL)
#define  ZCP_RAM_DATA2_DAT2		0x00000000ffffffffULL

#define ZCP_RAM_DATA3			(FZC_ZCP + 0x00070UL)
#define  ZCP_RAM_DATA3_DAT3		0x00000000ffffffffULL

#define ZCP_RAM_DATA4			(FZC_ZCP + 0x00078UL)
#define  ZCP_RAM_DATA4_DAT4		0x00000000000000ffULL

#define ZCP_RAM_BE			(FZC_ZCP + 0x00080UL)
#define  ZCP_RAM_BE_VAL			0x000000000001ffffULL

#define ZCP_RAM_ACC			(FZC_ZCP + 0x00088UL)
#define  ZCP_RAM_ACC_BUSY		0x0000000080000000ULL
#define  ZCP_RAM_ACC_READ		0x0000000040000000ULL
#define  ZCP_RAM_ACC_WRITE		0x0000000000000000ULL
#define  ZCP_RAM_ACC_LOJ		0x0000000020000000ULL
#define  ZCP_RAM_ACC_ZFCID		0x000000001ffe0000ULL
#define  ZCP_RAM_ACC_ZFCID_SHIFT	17
#define  ZCP_RAM_ACC_RAM_SEL		0x000000000001f000ULL
#define  ZCP_RAM_ACC_RAM_SEL_SHIFT	12
#define  ZCP_RAM_ACC_CFIFOADDR		0x0000000000000fffULL
#define  ZCP_RAM_ACC_CFIFOADDR_SHIFT	0

#define ZCP_RAM_SEL_BAM(INDEX)		(0x00 + (INDEX))
#define ZCP_RAM_SEL_TT_STATIC		0x08
#define ZCP_RAM_SEL_TT_DYNAMIC		0x09
#define ZCP_RAM_SEL_CFIFO(PORT)		(0x10 + (PORT))

#define NIU_CFIFO_ENTRIES		1024
#define ATLAS_P0_P1_CFIFO_ENTRIES	2048
#define ATLAS_P2_P3_CFIFO_ENTRIES	1024

#define CHK_BIT_DATA			(FZC_ZCP + 0x00090UL)
#define  CHK_BIT_DATA_DATA		0x000000000000ffffULL

#define RESET_CFIFO			(FZC_ZCP + 0x00098UL)
#define  RESET_CFIFO_RST(PORT)		(0x1 << (PORT))

#define CFIFO_ECC(PORT)			(FZC_ZCP + 0x000a0UL + (PORT) * 8UL)
#define  CFIFO_ECC_DIS_DBLBIT_ERR	0x0000000080000000ULL
#define  CFIFO_ECC_DBLBIT_ERR		0x0000000000020000ULL
#define  CFIFO_ECC_SINGLEBIT_ERR	0x0000000000010000ULL
#define  CFIFO_ECC_ALL_PKT		0x0000000000000400ULL
#define  CFIFO_ECC_LAST_LINE		0x0000000000000004ULL
#define  CFIFO_ECC_2ND_LINE		0x0000000000000002ULL
#define  CFIFO_ECC_1ST_LINE		0x0000000000000001ULL

#define ZCP_TRAINING_VECTOR		(FZC_ZCP + 0x000c0UL)
#define  ZCP_TRAINING_VECTOR_VECTOR	0x00000000ffffffffULL

#define ZCP_STATE_MACHINE		(FZC_ZCP + 0x000c8UL)
#define  ZCP_STATE_MACHINE_SM		0x00000000ffffffffULL

/* Same bits as ZCP_INT_STAT */
#define ZCP_INT_STAT_TEST		(FZC_ZCP + 0x00108UL)

#define RXDMA_CFIG1(IDX)		(DMC + 0x00000UL + (IDX) * 0x200UL)
#define  RXDMA_CFIG1_EN			0x0000000080000000ULL
#define  RXDMA_CFIG1_RST		0x0000000040000000ULL
#define  RXDMA_CFIG1_QST		0x0000000020000000ULL
#define  RXDMA_CFIG1_MBADDR_H		0x0000000000000fffULL /* mboxaddr 43:32 */

#define RXDMA_CFIG2(IDX)		(DMC + 0x00008UL + (IDX) * 0x200UL)
#define  RXDMA_CFIG2_MBADDR_L		0x00000000ffffffc0ULL /* mboxaddr 31:6 */
#define  RXDMA_CFIG2_OFFSET		0x0000000000000006ULL
#define  RXDMA_CFIG2_OFFSET_SHIFT	1
#define  RXDMA_CFIG2_FULL_HDR		0x0000000000000001ULL

#define RBR_CFIG_A(IDX)			(DMC + 0x00010UL + (IDX) * 0x200UL)
#define  RBR_CFIG_A_LEN			0xffff000000000000ULL
#define  RBR_CFIG_A_LEN_SHIFT		48
#define  RBR_CFIG_A_STADDR_BASE		0x00000ffffffc0000ULL
#define  RBR_CFIG_A_STADDR		0x000000000003ffc0ULL

#define RBR_CFIG_B(IDX)			(DMC + 0x00018UL + (IDX) * 0x200UL)
#define  RBR_CFIG_B_BLKSIZE		0x0000000003000000ULL
#define  RBR_CFIG_B_BLKSIZE_SHIFT	24
#define  RBR_CFIG_B_VLD2		0x0000000000800000ULL
#define  RBR_CFIG_B_BUFSZ2		0x0000000000030000ULL
#define  RBR_CFIG_B_BUFSZ2_SHIFT	16
#define  RBR_CFIG_B_VLD1		0x0000000000008000ULL
#define  RBR_CFIG_B_BUFSZ1		0x0000000000000300ULL
#define  RBR_CFIG_B_BUFSZ1_SHIFT	8
#define  RBR_CFIG_B_VLD0		0x0000000000000080ULL
#define  RBR_CFIG_B_BUFSZ0		0x0000000000000003ULL
#define  RBR_CFIG_B_BUFSZ0_SHIFT	0

#define RBR_BLKSIZE_4K			0x0
#define RBR_BLKSIZE_8K			0x1
#define RBR_BLKSIZE_16K			0x2
#define RBR_BLKSIZE_32K			0x3
#define RBR_BUFSZ2_2K			0x0
#define RBR_BUFSZ2_4K			0x1
#define RBR_BUFSZ2_8K			0x2
#define RBR_BUFSZ2_16K			0x3
#define RBR_BUFSZ1_1K			0x0
#define RBR_BUFSZ1_2K			0x1
#define RBR_BUFSZ1_4K			0x2
#define RBR_BUFSZ1_8K			0x3
#define RBR_BUFSZ0_256			0x0
#define RBR_BUFSZ0_512			0x1
#define RBR_BUFSZ0_1K			0x2
#define RBR_BUFSZ0_2K			0x3

#define RBR_KICK(IDX)			(DMC + 0x00020UL + (IDX) * 0x200UL)
#define  RBR_KICK_BKADD			0x000000000000ffffULL

#define RBR_STAT(IDX)			(DMC + 0x00028UL + (IDX) * 0x200UL)
#define  RBR_STAT_QLEN			0x000000000000ffffULL

#define RBR_HDH(IDX)			(DMC + 0x00030UL + (IDX) * 0x200UL)
#define  RBR_HDH_HEAD_H			0x0000000000000fffULL

#define RBR_HDL(IDX)			(DMC + 0x00038UL + (IDX) * 0x200UL)
#define  RBR_HDL_HEAD_L			0x00000000fffffffcULL

#define RCRCFIG_A(IDX)			(DMC + 0x00040UL + (IDX) * 0x200UL)
#define  RCRCFIG_A_LEN			0xffff000000000000ULL
#define  RCRCFIG_A_LEN_SHIFT		48
#define  RCRCFIG_A_STADDR_BASE		0x00000ffffff80000ULL
#define  RCRCFIG_A_STADDR		0x000000000007ffc0ULL

#define RCRCFIG_B(IDX)			(DMC + 0x00048UL + (IDX) * 0x200UL)
#define  RCRCFIG_B_PTHRES		0x00000000ffff0000ULL
#define  RCRCFIG_B_PTHRES_SHIFT		16
#define  RCRCFIG_B_ENTOUT		0x0000000000008000ULL
#define  RCRCFIG_B_TIMEOUT		0x000000000000003fULL
#define  RCRCFIG_B_TIMEOUT_SHIFT	0

#define RCRSTAT_A(IDX)			(DMC + 0x00050UL + (IDX) * 0x200UL)
#define  RCRSTAT_A_QLEN			0x000000000000ffffULL

#define RCRSTAT_B(IDX)			(DMC + 0x00058UL + (IDX) * 0x200UL)
#define  RCRSTAT_B_TIPTR_H		0x0000000000000fffULL

#define RCRSTAT_C(IDX)			(DMC + 0x00060UL + (IDX) * 0x200UL)
#define  RCRSTAT_C_TIPTR_L		0x00000000fffffff8ULL

#define RX_DMA_CTL_STAT(IDX)		(DMC + 0x00070UL + (IDX) * 0x200UL)
#define  RX_DMA_CTL_STAT_RBR_TMOUT	0x0020000000000000ULL
#define  RX_DMA_CTL_STAT_RSP_CNT_ERR	0x0010000000000000ULL
#define  RX_DMA_CTL_STAT_BYTE_EN_BUS	0x0008000000000000ULL
#define  RX_DMA_CTL_STAT_RSP_DAT_ERR	0x0004000000000000ULL
#define  RX_DMA_CTL_STAT_RCR_ACK_ERR	0x0002000000000000ULL
#define  RX_DMA_CTL_STAT_DC_FIFO_ERR	0x0001000000000000ULL
#define  RX_DMA_CTL_STAT_MEX		0x0000800000000000ULL
#define  RX_DMA_CTL_STAT_RCRTHRES	0x0000400000000000ULL
#define  RX_DMA_CTL_STAT_RCRTO		0x0000200000000000ULL
#define  RX_DMA_CTL_STAT_RCR_SHA_PAR	0x0000100000000000ULL
#define  RX_DMA_CTL_STAT_RBR_PRE_PAR	0x0000080000000000ULL
#define  RX_DMA_CTL_STAT_PORT_DROP_PKT	0x0000040000000000ULL
#define  RX_DMA_CTL_STAT_WRED_DROP	0x0000020000000000ULL
#define  RX_DMA_CTL_STAT_RBR_PRE_EMTY	0x0000010000000000ULL
#define  RX_DMA_CTL_STAT_RCRSHADOW_FULL	0x0000008000000000ULL
#define  RX_DMA_CTL_STAT_CONFIG_ERR	0x0000004000000000ULL
#define  RX_DMA_CTL_STAT_RCRINCON	0x0000002000000000ULL
#define  RX_DMA_CTL_STAT_RCRFULL	0x0000001000000000ULL
#define  RX_DMA_CTL_STAT_RBR_EMPTY	0x0000000800000000ULL
#define  RX_DMA_CTL_STAT_RBRFULL	0x0000000400000000ULL
#define  RX_DMA_CTL_STAT_RBRLOGPAGE	0x0000000200000000ULL
#define  RX_DMA_CTL_STAT_CFIGLOGPAGE	0x0000000100000000ULL
#define  RX_DMA_CTL_STAT_PTRREAD	0x00000000ffff0000ULL
#define  RX_DMA_CTL_STAT_PTRREAD_SHIFT	16
#define  RX_DMA_CTL_STAT_PKTREAD	0x000000000000ffffULL
#define  RX_DMA_CTL_STAT_PKTREAD_SHIFT	0

#define  RX_DMA_CTL_STAT_CHAN_FATAL	(RX_DMA_CTL_STAT_RBR_TMOUT | \
					 RX_DMA_CTL_STAT_RSP_CNT_ERR | \
					 RX_DMA_CTL_STAT_BYTE_EN_BUS | \
					 RX_DMA_CTL_STAT_RSP_DAT_ERR | \
					 RX_DMA_CTL_STAT_RCR_ACK_ERR | \
					 RX_DMA_CTL_STAT_RCR_SHA_PAR | \
					 RX_DMA_CTL_STAT_RBR_PRE_PAR | \
					 RX_DMA_CTL_STAT_CONFIG_ERR | \
					 RX_DMA_CTL_STAT_RCRINCON | \
					 RX_DMA_CTL_STAT_RCRFULL | \
					 RX_DMA_CTL_STAT_RBRFULL | \
					 RX_DMA_CTL_STAT_RBRLOGPAGE | \
					 RX_DMA_CTL_STAT_CFIGLOGPAGE)

#define RX_DMA_CTL_STAT_PORT_FATAL	(RX_DMA_CTL_STAT_DC_FIFO_ERR)

#define RX_DMA_CTL_WRITE_CLEAR_ERRS	(RX_DMA_CTL_STAT_RBR_EMPTY | \
					 RX_DMA_CTL_STAT_RCRSHADOW_FULL | \
					 RX_DMA_CTL_STAT_RBR_PRE_EMTY | \
					 RX_DMA_CTL_STAT_WRED_DROP | \
					 RX_DMA_CTL_STAT_PORT_DROP_PKT | \
					 RX_DMA_CTL_STAT_RCRTO | \
					 RX_DMA_CTL_STAT_RCRTHRES | \
					 RX_DMA_CTL_STAT_DC_FIFO_ERR)

#define RCR_FLSH(IDX)			(DMC + 0x00078UL + (IDX) * 0x200UL)
#define  RCR_FLSH_FLSH			0x0000000000000001ULL

#define RXMISC(IDX)			(DMC + 0x00090UL + (IDX) * 0x200UL)
#define  RXMISC_OFLOW			0x0000000000010000ULL
#define  RXMISC_COUNT			0x000000000000ffffULL

#define RX_DMA_CTL_STAT_DBG(IDX)	(DMC + 0x00098UL + (IDX) * 0x200UL)
#define  RX_DMA_CTL_STAT_DBG_RBR_TMOUT		0x0020000000000000ULL
#define  RX_DMA_CTL_STAT_DBG_RSP_CNT_ERR	0x0010000000000000ULL
#define  RX_DMA_CTL_STAT_DBG_BYTE_EN_BUS	0x0008000000000000ULL
#define  RX_DMA_CTL_STAT_DBG_RSP_DAT_ERR	0x0004000000000000ULL
#define  RX_DMA_CTL_STAT_DBG_RCR_ACK_ERR	0x0002000000000000ULL
#define  RX_DMA_CTL_STAT_DBG_DC_FIFO_ERR	0x0001000000000000ULL
#define  RX_DMA_CTL_STAT_DBG_MEX		0x0000800000000000ULL
#define  RX_DMA_CTL_STAT_DBG_RCRTHRES		0x0000400000000000ULL
#define  RX_DMA_CTL_STAT_DBG_RCRTO		0x0000200000000000ULL
#define  RX_DMA_CTL_STAT_DBG_RCR_SHA_PAR	0x0000100000000000ULL
#define  RX_DMA_CTL_STAT_DBG_RBR_PRE_PAR	0x0000080000000000ULL
#define  RX_DMA_CTL_STAT_DBG_PORT_DROP_PKT	0x0000040000000000ULL
#define  RX_DMA_CTL_STAT_DBG_WRED_DROP		0x0000020000000000ULL
#define  RX_DMA_CTL_STAT_DBG_RBR_PRE_EMTY	0x0000010000000000ULL
#define  RX_DMA_CTL_STAT_DBG_RCRSHADOW_FULL	0x0000008000000000ULL
#define  RX_DMA_CTL_STAT_DBG_CONFIG_ERR		0x0000004000000000ULL
#define  RX_DMA_CTL_STAT_DBG_RCRINCON		0x0000002000000000ULL
#define  RX_DMA_CTL_STAT_DBG_RCRFULL		0x0000001000000000ULL
#define  RX_DMA_CTL_STAT_DBG_RBR_EMPTY		0x0000000800000000ULL
#define  RX_DMA_CTL_STAT_DBG_RBRFULL		0x0000000400000000ULL
#define  RX_DMA_CTL_STAT_DBG_RBRLOGPAGE		0x0000000200000000ULL
#define  RX_DMA_CTL_STAT_DBG_CFIGLOGPAGE	0x0000000100000000ULL
#define  RX_DMA_CTL_STAT_DBG_PTRREAD		0x00000000ffff0000ULL
#define  RX_DMA_CTL_STAT_DBG_PKTREAD		0x000000000000ffffULL

#define RX_DMA_ENT_MSK(IDX)		(DMC + 0x00068UL + (IDX) * 0x200UL)
#define  RX_DMA_ENT_MSK_RBR_TMOUT	0x0000000000200000ULL
#define  RX_DMA_ENT_MSK_RSP_CNT_ERR	0x0000000000100000ULL
#define  RX_DMA_ENT_MSK_BYTE_EN_BUS	0x0000000000080000ULL
#define  RX_DMA_ENT_MSK_RSP_DAT_ERR	0x0000000000040000ULL
#define  RX_DMA_ENT_MSK_RCR_ACK_ERR	0x0000000000020000ULL
#define  RX_DMA_ENT_MSK_DC_FIFO_ERR	0x0000000000010000ULL
#define  RX_DMA_ENT_MSK_RCRTHRES	0x0000000000004000ULL
#define  RX_DMA_ENT_MSK_RCRTO		0x0000000000002000ULL
#define  RX_DMA_ENT_MSK_RCR_SHA_PAR	0x0000000000001000ULL
#define  RX_DMA_ENT_MSK_RBR_PRE_PAR	0x0000000000000800ULL
#define  RX_DMA_ENT_MSK_PORT_DROP_PKT	0x0000000000000400ULL
#define  RX_DMA_ENT_MSK_WRED_DROP	0x0000000000000200ULL
#define  RX_DMA_ENT_MSK_RBR_PRE_EMTY	0x0000000000000100ULL
#define  RX_DMA_ENT_MSK_RCR_SHADOW_FULL	0x0000000000000080ULL
#define  RX_DMA_ENT_MSK_CONFIG_ERR	0x0000000000000040ULL
#define  RX_DMA_ENT_MSK_RCRINCON	0x0000000000000020ULL
#define  RX_DMA_ENT_MSK_RCRFULL		0x0000000000000010ULL
#define  RX_DMA_ENT_MSK_RBR_EMPTY	0x0000000000000008ULL
#define  RX_DMA_ENT_MSK_RBRFULL		0x0000000000000004ULL
#define  RX_DMA_ENT_MSK_RBRLOGPAGE	0x0000000000000002ULL
#define  RX_DMA_ENT_MSK_CFIGLOGPAGE	0x0000000000000001ULL
#define  RX_DMA_ENT_MSK_ALL		0x00000000003f7fffULL

#define TX_RNG_CFIG(IDX)		(DMC + 0x40000UL + (IDX) * 0x200UL)
#define  TX_RNG_CFIG_LEN		0x1fff000000000000ULL
#define  TX_RNG_CFIG_LEN_SHIFT		48
#define  TX_RNG_CFIG_STADDR_BASE	0x00000ffffff80000ULL
#define  TX_RNG_CFIG_STADDR		0x000000000007ffc0ULL

#define TX_RING_HDL(IDX)		(DMC + 0x40010UL + (IDX) * 0x200UL)
#define  TX_RING_HDL_WRAP		0x0000000000080000ULL
#define  TX_RING_HDL_HEAD		0x000000000007fff8ULL
#define  TX_RING_HDL_HEAD_SHIFT		3

#define TX_RING_KICK(IDX)		(DMC + 0x40018UL + (IDX) * 0x200UL)
#define  TX_RING_KICK_WRAP		0x0000000000080000ULL
#define  TX_RING_KICK_TAIL		0x000000000007fff8ULL

#define TX_ENT_MSK(IDX)			(DMC + 0x40020UL + (IDX) * 0x200UL)
#define  TX_ENT_MSK_MK			0x0000000000008000ULL
#define  TX_ENT_MSK_MBOX_ERR		0x0000000000000080ULL
#define  TX_ENT_MSK_PKT_SIZE_ERR	0x0000000000000040ULL
#define  TX_ENT_MSK_TX_RING_OFLOW	0x0000000000000020ULL
#define  TX_ENT_MSK_PREF_BUF_ECC_ERR	0x0000000000000010ULL
#define  TX_ENT_MSK_NACK_PREF		0x0000000000000008ULL
#define  TX_ENT_MSK_NACK_PKT_RD		0x0000000000000004ULL
#define  TX_ENT_MSK_CONF_PART_ERR	0x0000000000000002ULL
#define  TX_ENT_MSK_PKT_PRT_ERR		0x0000000000000001ULL

#define TX_CS(IDX)			(DMC + 0x40028UL + (IDX)*0x200UL)
#define  TX_CS_PKT_CNT			0x0fff000000000000ULL
#define  TX_CS_PKT_CNT_SHIFT		48
#define  TX_CS_LASTMARK			0x00000fff00000000ULL
#define  TX_CS_LASTMARK_SHIFT		32
#define  TX_CS_RST			0x0000000080000000ULL
#define  TX_CS_RST_STATE		0x0000000040000000ULL
#define  TX_CS_MB			0x0000000020000000ULL
#define  TX_CS_STOP_N_GO		0x0000000010000000ULL
#define  TX_CS_SNG_STATE		0x0000000008000000ULL
#define  TX_CS_MK			0x0000000000008000ULL
#define  TX_CS_MMK			0x0000000000004000ULL
#define  TX_CS_MBOX_ERR			0x0000000000000080ULL
#define  TX_CS_PKT_SIZE_ERR		0x0000000000000040ULL
#define  TX_CS_TX_RING_OFLOW		0x0000000000000020ULL
#define  TX_CS_PREF_BUF_PAR_ERR		0x0000000000000010ULL
#define  TX_CS_NACK_PREF		0x0000000000000008ULL
#define  TX_CS_NACK_PKT_RD		0x0000000000000004ULL
#define  TX_CS_CONF_PART_ERR		0x0000000000000002ULL
#define  TX_CS_PKT_PRT_ERR		0x0000000000000001ULL

#define TXDMA_MBH(IDX)			(DMC + 0x40030UL + (IDX) * 0x200UL)
#define  TXDMA_MBH_MBADDR		0x0000000000000fffULL

#define TXDMA_MBL(IDX)			(DMC + 0x40038UL + (IDX) * 0x200UL)
#define  TXDMA_MBL_MBADDR		0x00000000ffffffc0ULL

#define TX_DMA_PRE_ST(IDX)		(DMC + 0x40040UL + (IDX) * 0x200UL)
#define  TX_DMA_PRE_ST_SHADOW_HD	0x000000000007ffffULL

#define TX_RNG_ERR_LOGH(IDX)		(DMC + 0x40048UL + (IDX) * 0x200UL)
#define  TX_RNG_ERR_LOGH_ERR		0x0000000080000000ULL
#define  TX_RNG_ERR_LOGH_MERR		0x0000000040000000ULL
#define  TX_RNG_ERR_LOGH_ERRCODE	0x0000000038000000ULL
#define  TX_RNG_ERR_LOGH_ERRADDR	0x0000000000000fffULL

#define TX_RNG_ERR_LOGL(IDX)		(DMC + 0x40050UL + (IDX) * 0x200UL)
#define  TX_RNG_ERR_LOGL_ERRADDR	0x00000000ffffffffULL

#define TDMC_INTR_DBG(IDX)		(DMC + 0x40060UL + (IDX) * 0x200UL)
#define  TDMC_INTR_DBG_MK		0x0000000000008000ULL
#define  TDMC_INTR_DBG_MBOX_ERR		0x0000000000000080ULL
#define  TDMC_INTR_DBG_PKT_SIZE_ERR	0x0000000000000040ULL
#define  TDMC_INTR_DBG_TX_RING_OFLOW	0x0000000000000020ULL
#define  TDMC_INTR_DBG_PREF_BUF_PAR_ERR	0x0000000000000010ULL
#define  TDMC_INTR_DBG_NACK_PREF	0x0000000000000008ULL
#define  TDMC_INTR_DBG_NACK_PKT_RD	0x0000000000000004ULL
#define  TDMC_INTR_DBG_CONF_PART_ERR	0x0000000000000002ULL
#define  TDMC_INTR_DBG_PKT_PART_ERR	0x0000000000000001ULL

#define TX_CS_DBG(IDX)			(DMC + 0x40068UL + (IDX) * 0x200UL)
#define  TX_CS_DBG_PKT_CNT		0x0fff000000000000ULL

#define TDMC_INJ_PAR_ERR(IDX)		(DMC + 0x45040UL + (IDX) * 0x200UL)
#define  TDMC_INJ_PAR_ERR_VAL		0x000000000000ffffULL

#define TDMC_DBG_SEL(IDX)		(DMC + 0x45080UL + (IDX) * 0x200UL)
#define  TDMC_DBG_SEL_DBG_SEL		0x000000000000003fULL

#define TDMC_TRAINING_VECTOR(IDX)	(DMC + 0x45088UL + (IDX) * 0x200UL)
#define  TDMC_TRAINING_VECTOR_VEC	0x00000000ffffffffULL

#define TXC_DMA_MAX(CHAN)		(FZC_TXC + 0x00000UL + (CHAN)*0x1000UL)
#define TXC_DMA_MAX_LEN(CHAN)		(FZC_TXC + 0x00008UL + (CHAN)*0x1000UL)

#define TXC_CONTROL			(FZC_TXC + 0x20000UL)
#define  TXC_CONTROL_ENABLE		0x0000000000000010ULL
#define  TXC_CONTROL_PORT_ENABLE(X)	(1 << (X))

#define TXC_TRAINING_VEC		(FZC_TXC + 0x20008UL)
#define  TXC_TRAINING_VEC_MASK		0x00000000ffffffffULL

#define TXC_DEBUG			(FZC_TXC + 0x20010UL)
#define  TXC_DEBUG_SELECT		0x000000000000003fULL

#define TXC_MAX_REORDER			(FZC_TXC + 0x20018UL)
#define  TXC_MAX_REORDER_PORT3		0x000000000f000000ULL
#define  TXC_MAX_REORDER_PORT2		0x00000000000f0000ULL
#define  TXC_MAX_REORDER_PORT1		0x0000000000000f00ULL
#define  TXC_MAX_REORDER_PORT0		0x000000000000000fULL

#define TXC_PORT_CTL(PORT)		(FZC_TXC + 0x20020UL + (PORT)*0x100UL)
#define  TXC_PORT_CTL_CLR_ALL_STAT	0x0000000000000001ULL

#define TXC_PKT_STUFFED(PORT)		(FZC_TXC + 0x20030UL + (PORT)*0x100UL)
#define  TXC_PKT_STUFFED_PP_REORDER	0x00000000ffff0000ULL
#define  TXC_PKT_STUFFED_PP_PACKETASSY	0x000000000000ffffULL

#define TXC_PKT_XMIT(PORT)		(FZC_TXC + 0x20038UL + (PORT)*0x100UL)
#define  TXC_PKT_XMIT_BYTES		0x00000000ffff0000ULL
#define  TXC_PKT_XMIT_PKTS		0x000000000000ffffULL

#define TXC_ROECC_CTL(PORT)		(FZC_TXC + 0x20040UL + (PORT)*0x100UL)
#define  TXC_ROECC_CTL_DISABLE_UE	0x0000000080000000ULL
#define  TXC_ROECC_CTL_DBL_BIT_ERR	0x0000000000020000ULL
#define  TXC_ROECC_CTL_SNGL_BIT_ERR	0x0000000000010000ULL
#define  TXC_ROECC_CTL_ALL_PKTS		0x0000000000000400ULL
#define  TXC_ROECC_CTL_ALT_PKTS		0x0000000000000200ULL
#define  TXC_ROECC_CTL_ONE_PKT_ONLY	0x0000000000000100ULL
#define  TXC_ROECC_CTL_LST_PKT_LINE	0x0000000000000004ULL
#define  TXC_ROECC_CTL_2ND_PKT_LINE	0x0000000000000002ULL
#define  TXC_ROECC_CTL_1ST_PKT_LINE	0x0000000000000001ULL

#define TXC_ROECC_ST(PORT)		(FZC_TXC + 0x20048UL + (PORT)*0x100UL)
#define  TXC_ROECC_CLR_ST		0x0000000080000000ULL
#define  TXC_ROECC_CE			0x0000000000020000ULL
#define  TXC_ROECC_UE			0x0000000000010000ULL
#define  TXC_ROECC_ST_ECC_ADDR		0x00000000000003ffULL

#define TXC_RO_DATA0(PORT)		(FZC_TXC + 0x20050UL + (PORT)*0x100UL)
#define  TXC_RO_DATA0_DATA0		0x00000000ffffffffULL /* bits 31:0 */

#define TXC_RO_DATA1(PORT)		(FZC_TXC + 0x20058UL + (PORT)*0x100UL)
#define  TXC_RO_DATA1_DATA1		0x00000000ffffffffULL /* bits 63:32 */

#define TXC_RO_DATA2(PORT)		(FZC_TXC + 0x20060UL + (PORT)*0x100UL)
#define  TXC_RO_DATA2_DATA2		0x00000000ffffffffULL /* bits 95:64 */

#define TXC_RO_DATA3(PORT)		(FZC_TXC + 0x20068UL + (PORT)*0x100UL)
#define  TXC_RO_DATA3_DATA3		0x00000000ffffffffULL /* bits 127:96 */

#define TXC_RO_DATA4(PORT)		(FZC_TXC + 0x20070UL + (PORT)*0x100UL)
#define  TXC_RO_DATA4_DATA4		0x0000000000ffffffULL /* bits 151:128 */

#define TXC_SFECC_CTL(PORT)		(FZC_TXC + 0x20078UL + (PORT)*0x100UL)
#define  TXC_SFECC_CTL_DISABLE_UE	0x0000000080000000ULL
#define  TXC_SFECC_CTL_DBL_BIT_ERR	0x0000000000020000ULL
#define  TXC_SFECC_CTL_SNGL_BIT_ERR	0x0000000000010000ULL
#define  TXC_SFECC_CTL_ALL_PKTS		0x0000000000000400ULL
#define  TXC_SFECC_CTL_ALT_PKTS		0x0000000000000200ULL
#define  TXC_SFECC_CTL_ONE_PKT_ONLY	0x0000000000000100ULL
#define  TXC_SFECC_CTL_LST_PKT_LINE	0x0000000000000004ULL
#define  TXC_SFECC_CTL_2ND_PKT_LINE	0x0000000000000002ULL
#define  TXC_SFECC_CTL_1ST_PKT_LINE	0x0000000000000001ULL

#define TXC_SFECC_ST(PORT)		(FZC_TXC + 0x20080UL + (PORT)*0x100UL)
#define  TXC_SFECC_ST_CLR_ST		0x0000000080000000ULL
#define  TXC_SFECC_ST_CE		0x0000000000020000ULL
#define  TXC_SFECC_ST_UE		0x0000000000010000ULL
#define  TXC_SFECC_ST_ECC_ADDR		0x00000000000003ffULL

#define TXC_SF_DATA0(PORT)		(FZC_TXC + 0x20088UL + (PORT)*0x100UL)
#define  TXC_SF_DATA0_DATA0		0x00000000ffffffffULL /* bits 31:0 */

#define TXC_SF_DATA1(PORT)		(FZC_TXC + 0x20090UL + (PORT)*0x100UL)
#define  TXC_SF_DATA1_DATA1		0x00000000ffffffffULL /* bits 63:32 */

#define TXC_SF_DATA2(PORT)		(FZC_TXC + 0x20098UL + (PORT)*0x100UL)
#define  TXC_SF_DATA2_DATA2		0x00000000ffffffffULL /* bits 95:64 */

#define TXC_SF_DATA3(PORT)		(FZC_TXC + 0x200a0UL + (PORT)*0x100UL)
#define  TXC_SF_DATA3_DATA3		0x00000000ffffffffULL /* bits 127:96 */

#define TXC_SF_DATA4(PORT)		(FZC_TXC + 0x200a8UL + (PORT)*0x100UL)
#define  TXC_SF_DATA4_DATA4		0x0000000000ffffffULL /* bits 151:128 */

#define TXC_RO_TIDS(PORT)		(FZC_TXC + 0x200b0UL + (PORT)*0x100UL)
#define  TXC_RO_TIDS_IN_USE		0x00000000ffffffffULL

#define TXC_RO_STATE0(PORT)		(FZC_TXC + 0x200b8UL + (PORT)*0x100UL)
#define  TXC_RO_STATE0_DUPLICATE_TID	0x00000000ffffffffULL

#define TXC_RO_STATE1(PORT)		(FZC_TXC + 0x200c0UL + (PORT)*0x100UL)
#define  TXC_RO_STATE1_UNUSED_TID	0x00000000ffffffffULL

#define TXC_RO_STATE2(PORT)		(FZC_TXC + 0x200c8UL + (PORT)*0x100UL)
#define  TXC_RO_STATE2_TRANS_TIMEOUT	0x00000000ffffffffULL

#define TXC_RO_STATE3(PORT)		(FZC_TXC + 0x200d0UL + (PORT)*0x100UL)
#define  TXC_RO_STATE3_ENAB_SPC_WMARK	0x0000000080000000ULL
#define  TXC_RO_STATE3_RO_SPC_WMARK	0x000000007fe00000ULL
#define  TXC_RO_STATE3_ROFIFO_SPC_AVAIL	0x00000000001ff800ULL
#define  TXC_RO_STATE3_ENAB_RO_WMARK	0x0000000000000100ULL
#define  TXC_RO_STATE3_HIGH_RO_USED	0x00000000000000f0ULL
#define  TXC_RO_STATE3_NUM_RO_USED	0x000000000000000fULL

#define TXC_RO_CTL(PORT)		(FZC_TXC + 0x200d8UL + (PORT)*0x100UL)
#define  TXC_RO_CTL_CLR_FAIL_STATE	0x0000000080000000ULL
#define  TXC_RO_CTL_RO_ADDR		0x000000000f000000ULL
#define  TXC_RO_CTL_ADDR_FAILED		0x0000000000400000ULL
#define  TXC_RO_CTL_DMA_FAILED		0x0000000000200000ULL
#define  TXC_RO_CTL_LEN_FAILED		0x0000000000100000ULL
#define  TXC_RO_CTL_CAPT_ADDR_FAILED	0x0000000000040000ULL
#define  TXC_RO_CTL_CAPT_DMA_FAILED	0x0000000000020000ULL
#define  TXC_RO_CTL_CAPT_LEN_FAILED	0x0000000000010000ULL
#define  TXC_RO_CTL_RO_STATE_RD_DONE	0x0000000000000080ULL
#define  TXC_RO_CTL_RO_STATE_WR_DONE	0x0000000000000040ULL
#define  TXC_RO_CTL_RO_STATE_RD		0x0000000000000020ULL
#define  TXC_RO_CTL_RO_STATE_WR		0x0000000000000010ULL
#define  TXC_RO_CTL_RO_STATE_ADDR	0x000000000000000fULL

#define TXC_RO_ST_DATA0(PORT)		(FZC_TXC + 0x200e0UL + (PORT)*0x100UL)
#define  TXC_RO_ST_DATA0_DATA0		0x00000000ffffffffULL

#define TXC_RO_ST_DATA1(PORT)		(FZC_TXC + 0x200e8UL + (PORT)*0x100UL)
#define  TXC_RO_ST_DATA1_DATA1		0x00000000ffffffffULL

#define TXC_RO_ST_DATA2(PORT)		(FZC_TXC + 0x200f0UL + (PORT)*0x100UL)
#define  TXC_RO_ST_DATA2_DATA2		0x00000000ffffffffULL

#define TXC_RO_ST_DATA3(PORT)		(FZC_TXC + 0x200f8UL + (PORT)*0x100UL)
#define  TXC_RO_ST_DATA3_DATA3		0x00000000ffffffffULL

#define TXC_PORT_PACKET_REQ(PORT)	(FZC_TXC + 0x20100UL + (PORT)*0x100UL)
#define  TXC_PORT_PACKET_REQ_GATHER_REQ	0x00000000f0000000ULL
#define  TXC_PORT_PACKET_REQ_PKT_REQ	0x000000000fff0000ULL
#define  TXC_PORT_PACKET_REQ_PERR_ABRT	0x000000000000ffffULL

	/* bits are same as TXC_INT_STAT */
#define TXC_INT_STAT_DBG		(FZC_TXC + 0x20420UL)

#define TXC_INT_STAT			(FZC_TXC + 0x20428UL)
#define  TXC_INT_STAT_VAL_SHIFT(PORT)	((PORT) * 8)
#define  TXC_INT_STAT_VAL(PORT)		(0x3f << TXC_INT_STAT_VAL_SHIFT(PORT))
#define  TXC_INT_STAT_SF_CE(PORT)	(0x01 << TXC_INT_STAT_VAL_SHIFT(PORT))
#define  TXC_INT_STAT_SF_UE(PORT)	(0x02 << TXC_INT_STAT_VAL_SHIFT(PORT))
#define  TXC_INT_STAT_RO_CE(PORT)	(0x04 << TXC_INT_STAT_VAL_SHIFT(PORT))
#define  TXC_INT_STAT_RO_UE(PORT)	(0x08 << TXC_INT_STAT_VAL_SHIFT(PORT))
#define  TXC_INT_STAT_REORDER_ERR(PORT)	(0x10 << TXC_INT_STAT_VAL_SHIFT(PORT))
#define  TXC_INT_STAT_PKTASM_DEAD(PORT)	(0x20 << TXC_INT_STAT_VAL_SHIFT(PORT))

#define TXC_INT_MASK			(FZC_TXC + 0x20430UL)
#define  TXC_INT_MASK_VAL_SHIFT(PORT)	((PORT) * 8)
#define  TXC_INT_MASK_VAL(PORT)		(0x3f << TXC_INT_STAT_VAL_SHIFT(PORT))

#define TXC_INT_MASK_SF_CE		0x01
#define TXC_INT_MASK_SF_UE		0x02
#define TXC_INT_MASK_RO_CE		0x04
#define TXC_INT_MASK_RO_UE		0x08
#define TXC_INT_MASK_REORDER_ERR	0x10
#define TXC_INT_MASK_PKTASM_DEAD	0x20
#define TXC_INT_MASK_ALL		0x3f

#define TXC_PORT_DMA(IDX)		(FZC_TXC + 0x20028UL + (IDX)*0x100UL)

#define ESPC_PIO_EN			(FZC_PROM + 0x40000UL)
#define  ESPC_PIO_EN_ENABLE		0x0000000000000001ULL

#define ESPC_PIO_STAT			(FZC_PROM + 0x40008UL)
#define  ESPC_PIO_STAT_READ_START	0x0000000080000000ULL
#define  ESPC_PIO_STAT_READ_END		0x0000000040000000ULL
#define  ESPC_PIO_STAT_WRITE_INIT	0x0000000020000000ULL
#define  ESPC_PIO_STAT_WRITE_END	0x0000000010000000ULL
#define  ESPC_PIO_STAT_ADDR		0x0000000003ffff00ULL
#define  ESPC_PIO_STAT_ADDR_SHIFT	8
#define  ESPC_PIO_STAT_DATA		0x00000000000000ffULL
#define  ESPC_PIO_STAT_DATA_SHIFT	0

#define ESPC_NCR(IDX)			(FZC_PROM + 0x40020UL + (IDX)*0x8UL)
#define  ESPC_NCR_VAL			0x00000000ffffffffULL

#define ESPC_MAC_ADDR0			ESPC_NCR(0)
#define ESPC_MAC_ADDR1			ESPC_NCR(1)
#define ESPC_NUM_PORTS_MACS		ESPC_NCR(2)
#define  ESPC_NUM_PORTS_MACS_VAL	0x00000000000000ffULL
#define ESPC_MOD_STR_LEN		ESPC_NCR(4)
#define ESPC_MOD_STR_1			ESPC_NCR(5)
#define ESPC_MOD_STR_2			ESPC_NCR(6)
#define ESPC_MOD_STR_3			ESPC_NCR(7)
#define ESPC_MOD_STR_4			ESPC_NCR(8)
#define ESPC_MOD_STR_5			ESPC_NCR(9)
#define ESPC_MOD_STR_6			ESPC_NCR(10)
#define ESPC_MOD_STR_7			ESPC_NCR(11)
#define ESPC_MOD_STR_8			ESPC_NCR(12)
#define ESPC_BD_MOD_STR_LEN		ESPC_NCR(13)
#define ESPC_BD_MOD_STR_1		ESPC_NCR(14)
#define ESPC_BD_MOD_STR_2		ESPC_NCR(15)
#define ESPC_BD_MOD_STR_3		ESPC_NCR(16)
#define ESPC_BD_MOD_STR_4		ESPC_NCR(17)

#define ESPC_PHY_TYPE			ESPC_NCR(18)
#define  ESPC_PHY_TYPE_PORT0		0x00000000ff000000ULL
#define  ESPC_PHY_TYPE_PORT0_SHIFT	24
#define  ESPC_PHY_TYPE_PORT1		0x0000000000ff0000ULL
#define  ESPC_PHY_TYPE_PORT1_SHIFT	16
#define  ESPC_PHY_TYPE_PORT2		0x000000000000ff00ULL
#define  ESPC_PHY_TYPE_PORT2_SHIFT	8
#define  ESPC_PHY_TYPE_PORT3		0x00000000000000ffULL
#define  ESPC_PHY_TYPE_PORT3_SHIFT	0

#define  ESPC_PHY_TYPE_1G_COPPER	3
#define  ESPC_PHY_TYPE_1G_FIBER		2
#define  ESPC_PHY_TYPE_10G_COPPER	1
#define  ESPC_PHY_TYPE_10G_FIBER	0

#define ESPC_MAX_FM_SZ			ESPC_NCR(19)

#define ESPC_INTR_NUM			ESPC_NCR(20)
#define  ESPC_INTR_NUM_PORT0		0x00000000ff000000ULL
#define  ESPC_INTR_NUM_PORT1		0x0000000000ff0000ULL
#define  ESPC_INTR_NUM_PORT2		0x000000000000ff00ULL
#define  ESPC_INTR_NUM_PORT3		0x00000000000000ffULL

#define ESPC_VER_IMGSZ			ESPC_NCR(21)
#define  ESPC_VER_IMGSZ_IMGSZ		0x00000000ffff0000ULL
#define  ESPC_VER_IMGSZ_IMGSZ_SHIFT	16
#define  ESPC_VER_IMGSZ_VER		0x000000000000ffffULL
#define  ESPC_VER_IMGSZ_VER_SHIFT	0

#define ESPC_CHKSUM			ESPC_NCR(22)
#define  ESPC_CHKSUM_SUM		0x00000000000000ffULL

#define ESPC_EEPROM_SIZE		0x100000

#define CLASS_CODE_UNRECOG		0x00
#define CLASS_CODE_DUMMY1		0x01
#define CLASS_CODE_ETHERTYPE1		0x02
#define CLASS_CODE_ETHERTYPE2		0x03
#define CLASS_CODE_USER_PROG1		0x04
#define CLASS_CODE_USER_PROG2		0x05
#define CLASS_CODE_USER_PROG3		0x06
#define CLASS_CODE_USER_PROG4		0x07
#define CLASS_CODE_TCP_IPV4		0x08
#define CLASS_CODE_UDP_IPV4		0x09
#define CLASS_CODE_AH_ESP_IPV4		0x0a
#define CLASS_CODE_SCTP_IPV4		0x0b
#define CLASS_CODE_TCP_IPV6		0x0c
#define CLASS_CODE_UDP_IPV6		0x0d
#define CLASS_CODE_AH_ESP_IPV6		0x0e
#define CLASS_CODE_SCTP_IPV6		0x0f
#define CLASS_CODE_ARP			0x10
#define CLASS_CODE_RARP			0x11
#define CLASS_CODE_DUMMY2		0x12
#define CLASS_CODE_DUMMY3		0x13
#define CLASS_CODE_DUMMY4		0x14
#define CLASS_CODE_DUMMY5		0x15
#define CLASS_CODE_DUMMY6		0x16
#define CLASS_CODE_DUMMY7		0x17
#define CLASS_CODE_DUMMY8		0x18
#define CLASS_CODE_DUMMY9		0x19
#define CLASS_CODE_DUMMY10		0x1a
#define CLASS_CODE_DUMMY11		0x1b
#define CLASS_CODE_DUMMY12		0x1c
#define CLASS_CODE_DUMMY13		0x1d
#define CLASS_CODE_DUMMY14		0x1e
#define CLASS_CODE_DUMMY15		0x1f

/* Logical devices and device groups */
#define LDN_RXDMA(CHAN)			(0 + (CHAN))
#define LDN_RESV1(OFF)			(16 + (OFF))
#define LDN_TXDMA(CHAN)			(32 + (CHAN))
#define LDN_RESV2(OFF)			(56 + (OFF))
#define LDN_MIF				63
#define LDN_MAC(PORT)			(64 + (PORT))
#define LDN_DEVICE_ERROR		68
#define LDN_MAX				LDN_DEVICE_ERROR

#define NIU_LDG_MIN			0
#define NIU_LDG_MAX			63
#define NIU_NUM_LDG			64
#define LDG_INVALID			0xff

/* PHY stuff */
#define NIU_PMA_PMD_DEV_ADDR		1
#define NIU_PCS_DEV_ADDR		3

#define NIU_PHY_ID_MASK			0xfffff0f0
#define NIU_PHY_ID_BCM8704		0x00206030
#define NIU_PHY_ID_BCM8706		0x00206035
#define NIU_PHY_ID_BCM5464R		0x002060b0
#define NIU_PHY_ID_MRVL88X2011		0x01410020

/* MRVL88X2011 register addresses */
#define MRVL88X2011_USER_DEV1_ADDR	1
#define MRVL88X2011_USER_DEV2_ADDR	2
#define MRVL88X2011_USER_DEV3_ADDR	3
#define MRVL88X2011_USER_DEV4_ADDR	4
#define MRVL88X2011_PMA_PMD_CTL_1	0x0000
#define MRVL88X2011_PMA_PMD_STATUS_1	0x0001
#define MRVL88X2011_10G_PMD_STATUS_2	0x0008
#define MRVL88X2011_10G_PMD_TX_DIS	0x0009
#define MRVL88X2011_10G_XGXS_LANE_STAT	0x0018
#define MRVL88X2011_GENERAL_CTL		0x8300
#define MRVL88X2011_LED_BLINK_CTL	0x8303
#define MRVL88X2011_LED_8_TO_11_CTL	0x8306

/* MRVL88X2011 register control */
#define MRVL88X2011_ENA_XFPREFCLK	0x0001
#define MRVL88X2011_ENA_PMDTX		0x0000
#define MRVL88X2011_LOOPBACK            0x1
#define MRVL88X2011_LED_ACT		0x1
#define MRVL88X2011_LNK_STATUS_OK	0x4
#define MRVL88X2011_LED_BLKRATE_MASK	0x70
#define MRVL88X2011_LED_BLKRATE_034MS	0x0
#define MRVL88X2011_LED_BLKRATE_067MS	0x1
#define MRVL88X2011_LED_BLKRATE_134MS	0x2
#define MRVL88X2011_LED_BLKRATE_269MS	0x3
#define MRVL88X2011_LED_BLKRATE_538MS	0x4
#define MRVL88X2011_LED_CTL_OFF		0x0
#define MRVL88X2011_LED_CTL_PCS_ACT	0x5
#define MRVL88X2011_LED_CTL_MASK	0x7
#define MRVL88X2011_LED(n,v)		((v)<<((n)*4))
#define MRVL88X2011_LED_STAT(n,v)	((v)>>((n)*4))

#define BCM8704_PMA_PMD_DEV_ADDR	1
#define BCM8704_PCS_DEV_ADDR		2
#define BCM8704_USER_DEV3_ADDR		3
#define BCM8704_PHYXS_DEV_ADDR		4
#define BCM8704_USER_DEV4_ADDR		4

#define BCM8704_PMD_RCV_SIGDET		0x000a
#define  PMD_RCV_SIGDET_LANE3		0x0010
#define  PMD_RCV_SIGDET_LANE2		0x0008
#define  PMD_RCV_SIGDET_LANE1		0x0004
#define  PMD_RCV_SIGDET_LANE0		0x0002
#define  PMD_RCV_SIGDET_GLOBAL		0x0001

#define BCM8704_PCS_10G_R_STATUS	0x0020
#define  PCS_10G_R_STATUS_LINKSTAT	0x1000
#define  PCS_10G_R_STATUS_PRBS31_ABLE	0x0004
#define  PCS_10G_R_STATUS_HI_BER	0x0002
#define  PCS_10G_R_STATUS_BLK_LOCK	0x0001

#define BCM8704_USER_CONTROL		0xc800
#define  USER_CONTROL_OPTXENB_LVL	0x8000
#define  USER_CONTROL_OPTXRST_LVL	0x4000
#define  USER_CONTROL_OPBIASFLT_LVL	0x2000
#define  USER_CONTROL_OBTMPFLT_LVL	0x1000
#define  USER_CONTROL_OPPRFLT_LVL	0x0800
#define  USER_CONTROL_OPTXFLT_LVL	0x0400
#define  USER_CONTROL_OPRXLOS_LVL	0x0200
#define  USER_CONTROL_OPRXFLT_LVL	0x0100
#define  USER_CONTROL_OPTXON_LVL	0x0080
#define  USER_CONTROL_RES1		0x007f
#define  USER_CONTROL_RES1_SHIFT	0

#define BCM8704_USER_ANALOG_CLK		0xc801
#define BCM8704_USER_PMD_RX_CONTROL	0xc802

#define BCM8704_USER_PMD_TX_CONTROL	0xc803
#define  USER_PMD_TX_CTL_RES1		0xfe00
#define  USER_PMD_TX_CTL_XFP_CLKEN	0x0100
#define  USER_PMD_TX_CTL_TX_DAC_TXD	0x00c0
#define  USER_PMD_TX_CTL_TX_DAC_TXD_SH	6
#define  USER_PMD_TX_CTL_TX_DAC_TXCK	0x0030
#define  USER_PMD_TX_CTL_TX_DAC_TXCK_SH	4
#define  USER_PMD_TX_CTL_TSD_LPWREN	0x0008
#define  USER_PMD_TX_CTL_TSCK_LPWREN	0x0004
#define  USER_PMD_TX_CTL_CMU_LPWREN	0x0002
#define  USER_PMD_TX_CTL_SFIFORST	0x0001

#define BCM8704_USER_ANALOG_STATUS0	0xc804
#define BCM8704_USER_OPT_DIGITAL_CTRL	0xc808
#define BCM8704_USER_TX_ALARM_STATUS	0x9004

#define  USER_ODIG_CTRL_FMODE		0x8000
#define  USER_ODIG_CTRL_TX_PDOWN	0x4000
#define  USER_ODIG_CTRL_RX_PDOWN	0x2000
#define  USER_ODIG_CTRL_EFILT_EN	0x1000
#define  USER_ODIG_CTRL_OPT_RST		0x0800
#define  USER_ODIG_CTRL_PCS_TIB		0x0400
#define  USER_ODIG_CTRL_PCS_RI		0x0200
#define  USER_ODIG_CTRL_RESV1		0x0180
#define  USER_ODIG_CTRL_GPIOS		0x0060
#define  USER_ODIG_CTRL_GPIOS_SHIFT	5
#define  USER_ODIG_CTRL_RESV2		0x0010
#define  USER_ODIG_CTRL_LB_ERR_DIS	0x0008
#define  USER_ODIG_CTRL_RESV3		0x0006
#define  USER_ODIG_CTRL_TXONOFF_PD_DIS	0x0001

#define BCM8704_PHYXS_XGXS_LANE_STAT	0x0018
#define  PHYXS_XGXS_LANE_STAT_ALINGED	0x1000
#define  PHYXS_XGXS_LANE_STAT_PATTEST	0x0800
#define  PHYXS_XGXS_LANE_STAT_MAGIC	0x0400
#define  PHYXS_XGXS_LANE_STAT_LANE3	0x0008
#define  PHYXS_XGXS_LANE_STAT_LANE2	0x0004
#define  PHYXS_XGXS_LANE_STAT_LANE1	0x0002
#define  PHYXS_XGXS_LANE_STAT_LANE0	0x0001

#define BCM5464R_AUX_CTL		24
#define  BCM5464R_AUX_CTL_EXT_LB	0x8000
#define  BCM5464R_AUX_CTL_EXT_PLEN	0x4000
#define  BCM5464R_AUX_CTL_ER1000	0x3000
#define  BCM5464R_AUX_CTL_ER1000_SHIFT	12
#define  BCM5464R_AUX_CTL_RESV1		0x0800
#define  BCM5464R_AUX_CTL_WRITE_1	0x0400
#define  BCM5464R_AUX_CTL_RESV2		0x0300
#define  BCM5464R_AUX_CTL_PRESP_DIS	0x0080
#define  BCM5464R_AUX_CTL_RESV3		0x0040
#define  BCM5464R_AUX_CTL_ER100		0x0030
#define  BCM5464R_AUX_CTL_ER100_SHIFT	4
#define  BCM5464R_AUX_CTL_DIAG_MODE	0x0008
#define  BCM5464R_AUX_CTL_SR_SEL	0x0007
#define  BCM5464R_AUX_CTL_SR_SEL_SHIFT	0

#define  BCM5464R_CTRL1000_AS_MASTER		0x0800
#define  BCM5464R_CTRL1000_ENABLE_AS_MASTER	0x1000

#define RCR_ENTRY_MULTI			0x8000000000000000ULL
#define RCR_ENTRY_PKT_TYPE		0x6000000000000000ULL
#define RCR_ENTRY_PKT_TYPE_SHIFT	61
#define RCR_ENTRY_ZERO_COPY		0x1000000000000000ULL
#define RCR_ENTRY_NOPORT		0x0800000000000000ULL
#define RCR_ENTRY_PROMISC		0x0400000000000000ULL
#define RCR_ENTRY_ERROR			0x0380000000000000ULL
#define RCR_ENTRY_DCF_ERR		0x0040000000000000ULL
#define RCR_ENTRY_L2_LEN		0x003fff0000000000ULL
#define RCR_ENTRY_L2_LEN_SHIFT		40
#define RCR_ENTRY_PKTBUFSZ		0x000000c000000000ULL
#define RCR_ENTRY_PKTBUFSZ_SHIFT	38
#define RCR_ENTRY_PKT_BUF_ADDR		0x0000003fffffffffULL /* bits 43:6 */
#define RCR_ENTRY_PKT_BUF_ADDR_SHIFT	6

#define RCR_PKT_TYPE_OTHER		0x0
#define RCR_PKT_TYPE_TCP		0x1
#define RCR_PKT_TYPE_UDP		0x2
#define RCR_PKT_TYPE_SCTP		0x3

#define NIU_RXPULL_MAX			ETH_HLEN

struct rx_pkt_hdr0 {
#if defined(__LITTLE_ENDIAN_BITFIELD)
	u8	inputport:2,
		maccheck:1,
		class:5;
	u8	vlan:1,
		llcsnap:1,
		noport:1,
		badip:1,
		tcamhit:1,
		tres:2,
		tzfvld:1;
#elif defined(__BIG_ENDIAN_BITFIELD)
	u8	class:5,
		maccheck:1,
		inputport:2;
	u8	tzfvld:1,
		tres:2,
		tcamhit:1,
		badip:1,
		noport:1,
		llcsnap:1,
		vlan:1;
#endif
};

struct rx_pkt_hdr1 {
	u8	hwrsvd1;
	u8	tcammatch;
#if defined(__LITTLE_ENDIAN_BITFIELD)
	u8	hwrsvd2:2,
		hashit:1,
		exact:1,
		hzfvld:1,
		hashsidx:3;
#elif defined(__BIG_ENDIAN_BITFIELD)
	u8	hashsidx:3,
		hzfvld:1,
		exact:1,
		hashit:1,
		hwrsvd2:2;
#endif
	u8	zcrsvd;

	/* Bits 11:8 of zero copy flow ID.  */
#if defined(__LITTLE_ENDIAN_BITFIELD)
	u8	hwrsvd3:4, zflowid0:4;
#elif defined(__BIG_ENDIAN_BITFIELD)
	u8	zflowid0:4, hwrsvd3:4;
#endif

	/* Bits 7:0 of zero copy flow ID.  */
	u8	zflowid1;

	/* Bits 15:8 of hash value, H2.  */
	u8	hashval2_0;

	/* Bits 7:0 of hash value, H2.  */
	u8	hashval2_1;

	/* Bits 19:16 of hash value, H1.  */
#if defined(__LITTLE_ENDIAN_BITFIELD)
	u8	hwrsvd4:4, hashval1_0:4;
#elif defined(__BIG_ENDIAN_BITFIELD)
	u8	hashval1_0:4, hwrsvd4:4;
#endif

	/* Bits 15:8 of hash value, H1.  */
	u8	hashval1_1;

	/* Bits 7:0 of hash value, H1.  */
	u8	hashval1_2;

	u8	hwrsvd5;
	u8	hwrsvd6;

	u8	usrdata_0;	/* Bits 39:32 of user data.  */
	u8	usrdata_1;	/* Bits 31:24 of user data.  */
	u8	usrdata_2;	/* Bits 23:16 of user data.  */
	u8	usrdata_3;	/* Bits 15:8 of user data.  */
	u8	usrdata_4;	/* Bits 7:0 of user data.  */
};

struct tx_dma_mbox {
	u64	tx_dma_pre_st;
	u64	tx_cs;
	u64	tx_ring_kick;
	u64	tx_ring_hdl;
	u64	resv1;
	u32	tx_rng_err_logl;
	u32	tx_rng_err_logh;
	u64	resv2;
	u64	resv3;
};

struct tx_pkt_hdr {
	__le64	flags;
#define TXHDR_PAD		0x0000000000000007ULL
#define  TXHDR_PAD_SHIFT	0
#define TXHDR_LEN		0x000000003fff0000ULL
#define  TXHDR_LEN_SHIFT	16
#define TXHDR_L4STUFF		0x0000003f00000000ULL
#define  TXHDR_L4STUFF_SHIFT	32
#define TXHDR_L4START		0x00003f0000000000ULL
#define  TXHDR_L4START_SHIFT	40
#define TXHDR_L3START		0x000f000000000000ULL
#define  TXHDR_L3START_SHIFT	48
#define TXHDR_IHL		0x00f0000000000000ULL
#define  TXHDR_IHL_SHIFT	52
#define TXHDR_VLAN		0x0100000000000000ULL
#define TXHDR_LLC		0x0200000000000000ULL
#define TXHDR_IP_VER		0x2000000000000000ULL
#define TXHDR_CSUM_NONE		0x0000000000000000ULL
#define TXHDR_CSUM_TCP		0x4000000000000000ULL
#define TXHDR_CSUM_UDP		0x8000000000000000ULL
#define TXHDR_CSUM_SCTP		0xc000000000000000ULL
	__le64	resv;
};

#define TX_DESC_SOP		0x8000000000000000ULL
#define TX_DESC_MARK		0x4000000000000000ULL
#define TX_DESC_NUM_PTR		0x3c00000000000000ULL
#define TX_DESC_NUM_PTR_SHIFT	58
#define TX_DESC_TR_LEN		0x01fff00000000000ULL
#define TX_DESC_TR_LEN_SHIFT	44
#define TX_DESC_SAD		0x00000fffffffffffULL
#define TX_DESC_SAD_SHIFT	0

struct tx_buff_info {
	struct sk_buff *skb;
	u64 mapping;
};

struct txdma_mailbox {
	__le64	tx_dma_pre_st;
	__le64	tx_cs;
	__le64	tx_ring_kick;
	__le64	tx_ring_hdl;
	__le64	resv1;
	__le32	tx_rng_err_logl;
	__le32	tx_rng_err_logh;
	__le64	resv2[2];
} __attribute__((aligned(64)));

#define MAX_TX_RING_SIZE	256
#define MAX_TX_DESC_LEN		4076

struct tx_ring_info {
	struct tx_buff_info	tx_buffs[MAX_TX_RING_SIZE];
	struct niu		*np;
	u64			tx_cs;
	int			pending;
	int			prod;
	int			cons;
	int			wrap_bit;
	u16			last_pkt_cnt;
	u16			tx_channel;
	u16			mark_counter;
	u16			mark_freq;
	u16			mark_pending;
	u16			__pad;
	struct txdma_mailbox	*mbox;
	__le64			*descr;

	u64			tx_packets;
	u64			tx_bytes;
	u64			tx_errors;

	u64			mbox_dma;
	u64			descr_dma;
	int			max_burst;
};

#define NEXT_TX(tp, index) \
	(((index) + 1) < (tp)->pending ? ((index) + 1) : 0)

static inline u32 niu_tx_avail(struct tx_ring_info *tp)
{
	return (tp->pending -
		((tp->prod - tp->cons) & (MAX_TX_RING_SIZE - 1)));
}

struct rxdma_mailbox {
	__le64	rx_dma_ctl_stat;
	__le64	rbr_stat;
	__le32	rbr_hdl;
	__le32	rbr_hdh;
	__le64	resv1;
	__le32	rcrstat_c;
	__le32	rcrstat_b;
	__le64	rcrstat_a;
	__le64	resv2[2];
} __attribute__((aligned(64)));

#define MAX_RBR_RING_SIZE	128
#define MAX_RCR_RING_SIZE	(MAX_RBR_RING_SIZE * 2)

#define RBR_REFILL_MIN		16

#define RX_SKB_ALLOC_SIZE	128 + NET_IP_ALIGN

struct rx_ring_info {
	struct niu		*np;
	int			rx_channel;
	u16			rbr_block_size;
	u16			rbr_blocks_per_page;
	u16			rbr_sizes[4];
	unsigned int		rcr_index;
	unsigned int		rcr_table_size;
	unsigned int		rbr_index;
	unsigned int		rbr_pending;
	unsigned int		rbr_refill_pending;
	unsigned int		rbr_kick_thresh;
	unsigned int		rbr_table_size;
	struct page		**rxhash;
	struct rxdma_mailbox	*mbox;
	__le64			*rcr;
	__le32			*rbr;
#define RBR_DESCR_ADDR_SHIFT	12

	u64			rx_packets;
	u64			rx_bytes;
	u64			rx_dropped;
	u64			rx_errors;

	u64			mbox_dma;
	u64			rcr_dma;
	u64			rbr_dma;

	/* WRED */
	int			nonsyn_window;
	int			nonsyn_threshold;
	int			syn_window;
	int			syn_threshold;

	/* interrupt mitigation */
	int			rcr_pkt_threshold;
	int			rcr_timeout;
};

#define NEXT_RCR(rp, index) \
	(((index) + 1) < (rp)->rcr_table_size ? ((index) + 1) : 0)
#define NEXT_RBR(rp, index) \
	(((index) + 1) < (rp)->rbr_table_size ? ((index) + 1) : 0)

#define NIU_MAX_PORTS		4
#define NIU_NUM_RXCHAN		16
#define NIU_NUM_TXCHAN		24
#define MAC_NUM_HASH		16

#define NIU_MAX_MTU		9216

/* VPD strings */
#define	NIU_QGC_LP_BM_STR	"501-7606"
#define	NIU_2XGF_LP_BM_STR	"501-7283"
#define	NIU_QGC_PEM_BM_STR	"501-7765"
#define	NIU_2XGF_PEM_BM_STR	"501-7626"
#define	NIU_ALONSO_BM_STR	"373-0202"
#define	NIU_FOXXY_BM_STR	"501-7961"
#define	NIU_2XGF_MRVL_BM_STR	"SK-6E82"
#define	NIU_QGC_LP_MDL_STR	"SUNW,pcie-qgc"
#define	NIU_2XGF_LP_MDL_STR	"SUNW,pcie-2xgf"
#define	NIU_QGC_PEM_MDL_STR	"SUNW,pcie-qgc-pem"
#define	NIU_2XGF_PEM_MDL_STR	"SUNW,pcie-2xgf-pem"
#define	NIU_ALONSO_MDL_STR	"SUNW,CP3220"
#define	NIU_KIMI_MDL_STR	"SUNW,CP3260"
#define	NIU_MARAMBA_MDL_STR	"SUNW,pcie-neptune"
#define	NIU_FOXXY_MDL_STR	"SUNW,pcie-rfem"
#define	NIU_2XGF_MRVL_MDL_STR	"SysKonnect,pcie-2xgf"

#define NIU_VPD_MIN_MAJOR	3
#define NIU_VPD_MIN_MINOR	4

#define NIU_VPD_MODEL_MAX	32
#define NIU_VPD_BD_MODEL_MAX	16
#define NIU_VPD_VERSION_MAX	64
#define NIU_VPD_PHY_TYPE_MAX	8

struct niu_vpd {
	char			model[NIU_VPD_MODEL_MAX];
	char			board_model[NIU_VPD_BD_MODEL_MAX];
	char			version[NIU_VPD_VERSION_MAX];
	char			phy_type[NIU_VPD_PHY_TYPE_MAX];
	u8			mac_num;
	u8			__pad;
	u8			local_mac[6];
	int			fcode_major;
	int			fcode_minor;
};

struct niu_altmac_rdc {
	u8			alt_mac_num;
	u8			rdc_num;
	u8			mac_pref;
};

struct niu_vlan_rdc {
	u8			rdc_num;
	u8			vlan_pref;
};

struct niu_classifier {
	struct niu_altmac_rdc	alt_mac_mappings[16];
	struct niu_vlan_rdc	vlan_mappings[ENET_VLAN_TBL_NUM_ENTRIES];

	u16			tcam_top;
	u16			tcam_sz;
	u16			tcam_valid_entries;
	u16			num_alt_mac_mappings;

	u32			h1_init;
	u16			h2_init;
};

#define NIU_NUM_RDC_TABLES	8
#define NIU_RDC_TABLE_SLOTS	16

struct rdc_table {
	u8			rxdma_channel[NIU_RDC_TABLE_SLOTS];
};

struct niu_rdc_tables {
	struct rdc_table	tables[NIU_NUM_RDC_TABLES];
	int			first_table_num;
	int			num_tables;
};

#define PHY_TYPE_PMA_PMD	0
#define PHY_TYPE_PCS		1
#define PHY_TYPE_MII		2
#define PHY_TYPE_MAX		3

struct phy_probe_info {
	u32	phy_id[PHY_TYPE_MAX][NIU_MAX_PORTS];
	u8	phy_port[PHY_TYPE_MAX][NIU_MAX_PORTS];
	u8	cur[PHY_TYPE_MAX];

	struct device_attribute	phy_port_attrs[PHY_TYPE_MAX * NIU_MAX_PORTS];
	struct device_attribute	phy_type_attrs[PHY_TYPE_MAX * NIU_MAX_PORTS];
	struct device_attribute	phy_id_attrs[PHY_TYPE_MAX * NIU_MAX_PORTS];
};

struct niu_tcam_entry {
	u8			valid;
	u64			key[4];
	u64			key_mask[4];
	u64			assoc_data;
};

struct device_node;
union niu_parent_id {
	struct {
		int		domain;
		int		bus;
		int		device;
	} pci;
	struct device_node	*of;
};

struct niu;
struct niu_parent {
	struct platform_device	*plat_dev;
	int			index;

	union niu_parent_id	id;

	struct niu		*ports[NIU_MAX_PORTS];

	atomic_t		refcnt;
	struct list_head	list;

	spinlock_t		lock;

	u32			flags;
#define PARENT_FLGS_CLS_HWINIT	0x00000001

	u32			port_phy;
#define PORT_PHY_UNKNOWN	0x00000000
#define PORT_PHY_INVALID	0xffffffff
#define PORT_TYPE_10G		0x01
#define PORT_TYPE_1G		0x02
#define PORT_TYPE_MASK		0x03

	u8			rxchan_per_port[NIU_MAX_PORTS];
	u8			txchan_per_port[NIU_MAX_PORTS];

	struct niu_rdc_tables	rdc_group_cfg[NIU_MAX_PORTS];
	u8			rdc_default[NIU_MAX_PORTS];

	u8			ldg_map[LDN_MAX + 1];

	u8			plat_type;
#define PLAT_TYPE_INVALID	0x00
#define PLAT_TYPE_ATLAS		0x01
#define PLAT_TYPE_NIU		0x02
#define PLAT_TYPE_VF_P0		0x03
#define PLAT_TYPE_VF_P1		0x04
#define PLAT_TYPE_ATCA_CP3220	0x08

	u8			num_ports;

	u16			tcam_num_entries;
#define NIU_PCI_TCAM_ENTRIES	256
#define NIU_NONPCI_TCAM_ENTRIES	128
#define NIU_TCAM_ENTRIES_MAX	256

	int			rxdma_clock_divider;

	struct phy_probe_info	phy_probe_info;

	struct niu_tcam_entry	tcam[NIU_TCAM_ENTRIES_MAX];

#define	NIU_L2_PROG_CLS		2
#define	NIU_L3_PROG_CLS		4
	u64			l2_cls[NIU_L2_PROG_CLS];
	u64			l3_cls[NIU_L3_PROG_CLS];
	u64			tcam_key[12];
	u64			flow_key[12];
	u16			l3_cls_refcnt[NIU_L3_PROG_CLS];
	u8			l3_cls_pid[NIU_L3_PROG_CLS];
};

struct niu_ops {
	void *(*alloc_coherent)(struct device *dev, size_t size,
				u64 *handle, gfp_t flag);
	void (*free_coherent)(struct device *dev, size_t size,
			      void *cpu_addr, u64 handle);
	u64 (*map_page)(struct device *dev, struct page *page,
			unsigned long offset, size_t size,
			enum dma_data_direction direction);
	void (*unmap_page)(struct device *dev, u64 dma_address,
			   size_t size, enum dma_data_direction direction);
	u64 (*map_single)(struct device *dev, void *cpu_addr,
			  size_t size,
			  enum dma_data_direction direction);
	void (*unmap_single)(struct device *dev, u64 dma_address,
			     size_t size, enum dma_data_direction direction);
};

struct niu_link_config {
	u32				supported;

	/* Describes what we're trying to get. */
	u32				advertising;
	u16				speed;
	u8				duplex;
	u8				autoneg;

	/* Describes what we actually have. */
	u32				active_advertising;
	u16				active_speed;
	u8				active_duplex;
	u8				active_autoneg;
#define SPEED_INVALID		0xffff
#define DUPLEX_INVALID		0xff
#define AUTONEG_INVALID		0xff

	u8				loopback_mode;
#define LOOPBACK_DISABLED	0x00
#define LOOPBACK_PHY		0x01
#define LOOPBACK_MAC		0x02
};

struct niu_ldg {
	struct napi_struct	napi;
	struct niu	*np;
	u8		ldg_num;
	u8		timer;
	u64		v0, v1, v2;
	unsigned int	irq;
};

struct niu_xmac_stats {
	u64	tx_frames;
	u64	tx_bytes;
	u64	tx_fifo_errors;
	u64	tx_overflow_errors;
	u64	tx_max_pkt_size_errors;
	u64	tx_underflow_errors;

	u64	rx_local_faults;
	u64	rx_remote_faults;
	u64	rx_link_faults;
	u64	rx_align_errors;
	u64	rx_frags;
	u64	rx_mcasts;
	u64	rx_bcasts;
	u64	rx_hist_cnt1;
	u64	rx_hist_cnt2;
	u64	rx_hist_cnt3;
	u64	rx_hist_cnt4;
	u64	rx_hist_cnt5;
	u64	rx_hist_cnt6;
	u64	rx_hist_cnt7;
	u64	rx_octets;
	u64	rx_code_violations;
	u64	rx_len_errors;
	u64	rx_crc_errors;
	u64	rx_underflows;
	u64	rx_overflows;

	u64	pause_off_state;
	u64	pause_on_state;
	u64	pause_received;
};

struct niu_bmac_stats {
	u64	tx_underflow_errors;
	u64	tx_max_pkt_size_errors;
	u64	tx_bytes;
	u64	tx_frames;

	u64	rx_overflows;
	u64	rx_frames;
	u64	rx_align_errors;
	u64	rx_crc_errors;
	u64	rx_len_errors;

	u64	pause_off_state;
	u64	pause_on_state;
	u64	pause_received;
};

union niu_mac_stats {
	struct niu_xmac_stats	xmac;
	struct niu_bmac_stats	bmac;
};

struct niu_phy_ops {
	int (*serdes_init)(struct niu *np);
	int (*xcvr_init)(struct niu *np);
	int (*link_status)(struct niu *np, int *);
};

struct platform_device;
struct niu {
	void __iomem			*regs;
	struct net_device		*dev;
	struct pci_dev			*pdev;
	struct device			*device;
	struct niu_parent		*parent;

	u32				flags;
#define NIU_FLAGS_HOTPLUG_PHY_PRESENT	0x02000000 /* Removeable PHY detected*/
#define NIU_FLAGS_HOTPLUG_PHY		0x01000000 /* Removeable PHY */
#define NIU_FLAGS_VPD_VALID		0x00800000 /* VPD has valid version */
#define NIU_FLAGS_MSIX			0x00400000 /* MSI-X in use */
#define NIU_FLAGS_MCAST			0x00200000 /* multicast filter enabled */
#define NIU_FLAGS_PROMISC		0x00100000 /* PROMISC enabled */
#define NIU_FLAGS_XCVR_SERDES		0x00080000 /* 0=PHY 1=SERDES */
#define NIU_FLAGS_10G			0x00040000 /* 0=1G 1=10G */
#define NIU_FLAGS_FIBER			0x00020000 /* 0=COPPER 1=FIBER */
#define NIU_FLAGS_XMAC			0x00010000 /* 0=BMAC 1=XMAC */

	u32				msg_enable;
	char                            irq_name[NIU_NUM_RXCHAN+NIU_NUM_TXCHAN+3][IFNAMSIZ + 6];

	/* Protects hw programming, and ring state.  */
	spinlock_t			lock;

	const struct niu_ops		*ops;
	union niu_mac_stats		mac_stats;

	struct rx_ring_info		*rx_rings;
	struct tx_ring_info		*tx_rings;
	int				num_rx_rings;
	int				num_tx_rings;

	struct niu_ldg			ldg[NIU_NUM_LDG];
	int				num_ldg;

	void __iomem			*mac_regs;
	unsigned long			ipp_off;
	unsigned long			pcs_off;
	unsigned long			xpcs_off;

	struct timer_list		timer;
	u64				orig_led_state;
	const struct niu_phy_ops	*phy_ops;
	int				phy_addr;

	struct niu_link_config		link_config;

	struct work_struct		reset_task;

	u8				port;
	u8				mac_xcvr;
#define MAC_XCVR_MII			1
#define MAC_XCVR_PCS			2
#define MAC_XCVR_XPCS			3

	struct niu_classifier		clas;

	struct niu_vpd			vpd;
	u32				eeprom_len;

	struct platform_device		*op;
	void __iomem			*vir_regs_1;
	void __iomem			*vir_regs_2;
};

#endif /* _NIU_H */
