/* SPDX-License-Identifier: GPL-2.0-or-later */
/* Copyright (C) 2018 ROHM Semiconductors */

#ifndef __LINUX_MFD_BD70528_H__
#define __LINUX_MFD_BD70528_H__

#include <linux/bits.h>
#include <linux/device.h>
#include <linux/mfd/rohm-generic.h>
#include <linux/regmap.h>

enum {
	BD70528_BUCK1,
	BD70528_BUCK2,
	BD70528_BUCK3,
	BD70528_LDO1,
	BD70528_LDO2,
	BD70528_LDO3,
	BD70528_LED1,
	BD70528_LED2,
};

struct bd70528_data {
	struct rohm_regmap_dev chip;
	struct mutex rtc_timer_lock;
};

#define BD70528_BUCK_VOLTS 0x10
#define BD70528_LDO_VOLTS 0x20

#define BD70528_REG_BUCK1_EN	0x0F
#define BD70528_REG_BUCK1_VOLT	0x15
#define BD70528_REG_BUCK2_EN	0x10
#define BD70528_REG_BUCK2_VOLT	0x16
#define BD70528_REG_BUCK3_EN	0x11
#define BD70528_REG_BUCK3_VOLT	0x17
#define BD70528_REG_LDO1_EN	0x1b
#define BD70528_REG_LDO1_VOLT	0x1e
#define BD70528_REG_LDO2_EN	0x1c
#define BD70528_REG_LDO2_VOLT	0x1f
#define BD70528_REG_LDO3_EN	0x1d
#define BD70528_REG_LDO3_VOLT	0x20
#define BD70528_REG_LED_CTRL	0x2b
#define BD70528_REG_LED_VOLT	0x29
#define BD70528_REG_LED_EN	0x2a

/* main irq registers */
#define BD70528_REG_INT_MAIN	0x7E
#define BD70528_REG_INT_MAIN_MASK 0x74

/* 'sub irq' registers */
#define BD70528_REG_INT_SHDN	0x7F
#define BD70528_REG_INT_PWR_FLT	0x80
#define BD70528_REG_INT_VR_FLT	0x81
#define BD70528_REG_INT_MISC	0x82
#define BD70528_REG_INT_BAT1	0x83
#define BD70528_REG_INT_BAT2	0x84
#define BD70528_REG_INT_RTC	0x85
#define BD70528_REG_INT_GPIO	0x86
#define BD70528_REG_INT_OP_FAIL	0x87

#define BD70528_REG_INT_SHDN_MASK	0x75
#define BD70528_REG_INT_PWR_FLT_MASK	0x76
#define BD70528_REG_INT_VR_FLT_MASK	0x77
#define BD70528_REG_INT_MISC_MASK	0x78
#define BD70528_REG_INT_BAT1_MASK	0x79
#define BD70528_REG_INT_BAT2_MASK	0x7a
#define BD70528_REG_INT_RTC_MASK	0x7b
#define BD70528_REG_INT_GPIO_MASK	0x7c
#define BD70528_REG_INT_OP_FAIL_MASK	0x7d

/* Reset related 'magic' registers */
#define BD70528_REG_SHIPMODE	0x03
#define BD70528_REG_HWRESET	0x04
#define BD70528_REG_WARMRESET	0x05
#define BD70528_REG_STANDBY	0x06

/* GPIO registers */
#define BD70528_REG_GPIO_STATE	0x8F

#define BD70528_REG_GPIO1_IN	0x4d
#define BD70528_REG_GPIO2_IN	0x4f
#define BD70528_REG_GPIO3_IN	0x51
#define BD70528_REG_GPIO4_IN	0x53
#define BD70528_REG_GPIO1_OUT	0x4e
#define BD70528_REG_GPIO2_OUT	0x50
#define BD70528_REG_GPIO3_OUT	0x52
#define BD70528_REG_GPIO4_OUT	0x54

/* clk control */

#define BD70528_REG_CLK_OUT	0x2c

/* RTC */

#define BD70528_REG_RTC_COUNT_H		0x2d
#define BD70528_REG_RTC_COUNT_L		0x2e
#define BD70528_REG_RTC_SEC		0x2f
#define BD70528_REG_RTC_MINUTE		0x30
#define BD70528_REG_RTC_HOUR		0x31
#define BD70528_REG_RTC_WEEK		0x32
#define BD70528_REG_RTC_DAY		0x33
#define BD70528_REG_RTC_MONTH		0x34
#define BD70528_REG_RTC_YEAR		0x35

#define BD70528_REG_RTC_ALM_SEC		0x36
#define BD70528_REG_RTC_ALM_START	BD70528_REG_RTC_ALM_SEC
#define BD70528_REG_RTC_ALM_MINUTE	0x37
#define BD70528_REG_RTC_ALM_HOUR	0x38
#define BD70528_REG_RTC_ALM_WEEK	0x39
#define BD70528_REG_RTC_ALM_DAY		0x3a
#define BD70528_REG_RTC_ALM_MONTH	0x3b
#define BD70528_REG_RTC_ALM_YEAR	0x3c
#define BD70528_REG_RTC_ALM_MASK	0x3d
#define BD70528_REG_RTC_ALM_REPEAT	0x3e
#define BD70528_REG_RTC_START		BD70528_REG_RTC_SEC

#define BD70528_REG_RTC_WAKE_SEC	0x43
#define BD70528_REG_RTC_WAKE_START	BD70528_REG_RTC_WAKE_SEC
#define BD70528_REG_RTC_WAKE_MIN	0x44
#define BD70528_REG_RTC_WAKE_HOUR	0x45
#define BD70528_REG_RTC_WAKE_CTRL	0x46

#define BD70528_REG_ELAPSED_TIMER_EN	0x42
#define BD70528_REG_WAKE_EN		0x46

/* WDT registers */
#define BD70528_REG_WDT_CTRL		0x4A
#define BD70528_REG_WDT_HOUR		0x49
#define BD70528_REG_WDT_MINUTE		0x48
#define BD70528_REG_WDT_SEC		0x47

/* Charger / Battery */
#define BD70528_REG_CHG_CURR_STAT	0x59
#define BD70528_REG_CHG_BAT_STAT	0x57
#define BD70528_REG_CHG_BAT_TEMP	0x58
#define BD70528_REG_CHG_IN_STAT		0x56
#define BD70528_REG_CHG_DCIN_ILIM	0x5d
#define BD70528_REG_CHG_CHG_CURR_WARM	0x61
#define BD70528_REG_CHG_CHG_CURR_COLD	0x62

/* Masks for main IRQ register bits */
enum {
	BD70528_INT_SHDN,
#define BD70528_INT_SHDN_MASK BIT(BD70528_INT_SHDN)
	BD70528_INT_PWR_FLT,
#define BD70528_INT_PWR_FLT_MASK BIT(BD70528_INT_PWR_FLT)
	BD70528_INT_VR_FLT,
#define BD70528_INT_VR_FLT_MASK BIT(BD70528_INT_VR_FLT)
	BD70528_INT_MISC,
#define BD70528_INT_MISC_MASK BIT(BD70528_INT_MISC)
	BD70528_INT_BAT1,
#define BD70528_INT_BAT1_MASK BIT(BD70528_INT_BAT1)
	BD70528_INT_RTC,
#define BD70528_INT_RTC_MASK BIT(BD70528_INT_RTC)
	BD70528_INT_GPIO,
#define BD70528_INT_GPIO_MASK BIT(BD70528_INT_GPIO)
	BD70528_INT_OP_FAIL,
#define BD70528_INT_OP_FAIL_MASK BIT(BD70528_INT_OP_FAIL)
};

/* IRQs */
enum {
	/* Shutdown register IRQs */
	BD70528_INT_LONGPUSH,
	BD70528_INT_WDT,
	BD70528_INT_HWRESET,
	BD70528_INT_RSTB_FAULT,
	BD70528_INT_VBAT_UVLO,
	BD70528_INT_TSD,
	BD70528_INT_RSTIN,
	/* Power failure register IRQs */
	BD70528_INT_BUCK1_FAULT,
	BD70528_INT_BUCK2_FAULT,
	BD70528_INT_BUCK3_FAULT,
	BD70528_INT_LDO1_FAULT,
	BD70528_INT_LDO2_FAULT,
	BD70528_INT_LDO3_FAULT,
	BD70528_INT_LED1_FAULT,
	BD70528_INT_LED2_FAULT,
	/* VR FAULT register IRQs */
	BD70528_INT_BUCK1_OCP,
	BD70528_INT_BUCK2_OCP,
	BD70528_INT_BUCK3_OCP,
	BD70528_INT_LED1_OCP,
	BD70528_INT_LED2_OCP,
	BD70528_INT_BUCK1_FULLON,
	BD70528_INT_BUCK2_FULLON,
	/* PMU register interrupts */
	BD70528_INT_SHORTPUSH,
	BD70528_INT_AUTO_WAKEUP,
	BD70528_INT_STATE_CHANGE,
	/* Charger 1 register IRQs */
	BD70528_INT_BAT_OV_RES,
	BD70528_INT_BAT_OV_DET,
	BD70528_INT_DBAT_DET,
	BD70528_INT_BATTSD_COLD_RES,
	BD70528_INT_BATTSD_COLD_DET,
	BD70528_INT_BATTSD_HOT_RES,
	BD70528_INT_BATTSD_HOT_DET,
	BD70528_INT_CHG_TSD,
	/* Charger 2 register IRQs */
	BD70528_INT_BAT_RMV,
	BD70528_INT_BAT_DET,
	BD70528_INT_DCIN2_OV_RES,
	BD70528_INT_DCIN2_OV_DET,
	BD70528_INT_DCIN2_RMV,
	BD70528_INT_DCIN2_DET,
	BD70528_INT_DCIN1_RMV,
	BD70528_INT_DCIN1_DET,
	/* RTC register IRQs */
	BD70528_INT_RTC_ALARM,
	BD70528_INT_ELPS_TIM,
	/* GPIO register IRQs */
	BD70528_INT_GPIO0,
	BD70528_INT_GPIO1,
	BD70528_INT_GPIO2,
	BD70528_INT_GPIO3,
	/* Invalid operation register IRQs */
	BD70528_INT_BUCK1_DVS_OPFAIL,
	BD70528_INT_BUCK2_DVS_OPFAIL,
	BD70528_INT_BUCK3_DVS_OPFAIL,
	BD70528_INT_LED1_VOLT_OPFAIL,
	BD70528_INT_LED2_VOLT_OPFAIL,
};

/* Masks */
#define BD70528_INT_LONGPUSH_MASK 0x1
#define BD70528_INT_WDT_MASK 0x2
#define BD70528_INT_HWRESET_MASK 0x4
#define BD70528_INT_RSTB_FAULT_MASK 0x8
#define BD70528_INT_VBAT_UVLO_MASK 0x10
#define BD70528_INT_TSD_MASK 0x20
#define BD70528_INT_RSTIN_MASK 0x40

#define BD70528_INT_BUCK1_FAULT_MASK 0x1
#define BD70528_INT_BUCK2_FAULT_MASK 0x2
#define BD70528_INT_BUCK3_FAULT_MASK 0x4
#define BD70528_INT_LDO1_FAULT_MASK 0x8
#define BD70528_INT_LDO2_FAULT_MASK 0x10
#define BD70528_INT_LDO3_FAULT_MASK 0x20
#define BD70528_INT_LED1_FAULT_MASK 0x40
#define BD70528_INT_LED2_FAULT_MASK 0x80

#define BD70528_INT_BUCK1_OCP_MASK 0x1
#define BD70528_INT_BUCK2_OCP_MASK 0x2
#define BD70528_INT_BUCK3_OCP_MASK 0x4
#define BD70528_INT_LED1_OCP_MASK 0x8
#define BD70528_INT_LED2_OCP_MASK 0x10
#define BD70528_INT_BUCK1_FULLON_MASK 0x20
#define BD70528_INT_BUCK2_FULLON_MASK 0x40

#define BD70528_INT_SHORTPUSH_MASK 0x1
#define BD70528_INT_AUTO_WAKEUP_MASK 0x2
#define BD70528_INT_STATE_CHANGE_MASK 0x10

#define BD70528_INT_BAT_OV_RES_MASK 0x1
#define BD70528_INT_BAT_OV_DET_MASK 0x2
#define BD70528_INT_DBAT_DET_MASK 0x4
#define BD70528_INT_BATTSD_COLD_RES_MASK 0x8
#define BD70528_INT_BATTSD_COLD_DET_MASK 0x10
#define BD70528_INT_BATTSD_HOT_RES_MASK 0x20
#define BD70528_INT_BATTSD_HOT_DET_MASK 0x40
#define BD70528_INT_CHG_TSD_MASK 0x80

#define BD70528_INT_BAT_RMV_MASK 0x1
#define BD70528_INT_BAT_DET_MASK 0x2
#define BD70528_INT_DCIN2_OV_RES_MASK 0x4
#define BD70528_INT_DCIN2_OV_DET_MASK 0x8
#define BD70528_INT_DCIN2_RMV_MASK 0x10
#define BD70528_INT_DCIN2_DET_MASK 0x20
#define BD70528_INT_DCIN1_RMV_MASK 0x40
#define BD70528_INT_DCIN1_DET_MASK 0x80

#define BD70528_INT_RTC_ALARM_MASK 0x1
#define BD70528_INT_ELPS_TIM_MASK 0x2

#define BD70528_INT_GPIO0_MASK 0x1
#define BD70528_INT_GPIO1_MASK 0x2
#define BD70528_INT_GPIO2_MASK 0x4
#define BD70528_INT_GPIO3_MASK 0x8

#define BD70528_INT_BUCK1_DVS_OPFAIL_MASK 0x1
#define BD70528_INT_BUCK2_DVS_OPFAIL_MASK 0x2
#define BD70528_INT_BUCK3_DVS_OPFAIL_MASK 0x4
#define BD70528_INT_LED1_VOLT_OPFAIL_MASK 0x10
#define BD70528_INT_LED2_VOLT_OPFAIL_MASK 0x20

#define BD70528_DEBOUNCE_MASK 0x3

#define BD70528_DEBOUNCE_DISABLE 0
#define BD70528_DEBOUNCE_15MS 1
#define BD70528_DEBOUNCE_30MS 2
#define BD70528_DEBOUNCE_50MS 3

#define BD70528_GPIO_DRIVE_MASK 0x2
#define BD70528_GPIO_PUSH_PULL 0x0
#define BD70528_GPIO_OPEN_DRAIN 0x2

#define BD70528_GPIO_OUT_EN_MASK 0x80
#define BD70528_GPIO_OUT_ENABLE 0x80
#define BD70528_GPIO_OUT_DISABLE 0x0

#define BD70528_GPIO_OUT_HI 0x1
#define BD70528_GPIO_OUT_LO 0x0
#define BD70528_GPIO_OUT_MASK 0x1

#define BD70528_GPIO_IN_STATE_BASE 1

#define BD70528_CLK_OUT_EN_MASK 0x1

/* RTC masks to mask out reserved bits */

#define BD70528_MASK_RTC_SEC		0x7f
#define BD70528_MASK_RTC_MINUTE		0x7f
#define BD70528_MASK_RTC_HOUR_24H	0x80
#define BD70528_MASK_RTC_HOUR_PM	0x20
#define BD70528_MASK_RTC_HOUR		0x3f
#define BD70528_MASK_RTC_DAY		0x3f
#define BD70528_MASK_RTC_WEEK		0x07
#define BD70528_MASK_RTC_MONTH		0x1f
#define BD70528_MASK_RTC_YEAR		0xff
#define BD70528_MASK_RTC_COUNT_L	0x7f

#define BD70528_MASK_ELAPSED_TIMER_EN	0x1
/* Mask second, min and hour fields
 * HW would support ALM irq for over 24h
 * (by setting day, month and year too)
 * but as we wish to keep this same as for
 * wake-up we limit ALM to 24H and only
 * unmask sec, min and hour
 */
#define BD70528_MASK_ALM_EN		0x7
#define BD70528_MASK_WAKE_EN		0x1

/* WDT masks */
#define BD70528_MASK_WDT_EN		0x1
#define BD70528_MASK_WDT_HOUR		0x1
#define BD70528_MASK_WDT_MINUTE		0x7f
#define BD70528_MASK_WDT_SEC		0x7f

#define BD70528_WDT_STATE_BIT		0x1
#define BD70528_ELAPSED_STATE_BIT	0x2
#define BD70528_WAKE_STATE_BIT		0x4

/* Charger masks */
#define BD70528_MASK_CHG_STAT		0x7f
#define BD70528_MASK_CHG_BAT_TIMER	0x20
#define BD70528_MASK_CHG_BAT_OVERVOLT	0x10
#define BD70528_MASK_CHG_BAT_DETECT	0x1
#define BD70528_MASK_CHG_DCIN1_UVLO	0x1
#define BD70528_MASK_CHG_DCIN_ILIM	0x3f
#define BD70528_MASK_CHG_CHG_CURR	0x1f
#define BD70528_MASK_CHG_TRICKLE_CURR	0x10

/*
 * Note, external battery register is the lonely rider at
 * address 0xc5. See how to stuff that in the regmap
 */
#define BD70528_MAX_REGISTER 0x94

/* Buck control masks */
#define BD70528_MASK_RUN_EN	0x4
#define BD70528_MASK_STBY_EN	0x2
#define BD70528_MASK_IDLE_EN	0x1
#define BD70528_MASK_LED1_EN	0x1
#define BD70528_MASK_LED2_EN	0x10

#define BD70528_MASK_BUCK_VOLT	0xf
#define BD70528_MASK_LDO_VOLT	0x1f
#define BD70528_MASK_LED1_VOLT	0x1
#define BD70528_MASK_LED2_VOLT	0x10

/* Misc irq masks */
#define BD70528_INT_MASK_SHORT_PUSH	1
#define BD70528_INT_MASK_AUTO_WAKE	2
#define BD70528_INT_MASK_POWER_STATE	4

#define BD70528_MASK_BUCK_RAMP 0x10
#define BD70528_SIFT_BUCK_RAMP 4

#if IS_ENABLED(CONFIG_BD70528_WATCHDOG)

int bd70528_wdt_set(struct rohm_regmap_dev *data, int enable, int *old_state);
void bd70528_wdt_lock(struct rohm_regmap_dev *data);
void bd70528_wdt_unlock(struct rohm_regmap_dev *data);

#else /* CONFIG_BD70528_WATCHDOG */

static inline int bd70528_wdt_set(struct rohm_regmap_dev *data, int enable,
				  int *old_state)
{
	return 0;
}

static inline void bd70528_wdt_lock(struct rohm_regmap_dev *data)
{
}

static inline void bd70528_wdt_unlock(struct rohm_regmap_dev *data)
{
}

#endif /* CONFIG_BD70528_WATCHDOG */

#endif /* __LINUX_MFD_BD70528_H__ */
