// SPDX-License-Identifier: GPL-2.0
/*
 * linux/fs/hfsplus/tables.c
 *
 * Various data tables
 */

#include "hfsplus_fs.h"

/*
 *  Unicode case folding table taken from Apple Technote #1150
 *  (HFS Plus Volume Format)
 */

u16 hfsplus_case_fold_table[] = {
/*
 *  The lower case table consists of a 256-entry high-byte table followed by
 *  some number of 256-entry subtables. The high-byte table contains either an
 *  offset to the subtable for characters with that high byte or zero, which
 *  means that there are no case mappings or ignored characters in that block.
 *  Ignored characters are mapped to zero.
 */

    // High-byte indices ( == 0 iff no case mapping and no ignorables )


    /* 0 */ 0x0100, 0x0200, 0x0000, 0x0300, 0x0400, 0x0500, 0x0000, 0x0000,
            0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /* 1 */ 0x0600, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
            0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /* 2 */ 0x0700, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
            0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /* 3 */ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
            0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /* 4 */ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
            0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /* 5 */ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
            0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /* 6 */ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
            0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /* 7 */ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
            0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /* 8 */ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
            0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /* 9 */ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
            0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /* A */ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
            0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /* B */ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
            0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /* C */ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
            0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /* D */ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
            0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /* E */ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
            0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /* F */ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
            0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0900, 0x0A00,

    // Table 1 (for high byte 0x00)

    /* 0 */ 0xFFFF, 0x0001, 0x0002, 0x0003, 0x0004, 0x0005, 0x0006, 0x0007,
            0x0008, 0x0009, 0x000A, 0x000B, 0x000C, 0x000D, 0x000E, 0x000F,
    /* 1 */ 0x0010, 0x0011, 0x0012, 0x0013, 0x0014, 0x0015, 0x0016, 0x0017,
            0x0018, 0x0019, 0x001A, 0x001B, 0x001C, 0x001D, 0x001E, 0x001F,
    /* 2 */ 0x0020, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027,
            0x0028, 0x0029, 0x002A, 0x002B, 0x002C, 0x002D, 0x002E, 0x002F,
    /* 3 */ 0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
            0x0038, 0x0039, 0x003A, 0x003B, 0x003C, 0x003D, 0x003E, 0x003F,
    /* 4 */ 0x0040, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
            0x0068, 0x0069, 0x006A, 0x006B, 0x006C, 0x006D, 0x006E, 0x006F,
    /* 5 */ 0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
            0x0078, 0x0079, 0x007A, 0x005B, 0x005C, 0x005D, 0x005E, 0x005F,
    /* 6 */ 0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
            0x0068, 0x0069, 0x006A, 0x006B, 0x006C, 0x006D, 0x006E, 0x006F,
    /* 7 */ 0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
            0x0078, 0x0079, 0x007A, 0x007B, 0x007C, 0x007D, 0x007E, 0x007F,
    /* 8 */ 0x0080, 0x0081, 0x0082, 0x0083, 0x0084, 0x0085, 0x0086, 0x0087,
            0x0088, 0x0089, 0x008A, 0x008B, 0x008C, 0x008D, 0x008E, 0x008F,
    /* 9 */ 0x0090, 0x0091, 0x0092, 0x0093, 0x0094, 0x0095, 0x0096, 0x0097,
            0x0098, 0x0099, 0x009A, 0x009B, 0x009C, 0x009D, 0x009E, 0x009F,
    /* A */ 0x00A0, 0x00A1, 0x00A2, 0x00A3, 0x00A4, 0x00A5, 0x00A6, 0x00A7,
            0x00A8, 0x00A9, 0x00AA, 0x00AB, 0x00AC, 0x00AD, 0x00AE, 0x00AF,
    /* B */ 0x00B0, 0x00B1, 0x00B2, 0x00B3, 0x00B4, 0x00B5, 0x00B6, 0x00B7,
            0x00B8, 0x00B9, 0x00BA, 0x00BB, 0x00BC, 0x00BD, 0x00BE, 0x00BF,
    /* C */ 0x00C0, 0x00C1, 0x00C2, 0x00C3, 0x00C4, 0x00C5, 0x00E6, 0x00C7,
            0x00C8, 0x00C9, 0x00CA, 0x00CB, 0x00CC, 0x00CD, 0x00CE, 0x00CF,
    /* D */ 0x00F0, 0x00D1, 0x00D2, 0x00D3, 0x00D4, 0x00D5, 0x00D6, 0x00D7,
            0x00F8, 0x00D9, 0x00DA, 0x00DB, 0x00DC, 0x00DD, 0x00FE, 0x00DF,
    /* E */ 0x00E0, 0x00E1, 0x00E2, 0x00E3, 0x00E4, 0x00E5, 0x00E6, 0x00E7,
            0x00E8, 0x00E9, 0x00EA, 0x00EB, 0x00EC, 0x00ED, 0x00EE, 0x00EF,
    /* F */ 0x00F0, 0x00F1, 0x00F2, 0x00F3, 0x00F4, 0x00F5, 0x00F6, 0x00F7,
            0x00F8, 0x00F9, 0x00FA, 0x00FB, 0x00FC, 0x00FD, 0x00FE, 0x00FF,

    // Table 2 (for high byte 0x01)

    /* 0 */ 0x0100, 0x0101, 0x0102, 0x0103, 0x0104, 0x0105, 0x0106, 0x0107,
            0x0108, 0x0109, 0x010A, 0x010B, 0x010C, 0x010D, 0x010E, 0x010F,
    /* 1 */ 0x0111, 0x0111, 0x0112, 0x0113, 0x0114, 0x0115, 0x0116, 0x0117,
            0x0118, 0x0119, 0x011A, 0x011B, 0x011C, 0x011D, 0x011E, 0x011F,
    /* 2 */ 0x0120, 0x0121, 0x0122, 0x0123, 0x0124, 0x0125, 0x0127, 0x0127,
            0x0128, 0x0129, 0x012A, 0x012B, 0x012C, 0x012D, 0x012E, 0x012F,
    /* 3 */ 0x0130, 0x0131, 0x0133, 0x0133, 0x0134, 0x0135, 0x0136, 0x0137,
            0x0138, 0x0139, 0x013A, 0x013B, 0x013C, 0x013D, 0x013E, 0x0140,
    /* 4 */ 0x0140, 0x0142, 0x0142, 0x0143, 0x0144, 0x0145, 0x0146, 0x0147,
            0x0148, 0x0149, 0x014B, 0x014B, 0x014C, 0x014D, 0x014E, 0x014F,
    /* 5 */ 0x0150, 0x0151, 0x0153, 0x0153, 0x0154, 0x0155, 0x0156, 0x0157,
            0x0158, 0x0159, 0x015A, 0x015B, 0x015C, 0x015D, 0x015E, 0x015F,
    /* 6 */ 0x0160, 0x0161, 0x0162, 0x0163, 0x0164, 0x0165, 0x0167, 0x0167,
            0x0168, 0x0169, 0x016A, 0x016B, 0x016C, 0x016D, 0x016E, 0x016F,
    /* 7 */ 0x0170, 0x0171, 0x0172, 0x0173, 0x0174, 0x0175, 0x0176, 0x0177,
            0x0178, 0x0179, 0x017A, 0x017B, 0x017C, 0x017D, 0x017E, 0x017F,
    /* 8 */ 0x0180, 0x0253, 0x0183, 0x0183, 0x0185, 0x0185, 0x0254, 0x0188,
            0x0188, 0x0256, 0x0257, 0x018C, 0x018C, 0x018D, 0x01DD, 0x0259,
    /* 9 */ 0x025B, 0x0192, 0x0192, 0x0260, 0x0263, 0x0195, 0x0269, 0x0268,
            0x0199, 0x0199, 0x019A, 0x019B, 0x026F, 0x0272, 0x019E, 0x0275,
    /* A */ 0x01A0, 0x01A1, 0x01A3, 0x01A3, 0x01A5, 0x01A5, 0x01A6, 0x01A8,
            0x01A8, 0x0283, 0x01AA, 0x01AB, 0x01AD, 0x01AD, 0x0288, 0x01AF,
    /* B */ 0x01B0, 0x028A, 0x028B, 0x01B4, 0x01B4, 0x01B6, 0x01B6, 0x0292,
            0x01B9, 0x01B9, 0x01BA, 0x01BB, 0x01BD, 0x01BD, 0x01BE, 0x01BF,
    /* C */ 0x01C0, 0x01C1, 0x01C2, 0x01C3, 0x01C6, 0x01C6, 0x01C6, 0x01C9,
            0x01C9, 0x01C9, 0x01CC, 0x01CC, 0x01CC, 0x01CD, 0x01CE, 0x01CF,
    /* D */ 0x01D0, 0x01D1, 0x01D2, 0x01D3, 0x01D4, 0x01D5, 0x01D6, 0x01D7,
            0x01D8, 0x01D9, 0x01DA, 0x01DB, 0x01DC, 0x01DD, 0x01DE, 0x01DF,
    /* E */ 0x01E0, 0x01E1, 0x01E2, 0x01E3, 0x01E5, 0x01E5, 0x01E6, 0x01E7,
            0x01E8, 0x01E9, 0x01EA, 0x01EB, 0x01EC, 0x01ED, 0x01EE, 0x01EF,
    /* F */ 0x01F0, 0x01F3, 0x01F3, 0x01F3, 0x01F4, 0x01F5, 0x01F6, 0x01F7,
            0x01F8, 0x01F9, 0x01FA, 0x01FB, 0x01FC, 0x01FD, 0x01FE, 0x01FF,

    // Table 3 (for high byte 0x03)

    /* 0 */ 0x0300, 0x0301, 0x0302, 0x0303, 0x0304, 0x0305, 0x0306, 0x0307,
            0x0308, 0x0309, 0x030A, 0x030B, 0x030C, 0x030D, 0x030E, 0x030F,
    /* 1 */ 0x0310, 0x0311, 0x0312, 0x0313, 0x0314, 0x0315, 0x0316, 0x0317,
            0x0318, 0x0319, 0x031A, 0x031B, 0x031C, 0x031D, 0x031E, 0x031F,
    /* 2 */ 0x0320, 0x0321, 0x0322, 0x0323, 0x0324, 0x0325, 0x0326, 0x0327,
            0x0328, 0x0329, 0x032A, 0x032B, 0x032C, 0x032D, 0x032E, 0x032F,
    /* 3 */ 0x0330, 0x0331, 0x0332, 0x0333, 0x0334, 0x0335, 0x0336, 0x0337,
            0x0338, 0x0339, 0x033A, 0x033B, 0x033C, 0x033D, 0x033E, 0x033F,
    /* 4 */ 0x0340, 0x0341, 0x0342, 0x0343, 0x0344, 0x0345, 0x0346, 0x0347,
            0x0348, 0x0349, 0x034A, 0x034B, 0x034C, 0x034D, 0x034E, 0x034F,
    /* 5 */ 0x0350, 0x0351, 0x0352, 0x0353, 0x0354, 0x0355, 0x0356, 0x0357,
            0x0358, 0x0359, 0x035A, 0x035B, 0x035C, 0x035D, 0x035E, 0x035F,
    /* 6 */ 0x0360, 0x0361, 0x0362, 0x0363, 0x0364, 0x0365, 0x0366, 0x0367,
            0x0368, 0x0369, 0x036A, 0x036B, 0x036C, 0x036D, 0x036E, 0x036F,
    /* 7 */ 0x0370, 0x0371, 0x0372, 0x0373, 0x0374, 0x0375, 0x0376, 0x0377,
            0x0378, 0x0379, 0x037A, 0x037B, 0x037C, 0x037D, 0x037E, 0x037F,
    /* 8 */ 0x0380, 0x0381, 0x0382, 0x0383, 0x0384, 0x0385, 0x0386, 0x0387,
            0x0388, 0x0389, 0x038A, 0x038B, 0x038C, 0x038D, 0x038E, 0x038F,
    /* 9 */ 0x0390, 0x03B1, 0x03B2, 0x03B3, 0x03B4, 0x03B5, 0x03B6, 0x03B7,
            0x03B8, 0x03B9, 0x03BA, 0x03BB, 0x03BC, 0x03BD, 0x03BE, 0x03BF,
    /* A */ 0x03C0, 0x03C1, 0x03A2, 0x03C3, 0x03C4, 0x03C5, 0x03C6, 0x03C7,
            0x03C8, 0x03C9, 0x03AA, 0x03AB, 0x03AC, 0x03AD, 0x03AE, 0x03AF,
    /* B */ 0x03B0, 0x03B1, 0x03B2, 0x03B3, 0x03B4, 0x03B5, 0x03B6, 0x03B7,
            0x03B8, 0x03B9, 0x03BA, 0x03BB, 0x03BC, 0x03BD, 0x03BE, 0x03BF,
    /* C */ 0x03C0, 0x03C1, 0x03C2, 0x03C3, 0x03C4, 0x03C5, 0x03C6, 0x03C7,
            0x03C8, 0x03C9, 0x03CA, 0x03CB, 0x03CC, 0x03CD, 0x03CE, 0x03CF,
    /* D */ 0x03D0, 0x03D1, 0x03D2, 0x03D3, 0x03D4, 0x03D5, 0x03D6, 0x03D7,
            0x03D8, 0x03D9, 0x03DA, 0x03DB, 0x03DC, 0x03DD, 0x03DE, 0x03DF,
    /* E */ 0x03E0, 0x03E1, 0x03E3, 0x03E3, 0x03E5, 0x03E5, 0x03E7, 0x03E7,
            0x03E9, 0x03E9, 0x03EB, 0x03EB, 0x03ED, 0x03ED, 0x03EF, 0x03EF,
    /* F */ 0x03F0, 0x03F1, 0x03F2, 0x03F3, 0x03F4, 0x03F5, 0x03F6, 0x03F7,
            0x03F8, 0x03F9, 0x03FA, 0x03FB, 0x03FC, 0x03FD, 0x03FE, 0x03FF,

    // Table 4 (for high byte 0x04)

    /* 0 */ 0x0400, 0x0401, 0x0452, 0x0403, 0x0454, 0x0455, 0x0456, 0x0407,
            0x0458, 0x0459, 0x045A, 0x045B, 0x040C, 0x040D, 0x040E, 0x045F,
    /* 1 */ 0x0430, 0x0431, 0x0432, 0x0433, 0x0434, 0x0435, 0x0436, 0x0437,
            0x0438, 0x0419, 0x043A, 0x043B, 0x043C, 0x043D, 0x043E, 0x043F,
    /* 2 */ 0x0440, 0x0441, 0x0442, 0x0443, 0x0444, 0x0445, 0x0446, 0x0447,
            0x0448, 0x0449, 0x044A, 0x044B, 0x044C, 0x044D, 0x044E, 0x044F,
    /* 3 */ 0x0430, 0x0431, 0x0432, 0x0433, 0x0434, 0x0435, 0x0436, 0x0437,
            0x0438, 0x0439, 0x043A, 0x043B, 0x043C, 0x043D, 0x043E, 0x043F,
    /* 4 */ 0x0440, 0x0441, 0x0442, 0x0443, 0x0444, 0x0445, 0x0446, 0x0447,
            0x0448, 0x0449, 0x044A, 0x044B, 0x044C, 0x044D, 0x044E, 0x044F,
    /* 5 */ 0x0450, 0x0451, 0x0452, 0x0453, 0x0454, 0x0455, 0x0456, 0x0457,
            0x0458, 0x0459, 0x045A, 0x045B, 0x045C, 0x045D, 0x045E, 0x045F,
    /* 6 */ 0x0461, 0x0461, 0x0463, 0x0463, 0x0465, 0x0465, 0x0467, 0x0467,
            0x0469, 0x0469, 0x046B, 0x046B, 0x046D, 0x046D, 0x046F, 0x046F,
    /* 7 */ 0x0471, 0x0471, 0x0473, 0x0473, 0x0475, 0x0475, 0x0476, 0x0477,
            0x0479, 0x0479, 0x047B, 0x047B, 0x047D, 0x047D, 0x047F, 0x047F,
    /* 8 */ 0x0481, 0x0481, 0x0482, 0x0483, 0x0484, 0x0485, 0x0486, 0x0487,
            0x0488, 0x0489, 0x048A, 0x048B, 0x048C, 0x048D, 0x048E, 0x048F,
    /* 9 */ 0x0491, 0x0491, 0x0493, 0x0493, 0x0495, 0x0495, 0x0497, 0x0497,
            0x0499, 0x0499, 0x049B, 0x049B, 0x049D, 0x049D, 0x049F, 0x049F,
    /* A */ 0x04A1, 0x04A1, 0x04A3, 0x04A3, 0x04A5, 0x04A5, 0x04A7, 0x04A7,
            0x04A9, 0x04A9, 0x04AB, 0x04AB, 0x04AD, 0x04AD, 0x04AF, 0x04AF,
    /* B */ 0x04B1, 0x04B1, 0x04B3, 0x04B3, 0x04B5, 0x04B5, 0x04B7, 0x04B7,
            0x04B9, 0x04B9, 0x04BB, 0x04BB, 0x04BD, 0x04BD, 0x04BF, 0x04BF,
    /* C */ 0x04C0, 0x04C1, 0x04C2, 0x04C4, 0x04C4, 0x04C5, 0x04C6, 0x04C8,
            0x04C8, 0x04C9, 0x04CA, 0x04CC, 0x04CC, 0x04CD, 0x04CE, 0x04CF,
    /* D */ 0x04D0, 0x04D1, 0x04D2, 0x04D3, 0x04D4, 0x04D5, 0x04D6, 0x04D7,
            0x04D8, 0x04D9, 0x04DA, 0x04DB, 0x04DC, 0x04DD, 0x04DE, 0x04DF,
    /* E */ 0x04E0, 0x04E1, 0x04E2, 0x04E3, 0x04E4, 0x04E5, 0x04E6, 0x04E7,
            0x04E8, 0x04E9, 0x04EA, 0x04EB, 0x04EC, 0x04ED, 0x04EE, 0x04EF,
    /* F */ 0x04F0, 0x04F1, 0x04F2, 0x04F3, 0x04F4, 0x04F5, 0x04F6, 0x04F7,
            0x04F8, 0x04F9, 0x04FA, 0x04FB, 0x04FC, 0x04FD, 0x04FE, 0x04FF,

    // Table 5 (for high byte 0x05)

    /* 0 */ 0x0500, 0x0501, 0x0502, 0x0503, 0x0504, 0x0505, 0x0506, 0x0507,
            0x0508, 0x0509, 0x050A, 0x050B, 0x050C, 0x050D, 0x050E, 0x050F,
    /* 1 */ 0x0510, 0x0511, 0x0512, 0x0513, 0x0514, 0x0515, 0x0516, 0x0517,
            0x0518, 0x0519, 0x051A, 0x051B, 0x051C, 0x051D, 0x051E, 0x051F,
    /* 2 */ 0x0520, 0x0521, 0x0522, 0x0523, 0x0524, 0x0525, 0x0526, 0x0527,
            0x0528, 0x0529, 0x052A, 0x052B, 0x052C, 0x052D, 0x052E, 0x052F,
    /* 3 */ 0x0530, 0x0561, 0x0562, 0x0563, 0x0564, 0x0565, 0x0566, 0x0567,
            0x0568, 0x0569, 0x056A, 0x056B, 0x056C, 0x056D, 0x056E, 0x056F,
    /* 4 */ 0x0570, 0x0571, 0x0572, 0x0573, 0x0574, 0x0575, 0x0576, 0x0577,
            0x0578, 0x0579, 0x057A, 0x057B, 0x057C, 0x057D, 0x057E, 0x057F,
    /* 5 */ 0x0580, 0x0581, 0x0582, 0x0583, 0x0584, 0x0585, 0x0586, 0x0557,
            0x0558, 0x0559, 0x055A, 0x055B, 0x055C, 0x055D, 0x055E, 0x055F,
    /* 6 */ 0x0560, 0x0561, 0x0562, 0x0563, 0x0564, 0x0565, 0x0566, 0x0567,
            0x0568, 0x0569, 0x056A, 0x056B, 0x056C, 0x056D, 0x056E, 0x056F,
    /* 7 */ 0x0570, 0x0571, 0x0572, 0x0573, 0x0574, 0x0575, 0x0576, 0x0577,
            0x0578, 0x0579, 0x057A, 0x057B, 0x057C, 0x057D, 0x057E, 0x057F,
    /* 8 */ 0x0580, 0x0581, 0x0582, 0x0583, 0x0584, 0x0585, 0x0586, 0x0587,
            0x0588, 0x0589, 0x058A, 0x058B, 0x058C, 0x058D, 0x058E, 0x058F,
    /* 9 */ 0x0590, 0x0591, 0x0592, 0x0593, 0x0594, 0x0595, 0x0596, 0x0597,
            0x0598, 0x0599, 0x059A, 0x059B, 0x059C, 0x059D, 0x059E, 0x059F,
    /* A */ 0x05A0, 0x05A1, 0x05A2, 0x05A3, 0x05A4, 0x05A5, 0x05A6, 0x05A7,
            0x05A8, 0x05A9, 0x05AA, 0x05AB, 0x05AC, 0x05AD, 0x05AE, 0x05AF,
    /* B */ 0x05B0, 0x05B1, 0x05B2, 0x05B3, 0x05B4, 0x05B5, 0x05B6, 0x05B7,
            0x05B8, 0x05B9, 0x05BA, 0x05BB, 0x05BC, 0x05BD, 0x05BE, 0x05BF,
    /* C */ 0x05C0, 0x05C1, 0x05C2, 0x05C3, 0x05C4, 0x05C5, 0x05C6, 0x05C7,
            0x05C8, 0x05C9, 0x05CA, 0x05CB, 0x05CC, 0x05CD, 0x05CE, 0x05CF,
    /* D */ 0x05D0, 0x05D1, 0x05D2, 0x05D3, 0x05D4, 0x05D5, 0x05D6, 0x05D7,
            0x05D8, 0x05D9, 0x05DA, 0x05DB, 0x05DC, 0x05DD, 0x05DE, 0x05DF,
    /* E */ 0x05E0, 0x05E1, 0x05E2, 0x05E3, 0x05E4, 0x05E5, 0x05E6, 0x05E7,
            0x05E8, 0x05E9, 0x05EA, 0x05EB, 0x05EC, 0x05ED, 0x05EE, 0x05EF,
    /* F */ 0x05F0, 0x05F1, 0x05F2, 0x05F3, 0x05F4, 0x05F5, 0x05F6, 0x05F7,
            0x05F8, 0x05F9, 0x05FA, 0x05FB, 0x05FC, 0x05FD, 0x05FE, 0x05FF,

    // Table 6 (for high byte 0x10)

    /* 0 */ 0x1000, 0x1001, 0x1002, 0x1003, 0x1004, 0x1005, 0x1006, 0x1007,
            0x1008, 0x1009, 0x100A, 0x100B, 0x100C, 0x100D, 0x100E, 0x100F,
    /* 1 */ 0x1010, 0x1011, 0x1012, 0x1013, 0x1014, 0x1015, 0x1016, 0x1017,
            0x1018, 0x1019, 0x101A, 0x101B, 0x101C, 0x101D, 0x101E, 0x101F,
    /* 2 */ 0x1020, 0x1021, 0x1022, 0x1023, 0x1024, 0x1025, 0x1026, 0x1027,
            0x1028, 0x1029, 0x102A, 0x102B, 0x102C, 0x102D, 0x102E, 0x102F,
    /* 3 */ 0x1030, 0x1031, 0x1032, 0x1033, 0x1034, 0x1035, 0x1036, 0x1037,
            0x1038, 0x1039, 0x103A, 0x103B, 0x103C, 0x103D, 0x103E, 0x103F,
    /* 4 */ 0x1040, 0x1041, 0x1042, 0x1043, 0x1044, 0x1045, 0x1046, 0x1047,
            0x1048, 0x1049, 0x104A, 0x104B, 0x104C, 0x104D, 0x104E, 0x104F,
    /* 5 */ 0x1050, 0x1051, 0x1052, 0x1053, 0x1054, 0x1055, 0x1056, 0x1057,
            0x1058, 0x1059, 0x105A, 0x105B, 0x105C, 0x105D, 0x105E, 0x105F,
    /* 6 */ 0x1060, 0x1061, 0x1062, 0x1063, 0x1064, 0x1065, 0x1066, 0x1067,
            0x1068, 0x1069, 0x106A, 0x106B, 0x106C, 0x106D, 0x106E, 0x106F,
    /* 7 */ 0x1070, 0x1071, 0x1072, 0x1073, 0x1074, 0x1075, 0x1076, 0x1077,
            0x1078, 0x1079, 0x107A, 0x107B, 0x107C, 0x107D, 0x107E, 0x107F,
    /* 8 */ 0x1080, 0x1081, 0x1082, 0x1083, 0x1084, 0x1085, 0x1086, 0x1087,
            0x1088, 0x1089, 0x108A, 0x108B, 0x108C, 0x108D, 0x108E, 0x108F,
    /* 9 */ 0x1090, 0x1091, 0x1092, 0x1093, 0x1094, 0x1095, 0x1096, 0x1097,
            0x1098, 0x1099, 0x109A, 0x109B, 0x109C, 0x109D, 0x109E, 0x109F,
    /* A */ 0x10D0, 0x10D1, 0x10D2, 0x10D3, 0x10D4, 0x10D5, 0x10D6, 0x10D7,
            0x10D8, 0x10D9, 0x10DA, 0x10DB, 0x10DC, 0x10DD, 0x10DE, 0x10DF,
    /* B */ 0x10E0, 0x10E1, 0x10E2, 0x10E3, 0x10E4, 0x10E5, 0x10E6, 0x10E7,
            0x10E8, 0x10E9, 0x10EA, 0x10EB, 0x10EC, 0x10ED, 0x10EE, 0x10EF,
    /* C */ 0x10F0, 0x10F1, 0x10F2, 0x10F3, 0x10F4, 0x10F5, 0x10C6, 0x10C7,
            0x10C8, 0x10C9, 0x10CA, 0x10CB, 0x10CC, 0x10CD, 0x10CE, 0x10CF,
    /* D */ 0x10D0, 0x10D1, 0x10D2, 0x10D3, 0x10D4, 0x10D5, 0x10D6, 0x10D7,
            0x10D8, 0x10D9, 0x10DA, 0x10DB, 0x10DC, 0x10DD, 0x10DE, 0x10DF,
    /* E */ 0x10E0, 0x10E1, 0x10E2, 0x10E3, 0x10E4, 0x10E5, 0x10E6, 0x10E7,
            0x10E8, 0x10E9, 0x10EA, 0x10EB, 0x10EC, 0x10ED, 0x10EE, 0x10EF,
    /* F */ 0x10F0, 0x10F1, 0x10F2, 0x10F3, 0x10F4, 0x10F5, 0x10F6, 0x10F7,
            0x10F8, 0x10F9, 0x10FA, 0x10FB, 0x10FC, 0x10FD, 0x10FE, 0x10FF,

    // Table 7 (for high byte 0x20)

    /* 0 */ 0x2000, 0x2001, 0x2002, 0x2003, 0x2004, 0x2005, 0x2006, 0x2007,
            0x2008, 0x2009, 0x200A, 0x200B, 0x0000, 0x0000, 0x0000, 0x0000,
    /* 1 */ 0x2010, 0x2011, 0x2012, 0x2013, 0x2014, 0x2015, 0x2016, 0x2017,
            0x2018, 0x2019, 0x201A, 0x201B, 0x201C, 0x201D, 0x201E, 0x201F,
    /* 2 */ 0x2020, 0x2021, 0x2022, 0x2023, 0x2024, 0x2025, 0x2026, 0x2027,
            0x2028, 0x2029, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x202F,
    /* 3 */ 0x2030, 0x2031, 0x2032, 0x2033, 0x2034, 0x2035, 0x2036, 0x2037,
            0x2038, 0x2039, 0x203A, 0x203B, 0x203C, 0x203D, 0x203E, 0x203F,
    /* 4 */ 0x2040, 0x2041, 0x2042, 0x2043, 0x2044, 0x2045, 0x2046, 0x2047,
            0x2048, 0x2049, 0x204A, 0x204B, 0x204C, 0x204D, 0x204E, 0x204F,
    /* 5 */ 0x2050, 0x2051, 0x2052, 0x2053, 0x2054, 0x2055, 0x2056, 0x2057,
            0x2058, 0x2059, 0x205A, 0x205B, 0x205C, 0x205D, 0x205E, 0x205F,
    /* 6 */ 0x2060, 0x2061, 0x2062, 0x2063, 0x2064, 0x2065, 0x2066, 0x2067,
            0x2068, 0x2069, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /* 7 */ 0x2070, 0x2071, 0x2072, 0x2073, 0x2074, 0x2075, 0x2076, 0x2077,
            0x2078, 0x2079, 0x207A, 0x207B, 0x207C, 0x207D, 0x207E, 0x207F,
    /* 8 */ 0x2080, 0x2081, 0x2082, 0x2083, 0x2084, 0x2085, 0x2086, 0x2087,
            0x2088, 0x2089, 0x208A, 0x208B, 0x208C, 0x208D, 0x208E, 0x208F,
    /* 9 */ 0x2090, 0x2091, 0x2092, 0x2093, 0x2094, 0x2095, 0x2096, 0x2097,
            0x2098, 0x2099, 0x209A, 0x209B, 0x209C, 0x209D, 0x209E, 0x209F,
    /* A */ 0x20A0, 0x20A1, 0x20A2, 0x20A3, 0x20A4, 0x20A5, 0x20A6, 0x20A7,
            0x20A8, 0x20A9, 0x20AA, 0x20AB, 0x20AC, 0x20AD, 0x20AE, 0x20AF,
    /* B */ 0x20B0, 0x20B1, 0x20B2, 0x20B3, 0x20B4, 0x20B5, 0x20B6, 0x20B7,
            0x20B8, 0x20B9, 0x20BA, 0x20BB, 0x20BC, 0x20BD, 0x20BE, 0x20BF,
    /* C */ 0x20C0, 0x20C1, 0x20C2, 0x20C3, 0x20C4, 0x20C5, 0x20C6, 0x20C7,
            0x20C8, 0x20C9, 0x20CA, 0x20CB, 0x20CC, 0x20CD, 0x20CE, 0x20CF,
    /* D */ 0x20D0, 0x20D1, 0x20D2, 0x20D3, 0x20D4, 0x20D5, 0x20D6, 0x20D7,
            0x20D8, 0x20D9, 0x20DA, 0x20DB, 0x20DC, 0x20DD, 0x20DE, 0x20DF,
    /* E */ 0x20E0, 0x20E1, 0x20E2, 0x20E3, 0x20E4, 0x20E5, 0x20E6, 0x20E7,
            0x20E8, 0x20E9, 0x20EA, 0x20EB, 0x20EC, 0x20ED, 0x20EE, 0x20EF,
    /* F */ 0x20F0, 0x20F1, 0x20F2, 0x20F3, 0x20F4, 0x20F5, 0x20F6, 0x20F7,
            0x20F8, 0x20F9, 0x20FA, 0x20FB, 0x20FC, 0x20FD, 0x20FE, 0x20FF,

    // Table 8 (for high byte 0x21)

    /* 0 */ 0x2100, 0x2101, 0x2102, 0x2103, 0x2104, 0x2105, 0x2106, 0x2107,
            0x2108, 0x2109, 0x210A, 0x210B, 0x210C, 0x210D, 0x210E, 0x210F,
    /* 1 */ 0x2110, 0x2111, 0x2112, 0x2113, 0x2114, 0x2115, 0x2116, 0x2117,
            0x2118, 0x2119, 0x211A, 0x211B, 0x211C, 0x211D, 0x211E, 0x211F,
    /* 2 */ 0x2120, 0x2121, 0x2122, 0x2123, 0x2124, 0x2125, 0x2126, 0x2127,
            0x2128, 0x2129, 0x212A, 0x212B, 0x212C, 0x212D, 0x212E, 0x212F,
    /* 3 */ 0x2130, 0x2131, 0x2132, 0x2133, 0x2134, 0x2135, 0x2136, 0x2137,
            0x2138, 0x2139, 0x213A, 0x213B, 0x213C, 0x213D, 0x213E, 0x213F,
    /* 4 */ 0x2140, 0x2141, 0x2142, 0x2143, 0x2144, 0x2145, 0x2146, 0x2147,
            0x2148, 0x2149, 0x214A, 0x214B, 0x214C, 0x214D, 0x214E, 0x214F,
    /* 5 */ 0x2150, 0x2151, 0x2152, 0x2153, 0x2154, 0x2155, 0x2156, 0x2157,
            0x2158, 0x2159, 0x215A, 0x215B, 0x215C, 0x215D, 0x215E, 0x215F,
    /* 6 */ 0x2170, 0x2171, 0x2172, 0x2173, 0x2174, 0x2175, 0x2176, 0x2177,
            0x2178, 0x2179, 0x217A, 0x217B, 0x217C, 0x217D, 0x217E, 0x217F,
    /* 7 */ 0x2170, 0x2171, 0x2172, 0x2173, 0x2174, 0x2175, 0x2176, 0x2177,
            0x2178, 0x2179, 0x217A, 0x217B, 0x217C, 0x217D, 0x217E, 0x217F,
    /* 8 */ 0x2180, 0x2181, 0x2182, 0x2183, 0x2184, 0x2185, 0x2186, 0x2187,
            0x2188, 0x2189, 0x218A, 0x218B, 0x218C, 0x218D, 0x218E, 0x218F,
    /* 9 */ 0x2190, 0x2191, 0x2192, 0x2193, 0x2194, 0x2195, 0x2196, 0x2197,
            0x2198, 0x2199, 0x219A, 0x219B, 0x219C, 0x219D, 0x219E, 0x219F,
    /* A */ 0x21A0, 0x21A1, 0x21A2, 0x21A3, 0x21A4, 0x21A5, 0x21A6, 0x21A7,
            0x21A8, 0x21A9, 0x21AA, 0x21AB, 0x21AC, 0x21AD, 0x21AE, 0x21AF,
    /* B */ 0x21B0, 0x21B1, 0x21B2, 0x21B3, 0x21B4, 0x21B5, 0x21B6, 0x21B7,
            0x21B8, 0x21B9, 0x21BA, 0x21BB, 0x21BC, 0x21BD, 0x21BE, 0x21BF,
    /* C */ 0x21C0, 0x21C1, 0x21C2, 0x21C3, 0x21C4, 0x21C5, 0x21C6, 0x21C7,
            0x21C8, 0x21C9, 0x21CA, 0x21CB, 0x21CC, 0x21CD, 0x21CE, 0x21CF,
    /* D */ 0x21D0, 0x21D1, 0x21D2, 0x21D3, 0x21D4, 0x21D5, 0x21D6, 0x21D7,
            0x21D8, 0x21D9, 0x21DA, 0x21DB, 0x21DC, 0x21DD, 0x21DE, 0x21DF,
    /* E */ 0x21E0, 0x21E1, 0x21E2, 0x21E3, 0x21E4, 0x21E5, 0x21E6, 0x21E7,
            0x21E8, 0x21E9, 0x21EA, 0x21EB, 0x21EC, 0x21ED, 0x21EE, 0x21EF,
    /* F */ 0x21F0, 0x21F1, 0x21F2, 0x21F3, 0x21F4, 0x21F5, 0x21F6, 0x21F7,
            0x21F8, 0x21F9, 0x21FA, 0x21FB, 0x21FC, 0x21FD, 0x21FE, 0x21FF,

    // Table 9 (for high byte 0xFE)

    /* 0 */ 0xFE00, 0xFE01, 0xFE02, 0xFE03, 0xFE04, 0xFE05, 0xFE06, 0xFE07,
            0xFE08, 0xFE09, 0xFE0A, 0xFE0B, 0xFE0C, 0xFE0D, 0xFE0E, 0xFE0F,
    /* 1 */ 0xFE10, 0xFE11, 0xFE12, 0xFE13, 0xFE14, 0xFE15, 0xFE16, 0xFE17,
            0xFE18, 0xFE19, 0xFE1A, 0xFE1B, 0xFE1C, 0xFE1D, 0xFE1E, 0xFE1F,
    /* 2 */ 0xFE20, 0xFE21, 0xFE22, 0xFE23, 0xFE24, 0xFE25, 0xFE26, 0xFE27,
            0xFE28, 0xFE29, 0xFE2A, 0xFE2B, 0xFE2C, 0xFE2D, 0xFE2E, 0xFE2F,
    /* 3 */ 0xFE30, 0xFE31, 0xFE32, 0xFE33, 0xFE34, 0xFE35, 0xFE36, 0xFE37,
            0xFE38, 0xFE39, 0xFE3A, 0xFE3B, 0xFE3C, 0xFE3D, 0xFE3E, 0xFE3F,
    /* 4 */ 0xFE40, 0xFE41, 0xFE42, 0xFE43, 0xFE44, 0xFE45, 0xFE46, 0xFE47,
            0xFE48, 0xFE49, 0xFE4A, 0xFE4B, 0xFE4C, 0xFE4D, 0xFE4E, 0xFE4F,
    /* 5 */ 0xFE50, 0xFE51, 0xFE52, 0xFE53, 0xFE54, 0xFE55, 0xFE56, 0xFE57,
            0xFE58, 0xFE59, 0xFE5A, 0xFE5B, 0xFE5C, 0xFE5D, 0xFE5E, 0xFE5F,
    /* 6 */ 0xFE60, 0xFE61, 0xFE62, 0xFE63, 0xFE64, 0xFE65, 0xFE66, 0xFE67,
            0xFE68, 0xFE69, 0xFE6A, 0xFE6B, 0xFE6C, 0xFE6D, 0xFE6E, 0xFE6F,
    /* 7 */ 0xFE70, 0xFE71, 0xFE72, 0xFE73, 0xFE74, 0xFE75, 0xFE76, 0xFE77,
            0xFE78, 0xFE79, 0xFE7A, 0xFE7B, 0xFE7C, 0xFE7D, 0xFE7E, 0xFE7F,
    /* 8 */ 0xFE80, 0xFE81, 0xFE82, 0xFE83, 0xFE84, 0xFE85, 0xFE86, 0xFE87,
            0xFE88, 0xFE89, 0xFE8A, 0xFE8B, 0xFE8C, 0xFE8D, 0xFE8E, 0xFE8F,
    /* 9 */ 0xFE90, 0xFE91, 0xFE92, 0xFE93, 0xFE94, 0xFE95, 0xFE96, 0xFE97,
            0xFE98, 0xFE99, 0xFE9A, 0xFE9B, 0xFE9C, 0xFE9D, 0xFE9E, 0xFE9F,
    /* A */ 0xFEA0, 0xFEA1, 0xFEA2, 0xFEA3, 0xFEA4, 0xFEA5, 0xFEA6, 0xFEA7,
            0xFEA8, 0xFEA9, 0xFEAA, 0xFEAB, 0xFEAC, 0xFEAD, 0xFEAE, 0xFEAF,
    /* B */ 0xFEB0, 0xFEB1, 0xFEB2, 0xFEB3, 0xFEB4, 0xFEB5, 0xFEB6, 0xFEB7,
            0xFEB8, 0xFEB9, 0xFEBA, 0xFEBB, 0xFEBC, 0xFEBD, 0xFEBE, 0xFEBF,
    /* C */ 0xFEC0, 0xFEC1, 0xFEC2, 0xFEC3, 0xFEC4, 0xFEC5, 0xFEC6, 0xFEC7,
            0xFEC8, 0xFEC9, 0xFECA, 0xFECB, 0xFECC, 0xFECD, 0xFECE, 0xFECF,
    /* D */ 0xFED0, 0xFED1, 0xFED2, 0xFED3, 0xFED4, 0xFED5, 0xFED6, 0xFED7,
            0xFED8, 0xFED9, 0xFEDA, 0xFEDB, 0xFEDC, 0xFEDD, 0xFEDE, 0xFEDF,
    /* E */ 0xFEE0, 0xFEE1, 0xFEE2, 0xFEE3, 0xFEE4, 0xFEE5, 0xFEE6, 0xFEE7,
            0xFEE8, 0xFEE9, 0xFEEA, 0xFEEB, 0xFEEC, 0xFEED, 0xFEEE, 0xFEEF,
    /* F */ 0xFEF0, 0xFEF1, 0xFEF2, 0xFEF3, 0xFEF4, 0xFEF5, 0xFEF6, 0xFEF7,
            0xFEF8, 0xFEF9, 0xFEFA, 0xFEFB, 0xFEFC, 0xFEFD, 0xFEFE, 0x0000,

    // Table 10 (for high byte 0xFF)

    /* 0 */ 0xFF00, 0xFF01, 0xFF02, 0xFF03, 0xFF04, 0xFF05, 0xFF06, 0xFF07,
            0xFF08, 0xFF09, 0xFF0A, 0xFF0B, 0xFF0C, 0xFF0D, 0xFF0E, 0xFF0F,
    /* 1 */ 0xFF10, 0xFF11, 0xFF12, 0xFF13, 0xFF14, 0xFF15, 0xFF16, 0xFF17,
            0xFF18, 0xFF19, 0xFF1A, 0xFF1B, 0xFF1C, 0xFF1D, 0xFF1E, 0xFF1F,
    /* 2 */ 0xFF20, 0xFF41, 0xFF42, 0xFF43, 0xFF44, 0xFF45, 0xFF46, 0xFF47,
            0xFF48, 0xFF49, 0xFF4A, 0xFF4B, 0xFF4C, 0xFF4D, 0xFF4E, 0xFF4F,
    /* 3 */ 0xFF50, 0xFF51, 0xFF52, 0xFF53, 0xFF54, 0xFF55, 0xFF56, 0xFF57,
            0xFF58, 0xFF59, 0xFF5A, 0xFF3B, 0xFF3C, 0xFF3D, 0xFF3E, 0xFF3F,
    /* 4 */ 0xFF40, 0xFF41, 0xFF42, 0xFF43, 0xFF44, 0xFF45, 0xFF46, 0xFF47,
            0xFF48, 0xFF49, 0xFF4A, 0xFF4B, 0xFF4C, 0xFF4D, 0xFF4E, 0xFF4F,
    /* 5 */ 0xFF50, 0xFF51, 0xFF52, 0xFF53, 0xFF54, 0xFF55, 0xFF56, 0xFF57,
            0xFF58, 0xFF59, 0xFF5A, 0xFF5B, 0xFF5C, 0xFF5D, 0xFF5E, 0xFF5F,
    /* 6 */ 0xFF60, 0xFF61, 0xFF62, 0xFF63, 0xFF64, 0xFF65, 0xFF66, 0xFF67,
            0xFF68, 0xFF69, 0xFF6A, 0xFF6B, 0xFF6C, 0xFF6D, 0xFF6E, 0xFF6F,
    /* 7 */ 0xFF70, 0xFF71, 0xFF72, 0xFF73, 0xFF74, 0xFF75, 0xFF76, 0xFF77,
            0xFF78, 0xFF79, 0xFF7A, 0xFF7B, 0xFF7C, 0xFF7D, 0xFF7E, 0xFF7F,
    /* 8 */ 0xFF80, 0xFF81, 0xFF82, 0xFF83, 0xFF84, 0xFF85, 0xFF86, 0xFF87,
            0xFF88, 0xFF89, 0xFF8A, 0xFF8B, 0xFF8C, 0xFF8D, 0xFF8E, 0xFF8F,
    /* 9 */ 0xFF90, 0xFF91, 0xFF92, 0xFF93, 0xFF94, 0xFF95, 0xFF96, 0xFF97,
            0xFF98, 0xFF99, 0xFF9A, 0xFF9B, 0xFF9C, 0xFF9D, 0xFF9E, 0xFF9F,
    /* A */ 0xFFA0, 0xFFA1, 0xFFA2, 0xFFA3, 0xFFA4, 0xFFA5, 0xFFA6, 0xFFA7,
            0xFFA8, 0xFFA9, 0xFFAA, 0xFFAB, 0xFFAC, 0xFFAD, 0xFFAE, 0xFFAF,
    /* B */ 0xFFB0, 0xFFB1, 0xFFB2, 0xFFB3, 0xFFB4, 0xFFB5, 0xFFB6, 0xFFB7,
            0xFFB8, 0xFFB9, 0xFFBA, 0xFFBB, 0xFFBC, 0xFFBD, 0xFFBE, 0xFFBF,
    /* C */ 0xFFC0, 0xFFC1, 0xFFC2, 0xFFC3, 0xFFC4, 0xFFC5, 0xFFC6, 0xFFC7,
            0xFFC8, 0xFFC9, 0xFFCA, 0xFFCB, 0xFFCC, 0xFFCD, 0xFFCE, 0xFFCF,
    /* D */ 0xFFD0, 0xFFD1, 0xFFD2, 0xFFD3, 0xFFD4, 0xFFD5, 0xFFD6, 0xFFD7,
            0xFFD8, 0xFFD9, 0xFFDA, 0xFFDB, 0xFFDC, 0xFFDD, 0xFFDE, 0xFFDF,
    /* E */ 0xFFE0, 0xFFE1, 0xFFE2, 0xFFE3, 0xFFE4, 0xFFE5, 0xFFE6, 0xFFE7,
            0xFFE8, 0xFFE9, 0xFFEA, 0xFFEB, 0xFFEC, 0xFFED, 0xFFEE, 0xFFEF,
    /* F */ 0xFFF0, 0xFFF1, 0xFFF2, 0xFFF3, 0xFFF4, 0xFFF5, 0xFFF6, 0xFFF7,
            0xFFF8, 0xFFF9, 0xFFFA, 0xFFFB, 0xFFFC, 0xFFFD, 0xFFFE, 0xFFFF,
};

u16 hfsplus_decompose_table[] = {
	/* base table */
	0x0010, 0x04c0, 0x0000, 0x06f0, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x07b0,
	/* char table 0x0___ */
	0x0020, 0x0070, 0x0160, 0x0190, 0x0230, 0x0000, 0x0000, 0x0000,
	0x0000, 0x02d0, 0x0340, 0x0360, 0x03b0, 0x03e0, 0x0400, 0x0430,
	/* char table 0x00__ */
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0030, 0x0040, 0x0050, 0x0060,
	/* char values 0x00c_ */
	0x2042, 0x204a, 0x2052, 0x205a, 0x2062, 0x206a, 0x0000, 0x2072,
	0x207a, 0x2082, 0x208a, 0x2092, 0x209a, 0x20a2, 0x20aa, 0x20b2,
	/* char values 0x00d_ */
	0x0000, 0x20ba, 0x20c2, 0x20ca, 0x20d2, 0x20da, 0x20e2, 0x0000,
	0x0000, 0x20ea, 0x20f2, 0x20fa, 0x2102, 0x210a, 0x0000, 0x0000,
	/* char values 0x00e_ */
	0x2112, 0x211a, 0x2122, 0x212a, 0x2132, 0x213a, 0x0000, 0x2142,
	0x214a, 0x2152, 0x215a, 0x2162, 0x216a, 0x2172, 0x217a, 0x2182,
	/* char values 0x00f_ */
	0x0000, 0x218a, 0x2192, 0x219a, 0x21a2, 0x21aa, 0x21b2, 0x0000,
	0x0000, 0x21ba, 0x21c2, 0x21ca, 0x21d2, 0x21da, 0x0000, 0x21e2,
	/* char table 0x01__ */
	0x0080, 0x0090, 0x00a0, 0x00b0, 0x00c0, 0x00d0, 0x00e0, 0x00f0,
	0x0000, 0x0000, 0x0100, 0x0110, 0x0120, 0x0130, 0x0140, 0x0150,
	/* char values 0x010_ */
	0x21ea, 0x21f2, 0x21fa, 0x2202, 0x220a, 0x2212, 0x221a, 0x2222,
	0x222a, 0x2232, 0x223a, 0x2242, 0x224a, 0x2252, 0x225a, 0x2262,
	/* char values 0x011_ */
	0x0000, 0x0000, 0x226a, 0x2272, 0x227a, 0x2282, 0x228a, 0x2292,
	0x229a, 0x22a2, 0x22aa, 0x22b2, 0x22ba, 0x22c2, 0x22ca, 0x22d2,
	/* char values 0x012_ */
	0x22da, 0x22e2, 0x22ea, 0x22f2, 0x22fa, 0x2302, 0x0000, 0x0000,
	0x230a, 0x2312, 0x231a, 0x2322, 0x232a, 0x2332, 0x233a, 0x2342,
	/* char values 0x013_ */
	0x234a, 0x0000, 0x0000, 0x0000, 0x2352, 0x235a, 0x2362, 0x236a,
	0x0000, 0x2372, 0x237a, 0x2382, 0x238a, 0x2392, 0x239a, 0x0000,
	/* char values 0x014_ */
	0x0000, 0x0000, 0x0000, 0x23a2, 0x23aa, 0x23b2, 0x23ba, 0x23c2,
	0x23ca, 0x0000, 0x0000, 0x0000, 0x23d2, 0x23da, 0x23e2, 0x23ea,
	/* char values 0x015_ */
	0x23f2, 0x23fa, 0x0000, 0x0000, 0x2402, 0x240a, 0x2412, 0x241a,
	0x2422, 0x242a, 0x2432, 0x243a, 0x2442, 0x244a, 0x2452, 0x245a,
	/* char values 0x016_ */
	0x2462, 0x246a, 0x2472, 0x247a, 0x2482, 0x248a, 0x0000, 0x0000,
	0x2492, 0x249a, 0x24a2, 0x24aa, 0x24b2, 0x24ba, 0x24c2, 0x24ca,
	/* char values 0x017_ */
	0x24d2, 0x24da, 0x24e2, 0x24ea, 0x24f2, 0x24fa, 0x2502, 0x250a,
	0x2512, 0x251a, 0x2522, 0x252a, 0x2532, 0x253a, 0x2542, 0x0000,
	/* char values 0x01a_ */
	0x254a, 0x2552, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x255a,
	/* char values 0x01b_ */
	0x2562, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	/* char values 0x01c_ */
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x256a, 0x2572, 0x257a,
	/* char values 0x01d_ */
	0x2582, 0x258a, 0x2592, 0x259a, 0x25a2, 0x25ab, 0x25b7, 0x25c3,
	0x25cf, 0x25db, 0x25e7, 0x25f3, 0x25ff, 0x0000, 0x260b, 0x2617,
	/* char values 0x01e_ */
	0x2623, 0x262f, 0x263a, 0x2642, 0x0000, 0x0000, 0x264a, 0x2652,
	0x265a, 0x2662, 0x266a, 0x2672, 0x267b, 0x2687, 0x2692, 0x269a,
	/* char values 0x01f_ */
	0x26a2, 0x0000, 0x0000, 0x0000, 0x26aa, 0x26b2, 0x0000, 0x0000,
	0x0000, 0x0000, 0x26bb, 0x26c7, 0x26d2, 0x26da, 0x26e2, 0x26ea,
	/* char table 0x02__ */
	0x0170, 0x0180, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	/* char values 0x020_ */
	0x26f2, 0x26fa, 0x2702, 0x270a, 0x2712, 0x271a, 0x2722, 0x272a,
	0x2732, 0x273a, 0x2742, 0x274a, 0x2752, 0x275a, 0x2762, 0x276a,
	/* char values 0x021_ */
	0x2772, 0x277a, 0x2782, 0x278a, 0x2792, 0x279a, 0x27a2, 0x27aa,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	/* char table 0x03__ */
	0x0000, 0x01a0, 0x0000, 0x0000, 0x01b0, 0x0000, 0x0000, 0x01c0,
	0x01d0, 0x01e0, 0x01f0, 0x0200, 0x0210, 0x0220, 0x0000, 0x0000,
	/* char values 0x031_ */
	0x27b2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	/* char values 0x034_ */
	0x27b9, 0x27bd, 0x0000, 0x27c1, 0x27c6, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	/* char values 0x037_ */
	0x0000, 0x0000, 0x0000, 0x0000, 0x27cd, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x27d1, 0x0000,
	/* char values 0x038_ */
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x27d6, 0x27de, 0x27e5,
	0x27ea, 0x27f2, 0x27fa, 0x0000, 0x2802, 0x0000, 0x280a, 0x2812,
	/* char values 0x039_ */
	0x281b, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	/* char values 0x03a_ */
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x2826, 0x282e, 0x2836, 0x283e, 0x2846, 0x284e,
	/* char values 0x03b_ */
	0x2857, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	/* char values 0x03c_ */
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x2862, 0x286a, 0x2872, 0x287a, 0x2882, 0x0000,
	/* char values 0x03d_ */
	0x0000, 0x0000, 0x0000, 0x288a, 0x2892, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	/* char table 0x04__ */
	0x0240, 0x0250, 0x0000, 0x0260, 0x0000, 0x0270, 0x0000, 0x0280,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0290, 0x02a0, 0x02b0, 0x02c0,
	/* char values 0x040_ */
	0x0000, 0x289a, 0x0000, 0x28a2, 0x0000, 0x0000, 0x0000, 0x28aa,
	0x0000, 0x0000, 0x0000, 0x0000, 0x28b2, 0x0000, 0x28ba, 0x0000,
	/* char values 0x041_ */
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x28c2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	/* char values 0x043_ */
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x28ca, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	/* char values 0x045_ */
	0x0000, 0x28d2, 0x0000, 0x28da, 0x0000, 0x0000, 0x0000, 0x28e2,
	0x0000, 0x0000, 0x0000, 0x0000, 0x28ea, 0x0000, 0x28f2, 0x0000,
	/* char values 0x047_ */
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x28fa, 0x2902,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	/* char values 0x04c_ */
	0x0000, 0x290a, 0x2912, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	/* char values 0x04d_ */
	0x291a, 0x2922, 0x292a, 0x2932, 0x2939, 0x293d, 0x2942, 0x294a,
	0x2951, 0x2955, 0x295a, 0x2962, 0x296a, 0x2972, 0x297a, 0x2982,
	/* char values 0x04e_ */
	0x2989, 0x298d, 0x2992, 0x299a, 0x29a2, 0x29aa, 0x29b2, 0x29ba,
	0x29c1, 0x29c5, 0x29ca, 0x29d2, 0x0000, 0x0000, 0x29da, 0x29e2,
	/* char values 0x04f_ */
	0x29ea, 0x29f2, 0x29fa, 0x2a02, 0x2a0a, 0x2a12, 0x0000, 0x0000,
	0x2a1a, 0x2a22, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	/* char table 0x09__ */
	0x0000, 0x0000, 0x02e0, 0x02f0, 0x0000, 0x0300, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0310, 0x0320, 0x0330, 0x0000, 0x0000,
	/* char values 0x092_ */
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x2a2a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	/* char values 0x093_ */
	0x0000, 0x2a32, 0x0000, 0x0000, 0x2a3a, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	/* char values 0x095_ */
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x2a42, 0x2a4a, 0x2a52, 0x2a5a, 0x2a62, 0x2a6a, 0x2a72, 0x2a7a,
	/* char values 0x09b_ */
	0x2a82, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	/* char values 0x09c_ */
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x2a8a, 0x2a92, 0x0000, 0x0000, 0x0000,
	/* char values 0x09d_ */
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x2a9a, 0x2aa2, 0x0000, 0x2aaa,
	/* char table 0x0a__ */
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0350, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	/* char values 0x0a5_ */
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x2ab2, 0x2aba, 0x2ac2, 0x2aca, 0x0000, 0x2ad2, 0x0000,
	/* char table 0x0b__ */
	0x0000, 0x0000, 0x0000, 0x0000, 0x0370, 0x0380, 0x0000, 0x0000,
	0x0000, 0x0390, 0x0000, 0x0000, 0x03a0, 0x0000, 0x0000, 0x0000,
	/* char values 0x0b4_ */
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x2ada, 0x0000, 0x0000, 0x2ae2, 0x2aea, 0x0000, 0x0000, 0x0000,
	/* char values 0x0b5_ */
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x2af2, 0x2afa, 0x0000, 0x2b02,
	/* char values 0x0b9_ */
	0x0000, 0x0000, 0x0000, 0x0000, 0x2b0a, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	/* char values 0x0bc_ */
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x2b12, 0x2b1a, 0x2b22, 0x0000, 0x0000, 0x0000,
	/* char table 0x0c__ */
	0x0000, 0x0000, 0x0000, 0x0000, 0x03c0, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x03d0, 0x0000, 0x0000, 0x0000,
	/* char values 0x0c4_ */
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x2b2a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	/* char values 0x0cc_ */
	0x2b32, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2b3a,
	0x2b42, 0x0000, 0x2b4a, 0x2b53, 0x0000, 0x0000, 0x0000, 0x0000,
	/* char table 0x0d__ */
	0x0000, 0x0000, 0x0000, 0x0000, 0x03f0, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	/* char values 0x0d4_ */
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x2b5e, 0x2b66, 0x2b6e, 0x0000, 0x0000, 0x0000,
	/* char table 0x0e__ */
	0x0000, 0x0000, 0x0000, 0x0410, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0420, 0x0000, 0x0000, 0x0000, 0x0000,
	/* char values 0x0e3_ */
	0x0000, 0x0000, 0x0000, 0x2b76, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	/* char values 0x0eb_ */
	0x0000, 0x0000, 0x0000, 0x2b7e, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	/* char table 0x0f__ */
	0x0000, 0x0000, 0x0000, 0x0000, 0x0440, 0x0450, 0x0460, 0x0470,
	0x0480, 0x0490, 0x04a0, 0x04b0, 0x0000, 0x0000, 0x0000, 0x0000,
	/* char values 0x0f4_ */
	0x0000, 0x0000, 0x0000, 0x2b86, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2b8e, 0x0000, 0x0000,
	/* char values 0x0f5_ */
	0x0000, 0x0000, 0x2b96, 0x0000, 0x0000, 0x0000, 0x0000, 0x2b9e,
	0x0000, 0x0000, 0x0000, 0x0000, 0x2ba6, 0x0000, 0x0000, 0x0000,
	/* char values 0x0f6_ */
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x2bae, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	/* char values 0x0f7_ */
	0x0000, 0x0000, 0x0000, 0x2bb6, 0x0000, 0x2bbe, 0x2bc6, 0x2bcf,
	0x2bda, 0x2be3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	/* char values 0x0f8_ */
	0x0000, 0x2bee, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	/* char values 0x0f9_ */
	0x0000, 0x0000, 0x0000, 0x2bf6, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2bfe, 0x0000, 0x0000,
	/* char values 0x0fa_ */
	0x0000, 0x0000, 0x2c06, 0x0000, 0x0000, 0x0000, 0x0000, 0x2c0e,
	0x0000, 0x0000, 0x0000, 0x0000, 0x2c16, 0x0000, 0x0000, 0x0000,
	/* char values 0x0fb_ */
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x2c1e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	/* char table 0x1___ */
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x04d0, 0x05e0,
	/* char table 0x1e__ */
	0x04e0, 0x04f0, 0x0500, 0x0510, 0x0520, 0x0530, 0x0540, 0x0550,
	0x0560, 0x0570, 0x0580, 0x0590, 0x05a0, 0x05b0, 0x05c0, 0x05d0,
	/* char values 0x1e0_ */
	0x2c26, 0x2c2e, 0x2c36, 0x2c3e, 0x2c46, 0x2c4e, 0x2c56, 0x2c5e,
	0x2c67, 0x2c73, 0x2c7e, 0x2c86, 0x2c8e, 0x2c96, 0x2c9e, 0x2ca6,
	/* char values 0x1e1_ */
	0x2cae, 0x2cb6, 0x2cbe, 0x2cc6, 0x2ccf, 0x2cdb, 0x2ce7, 0x2cf3,
	0x2cfe, 0x2d06, 0x2d0e, 0x2d16, 0x2d1f, 0x2d2b, 0x2d36, 0x2d3e,
	/* char values 0x1e2_ */
	0x2d46, 0x2d4e, 0x2d56, 0x2d5e, 0x2d66, 0x2d6e, 0x2d76, 0x2d7e,
	0x2d86, 0x2d8e, 0x2d96, 0x2d9e, 0x2da6, 0x2dae, 0x2db7, 0x2dc3,
	/* char values 0x1e3_ */
	0x2dce, 0x2dd6, 0x2dde, 0x2de6, 0x2dee, 0x2df6, 0x2dfe, 0x2e06,
	0x2e0f, 0x2e1b, 0x2e26, 0x2e2e, 0x2e36, 0x2e3e, 0x2e46, 0x2e4e,
	/* char values 0x1e4_ */
	0x2e56, 0x2e5e, 0x2e66, 0x2e6e, 0x2e76, 0x2e7e, 0x2e86, 0x2e8e,
	0x2e96, 0x2e9e, 0x2ea6, 0x2eae, 0x2eb7, 0x2ec3, 0x2ecf, 0x2edb,
	/* char values 0x1e5_ */
	0x2ee7, 0x2ef3, 0x2eff, 0x2f0b, 0x2f16, 0x2f1e, 0x2f26, 0x2f2e,
	0x2f36, 0x2f3e, 0x2f46, 0x2f4e, 0x2f57, 0x2f63, 0x2f6e, 0x2f76,
	/* char values 0x1e6_ */
	0x2f7e, 0x2f86, 0x2f8e, 0x2f96, 0x2f9f, 0x2fab, 0x2fb7, 0x2fc3,
	0x2fcf, 0x2fdb, 0x2fe6, 0x2fee, 0x2ff6, 0x2ffe, 0x3006, 0x300e,
	/* char values 0x1e7_ */
	0x3016, 0x301e, 0x3026, 0x302e, 0x3036, 0x303e, 0x3046, 0x304e,
	0x3057, 0x3063, 0x306f, 0x307b, 0x3086, 0x308e, 0x3096, 0x309e,
	/* char values 0x1e8_ */
	0x30a6, 0x30ae, 0x30b6, 0x30be, 0x30c6, 0x30ce, 0x30d6, 0x30de,
	0x30e6, 0x30ee, 0x30f6, 0x30fe, 0x3106, 0x310e, 0x3116, 0x311e,
	/* char values 0x1e9_ */
	0x3126, 0x312e, 0x3136, 0x313e, 0x3146, 0x314e, 0x3156, 0x315e,
	0x3166, 0x316e, 0x0000, 0x3176, 0x0000, 0x0000, 0x0000, 0x0000,
	/* char values 0x1ea_ */
	0x317e, 0x3186, 0x318e, 0x3196, 0x319f, 0x31ab, 0x31b7, 0x31c3,
	0x31cf, 0x31db, 0x31e7, 0x31f3, 0x31ff, 0x320b, 0x3217, 0x3223,
	/* char values 0x1eb_ */
	0x322f, 0x323b, 0x3247, 0x3253, 0x325f, 0x326b, 0x3277, 0x3283,
	0x328e, 0x3296, 0x329e, 0x32a6, 0x32ae, 0x32b6, 0x32bf, 0x32cb,
	/* char values 0x1ec_ */
	0x32d7, 0x32e3, 0x32ef, 0x32fb, 0x3307, 0x3313, 0x331f, 0x332b,
	0x3336, 0x333e, 0x3346, 0x334e, 0x3356, 0x335e, 0x3366, 0x336e,
	/* char values 0x1ed_ */
	0x3377, 0x3383, 0x338f, 0x339b, 0x33a7, 0x33b3, 0x33bf, 0x33cb,
	0x33d7, 0x33e3, 0x33ef, 0x33fb, 0x3407, 0x3413, 0x341f, 0x342b,
	/* char values 0x1ee_ */
	0x3437, 0x3443, 0x344f, 0x345b, 0x3466, 0x346e, 0x3476, 0x347e,
	0x3487, 0x3493, 0x349f, 0x34ab, 0x34b7, 0x34c3, 0x34cf, 0x34db,
	/* char values 0x1ef_ */
	0x34e7, 0x34f3, 0x34fe, 0x3506, 0x350e, 0x3516, 0x351e, 0x3526,
	0x352e, 0x3536, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	/* char table 0x1f__ */
	0x05f0, 0x0600, 0x0610, 0x0620, 0x0630, 0x0640, 0x0650, 0x0660,
	0x0670, 0x0680, 0x0690, 0x06a0, 0x06b0, 0x06c0, 0x06d0, 0x06e0,
	/* char values 0x1f0_ */
	0x353e, 0x3546, 0x354f, 0x355b, 0x3567, 0x3573, 0x357f, 0x358b,
	0x3596, 0x359e, 0x35a7, 0x35b3, 0x35bf, 0x35cb, 0x35d7, 0x35e3,
	/* char values 0x1f1_ */
	0x35ee, 0x35f6, 0x35ff, 0x360b, 0x3617, 0x3623, 0x0000, 0x0000,
	0x362e, 0x3636, 0x363f, 0x364b, 0x3657, 0x3663, 0x0000, 0x0000,
	/* char values 0x1f2_ */
	0x366e, 0x3676, 0x367f, 0x368b, 0x3697, 0x36a3, 0x36af, 0x36bb,
	0x36c6, 0x36ce, 0x36d7, 0x36e3, 0x36ef, 0x36fb, 0x3707, 0x3713,
	/* char values 0x1f3_ */
	0x371e, 0x3726, 0x372f, 0x373b, 0x3747, 0x3753, 0x375f, 0x376b,
	0x3776, 0x377e, 0x3787, 0x3793, 0x379f, 0x37ab, 0x37b7, 0x37c3,
	/* char values 0x1f4_ */
	0x37ce, 0x37d6, 0x37df, 0x37eb, 0x37f7, 0x3803, 0x0000, 0x0000,
	0x380e, 0x3816, 0x381f, 0x382b, 0x3837, 0x3843, 0x0000, 0x0000,
	/* char values 0x1f5_ */
	0x384e, 0x3856, 0x385f, 0x386b, 0x3877, 0x3883, 0x388f, 0x389b,
	0x0000, 0x38a6, 0x0000, 0x38af, 0x0000, 0x38bb, 0x0000, 0x38c7,
	/* char values 0x1f6_ */
	0x38d2, 0x38da, 0x38e3, 0x38ef, 0x38fb, 0x3907, 0x3913, 0x391f,
	0x392a, 0x3932, 0x393b, 0x3947, 0x3953, 0x395f, 0x396b, 0x3977,
	/* char values 0x1f7_ */
	0x3982, 0x398a, 0x3992, 0x399a, 0x39a2, 0x39aa, 0x39b2, 0x39ba,
	0x39c2, 0x39ca, 0x39d2, 0x39da, 0x39e2, 0x39ea, 0x0000, 0x0000,
	/* char values 0x1f8_ */
	0x39f3, 0x39ff, 0x3a0c, 0x3a1c, 0x3a2c, 0x3a3c, 0x3a4c, 0x3a5c,
	0x3a6b, 0x3a77, 0x3a84, 0x3a94, 0x3aa4, 0x3ab4, 0x3ac4, 0x3ad4,
	/* char values 0x1f9_ */
	0x3ae3, 0x3aef, 0x3afc, 0x3b0c, 0x3b1c, 0x3b2c, 0x3b3c, 0x3b4c,
	0x3b5b, 0x3b67, 0x3b74, 0x3b84, 0x3b94, 0x3ba4, 0x3bb4, 0x3bc4,
	/* char values 0x1fa_ */
	0x3bd3, 0x3bdf, 0x3bec, 0x3bfc, 0x3c0c, 0x3c1c, 0x3c2c, 0x3c3c,
	0x3c4b, 0x3c57, 0x3c64, 0x3c74, 0x3c84, 0x3c94, 0x3ca4, 0x3cb4,
	/* char values 0x1fb_ */
	0x3cc2, 0x3cca, 0x3cd3, 0x3cde, 0x3ce7, 0x0000, 0x3cf2, 0x3cfb,
	0x3d06, 0x3d0e, 0x3d16, 0x3d1e, 0x3d26, 0x0000, 0x3d2d, 0x0000,
	/* char values 0x1fc_ */
	0x0000, 0x3d32, 0x3d3b, 0x3d46, 0x3d4f, 0x0000, 0x3d5a, 0x3d63,
	0x3d6e, 0x3d76, 0x3d7e, 0x3d86, 0x3d8e, 0x3d96, 0x3d9e, 0x3da6,
	/* char values 0x1fd_ */
	0x3dae, 0x3db6, 0x3dbf, 0x3dcb, 0x0000, 0x0000, 0x3dd6, 0x3ddf,
	0x3dea, 0x3df2, 0x3dfa, 0x3e02, 0x0000, 0x3e0a, 0x3e12, 0x3e1a,
	/* char values 0x1fe_ */
	0x3e22, 0x3e2a, 0x3e33, 0x3e3f, 0x3e4a, 0x3e52, 0x3e5a, 0x3e63,
	0x3e6e, 0x3e76, 0x3e7e, 0x3e86, 0x3e8e, 0x3e96, 0x3e9e, 0x3ea5,
	/* char values 0x1ff_ */
	0x0000, 0x0000, 0x3eab, 0x3eb6, 0x3ebf, 0x0000, 0x3eca, 0x3ed3,
	0x3ede, 0x3ee6, 0x3eee, 0x3ef6, 0x3efe, 0x3f05, 0x0000, 0x0000,
	/* char table 0x3___ */
	0x0700, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	/* char table 0x30__ */
	0x0000, 0x0000, 0x0000, 0x0000, 0x0710, 0x0720, 0x0730, 0x0740,
	0x0000, 0x0750, 0x0760, 0x0770, 0x0780, 0x0790, 0x0000, 0x07a0,
	/* char values 0x304_ */
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x3f0a, 0x0000, 0x3f12, 0x0000,
	/* char values 0x305_ */
	0x3f1a, 0x0000, 0x3f22, 0x0000, 0x3f2a, 0x0000, 0x3f32, 0x0000,
	0x3f3a, 0x0000, 0x3f42, 0x0000, 0x3f4a, 0x0000, 0x3f52, 0x0000,
	/* char values 0x306_ */
	0x3f5a, 0x0000, 0x3f62, 0x0000, 0x0000, 0x3f6a, 0x0000, 0x3f72,
	0x0000, 0x3f7a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	/* char values 0x307_ */
	0x3f82, 0x3f8a, 0x0000, 0x3f92, 0x3f9a, 0x0000, 0x3fa2, 0x3faa,
	0x0000, 0x3fb2, 0x3fba, 0x0000, 0x3fc2, 0x3fca, 0x0000, 0x0000,
	/* char values 0x309_ */
	0x0000, 0x0000, 0x0000, 0x0000, 0x3fd2, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3fda, 0x0000,
	/* char values 0x30a_ */
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x3fe2, 0x0000, 0x3fea, 0x0000,
	/* char values 0x30b_ */
	0x3ff2, 0x0000, 0x3ffa, 0x0000, 0x4002, 0x0000, 0x400a, 0x0000,
	0x4012, 0x0000, 0x401a, 0x0000, 0x4022, 0x0000, 0x402a, 0x0000,
	/* char values 0x30c_ */
	0x4032, 0x0000, 0x403a, 0x0000, 0x0000, 0x4042, 0x0000, 0x404a,
	0x0000, 0x4052, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	/* char values 0x30d_ */
	0x405a, 0x4062, 0x0000, 0x406a, 0x4072, 0x0000, 0x407a, 0x4082,
	0x0000, 0x408a, 0x4092, 0x0000, 0x409a, 0x40a2, 0x0000, 0x0000,
	/* char values 0x30f_ */
	0x0000, 0x0000, 0x0000, 0x0000, 0x40aa, 0x0000, 0x0000, 0x40b2,
	0x40ba, 0x40c2, 0x40ca, 0x0000, 0x0000, 0x0000, 0x40d2, 0x0000,
	/* char table 0xf___ */
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x07c0, 0x0000, 0x0000, 0x0000, 0x0000,
	/* char table 0xfb__ */
	0x0000, 0x07d0, 0x07e0, 0x07f0, 0x0800, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	/* char values 0xfb1_ */
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x40da,
	/* char values 0xfb2_ */
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x40e2, 0x40ea, 0x40f3, 0x40ff, 0x410a, 0x4112,
	/* char values 0xfb3_ */
	0x411a, 0x4122, 0x412a, 0x4132, 0x413a, 0x4142, 0x414a, 0x0000,
	0x4152, 0x415a, 0x4162, 0x416a, 0x4172, 0x0000, 0x417a, 0x0000,
	/* char values 0xfb4_ */
	0x4182, 0x418a, 0x0000, 0x4192, 0x419a, 0x0000, 0x41a2, 0x41aa,
	0x41b2, 0x41ba, 0x41c2, 0x41ca, 0x41d2, 0x41da, 0x41e2, 0x0000,
	/* decomposed characters */
	0x0041, 0x0300, 0x0041, 0x0301, 0x0041, 0x0302, 0x0041, 0x0303,
	0x0041, 0x0308, 0x0041, 0x030a, 0x0043, 0x0327, 0x0045, 0x0300,
	0x0045, 0x0301, 0x0045, 0x0302, 0x0045, 0x0308, 0x0049, 0x0300,
	0x0049, 0x0301, 0x0049, 0x0302, 0x0049, 0x0308, 0x004e, 0x0303,
	0x004f, 0x0300, 0x004f, 0x0301, 0x004f, 0x0302, 0x004f, 0x0303,
	0x004f, 0x0308, 0x0055, 0x0300, 0x0055, 0x0301, 0x0055, 0x0302,
	0x0055, 0x0308, 0x0059, 0x0301, 0x0061, 0x0300, 0x0061, 0x0301,
	0x0061, 0x0302, 0x0061, 0x0303, 0x0061, 0x0308, 0x0061, 0x030a,
	0x0063, 0x0327, 0x0065, 0x0300, 0x0065, 0x0301, 0x0065, 0x0302,
	0x0065, 0x0308, 0x0069, 0x0300, 0x0069, 0x0301, 0x0069, 0x0302,
	0x0069, 0x0308, 0x006e, 0x0303, 0x006f, 0x0300, 0x006f, 0x0301,
	0x006f, 0x0302, 0x006f, 0x0303, 0x006f, 0x0308, 0x0075, 0x0300,
	0x0075, 0x0301, 0x0075, 0x0302, 0x0075, 0x0308, 0x0079, 0x0301,
	0x0079, 0x0308, 0x0041, 0x0304, 0x0061, 0x0304, 0x0041, 0x0306,
	0x0061, 0x0306, 0x0041, 0x0328, 0x0061, 0x0328, 0x0043, 0x0301,
	0x0063, 0x0301, 0x0043, 0x0302, 0x0063, 0x0302, 0x0043, 0x0307,
	0x0063, 0x0307, 0x0043, 0x030c, 0x0063, 0x030c, 0x0044, 0x030c,
	0x0064, 0x030c, 0x0045, 0x0304, 0x0065, 0x0304, 0x0045, 0x0306,
	0x0065, 0x0306, 0x0045, 0x0307, 0x0065, 0x0307, 0x0045, 0x0328,
	0x0065, 0x0328, 0x0045, 0x030c, 0x0065, 0x030c, 0x0047, 0x0302,
	0x0067, 0x0302, 0x0047, 0x0306, 0x0067, 0x0306, 0x0047, 0x0307,
	0x0067, 0x0307, 0x0047, 0x0327, 0x0067, 0x0327, 0x0048, 0x0302,
	0x0068, 0x0302, 0x0049, 0x0303, 0x0069, 0x0303, 0x0049, 0x0304,
	0x0069, 0x0304, 0x0049, 0x0306, 0x0069, 0x0306, 0x0049, 0x0328,
	0x0069, 0x0328, 0x0049, 0x0307, 0x004a, 0x0302, 0x006a, 0x0302,
	0x004b, 0x0327, 0x006b, 0x0327, 0x004c, 0x0301, 0x006c, 0x0301,
	0x004c, 0x0327, 0x006c, 0x0327, 0x004c, 0x030c, 0x006c, 0x030c,
	0x004e, 0x0301, 0x006e, 0x0301, 0x004e, 0x0327, 0x006e, 0x0327,
	0x004e, 0x030c, 0x006e, 0x030c, 0x004f, 0x0304, 0x006f, 0x0304,
	0x004f, 0x0306, 0x006f, 0x0306, 0x004f, 0x030b, 0x006f, 0x030b,
	0x0052, 0x0301, 0x0072, 0x0301, 0x0052, 0x0327, 0x0072, 0x0327,
	0x0052, 0x030c, 0x0072, 0x030c, 0x0053, 0x0301, 0x0073, 0x0301,
	0x0053, 0x0302, 0x0073, 0x0302, 0x0053, 0x0327, 0x0073, 0x0327,
	0x0053, 0x030c, 0x0073, 0x030c, 0x0054, 0x0327, 0x0074, 0x0327,
	0x0054, 0x030c, 0x0074, 0x030c, 0x0055, 0x0303, 0x0075, 0x0303,
	0x0055, 0x0304, 0x0075, 0x0304, 0x0055, 0x0306, 0x0075, 0x0306,
	0x0055, 0x030a, 0x0075, 0x030a, 0x0055, 0x030b, 0x0075, 0x030b,
	0x0055, 0x0328, 0x0075, 0x0328, 0x0057, 0x0302, 0x0077, 0x0302,
	0x0059, 0x0302, 0x0079, 0x0302, 0x0059, 0x0308, 0x005a, 0x0301,
	0x007a, 0x0301, 0x005a, 0x0307, 0x007a, 0x0307, 0x005a, 0x030c,
	0x007a, 0x030c, 0x004f, 0x031b, 0x006f, 0x031b, 0x0055, 0x031b,
	0x0075, 0x031b, 0x0041, 0x030c, 0x0061, 0x030c, 0x0049, 0x030c,
	0x0069, 0x030c, 0x004f, 0x030c, 0x006f, 0x030c, 0x0055, 0x030c,
	0x0075, 0x030c, 0x0055, 0x0308, 0x0304, 0x0075, 0x0308, 0x0304,
	0x0055, 0x0308, 0x0301, 0x0075, 0x0308, 0x0301, 0x0055, 0x0308,
	0x030c, 0x0075, 0x0308, 0x030c, 0x0055, 0x0308, 0x0300, 0x0075,
	0x0308, 0x0300, 0x0041, 0x0308, 0x0304, 0x0061, 0x0308, 0x0304,
	0x0041, 0x0307, 0x0304, 0x0061, 0x0307, 0x0304, 0x00c6, 0x0304,
	0x00e6, 0x0304, 0x0047, 0x030c, 0x0067, 0x030c, 0x004b, 0x030c,
	0x006b, 0x030c, 0x004f, 0x0328, 0x006f, 0x0328, 0x004f, 0x0328,
	0x0304, 0x006f, 0x0328, 0x0304, 0x01b7, 0x030c, 0x0292, 0x030c,
	0x006a, 0x030c, 0x0047, 0x0301, 0x0067, 0x0301, 0x0041, 0x030a,
	0x0301, 0x0061, 0x030a, 0x0301, 0x00c6, 0x0301, 0x00e6, 0x0301,
	0x00d8, 0x0301, 0x00f8, 0x0301, 0x0041, 0x030f, 0x0061, 0x030f,
	0x0041, 0x0311, 0x0061, 0x0311, 0x0045, 0x030f, 0x0065, 0x030f,
	0x0045, 0x0311, 0x0065, 0x0311, 0x0049, 0x030f, 0x0069, 0x030f,
	0x0049, 0x0311, 0x0069, 0x0311, 0x004f, 0x030f, 0x006f, 0x030f,
	0x004f, 0x0311, 0x006f, 0x0311, 0x0052, 0x030f, 0x0072, 0x030f,
	0x0052, 0x0311, 0x0072, 0x0311, 0x0055, 0x030f, 0x0075, 0x030f,
	0x0055, 0x0311, 0x0075, 0x0311, 0x0306, 0x0307, 0x0300, 0x0301,
	0x0313, 0x0308, 0x030d, 0x02b9, 0x003b, 0x00a8, 0x030d, 0x0391,
	0x030d, 0x00b7, 0x0395, 0x030d, 0x0397, 0x030d, 0x0399, 0x030d,
	0x039f, 0x030d, 0x03a5, 0x030d, 0x03a9, 0x030d, 0x03b9, 0x0308,
	0x030d, 0x0399, 0x0308, 0x03a5, 0x0308, 0x03b1, 0x030d, 0x03b5,
	0x030d, 0x03b7, 0x030d, 0x03b9, 0x030d, 0x03c5, 0x0308, 0x030d,
	0x03b9, 0x0308, 0x03c5, 0x0308, 0x03bf, 0x030d, 0x03c5, 0x030d,
	0x03c9, 0x030d, 0x03d2, 0x030d, 0x03d2, 0x0308, 0x0415, 0x0308,
	0x0413, 0x0301, 0x0406, 0x0308, 0x041a, 0x0301, 0x0423, 0x0306,
	0x0418, 0x0306, 0x0438, 0x0306, 0x0435, 0x0308, 0x0433, 0x0301,
	0x0456, 0x0308, 0x043a, 0x0301, 0x0443, 0x0306, 0x0474, 0x030f,
	0x0475, 0x030f, 0x0416, 0x0306, 0x0436, 0x0306, 0x0410, 0x0306,
	0x0430, 0x0306, 0x0410, 0x0308, 0x0430, 0x0308, 0x00c6, 0x00e6,
	0x0415, 0x0306, 0x0435, 0x0306, 0x018f, 0x0259, 0x018f, 0x0308,
	0x0259, 0x0308, 0x0416, 0x0308, 0x0436, 0x0308, 0x0417, 0x0308,
	0x0437, 0x0308, 0x01b7, 0x0292, 0x0418, 0x0304, 0x0438, 0x0304,
	0x0418, 0x0308, 0x0438, 0x0308, 0x041e, 0x0308, 0x043e, 0x0308,
	0x019f, 0x0275, 0x019f, 0x0308, 0x0275, 0x0308, 0x0423, 0x0304,
	0x0443, 0x0304, 0x0423, 0x0308, 0x0443, 0x0308, 0x0423, 0x030b,
	0x0443, 0x030b, 0x0427, 0x0308, 0x0447, 0x0308, 0x042b, 0x0308,
	0x044b, 0x0308, 0x0928, 0x093c, 0x0930, 0x093c, 0x0933, 0x093c,
	0x0915, 0x093c, 0x0916, 0x093c, 0x0917, 0x093c, 0x091c, 0x093c,
	0x0921, 0x093c, 0x0922, 0x093c, 0x092b, 0x093c, 0x092f, 0x093c,
	0x09ac, 0x09bc, 0x09c7, 0x09be, 0x09c7, 0x09d7, 0x09a1, 0x09bc,
	0x09a2, 0x09bc, 0x09af, 0x09bc, 0x0a16, 0x0a3c, 0x0a17, 0x0a3c,
	0x0a1c, 0x0a3c, 0x0a21, 0x0a3c, 0x0a2b, 0x0a3c, 0x0b47, 0x0b56,
	0x0b47, 0x0b3e, 0x0b47, 0x0b57, 0x0b21, 0x0b3c, 0x0b22, 0x0b3c,
	0x0b2f, 0x0b3c, 0x0b92, 0x0bd7, 0x0bc6, 0x0bbe, 0x0bc7, 0x0bbe,
	0x0bc6, 0x0bd7, 0x0c46, 0x0c56, 0x0cbf, 0x0cd5, 0x0cc6, 0x0cd5,
	0x0cc6, 0x0cd6, 0x0cc6, 0x0cc2, 0x0cc6, 0x0cc2, 0x0cd5, 0x0d46,
	0x0d3e, 0x0d47, 0x0d3e, 0x0d46, 0x0d57, 0x0e4d, 0x0e32, 0x0ecd,
	0x0eb2, 0x0f42, 0x0fb7, 0x0f4c, 0x0fb7, 0x0f51, 0x0fb7, 0x0f56,
	0x0fb7, 0x0f5b, 0x0fb7, 0x0f40, 0x0fb5, 0x0f72, 0x0f71, 0x0f74,
	0x0f71, 0x0fb2, 0x0f80, 0x0fb2, 0x0f80, 0x0f71, 0x0fb3, 0x0f80,
	0x0fb3, 0x0f80, 0x0f71, 0x0f80, 0x0f71, 0x0f92, 0x0fb7, 0x0f9c,
	0x0fb7, 0x0fa1, 0x0fb7, 0x0fa6, 0x0fb7, 0x0fab, 0x0fb7, 0x0f90,
	0x0fb5, 0x0041, 0x0325, 0x0061, 0x0325, 0x0042, 0x0307, 0x0062,
	0x0307, 0x0042, 0x0323, 0x0062, 0x0323, 0x0042, 0x0331, 0x0062,
	0x0331, 0x0043, 0x0327, 0x0301, 0x0063, 0x0327, 0x0301, 0x0044,
	0x0307, 0x0064, 0x0307, 0x0044, 0x0323, 0x0064, 0x0323, 0x0044,
	0x0331, 0x0064, 0x0331, 0x0044, 0x0327, 0x0064, 0x0327, 0x0044,
	0x032d, 0x0064, 0x032d, 0x0045, 0x0304, 0x0300, 0x0065, 0x0304,
	0x0300, 0x0045, 0x0304, 0x0301, 0x0065, 0x0304, 0x0301, 0x0045,
	0x032d, 0x0065, 0x032d, 0x0045, 0x0330, 0x0065, 0x0330, 0x0045,
	0x0327, 0x0306, 0x0065, 0x0327, 0x0306, 0x0046, 0x0307, 0x0066,
	0x0307, 0x0047, 0x0304, 0x0067, 0x0304, 0x0048, 0x0307, 0x0068,
	0x0307, 0x0048, 0x0323, 0x0068, 0x0323, 0x0048, 0x0308, 0x0068,
	0x0308, 0x0048, 0x0327, 0x0068, 0x0327, 0x0048, 0x032e, 0x0068,
	0x032e, 0x0049, 0x0330, 0x0069, 0x0330, 0x0049, 0x0308, 0x0301,
	0x0069, 0x0308, 0x0301, 0x004b, 0x0301, 0x006b, 0x0301, 0x004b,
	0x0323, 0x006b, 0x0323, 0x004b, 0x0331, 0x006b, 0x0331, 0x004c,
	0x0323, 0x006c, 0x0323, 0x004c, 0x0323, 0x0304, 0x006c, 0x0323,
	0x0304, 0x004c, 0x0331, 0x006c, 0x0331, 0x004c, 0x032d, 0x006c,
	0x032d, 0x004d, 0x0301, 0x006d, 0x0301, 0x004d, 0x0307, 0x006d,
	0x0307, 0x004d, 0x0323, 0x006d, 0x0323, 0x004e, 0x0307, 0x006e,
	0x0307, 0x004e, 0x0323, 0x006e, 0x0323, 0x004e, 0x0331, 0x006e,
	0x0331, 0x004e, 0x032d, 0x006e, 0x032d, 0x004f, 0x0303, 0x0301,
	0x006f, 0x0303, 0x0301, 0x004f, 0x0303, 0x0308, 0x006f, 0x0303,
	0x0308, 0x004f, 0x0304, 0x0300, 0x006f, 0x0304, 0x0300, 0x004f,
	0x0304, 0x0301, 0x006f, 0x0304, 0x0301, 0x0050, 0x0301, 0x0070,
	0x0301, 0x0050, 0x0307, 0x0070, 0x0307, 0x0052, 0x0307, 0x0072,
	0x0307, 0x0052, 0x0323, 0x0072, 0x0323, 0x0052, 0x0323, 0x0304,
	0x0072, 0x0323, 0x0304, 0x0052, 0x0331, 0x0072, 0x0331, 0x0053,
	0x0307, 0x0073, 0x0307, 0x0053, 0x0323, 0x0073, 0x0323, 0x0053,
	0x0301, 0x0307, 0x0073, 0x0301, 0x0307, 0x0053, 0x030c, 0x0307,
	0x0073, 0x030c, 0x0307, 0x0053, 0x0323, 0x0307, 0x0073, 0x0323,
	0x0307, 0x0054, 0x0307, 0x0074, 0x0307, 0x0054, 0x0323, 0x0074,
	0x0323, 0x0054, 0x0331, 0x0074, 0x0331, 0x0054, 0x032d, 0x0074,
	0x032d, 0x0055, 0x0324, 0x0075, 0x0324, 0x0055, 0x0330, 0x0075,
	0x0330, 0x0055, 0x032d, 0x0075, 0x032d, 0x0055, 0x0303, 0x0301,
	0x0075, 0x0303, 0x0301, 0x0055, 0x0304, 0x0308, 0x0075, 0x0304,
	0x0308, 0x0056, 0x0303, 0x0076, 0x0303, 0x0056, 0x0323, 0x0076,
	0x0323, 0x0057, 0x0300, 0x0077, 0x0300, 0x0057, 0x0301, 0x0077,
	0x0301, 0x0057, 0x0308, 0x0077, 0x0308, 0x0057, 0x0307, 0x0077,
	0x0307, 0x0057, 0x0323, 0x0077, 0x0323, 0x0058, 0x0307, 0x0078,
	0x0307, 0x0058, 0x0308, 0x0078, 0x0308, 0x0059, 0x0307, 0x0079,
	0x0307, 0x005a, 0x0302, 0x007a, 0x0302, 0x005a, 0x0323, 0x007a,
	0x0323, 0x005a, 0x0331, 0x007a, 0x0331, 0x0068, 0x0331, 0x0074,
	0x0308, 0x0077, 0x030a, 0x0079, 0x030a, 0x017f, 0x0307, 0x0041,
	0x0323, 0x0061, 0x0323, 0x0041, 0x0309, 0x0061, 0x0309, 0x0041,
	0x0302, 0x0301, 0x0061, 0x0302, 0x0301, 0x0041, 0x0302, 0x0300,
	0x0061, 0x0302, 0x0300, 0x0041, 0x0302, 0x0309, 0x0061, 0x0302,
	0x0309, 0x0041, 0x0302, 0x0303, 0x0061, 0x0302, 0x0303, 0x0041,
	0x0323, 0x0302, 0x0061, 0x0323, 0x0302, 0x0041, 0x0306, 0x0301,
	0x0061, 0x0306, 0x0301, 0x0041, 0x0306, 0x0300, 0x0061, 0x0306,
	0x0300, 0x0041, 0x0306, 0x0309, 0x0061, 0x0306, 0x0309, 0x0041,
	0x0306, 0x0303, 0x0061, 0x0306, 0x0303, 0x0041, 0x0323, 0x0306,
	0x0061, 0x0323, 0x0306, 0x0045, 0x0323, 0x0065, 0x0323, 0x0045,
	0x0309, 0x0065, 0x0309, 0x0045, 0x0303, 0x0065, 0x0303, 0x0045,
	0x0302, 0x0301, 0x0065, 0x0302, 0x0301, 0x0045, 0x0302, 0x0300,
	0x0065, 0x0302, 0x0300, 0x0045, 0x0302, 0x0309, 0x0065, 0x0302,
	0x0309, 0x0045, 0x0302, 0x0303, 0x0065, 0x0302, 0x0303, 0x0045,
	0x0323, 0x0302, 0x0065, 0x0323, 0x0302, 0x0049, 0x0309, 0x0069,
	0x0309, 0x0049, 0x0323, 0x0069, 0x0323, 0x004f, 0x0323, 0x006f,
	0x0323, 0x004f, 0x0309, 0x006f, 0x0309, 0x004f, 0x0302, 0x0301,
	0x006f, 0x0302, 0x0301, 0x004f, 0x0302, 0x0300, 0x006f, 0x0302,
	0x0300, 0x004f, 0x0302, 0x0309, 0x006f, 0x0302, 0x0309, 0x004f,
	0x0302, 0x0303, 0x006f, 0x0302, 0x0303, 0x004f, 0x0323, 0x0302,
	0x006f, 0x0323, 0x0302, 0x004f, 0x031b, 0x0301, 0x006f, 0x031b,
	0x0301, 0x004f, 0x031b, 0x0300, 0x006f, 0x031b, 0x0300, 0x004f,
	0x031b, 0x0309, 0x006f, 0x031b, 0x0309, 0x004f, 0x031b, 0x0303,
	0x006f, 0x031b, 0x0303, 0x004f, 0x031b, 0x0323, 0x006f, 0x031b,
	0x0323, 0x0055, 0x0323, 0x0075, 0x0323, 0x0055, 0x0309, 0x0075,
	0x0309, 0x0055, 0x031b, 0x0301, 0x0075, 0x031b, 0x0301, 0x0055,
	0x031b, 0x0300, 0x0075, 0x031b, 0x0300, 0x0055, 0x031b, 0x0309,
	0x0075, 0x031b, 0x0309, 0x0055, 0x031b, 0x0303, 0x0075, 0x031b,
	0x0303, 0x0055, 0x031b, 0x0323, 0x0075, 0x031b, 0x0323, 0x0059,
	0x0300, 0x0079, 0x0300, 0x0059, 0x0323, 0x0079, 0x0323, 0x0059,
	0x0309, 0x0079, 0x0309, 0x0059, 0x0303, 0x0079, 0x0303, 0x03b1,
	0x0313, 0x03b1, 0x0314, 0x03b1, 0x0313, 0x0300, 0x03b1, 0x0314,
	0x0300, 0x03b1, 0x0313, 0x0301, 0x03b1, 0x0314, 0x0301, 0x03b1,
	0x0313, 0x0342, 0x03b1, 0x0314, 0x0342, 0x0391, 0x0313, 0x0391,
	0x0314, 0x0391, 0x0313, 0x0300, 0x0391, 0x0314, 0x0300, 0x0391,
	0x0313, 0x0301, 0x0391, 0x0314, 0x0301, 0x0391, 0x0313, 0x0342,
	0x0391, 0x0314, 0x0342, 0x03b5, 0x0313, 0x03b5, 0x0314, 0x03b5,
	0x0313, 0x0300, 0x03b5, 0x0314, 0x0300, 0x03b5, 0x0313, 0x0301,
	0x03b5, 0x0314, 0x0301, 0x0395, 0x0313, 0x0395, 0x0314, 0x0395,
	0x0313, 0x0300, 0x0395, 0x0314, 0x0300, 0x0395, 0x0313, 0x0301,
	0x0395, 0x0314, 0x0301, 0x03b7, 0x0313, 0x03b7, 0x0314, 0x03b7,
	0x0313, 0x0300, 0x03b7, 0x0314, 0x0300, 0x03b7, 0x0313, 0x0301,
	0x03b7, 0x0314, 0x0301, 0x03b7, 0x0313, 0x0342, 0x03b7, 0x0314,
	0x0342, 0x0397, 0x0313, 0x0397, 0x0314, 0x0397, 0x0313, 0x0300,
	0x0397, 0x0314, 0x0300, 0x0397, 0x0313, 0x0301, 0x0397, 0x0314,
	0x0301, 0x0397, 0x0313, 0x0342, 0x0397, 0x0314, 0x0342, 0x03b9,
	0x0313, 0x03b9, 0x0314, 0x03b9, 0x0313, 0x0300, 0x03b9, 0x0314,
	0x0300, 0x03b9, 0x0313, 0x0301, 0x03b9, 0x0314, 0x0301, 0x03b9,
	0x0313, 0x0342, 0x03b9, 0x0314, 0x0342, 0x0399, 0x0313, 0x0399,
	0x0314, 0x0399, 0x0313, 0x0300, 0x0399, 0x0314, 0x0300, 0x0399,
	0x0313, 0x0301, 0x0399, 0x0314, 0x0301, 0x0399, 0x0313, 0x0342,
	0x0399, 0x0314, 0x0342, 0x03bf, 0x0313, 0x03bf, 0x0314, 0x03bf,
	0x0313, 0x0300, 0x03bf, 0x0314, 0x0300, 0x03bf, 0x0313, 0x0301,
	0x03bf, 0x0314, 0x0301, 0x039f, 0x0313, 0x039f, 0x0314, 0x039f,
	0x0313, 0x0300, 0x039f, 0x0314, 0x0300, 0x039f, 0x0313, 0x0301,
	0x039f, 0x0314, 0x0301, 0x03c5, 0x0313, 0x03c5, 0x0314, 0x03c5,
	0x0313, 0x0300, 0x03c5, 0x0314, 0x0300, 0x03c5, 0x0313, 0x0301,
	0x03c5, 0x0314, 0x0301, 0x03c5, 0x0313, 0x0342, 0x03c5, 0x0314,
	0x0342, 0x03a5, 0x0314, 0x03a5, 0x0314, 0x0300, 0x03a5, 0x0314,
	0x0301, 0x03a5, 0x0314, 0x0342, 0x03c9, 0x0313, 0x03c9, 0x0314,
	0x03c9, 0x0313, 0x0300, 0x03c9, 0x0314, 0x0300, 0x03c9, 0x0313,
	0x0301, 0x03c9, 0x0314, 0x0301, 0x03c9, 0x0313, 0x0342, 0x03c9,
	0x0314, 0x0342, 0x03a9, 0x0313, 0x03a9, 0x0314, 0x03a9, 0x0313,
	0x0300, 0x03a9, 0x0314, 0x0300, 0x03a9, 0x0313, 0x0301, 0x03a9,
	0x0314, 0x0301, 0x03a9, 0x0313, 0x0342, 0x03a9, 0x0314, 0x0342,
	0x03b1, 0x0300, 0x03b1, 0x0301, 0x03b5, 0x0300, 0x03b5, 0x0301,
	0x03b7, 0x0300, 0x03b7, 0x0301, 0x03b9, 0x0300, 0x03b9, 0x0301,
	0x03bf, 0x0300, 0x03bf, 0x0301, 0x03c5, 0x0300, 0x03c5, 0x0301,
	0x03c9, 0x0300, 0x03c9, 0x0301, 0x03b1, 0x0345, 0x0313, 0x03b1,
	0x0345, 0x0314, 0x03b1, 0x0345, 0x0313, 0x0300, 0x03b1, 0x0345,
	0x0314, 0x0300, 0x03b1, 0x0345, 0x0313, 0x0301, 0x03b1, 0x0345,
	0x0314, 0x0301, 0x03b1, 0x0345, 0x0313, 0x0342, 0x03b1, 0x0345,
	0x0314, 0x0342, 0x0391, 0x0345, 0x0313, 0x0391, 0x0345, 0x0314,
	0x0391, 0x0345, 0x0313, 0x0300, 0x0391, 0x0345, 0x0314, 0x0300,
	0x0391, 0x0345, 0x0313, 0x0301, 0x0391, 0x0345, 0x0314, 0x0301,
	0x0391, 0x0345, 0x0313, 0x0342, 0x0391, 0x0345, 0x0314, 0x0342,
	0x03b7, 0x0345, 0x0313, 0x03b7, 0x0345, 0x0314, 0x03b7, 0x0345,
	0x0313, 0x0300, 0x03b7, 0x0345, 0x0314, 0x0300, 0x03b7, 0x0345,
	0x0313, 0x0301, 0x03b7, 0x0345, 0x0314, 0x0301, 0x03b7, 0x0345,
	0x0313, 0x0342, 0x03b7, 0x0345, 0x0314, 0x0342, 0x0397, 0x0345,
	0x0313, 0x0397, 0x0345, 0x0314, 0x0397, 0x0345, 0x0313, 0x0300,
	0x0397, 0x0345, 0x0314, 0x0300, 0x0397, 0x0345, 0x0313, 0x0301,
	0x0397, 0x0345, 0x0314, 0x0301, 0x0397, 0x0345, 0x0313, 0x0342,
	0x0397, 0x0345, 0x0314, 0x0342, 0x03c9, 0x0345, 0x0313, 0x03c9,
	0x0345, 0x0314, 0x03c9, 0x0345, 0x0313, 0x0300, 0x03c9, 0x0345,
	0x0314, 0x0300, 0x03c9, 0x0345, 0x0313, 0x0301, 0x03c9, 0x0345,
	0x0314, 0x0301, 0x03c9, 0x0345, 0x0313, 0x0342, 0x03c9, 0x0345,
	0x0314, 0x0342, 0x03a9, 0x0345, 0x0313, 0x03a9, 0x0345, 0x0314,
	0x03a9, 0x0345, 0x0313, 0x0300, 0x03a9, 0x0345, 0x0314, 0x0300,
	0x03a9, 0x0345, 0x0313, 0x0301, 0x03a9, 0x0345, 0x0314, 0x0301,
	0x03a9, 0x0345, 0x0313, 0x0342, 0x03a9, 0x0345, 0x0314, 0x0342,
	0x03b1, 0x0306, 0x03b1, 0x0304, 0x03b1, 0x0345, 0x0300, 0x03b1,
	0x0345, 0x03b1, 0x0345, 0x0301, 0x03b1, 0x0342, 0x03b1, 0x0345,
	0x0342, 0x0391, 0x0306, 0x0391, 0x0304, 0x0391, 0x0300, 0x0391,
	0x0301, 0x0391, 0x0345, 0x03b9, 0x00a8, 0x0342, 0x03b7, 0x0345,
	0x0300, 0x03b7, 0x0345, 0x03b7, 0x0345, 0x0301, 0x03b7, 0x0342,
	0x03b7, 0x0345, 0x0342, 0x0395, 0x0300, 0x0395, 0x0301, 0x0397,
	0x0300, 0x0397, 0x0301, 0x0397, 0x0345, 0x1fbf, 0x0300, 0x1fbf,
	0x0301, 0x1fbf, 0x0342, 0x03b9, 0x0306, 0x03b9, 0x0304, 0x03b9,
	0x0308, 0x0300, 0x03b9, 0x0308, 0x0301, 0x03b9, 0x0342, 0x03b9,
	0x0308, 0x0342, 0x0399, 0x0306, 0x0399, 0x0304, 0x0399, 0x0300,
	0x0399, 0x0301, 0x1ffe, 0x0300, 0x1ffe, 0x0301, 0x1ffe, 0x0342,
	0x03c5, 0x0306, 0x03c5, 0x0304, 0x03c5, 0x0308, 0x0300, 0x03c5,
	0x0308, 0x0301, 0x03c1, 0x0313, 0x03c1, 0x0314, 0x03c5, 0x0342,
	0x03c5, 0x0308, 0x0342, 0x03a5, 0x0306, 0x03a5, 0x0304, 0x03a5,
	0x0300, 0x03a5, 0x0301, 0x03a1, 0x0314, 0x00a8, 0x0300, 0x00a8,
	0x0301, 0x0060, 0x03c9, 0x0345, 0x0300, 0x03c9, 0x0345, 0x03bf,
	0x0345, 0x0301, 0x03c9, 0x0342, 0x03c9, 0x0345, 0x0342, 0x039f,
	0x0300, 0x039f, 0x0301, 0x03a9, 0x0300, 0x03a9, 0x0301, 0x03a9,
	0x0345, 0x00b4, 0x304b, 0x3099, 0x304d, 0x3099, 0x304f, 0x3099,
	0x3051, 0x3099, 0x3053, 0x3099, 0x3055, 0x3099, 0x3057, 0x3099,
	0x3059, 0x3099, 0x305b, 0x3099, 0x305d, 0x3099, 0x305f, 0x3099,
	0x3061, 0x3099, 0x3064, 0x3099, 0x3066, 0x3099, 0x3068, 0x3099,
	0x306f, 0x3099, 0x306f, 0x309a, 0x3072, 0x3099, 0x3072, 0x309a,
	0x3075, 0x3099, 0x3075, 0x309a, 0x3078, 0x3099, 0x3078, 0x309a,
	0x307b, 0x3099, 0x307b, 0x309a, 0x3046, 0x3099, 0x309d, 0x3099,
	0x30ab, 0x3099, 0x30ad, 0x3099, 0x30af, 0x3099, 0x30b1, 0x3099,
	0x30b3, 0x3099, 0x30b5, 0x3099, 0x30b7, 0x3099, 0x30b9, 0x3099,
	0x30bb, 0x3099, 0x30bd, 0x3099, 0x30bf, 0x3099, 0x30c1, 0x3099,
	0x30c4, 0x3099, 0x30c6, 0x3099, 0x30c8, 0x3099, 0x30cf, 0x3099,
	0x30cf, 0x309a, 0x30d2, 0x3099, 0x30d2, 0x309a, 0x30d5, 0x3099,
	0x30d5, 0x309a, 0x30d8, 0x3099, 0x30d8, 0x309a, 0x30db, 0x3099,
	0x30db, 0x309a, 0x30a6, 0x3099, 0x30ef, 0x3099, 0x30f0, 0x3099,
	0x30f1, 0x3099, 0x30f2, 0x3099, 0x30fd, 0x3099, 0x05f2, 0x05b7,
	0x05e9, 0x05c1, 0x05e9, 0x05c2, 0x05e9, 0x05bc, 0x05c1, 0x05e9,
	0x05bc, 0x05c2, 0x05d0, 0x05b7, 0x05d0, 0x05b8, 0x05d0, 0x05bc,
	0x05d1, 0x05bc, 0x05d2, 0x05bc, 0x05d3, 0x05bc, 0x05d4, 0x05bc,
	0x05d5, 0x05bc, 0x05d6, 0x05bc, 0x05d8, 0x05bc, 0x05d9, 0x05bc,
	0x05da, 0x05bc, 0x05db, 0x05bc, 0x05dc, 0x05bc, 0x05de, 0x05bc,
	0x05e0, 0x05bc, 0x05e1, 0x05bc, 0x05e3, 0x05bc, 0x05e4, 0x05bc,
	0x05e6, 0x05bc, 0x05e7, 0x05bc, 0x05e8, 0x05bc, 0x05e9, 0x05bc,
	0x05ea, 0x05bc, 0x05d5, 0x05b9, 0x05d1, 0x05bf, 0x05db, 0x05bf,
	0x05e4, 0x05bf
};

u16 hfsplus_compose_table[] = {
	/* base */
	0x0000, 0x0050,  0x0300, 0x00a4,  0x0301, 0x00e4,  0x0302, 0x015c,
	0x0303, 0x0192,  0x0304, 0x01b4,  0x0306, 0x01e6,  0x0307, 0x0220,
	0x0308, 0x0270,  0x0309, 0x02d2,  0x030a, 0x02ec,  0x030b, 0x02fa,
	0x030c, 0x0308,  0x030d, 0x034c,  0x030f, 0x0370,  0x0311, 0x038e,
	0x0313, 0x03a8,  0x0314, 0x03c6,  0x031b, 0x03e8,  0x0323, 0x03f2,
	0x0324, 0x0440,  0x0325, 0x0446,  0x0327, 0x044c,  0x0328, 0x047a,
	0x032d, 0x0490,  0x032e, 0x04aa,  0x0330, 0x04b0,  0x0331, 0x04be,
	0x0342, 0x04e2,  0x0345, 0x04f4,  0x05b7, 0x0504,  0x05b8, 0x050a,
	0x05b9, 0x050e,  0x05bc, 0x0512,  0x05bf, 0x0540,  0x05c1, 0x0548,
	0x05c2, 0x054c,  0x093c, 0x0550,  0x09bc, 0x0568,  0x09be, 0x0572,
	0x09d7, 0x0576,  0x0a3c, 0x057a,  0x0b3c, 0x0586,  0x0b3e, 0x058e,
	0x0b56, 0x0592,  0x0b57, 0x0596,  0x0bbe, 0x059a,  0x0bd7, 0x05a0,
	0x0c56, 0x05a6,  0x0cc2, 0x05aa,  0x0cd5, 0x05ae,  0x0cd6, 0x05b4,
	0x0d3e, 0x05b8,  0x0d57, 0x05be,  0x0e32, 0x05c2,  0x0eb2, 0x05c6,
	0x0f71, 0x05ca,  0x0f80, 0x05d2,  0x0fb5, 0x05d8,  0x0fb7, 0x05de,
	0x1100, 0x00a2,  0x1101, 0x00a2,  0x1102, 0x00a2,  0x1103, 0x00a2,
	0x1104, 0x00a2,  0x1105, 0x00a2,  0x1106, 0x00a2,  0x1107, 0x00a2,
	0x1108, 0x00a2,  0x1109, 0x00a2,  0x110a, 0x00a2,  0x110b, 0x00a2,
	0x110c, 0x00a2,  0x110d, 0x00a2,  0x110e, 0x00a2,  0x110f, 0x00a2,
	0x1110, 0x00a2,  0x1111, 0x00a2,  0x1112, 0x00a2,  0x3099, 0x05f4,
	0x309a, 0x0656,
	/* hangul marker */
	0xffff, 0x0000,
	/* 0x0300 */
	0x0340, 0x001f,  0x0041, 0x066c,  0x0045, 0x066e,  0x0049, 0x0670,
	0x004f, 0x0672,  0x0055, 0x0674,  0x0057, 0x0676,  0x0059, 0x0678,
	0x0061, 0x067a,  0x0065, 0x067c,  0x0069, 0x067e,  0x006f, 0x0680,
	0x0075, 0x0682,  0x0077, 0x0684,  0x0079, 0x0686,  0x00a8, 0x0688,
	0x0391, 0x068a,  0x0395, 0x068c,  0x0397, 0x068e,  0x0399, 0x0690,
	0x039f, 0x0692,  0x03a5, 0x0694,  0x03a9, 0x0696,  0x03b1, 0x0698,
	0x03b5, 0x069a,  0x03b7, 0x069c,  0x03b9, 0x069e,  0x03bf, 0x06a0,
	0x03c5, 0x06a2,  0x03c9, 0x06a4,  0x1fbf, 0x06a6,  0x1ffe, 0x06a8,
	/* 0x0301 */
	0x0341, 0x003b,  0x0041, 0x06aa,  0x0043, 0x06ac,  0x0045, 0x06ae,
	0x0047, 0x06b0,  0x0049, 0x06b2,  0x004b, 0x06b4,  0x004c, 0x06b6,
	0x004d, 0x06b8,  0x004e, 0x06ba,  0x004f, 0x06bc,  0x0050, 0x06be,
	0x0052, 0x06c0,  0x0053, 0x06c2,  0x0055, 0x06c6,  0x0057, 0x06c8,
	0x0059, 0x06ca,  0x005a, 0x06cc,  0x0061, 0x06ce,  0x0063, 0x06d0,
	0x0065, 0x06d2,  0x0067, 0x06d4,  0x0069, 0x06d6,  0x006b, 0x06d8,
	0x006c, 0x06da,  0x006d, 0x06dc,  0x006e, 0x06de,  0x006f, 0x06e0,
	0x0070, 0x06e2,  0x0072, 0x06e4,  0x0073, 0x06e6,  0x0075, 0x06ea,
	0x0077, 0x06ec,  0x0079, 0x06ee,  0x007a, 0x06f0,  0x00a8, 0x06f2,
	0x00c6, 0x06f4,  0x00d8, 0x06f6,  0x00e6, 0x06f8,  0x00f8, 0x06fa,
	0x0391, 0x06fc,  0x0395, 0x06fe,  0x0397, 0x0700,  0x0399, 0x0702,
	0x039f, 0x0704,  0x03a5, 0x0706,  0x03a9, 0x0708,  0x03b1, 0x070a,
	0x03b5, 0x070c,  0x03b7, 0x070e,  0x03b9, 0x0710,  0x03bf, 0x0712,
	0x03c5, 0x0714,  0x03c9, 0x0716,  0x0413, 0x0718,  0x041a, 0x071a,
	0x0433, 0x071c,  0x043a, 0x071e,  0x1fbf, 0x0720,  0x1ffe, 0x0722,
	/* 0x0302 */
	0x0000, 0x001a,  0x0041, 0x0724,  0x0043, 0x072e,  0x0045, 0x0730,
	0x0047, 0x073a,  0x0048, 0x073c,  0x0049, 0x073e,  0x004a, 0x0740,
	0x004f, 0x0742,  0x0053, 0x074c,  0x0055, 0x074e,  0x0057, 0x0750,
	0x0059, 0x0752,  0x005a, 0x0754,  0x0061, 0x0756,  0x0063, 0x0760,
	0x0065, 0x0762,  0x0067, 0x076c,  0x0068, 0x076e,  0x0069, 0x0770,
	0x006a, 0x0772,  0x006f, 0x0774,  0x0073, 0x077e,  0x0075, 0x0780,
	0x0077, 0x0782,  0x0079, 0x0784,  0x007a, 0x0786,
	/* 0x0303 */
	0x0000, 0x0010,  0x0041, 0x0788,  0x0045, 0x078a,  0x0049, 0x078c,
	0x004e, 0x078e,  0x004f, 0x0790,  0x0055, 0x0796,  0x0056, 0x079a,
	0x0059, 0x079c,  0x0061, 0x079e,  0x0065, 0x07a0,  0x0069, 0x07a2,
	0x006e, 0x07a4,  0x006f, 0x07a6,  0x0075, 0x07ac,  0x0076, 0x07b0,
	0x0079, 0x07b2,
	/* 0x0304 */
	0x0000, 0x0018,  0x0041, 0x07b4,  0x0045, 0x07b6,  0x0047, 0x07bc,
	0x0049, 0x07be,  0x004f, 0x07c0,  0x0055, 0x07c6,  0x0061, 0x07ca,
	0x0065, 0x07cc,  0x0067, 0x07d2,  0x0069, 0x07d4,  0x006f, 0x07d6,
	0x0075, 0x07dc,  0x00c6, 0x07e0,  0x00e6, 0x07e2,  0x0391, 0x07e4,
	0x0399, 0x07e6,  0x03a5, 0x07e8,  0x03b1, 0x07ea,  0x03b9, 0x07ec,
	0x03c5, 0x07ee,  0x0418, 0x07f0,  0x0423, 0x07f2,  0x0438, 0x07f4,
	0x0443, 0x07f6,
	/* 0x0306 */
	0x0000, 0x001c,  0x0041, 0x07f8,  0x0045, 0x0802,  0x0047, 0x0804,
	0x0049, 0x0806,  0x004f, 0x0808,  0x0055, 0x080a,  0x0061, 0x080c,
	0x0065, 0x0816,  0x0067, 0x0818,  0x0069, 0x081a,  0x006f, 0x081c,
	0x0075, 0x081e,  0x0391, 0x0820,  0x0399, 0x0822,  0x03a5, 0x0824,
	0x03b1, 0x0826,  0x03b9, 0x0828,  0x03c5, 0x082a,  0x0410, 0x082c,
	0x0415, 0x082e,  0x0416, 0x0830,  0x0418, 0x0832,  0x0423, 0x0834,
	0x0430, 0x0836,  0x0435, 0x0838,  0x0436, 0x083a,  0x0438, 0x083c,
	0x0443, 0x083e,
	/* 0x0307 */
	0x0000, 0x0027,  0x0041, 0x0840,  0x0042, 0x0844,  0x0043, 0x0846,
	0x0044, 0x0848,  0x0045, 0x084a,  0x0046, 0x084c,  0x0047, 0x084e,
	0x0048, 0x0850,  0x0049, 0x0852,  0x004d, 0x0854,  0x004e, 0x0856,
	0x0050, 0x0858,  0x0052, 0x085a,  0x0053, 0x085c,  0x0054, 0x085e,
	0x0057, 0x0860,  0x0058, 0x0862,  0x0059, 0x0864,  0x005a, 0x0866,
	0x0061, 0x0868,  0x0062, 0x086c,  0x0063, 0x086e,  0x0064, 0x0870,
	0x0065, 0x0872,  0x0066, 0x0874,  0x0067, 0x0876,  0x0068, 0x0878,
	0x006d, 0x087a,  0x006e, 0x087c,  0x0070, 0x087e,  0x0072, 0x0880,
	0x0073, 0x0882,  0x0074, 0x0884,  0x0077, 0x0886,  0x0078, 0x0888,
	0x0079, 0x088a,  0x007a, 0x088c,  0x017f, 0x088e,  0x0306, 0x0890,
	/* 0x0308 */
	0x0000, 0x0030,  0x0041, 0x0892,  0x0045, 0x0896,  0x0048, 0x0898,
	0x0049, 0x089a,  0x004f, 0x089e,  0x0055, 0x08a0,  0x0057, 0x08aa,
	0x0058, 0x08ac,  0x0059, 0x08ae,  0x0061, 0x08b0,  0x0065, 0x08b4,
	0x0068, 0x08b6,  0x0069, 0x08b8,  0x006f, 0x08bc,  0x0074, 0x08be,
	0x0075, 0x08c0,  0x0077, 0x08ca,  0x0078, 0x08cc,  0x0079, 0x08ce,
	0x018f, 0x08d0,  0x019f, 0x08d2,  0x0259, 0x08d4,  0x0275, 0x08d6,
	0x0399, 0x08d8,  0x03a5, 0x08da,  0x03b9, 0x08dc,  0x03c5, 0x08e6,
	0x03d2, 0x08f0,  0x0406, 0x08f2,  0x0410, 0x08f4,  0x0415, 0x08f6,
	0x0416, 0x08f8,  0x0417, 0x08fa,  0x0418, 0x08fc,  0x041e, 0x08fe,
	0x0423, 0x0900,  0x0427, 0x0902,  0x042b, 0x0904,  0x0430, 0x0906,
	0x0435, 0x0908,  0x0436, 0x090a,  0x0437, 0x090c,  0x0438, 0x090e,
	0x043e, 0x0910,  0x0443, 0x0912,  0x0447, 0x0914,  0x044b, 0x0916,
	0x0456, 0x0918,
	/* 0x0309 */
	0x0000, 0x000c,  0x0041, 0x091a,  0x0045, 0x091c,  0x0049, 0x091e,
	0x004f, 0x0920,  0x0055, 0x0922,  0x0059, 0x0924,  0x0061, 0x0926,
	0x0065, 0x0928,  0x0069, 0x092a,  0x006f, 0x092c,  0x0075, 0x092e,
	0x0079, 0x0930,
	/* 0x030a */
	0x0000, 0x0006,  0x0041, 0x0932,  0x0055, 0x0936,  0x0061, 0x0938,
	0x0075, 0x093c,  0x0077, 0x093e,  0x0079, 0x0940,
	/* 0x030b */
	0x0000, 0x0006,  0x004f, 0x0942,  0x0055, 0x0944,  0x006f, 0x0946,
	0x0075, 0x0948,  0x0423, 0x094a,  0x0443, 0x094c,
	/* 0x030c */
	0x0000, 0x0021,  0x0041, 0x094e,  0x0043, 0x0950,  0x0044, 0x0952,
	0x0045, 0x0954,  0x0047, 0x0956,  0x0049, 0x0958,  0x004b, 0x095a,
	0x004c, 0x095c,  0x004e, 0x095e,  0x004f, 0x0960,  0x0052, 0x0962,
	0x0053, 0x0964,  0x0054, 0x0968,  0x0055, 0x096a,  0x005a, 0x096c,
	0x0061, 0x096e,  0x0063, 0x0970,  0x0064, 0x0972,  0x0065, 0x0974,
	0x0067, 0x0976,  0x0069, 0x0978,  0x006a, 0x097a,  0x006b, 0x097c,
	0x006c, 0x097e,  0x006e, 0x0980,  0x006f, 0x0982,  0x0072, 0x0984,
	0x0073, 0x0986,  0x0074, 0x098a,  0x0075, 0x098c,  0x007a, 0x098e,
	0x01b7, 0x0990,  0x0292, 0x0992,
	/* 0x030d */
	0x0000, 0x0011,  0x00a8, 0x0994,  0x0308, 0x0996,  0x0391, 0x0998,
	0x0395, 0x099a,  0x0397, 0x099c,  0x0399, 0x099e,  0x039f, 0x09a0,
	0x03a5, 0x09a2,  0x03a9, 0x09a4,  0x03b1, 0x09a6,  0x03b5, 0x09a8,
	0x03b7, 0x09aa,  0x03b9, 0x09ac,  0x03bf, 0x09ae,  0x03c5, 0x09b0,
	0x03c9, 0x09b2,  0x03d2, 0x09b4,
	/* 0x030f */
	0x0000, 0x000e,  0x0041, 0x09b6,  0x0045, 0x09b8,  0x0049, 0x09ba,
	0x004f, 0x09bc,  0x0052, 0x09be,  0x0055, 0x09c0,  0x0061, 0x09c2,
	0x0065, 0x09c4,  0x0069, 0x09c6,  0x006f, 0x09c8,  0x0072, 0x09ca,
	0x0075, 0x09cc,  0x0474, 0x09ce,  0x0475, 0x09d0,
	/* 0x0311 */
	0x0000, 0x000c,  0x0041, 0x09d2,  0x0045, 0x09d4,  0x0049, 0x09d6,
	0x004f, 0x09d8,  0x0052, 0x09da,  0x0055, 0x09dc,  0x0061, 0x09de,
	0x0065, 0x09e0,  0x0069, 0x09e2,  0x006f, 0x09e4,  0x0072, 0x09e6,
	0x0075, 0x09e8,
	/* 0x0313 */
	0x0343, 0x000e,  0x0391, 0x09ea,  0x0395, 0x09f2,  0x0397, 0x09f8,
	0x0399, 0x0a00,  0x039f, 0x0a08,  0x03a9, 0x0a0e,  0x03b1, 0x0a16,
	0x03b5, 0x0a1e,  0x03b7, 0x0a24,  0x03b9, 0x0a2c,  0x03bf, 0x0a34,
	0x03c1, 0x0a3a,  0x03c5, 0x0a3c,  0x03c9, 0x0a44,
	/* 0x0314 */
	0x0000, 0x0010,  0x0391, 0x0a4c,  0x0395, 0x0a54,  0x0397, 0x0a5a,
	0x0399, 0x0a62,  0x039f, 0x0a6a,  0x03a1, 0x0a70,  0x03a5, 0x0a72,
	0x03a9, 0x0a7a,  0x03b1, 0x0a82,  0x03b5, 0x0a8a,  0x03b7, 0x0a90,
	0x03b9, 0x0a98,  0x03bf, 0x0aa0,  0x03c1, 0x0aa6,  0x03c5, 0x0aa8,
	0x03c9, 0x0ab0,
	/* 0x031b */
	0x0000, 0x0004,  0x004f, 0x0ab8,  0x0055, 0x0ac4,  0x006f, 0x0ad0,
	0x0075, 0x0adc,
	/* 0x0323 */
	0x0000, 0x0026,  0x0041, 0x0ae8,  0x0042, 0x0aee,  0x0044, 0x0af0,
	0x0045, 0x0af2,  0x0048, 0x0af6,  0x0049, 0x0af8,  0x004b, 0x0afa,
	0x004c, 0x0afc,  0x004d, 0x0b00,  0x004e, 0x0b02,  0x004f, 0x0b04,
	0x0052, 0x0b08,  0x0053, 0x0b0c,  0x0054, 0x0b10,  0x0055, 0x0b12,
	0x0056, 0x0b14,  0x0057, 0x0b16,  0x0059, 0x0b18,  0x005a, 0x0b1a,
	0x0061, 0x0b1c,  0x0062, 0x0b22,  0x0064, 0x0b24,  0x0065, 0x0b26,
	0x0068, 0x0b2a,  0x0069, 0x0b2c,  0x006b, 0x0b2e,  0x006c, 0x0b30,
	0x006d, 0x0b34,  0x006e, 0x0b36,  0x006f, 0x0b38,  0x0072, 0x0b3c,
	0x0073, 0x0b40,  0x0074, 0x0b44,  0x0075, 0x0b46,  0x0076, 0x0b48,
	0x0077, 0x0b4a,  0x0079, 0x0b4c,  0x007a, 0x0b4e,
	/* 0x0324 */
	0x0000, 0x0002,  0x0055, 0x0b50,  0x0075, 0x0b52,
	/* 0x0325 */
	0x0000, 0x0002,  0x0041, 0x0b54,  0x0061, 0x0b56,
	/* 0x0327 */
	0x0000, 0x0016,  0x0043, 0x0b58,  0x0044, 0x0b5c,  0x0045, 0x0b5e,
	0x0047, 0x0b62,  0x0048, 0x0b64,  0x004b, 0x0b66,  0x004c, 0x0b68,
	0x004e, 0x0b6a,  0x0052, 0x0b6c,  0x0053, 0x0b6e,  0x0054, 0x0b70,
	0x0063, 0x0b72,  0x0064, 0x0b76,  0x0065, 0x0b78,  0x0067, 0x0b7c,
	0x0068, 0x0b7e,  0x006b, 0x0b80,  0x006c, 0x0b82,  0x006e, 0x0b84,
	0x0072, 0x0b86,  0x0073, 0x0b88,  0x0074, 0x0b8a,
	/* 0x0328 */
	0x0000, 0x000a,  0x0041, 0x0b8c,  0x0045, 0x0b8e,  0x0049, 0x0b90,
	0x004f, 0x0b92,  0x0055, 0x0b96,  0x0061, 0x0b98,  0x0065, 0x0b9a,
	0x0069, 0x0b9c,  0x006f, 0x0b9e,  0x0075, 0x0ba2,
	/* 0x032d */
	0x0000, 0x000c,  0x0044, 0x0ba4,  0x0045, 0x0ba6,  0x004c, 0x0ba8,
	0x004e, 0x0baa,  0x0054, 0x0bac,  0x0055, 0x0bae,  0x0064, 0x0bb0,
	0x0065, 0x0bb2,  0x006c, 0x0bb4,  0x006e, 0x0bb6,  0x0074, 0x0bb8,
	0x0075, 0x0bba,
	/* 0x032e */
	0x0000, 0x0002,  0x0048, 0x0bbc,  0x0068, 0x0bbe,
	/* 0x0330 */
	0x0000, 0x0006,  0x0045, 0x0bc0,  0x0049, 0x0bc2,  0x0055, 0x0bc4,
	0x0065, 0x0bc6,  0x0069, 0x0bc8,  0x0075, 0x0bca,
	/* 0x0331 */
	0x0000, 0x0011,  0x0042, 0x0bcc,  0x0044, 0x0bce,  0x004b, 0x0bd0,
	0x004c, 0x0bd2,  0x004e, 0x0bd4,  0x0052, 0x0bd6,  0x0054, 0x0bd8,
	0x005a, 0x0bda,  0x0062, 0x0bdc,  0x0064, 0x0bde,  0x0068, 0x0be0,
	0x006b, 0x0be2,  0x006c, 0x0be4,  0x006e, 0x0be6,  0x0072, 0x0be8,
	0x0074, 0x0bea,  0x007a, 0x0bec,
	/* 0x0342 */
	0x0000, 0x0008,  0x00a8, 0x0bee,  0x03b1, 0x0bf0,  0x03b7, 0x0bf2,
	0x03b9, 0x0bf4,  0x03c5, 0x0bf6,  0x03c9, 0x0bf8,  0x1fbf, 0x0bfa,
	0x1ffe, 0x0bfc,
	/* 0x0345 */
	0x0000, 0x0007,  0x0391, 0x0bfe,  0x0397, 0x0c04,  0x03a9, 0x0c0a,
	0x03b1, 0x0c10,  0x03b7, 0x0c1c,  0x03bf, 0x0c28,  0x03c9, 0x0c2c,
	/* 0x05b7 */
	0x0000, 0x0002,  0x05d0, 0x0c36,  0x05f2, 0x0c38,
	/* 0x05b8 */
	0x0000, 0x0001,  0x05d0, 0x0c3a,
	/* 0x05b9 */
	0x0000, 0x0001,  0x05d5, 0x0c3c,
	/* 0x05bc */
	0x0000, 0x0016,  0x05d0, 0x0c3e,  0x05d1, 0x0c40,  0x05d2, 0x0c42,
	0x05d3, 0x0c44,  0x05d4, 0x0c46,  0x05d5, 0x0c48,  0x05d6, 0x0c4a,
	0x05d8, 0x0c4c,  0x05d9, 0x0c4e,  0x05da, 0x0c50,  0x05db, 0x0c52,
	0x05dc, 0x0c54,  0x05de, 0x0c56,  0x05e0, 0x0c58,  0x05e1, 0x0c5a,
	0x05e3, 0x0c5c,  0x05e4, 0x0c5e,  0x05e6, 0x0c60,  0x05e7, 0x0c62,
	0x05e8, 0x0c64,  0x05e9, 0x0c66,  0x05ea, 0x0c6c,
	/* 0x05bf */
	0x0000, 0x0003,  0x05d1, 0x0c6e,  0x05db, 0x0c70,  0x05e4, 0x0c72,
	/* 0x05c1 */
	0x0000, 0x0001,  0x05e9, 0x0c74,
	/* 0x05c2 */
	0x0000, 0x0001,  0x05e9, 0x0c76,
	/* 0x093c */
	0x0000, 0x000b,  0x0915, 0x0c78,  0x0916, 0x0c7a,  0x0917, 0x0c7c,
	0x091c, 0x0c7e,  0x0921, 0x0c80,  0x0922, 0x0c82,  0x0928, 0x0c84,
	0x092b, 0x0c86,  0x092f, 0x0c88,  0x0930, 0x0c8a,  0x0933, 0x0c8c,
	/* 0x09bc */
	0x0000, 0x0004,  0x09a1, 0x0c8e,  0x09a2, 0x0c90,  0x09ac, 0x0c92,
	0x09af, 0x0c94,
	/* 0x09be */
	0x0000, 0x0001,  0x09c7, 0x0c96,
	/* 0x09d7 */
	0x0000, 0x0001,  0x09c7, 0x0c98,
	/* 0x0a3c */
	0x0000, 0x0005,  0x0a16, 0x0c9a,  0x0a17, 0x0c9c,  0x0a1c, 0x0c9e,
	0x0a21, 0x0ca0,  0x0a2b, 0x0ca2,
	/* 0x0b3c */
	0x0000, 0x0003,  0x0b21, 0x0ca4,  0x0b22, 0x0ca6,  0x0b2f, 0x0ca8,
	/* 0x0b3e */
	0x0000, 0x0001,  0x0b47, 0x0caa,
	/* 0x0b56 */
	0x0000, 0x0001,  0x0b47, 0x0cac,
	/* 0x0b57 */
	0x0000, 0x0001,  0x0b47, 0x0cae,
	/* 0x0bbe */
	0x0000, 0x0002,  0x0bc6, 0x0cb0,  0x0bc7, 0x0cb2,
	/* 0x0bd7 */
	0x0000, 0x0002,  0x0b92, 0x0cb4,  0x0bc6, 0x0cb6,
	/* 0x0c56 */
	0x0000, 0x0001,  0x0c46, 0x0cb8,
	/* 0x0cc2 */
	0x0000, 0x0001,  0x0cc6, 0x0cba,
	/* 0x0cd5 */
	0x0000, 0x0002,  0x0cbf, 0x0cbe,  0x0cc6, 0x0cc0,
	/* 0x0cd6 */
	0x0000, 0x0001,  0x0cc6, 0x0cc2,
	/* 0x0d3e */
	0x0000, 0x0002,  0x0d46, 0x0cc4,  0x0d47, 0x0cc6,
	/* 0x0d57 */
	0x0000, 0x0001,  0x0d46, 0x0cc8,
	/* 0x0e32 */
	0x0000, 0x0001,  0x0e4d, 0x0cca,
	/* 0x0eb2 */
	0x0000, 0x0001,  0x0ecd, 0x0ccc,
	/* 0x0f71 */
	0x0000, 0x0003,  0x0f72, 0x0cce,  0x0f74, 0x0cd0,  0x0f80, 0x0cd2,
	/* 0x0f80 */
	0x0000, 0x0002,  0x0fb2, 0x0cd4,  0x0fb3, 0x0cd8,
	/* 0x0fb5 */
	0x0000, 0x0002,  0x0f40, 0x0cdc,  0x0f90, 0x0cde,
	/* 0x0fb7 */
	0x0000, 0x000a,  0x0f42, 0x0ce0,  0x0f4c, 0x0ce2,  0x0f51, 0x0ce4,
	0x0f56, 0x0ce6,  0x0f5b, 0x0ce8,  0x0f92, 0x0cea,  0x0f9c, 0x0cec,
	0x0fa1, 0x0cee,  0x0fa6, 0x0cf0,  0x0fab, 0x0cf2,
	/* 0x3099 */
	0x0000, 0x0030,  0x3046, 0x0cf4,  0x304b, 0x0cf6,  0x304d, 0x0cf8,
	0x304f, 0x0cfa,  0x3051, 0x0cfc,  0x3053, 0x0cfe,  0x3055, 0x0d00,
	0x3057, 0x0d02,  0x3059, 0x0d04,  0x305b, 0x0d06,  0x305d, 0x0d08,
	0x305f, 0x0d0a,  0x3061, 0x0d0c,  0x3064, 0x0d0e,  0x3066, 0x0d10,
	0x3068, 0x0d12,  0x306f, 0x0d14,  0x3072, 0x0d16,  0x3075, 0x0d18,
	0x3078, 0x0d1a,  0x307b, 0x0d1c,  0x309d, 0x0d1e,  0x30a6, 0x0d20,
	0x30ab, 0x0d22,  0x30ad, 0x0d24,  0x30af, 0x0d26,  0x30b1, 0x0d28,
	0x30b3, 0x0d2a,  0x30b5, 0x0d2c,  0x30b7, 0x0d2e,  0x30b9, 0x0d30,
	0x30bb, 0x0d32,  0x30bd, 0x0d34,  0x30bf, 0x0d36,  0x30c1, 0x0d38,
	0x30c4, 0x0d3a,  0x30c6, 0x0d3c,  0x30c8, 0x0d3e,  0x30cf, 0x0d40,
	0x30d2, 0x0d42,  0x30d5, 0x0d44,  0x30d8, 0x0d46,  0x30db, 0x0d48,
	0x30ef, 0x0d4a,  0x30f0, 0x0d4c,  0x30f1, 0x0d4e,  0x30f2, 0x0d50,
	0x30fd, 0x0d52,
	/* 0x309a */
	0x0000, 0x000a,  0x306f, 0x0d54,  0x3072, 0x0d56,  0x3075, 0x0d58,
	0x3078, 0x0d5a,  0x307b, 0x0d5c,  0x30cf, 0x0d5e,  0x30d2, 0x0d60,
	0x30d5, 0x0d62,  0x30d8, 0x0d64,  0x30db, 0x0d66,
	/* 0x0041 0x0300 */
	0x00c0, 0x0000,
	/* 0x0045 0x0300 */
	0x00c8, 0x0000,
	/* 0x0049 0x0300 */
	0x00cc, 0x0000,
	/* 0x004f 0x0300 */
	0x00d2, 0x0000,
	/* 0x0055 0x0300 */
	0x00d9, 0x0000,
	/* 0x0057 0x0300 */
	0x1e80, 0x0000,
	/* 0x0059 0x0300 */
	0x1ef2, 0x0000,
	/* 0x0061 0x0300 */
	0x00e0, 0x0000,
	/* 0x0065 0x0300 */
	0x00e8, 0x0000,
	/* 0x0069 0x0300 */
	0x00ec, 0x0000,
	/* 0x006f 0x0300 */
	0x00f2, 0x0000,
	/* 0x0075 0x0300 */
	0x00f9, 0x0000,
	/* 0x0077 0x0300 */
	0x1e81, 0x0000,
	/* 0x0079 0x0300 */
	0x1ef3, 0x0000,
	/* 0x00a8 0x0300 */
	0x1fed, 0x0000,
	/* 0x0391 0x0300 */
	0x1fba, 0x0000,
	/* 0x0395 0x0300 */
	0x1fc8, 0x0000,
	/* 0x0397 0x0300 */
	0x1fca, 0x0000,
	/* 0x0399 0x0300 */
	0x1fda, 0x0000,
	/* 0x039f 0x0300 */
	0x1ff8, 0x0000,
	/* 0x03a5 0x0300 */
	0x1fea, 0x0000,
	/* 0x03a9 0x0300 */
	0x1ffa, 0x0000,
	/* 0x03b1 0x0300 */
	0x1f70, 0x0000,
	/* 0x03b5 0x0300 */
	0x1f72, 0x0000,
	/* 0x03b7 0x0300 */
	0x1f74, 0x0000,
	/* 0x03b9 0x0300 */
	0x1f76, 0x0000,
	/* 0x03bf 0x0300 */
	0x1f78, 0x0000,
	/* 0x03c5 0x0300 */
	0x1f7a, 0x0000,
	/* 0x03c9 0x0300 */
	0x1f7c, 0x0000,
	/* 0x1fbf 0x0300 */
	0x1fcd, 0x0000,
	/* 0x1ffe 0x0300 */
	0x1fdd, 0x0000,
	/* 0x0041 0x0301 */
	0x00c1, 0x0000,
	/* 0x0043 0x0301 */
	0x0106, 0x0000,
	/* 0x0045 0x0301 */
	0x00c9, 0x0000,
	/* 0x0047 0x0301 */
	0x01f4, 0x0000,
	/* 0x0049 0x0301 */
	0x00cd, 0x0000,
	/* 0x004b 0x0301 */
	0x1e30, 0x0000,
	/* 0x004c 0x0301 */
	0x0139, 0x0000,
	/* 0x004d 0x0301 */
	0x1e3e, 0x0000,
	/* 0x004e 0x0301 */
	0x0143, 0x0000,
	/* 0x004f 0x0301 */
	0x00d3, 0x0000,
	/* 0x0050 0x0301 */
	0x1e54, 0x0000,
	/* 0x0052 0x0301 */
	0x0154, 0x0000,
	/* 0x0053 0x0301 */
	0x015a, 0x0001,  0x0307, 0x0d68,
	/* 0x0055 0x0301 */
	0x00da, 0x0000,
	/* 0x0057 0x0301 */
	0x1e82, 0x0000,
	/* 0x0059 0x0301 */
	0x00dd, 0x0000,
	/* 0x005a 0x0301 */
	0x0179, 0x0000,
	/* 0x0061 0x0301 */
	0x00e1, 0x0000,
	/* 0x0063 0x0301 */
	0x0107, 0x0000,
	/* 0x0065 0x0301 */
	0x00e9, 0x0000,
	/* 0x0067 0x0301 */
	0x01f5, 0x0000,
	/* 0x0069 0x0301 */
	0x00ed, 0x0000,
	/* 0x006b 0x0301 */
	0x1e31, 0x0000,
	/* 0x006c 0x0301 */
	0x013a, 0x0000,
	/* 0x006d 0x0301 */
	0x1e3f, 0x0000,
	/* 0x006e 0x0301 */
	0x0144, 0x0000,
	/* 0x006f 0x0301 */
	0x00f3, 0x0000,
	/* 0x0070 0x0301 */
	0x1e55, 0x0000,
	/* 0x0072 0x0301 */
	0x0155, 0x0000,
	/* 0x0073 0x0301 */
	0x015b, 0x0001,  0x0307, 0x0d6a,
	/* 0x0075 0x0301 */
	0x00fa, 0x0000,
	/* 0x0077 0x0301 */
	0x1e83, 0x0000,
	/* 0x0079 0x0301 */
	0x00fd, 0x0000,
	/* 0x007a 0x0301 */
	0x017a, 0x0000,
	/* 0x00a8 0x0301 */
	0x1fee, 0x0000,
	/* 0x00c6 0x0301 */
	0x01fc, 0x0000,
	/* 0x00d8 0x0301 */
	0x01fe, 0x0000,
	/* 0x00e6 0x0301 */
	0x01fd, 0x0000,
	/* 0x00f8 0x0301 */
	0x01ff, 0x0000,
	/* 0x0391 0x0301 */
	0x1fbb, 0x0000,
	/* 0x0395 0x0301 */
	0x1fc9, 0x0000,
	/* 0x0397 0x0301 */
	0x1fcb, 0x0000,
	/* 0x0399 0x0301 */
	0x1fdb, 0x0000,
	/* 0x039f 0x0301 */
	0x1ff9, 0x0000,
	/* 0x03a5 0x0301 */
	0x1feb, 0x0000,
	/* 0x03a9 0x0301 */
	0x1ffb, 0x0000,
	/* 0x03b1 0x0301 */
	0x1f71, 0x0000,
	/* 0x03b5 0x0301 */
	0x1f73, 0x0000,
	/* 0x03b7 0x0301 */
	0x1f75, 0x0000,
	/* 0x03b9 0x0301 */
	0x1f77, 0x0000,
	/* 0x03bf 0x0301 */
	0x1f79, 0x0000,
	/* 0x03c5 0x0301 */
	0x1f7b, 0x0000,
	/* 0x03c9 0x0301 */
	0x1f7d, 0x0000,
	/* 0x0413 0x0301 */
	0x0403, 0x0000,
	/* 0x041a 0x0301 */
	0x040c, 0x0000,
	/* 0x0433 0x0301 */
	0x0453, 0x0000,
	/* 0x043a 0x0301 */
	0x045c, 0x0000,
	/* 0x1fbf 0x0301 */
	0x1fce, 0x0000,
	/* 0x1ffe 0x0301 */
	0x1fde, 0x0000,
	/* 0x0041 0x0302 */
	0x00c2, 0x0004,  0x0300, 0x0d6c,  0x0301, 0x0d6e,  0x0303, 0x0d70,
	0x0309, 0x0d72,
	/* 0x0043 0x0302 */
	0x0108, 0x0000,
	/* 0x0045 0x0302 */
	0x00ca, 0x0004,  0x0300, 0x0d74,  0x0301, 0x0d76,  0x0303, 0x0d78,
	0x0309, 0x0d7a,
	/* 0x0047 0x0302 */
	0x011c, 0x0000,
	/* 0x0048 0x0302 */
	0x0124, 0x0000,
	/* 0x0049 0x0302 */
	0x00ce, 0x0000,
	/* 0x004a 0x0302 */
	0x0134, 0x0000,
	/* 0x004f 0x0302 */
	0x00d4, 0x0004,  0x0300, 0x0d7c,  0x0301, 0x0d7e,  0x0303, 0x0d80,
	0x0309, 0x0d82,
	/* 0x0053 0x0302 */
	0x015c, 0x0000,
	/* 0x0055 0x0302 */
	0x00db, 0x0000,
	/* 0x0057 0x0302 */
	0x0174, 0x0000,
	/* 0x0059 0x0302 */
	0x0176, 0x0000,
	/* 0x005a 0x0302 */
	0x1e90, 0x0000,
	/* 0x0061 0x0302 */
	0x00e2, 0x0004,  0x0300, 0x0d84,  0x0301, 0x0d86,  0x0303, 0x0d88,
	0x0309, 0x0d8a,
	/* 0x0063 0x0302 */
	0x0109, 0x0000,
	/* 0x0065 0x0302 */
	0x00ea, 0x0004,  0x0300, 0x0d8c,  0x0301, 0x0d8e,  0x0303, 0x0d90,
	0x0309, 0x0d92,
	/* 0x0067 0x0302 */
	0x011d, 0x0000,
	/* 0x0068 0x0302 */
	0x0125, 0x0000,
	/* 0x0069 0x0302 */
	0x00ee, 0x0000,
	/* 0x006a 0x0302 */
	0x0135, 0x0000,
	/* 0x006f 0x0302 */
	0x00f4, 0x0004,  0x0300, 0x0d94,  0x0301, 0x0d96,  0x0303, 0x0d98,
	0x0309, 0x0d9a,
	/* 0x0073 0x0302 */
	0x015d, 0x0000,
	/* 0x0075 0x0302 */
	0x00fb, 0x0000,
	/* 0x0077 0x0302 */
	0x0175, 0x0000,
	/* 0x0079 0x0302 */
	0x0177, 0x0000,
	/* 0x007a 0x0302 */
	0x1e91, 0x0000,
	/* 0x0041 0x0303 */
	0x00c3, 0x0000,
	/* 0x0045 0x0303 */
	0x1ebc, 0x0000,
	/* 0x0049 0x0303 */
	0x0128, 0x0000,
	/* 0x004e 0x0303 */
	0x00d1, 0x0000,
	/* 0x004f 0x0303 */
	0x00d5, 0x0002,  0x0301, 0x0d9c,  0x0308, 0x0d9e,
	/* 0x0055 0x0303 */
	0x0168, 0x0001,  0x0301, 0x0da0,
	/* 0x0056 0x0303 */
	0x1e7c, 0x0000,
	/* 0x0059 0x0303 */
	0x1ef8, 0x0000,
	/* 0x0061 0x0303 */
	0x00e3, 0x0000,
	/* 0x0065 0x0303 */
	0x1ebd, 0x0000,
	/* 0x0069 0x0303 */
	0x0129, 0x0000,
	/* 0x006e 0x0303 */
	0x00f1, 0x0000,
	/* 0x006f 0x0303 */
	0x00f5, 0x0002,  0x0301, 0x0da2,  0x0308, 0x0da4,
	/* 0x0075 0x0303 */
	0x0169, 0x0001,  0x0301, 0x0da6,
	/* 0x0076 0x0303 */
	0x1e7d, 0x0000,
	/* 0x0079 0x0303 */
	0x1ef9, 0x0000,
	/* 0x0041 0x0304 */
	0x0100, 0x0000,
	/* 0x0045 0x0304 */
	0x0112, 0x0002,  0x0300, 0x0da8,  0x0301, 0x0daa,
	/* 0x0047 0x0304 */
	0x1e20, 0x0000,
	/* 0x0049 0x0304 */
	0x012a, 0x0000,
	/* 0x004f 0x0304 */
	0x014c, 0x0002,  0x0300, 0x0dac,  0x0301, 0x0dae,
	/* 0x0055 0x0304 */
	0x016a, 0x0001,  0x0308, 0x0db0,
	/* 0x0061 0x0304 */
	0x0101, 0x0000,
	/* 0x0065 0x0304 */
	0x0113, 0x0002,  0x0300, 0x0db2,  0x0301, 0x0db4,
	/* 0x0067 0x0304 */
	0x1e21, 0x0000,
	/* 0x0069 0x0304 */
	0x012b, 0x0000,
	/* 0x006f 0x0304 */
	0x014d, 0x0002,  0x0300, 0x0db6,  0x0301, 0x0db8,
	/* 0x0075 0x0304 */
	0x016b, 0x0001,  0x0308, 0x0dba,
	/* 0x00c6 0x0304 */
	0x01e2, 0x0000,
	/* 0x00e6 0x0304 */
	0x01e3, 0x0000,
	/* 0x0391 0x0304 */
	0x1fb9, 0x0000,
	/* 0x0399 0x0304 */
	0x1fd9, 0x0000,
	/* 0x03a5 0x0304 */
	0x1fe9, 0x0000,
	/* 0x03b1 0x0304 */
	0x1fb1, 0x0000,
	/* 0x03b9 0x0304 */
	0x1fd1, 0x0000,
	/* 0x03c5 0x0304 */
	0x1fe1, 0x0000,
	/* 0x0418 0x0304 */
	0x04e2, 0x0000,
	/* 0x0423 0x0304 */
	0x04ee, 0x0000,
	/* 0x0438 0x0304 */
	0x04e3, 0x0000,
	/* 0x0443 0x0304 */
	0x04ef, 0x0000,
	/* 0x0041 0x0306 */
	0x0102, 0x0004,  0x0300, 0x0dbc,  0x0301, 0x0dbe,  0x0303, 0x0dc0,
	0x0309, 0x0dc2,
	/* 0x0045 0x0306 */
	0x0114, 0x0000,
	/* 0x0047 0x0306 */
	0x011e, 0x0000,
	/* 0x0049 0x0306 */
	0x012c, 0x0000,
	/* 0x004f 0x0306 */
	0x014e, 0x0000,
	/* 0x0055 0x0306 */
	0x016c, 0x0000,
	/* 0x0061 0x0306 */
	0x0103, 0x0004,  0x0300, 0x0dc4,  0x0301, 0x0dc6,  0x0303, 0x0dc8,
	0x0309, 0x0dca,
	/* 0x0065 0x0306 */
	0x0115, 0x0000,
	/* 0x0067 0x0306 */
	0x011f, 0x0000,
	/* 0x0069 0x0306 */
	0x012d, 0x0000,
	/* 0x006f 0x0306 */
	0x014f, 0x0000,
	/* 0x0075 0x0306 */
	0x016d, 0x0000,
	/* 0x0391 0x0306 */
	0x1fb8, 0x0000,
	/* 0x0399 0x0306 */
	0x1fd8, 0x0000,
	/* 0x03a5 0x0306 */
	0x1fe8, 0x0000,
	/* 0x03b1 0x0306 */
	0x1fb0, 0x0000,
	/* 0x03b9 0x0306 */
	0x1fd0, 0x0000,
	/* 0x03c5 0x0306 */
	0x1fe0, 0x0000,
	/* 0x0410 0x0306 */
	0x04d0, 0x0000,
	/* 0x0415 0x0306 */
	0x04d6, 0x0000,
	/* 0x0416 0x0306 */
	0x04c1, 0x0000,
	/* 0x0418 0x0306 */
	0x0419, 0x0000,
	/* 0x0423 0x0306 */
	0x040e, 0x0000,
	/* 0x0430 0x0306 */
	0x04d1, 0x0000,
	/* 0x0435 0x0306 */
	0x04d7, 0x0000,
	/* 0x0436 0x0306 */
	0x04c2, 0x0000,
	/* 0x0438 0x0306 */
	0x0439, 0x0000,
	/* 0x0443 0x0306 */
	0x045e, 0x0000,
	/* 0x0041 0x0307 */
	0x0000, 0x0001,  0x0304, 0x0dcc,
	/* 0x0042 0x0307 */
	0x1e02, 0x0000,
	/* 0x0043 0x0307 */
	0x010a, 0x0000,
	/* 0x0044 0x0307 */
	0x1e0a, 0x0000,
	/* 0x0045 0x0307 */
	0x0116, 0x0000,
	/* 0x0046 0x0307 */
	0x1e1e, 0x0000,
	/* 0x0047 0x0307 */
	0x0120, 0x0000,
	/* 0x0048 0x0307 */
	0x1e22, 0x0000,
	/* 0x0049 0x0307 */
	0x0130, 0x0000,
	/* 0x004d 0x0307 */
	0x1e40, 0x0000,
	/* 0x004e 0x0307 */
	0x1e44, 0x0000,
	/* 0x0050 0x0307 */
	0x1e56, 0x0000,
	/* 0x0052 0x0307 */
	0x1e58, 0x0000,
	/* 0x0053 0x0307 */
	0x1e60, 0x0000,
	/* 0x0054 0x0307 */
	0x1e6a, 0x0000,
	/* 0x0057 0x0307 */
	0x1e86, 0x0000,
	/* 0x0058 0x0307 */
	0x1e8a, 0x0000,
	/* 0x0059 0x0307 */
	0x1e8e, 0x0000,
	/* 0x005a 0x0307 */
	0x017b, 0x0000,
	/* 0x0061 0x0307 */
	0x0000, 0x0001,  0x0304, 0x0dce,
	/* 0x0062 0x0307 */
	0x1e03, 0x0000,
	/* 0x0063 0x0307 */
	0x010b, 0x0000,
	/* 0x0064 0x0307 */
	0x1e0b, 0x0000,
	/* 0x0065 0x0307 */
	0x0117, 0x0000,
	/* 0x0066 0x0307 */
	0x1e1f, 0x0000,
	/* 0x0067 0x0307 */
	0x0121, 0x0000,
	/* 0x0068 0x0307 */
	0x1e23, 0x0000,
	/* 0x006d 0x0307 */
	0x1e41, 0x0000,
	/* 0x006e 0x0307 */
	0x1e45, 0x0000,
	/* 0x0070 0x0307 */
	0x1e57, 0x0000,
	/* 0x0072 0x0307 */
	0x1e59, 0x0000,
	/* 0x0073 0x0307 */
	0x1e61, 0x0000,
	/* 0x0074 0x0307 */
	0x1e6b, 0x0000,
	/* 0x0077 0x0307 */
	0x1e87, 0x0000,
	/* 0x0078 0x0307 */
	0x1e8b, 0x0000,
	/* 0x0079 0x0307 */
	0x1e8f, 0x0000,
	/* 0x007a 0x0307 */
	0x017c, 0x0000,
	/* 0x017f 0x0307 */
	0x1e9b, 0x0000,
	/* 0x0306 0x0307 */
	0x0310, 0x0000,
	/* 0x0041 0x0308 */
	0x00c4, 0x0001,  0x0304, 0x0dd0,
	/* 0x0045 0x0308 */
	0x00cb, 0x0000,
	/* 0x0048 0x0308 */
	0x1e26, 0x0000,
	/* 0x0049 0x0308 */
	0x00cf, 0x0001,  0x0301, 0x0dd2,
	/* 0x004f 0x0308 */
	0x00d6, 0x0000,
	/* 0x0055 0x0308 */
	0x00dc, 0x0004,  0x0300, 0x0dd4,  0x0301, 0x0dd6,  0x0304, 0x0dd8,
	0x030c, 0x0dda,
	/* 0x0057 0x0308 */
	0x1e84, 0x0000,
	/* 0x0058 0x0308 */
	0x1e8c, 0x0000,
	/* 0x0059 0x0308 */
	0x0178, 0x0000,
	/* 0x0061 0x0308 */
	0x00e4, 0x0001,  0x0304, 0x0ddc,
	/* 0x0065 0x0308 */
	0x00eb, 0x0000,
	/* 0x0068 0x0308 */
	0x1e27, 0x0000,
	/* 0x0069 0x0308 */
	0x00ef, 0x0001,  0x0301, 0x0dde,
	/* 0x006f 0x0308 */
	0x00f6, 0x0000,
	/* 0x0074 0x0308 */
	0x1e97, 0x0000,
	/* 0x0075 0x0308 */
	0x00fc, 0x0004,  0x0300, 0x0de0,  0x0301, 0x0de2,  0x0304, 0x0de4,
	0x030c, 0x0de6,
	/* 0x0077 0x0308 */
	0x1e85, 0x0000,
	/* 0x0078 0x0308 */
	0x1e8d, 0x0000,
	/* 0x0079 0x0308 */
	0x00ff, 0x0000,
	/* 0x018f 0x0308 */
	0x04da, 0x0000,
	/* 0x019f 0x0308 */
	0x04ea, 0x0000,
	/* 0x0259 0x0308 */
	0x04db, 0x0000,
	/* 0x0275 0x0308 */
	0x04eb, 0x0000,
	/* 0x0399 0x0308 */
	0x03aa, 0x0000,
	/* 0x03a5 0x0308 */
	0x03ab, 0x0000,
	/* 0x03b9 0x0308 */
	0x03ca, 0x0004,  0x0300, 0x0de8,  0x0301, 0x0dea,  0x030d, 0x0dec,
	0x0342, 0x0dee,
	/* 0x03c5 0x0308 */
	0x03cb, 0x0004,  0x0300, 0x0df0,  0x0301, 0x0df2,  0x030d, 0x0df4,
	0x0342, 0x0df6,
	/* 0x03d2 0x0308 */
	0x03d4, 0x0000,
	/* 0x0406 0x0308 */
	0x0407, 0x0000,
	/* 0x0410 0x0308 */
	0x04d2, 0x0000,
	/* 0x0415 0x0308 */
	0x0401, 0x0000,
	/* 0x0416 0x0308 */
	0x04dc, 0x0000,
	/* 0x0417 0x0308 */
	0x04de, 0x0000,
	/* 0x0418 0x0308 */
	0x04e4, 0x0000,
	/* 0x041e 0x0308 */
	0x04e6, 0x0000,
	/* 0x0423 0x0308 */
	0x04f0, 0x0000,
	/* 0x0427 0x0308 */
	0x04f4, 0x0000,
	/* 0x042b 0x0308 */
	0x04f8, 0x0000,
	/* 0x0430 0x0308 */
	0x04d3, 0x0000,
	/* 0x0435 0x0308 */
	0x0451, 0x0000,
	/* 0x0436 0x0308 */
	0x04dd, 0x0000,
	/* 0x0437 0x0308 */
	0x04df, 0x0000,
	/* 0x0438 0x0308 */
	0x04e5, 0x0000,
	/* 0x043e 0x0308 */
	0x04e7, 0x0000,
	/* 0x0443 0x0308 */
	0x04f1, 0x0000,
	/* 0x0447 0x0308 */
	0x04f5, 0x0000,
	/* 0x044b 0x0308 */
	0x04f9, 0x0000,
	/* 0x0456 0x0308 */
	0x0457, 0x0000,
	/* 0x0041 0x0309 */
	0x1ea2, 0x0000,
	/* 0x0045 0x0309 */
	0x1eba, 0x0000,
	/* 0x0049 0x0309 */
	0x1ec8, 0x0000,
	/* 0x004f 0x0309 */
	0x1ece, 0x0000,
	/* 0x0055 0x0309 */
	0x1ee6, 0x0000,
	/* 0x0059 0x0309 */
	0x1ef6, 0x0000,
	/* 0x0061 0x0309 */
	0x1ea3, 0x0000,
	/* 0x0065 0x0309 */
	0x1ebb, 0x0000,
	/* 0x0069 0x0309 */
	0x1ec9, 0x0000,
	/* 0x006f 0x0309 */
	0x1ecf, 0x0000,
	/* 0x0075 0x0309 */
	0x1ee7, 0x0000,
	/* 0x0079 0x0309 */
	0x1ef7, 0x0000,
	/* 0x0041 0x030a */
	0x00c5, 0x0001,  0x0301, 0x0df8,
	/* 0x0055 0x030a */
	0x016e, 0x0000,
	/* 0x0061 0x030a */
	0x00e5, 0x0001,  0x0301, 0x0dfa,
	/* 0x0075 0x030a */
	0x016f, 0x0000,
	/* 0x0077 0x030a */
	0x1e98, 0x0000,
	/* 0x0079 0x030a */
	0x1e99, 0x0000,
	/* 0x004f 0x030b */
	0x0150, 0x0000,
	/* 0x0055 0x030b */
	0x0170, 0x0000,
	/* 0x006f 0x030b */
	0x0151, 0x0000,
	/* 0x0075 0x030b */
	0x0171, 0x0000,
	/* 0x0423 0x030b */
	0x04f2, 0x0000,
	/* 0x0443 0x030b */
	0x04f3, 0x0000,
	/* 0x0041 0x030c */
	0x01cd, 0x0000,
	/* 0x0043 0x030c */
	0x010c, 0x0000,
	/* 0x0044 0x030c */
	0x010e, 0x0000,
	/* 0x0045 0x030c */
	0x011a, 0x0000,
	/* 0x0047 0x030c */
	0x01e6, 0x0000,
	/* 0x0049 0x030c */
	0x01cf, 0x0000,
	/* 0x004b 0x030c */
	0x01e8, 0x0000,
	/* 0x004c 0x030c */
	0x013d, 0x0000,
	/* 0x004e 0x030c */
	0x0147, 0x0000,
	/* 0x004f 0x030c */
	0x01d1, 0x0000,
	/* 0x0052 0x030c */
	0x0158, 0x0000,
	/* 0x0053 0x030c */
	0x0160, 0x0001,  0x0307, 0x0dfc,
	/* 0x0054 0x030c */
	0x0164, 0x0000,
	/* 0x0055 0x030c */
	0x01d3, 0x0000,
	/* 0x005a 0x030c */
	0x017d, 0x0000,
	/* 0x0061 0x030c */
	0x01ce, 0x0000,
	/* 0x0063 0x030c */
	0x010d, 0x0000,
	/* 0x0064 0x030c */
	0x010f, 0x0000,
	/* 0x0065 0x030c */
	0x011b, 0x0000,
	/* 0x0067 0x030c */
	0x01e7, 0x0000,
	/* 0x0069 0x030c */
	0x01d0, 0x0000,
	/* 0x006a 0x030c */
	0x01f0, 0x0000,
	/* 0x006b 0x030c */
	0x01e9, 0x0000,
	/* 0x006c 0x030c */
	0x013e, 0x0000,
	/* 0x006e 0x030c */
	0x0148, 0x0000,
	/* 0x006f 0x030c */
	0x01d2, 0x0000,
	/* 0x0072 0x030c */
	0x0159, 0x0000,
	/* 0x0073 0x030c */
	0x0161, 0x0001,  0x0307, 0x0dfe,
	/* 0x0074 0x030c */
	0x0165, 0x0000,
	/* 0x0075 0x030c */
	0x01d4, 0x0000,
	/* 0x007a 0x030c */
	0x017e, 0x0000,
	/* 0x01b7 0x030c */
	0x01ee, 0x0000,
	/* 0x0292 0x030c */
	0x01ef, 0x0000,
	/* 0x00a8 0x030d */
	0x0385, 0x0000,
	/* 0x0308 0x030d */
	0x0344, 0x0000,
	/* 0x0391 0x030d */
	0x0386, 0x0000,
	/* 0x0395 0x030d */
	0x0388, 0x0000,
	/* 0x0397 0x030d */
	0x0389, 0x0000,
	/* 0x0399 0x030d */
	0x038a, 0x0000,
	/* 0x039f 0x030d */
	0x038c, 0x0000,
	/* 0x03a5 0x030d */
	0x038e, 0x0000,
	/* 0x03a9 0x030d */
	0x038f, 0x0000,
	/* 0x03b1 0x030d */
	0x03ac, 0x0000,
	/* 0x03b5 0x030d */
	0x03ad, 0x0000,
	/* 0x03b7 0x030d */
	0x03ae, 0x0000,
	/* 0x03b9 0x030d */
	0x03af, 0x0000,
	/* 0x03bf 0x030d */
	0x03cc, 0x0000,
	/* 0x03c5 0x030d */
	0x03cd, 0x0000,
	/* 0x03c9 0x030d */
	0x03ce, 0x0000,
	/* 0x03d2 0x030d */
	0x03d3, 0x0000,
	/* 0x0041 0x030f */
	0x0200, 0x0000,
	/* 0x0045 0x030f */
	0x0204, 0x0000,
	/* 0x0049 0x030f */
	0x0208, 0x0000,
	/* 0x004f 0x030f */
	0x020c, 0x0000,
	/* 0x0052 0x030f */
	0x0210, 0x0000,
	/* 0x0055 0x030f */
	0x0214, 0x0000,
	/* 0x0061 0x030f */
	0x0201, 0x0000,
	/* 0x0065 0x030f */
	0x0205, 0x0000,
	/* 0x0069 0x030f */
	0x0209, 0x0000,
	/* 0x006f 0x030f */
	0x020d, 0x0000,
	/* 0x0072 0x030f */
	0x0211, 0x0000,
	/* 0x0075 0x030f */
	0x0215, 0x0000,
	/* 0x0474 0x030f */
	0x0476, 0x0000,
	/* 0x0475 0x030f */
	0x0477, 0x0000,
	/* 0x0041 0x0311 */
	0x0202, 0x0000,
	/* 0x0045 0x0311 */
	0x0206, 0x0000,
	/* 0x0049 0x0311 */
	0x020a, 0x0000,
	/* 0x004f 0x0311 */
	0x020e, 0x0000,
	/* 0x0052 0x0311 */
	0x0212, 0x0000,
	/* 0x0055 0x0311 */
	0x0216, 0x0000,
	/* 0x0061 0x0311 */
	0x0203, 0x0000,
	/* 0x0065 0x0311 */
	0x0207, 0x0000,
	/* 0x0069 0x0311 */
	0x020b, 0x0000,
	/* 0x006f 0x0311 */
	0x020f, 0x0000,
	/* 0x0072 0x0311 */
	0x0213, 0x0000,
	/* 0x0075 0x0311 */
	0x0217, 0x0000,
	/* 0x0391 0x0313 */
	0x1f08, 0x0003,  0x0300, 0x0e00,  0x0301, 0x0e02,  0x0342, 0x0e04,
	/* 0x0395 0x0313 */
	0x1f18, 0x0002,  0x0300, 0x0e06,  0x0301, 0x0e08,
	/* 0x0397 0x0313 */
	0x1f28, 0x0003,  0x0300, 0x0e0a,  0x0301, 0x0e0c,  0x0342, 0x0e0e,
	/* 0x0399 0x0313 */
	0x1f38, 0x0003,  0x0300, 0x0e10,  0x0301, 0x0e12,  0x0342, 0x0e14,
	/* 0x039f 0x0313 */
	0x1f48, 0x0002,  0x0300, 0x0e16,  0x0301, 0x0e18,
	/* 0x03a9 0x0313 */
	0x1f68, 0x0003,  0x0300, 0x0e1a,  0x0301, 0x0e1c,  0x0342, 0x0e1e,
	/* 0x03b1 0x0313 */
	0x1f00, 0x0003,  0x0300, 0x0e20,  0x0301, 0x0e22,  0x0342, 0x0e24,
	/* 0x03b5 0x0313 */
	0x1f10, 0x0002,  0x0300, 0x0e26,  0x0301, 0x0e28,
	/* 0x03b7 0x0313 */
	0x1f20, 0x0003,  0x0300, 0x0e2a,  0x0301, 0x0e2c,  0x0342, 0x0e2e,
	/* 0x03b9 0x0313 */
	0x1f30, 0x0003,  0x0300, 0x0e30,  0x0301, 0x0e32,  0x0342, 0x0e34,
	/* 0x03bf 0x0313 */
	0x1f40, 0x0002,  0x0300, 0x0e36,  0x0301, 0x0e38,
	/* 0x03c1 0x0313 */
	0x1fe4, 0x0000,
	/* 0x03c5 0x0313 */
	0x1f50, 0x0003,  0x0300, 0x0e3a,  0x0301, 0x0e3c,  0x0342, 0x0e3e,
	/* 0x03c9 0x0313 */
	0x1f60, 0x0003,  0x0300, 0x0e40,  0x0301, 0x0e42,  0x0342, 0x0e44,
	/* 0x0391 0x0314 */
	0x1f09, 0x0003,  0x0300, 0x0e46,  0x0301, 0x0e48,  0x0342, 0x0e4a,
	/* 0x0395 0x0314 */
	0x1f19, 0x0002,  0x0300, 0x0e4c,  0x0301, 0x0e4e,
	/* 0x0397 0x0314 */
	0x1f29, 0x0003,  0x0300, 0x0e50,  0x0301, 0x0e52,  0x0342, 0x0e54,
	/* 0x0399 0x0314 */
	0x1f39, 0x0003,  0x0300, 0x0e56,  0x0301, 0x0e58,  0x0342, 0x0e5a,
	/* 0x039f 0x0314 */
	0x1f49, 0x0002,  0x0300, 0x0e5c,  0x0301, 0x0e5e,
	/* 0x03a1 0x0314 */
	0x1fec, 0x0000,
	/* 0x03a5 0x0314 */
	0x1f59, 0x0003,  0x0300, 0x0e60,  0x0301, 0x0e62,  0x0342, 0x0e64,
	/* 0x03a9 0x0314 */
	0x1f69, 0x0003,  0x0300, 0x0e66,  0x0301, 0x0e68,  0x0342, 0x0e6a,
	/* 0x03b1 0x0314 */
	0x1f01, 0x0003,  0x0300, 0x0e6c,  0x0301, 0x0e6e,  0x0342, 0x0e70,
	/* 0x03b5 0x0314 */
	0x1f11, 0x0002,  0x0300, 0x0e72,  0x0301, 0x0e74,
	/* 0x03b7 0x0314 */
	0x1f21, 0x0003,  0x0300, 0x0e76,  0x0301, 0x0e78,  0x0342, 0x0e7a,
	/* 0x03b9 0x0314 */
	0x1f31, 0x0003,  0x0300, 0x0e7c,  0x0301, 0x0e7e,  0x0342, 0x0e80,
	/* 0x03bf 0x0314 */
	0x1f41, 0x0002,  0x0300, 0x0e82,  0x0301, 0x0e84,
	/* 0x03c1 0x0314 */
	0x1fe5, 0x0000,
	/* 0x03c5 0x0314 */
	0x1f51, 0x0003,  0x0300, 0x0e86,  0x0301, 0x0e88,  0x0342, 0x0e8a,
	/* 0x03c9 0x0314 */
	0x1f61, 0x0003,  0x0300, 0x0e8c,  0x0301, 0x0e8e,  0x0342, 0x0e90,
	/* 0x004f 0x031b */
	0x01a0, 0x0005,  0x0300, 0x0e92,  0x0301, 0x0e94,  0x0303, 0x0e96,
	0x0309, 0x0e98,  0x0323, 0x0e9a,
	/* 0x0055 0x031b */
	0x01af, 0x0005,  0x0300, 0x0e9c,  0x0301, 0x0e9e,  0x0303, 0x0ea0,
	0x0309, 0x0ea2,  0x0323, 0x0ea4,
	/* 0x006f 0x031b */
	0x01a1, 0x0005,  0x0300, 0x0ea6,  0x0301, 0x0ea8,  0x0303, 0x0eaa,
	0x0309, 0x0eac,  0x0323, 0x0eae,
	/* 0x0075 0x031b */
	0x01b0, 0x0005,  0x0300, 0x0eb0,  0x0301, 0x0eb2,  0x0303, 0x0eb4,
	0x0309, 0x0eb6,  0x0323, 0x0eb8,
	/* 0x0041 0x0323 */
	0x1ea0, 0x0002,  0x0302, 0x0eba,  0x0306, 0x0ebc,
	/* 0x0042 0x0323 */
	0x1e04, 0x0000,
	/* 0x0044 0x0323 */
	0x1e0c, 0x0000,
	/* 0x0045 0x0323 */
	0x1eb8, 0x0001,  0x0302, 0x0ebe,
	/* 0x0048 0x0323 */
	0x1e24, 0x0000,
	/* 0x0049 0x0323 */
	0x1eca, 0x0000,
	/* 0x004b 0x0323 */
	0x1e32, 0x0000,
	/* 0x004c 0x0323 */
	0x1e36, 0x0001,  0x0304, 0x0ec0,
	/* 0x004d 0x0323 */
	0x1e42, 0x0000,
	/* 0x004e 0x0323 */
	0x1e46, 0x0000,
	/* 0x004f 0x0323 */
	0x1ecc, 0x0001,  0x0302, 0x0ec2,
	/* 0x0052 0x0323 */
	0x1e5a, 0x0001,  0x0304, 0x0ec4,
	/* 0x0053 0x0323 */
	0x1e62, 0x0001,  0x0307, 0x0ec6,
	/* 0x0054 0x0323 */
	0x1e6c, 0x0000,
	/* 0x0055 0x0323 */
	0x1ee4, 0x0000,
	/* 0x0056 0x0323 */
	0x1e7e, 0x0000,
	/* 0x0057 0x0323 */
	0x1e88, 0x0000,
	/* 0x0059 0x0323 */
	0x1ef4, 0x0000,
	/* 0x005a 0x0323 */
	0x1e92, 0x0000,
	/* 0x0061 0x0323 */
	0x1ea1, 0x0002,  0x0302, 0x0ec8,  0x0306, 0x0eca,
	/* 0x0062 0x0323 */
	0x1e05, 0x0000,
	/* 0x0064 0x0323 */
	0x1e0d, 0x0000,
	/* 0x0065 0x0323 */
	0x1eb9, 0x0001,  0x0302, 0x0ecc,
	/* 0x0068 0x0323 */
	0x1e25, 0x0000,
	/* 0x0069 0x0323 */
	0x1ecb, 0x0000,
	/* 0x006b 0x0323 */
	0x1e33, 0x0000,
	/* 0x006c 0x0323 */
	0x1e37, 0x0001,  0x0304, 0x0ece,
	/* 0x006d 0x0323 */
	0x1e43, 0x0000,
	/* 0x006e 0x0323 */
	0x1e47, 0x0000,
	/* 0x006f 0x0323 */
	0x1ecd, 0x0001,  0x0302, 0x0ed0,
	/* 0x0072 0x0323 */
	0x1e5b, 0x0001,  0x0304, 0x0ed2,
	/* 0x0073 0x0323 */
	0x1e63, 0x0001,  0x0307, 0x0ed4,
	/* 0x0074 0x0323 */
	0x1e6d, 0x0000,
	/* 0x0075 0x0323 */
	0x1ee5, 0x0000,
	/* 0x0076 0x0323 */
	0x1e7f, 0x0000,
	/* 0x0077 0x0323 */
	0x1e89, 0x0000,
	/* 0x0079 0x0323 */
	0x1ef5, 0x0000,
	/* 0x007a 0x0323 */
	0x1e93, 0x0000,
	/* 0x0055 0x0324 */
	0x1e72, 0x0000,
	/* 0x0075 0x0324 */
	0x1e73, 0x0000,
	/* 0x0041 0x0325 */
	0x1e00, 0x0000,
	/* 0x0061 0x0325 */
	0x1e01, 0x0000,
	/* 0x0043 0x0327 */
	0x00c7, 0x0001,  0x0301, 0x0ed6,
	/* 0x0044 0x0327 */
	0x1e10, 0x0000,
	/* 0x0045 0x0327 */
	0x0000, 0x0001,  0x0306, 0x0ed8,
	/* 0x0047 0x0327 */
	0x0122, 0x0000,
	/* 0x0048 0x0327 */
	0x1e28, 0x0000,
	/* 0x004b 0x0327 */
	0x0136, 0x0000,
	/* 0x004c 0x0327 */
	0x013b, 0x0000,
	/* 0x004e 0x0327 */
	0x0145, 0x0000,
	/* 0x0052 0x0327 */
	0x0156, 0x0000,
	/* 0x0053 0x0327 */
	0x015e, 0x0000,
	/* 0x0054 0x0327 */
	0x0162, 0x0000,
	/* 0x0063 0x0327 */
	0x00e7, 0x0001,  0x0301, 0x0eda,
	/* 0x0064 0x0327 */
	0x1e11, 0x0000,
	/* 0x0065 0x0327 */
	0x0000, 0x0001,  0x0306, 0x0edc,
	/* 0x0067 0x0327 */
	0x0123, 0x0000,
	/* 0x0068 0x0327 */
	0x1e29, 0x0000,
	/* 0x006b 0x0327 */
	0x0137, 0x0000,
	/* 0x006c 0x0327 */
	0x013c, 0x0000,
	/* 0x006e 0x0327 */
	0x0146, 0x0000,
	/* 0x0072 0x0327 */
	0x0157, 0x0000,
	/* 0x0073 0x0327 */
	0x015f, 0x0000,
	/* 0x0074 0x0327 */
	0x0163, 0x0000,
	/* 0x0041 0x0328 */
	0x0104, 0x0000,
	/* 0x0045 0x0328 */
	0x0118, 0x0000,
	/* 0x0049 0x0328 */
	0x012e, 0x0000,
	/* 0x004f 0x0328 */
	0x01ea, 0x0001,  0x0304, 0x0ede,
	/* 0x0055 0x0328 */
	0x0172, 0x0000,
	/* 0x0061 0x0328 */
	0x0105, 0x0000,
	/* 0x0065 0x0328 */
	0x0119, 0x0000,
	/* 0x0069 0x0328 */
	0x012f, 0x0000,
	/* 0x006f 0x0328 */
	0x01eb, 0x0001,  0x0304, 0x0ee0,
	/* 0x0075 0x0328 */
	0x0173, 0x0000,
	/* 0x0044 0x032d */
	0x1e12, 0x0000,
	/* 0x0045 0x032d */
	0x1e18, 0x0000,
	/* 0x004c 0x032d */
	0x1e3c, 0x0000,
	/* 0x004e 0x032d */
	0x1e4a, 0x0000,
	/* 0x0054 0x032d */
	0x1e70, 0x0000,
	/* 0x0055 0x032d */
	0x1e76, 0x0000,
	/* 0x0064 0x032d */
	0x1e13, 0x0000,
	/* 0x0065 0x032d */
	0x1e19, 0x0000,
	/* 0x006c 0x032d */
	0x1e3d, 0x0000,
	/* 0x006e 0x032d */
	0x1e4b, 0x0000,
	/* 0x0074 0x032d */
	0x1e71, 0x0000,
	/* 0x0075 0x032d */
	0x1e77, 0x0000,
	/* 0x0048 0x032e */
	0x1e2a, 0x0000,
	/* 0x0068 0x032e */
	0x1e2b, 0x0000,
	/* 0x0045 0x0330 */
	0x1e1a, 0x0000,
	/* 0x0049 0x0330 */
	0x1e2c, 0x0000,
	/* 0x0055 0x0330 */
	0x1e74, 0x0000,
	/* 0x0065 0x0330 */
	0x1e1b, 0x0000,
	/* 0x0069 0x0330 */
	0x1e2d, 0x0000,
	/* 0x0075 0x0330 */
	0x1e75, 0x0000,
	/* 0x0042 0x0331 */
	0x1e06, 0x0000,
	/* 0x0044 0x0331 */
	0x1e0e, 0x0000,
	/* 0x004b 0x0331 */
	0x1e34, 0x0000,
	/* 0x004c 0x0331 */
	0x1e3a, 0x0000,
	/* 0x004e 0x0331 */
	0x1e48, 0x0000,
	/* 0x0052 0x0331 */
	0x1e5e, 0x0000,
	/* 0x0054 0x0331 */
	0x1e6e, 0x0000,
	/* 0x005a 0x0331 */
	0x1e94, 0x0000,
	/* 0x0062 0x0331 */
	0x1e07, 0x0000,
	/* 0x0064 0x0331 */
	0x1e0f, 0x0000,
	/* 0x0068 0x0331 */
	0x1e96, 0x0000,
	/* 0x006b 0x0331 */
	0x1e35, 0x0000,
	/* 0x006c 0x0331 */
	0x1e3b, 0x0000,
	/* 0x006e 0x0331 */
	0x1e49, 0x0000,
	/* 0x0072 0x0331 */
	0x1e5f, 0x0000,
	/* 0x0074 0x0331 */
	0x1e6f, 0x0000,
	/* 0x007a 0x0331 */
	0x1e95, 0x0000,
	/* 0x00a8 0x0342 */
	0x1fc1, 0x0000,
	/* 0x03b1 0x0342 */
	0x1fb6, 0x0000,
	/* 0x03b7 0x0342 */
	0x1fc6, 0x0000,
	/* 0x03b9 0x0342 */
	0x1fd6, 0x0000,
	/* 0x03c5 0x0342 */
	0x1fe6, 0x0000,
	/* 0x03c9 0x0342 */
	0x1ff6, 0x0000,
	/* 0x1fbf 0x0342 */
	0x1fcf, 0x0000,
	/* 0x1ffe 0x0342 */
	0x1fdf, 0x0000,
	/* 0x0391 0x0345 */
	0x1fbc, 0x0002,  0x0313, 0x0ee2,  0x0314, 0x0eea,
	/* 0x0397 0x0345 */
	0x1fcc, 0x0002,  0x0313, 0x0ef2,  0x0314, 0x0efa,
	/* 0x03a9 0x0345 */
	0x1ffc, 0x0002,  0x0313, 0x0f02,  0x0314, 0x0f0a,
	/* 0x03b1 0x0345 */
	0x1fb3, 0x0005,  0x0300, 0x0f12,  0x0301, 0x0f14,  0x0313, 0x0f16,
	0x0314, 0x0f1e,  0x0342, 0x0f26,
	/* 0x03b7 0x0345 */
	0x1fc3, 0x0005,  0x0300, 0x0f28,  0x0301, 0x0f2a,  0x0313, 0x0f2c,
	0x0314, 0x0f34,  0x0342, 0x0f3c,
	/* 0x03bf 0x0345 */
	0x0000, 0x0001,  0x0301, 0x0f3e,
	/* 0x03c9 0x0345 */
	0x1ff3, 0x0004,  0x0300, 0x0f40,  0x0313, 0x0f42,  0x0314, 0x0f4a,
	0x0342, 0x0f52,
	/* 0x05d0 0x05b7 */
	0xfb2e, 0x0000,
	/* 0x05f2 0x05b7 */
	0xfb1f, 0x0000,
	/* 0x05d0 0x05b8 */
	0xfb2f, 0x0000,
	/* 0x05d5 0x05b9 */
	0xfb4b, 0x0000,
	/* 0x05d0 0x05bc */
	0xfb30, 0x0000,
	/* 0x05d1 0x05bc */
	0xfb31, 0x0000,
	/* 0x05d2 0x05bc */
	0xfb32, 0x0000,
	/* 0x05d3 0x05bc */
	0xfb33, 0x0000,
	/* 0x05d4 0x05bc */
	0xfb34, 0x0000,
	/* 0x05d5 0x05bc */
	0xfb35, 0x0000,
	/* 0x05d6 0x05bc */
	0xfb36, 0x0000,
	/* 0x05d8 0x05bc */
	0xfb38, 0x0000,
	/* 0x05d9 0x05bc */
	0xfb39, 0x0000,
	/* 0x05da 0x05bc */
	0xfb3a, 0x0000,
	/* 0x05db 0x05bc */
	0xfb3b, 0x0000,
	/* 0x05dc 0x05bc */
	0xfb3c, 0x0000,
	/* 0x05de 0x05bc */
	0xfb3e, 0x0000,
	/* 0x05e0 0x05bc */
	0xfb40, 0x0000,
	/* 0x05e1 0x05bc */
	0xfb41, 0x0000,
	/* 0x05e3 0x05bc */
	0xfb43, 0x0000,
	/* 0x05e4 0x05bc */
	0xfb44, 0x0000,
	/* 0x05e6 0x05bc */
	0xfb46, 0x0000,
	/* 0x05e7 0x05bc */
	0xfb47, 0x0000,
	/* 0x05e8 0x05bc */
	0xfb48, 0x0000,
	/* 0x05e9 0x05bc */
	0xfb49, 0x0002,  0x05c1, 0x0f54,  0x05c2, 0x0f56,
	/* 0x05ea 0x05bc */
	0xfb4a, 0x0000,
	/* 0x05d1 0x05bf */
	0xfb4c, 0x0000,
	/* 0x05db 0x05bf */
	0xfb4d, 0x0000,
	/* 0x05e4 0x05bf */
	0xfb4e, 0x0000,
	/* 0x05e9 0x05c1 */
	0xfb2a, 0x0000,
	/* 0x05e9 0x05c2 */
	0xfb2b, 0x0000,
	/* 0x0915 0x093c */
	0x0958, 0x0000,
	/* 0x0916 0x093c */
	0x0959, 0x0000,
	/* 0x0917 0x093c */
	0x095a, 0x0000,
	/* 0x091c 0x093c */
	0x095b, 0x0000,
	/* 0x0921 0x093c */
	0x095c, 0x0000,
	/* 0x0922 0x093c */
	0x095d, 0x0000,
	/* 0x0928 0x093c */
	0x0929, 0x0000,
	/* 0x092b 0x093c */
	0x095e, 0x0000,
	/* 0x092f 0x093c */
	0x095f, 0x0000,
	/* 0x0930 0x093c */
	0x0931, 0x0000,
	/* 0x0933 0x093c */
	0x0934, 0x0000,
	/* 0x09a1 0x09bc */
	0x09dc, 0x0000,
	/* 0x09a2 0x09bc */
	0x09dd, 0x0000,
	/* 0x09ac 0x09bc */
	0x09b0, 0x0000,
	/* 0x09af 0x09bc */
	0x09df, 0x0000,
	/* 0x09c7 0x09be */
	0x09cb, 0x0000,
	/* 0x09c7 0x09d7 */
	0x09cc, 0x0000,
	/* 0x0a16 0x0a3c */
	0x0a59, 0x0000,
	/* 0x0a17 0x0a3c */
	0x0a5a, 0x0000,
	/* 0x0a1c 0x0a3c */
	0x0a5b, 0x0000,
	/* 0x0a21 0x0a3c */
	0x0a5c, 0x0000,
	/* 0x0a2b 0x0a3c */
	0x0a5e, 0x0000,
	/* 0x0b21 0x0b3c */
	0x0b5c, 0x0000,
	/* 0x0b22 0x0b3c */
	0x0b5d, 0x0000,
	/* 0x0b2f 0x0b3c */
	0x0b5f, 0x0000,
	/* 0x0b47 0x0b3e */
	0x0b4b, 0x0000,
	/* 0x0b47 0x0b56 */
	0x0b48, 0x0000,
	/* 0x0b47 0x0b57 */
	0x0b4c, 0x0000,
	/* 0x0bc6 0x0bbe */
	0x0bca, 0x0000,
	/* 0x0bc7 0x0bbe */
	0x0bcb, 0x0000,
	/* 0x0b92 0x0bd7 */
	0x0b94, 0x0000,
	/* 0x0bc6 0x0bd7 */
	0x0bcc, 0x0000,
	/* 0x0c46 0x0c56 */
	0x0c48, 0x0000,
	/* 0x0cc6 0x0cc2 */
	0x0cca, 0x0001,  0x0cd5, 0x0f58,
	/* 0x0cbf 0x0cd5 */
	0x0cc0, 0x0000,
	/* 0x0cc6 0x0cd5 */
	0x0cc7, 0x0000,
	/* 0x0cc6 0x0cd6 */
	0x0cc8, 0x0000,
	/* 0x0d46 0x0d3e */
	0x0d4a, 0x0000,
	/* 0x0d47 0x0d3e */
	0x0d4b, 0x0000,
	/* 0x0d46 0x0d57 */
	0x0d4c, 0x0000,
	/* 0x0e4d 0x0e32 */
	0x0e33, 0x0000,
	/* 0x0ecd 0x0eb2 */
	0x0eb3, 0x0000,
	/* 0x0f72 0x0f71 */
	0x0f73, 0x0000,
	/* 0x0f74 0x0f71 */
	0x0f75, 0x0000,
	/* 0x0f80 0x0f71 */
	0x0f81, 0x0000,
	/* 0x0fb2 0x0f80 */
	0x0f76, 0x0001,  0x0f71, 0x0f5a,
	/* 0x0fb3 0x0f80 */
	0x0f78, 0x0001,  0x0f71, 0x0f5c,
	/* 0x0f40 0x0fb5 */
	0x0f69, 0x0000,
	/* 0x0f90 0x0fb5 */
	0x0fb9, 0x0000,
	/* 0x0f42 0x0fb7 */
	0x0f43, 0x0000,
	/* 0x0f4c 0x0fb7 */
	0x0f4d, 0x0000,
	/* 0x0f51 0x0fb7 */
	0x0f52, 0x0000,
	/* 0x0f56 0x0fb7 */
	0x0f57, 0x0000,
	/* 0x0f5b 0x0fb7 */
	0x0f5c, 0x0000,
	/* 0x0f92 0x0fb7 */
	0x0f93, 0x0000,
	/* 0x0f9c 0x0fb7 */
	0x0f9d, 0x0000,
	/* 0x0fa1 0x0fb7 */
	0x0fa2, 0x0000,
	/* 0x0fa6 0x0fb7 */
	0x0fa7, 0x0000,
	/* 0x0fab 0x0fb7 */
	0x0fac, 0x0000,
	/* 0x3046 0x3099 */
	0x3094, 0x0000,
	/* 0x304b 0x3099 */
	0x304c, 0x0000,
	/* 0x304d 0x3099 */
	0x304e, 0x0000,
	/* 0x304f 0x3099 */
	0x3050, 0x0000,
	/* 0x3051 0x3099 */
	0x3052, 0x0000,
	/* 0x3053 0x3099 */
	0x3054, 0x0000,
	/* 0x3055 0x3099 */
	0x3056, 0x0000,
	/* 0x3057 0x3099 */
	0x3058, 0x0000,
	/* 0x3059 0x3099 */
	0x305a, 0x0000,
	/* 0x305b 0x3099 */
	0x305c, 0x0000,
	/* 0x305d 0x3099 */
	0x305e, 0x0000,
	/* 0x305f 0x3099 */
	0x3060, 0x0000,
	/* 0x3061 0x3099 */
	0x3062, 0x0000,
	/* 0x3064 0x3099 */
	0x3065, 0x0000,
	/* 0x3066 0x3099 */
	0x3067, 0x0000,
	/* 0x3068 0x3099 */
	0x3069, 0x0000,
	/* 0x306f 0x3099 */
	0x3070, 0x0000,
	/* 0x3072 0x3099 */
	0x3073, 0x0000,
	/* 0x3075 0x3099 */
	0x3076, 0x0000,
	/* 0x3078 0x3099 */
	0x3079, 0x0000,
	/* 0x307b 0x3099 */
	0x307c, 0x0000,
	/* 0x309d 0x3099 */
	0x309e, 0x0000,
	/* 0x30a6 0x3099 */
	0x30f4, 0x0000,
	/* 0x30ab 0x3099 */
	0x30ac, 0x0000,
	/* 0x30ad 0x3099 */
	0x30ae, 0x0000,
	/* 0x30af 0x3099 */
	0x30b0, 0x0000,
	/* 0x30b1 0x3099 */
	0x30b2, 0x0000,
	/* 0x30b3 0x3099 */
	0x30b4, 0x0000,
	/* 0x30b5 0x3099 */
	0x30b6, 0x0000,
	/* 0x30b7 0x3099 */
	0x30b8, 0x0000,
	/* 0x30b9 0x3099 */
	0x30ba, 0x0000,
	/* 0x30bb 0x3099 */
	0x30bc, 0x0000,
	/* 0x30bd 0x3099 */
	0x30be, 0x0000,
	/* 0x30bf 0x3099 */
	0x30c0, 0x0000,
	/* 0x30c1 0x3099 */
	0x30c2, 0x0000,
	/* 0x30c4 0x3099 */
	0x30c5, 0x0000,
	/* 0x30c6 0x3099 */
	0x30c7, 0x0000,
	/* 0x30c8 0x3099 */
	0x30c9, 0x0000,
	/* 0x30cf 0x3099 */
	0x30d0, 0x0000,
	/* 0x30d2 0x3099 */
	0x30d3, 0x0000,
	/* 0x30d5 0x3099 */
	0x30d6, 0x0000,
	/* 0x30d8 0x3099 */
	0x30d9, 0x0000,
	/* 0x30db 0x3099 */
	0x30dc, 0x0000,
	/* 0x30ef 0x3099 */
	0x30f7, 0x0000,
	/* 0x30f0 0x3099 */
	0x30f8, 0x0000,
	/* 0x30f1 0x3099 */
	0x30f9, 0x0000,
	/* 0x30f2 0x3099 */
	0x30fa, 0x0000,
	/* 0x30fd 0x3099 */
	0x30fe, 0x0000,
	/* 0x306f 0x309a */
	0x3071, 0x0000,
	/* 0x3072 0x309a */
	0x3074, 0x0000,
	/* 0x3075 0x309a */
	0x3077, 0x0000,
	/* 0x3078 0x309a */
	0x307a, 0x0000,
	/* 0x307b 0x309a */
	0x307d, 0x0000,
	/* 0x30cf 0x309a */
	0x30d1, 0x0000,
	/* 0x30d2 0x309a */
	0x30d4, 0x0000,
	/* 0x30d5 0x309a */
	0x30d7, 0x0000,
	/* 0x30d8 0x309a */
	0x30da, 0x0000,
	/* 0x30db 0x309a */
	0x30dd, 0x0000,
	/* 0x0307 0x0053 0x0301 */
	0x1e64, 0x0000,
	/* 0x0307 0x0073 0x0301 */
	0x1e65, 0x0000,
	/* 0x0300 0x0041 0x0302 */
	0x1ea6, 0x0000,
	/* 0x0301 0x0041 0x0302 */
	0x1ea4, 0x0000,
	/* 0x0303 0x0041 0x0302 */
	0x1eaa, 0x0000,
	/* 0x0309 0x0041 0x0302 */
	0x1ea8, 0x0000,
	/* 0x0300 0x0045 0x0302 */
	0x1ec0, 0x0000,
	/* 0x0301 0x0045 0x0302 */
	0x1ebe, 0x0000,
	/* 0x0303 0x0045 0x0302 */
	0x1ec4, 0x0000,
	/* 0x0309 0x0045 0x0302 */
	0x1ec2, 0x0000,
	/* 0x0300 0x004f 0x0302 */
	0x1ed2, 0x0000,
	/* 0x0301 0x004f 0x0302 */
	0x1ed0, 0x0000,
	/* 0x0303 0x004f 0x0302 */
	0x1ed6, 0x0000,
	/* 0x0309 0x004f 0x0302 */
	0x1ed4, 0x0000,
	/* 0x0300 0x0061 0x0302 */
	0x1ea7, 0x0000,
	/* 0x0301 0x0061 0x0302 */
	0x1ea5, 0x0000,
	/* 0x0303 0x0061 0x0302 */
	0x1eab, 0x0000,
	/* 0x0309 0x0061 0x0302 */
	0x1ea9, 0x0000,
	/* 0x0300 0x0065 0x0302 */
	0x1ec1, 0x0000,
	/* 0x0301 0x0065 0x0302 */
	0x1ebf, 0x0000,
	/* 0x0303 0x0065 0x0302 */
	0x1ec5, 0x0000,
	/* 0x0309 0x0065 0x0302 */
	0x1ec3, 0x0000,
	/* 0x0300 0x006f 0x0302 */
	0x1ed3, 0x0000,
	/* 0x0301 0x006f 0x0302 */
	0x1ed1, 0x0000,
	/* 0x0303 0x006f 0x0302 */
	0x1ed7, 0x0000,
	/* 0x0309 0x006f 0x0302 */
	0x1ed5, 0x0000,
	/* 0x0301 0x004f 0x0303 */
	0x1e4c, 0x0000,
	/* 0x0308 0x004f 0x0303 */
	0x1e4e, 0x0000,
	/* 0x0301 0x0055 0x0303 */
	0x1e78, 0x0000,
	/* 0x0301 0x006f 0x0303 */
	0x1e4d, 0x0000,
	/* 0x0308 0x006f 0x0303 */
	0x1e4f, 0x0000,
	/* 0x0301 0x0075 0x0303 */
	0x1e79, 0x0000,
	/* 0x0300 0x0045 0x0304 */
	0x1e14, 0x0000,
	/* 0x0301 0x0045 0x0304 */
	0x1e16, 0x0000,
	/* 0x0300 0x004f 0x0304 */
	0x1e50, 0x0000,
	/* 0x0301 0x004f 0x0304 */
	0x1e52, 0x0000,
	/* 0x0308 0x0055 0x0304 */
	0x1e7a, 0x0000,
	/* 0x0300 0x0065 0x0304 */
	0x1e15, 0x0000,
	/* 0x0301 0x0065 0x0304 */
	0x1e17, 0x0000,
	/* 0x0300 0x006f 0x0304 */
	0x1e51, 0x0000,
	/* 0x0301 0x006f 0x0304 */
	0x1e53, 0x0000,
	/* 0x0308 0x0075 0x0304 */
	0x1e7b, 0x0000,
	/* 0x0300 0x0041 0x0306 */
	0x1eb0, 0x0000,
	/* 0x0301 0x0041 0x0306 */
	0x1eae, 0x0000,
	/* 0x0303 0x0041 0x0306 */
	0x1eb4, 0x0000,
	/* 0x0309 0x0041 0x0306 */
	0x1eb2, 0x0000,
	/* 0x0300 0x0061 0x0306 */
	0x1eb1, 0x0000,
	/* 0x0301 0x0061 0x0306 */
	0x1eaf, 0x0000,
	/* 0x0303 0x0061 0x0306 */
	0x1eb5, 0x0000,
	/* 0x0309 0x0061 0x0306 */
	0x1eb3, 0x0000,
	/* 0x0304 0x0041 0x0307 */
	0x01e0, 0x0000,
	/* 0x0304 0x0061 0x0307 */
	0x01e1, 0x0000,
	/* 0x0304 0x0041 0x0308 */
	0x01de, 0x0000,
	/* 0x0301 0x0049 0x0308 */
	0x1e2e, 0x0000,
	/* 0x0300 0x0055 0x0308 */
	0x01db, 0x0000,
	/* 0x0301 0x0055 0x0308 */
	0x01d7, 0x0000,
	/* 0x0304 0x0055 0x0308 */
	0x01d5, 0x0000,
	/* 0x030c 0x0055 0x0308 */
	0x01d9, 0x0000,
	/* 0x0304 0x0061 0x0308 */
	0x01df, 0x0000,
	/* 0x0301 0x0069 0x0308 */
	0x1e2f, 0x0000,
	/* 0x0300 0x0075 0x0308 */
	0x01dc, 0x0000,
	/* 0x0301 0x0075 0x0308 */
	0x01d8, 0x0000,
	/* 0x0304 0x0075 0x0308 */
	0x01d6, 0x0000,
	/* 0x030c 0x0075 0x0308 */
	0x01da, 0x0000,
	/* 0x0300 0x03b9 0x0308 */
	0x1fd2, 0x0000,
	/* 0x0301 0x03b9 0x0308 */
	0x1fd3, 0x0000,
	/* 0x030d 0x03b9 0x0308 */
	0x0390, 0x0000,
	/* 0x0342 0x03b9 0x0308 */
	0x1fd7, 0x0000,
	/* 0x0300 0x03c5 0x0308 */
	0x1fe2, 0x0000,
	/* 0x0301 0x03c5 0x0308 */
	0x1fe3, 0x0000,
	/* 0x030d 0x03c5 0x0308 */
	0x03b0, 0x0000,
	/* 0x0342 0x03c5 0x0308 */
	0x1fe7, 0x0000,
	/* 0x0301 0x0041 0x030a */
	0x01fa, 0x0000,
	/* 0x0301 0x0061 0x030a */
	0x01fb, 0x0000,
	/* 0x0307 0x0053 0x030c */
	0x1e66, 0x0000,
	/* 0x0307 0x0073 0x030c */
	0x1e67, 0x0000,
	/* 0x0300 0x0391 0x0313 */
	0x1f0a, 0x0000,
	/* 0x0301 0x0391 0x0313 */
	0x1f0c, 0x0000,
	/* 0x0342 0x0391 0x0313 */
	0x1f0e, 0x0000,
	/* 0x0300 0x0395 0x0313 */
	0x1f1a, 0x0000,
	/* 0x0301 0x0395 0x0313 */
	0x1f1c, 0x0000,
	/* 0x0300 0x0397 0x0313 */
	0x1f2a, 0x0000,
	/* 0x0301 0x0397 0x0313 */
	0x1f2c, 0x0000,
	/* 0x0342 0x0397 0x0313 */
	0x1f2e, 0x0000,
	/* 0x0300 0x0399 0x0313 */
	0x1f3a, 0x0000,
	/* 0x0301 0x0399 0x0313 */
	0x1f3c, 0x0000,
	/* 0x0342 0x0399 0x0313 */
	0x1f3e, 0x0000,
	/* 0x0300 0x039f 0x0313 */
	0x1f4a, 0x0000,
	/* 0x0301 0x039f 0x0313 */
	0x1f4c, 0x0000,
	/* 0x0300 0x03a9 0x0313 */
	0x1f6a, 0x0000,
	/* 0x0301 0x03a9 0x0313 */
	0x1f6c, 0x0000,
	/* 0x0342 0x03a9 0x0313 */
	0x1f6e, 0x0000,
	/* 0x0300 0x03b1 0x0313 */
	0x1f02, 0x0000,
	/* 0x0301 0x03b1 0x0313 */
	0x1f04, 0x0000,
	/* 0x0342 0x03b1 0x0313 */
	0x1f06, 0x0000,
	/* 0x0300 0x03b5 0x0313 */
	0x1f12, 0x0000,
	/* 0x0301 0x03b5 0x0313 */
	0x1f14, 0x0000,
	/* 0x0300 0x03b7 0x0313 */
	0x1f22, 0x0000,
	/* 0x0301 0x03b7 0x0313 */
	0x1f24, 0x0000,
	/* 0x0342 0x03b7 0x0313 */
	0x1f26, 0x0000,
	/* 0x0300 0x03b9 0x0313 */
	0x1f32, 0x0000,
	/* 0x0301 0x03b9 0x0313 */
	0x1f34, 0x0000,
	/* 0x0342 0x03b9 0x0313 */
	0x1f36, 0x0000,
	/* 0x0300 0x03bf 0x0313 */
	0x1f42, 0x0000,
	/* 0x0301 0x03bf 0x0313 */
	0x1f44, 0x0000,
	/* 0x0300 0x03c5 0x0313 */
	0x1f52, 0x0000,
	/* 0x0301 0x03c5 0x0313 */
	0x1f54, 0x0000,
	/* 0x0342 0x03c5 0x0313 */
	0x1f56, 0x0000,
	/* 0x0300 0x03c9 0x0313 */
	0x1f62, 0x0000,
	/* 0x0301 0x03c9 0x0313 */
	0x1f64, 0x0000,
	/* 0x0342 0x03c9 0x0313 */
	0x1f66, 0x0000,
	/* 0x0300 0x0391 0x0314 */
	0x1f0b, 0x0000,
	/* 0x0301 0x0391 0x0314 */
	0x1f0d, 0x0000,
	/* 0x0342 0x0391 0x0314 */
	0x1f0f, 0x0000,
	/* 0x0300 0x0395 0x0314 */
	0x1f1b, 0x0000,
	/* 0x0301 0x0395 0x0314 */
	0x1f1d, 0x0000,
	/* 0x0300 0x0397 0x0314 */
	0x1f2b, 0x0000,
	/* 0x0301 0x0397 0x0314 */
	0x1f2d, 0x0000,
	/* 0x0342 0x0397 0x0314 */
	0x1f2f, 0x0000,
	/* 0x0300 0x0399 0x0314 */
	0x1f3b, 0x0000,
	/* 0x0301 0x0399 0x0314 */
	0x1f3d, 0x0000,
	/* 0x0342 0x0399 0x0314 */
	0x1f3f, 0x0000,
	/* 0x0300 0x039f 0x0314 */
	0x1f4b, 0x0000,
	/* 0x0301 0x039f 0x0314 */
	0x1f4d, 0x0000,
	/* 0x0300 0x03a5 0x0314 */
	0x1f5b, 0x0000,
	/* 0x0301 0x03a5 0x0314 */
	0x1f5d, 0x0000,
	/* 0x0342 0x03a5 0x0314 */
	0x1f5f, 0x0000,
	/* 0x0300 0x03a9 0x0314 */
	0x1f6b, 0x0000,
	/* 0x0301 0x03a9 0x0314 */
	0x1f6d, 0x0000,
	/* 0x0342 0x03a9 0x0314 */
	0x1f6f, 0x0000,
	/* 0x0300 0x03b1 0x0314 */
	0x1f03, 0x0000,
	/* 0x0301 0x03b1 0x0314 */
	0x1f05, 0x0000,
	/* 0x0342 0x03b1 0x0314 */
	0x1f07, 0x0000,
	/* 0x0300 0x03b5 0x0314 */
	0x1f13, 0x0000,
	/* 0x0301 0x03b5 0x0314 */
	0x1f15, 0x0000,
	/* 0x0300 0x03b7 0x0314 */
	0x1f23, 0x0000,
	/* 0x0301 0x03b7 0x0314 */
	0x1f25, 0x0000,
	/* 0x0342 0x03b7 0x0314 */
	0x1f27, 0x0000,
	/* 0x0300 0x03b9 0x0314 */
	0x1f33, 0x0000,
	/* 0x0301 0x03b9 0x0314 */
	0x1f35, 0x0000,
	/* 0x0342 0x03b9 0x0314 */
	0x1f37, 0x0000,
	/* 0x0300 0x03bf 0x0314 */
	0x1f43, 0x0000,
	/* 0x0301 0x03bf 0x0314 */
	0x1f45, 0x0000,
	/* 0x0300 0x03c5 0x0314 */
	0x1f53, 0x0000,
	/* 0x0301 0x03c5 0x0314 */
	0x1f55, 0x0000,
	/* 0x0342 0x03c5 0x0314 */
	0x1f57, 0x0000,
	/* 0x0300 0x03c9 0x0314 */
	0x1f63, 0x0000,
	/* 0x0301 0x03c9 0x0314 */
	0x1f65, 0x0000,
	/* 0x0342 0x03c9 0x0314 */
	0x1f67, 0x0000,
	/* 0x0300 0x004f 0x031b */
	0x1edc, 0x0000,
	/* 0x0301 0x004f 0x031b */
	0x1eda, 0x0000,
	/* 0x0303 0x004f 0x031b */
	0x1ee0, 0x0000,
	/* 0x0309 0x004f 0x031b */
	0x1ede, 0x0000,
	/* 0x0323 0x004f 0x031b */
	0x1ee2, 0x0000,
	/* 0x0300 0x0055 0x031b */
	0x1eea, 0x0000,
	/* 0x0301 0x0055 0x031b */
	0x1ee8, 0x0000,
	/* 0x0303 0x0055 0x031b */
	0x1eee, 0x0000,
	/* 0x0309 0x0055 0x031b */
	0x1eec, 0x0000,
	/* 0x0323 0x0055 0x031b */
	0x1ef0, 0x0000,
	/* 0x0300 0x006f 0x031b */
	0x1edd, 0x0000,
	/* 0x0301 0x006f 0x031b */
	0x1edb, 0x0000,
	/* 0x0303 0x006f 0x031b */
	0x1ee1, 0x0000,
	/* 0x0309 0x006f 0x031b */
	0x1edf, 0x0000,
	/* 0x0323 0x006f 0x031b */
	0x1ee3, 0x0000,
	/* 0x0300 0x0075 0x031b */
	0x1eeb, 0x0000,
	/* 0x0301 0x0075 0x031b */
	0x1ee9, 0x0000,
	/* 0x0303 0x0075 0x031b */
	0x1eef, 0x0000,
	/* 0x0309 0x0075 0x031b */
	0x1eed, 0x0000,
	/* 0x0323 0x0075 0x031b */
	0x1ef1, 0x0000,
	/* 0x0302 0x0041 0x0323 */
	0x1eac, 0x0000,
	/* 0x0306 0x0041 0x0323 */
	0x1eb6, 0x0000,
	/* 0x0302 0x0045 0x0323 */
	0x1ec6, 0x0000,
	/* 0x0304 0x004c 0x0323 */
	0x1e38, 0x0000,
	/* 0x0302 0x004f 0x0323 */
	0x1ed8, 0x0000,
	/* 0x0304 0x0052 0x0323 */
	0x1e5c, 0x0000,
	/* 0x0307 0x0053 0x0323 */
	0x1e68, 0x0000,
	/* 0x0302 0x0061 0x0323 */
	0x1ead, 0x0000,
	/* 0x0306 0x0061 0x0323 */
	0x1eb7, 0x0000,
	/* 0x0302 0x0065 0x0323 */
	0x1ec7, 0x0000,
	/* 0x0304 0x006c 0x0323 */
	0x1e39, 0x0000,
	/* 0x0302 0x006f 0x0323 */
	0x1ed9, 0x0000,
	/* 0x0304 0x0072 0x0323 */
	0x1e5d, 0x0000,
	/* 0x0307 0x0073 0x0323 */
	0x1e69, 0x0000,
	/* 0x0301 0x0043 0x0327 */
	0x1e08, 0x0000,
	/* 0x0306 0x0045 0x0327 */
	0x1e1c, 0x0000,
	/* 0x0301 0x0063 0x0327 */
	0x1e09, 0x0000,
	/* 0x0306 0x0065 0x0327 */
	0x1e1d, 0x0000,
	/* 0x0304 0x004f 0x0328 */
	0x01ec, 0x0000,
	/* 0x0304 0x006f 0x0328 */
	0x01ed, 0x0000,
	/* 0x0313 0x0391 0x0345 */
	0x1f88, 0x0003,  0x0300, 0x0f5e,  0x0301, 0x0f60,  0x0342, 0x0f62,
	/* 0x0314 0x0391 0x0345 */
	0x1f89, 0x0003,  0x0300, 0x0f64,  0x0301, 0x0f66,  0x0342, 0x0f68,
	/* 0x0313 0x0397 0x0345 */
	0x1f98, 0x0003,  0x0300, 0x0f6a,  0x0301, 0x0f6c,  0x0342, 0x0f6e,
	/* 0x0314 0x0397 0x0345 */
	0x1f99, 0x0003,  0x0300, 0x0f70,  0x0301, 0x0f72,  0x0342, 0x0f74,
	/* 0x0313 0x03a9 0x0345 */
	0x1fa8, 0x0003,  0x0300, 0x0f76,  0x0301, 0x0f78,  0x0342, 0x0f7a,
	/* 0x0314 0x03a9 0x0345 */
	0x1fa9, 0x0003,  0x0300, 0x0f7c,  0x0301, 0x0f7e,  0x0342, 0x0f80,
	/* 0x0300 0x03b1 0x0345 */
	0x1fb2, 0x0000,
	/* 0x0301 0x03b1 0x0345 */
	0x1fb4, 0x0000,
	/* 0x0313 0x03b1 0x0345 */
	0x1f80, 0x0003,  0x0300, 0x0f82,  0x0301, 0x0f84,  0x0342, 0x0f86,
	/* 0x0314 0x03b1 0x0345 */
	0x1f81, 0x0003,  0x0300, 0x0f88,  0x0301, 0x0f8a,  0x0342, 0x0f8c,
	/* 0x0342 0x03b1 0x0345 */
	0x1fb7, 0x0000,
	/* 0x0300 0x03b7 0x0345 */
	0x1fc2, 0x0000,
	/* 0x0301 0x03b7 0x0345 */
	0x1fc4, 0x0000,
	/* 0x0313 0x03b7 0x0345 */
	0x1f90, 0x0003,  0x0300, 0x0f8e,  0x0301, 0x0f90,  0x0342, 0x0f92,
	/* 0x0314 0x03b7 0x0345 */
	0x1f91, 0x0003,  0x0300, 0x0f94,  0x0301, 0x0f96,  0x0342, 0x0f98,
	/* 0x0342 0x03b7 0x0345 */
	0x1fc7, 0x0000,
	/* 0x0301 0x03bf 0x0345 */
	0x1ff4, 0x0000,
	/* 0x0300 0x03c9 0x0345 */
	0x1ff2, 0x0000,
	/* 0x0313 0x03c9 0x0345 */
	0x1fa0, 0x0003,  0x0300, 0x0f9a,  0x0301, 0x0f9c,  0x0342, 0x0f9e,
	/* 0x0314 0x03c9 0x0345 */
	0x1fa1, 0x0003,  0x0300, 0x0fa0,  0x0301, 0x0fa2,  0x0342, 0x0fa4,
	/* 0x0342 0x03c9 0x0345 */
	0x1ff7, 0x0000,
	/* 0x05c1 0x05e9 0x05bc */
	0xfb2c, 0x0000,
	/* 0x05c2 0x05e9 0x05bc */
	0xfb2d, 0x0000,
	/* 0x0cd5 0x0cc6 0x0cc2 */
	0x0ccb, 0x0000,
	/* 0x0f71 0x0fb2 0x0f80 */
	0x0f77, 0x0000,
	/* 0x0f71 0x0fb3 0x0f80 */
	0x0f79, 0x0000,
	/* 0x0300 0x0313 0x0391 0x0345 */
	0x1f8a, 0x0000,
	/* 0x0301 0x0313 0x0391 0x0345 */
	0x1f8c, 0x0000,
	/* 0x0342 0x0313 0x0391 0x0345 */
	0x1f8e, 0x0000,
	/* 0x0300 0x0314 0x0391 0x0345 */
	0x1f8b, 0x0000,
	/* 0x0301 0x0314 0x0391 0x0345 */
	0x1f8d, 0x0000,
	/* 0x0342 0x0314 0x0391 0x0345 */
	0x1f8f, 0x0000,
	/* 0x0300 0x0313 0x0397 0x0345 */
	0x1f9a, 0x0000,
	/* 0x0301 0x0313 0x0397 0x0345 */
	0x1f9c, 0x0000,
	/* 0x0342 0x0313 0x0397 0x0345 */
	0x1f9e, 0x0000,
	/* 0x0300 0x0314 0x0397 0x0345 */
	0x1f9b, 0x0000,
	/* 0x0301 0x0314 0x0397 0x0345 */
	0x1f9d, 0x0000,
	/* 0x0342 0x0314 0x0397 0x0345 */
	0x1f9f, 0x0000,
	/* 0x0300 0x0313 0x03a9 0x0345 */
	0x1faa, 0x0000,
	/* 0x0301 0x0313 0x03a9 0x0345 */
	0x1fac, 0x0000,
	/* 0x0342 0x0313 0x03a9 0x0345 */
	0x1fae, 0x0000,
	/* 0x0300 0x0314 0x03a9 0x0345 */
	0x1fab, 0x0000,
	/* 0x0301 0x0314 0x03a9 0x0345 */
	0x1fad, 0x0000,
	/* 0x0342 0x0314 0x03a9 0x0345 */
	0x1faf, 0x0000,
	/* 0x0300 0x0313 0x03b1 0x0345 */
	0x1f82, 0x0000,
	/* 0x0301 0x0313 0x03b1 0x0345 */
	0x1f84, 0x0000,
	/* 0x0342 0x0313 0x03b1 0x0345 */
	0x1f86, 0x0000,
	/* 0x0300 0x0314 0x03b1 0x0345 */
	0x1f83, 0x0000,
	/* 0x0301 0x0314 0x03b1 0x0345 */
	0x1f85, 0x0000,
	/* 0x0342 0x0314 0x03b1 0x0345 */
	0x1f87, 0x0000,
	/* 0x0300 0x0313 0x03b7 0x0345 */
	0x1f92, 0x0000,
	/* 0x0301 0x0313 0x03b7 0x0345 */
	0x1f94, 0x0000,
	/* 0x0342 0x0313 0x03b7 0x0345 */
	0x1f96, 0x0000,
	/* 0x0300 0x0314 0x03b7 0x0345 */
	0x1f93, 0x0000,
	/* 0x0301 0x0314 0x03b7 0x0345 */
	0x1f95, 0x0000,
	/* 0x0342 0x0314 0x03b7 0x0345 */
	0x1f97, 0x0000,
	/* 0x0300 0x0313 0x03c9 0x0345 */
	0x1fa2, 0x0000,
	/* 0x0301 0x0313 0x03c9 0x0345 */
	0x1fa4, 0x0000,
	/* 0x0342 0x0313 0x03c9 0x0345 */
	0x1fa6, 0x0000,
	/* 0x0300 0x0314 0x03c9 0x0345 */
	0x1fa3, 0x0000,
	/* 0x0301 0x0314 0x03c9 0x0345 */
	0x1fa5, 0x0000,
	/* 0x0342 0x0314 0x03c9 0x0345 */
	0x1fa7, 0x0000,
};
