// SPDX-License-Identifier: GPL-2.0-or-later
/* Subdriver for the GL860 chip with the OV9655 sensor
 * Author Olivier LORIN, from logs done by Simon (Sur3) and Almighurt
 * on dsd's weblog
 */

/* Sensor : OV9655 */

#include "gl860.h"

static struct validx tbl_init_at_startup[] = {
	{0x0000, 0x0000}, {0x0010, 0x0010}, {0x0008, 0x00c0}, {0x0001, 0x00c1},
	{0x0001, 0x00c2}, {0x0020, 0x0006}, {0x006a, 0x000d},

	{0x0040, 0x0000},
};

static struct validx tbl_commmon[] = {
	{0x0041, 0x0000}, {0x006a, 0x0007}, {0x0063, 0x0006}, {0x006a, 0x000d},
	{0x0000, 0x00c0}, {0x0010, 0x0010}, {0x0001, 0x00c1}, {0x0041, 0x00c2},
	{0x0004, 0x00d8}, {0x0012, 0x0004}, {0x0000, 0x0058}, {0x0040, 0x0000},
	{0x00f3, 0x0006}, {0x0058, 0x0000}, {0x0048, 0x0000}, {0x0061, 0x0000},
};

static s32 tbl_length[] = {12, 56, 52, 54, 56, 42, 32, 12};

static u8 *tbl_640[] = {
	(u8[]){
		0x00, 0x40, 0x07, 0x6a, 0x06, 0xf3, 0x0d, 0x6a,
		0x10, 0x10, 0xc1, 0x01
	}, (u8[]){
		0x12, 0x80, 0x00, 0x00, 0x01, 0x98, 0x02, 0x80,
		0x03, 0x12, 0x04, 0x03, 0x0b, 0x57, 0x0e, 0x61,
		0x0f, 0x42, 0x11, 0x01, 0x12, 0x60, 0x13, 0x00,
		0x14, 0x3a, 0x16, 0x24, 0x17, 0x14, 0x18, 0x00,
		0x19, 0x01, 0x1a, 0x3d, 0x1e, 0x04, 0x24, 0x3c,
		0x25, 0x36, 0x26, 0x72, 0x27, 0x08, 0x28, 0x08,
		0x29, 0x15, 0x2a, 0x00, 0x2b, 0x00, 0x2c, 0x08
	}, (u8[]){
		0x32, 0xff, 0x33, 0x00, 0x34, 0x3d, 0x35, 0x00,
		0x36, 0xfa, 0x38, 0x72, 0x39, 0x57, 0x3a, 0x00,
		0x3b, 0x0c, 0x3d, 0x99, 0x3e, 0x0c, 0x3f, 0xc1,
		0x40, 0xc0, 0x41, 0x00, 0x42, 0xc0, 0x43, 0x0a,
		0x44, 0xf0, 0x45, 0x46, 0x46, 0x62, 0x47, 0x2a,
		0x48, 0x3c, 0x4a, 0xee, 0x4b, 0xe7, 0x4c, 0xe7,
		0x4d, 0xe7, 0x4e, 0xe7
	}, (u8[]){
		0x4f, 0x98, 0x50, 0x98, 0x51, 0x00, 0x52, 0x28,
		0x53, 0x70, 0x54, 0x98, 0x58, 0x1a, 0x59, 0x85,
		0x5a, 0xa9, 0x5b, 0x64, 0x5c, 0x84, 0x5d, 0x53,
		0x5e, 0x0e, 0x5f, 0xf0, 0x60, 0xf0, 0x61, 0xf0,
		0x62, 0x00, 0x63, 0x00, 0x64, 0x02, 0x65, 0x20,
		0x66, 0x00, 0x69, 0x0a, 0x6b, 0x5a, 0x6c, 0x04,
		0x6d, 0x55, 0x6e, 0x00, 0x6f, 0x9d
	}, (u8[]){
		0x70, 0x15, 0x71, 0x78, 0x72, 0x00, 0x73, 0x00,
		0x74, 0x3a, 0x75, 0x35, 0x76, 0x01, 0x77, 0x02,
		0x7a, 0x24, 0x7b, 0x04, 0x7c, 0x07, 0x7d, 0x10,
		0x7e, 0x28, 0x7f, 0x36, 0x80, 0x44, 0x81, 0x52,
		0x82, 0x60, 0x83, 0x6c, 0x84, 0x78, 0x85, 0x8c,
		0x86, 0x9e, 0x87, 0xbb, 0x88, 0xd2, 0x89, 0xe5,
		0x8a, 0x23, 0x8c, 0x8d, 0x90, 0x7c, 0x91, 0x7b
	}, (u8[]){
		0x9d, 0x02, 0x9e, 0x02, 0x9f, 0x74, 0xa0, 0x73,
		0xa1, 0x40, 0xa4, 0x50, 0xa5, 0x68, 0xa6, 0x70,
		0xa8, 0xc1, 0xa9, 0xef, 0xaa, 0x92, 0xab, 0x04,
		0xac, 0x80, 0xad, 0x80, 0xae, 0x80, 0xaf, 0x80,
		0xb2, 0xf2, 0xb3, 0x20, 0xb4, 0x20, 0xb5, 0x00,
		0xb6, 0xaf
	}, (u8[]){
		0xbb, 0xae, 0xbc, 0x4f, 0xbd, 0x4e, 0xbe, 0x6a,
		0xbf, 0x68, 0xc0, 0xaa, 0xc1, 0xc0, 0xc2, 0x01,
		0xc3, 0x4e, 0xc6, 0x85, 0xc7, 0x81, 0xc9, 0xe0,
		0xca, 0xe8, 0xcb, 0xf0, 0xcc, 0xd8, 0xcd, 0x93
	}, (u8[]){
		0xd0, 0x01, 0xd1, 0x08, 0xd2, 0xe0, 0xd3, 0x01,
		0xd4, 0x10, 0xd5, 0x80
	}
};

static u8 *tbl_1280[] = {
	(u8[]){
		0x00, 0x40, 0x07, 0x6a, 0x06, 0xf3, 0x0d, 0x6a,
		0x10, 0x10, 0xc1, 0x01
	},
	(u8[]){
		0x12, 0x80, 0x00, 0x00, 0x01, 0x98, 0x02, 0x80,
		0x03, 0x12, 0x04, 0x01, 0x0b, 0x57, 0x0e, 0x61,
		0x0f, 0x42, 0x11, 0x00, 0x12, 0x00, 0x13, 0x00,
		0x14, 0x3a, 0x16, 0x24, 0x17, 0x1b, 0x18, 0xbb,
		0x19, 0x01, 0x1a, 0x81, 0x1e, 0x04, 0x24, 0x3c,
		0x25, 0x36, 0x26, 0x72, 0x27, 0x08, 0x28, 0x08,
		0x29, 0x15, 0x2a, 0x00, 0x2b, 0x00, 0x2c, 0x08
	},
	(u8[]){
		0x32, 0xa4, 0x33, 0x00, 0x34, 0x3d, 0x35, 0x00,
		0x36, 0xf8, 0x38, 0x72, 0x39, 0x57, 0x3a, 0x00,
		0x3b, 0x0c, 0x3d, 0x99, 0x3e, 0x0c, 0x3f, 0xc2,
		0x40, 0xc0, 0x41, 0x00, 0x42, 0xc0, 0x43, 0x0a,
		0x44, 0xf0, 0x45, 0x46, 0x46, 0x62, 0x47, 0x2a,
		0x48, 0x3c, 0x4a, 0xec, 0x4b, 0xe8, 0x4c, 0xe8,
		0x4d, 0xe8, 0x4e, 0xe8
	},
	(u8[]){
		0x4f, 0x98, 0x50, 0x98, 0x51, 0x00, 0x52, 0x28,
		0x53, 0x70, 0x54, 0x98, 0x58, 0x1a, 0x59, 0x85,
		0x5a, 0xa9, 0x5b, 0x64, 0x5c, 0x84, 0x5d, 0x53,
		0x5e, 0x0e, 0x5f, 0xf0, 0x60, 0xf0, 0x61, 0xf0,
		0x62, 0x00, 0x63, 0x00, 0x64, 0x02, 0x65, 0x20,
		0x66, 0x00, 0x69, 0x02, 0x6b, 0x5a, 0x6c, 0x04,
		0x6d, 0x55, 0x6e, 0x00, 0x6f, 0x9d
	},
	(u8[]){
		0x70, 0x08, 0x71, 0x78, 0x72, 0x00, 0x73, 0x01,
		0x74, 0x3a, 0x75, 0x35, 0x76, 0x01, 0x77, 0x02,
		0x7a, 0x24, 0x7b, 0x04, 0x7c, 0x07, 0x7d, 0x10,
		0x7e, 0x28, 0x7f, 0x36, 0x80, 0x44, 0x81, 0x52,
		0x82, 0x60, 0x83, 0x6c, 0x84, 0x78, 0x85, 0x8c,
		0x86, 0x9e, 0x87, 0xbb, 0x88, 0xd2, 0x89, 0xe5,
		0x8a, 0x23, 0x8c, 0x0d, 0x90, 0x90, 0x91, 0x90
	},
	(u8[]){
		0x9d, 0x02, 0x9e, 0x02, 0x9f, 0x94, 0xa0, 0x94,
		0xa1, 0x01, 0xa4, 0x50, 0xa5, 0x68, 0xa6, 0x70,
		0xa8, 0xc1, 0xa9, 0xef, 0xaa, 0x92, 0xab, 0x04,
		0xac, 0x80, 0xad, 0x80, 0xae, 0x80, 0xaf, 0x80,
		0xb2, 0xf2, 0xb3, 0x20, 0xb4, 0x20, 0xb5, 0x00,
		0xb6, 0xaf
	},
	(u8[]){
		0xbb, 0xae, 0xbc, 0x38, 0xbd, 0x39, 0xbe, 0x01,
		0xbf, 0x01, 0xc0, 0xe2, 0xc1, 0xc0, 0xc2, 0x01,
		0xc3, 0x4e, 0xc6, 0x85, 0xc7, 0x81, 0xc9, 0xe0,
		0xca, 0xe8, 0xcb, 0xf0, 0xcc, 0xd8, 0xcd, 0x93
	},
	(u8[]){
		0xd0, 0x21, 0xd1, 0x18, 0xd2, 0xe0, 0xd3, 0x01,
		0xd4, 0x28, 0xd5, 0x00
	}
};

static u8 c04[] = {0x04};
static u8 dat_post1[] = "\x04\x00\x10\x20\xa1\x00\x00\x02";
static u8 dat_post2[] = "\x10\x10\xc1\x02";
static u8 dat_post3[] = "\x04\x00\x10\x7c\xa1\x00\x00\x04";
static u8 dat_post4[] = "\x10\x02\xc1\x06";
static u8 dat_post5[] = "\x04\x00\x10\x7b\xa1\x00\x00\x08";
static u8 dat_post6[] = "\x10\x10\xc1\x05";
static u8 dat_post7[] = "\x04\x00\x10\x7c\xa1\x00\x00\x08";
static u8 dat_post8[] = "\x04\x00\x10\x7c\xa1\x00\x00\x09";

static struct validx tbl_init_post_alt[] = {
	{0x6032, 0x00ff}, {0x6032, 0x00ff}, {0x6032, 0x00ff}, {0x603c, 0x00ff},
	{0x6003, 0x00ff}, {0x6032, 0x00ff}, {0x6032, 0x00ff}, {0x6001, 0x00ff},
	{0x6000, 0x801e},
	{0xffff, 0xffff},
	{0x6004, 0x001e}, {0x6000, 0x801e},
	{0xffff, 0xffff},
	{0x6004, 0x001e}, {0x6012, 0x0003}, {0x6000, 0x801e},
	{0xffff, 0xffff},
	{0x6004, 0x001e}, {0x6000, 0x801e},
	{0xffff, 0xffff},
	{0x6004, 0x001e}, {0x6012, 0x0003},
	{0xffff, 0xffff},
	{0x6000, 0x801e},
	{0xffff, 0xffff},
	{0x6004, 0x001e}, {0x6000, 0x801e},
	{0xffff, 0xffff},
	{0x6004, 0x001e}, {0x6012, 0x0003}, {0x6000, 0x801e},
	{0xffff, 0xffff},
	{0x6004, 0x001e}, {0x6000, 0x801e},
	{0xffff, 0xffff},
	{0x6004, 0x001e}, {0x6012, 0x0003},
	{0xffff, 0xffff},
	{0x6000, 0x801e},
	{0xffff, 0xffff},
	{0x6004, 0x001e}, {0x6000, 0x801e},
	{0xffff, 0xffff},
	{0x6004, 0x001e}, {0x6012, 0x0003},
};

static int  ov9655_init_at_startup(struct gspca_dev *gspca_dev);
static int  ov9655_configure_alt(struct gspca_dev *gspca_dev);
static int  ov9655_init_pre_alt(struct gspca_dev *gspca_dev);
static int  ov9655_init_post_alt(struct gspca_dev *gspca_dev);
static void ov9655_post_unset_alt(struct gspca_dev *gspca_dev);
static int  ov9655_camera_settings(struct gspca_dev *gspca_dev);
/*==========================================================================*/

void ov9655_init_settings(struct gspca_dev *gspca_dev)
{
	struct sd *sd = (struct sd *) gspca_dev;

	sd->vcur.backlight  =   0;
	sd->vcur.brightness = 128;
	sd->vcur.sharpness  =   0;
	sd->vcur.contrast   =   0;
	sd->vcur.gamma      =   0;
	sd->vcur.hue        =   0;
	sd->vcur.saturation =   0;
	sd->vcur.whitebal   =   0;

	sd->vmax.backlight  =   0;
	sd->vmax.brightness = 255;
	sd->vmax.sharpness  =   0;
	sd->vmax.contrast   =   0;
	sd->vmax.gamma      =   0;
	sd->vmax.hue        =   0 + 1;
	sd->vmax.saturation =   0;
	sd->vmax.whitebal   =   0;
	sd->vmax.mirror     = 0;
	sd->vmax.flip       = 0;
	sd->vmax.AC50Hz     = 0;

	sd->dev_camera_settings = ov9655_camera_settings;
	sd->dev_init_at_startup = ov9655_init_at_startup;
	sd->dev_configure_alt   = ov9655_configure_alt;
	sd->dev_init_pre_alt    = ov9655_init_pre_alt;
	sd->dev_post_unset_alt  = ov9655_post_unset_alt;
}

/*==========================================================================*/

static int ov9655_init_at_startup(struct gspca_dev *gspca_dev)
{
	fetch_validx(gspca_dev, tbl_init_at_startup,
			ARRAY_SIZE(tbl_init_at_startup));
	fetch_validx(gspca_dev, tbl_commmon, ARRAY_SIZE(tbl_commmon));
/*	ctrl_out(gspca_dev, 0x40, 11, 0x0000, 0x0000, 0, NULL);*/

	return 0;
}

static int ov9655_init_pre_alt(struct gspca_dev *gspca_dev)
{
	struct sd *sd = (struct sd *) gspca_dev;

	sd->vold.brightness = -1;
	sd->vold.hue = -1;

	fetch_validx(gspca_dev, tbl_commmon, ARRAY_SIZE(tbl_commmon));

	ov9655_init_post_alt(gspca_dev);

	return 0;
}

static int ov9655_init_post_alt(struct gspca_dev *gspca_dev)
{
	s32 reso = gspca_dev->cam.cam_mode[(s32) gspca_dev->curr_mode].priv;
	s32 n; /* reserved for FETCH functions */
	s32 i;
	u8 **tbl;

	ctrl_out(gspca_dev, 0x40, 5, 0x0001, 0x0000, 0, NULL);

	tbl = (reso == IMAGE_640) ? tbl_640 : tbl_1280;

	ctrl_out(gspca_dev, 0x40, 3, 0x0000, 0x0200,
			tbl_length[0], tbl[0]);
	for (i = 1; i < 7; i++)
		ctrl_out(gspca_dev, 0x40, 3, 0x6000, 0x0200,
				tbl_length[i], tbl[i]);
	ctrl_out(gspca_dev, 0x40, 3, 0x0000, 0x0200,
			tbl_length[7], tbl[7]);

	n = fetch_validx(gspca_dev, tbl_init_post_alt,
			ARRAY_SIZE(tbl_init_post_alt));

	ctrl_in(gspca_dev, 0xc0, 2, 0x6000, 0x801e, 1, c04);
	keep_on_fetching_validx(gspca_dev, tbl_init_post_alt,
					ARRAY_SIZE(tbl_init_post_alt), n);
	ctrl_in(gspca_dev, 0xc0, 2, 0x6000, 0x801e, 1, c04);
	keep_on_fetching_validx(gspca_dev, tbl_init_post_alt,
					ARRAY_SIZE(tbl_init_post_alt), n);
	ctrl_in(gspca_dev, 0xc0, 2, 0x6000, 0x801e, 1, c04);
	keep_on_fetching_validx(gspca_dev, tbl_init_post_alt,
					ARRAY_SIZE(tbl_init_post_alt), n);
	ctrl_in(gspca_dev, 0xc0, 2, 0x6000, 0x801e, 1, c04);
	keep_on_fetching_validx(gspca_dev, tbl_init_post_alt,
					ARRAY_SIZE(tbl_init_post_alt), n);
	ctrl_out(gspca_dev, 0x40, 3, 0x6000, 0x0200, 8, dat_post1);
	keep_on_fetching_validx(gspca_dev, tbl_init_post_alt,
					ARRAY_SIZE(tbl_init_post_alt), n);

	ctrl_in(gspca_dev, 0xc0, 2, 0x6000, 0x801e, 1, c04);
	keep_on_fetching_validx(gspca_dev, tbl_init_post_alt,
					ARRAY_SIZE(tbl_init_post_alt), n);
	ctrl_in(gspca_dev, 0xc0, 2, 0x6000, 0x801e, 1, c04);
	keep_on_fetching_validx(gspca_dev, tbl_init_post_alt,
					ARRAY_SIZE(tbl_init_post_alt), n);
	ctrl_in(gspca_dev, 0xc0, 2, 0x6000, 0x801e, 1, c04);
	keep_on_fetching_validx(gspca_dev, tbl_init_post_alt,
					ARRAY_SIZE(tbl_init_post_alt), n);
	ctrl_in(gspca_dev, 0xc0, 2, 0x6000, 0x801e, 1, c04);
	keep_on_fetching_validx(gspca_dev, tbl_init_post_alt,
					ARRAY_SIZE(tbl_init_post_alt), n);
	ctrl_out(gspca_dev, 0x40, 3, 0x6000, 0x0200, 8, dat_post1);
	keep_on_fetching_validx(gspca_dev, tbl_init_post_alt,
					ARRAY_SIZE(tbl_init_post_alt), n);

	ctrl_in(gspca_dev, 0xc0, 2, 0x6000, 0x801e, 1, c04);
	keep_on_fetching_validx(gspca_dev, tbl_init_post_alt,
					ARRAY_SIZE(tbl_init_post_alt), n);
	ctrl_in(gspca_dev, 0xc0, 2, 0x6000, 0x801e, 1, c04);
	keep_on_fetching_validx(gspca_dev, tbl_init_post_alt,
					ARRAY_SIZE(tbl_init_post_alt), n);

	ctrl_out(gspca_dev, 0x40, 3, 0x6000, 0x0200, 8, dat_post1);

	ctrl_out(gspca_dev, 0x40, 3, 0x0000, 0x0200, 4, dat_post2);
	ctrl_out(gspca_dev, 0x40, 3, 0x6000, 0x0200, 8, dat_post3);

	ctrl_out(gspca_dev, 0x40, 3, 0x0000, 0x0200, 4, dat_post4);
	ctrl_out(gspca_dev, 0x40, 3, 0x6000, 0x0200, 8, dat_post5);

	ctrl_out(gspca_dev, 0x40, 3, 0x0000, 0x0200, 4, dat_post6);
	ctrl_out(gspca_dev, 0x40, 3, 0x6000, 0x0200, 8, dat_post7);

	ctrl_out(gspca_dev, 0x40, 3, 0x6000, 0x0200, 8, dat_post8);

	ov9655_camera_settings(gspca_dev);

	return 0;
}

static int ov9655_configure_alt(struct gspca_dev *gspca_dev)
{
	s32 reso = gspca_dev->cam.cam_mode[(s32) gspca_dev->curr_mode].priv;

	switch (reso) {
	case IMAGE_640:
		gspca_dev->alt = 1 + 1;
		break;

	default:
		gspca_dev->alt = 1 + 1;
		break;
	}
	return 0;
}

static int ov9655_camera_settings(struct gspca_dev *gspca_dev)
{
	struct sd *sd = (struct sd *) gspca_dev;

	u8 dat_bright[] = "\x04\x00\x10\x7c\xa1\x00\x00\x70";

	s32 bright = sd->vcur.brightness;
	s32 hue    = sd->vcur.hue;

	if (bright != sd->vold.brightness) {
		sd->vold.brightness = bright;
		if (bright < 0 || bright > sd->vmax.brightness)
			bright = 0;

		dat_bright[3] = bright;
		ctrl_out(gspca_dev, 0x40, 3, 0x6000, 0x0200, 8, dat_bright);
	}

	if (hue != sd->vold.hue) {
		sd->vold.hue = hue;
		sd->swapRB = (hue != 0);
	}

	return 0;
}

static void ov9655_post_unset_alt(struct gspca_dev *gspca_dev)
{
	ctrl_out(gspca_dev, 0x40, 5, 0x0000, 0x0000, 0, NULL);
	ctrl_out(gspca_dev, 0x40, 1, 0x0061, 0x0000, 0, NULL);
}
