/* SPDX-License-Identifier: GPL-2.0-or-later */

#ifndef _LAN966X_SERDES_REGS_H_
#define _LAN966X_SERDES_REGS_H_

#include <linux/bitfield.h>
#include <linux/types.h>
#include <linux/bug.h>

enum lan966x_target {
	TARGET_HSIO = 32,
	NUM_TARGETS = 66
};

#define __REG(...)    __VA_ARGS__

/*      HSIO:SD:SD_CFG */
#define HSIO_SD_CFG(g)            __REG(TARGET_HSIO, 0, 1, 8, g, 3, 32, 0, 0, 1, 4)

#define HSIO_SD_CFG_PHY_RESET                    BIT(27)
#define HSIO_SD_CFG_PHY_RESET_SET(x)\
	FIELD_PREP(HSIO_SD_CFG_PHY_RESET, x)
#define HSIO_SD_CFG_PHY_RESET_GET(x)\
	FIELD_GET(HSIO_SD_CFG_PHY_RESET, x)

#define HSIO_SD_CFG_TX_RESET                     BIT(18)
#define HSIO_SD_CFG_TX_RESET_SET(x)\
	FIELD_PREP(HSIO_SD_CFG_TX_RESET, x)
#define HSIO_SD_CFG_TX_RESET_GET(x)\
	FIELD_GET(HSIO_SD_CFG_TX_RESET, x)

#define HSIO_SD_CFG_TX_RATE                      GENMASK(17, 16)
#define HSIO_SD_CFG_TX_RATE_SET(x)\
	FIELD_PREP(HSIO_SD_CFG_TX_RATE, x)
#define HSIO_SD_CFG_TX_RATE_GET(x)\
	FIELD_GET(HSIO_SD_CFG_TX_RATE, x)

#define HSIO_SD_CFG_TX_INVERT                    BIT(15)
#define HSIO_SD_CFG_TX_INVERT_SET(x)\
	FIELD_PREP(HSIO_SD_CFG_TX_INVERT, x)
#define HSIO_SD_CFG_TX_INVERT_GET(x)\
	FIELD_GET(HSIO_SD_CFG_TX_INVERT, x)

#define HSIO_SD_CFG_TX_EN                        BIT(14)
#define HSIO_SD_CFG_TX_EN_SET(x)\
	FIELD_PREP(HSIO_SD_CFG_TX_EN, x)
#define HSIO_SD_CFG_TX_EN_GET(x)\
	FIELD_GET(HSIO_SD_CFG_TX_EN, x)

#define HSIO_SD_CFG_TX_DATA_EN                   BIT(12)
#define HSIO_SD_CFG_TX_DATA_EN_SET(x)\
	FIELD_PREP(HSIO_SD_CFG_TX_DATA_EN, x)
#define HSIO_SD_CFG_TX_DATA_EN_GET(x)\
	FIELD_GET(HSIO_SD_CFG_TX_DATA_EN, x)

#define HSIO_SD_CFG_TX_CM_EN                     BIT(11)
#define HSIO_SD_CFG_TX_CM_EN_SET(x)\
	FIELD_PREP(HSIO_SD_CFG_TX_CM_EN, x)
#define HSIO_SD_CFG_TX_CM_EN_GET(x)\
	FIELD_GET(HSIO_SD_CFG_TX_CM_EN, x)

#define HSIO_SD_CFG_LANE_10BIT_SEL               BIT(10)
#define HSIO_SD_CFG_LANE_10BIT_SEL_SET(x)\
	FIELD_PREP(HSIO_SD_CFG_LANE_10BIT_SEL, x)
#define HSIO_SD_CFG_LANE_10BIT_SEL_GET(x)\
	FIELD_GET(HSIO_SD_CFG_LANE_10BIT_SEL, x)

#define HSIO_SD_CFG_RX_TERM_EN                   BIT(9)
#define HSIO_SD_CFG_RX_TERM_EN_SET(x)\
	FIELD_PREP(HSIO_SD_CFG_RX_TERM_EN, x)
#define HSIO_SD_CFG_RX_TERM_EN_GET(x)\
	FIELD_GET(HSIO_SD_CFG_RX_TERM_EN, x)

#define HSIO_SD_CFG_RX_RESET                     BIT(8)
#define HSIO_SD_CFG_RX_RESET_SET(x)\
	FIELD_PREP(HSIO_SD_CFG_RX_RESET, x)
#define HSIO_SD_CFG_RX_RESET_GET(x)\
	FIELD_GET(HSIO_SD_CFG_RX_RESET, x)

#define HSIO_SD_CFG_RX_RATE                      GENMASK(7, 6)
#define HSIO_SD_CFG_RX_RATE_SET(x)\
	FIELD_PREP(HSIO_SD_CFG_RX_RATE, x)
#define HSIO_SD_CFG_RX_RATE_GET(x)\
	FIELD_GET(HSIO_SD_CFG_RX_RATE, x)

#define HSIO_SD_CFG_RX_PLL_EN                    BIT(5)
#define HSIO_SD_CFG_RX_PLL_EN_SET(x)\
	FIELD_PREP(HSIO_SD_CFG_RX_PLL_EN, x)
#define HSIO_SD_CFG_RX_PLL_EN_GET(x)\
	FIELD_GET(HSIO_SD_CFG_RX_PLL_EN, x)

#define HSIO_SD_CFG_RX_INVERT                    BIT(3)
#define HSIO_SD_CFG_RX_INVERT_SET(x)\
	FIELD_PREP(HSIO_SD_CFG_RX_INVERT, x)
#define HSIO_SD_CFG_RX_INVERT_GET(x)\
	FIELD_GET(HSIO_SD_CFG_RX_INVERT, x)

#define HSIO_SD_CFG_RX_DATA_EN                   BIT(2)
#define HSIO_SD_CFG_RX_DATA_EN_SET(x)\
	FIELD_PREP(HSIO_SD_CFG_RX_DATA_EN, x)
#define HSIO_SD_CFG_RX_DATA_EN_GET(x)\
	FIELD_GET(HSIO_SD_CFG_RX_DATA_EN, x)

#define HSIO_SD_CFG_LANE_LOOPBK_EN               BIT(0)
#define HSIO_SD_CFG_LANE_LOOPBK_EN_SET(x)\
	FIELD_PREP(HSIO_SD_CFG_LANE_LOOPBK_EN, x)
#define HSIO_SD_CFG_LANE_LOOPBK_EN_GET(x)\
	FIELD_GET(HSIO_SD_CFG_LANE_LOOPBK_EN, x)

/*      HSIO:SD:MPLL_CFG */
#define HSIO_MPLL_CFG(g)          __REG(TARGET_HSIO, 0, 1, 8, g, 3, 32, 8, 0, 1, 4)

#define HSIO_MPLL_CFG_REF_SSP_EN                 BIT(18)
#define HSIO_MPLL_CFG_REF_SSP_EN_SET(x)\
	FIELD_PREP(HSIO_MPLL_CFG_REF_SSP_EN, x)
#define HSIO_MPLL_CFG_REF_SSP_EN_GET(x)\
	FIELD_GET(HSIO_MPLL_CFG_REF_SSP_EN, x)

#define HSIO_MPLL_CFG_REF_CLKDIV2                BIT(17)
#define HSIO_MPLL_CFG_REF_CLKDIV2_SET(x)\
	FIELD_PREP(HSIO_MPLL_CFG_REF_CLKDIV2, x)
#define HSIO_MPLL_CFG_REF_CLKDIV2_GET(x)\
	FIELD_GET(HSIO_MPLL_CFG_REF_CLKDIV2, x)

#define HSIO_MPLL_CFG_MPLL_EN                    BIT(16)
#define HSIO_MPLL_CFG_MPLL_EN_SET(x)\
	FIELD_PREP(HSIO_MPLL_CFG_MPLL_EN, x)
#define HSIO_MPLL_CFG_MPLL_EN_GET(x)\
	FIELD_GET(HSIO_MPLL_CFG_MPLL_EN, x)

#define HSIO_MPLL_CFG_MPLL_MULTIPLIER            GENMASK(6, 0)
#define HSIO_MPLL_CFG_MPLL_MULTIPLIER_SET(x)\
	FIELD_PREP(HSIO_MPLL_CFG_MPLL_MULTIPLIER, x)
#define HSIO_MPLL_CFG_MPLL_MULTIPLIER_GET(x)\
	FIELD_GET(HSIO_MPLL_CFG_MPLL_MULTIPLIER, x)

/*      HSIO:SD:SD_STAT */
#define HSIO_SD_STAT(g)           __REG(TARGET_HSIO, 0, 1, 8, g, 3, 32, 12, 0, 1, 4)

#define HSIO_SD_STAT_MPLL_STATE                  BIT(6)
#define HSIO_SD_STAT_MPLL_STATE_SET(x)\
	FIELD_PREP(HSIO_SD_STAT_MPLL_STATE, x)
#define HSIO_SD_STAT_MPLL_STATE_GET(x)\
	FIELD_GET(HSIO_SD_STAT_MPLL_STATE, x)

#define HSIO_SD_STAT_TX_STATE                    BIT(5)
#define HSIO_SD_STAT_TX_STATE_SET(x)\
	FIELD_PREP(HSIO_SD_STAT_TX_STATE, x)
#define HSIO_SD_STAT_TX_STATE_GET(x)\
	FIELD_GET(HSIO_SD_STAT_TX_STATE, x)

#define HSIO_SD_STAT_TX_CM_STATE                 BIT(2)
#define HSIO_SD_STAT_TX_CM_STATE_SET(x)\
	FIELD_PREP(HSIO_SD_STAT_TX_CM_STATE, x)
#define HSIO_SD_STAT_TX_CM_STATE_GET(x)\
	FIELD_GET(HSIO_SD_STAT_TX_CM_STATE, x)

#define HSIO_SD_STAT_RX_PLL_STATE                BIT(0)
#define HSIO_SD_STAT_RX_PLL_STATE_SET(x)\
	FIELD_PREP(HSIO_SD_STAT_RX_PLL_STATE, x)
#define HSIO_SD_STAT_RX_PLL_STATE_GET(x)\
	FIELD_GET(HSIO_SD_STAT_RX_PLL_STATE, x)

/*      HSIO:HW_CFGSTAT:HW_CFG */
#define HSIO_HW_CFG               __REG(TARGET_HSIO, 0, 1, 104, 0, 1, 52, 0, 0, 1, 4)

#define HSIO_HW_CFG_RGMII_1_CFG                  BIT(15)
#define HSIO_HW_CFG_RGMII_1_CFG_SET(x)\
	(((x) << 15) & GENMASK(15, 15))
#define HSIO_HW_CFG_RGMII_1_CFG_GET(x)\
	FIELD_GET(HSIO_HW_CFG_RGMII_1_CFG, x)

#define HSIO_HW_CFG_RGMII_0_CFG                  BIT(14)
#define HSIO_HW_CFG_RGMII_0_CFG_SET(x)\
	(((x) << 14) & GENMASK(14, 14))
#define HSIO_HW_CFG_RGMII_0_CFG_GET(x)\
	FIELD_GET(HSIO_HW_CFG_RGMII_0_CFG, x)

#define HSIO_HW_CFG_RGMII_ENA                    GENMASK(13, 12)
#define HSIO_HW_CFG_RGMII_ENA_SET(x)\
	(((x) << 12) & GENMASK(13, 12))
#define HSIO_HW_CFG_RGMII_ENA_GET(x)\
	FIELD_GET(HSIO_HW_CFG_RGMII_ENA, x)

#define HSIO_HW_CFG_SD6G_0_CFG                   BIT(11)
#define HSIO_HW_CFG_SD6G_0_CFG_SET(x)\
	(((x) << 11) & GENMASK(11, 11))
#define HSIO_HW_CFG_SD6G_0_CFG_GET(x)\
	FIELD_GET(HSIO_HW_CFG_SD6G_0_CFG, x)

#define HSIO_HW_CFG_SD6G_1_CFG                   BIT(10)
#define HSIO_HW_CFG_SD6G_1_CFG_SET(x)\
	(((x) << 10) & GENMASK(10, 10))
#define HSIO_HW_CFG_SD6G_1_CFG_GET(x)\
	FIELD_GET(HSIO_HW_CFG_SD6G_1_CFG, x)

#define HSIO_HW_CFG_GMII_ENA                     GENMASK(9, 2)
#define HSIO_HW_CFG_GMII_ENA_SET(x)\
	(((x) << 2) & GENMASK(9, 2))
#define HSIO_HW_CFG_GMII_ENA_GET(x)\
	FIELD_GET(HSIO_HW_CFG_GMII_ENA, x)

#define HSIO_HW_CFG_QSGMII_ENA                   GENMASK(1, 0)
#define HSIO_HW_CFG_QSGMII_ENA_SET(x)\
	((x) & GENMASK(1, 0))
#define HSIO_HW_CFG_QSGMII_ENA_GET(x)\
	FIELD_GET(HSIO_HW_CFG_QSGMII_ENA, x)

/*      HSIO:HW_CFGSTAT:RGMII_CFG */
#define HSIO_RGMII_CFG(r)         __REG(TARGET_HSIO, 0, 1, 104, 0, 1, 52, 20, r, 2, 4)

#define HSIO_RGMII_CFG_TX_CLK_CFG                GENMASK(4, 2)
#define HSIO_RGMII_CFG_TX_CLK_CFG_SET(x)\
	FIELD_PREP(HSIO_RGMII_CFG_TX_CLK_CFG, x)
#define HSIO_RGMII_CFG_TX_CLK_CFG_GET(x)\
	FIELD_GET(HSIO_RGMII_CFG_TX_CLK_CFG, x)

#define HSIO_RGMII_CFG_RGMII_TX_RST              BIT(1)
#define HSIO_RGMII_CFG_RGMII_TX_RST_SET(x)\
	FIELD_PREP(HSIO_RGMII_CFG_RGMII_TX_RST, x)
#define HSIO_RGMII_CFG_RGMII_TX_RST_GET(x)\
	FIELD_GET(HSIO_RGMII_CFG_RGMII_TX_RST, x)

#define HSIO_RGMII_CFG_RGMII_RX_RST              BIT(0)
#define HSIO_RGMII_CFG_RGMII_RX_RST_SET(x)\
	FIELD_PREP(HSIO_RGMII_CFG_RGMII_RX_RST, x)
#define HSIO_RGMII_CFG_RGMII_RX_RST_GET(x)\
	FIELD_GET(HSIO_RGMII_CFG_RGMII_RX_RST, x)

/*      HSIO:HW_CFGSTAT:DLL_CFG */
#define HSIO_DLL_CFG(r)           __REG(TARGET_HSIO, 0, 1, 104, 0, 1, 52, 36, r, 4, 4)

#define HSIO_DLL_CFG_DELAY_ENA                   BIT(2)
#define HSIO_DLL_CFG_DELAY_ENA_SET(x)\
	FIELD_PREP(HSIO_DLL_CFG_DELAY_ENA, x)
#define HSIO_DLL_CFG_DELAY_ENA_GET(x)\
	FIELD_GET(HSIO_DLL_CFG_DELAY_ENA, x)

#define HSIO_DLL_CFG_DLL_ENA                     BIT(1)
#define HSIO_DLL_CFG_DLL_ENA_SET(x)\
	FIELD_PREP(HSIO_DLL_CFG_DLL_ENA, x)
#define HSIO_DLL_CFG_DLL_ENA_GET(x)\
	FIELD_GET(HSIO_DLL_CFG_DLL_ENA, x)

#define HSIO_DLL_CFG_DLL_RST                     BIT(0)
#define HSIO_DLL_CFG_DLL_RST_SET(x)\
	FIELD_PREP(HSIO_DLL_CFG_DLL_RST, x)
#define HSIO_DLL_CFG_DLL_RST_GET(x)\
	FIELD_GET(HSIO_DLL_CFG_DLL_RST, x)

#endif /* _LAN966X_HSIO_REGS_H_ */
