/* THese constants are for the segment types stored in the image headers */
#define PT_NULL    0
#define PT_LOAD    1
#define PT_DYNAMIC 2
#define PT_INTERP  3
#define PT_NOTE    4
#define PT_SHLIB   5
#define PT_PHDR    6
#define PT_LOPROC  0x70000000
#define PT_HIPROC  0x7fffffff

/* These constants define the different elf file types */
#define ET_NONE   0
#define ET_REL    1
#define ET_EXEC   2
#define ET_DYN    3
#define ET_CORE   4
#define ET_LOPROC 5
#define ET_HIPROC 6

/* These constants define the various ELF target machines */
#define EM_NONE  0
#define EM_M32   1
#define EM_SPARC 2
#define EM_386   3
#define EM_68K   4
#define EM_88K   5
#define EM_486   6   /* Perhaps disused */
#define EM_860   7

/* This is the info that is needed to parse the dynamic section of the file */
#define DT_NULL		0
#define DT_NEEDED	1
#define DT_PLTRELSZ	2
#define DT_PLTGOT	3
#define DT_HASH		4
#define DT_STRTAB	5
#define DT_SYMTAB	6
#define DT_RELA		7
#define DT_RELASZ	8
#define DT_RELAENT	9
#define DT_STRSZ	10
#define DT_SYMENT	11
#define DT_INIT		12
#define DT_FINI		13
#define DT_SONAME	14
#define DT_RPATH 	15
#define DT_SYMBOLIC	16
#define DT_REL	        17
#define DT_RELSZ	18
#define DT_RELENT	19
#define DT_PLTREL	20
#define DT_DEBUG	21
#define DT_TEXTREL	22
#define DT_JMPREL	23
#define DT_LOPROC	0x70000000
#define DT_HIPROC	0x7fffffff

/* This info is needed when parsing the symbol table */
#define STB_LOCAL  0
#define STB_GLOBAL 1
#define STB_WEAK   2

#define STT_NOTYPE  0
#define STT_OBJECT  1
#define STT_FUNC    2
#define STT_SECTION 3
#define STT_FILE    4

#define ELF32_ST_BIND(x) ((x) >> 4)
#define ELF32_ST_TYPE(x) (((unsigned int) x) & 0xf)


#if 0
struct dynamic{
  int d_tag;
  union{
    int d_val;
    char * d_ptr;
  } d_un;
};
#endif

/* THe following are used with relocations */
#define ELF32_R_SYM(x) ((x) >> 8)
#define ELF32_R_TYPE(x) ((x) & 0xff)

#define R_386_NONE	0
#define R_386_32	1
#define R_386_PC32	2
#define R_386_GOT32	3
#define R_386_PLT32	4
#define R_386_COPY	5
#define R_386_GLOB_DAT	6
#define R_386_JMP_SLOT	7
#define R_386_RELATIVE	8
#define R_386_GOTOFF	9
#define R_386_GOTPC	10
#define R_386_NUM	11

struct Elf32_Rel{
  unsigned int * offset;
  int info;
};

struct Elf32_Rela{
  unsigned int * offset;
  int info;
  int addend;
};

struct Elf32_Sym{
  int st_name;
  unsigned int st_value;
  int st_size;
  unsigned char st_info;
  unsigned char st_other;
  short int st_shndx;
};

#if 0

struct elfhdr{
  char	e_ident[16];
  short int e_type;
  short int e_machine;
  int   e_version;
  char *e_entry;  /* Entry point */
  int   e_phoff;
  int   e_shoff;
  int   e_flags;
  short int e_ehsize;
  short int e_phentsize;
  short int e_phnum;
  short int e_shentsize;
  short int e_shnum;
  short int e_shstrndx;
};

struct elf_phdr{
  int p_type;
  int p_offset;
  int p_vaddr;
  int p_paddr;
  int p_filesz;
  int p_memsz;
  int p_flags;
  int p_align;
};

#endif

extern _dl_linux_resolve(void);
extern struct elf_resolve * _dl_load_shared_library(struct dyn_elf *,
				char * libname);
extern void * _dl_malloc(int size);

extern struct elf_resolve * _dl_load_elf_shared_library(char * libname, int);
int _dl_copy_fixups(struct dyn_elf * tpnt);

extern int linux_run(int argc, char * argv[]);

extern void _dl_parse_lazy_relocation_information(struct elf_resolve * tpnt, int rel_addr,
       int rel_size, int type);

extern int _dl_parse_relocation_information(struct elf_resolve * tpnt, int rel_addr,
       int rel_size, int type);
extern int _dl_parse_copy_information(struct dyn_elf * rpnt, int rel_addr,
       int rel_size, int type);

extern unsigned int _dl_linux_resolver(int dummy, int i);


/* This means that we may be forced to manually search for copy fixups
   which were omitted by the linker.  We cannot depend upon the DT_TEXTREL
   to tell us whether there are fixups in a text section or not. */

#ifndef SVR4_BUGCOMPAT
#define SVR4_BUGCOMPAT 1
#endif

#ifndef PF_R
#define PF_R 4
#define PF_W 2
#define PF_X 1
#endif

/* Convert between the Linux flags for page protections and the
   ones specified in the ELF standard. */

#define LXFLAGS(X) ( (((X) & PF_R) ? PROT_READ : 0) | \
		    (((X) & PF_W) ? PROT_WRITE : 0) | \
		    (((X) & PF_X) ? PROT_EXEC : 0))

/* Use BROKEN_LINKER if the SVr4 linker is being used.  It fails to emit
   COPY relocations in some cases */

#ifdef IBCS_COMPATIBLE
#define BROKEN_LINKER
#endif
