#include <stdlib.h>

#include <security/pam_appl.h>
#include <security/pam_misc.h>

/*This is an include file made of functions in lib directory.*/

#define RHOST_UNKNOWN_NAME        ""     /* perhaps "[from.where?]" */

#define DEVICE_FILE_PREFIX        "/dev/"

#define WTMP_LOCK_TIMEOUT         3      /* in seconds */

#ifndef UT_IDSIZE
#define UT_IDSIZE 4            /* XXX - this is sizeof(struct utmp.ut_id) */
#endif

int make_environment(pam_handle_t *pamh, int keep_env);
int set_user_credentials(pam_handle_t *pamh, int login
                                , const char **user, uid_t *uid
                                , const char **shell);
int set_user_credentials(pam_handle_t *pamh, int login
                                , const char **user, uid_t *uid
                                , const char **shell);
char * const *build_shell_args(const char *pw_shell
                                      , int login, const char *command);
void wait_for_child_catch_sig(int sig);
void prepare_for_job_control(pid_t child, int need_it);
int wait_for_child(pid_t child);
const struct utmp *find_utmp_entry(const char *ut_line
        , const char *ut_id);
void set_terminal_name(const char *terminal, char *ut_line, char *ut_id);
int write_wtmp(struct utmp *u_tmp_p
                      , const char **callname, const char **err_descr);
int utmp_open_session(pam_handle_t *pamh, pid_t pid
                             , const char **callname, const char **err_descr);
int utmp_close_session(pam_handle_t *pamh
                              , const char **callname, const char **err_descr);

