
/* TreeSize for Unix  http://treesize.sf.net/
 * Copyright (c) 2006-2007 Marcos Diez <marcos_AT_unitron.com.br>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 */

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include "util.h"


char printBuffer[PRINT_BUFFER_SIZE];

void doNothing( void *a , void *b , void *c , void *d){
  printf("DoNothing was called: %p , %p , %p ,%p\n" , a , b , c , d );
}

void *xMalloc( const size_t size ){
  void *x = malloc( size );

  if( x ) return x;

  printf("Fatal Error: could not allocate %d bytes of memory with malloc()\n" , size );
  exit( ENOMEM );

}


void *xRealloc( void *ptr, const size_t size ){
  void *x = realloc( ptr , size );

  if( x ) return x;

  printf("Fatal Error: could not allocate %d bytes of memory with realloc()\n" , size );
  exit( ENOMEM );

}

void *xCalloc( const size_t nmemb, const size_t size ){

  void *x = calloc( nmemb , size );
  if( x ) return x;

  printf("Fatal Error: could not allocate %d blocks of %d bytes of memory with calloc()\n" , nmemb , size );
  exit( ENOMEM );


}


void *memdup( const void *src , size_t n ){
  void *x  = xMalloc( n );
  memcpy( x , src , n );
  return x;
}

/* unsigned int getGCD(unsigned int u, unsigned int v) { /\* great common divisor *\/ */
/*   /\* source: http://en.wikipedia.org/wiki/Euclidean_algorithm  *\/ */
/*   /\* knuth said it is faster *\/ */
/*   unsigned int k = 0; */
/*   if (u == 0) */
/*     return v; */
/*   if (v == 0) */
/*     return u; */
/*   while ((u & 1) == 0  &&  (v & 1) == 0) { /\* while both u and v are even *\/ */
/*     u >>= 1;   /\* shift u right, dividing it by 2 *\/ */
/*     v >>= 1;   /\* shift v right, dividing it by 2 *\/ */
/*     k++;       /\* add a power of 2 to the final result *\/ */
/*   } */
/*   /\* At this point either u or v (or both) is odd *\/ */
/*   do { */
/*     if ((u & 1) == 0)      /\* if u is even *\/ */
/*       u >>= 1;           /\* divide u by 2 *\/ */
/*     else if ((v & 1) == 0) /\* else if v is even *\/ */
/*       v >>= 1;           /\* divide v by 2 *\/ */
/*     else if (u >= v)       /\* u and v are both odd *\/ */
/*       u = (u-v) >> 1; */
/*     else                   /\* u and v both odd, v > u *\/ */
/*       v = (v-u) >> 1; */
/*   } while (u > 0); */
/*   return v << k;  /\* returns v * 2^k *\/ */
/* } */

/* unsigned int getLCM( unsigned int u , unsigned int v ){ */
/*   return (int)((double)(u*v)/getGCD(u,v)); */
/* } */

/* unsigned int getGCD(unsigned int a, unsigned int b) {	/\* great common divisor *\/ */
/* /\*   source: http://en.wikipedia.org/wiki/Euclidean_algorithm *\/ */
/*   unsigned int t; */
/*   while (b != 0) { */
/*     t = b; */
/*     b = a % b; */
/*     a = t; */
/*   } */
/*   return a; */
/* } */

static double mod( double p , double q ){
  double t= p/q;
/*   printf("%s(%g,%g)\n" , __FUNCTION__ , p , q ); */
  t =  (t- (unsigned int) t)*q;
  if( t < .05 ) return 0;
  return t;
}

double getLCM( double u , double v ){
/*   printf("%s(%f,%f)\n" , __FUNCTION__ , u , v ); */
  return (int)((double)(u*v)/getGCD(u,v));
}

double getGCD(double a, double b) {	/* great common divisor */
/*   source: http://en.wikipedia.org/wiki/Euclidean_algorithm */
  double t;
/*   printf("%s(%f,%f)\n" , __FUNCTION__ , a , b ); */
  while (b != 0) {
    t = b;
    b = mod( a , b );
    a = t;
  }
  return a;
}

