.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "ALTER AGGREGATE" "" "2007-02-01" "SQL - Language Statements" "SQL Commands"
.SH NAME
ALTER AGGREGATE \- change the definition of an aggregate function

.SH SYNOPSIS
.sp
.nf
ALTER AGGREGATE \fIname\fR ( \fItype\fR ) RENAME TO \fInewname\fR
ALTER AGGREGATE \fIname\fR ( \fItype\fR ) OWNER TO \fInewowner\fR
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBALTER AGGREGATE\fR changes the definition of an
aggregate function.
.SH "PARAMETERS"
.TP
\fB\fIname\fB\fR
The name (optionally schema-qualified) of an existing aggregate function.
.TP
\fB\fItype\fB\fR
The argument data type of the aggregate function, or
* if the function accepts any data type.
.TP
\fB\fInewname\fB\fR
The new name of the aggregate function.
.TP
\fB\fInewowner\fB\fR
The new owner of the aggregate function.
You must be a superuser to change an aggregate's owner.
.SH "EXAMPLES"
.PP
To rename the aggregate function myavg for type
\fBinteger\fR to my_average:
.sp
.nf
ALTER AGGREGATE myavg(integer) RENAME TO my_average;
.sp
.fi
.PP
To change the owner of the aggregate function myavg for type
\fBinteger\fR to joe:
.sp
.nf
ALTER AGGREGATE myavg(integer) OWNER TO joe;
.sp
.fi
.SH "COMPATIBILITY"
.PP
There is no \fBALTER AGGREGATE\fR statement in the SQL
standard.
.SH "SEE ALSO"
CREATE AGGREGATE [\fBcreate_aggregate\fR(l)], DROP AGGREGATE [\fBdrop_aggregate\fR(l)]
