/* A Bison parser, made by GNU Bison 1.875.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Using locations.  */
#define YYLSP_NEEDED 0



/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     SQL_ALLOCATE = 258,
     SQL_AUTOCOMMIT = 259,
     SQL_BOOL = 260,
     SQL_BREAK = 261,
     SQL_CALL = 262,
     SQL_CARDINALITY = 263,
     SQL_CONNECT = 264,
     SQL_CONNECTION = 265,
     SQL_CONTINUE = 266,
     SQL_COUNT = 267,
     SQL_CURRENT = 268,
     SQL_DATA = 269,
     SQL_DATETIME_INTERVAL_CODE = 270,
     SQL_DATETIME_INTERVAL_PRECISION = 271,
     SQL_DESCRIBE = 272,
     SQL_DESCRIPTOR = 273,
     SQL_DISCONNECT = 274,
     SQL_ENUM = 275,
     SQL_FOUND = 276,
     SQL_FREE = 277,
     SQL_GO = 278,
     SQL_GOTO = 279,
     SQL_IDENTIFIED = 280,
     SQL_INDICATOR = 281,
     SQL_KEY_MEMBER = 282,
     SQL_LENGTH = 283,
     SQL_LONG = 284,
     SQL_NAME = 285,
     SQL_NULLABLE = 286,
     SQL_OCTET_LENGTH = 287,
     SQL_OPEN = 288,
     SQL_OUTPUT = 289,
     SQL_REFERENCE = 290,
     SQL_RETURNED_LENGTH = 291,
     SQL_RETURNED_OCTET_LENGTH = 292,
     SQL_SCALE = 293,
     SQL_SECTION = 294,
     SQL_SHORT = 295,
     SQL_SIGNED = 296,
     SQL_SQL = 297,
     SQL_SQLERROR = 298,
     SQL_SQLPRINT = 299,
     SQL_SQLWARNING = 300,
     SQL_START = 301,
     SQL_STOP = 302,
     SQL_STRUCT = 303,
     SQL_UNSIGNED = 304,
     SQL_VALUE = 305,
     SQL_VAR = 306,
     SQL_WHENEVER = 307,
     S_ADD = 308,
     S_AND = 309,
     S_ANYTHING = 310,
     S_AUTO = 311,
     S_CONST = 312,
     S_DEC = 313,
     S_DIV = 314,
     S_DOTPOINT = 315,
     S_EQUAL = 316,
     S_EXTERN = 317,
     S_INC = 318,
     S_LSHIFT = 319,
     S_MEMPOINT = 320,
     S_MEMBER = 321,
     S_MOD = 322,
     S_MUL = 323,
     S_NEQUAL = 324,
     S_OR = 325,
     S_REGISTER = 326,
     S_RSHIFT = 327,
     S_STATIC = 328,
     S_SUB = 329,
     S_VOLATILE = 330,
     S_TYPEDEF = 331,
     TYPECAST = 332,
     ABORT_P = 333,
     ABSOLUTE_P = 334,
     ACCESS = 335,
     ACTION = 336,
     ADD = 337,
     AFTER = 338,
     AGGREGATE = 339,
     ALL = 340,
     ALSO = 341,
     ALTER = 342,
     ANALYSE = 343,
     ANALYZE = 344,
     AND = 345,
     ANY = 346,
     ARRAY = 347,
     AS = 348,
     ASC = 349,
     ASSERTION = 350,
     ASSIGNMENT = 351,
     AT = 352,
     AUTHORIZATION = 353,
     BACKWARD = 354,
     BEFORE = 355,
     BEGIN_P = 356,
     BETWEEN = 357,
     BIGINT = 358,
     BINARY = 359,
     BIT = 360,
     BOOLEAN_P = 361,
     BOTH = 362,
     BY = 363,
     CACHE = 364,
     CALLED = 365,
     CASCADE = 366,
     CASE = 367,
     CAST = 368,
     CHAIN = 369,
     CHAR_P = 370,
     CHARACTER = 371,
     CHARACTERISTICS = 372,
     CHECK = 373,
     CHECKPOINT = 374,
     CLASS = 375,
     CLOSE = 376,
     CLUSTER = 377,
     COALESCE = 378,
     COLLATE = 379,
     COLUMN = 380,
     COMMENT = 381,
     COMMIT = 382,
     COMMITTED = 383,
     CONSTRAINT = 384,
     CONSTRAINTS = 385,
     CONVERSION_P = 386,
     CONVERT = 387,
     COPY = 388,
     CREATE = 389,
     CREATEDB = 390,
     CREATEUSER = 391,
     CROSS = 392,
     CSV = 393,
     CURRENT_DATE = 394,
     CURRENT_TIME = 395,
     CURRENT_TIMESTAMP = 396,
     CURRENT_USER = 397,
     CURSOR = 398,
     CYCLE = 399,
     DATABASE = 400,
     DAY_P = 401,
     DEALLOCATE = 402,
     DEC = 403,
     DECIMAL_P = 404,
     DECLARE = 405,
     DEFAULT = 406,
     DEFAULTS = 407,
     DEFERRABLE = 408,
     DEFERRED = 409,
     DEFINER = 410,
     DELETE_P = 411,
     DELIMITER = 412,
     DELIMITERS = 413,
     DESC = 414,
     DISTINCT = 415,
     DO = 416,
     DOMAIN_P = 417,
     DOUBLE_P = 418,
     DROP = 419,
     EACH = 420,
     ELSE = 421,
     ENCODING = 422,
     ENCRYPTED = 423,
     END_P = 424,
     ESCAPE = 425,
     EXCEPT = 426,
     EXCLUSIVE = 427,
     EXCLUDING = 428,
     EXECUTE = 429,
     EXISTS = 430,
     EXPLAIN = 431,
     EXTERNAL = 432,
     EXTRACT = 433,
     FALSE_P = 434,
     FETCH = 435,
     FIRST_P = 436,
     FLOAT_P = 437,
     FOR = 438,
     FORCE = 439,
     FOREIGN = 440,
     FORWARD = 441,
     FREEZE = 442,
     FROM = 443,
     FULL = 444,
     FUNCTION = 445,
     GET = 446,
     GLOBAL = 447,
     GRANT = 448,
     GROUP_P = 449,
     HANDLER = 450,
     HAVING = 451,
     HOLD = 452,
     HOUR_P = 453,
     ILIKE = 454,
     IMMEDIATE = 455,
     IMMUTABLE = 456,
     IMPLICIT_P = 457,
     IN_P = 458,
     INCLUDING = 459,
     INCREMENT = 460,
     INDEX = 461,
     INHERITS = 462,
     INITIALLY = 463,
     INNER_P = 464,
     INOUT = 465,
     INPUT_P = 466,
     INSENSITIVE = 467,
     INSERT = 468,
     INSTEAD = 469,
     INT_P = 470,
     INTEGER = 471,
     INTERSECT = 472,
     INTERVAL = 473,
     INTO = 474,
     INVOKER = 475,
     IS = 476,
     ISNULL = 477,
     ISOLATION = 478,
     JOIN = 479,
     KEY = 480,
     LANCOMPILER = 481,
     LANGUAGE = 482,
     LARGE_P = 483,
     LAST_P = 484,
     LEADING = 485,
     LEFT = 486,
     LEVEL = 487,
     LIKE = 488,
     LIMIT = 489,
     LISTEN = 490,
     LOAD = 491,
     LOCAL = 492,
     LOCATION = 493,
     LOCK_P = 494,
     MATCH = 495,
     MAXVALUE = 496,
     MINUTE_P = 497,
     MINVALUE = 498,
     MODE = 499,
     MONTH_P = 500,
     MOVE = 501,
     NAMES = 502,
     NATIONAL = 503,
     NATURAL = 504,
     NCHAR = 505,
     NEW = 506,
     NEXT = 507,
     NO = 508,
     NOCREATEDB = 509,
     NOCREATEUSER = 510,
     NONE = 511,
     NOT = 512,
     NOTHING = 513,
     NOTIFY = 514,
     NOTNULL = 515,
     NOWAIT = 516,
     NULL_P = 517,
     NULLIF = 518,
     NUMERIC = 519,
     OBJECT_P = 520,
     OF = 521,
     OFF = 522,
     OFFSET = 523,
     OIDS = 524,
     OLD = 525,
     ON = 526,
     ONLY = 527,
     OPERATOR = 528,
     OPTION = 529,
     OR = 530,
     ORDER = 531,
     OUT_P = 532,
     OUTER_P = 533,
     OVERLAPS = 534,
     OVERLAY = 535,
     OWNER = 536,
     PARTIAL = 537,
     PASSWORD = 538,
     PLACING = 539,
     POSITION = 540,
     PRECISION = 541,
     PRESERVE = 542,
     PREPARE = 543,
     PRIMARY = 544,
     PRIOR = 545,
     PRIVILEGES = 546,
     PROCEDURAL = 547,
     PROCEDURE = 548,
     QUOTE = 549,
     READ = 550,
     REAL = 551,
     RECHECK = 552,
     REFERENCES = 553,
     REINDEX = 554,
     RELATIVE_P = 555,
     RELEASE = 556,
     RENAME = 557,
     REPEATABLE = 558,
     REPLACE = 559,
     RESET = 560,
     RESTART = 561,
     RESTRICT = 562,
     RETURNS = 563,
     REVOKE = 564,
     RIGHT = 565,
     ROLLBACK = 566,
     ROW = 567,
     ROWS = 568,
     RULE = 569,
     SAVEPOINT = 570,
     SCHEMA = 571,
     SCROLL = 572,
     SECOND_P = 573,
     SECURITY = 574,
     SELECT = 575,
     SEQUENCE = 576,
     SERIALIZABLE = 577,
     SESSION = 578,
     SESSION_USER = 579,
     SET = 580,
     SETOF = 581,
     SHARE = 582,
     SHOW = 583,
     SIMILAR = 584,
     SIMPLE = 585,
     SMALLINT = 586,
     SOME = 587,
     STABLE = 588,
     START = 589,
     STATEMENT = 590,
     STATISTICS = 591,
     STDIN = 592,
     STDOUT = 593,
     STORAGE = 594,
     STRICT_P = 595,
     SUBSTRING = 596,
     SYSID = 597,
     TABLE = 598,
     TABLESPACE = 599,
     TEMP = 600,
     TEMPLATE = 601,
     TEMPORARY = 602,
     THEN = 603,
     TIME = 604,
     TIMESTAMP = 605,
     TO = 606,
     TOAST = 607,
     TRAILING = 608,
     TRANSACTION = 609,
     TREAT = 610,
     TRIGGER = 611,
     TRIM = 612,
     TRUE_P = 613,
     TRUNCATE = 614,
     TRUSTED = 615,
     TYPE_P = 616,
     UNCOMMITTED = 617,
     UNENCRYPTED = 618,
     UNION = 619,
     UNIQUE = 620,
     UNKNOWN = 621,
     UNLISTEN = 622,
     UNTIL = 623,
     UPDATE = 624,
     USAGE = 625,
     USER = 626,
     USING = 627,
     VACUUM = 628,
     VALID = 629,
     VALUES = 630,
     VARCHAR = 631,
     VARYING = 632,
     VERBOSE = 633,
     VIEW = 634,
     VOLATILE = 635,
     WHEN = 636,
     WHERE = 637,
     WITH = 638,
     WITHOUT = 639,
     WORK = 640,
     WRITE = 641,
     YEAR_P = 642,
     ZONE = 643,
     UNIONJOIN = 644,
     IDENT = 645,
     SCONST = 646,
     Op = 647,
     CSTRING = 648,
     CVARIABLE = 649,
     CPP_LINE = 650,
     IP = 651,
     BCONST = 652,
     XCONST = 653,
     ICONST = 654,
     PARAM = 655,
     FCONST = 656,
     POSTFIXOP = 657,
     UMINUS = 658
   };
#endif
#define SQL_ALLOCATE 258
#define SQL_AUTOCOMMIT 259
#define SQL_BOOL 260
#define SQL_BREAK 261
#define SQL_CALL 262
#define SQL_CARDINALITY 263
#define SQL_CONNECT 264
#define SQL_CONNECTION 265
#define SQL_CONTINUE 266
#define SQL_COUNT 267
#define SQL_CURRENT 268
#define SQL_DATA 269
#define SQL_DATETIME_INTERVAL_CODE 270
#define SQL_DATETIME_INTERVAL_PRECISION 271
#define SQL_DESCRIBE 272
#define SQL_DESCRIPTOR 273
#define SQL_DISCONNECT 274
#define SQL_ENUM 275
#define SQL_FOUND 276
#define SQL_FREE 277
#define SQL_GO 278
#define SQL_GOTO 279
#define SQL_IDENTIFIED 280
#define SQL_INDICATOR 281
#define SQL_KEY_MEMBER 282
#define SQL_LENGTH 283
#define SQL_LONG 284
#define SQL_NAME 285
#define SQL_NULLABLE 286
#define SQL_OCTET_LENGTH 287
#define SQL_OPEN 288
#define SQL_OUTPUT 289
#define SQL_REFERENCE 290
#define SQL_RETURNED_LENGTH 291
#define SQL_RETURNED_OCTET_LENGTH 292
#define SQL_SCALE 293
#define SQL_SECTION 294
#define SQL_SHORT 295
#define SQL_SIGNED 296
#define SQL_SQL 297
#define SQL_SQLERROR 298
#define SQL_SQLPRINT 299
#define SQL_SQLWARNING 300
#define SQL_START 301
#define SQL_STOP 302
#define SQL_STRUCT 303
#define SQL_UNSIGNED 304
#define SQL_VALUE 305
#define SQL_VAR 306
#define SQL_WHENEVER 307
#define S_ADD 308
#define S_AND 309
#define S_ANYTHING 310
#define S_AUTO 311
#define S_CONST 312
#define S_DEC 313
#define S_DIV 314
#define S_DOTPOINT 315
#define S_EQUAL 316
#define S_EXTERN 317
#define S_INC 318
#define S_LSHIFT 319
#define S_MEMPOINT 320
#define S_MEMBER 321
#define S_MOD 322
#define S_MUL 323
#define S_NEQUAL 324
#define S_OR 325
#define S_REGISTER 326
#define S_RSHIFT 327
#define S_STATIC 328
#define S_SUB 329
#define S_VOLATILE 330
#define S_TYPEDEF 331
#define TYPECAST 332
#define ABORT_P 333
#define ABSOLUTE_P 334
#define ACCESS 335
#define ACTION 336
#define ADD 337
#define AFTER 338
#define AGGREGATE 339
#define ALL 340
#define ALSO 341
#define ALTER 342
#define ANALYSE 343
#define ANALYZE 344
#define AND 345
#define ANY 346
#define ARRAY 347
#define AS 348
#define ASC 349
#define ASSERTION 350
#define ASSIGNMENT 351
#define AT 352
#define AUTHORIZATION 353
#define BACKWARD 354
#define BEFORE 355
#define BEGIN_P 356
#define BETWEEN 357
#define BIGINT 358
#define BINARY 359
#define BIT 360
#define BOOLEAN_P 361
#define BOTH 362
#define BY 363
#define CACHE 364
#define CALLED 365
#define CASCADE 366
#define CASE 367
#define CAST 368
#define CHAIN 369
#define CHAR_P 370
#define CHARACTER 371
#define CHARACTERISTICS 372
#define CHECK 373
#define CHECKPOINT 374
#define CLASS 375
#define CLOSE 376
#define CLUSTER 377
#define COALESCE 378
#define COLLATE 379
#define COLUMN 380
#define COMMENT 381
#define COMMIT 382
#define COMMITTED 383
#define CONSTRAINT 384
#define CONSTRAINTS 385
#define CONVERSION_P 386
#define CONVERT 387
#define COPY 388
#define CREATE 389
#define CREATEDB 390
#define CREATEUSER 391
#define CROSS 392
#define CSV 393
#define CURRENT_DATE 394
#define CURRENT_TIME 395
#define CURRENT_TIMESTAMP 396
#define CURRENT_USER 397
#define CURSOR 398
#define CYCLE 399
#define DATABASE 400
#define DAY_P 401
#define DEALLOCATE 402
#define DEC 403
#define DECIMAL_P 404
#define DECLARE 405
#define DEFAULT 406
#define DEFAULTS 407
#define DEFERRABLE 408
#define DEFERRED 409
#define DEFINER 410
#define DELETE_P 411
#define DELIMITER 412
#define DELIMITERS 413
#define DESC 414
#define DISTINCT 415
#define DO 416
#define DOMAIN_P 417
#define DOUBLE_P 418
#define DROP 419
#define EACH 420
#define ELSE 421
#define ENCODING 422
#define ENCRYPTED 423
#define END_P 424
#define ESCAPE 425
#define EXCEPT 426
#define EXCLUSIVE 427
#define EXCLUDING 428
#define EXECUTE 429
#define EXISTS 430
#define EXPLAIN 431
#define EXTERNAL 432
#define EXTRACT 433
#define FALSE_P 434
#define FETCH 435
#define FIRST_P 436
#define FLOAT_P 437
#define FOR 438
#define FORCE 439
#define FOREIGN 440
#define FORWARD 441
#define FREEZE 442
#define FROM 443
#define FULL 444
#define FUNCTION 445
#define GET 446
#define GLOBAL 447
#define GRANT 448
#define GROUP_P 449
#define HANDLER 450
#define HAVING 451
#define HOLD 452
#define HOUR_P 453
#define ILIKE 454
#define IMMEDIATE 455
#define IMMUTABLE 456
#define IMPLICIT_P 457
#define IN_P 458
#define INCLUDING 459
#define INCREMENT 460
#define INDEX 461
#define INHERITS 462
#define INITIALLY 463
#define INNER_P 464
#define INOUT 465
#define INPUT_P 466
#define INSENSITIVE 467
#define INSERT 468
#define INSTEAD 469
#define INT_P 470
#define INTEGER 471
#define INTERSECT 472
#define INTERVAL 473
#define INTO 474
#define INVOKER 475
#define IS 476
#define ISNULL 477
#define ISOLATION 478
#define JOIN 479
#define KEY 480
#define LANCOMPILER 481
#define LANGUAGE 482
#define LARGE_P 483
#define LAST_P 484
#define LEADING 485
#define LEFT 486
#define LEVEL 487
#define LIKE 488
#define LIMIT 489
#define LISTEN 490
#define LOAD 491
#define LOCAL 492
#define LOCATION 493
#define LOCK_P 494
#define MATCH 495
#define MAXVALUE 496
#define MINUTE_P 497
#define MINVALUE 498
#define MODE 499
#define MONTH_P 500
#define MOVE 501
#define NAMES 502
#define NATIONAL 503
#define NATURAL 504
#define NCHAR 505
#define NEW 506
#define NEXT 507
#define NO 508
#define NOCREATEDB 509
#define NOCREATEUSER 510
#define NONE 511
#define NOT 512
#define NOTHING 513
#define NOTIFY 514
#define NOTNULL 515
#define NOWAIT 516
#define NULL_P 517
#define NULLIF 518
#define NUMERIC 519
#define OBJECT_P 520
#define OF 521
#define OFF 522
#define OFFSET 523
#define OIDS 524
#define OLD 525
#define ON 526
#define ONLY 527
#define OPERATOR 528
#define OPTION 529
#define OR 530
#define ORDER 531
#define OUT_P 532
#define OUTER_P 533
#define OVERLAPS 534
#define OVERLAY 535
#define OWNER 536
#define PARTIAL 537
#define PASSWORD 538
#define PLACING 539
#define POSITION 540
#define PRECISION 541
#define PRESERVE 542
#define PREPARE 543
#define PRIMARY 544
#define PRIOR 545
#define PRIVILEGES 546
#define PROCEDURAL 547
#define PROCEDURE 548
#define QUOTE 549
#define READ 550
#define REAL 551
#define RECHECK 552
#define REFERENCES 553
#define REINDEX 554
#define RELATIVE_P 555
#define RELEASE 556
#define RENAME 557
#define REPEATABLE 558
#define REPLACE 559
#define RESET 560
#define RESTART 561
#define RESTRICT 562
#define RETURNS 563
#define REVOKE 564
#define RIGHT 565
#define ROLLBACK 566
#define ROW 567
#define ROWS 568
#define RULE 569
#define SAVEPOINT 570
#define SCHEMA 571
#define SCROLL 572
#define SECOND_P 573
#define SECURITY 574
#define SELECT 575
#define SEQUENCE 576
#define SERIALIZABLE 577
#define SESSION 578
#define SESSION_USER 579
#define SET 580
#define SETOF 581
#define SHARE 582
#define SHOW 583
#define SIMILAR 584
#define SIMPLE 585
#define SMALLINT 586
#define SOME 587
#define STABLE 588
#define START 589
#define STATEMENT 590
#define STATISTICS 591
#define STDIN 592
#define STDOUT 593
#define STORAGE 594
#define STRICT_P 595
#define SUBSTRING 596
#define SYSID 597
#define TABLE 598
#define TABLESPACE 599
#define TEMP 600
#define TEMPLATE 601
#define TEMPORARY 602
#define THEN 603
#define TIME 604
#define TIMESTAMP 605
#define TO 606
#define TOAST 607
#define TRAILING 608
#define TRANSACTION 609
#define TREAT 610
#define TRIGGER 611
#define TRIM 612
#define TRUE_P 613
#define TRUNCATE 614
#define TRUSTED 615
#define TYPE_P 616
#define UNCOMMITTED 617
#define UNENCRYPTED 618
#define UNION 619
#define UNIQUE 620
#define UNKNOWN 621
#define UNLISTEN 622
#define UNTIL 623
#define UPDATE 624
#define USAGE 625
#define USER 626
#define USING 627
#define VACUUM 628
#define VALID 629
#define VALUES 630
#define VARCHAR 631
#define VARYING 632
#define VERBOSE 633
#define VIEW 634
#define VOLATILE 635
#define WHEN 636
#define WHERE 637
#define WITH 638
#define WITHOUT 639
#define WORK 640
#define WRITE 641
#define YEAR_P 642
#define ZONE 643
#define UNIONJOIN 644
#define IDENT 645
#define SCONST 646
#define Op 647
#define CSTRING 648
#define CVARIABLE 649
#define CPP_LINE 650
#define IP 651
#define BCONST 652
#define XCONST 653
#define ICONST 654
#define PARAM 655
#define FCONST 656
#define POSTFIXOP 657
#define UMINUS 658




/* Copy the first part of user declarations.  */
#line 4 "preproc.y"

#include "postgres_fe.h"

#include "extern.h"

/*
 * Variables containing simple states.
 */
int struct_level = 0;
int braces_open; /* brace level counter */
int ecpg_informix_var = 0;
char	*connection = NULL;
char	*input_filename = NULL;

static int	QueryIsRule = 0, FoundInto = 0;
static int	initializer = 0;
static struct this_type actual_type[STRUCT_DEPTH];
static char *actual_startline[STRUCT_DEPTH];

/* temporarily store struct members while creating the data structure */
struct ECPGstruct_member *struct_member_list[STRUCT_DEPTH] = { NULL };

/* also store struct type so we can do a sizeof() later */
static char *ECPGstruct_sizeof = NULL;

/* for forward declarations we have to store some data as well */
static char *forward_name = NULL;

struct ECPGtype ecpg_no_indicator = {ECPGt_NO_INDICATOR, 0L, NULL, {NULL}};
struct variable no_indicator = {"no_indicator", &ecpg_no_indicator, 0, NULL};

struct ECPGtype ecpg_query = {ECPGt_char_variable, 0L, NULL, {NULL}};

static struct inf_compat_col
{
	char *name;
	char *indirection;
	struct inf_compat_col *next;
} *informix_col;

static struct inf_compat_val
{
	char *val;
	struct inf_compat_val *next;
} *informix_val;

/*
 * Handle parsing errors and warnings
 */
void
mmerror(int error_code, enum errortype type, char * error, ...)
{
	va_list ap;
	
	fprintf(stderr, "%s:%d: ", input_filename, yylineno);
	
	switch(type)
	{
		case ET_WARNING:
			fprintf(stderr, "WARNING: ");
			break;
		case ET_ERROR:
		case ET_FATAL:
			fprintf(stderr, "ERROR: ");
			break;
	}

	va_start(ap, error);
	vfprintf(stderr, error, ap);
	va_end(ap);
	
	fprintf(stderr, "\n");
	
	switch(type)
	{
		case ET_WARNING:
			break;
		case ET_ERROR:
			ret_value = error_code;
			break;
		case ET_FATAL:
			exit(error_code);
	}
}

/*
 * string concatenation
 */

static char *
cat2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 2);

	strcpy(res_str, str1);
	strcat(res_str, " ");
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
cat_str(int count, ...)
{
	va_list		args;
	int			i;
	char		*res_str;

	va_start(args, count);

	res_str = va_arg(args, char *);

	/* now add all other strings */
	for (i = 1; i < count; i++)
		res_str = cat2_str(res_str, va_arg(args, char *));

	va_end(args);

	return(res_str);
}

char *
make_str(const char *str)
{
	char * res_str = (char *)mm_alloc(strlen(str) + 1);

	strcpy(res_str, str);
	return res_str;
}

static char *
make2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
make3_str(char *str1, char *str2, char *str3)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) +strlen(str3) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	strcat(res_str, str3);
	free(str1);
	free(str2);
	free(str3);
	return(res_str);
}

/* and the rest */
static char *
make_name(void)
{
	char * name = (char *)mm_alloc(yyleng + 1);

	strncpy(name, yytext, yyleng);
	name[yyleng] = '\0';
	return(name);
}

static char *
create_questionmarks(char *name, bool array)
{
	struct variable *p = find_variable(name);
	int count;
	char *result = EMPTY;

	/* In case we have a struct, we have to print as many "?" as there are attributes in the struct 
	 * An array is only allowed together with an element argument 
	 * This is essantially only used for inserts, but using a struct as input parameter is an error anywhere else 
	 * so we don't have to worry here. */
	
	if (p->type->type == ECPGt_struct || (array && p->type->type == ECPGt_array && p->type->u.element->type == ECPGt_struct))
	{
		struct ECPGstruct_member *m;

		if (p->type->type == ECPGt_struct)
			m = p->type->u.members;
		else
			m = p->type->u.element->u.members;

		for (count = 0; m != NULL; m=m->next, count++);
	}
	else
		count = 1;

	for (; count > 0; count --)
		result = cat2_str(result, make_str("? , "));

	/* removed the trailing " ," */

	result[strlen(result)-3] = '\0';
	return(result);
}

static char *
adjust_informix(struct arguments *list)
{
	/* Informix accepts DECLARE with variables that are out of scope when OPEN is called.
	 * This breaks standard and leads to some very dangerous programming. 
	 * Since they do, we have to work around and accept their syntax as well.
	 * But we will do so ONLY in Informix mode.
	 * We have to change the variables to our own struct and just store the pointer instead of the variable */

	 struct arguments *ptr;
	 char *result = make_str("");

	 for (ptr = list; ptr != NULL; ptr = ptr->next)
	 {
	 	char temp[20]; /* this should be sufficient unless you have 8 byte integers */
		char *original_var;
		
	 	/* change variable name to "ECPG_informix_get_var(<counter>)" */
		original_var = ptr->variable->name;
		sprintf(temp, "%d))", ecpg_informix_var);
		
		if ((ptr->variable->type->type != ECPGt_char && ptr->variable->type->type != ECPGt_unsigned_char) && atoi(ptr->variable->type->size) > 1)
		{
			ptr->variable = new_variable(cat_str(4, make_str("("), mm_strdup(ECPGtype_name(ptr->variable->type->u.element->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_array_type(ECPGmake_simple_type(ptr->variable->type->u.element->type, make_str("1")), ptr->variable->type->size), 0);
			sprintf(temp, "%d, (", ecpg_informix_var++);
		}
		else if ((ptr->variable->type->type == ECPGt_char || ptr->variable->type->type == ECPGt_unsigned_char) && atoi(ptr->variable->type->size) > 1)
		{
			ptr->variable = new_variable(cat_str(4, make_str("("), mm_strdup(ECPGtype_name(ptr->variable->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->variable->type->type, ptr->variable->type->size), 0);
			sprintf(temp, "%d, (", ecpg_informix_var++);
		}
		else
		{
			ptr->variable = new_variable(cat_str(4, make_str("*("), mm_strdup(ECPGtype_name(ptr->variable->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->variable->type->type, ptr->variable->type->size), 0);
			sprintf(temp, "%d, &(", ecpg_informix_var++);
		}
		
		/* create call to "ECPG_informix_set_var(<counter>, <pointer>. <linen number>)" */
		result = cat_str(5, result, make_str("ECPG_informix_set_var("), mm_strdup(temp), mm_strdup(original_var), make_str("), __LINE__);\n"));
		
		/* now the indicator if there is one */
		if (ptr->indicator->type->type != ECPGt_NO_INDICATOR)
		{
			/* change variable name to "ECPG_informix_get_var(<counter>)" */
			original_var = ptr->indicator->name;
			sprintf(temp, "%d))", ecpg_informix_var);
			
			/* create call to "ECPG_informix_set_var(<counter>, <pointer>. <linen number>)" */
			if (atoi(ptr->indicator->type->size) > 1)
			{
				ptr->indicator = new_variable(cat_str(4, make_str("("), mm_strdup(ECPGtype_name(ptr->indicator->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->indicator->type->type, ptr->indicator->type->size), 0);
				sprintf(temp, "%d, (", ecpg_informix_var++);
			}
			else
			{
				ptr->indicator = new_variable(cat_str(4, make_str("*("), mm_strdup(ECPGtype_name(ptr->indicator->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->indicator->type->type, ptr->indicator->type->size), 0);
				sprintf(temp, "%d, &(", ecpg_informix_var++);
			}
			result = cat_str(5, result, make_str("ECPG_informix_set_var("), mm_strdup(temp), mm_strdup(original_var), make_str("), __LINE__);\n"));
		}
	 }

	 return result;
}

static struct cursor *
add_additional_variables(char *name, bool insert)
{
	struct cursor *ptr;
	struct arguments *p;

	for (ptr = cur; ptr != NULL; ptr=ptr->next)
	{
		if (strcmp(ptr->name, name) == 0)
			break;
	}

	if (ptr == NULL)
	{
		mmerror(PARSE_ERROR, ET_ERROR, "trying to access an undeclared cursor %s\n", name);
		return NULL;
	}
	if (insert)
	{
		/* add all those input variables that were given earlier 
		 * note that we have to append here but have to keep the existing order */
		for (p = ptr->argsinsert; p; p = p->next)
			add_variable_to_tail(&argsinsert, p->variable, p->indicator);
	}

	/* add all those output variables that were given earlier */
	for (p = ptr->argsresult; p; p = p->next)
		add_variable_to_tail(&argsresult, p->variable, p->indicator);
	
	return ptr;
}


/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 305 "preproc.y"
typedef union YYSTYPE {
	double	dval;
	char	*str;
	int     ival;
	struct	when		action;
	struct	index		index;
	int		tagname;
	struct	this_type	type;
	enum	ECPGttype	type_enum;
	enum	ECPGdtype	dtype_enum;
	struct	fetch_desc	descriptor;
	struct  su_symbol	struct_union;
} YYSTYPE;
/* Line 191 of yacc.c.  */
#line 1196 "y.tab.c"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */


/* Line 214 of yacc.c.  */
#line 1208 "y.tab.c"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# if YYSTACK_USE_ALLOCA
#  define YYSTACK_ALLOC alloca
# else
#  ifndef YYSTACK_USE_ALLOCA
#   if defined (alloca) || defined (_ALLOCA_H)
#    define YYSTACK_ALLOC alloca
#   else
#    ifdef __GNUC__
#     define YYSTACK_ALLOC __builtin_alloca
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC malloc
#  define YYSTACK_FREE free
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE))				\
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  3
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   50688

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  424
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  514
/* YYNRULES -- Number of rules. */
#define YYNRULES  1940
/* YYNRULES -- Number of states. */
#define YYNSTATES  3190

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   659

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned short yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,   410,     2,     2,
     415,   416,   408,   406,   421,   407,   417,   409,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   423,   418,
     403,   402,   404,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   413,     2,   414,   411,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   419,     2,   420,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   405,   412,   422
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned short yyprhs[] =
{
       0,     0,     3,     5,     6,     9,    14,    18,    21,    23,
      25,    27,    29,    31,    34,    36,    38,    40,    42,    44,
      46,    48,    50,    52,    54,    56,    58,    60,    62,    64,
      66,    68,    70,    72,    74,    76,    78,    80,    82,    84,
      86,    88,    90,    92,    94,    96,    98,   100,   102,   104,
     106,   108,   110,   112,   114,   116,   118,   120,   122,   124,
     126,   128,   130,   132,   134,   136,   138,   140,   142,   144,
     146,   148,   150,   152,   154,   156,   158,   160,   162,   164,
     166,   168,   170,   172,   174,   176,   178,   180,   182,   184,
     186,   188,   190,   192,   194,   196,   198,   200,   202,   204,
     206,   208,   210,   212,   214,   216,   218,   224,   226,   227,
     232,   238,   244,   249,   253,   256,   257,   260,   263,   265,
     267,   269,   271,   275,   279,   283,   285,   290,   296,   299,
     300,   303,   306,   313,   320,   324,   332,   338,   340,   341,
     344,   345,   347,   349,   351,   353,   355,   357,   360,   364,
     368,   372,   376,   380,   383,   389,   392,   396,   400,   402,
     406,   408,   410,   412,   416,   419,   422,   425,   427,   429,
     431,   433,   435,   437,   439,   441,   443,   445,   449,   456,
     458,   460,   462,   464,   465,   467,   469,   472,   476,   481,
     485,   488,   491,   495,   500,   504,   507,   512,   514,   516,
     518,   520,   522,   527,   532,   534,   538,   542,   547,   554,
     561,   568,   575,   580,   587,   590,   595,   599,   603,   607,
     611,   613,   617,   621,   625,   629,   632,   634,   636,   637,
     640,   641,   644,   654,   656,   658,   660,   662,   664,   667,
     668,   670,   672,   676,   680,   682,   686,   690,   694,   699,
     701,   702,   705,   706,   710,   711,   713,   714,   726,   739,
     741,   743,   746,   749,   752,   755,   756,   758,   759,   761,
     765,   767,   769,   771,   775,   778,   779,   783,   785,   787,
     790,   792,   795,   799,   804,   807,   813,   815,   818,   821,
     824,   828,   831,   834,   835,   839,   841,   846,   852,   859,
     871,   875,   876,   880,   882,   884,   887,   890,   891,   893,
     895,   898,   901,   902,   906,   910,   913,   915,   917,   920,
     923,   928,   929,   932,   935,   936,   940,   945,   950,   951,
     954,   955,   960,   961,   962,   971,   975,   979,   981,   985,
     986,   990,   992,   994,  1000,  1005,  1008,  1009,  1012,  1014,
    1017,  1021,  1024,  1027,  1030,  1033,  1037,  1041,  1043,  1044,
    1053,  1055,  1056,  1058,  1061,  1064,  1065,  1071,  1073,  1074,
    1081,  1084,  1085,  1089,  1104,  1124,  1126,  1128,  1130,  1134,
    1140,  1142,  1144,  1146,  1150,  1151,  1153,  1154,  1156,  1158,
    1160,  1164,  1165,  1167,  1169,  1170,  1173,  1175,  1178,  1180,
    1183,  1186,  1188,  1191,  1194,  1201,  1210,  1214,  1219,  1224,
    1229,  1235,  1239,  1243,  1245,  1249,  1253,  1255,  1257,  1259,
    1261,  1274,  1276,  1280,  1285,  1293,  1298,  1301,  1303,  1304,
    1306,  1307,  1315,  1320,  1322,  1324,  1326,  1328,  1330,  1332,
    1334,  1336,  1338,  1342,  1344,  1347,  1350,  1354,  1358,  1364,
    1369,  1374,  1378,  1383,  1387,  1391,  1394,  1399,  1402,  1404,
    1406,  1408,  1410,  1413,  1416,  1418,  1420,  1422,  1425,  1428,
    1430,  1433,  1436,  1438,  1440,  1442,  1449,  1459,  1467,  1477,
    1486,  1495,  1502,  1512,  1520,  1531,  1539,  1541,  1543,  1545,
    1547,  1549,  1551,  1553,  1555,  1557,  1559,  1561,  1563,  1571,
    1580,  1583,  1585,  1587,  1589,  1593,  1595,  1597,  1599,  1601,
    1603,  1605,  1607,  1609,  1611,  1613,  1615,  1617,  1619,  1622,
    1625,  1628,  1631,  1634,  1637,  1639,  1643,  1645,  1648,  1652,
    1653,  1657,  1658,  1660,  1664,  1667,  1680,  1682,  1683,  1686,
    1687,  1689,  1693,  1696,  1699,  1704,  1706,  1709,  1710,  1720,
    1723,  1724,  1728,  1731,  1733,  1737,  1741,  1744,  1746,  1748,
    1750,  1751,  1753,  1757,  1759,  1761,  1763,  1768,  1770,  1773,
    1776,  1779,  1781,  1783,  1785,  1790,  1796,  1798,  1802,  1806,
    1809,  1812,  1815,  1816,  1822,  1830,  1832,  1834,  1842,  1844,
    1848,  1852,  1856,  1858,  1862,  1874,  1885,  1888,  1889,  1898,
    1903,  1908,  1910,  1912,  1914,  1915,  1925,  1932,  1939,  1947,
    1954,  1961,  1971,  1978,  1985,  1992,  2001,  2010,  2017,  2024,
    2026,  2027,  2037,  2044,  2051,  2058,  2066,  2076,  2086,  2093,
    2100,  2107,  2108,  2123,  2125,  2127,  2131,  2135,  2137,  2139,
    2141,  2143,  2145,  2147,  2149,  2150,  2152,  2154,  2156,  2158,
    2160,  2162,  2163,  2170,  2173,  2176,  2179,  2182,  2185,  2189,
    2193,  2196,  2199,  2202,  2205,  2209,  2212,  2218,  2223,  2225,
    2227,  2228,  2232,  2235,  2238,  2240,  2244,  2247,  2249,  2250,
    2258,  2261,  2267,  2271,  2273,  2276,  2280,  2284,  2288,  2292,
    2296,  2300,  2304,  2308,  2312,  2316,  2318,  2319,  2325,  2330,
    2334,  2341,  2346,  2353,  2360,  2366,  2374,  2376,  2377,  2388,
    2393,  2396,  2398,  2403,  2409,  2415,  2418,  2423,  2425,  2427,
    2429,  2430,  2432,  2433,  2435,  2436,  2440,  2441,  2446,  2448,
    2450,  2452,  2454,  2456,  2458,  2459,  2464,  2469,  2472,  2474,
    2482,  2487,  2491,  2493,  2496,  2501,  2507,  2511,  2512,  2515,
    2518,  2521,  2525,  2527,  2531,  2533,  2536,  2538,  2539,  2546,
    2554,  2555,  2558,  2561,  2564,  2568,  2569,  2572,  2575,  2577,
    2579,  2583,  2587,  2589,  2592,  2597,  2602,  2604,  2606,  2615,
    2620,  2625,  2630,  2633,  2635,  2636,  2640,  2644,  2649,  2654,
    2659,  2664,  2667,  2669,  2671,  2672,  2674,  2675,  2677,  2683,
    2685,  2686,  2688,  2689,  2693,  2695,  2699,  2703,  2706,  2709,
    2711,  2716,  2721,  2724,  2727,  2732,  2734,  2735,  2737,  2739,
    2741,  2745,  2746,  2749,  2750,  2754,  2758,  2760,  2761,  2764,
    2765,  2768,  2769,  2773,  2775,  2777,  2780,  2782,  2785,  2791,
    2798,  2804,  2806,  2809,  2811,  2816,  2820,  2825,  2829,  2835,
    2840,  2846,  2851,  2857,  2860,  2865,  2867,  2870,  2873,  2876,
    2878,  2880,  2881,  2886,  2889,  2891,  2894,  2897,  2902,  2904,
    2907,  2908,  2910,  2914,  2917,  2920,  2924,  2930,  2937,  2941,
    2946,  2947,  2949,  2953,  2957,  2961,  2965,  2969,  2973,  2975,
    2977,  2979,  2981,  2983,  2985,  2987,  2990,  2996,  2999,  3001,
    3003,  3005,  3007,  3009,  3011,  3013,  3015,  3017,  3019,  3021,
    3024,  3027,  3030,  3033,  3036,  3038,  3042,  3043,  3049,  3053,
    3054,  3060,  3064,  3065,  3067,  3069,  3071,  3073,  3079,  3082,
    3084,  3086,  3088,  3090,  3096,  3099,  3102,  3105,  3107,  3111,
    3115,  3118,  3120,  3121,  3125,  3126,  3132,  3135,  3141,  3144,
    3146,  3150,  3154,  3155,  3157,  3159,  3161,  3163,  3165,  3167,
    3171,  3175,  3179,  3183,  3187,  3191,  3195,  3196,  3198,  3202,
    3208,  3211,  3214,  3217,  3220,  3223,  3226,  3230,  3234,  3238,
    3242,  3246,  3250,  3254,  3258,  3262,  3266,  3269,  3272,  3276,
    3280,  3283,  3287,  3293,  3298,  3305,  3309,  3315,  3320,  3327,
    3332,  3339,  3345,  3353,  3356,  3360,  3363,  3368,  3372,  3377,
    3381,  3386,  3390,  3395,  3401,  3408,  3416,  3422,  3429,  3433,
    3438,  3443,  3450,  3453,  3455,  3459,  3462,  3465,  3468,  3471,
    3474,  3478,  3482,  3486,  3490,  3494,  3498,  3502,  3506,  3510,
    3514,  3517,  3520,  3526,  3533,  3541,  3543,  3545,  3548,  3553,
    3555,  3557,  3559,  3562,  3565,  3568,  3570,  3574,  3579,  3585,
    3591,  3596,  3598,  3601,  3606,  3609,  3614,  3617,  3620,  3623,
    3630,  3635,  3640,  3645,  3650,  3657,  3663,  3669,  3675,  3680,
    3687,  3692,  3699,  3704,  3709,  3713,  3719,  3721,  3723,  3725,
    3727,  3729,  3731,  3733,  3735,  3737,  3739,  3741,  3743,  3745,
    3747,  3749,  3754,  3756,  3761,  3763,  3768,  3770,  3773,  3775,
    3778,  3780,  3784,  3788,  3789,  3793,  3795,  3797,  3801,  3805,
    3809,  3811,  3813,  3815,  3817,  3819,  3821,  3823,  3825,  3830,
    3834,  3837,  3841,  3842,  3846,  3850,  3853,  3856,  3858,  3859,
    3862,  3865,  3869,  3872,  3874,  3876,  3880,  3886,  3889,  3891,
    3896,  3899,  3900,  3902,  3903,  3905,  3908,  3911,  3914,  3918,
    3924,  3926,  3929,  3930,  3933,  3936,  3937,  3941,  3943,  3947,
    3949,  3951,  3955,  3963,  3965,  3968,  3973,  3975,  3979,  3984,
    3989,  3993,  3995,  3997,  3999,  4001,  4003,  4005,  4009,  4011,
    4014,  4016,  4020,  4022,  4024,  4026,  4028,  4030,  4032,  4034,
    4037,  4039,  4042,  4046,  4053,  4055,  4057,  4059,  4061,  4063,
    4065,  4067,  4069,  4071,  4073,  4075,  4077,  4080,  4082,  4084,
    4086,  4088,  4091,  4094,  4096,  4098,  4100,  4102,  4104,  4106,
    4108,  4110,  4113,  4116,  4118,  4120,  4122,  4124,  4126,  4128,
    4130,  4132,  4134,  4136,  4138,  4140,  4146,  4150,  4153,  4156,
    4160,  4168,  4170,  4172,  4175,  4178,  4180,  4181,  4183,  4187,
    4189,  4192,  4193,  4196,  4197,  4200,  4201,  4203,  4207,  4212,
    4216,  4218,  4220,  4222,  4225,  4226,  4234,  4238,  4241,  4243,
    4245,  4247,  4248,  4254,  4255,  4260,  4263,  4265,  4268,  4269,
    4271,  4275,  4279,  4283,  4287,  4288,  4293,  4299,  4305,  4306,
    4308,  4310,  4312,  4315,  4318,  4320,  4323,  4324,  4332,  4333,
    4339,  4340,  4345,  4348,  4351,  4353,  4355,  4357,  4359,  4361,
    4363,  4365,  4367,  4369,  4371,  4373,  4379,  4382,  4384,  4388,
    4391,  4394,  4398,  4399,  4405,  4407,  4408,  4414,  4417,  4420,
    4422,  4424,  4426,  4429,  4432,  4436,  4438,  4441,  4444,  4448,
    4452,  4457,  4460,  4462,  4465,  4467,  4469,  4472,  4475,  4479,
    4481,  4483,  4485,  4487,  4488,  4490,  4494,  4499,  4500,  4503,
    4504,  4506,  4509,  4513,  4516,  4518,  4520,  4522,  4523,  4525,
    4527,  4531,  4532,  4537,  4540,  4543,  4545,  4547,  4548,  4550,
    4552,  4554,  4556,  4559,  4563,  4564,  4566,  4569,  4571,  4576,
    4581,  4582,  4584,  4587,  4589,  4591,  4595,  4597,  4599,  4604,
    4609,  4614,  4619,  4621,  4622,  4626,  4630,  4635,  4637,  4641,
    4645,  4650,  4652,  4656,  4660,  4662,  4669,  4671,  4675,  4679,
    4686,  4688,  4692,  4696,  4698,  4700,  4702,  4704,  4706,  4708,
    4710,  4712,  4714,  4716,  4718,  4720,  4722,  4724,  4726,  4731,
    4736,  4738,  4740,  4745,  4750,  4754,  4755,  4763,  4765,  4766,
    4767,  4775,  4779,  4784,  4788,  4790,  4792,  4794,  4797,  4801,
    4807,  4810,  4816,  4819,  4821,  4823,  4825,  4827,  4829,  4831,
    4833,  4835,  4837,  4839,  4841,  4843,  4845,  4847,  4849,  4851,
    4853,  4855,  4857,  4859,  4861,  4863,  4865,  4867,  4869,  4871,
    4873,  4875,  4877,  4879,  4881,  4883,  4885,  4887,  4889,  4891,
    4893,  4895,  4897,  4899,  4901,  4903,  4905,  4907,  4909,  4911,
    4913,  4915,  4917,  4919,  4921,  4923,  4925,  4927,  4929,  4931,
    4933,  4935,  4937,  4939,  4941,  4943,  4945,  4947,  4949,  4951,
    4953,  4955,  4957,  4959,  4961,  4963,  4965,  4967,  4969,  4971,
    4973,  4975,  4977,  4979,  4981,  4983,  4985,  4987,  4989,  4991,
    4993,  4995,  4997,  4999,  5001,  5003,  5005,  5007,  5009,  5011,
    5013,  5015,  5017,  5019,  5021,  5023,  5025,  5027,  5029,  5031,
    5033,  5035,  5037,  5039,  5041,  5043,  5045,  5047,  5049,  5051,
    5053,  5055,  5057,  5059,  5061,  5063,  5065,  5067,  5069,  5071,
    5073,  5075,  5077,  5079,  5081,  5083,  5085,  5087,  5089,  5091,
    5093,  5095,  5097,  5099,  5101,  5103,  5105,  5107,  5109,  5111,
    5113,  5115,  5117,  5119,  5121,  5123,  5125,  5127,  5129,  5131,
    5133,  5135,  5137,  5139,  5141,  5143,  5145,  5147,  5149,  5151,
    5153,  5155,  5157,  5159,  5161,  5163,  5165,  5167,  5169,  5171,
    5173,  5175,  5177,  5179,  5181,  5183,  5185,  5187,  5189,  5191,
    5193,  5195,  5197,  5199,  5201,  5203,  5205,  5207,  5209,  5211,
    5213,  5215,  5217,  5219,  5221,  5223,  5225,  5227,  5229,  5231,
    5233,  5235,  5237,  5239,  5241,  5243,  5245,  5247,  5249,  5251,
    5253,  5255,  5257,  5259,  5261,  5263,  5265,  5267,  5269,  5271,
    5273,  5275,  5277,  5279,  5281,  5283,  5285,  5287,  5289,  5291,
    5293,  5295,  5297,  5299,  5301,  5303,  5305,  5307,  5309,  5311,
    5313,  5315,  5317,  5319,  5321,  5323,  5325,  5327,  5329,  5331,
    5333,  5335,  5337,  5339,  5341,  5343,  5345,  5347,  5349,  5351,
    5353,  5355,  5357,  5359,  5361,  5363,  5365,  5367,  5369,  5371,
    5373,  5375,  5377,  5379,  5381,  5383,  5385,  5387,  5389,  5391,
    5393,  5395,  5397,  5399,  5401,  5403,  5405,  5407,  5409,  5411,
    5413,  5415,  5417,  5419,  5421,  5423,  5425,  5427,  5429,  5431,
    5433,  5435,  5437,  5439,  5441,  5443,  5445,  5447,  5449,  5451,
    5453,  5455,  5457,  5459,  5461,  5463,  5465,  5467,  5469,  5471,
    5473,  5475,  5477,  5479,  5481,  5483,  5485,  5487,  5489,  5491,
    5493,  5495,  5497,  5499,  5501,  5503,  5505,  5507,  5509,  5511,
    5513,  5515,  5517,  5519,  5521,  5523,  5525,  5527,  5529,  5531,
    5533,  5535,  5537,  5539,  5541,  5543,  5545,  5547,  5549,  5551,
    5553,  5555,  5557,  5559,  5561,  5563,  5565,  5567,  5569,  5571,
    5573,  5575,  5577,  5579,  5581,  5583,  5587,  5589,  5590,  5592,
    5595,  5597,  5600,  5602,  5604,  5607,  5610,  5612,  5614,  5616,
    5618,  5620,  5622,  5625,  5629,  5631,  5634,  5636,  5640,  5642,
    5646,  5648,  5650,  5652,  5654,  5656,  5658,  5660,  5662,  5664,
    5666,  5668,  5670,  5672,  5674,  5676,  5678,  5680,  5682,  5684,
    5686,  5688,  5690,  5692,  5694,  5696,  5698,  5700,  5702,  5704,
    5706,  5708,  5710,  5712,  5714,  5716,  5718,  5720,  5722,  5724,
    5726,  5728,  5730,  5732,  5734,  5736,  5738,  5740,  5742,  5744,
    5746,  5748,  5750,  5752,  5754,  5756,  5758,  5760,  5762,  5764,
    5766
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const short yyrhs[] =
{
     425,     0,    -1,   426,    -1,    -1,   426,   427,    -1,   923,
     428,   429,   418,    -1,   923,   429,   418,    -1,   923,   816,
      -1,   824,    -1,   936,    -1,   395,    -1,   419,    -1,   420,
      -1,    97,   802,    -1,   639,    -1,   642,    -1,   441,    -1,
     615,    -1,   516,    -1,   464,    -1,   433,    -1,   432,    -1,
     647,    -1,   463,    -1,   472,    -1,   645,    -1,   567,    -1,
     460,    -1,   473,    -1,   509,    -1,   543,    -1,   607,    -1,
     644,    -1,   641,    -1,   588,    -1,   438,    -1,   520,    -1,
     551,    -1,   443,    -1,   515,    -1,   482,    -1,   529,    -1,
     526,    -1,   430,    -1,   635,    -1,   666,    -1,   545,    -1,
     660,    -1,   544,    -1,   609,    -1,   442,    -1,   556,    -1,
     524,    -1,   624,    -1,   557,    -1,   528,    -1,   542,    -1,
     434,    -1,   640,    -1,   653,    -1,   563,    -1,   570,    -1,
     582,    -1,   656,    -1,   626,    -1,   634,    -1,   661,    -1,
     625,    -1,   610,    -1,   602,    -1,   604,    -1,   601,    -1,
     613,    -1,   571,    -1,   616,    -1,   669,    -1,   628,    -1,
     562,    -1,   627,    -1,   665,    -1,   646,    -1,   447,    -1,
     458,    -1,   459,    -1,   633,    -1,   878,    -1,   801,    -1,
     814,    -1,   815,    -1,   879,    -1,   856,    -1,   876,    -1,
     857,    -1,   860,    -1,   865,    -1,   887,    -1,   880,    -1,
     866,    -1,   875,    -1,   894,    -1,   896,    -1,   890,    -1,
     883,    -1,   897,    -1,   900,    -1,   902,    -1,   134,   371,
     799,   431,   435,    -1,   383,    -1,    -1,    87,   371,   799,
     435,    -1,    87,   371,   799,   383,   435,    -1,    87,   371,
     799,   325,   448,    -1,    87,   371,   799,   459,    -1,   164,
     371,   437,    -1,   435,   436,    -1,    -1,   283,   789,    -1,
     342,   790,    -1,   135,    -1,   254,    -1,   136,    -1,   255,
      -1,   203,   194,   437,    -1,   374,   368,   789,    -1,   437,
     421,   799,    -1,   799,    -1,   134,   194,   799,   439,    -1,
     134,   194,   799,   383,   439,    -1,   439,   440,    -1,    -1,
     371,   437,    -1,   342,   790,    -1,    87,   194,   799,    82,
     371,   437,    -1,    87,   194,   799,   164,   371,   437,    -1,
     164,   194,   799,    -1,   134,   316,   444,    98,   799,   507,
     445,    -1,   134,   316,   909,   507,   445,    -1,   909,    -1,
      -1,   445,   446,    -1,    -1,   482,    -1,   582,    -1,   515,
      -1,   529,    -1,   570,    -1,   633,    -1,   325,   448,    -1,
     325,   237,   448,    -1,   325,   323,   448,    -1,   449,   351,
     450,    -1,   449,   422,   450,    -1,   349,   388,   455,    -1,
     354,   631,    -1,   323,   117,    93,   354,   631,    -1,   247,
     456,    -1,   323,    98,   457,    -1,   323,    98,   151,    -1,
     909,    -1,   449,   417,   909,    -1,   451,    -1,   151,    -1,
     453,    -1,   451,   421,   453,    -1,   295,   362,    -1,   295,
     128,    -1,   303,   295,    -1,   322,    -1,   454,    -1,   797,
      -1,   909,    -1,   358,    -1,   179,    -1,   271,    -1,   267,
      -1,   797,    -1,   930,    -1,   727,   794,   729,    -1,   727,
     415,   790,   416,   794,   729,    -1,   151,    -1,   237,    -1,
     794,    -1,   151,    -1,    -1,   909,    -1,   794,    -1,   328,
     909,    -1,   328,   349,   388,    -1,   328,   354,   223,   232,
      -1,   328,   323,    98,    -1,   328,    85,    -1,   305,   909,
      -1,   305,   349,   388,    -1,   305,   354,   223,   232,    -1,
     305,   323,    98,    -1,   305,    85,    -1,   325,   130,   461,
     462,    -1,    85,    -1,   776,    -1,   154,    -1,   200,    -1,
     119,    -1,    87,   343,   700,   465,    -1,    87,   206,   700,
     467,    -1,   466,    -1,   465,   421,   466,    -1,    82,   614,
     487,    -1,    87,   614,   909,   469,    -1,    87,   614,   909,
     164,   257,   262,    -1,    87,   614,   909,   325,   257,   262,
      -1,    87,   614,   909,   325,   336,   790,    -1,    87,   614,
     909,   325,   339,   909,    -1,   164,   614,   909,   470,    -1,
      87,   614,   909,   361,   705,   471,    -1,    82,   494,    -1,
     164,   129,   777,   470,    -1,   325,   384,   269,    -1,   134,
     352,   343,    -1,   122,   271,   777,    -1,   325,   384,   122,
      -1,   468,    -1,   467,   421,   468,    -1,   281,   351,   799,
      -1,   325,   344,   777,    -1,   325,   151,   730,    -1,   164,
     151,    -1,   111,    -1,   307,    -1,    -1,   372,   730,    -1,
      -1,   121,   777,    -1,   133,   478,   775,   479,   474,   475,
     480,   431,   476,    -1,   351,    -1,   188,    -1,   794,    -1,
     337,    -1,   338,    -1,   476,   477,    -1,    -1,   104,    -1,
     269,    -1,   157,   643,   794,    -1,   262,   643,   794,    -1,
     138,    -1,   294,   643,   789,    -1,   170,   643,   789,    -1,
     184,   294,   497,    -1,   184,   257,   262,   497,    -1,   104,
      -1,    -1,   383,   269,    -1,    -1,   481,   158,   794,    -1,
      -1,   372,    -1,    -1,   134,   483,   343,   775,   415,   484,
     416,   504,   505,   506,   507,    -1,   134,   483,   343,   775,
     266,   775,   415,   484,   416,   505,   506,   507,    -1,   347,
      -1,   345,    -1,   237,   347,    -1,   237,   345,    -1,   192,
     347,    -1,   192,   345,    -1,    -1,   485,    -1,    -1,   486,
      -1,   485,   421,   486,    -1,   487,    -1,   492,    -1,   494,
      -1,   909,   705,   488,    -1,   488,   489,    -1,    -1,   129,
     777,   490,    -1,   490,    -1,   491,    -1,   257,   262,    -1,
     262,    -1,   365,   508,    -1,   289,   225,   508,    -1,   118,
     415,   730,   416,    -1,   151,   731,    -1,   298,   775,   496,
     499,   500,    -1,   153,    -1,   257,   153,    -1,   208,   154,
      -1,   208,   200,    -1,   233,   775,   493,    -1,   204,   152,
      -1,   173,   152,    -1,    -1,   129,   777,   495,    -1,   495,
      -1,   118,   415,   730,   416,    -1,   365,   415,   497,   416,
     508,    -1,   289,   225,   415,   497,   416,   508,    -1,   185,
     225,   415,   497,   416,   298,   775,   496,   499,   500,   539,
      -1,   415,   497,   416,    -1,    -1,   497,   421,   498,    -1,
     498,    -1,   909,    -1,   240,   189,    -1,   240,   282,    -1,
      -1,   501,    -1,   502,    -1,   501,   502,    -1,   502,   501,
      -1,    -1,   271,   156,   503,    -1,   271,   369,   503,    -1,
     253,    81,    -1,   307,    -1,   111,    -1,   325,   151,    -1,
     325,   262,    -1,   207,   415,   774,   416,    -1,    -1,   383,
     269,    -1,   384,   269,    -1,    -1,   271,   127,   164,    -1,
     271,   127,   156,   313,    -1,   271,   127,   287,   313,    -1,
      -1,   344,   777,    -1,    -1,   372,   206,   344,   777,    -1,
      -1,    -1,   134,   483,   343,   775,   512,   511,   510,   669,
      -1,   383,   269,    93,    -1,   384,   269,    93,    -1,    93,
      -1,   415,   513,   416,    -1,    -1,   513,   421,   514,    -1,
     514,    -1,   909,    -1,   134,   483,   321,   775,   517,    -1,
      87,   321,   775,   517,    -1,   517,   518,    -1,    -1,   109,
     796,    -1,   144,    -1,   253,   144,    -1,   205,   519,   796,
      -1,   241,   796,    -1,   243,   796,    -1,   253,   241,    -1,
     253,   243,    -1,   334,   431,   796,    -1,   306,   431,   796,
      -1,   108,    -1,    -1,   134,   521,   525,   227,   457,   195,
     522,   523,    -1,   360,    -1,    -1,   777,    -1,   777,   561,
      -1,   226,   794,    -1,    -1,   164,   525,   227,   794,   470,
      -1,   292,    -1,    -1,   134,   344,   777,   527,   238,   789,
      -1,   281,   777,    -1,    -1,   164,   344,   777,    -1,   134,
     356,   777,   530,   531,   271,   775,   533,   174,   293,   777,
     415,   536,   416,    -1,   134,   129,   356,   777,    83,   531,
     271,   775,   538,   539,   183,   165,   312,   174,   293,   783,
     415,   536,   416,    -1,   100,    -1,    83,    -1,   532,    -1,
     532,   275,   532,    -1,   532,   275,   532,   275,   532,    -1,
     213,    -1,   156,    -1,   369,    -1,   183,   534,   535,    -1,
      -1,   165,    -1,    -1,   312,    -1,   335,    -1,   537,    -1,
     536,   421,   537,    -1,    -1,   798,    -1,   909,    -1,    -1,
     188,   775,    -1,   540,    -1,   540,   541,    -1,   541,    -1,
     541,   540,    -1,   257,   153,    -1,   153,    -1,   208,   200,
      -1,   208,   154,    -1,   164,   356,   777,   271,   775,   470,
      -1,   134,    95,   777,   118,   415,   730,   416,   539,    -1,
     164,    95,   777,    -1,   134,    84,   783,   547,    -1,   134,
     273,   736,   547,    -1,   134,   361,   560,   547,    -1,   134,
     361,   560,    93,   546,    -1,   415,   703,   416,    -1,   415,
     548,   416,    -1,   549,    -1,   548,   421,   549,    -1,   912,
     402,   550,    -1,   912,    -1,   596,    -1,   739,    -1,   797,
      -1,   134,   273,   120,   560,   554,   183,   361,   705,   372,
     779,    93,   552,    -1,   553,    -1,   552,   421,   553,    -1,
     273,   790,   606,   555,    -1,   273,   790,   606,   415,   605,
     416,   555,    -1,   190,   790,   783,   590,    -1,   339,   705,
      -1,   151,    -1,    -1,   297,    -1,    -1,   164,   273,   120,
     560,   372,   779,   470,    -1,   164,   558,   559,   470,    -1,
     343,    -1,   321,    -1,   379,    -1,   206,    -1,   361,    -1,
     162,    -1,   131,    -1,   316,    -1,   560,    -1,   559,   421,
     560,    -1,   909,    -1,   909,   561,    -1,   417,   780,    -1,
     417,   780,   561,    -1,   359,   676,   775,    -1,   180,   564,
     566,   777,   872,    -1,   180,   564,   777,   872,    -1,   180,
     566,   777,   872,    -1,   180,   777,   872,    -1,   180,   564,
     566,   777,    -1,   180,   564,   777,    -1,   180,   566,   777,
      -1,   180,   777,    -1,   246,   564,   566,   777,    -1,   246,
     777,    -1,   252,    -1,   290,    -1,   181,    -1,   229,    -1,
      79,   565,    -1,   300,   565,    -1,   565,    -1,    85,    -1,
     186,    -1,   186,   565,    -1,   186,    85,    -1,    99,    -1,
      99,   565,    -1,    99,    85,    -1,   791,    -1,   203,    -1,
     188,    -1,   126,   271,   568,   777,   221,   569,    -1,   126,
     271,    84,   783,   415,   603,   416,   221,   569,    -1,   126,
     271,   190,   783,   590,   221,   569,    -1,   126,   271,   273,
     736,   415,   605,   416,   221,   569,    -1,   126,   271,   356,
     777,   271,   560,   221,   569,    -1,   126,   271,   314,   777,
     271,   560,   221,   569,    -1,   126,   271,   314,   777,   221,
     569,    -1,   126,   271,   273,   120,   560,   372,   779,   221,
     569,    -1,   126,   271,   228,   265,   796,   221,   569,    -1,
     126,   271,   113,   415,   705,    93,   705,   416,   221,   569,
      -1,   126,   271,   525,   227,   560,   221,   569,    -1,   125,
      -1,   145,    -1,   316,    -1,   206,    -1,   321,    -1,   343,
      -1,   162,    -1,   361,    -1,   379,    -1,   131,    -1,   794,
      -1,   262,    -1,   193,   572,   271,   575,   351,   576,   578,
      -1,   309,   579,   572,   271,   575,   188,   576,   470,    -1,
      85,   291,    -1,    85,    -1,   573,    -1,   574,    -1,   573,
     421,   574,    -1,   320,    -1,   213,    -1,   369,    -1,   156,
      -1,   314,    -1,   298,    -1,   356,    -1,   174,    -1,   370,
      -1,   134,    -1,   347,    -1,   345,    -1,   774,    -1,   343,
     774,    -1,   190,   580,    -1,   145,   776,    -1,   227,   776,
      -1,   316,   776,    -1,   344,   776,    -1,   577,    -1,   576,
     421,   577,    -1,   909,    -1,   194,   909,    -1,   383,   193,
     274,    -1,    -1,   193,   274,   183,    -1,    -1,   581,    -1,
     580,   421,   581,    -1,   783,   590,    -1,   134,   583,   206,
     781,   271,   775,   584,   415,   585,   416,   507,   702,    -1,
     365,    -1,    -1,   372,   779,    -1,    -1,   586,    -1,   585,
     421,   586,    -1,   909,   587,    -1,   733,   587,    -1,   415,
     730,   416,   587,    -1,   560,    -1,   372,   560,    -1,    -1,
     134,   589,   190,   783,   590,   308,   596,   598,   600,    -1,
     275,   304,    -1,    -1,   415,   591,   416,    -1,   415,   416,
      -1,   592,    -1,   591,   421,   592,    -1,   593,   595,   597,
      -1,   593,   597,    -1,   203,    -1,   277,    -1,   210,    -1,
      -1,   794,    -1,   794,   421,   794,    -1,   911,    -1,   597,
      -1,   705,    -1,   910,   561,   410,   361,    -1,   599,    -1,
     598,   599,    -1,    93,   594,    -1,   227,   457,    -1,   201,
      -1,   333,    -1,   380,    -1,   110,   271,   262,   211,    -1,
     308,   262,   271,   262,   211,    -1,   340,    -1,   177,   319,
     155,    -1,   177,   319,   220,    -1,   319,   155,    -1,   319,
     220,    -1,   383,   547,    -1,    -1,   164,   190,   783,   590,
     470,    -1,   164,    84,   783,   415,   603,   416,   470,    -1,
     705,    -1,   408,    -1,   164,   273,   736,   415,   605,   416,
     470,    -1,   705,    -1,   705,   421,   705,    -1,   256,   421,
     705,    -1,   705,   421,   256,    -1,   736,    -1,   909,   417,
     606,    -1,   134,   113,   415,   705,    93,   705,   416,   383,
     190,   581,   608,    -1,   134,   113,   415,   705,    93,   705,
     416,   384,   190,   608,    -1,    93,    96,    -1,    -1,   164,
     113,   415,   705,    93,   705,   416,   470,    -1,   299,   611,
     775,   612,    -1,   299,   145,   777,   612,    -1,   206,    -1,
     343,    -1,   184,    -1,    -1,    87,    84,   783,   415,   603,
     416,   302,   351,   777,    -1,    87,   131,   560,   302,   351,
     777,    -1,    87,   145,   778,   302,   351,   778,    -1,    87,
     190,   783,   590,   302,   351,   777,    -1,    87,   194,   799,
     302,   351,   799,    -1,    87,   227,   777,   302,   351,   777,
      -1,    87,   273,   120,   560,   372,   779,   302,   351,   777,
      -1,    87,   316,   777,   302,   351,   777,    -1,    87,   343,
     700,   302,   351,   777,    -1,    87,   206,   700,   302,   351,
     777,    -1,    87,   343,   700,   302,   614,   777,   351,   777,
      -1,    87,   356,   777,   271,   700,   302,   351,   777,    -1,
      87,   371,   799,   302,   351,   799,    -1,    87,   344,   777,
     302,   351,   777,    -1,   125,    -1,    -1,    87,    84,   783,
     415,   603,   416,   281,   351,   799,    -1,    87,   131,   560,
     281,   351,   799,    -1,    87,   145,   778,   281,   351,   799,
      -1,    87,   162,   778,   281,   351,   799,    -1,    87,   190,
     783,   590,   281,   351,   799,    -1,    87,   273,   606,   415,
     605,   416,   281,   351,   799,    -1,    87,   273,   120,   560,
     372,   779,   281,   351,   799,    -1,    87,   316,   777,   281,
     351,   799,    -1,    87,   361,   560,   281,   351,   799,    -1,
      87,   344,   777,   281,   351,   799,    -1,    -1,   134,   589,
     314,   777,    93,   617,   271,   622,   351,   775,   702,   161,
     623,   618,    -1,   258,    -1,   620,    -1,   415,   619,   416,
      -1,   619,   418,   621,    -1,   621,    -1,   669,    -1,   656,
      -1,   665,    -1,   660,    -1,   625,    -1,   620,    -1,    -1,
     320,    -1,   369,    -1,   156,    -1,   213,    -1,   214,    -1,
      86,    -1,    -1,   164,   314,   777,   271,   775,   470,    -1,
     259,   775,    -1,   235,   775,    -1,   367,   775,    -1,   367,
     408,    -1,    78,   629,    -1,   101,   629,   632,    -1,   334,
     354,   632,    -1,   127,   629,    -1,   169,   629,    -1,   311,
     629,    -1,   315,   909,    -1,   301,   315,   909,    -1,   301,
     909,    -1,   311,   629,   351,   315,   909,    -1,   311,   629,
     351,   909,    -1,   385,    -1,   354,    -1,    -1,   223,   232,
     452,    -1,   295,   272,    -1,   295,   386,    -1,   630,    -1,
     631,   421,   630,    -1,   631,   630,    -1,   631,    -1,    -1,
     134,   589,   379,   775,   496,    93,   669,    -1,   236,   782,
      -1,   134,   145,   778,   383,   636,    -1,   134,   145,   778,
      -1,   637,    -1,   636,   637,    -1,   344,   638,   777,    -1,
     344,   638,   151,    -1,   238,   638,   794,    -1,   238,   638,
     151,    -1,   346,   638,   777,    -1,   346,   638,   151,    -1,
     167,   638,   795,    -1,   167,   638,   151,    -1,   281,   638,
     777,    -1,   281,   638,   151,    -1,   402,    -1,    -1,    87,
     145,   778,   325,   448,    -1,    87,   145,   778,   459,    -1,
     164,   145,   778,    -1,   134,   162,   560,   643,   705,   488,
      -1,    87,   162,   560,   469,    -1,    87,   162,   560,   164,
     257,   262,    -1,    87,   162,   560,   325,   257,   262,    -1,
      87,   162,   560,    82,   494,    -1,    87,   162,   560,   164,
     129,   777,   470,    -1,    93,    -1,    -1,   134,   554,   131,
     560,   183,   794,   351,   794,   188,   560,    -1,   122,   781,
     271,   775,    -1,   122,   775,    -1,   122,    -1,   373,   650,
     651,   649,    -1,   373,   650,   651,   649,   775,    -1,   373,
     650,   651,   649,   647,    -1,   648,   649,    -1,   648,   649,
     775,   652,    -1,    89,    -1,    88,    -1,   378,    -1,    -1,
     189,    -1,    -1,   187,    -1,    -1,   415,   776,   416,    -1,
      -1,   176,   655,   649,   654,    -1,   669,    -1,   656,    -1,
     665,    -1,   660,    -1,   666,    -1,   648,    -1,    -1,   213,
     219,   775,   657,    -1,   375,   415,   771,   416,    -1,   151,
     375,    -1,   669,    -1,   415,   658,   416,   375,   415,   771,
     416,    -1,   415,   658,   416,   669,    -1,   658,   421,   659,
      -1,   659,    -1,   909,   763,    -1,   156,   188,   700,   702,
      -1,   239,   676,   774,   662,   664,    -1,   203,   663,   244,
      -1,    -1,    80,   327,    -1,   312,   327,    -1,   312,   172,
      -1,   327,   369,   172,    -1,   327,    -1,   327,   312,   172,
      -1,   172,    -1,    80,   172,    -1,   261,    -1,    -1,   369,
     700,   325,   767,   692,   702,    -1,   150,   777,   667,   143,
     668,   183,   669,    -1,    -1,   667,   104,    -1,   667,   212,
      -1,   667,   317,    -1,   667,   253,   317,    -1,    -1,   383,
     197,    -1,   384,   197,    -1,   671,    -1,   670,    -1,   415,
     671,   416,    -1,   415,   670,   416,    -1,   673,    -1,   672,
     680,    -1,   672,   679,   689,   684,    -1,   672,   679,   683,
     690,    -1,   673,    -1,   670,    -1,   320,   678,   765,   674,
     692,   702,   687,   688,    -1,   672,   364,   677,   672,    -1,
     672,   217,   677,   672,    -1,   672,   171,   677,   672,    -1,
     219,   675,    -1,   872,    -1,    -1,   347,   676,   775,    -1,
     345,   676,   775,    -1,   237,   347,   676,   775,    -1,   237,
     345,   676,   775,    -1,   192,   347,   676,   775,    -1,   192,
     345,   676,   775,    -1,   343,   775,    -1,   775,    -1,   343,
      -1,    -1,    85,    -1,    -1,   160,    -1,   160,   271,   415,
     741,   416,    -1,    85,    -1,    -1,   680,    -1,    -1,   276,
     108,   681,    -1,   682,    -1,   681,   421,   682,    -1,   730,
     372,   739,    -1,   730,    94,    -1,   730,   159,    -1,   730,
      -1,   234,   685,   268,   686,    -1,   268,   686,   234,   685,
      -1,   234,   685,    -1,   268,   686,    -1,   234,   685,   421,
     686,    -1,   683,    -1,    -1,   730,    -1,    85,    -1,   730,
      -1,   194,   108,   741,    -1,    -1,   196,   730,    -1,    -1,
     183,   369,   691,    -1,   183,   295,   272,    -1,   689,    -1,
      -1,   266,   776,    -1,    -1,   188,   693,    -1,    -1,   693,
     421,   694,    -1,   694,    -1,   700,    -1,   700,   696,    -1,
     701,    -1,   701,   696,    -1,   701,    93,   415,   703,   416,
      -1,   701,    93,   909,   415,   703,   416,    -1,   701,   909,
     415,   703,   416,    -1,   670,    -1,   670,   696,    -1,   695,
      -1,   415,   695,   416,   696,    -1,   415,   695,   416,    -1,
     694,   137,   224,   694,    -1,   694,   389,   694,    -1,   694,
     697,   224,   694,   699,    -1,   694,   224,   694,   699,    -1,
     694,   249,   697,   224,   694,    -1,   694,   249,   224,   694,
      -1,    93,   909,   415,   776,   416,    -1,    93,   909,    -1,
     909,   415,   776,   416,    -1,   909,    -1,   189,   698,    -1,
     231,   698,    -1,   310,   698,    -1,   209,    -1,   278,    -1,
      -1,   372,   415,   776,   416,    -1,   271,   730,    -1,   775,
      -1,   775,   408,    -1,   272,   775,    -1,   272,   415,   775,
     416,    -1,   733,    -1,   382,   730,    -1,    -1,   704,    -1,
     703,   421,   704,    -1,   909,   705,    -1,   708,   706,    -1,
     326,   708,   706,    -1,   708,    92,   413,   790,   414,    -1,
     326,   708,    92,   413,   790,   414,    -1,   413,   414,   706,
      -1,   413,   707,   414,   706,    -1,    -1,   790,    -1,   415,
     707,   416,    -1,   707,   406,   707,    -1,   707,   407,   707,
      -1,   707,   408,   707,    -1,   707,   409,   707,    -1,   707,
     410,   707,    -1,   789,    -1,   909,    -1,   710,    -1,   726,
      -1,   711,    -1,   715,    -1,   719,    -1,   727,   729,    -1,
     727,   415,   790,   416,   729,    -1,   910,   561,    -1,   710,
      -1,   726,    -1,   711,    -1,   716,    -1,   720,    -1,   910,
      -1,   215,    -1,   216,    -1,   331,    -1,   103,    -1,   296,
      -1,   182,   712,    -1,   163,   286,    -1,   149,   714,    -1,
     148,   714,    -1,   264,   713,    -1,   106,    -1,   415,   790,
     416,    -1,    -1,   415,   790,   421,   790,   416,    -1,   415,
     790,   416,    -1,    -1,   415,   790,   421,   790,   416,    -1,
     415,   790,   416,    -1,    -1,   717,    -1,   718,    -1,   717,
      -1,   718,    -1,   105,   724,   415,   790,   416,    -1,   105,
     724,    -1,   721,    -1,   722,    -1,   721,    -1,   722,    -1,
     723,   415,   790,   416,   725,    -1,   723,   725,    -1,   116,
     724,    -1,   115,   724,    -1,   376,    -1,   248,   116,   724,
      -1,   248,   115,   724,    -1,   250,   724,    -1,   377,    -1,
      -1,   116,   325,   909,    -1,    -1,   350,   415,   790,   416,
     728,    -1,   350,   728,    -1,   349,   415,   790,   416,   728,
      -1,   349,   728,    -1,   218,    -1,   383,   349,   388,    -1,
     384,   349,   388,    -1,    -1,   387,    -1,   245,    -1,   146,
      -1,   198,    -1,   242,    -1,   318,    -1,   387,   351,   245,
      -1,   146,   351,   198,    -1,   146,   351,   242,    -1,   146,
     351,   318,    -1,   198,   351,   242,    -1,   242,   351,   318,
      -1,   198,   351,   318,    -1,    -1,   732,    -1,   730,    77,
     705,    -1,   730,    97,   349,   388,   732,    -1,   406,   730,
      -1,   407,   730,    -1,   410,   730,    -1,   411,   730,    -1,
     730,   410,    -1,   730,   411,    -1,   730,   406,   730,    -1,
     730,   407,   730,    -1,   730,   408,   730,    -1,   730,   409,
     730,    -1,   730,   410,   730,    -1,   730,   411,   730,    -1,
     730,   403,   730,    -1,   730,   404,   730,    -1,   730,   402,
     730,    -1,   730,   738,   730,    -1,   738,   730,    -1,   730,
     738,    -1,   730,    90,   730,    -1,   730,   275,   730,    -1,
     257,   730,    -1,   730,   233,   730,    -1,   730,   233,   730,
     170,   730,    -1,   730,   257,   233,   730,    -1,   730,   257,
     233,   730,   170,   730,    -1,   730,   199,   730,    -1,   730,
     199,   730,   170,   730,    -1,   730,   257,   199,   730,    -1,
     730,   257,   199,   730,   170,   730,    -1,   730,   329,   351,
     730,    -1,   730,   329,   351,   730,   170,   730,    -1,   730,
     257,   329,   351,   730,    -1,   730,   257,   329,   351,   730,
     170,   730,    -1,   730,   222,    -1,   730,   221,   262,    -1,
     730,   260,    -1,   730,   221,   257,   262,    -1,   730,   221,
     358,    -1,   730,   221,   257,   358,    -1,   730,   221,   179,
      -1,   730,   221,   257,   179,    -1,   730,   221,   366,    -1,
     730,   221,   257,   366,    -1,   730,   221,   160,   188,   730,
      -1,   730,   221,   266,   415,   743,   416,    -1,   730,   221,
     257,   266,   415,   743,   416,    -1,   730,   102,   731,    90,
     731,    -1,   730,   257,   102,   731,    90,   731,    -1,   730,
     203,   754,    -1,   730,   257,   203,   754,    -1,   730,   740,
     735,   670,    -1,   730,   740,   735,   415,   730,   416,    -1,
     365,   670,    -1,   732,    -1,   731,    77,   705,    -1,   407,
     731,    -1,   410,   731,    -1,   411,   731,    -1,   731,   410,
      -1,   731,   411,    -1,   731,   406,   731,    -1,   731,   407,
     731,    -1,   731,   408,   731,    -1,   731,   409,   731,    -1,
     731,   410,   731,    -1,   731,   411,   731,    -1,   731,   403,
     731,    -1,   731,   404,   731,    -1,   731,   402,   731,    -1,
     731,   392,   731,    -1,   738,   731,    -1,   731,   738,    -1,
     731,   221,   160,   188,   731,    -1,   731,   221,   266,   415,
     731,   416,    -1,   731,   221,   257,   266,   415,   731,   416,
      -1,   760,    -1,   784,    -1,   400,   763,    -1,   415,   730,
     416,   763,    -1,   755,    -1,   733,    -1,   670,    -1,   175,
     670,    -1,    92,   670,    -1,    92,   745,    -1,   734,    -1,
     783,   415,   416,    -1,   783,   415,   741,   416,    -1,   783,
     415,    85,   741,   416,    -1,   783,   415,   160,   741,   416,
      -1,   783,   415,   408,   416,    -1,   139,    -1,   140,   764,
      -1,   140,   415,   790,   416,    -1,   141,   764,    -1,   141,
     415,   790,   416,    -1,   142,   764,    -1,   324,   764,    -1,
     371,   764,    -1,   113,   415,   730,    93,   705,   416,    -1,
     178,   415,   742,   416,    -1,   280,   415,   747,   416,    -1,
     285,   415,   749,   416,    -1,   341,   415,   750,   416,    -1,
     355,   415,   730,    93,   705,   416,    -1,   357,   415,   107,
     753,   416,    -1,   357,   415,   230,   753,   416,    -1,   357,
     415,   353,   753,   416,    -1,   357,   415,   753,   416,    -1,
     132,   415,   730,   372,   560,   416,    -1,   132,   415,   741,
     416,    -1,   263,   415,   730,   421,   730,   416,    -1,   123,
     415,   741,   416,    -1,   312,   415,   741,   416,    -1,   312,
     415,   416,    -1,   415,   741,   421,   730,   416,    -1,    91,
      -1,   332,    -1,    85,    -1,   392,    -1,   737,    -1,   406,
      -1,   407,    -1,   408,    -1,   410,    -1,   411,    -1,   409,
      -1,   403,    -1,   404,    -1,   402,    -1,   392,    -1,   273,
     415,   606,   416,    -1,   736,    -1,   273,   415,   606,   416,
      -1,   736,    -1,   273,   415,   606,   416,    -1,   233,    -1,
     257,   233,    -1,   199,    -1,   257,   199,    -1,   730,    -1,
     741,   421,   730,    -1,   746,   188,   730,    -1,    -1,   743,
     421,   705,    -1,   705,    -1,   745,    -1,   744,   421,   745,
      -1,   413,   741,   414,    -1,   413,   744,   414,    -1,   930,
      -1,   387,    -1,   245,    -1,   146,    -1,   198,    -1,   242,
      -1,   318,    -1,   794,    -1,   730,   748,   751,   752,    -1,
     730,   748,   751,    -1,   284,   730,    -1,   731,   203,   731,
      -1,    -1,   730,   751,   752,    -1,   730,   752,   751,    -1,
     730,   751,    -1,   730,   752,    -1,   741,    -1,    -1,   188,
     730,    -1,   183,   730,    -1,   730,   188,   741,    -1,   188,
     741,    -1,   741,    -1,   670,    -1,   415,   741,   416,    -1,
     112,   759,   756,   758,   169,    -1,   756,   757,    -1,   757,
      -1,   381,   730,   348,   730,    -1,   166,   730,    -1,    -1,
     730,    -1,    -1,   773,    -1,   773,   762,    -1,   417,   780,
      -1,   417,   408,    -1,   413,   730,   414,    -1,   413,   730,
     423,   730,   414,    -1,   761,    -1,   762,   761,    -1,    -1,
     763,   761,    -1,   415,   416,    -1,    -1,   765,   421,   766,
      -1,   766,    -1,   730,    93,   912,    -1,   730,    -1,   408,
      -1,   767,   421,   770,    -1,   415,   768,   416,   402,   415,
     769,   416,    -1,   770,    -1,   909,   763,    -1,   909,   763,
     421,   768,    -1,   730,    -1,   730,   421,   769,    -1,   909,
     763,   402,   730,    -1,   909,   763,   402,   151,    -1,   771,
     421,   772,    -1,   772,    -1,   730,    -1,   151,    -1,   800,
      -1,   909,    -1,   775,    -1,   774,   421,   775,    -1,   773,
      -1,   773,   561,    -1,   777,    -1,   776,   421,   777,    -1,
     909,    -1,   909,    -1,   909,    -1,   912,    -1,   909,    -1,
     794,    -1,   911,    -1,   773,   762,    -1,   798,    -1,   709,
     794,    -1,   727,   794,   729,    -1,   727,   415,   790,   416,
     794,   729,    -1,   358,    -1,   179,    -1,   262,    -1,   926,
      -1,   399,    -1,   401,    -1,   397,    -1,   398,    -1,   391,
      -1,   785,    -1,   927,    -1,   790,    -1,   407,   790,    -1,
     785,    -1,   929,    -1,   786,    -1,   792,    -1,   407,   786,
      -1,   407,   785,    -1,   789,    -1,   789,    -1,   927,    -1,
     785,    -1,   789,    -1,   927,    -1,   786,    -1,   785,    -1,
     407,   786,    -1,   407,   785,    -1,   927,    -1,   789,    -1,
     796,    -1,   789,    -1,   786,    -1,   785,    -1,   787,    -1,
     788,    -1,   927,    -1,   909,    -1,   270,    -1,   251,    -1,
       9,   351,   802,   808,   809,    -1,     9,   351,   151,    -1,
       9,   810,    -1,   145,   802,    -1,   778,   805,   807,    -1,
     803,   423,   804,   807,   409,   778,   813,    -1,   789,    -1,
     812,    -1,   930,   929,    -1,   392,   806,    -1,   804,    -1,
      -1,   909,    -1,   909,   417,   806,    -1,   396,    -1,   423,
     790,    -1,    -1,    93,   802,    -1,    -1,   371,   810,    -1,
      -1,   811,    -1,   811,   409,   811,    -1,   811,    25,   108,
     811,    -1,   811,   372,   811,    -1,   799,    -1,   794,    -1,
     929,    -1,   392,   909,    -1,    -1,   150,   777,   667,   143,
     668,   183,   864,    -1,   147,   288,   864,    -1,   147,   864,
      -1,   817,    -1,   831,    -1,   818,    -1,    -1,   836,   839,
     819,   852,   418,    -1,    -1,   839,   820,   852,   418,    -1,
     842,   418,    -1,   796,    -1,   421,   796,    -1,    -1,   729,
      -1,   387,   351,   242,    -1,   387,   351,   318,    -1,   146,
     351,   146,    -1,   245,   351,   245,    -1,    -1,   826,   825,
     828,   827,    -1,   923,   101,   150,    39,   418,    -1,   923,
     169,   150,    39,   418,    -1,    -1,   829,    -1,   833,    -1,
     831,    -1,   829,   833,    -1,   829,   831,    -1,   833,    -1,
     830,   833,    -1,    -1,    76,   832,   839,   855,   913,   706,
     418,    -1,    -1,   836,   839,   834,   852,   418,    -1,    -1,
     839,   835,   852,   418,    -1,   842,   418,    -1,   837,   838,
      -1,   837,    -1,   838,    -1,    62,    -1,    73,    -1,    71,
      -1,    56,    -1,    57,    -1,    75,    -1,   848,    -1,   844,
      -1,   840,    -1,   913,   415,   821,   822,   416,    -1,   913,
     823,    -1,   846,    -1,    20,   908,   841,    -1,    20,   841,
      -1,    20,   908,    -1,   419,   934,   420,    -1,    -1,   846,
     843,   419,   830,   420,    -1,   842,    -1,    -1,   847,   845,
     419,   830,   420,    -1,    48,   908,    -1,   364,   908,    -1,
      48,    -1,   364,    -1,   849,    -1,   851,   850,    -1,    49,
      40,    -1,    49,    40,   215,    -1,    49,    -1,    49,   215,
      -1,    49,    29,    -1,    49,    29,   215,    -1,    49,    29,
      29,    -1,    49,    29,    29,   215,    -1,    49,   115,    -1,
      40,    -1,    40,   215,    -1,   215,    -1,    29,    -1,    29,
     215,    -1,    29,    29,    -1,    29,    29,   215,    -1,     5,
      -1,   115,    -1,   163,    -1,    41,    -1,    -1,   853,    -1,
     852,   421,   853,    -1,   855,   914,   706,   854,    -1,    -1,
     402,   935,    -1,    -1,   408,    -1,   408,   408,    -1,   150,
     335,   930,    -1,    19,   858,    -1,   859,    -1,    13,    -1,
      85,    -1,    -1,   802,    -1,   151,    -1,   174,   200,   863,
      -1,    -1,   174,   864,   861,   862,    -1,   868,   872,    -1,
     872,   868,    -1,   868,    -1,   872,    -1,    -1,   812,    -1,
     393,    -1,   777,    -1,   812,    -1,    22,   777,    -1,    33,
     777,   867,    -1,    -1,   868,    -1,   372,   873,    -1,   869,
      -1,   372,   871,    18,   931,    -1,   219,   871,    18,   931,
      -1,    -1,    42,    -1,   219,   922,    -1,   870,    -1,   874,
      -1,   874,   421,   873,    -1,   797,    -1,   926,    -1,   288,
     864,   188,   863,    -1,    17,   211,   777,   869,    -1,    17,
     877,   777,   869,    -1,    17,   877,   777,   870,    -1,    34,
      -1,    -1,     3,    18,   931,    -1,   147,    18,   931,    -1,
     191,    18,   931,   881,    -1,   882,    -1,   881,   421,   882,
      -1,   929,   402,   886,    -1,   325,    18,   931,   884,    -1,
     885,    -1,   884,   421,   885,    -1,   886,   402,   792,    -1,
      12,    -1,   191,    18,   931,    50,   792,   888,    -1,   889,
      -1,   888,   421,   889,    -1,   929,   402,   893,    -1,   325,
      18,   931,    50,   792,   891,    -1,   892,    -1,   891,   421,
     892,    -1,   893,   402,   793,    -1,     8,    -1,    14,    -1,
      15,    -1,    16,    -1,    26,    -1,    27,    -1,    28,    -1,
      30,    -1,    31,    -1,    32,    -1,   286,    -1,    36,    -1,
      37,    -1,    38,    -1,   361,    -1,   325,     4,   402,   895,
      -1,   325,     4,   351,   895,    -1,   271,    -1,   267,    -1,
     325,    10,   351,   859,    -1,   325,    10,   402,   859,    -1,
     325,    10,   859,    -1,    -1,   361,   898,   913,   221,   839,
     706,   899,    -1,    35,    -1,    -1,    -1,    51,   901,   912,
     221,   839,   706,   899,    -1,    52,    43,   903,    -1,    52,
     257,    21,   903,    -1,    52,    45,   903,    -1,    11,    -1,
      44,    -1,    47,    -1,    24,   777,    -1,    23,   351,   777,
      -1,   161,   777,   415,   924,   416,    -1,   161,     6,    -1,
       7,   777,   415,   924,   416,    -1,     7,   777,    -1,   905,
      -1,   906,    -1,     6,    -1,     7,    -1,     8,    -1,    11,
      -1,    12,    -1,    14,    -1,    15,    -1,    16,    -1,    21,
      -1,    23,    -1,    24,    -1,    25,    -1,    26,    -1,    27,
      -1,    28,    -1,    30,    -1,    31,    -1,    32,    -1,    36,
      -1,    37,    -1,    38,    -1,    39,    -1,    43,    -1,    44,
      -1,    45,    -1,    47,    -1,     9,    -1,    17,    -1,    19,
      -1,    33,    -1,    51,    -1,    52,    -1,     5,    -1,    29,
      -1,    34,    -1,    40,    -1,    48,    -1,    41,    -1,    49,
      -1,   912,    -1,   930,    -1,   916,    -1,   919,    -1,   904,
      -1,   915,    -1,   115,    -1,   930,    -1,   916,    -1,   904,
      -1,   907,    -1,   915,    -1,   930,    -1,   916,    -1,   920,
      -1,   904,    -1,   915,    -1,   914,    -1,   907,    -1,   115,
      -1,   211,    -1,   215,    -1,   364,    -1,   351,    -1,   915,
      -1,   917,    -1,   930,    -1,   919,    -1,   920,    -1,   905,
      -1,   913,    -1,   921,    -1,   918,    -1,   906,    -1,    56,
      -1,    57,    -1,    62,    -1,    71,    -1,    73,    -1,    76,
      -1,    75,    -1,   917,    -1,   918,    -1,   146,    -1,   198,
      -1,   242,    -1,   245,    -1,   318,    -1,   387,    -1,    78,
      -1,    79,    -1,    80,    -1,    81,    -1,    82,    -1,    83,
      -1,    84,    -1,    86,    -1,    87,    -1,    95,    -1,    96,
      -1,    97,    -1,    99,    -1,   100,    -1,   101,    -1,   108,
      -1,   109,    -1,   111,    -1,   114,    -1,   117,    -1,   119,
      -1,   120,    -1,   121,    -1,   122,    -1,   126,    -1,   127,
      -1,   128,    -1,   130,    -1,   131,    -1,   133,    -1,   135,
      -1,   136,    -1,   138,    -1,   143,    -1,   144,    -1,   145,
      -1,   147,    -1,   150,    -1,   152,    -1,   154,    -1,   156,
      -1,   157,    -1,   158,    -1,   162,    -1,   163,    -1,   164,
      -1,   165,    -1,   167,    -1,   168,    -1,   170,    -1,   173,
      -1,   172,    -1,   174,    -1,   176,    -1,   180,    -1,   181,
      -1,   184,    -1,   186,    -1,   190,    -1,   192,    -1,   195,
      -1,   197,    -1,   200,    -1,   201,    -1,   202,    -1,   204,
      -1,   205,    -1,   206,    -1,   207,    -1,   212,    -1,   213,
      -1,   214,    -1,   223,    -1,   225,    -1,   226,    -1,   227,
      -1,   228,    -1,   229,    -1,   232,    -1,   235,    -1,   236,
      -1,   237,    -1,   238,    -1,   239,    -1,   240,    -1,   241,
      -1,   243,    -1,   244,    -1,   246,    -1,   247,    -1,   252,
      -1,   253,    -1,   254,    -1,   255,    -1,   258,    -1,   259,
      -1,   261,    -1,   265,    -1,   266,    -1,   269,    -1,   273,
      -1,   274,    -1,   281,    -1,   282,    -1,   283,    -1,   288,
      -1,   287,    -1,   290,    -1,   291,    -1,   292,    -1,   293,
      -1,   294,    -1,   295,    -1,   297,    -1,   299,    -1,   300,
      -1,   301,    -1,   302,    -1,   303,    -1,   304,    -1,   305,
      -1,   306,    -1,   307,    -1,   308,    -1,   309,    -1,   311,
      -1,   313,    -1,   314,    -1,   315,    -1,   316,    -1,   317,
      -1,   321,    -1,   322,    -1,   323,    -1,   325,    -1,   327,
      -1,   328,    -1,   330,    -1,   333,    -1,   334,    -1,   335,
      -1,   336,    -1,   337,    -1,   338,    -1,   339,    -1,   340,
      -1,   342,    -1,   344,    -1,   345,    -1,   346,    -1,   347,
      -1,   352,    -1,   354,    -1,   356,    -1,   359,    -1,   360,
      -1,   361,    -1,   362,    -1,   363,    -1,   366,    -1,   367,
      -1,   368,    -1,   369,    -1,   370,    -1,   373,    -1,   374,
      -1,   375,    -1,   377,    -1,   379,    -1,   383,    -1,   384,
      -1,   385,    -1,   386,    -1,   388,    -1,   103,    -1,   105,
      -1,   116,    -1,   123,    -1,   132,    -1,   148,    -1,   149,
      -1,   175,    -1,   178,    -1,   182,    -1,   210,    -1,   216,
      -1,   218,    -1,   248,    -1,   250,    -1,   256,    -1,   263,
      -1,   264,    -1,   277,    -1,   280,    -1,   285,    -1,   286,
      -1,   296,    -1,   312,    -1,   326,    -1,   331,    -1,   341,
      -1,   349,    -1,   350,    -1,   355,    -1,   357,    -1,   376,
      -1,    98,    -1,   102,    -1,   104,    -1,   137,    -1,   187,
      -1,   189,    -1,   199,    -1,   209,    -1,   221,    -1,   222,
      -1,   224,    -1,   231,    -1,   233,    -1,   249,    -1,   260,
      -1,   278,    -1,   279,    -1,   310,    -1,   329,    -1,   378,
      -1,    85,    -1,    88,    -1,    89,    -1,    90,    -1,    91,
      -1,    92,    -1,    93,    -1,    94,    -1,   107,    -1,   112,
      -1,   113,    -1,   118,    -1,   124,    -1,   125,    -1,   129,
      -1,   134,    -1,   139,    -1,   140,    -1,   141,    -1,   142,
      -1,   151,    -1,   153,    -1,   159,    -1,   160,    -1,   161,
      -1,   166,    -1,   169,    -1,   171,    -1,   179,    -1,   183,
      -1,   185,    -1,   188,    -1,   193,    -1,   194,    -1,   196,
      -1,   203,    -1,   208,    -1,   217,    -1,   219,    -1,   230,
      -1,   234,    -1,   251,    -1,   257,    -1,   262,    -1,   267,
      -1,   268,    -1,   270,    -1,   271,    -1,   272,    -1,   275,
      -1,   276,    -1,   289,    -1,   298,    -1,   320,    -1,   324,
      -1,   332,    -1,   343,    -1,   348,    -1,   353,    -1,   358,
      -1,   365,    -1,   371,    -1,   372,    -1,   381,    -1,   382,
      -1,   925,    -1,   922,   421,   925,    -1,    46,    -1,    -1,
     934,    -1,   929,   928,    -1,   929,    -1,   929,   928,    -1,
     929,    -1,   929,    -1,    26,   929,    -1,    26,   777,    -1,
     394,    -1,   390,    -1,   393,    -1,   777,    -1,   812,    -1,
     937,    -1,   415,   416,    -1,   415,   933,   416,    -1,   932,
      -1,   933,   932,    -1,   935,    -1,   934,   421,   935,    -1,
     933,    -1,   419,   934,   420,    -1,   937,    -1,   415,    -1,
     416,    -1,   421,    -1,   418,    -1,   390,    -1,   393,    -1,
     785,    -1,   786,    -1,   789,    -1,   408,    -1,   406,    -1,
     407,    -1,   409,    -1,   410,    -1,   262,    -1,    53,    -1,
      54,    -1,    55,    -1,    56,    -1,    57,    -1,    58,    -1,
      59,    -1,    60,    -1,    61,    -1,    62,    -1,    63,    -1,
      64,    -1,    66,    -1,    65,    -1,    67,    -1,    68,    -1,
      69,    -1,    70,    -1,    71,    -1,    72,    -1,    73,    -1,
      74,    -1,    76,    -1,    75,    -1,     5,    -1,    20,    -1,
     198,    -1,   215,    -1,    29,    -1,   242,    -1,   245,    -1,
     318,    -1,    40,    -1,    41,    -1,    48,    -1,    49,    -1,
     387,    -1,   115,    -1,   182,    -1,   351,    -1,   364,    -1,
     376,    -1,   413,    -1,   414,    -1,   402,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short yyrline[] =
{
       0,   585,   585,   587,   588,   591,   592,   593,   599,   600,
     601,   602,   603,   606,   618,   619,   620,   621,   622,   623,
     624,   625,   626,   627,   628,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   671,   672,   673,   674,   675,
     676,   677,   678,   679,   680,   681,   682,   683,   684,   685,
     687,   688,   689,   690,   691,   692,   693,   694,   696,   697,
     698,   699,   700,   701,   702,   703,   704,   710,   711,   712,
     713,   714,   715,   716,   717,   718,   724,   734,   738,   746,
     754,   758,   769,   779,   783,   790,   797,   803,   811,   821,
     827,   836,   843,   849,   858,   865,   886,   890,   891,   902,
     904,   908,   910,   920,   927,   928,   931,   933,   935,   937,
     939,   941,   943,   945,   949,   951,   961,   963,   970,   971,
     974,   976,   987,   989,   999,  1010,  1012,  1016,  1017,  1020,
    1021,  1028,  1029,  1030,  1031,  1032,  1033,  1046,  1048,  1050,
    1054,  1056,  1058,  1060,  1062,  1064,  1066,  1068,  1072,  1073,
    1077,  1079,  1083,  1085,  1089,  1090,  1091,  1092,  1095,  1096,
    1097,  1100,  1101,  1102,  1103,  1113,  1114,  1115,  1117,  1119,
    1121,  1125,  1126,  1127,  1130,  1131,  1134,  1136,  1138,  1140,
    1142,  1146,  1148,  1150,  1152,  1154,  1158,  1162,  1164,  1168,
    1169,  1175,  1186,  1188,  1194,  1195,  1199,  1203,  1206,  1209,
    1212,  1215,  1218,  1221,  1224,  1227,  1230,  1233,  1236,  1239,
    1243,  1244,  1250,  1253,  1258,  1259,  1262,  1263,  1264,  1267,
    1268,  1278,  1292,  1297,  1298,  1306,  1307,  1308,  1311,  1312,
    1315,  1316,  1317,  1319,  1321,  1322,  1324,  1326,  1328,  1333,
    1334,  1337,  1338,  1345,  1348,  1351,  1352,  1362,  1365,  1375,
    1376,  1377,  1378,  1379,  1380,  1381,  1385,  1388,  1390,  1392,
    1396,  1397,  1398,  1401,  1407,  1408,  1411,  1413,  1414,  1428,
    1430,  1432,  1434,  1436,  1438,  1440,  1455,  1456,  1457,  1458,
    1461,  1468,  1469,  1470,  1477,  1479,  1483,  1485,  1487,  1489,
    1494,  1495,  1498,  1500,  1504,  1507,  1509,  1515,  1518,  1519,
    1520,  1521,  1522,  1525,  1529,  1533,  1534,  1535,  1536,  1537,
    1540,  1543,  1546,  1547,  1548,  1551,  1552,  1553,  1554,  1557,
    1558,  1561,  1562,  1571,  1570,  1588,  1589,  1590,  1594,  1597,
    1600,  1602,  1606,  1617,  1621,  1625,  1626,  1629,  1631,  1633,
    1635,  1637,  1639,  1641,  1643,  1645,  1647,  1651,  1652,  1663,
    1668,  1669,  1676,  1677,  1680,  1683,  1686,  1690,  1691,  1701,
    1705,  1706,  1720,  1731,  1736,  1744,  1745,  1748,  1750,  1752,
    1756,  1757,  1758,  1761,  1764,  1767,  1768,  1771,  1772,  1775,
    1777,  1780,  1783,  1784,  1787,  1788,  1791,  1792,  1799,  1800,
    1809,  1811,  1815,  1817,  1821,  1832,  1840,  1855,  1857,  1859,
    1861,  1865,  1869,  1873,  1874,  1877,  1878,  1882,  1883,  1884,
    1887,  1894,  1895,  1898,  1900,  1902,  1904,  1908,  1909,  1912,
    1913,  1916,  1928,  1932,  1933,  1934,  1935,  1936,  1937,  1938,
    1939,  1942,  1944,  1948,  1949,  1956,  1957,  1966,  1981,  1986,
    1991,  1996,  2001,  2006,  2011,  2016,  2021,  2023,  2027,  2028,
    2029,  2030,  2031,  2032,  2033,  2034,  2035,  2036,  2037,  2038,
    2039,  2040,  2043,  2046,  2047,  2050,  2052,  2054,  2056,  2058,
    2060,  2062,  2064,  2066,  2068,  2070,  2074,  2075,  2076,  2077,
    2078,  2079,  2080,  2081,  2082,  2083,  2086,  2087,  2097,  2101,
    2108,  2109,  2110,  2113,  2115,  2119,  2120,  2121,  2122,  2123,
    2124,  2125,  2126,  2127,  2128,  2129,  2130,  2133,  2135,  2137,
    2139,  2141,  2143,  2145,  2149,  2151,  2155,  2156,  2159,  2164,
    2167,  2172,  2175,  2177,  2181,  2192,  2197,  2198,  2201,  2204,
    2207,  2208,  2211,  2213,  2215,  2219,  2220,  2221,  2224,  2229,
    2230,  2233,  2235,  2239,  2241,  2245,  2246,  2249,  2250,  2256,
    2263,  2266,  2268,  2272,  2274,  2284,  2286,  2291,  2293,  2297,
    2299,  2301,  2303,  2305,  2307,  2309,  2311,  2313,  2315,  2317,
    2319,  2323,  2324,  2337,  2341,  2345,  2346,  2350,  2354,  2356,
    2358,  2360,  2365,  2367,  2371,  2374,  2379,  2380,  2384,  2395,
    2397,  2401,  2402,  2405,  2406,  2417,  2419,  2421,  2423,  2425,
    2427,  2429,  2431,  2433,  2435,  2437,  2439,  2441,  2443,  2447,
    2448,  2457,  2459,  2461,  2463,  2465,  2467,  2469,  2471,  2473,
    2475,  2487,  2486,  2496,  2497,  2498,  2502,  2504,  2508,  2509,
    2510,  2511,  2512,  2515,  2516,  2520,  2521,  2522,  2523,  2526,
    2527,  2528,  2531,  2543,  2547,  2551,  2553,  2566,  2567,  2568,
    2569,  2570,  2571,  2572,  2573,  2574,  2575,  2576,  2580,  2581,
    2582,  2586,  2588,  2589,  2593,  2594,  2595,  2599,  2600,  2610,
    2622,  2634,  2636,  2640,  2642,  2646,  2648,  2650,  2652,  2654,
    2656,  2658,  2660,  2662,  2664,  2668,  2669,  2680,  2682,  2693,
    2704,  2711,  2713,  2715,  2717,  2719,  2723,  2724,  2728,  2742,
    2744,  2746,  2759,  2761,  2763,  2767,  2769,  2773,  2774,  2777,
    2778,  2781,  2782,  2785,  2786,  2789,  2792,  2803,  2808,  2809,
    2810,  2811,  2812,  2816,  2817,  2866,  2870,  2872,  2874,  2876,
    2878,  2882,  2884,  2888,  2900,  2904,  2908,  2911,  2914,  2915,
    2916,  2917,  2918,  2919,  2920,  2921,  2924,  2925,  2935,  2949,
    2980,  2981,  2982,  2983,  2984,  2987,  2991,  2992,  3002,  3004,
    3008,  3010,  3014,  3016,  3018,  3020,  3024,  3025,  3028,  3032,
    3034,  3036,  3040,  3045,  3046,  3056,  3058,  3060,  3062,  3064,
    3066,  3068,  3070,  3074,  3075,  3078,  3079,  3082,  3084,  3086,
    3089,  3092,  3093,  3096,  3100,  3101,  3104,  3106,  3108,  3110,
    3114,  3116,  3118,  3120,  3122,  3126,  3127,  3130,  3131,  3134,
    3144,  3147,  3150,  3153,  3156,  3158,  3162,  3163,  3166,  3167,
    3178,  3179,  3182,  3183,  3193,  3195,  3197,  3199,  3201,  3203,
    3205,  3207,  3209,  3211,  3213,  3234,  3236,  3238,  3240,  3242,
    3244,  3246,  3250,  3252,  3254,  3256,  3260,  3261,  3262,  3263,
    3267,  3268,  3278,  3280,  3284,  3286,  3288,  3290,  3294,  3297,
    3298,  3301,  3303,  3307,  3320,  3322,  3324,  3326,  3331,  3337,
    3344,  3351,  3352,  3353,  3354,  3355,  3356,  3357,  3358,  3359,
    3362,  3363,  3364,  3365,  3366,  3367,  3369,  3371,  3375,  3376,
    3377,  3378,  3379,  3382,  3390,  3392,  3394,  3396,  3398,  3400,
    3402,  3404,  3406,  3408,  3410,  3414,  3417,  3420,  3422,  3425,
    3428,  3430,  3433,  3441,  3442,  3445,  3446,  3449,  3453,  3462,
    3463,  3466,  3467,  3470,  3474,  3478,  3480,  3482,  3484,  3486,
    3488,  3492,  3495,  3498,  3501,  3504,  3506,  3508,  3510,  3514,
    3518,  3520,  3523,  3526,  3527,  3528,  3529,  3530,  3531,  3532,
    3533,  3534,  3535,  3536,  3537,  3538,  3539,  3565,  3567,  3569,
    3580,  3582,  3584,  3586,  3588,  3590,  3592,  3594,  3596,  3598,
    3600,  3602,  3604,  3606,  3608,  3610,  3612,  3614,  3616,  3618,
    3620,  3622,  3624,  3626,  3628,  3630,  3632,  3634,  3636,  3638,
    3640,  3642,  3644,  3646,  3648,  3650,  3652,  3663,  3665,  3667,
    3669,  3671,  3673,  3675,  3677,  3679,  3681,  3683,  3685,  3687,
    3689,  3691,  3693,  3705,  3707,  3709,  3711,  3713,  3715,  3717,
    3719,  3721,  3723,  3725,  3727,  3729,  3731,  3733,  3735,  3737,
    3739,  3741,  3743,  3745,  3747,  3759,  3761,  3763,  3765,  3767,
    3769,  3771,  3773,  3775,  3777,  3779,  3791,  3793,  3795,  3797,
    3799,  3801,  3803,  3805,  3807,  3809,  3811,  3813,  3815,  3817,
    3819,  3821,  3823,  3825,  3827,  3830,  3832,  3834,  3836,  3838,
    3840,  3842,  3844,  3849,  3851,  3853,  3857,  3858,  3859,  3862,
    3863,  3866,  3867,  3868,  3869,  3870,  3871,  3872,  3873,  3874,
    3877,  3878,  3881,  3882,  3885,  3886,  3887,  3888,  3889,  3890,
    3893,  3895,  3899,  3902,  3905,  3907,  3911,  3912,  3916,  3917,
    3923,  3924,  3925,  3926,  3927,  3928,  3929,  3930,  3934,  3936,
    3941,  3945,  3948,  3951,  3953,  3955,  3957,  3959,  3962,  3965,
    3969,  3973,  3975,  3977,  3981,  3983,  3990,  3994,  3996,  4000,
    4004,  4007,  4010,  4011,  4014,  4015,  4019,  4020,  4021,  4022,
    4025,  4026,  4030,  4031,  4034,  4035,  4045,  4047,  4052,  4054,
    4056,  4061,  4063,  4087,  4091,  4100,  4111,  4119,  4129,  4131,
    4135,  4137,  4141,  4142,  4152,  4153,  4156,  4158,  4162,  4164,
    4168,  4170,  4175,  4176,  4177,  4178,  4179,  4181,  4183,  4185,
    4193,  4195,  4197,  4199,  4201,  4203,  4205,  4207,  4211,  4212,
    4213,  4214,  4215,  4226,  4227,  4230,  4231,  4234,  4242,  4245,
    4253,  4254,  4263,  4272,  4284,  4285,  4288,  4289,  4290,  4293,
    4294,  4295,  4296,  4297,  4300,  4301,  4304,  4305,  4306,  4307,
    4308,  4309,  4312,  4314,  4321,  4337,  4339,  4342,  4344,  4348,
    4356,  4372,  4379,  4385,  4397,  4406,  4407,  4410,  4411,  4412,
    4415,  4416,  4419,  4420,  4423,  4424,  4427,  4429,  4431,  4433,
    4437,  4444,  4467,  4499,  4509,  4516,  4556,  4558,  4565,  4567,
    4568,  4573,  4571,  4586,  4585,  4598,  4604,  4606,  4607,  4610,
    4611,  4612,  4613,  4614,  4621,  4620,  4630,  4632,  4634,  4635,
    4638,  4639,  4640,  4641,  4644,  4645,  4649,  4648,  4709,  4707,
    4722,  4721,  4734,  4740,  4744,  4748,  4754,  4755,  4756,  4757,
    4760,  4761,  4764,  4772,  4789,  4797,  4820,  4914,  4948,  4950,
    4952,  4956,  4960,  4959,  5010,  5012,  5011,  5026,  5032,  5039,
    5044,  5047,  5048,  5051,  5052,  5053,  5054,  5055,  5056,  5057,
    5065,  5073,  5076,  5077,  5078,  5079,  5080,  5081,  5089,  5097,
    5098,  5099,  5102,  5103,  5106,  5108,  5112,  5182,  5183,  5190,
    5191,  5192,  5198,  5207,  5210,  5211,  5212,  5213,  5216,  5217,
    5223,  5237,  5236,  5254,  5255,  5256,  5257,  5258,  5261,  5263,
    5267,  5268,  5275,  5280,  5282,  5283,  5286,  5287,  5290,  5297,
    5304,  5304,  5306,  5307,  5310,  5310,  5312,  5322,  5331,  5337,
    5343,  5349,  5357,  5358,  5370,  5380,  5391,  5395,  5396,  5399,
    5404,  5408,  5409,  5412,  5419,  5426,  5430,  5431,  5434,  5437,
    5441,  5442,  5445,  5452,  5453,  5454,  5455,  5456,  5457,  5458,
    5459,  5460,  5461,  5462,  5463,  5464,  5465,  5466,  5496,  5497,
    5500,  5501,  5508,  5509,  5510,  5517,  5516,  5575,  5576,  5583,
    5582,  5651,  5657,  5663,  5671,  5677,  5683,  5689,  5695,  5701,
    5707,  5713,  5719,  5730,  5731,  5734,  5735,  5736,  5737,  5738,
    5739,  5740,  5741,  5742,  5743,  5744,  5745,  5746,  5747,  5748,
    5749,  5750,  5751,  5752,  5753,  5754,  5755,  5756,  5757,  5758,
    5759,  5762,  5763,  5764,  5765,  5766,  5767,  5771,  5772,  5773,
    5774,  5775,  5776,  5777,  5780,  5796,  5797,  5798,  5799,  5800,
    5801,  5806,  5807,  5808,  5809,  5810,  5815,  5816,  5817,  5818,
    5819,  5825,  5826,  5827,  5828,  5829,  5830,  5831,  5832,  5833,
    5836,  5837,  5838,  5839,  5842,  5843,  5844,  5845,  5848,  5849,
    5850,  5851,  5852,  5853,  5854,  5872,  5872,  5874,  5875,  5876,
    5877,  5878,  5879,  5882,  5883,  5884,  5885,  5886,  5887,  5888,
    5889,  5890,  5891,  5892,  5893,  5894,  5895,  5896,  5897,  5898,
    5899,  5900,  5901,  5902,  5903,  5904,  5905,  5906,  5907,  5908,
    5909,  5910,  5911,  5912,  5913,  5914,  5915,  5916,  5917,  5919,
    5920,  5921,  5922,  5923,  5924,  5925,  5926,  5927,  5928,  5929,
    5930,  5931,  5932,  5933,  5934,  5935,  5936,  5937,  5938,  5939,
    5940,  5941,  5942,  5943,  5944,  5946,  5947,  5948,  5949,  5950,
    5951,  5952,  5953,  5954,  5955,  5956,  5957,  5958,  5959,  5960,
    5961,  5962,  5963,  5964,  5965,  5966,  5967,  5968,  5969,  5971,
    5972,  5974,  5975,  5976,  5977,  5978,  5979,  5980,  5981,  5982,
    5983,  5984,  5985,  5986,  5987,  5988,  5989,  5990,  5991,  5992,
    5993,  5994,  5995,  5996,  5997,  5998,  5999,  6000,  6001,  6002,
    6003,  6004,  6005,  6006,  6007,  6008,  6009,  6010,  6011,  6012,
    6013,  6014,  6015,  6016,  6018,  6019,  6020,  6021,  6022,  6023,
    6024,  6025,  6026,  6027,  6028,  6029,  6030,  6031,  6032,  6033,
    6034,  6035,  6036,  6037,  6038,  6039,  6040,  6041,  6042,  6043,
    6044,  6045,  6046,  6047,  6048,  6049,  6050,  6051,  6052,  6053,
    6054,  6055,  6056,  6057,  6058,  6059,  6061,  6075,  6076,  6080,
    6081,  6082,  6083,  6084,  6085,  6086,  6087,  6088,  6092,  6093,
    6094,  6095,  6096,  6097,  6098,  6099,  6100,  6101,  6102,  6103,
    6104,  6105,  6106,  6107,  6108,  6109,  6110,  6111,  6112,  6126,
    6127,  6128,  6129,  6130,  6131,  6132,  6133,  6134,  6135,  6136,
    6137,  6138,  6139,  6140,  6141,  6142,  6143,  6144,  6145,  6155,
    6156,  6157,  6158,  6159,  6160,  6161,  6162,  6163,  6164,  6165,
    6166,  6167,  6168,  6169,  6170,  6171,  6172,  6173,  6174,  6175,
    6176,  6177,  6178,  6179,  6180,  6181,  6182,  6183,  6184,  6185,
    6186,  6187,  6188,  6189,  6190,  6191,  6192,  6193,  6194,  6195,
    6196,  6197,  6198,  6199,  6200,  6201,  6202,  6203,  6204,  6205,
    6206,  6207,  6208,  6209,  6210,  6211,  6212,  6216,  6217,  6221,
    6222,  6223,  6224,  6225,  6229,  6229,  6232,  6235,  6236,  6239,
    6241,  6246,  6256,  6263,  6264,  6265,  6268,  6297,  6298,  6301,
    6303,  6311,  6312,  6313,  6317,  6318,  6322,  6323,  6326,  6327,
    6330,  6331,  6332,  6333,  6334,  6337,  6338,  6339,  6340,  6341,
    6342,  6343,  6344,  6345,  6346,  6347,  6348,  6349,  6350,  6351,
    6352,  6353,  6354,  6355,  6356,  6357,  6358,  6359,  6360,  6361,
    6362,  6363,  6364,  6365,  6366,  6367,  6368,  6369,  6370,  6371,
    6372,  6373,  6374,  6375,  6376,  6377,  6378,  6379,  6380,  6381,
    6382,  6383,  6384,  6385,  6386,  6387,  6388,  6389,  6390,  6391,
    6392
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "SQL_ALLOCATE", "SQL_AUTOCOMMIT", 
  "SQL_BOOL", "SQL_BREAK", "SQL_CALL", "SQL_CARDINALITY", "SQL_CONNECT", 
  "SQL_CONNECTION", "SQL_CONTINUE", "SQL_COUNT", "SQL_CURRENT", 
  "SQL_DATA", "SQL_DATETIME_INTERVAL_CODE", 
  "SQL_DATETIME_INTERVAL_PRECISION", "SQL_DESCRIBE", "SQL_DESCRIPTOR", 
  "SQL_DISCONNECT", "SQL_ENUM", "SQL_FOUND", "SQL_FREE", "SQL_GO", 
  "SQL_GOTO", "SQL_IDENTIFIED", "SQL_INDICATOR", "SQL_KEY_MEMBER", 
  "SQL_LENGTH", "SQL_LONG", "SQL_NAME", "SQL_NULLABLE", 
  "SQL_OCTET_LENGTH", "SQL_OPEN", "SQL_OUTPUT", "SQL_REFERENCE", 
  "SQL_RETURNED_LENGTH", "SQL_RETURNED_OCTET_LENGTH", "SQL_SCALE", 
  "SQL_SECTION", "SQL_SHORT", "SQL_SIGNED", "SQL_SQL", "SQL_SQLERROR", 
  "SQL_SQLPRINT", "SQL_SQLWARNING", "SQL_START", "SQL_STOP", "SQL_STRUCT", 
  "SQL_UNSIGNED", "SQL_VALUE", "SQL_VAR", "SQL_WHENEVER", "S_ADD", 
  "S_AND", "S_ANYTHING", "S_AUTO", "S_CONST", "S_DEC", "S_DIV", 
  "S_DOTPOINT", "S_EQUAL", "S_EXTERN", "S_INC", "S_LSHIFT", "S_MEMPOINT", 
  "S_MEMBER", "S_MOD", "S_MUL", "S_NEQUAL", "S_OR", "S_REGISTER", 
  "S_RSHIFT", "S_STATIC", "S_SUB", "S_VOLATILE", "S_TYPEDEF", "TYPECAST", 
  "ABORT_P", "ABSOLUTE_P", "ACCESS", "ACTION", "ADD", "AFTER", 
  "AGGREGATE", "ALL", "ALSO", "ALTER", "ANALYSE", "ANALYZE", "AND", "ANY", 
  "ARRAY", "AS", "ASC", "ASSERTION", "ASSIGNMENT", "AT", "AUTHORIZATION", 
  "BACKWARD", "BEFORE", "BEGIN_P", "BETWEEN", "BIGINT", "BINARY", "BIT", 
  "BOOLEAN_P", "BOTH", "BY", "CACHE", "CALLED", "CASCADE", "CASE", "CAST", 
  "CHAIN", "CHAR_P", "CHARACTER", "CHARACTERISTICS", "CHECK", 
  "CHECKPOINT", "CLASS", "CLOSE", "CLUSTER", "COALESCE", "COLLATE", 
  "COLUMN", "COMMENT", "COMMIT", "COMMITTED", "CONSTRAINT", "CONSTRAINTS", 
  "CONVERSION_P", "CONVERT", "COPY", "CREATE", "CREATEDB", "CREATEUSER", 
  "CROSS", "CSV", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", 
  "CURRENT_USER", "CURSOR", "CYCLE", "DATABASE", "DAY_P", "DEALLOCATE", 
  "DEC", "DECIMAL_P", "DECLARE", "DEFAULT", "DEFAULTS", "DEFERRABLE", 
  "DEFERRED", "DEFINER", "DELETE_P", "DELIMITER", "DELIMITERS", "DESC", 
  "DISTINCT", "DO", "DOMAIN_P", "DOUBLE_P", "DROP", "EACH", "ELSE", 
  "ENCODING", "ENCRYPTED", "END_P", "ESCAPE", "EXCEPT", "EXCLUSIVE", 
  "EXCLUDING", "EXECUTE", "EXISTS", "EXPLAIN", "EXTERNAL", "EXTRACT", 
  "FALSE_P", "FETCH", "FIRST_P", "FLOAT_P", "FOR", "FORCE", "FOREIGN", 
  "FORWARD", "FREEZE", "FROM", "FULL", "FUNCTION", "GET", "GLOBAL", 
  "GRANT", "GROUP_P", "HANDLER", "HAVING", "HOLD", "HOUR_P", "ILIKE", 
  "IMMEDIATE", "IMMUTABLE", "IMPLICIT_P", "IN_P", "INCLUDING", 
  "INCREMENT", "INDEX", "INHERITS", "INITIALLY", "INNER_P", "INOUT", 
  "INPUT_P", "INSENSITIVE", "INSERT", "INSTEAD", "INT_P", "INTEGER", 
  "INTERSECT", "INTERVAL", "INTO", "INVOKER", "IS", "ISNULL", "ISOLATION", 
  "JOIN", "KEY", "LANCOMPILER", "LANGUAGE", "LARGE_P", "LAST_P", 
  "LEADING", "LEFT", "LEVEL", "LIKE", "LIMIT", "LISTEN", "LOAD", "LOCAL", 
  "LOCATION", "LOCK_P", "MATCH", "MAXVALUE", "MINUTE_P", "MINVALUE", 
  "MODE", "MONTH_P", "MOVE", "NAMES", "NATIONAL", "NATURAL", "NCHAR", 
  "NEW", "NEXT", "NO", "NOCREATEDB", "NOCREATEUSER", "NONE", "NOT", 
  "NOTHING", "NOTIFY", "NOTNULL", "NOWAIT", "NULL_P", "NULLIF", "NUMERIC", 
  "OBJECT_P", "OF", "OFF", "OFFSET", "OIDS", "OLD", "ON", "ONLY", 
  "OPERATOR", "OPTION", "OR", "ORDER", "OUT_P", "OUTER_P", "OVERLAPS", 
  "OVERLAY", "OWNER", "PARTIAL", "PASSWORD", "PLACING", "POSITION", 
  "PRECISION", "PRESERVE", "PREPARE", "PRIMARY", "PRIOR", "PRIVILEGES", 
  "PROCEDURAL", "PROCEDURE", "QUOTE", "READ", "REAL", "RECHECK", 
  "REFERENCES", "REINDEX", "RELATIVE_P", "RELEASE", "RENAME", 
  "REPEATABLE", "REPLACE", "RESET", "RESTART", "RESTRICT", "RETURNS", 
  "REVOKE", "RIGHT", "ROLLBACK", "ROW", "ROWS", "RULE", "SAVEPOINT", 
  "SCHEMA", "SCROLL", "SECOND_P", "SECURITY", "SELECT", "SEQUENCE", 
  "SERIALIZABLE", "SESSION", "SESSION_USER", "SET", "SETOF", "SHARE", 
  "SHOW", "SIMILAR", "SIMPLE", "SMALLINT", "SOME", "STABLE", "START", 
  "STATEMENT", "STATISTICS", "STDIN", "STDOUT", "STORAGE", "STRICT_P", 
  "SUBSTRING", "SYSID", "TABLE", "TABLESPACE", "TEMP", "TEMPLATE", 
  "TEMPORARY", "THEN", "TIME", "TIMESTAMP", "TO", "TOAST", "TRAILING", 
  "TRANSACTION", "TREAT", "TRIGGER", "TRIM", "TRUE_P", "TRUNCATE", 
  "TRUSTED", "TYPE_P", "UNCOMMITTED", "UNENCRYPTED", "UNION", "UNIQUE", 
  "UNKNOWN", "UNLISTEN", "UNTIL", "UPDATE", "USAGE", "USER", "USING", 
  "VACUUM", "VALID", "VALUES", "VARCHAR", "VARYING", "VERBOSE", "VIEW", 
  "VOLATILE", "WHEN", "WHERE", "WITH", "WITHOUT", "WORK", "WRITE", 
  "YEAR_P", "ZONE", "UNIONJOIN", "IDENT", "SCONST", "Op", "CSTRING", 
  "CVARIABLE", "CPP_LINE", "IP", "BCONST", "XCONST", "ICONST", "PARAM", 
  "FCONST", "'='", "'<'", "'>'", "POSTFIXOP", "'+'", "'-'", "'*'", "'/'", 
  "'%'", "'^'", "UMINUS", "'['", "']'", "'('", "')'", "'.'", "';'", "'{'", 
  "'}'", "','", "\"=\"", "':'", "$accept", "prog", "statements", 
  "statement", "opt_at", "stmt", "CreateUserStmt", "opt_with", 
  "AlterUserStmt", "AlterUserSetStmt", "DropUserStmt", "OptUserList", 
  "OptUserElem", "user_list", "CreateGroupStmt", "OptGroupList", 
  "OptGroupElem", "AlterGroupStmt", "DropGroupStmt", "CreateSchemaStmt", 
  "OptSchemaName", "OptSchemaEltList", "schema_stmt", "VariableSetStmt", 
  "set_rest", "var_name", "var_list_or_default", "var_list", "iso_level", 
  "var_value", "opt_boolean", "zone_value", "opt_encoding", 
  "ColId_or_Sconst", "VariableShowStmt", "VariableResetStmt", 
  "ConstraintsSetStmt", "constraints_set_list", "constraints_set_mode", 
  "CheckPointStmt", "AlterTableStmt", "alter_table_cmds", 
  "alter_table_cmd", "alter_rel_cmds", "alter_rel_cmd", 
  "alter_column_default", "opt_drop_behavior", "alter_using", 
  "ClosePortalStmt", "CopyStmt", "copy_from", "copy_file_name", 
  "copy_opt_list", "copy_opt_item", "opt_binary", "opt_oids", 
  "copy_delimiter", "opt_using", "CreateStmt", "OptTemp", 
  "OptTableElementList", "TableElementList", "TableElement", "columnDef", 
  "ColQualList", "ColConstraint", "ColConstraintElem", "ConstraintAttr", 
  "TableLikeClause", "like_including_defaults", "TableConstraint", 
  "ConstraintElem", "opt_column_list", "columnList", "columnElem", 
  "key_match", "key_actions", "key_delete", "key_update", "key_action", 
  "OptInherit", "OptWithOids", "OnCommitOption", "OptTableSpace", 
  "OptConsTableSpace", "CreateAsStmt", "@1", "WithOidsAs", "OptCreateAs", 
  "CreateAsList", "CreateAsElement", "CreateSeqStmt", "AlterSeqStmt", 
  "OptSeqList", "OptSeqElem", "opt_by", "CreatePLangStmt", "opt_Trusted", 
  "handler_name", "opt_lancompiler", "DropPLangStmt", "opt_procedural", 
  "CreateTableSpaceStmt", "OptTableSpaceOwner", "DropTableSpaceStmt", 
  "CreateTrigStmt", "TriggerActionTime", "TriggerEvents", 
  "TriggerOneEvent", "TriggerForSpec", "TriggerForOpt", "TriggerForType", 
  "TriggerFuncArgs", "TriggerFuncArg", "OptConstrFromTable", 
  "ConstraintAttributeSpec", "ConstraintDeferrabilitySpec", 
  "ConstraintTimeSpec", "DropTrigStmt", "CreateAssertStmt", 
  "DropAssertStmt", "DefineStmt", "rowdefinition", "definition", 
  "def_list", "def_elem", "def_arg", "CreateOpClassStmt", 
  "opclass_item_list", "opclass_item", "opt_default", "opt_recheck", 
  "DropOpClassStmt", "DropStmt", "drop_type", "any_name_list", "any_name", 
  "attrs", "TruncateStmt", "FetchStmt", "fetch_direction", "fetch_count", 
  "from_in", "CommentStmt", "comment_type", "comment_text", "GrantStmt", 
  "RevokeStmt", "privileges", "privilege_list", "privilege", 
  "privilege_target", "grantee_list", "grantee", "opt_grant_grant_option", 
  "opt_revoke_grant_option", "function_with_argtypes_list", 
  "function_with_argtypes", "IndexStmt", "index_opt_unique", 
  "access_method_clause", "index_params", "index_elem", "opt_class", 
  "CreateFunctionStmt", "opt_or_replace", "func_args", "func_args_list", 
  "func_arg", "arg_class", "func_as", "param_name", "func_return", 
  "func_type", "createfunc_opt_list", "createfunc_opt_item", 
  "opt_definition", "RemoveFuncStmt", "RemoveAggrStmt", "aggr_argtype", 
  "RemoveOperStmt", "oper_argtypes", "any_operator", "CreateCastStmt", 
  "cast_context", "DropCastStmt", "ReindexStmt", "reindex_type", 
  "opt_force", "RenameStmt", "opt_column", "AlterOwnerStmt", "RuleStmt", 
  "@2", "RuleActionList", "RuleActionMulti", "RuleActionStmt", 
  "RuleActionStmtOrEmpty", "event", "opt_instead", "DropRuleStmt", 
  "NotifyStmt", "ListenStmt", "UnlistenStmt", "TransactionStmt", 
  "opt_transaction", "transaction_mode_item", "transaction_mode_list", 
  "transaction_mode_list_or_empty", "ViewStmt", "LoadStmt", 
  "CreatedbStmt", "createdb_opt_list", "createdb_opt_item", "opt_equal", 
  "AlterDatabaseSetStmt", "DropdbStmt", "CreateDomainStmt", 
  "AlterDomainStmt", "opt_as", "CreateConversionStmt", "ClusterStmt", 
  "VacuumStmt", "AnalyzeStmt", "analyze_keyword", "opt_verbose", 
  "opt_full", "opt_freeze", "opt_name_list", "ExplainStmt", 
  "ExplainableStmt", "opt_analyze", "InsertStmt", "insert_rest", 
  "insert_column_list", "insert_column_item", "DeleteStmt", "LockStmt", 
  "opt_lock", "lock_type", "opt_nowait", "UpdateStmt", 
  "DeclareCursorStmt", "cursor_options", "opt_hold", "SelectStmt", 
  "select_with_parens", "select_no_parens", "select_clause", 
  "simple_select", "into_clause", "OptTempTableName", "opt_table", 
  "opt_all", "opt_distinct", "opt_sort_clause", "sort_clause", 
  "sortby_list", "sortby", "select_limit", "opt_select_limit", 
  "select_limit_value", "select_offset_value", "group_clause", 
  "having_clause", "for_update_clause", "opt_for_update_clause", 
  "update_list", "from_clause", "from_list", "table_ref", "joined_table", 
  "alias_clause", "join_type", "join_outer", "join_qual", "relation_expr", 
  "func_table", "where_clause", "TableFuncElementList", 
  "TableFuncElement", "Typename", "opt_array_bounds", "Iresult", 
  "SimpleTypename", "ConstTypename", "GenericType", "Numeric", 
  "opt_float", "opt_numeric", "opt_decimal", "Bit", "ConstBit", 
  "BitWithLength", "BitWithoutLength", "Character", "ConstCharacter", 
  "CharacterWithLength", "CharacterWithoutLength", "character", 
  "opt_varying", "opt_charset", "ConstDatetime", "ConstInterval", 
  "opt_timezone", "opt_interval", "a_expr", "b_expr", "c_expr", 
  "func_expr", "row", "sub_type", "all_Op", "MathOp", "qual_Op", 
  "qual_all_Op", "subquery_Op", "expr_list", "extract_list", "type_list", 
  "array_expr_list", "array_expr", "extract_arg", "overlay_list", 
  "overlay_placing", "position_list", "substr_list", "substr_from", 
  "substr_for", "trim_list", "in_expr", "case_expr", "when_clause_list", 
  "when_clause", "case_default", "case_arg", "columnref", 
  "indirection_el", "indirection", "opt_indirection", 
  "opt_empty_parentheses", "target_list", "target_el", 
  "update_target_list", "inf_col_list", "inf_val_list", 
  "update_target_el", "insert_target_list", "insert_target_el", 
  "relation_name", "qualified_name_list", "qualified_name", "name_list", 
  "name", "database_name", "access_method", "attr_name", "index_name", 
  "file_name", "func_name", "AexprConst", "Iconst", "Fconst", "Bconst", 
  "Xconst", "Sconst", "PosIntConst", "IntConst", "IntConstVar", 
  "AllConstVar", "StringConst", "PosIntStringConst", "NumConst", 
  "AllConst", "PosAllConst", "UserId", "SpecialRuleRelation", 
  "ECPGConnect", "connection_target", "db_prefix", "server", "opt_server", 
  "server_name", "opt_port", "opt_connection_name", "opt_user", 
  "ora_user", "user_name", "char_variable", "opt_options", 
  "ECPGCursorStmt", "ECPGDeallocate", "ECPGVarDeclaration", 
  "single_vt_declaration", "single_var_declaration", "@3", "@4", 
  "precision", "opt_scale", "ecpg_interval", "ECPGDeclaration", "@5", 
  "sql_startdeclare", "sql_enddeclare", "var_type_declarations", 
  "vt_declarations", "variable_declarations", "type_declaration", "@6", 
  "var_declaration", "@7", "@8", "storage_declaration", "storage_clause", 
  "storage_modifier", "var_type", "enum_type", "enum_definition", 
  "struct_union_type_with_symbol", "@9", "struct_union_type", "@10", 
  "s_struct_union_symbol", "s_struct_union", "simple_type", 
  "unsigned_type", "signed_type", "opt_signed", "variable_list", 
  "variable", "opt_initializer", "opt_pointer", "ECPGDeclare", 
  "ECPGDisconnect", "dis_name", "connection_object", "ECPGExecute", "@11", 
  "execute_rest", "execstring", "prepared_name", "ECPGFree", "ECPGOpen", 
  "opt_ecpg_using", "ecpg_using", "using_descriptor", "into_descriptor", 
  "opt_sql", "ecpg_into", "using_list", "UsingConst", "ECPGPrepare", 
  "ECPGDescribe", "opt_output", "ECPGAllocateDescr", 
  "ECPGDeallocateDescr", "ECPGGetDescriptorHeader", 
  "ECPGGetDescHeaderItems", "ECPGGetDescHeaderItem", 
  "ECPGSetDescriptorHeader", "ECPGSetDescHeaderItems", 
  "ECPGSetDescHeaderItem", "desc_header_item", "ECPGGetDescriptor", 
  "ECPGGetDescItems", "ECPGGetDescItem", "ECPGSetDescriptor", 
  "ECPGSetDescItems", "ECPGSetDescItem", "descriptor_item", 
  "ECPGSetAutocommit", "on_off", "ECPGSetConnection", "ECPGTypedef", 
  "@12", "opt_reference", "ECPGVar", "@13", "ECPGWhenever", "action", 
  "ECPGKeywords", "ECPGKeywords_vanames", "ECPGKeywords_rest", 
  "ECPGTypeName", "symbol", "ColId", "type_name", "function_name", 
  "ColLabel", "ECPGColLabelCommon", "ECPGColLabel", "ECPGCKeywords", 
  "unreserved_keyword", "ECPGunreserved_interval", "ECPGunreserved", 
  "col_name_keyword", "func_name_keyword", "reserved_keyword", 
  "into_list", "ecpgstart", "c_args", "coutputvariable", "civarind", 
  "civar", "indicator", "cvariable", "ident", "quoted_ident_stringvar", 
  "c_stuff_item", "c_stuff", "c_list", "c_term", "c_thing", "c_anything", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,    61,    60,    62,   657,    43,    45,    42,    47,
      37,    94,   658,    91,    93,    40,    41,    46,    59,   123,
     125,    44,   659,    58
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned short yyr1[] =
{
       0,   424,   425,   426,   426,   427,   427,   427,   427,   427,
     427,   427,   427,   428,   429,   429,   429,   429,   429,   429,
     429,   429,   429,   429,   429,   429,   429,   429,   429,   429,
     429,   429,   429,   429,   429,   429,   429,   429,   429,   429,
     429,   429,   429,   429,   429,   429,   429,   429,   429,   429,
     429,   429,   429,   429,   429,   429,   429,   429,   429,   429,
     429,   429,   429,   429,   429,   429,   429,   429,   429,   429,
     429,   429,   429,   429,   429,   429,   429,   429,   429,   429,
     429,   429,   429,   429,   429,   429,   429,   429,   429,   429,
     429,   429,   429,   429,   429,   429,   429,   429,   429,   429,
     429,   429,   429,   429,   429,   429,   430,   431,   431,   432,
     432,   433,   433,   434,   435,   435,   436,   436,   436,   436,
     436,   436,   436,   436,   437,   437,   438,   438,   439,   439,
     440,   440,   441,   441,   442,   443,   443,   444,   444,   445,
     445,   446,   446,   446,   446,   446,   446,   447,   447,   447,
     448,   448,   448,   448,   448,   448,   448,   448,   449,   449,
     450,   450,   451,   451,   452,   452,   452,   452,   453,   453,
     453,   454,   454,   454,   454,   455,   455,   455,   455,   455,
     455,   456,   456,   456,   457,   457,   458,   458,   458,   458,
     458,   459,   459,   459,   459,   459,   460,   461,   461,   462,
     462,   463,   464,   464,   465,   465,   466,   466,   466,   466,
     466,   466,   466,   466,   466,   466,   466,   466,   466,   466,
     467,   467,   468,   468,   469,   469,   470,   470,   470,   471,
     471,   472,   473,   474,   474,   475,   475,   475,   476,   476,
     477,   477,   477,   477,   477,   477,   477,   477,   477,   478,
     478,   479,   479,   480,   480,   481,   481,   482,   482,   483,
     483,   483,   483,   483,   483,   483,   484,   484,   485,   485,
     486,   486,   486,   487,   488,   488,   489,   489,   489,   490,
     490,   490,   490,   490,   490,   490,   491,   491,   491,   491,
     492,   493,   493,   493,   494,   494,   495,   495,   495,   495,
     496,   496,   497,   497,   498,   499,   499,   499,   500,   500,
     500,   500,   500,   501,   502,   503,   503,   503,   503,   503,
     504,   504,   505,   505,   505,   506,   506,   506,   506,   507,
     507,   508,   508,   510,   509,   511,   511,   511,   512,   512,
     513,   513,   514,   515,   516,   517,   517,   518,   518,   518,
     518,   518,   518,   518,   518,   518,   518,   519,   519,   520,
     521,   521,   522,   522,   523,   523,   524,   525,   525,   526,
     527,   527,   528,   529,   529,   530,   530,   531,   531,   531,
     532,   532,   532,   533,   533,   534,   534,   535,   535,   536,
     536,   536,   537,   537,   538,   538,   539,   539,   539,   539,
     540,   540,   541,   541,   542,   543,   544,   545,   545,   545,
     545,   546,   547,   548,   548,   549,   549,   550,   550,   550,
     551,   552,   552,   553,   553,   553,   553,   554,   554,   555,
     555,   556,   557,   558,   558,   558,   558,   558,   558,   558,
     558,   559,   559,   560,   560,   561,   561,   562,   563,   563,
     563,   563,   563,   563,   563,   563,   563,   563,   564,   564,
     564,   564,   564,   564,   564,   564,   564,   564,   564,   564,
     564,   564,   565,   566,   566,   567,   567,   567,   567,   567,
     567,   567,   567,   567,   567,   567,   568,   568,   568,   568,
     568,   568,   568,   568,   568,   568,   569,   569,   570,   571,
     572,   572,   572,   573,   573,   574,   574,   574,   574,   574,
     574,   574,   574,   574,   574,   574,   574,   575,   575,   575,
     575,   575,   575,   575,   576,   576,   577,   577,   578,   578,
     579,   579,   580,   580,   581,   582,   583,   583,   584,   584,
     585,   585,   586,   586,   586,   587,   587,   587,   588,   589,
     589,   590,   590,   591,   591,   592,   592,   593,   593,   593,
     593,   594,   594,   595,   596,   597,   597,   598,   598,   599,
     599,   599,   599,   599,   599,   599,   599,   599,   599,   599,
     599,   600,   600,   601,   602,   603,   603,   604,   605,   605,
     605,   605,   606,   606,   607,   607,   608,   608,   609,   610,
     610,   611,   611,   612,   612,   613,   613,   613,   613,   613,
     613,   613,   613,   613,   613,   613,   613,   613,   613,   614,
     614,   615,   615,   615,   615,   615,   615,   615,   615,   615,
     615,   617,   616,   618,   618,   618,   619,   619,   620,   620,
     620,   620,   620,   621,   621,   622,   622,   622,   622,   623,
     623,   623,   624,   625,   626,   627,   627,   628,   628,   628,
     628,   628,   628,   628,   628,   628,   628,   628,   629,   629,
     629,   630,   630,   630,   631,   631,   631,   632,   632,   633,
     634,   635,   635,   636,   636,   637,   637,   637,   637,   637,
     637,   637,   637,   637,   637,   638,   638,   639,   639,   640,
     641,   642,   642,   642,   642,   642,   643,   643,   644,   645,
     645,   645,   646,   646,   646,   647,   647,   648,   648,   649,
     649,   650,   650,   651,   651,   652,   652,   653,   654,   654,
     654,   654,   654,   655,   655,   656,   657,   657,   657,   657,
     657,   658,   658,   659,   660,   661,   662,   662,   663,   663,
     663,   663,   663,   663,   663,   663,   664,   664,   665,   666,
     667,   667,   667,   667,   667,   668,   668,   668,   669,   669,
     670,   670,   671,   671,   671,   671,   672,   672,   673,   673,
     673,   673,   674,   674,   674,   675,   675,   675,   675,   675,
     675,   675,   675,   676,   676,   677,   677,   678,   678,   678,
     678,   679,   679,   680,   681,   681,   682,   682,   682,   682,
     683,   683,   683,   683,   683,   684,   684,   685,   685,   686,
     687,   687,   688,   688,   689,   689,   690,   690,   691,   691,
     692,   692,   693,   693,   694,   694,   694,   694,   694,   694,
     694,   694,   694,   694,   694,   695,   695,   695,   695,   695,
     695,   695,   696,   696,   696,   696,   697,   697,   697,   697,
     698,   698,   699,   699,   700,   700,   700,   700,   701,   702,
     702,   703,   703,   704,   705,   705,   705,   705,   706,   706,
     706,   707,   707,   707,   707,   707,   707,   707,   707,   707,
     708,   708,   708,   708,   708,   708,   708,   708,   709,   709,
     709,   709,   709,   710,   711,   711,   711,   711,   711,   711,
     711,   711,   711,   711,   711,   712,   712,   713,   713,   713,
     714,   714,   714,   715,   715,   716,   716,   717,   718,   719,
     719,   720,   720,   721,   722,   723,   723,   723,   723,   723,
     723,   724,   724,   725,   725,   726,   726,   726,   726,   727,
     728,   728,   728,   729,   729,   729,   729,   729,   729,   729,
     729,   729,   729,   729,   729,   729,   729,   730,   730,   730,
     730,   730,   730,   730,   730,   730,   730,   730,   730,   730,
     730,   730,   730,   730,   730,   730,   730,   730,   730,   730,
     730,   730,   730,   730,   730,   730,   730,   730,   730,   730,
     730,   730,   730,   730,   730,   730,   730,   730,   730,   730,
     730,   730,   730,   730,   730,   730,   730,   730,   730,   730,
     730,   730,   730,   731,   731,   731,   731,   731,   731,   731,
     731,   731,   731,   731,   731,   731,   731,   731,   731,   731,
     731,   731,   731,   731,   731,   732,   732,   732,   732,   732,
     732,   732,   732,   732,   732,   732,   733,   733,   733,   733,
     733,   733,   733,   733,   733,   733,   733,   733,   733,   733,
     733,   733,   733,   733,   733,   733,   733,   733,   733,   733,
     733,   733,   733,   734,   734,   734,   735,   735,   735,   736,
     736,   737,   737,   737,   737,   737,   737,   737,   737,   737,
     738,   738,   739,   739,   740,   740,   740,   740,   740,   740,
     741,   741,   742,   742,   743,   743,   744,   744,   745,   745,
     746,   746,   746,   746,   746,   746,   746,   746,   747,   747,
     748,   749,   749,   750,   750,   750,   750,   750,   750,   751,
     752,   753,   753,   753,   754,   754,   755,   756,   756,   757,
     758,   758,   759,   759,   760,   760,   761,   761,   761,   761,
     762,   762,   763,   763,   764,   764,   765,   765,   766,   766,
     766,   767,   767,   767,   768,   768,   769,   769,   770,   770,
     771,   771,   772,   772,   773,   773,   774,   774,   775,   775,
     776,   776,   777,   778,   779,   780,   781,   782,   783,   783,
     784,   784,   784,   784,   784,   784,   784,   784,   785,   786,
     787,   788,   789,   790,   790,   791,   791,   792,   792,   793,
     793,   793,   793,   793,   794,   794,   795,   795,   795,   796,
     796,   796,   796,   796,   797,   797,   798,   798,   798,   798,
     798,   798,   799,   800,   800,   801,   801,   801,   801,   802,
     802,   802,   802,   803,   804,   805,   805,   806,   806,   806,
     807,   807,   808,   808,   809,   809,   810,   810,   810,   810,
     811,   811,   812,   813,   813,   814,   815,   815,   816,   817,
     817,   819,   818,   820,   818,   818,   821,   822,   822,   823,
     823,   823,   823,   823,   825,   824,   826,   827,   828,   828,
     829,   829,   829,   829,   830,   830,   832,   831,   834,   833,
     835,   833,   833,   836,   836,   836,   837,   837,   837,   837,
     838,   838,   839,   839,   839,   839,   839,   839,   840,   840,
     840,   841,   843,   842,   844,   845,   844,   846,   846,   847,
     847,   848,   848,   849,   849,   849,   849,   849,   849,   849,
     849,   849,   850,   850,   850,   850,   850,   850,   850,   850,
     850,   850,   851,   851,   852,   852,   853,   854,   854,   855,
     855,   855,   856,   857,   858,   858,   858,   858,   859,   859,
     860,   861,   860,   862,   862,   862,   862,   862,   863,   863,
     864,   864,   865,   866,   867,   867,   868,   868,   869,   870,
     871,   871,   872,   872,   873,   873,   874,   874,   875,   876,
     876,   876,   877,   877,   878,   879,   880,   881,   881,   882,
     883,   884,   884,   885,   886,   887,   888,   888,   889,   890,
     891,   891,   892,   893,   893,   893,   893,   893,   893,   893,
     893,   893,   893,   893,   893,   893,   893,   893,   894,   894,
     895,   895,   896,   896,   896,   898,   897,   899,   899,   901,
     900,   902,   902,   902,   903,   903,   903,   903,   903,   903,
     903,   903,   903,   904,   904,   905,   905,   905,   905,   905,
     905,   905,   905,   905,   905,   905,   905,   905,   905,   905,
     905,   905,   905,   905,   905,   905,   905,   905,   905,   905,
     905,   906,   906,   906,   906,   906,   906,   907,   907,   907,
     907,   907,   907,   907,   908,   909,   909,   909,   909,   909,
     909,   910,   910,   910,   910,   910,   911,   911,   911,   911,
     911,   912,   912,   912,   912,   912,   912,   912,   912,   912,
     913,   913,   913,   913,   914,   914,   914,   914,   915,   915,
     915,   915,   915,   915,   915,   916,   916,   917,   917,   917,
     917,   917,   917,   918,   918,   918,   918,   918,   918,   918,
     918,   918,   918,   918,   918,   918,   918,   918,   918,   918,
     918,   918,   918,   918,   918,   918,   918,   918,   918,   918,
     918,   918,   918,   918,   918,   918,   918,   918,   918,   918,
     918,   918,   918,   918,   918,   918,   918,   918,   918,   918,
     918,   918,   918,   918,   918,   918,   918,   918,   918,   918,
     918,   918,   918,   918,   918,   918,   918,   918,   918,   918,
     918,   918,   918,   918,   918,   918,   918,   918,   918,   918,
     918,   918,   918,   918,   918,   918,   918,   918,   918,   918,
     918,   918,   918,   918,   918,   918,   918,   918,   918,   918,
     918,   918,   918,   918,   918,   918,   918,   918,   918,   918,
     918,   918,   918,   918,   918,   918,   918,   918,   918,   918,
     918,   918,   918,   918,   918,   918,   918,   918,   918,   918,
     918,   918,   918,   918,   918,   918,   918,   918,   918,   918,
     918,   918,   918,   918,   918,   918,   918,   918,   918,   918,
     918,   918,   918,   918,   918,   918,   918,   918,   918,   918,
     918,   918,   918,   918,   918,   918,   918,   918,   918,   918,
     918,   918,   918,   918,   918,   918,   918,   919,   919,   919,
     919,   919,   919,   919,   919,   919,   919,   919,   919,   919,
     919,   919,   919,   919,   919,   919,   919,   919,   919,   919,
     919,   919,   919,   919,   919,   919,   919,   919,   919,   920,
     920,   920,   920,   920,   920,   920,   920,   920,   920,   920,
     920,   920,   920,   920,   920,   920,   920,   920,   920,   921,
     921,   921,   921,   921,   921,   921,   921,   921,   921,   921,
     921,   921,   921,   921,   921,   921,   921,   921,   921,   921,
     921,   921,   921,   921,   921,   921,   921,   921,   921,   921,
     921,   921,   921,   921,   921,   921,   921,   921,   921,   921,
     921,   921,   921,   921,   921,   921,   921,   921,   921,   921,
     921,   921,   921,   921,   921,   921,   921,   921,   921,   921,
     921,   921,   921,   921,   922,   922,   923,   924,   924,   925,
     925,   926,   927,   928,   928,   928,   929,   930,   930,   931,
     931,   932,   932,   932,   933,   933,   934,   934,   935,   935,
     936,   936,   936,   936,   936,   937,   937,   937,   937,   937,
     937,   937,   937,   937,   937,   937,   937,   937,   937,   937,
     937,   937,   937,   937,   937,   937,   937,   937,   937,   937,
     937,   937,   937,   937,   937,   937,   937,   937,   937,   937,
     937,   937,   937,   937,   937,   937,   937,   937,   937,   937,
     937,   937,   937,   937,   937,   937,   937,   937,   937,   937,
     937
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     1,     0,     2,     4,     3,     2,     1,     1,
       1,     1,     1,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     5,     1,     0,     4,
       5,     5,     4,     3,     2,     0,     2,     2,     1,     1,
       1,     1,     3,     3,     3,     1,     4,     5,     2,     0,
       2,     2,     6,     6,     3,     7,     5,     1,     0,     2,
       0,     1,     1,     1,     1,     1,     1,     2,     3,     3,
       3,     3,     3,     2,     5,     2,     3,     3,     1,     3,
       1,     1,     1,     3,     2,     2,     2,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     3,     6,     1,
       1,     1,     1,     0,     1,     1,     2,     3,     4,     3,
       2,     2,     3,     4,     3,     2,     4,     1,     1,     1,
       1,     1,     4,     4,     1,     3,     3,     4,     6,     6,
       6,     6,     4,     6,     2,     4,     3,     3,     3,     3,
       1,     3,     3,     3,     3,     2,     1,     1,     0,     2,
       0,     2,     9,     1,     1,     1,     1,     1,     2,     0,
       1,     1,     3,     3,     1,     3,     3,     3,     4,     1,
       0,     2,     0,     3,     0,     1,     0,    11,    12,     1,
       1,     2,     2,     2,     2,     0,     1,     0,     1,     3,
       1,     1,     1,     3,     2,     0,     3,     1,     1,     2,
       1,     2,     3,     4,     2,     5,     1,     2,     2,     2,
       3,     2,     2,     0,     3,     1,     4,     5,     6,    11,
       3,     0,     3,     1,     1,     2,     2,     0,     1,     1,
       2,     2,     0,     3,     3,     2,     1,     1,     2,     2,
       4,     0,     2,     2,     0,     3,     4,     4,     0,     2,
       0,     4,     0,     0,     8,     3,     3,     1,     3,     0,
       3,     1,     1,     5,     4,     2,     0,     2,     1,     2,
       3,     2,     2,     2,     2,     3,     3,     1,     0,     8,
       1,     0,     1,     2,     2,     0,     5,     1,     0,     6,
       2,     0,     3,    14,    19,     1,     1,     1,     3,     5,
       1,     1,     1,     3,     0,     1,     0,     1,     1,     1,
       3,     0,     1,     1,     0,     2,     1,     2,     1,     2,
       2,     1,     2,     2,     6,     8,     3,     4,     4,     4,
       5,     3,     3,     1,     3,     3,     1,     1,     1,     1,
      12,     1,     3,     4,     7,     4,     2,     1,     0,     1,
       0,     7,     4,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     3,     1,     2,     2,     3,     3,     5,     4,
       4,     3,     4,     3,     3,     2,     4,     2,     1,     1,
       1,     1,     2,     2,     1,     1,     1,     2,     2,     1,
       2,     2,     1,     1,     1,     6,     9,     7,     9,     8,
       8,     6,     9,     7,    10,     7,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     7,     8,
       2,     1,     1,     1,     3,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     2,     2,
       2,     2,     2,     2,     1,     3,     1,     2,     3,     0,
       3,     0,     1,     3,     2,    12,     1,     0,     2,     0,
       1,     3,     2,     2,     4,     1,     2,     0,     9,     2,
       0,     3,     2,     1,     3,     3,     2,     1,     1,     1,
       0,     1,     3,     1,     1,     1,     4,     1,     2,     2,
       2,     1,     1,     1,     4,     5,     1,     3,     3,     2,
       2,     2,     0,     5,     7,     1,     1,     7,     1,     3,
       3,     3,     1,     3,    11,    10,     2,     0,     8,     4,
       4,     1,     1,     1,     0,     9,     6,     6,     7,     6,
       6,     9,     6,     6,     6,     8,     8,     6,     6,     1,
       0,     9,     6,     6,     6,     7,     9,     9,     6,     6,
       6,     0,    14,     1,     1,     3,     3,     1,     1,     1,
       1,     1,     1,     1,     0,     1,     1,     1,     1,     1,
       1,     0,     6,     2,     2,     2,     2,     2,     3,     3,
       2,     2,     2,     2,     3,     2,     5,     4,     1,     1,
       0,     3,     2,     2,     1,     3,     2,     1,     0,     7,
       2,     5,     3,     1,     2,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     1,     0,     5,     4,     3,
       6,     4,     6,     6,     5,     7,     1,     0,    10,     4,
       2,     1,     4,     5,     5,     2,     4,     1,     1,     1,
       0,     1,     0,     1,     0,     3,     0,     4,     1,     1,
       1,     1,     1,     1,     0,     4,     4,     2,     1,     7,
       4,     3,     1,     2,     4,     5,     3,     0,     2,     2,
       2,     3,     1,     3,     1,     2,     1,     0,     6,     7,
       0,     2,     2,     2,     3,     0,     2,     2,     1,     1,
       3,     3,     1,     2,     4,     4,     1,     1,     8,     4,
       4,     4,     2,     1,     0,     3,     3,     4,     4,     4,
       4,     2,     1,     1,     0,     1,     0,     1,     5,     1,
       0,     1,     0,     3,     1,     3,     3,     2,     2,     1,
       4,     4,     2,     2,     4,     1,     0,     1,     1,     1,
       3,     0,     2,     0,     3,     3,     1,     0,     2,     0,
       2,     0,     3,     1,     1,     2,     1,     2,     5,     6,
       5,     1,     2,     1,     4,     3,     4,     3,     5,     4,
       5,     4,     5,     2,     4,     1,     2,     2,     2,     1,
       1,     0,     4,     2,     1,     2,     2,     4,     1,     2,
       0,     1,     3,     2,     2,     3,     5,     6,     3,     4,
       0,     1,     3,     3,     3,     3,     3,     3,     1,     1,
       1,     1,     1,     1,     1,     2,     5,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     2,
       2,     2,     2,     2,     1,     3,     0,     5,     3,     0,
       5,     3,     0,     1,     1,     1,     1,     5,     2,     1,
       1,     1,     1,     5,     2,     2,     2,     1,     3,     3,
       2,     1,     0,     3,     0,     5,     2,     5,     2,     1,
       3,     3,     0,     1,     1,     1,     1,     1,     1,     3,
       3,     3,     3,     3,     3,     3,     0,     1,     3,     5,
       2,     2,     2,     2,     2,     2,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     2,     2,     3,     3,
       2,     3,     5,     4,     6,     3,     5,     4,     6,     4,
       6,     5,     7,     2,     3,     2,     4,     3,     4,     3,
       4,     3,     4,     5,     6,     7,     5,     6,     3,     4,
       4,     6,     2,     1,     3,     2,     2,     2,     2,     2,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       2,     2,     5,     6,     7,     1,     1,     2,     4,     1,
       1,     1,     2,     2,     2,     1,     3,     4,     5,     5,
       4,     1,     2,     4,     2,     4,     2,     2,     2,     6,
       4,     4,     4,     4,     6,     5,     5,     5,     4,     6,
       4,     6,     4,     4,     3,     5,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     4,     1,     4,     1,     4,     1,     2,     1,     2,
       1,     3,     3,     0,     3,     1,     1,     3,     3,     3,
       1,     1,     1,     1,     1,     1,     1,     1,     4,     3,
       2,     3,     0,     3,     3,     2,     2,     1,     0,     2,
       2,     3,     2,     1,     1,     3,     5,     2,     1,     4,
       2,     0,     1,     0,     1,     2,     2,     2,     3,     5,
       1,     2,     0,     2,     2,     0,     3,     1,     3,     1,
       1,     3,     7,     1,     2,     4,     1,     3,     4,     4,
       3,     1,     1,     1,     1,     1,     1,     3,     1,     2,
       1,     3,     1,     1,     1,     1,     1,     1,     1,     2,
       1,     2,     3,     6,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     2,     1,     1,     1,
       1,     2,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     2,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     5,     3,     2,     2,     3,
       7,     1,     1,     2,     2,     1,     0,     1,     3,     1,
       2,     0,     2,     0,     2,     0,     1,     3,     4,     3,
       1,     1,     1,     2,     0,     7,     3,     2,     1,     1,
       1,     0,     5,     0,     4,     2,     1,     2,     0,     1,
       3,     3,     3,     3,     0,     4,     5,     5,     0,     1,
       1,     1,     2,     2,     1,     2,     0,     7,     0,     5,
       0,     4,     2,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     5,     2,     1,     3,     2,
       2,     3,     0,     5,     1,     0,     5,     2,     2,     1,
       1,     1,     2,     2,     3,     1,     2,     2,     3,     3,
       4,     2,     1,     2,     1,     1,     2,     2,     3,     1,
       1,     1,     1,     0,     1,     3,     4,     0,     2,     0,
       1,     2,     3,     2,     1,     1,     1,     0,     1,     1,
       3,     0,     4,     2,     2,     1,     1,     0,     1,     1,
       1,     1,     2,     3,     0,     1,     2,     1,     4,     4,
       0,     1,     2,     1,     1,     3,     1,     1,     4,     4,
       4,     4,     1,     0,     3,     3,     4,     1,     3,     3,
       4,     1,     3,     3,     1,     6,     1,     3,     3,     6,
       1,     3,     3,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     4,     4,
       1,     1,     4,     4,     3,     0,     7,     1,     0,     0,
       7,     3,     4,     3,     1,     1,     1,     2,     3,     5,
       2,     5,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     3,     1,     0,     1,     2,
       1,     2,     1,     1,     2,     2,     1,     1,     1,     1,
       1,     1,     2,     3,     1,     2,     1,     3,     1,     3,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned short yydefact[] =
{
       3,     0,     2,     1,  1920,  1921,  1924,  1928,  1929,  1856,
    1930,  1931,  1896,  1897,  1898,  1899,  1900,  1901,  1902,  1903,
    1904,  1905,  1906,  1907,  1909,  1908,  1910,  1911,  1912,  1913,
    1914,  1915,  1916,  1917,  1919,  1918,  1933,  1934,  1922,  1923,
    1925,  1926,  1895,  1927,  1935,  1936,  1937,  1932,  1885,  1212,
    1886,    10,  1208,  1209,  1940,  1891,  1892,  1890,  1893,  1894,
    1938,  1939,  1881,  1882,  1884,    11,    12,  1883,     4,  1887,
    1888,  1889,     8,  1294,  1363,     9,  1880,  1363,     0,  1475,
    1476,  1477,     0,  1478,  1479,  1480,  1481,  1482,  1413,  1377,
       0,  1483,     0,  1484,  1485,  1486,  1487,  1488,  1489,  1490,
    1491,  1492,     0,  1493,  1494,  1495,  1496,  1362,  1497,  1498,
    1499,  1500,  1339,  1345,  1459,     0,  1319,  1320,  1316,  1318,
    1317,  1321,  1306,   670,     0,   718,   717,     0,  1769,   670,
    1770,  1737,  1771,  1738,  1739,   201,     0,   711,  1740,     0,
     670,  1741,   250,   550,  1772,     0,     0,  1742,  1743,     0,
       0,   368,   670,     0,  1744,   734,  1745,     0,  1746,  1773,
    1774,     0,     0,  1775,  1776,  1747,     0,  1748,  1749,  1777,
    1778,  1779,  1780,  1781,     0,     0,   794,     0,  1750,  1782,
    1751,  1752,     0,  1783,  1753,  1754,  1755,  1784,  1785,  1756,
    1757,  1758,     0,  1759,     0,     0,     0,   531,  1786,   670,
    1760,     0,   800,     0,  1761,     0,  1787,  1762,     0,  1763,
    1764,  1765,  1766,  1767,   794,  1455,  1340,     0,     0,   722,
    1768,  1788,  1867,  1868,     0,     0,     0,    43,    21,    20,
      57,    35,    16,    50,    38,    81,    82,    83,    27,    23,
      19,    24,    28,    40,    29,    39,    18,    36,    52,    42,
      55,    41,    56,    30,    48,    46,    37,    51,    54,    77,
      60,    26,    61,    73,    62,    34,    71,    69,    70,    31,
      49,    68,    72,    17,    74,    53,    67,    64,    78,    76,
      84,    65,    44,    14,    58,    33,    15,    32,    25,    80,
      22,   720,    59,    63,    47,    66,    79,    45,    75,   777,
     768,   802,   776,    86,    87,    88,     7,  1278,  1280,  1279,
    1363,  1314,  1315,  1283,  1324,  1334,  1323,  1327,  1335,  1322,
    1341,     0,    90,    92,    93,    94,    97,    98,    91,    85,
      89,    96,   102,    95,   101,    99,   100,   103,   104,   105,
    1543,   966,  1541,  1542,  1540,     0,  1363,  1301,  1300,  1363,
    1310,  1334,     0,  1501,  1502,  1503,  1504,  1505,  1506,  1548,
    1549,  1550,  1551,  1552,  1554,  1553,  1563,  1564,  1565,  1566,
    1567,  1568,  1569,  1570,  1571,  1572,  1573,  1574,  1575,  1576,
    1577,  1578,  1579,  1580,  1581,  1520,  1582,  1583,  1584,  1585,
    1586,  1587,  1588,  1589,  1590,  1591,  1592,  1593,  1594,  1595,
    1596,  1597,  1598,  1557,  1599,  1600,  1601,  1602,  1603,  1604,
    1605,  1606,  1607,  1608,  1609,  1610,  1611,  1612,  1614,  1613,
    1615,  1616,  1617,  1618,  1619,  1620,  1621,  1622,  1623,  1624,
    1558,  1625,  1626,  1627,  1628,  1629,  1630,  1631,  1632,  1633,
    1634,  1635,  1636,  1637,  1638,  1639,  1640,  1641,  1642,  1643,
    1644,  1645,  1646,  1647,  1648,  1559,  1649,  1650,  1560,  1651,
    1652,  1653,  1654,  1655,  1656,  1657,  1658,  1659,  1660,  1661,
    1662,  1663,  1664,  1665,  1666,  1667,  1669,  1668,  1670,  1671,
    1672,  1673,  1674,  1675,  1676,  1677,  1678,  1679,  1680,  1681,
    1682,  1683,  1684,  1685,  1686,  1687,  1688,  1689,  1690,  1691,
    1692,  1693,  1561,  1694,  1695,  1696,  1697,  1698,  1699,  1700,
    1701,  1702,  1703,  1704,  1705,  1706,  1707,  1708,  1709,  1710,
    1711,  1712,  1713,     0,  1714,  1715,  1716,  1717,  1718,  1719,
    1720,  1721,  1722,  1723,  1724,  1725,  1726,  1727,  1728,  1729,
    1730,  1731,  1732,  1733,  1734,  1735,  1562,  1736,  1866,  1224,
    1271,  1270,  1247,  1266,  1518,  1473,  1474,  1242,  1519,  1516,
    1555,  1556,  1517,  1225,  1862,  1515,  1412,     0,     0,  1375,
    1376,  1379,  1256,  1251,  1378,     0,  1252,  1373,  1374,  1193,
    1272,  1515,  1507,  1508,  1509,  1510,  1512,  1511,  1513,  1789,
    1790,  1791,  1792,  1793,  1794,  1795,  1796,  1797,  1798,  1799,
    1533,  1800,  1801,  1802,  1803,  1804,  1805,  1806,  1807,  1808,
    1809,  1810,  1811,  1812,  1813,  1814,  1815,  1816,  1817,  1818,
    1819,  1820,  1821,  1822,  1823,  1824,  1825,  1534,  1535,  1826,
    1827,  1828,  1829,  1830,  1831,  1832,  1833,  1834,  1835,  1836,
    1837,  1838,  1839,  1840,  1841,  1842,  1843,  1844,  1845,  1846,
    1537,  1847,  1848,  1536,  1849,  1850,  1851,  1852,  1853,     0,
    1329,  1547,  1532,  1330,  1514,  1544,  1531,  1538,  1539,  1546,
    1545,  1392,  1192,  1394,  1337,  1347,  1343,  1351,  1346,     0,
       0,     0,     0,  1363,   669,   668,   657,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    13,     0,   678,   231,  1244,  1243,  1188,
     710,     0,  1184,  1185,   368,   660,   249,     0,     0,     0,
       0,     0,     0,   427,     0,     0,     0,     0,     0,     0,
     138,     0,   260,   259,     0,   360,     0,   536,     0,     0,
     368,     0,     0,     0,  1248,     0,  1668,  1390,  1391,  1277,
    1703,   760,     0,     0,     0,     0,   439,     0,   438,     0,
       0,   436,     0,   367,     0,   440,   434,   433,     0,     0,
     437,     0,   435,     0,     0,   661,  1625,  1381,   733,   720,
    1564,   465,   469,   460,   466,   474,   473,   461,   458,   459,
    1678,     0,     0,   464,     0,   455,  1213,  1215,   472,  1214,
       0,   501,   514,   508,   512,   506,   510,   509,   505,   516,
     515,   511,   507,   513,     0,   502,   503,     0,   654,  1185,
     680,  1197,   793,     0,     0,   457,   653,     0,     0,   601,
     602,     0,  1691,   665,   195,  1696,  1764,  1715,   191,     0,
       0,   662,   663,   799,   797,     0,     0,     0,     0,  1590,
    1644,  1652,  1696,  1764,  1715,   147,     0,   158,   190,  1696,
    1764,  1715,   186,   678,     0,     0,  1338,   656,   655,     0,
       0,   864,   721,   724,   777,     0,   670,     0,     6,   719,
     715,   796,   796,     0,   796,     0,   773,  1281,  1334,  1313,
    1369,  1285,     0,     0,  1359,  1355,  1352,  1360,  1361,  1354,
    1342,   955,   956,   957,   954,   958,   953,     0,  1289,  1326,
    1295,     0,  1303,  1302,  1308,  1369,  1312,  1869,  1870,  1414,
    1246,  1263,     0,     0,     0,     0,     0,     0,  1255,  1261,
       0,  1253,     0,     0,  1874,  1878,     0,  1876,  1871,  1328,
    1400,  1393,  1395,  1397,  1349,  1348,  1344,     0,     0,  1464,
       0,     0,  1465,  1466,     0,  1461,  1463,     0,  1369,     0,
       0,  1518,  1198,  1519,  1516,  1528,  1515,     0,   443,     0,
       0,     0,   443,     0,     0,     0,     0,  1584,  1089,  1099,
    1097,  1098,  1091,  1092,  1093,  1096,  1094,  1095,     0,   592,
    1090,     0,     0,   346,     0,     0,     0,     0,   115,     0,
       0,     0,   674,   677,   658,     0,  1189,     0,     0,     0,
     486,   495,   487,   492,     0,   489,     0,     0,     0,   488,
     490,   491,     0,   493,   494,     0,     0,   252,     0,     0,
       0,     0,   682,   707,   264,   263,   129,   262,   261,     0,
       0,   549,     0,   330,   371,     0,     0,   108,     0,     0,
       0,     0,     0,     0,     0,     0,  1415,  1276,  1372,     0,
     870,     0,   406,     0,   699,     0,   134,     0,     0,     0,
     372,     0,   113,   125,     0,   228,   441,  1389,  1388,  1380,
    1387,     0,   462,   471,   470,   468,   467,   463,  1216,     0,
     453,   454,  1400,  1403,   451,     0,   500,     0,     0,     0,
     747,  1186,     0,     0,   604,   604,   664,   194,   192,     0,
       0,     0,     0,     0,     0,  1737,  1738,   914,  1153,     0,
    1520,  1739,  1740,  1741,  1061,  1165,  1165,  1165,  1742,  1743,
    1607,  1744,  1745,  1205,  1746,   904,  1748,  1749,  1750,  1751,
       0,  1206,  1753,  1754,  1663,  1756,  1757,  1759,  1760,  1165,
    1762,  1763,  1764,  1765,  1766,  1767,  1204,     0,  1165,  1768,
    1100,  1210,  1211,  1162,     0,     0,  1170,     0,     0,     0,
    1051,     0,   898,   900,   901,   925,   926,   902,   931,   932,
     944,   899,     0,  1169,   967,  1050,  1055,     0,  1049,  1045,
     784,  1167,  1154,     0,  1046,  1238,  1237,  1239,  1240,  1236,
    1200,  1518,  1524,   903,  1519,  1516,  1207,  1241,  1862,  1515,
       0,     0,     0,     0,  1454,     0,   197,     0,   198,  1190,
    1696,   148,   182,   155,   181,     0,  1582,   149,     0,   153,
       0,     0,     0,   189,   187,     0,   659,   447,     0,     0,
     866,     0,   865,   723,   720,   771,   770,     5,   726,   795,
       0,     0,     0,     0,     0,     0,     0,   827,   816,  1369,
    1370,     0,  1364,     0,  1363,  1363,  1357,  1356,  1353,     0,
       0,     0,     0,     0,     0,  1230,  1229,  1286,  1288,  1233,
       0,  1369,     0,     0,  1265,     0,  1269,  1267,  1400,  1409,
    1400,  1410,  1411,  1259,  1254,  1257,     0,  1249,  1261,  1872,
       0,     0,  1875,  1331,     0,  1401,  1234,  1235,  1406,     0,
    1396,  1404,  1407,  1350,  1363,  1472,     0,  1467,  1470,     0,
    1462,     0,     0,     0,  1160,  1199,     0,     0,     0,   444,
       0,     0,     0,   698,     0,     0,     0,   701,     0,   560,
       0,     0,     0,     0,     0,     0,     0,   203,   220,     0,
       0,     0,     0,     0,     0,   344,   620,   620,     0,     0,
     620,   620,     0,   202,   204,     0,     0,     0,     0,     0,
       0,   115,   109,   112,  1296,     0,   672,   673,     0,   676,
     445,  1195,   709,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   407,     0,   907,   942,
     942,   942,   922,   922,   916,   905,   949,     0,   942,   919,
     908,     0,   906,   952,   952,   937,     0,   880,   890,   892,
     893,   923,   924,   894,   929,   930,   891,   966,  1523,   903,
    1525,  1522,  1521,     0,     0,   706,     0,   129,   126,   428,
     408,     0,     0,   140,     0,     0,   376,   375,     0,     0,
     409,   107,   115,   346,   339,     0,     0,     0,  1196,     0,
       0,   301,   761,   765,   762,     0,   763,     0,   744,     0,
       0,   228,     0,     0,     0,     0,     0,   228,   226,   227,
       0,   432,  1382,  1385,  1386,     0,   727,   729,   731,   730,
     732,   728,   452,   449,   450,     0,  1402,  1854,  1860,     0,
    1416,  1417,     0,  1598,  1621,  1638,  1692,     0,  1710,     0,
     517,   504,     0,     0,     0,   735,   738,     0,     0,   757,
     456,  1408,   603,   600,   599,   193,   530,     0,  1691,   667,
       0,     0,  1053,  1054,   941,   928,  1152,     0,     0,   936,
     935,     0,     0,     0,  1062,     0,  1064,     0,  1066,     0,
     912,   911,   910,  1052,  1113,     0,   909,   942,   942,   940,
     990,     0,     0,   913,     0,     0,  1132,     0,  1067,  1138,
       0,     0,     0,   948,     0,   946,     0,     0,  1022,  1068,
    1047,   970,   971,   972,   973,  1051,  1110,     0,  1201,     0,
       0,   934,     0,   966,     0,     0,     0,     0,     0,  1108,
       0,     0,  1003,  1106,     0,  1005,     0,     0,     0,  1100,
    1099,  1097,  1098,  1091,  1092,  1093,  1096,   974,   975,  1104,
     987,     0,   986,  1400,     0,   831,   783,  1155,     0,     0,
    1861,  1863,  1451,  1450,  1449,  1448,  1452,  1453,  1424,     0,
    1420,  1421,     0,   199,   200,   196,     0,     0,   157,   156,
     185,   184,     0,   179,   180,   152,     0,   175,   176,   161,
     172,   174,   173,   171,   150,   160,   162,   168,   169,   170,
     159,   151,   188,  1363,     0,     0,   831,  1173,  1162,   712,
       0,   716,   777,   781,   776,   780,   803,   804,   809,   779,
       0,   829,   818,   812,   817,   813,   819,   826,   775,   815,
     774,     0,  1371,  1284,  1369,   880,  1363,  1304,  1363,  1358,
    1292,   960,   961,   962,   963,   965,   964,  1293,  1290,   959,
    1291,  1232,  1231,     0,     0,     0,     0,  1311,  1262,     0,
    1245,  1268,     0,  1260,     0,  1873,  1879,  1877,     0,     0,
     880,  1857,  1468,  1857,   880,     0,  1157,  1156,  1161,   586,
       0,   585,     0,     0,     0,     0,   697,     0,     0,     0,
       0,     0,   704,   295,     0,   225,     0,     0,     0,     0,
     557,   559,   558,   552,     0,   553,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     588,   593,     0,     0,     0,   348,   358,     0,     0,     0,
     108,   108,   345,   619,   214,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     111,   110,   118,   120,     0,   119,   121,     0,     0,     0,
     114,     0,     0,   167,   671,   675,   446,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   251,   234,
     233,     0,     0,   413,   416,     0,   880,     0,     0,     0,
     874,   955,   954,   953,     0,   895,   897,     0,   696,   696,
     696,   696,   696,   681,   683,   275,   127,     0,     0,   128,
       0,   330,   329,   136,   370,     0,   381,   380,   382,     0,
     377,     0,   410,   106,   343,     0,   267,     0,     0,     0,
       0,     0,   631,     0,     0,     0,     0,     0,   764,   869,
       0,     0,   583,     0,     0,   228,   228,   124,   366,   442,
    1383,  1384,   760,   448,     0,     0,  1859,  1217,     0,  1218,
       0,     0,   520,   519,   532,     0,   521,   522,   518,   523,
       0,   737,     0,     0,   742,  1162,     0,   754,     0,   752,
       0,  1187,   756,   745,     0,   666,  1110,     0,     0,     0,
    1116,     0,     0,  1151,  1148,     0,     0,  1110,     0,  1164,
       0,     0,     0,  1123,  1124,  1125,  1122,  1126,  1121,     0,
       0,  1127,  1120,     0,   939,   938,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1023,     0,     0,  1084,     0,
    1110,  1137,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1110,  1143,     0,  1163,  1162,     0,     0,     0,
       0,  1202,   968,   988,  1168,     0,     0,   995,     0,  1144,
    1018,     0,  1009,     0,  1004,     0,  1007,  1011,   991,     0,
    1109,     0,  1107,     0,     0,   989,     0,   984,   982,   983,
     976,   977,   978,   979,   980,   981,   985,  1088,  1086,  1087,
       0,  1622,  1644,     0,   794,   794,   782,   792,  1166,     0,
     870,     0,     0,     0,  1056,     0,  1865,  1864,     0,     0,
       0,  1191,     0,     0,   966,     0,   880,   867,     0,  1162,
       0,   870,     0,   714,   713,     0,     0,   807,   808,     0,
     825,     0,   824,     0,     0,     0,  1282,  1365,  1367,  1333,
    1305,  1336,  1287,  1325,     0,  1309,  1264,  1258,     0,  1398,
    1405,  1458,     0,  1858,     0,     0,  1158,     0,     0,   622,
     606,   623,   607,     0,     0,     0,     0,     0,   228,   702,
     224,   703,   624,   551,   560,     0,   556,   565,  1529,   903,
     563,  1530,  1527,  1526,     0,     0,   132,   133,   609,   222,
     614,   223,   221,   610,     0,  1194,     0,     0,     0,   628,
     612,   347,   357,     0,   351,   352,   349,   353,   354,     0,
       0,   206,     0,     0,   218,   217,   228,   228,   613,     0,
     219,   216,   205,   630,   618,     0,   629,   617,     0,   116,
     117,     0,   165,   164,   166,     0,     0,     0,     0,     0,
       0,   497,   481,   496,     0,     0,     0,   475,   236,   237,
     254,   235,   412,     0,     0,     0,     0,   875,     0,     0,
     880,     0,     0,   888,   881,   889,     0,     0,     0,     0,
     695,     0,     0,     0,     0,     0,   684,   700,   131,   130,
       0,   140,   265,   139,   141,   143,   144,   145,   142,   146,
     369,     0,     0,     0,   871,     0,     0,     0,     0,   266,
     268,   270,   271,   272,     0,   341,   342,   337,     0,     0,
     333,     0,     0,   539,     0,     0,     0,   303,   304,     0,
     766,   767,     0,   228,     0,   228,   228,   652,   404,     0,
    1399,  1855,  1425,  1426,     0,  1418,  1419,     0,   534,     0,
     529,   524,   526,  1183,  1182,     0,  1181,     0,     0,   743,
     755,   748,   750,   749,     0,     0,   746,     0,   798,     0,
    1118,  1119,     0,     0,     0,     0,  1147,     0,     0,  1082,
       0,  1080,  1063,  1065,   921,     0,  1070,     0,   915,     0,
     918,     0,  1101,     0,     0,  1071,  1025,  1026,  1027,     0,
       0,     0,     0,  1100,     0,     0,     0,     0,     0,     0,
       0,  1028,  1029,  1041,  1040,  1072,  1083,     0,     0,  1135,
    1136,  1073,   950,   951,   952,   952,     0,     0,  1142,     0,
       0,     0,  1078,  1048,  1111,   943,   944,     0,     0,     0,
       0,     0,     0,  1010,  1006,     0,  1008,  1012,     0,     0,
       0,   997,  1019,   993,     0,     0,   999,     0,  1020,   794,
     794,   794,   794,   791,     0,     0,     0,   841,   830,   833,
     843,   834,   836,   868,  1188,   821,     0,     0,  1060,  1057,
    1433,  1434,  1435,  1436,  1437,  1438,  1439,  1440,  1441,  1442,
    1444,  1445,  1446,  1443,  1447,  1429,  1430,     0,  1422,  1423,
     154,     0,   177,   163,  1458,     0,  1174,  1171,   758,     0,
     725,   805,     0,  1102,   806,   828,   810,   814,   811,     0,
    1366,  1297,  1274,  1457,  1460,  1471,  1469,  1307,     0,     0,
       0,     0,   294,     0,     0,     0,   705,   554,   555,   897,
     625,   608,     0,     0,   590,     0,   591,   589,   350,   356,
     355,   275,     0,     0,     0,   207,   215,   212,     0,     0,
     122,   123,     0,     0,   477,   483,     0,     0,     0,     0,
     485,   255,   108,     0,   414,  1663,  1092,   415,   417,   564,
     418,   419,     0,     0,     0,     0,   878,     0,     0,     0,
       0,     0,     0,   880,   966,     0,   692,  1226,  1227,   691,
    1228,   688,   687,   694,   693,   686,   685,   690,   689,     0,
       0,     0,   286,     0,     0,   280,     0,     0,   332,   274,
     277,   278,     0,   135,     0,     0,   384,   378,   411,     0,
     873,   267,   293,   321,     0,   338,     0,     0,     0,     0,
     365,   362,     0,     0,     0,     0,     0,   300,     0,   679,
     759,  1275,   584,   228,   431,   587,   765,     0,     0,   533,
     527,     0,     0,   498,   736,     0,     0,   740,   741,   753,
     751,   228,  1111,  1117,   927,     0,  1150,  1146,     0,     0,
       0,  1112,     0,     0,  1130,  1129,  1024,  1131,     0,     0,
       0,  1039,  1038,  1036,  1037,  1030,  1031,  1032,  1033,  1034,
    1035,  1140,  1139,  1133,  1134,   947,   945,     0,  1075,  1076,
    1077,  1141,  1085,   933,   966,   969,  1016,   996,  1145,  1013,
       0,  1115,     0,   992,     0,     0,     0,  1001,  1101,     0,
       0,     0,     0,     0,     0,   786,   785,   841,     0,   843,
       0,   842,   855,     0,     0,   861,   859,     0,   861,     0,
     861,     0,     0,   835,     0,   837,   855,     0,     0,   823,
    1058,  1059,     0,     0,     0,  1456,     0,     0,  1179,  1178,
       0,  1368,     0,  1250,  1159,     0,     0,   296,     0,     0,
     332,     0,     0,     0,     0,   273,     0,     0,     0,     0,
     230,   615,   616,     0,     0,     0,     0,   480,   479,   239,
       0,   401,     0,     0,   405,   396,   398,     0,     0,     0,
     876,   882,   883,   884,   885,   886,   887,   879,   896,   394,
       0,     0,   284,   288,   289,   287,   279,   332,   301,     0,
     281,     0,     0,   386,     0,     0,   872,     0,     0,     0,
     290,     0,   324,   269,   340,   342,   335,   336,   334,     0,
     359,   363,     0,   538,     0,     0,     0,     0,   571,     0,
       0,     0,   572,   576,   573,   582,   567,   647,   648,   645,
     646,     0,   302,   598,     0,  1427,  1428,     0,   525,  1180,
       0,   499,  1149,  1069,  1079,   920,  1081,   917,  1128,     0,
       0,     0,  1074,  1203,     0,  1014,     0,  1017,   998,   994,
       0,  1000,  1021,   790,   789,   788,   787,   845,   853,     0,
     832,     0,   860,   856,     0,   857,     0,     0,   858,   847,
       0,     0,   853,     0,   445,     0,     0,   778,  1431,     0,
    1219,  1223,  1220,  1432,   966,     0,  1175,     0,  1273,   621,
     605,     0,   332,   297,   566,   627,   611,   626,   208,   209,
     210,   211,     0,   213,   476,     0,   482,   478,   232,   253,
     403,   402,   400,   397,   399,   877,     0,   597,     0,     0,
       0,     0,   276,   282,   307,     0,     0,     0,   385,     0,
       0,   379,   324,   292,   291,     0,     0,     0,   328,   364,
       0,     0,     0,   540,   547,   547,   569,   561,     0,     0,
     570,     0,   579,   580,     0,   568,   548,     0,     0,   528,
       0,  1042,     0,     0,  1015,  1114,  1002,   844,     0,     0,
     846,     0,     0,   849,   851,     0,     0,     0,     0,     0,
    1192,   820,   822,  1222,  1221,   178,  1176,     0,  1103,     0,
     298,   229,   484,   240,   244,   707,   707,     0,   707,   241,
     707,   238,   597,     0,   595,   395,     0,   283,     0,   312,
       0,     0,   267,   387,   388,   383,     0,   328,     0,   322,
     323,     0,   330,   708,     0,   330,     0,     0,   545,   543,
     542,     0,     0,   577,   578,     0,   581,   870,   739,     0,
    1043,     0,   854,   863,     0,   850,   848,   838,     0,   840,
       0,  1172,   301,     0,     0,     0,     0,     0,     0,   594,
     596,     0,   305,   306,     0,   285,   308,   309,   331,     0,
       0,   330,   320,     0,   257,   547,   870,   541,   546,   562,
     574,     0,     0,  1044,   852,     0,   839,  1177,   307,   242,
     246,     0,   247,   243,   245,     0,     0,     0,     0,   310,
       0,   311,     0,     0,     0,   420,   421,   391,   258,     0,
     325,     0,   544,   535,   575,   651,   862,   312,   248,     0,
     317,     0,   316,     0,   313,   314,     0,     0,   426,     0,
       0,   389,   392,   393,   326,   327,   650,   649,     0,     0,
       0,   315,   318,   319,     0,   430,   422,   373,     0,   633,
     644,   632,   634,   642,   639,   641,   640,   638,   299,     0,
     425,   429,     0,   423,   390,     0,   643,   637,   777,   768,
       0,     0,   635,   644,   391,   430,   636,     0,   424,   374
};

/* YYDEFGOTO[NTERM-NUM]. */
static const short yydefgoto[] =
{
      -1,     1,     2,    68,   225,   226,   227,  1452,   228,   229,
     230,  1372,  1830,  1072,   231,  1438,  1879,   232,   233,   234,
    1042,  1883,  2253,   235,   855,   856,  1664,  1665,  1834,  1666,
    1667,  1655,  1223,  1649,   236,   237,   238,  1217,  1645,   239,
     240,  1363,  1364,  1347,  1348,  1337,  1481,  2913,   241,   242,
    1851,  2220,  2918,  3011,   717,  1394,  2532,  2533,   243,   739,
    2268,  2269,  2270,  2271,  2247,  2579,  2580,  2581,  2272,  2800,
    2273,  1763,  1904,  2286,  2287,  3019,  3075,  3076,  3077,  3134,
    2802,  2948,  3032,  1443,  2790,   244,  2599,  2280,  1897,  2274,
    2275,   245,   246,  1355,  1802,  2173,   247,   740,  2600,  2810,
     248,   773,   249,  1445,   250,   251,  1448,  1889,  1890,  2794,
    2939,  3025,  3140,  3141,  2929,  2764,  2765,  2766,   252,   253,
     254,   255,  1892,  1396,  1852,  1853,  2537,   256,  3115,  3116,
     741,  3173,   257,   258,   774,  1075,  3038,  1006,   259,   260,
     792,   793,   794,   261,  1026,  2212,   262,   263,   814,   815,
     816,  1509,  2310,  2311,  2623,   840,  1933,  1934,   264,   742,
    2604,  2952,  2953,  3039,   265,   743,  1340,  1774,  1775,  1776,
    2956,  2145,  2538,  2539,  2825,  2826,  2966,   266,   267,  1750,
     268,  1789,   988,   269,  3014,   270,   271,   831,  1523,   272,
    1805,   273,   274,  2285,  3161,  3175,  3176,  3177,  2831,  3148,
     275,  3163,   277,   278,   279,   705,  1002,  1003,  1004,   280,
     281,   282,  1873,  1874,  2241,   283,   284,   285,   286,  1436,
     287,   288,   289,   290,   291,   880,   873,  1244,  1681,   292,
    1486,   779,  3164,  1515,  1943,  1944,  3165,   295,  1519,  1950,
    1953,  3166,   297,  1059,  1907,  3167,  1170,   300,   301,   302,
    1625,  2066,   823,  1250,   845,   885,   886,  1686,  1687,  1257,
    1700,  1693,  1695,  2719,  2887,  1258,  1698,  2102,  2070,  2428,
    2429,  2430,  2701,  2712,  2873,  2983,  2431,  2432,  1468,  2263,
    2264,  1790,  1860,  2232,  1417,  1171,  1172,  1173,  1556,  1563,
    1550,  1420,  1174,  1175,  1176,  1423,  1177,  1178,  1179,  1180,
    1535,  1591,  1181,  1182,  1573,   908,  1956,  1994,  1184,  1185,
    1186,  2060,  1619,   990,  1187,  2474,  1621,  2013,  1979,  2682,
    1959,  1533,  1980,  1990,  2354,  1997,  2002,  2379,  2380,  2014,
    2030,  1188,  1963,  1964,  2337,  1537,  1189,  2015,  1325,  1580,
    1544,  1190,  1191,  1676,  2088,  2997,  1677,  2315,  2316,  1192,
    1510,   871,  2979,  1219,   572,  2164,  1380,   711,   820,  1193,
    1194,  1195,  1196,  1197,  1198,  1199,  2234,   798,  1928,  2893,
    2213,  2559,  1307,  1668,  1200,   551,   712,   303,   574,   575,
     928,   929,  1294,  1297,  1284,  1730,   552,   553,   576,  2733,
     304,   305,   306,   307,   308,  1259,   890,  1278,  1724,   909,
      72,    77,    73,   910,   345,   346,  1706,   309,   683,  1707,
    1281,   915,   349,   311,   312,   350,   314,   660,   351,   892,
     316,   893,   317,   318,   319,   320,   900,   321,  1261,  1262,
    2480,  1263,   322,   323,   577,   578,   324,  1080,  1482,  1079,
     749,   325,   326,   941,   942,   943,  1093,  1495,  1094,  1310,
    1311,   327,   328,   568,   329,   330,   331,  1500,  1501,   332,
    1640,  1641,  1642,   333,  2302,  2303,   334,  2455,  2456,  2457,
     335,  1634,   336,   337,   865,  2484,   338,   679,   339,   955,
     554,   555,   556,  1202,   663,   819,  1203,   962,   664,   341,
     666,   558,   559,   560,   561,   562,   965,   670,  1496,    74,
    2122,  1497,  1206,  1207,  1630,  1208,   565,   919,   934,   935,
    2123,   937,    75,   938
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -2737
static const int yypact[] =
{
   -2737,   311,  8642, -2737, -2737, -2737, -2737, -2737, -2737, -2737,
   -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737,
   -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737,
   -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737,
   -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737,
   -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737,
   -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737,
   -2737, -2737, -2737, -2737, 13666, -2737, -2737, 48782,   659, -2737,
   -2737, -2737, 34414, -2737, -2737, -2737, -2737, -2737,   594, 33636,
   12516, -2737, 46454, -2737, -2737, -2737, -2737, -2737, -2737, -2737,
   -2737, -2737, 46454, -2737, -2737, -2737, -2737, -2737, -2737, -2737,
   -2737, -2737, 32859,   602, -2737,   212, -2737, -2737, -2737, -2737,
   -2737, -2737, -2737,   554,  2817, -2737, -2737, 35970, -2737,    37,
   -2737, -2737, -2737, -2737, -2737, -2737, 46454, 41410, -2737,   433,
     554, -2737,   703,  6779, -2737, 35970, 36359, -2737, -2737, 46842,
     672,  4652,   554, 36748, -2737,  1212, -2737, 30516, -2737, -2737,
   -2737,   826,  1572, -2737, -2737, -2737,   673, -2737, -2737, -2737,
   -2737, -2737, -2737, -2737, 41410,   838,   577, 30905, -2737, -2737,
   -2737, -2737, 41410, -2737, -2737, -2737, -2737, -2737, -2737, -2737,
   -2737, -2737, 37137, -2737,    82, 47230, 42186,   733, -2737,   554,
   -2737, 46454,   754, 32470, -2737, 42574, -2737, -2737,   723, -2737,
   -2737, -2737, -2737, -2737,   577, -2737, 32859, 29334, 40634,   855,
   -2737, -2737, -2737, -2737,   -38,  9111,   719, -2737, -2737, -2737,
   -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737,
   -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737,
   -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737,
   -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737,
   -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737,
   -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737,
   -2737,   805, -2737, -2737, -2737, -2737, -2737, -2737, -2737,    40,
   -2737,    39,    69, -2737, -2737, -2737, -2737, -2737, -2737, -2737,
   49922,  1036, -2737, -2737, -2737,   795, -2737,   730, -2737, -2737,
   -2737,  1172, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737,
   -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737,
   -2737,    36, -2737, -2737, -2737,  1157, 49162, -2737, -2737, 49922,
   -2737,   830, 37137, -2737, -2737, -2737, -2737, -2737, -2737, -2737,
   -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737,
   -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737,
   -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737,
   -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737,
   -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737,
   -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737,
   -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737,
   -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737,
   -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737,
   -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737,
   -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737,
   -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737,
   -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737,
   -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737,
   -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737,
   -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737,
   -2737, -2737, -2737, 34803, -2737, -2737, -2737, -2737, -2737, -2737,
   -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737,
   -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737,
   -2737, -2737, -2737,    64, -2737, -2737, -2737, -2737, -2737, -2737,
   -2737, -2737, -2737, -2737, -2737, -2737, -2737, 46454, 46454, -2737,
   -2737, -2737,   886, -2737, -2737,   895, -2737, -2737, -2737, -2737,
   -2737,   942, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737,
   -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737,
   -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737,
   -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737,
   -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737,
   -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737,
   -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737,
   -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, 11212,
   -2737, -2737, -2737,   947, -2737, -2737, -2737, -2737, -2737, -2737,
   -2737, -2737, -2737,  1002, -2737,   289,  1182, -2737, -2737, 32859,
    1657,  1657,  1390, 49922, -2737, -2737, -2737, 39470, 46454, 46454,
   46454, 39470, 46454, 40634, 46454, 27743, 46454, 41410, 40634, 46454,
   46454, 46454, 46454, -2737,  1350,    57, -2737, -2737, -2737,  1001,
   -2737,  1191, -2737,  1200,  2714, -2737, -2737, 41410, 39470, 46454,
    1018,  1095, 46454, -2737, 46454,   941, 46454,  1043,   762,  1178,
   46454, 46454, -2737, -2737, 46454, -2737, 46454, -2737, 46454,   629,
    1224,  1399,  1344,   346, -2737, 37137, 37137, -2737, -2737, -2737,
     970, -2737, 40634, 39470, 46454,  1149, -2737, 46454, -2737, 39470,
   46454, -2737,   814, -2737, 46454, -2737, -2737, -2737, 46454, 46454,
   -2737, 46454, -2737,  1358, 46454, -2737,   960, -2737, -2737,   805,
     863, -2737,   166,    -1,   240, -2737, -2737,   131,   145,   150,
     863,   -77, 41798, -2737, 46454,  1374, -2737, -2737, -2737, -2737,
   37137,  1343, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737,
   -2737, -2737, -2737, -2737,  1382,  1245, -2737, 41410, -2737, -2737,
   -2737, -2737, -2737, 41410,   834, -2737, -2737,  1524, 46454, -2737,
   -2737, 41410, 46454, -2737, -2737,  1626,  1346,  1513, -2737,  1468,
    1572,  1409, -2737, -2737,  1495, 16067,   -58, 31294, 37137, 42962,
   47618,   220, 43350,  1388,    57, -2737,   485, -2737, -2737,  1682,
    1398,  1565, -2737,    57, 41410, 50295, -2737, -2737, -2737, 25372,
    1469,  1391, -2737,  1617,  1394,  1400,   554,  1403, -2737, -2737,
   41410,  1742,  1742,  1721,  1742,    80,    87, -2737, -2737, -2737,
    1427, -2737,  1428,  1431, -2737,   569,  1631, -2737, -2737, -2737,
   -2737,  1500,  1502,  1505,  1508, -2737,  1509,  1155, -2737, -2737,
   -2737,  1692, -2737, -2737, -2737,  1427, -2737, -2737, -2737, -2737,
   -2737,  1770,  1756, 35970, 35970,  1494,   403, 32079, -2737,  1444,
     886, -2737, 11903, 11212, -2737, 22978,  1103, -2737, -2737, -2737,
     123, -2737, -2737, -2737,  1653, -2737, -2737,  1648, 46454, -2737,
    1523, 46454, -2737, -2737, 48006, -2737, -2737,  1657,  1427,   567,
    1462,  1463, -2737,  1466,  1467, -2737,  1475,    32,  1001,   811,
     139,  1602,   318,  1476,   108,   785,  1582, 46454, -2737, -2737,
   -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737,  1478, -2737,
   -2737,  1481,   798, -2737,   208,   827,  1628,  1620,   779,  1496,
    1681,   -28, -2737,   526, -2737, 32859, -2737, 41410, 39470,  1501,
   -2737, -2737, -2737, -2737, 39470, -2737,  1655,  1077, 46454, -2737,
   -2737, -2737, 46454, -2737, -2737,  1691, 46454,  1539,  1511,  1805,
   38305, 46454,  1541,  1837, -2737, -2737,  1548, -2737, -2737, 46454,
    1511, -2737,  1834,    63,  1652,  1041,    84,  1552, 41410, 41410,
    1709, 46454, 46454, 39470, 46454, 41410, -2737, -2737, -2737,   454,
    1556,  1525, -2737, 38305, -2737,  1476, -2737, 46454,  1529,  1675,
   -2737,  1677,  1531, -2737,   838,    46, -2737, -2737, -2737, -2737,
     414,   635, -2737, -2737, -2737, -2737, -2737, -2737, -2737, 46454,
    1374,  1374,    83, -2737, -2737,   102, -2737, 41022,  2974,    56,
     -15, -2737, 46454,   960,  1766,  1766, -2737, -2737, -2737,  1723,
    1775,  1689, 48394,  1538,   761,  1007,   728, -2737, 18944,  1546,
     284,   284,  1550,  1553, -2737,  1554,  1557,  1558,   877,   877,
    1695,  1559,  1560, -2737,   902, -2737,  1066,   952,  1265,   284,
   18944, -2737,  1563,   985,  1567,  1568,  1569,  1180,  1570,  1558,
    1349,  1571,   870,   978,  1573,  1578, -2737,  1559,  1558,   178,
   -2737, -2737, -2737, -2737, 18944, 18944, -2737, 18944, 18944, 16478,
   -2737,   838, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737,
      60, -2737,   991,  9186, -2737, -2737, -2737, 18944, -2737, -2737,
      -7, -2737,   567,  1579, -2737, -2737, -2737, -2737, -2737, -2737,
   -2737,   992, -2737, -2737,  1005,  1035, -2737, -2737,    97,  1076,
     890,   890, 35192, 35192, -2737,   296, -2737,   143,  1574, -2737,
     519, -2737, -2737, -2737, -2737, 35581,  1887, -2737,  1108,   526,
   29722, 46454, 29722, -2737, -2737,  1767, -2737, -2737,  1789, 41410,
   -2737, 26551, -2737, -2737,   805, -2737, -2737, -2737,  1596, -2737,
     -38,   -38, 18944,   -38,   -20, 16889, 18944,  1829,   534,  1427,
    1605,  1013, -2737, 39082, 49542, 49542,  1801, -2737, -2737,   502,
     568,  1699,  1773,   656,   186, -2737, -2737, -2737,  1599, -2737,
    1869,  1427,  1372, 35970,  1650, 35970, -2737, -2737,  1981, -2737,
    1981, -2737, -2737, -2737, -2737,  1607,   -77, -2737,  1444, -2737,
   15244,  1117, -2737, -2737, 11212, -2737, -2737, -2737, -2737,  2007,
   -2737,  1609, -2737, -2737, 49922,  1611, 46454, -2737,  1616,  1619,
   -2737, 50295, 18944, 28556, -2737,   567, 28946,  1687,  1690, -2737,
    1696,  1697, 47618, -2737,    76,   501,   116, -2737,  1705,   446,
     831,  1661,  1668,  1706,  1707,  1710,  1701,  1622, -2737,  1714,
    1674, 37527, 28149,  1715,  1717,  1211,   724,  1925,  1788,  1718,
    1131,    95,  1676,  1651, -2737,  1720,  1724, 40634,  1725,  1728,
   47618, -2737,   955, -2737, -2737,   772, -2737, -2737,    57, -2737,
    1001, -2737, -2737,  1654, 38305,  1476,  1155, 46454,  1665,   697,
    1811, 46454,  1867,  1820,    16, 32859, -2737,  1680, -2737,  1713,
    1713,  1713,  1684,  1684,  1693, -2737, -2737,  1265,  1713,  1702,
   -2737, 38694, -2737,   812,   821, -2737,  1998,    59, -2737, -2737,
   -2737, -2737, -2737, -2737, -2737, -2737, -2737,   601, -2737,  1001,
   -2737, -2737, -2737,  2009,   802, -2737, 38305, -2737,   -35,  1956,
   -2737, 46454, 46454, -2737, 46454,  1871, -2737, -2737,    92,  1703,
   -2737, -2737, -2737, -2737,   -13, 35970,  1927,  1843, -2737,  1476,
    2023,  1711, -2737,  1193, -2737,  1804, -2737, 18944, -2737, 28946,
    2029,   111,  1751, 37527, 41410, 41410, 46454,   111, -2737, -2737,
   46454, -2737, -2737,  1374,  1002, 46454, -2737, -2737, -2737, -2737,
   -2737, -2737,  1374, -2737, -2737,  2110,  1726, -2737,    97,   -77,
    1730, -2737,  1727, 46454, 39470, 46454, 46454, 41410, 46454,  1779,
    1733, -2737,  1757,  1716, 26158, -2737, -2737,   112, 41410,  1873,
   -2737, -2737, -2737, -2737, -2737, -2737, -2737, 41022, 46454, -2737,
   18944, 17300, -2737, -2737, -2737,  1734, 10107,  1755, 18944, -2737,
   -2737, 18944, 18944,   933, -2737,   933, -2737,  1729, -2737,   -77,
   -2737, -2737, -2737, -2737,  1948,   -77, -2737,  1713,  1713, -2737,
    3963, 18944,   -77, -2737, 28149, 18944, 19355, 14458, -2737, 18944,
    1792,  1793,   -77, -2737,   -77, -2737, 18944, 15656, -2737, -2737,
     567,  2081,  2081,   104,  1037,  1363,  4016,  1739, -2737,  1836,
     -77, -2737,   -77,   797, 38305, 18944, 32859,  1813, 19355, 18944,
    1748,   627, -2737, 18944,   561, -2737,  1750, 18944,  1818,    98,
   18944, 18944, 18944, 18944, 18944, 18944, 18944, 20985, 21396, -2737,
   19766,   100,   470, 34025, 16067,  1984, -2737,   927, 14046, 37137,
   -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737,   -77,
    1753, -2737,  1778, -2737, -2737, -2737, 46454,  1887, -2737, -2737,
   -2737, -2737,  1821, -2737, -2737, -2737,  1120, -2737, -2737, -2737,
   -2737, -2737, -2737, -2737, -2737,  1761, -2737, -2737, -2737, -2737,
   -2737, -2737, -2737, 49922,  1768, 46454,    21, -2737, -2737, 40246,
   46454, -2737, -2737,  1966, -2737, -2737,  1764, -2737,  7410,  1966,
    1914,  1921, -2737,   369, 10107,  1954, 10107, -2737, -2737, -2737,
   -2737,  1404, -2737, -2737,  1427,  1783, 12906, -2737, 13286, -2737,
   -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737,
   -2737, -2737, -2737,  1155,  1781,  2152,  1415, -2737, -2737, 35970,
   -2737, -2737, 32079, -2737,  1790, -2737, -2737, -2737, 37137,  1174,
    1783, 11212, -2737, 11212,  1783,  2115, -2737, -2737, -2737, -2737,
    1782, -2737, 46454, 46454, 46454, 46454, -2737,  1786, 46454,  1977,
    1979,  1791, -2737, -2737, 46454, -2737,  1945, 18944,  1949, 46454,
   -2737, -2737, -2737, -2737,   395, -2737, 33248,  1863,  1865, 46454,
   46454, 46454, 46454, 46454, 46454,   391, 46454, 46454,  1807,  1809,
    1815, -2737, 46454, 46454,  1155, -2737,  2118,  1155,  1155,   127,
    1552,  1552, -2737, -2737, -2737, 46454, 46454, 46454,  1889, 46454,
   46454, 46454, 46454,   120,   217, 46454, 46454,  1932, 46454, 46454,
   -2737,   955, -2737, -2737,  2043, -2737, -2737,  1847,   -77,  1872,
   -2737,    88,  1947, -2737, -2737, -2737, -2737, 28946,  2163,  2024,
    2047,  1897, 37527,   512, 46454, 46454,  2051,   512, -2737, -2737,
   -2737,   856,   647, -2737,  1876, 18944,    71, 38305,  1861, 24567,
   -2737,  1924, -2737,  1928,   -77, -2737, -2737,    92,  1878,  1878,
    1878,  1878,  1878,   802, -2737, -2737,   -35,   -77, 46454, -2737,
    2098,  1938, -2737,   152, -2737,  1847, -2737, -2737, -2737,  2013,
    2011, 46454, -2737,   955,  1211, 41410, 39858,   135,  2092,   838,
   41410,  1980, -2737, 46454,  2196,  2093,  2094,  2109, -2737, 10107,
    1877, 38305, -2737, 46454,  1880,   111,   111, -2737, -2737, -2737,
   -2737, -2737, -2737, -2737, 37137,   942, -2737, -2737,   942, -2737,
     942,  2282,  1574,  1881, -2737,  1476,  1574,  1574,  1733,  1574,
   43738, -2737, 17711,   685, -2737, -2737,    78, -2737,   452,   -29,
    2053, -2737, -2737, -2737,  2113, -2737, 10107,   883,   557,   778,
   -2737,   -77, 18944,    31, -2737,  9252,   954,  9475,   993, -2737,
    1882,  1888,  1003, -2737, -2737, -2737, -2737, -2737, -2737,  1890,
    2117, -2737, -2737,  1892, -2737, -2737,  3004,  1040,  1893,  9845,
    1894, 19355, 19355, 19355,  1694, -2737, 19355,  1895, -2737,  1047,
    8228,  1898,  1905,  1915,  1934,  1907,  1908,  9521, 18122, 18944,
   18122, 18122,  9945,  1898,  1910, -2737, -2737, 18944, 46454,  1913,
    1916, -2737, -2737,  3963, -2737,  1942,  2153,  1852, 16478, -2737,
   -2737,  2125, -2737,   737, -2737,  1918, -2737, -2737,  2899, 19355,
   18944,  1748, 18944,  1983, 28149,  1598, 18944,  6274,  6305,  6305,
     118,   118,   104,   104,   104,  1037,   470, -2737, -2737, -2737,
    1929,  1080,  1097, 41410,  2568,  3052, -2737, -2737, -2737, 23781,
    1556, 18944, 18944,  1935, -2737,  1074, -2737, -2737,   209,  2282,
     -77, -2737,    57,   -77,   797, 30119,  1783, -2737,  1940, -2737,
   46454,  1556,   829, -2737, -2737,  1123, 18944, -2737, -2737,  2089,
   -2737, 46454, -2737, 18944, 18944, 16889, -2737, -2737,  1943, -2737,
   -2737, -2737, -2737, -2737,  1922, -2737, -2737, -2737, 46454, -2737,
   -2737,  2296,  1944,  1937,  1952,  1941, -2737, 18944,   837, -2737,
   -2737, -2737, -2737, 18944,   416,  1946,  1950, 46454,   111, -2737,
   10107, -2737, -2737, -2737,   776, 38305, -2737, -2737,    49,  1001,
   -2737,   122,   140,   173, 46454, 46454,  1531,  1531, -2737, -2737,
   -2737, -2737, -2737, -2737,   906, -2737, 38305,  2069, 37916, -2737,
   -2737, -2737, -2737,  1155, -2737, -2737, -2737, -2737, -2737,  1155,
    1155, -2737, 38305,   599, -2737, -2737,   111,   111, -2737,  2012,
   -2737, -2737, -2737, -2737, -2737,  2022, -2737, -2737, 46454, -2737,
   -2737,  1847, -2737, -2737, -2737,  1955, 38305,   512,   512, 46454,
    1960, -2737, -2737, -2737,  2143,  2156,   512, -2737, -2737, -2737,
     144, -2737, -2737, 32859, 27337,  4081,  1965, -2737,  1963,   -77,
    1783, 24977,  1355, -2737, -2737, -2737,   731,  2136,  1967,  2111,
   -2737,   107,   268, 44126, 44514, 44902, -2737,  1911, -2737,  1531,
    2026, -2737,  1688, -2737, -2737, -2737, -2737, -2737, -2737, -2737,
   -2737, 41410,    92,  1142, -2737, 38305,  1969, 41410,  1976,  1964,
   -2737, -2737, -2737, -2737,  1162, -2737, 38305, -2737,  2124,  2126,
   -2737, 46454,  2045,  2025, 38305,  2123,  1188, -2737, -2737,   -38,
   -2737, -2737, 25765,   111,  1987,   111,   111, -2737, -2737,   692,
   -2737, -2737,  1978, -2737,  2002, -2737, -2737, 39470, -2737, 46454,
     584, -2737, -2737, -2737, 10107,  1195, -2737,   633, 46454,   567,
   -2737, -2737, -2737, -2737,  2228,  2234, -2737, 43738, -2737, 18944,
   -2737, -2737,  1995,  1999, 10066, 18944, -2737,  2242, 38305, -2737,
   46454, -2737, -2737, -2737, -2737,   -77, -2737, 18944, -2737, 18944,
   -2737,   -77, -2737, 18944,  2235, -2737,  2345,    52,  2345, 38305,
   19355,   788,  1567, 20574, 19355, 19355, 19355, 19355, 19355, 19355,
   19355, 21793, 22204, -2737,   302, -2737, -2737, 18944, 18944,  2241,
    2235, -2737, -2737, -2737,  1455,  1455, 38305,  2016,  1898,  2018,
    2019, 18944, -2737,   567,  4300, -2737,  2309,   838, 20177, 19355,
   18944,  1202, 18944, -2737, -2737,  2014, -2737, -2737, 38305, 18944,
    2177,  3459, -2737,  3509, 18944,  2021,  5672, 16478, -2737,   577,
     577,   577,   577, -2737, 41410, 41410, 23388, 45290,  2006,  1498,
   -2737, 45290, 45678, -2737,   917,  2244,  1217,  1220, -2737, -2737,
   -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737,
   -2737, -2737, -2737, -2737, -2737,  2015, -2737,  2038, -2737, -2737,
     526,  2027, -2737, -2737,  2296,  2039,   -94, -2737, -2737, 18533,
   -2737, -2737,  2030, -2737, -2737,  1574, -2737, -2737, -2737, 11212,
   -2737, -2737,  2054, -2737, -2737, -2737, -2737, -2737,  4865,  2100,
    2101,  4699, -2737, 46454, 46454,  1227, -2737, -2737, -2737,  2044,
   -2737, -2737,  2104,  2105, -2737,  2108, -2737, -2737, -2737, -2737,
   -2737, -2737,   467,   426, 38305, -2737, -2737, -2737, 46454, 46454,
    1531, -2737,  2239,  2033, -2737, -2737,  2243,  2245,   512,   512,
   -2737, -2737,  1552,  2304, -2737,  2030,   186, -2737, -2737, -2737,
   -2737, -2737,   784,   -77,  1457,  2049, -2737,  1112, 24977, 24977,
   24977, 24977, 24977,  1783,   797, 41410, -2737, -2737, -2737, -2737,
   -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737,  2052,
   46454, 19355, -2737,   543,   101, -2737,  2246, 41410,  2096, -2737,
   -2737, -2737, 38305,   152,   690,  2091,  2289,  2198, -2737, 46454,
   -2737, 39858,   771,  2267, 39858, -2737, 46454,  2382,  2383,   -38,
    2252,  1001,   838, 46454,  2064,  1744,   563, -2737, 46454, -2737,
   -2737, -2737, -2737,   111, -2737, -2737,  1193,   942,   209, -2737,
   -2737,  2291, 43738, -2737, -2737, 17711,  2067, -2737, -2737, -2737,
   -2737,    55, 10107, -2737, -2737, 18944, 10107, -2737,  2070,  2071,
    2072, 10107,  5219,  2078, 10107,  2241, -2737,  2010,  2297,  2237,
    2086,   302,  2010,   423,   423,    70,    70,    52,    52,    52,
    2345, 10107, 10107, -2737, -2737, -2737, -2737,  2088, -2737, -2737,
   -2737,  1898, -2737, -2737,   797, -2737,   448,  1030, -2737,   199,
   38305, -2737,  1253,  1030, 19355, 18944, 18944,  6948,   188, 18944,
    5330, 41410, 41410, 41410, 41410, -2737, -2737, 22601,  1498,  2090,
   46454, -2737,  2095, 23781,  2284,  2231, -2737, 23781,  2231,   849,
    2231, 23781,  2287, -2737, 26944, -2737,  2099, 28556,  2405,  2319,
   -2737, -2737,   209,  1251,   838, -2737,  2112, 46454, -2737, 10107,
   28149, -2737, 46454, -2737, -2737, 46454, 46454, -2737,  1256,  1270,
    2096,  2155, 46454, 46454, 46454,  1911,  2258,  2269,   -77, 46454,
    2160, -2737, -2737,   512,  2312,   512,   512, -2737, -2737, -2737,
     838, -2737,   687,  2384, -2737,  2327,   121,  2122,  2349,  2350,
   -2737, -2737,   900,   900, -2737, -2737, -2737, -2737, -2737,  2354,
   18944,  1027,  2010, -2737, -2737, -2737, -2737,  2096,  1711,  2337,
   -2737,  2172, 41410,  2386,  2378,    92, -2737,  2137,  2406,  2413,
   -2737,  2151,  1459, -2737, -2737, -2737, -2737, -2737, -2737,   838,
   -2737, -2737,  2380, -2737, 24174,   838,  2301,  2254, -2737, 35970,
    2314,   137, -2737, -2737, -2737,  1365, -2737, -2737, -2737, -2737,
   -2737,  2223, -2737, -2737,  2394, -2737, -2737,  2308, -2737, -2737,
   17711, -2737, 10107, -2737, -2737, -2737, -2737, -2737, -2737, 19355,
    2174, 19355, -2737, -2737,  1276, -2737, 38305,   448,  1030,  1030,
   18944,  1030, -2737, -2737, -2737, -2737, -2737, 45290,  2175, 46454,
    1498, 23781, -2737, -2737,  2076, -2737, 23781,  2367, -2737, -2737,
   23781, 46454,  2178, 46454,  1296, 18944, 18944, -2737, -2737,   186,
   -2737, -2737, -2737, -2737,   797, 18944, -2737,  2162, -2737, -2737,
   -2737,  2294,  2096, -2737, -2737, -2737, -2737, -2737, -2737, -2737,
   -2737, -2737, 18944, -2737, -2737,   512, -2737, -2737,  1858, -2737,
   -2737, -2737, -2737, -2737, -2737, -2737, 39470,  2505, 41410,   784,
    5554,  2339, -2737, -2737,  2359,  2259, 46454,   413, -2737,   694,
    2311, -2737,  1459, -2737, -2737, 41410,  2333,  2338,  2335, -2737,
   46454, 18944,  1287, -2737, 46066, 14869, -2737,  2187,  2347,   799,
   -2737,  2340, -2737, -2737,  1511, -2737, -2737, 41410,   -38, -2737,
    1299,   331, 19355,   172, -2737, -2737,  1030, -2737, 46454,  1310,
   -2737, 18944,  2195, -2737, -2737, 23781,  2076,  1314, 46454,  1317,
   38305,  1898, 10107, -2737, -2737, -2737,  3355,  2197, -2737, 41410,
   -2737, 10107, -2737, -2737, -2737,  1837,  1837,    34,  1837, -2737,
    1837, -2737,  2505,  2516, -2737, -2737,  2431, -2737,   440,  2344,
   46454,  2523, 39858, -2737, -2737, -2737, 46454,  2335,  1328, -2737,
   -2737,  2490,  1938, -2737,  7064,  1938, 24174, 46454, -2737, -2737,
   -2737,   838,  2407, -2737, -2737,  2361, -2737,  1556, -2737,  1192,
   -2737,  1334, -2737, 10107, 46454, -2737, -2737, -2737,  1338, -2737,
   18944, -2737,  1711,   838,  1847,  2362, 46454,   838,  1847, -2737,
   -2737,  2460, -2737, -2737,    42, -2737,  2355,  2357, -2737,   546,
    2215,  1938, -2737,    96, -2737, 46066,  1556, -2737, -2737, -2737,
   -2737,  2426,  2477, -2737, -2737,  1362, -2737, -2737,  2359, -2737,
   -2737, 46454,  2220, -2737, -2737,  2330,   421,   421,  2274, -2737,
    2488, -2737,   -77,   -77, 38305,  2224, -2737, 31683, -2737,  2334,
   -2737,  2336, -2737, -2737, -2737,   579, -2737,  2344,  2220,  2472,
   -2737,  2567, -2737,   113, -2737, -2737, 39470, 28149, -2737,   546,
    1366, -2737, -2737, -2737, -2737, -2737, -2737, -2737,   682,   784,
    2358, -2737, -2737, -2737,  1476,   385, -2737, -2737, 31683, -2737,
     333, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, 39470,
   -2737, -2737, 37527, -2737, -2737,  1194, -2737, -2737,  1214,  1400,
    2238,  2240, -2737,   333, 31683,  2353, -2737,  1368, -2737, -2737
};

/* YYPGOTO[NTERM-NUM].  */
static const short yypgoto[] =
{
   -2737, -2737, -2737, -2737, -2737,  2430, -2737, -1709, -2737, -2737,
   -2737, -1086, -2737, -1667, -2737,  1221, -2737, -2737, -2737, -2737,
   -2737,   408, -2737, -2737,  -716, -2737,  1430, -2737, -2737,   575,
   -2737, -2737, -2737, -1425, -2737,  -284, -2737, -2737, -2737, -2737,
   -2737, -2737,   850, -2737,   880,   483, -1275, -2737, -2737, -2737,
   -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -1817,   417,
      77, -2737,    81,   865,   160, -2737,  -109, -2737, -2737, -2737,
   -1025,   540, -2624, -2065,    68,  -417,  -445,  -392,  -390,  -420,
   -2737,  -254,  -337, -1844, -2089, -2737, -2737, -2737, -2737, -2737,
     103, -1788, -2737,  1239, -2737, -2737, -2737, -2737, -2737, -2737,
   -2737,  -408, -2737, -2737, -2737, -1785, -2737,   833, -2192, -2737,
   -2737, -2737,  -488,  -465, -2737, -2736,   -68,   -64, -2737, -2737,
   -2737, -2737, -2737, -1030, -2737,   480, -2737, -2737, -2737,  -429,
    1274,  -471, -2737, -2737, -2737, -2737,  -630,  -947, -2737, -2737,
    2538,   777,  -491, -2737, -2737, -1759, -1782, -2737,  1879, -2737,
    1618,  1196,   397,   106, -2737, -2737, -2737, -2225, -1780, -2737,
   -2737, -2737,  -314, -2724, -2737,   473, -1061, -2737,   582, -2737,
   -2737, -2737,   461, -1655, -2737,   -75, -2737, -2737, -2737, -1334,
   -2737, -1458, -1326, -2737,  -260, -2737, -2737, -2737,  1649, -2737,
    -116, -2737, -2737, -2737, -2737, -2737,  -395,  -426, -2737, -2737,
   -2737,   155, -2737, -2737, -2737,   936,  -986,  -827,  1900, -1779,
   -2737, -2737, -2737,   885,  -366, -2737, -2737, -2737, -2737, -1419,
   -2737, -2737, -2737,  1081,  2611,  -696, -2737, -2737, -2737, -2737,
   -2737, -2737,   -25, -2737, -2737,   450,   -17, -2737, -2737, -2737,
   -2737,   -12,  1700,   851,   156,   -69,   -71,  -223,   556,   562,
   -2737, -2737,  -169,   783, -2737, -2737, -2737, -2737,   678,  1517,
   -2737,   671,  -352, -2737, -2737,  1521, -2737, -2737,  1104, -2737,
   -2321,   357, -2316,    86, -1032,  -200,  -186, -2737, -2001, -2594,
     198,   973, -1626, -1796,  1378, -2737,  1708,  2020, -2737, -2737,
    -956, -2737, -2737,  2475,  2704, -2737, -2737,  3409,  3955, -2737,
   -1013,   400,  5029,  1439, -1102, -1394,  9363,  -460, -1499, -1889,
   -2737, -2737,  -676, -2737,  9517,   573, -2737, -1115, -2737,   126,
   -2737, -1481, -2737, -2737, -2737, -2737, -2737, -1391, -2201,  -976,
     750, -2737, -2737,   844, -2737, -2737, -2737,  -924,  1601, -1548,
     179, -2737,  1177, -2737,    85,  -247,   725,   -23,   193,   -72,
    -801,   -97,  -835,  7157,  -646, -1871, -1305,  1772, -2737,  -679,
   -2737,    -2,    91, -2737, -2737,  5807,   -96, -2737, -1592, -2737,
     -27, -2737,  -832,  -902, -2194,  -629, -2737, -2737,   -49, -2737,
    1896, -2737,  1087,  1522, -2737, -2737,  1093,  -774,  -133, -2737,
   -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737,
   -2737, -2737, -2737, -2737, -2737, -2737,  1564,   109, -2737,   -46,
   -2737, -2737,  2751, -2737,  2521,   -51, -2737,  2170,   -33, -2737,
   -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737,  -776,  1130,
   -2737,  1883, -2737, -2737, -2737,  -704, -2737, -2737, -2737,  1732,
    -144, -2737, -2737, -2737,  -963,   919,  1917,  -802,  -921,  1098,
   -2737, -2737, -2737, -2737, -2737, -2737, -2737, -2737,   910, -2737,
   -2737,   763,   915, -2737, -2737,   230, -2737, -2737,   129,   234,
   -2737,  1642, -2737, -2737, -2737,   393, -2737, -2737, -2737,  -523,
    7611,    10,   -88,   -84,   515,   925,  5349,  1079,  -668,   -56,
    1595,  5381,  8665,   -83,   -44,    50,    94, -2737, -2737,  2515,
    1118,   937,  -887,  6046,  1369,  2602,  3908,  -681,  -798,  1931,
    -480, -1268, -2737,  2862
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -1714
static const short yytable[] =
{
      69,   875,   661,   299,  1471,   298,   662,   668,   960,   777,
    1440,   947,   973,   748,  1218,  1914,  1450,  1379,  1747,   989,
     748,  1329,  1100,   313,   661,  1329,  1791,  1229,   662,   668,
    1898,   348,   870,  1865,   665,  1324,  1737,  2251,  1308,  1028,
     710,   315,  2295,   969,   971,   864,   669,  2078,   827,   293,
    1960,  1575,  1040,  1312,  1587,   550,   665,   294,   967,   748,
     970,   797,   296,   974,  1056,   709,  2254,  1995,   669,  2435,
    2587,   997,  2495,   998,  1061,  1277,  1032,   818,   703,  2108,
    1065,   797,  2619,  1081,   340,   826,  1068,   340,  2217,   922,
    2468,  2179,  2180,    70,  1033,  2255,   744,  1036,  2256,  1995,
     340,  2257,   709,  2258,  2259,  2698,  1046,  1539,  1540,  1047,
     709,  1064,  2156,  2157,  2121,  2713,  2715,  1483,  2125,  1095,
     868,  2146,   340,  1629,   342,  1305,  1559,   342,   661,  2359,
    2092,  1066,   662,   668,  1221,  1910,  1227,  1302,  1309,  1282,
     342, -1523,  1073,  1214,  1076,   709,   709,  2359,   821,  1286,
    1287,  1858,  1499,   874,   299,   796,   298,  1478,   956,  1484,
     665,  -137,   342,  2226,  2934,  1305,  1478,  1215,   343,  1493,
    1494,   343,   669,  1551,  -769,   796,  1589,  1449,  2663,   936,
    2433,  1594,   901, -1089,   343,  2057,   347,   704,  1517, -1089,
    1341,  2058,  1946,  3016,  1757,  1594,  1912,  2335,  3106,  2021,
     293,  1597,  1918,  -772,  1849,  1758,   343,  1512,   294,  2069,
     881,  2249,  1623,   296, -1525,  1597,  2202,  2440, -1618,   918,
    1803,  1334,  1478,  2441,  2442,  2443,   340,   828,  2277,   276,
    2227,  3040, -1522,  -769,   902,  2444,  2445,  2446,  1988,  2447,
    2448,  2449,  2190,  1379,  1376,  2450,  2451,  2452,  1886,  2359,
    2320,  1083,  3119,  1895,  2785,   680,   882,   681,  2556,   887,
    3120,  1759,  -772,  1254,  3152, -1521,   342,  1767,  1324,  1626,
    -801,  2176,  1342, -1105,  2761,  1690,  1594,   888,   903, -1105,
    1000,   904,   202,  2324,  1947,  1821,  2252,  2987,   829,  2989,
    1356,  3065,  2962,  1210,  -937,  1357,  1597,  1643,   914,  1356,
     913,  1089,  -256,  1335,  1357,  1887,  1025,  1877,  1638,  1762,
     343,     3,  1575,  1327,  1255,   883,   888,   548,   944,  1322,
     340,  -801,    52,  1323,  1839,  1085,  1657,  2727,  3066,  1383,
    1358,  1804,  1050,  1102,  1328,  1385,  1878,  1381,  2526,  1358,
    2325,  1388,  1359,  1644,  1211,   162,  1639,  1350,  1256,  1691,
   -1640,  1359,  1001,  1479,   905,  -801,   340,  2963,  1377,   340,
     342,  3122,  1479,  2786, -1653,  1760,  1893,  1850,  2177, -1670,
    2178,  1222,  1360,  1768,  1459,  3153,   202,   224,  2763,  2359,
     276,  1360,  2870,  3121,  2210, -1575,  2874,  1539,  1540,  2191,
    2879,   684,  1835,  2361,  3058,  1559,   342,  2319,  1901,   342,
    -942,  1748,  1896,   884,   343,  2321,  1518,  1442,  2359,  1439,
    1343,  3107,  1962,  3168,  1624,  1957,  1958, -1618,  1479,  2561,
   -1714,  1456,   685,   906,  1948,   830,  1966,  1968,  2738,  2739,
   -1089,  1513,  2059,  1836,  1320,  2547,   923,  1472,  3098,  1949,
     343,  1761,  2090,   343,  2848,  2362,  1811,  1551,  2524,  2525,
    2203,   907,  1999,  1301,  2001,   912,  -769,  2530,  -769, -1620,
    2464,  1888, -1523,  2372,  1336, -1523, -1523,  1480,  2393,   682,
   -1523,  1514,  1859,   924,   921,  1590,  2622,   548,  2369,  2370,
    2371,  2372,  1866,  1701,  1859,  -772,  1309,  -772,  2459,   150,
    2498,   548,  1995,  1995,  1995,  2453,   548,  1995,    49,  1395,
    2359,   548,  1302,  2205,   945,  1726,    52,   975,  1636,  1637,
    1361,  1731,   994,  2075,    49,  1618,  2531,   548,  2278,  2279,
   -1105,  1921,    52,  2361,    53,  2359,  1615,  1616,  1617,  1618,
    1274,  2520,  3130,  1362,  1757, -1525,  1053,  2433, -1525, -1525,
    1995,  2466,  1362, -1525,  1984,  1985,   166,  1594,  1679, -1640,
    2980,  2977, -1714, -1522,  1840,  2984, -1522, -1522,  1462,  2986,
     548, -1522,  1920, -1653,  2363,    52,  1060,  1597, -1670,  -937,
    2454,  1923,  -937,   791,  2364,  2365,  2366,  1767,  2367,  2368,
    2369,  2370,  2371,  2372, -1575,    52, -1521,    53,  3050, -1521,
   -1521,   661,   182,  -937, -1521,   662,   668,  1463,  1266, -1193,
     993,  1759,  1057,  2941,  2546,  1613,  1614,  1615,  1616,  1617,
    1618,    49,   918,   748,   548,   959,  1756,  1225,  1765,   959,
    1027,   709,  1290,   665,  2322,   709,   709,   674,   566,  3072,
    1764,   675,   958,  1092,   548,   669,  1647,  2103,  -183,    52,
    2297,  2298,   676,  1078,  2361,   709,   959,   791,  1710,  1770,
     888,  2903,  1765,   202,  1820,  1381,  1771,    69, -1620,    49,
    1054,  1534,   548,  2039,  3055,  3146,  1464,   918,  1932,  2361,
    1936,  1937,  1344,  1939,  3131,  -942,   989,   352,  -942,  1895,
     709,   959,  3171,  2747,   797,  1333,   797,   959,   797,   340,
    2462,  1601,  1602,   340,   797,  1088,  2362,  2783,  2933,  -942,
    1711,  3012,   218,  1748,   714,  1760,  1938,  1465,  2367,  2368,
    2369,  2370,  2371,  2372,  1373,   918,  1346,   677,  2415,  2827,
    1099,  2362,  3073,  1772,  2746,  1055,  1101,  1854,  3132,   342,
    1605,   866,  2813,   342,  1105,  1005,  3112,  2367,  2368,  2369,
    2370,  2371,  2372,  2784,  1712,   709,  3133,  1861,   224,  1000,
      70,   709,  2772,  2773,  2774,  2775,  2776,  1841,  1766,   709,
    2040,  1846,  2748,  2512,  2041,  2749,  2254,  1237,  1255,  2757,
    2758,  1466,  1240,   343,  2211,  1288,  2828,   343,   796,  2323,
     796,  1761,   796,  1248,  1267,  1485,   940,  2031,   796,   796,
    2104,   150,   709,  3147,  2042,  2255,  1462,   709,  2256,   902,
    3172,  2257,  1256,  2258,  2259,   567,  2032,   716,   709,  1238,
    1714,  2143,  1881,  3000,  2433,  2363,  2144,   678,  2433,  3113,
    1713,  1001,  2433,  2759,  1224,  1935, -1714, -1714,  3022,  2367,
    2368,  2369,  2370,  2371,  2372,  2616,  1230,  1308,   150,   843,
    2363,  2920,  1757,   903,   800,  2095,  1862,  1917,   166,  1803,
    1919,  2633,  1312,  1758,  2367,  2368,  2369,  2370,  2371,  2372,
     752,  1995,  1773,  2496,  1995,  1995,  1995,  1995,  1995,  1995,
    1995,  1995,  1995,  1995,  2308,   340,  1613,  1614,  1615,  1616,
    1617,  1618,  1039,  2829,  2033,  3114,  1715,  2921,   989,  2034,
    2043,  2112,   817,  2035,  2388,   166,   550,   550,  1718,  2675,
    1995,  1719,  1231,    49,  1464,  1275,   548,  1232,   684,  1759,
    1382,  2516,  2517,  2401,   844,   342,  2403,   661,  1843,   905,
     822,   662,   668,  3142,  2513,  2954,   839,  2777,  2024,  1711,
      69,    69,  2830,    69,  1067,   709,   959,  2761,  1275,   685,
    3159,   182,   959,  1861,  2798,  1465,   875,  1378,  2648,   665,
    1048,  1453,  1454,   202,  3043,   202,  2436,  2437,  1461,   343,
    2514,   669,  2171,  2645,  3142,  2174,  2175,  2621,  1844,  1868,
    1078,  2330,  1049,  1712,  1720,  2799,   709,   709,  2329,  1770,
    1322,   959,  2433,   709,  1323,  2036,  1771,  2433,  1863,  2664,
    3142,  2433,  2762,  2037,  2914,   902,  2916,  2917,  1276,  2404,
    1101,  3102,   202,  2405,   218,  2622,  3023,   557,  2626,  1466,
     299,  1048,  1491,  1760,   579,   340,  1864,   672,  2612,  3044,
    2614,  2615,   785,    70,    70,   709,    70,   672,   299,  3024,
    1516,  1276,  2387,  2792,  2389,  2390,  3128,   786,  2705,   903,
    1869,  2763,  1862,  1532,   872,  2649,  3092,  1477,   224,  1713,
     224,   218,   579,  1772,  2650,   342,  1487,  2119,  2706,   686,
    1553,   672,   713,  2222,  1488,  3021,  1344,  1831,  2223,  1489,
     579,   672,  1995,  2876,   672,  1832,   715,   863,   672,  1353,
    2708,  1369,   672,  1870,   196,  3123,  1578,  1345,   775,  1761,
    1822,  1823,  1330,   117,  1833,  2406,  2433,  3160,  1585,   343,
    1354,  2317,   672,  2407,  1370,  1534,  2318,  1594,  1365,  2132,
    1346,   121,  1777,  1331,  1594,   905,   196,   672,  2489,  -942,
     833,   838,  -942,  2129,  1446,  2131,   842,  1597,   857,  1366,
     862,  2892,  1598,  1778,  1597,   841,  1332,   878,  2026,  2490,
    2142,  1447,  1674,  -942,  1588,  2569,  1871,  2954,  1872, -1332,
    1073,  1073,  2158,  2159,   978,  1593,  3002,  1632,  1824,  2710,
    2778,  1633,  1371,  2169,   979,   980,   981,   709,   982,   983,
     984,   985,   986,   987,  1531,   661,   224,   894,  2571,  1682,
    1682,  1817,  1682,   879,  1863,  1995,  2193,  2502,  3084,  2196,
    2197,  3086,  2331,  2218,  2219,  1570,  1571,  1387,  1650,  2332,
    1733,   895,  2499,     9,  1570,  1571,   978,   665,  2503,  1825,
    1826,  2731,   896,   891,  2214,  2215,   979,   980,   981,   669,
     982,   983,   984,   985,   986,   987,  1275,  1572,  1275,    49,
    1275,  2469,   548,  1600,  1728,   661,  1574,  3118,  1827,   662,
     668,  1806,  1322,  2300,  1810,  1812,  1323,    49,   916,  1073,
     548,  1601,  1602,  1570,  1571,  2460,  1803,   548,   550,  1653,
    1809,  -952,    52,  1740,  -952,  1744,  2475,   665,  -922,  2359,
     791,  -922,  1721,   340,   340,   340,  2671,   672,   927,   669,
    2853,   888,  2665,  2666,  2931,  1572,  1034,   897,  1035,  2575,
    1605,   875,  1549,  -916,   796,   709,  -916,  1828,    69,  2328,
     125,   126,    69,  1606,  2329,  1546,  1548,   661,  2550,  2551,
    2552,   662,   668,   342,   342,   342,  2576,  1555,   930,  1276,
    1794,  1276,  2541,  1276,   340,  2577,  1406,   548,  1568,  1829,
    1322,   340,    52,   340,  2717,   898,   548,  1579,  2833,   665,
    1322,  2508, -1199,  -949,  1323,  1654,  -949,  2509,  2510,  1969,
    1995,   669,  1995,  1077,   548,  1795,  2841,   343,   343,   343,
     222,  1570,  1571,   223,   342,  1722,   659,  -949,   989,  -952,
    2339,   342,  -952,   342,   940,  2329,  -919,  1915,  1916,  -919,
    1557,  1558,    49, -1523,  1275,   548, -1523,   899,  1037,   999,
    1038,    70,  2578,  1574,  2960,    70, -1525,   946,  -907, -1525,
    1562,  -907,   709,   709,  2897,   340,  1592, -1529,   343,  2341,
    1101,   957,  2884,  2361,  2329,   343,  1796,   343,  1005,  2344,
   -1530,  1951,  1609,  2473,  2345,  2419, -1522,  2420,  1650, -1522,
    1101,  1703,   959,  1030,  1704,   709,  1613,  1614,  1615,  1616,
    1617,  1618,  2421,   874,  2422,   342,   709,  1970,   579,  1971,
   -1527,  1031,  1797,  1972,  1798,   709,  2350,  -905,  2815,  1983,
    -905,  2351,  1007,  2376,  1799,  2362,  1987, -1521,  2329,   978,
   -1521, -1196,  2482,  1995,  1379,  2816,  2005,  1276,  2006,   979,
     980,   981,  1041,   982,   983,   984,   985,   986,   987,   343,
    2439, -1526,   672,   672,  2019,  2329,  2020,  1927,   222,    49,
    2995,   223,   548,  2242,  2243,  2244,  2245,    52,   661,    53,
    1324,    49,   662,   668,   548,  1274,   763,  1800,  2548,  2549,
    2550,  2551,  2552,  1303,  1304,  2500,  2067,  1981,  2771,  2029,
    1051,  2356,  2357,  2358,  -777,  2083,  2374,  1736,  1304,  2470,
     665,   796,  2817,   796,  1646,  1801,  -777,   796,  2473,   548,
    1052,   709,   669,   796,    52,  1854,    53,  1082,  2588,  1084,
     796,  1086,  1274,  2589,  1063,    49,  2818,  1087,   548,  1073,
     796,  -908,   796,    52,  -908,    53,  1905,  1906,  2595,  2410,
    -777,  1274,  2094,  2596,  2363,  1074,  3063,  3064,   796,  3067,
     796,  3068,  2819,  1092,  2364,  2365,  2366,  -777,  2367,  2368,
    2369,  2370,  2371,  2372,  2607,   918,   340,   709,  3093,  2608,
    3182,  2624,  3183,   968,   579,   972,  2625,   557,  2678,   672,
     991,   672,  2086,  2329,   672,   672,   968,   557,  1935,  2084,
    1245,  -777,  -769,  2720,  1096,  2704,  2721,  1927,  2329,  -777,
     888,  2329,    49,  2740,   672,   548,   342,   579,  2608,   968,
      52,   557,    53,  1097,  2811,  1043,   672,   801,  2889,   672,
    2110,   968,  2110,   557,   948,  1251,  1098,  1253,   949,  2855,
     672,   672,  2901,  2820,  2856,  1594,  2875,  2608,  2878,   672,
     950,   951,   579,   340,  2821,   557,  2902,  2705,  1595,   672,
     343,  2608,  2974,   672,   672,  1597,   557,  2856,  2822,   968,
    1598,   952,   550,  3035,   953,  2823,   802,  2706,  3036, -1156,
    2639, -1156,  1103, -1156,  3181,  3048,   340,   672,   340,   672,
    2625,  1275,  2707,   342,  1107,   672,  3052,  -777,   803,  2708,
    3057,  1646,  2200,  3059,  1108,  2589,  1109,  1275,  2589,    69,
    -906,    69,  1110,  -906,  3082,  2824,   804,  2709,  2964,  1518,
    3094,  2476,  2477,   672,  3096,  1646,   342,  1106,   342,  2589,
    1112,  2548,  2549,  2550,  2551,  2552,  1113,   343,  2238,  2553,
    2991,  2359,   579,   672,   672,   857,  1228,   857,  3126,  1245,
    1233,  2248,  3157,  1646,  3189,   805,  1234,  3158,  1235,  3158,
    1727,   918,  1275,  1704,  1241,  1275,  1275,  1599,  2266,  1242,
     343,  1600,   343,  2283,  1243,   875,  1683,  1685,  2710,  1689,
    1245,  3155,  1684,  1684,  1276,  1684,  1246,   721,   954,  1601,
    1602,  1247,  2106,   709,  2221,  1704,   796,  1249,   709,  1252,
    1276,  1603,    70,  2115,    70,  1260,  1704,  2815,  1570,  1571,
    2768,  2769,  2946,  2947,  1289,  1291,  1268,  1264,   557,   557,
    1265,  1269,  1295,  1270,  2816,  1604,  1271,   796,  1605,  1272,
    1273,  1280,   796,  1283,  1285,  2333,  1288,  1296,  1313,  1314,
     806,  1606,  2282,   672,  1316,   796,   672,  1326, -1529,   672,
     725, -1530, -1527,  1338,  1349,  1276,   807,  2711,  1276,  1276,
   -1526,  1339,   808,  1351,  -537,  2424,  2425,  2360,  1352,  1367,
    2647,  1368,   968,  2651,  2652,  2653,  2654,  2655,  2656,  2657,
    2658,  2659,  2660,  1375,  1374,  2361,  1384,   809,  1391,   810,
    1386,  2817,  1393,  1397,  1434,   727,  1395,  1608,   811,  1594,
    1435,  1437,  1441,  1444,  3046,  1451,  1455,  1836,  1467,  2676,
    1469,   812,   813,   672,  1473,  2818,  1474,   672,  1475,  1597,
    1522,   672,  1476,  1530,  1598,  1525,   672,  1585,  1526,   796,
    1527,  1538,  3003,   729,   968,  1541,  2423,  2362,  1542,  1543,
    2029,  2819,  1545,  1547,   224,  1554,   968,  1458,  1561,   672,
    1652,  1552,  1564,  1565,  1566,  1567,  1569,  2461,  1576,  2418,
    1609,   709,   968,  1577,  1628,  1646,  3004,  2434,  2427,  1672,
    1610,  1611,  1612,  1416,  1613,  1614,  1615,  1616,  1617,  1618,
    1673,  1680,  1254,  1702,   672,  3005,  1709,  1716,  1717,  1725,
    1723,  1729,  2400,  1305,  1732,  1738,  1741,   672,  3006,  2569,
    1739, -1475,  1779,   732,  1743,   733,  1470,  1529,  1752,  1780,
    2570,  1753,  3007,  1785,   734,  1784,  1787,  1754,  1755,  1381,
    1803, -1714,  2820,   737,   989,  1600,  1769,  1781,  1782,  1807,
    1813,  1783,  2571,  2821,  2572,  1786,  1792,  -550,  1793,  1837,
    1808,  1815,  1814,  1601,  1602,  1816,  1818,  2822,  1927,  1819,
    1842,   796,  1845,  1275,  2823, -1714,  2363,  2359,  1847,  1848,
    1534,  1857,  1867,  3170,  1973,  1855,  2364,  2365,  2366,  1549,
    2367,  2368,  2369,  2370,  2371,  2372,  2899,   723,  1555,  1885,
    1899,  2782,  1605,  2905,  1900,  2907,  1902,  1562,  1891,  2573,
    3008,  1908,  1911,  1913,  2824,  1606,  1903,  3009,  1924,  1931,
    1940,  1942,  1941,  2545,  1952,   661,  1962,   579,   579,   662,
     668,  2003,  2004,  3051,  3028,  1969,  1974,  1925,  2611,  1961,
    1651,  1930,  3010,  3051,  1518,  1669,  1670,  1669,  1594,   748,
    2017,  2018,  2025,  2028,  2586,  2044,  1678,   665,  2574,  2046,
    2592,  1275,  2069,  2575,  2079,  2082,  1276,  1275,  1275,   669,
    2080, -1714,  2085,   882,  2087,  2096,  2100,  2101,  2105,   709,
    1975,  2114,  1594,  1976,   875,   709,  1859,  2113,  2128,  2118,
    2576,  2133,  2135,   875,  2136,  1595,  2137,  2139,   579,  2577,
     557,  2141,  1597,  2704,  2154,  2562,  2155,  1598,   299,  3095,
    2609,   299,  1275,  2610,  2857,  2167,  2172,   796,  2166,   796,
    2359,  2361,  2185,   340,  2195,   959,  2168,  2198,    49,  2557,
    2201,   672,  2204,  2399,  1609,  2207,   299,  1935,  2627,  2640,
    2691,  2692,  2693,  2694,  2359,  2643,  2206,   857,  1613,  1614,
    1615,  1616,  1617,  1618,  1276,  2705,  1977,  2684,  2208,  2209,
    1276,  1276,  2216,   342,  2229,  2236,  2578,   991,  2224,  2237,
    2240,  2250,  1442,  2362,  2261,  2706,  2262,  2281,  2284,  2289,
    2290,  2291,  2292,  2293,  1638,   857,  2296,  2326,  2342,  1751,
    2707,  2327,  2307,  2382,  2343,  2347,  2346,  2708,  2348,  2352,
    2355,  2375,   968,  2402,  1599,  1276,   968,   343,  1600,  2329,
    3033,  2381,  2383,  2384,  2385,  2709,  2392,  2695,  2696,  2396,
    2398,  2483,  2397,  2408,  2414,  1978,  1601,  1602,   222,    49,
    2481,   223,   548,   796,  2417,  2479,  1585,  2981,  1603,   796,
    2505,  2438,   709,   709,  2434,  2697,  2465,  1838,  1304,  2487,
    2485,  2493,  2472,  2518,  2528,  2494,   557,   672,  2486,   672,
    2674,  2522,  1604,  2519,  2361,  1605,  2527,  2529,  2543,  2544,
    1651,  1719,  2555,  2554,  2591,  2594,  2710,  2582,  1606,  2971,
    1607,  2973,  2593,  2597,  2606,  2598,  2602,  2603,  2361,  2617,
    2629,   557,  2363,  2613,  2618,   968,  2630,  3088,  1531,  1875,
     672,  2637,  2364,  2365,  2366,  2634,  2367,  2368,  2369,  2370,
    2371,  2372,  2359,  2378,  2377,  1589,  2362,  2703,   672,  2680,
     672,   672,  2668,   672,  2669,  2670,  2722,  2688,  2718,  1945,
    2723,  2726,  1751,  2724,  1608,  2730,  2732,  2767,  2982,  2754,
    2362,  2735,  2736,  1955,  2741,  2742,  2743,  3154,  2779,  2744,
    2753,   989,  2760,  2770,  2755,  2711,  2756,  2780,  2789,  1427,
    1055,  2787,  2793,  2795,  2801,  2806,  2807,    69,  2809,  2814,
    2788,   978,  2840,   709,  2837,  2849,  2843,  2844,  2845,   991,
    3180,   979,   980,   981,  2847,   982,   983,   984,   985,   986,
     987,  2851,  1427,  2850,  2852,   709,  2867,  1609,  2871,  2872,
    2869,  2880,  3049,  2885,  2883,  2886,  2904,  1610,  1611,  1612,
    2908,  1613,  1614,  1615,  1616,  1617,  1618,  2895,   299,  2126,
    2808,  2909,  2912,  2915,  1721,  2762,  2925,  2922,  2127,  2926,
    2927,   796,  2928,  2935,  2936,  2363,   796,   796,   796,   796,
     796,  2938,  2940,  2942,   672,  2364,  2365,  2366,  2943,  2367,
    2368,  2369,  2370,  2371,  2372,  2944,  2945,  2022,  2950,  2363,
      70,   672,  2958,  2959,  2967,  2812,  2961,  2968,  2998,  2364,
    2365,  2366,  2969,  2367,  2368,  2369,  2370,  2371,  2372,  2972,
    2978,  2985,  2999,  2988,  2863,  2864,  2865,  2866,  3013,  3018,
    2089,  2786,  3029,  3020,  3026,   672,  3031,  3030,  3041,  3042,
    3054,  3045,  3070,  3061,  3071,  3074,  3079,  3083,  3090,   709,
     709,   709,   709,  3091,  3101,  3105,  3108,  1722,  3110,   661,
    3117,  2434,  2427,   662,   668,  2434,  2427,  3124,  3125,  2434,
    2427,  2608,  3129,  3107,  3106,  3139,  3150,  3144,  3151,  3145,
    3171,  3169,  2910,  3184,   557,   877,  3185,  1295,  1876,  2583,
    2463,   665,  1671,   672,  2192,  2162,  2515,  1656,  2797,  2584,
    2181,  2745,  2932,   669,  2492,  2803,  2832,   557,   672,   557,
     579,  3127,  3149,   672,   564,  3111,  3109,  3135,  3027,   672,
    3081,   580,  1894,  3174,   557,  2937,  3187,  2894,  2924,  2804,
    2239,  2923, -1711,  2534,   557,   557,   557,   557,   672,   672,
    3156,   672,  2165,  1880,  3188,   824,  1511,   557,   672,  1111,
     709,  1927,  3087,  1954,  2631,  2585,  2497,   340,  2838,   580,
    2182,  2183,   672,  2919,   672,  2187,   672,   672,  1418, -1711,
     557,   672,   959,   557,   557,  2605,   796,   580,   580,  2147,
    2965, -1711,  3069,  3162,  1524,   580, -1711,  3186,  2246,   564,
    2093, -1711, -1711,  1236, -1711,  1427,   778,   342,  2628,   968,
     968,  1418,  2834,  2299,  2471,  1699,  2478,   564,  1697,   564,
    2091,  1490,  2949,  2699,  2235, -1711,  3056,  2796,  2957,  1856,
    1427,  2412,  1650,  1627,   580,  2877,  2673,  2540,  1008,  2434,
    2427,  2068, -1711,   557,  2434,  2427,  2854,  2336,  2434,  2427,
    1751,   343,  2896,  3097,  2890,  2467,  2265,  2970,  2839,  2117,
    1734,  2276,  2116,  1427,  1457,   310,  1298,  1009,  2288,  1708,
    2228,  3015,   889,   939,  2107,  1521, -1711,  2120,  2165,  1010,
    2305,  1321,  2458,  1292, -1711,  1011,  2306,  2835,  1101,   672,
    1427,  2888,  2836,  1635,   959,  2150,   709,  2725,  1705,  1012,
     911,  2124,  2301,  1300,    76,  2312,     0,  1926,     0,     0,
    3047,     0,     0,   709,     0,  1427,  1013,     0,     0,     0,
       0,     0,     0,     0,  2294,     0,     0,  2993,     0,     0,
       0,     0,     0,     0,     0,   709,     0,   299,     0,  2610,
       0,   687,  3062,     0,  1014,     0,     0,     0,  1427,     0,
       0,   822,  1427,  2434,  2427,     0,     0,     0,     0,     0,
    1015,     0,     0,     0,     0,     0,     0,   709,     0,     0,
       0,     0, -1711,     0,     0,     0,     0,  3179,     0,     0,
       0,     0,  1016,  2395,     0,     0,     0,     0,   688,     0,
   -1711,     0,     0,     0,   580,     0,     0,     0,     0,     0,
       0,     0,   689,     0,   959,     0,     0,     0,     0,   991,
       0,     0,     0,     0,     0,     0,  1594,     0,     0,   690,
    2994,     0,     0,     0, -1711, -1711, -1711,  1017,     0,     0,
       0,     0,     0,     0,     0,     0,  1597,     0,     0,     0,
       0,  1598,     0,     0,     0,     0,   763,   691,     0,     0,
    1669,   692,     0,     0,  3089,  1678,  3136,  3137,     0,     0,
       0,     0,     0,   693,     0,     0,   672,     0,  1018,     0,
    1019,     0,     0,  1427,  1418,  1020,  3099,     0,     0,     0,
    3103,     0,     0,   579,   694,     0,     0,     0,     0,     0,
    1419,     0,     0,     0,     0,     0,     0,  1021,     0,  1418,
       0,     0,  2288,     0,   959,     0,     0,     0,     0,  2409,
    1022,     0,     0,     0,     0,  1023,     0,   299,     0,   557,
     672,  1594,     0,  1419,     0,     0,     0,     0,     0,  3178,
     695,     0,  1418,  1024,  1595,     0,     0,   959, -1714,     0,
       0,  1597,  1600,     0,     0,     0,  1598,     0,   802,     0,
     796,   796,   299,     0,     0,     0,     0,     0,  2147,  1418,
    1601,  1602,     0,   557,     0,   580,     0,     0,     0,     0,
     803,     0, -1714,   696,  2165,     0,     0,     0,   697,  2504,
       0,  2507,     0,     0,  1418,     0,     0,     0,   804,     0,
       0,     0,     0,     0,     0,  2511,  2235,     0,     0,  1605,
     698,   699,     0,     0,     0,     0,     0,     0,   672,   672,
     672,     0,  1606,   700,     0,     0,     0,  1418,   701,  2523,
       0,  1418,     0,   931,     0,     0, -1713,   805,   702,     0,
       0,     0,     0,     0,     0,     0,     0,  2147,     0,     0,
       0,     0,     0,  1599,     0,     0,   672,  1600,     0,     0,
       0,     0,     0,     0,     0,  1427,     0,   672,     0,     0,
       0,     0,     0, -1713,     0,  1601,  1602,     0, -1714,     0,
       0,     0,     0,     0,  2620, -1713,     0,  1603,  2590,     0,
   -1713,     0,     0,  1945,     0, -1713, -1713,     0, -1713,  2511,
       0,     0,  2312,     0,     0,     0,     0,  2147,     0,     0,
       0,  1604,     0,     0,  1605,   968,     0,     0,     0, -1713,
       0,     0,   806,     0,     0,     0,  1427,  1606,     0,  1607,
       0,  1427,     0,     0,     0,     0, -1713,     0,   807,     0,
       0,  1609,     0,     0,   808,     0,  1427,     0,     0,     0,
       0,     0,  1418,     0,     0,  1613,  1614,  1615,  1616,  1617,
    1618,  2638,     0,     0,     0,     0,     0,     0,     0,   809,
   -1713,   810,     0,     0,     0,     0,     0,     0, -1713,     0,
     811,     0,  2646,  1608,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   812,   813,     0,  1419,   580,   580,     0,
    1427,     0,  2702,     0,     0,     0,  2702,  2716,     0,  2667,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1419,     0,     0,     0,     0,     0,     0,   580,     0,
       0,  2681,   564,     0,   564,     0,   564,     0,     0,     0,
       0,     0,   564,   564,     0,   822,  1609,     0,     0,     0,
       0,     0,   580,     0,  1419,     0,  1610,  1611,  1612,     0,
    1613,  1614,  1615,  1616,  1617,  1618, -1713,     0,  2288,  2288,
       0,     0,     0,     0,     0,  2349,     0,     0,     0,     0,
       0,  1419,  1594,     0, -1713,     0,     0,     0,     0,     0,
       0,     0,     0,   672,   672,  1595,     0,     0,     0,   580,
     580,     0,  1597,   564,     0,     0,  1419,  1598,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0, -1713, -1713,
   -1713,     0,     0,  2235,  2235,  2235,  2235,  2235,     0,     0,
       0,     0,     0,     0,  1418,     0,     0,  2750,     0,  1419,
       0,     0,     0,  1419,     0,   672,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1421,     0,     0,     0,   564,
       0,     0,     0,     0,  2265,     0,  2182,     0,     0,  2182,
       0,  2805,     0,     0,     0,   564,   564,     0,  2165,     0,
       0,     0,     0,  2288,     0,     0,  1594,     0,  1421,     0,
       0,     0,     0,     0,     0,  1418,     0,  2312,     0,     0,
    1418,     0,     0,     0,  1599,  2791,  1597,     0,  1600,     0,
       0,  1598,     0,     0,     0,  1418,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1601,  1602,     0,     0,
       0,     0,     0,     0,  1427,     0,  1594,     0,  1603,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1427,  1597,  1427,     0,     0,
       0,  1598,  1604,     0,  1419,  1605,     0,     0,     0,  1418,
       0,  1427,  2702,     0,     0,  2868,     0,     0,  1606,  2685,
    1607,     0,     0,     0,     0,     0,     0,     0,     0,  2882,
       0,     0,     0,     0,     0,  1427,     0,     0,     0,     0,
       0,     0,  2089,  2681,     0,   991,     0,  2898, -1714,     0,
     557,   672,  1600,  1427,     0,     0,     0,   557,   672,   557,
       0,     0,     0,     0,  2911,     0,   564,     0,     0,  2686,
    1601,  1602,     0,     0,  1608,     0,     0,     0,     0,     0,
       0,     0, -1714,     0,  1498,     0,     0,  1502,     0,     0,
       0,     0,     0,     0,  1427,   580,     0,     0, -1714,     0,
       0,     0,  1600,     0,     0,  1427,     0,     0,     0,  1605,
       0,     0,     0,  1427,     0,     0,     0,     0,     0,     0,
    1601,  1602,  1606,     0,  1422,     0,     0,     0,     0,  2955,
       0,     0, -1714,     0,  1651,     0,     0,  1609,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1610,  1611,  1612,
       0,  1613,  1614,  1615,  1616,  1617,  1618,  1422,     0,  1605,
       0,     0,     0,   564,     0,     0,  3060,  1427,     0,     0,
       0,     0,  1606,     0,   564,     0,     0,     0, -1714,     0,
       0,     0,  2702,     0,   672,     0,  1419,     0,  1427,     0,
       0,  1421,     0,     0,     0,     0,  2265,     0,  2990,     0,
    1631,     0,     0,     0,   580,   580,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1427,  1421,   564,     0,  2975,
     564,     0,   564,     0,   564,     0,     0,     0, -1714,     0,
       0,     0,     0,     0,     0,     0,     0,  1427,     0,     0,
       0,  1609,     0,  1418,     0,     0,     0,  1419,     0,  1421,
       0,  2165,  1419,     0,     0,  1613,  1614,  1615,  1616,  1617,
    1618,     0,     0,     0,  1418,   968,  1418,  1419,     0,   968,
     968,     0,     0,     0,     0,   580,  1421,   564,     0,     0,
    1418,     0,     0,     0,     0,     0,     0,     0,   564,     0,
       0,  1609,     0,   672,     0,     0,     0,     0,     0,     0,
       0,  1421,     0,  2990,  1418,  1613,  1614,  1615,  1616,  1617,
    1618,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1419,  1418,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1421,   672,     0,  2182,  1421,     0,
       0,   672,     0,  1427,     0,     0,     0,     0,     0,     0,
       0,  2955,   968,  2590,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1418,     0,     0,     0,     0,     0,   672,
       0,     0,   344,     0,  1418,   344,     0,     0,   564,     0,
       0,  2288,  1418,     0,     0,     0,     0,   581,   344,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     968,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     344,  1427,     0,     0,     0,     0,  2288,     0,     0,     0,
    1422,     0,     0,     0,     0,   581,     0,     0,     0,     0,
    1594,     0,  3143,     0,     0,     0,  1418,     0,     0,     0,
       0,     0,     0,   581,     0,  1422,     0,   564,     0,     0,
    1597,     0,   991,     0,     0,  1598,     0,  1418,     0,  1421,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3143,     0,     0,     0,  3138,  1422,     0,
       0,     0,     0,  1594,  1418,     0,     0,     0,     0,     0,
    1631,  1929,     0,     0,     0,     0,  1595,     0,     0,  3143,
       0,     0,     0,  1597,     0,  1422,  1418,     0,  1598,  1427,
       0,     0,     0,     0,   344,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1422,     0,     0,     0,     0,   564,     0,   564,     0,     0,
       0,   564,     0,     0,     0,     0,   564,   564,  1594,     0,
       0,     0,  1599,     0,   564,  1419,  1600,     0,     0,     0,
       0,  1595,     0,  1422,   564,     0,   564,  1422,  1597,     0,
       0,     0,     0,  1598,  1601,  1602,  1419,     0,  1419,     0,
       0,     0,   564,     0,   564,     0,  1603,     0,     0,     0,
       0,     0,  1419,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1599,     0,     0,   344,  1600,
    1604,     0,  1418,  1605,     0,  1498,  1419,     0,     0,     0,
       0,  2077,     0,     0,     0,     0,  1606,  1601,  1602,     0,
       0,  1929,     0,     0,  1419,     0,     0,     0,     0,  1603,
       0,  1421,     0,     0,   344,     0,     0,   344,   564,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1604,     0,     0,  1605,     0,     0,     0,
    1599,     0,     0,     0,  1600,  1419,     0,     0,     0,  1606,
    1418,  1607,  1608,     0,     0,  1427,  1419,     0,  1422,     0,
       0,     0,  1601,  1602,  1419,     0,     0,     0,     0,     0,
       0,     0,  1421,     0,  1603,     0,     0,  1421,     0,     0,
       0,     0,     0,     0,     0,   564,     0,     0,     0,     0,
       0,   564,  1421,     0,     0,     0,     0,     0,  1604,     0,
     580,  1605,     0,     0,     0,  1608,     0,     0,     0,     0,
       0,     0,     0,     0,  1606,  1609,  1607,     0,  1419,     0,
       0,     0,     0,     0,     0,  1610,  1611,  1612,     0,  1613,
    1614,  1615,  1616,  1617,  1618,     0,     0,  1594,     0,  1419,
       0,     0,     0,     0,     0,     0,  1421,     0,  1418,     0,
    1595,     0,     0,     0,     0,     0,   564,  1597,     0,   564,
     564,     0,  1598,     0,     0,     0,  1419,     0,  1609,     0,
    1608,     0,     0,     0,     0,     0,     0,     0,  1610,  1611,
    1612,     0,  1613,  1614,  1615,  1616,  1617,  1618,  1419,  1427,
     564,   581,  2016,     0,     0,     0,     0,     0,     0,  1424,
       0,     0,     0,     0,     0,   564,     0,     0,     0,   564,
       0,     0,     0,   564,     0,     0,     0,     0,     0,     0,
       0,   564,     0,     0,     0,     0,   564,     0,     0,     0,
       0,     0,  1424,  1609,     0,     0,     0,     0,     0,   564,
    1422,     0,     0,  1610,  1611,  1612,     0,  1613,  1614,  1615,
    1616,  1617,  1618,     0,     0,     0,     0,  2542,     0,  1599,
       0,   564,     0,  1600,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1601,  1602,     0,     0,     0,   580,  1498,     0,     0,
    2304,     0,  1502,  1603,  1419,     0,     0,     0,     0,     0,
       0,  1422,     0,     0,     0,     0,  1422,     0,     0,     0,
       0,     0,     0,  1427,     0,     0,     0,  1604,     0,     0,
    1605,  1422,     0,   564,  1418,     0,     0,     0,     0,     0,
       0,     0,     0,  1606,     0,  1607,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   344,     0,     0,
       0,   344,     0,     0,     0,   966,     0,     0,     0,   966,
       0,     0,  1419,     0,     0,     0,     0,     0,     0,     0,
       0,  1427,     0,     0,     0,  1422,     0,     0,     0,     0,
    1421,     0,     0,     0,     0,     0,   966,     0,     0,  1608,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1421,     0,  1421,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1421,  1058,     0,
       0,   966,     0,     0,     0,     0,     0,   966,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1421,  1929,     0,     0,   564,     0,   564,     0,     0,
       0,     0,  1609,     0,     0,     0,     0,     0,  1418,  1421,
    1419,     0,  1610,  1611,  1612,     0,  1613,  1614,  1615,  1616,
    1617,  1618,     0,     0,     0,     0,  2672,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1424,   753,     0,     0,     0,
    1421,     0,     0,     0,     0,     0,     0,   754,     0,     0,
       0,  1421,     0,  1209,     0,   581,     0,     0,     0,  1421,
    1424,     0,     0,     0,     0,   755,     0,     0,     0,     0,
       0,     0,     0,   344,     0,   564,  1594,     0,     0,     0,
       0,   564,   564,   756,     0,     0,     0,     0,     0,  1595,
       0,     0,     0,  1424,     0,     0,  1597,   757,     0,     0,
       0,  1598,     0,     0,     0,     0,     0,     0,     0,   564,
     564,     0,     0,  1421,   758,     0,     0,     0,   564,     0,
    1424,     0,  1418,     0,     0,     0,   564,     0,     0,     0,
       0,   564,     0,   564,  1421,     0,     0,     0,     0,     0,
       0,     0,   759,   564,   564,  1424,   760,     0,     0,  1422,
       0,     0,     0,     0,     0,     0,     0,     0,   761,     0,
       0,  1421,     0,     0,     0,     0,     0,     0,     0,     0,
    1422,     0,  1422,     0,     0,     0,  1419,     0,  1424,     0,
    1418,     0,  1424,  1421,     0,     0,  1422,     0,     0,     0,
       0,     0,     0,     0,   580,     0,     0,     0,  1599,     0,
       0,     0,  1600,     0,     0,     0,     0,     0,     0,     0,
    1422,     0,     0,   344,     0,     0,   966,     0,     0,     0,
    1601,  1602,   966,     0,     0,   762,     0,     0,  1422,     0,
       0,     0,  1603,     0,     0,     0,     0,     0,  1432,     0,
       0,     0,  1594,     0,   763,     0,     0,   564,     0,     0,
       0,     0,     0,   564,     0,  1595,  1604,     0,     0,  1605,
       0,   966,  1597,     0,     0,     0,   764,  1598,   765,  1422,
       0,  1432,  1606,   766,  1607,     0,     0,     0,     0,     0,
    1422,     0,     0,     0,     0,  1425,     0,     0,  1422,  1421,
       0,     0,     0,     0,     0,   767,   768,     0,     0,   564,
       0,     0,     0,  1424,     0,     0,     0,     0,   769,     0,
    1419,     0,     0,   770,     0,     0,     0,     0,  1425,     0,
       0,     0,     0,   771,     0,     0,  1209,     0,  1608,     0,
       0,   772,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1422,     0,     0,     0,     0,     0,  1209,     0,
       0,     0,     0,     0,     0,     0,     0,  1421,     0,     0,
       0,     0,     0,  1422,  1599,     0,     0,     0,  1600,     0,
       0,     0,  1209,  1209,     0,  1209,  1209,  1209,     0,     0,
       0,     0,     0,     0,     0,     0,  1601,  1602,     0,     0,
    1422,  1609,     0,     0,     0,  1209,     0,     0,  1603,     0,
       0,  1610,  1611,  1612,     0,  1613,  1614,  1615,  1616,  1617,
    1618,     0,  1422,     0,     0,  2737,     0,     0,     0,     0,
     581,   581,  1604,     0,     0,  1605,     0,     0,     0,     0,
     564,   564,     0,     0,  1419,     0,  1658,     0,  1606,     0,
    1607,     0,     0,     0,     0,   564,     0,     0,     0,     0,
     564,   564,   564,   564,   564,  1421,     0,     0,     0,     0,
    1209,     0,     0,  1209,  1209,     0,     0,     0,     0,     0,
       0,   344,   344,   344,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1424,     0,     0,     0,     0,
       0,   581,  1419,     0,  1608,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   564,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1422,  2304,
       0,     0,   344,     0,     0,     0,     0,     0,     0,   344,
    1209,   344,     0,     0,  1432,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1424,     0,     0,     0,
       0,  1424,     0,     0,     0,     0,     0,  1609,     0,  1432,
       0,     0,     0,     0,     0,     0,  1424,  1610,  1611,  1612,
       0,  1613,  1614,  1615,  1616,  1617,  1618,     0,     0,  2734,
       0,  1425,     0,     0,     0,     0,  1422,     0,     0,     0,
       0,     0,  1432,     0,     0,     0,  1594,     0,     0,     0,
       0,     0,     0,   344,     0,     0,  1425,     0,     0,  1595,
       0,     0,     0,     0,     0,     0,  1597,     0,     0,  1432,
    1424,  1598,     0,     0,     0,  1929,   564,     0,     0,     0,
       0,  1421,     0,     0,     0,     0,     0,     0,     0,  1425,
       0,     0,     0,     0,  1432,     0,     0,     0,     0,     0,
     564,     0,     0,     0,     0,   564,     0,   564,   564,     0,
       0,     0,   564,     0,     0,     0,  1425,     0,     0,     0,
       0,     0,     0,     0,     0,  1209,     0,  1432,     0,     0,
       0,  1432,     0,     0,  1422,     0,     0,     0,     0,     0,
       0,  1425,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1594,     0,     0,
       0,   564,   966,     0,     0,     0,     0,   564,  1599,     0,
    1595,   564,  1600,     0,  1425,     0,     0,  1597,  1425,     0,
       0,     0,  1598,     0,     0,     0,     0,     0,  1209,  1209,
    1601,  1602,     0,     0,     0,     0,  1209,     0,     0,  1209,
    1209,     0,  1603,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1982,     0,     0,  1421,     0,     0,     0,  1209,
       0,   667,     0,  1209,  1209,  1209,  1604,  1209,     0,  1605,
       0,     0,     0,     0,  1209,  1209,     0,     0,     0,     0,
       0,     0,  1606,   667,  1607,     0,     0,     0,     0,     0,
       0,     0,  1432,  1209,   344,     0,  1209,  1209,     0,     0,
       0,  1209,     0,     0,     0,  1209,     0,   564,  1209,  1209,
    1209,  1209,  1209,  1209,  1209,  1209,  1209,     0,  1209,  1599,
       0,     0,  1209,  1600,     0,     0,  1209,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1608,  1425,
       0,  1601,  1602,     0,  1424,     0,     0,     0,     0,     0,
    1422,     0,     0,  1603,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1424,     0,  1424,     0,     0,
       0,   344,     0,     0,     0,     0,     0,  1604,     0,  1421,
    1605,  1424,     0,     0,     0,     0,     0,   667,     0,     0,
       0,     0,     0,  1606,     0,  1607,     0,     0,     0,     0,
       0,  1609,     0,     0,   344,  1424,   344,     0,     0,     0,
       0,  1610,  1611,  1612,     0,  1613,  1614,  1615,  1616,  1617,
    1618,  1594,     0,  1424,     0,  2846,     0,     0,     0,     0,
       0,     0,     0,   564,  1595,     0,     0,  1421,     0,     0,
       0,  1597,     0,     0,     0,     0,  1598,     0,     0,  1608,
       0,     0,     0,     0,     0,   564,     0,     0,     0,   564,
       0,     0,     0,     0,  1424,  1209,     0,     0,     0,     0,
       0,     0,     0,     0,  2153,  1424,     0,     0,     0,     0,
       0,     0,     0,  1424,  1422,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   564,   564,     0,     0,     0,   564,
       0,     0,  1609,     0,     0,     0,     0,     0,     0,     0,
       0,  1425,  1610,  1611,  1612,     0,  1613,  1614,  1615,  1616,
    1617,  1618,     0,     0,     0,  1432,  2862,  1424,     0,  1594,
    1432,     0,     0,  1599,     0,     0,     0,  1600,     0,     0,
     564,     0,     0,  1209,     0,  1432,     0,     0,  1424,  1597,
       0,     0,     0,     0,  1598,  1601,  1602,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   564,  1603,     0,     0,
       0,     0,  1425,     0,     0,  1424,     0,  1425,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    71,
       0,  1604,  1425,     0,  1605,     0,     0,  1424,  1422,  1432,
       0,     0,     0,     0,     0,     0,     0,  1606,     0,  1607,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2689,     0,     0,     0,     0,     0,     0,     0,
    1209,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1425,     0,     0,     0,
    1209, -1714,     0,     0,     0,  1600,  1422,     0,     0,     0,
       0,     0,     0,  1608,     0,     0,     0,     0,     0,   549,
       0,     0,     0,  1601,  1602,     0,   573,     0,     0,  1209,
    1209,  1209,     0,     0,  1209, -1714,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1209,  1209,  1209,  1209,
       0,     0,     0,  1424,     0,  1209,     0,     0,     0,     0,
       0,     0,  1605,     0,   573,     0,  1209,     0,     0,     0,
       0,     0,     0,     0,     0,  1606,  1609,  1209,  1209,     0,
    1209,     0,   573,     0,  1209,     0,  1610,  1611,  1612,     0,
    1613,  1614,  1615,  1616,  1617,  1618,     0,     0,     0,     0,
    3017,     0,     0,     0,     0,     0,     0,   966,     0,  1209,
    1209,     0,   549,     0,     0,     0,     0,     0,     0,     0,
       0,  1424,     0,     0,     0,     0,     0,     0,     0,     0,
       0, -1714,     0,     0,  1209,     0,     0,     0,     0,     0,
       0,  1209,  1209,  1209,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1209,     0,     0,     0,     0,
       0,  1209,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1432,     0,     0,     0,     0,     0,  1426,
     667,     0,     0,     0,  1609,     0,     0,     0,   963,     0,
       0,     0,   963,     0,  1432,     0,  1432,     0,  1613,  1614,
    1615,  1616,  1617,  1618,     0,     0,     0,     0,     0,  1424,
    1432,     0,  1426,     0,     0,     0,     0,     0,     0,   963,
    1425,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1432,     0,     0,     0,     0,     0,
       0,  1425,     0,  1425,     0,     0,     0,     0,   563,     0,
       0,   344,  1432,     0,   963,     0,     0,  1425,     0,     0,
     963,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1425,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1432,     0,     0,     0,     0,     0,  1425,
       0,     0,     0,     0,  1432,     0,     0,     0,     0,     0,
       0,     0,  1432,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   799,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   966,     0,     0,     0,     0,
    1425,   563,     0,   799,     0,     0,  1204,     0,     0,     0,
       0,  1425,     0,     0,     0,     0,     0,  1209,     0,  1425,
       0,     0,     0,  1209,     0,     0,  1432,     0,     0,     0,
       0,     0,     0,     0,     0,  1209,     0,  1209,     0,     0,
       0,  1209,     0,     0,     0,  1424,     0,  1432,  1209,     0,
       0,  1209,  1209,  1209,  1209,  1209,  1209,  1209,  1209,  1209,
    1209,     0,     0,     0,     0,  1209,  1209,     0,     0,     0,
       0,     0,     0,  1425,  1432,     0,     0,     0,     0,  1209,
       0,     0,     0,     0,     0,     0,  1209,  1209,  1209,     0,
    1209,     0,     0,     0,  1425,     0,  1432,  1209,     0,     0,
       0,     0,  1209,     0,     0,  1209,     0,     0,     0,     0,
     573,     0,     0,     0,   966,     0,     0,     0,     0,     0,
       0,  1425,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1594,     0,     0,     0,  1426,     0,     0,     0,     0,
       0,     0,     0,  1425,     0,     0,     0,     0,     0,     0,
       0,  1597,     0,     0,     0,     0,  1598,  1209,     0,  1429,
    1426,     0,  1594,     0,     0,     0,   667,     0,     0,   963,
       0,     0,     0,     0,     0,   963,     0,     0,     0,  1424,
       0,     0,  1597,     0,     0,     0,     0,  1598,     0,     0,
       0,  1430,  1429,  1426,     0,     0,     0,     0,     0,     0,
       0,     0,  1432,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   963,     0,     0,     0,     0,     0,
    1426,     0,     0,     0,  1430,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1426,    71,     0,     0,  1425,
       0,     0,     0,  1599,     0,     0,     0,  1600,     0,  1209,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1432,     0,     0,     0,     0,  1601,  1602,     0,  1426,  1204,
       0,     0,  1426,     0,  1599,     0,     0,  1603,  1600,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1204,     0,  1424,     0,     0,  1601,  1602,     0,     0,
       0,     0,     0,  1209,  1605,     0,     0,  1425,  1603,     0,
       0,     0,     0,  1209,     0,  1204,  1204,  1606,  1204,  1204,
    1204,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1605,     0,     0,  1204,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1606,     0,
       0,  1424,     0,     0,     0,     0,     0,     0,  1432,     0,
       0,     0,  1209,  1209,  1209,     0,     0,  1209,     0,     0,
       0,     0,     0,  1608,     0,     0,     0,     0,     0,     0,
       0,   966,     0,     0,     0,   966,     0,     0,     0,   966,
       0,     0,     0,  1426,     0,   344,     0,     0,     0,     0,
       0,     0,     0,  1204,  1608,  1425,  1204,  1204,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   573,     0,     0,     0,   549,     0,
       0,     0,     0,     0,     0,     0,  1609,     0,     0,     0,
       0,     0,     0,     0,     0,  1429,  1610,  1611,  1612,     0,
    1613,  1614,  1615,  1616,  1617,  1618,     0,     0,  1209,     0,
       0,     0,     0,     0,     0,     0,     0,  1609,     0,     0,
    1429,     0,     0,  1204,   667,     0,     0,  1430, -1714, -1714,
       0,  1613,  1614,  1615,  1616,  1617,  1618,     0,     0,     0,
       0,     0,   966,     0,     0,     0,     0,     0,     0,     0,
     549,   549,  1430,  1429,     0,     0,     0,     0,     0,    71,
      71,     0,    71,     0,     0,     0,     0,  1306,  1209,     0,
       0,     0,     0,     0,     0,     0,     0,  1209,     0,  1209,
    1429,     0,     0,     0,  1432,  1430,     0,     0,  1209,     0,
       0,     0,     0,     0,     0,     0,   667,     0,     0,   966,
       0,     0,     0,     0,   966,  1429,     0,     0,   966,     0,
       0,     0,  1430,  1209,  1209,     0,     0,     0,     0,     0,
       0,     0,     0,  1209,     0,  1426,     0,     0,     0,     0,
       0,  1425,     0,     0,     0,     0,     0,  1430,  1429,     0,
    1209,     0,  1429,     0,     0,     0,   799,     0,   799,     0,
     799,     0,     0,     0,   966,     0,   799,   799,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1204,     0,
    1430,     0,     0,     0,  1430,     0,     0,     0,     0,  1209,
       0,     0,     0,   718,     0,     0,  1426,     0,     0,     0,
       0,  1426,     0,     0,   719,     0,     0,     0,     0,     0,
    1209,   549,     0,     0,     0,   963,  1426,     0,     0,  1209,
       0,     0,   720,   966,     0,     0,     0,   563,  1432,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   721,     0,
    -428,  1204,  1204,     0,     0,     0,     0,     0,     0,  1204,
       0,     0,  1204,  1204,   722,     0,     0,     0,     0,     0,
     723,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1426,   724,  1204,  1429,   966,  1425,  1204,  1204,  1204,     0,
    1204,     0,     0,  1279,     0,     0,     0,  1204,  1204,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1209,   563,
     563,   725,     0,   726,     0,  1430,  1204,   667,   549,  1204,
    1204,     0,     0,     0,  1204,  -537,  1279,     0,  1204,   549,
       0,  1204,  1204,  1204,  1204,  1204,  1204,  1204,  1204,  1204,
       0,  1204,     0,     0,     0,  1204,  -361,     0,     0,  1204,
       0,     0,     0,     0,     0,     0,   727,     0,     0,   573,
     573,     0,  1432,     0,     0,  1594,     0,     0,     0,     0,
       0,     0,   549,     0,     0,  1306,     0,  1306,     0,  1306,
       0,     0,     0,     0,   966,  1597,     0,     0,     0,     0,
    1598,     0,   728,     0,   729,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1425,
       0,  -361,     0,     0,     0,     0,     0,   966,     0,     0,
    1432,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     573,     0,   549,     0,     0,   730,     0,     0,     0,     0,
    -265,     0,     0,     0,     0,     0,     0,    71,     0,     0,
       0,    71,     0,     0,     0,     0,     0,     0,  2860,     0,
     563,     0,  -265,   731,   732,  2149,   733,  1425,     0,     0,
       0,     0,     0,     0,     0,   734,     0,     0,     0,   735,
     736,  1594,     0,     0,   737,     0,     0, -1714,  1204,     0,
     738,  1600,     0,     0,  1595,     0,     0,  2151,     0,     0,
       0,  1597,     0,     0,     0,     0,  1598,     0,     0,  1601,
    1602,     0,     0,     0,  1426,     0,     0,     0,     0,     0,
       0, -1714,     0,     0,     0,     0,  1429,     0,     0,     0,
       0,  1429,     0,     0,     0,  1426,     0,  1426,     0,     0,
       0,     0,     0,     0,     0,     0,  1429,     0,  1605,     0,
       0,  1426,     0,     0,     0,     0,     0,   563,  1430,     0,
       0,  1606,     0,  1430,     0,     0,     0,     0,   563,     0,
       0,     0,     0,     0,     0,  1426,  1204,     0,  1430,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   671,
       0,     0,     0,  1426,     0,     0,     0,     0,     0,   673,
    1429,     0,   549,  1599,     0,     0,     0,  1600,     0,     0,
       0,   563,     0,     0,  1279,     0,  1279, -1714,  1279,     0,
       0,     0,     0,     0,     0,  1601,  1602,     0,     0,     0,
       0,     0,  1430,   706,  1426,     0,     0,  1603,     0,     0,
       0,     0,     0,   747,     0,  1426,   751,     0,     0,     0,
     747,     0,     0,  1426,   795,     0,     0,     0,     0,     0,
       0,  1604,     0,  1204,  1605,     0,     0,     0,     0,     0,
       0,   563,     0,     0,   825,     0,     0,  1606,     0,  1607,
    1609,     0,   799,  1204,     0,     0,     0,     0,     0,   747,
       0,     0,     0,     0,  1613,  1614,  1615,  1616,  1617,  1618,
       0,   549,     0,     0,     0,     0,     0,  1426,     0,     0,
       0,     0,  1204,  1204,  1204,     0,     0,  1204,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1426,  1204,
    1204,  1204,  1204,  1608,     0,     0,     0,     0,  1204,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1204,
       0,     0,     0,     0,     0,  1426,     0,     0,     0,     0,
    1204,  1204,     0,  1204,     0,     0,     0,  1204,     0,     0,
       0,     0,  1279,     0,     0,     0,     0,  1426,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     963,     0,  1204,  1204,     0,     0,  1609,     0,     0,     0,
       0,     0,     0,   549,     0,     0,  1610,  1611,  1612,     0,
    1613,  1614,  1615,  1616,  1617,  1618,     0,  1204,     0,     0,
    3085,     0,     0,     0,  1204,  1204,  1204,  1594,     0,     0,
       0,     0,     0,     0,  2149,     0,     0,     0,     0,     0,
    1595,   563,     0,     0,  2097,     0,     0,  1597,  1204,   917,
       0,     0,  1598,     0,  1204,  1429,     0,  1429,     0,     0,
       0,     0,     0,     0,     0,     0,  1430,     0,     0,     0,
       0,  1429,     0,     0,     0,     0,   549,     0,     0,     0,
       0,     0,     0,  1426,     0,     0,  1306,  1430,    71,  1430,
      71,     0,     0,     0,     0,  1429,     0,     0,     0,     0,
       0,     0,     0,  1430,     0,     0,     0,     0,     0,  2098,
       0,     0,     0,  2149,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1430,     0,   799,
       0,   799,     0,     0,     0,   799,     0,     0,     0,     0,
     563,   799,     0,     0,   667,  1430,     0,     0,   799,  1599,
       0,  1426,     0,  1600,  1429,     0,     0,     0,   799,     0,
     799,     0,     0,     0,     0,  1429,     0,     0,     0,     0,
       0,  1601,  1602,  2149,  2199,     0,   799,     0,   799,     0,
       0,     0,     0,  1603,     0,     0,  1430,     0,     0,     0,
     549,     0,     0,     0,   549,     0,     0,  1430,   549,     0,
       0,     0,     0,     0,     0,  1430,  2233,  1604,     0,     0,
    1605,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1606,     0,  1607,     0,  1429,   963,     0,
       0,     0,  2260,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   563,     0,     0,     0,   549,     0,  1429,  1426,
    1204,     0,     0,     0,     0,     0,  1204,     0,     0,  1430,
       0,     0,     0,     0,   925,   926,     0,     0,  1204,     0,
    1204,     0,     0,     0,  1204,  1429,     0,     0,     0,  1608,
    1430,  1204,     0,     0,  1204,  1204,  1204,  1204,  1204,  1204,
    1204,  1204,  1204,  1204,     0,     0,     0,  1429,  1204,  1204,
       0,     0,     0,     0,     0,     0,     0,  1430,     0,  1279,
       0,     0,  1204,     0,     0,   563,     0,     0,     0,  1204,
    1204,  1204,  2099,  1204,     0,  1279,     0,     0,     0,  1430,
    1204,     0,     0,     0,     0,  1204,     0,     0,  1204,     0,
       0,     0,  1609,     0,     0,     0,     0,   963,     0,     0,
       0,     0,  1610,  1611,  1612,     0,  1613,  1614,  1615,  1616,
    1617,  1618,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1279,     0,     0,  1279,  1279,     0,     0,     0,     0,     0,
    1204,   976,     0,   992,     0,     0,   995,   996,     0,     0,
       0,     0,     0,  1429,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   799,     0,  1029,     0,     0,     0,
       0,     0,     0,     0,     0,  1426,     0,     0,  1044,   563,
       0,  1045,  1306,   563,     0,  1430,     0,   563,     0,     0,
       0,     0,   917,   747,     0,   799,     0,     0,     0,     0,
     799,  1062,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1069,     0,   799,     0,  1070,  1071,     0,     0,     0,
       0,  1429,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   563,     0,     0,     0,  1090,
       0,  1091,  1204,     0,     0,     0,     0,   917,     0,     0,
       0,     0,     0,  1430,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1104,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   917,  1204,   799,  2521,     0,
       0,     0,     0,     0,   549,   549,  1204,     0,     0,  1426,
       0,     0,     0,   549,     0,     0,     0,     0,     0,  1429,
       0,  1306,     0,     0,     0,     0,     0,     0,  2233,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2558,   549,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1430,     0,     0,     0,  1204,  1204,  1204,     0,     0,
    1204,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   963,     0,     0,     0,   963,     0,
       0,     0,   963,     0,     0,     0,     0,     0,   667,     0,
       0,     0,     0,     0,     0,  1315,     0,     0,  1317,     0,
       0,  1319,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   799,
       0,  1279,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1426,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1204,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1389,     0,     0,     0,  1390,
       0,     0,     0,  1392,     0,     0,     0,     0,  1433,     0,
       0,     0,     0,     0,     0,   963,     0,     0,     0,     0,
       0,  1426,     0,     0,   549,  1429,     0,     0,     0,     0,
       0,  1460,     0,     0,     0,     0,     0,     0,     0,  1279,
       0,  1204,     0,     0,     0,  1279,  1279,     0,     0,     0,
    1204,     0,  1204,     0,     0,     0,     0,  1430,     0,     0,
       0,  1204,     0,     0,     0,     0,  1492,     0,     0,     0,
       0,     0,   963,   563,   563,     0,     0,   963,     0,  1520,
       0,   963,   563,     0,     0,     0,  1204,  1204,     0,     0,
    1279,     0,     0,     0,     0,   799,  1204,   799,     0,     0,
       0,     0,     0,     0,     0,     0,    71,  2560,   563,     0,
       0,     0,     0,  1204,     0,     0,     0,     0,   961,     0,
       0,     0,   961,     0,     0,  1594,     0,   963,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1595,     0,
       0,     0,     0,     0,     0,  1597,     0,     0,     0,   961,
    1598,     0,  1204,     0,     0,   549,   549,     0,     0,  1429,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1204,     0,  2233,  2233,  2233,  2233,  2233,
       0,     0,  1204,     0,   961,     0,   963,     0,     0,     0,
     961,  1430,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   799,     0,     0,     0,     0,     0,   799,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   549,
       0,  2377,     0,     0,     0,     0,  2378,   963,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1599,     0,     0,
       0,  1600,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1204,     0,   563,     0,     0,     0,     0,     0,  1601,
    1602,     0,     0,     0,     0,     0,  1201,     0,     0,     0,
       0,  1603,     0,  1429,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1742,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1604,     0,     0,  1605,     0,
       0,     0,     0,     0,     0,  1430,     0,     0,     0,     0,
       0,  1606,     0,  1607,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   963,     0,     0,
       0,  1429,     0,     0,     0,     0,     0,     0,     0,     0,
    2891,   549,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     963,     0,     0,  1430,     0,     0,     0,  1608,     0,     0,
     549,     0,   549,   549,     0,     0,     0,   549,     0,     0,
       0,     0,     0,     0,   563,   563,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   799,
       0,     0,     0,     0,   799,   799,   799,   799,   799,  1882,
       0,  1884,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   549,     0,     0,   961,
    1609,     0,   549,     0,     0,   961,   549,     0,     0,     0,
    1610,  1611,  1612,     0,  1613,  1614,  1615,  1616,  1617,  1618,
       0,  1428,  1922,     0,     0,     0,     0,     4,   563,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     5,     0,   961,     0,     0,     0,     0,     0,
       0,     6,     0,     0,  1428,     0,     0,     0,     0,     0,
       0,     0,     7,     8,     0,     0,     0,     0,     9,     0,
      10,    11,     0,     0,     0,    12,    13,    14,    15,    16,
      17,    18,    19,    20,    21,    22,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    34,    35,     0,
       0,     0,   549,     0,     0,     0,     0,     0,     0,  1201,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1201,     0,     0,     0,     0,     0,    36,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     563,     0,     0,     0,     0,  1201,  1201,     0,  1201,  1201,
    1201,     0,     0,     0,     0,     0,  2076,     0,     0,     0,
       0,     0,     0,     0,   799,     0,     0,     0,  1201,   563,
       0,   563,   563,  2081,     0,     0,   563,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    37,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      38,     0,     0,     0,     0,     0,     0,     0,   549,     0,
       0,     0,     0,     0,     0,   563,     0,    39,     0,     0,
       0,   563,     0,  1201,     0,   563,  1201,  1201,     0,     0,
     549,  3100,     0,     0,   549,  3104,     0,     0,     0,     0,
       0,     0,     0,     0,    40,     0,     0,    41,     0,     0,
       0,     0,     0,     0,     0,   917,     0,     0,     0,     0,
       0,     0,     0,     0,    42,     0,     0,     0,     0,     0,
    2130,     0,     0,     0,     0,  2134,     0,     0,     0,     0,
       0,  2138,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1201,     0,     0,     0,  1428,     0,     0,
    2160,  2161,     0,  2163,     0,     0,     0,     0,     0,     0,
    2170,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      43,   563,  1428,     0,  2184,     0,  2186,     0,  2188,  2189,
       0,     0,     0,  2194,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    44,     0,  1428,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    45,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    46,     0,
       0,     0,  1428,     0,     0,     0,     0,     0,     0,    47,
       0,     0,    48,    49,     0,    50,     0,    51,     0,     0,
       0,    52,     0,    53,    54,     0,     0,  1428,    55,    56,
      57,    58,    59,     0,     0,    60,    61,    62,    63,     0,
      64,    65,    66,    67,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1201,     0,
    1428,   917,     0,     0,  1428,     0,     0,   563,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   563,
       0,     0,     0,   563,    78,   961,     0,     0,     0,     0,
      82,     0,     0,     0,     0,     0,     0,     0,    88,     0,
      89,     0,     0,    92,     0,     0,     0,     0,     0,     0,
       0,  1201,  1201,     0,   102,     0,     0,     0,     0,  1201,
       0,     0,  1201,  1201,     0,     0,     0,     0,   799,   799,
       0,     0,   114,   115,     0,     0,     0,     0,     0,     0,
       0,     0,  1201,     0,     0,     0,  1201,  1201,  1201,     0,
    1201,     0,     0,     0,     0,     0,     0,  1201,  1201,   123,
       0,     0,     0,     0,     0,     0,     0,     0,   124,   125,
     126,     0,     0,     0,     0,  1428,  1201,     0,     0,  1201,
    1201,     0,   876,     0,  1201,     0,     0,     0,  1201,     0,
       0,  1201,  1201,  1201,  1201,  1201,  1201,  1201,  1201,  1201,
     135,  1201,   136,   137,     0,  1201,     0,   139,   140,  1201,
       0,     0,     0,     0,   142,   143,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   145,     0,   146,     0,
       0,   149,     0,  1594,     0,     0,     0,   150,     0,     0,
       0,     0,     0,     0,     0,   151,  1595,     0,     0,  1596,
     152,     0,     0,  1597,     0,   153,     0,   155,  1598,     0,
       0,   157,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   161,     0,   162,     0,     0,     0,     0,     0,
       0,     0,  2501,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   166,     0,     0,     0,     0,  1594,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1595,     0,     0,  2338,   174,   175,     0,  1597,
     176,     0,   964,     0,  1598,     0,   964,   177,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     182,     0,     0,     0,     0,     0,     0,     0,  1201,     0,
       0,     0,     0,   964,     0,  1599,     0,  2148,     0,  1600,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   192,
    2564,  2566,  2568,     0,     0,     0,     0,  1601,  1602,     0,
     194,     0,   195,     0,     0,     0,   196,     0,   964,  1603,
     197,     0,   199,     0,   964,     0,   201,     0,     0,     0,
       0,   202,     0,     0,     0,     0,   203,     0,  2601,   205,
       0,     0,     0,  1604,     0,   208,  1605,     0,  1428,   747,
       0,  1599,     0,  1428,     0,  1600,     0,     0,     0,  1606,
       0,  1607,     0,     0,     0,     0,  1201,     0,  1428,     0,
     214,     0,   215,  1601,  1602,     0,     0,     0,   217,     0,
     218,     0,     0,     0,   219,  1603,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1604,
    1205,     0,  1605,     0,     0,  1608,     0,     0,     0,     0,
       0,     0,  1428,     0,     0,  1606,   224,  1607,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1594,  1201,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1595,     0,     0,     0,     0,
       0,     0,  1597,  1201,     0,     0,     0,  1598,  1609,     0,
       0,  1608,     0,     0,     0,     0,     0,     0,  1610,  1611,
    1612,     0,  1613,  1614,  1615,  1616,  1617,  1618,  1594,     0,
       0,     0,  1201,  1201,  1201,     0,     0,  1201,     0,     0,
       0,  1595,     0,     0,  2386,     0,     0,     0,  1597,  1201,
    1201,  1201,  1201,  1598,     0,     0,     0,     0,  1201,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1201,
       0,     0,     0,     0,  1609,     0,     0,     0,     0,     0,
    1201,  1201,     0,  1201,  1610,  1611,  1612,  1201,  1613,  1614,
    1615,  1616,  1617,  1618,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   964,  1599,  2751,  2752,     0,  1600,   964,
     961,     0,  1201,  1201,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1431,  1601,  1602,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1201,  1603,     0,
       0,     0,     0,     0,  1201,  1201,  1201,     0,   964,     0,
    1599,     0,     0,     0,  1600,     0,     0,  2781,  1431,     0,
       0,     0,  1604,     0,     0,  1605,     0,     0,  1201,     0,
       0,     0,  1601,  1602,  1201,     0,     0,     0,  1606,     0,
    1607,     0,     0,     0,  1603,     0,  1428,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1428,  1604,  1428,
       0,  1605,     0,  1205,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1428,  1606,     0,  1607,     0,     0,     0,
       0,     0,     0,     0,  1608,  1205,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1428,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1205,
    1205,     0,  1205,  1205,  1205,  1428,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2340,     0,     0,
    1608,     0,  1205,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1609,     0,     0,
       0,     0,     0,     0,     0,     0,  1428,  1610,  1611,  1612,
       0,  1613,  1614,  1615,  1616,  1617,  1618,  1428,     0,     0,
       0,     0,     0,  2900,     0,  1428,     0,     0,     0,     0,
    2906,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1609,     0,     0,     0,  1205,   961,     0,
    1205,  1205,  1594,  1610,  1611,  1612,     0,  1613,  1614,  1615,
    1616,  1617,  1618,     0,     0,  1595,     0,     0,     0,     0,
    1201,     0,  1597,     0,     0,     0,  1201,  1598,     0,  1428,
       0,     0,     0,     0,     0,     0,     0,     0,  1201,     0,
    1201,     0,     0,     0,  1201,     0,     0,     0,     0,     0,
    1428,  1201,     0,     0,  1201,  1201,  1201,  1201,  1201,  1201,
    1201,  1201,  1201,  1201,     0,     0,     0,  1205,  1201,  1201,
       0,  1431,     0,     0,     0,     0,     0,  1428,     0,     0,
       0,     0,  1201,     0,     0,     0,     0,     0,     0,  1201,
    1201,  1201,     0,  1201,     0,     0,  1431,     0,     0,  1428,
    1201,     0,  1594,     0,     0,  1201,     0,     0,  1201,     0,
       0,     0,     0,     0,     0,  1595,     0,   961,     0,     0,
       0,     0,  1597,     0,  1599,     0,     0,  1598,  1600,  1431,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1601,  1602,     0,     0,
       0,     0,     0,     0,     0,     0,  1431,     0,  1603,     0,
    1201,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1431,  1604,     0,     0,  1605,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1606,     0,
    1607,     0,     0,     0,     0,  1428,     0,     0,     0,  2353,
       0,     0,  1205,  2391,  1431,     0,     0,     0,  1431,     0,
       0,     0,     0,  1594,  1599,     0,     0,     0,  1600,     0,
       0,     0,     0,     0,     0,     0,  1595,     0,     0,     0,
       0,     0,     0,  1597,     0,     0,  1601,  1602,  1598,   964,
       0,     0,     0,     0,  1608,     0,     0,  3078,  1603,     0,
       0,     0,  1201,  3080,  1594,     0,     0,     0,     0,     0,
       0,     0,     0,  1428,     0,  1205,  1205,  1595,     0,     0,
       0,     0,  1604,  1205,  1597,  1605,  1205,  1205,  1183,  1598,
       0,     0,     0,     0,     0,     0,     0,     0,  1606,     0,
    1607,     0,     0,     0,     0,     0,  1205,     0,     0,     0,
    1205,  1205,  1205,     0,  1205,     0,  1201,  1609,     0,     0,
       0,  1205,  1205,     0,     0,     0,  1201,  1610,  1611,  1612,
       0,  1613,  1614,  1615,  1616,  1617,  1618,     0,     0,  1431,
    1205,     0,     0,  1205,  1205,  1599,     0,     0,  1205,  1600,
       0,     0,  1205,     0,  1608,  1205,  1205,  1205,  1205,  1205,
    1205,  1205,  1205,  1205,     0,  1205,     0,  1601,  1602,  1205,
       0,  1428,     0,  1205,     0,  1201,  1201,  1201,     0,  1603,
    1201,     0,     0,     0,     0,     0,  1599,     0,     0,     0,
    1600,     0,     0,     0,   961,     0,     0,     0,   961,     0,
       0,     0,   961,  1604,     0,     0,  1605,     0,  1601,  1602,
       0,     0,     0,     0,     0,     0,     0,  1609,     0,  1606,
    1603,  1607,     0,     0,     0,     0,     0,  1610,  1611,  1612,
       0,  1613,  1614,  1615,  1616,  1617,  1618,     0,     0,     0,
       0,     0,     0,     0,  1604,     0,     0,  1605,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1606,     0,  1607,     0,     0,     0,     0,     0,     0,     0,
       0,  1201,     0,     0,     0,  1608,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2635,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   961,     0,     0,     0,     0,
       0,     0,  1205,     0,     0,     0,  1608,     0,     0,     0,
       0,  2152,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1201,     0,     0,     0,     0,     0,     0,  1609,     0,
    1201,     0,  1201,     0,     0,     0,     0,  1428,  1610,  1611,
    1612,  1201,  1613,  1614,  1615,  1616,  1617,  1618,     0,     0,
       0,  1536,   961,     0,     0,     0,     0,   961,     0,     0,
       0,   961,     0,     0,     0,     0,  1201,  1201,     0,  1609,
       0,     0,  1431,  1560,     0,     0,  1201,  1431,     0,  1610,
    1611,  1612,     0,  1613,  1614,  1615,  1616,  1617,  1618,     0,
    1205,     0,  1431,  1201,     0,     0,     0,  1581,  1582,     0,
    1583,  1584,  1586,     0,     0,     0,     0,   961,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1622,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1201,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1431,     0,     0,     0,
       0,     0,     0,  1201,     0,     0,     0,     0,     0,     0,
       0,     0,  1201,     0,     0,     0,   961,     0,     0,     0,
       0,  1428,     0,     0,     0,     0,     0,  1205,     0,     0,
       0,     0,     0,     0,     0,  1688,     0,     0,  1694,  1696,
       0,     0,     0,     0,     0,     0,     0,  1205,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   961,     0,     0,
       0,     0,     0,     0,     0,     0,  1205,  1205,  1205,     0,
       0,  1205,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1201,     0,  1205,  1205,  1205,  1205,     0,     0,     0,
       0,     0,  1205,     0,     0,  1745,     0,     0,     0,     0,
       0,     0,     0,  1205,     0,     0,     0,     0,     0,     0,
    1620,     0,     0,     0,  1205,  1205,     0,  1205,     0,     0,
       0,  1205,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1428,     0,     0,     0,     0,
       0,     0,     0,     0,   964,     0,  1205,  1205,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   961,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1205,     0,     0,     0,     0,     0,     0,  1205,  1205,
    1205,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     961,     0,     0,  1428,     0,     0,     0,     0,     0,     0,
       0,     0,  1205,     0,     0,     0,     0,     0,  1205,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1431,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1909,  1431,     0,  1431,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1431,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1431,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1431,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1965,     0,     0,     0,  1967,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1986,     0,     0,     0,  1989,     0,
    1431,     0,  2000,     0,     0,     0,     0,     0,     0,  2007,
    2012,  1431,     0,     0,     0,     0,     0,     0,     0,  1431,
       0,     0,     0,     0,     0,     0,     0,     0,  2023,     0,
       0,     0,  2027,     0,     0,     0,  2038,     0,     0,     0,
    2045,     0,   964,  2047,  2048,  2049,  2050,  2051,  2052,  2053,
    2054,  2055,     0,  2056,     0,     0,     0,  1183,     0,     0,
       0,     0,     0,     0,  1205,     0,     0,     0,     0,     0,
    1205,     0,     0,  1431,     0,     0,     0,     0,     0,     0,
       0,     0,  1205,     0,  1205,     0,     0,     0,  1205,     0,
       0,     0,     0,     0,  1431,  1205,     0,     0,  1205,  1205,
    1205,  1205,  1205,  1205,  1205,  1205,  1205,  1205,     0,     0,
       0,     0,  1205,  1205,     0,     0,     0,     0,     0,     0,
       0,  1431,     0,  1620,     0,     0,  1205,     0,     0,     0,
       0,     0,     0,  1205,  1205,  1205,     0,  1205,     0,     0,
       0,     0,     0,  1431,  1205,     0,     0,  1620,     0,  1205,
       0,     0,  1205,  1996,     0,     0,     0,     0,     0,     0,
       0,   964,     0,     0,     0,     0,     0,     0,  1620,  1620,
    1620,  1620,     0,  1620,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1996,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2140,     0,     0,     0,  1205,     0,     0,     0,     0,  1620,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1431,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1620,     0,     0,     0,     0,
       0,  1620,     0,  1620,     0,     0,     0,     4,  2225,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     5,     0,     0,     0,  1205,     0,     0,     0,
       0,     6,     0,     0,     0,     0,     0,  1431,     0,     0,
       0,     0,     7,     8,     0,     0,     0,     0,     0,     0,
      10,    11,  1620,     0,     0,    12,    13,    14,    15,    16,
      17,    18,    19,    20,    21,    22,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    34,    35,     0,
    1205,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1205,     0,     0,     0,     0,  2314,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2334,     0,    36,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1431,     0,     0,     0,  1205,
    1205,  1205,     0,     0,  1205,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   964,     0,
       0,  2012,   964,  2012,  2012,     0,   964,     0,     0,     0,
    2394,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    37,     0,     0,     0,     0,     0,
       0,     0,     0,  2411,     0,  2413,     0,     0,     0,  2416,
      38,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1620,    39,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1205,     0,     0,     0,     0,
       0,     0,     0,     0,    40,     0,     0,    41,     0,  1688,
       0,     0,     0,     0,     0,     0,  1696,  1696,  1694,     0,
       0,     0,     0,  1620,    42,     0,     0,     0,     0,   964,
       0,     0,  1620,     0,  1620,     0,     0,     0,     0,     0,
    2488,     0,     0,     0,     0,     0,  2491,     0,     0,     0,
       0,     0,     0,  1620,     0,  1205,  1620,     0,  1996,  1996,
    1996,  2373,     0,  1996,  1205,     0,  1205,  1620,     0,     0,
       0,  1431,     0,     0,  1620,  1205,     0,     0,     0,  1620,
      43,     0,     0,     0,     0,     0,   964,     0,     0,     0,
    1620,   964,     0,  2373,  1620,   964,     0,     0,     0,     0,
    1205,  1205,     0,     0,     0,  1620,  1996,     0,     0,     0,
    1205,     0,  1620,    44,  1620,  1620,  1620,  1620,  1620,  1620,
    1620,  1620,  1620,  1620,     0,     0,    45,  1205,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    46,     0,
       0,   964,     0,     0,     0,     0,     0,     0,     0,    47,
       0,     0,    48,    49,     0,    50,     0,     0,     0,     0,
       0,    52,     0,    53,    54,     0,  1205,     0,    55,    56,
      57,    58,    59,     0,     0,    60,    61,   932,     0,     0,
       0,   933,     0,     0,     0,     0,     0,  1205,     0,     0,
       0,     0,     0,     0,     0,     0,  1205,     0,     0,     0,
     964,     0,     0,     0,     0,  1431,     0,  1620,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2632,     0,     0,     0,     0,     0,  2636,     0,
       0,   964,     0,     0,     0,     0,     0,     0,     0,     0,
    2641,     0,  2642,     0,     0,     0,  2644,     0,     0,     0,
       0,     0,     0,     0,     0,  1205,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2661,  2662,  1620,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2677,     0,  2679,     0,     0,     0,     0,
       0,     0,  2683,     0,     0,     0,     0,  2687,     0,  1431,
    2690,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   964,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1620,  2729,     0,   964,     0,     0,  1431,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1620,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2373,  2373,  2373,     0,  1996,     0,     0,
    1996,  1996,  1996,  1996,  1996,  1996,  1996,  1996,  1996,  1996,
       0,  2373,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     4,     0,
       0,  1620,     0,     0,     0,     0,  1996,     0,     0,     0,
       0,     0,     0,     5,     0,     0,     0,  2373,  1620,     0,
    1620,     0,     6,  1620,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     7,     8,     0,     0,     0,     0,     0,
       0,    10,    11,     0,     0,     0,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    34,    35,
       0,     0,     0,     0,     0,     0,     0,     0,  2314,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2842,     0,
       0,     0,     0,     0,     0,  1620,     0,     0,  1620,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    36,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2858,  2859,
       0,     0,  2861,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    37,     0,     0,  1996,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    38,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    39,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2930,     0,    40,     0,     0,    41,  1620,
       0,     0,     0,  1620,     0,     0,     0,     0,  1620,  1620,
       0,  1620,     0,     0,  2373,    42,     0,     0,  2373,  2373,
    2373,  2373,  2373,  2373,  2373,  2373,  2373,  2373,  1620,  1620,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2373,  1620,     0,  1620,     0,     0,     0,
    1620,  1996,     0,  2314,  1620,     0,     0,  1620,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    43,     0,  2976,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1620,     0,     0,  2992,
       0,     0,     0,     0,    44,     0,     0,     0,  2996,     0,
       0,     0,     0,     0,     0,     0,     0,    45,     0,     0,
       0,     0,     0,     0,     0,  3001,     0,     0,     0,    46,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      47,     0,     0,    48,    49,     0,    50,     0,     0,  2373,
       0,     0,    52,     0,    53,    54,     0,     0,     0,    55,
      56,    57,    58,    59,  3034,     0,    60,    61,   932,  1299,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3053,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1620,
       0,     0,     0,     0,     0,     0,  1996,     0,  1996,     0,
       0,     0,     0,     0,  2373,  1620,  1620,     0,  1620,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2996,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1620,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2373,  1996,
    2373,     0,     0,  1620,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1620,
       0,     0,     0,  1620,     0,     0,     0,     0,  1620,     0,
       0,   582,    79,    80,    81,   353,     0,    83,    84,     0,
      85,    86,    87,   354,     0,   355,     0,    91,     0,    93,
      94,    95,    96,    97,    98,   583,    99,   100,   101,   356,
     584,  1620,   103,   104,   105,   106,   585,   586,     0,   108,
     109,   110,     0,   111,   587,   588,  2373,   357,   358,     0,
    1620,     0,   359,   360,     0,     0,     0,     0,   361,     0,
       0,     0,     0,     0,     0,     0,     0,   362,     0,   363,
       0,   364,   365,     0,   366,   367,   368,   369,   370,   371,
     372,   589,   373,   374,   590,   591,   592,   593,   594,   595,
     596,   375,   376,   377,   128,   378,   379,   380,   130,   131,
     132,   133,     0,   597,   381,   382,     0,   383,   598,   599,
     384,   600,   134,   386,   601,   387,   388,   389,   390,   138,
     602,   603,   391,   392,   393,   604,   394,   395,   141,   396,
     605,   397,   398,   144,   399,   606,   607,   608,   609,   400,
     401,   402,   403,   404,   147,   148,   405,   610,   406,   611,
     407,     0,   408,   409,   410,   612,   613,   614,   411,   412,
     413,   414,   615,   415,   416,   616,   417,   617,   418,   419,
     420,   154,   421,     0,   156,   618,   422,   423,   158,   619,
     424,   620,   425,   159,   621,   160,   426,     0,   427,   622,
     623,   428,   624,   429,   430,   163,   431,   432,   433,   625,
     434,   435,   436,   437,   626,   164,   165,   627,   438,   439,
     440,   628,   167,   629,   168,   630,     0,   169,   170,   441,
     171,   442,   443,   444,   445,   446,   631,   172,   447,   173,
     632,   448,   449,   450,   451,   452,   453,   454,   455,   456,
     457,   458,   459,   460,   178,   179,   180,   633,   461,   462,
     463,   464,   181,   634,   465,   466,   183,   467,   635,   184,
     185,   468,   469,   636,   637,   470,   638,   639,   640,   471,
     472,   641,   642,   186,   187,   188,   189,   473,   474,   475,
       0,   190,   191,   476,   477,   643,   478,   479,   480,   481,
     482,   483,   193,   484,   644,   485,   486,   487,   488,   489,
     490,   491,   492,   493,   494,   495,   198,   496,   200,   497,
     498,   499,   500,   501,   502,     0,   645,   503,   504,   505,
     646,   506,   204,   507,   508,   206,   509,   207,   647,   510,
     511,   512,   513,   514,   515,   516,   517,   209,   518,   648,
     519,   520,   521,   522,   649,   210,   211,   650,   524,   651,
     525,   212,   526,   213,   652,   527,   528,   529,   530,   531,
     653,   654,   532,   533,   534,   535,   536,   655,   656,   537,
     538,   539,   220,   540,   221,   541,     0,   657,   658,   542,
     543,   544,   545,   546,   547,     0,   222,     0,     0,   223,
       0,     0,    79,    80,    81,     0,     0,    83,    84,     0,
      85,    86,    87,     0,     0,     0,    90,    91,     0,    93,
      94,    95,    96,    97,    98,   659,    99,   100,   101,     0,
       0,     0,   103,   104,   105,   106,     0,   107,     0,   108,
     109,   110,     0,   111,   112,   113,     0,     0,     0,     0,
       0,     0,   116,   117,     0,     0,     0,     0,   118,     0,
       0,     0,     0,     0,     0,     0,     0,   119,     0,   120,
       0,   121,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   128,     0,     0,     0,   130,   131,
     132,   133,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   134,     0,     0,     0,     0,     0,     0,   138,
       0,     0,     0,     0,     0,     0,     0,     0,   141,     0,
       0,     0,     0,   144,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   147,   148,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   154,     0,     0,   156,     0,     0,     0,   158,     0,
       0,     0,     0,   159,     0,   160,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   163,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   164,   165,     0,     0,     0,
       0,     0,   167,     0,   168,     0,     0,   169,   170,     0,
     171,     0,     0,     0,     0,     0,     0,   172,     0,   173,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   178,   179,   180,     0,     0,     0,
       0,     0,   181,     0,     0,     0,   183,     0,     0,   184,
     185,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   186,   187,   188,   189,     0,     0,     0,
       0,   190,   191,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   193,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   198,     0,   200,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   204,     0,     0,   206,     0,   207,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   209,     0,     0,
       0,     0,     0,     0,     0,   210,   211,     0,     0,     0,
       0,   212,     0,   213,     0,     0,     0,     0,     0,     0,
     216,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   220,     0,   221,     0,     0,     0,     0,     0,
       0,     0,    79,    80,    81,     0,   222,    83,    84,   223,
      85,    86,    87,     0,     0,     0,    90,    91,     0,    93,
      94,    95,    96,    97,    98,     0,    99,   100,   101,     0,
       0,     0,   103,   104,   105,   106,  2109,   107,     0,   108,
     109,   110,     0,   111,   112,   113,     0,     0,     0,     0,
       0,     0,   116,   117,     0,     0,     0,     0,   118,     0,
       0,     0,     0,     0,     0,     0,     0,   119,     0,   120,
       0,   121,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   128,     0,     0,     0,   130,   131,
     132,   133,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   134,     0,     0,     0,     0,     0,     0,   138,
       0,     0,     0,     0,     0,     0,     0,     0,   141,     0,
       0,     0,     0,   144,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   147,   148,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   154,     0,     0,   156,     0,     0,     0,   158,     0,
       0,     0,     0,   159,     0,   160,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   163,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   164,   165,     0,     0,     0,
       0,     0,   167,     0,   168,     0,     0,   169,   170,     0,
     171,     0,     0,     0,     0,     0,     0,   172,     0,   173,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   178,   179,   180,     0,     0,     0,
       0,     0,   181,     0,     0,     0,   183,     0,     0,   184,
     185,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   186,   187,   188,   189,     0,     0,     0,
       0,   190,   191,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   193,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   198,     0,   200,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   204,     0,     0,   206,     0,   207,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   209,     0,     0,
       0,     0,     0,     0,     0,   210,   211,     0,     0,     0,
       0,   212,     0,   213,     0,     0,     0,     0,     0,     0,
     216,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   220,     0,   221,     0,     0,     0,     0,    78,
       0,     0,    79,    80,    81,    82,   222,    83,    84,   223,
      85,    86,    87,    88,     0,    89,    90,    91,    92,    93,
      94,    95,    96,    97,    98,     0,    99,   100,   101,   102,
       0,     0,   103,   104,   105,   106,  2111,   107,     0,   108,
     109,   110,     0,   111,   112,   113,     0,   114,   115,     0,
       0,     0,   116,   117,     0,     0,     0,     0,   118,     0,
       0,     0,     0,     0,     0,     0,     0,   119,     0,   120,
       0,   121,   122,     0,   123,     0,     0,     0,     0,     0,
       0,     0,     0,   124,   125,   126,     0,     0,     0,     0,
       0,     0,     0,   127,   128,     0,     0,   129,   130,   131,
     132,   133,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   134,     0,     0,   135,     0,   136,   137,   138,
       0,     0,   139,   140,     0,     0,     0,     0,   141,   142,
     143,     0,     0,   144,     0,     0,     0,     0,     0,     0,
       0,   145,     0,   146,   147,   148,   149,     0,     0,     0,
       0,     0,   150,     0,     0,     0,     0,     0,     0,     0,
     151,     0,     0,     0,     0,   152,     0,     0,     0,     0,
     153,   154,   155,     0,   156,     0,   157,     0,   158,     0,
       0,     0,     0,   159,     0,   160,     0,   161,     0,   162,
       0,     0,     0,     0,     0,   163,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   164,   165,     0,     0,   166,
       0,     0,   167,     0,   168,     0,     0,   169,   170,     0,
     171,     0,     0,     0,     0,     0,     0,   172,     0,   173,
       0,   174,   175,     0,     0,   176,     0,     0,     0,     0,
       0,     0,   177,     0,   178,   179,   180,     0,     0,     0,
       0,     0,   181,     0,     0,   182,   183,     0,     0,   184,
     185,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   186,   187,   188,   189,     0,     0,     0,
       0,   190,   191,     0,   192,     0,     0,     0,     0,     0,
       0,     0,   193,     0,     0,   194,     0,   195,     0,     0,
       0,   196,     0,     0,     0,   197,   198,   199,   200,     0,
       0,   201,     0,     0,     0,     0,   202,     0,     0,     0,
       0,   203,   204,     0,   205,   206,     0,   207,     0,     0,
     208,     0,     0,     0,     0,     0,     0,   209,     0,     0,
       0,     0,     0,     0,     0,   210,   211,     0,     0,     0,
       0,   212,     0,   213,     0,   214,     0,   215,     0,     0,
     216,     0,     0,   217,     0,   218,     0,     0,     0,   219,
       0,     0,   220,     0,   221,     0,     0,     0,     0,     0,
       0,   582,    79,    80,    81,   353,   222,    83,    84,   223,
      85,    86,    87,   354,     0,   355,     0,    91,     0,    93,
      94,    95,    96,    97,    98,   583,    99,   100,   101,   356,
     584,   224,   103,   104,   105,   106,   585,   586,     0,   108,
     109,   110,     0,   111,   587,   588,     0,   357,   358,     0,
       0,     0,   359,   360,     0,     0,     0,     0,   361,     0,
       0,     0,     0,     0,     0,     0,     0,   362,     0,   363,
       0,   364,   365,     0,   366,   367,   368,   369,   370,   371,
     372,  2071,   373,   374,     0,     0,     0,     0,  1114,     0,
       0,   375,   376,   377,   128,   378,   379,   380,   130,  1115,
     132,  1116,  1117,     0,   381,   382,     0,   383,  1118,  1119,
     384,  1120,  1121,   386,     0,   387,   388,   389,   390,  1122,
       0,     0,   391,   392,   393,     0,   394,   395,  1123,   396,
       0,   397,   398,   144,   399,  1124,  1125,  1126,  1127,   400,
     401,   402,   403,   404,  1128,  1129,   405,     0,   406,     0,
     407,     0,   408,   409,   410,     0,  2072,     0,   411,  1130,
     413,   414,     0,   415,   416,     0,   417,     0,   418,   419,
     420,  1131,   421,     0,  1132,  1133,   422,   423,  1134,     0,
     424,     0,   425,   159,     0,   160,   426,     0,   427,     0,
       0,   428,     0,   429,   430,   163,   431,   432,   433,     0,
     434,   435,   436,   437,     0,   164,   165,     0,   438,   439,
     440,  1135,  1136,     0,  1137,     0,     0,   169,   170,   441,
     171,   442,   443,   444,   445,   446,     0,   172,   447,   173,
       0,   448,   449,   450,   451,   452,   453,   454,   455,   456,
     457,   458,   459,   460,  1138,   179,  1139,   707,   461,   462,
     463,   464,   181,  1140,   465,   466,   183,   467,  1141,  1142,
    1143,   468,   469,     0,     0,   470,   708,     0,     0,  1144,
     472,     0,     0,   186,   187,   188,  1145,   473,   474,   475,
       0,  1146,   191,   476,   477,     0,   478,   479,   480,   481,
     482,   483,  1147,   484,     0,   485,   486,   487,   488,   489,
     490,   491,   492,   493,   494,   495,   198,   496,  1148,   497,
     498,   499,   500,   501,   502,     0,     0,   503,   504,   505,
    1149,   506,   204,   507,   508,   206,   509,  1150,     0,   510,
     511,   512,   513,   514,   515,   516,   517,  1151,   518,     0,
     519,   520,   521,   522,     0,  1152,  1153,     0,   524,     0,
     525,  1154,   526,  1155,  1156,   527,   528,   529,   530,   531,
       0,  1157,   532,   533,   534,   535,   536,  1158,     0,   537,
     538,   539,  1159,   540,   221,   541,     0,     0,     0,   542,
     543,   544,   545,   546,   547,     0,   222,    49,  1160,   223,
     548,     0,     0,  1161,  1162,    52,  1163,    53,     0,     0,
       0,     0,  1164,  1165,  2073,     0,  1167,  1168,     0,     0,
       0,  1169,  2074,   582,    79,    80,    81,   353,     0,    83,
      84,     0,    85,    86,    87,   354,     0,   355,     0,    91,
       0,    93,    94,    95,    96,    97,    98,   583,    99,   100,
     101,   356,   584,     0,   103,   104,   105,   106,   585,   586,
       0,   108,   109,   110,     0,   111,   587,   588,     0,   357,
     358,     0,     0,     0,   359,   360,     0,     0,     0,     0,
     361,     0,     0,     0,     0,     0,     0,     0,     0,   362,
       0,   363,     0,   364,   365,     0,   366,   367,   368,   369,
     370,   371,   372,     0,   373,   374,     0,     0,     0,     0,
    1114,     0,     0,   375,   376,   377,   128,   378,   379,   380,
     130,  1115,   132,  1116,  1117,     0,   381,   382,     0,   383,
    1118,  1119,   384,  1120,  1121,   386,     0,   387,   388,   389,
     390,  1122,     0,     0,   391,   392,   393,     0,   394,   395,
    1123,   396,     0,   397,   398,   144,   399,  1124,  1125,  1126,
    1127,   400,   401,   402,   403,   404,  1128,  1129,   405,     0,
     406,     0,   407,     0,   408,   409,   410,     0,     0,     0,
     411,  1130,   413,   414,     0,   415,   416,     0,   417,     0,
     418,   419,   420,  1131,   421,     0,  1132,  1133,   422,   423,
    1134,     0,   424,     0,   425,   159,     0,   160,   426,     0,
     427,     0,     0,   428,     0,   429,   430,   163,   431,   432,
     433,     0,   434,   435,   436,   437,     0,   164,   165,     0,
     438,   439,   440,  1135,  1136,     0,  1137,     0,     0,   169,
     170,   441,   171,   442,   443,   444,   445,   446,     0,   172,
     447,   173,     0,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,  1138,   179,  1139,   707,
     461,   462,   463,   464,   181,  1140,   465,   466,   183,   467,
    1141,  1142,  1143,   468,   469,     0,     0,   470,   708,     0,
       0,  1144,   472,     0,     0,   186,   187,   188,  1145,   473,
     474,   475,     0,  1146,   191,   476,   477,     0,   478,   479,
     480,   481,   482,   483,  1147,   484,     0,   485,   486,   487,
     488,   489,   490,   491,   492,   493,   494,   495,   198,   496,
    1148,   497,   498,   499,   500,   501,   502,     0,     0,   503,
     504,   505,  1149,   506,   204,   507,   508,   206,   509,  1150,
       0,   510,   511,   512,   513,   514,   515,   516,   517,  1151,
     518,     0,   519,   520,   521,   522,     0,  1152,  1153,     0,
     524,     0,   525,  1154,   526,  1155,  1156,   527,   528,   529,
     530,   531,     0,  1157,   532,   533,   534,   535,   536,  1158,
       0,   537,   538,   539,  1159,   540,   221,   541,     0,     0,
       0,   542,   543,   544,   545,   546,   547,     0,   222,    49,
    1160,   223,   548,     0,     0,  1161,  1162,    52,  1163,    53,
       0,     0,     0,     0,  1164,  1165,     0,     0,  1167,  1168,
       0,     0,     0,  1169,  1998,    79,    80,    81,   353,     0,
      83,    84,     0,    85,    86,    87,   354,     0,   355,     0,
      91,     0,    93,    94,    95,    96,    97,    98,     0,    99,
     100,   101,   356,     0,     0,   103,   104,   105,   106,     0,
       0,     0,   108,   109,   110,     0,   111,     0,     0,     0,
     357,   358,     0,     0,     0,   359,   360,     0,     0,     0,
       0,   361,     0,     0,     0,     0,     0,     0,     0,     0,
     362,     0,   363,     0,   364,   365,     0,   366,   367,   368,
     369,   370,   371,   372,     0,   373,   374,     0,     0,     0,
       0,     0,     0,     0,   375,   376,   377,     0,   378,   379,
     380,     0,   131,     0,   133,     0,     0,   381,   382,     0,
     383,     0,     0,   384,   385,   134,   386,     0,   387,   388,
     389,   390,   138,     0,     0,   391,   392,   393,     0,   394,
     395,   141,   396,     0,   397,   398,     0,   399,     0,     0,
       0,     0,   400,   401,   402,   403,   404,   147,   148,   405,
       0,   406,     0,   407,     0,   408,   409,   410,     0,     0,
       0,   411,   412,   413,   414,     0,   415,   416,     0,   417,
       0,   418,   419,   420,   154,   421,     0,   156,     0,   422,
     423,   158,     0,   424,     0,   425,     0,     0,     0,   426,
       0,   427,     0,     0,   428,     0,   429,   430,     0,   431,
     432,   433,     0,   434,   435,   436,   437,     0,     0,   165,
       0,   438,   439,   440,     0,   167,     0,   168,     0,     0,
       0,     0,   441,     0,   442,   443,   444,   445,   446,     0,
       0,   447,     0,     0,   448,   449,   450,   451,   452,   453,
     454,   455,   456,   457,   458,   459,   460,   178,     0,   180,
       0,   461,   462,   463,   464,   181,     0,   465,   466,     0,
     467,     0,   184,   185,   468,   469,     0,     0,   470,     0,
       0,     0,   471,   472,     0,     0,   186,     0,     0,   189,
     473,   474,   475,     0,   190,   191,   476,   477,     0,   478,
     479,   480,   481,   482,   483,   193,   484,     0,   485,   486,
     487,   488,   489,   490,   491,   492,   493,   494,   495,     0,
     496,   200,   497,   498,   499,   500,   501,   502,     0,     0,
     503,   504,   505,     0,   506,   204,   507,   508,     0,   509,
     207,     0,   510,   511,   512,   513,   514,   515,   516,   517,
     209,   518,     0,   519,   520,   521,   522,     0,   210,   211,
       0,   524,     0,   525,   212,   526,   213,     0,   527,   528,
     529,   530,   531,     0,     0,   532,   533,   534,   535,   536,
       0,  3037,   537,   538,   539,   220,   540,     0,   541,     4,
       0,     0,   542,   543,   544,   545,   546,   547,     0,   222,
       0,     0,   223,     0,     5,     0,     0,     0,     0,     0,
       0,     0,     0,     6,     0,     0,     0,     0,     0,     0,
       0,     0, -1185,     0,     7,     8, -1185,     0,     0,     0,
       0,     0,    10,    11,     0,     0,     0,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    36,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    37,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    38,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    39,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    40,     0,     0,    41,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    43,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    44,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    45,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      46,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    47,     0,     0,    48,    49,     0,    50,     0,     0,
       0,     0,     0,    52,     0,    53,    54,     0,     0,     0,
      55,    56,    57,    58,    59,     0,     0,    60,    61,   932,
    1735,   582,    79,    80,    81,   353,     0,    83,    84,     0,
      85,    86,    87,   354,     0,   355,     0,    91,     0,    93,
      94,    95,    96,    97,    98,   583,    99,   100,   101,   356,
     584,     0,   103,   104,   105,   106,   585,   586,     0,   108,
     109,   110,     0,   111,   587,   588,     0,   357,   358,     0,
       0,     0,   359,   360,     0,     0,     0,     0,   361,     0,
       0,     0,     0,     0,     0,     0,     0,   362,     0,   363,
       0,   364,   365,     0,   366,   367,   368,   369,   370,   371,
     372,     0,   373,   374,     0,     0,     0,     0,  1114,     0,
       0,   375,   376,   377,   128,   378,   379,   380,   130,  1115,
     132,  1116,  1117,  2008,   381,   382,     0,   383,  1118,  1119,
     384,  1120,  1121,   386,     0,   387,   388,   389,   390,  1122,
       0,     0,   391,   392,   393,     0,   394,   395,  1123,   396,
       0,   397,   398,   144,   399,  1124,  1125,  1126,  1127,   400,
     401,   402,   403,   404,  1128,  1129,   405,     0,   406,     0,
     407,     0,   408,   409,   410,     0,     0,     0,   411,  1130,
     413,   414,     0,   415,   416,     0,   417,     0,   418,   419,
     420,  1131,   421,     0,  1132,  1133,   422,   423,  1134,     0,
     424,     0,   425,   159,  2009,   160,   426,     0,   427,     0,
       0,   428,     0,   429,   430,   163,   431,   432,   433,     0,
     434,   435,   436,   437,     0,   164,   165,     0,   438,   439,
     440,  1135,  1136,     0,  1137,     0,     0,   169,   170,   441,
     171,   442,   443,   444,   445,   446,  2010,   172,   447,   173,
       0,   448,   449,   450,   451,   452,   453,   454,   455,   456,
     457,   458,   459,   460,  1138,   179,  1139,   707,   461,   462,
     463,   464,   181,  1140,   465,   466,   183,   467,  1141,  1142,
    1143,   468,   469,     0,     0,   470,   708,     0,     0,  1144,
     472,     0,     0,   186,   187,   188,  1145,   473,   474,   475,
       0,  1146,   191,   476,   477,     0,   478,   479,   480,   481,
     482,   483,  1147,   484,     0,   485,   486,   487,   488,   489,
     490,   491,   492,   493,   494,   495,   198,   496,  1148,   497,
     498,   499,   500,   501,   502,     0,     0,   503,   504,   505,
    1149,   506,   204,   507,   508,   206,   509,  1150,     0,   510,
     511,   512,   513,   514,   515,   516,   517,  1151,   518,     0,
     519,   520,   521,   522,     0,  1152,  1153,     0,   524,  2011,
     525,  1154,   526,  1155,  1156,   527,   528,   529,   530,   531,
       0,  1157,   532,   533,   534,   535,   536,  1158,     0,   537,
     538,   539,  1159,   540,   221,   541,     0,     0,     0,   542,
     543,   544,   545,   546,   547,     0,   222,    49,  1160,   223,
     548,     0,     0,  1161,  1162,    52,  1163,    53,     0,     0,
       0,     0,  1164,  1165,     0,     0,  1167,  1168,     0,     0,
       0,  1169,   582,    79,    80,    81,   353,     0,    83,    84,
       0,    85,    86,    87,   354,     0,   355,     0,    91,     0,
      93,    94,    95,    96,    97,    98,   583,    99,   100,   101,
     356,   584,     0,   103,   104,   105,   106,   585,   586,     0,
     108,   109,   110,     0,   111,   587,   588,     0,   357,   358,
       0,     0,     0,   359,   360,     0,     0,     0,     0,   361,
       0,     0,     0,     0,     0,     0,     0,     0,   362,     0,
     363,     0,   364,   365,     0,   366,   367,   368,   369,   370,
     371,   372,     0,   373,   374,     0,     0,     0,     0,  1114,
       0,     0,   375,   376,   377,   128,   378,   379,   380,   130,
    1115,   132,  1116,  1117,     0,   381,   382,     0,   383,  1118,
    1119,   384,  1120,  1121,   386,     0,   387,   388,   389,   390,
    1122,     0,     0,   391,   392,   393,     0,   394,   395,  1123,
     396,     0,   397,   398,   144,   399,  1124,  1125,  1126,  1127,
     400,   401,   402,   403,   404,  1128,  1129,   405,     0,   406,
       0,   407,     0,   408,   409,   410,     0,     0,     0,   411,
    1130,   413,   414,     0,   415,   416,     0,   417,     0,   418,
     419,   420,  1131,   421,     0,  1132,  1133,   422,   423,  1134,
       0,   424,     0,   425,   159,     0,   160,   426,     0,   427,
       0,     0,   428,     0,   429,   430,   163,   431,   432,   433,
       0,   434,   435,   436,   437,     0,   164,   165,     0,   438,
     439,   440,  1135,  1136,     0,  1137,     0,     0,   169,   170,
     441,   171,   442,   443,   444,   445,   446,     0,   172,   447,
     173,     0,   448,   449,   450,   451,   452,   453,   454,   455,
     456,   457,   458,   459,   460,  1138,   179,  1139,   707,   461,
     462,   463,   464,   181,  1140,   465,   466,   183,   467,  1141,
    1142,  1143,   468,   469,     0,     0,   470,   708,     0,     0,
    1144,   472,     0,     0,   186,   187,   188,  1145,   473,   474,
     475,     0,  1146,   191,   476,   477,     0,   478,   479,   480,
     481,   482,   483,  1147,   484,     0,   485,   486,   487,   488,
     489,   490,   491,   492,   493,   494,   495,   198,   496,  1148,
     497,   498,   499,   500,   501,   502,     0,     0,   503,   504,
     505,  1149,   506,   204,   507,   508,   206,   509,  1150,     0,
     510,   511,   512,   513,   514,   515,   516,   517,  1151,   518,
       0,   519,   520,   521,   522,     0,  1152,  1153,     0,   524,
       0,   525,  1154,   526,  1155,  1156,   527,   528,   529,   530,
     531,     0,  1157,   532,   533,   534,   535,   536,  1158,     0,
     537,   538,   539,  1159,   540,   221,   541,     0,     0,     0,
     542,   543,   544,   545,   546,   547,     0,   222,    49,  1160,
     223,   548,     0,     0,  1161,  1162,    52,  1163,    53,     0,
       0,     0,     0,  1164,  1165,  1166,     0,  1167,  1168,     0,
       0,     0,  1169,   582,    79,    80,    81,   353,     0,    83,
      84,     0,    85,    86,    87,   354,     0,   355,     0,    91,
       0,    93,    94,    95,    96,    97,    98,   583,    99,   100,
     101,   356,   584,     0,   103,   104,   105,   106,   585,   586,
       0,   108,   109,   110,     0,   111,   587,   588,     0,   357,
     358,     0,     0,     0,   359,   360,     0,     0,     0,     0,
     361,     0,     0,     0,     0,     0,     0,     0,     0,   362,
       0,   363,     0,   364,   365,     0,   366,   367,   368,   369,
     370,   371,   372,     0,   373,   374,     0,     0,     0,     0,
    1114,     0,     0,   375,   376,   377,   128,   378,   379,   380,
     130,  1115,   132,  1116,  1117,     0,   381,   382,     0,   383,
    1118,  1119,   384,  1120,  1121,   386,     0,   387,   388,   389,
     390,  1122,     0,     0,   391,   392,   393,     0,   394,   395,
    1123,   396,     0,   397,   398,   144,   399,  1124,  1125,  1126,
    1127,   400,   401,   402,   403,   404,  1128,  1129,   405,     0,
     406,     0,   407,     0,   408,   409,   410,     0,     0,     0,
     411,  1130,   413,   414,     0,   415,   416,     0,   417,     0,
     418,   419,   420,  1131,   421,     0,  1132,  1133,   422,   423,
    1134,     0,   424,     0,   425,   159,     0,   160,   426,     0,
     427,     0,     0,   428,     0,   429,   430,   163,   431,   432,
     433,     0,   434,   435,   436,   437,     0,   164,   165,     0,
     438,   439,   440,  1135,  1136,     0,  1137,     0,     0,   169,
     170,   441,   171,   442,   443,   444,   445,   446,     0,   172,
     447,   173,     0,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,  1138,   179,  1139,   707,
     461,   462,   463,   464,   181,  1140,   465,   466,   183,   467,
    1141,  1142,  1143,   468,   469,     0,     0,   470,   708,     0,
       0,  1144,   472,     0,     0,   186,   187,   188,  1145,   473,
     474,   475,     0,  1146,   191,   476,   477,     0,   478,   479,
     480,   481,   482,   483,  1147,   484,     0,   485,   486,   487,
     488,   489,   490,   491,   492,   493,   494,   495,   198,   496,
    1148,   497,   498,   499,   500,   501,   502,     0,   202,   503,
     504,   505,  1149,   506,   204,   507,   508,   206,   509,  1150,
       0,   510,   511,   512,   513,   514,   515,   516,   517,  1151,
     518,     0,   519,   520,   521,   522,     0,  1152,  1153,     0,
     524,     0,   525,  1154,   526,  1155,  1156,   527,   528,   529,
     530,   531,     0,  1157,   532,   533,   534,   535,   536,  1158,
       0,   537,   538,   539,  1159,   540,   221,   541,     0,     0,
       0,   542,   543,   544,   545,   546,   547,     0,   222,    49,
    1160,   223,   548,     0,     0,  1161,  1162,    52,  1163,    53,
       0,     0,     0,     0,  1164,  1165,     0,     0,  1167,  1168,
       0,     0,     0,  1169,   582,    79,    80,    81,   353,     0,
      83,    84,     0,    85,    86,    87,   354,     0,   355,     0,
      91,     0,    93,    94,    95,    96,    97,    98,   583,    99,
     100,   101,   356,   584,     0,   103,   104,   105,   106,   585,
     586,     0,   108,   109,   110,     0,   111,   587,   588,     0,
     357,   358,     0,     0,     0,   359,   360,     0,     0,     0,
       0,   361,     0,     0,     0,     0,     0,     0,     0,     0,
     362,     0,   363,     0,   364,   365,     0,   366,   367,   368,
     369,   370,   371,   372,  1692,   373,   374,     0,     0,     0,
       0,  1114,     0,     0,   375,   376,   377,   128,   378,   379,
     380,   130,  1115,   132,  1116,  1117,     0,   381,   382,     0,
     383,  1118,  1119,   384,  1120,  1121,   386,     0,   387,   388,
     389,   390,  1122,     0,     0,   391,   392,   393,     0,   394,
     395,  1123,   396,     0,   397,   398,   144,   399,  1124,  1125,
    1126,  1127,   400,   401,   402,   403,   404,  1128,  1129,   405,
       0,   406,     0,   407,     0,   408,   409,   410,     0,     0,
       0,   411,  1130,   413,   414,     0,   415,   416,     0,   417,
       0,   418,   419,   420,  1131,   421,     0,  1132,  1133,   422,
     423,  1134,     0,   424,     0,   425,   159,     0,   160,   426,
       0,   427,     0,     0,   428,     0,   429,   430,   163,   431,
     432,   433,     0,   434,   435,   436,   437,     0,   164,   165,
       0,   438,   439,   440,  1135,  1136,     0,  1137,     0,     0,
     169,   170,   441,   171,   442,   443,   444,   445,   446,     0,
     172,   447,   173,     0,   448,   449,   450,   451,   452,   453,
     454,   455,   456,   457,   458,   459,   460,  1138,   179,  1139,
     707,   461,   462,   463,   464,   181,  1140,   465,   466,   183,
     467,  1141,  1142,  1143,   468,   469,     0,     0,   470,   708,
       0,     0,  1144,   472,     0,     0,   186,   187,   188,  1145,
     473,   474,   475,     0,  1146,   191,   476,   477,     0,   478,
     479,   480,   481,   482,   483,  1147,   484,     0,   485,   486,
     487,   488,   489,   490,   491,   492,   493,   494,   495,   198,
     496,  1148,   497,   498,   499,   500,   501,   502,     0,     0,
     503,   504,   505,  1149,   506,   204,   507,   508,   206,   509,
    1150,     0,   510,   511,   512,   513,   514,   515,   516,   517,
    1151,   518,     0,   519,   520,   521,   522,     0,  1152,  1153,
       0,   524,     0,   525,  1154,   526,  1155,  1156,   527,   528,
     529,   530,   531,     0,  1157,   532,   533,   534,   535,   536,
    1158,     0,   537,   538,   539,  1159,   540,   221,   541,     0,
       0,     0,   542,   543,   544,   545,   546,   547,     0,   222,
      49,  1160,   223,   548,     0,     0,  1161,  1162,    52,  1163,
      53,     0,     0,     0,     0,  1164,  1165,     0,     0,  1167,
    1168,     0,     0,     0,  1169,   582,    79,    80,    81,   353,
       0,    83,    84,     0,    85,    86,    87,   354,     0,   355,
       0,    91,     0,    93,    94,    95,    96,    97,    98,   583,
      99,   100,   101,   356,   584,     0,   103,   104,   105,   106,
     585,   586,     0,   108,   109,   110,     0,   111,   587,   588,
       0,   357,   358,     0,     0,     0,   359,   360,     0,     0,
       0,     0,   361,     0,     0,     0,     0,     0,     0,     0,
       0,   362,     0,   363,     0,   364,   365,     0,   366,   367,
     368,   369,   370,   371,   372,     0,   373,   374,     0,     0,
       0,     0,  1114,     0,     0,   375,   376,   377,   128,   378,
     379,   380,   130,  1115,   132,  1116,  1117,     0,   381,   382,
       0,   383,  1118,  1119,   384,  1120,  1121,   386,     0,   387,
     388,   389,   390,  1122,     0,     0,   391,   392,   393,     0,
     394,   395,  1123,   396,     0,   397,   398,   144,   399,  1124,
    1125,  1126,  1127,   400,   401,   402,   403,   404,  1128,  1129,
     405,     0,   406,     0,   407,     0,   408,   409,   410,     0,
       0,     0,   411,  1130,   413,   414,     0,   415,   416,     0,
     417,     0,   418,   419,   420,  1131,   421,     0,  1132,  1133,
     422,   423,  1134,     0,   424,     0,   425,   159,     0,   160,
     426,     0,   427,     0,     0,   428,     0,   429,   430,   163,
     431,   432,   433,     0,   434,   435,   436,   437,     0,   164,
     165,     0,   438,   439,   440,  1135,  1136,     0,  1137,     0,
       0,   169,   170,   441,   171,   442,   443,   444,   445,   446,
       0,   172,   447,   173,     0,   448,   449,   450,   451,   452,
     453,   454,   455,   456,   457,   458,   459,   460,  1138,   179,
    1139,   707,   461,   462,   463,   464,   181,  1140,   465,   466,
     183,   467,  1141,  1142,  1143,   468,   469,     0,     0,   470,
     708,     0,     0,  1144,   472,     0,     0,   186,   187,   188,
    1145,   473,   474,   475,     0,  1146,   191,   476,   477,     0,
     478,   479,   480,   481,   482,   483,  1147,   484,     0,   485,
     486,   487,   488,   489,   490,   491,   492,   493,   494,   495,
     198,   496,  1148,   497,   498,   499,   500,   501,   502,     0,
       0,   503,   504,   505,  1149,   506,   204,   507,   508,   206,
     509,  1150,     0,   510,   511,   512,   513,   514,   515,   516,
     517,  1151,   518,     0,   519,   520,   521,   522,     0,  1152,
    1153,     0,   524,     0,   525,  1154,   526,  1155,  1156,   527,
     528,   529,   530,   531,     0,  1157,   532,   533,   534,   535,
     536,  1158,     0,   537,   538,   539,  1159,   540,   221,   541,
       0,     0,     0,   542,   543,   544,   545,   546,   547,     0,
     222,    49,  1160,   223,   548,     0,     0,  1161,  1162,    52,
    1163,    53,     0,     0,     0,     0,  1164,  1165,     0,     0,
    1167,  1168,     0,  1531,     0,  1169,   582,    79,    80,    81,
     353,     0,    83,    84,     0,    85,    86,    87,   354,     0,
     355,     0,    91,     0,    93,    94,    95,    96,    97,    98,
     583,    99,   100,   101,   356,   584,     0,   103,   104,   105,
     106,   585,   586,     0,   108,   109,   110,     0,   111,   587,
     588,     0,   357,   358,     0,     0,     0,   359,   360,     0,
       0,     0,     0,   361,     0,     0,     0,     0,     0,     0,
       0,     0,   362,     0,   363,     0,   364,   365,     0,   366,
     367,   368,   369,   370,   371,   372,     0,   373,   374,     0,
       0,     0,     0,  1114,     0,     0,   375,   376,   377,   128,
     378,   379,   380,   130,  1115,   132,  1116,  1117,     0,   381,
     382,     0,   383,  1118,  1119,   384,  1120,  1121,   386,     0,
     387,   388,   389,   390,  1122,     0,     0,   391,   392,   393,
       0,   394,   395,  1123,   396,     0,   397,   398,   144,   399,
    1124,  1125,  1126,  1127,   400,   401,   402,   403,   404,  1128,
    1129,   405,  2313,   406,     0,   407,     0,   408,   409,   410,
       0,     0,     0,   411,  1130,   413,   414,     0,   415,   416,
       0,   417,     0,   418,   419,   420,  1131,   421,     0,  1132,
    1133,   422,   423,  1134,     0,   424,     0,   425,   159,     0,
     160,   426,     0,   427,     0,     0,   428,     0,   429,   430,
     163,   431,   432,   433,     0,   434,   435,   436,   437,     0,
     164,   165,     0,   438,   439,   440,  1135,  1136,     0,  1137,
       0,     0,   169,   170,   441,   171,   442,   443,   444,   445,
     446,     0,   172,   447,   173,     0,   448,   449,   450,   451,
     452,   453,   454,   455,   456,   457,   458,   459,   460,  1138,
     179,  1139,   707,   461,   462,   463,   464,   181,  1140,   465,
     466,   183,   467,  1141,  1142,  1143,   468,   469,     0,     0,
     470,   708,     0,     0,  1144,   472,     0,     0,   186,   187,
     188,  1145,   473,   474,   475,     0,  1146,   191,   476,   477,
       0,   478,   479,   480,   481,   482,   483,  1147,   484,     0,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   198,   496,  1148,   497,   498,   499,   500,   501,   502,
       0,     0,   503,   504,   505,  1149,   506,   204,   507,   508,
     206,   509,  1150,     0,   510,   511,   512,   513,   514,   515,
     516,   517,  1151,   518,     0,   519,   520,   521,   522,     0,
    1152,  1153,     0,   524,     0,   525,  1154,   526,  1155,  1156,
     527,   528,   529,   530,   531,     0,  1157,   532,   533,   534,
     535,   536,  1158,     0,   537,   538,   539,  1159,   540,   221,
     541,     0,     0,     0,   542,   543,   544,   545,   546,   547,
       0,   222,    49,  1160,   223,   548,     0,     0,  1161,  1162,
      52,  1163,    53,     0,     0,     0,     0,  1164,  1165,     0,
       0,  1167,  1168,     0,     0,     0,  1169,   582,    79,    80,
      81,   353,     0,    83,    84,     0,    85,    86,    87,   354,
       0,   355,     0,    91,     0,    93,    94,    95,    96,    97,
      98,   583,    99,   100,   101,   356,   584,     0,   103,   104,
     105,   106,   585,   586,     0,   108,   109,   110,     0,   111,
     587,   588,     0,   357,   358,     0,     0,     0,   359,   360,
       0,     0,     0,     0,   361,     0,     0,     0,     0,     0,
       0,     0,     0,   362,     0,   363,     0,   364,   365,     0,
     366,   367,   368,   369,   370,   371,   372,     0,   373,   374,
       0,     0,     0,     0,  1114,     0,     0,   375,   376,   377,
     128,   378,   379,   380,   130,  1115,   132,  1116,  1117,     0,
     381,   382,     0,   383,  1118,  1119,   384,  1120,  1121,   386,
       0,   387,   388,   389,   390,  1122,     0,     0,   391,   392,
     393,     0,   394,   395,  1123,   396,     0,   397,   398,   144,
     399,  1124,  1125,  1126,  1127,   400,   401,   402,   403,   404,
    1128,  1129,   405,     0,   406,     0,   407,     0,   408,   409,
     410,     0,     0,     0,   411,  1130,   413,   414,     0,   415,
     416,     0,   417,     0,   418,   419,   420,  1131,   421,     0,
    1132,  1133,   422,   423,  1134,     0,   424,     0,   425,   159,
    2009,   160,   426,     0,   427,     0,     0,   428,     0,   429,
     430,   163,   431,   432,   433,     0,   434,   435,   436,   437,
       0,   164,   165,     0,   438,   439,   440,  1135,  1136,     0,
    1137,     0,     0,   169,   170,   441,   171,   442,   443,   444,
     445,   446,     0,   172,   447,   173,     0,   448,   449,   450,
     451,   452,   453,   454,   455,   456,   457,   458,   459,   460,
    1138,   179,  1139,   707,   461,   462,   463,   464,   181,  1140,
     465,   466,   183,   467,  1141,  1142,  1143,   468,   469,     0,
       0,   470,   708,     0,     0,  1144,   472,     0,     0,   186,
     187,   188,  1145,   473,   474,   475,     0,  1146,   191,   476,
     477,     0,   478,   479,   480,   481,   482,   483,  1147,   484,
       0,   485,   486,   487,   488,   489,   490,   491,   492,   493,
     494,   495,   198,   496,  1148,   497,   498,   499,   500,   501,
     502,     0,     0,   503,   504,   505,  1149,   506,   204,   507,
     508,   206,   509,  1150,     0,   510,   511,   512,   513,   514,
     515,   516,   517,  1151,   518,     0,   519,   520,   521,   522,
       0,  1152,  1153,     0,   524,     0,   525,  1154,   526,  1155,
    1156,   527,   528,   529,   530,   531,     0,  1157,   532,   533,
     534,   535,   536,  1158,     0,   537,   538,   539,  1159,   540,
     221,   541,     0,     0,     0,   542,   543,   544,   545,   546,
     547,     0,   222,    49,  1160,   223,   548,     0,     0,  1161,
    1162,    52,  1163,    53,     0,     0,     0,     0,  1164,  1165,
       0,     0,  1167,  1168,     0,     0,     0,  1169,   582,    79,
      80,    81,   353,     0,    83,    84,     0,    85,    86,    87,
     354,     0,   355,     0,    91,     0,    93,    94,    95,    96,
      97,    98,   583,    99,   100,   101,   356,   584,     0,   103,
     104,   105,   106,   585,   586,     0,   108,   109,   110,     0,
     111,   587,   588,     0,   357,   358,     0,     0,     0,   359,
     360,     0,     0,     0,     0,   361,     0,     0,     0,     0,
       0,     0,     0,     0,   362,     0,   363,     0,   364,   365,
       0,   366,   367,   368,   369,   370,   371,   372,     0,   373,
     374,     0,     0,     0,     0,  1114,     0,     0,   375,   376,
     377,   128,   378,   379,   380,   130,  1115,   132,  1116,  1117,
       0,   381,   382,     0,   383,  1118,  1119,   384,  1120,  1121,
     386,     0,   387,   388,   389,   390,  1122,     0,     0,   391,
     392,   393,     0,   394,   395,  1123,   396,     0,   397,   398,
     144,   399,  1124,  1125,  1126,  1127,   400,   401,   402,   403,
     404,  1128,  1129,   405,  2728,   406,     0,   407,     0,   408,
     409,   410,     0,     0,     0,   411,  1130,   413,   414,     0,
     415,   416,     0,   417,     0,   418,   419,   420,  1131,   421,
       0,  1132,  1133,   422,   423,  1134,     0,   424,     0,   425,
     159,     0,   160,   426,     0,   427,     0,     0,   428,     0,
     429,   430,   163,   431,   432,   433,     0,   434,   435,   436,
     437,     0,   164,   165,     0,   438,   439,   440,  1135,  1136,
       0,  1137,     0,     0,   169,   170,   441,   171,   442,   443,
     444,   445,   446,     0,   172,   447,   173,     0,   448,   449,
     450,   451,   452,   453,   454,   455,   456,   457,   458,   459,
     460,  1138,   179,  1139,   707,   461,   462,   463,   464,   181,
    1140,   465,   466,   183,   467,  1141,  1142,  1143,   468,   469,
       0,     0,   470,   708,     0,     0,  1144,   472,     0,     0,
     186,   187,   188,  1145,   473,   474,   475,     0,  1146,   191,
     476,   477,     0,   478,   479,   480,   481,   482,   483,  1147,
     484,     0,   485,   486,   487,   488,   489,   490,   491,   492,
     493,   494,   495,   198,   496,  1148,   497,   498,   499,   500,
     501,   502,     0,     0,   503,   504,   505,  1149,   506,   204,
     507,   508,   206,   509,  1150,     0,   510,   511,   512,   513,
     514,   515,   516,   517,  1151,   518,     0,   519,   520,   521,
     522,     0,  1152,  1153,     0,   524,     0,   525,  1154,   526,
    1155,  1156,   527,   528,   529,   530,   531,     0,  1157,   532,
     533,   534,   535,   536,  1158,     0,   537,   538,   539,  1159,
     540,   221,   541,     0,     0,     0,   542,   543,   544,   545,
     546,   547,     0,   222,    49,  1160,   223,   548,     0,     0,
    1161,  1162,    52,  1163,    53,     0,     0,     0,     0,  1164,
    1165,     0,     0,  1167,  1168,     0,     0,     0,  1169,   582,
      79,    80,    81,   353,     0,    83,    84,     0,    85,    86,
      87,   354,     0,   355,     0,    91,     0,    93,    94,    95,
      96,    97,    98,   583,    99,   100,   101,   356,   584,     0,
     103,   104,   105,   106,   585,   586,     0,   108,   109,   110,
       0,   111,   587,   588,     0,   357,   358,     0,     0,     0,
     359,   360,     0,     0,     0,     0,   361,     0,     0,     0,
       0,     0,     0,     0,     0,   362,     0,   363,     0,   364,
     365,     0,   366,   367,   368,   369,   370,   371,   372,     0,
     373,   374,     0,     0,     0,     0,  1114,     0,     0,   375,
     376,   377,   128,   378,   379,   380,   130,  1115,   132,  1116,
    1117,     0,   381,   382,     0,   383,  1118,  1119,   384,  1120,
    1121,   386,     0,   387,   388,   389,   390,  1122,     0,     0,
     391,   392,   393,     0,   394,   395,  1123,   396,     0,   397,
     398,   144,   399,  1124,  1125,  1126,  1127,   400,   401,   402,
     403,   404,  1128,  1129,   405,     0,   406,     0,   407,     0,
     408,   409,   410,     0,     0,     0,   411,  1130,   413,   414,
       0,   415,   416,     0,   417,     0,   418,   419,   420,  1131,
     421,     0,  1132,  1133,   422,   423,  1134,     0,   424,     0,
     425,   159,     0,   160,   426,     0,   427,     0,     0,   428,
       0,   429,   430,   163,   431,   432,   433,     0,   434,   435,
     436,   437,     0,   164,   165,     0,   438,   439,   440,  1135,
    1136,     0,  1137,     0,     0,   169,   170,   441,   171,   442,
     443,   444,   445,   446,     0,   172,   447,   173,     0,   448,
     449,   450,   451,   452,   453,   454,   455,   456,   457,   458,
     459,   460,  1138,   179,  1139,   707,   461,   462,   463,   464,
     181,  1140,   465,   466,   183,   467,  1141,  1142,  1143,   468,
     469,     0,     0,   470,   708,     0,     0,  1144,   472,     0,
       0,   186,   187,   188,  1145,   473,   474,   475,     0,  1146,
     191,   476,   477,     0,   478,   479,   480,   481,   482,   483,
    1147,   484,     0,   485,   486,   487,   488,   489,   490,   491,
     492,   493,   494,   495,   198,   496,  1148,   497,   498,   499,
     500,   501,   502,     0,     0,   503,   504,   505,  1149,   506,
     204,   507,   508,   206,   509,  1150,     0,   510,   511,   512,
     513,   514,   515,   516,   517,  1151,   518,     0,   519,   520,
     521,   522,     0,  1152,  1153,     0,   524,     0,   525,  1154,
     526,  1155,  1156,   527,   528,   529,   530,   531,     0,  1157,
     532,   533,   534,   535,   536,  1158,     0,   537,   538,   539,
    1159,   540,   221,   541,     0,     0,     0,   542,   543,   544,
     545,   546,   547,     0,   222,    49,  1160,   223,   548,     0,
       0,  1161,  1162,    52,  1163,    53,     0,     0,     0,     0,
    1164,  1165,     0,     0,  1167,  1168,     0,     0,     0,  1169,
     582,    79,    80,    81,   353,     0,    83,    84,     0,    85,
      86,    87,   354,     0,   355,     0,    91,     0,    93,    94,
      95,    96,    97,    98,   583,    99,   100,   101,   356,   584,
       0,   103,   104,   105,   106,   585,   586,     0,   108,   109,
     110,     0,   111,   587,   588,     0,   357,   358,     0,     0,
       0,   359,   360,     0,     0,     0,     0,   361,     0,     0,
       0,     0,     0,     0,     0,     0,   362,     0,   363,     0,
     364,   365,     0,   366,   367,   368,   369,   370,   371,   372,
       0,   373,   374,     0,     0,     0,     0,  1114,     0,     0,
     375,   376,   377,   128,   378,   379,   380,   130,  1115,   132,
    1116,  1117,     0,   381,   382,     0,   383,  1118,  1119,   384,
    1120,  1121,   386,     0,   387,   388,   389,   390,  1122,     0,
       0,   391,   392,   393,     0,   394,   395,  1123,   396,     0,
     397,   398,   144,   399,  1124,  1125,  1126,  1127,   400,   401,
     402,   403,   404,  1128,  1129,   405,     0,   406,     0,   407,
       0,   408,   409,   410,     0,     0,     0,   411,  1130,   413,
     414,     0,   415,   416,     0,   417,     0,   418,   419,   420,
    1131,   421,     0,  1132,  1133,   422,   423,  1134,     0,   424,
       0,   425,   159,     0,   160,   426,     0,   427,     0,     0,
     428,     0,   429,   430,   163,   431,   432,   433,     0,   434,
     435,   436,   437,     0,   164,   165,     0,   438,   439,   440,
    1135,  1136,     0,  1137,     0,     0,   169,   170,   441,   171,
     442,   443,   444,   445,   446,     0,   172,   447,   173,     0,
     448,   449,   450,   451,   452,   453,   454,   455,   456,   457,
     458,   459,   460,  1138,   179,  1139,   707,   461,   462,   463,
     464,   181,     0,   465,   466,   183,   467,  1141,  1142,  1143,
     468,   469,     0,     0,   470,   708,     0,     0,  1144,   472,
       0,     0,   186,   187,   188,  1145,   473,   474,   475,     0,
    1146,   191,   476,   477,     0,   478,   479,   480,   481,   482,
     483,  1147,   484,     0,   485,   486,   487,   488,   489,   490,
     491,   492,   493,   494,   495,   198,   496,  1148,   497,   498,
     499,   500,   501,   502,     0,     0,   503,   504,   505,  1149,
     506,   204,   507,   508,   206,   509,  1150,     0,   510,   511,
     512,   513,   514,   515,   516,   517,  1151,   518,     0,   519,
     520,   521,   522,     0,  1152,  1153,     0,   524,     0,   525,
    1154,   526,  1155,  1156,   527,   528,   529,   530,   531,     0,
       0,   532,   533,   534,   535,   536,  1158,     0,   537,   538,
     539,  1159,   540,   221,   541,     0,     0,     0,   542,   543,
     544,   545,   546,   547,     0,   222,    49,  1160,   223,   548,
       0,     0,  1161,  1162,    52,  1163,    53,     0,     0,     0,
       0,     0,  1991,     0,     0,  1992,  1993,     0,     0,     0,
    1169,   582,    79,    80,    81,   353,     0,    83,    84,     0,
      85,    86,    87,   354,     0,   355,     0,    91,     0,    93,
      94,    95,    96,    97,    98,   583,    99,   100,   101,   356,
     584,     0,   103,   104,   105,   106,   585,   586,     0,   108,
     109,   110,     0,   111,   587,   588,     0,   357,   358,     0,
       0,     0,   359,   360,     0,     0,     0,     0,   361,     0,
       0,     0,     0,     0,     0,     0,     0,   362,     0,   363,
       0,   364,   365,     0,   366,   367,   368,   369,   370,   371,
     372,     0,   373,   374,     0,     0,     0,     0,  1114,     0,
       0,   375,   376,   377,   128,   378,   379,   380,     0,  1115,
     132,  1116,  1117,     0,   381,   382,     0,   383,  1118,  1119,
     384,  1120,  1121,   386,     0,   387,   388,   389,   390,  1122,
       0,     0,   391,   392,   393,     0,   394,   395,  1123,   396,
       0,   397,   398,   144,   399,  1124,  1125,  1126,  1127,   400,
     401,   402,   403,   404,  1128,  1129,   405,     0,   406,     0,
     407,     0,   408,   409,   410,     0,     0,     0,   411,  1130,
     413,   414,     0,   415,   416,     0,     0,     0,   418,   419,
     420,  1131,   421,     0,  1132,  1133,   422,   423,  1134,     0,
     424,     0,   425,   159,     0,   160,   426,     0,   427,     0,
       0,   428,     0,   429,   430,     0,   431,   432,   433,     0,
     434,   435,   436,   437,     0,   164,   165,     0,   438,   439,
     440,  1135,  1136,     0,  1137,     0,     0,   169,   170,   441,
     171,   442,   443,   444,   445,   446,     0,   172,   447,     0,
       0,   448,   449,   450,   451,   452,   453,   454,   455,   456,
     457,   458,   459,   460,  1138,   179,  1139,   707,   461,   462,
     463,   464,   181,     0,   465,   466,   183,   467,  1141,  1142,
    1143,   468,   469,     0,     0,   470,   708,     0,     0,  1144,
     472,     0,     0,   186,   187,   188,  1145,   473,   474,   475,
       0,  1146,   191,   476,   477,     0,   478,   479,   480,   481,
     482,   483,  1147,   484,     0,   485,   486,   487,   488,   489,
     490,   491,   492,   493,   494,   495,   198,   496,  1148,   497,
     498,   499,   500,   501,   502,     0,     0,   503,   504,   505,
    1149,   506,   204,   507,   508,     0,   509,  1150,     0,   510,
     511,   512,   513,   514,   515,   516,   517,  1151,   518,     0,
     519,   520,   521,   522,     0,  1152,  1153,     0,   524,     0,
     525,  1154,   526,  1155,  1156,   527,   528,   529,   530,   531,
       0,  1157,   532,   533,   534,   535,   536,  1158,     0,   537,
     538,   539,  1159,   540,   221,   541,     0,     0,     0,   542,
     543,   544,   545,   546,   547,     0,   222,    49,  1160,   223,
     548,     0,     0,  1161,  1162,    52,  1163,    53,     0,     0,
       0,     0,  1164,  1165,     0,     0,  1167,  1168,     0,     0,
       0,  1169,   582,    79,    80,    81,   353,     0,    83,    84,
       0,    85,    86,    87,   354,     0,   355,     0,    91,     0,
      93,    94,    95,    96,    97,    98,   583,    99,   100,   101,
     356,   584,     0,   103,   104,   105,   106,   585,   586,     0,
     108,   109,   110,     0,   111,   587,   588,     0,   357,   358,
       0,     0,     0,   359,   360,     0,     0,     0,     0,   361,
       0,     0,     0,     0,     0,     0,     0,     0,   362,     0,
     363,     0,   364,   365,     0,   366,   367,   368,   369,   370,
     371,   372,     0,   373,   374,     0,     0,     0,     0,  1114,
       0,     0,   375,   376,   377,   128,   378,   379,   380,   130,
    1115,   132,  1116,  1117,     0,   381,   382,     0,   383,  1118,
    1119,   384,  1120,  1121,   386,     0,   387,   388,   389,   390,
    1122,     0,     0,   391,   392,   393,     0,   394,   395,  1123,
     396,     0,   397,   398,   144,   399,  1124,  1125,  1126,  1127,
     400,   401,   402,   403,   404,  1128,  1129,   405,     0,   406,
       0,   407,     0,   408,   409,   410,     0,     0,     0,   411,
    1130,   413,   414,     0,   415,   416,     0,   417,     0,   418,
     419,   420,  1131,   421,     0,  1132,  1133,   422,   423,  1134,
       0,   424,     0,   425,   159,     0,   160,   426,     0,   427,
       0,     0,   428,     0,   429,   430,   163,   431,   432,   433,
       0,   434,   435,   436,   437,     0,   164,   165,     0,   438,
     439,   440,  1135,  1136,     0,  1137,     0,     0,   169,   170,
     441,   171,   442,   443,   444,   445,   446,     0,   172,   447,
     173,     0,   448,   449,   450,   451,   452,   453,   454,   455,
     456,   457,   458,   459,   460,  1138,   179,  1139,   707,   461,
     462,   463,   464,   181,     0,   465,   466,   183,   467,  1141,
    1142,  1143,   468,   469,     0,     0,   470,   708,     0,     0,
     471,   472,     0,     0,   186,   187,   188,  1145,   473,   474,
     475,     0,  1146,   191,   476,   477,     0,   478,   479,   480,
     481,   482,   483,  1147,   484,     0,   485,   486,   487,   488,
     489,   490,   491,   492,   493,   494,   495,   198,   496,  1148,
     497,   498,   499,   500,   501,   502,     0,     0,   503,   504,
     505,  1149,   506,   204,   507,   508,   206,   509,  1150,     0,
     510,   511,   512,   513,   514,   515,   516,   517,  1151,   518,
       0,   519,   520,   521,   522,     0,  1152,  1153,     0,   524,
       0,   525,  1154,   526,  1155,  1156,   527,   528,   529,   530,
     531,     0,     0,   532,   533,   534,   535,   536,  1158,     0,
     537,   538,   539,  1159,   540,   221,   541,     0,     0,     0,
     542,   543,   544,   545,   546,   547,     0,   222,    49,     0,
     223,   548,     0,     0,  1161,  1162,    52,  1163,    53,   582,
      79,    80,    81,   353,     0,    83,    84,     0,    85,    86,
      87,   354,  1169,   355,     0,    91,     0,    93,    94,    95,
      96,    97,    98,   583,    99,   100,   101,   356,   584,     0,
     103,   104,   105,   106,   585,   586,     0,   108,   109,   110,
       0,   111,   587,   588,     0,   357,   358,     0,     0,     0,
     359,   360,     0,     0,     0,     0,   361,     0,     0,     0,
       0,     0,     0,     0,     0,   362,     0,   363,     0,   364,
     365,     0,   366,   367,   368,   369,   370,   371,   372,     0,
     373,   374,     0,     0,     0,     0,  1114,     0,     0,   375,
     376,   377,   128,   378,   379,   380,     0,  1115,   132,  1116,
    1117,     0,   381,   382,     0,   383,  1118,  1119,   384,  1120,
    1121,   386,     0,   387,   388,   389,   390,  1122,     0,     0,
     391,   392,   393,     0,   394,   395,  1123,   396,     0,   397,
     398,   144,   399,  1124,  1125,  1126,  1127,   400,   401,   402,
     403,   404,  1128,  1129,   405,     0,   406,     0,   407,     0,
     408,   409,   410,     0,     0,     0,   411,  1130,   413,   414,
       0,   415,   416,     0,     0,     0,   418,   419,   420,  1131,
     421,     0,  1132,  1133,   422,   423,  1134,     0,   424,     0,
     425,   159,     0,   160,   426,     0,   427,     0,     0,   428,
       0,   429,   430,     0,   431,   432,   433,     0,   434,   435,
     436,   437,     0,   164,   165,     0,   438,   439,   440,  1135,
    1136,     0,  1137,     0,     0,   169,   170,   441,   171,   442,
     443,   444,   445,   446,     0,   172,   447,     0,     0,   448,
     449,   450,   451,   452,   453,   454,   455,   456,   457,   458,
     459,   460,  1138,   179,  1139,   707,   461,   462,   463,   464,
     181,     0,   465,   466,   183,   467,  1141,  1142,  1143,   468,
     469,     0,     0,   470,   708,     0,     0,     0,   472,     0,
       0,   186,   187,   188,  1145,   473,   474,   475,     0,  1146,
     191,   476,   477,     0,   478,   479,   480,   481,   482,   483,
    1147,   484,     0,   485,   486,   487,   488,   489,   490,   491,
     492,   493,   494,   495,   198,   496,  1148,   497,   498,   499,
     500,   501,   502,     0,     0,   503,   504,   505,  1149,   506,
     204,   507,   508,     0,   509,  1150,     0,   510,   511,   512,
     513,   514,   515,   516,   517,  1151,   518,     0,   519,   520,
     521,   522,     0,  1152,  1153,     0,   524,     0,   525,  1154,
     526,  1155,  1156,   527,   528,   529,   530,   531,     0,     0,
     532,   533,   534,   535,   536,  1158,     0,   537,   538,   539,
    1159,   540,   221,   541,     0,     0,     0,   542,   543,   544,
     545,   546,   547,     0,   222,    49,     0,   223,   548,     0,
       0,  1161,  1162,    52,  1163,    53,     0,     0,     0,     0,
       0,  1991,     0,     0,  1992,  1993,     0,     0,     0,  1169,
     582,    79,    80,    81,   353,     0,    83,    84,     0,    85,
      86,    87,   354,     0,   355,     0,    91,     0,    93,    94,
      95,    96,    97,    98,   583,    99,   100,   101,   356,   584,
       0,   103,   104,   105,   106,   585,   586,     0,   108,   109,
     110,     0,   111,   587,   588,     0,   357,   358,     0,     0,
       0,   359,   360,     0,     0,     0,     0,   361,     0,     0,
       0,     0,     0,     0,     0,     0,   362,     0,   363,     0,
     364,   365,     0,   366,   367,   368,   369,   370,   371,   372,
   -1094,   373,   374,     0,     0,     0, -1094,  1114,     0,     0,
     375,   376,   377,   128,   378,   379,   380,     0,  1115,   132,
    1116,  1117,     0,   381,   382,     0,   383,  1118,  1119,   384,
    1120,  1121,   386,     0,   387,   388,   389,   390,  1122,     0,
       0,   391,   392,   393,     0,   394,   395,  1123,   396,     0,
     397,   398,   144,   399,  1124,  1125,  1126,  1127,   400,   401,
     402,   403,   404,  1128,  1129,   405,     0,   406,     0,   407,
       0,   408,   409,   410,     0,     0,     0,   411,  1130,   413,
     414,     0,   415,   416,     0,     0,     0,   418,   419,   420,
    1131,   421,     0,  1132,  1133,   422,   423,  1134,     0,   424,
       0,   425,   159,     0,   160,   426,     0,   427,     0,     0,
     428,     0,   429,   430,     0,   431,   432,   433,     0,   434,
     435,   436,   437,     0,   164,   165,     0,   438,   439,   440,
    1135,  1136,     0,  1137,     0,     0,     0,     0,   441,   171,
     442,   443,   444,   445,   446,     0,   172,   447,     0,     0,
     448,   449,   450,   451,   452,   453,   454,   455,   456,   457,
     458,   459,   460,  1138,   179,  1139,   707,   461,   462,   463,
     464,   181,     0,   465,   466,     0,   467,  1141,  1142,  1143,
     468,   469,     0,     0,   470,   708,     0,     0,     0,   472,
       0,     0,   186,   187,   188,  1145,   473,   474,   475,     0,
    1146,   191,   476,   477,     0,   478,   479,   480,   481,   482,
     483,  1147,   484,     0,   485,   486,   487,   488,   489,   490,
     491,   492,   493,   494,   495,   198,   496,  1148,   497,   498,
     499,   500,   501,   502,     0,     0,   503,   504,   505,  1149,
     506,   204,   507,   508,     0,   509,  1150, -1094,   510,   511,
     512,   513,   514,   515,   516,   517,  1151,   518,     0,   519,
     520,   521,   522,     0,  1152,  1153,     0,   524,     0,   525,
    1154,   526,  1155,  1156,   527,   528,   529,   530,   531,     0,
    1157,   532,   533,   534,   535,   536,  1158,     0,   537,   538,
     539,  1159,   540,   221,   541,     0,     0,     0,   542,   543,
     544,   545,   546,   547,     0,   222,    49,     0,   223,   548,
       0,     0,  1161,  1162,    52,  1163,    53,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1168,     0,     0,     0,
    1169,   582,    79,    80,    81,   353,     0,    83,    84,     0,
      85,    86,    87,   354,     0,   355,     0,    91,     0,    93,
      94,    95,    96,    97,    98,   583,    99,   100,   101,   356,
     584,     0,   103,   104,   105,   106,   585,   586,     0,   108,
     109,   110,     0,   111,   587,   588,     0,   357,   358,     0,
       0,     0,   359,   360,     0,     0,     0,     0,   361,     0,
       0,     0,     0,     0,     0,     0,     0,   362,     0,   363,
       0,   364,   365,     0,   366,   367,   368,   369,   370,   371,
     372, -1095,   373,   374,     0,     0,     0, -1095,  1114,     0,
       0,   375,   376,   377,   128,   378,   379,   380,     0,  1115,
     132,  1116,  1117,     0,   381,   382,     0,   383,  1118,  1119,
     384,  1120,  1121,   386,     0,   387,   388,   389,   390,  1122,
       0,     0,   391,   392,   393,     0,   394,   395,  1123,   396,
       0,   397,   398,   144,   399,  1124,  1125,  1126,  1127,   400,
     401,   402,   403,   404,  1128,  1129,   405,     0,   406,     0,
     407,     0,   408,   409,   410,     0,     0,     0,   411,  1130,
     413,   414,     0,   415,   416,     0,     0,     0,   418,   419,
     420,  1131,   421,     0,  1132,  1133,   422,   423,  1134,     0,
     424,     0,   425,   159,     0,   160,   426,     0,   427,     0,
       0,   428,     0,   429,   430,     0,   431,   432,   433,     0,
     434,   435,   436,   437,     0,   164,   165,     0,   438,   439,
     440,  1135,  1136,     0,  1137,     0,     0,     0,     0,   441,
     171,   442,   443,   444,   445,   446,     0,   172,   447,     0,
       0,   448,   449,   450,   451,   452,   453,   454,   455,   456,
     457,   458,   459,   460,  1138,   179,  1139,   707,   461,   462,
     463,   464,   181,     0,   465,   466,     0,   467,  1141,  1142,
    1143,   468,   469,     0,     0,   470,   708,     0,     0,     0,
     472,     0,     0,   186,   187,   188,  1145,   473,   474,   475,
       0,  1146,   191,   476,   477,     0,   478,   479,   480,   481,
     482,   483,  1147,   484,     0,   485,   486,   487,   488,   489,
     490,   491,   492,   493,   494,   495,   198,   496,  1148,   497,
     498,   499,   500,   501,   502,     0,     0,   503,   504,   505,
    1149,   506,   204,   507,   508,     0,   509,  1150, -1095,   510,
     511,   512,   513,   514,   515,   516,   517,  1151,   518,     0,
     519,   520,   521,   522,     0,  1152,  1153,     0,   524,     0,
     525,  1154,   526,  1155,  1156,   527,   528,   529,   530,   531,
       0,  1157,   532,   533,   534,   535,   536,  1158,     0,   537,
     538,   539,  1159,   540,   221,   541,     0,     0,     0,   542,
     543,   544,   545,   546,   547,     0,   222,    49,     0,   223,
     548,     0,     0,  1161,  1162,    52,  1163,    53,   582,    79,
      80,    81,   353,     0,    83,    84,     0,    85,    86,    87,
     354,  1169,   355,     0,    91,     0,    93,    94,    95,    96,
      97,    98,   583,    99,   100,   101,   356,   584,     0,   103,
     104,   105,   106,   585,   586,     0,   108,   109,   110,     0,
     111,   587,   588,     0,   357,   358,     0,     0,     0,   359,
     360,     0,     0,     0,     0,   361,     0,     0,     0,     0,
       0,     0,     0,     0,   362,     0,   363,     0,   364,   365,
       0,   366,   367,   368,   369,   370,   371,   372,     0,   373,
     374,     0,     0,     0,     0,  1114,     0,     0,   375,   376,
     377,   128,   378,   379,   380,     0,  1115,   132,  1116,  1117,
       0,   381,   382,     0,   383,  1118,  1119,   384,  1120,  1121,
     386,     0,   387,   388,   389,   390,  1122,     0,     0,   391,
     392,   393,     0,   394,   395,  1123,   396,     0,   397,   398,
     144,   399,  1124,  1125,  1126,  1127,   400,   401,   402,   403,
     404,  1128,  1129,   405,     0,   406,     0,   407,     0,   408,
     409,   410,     0,     0,     0,   411,  1130,   413,   414,     0,
     415,   416,     0,     0,     0,   418,   419,   420,  1131,   421,
       0,  1132,  1133,   422,   423,  1134,     0,   424,     0,   425,
     159,     0,   160,   426,     0,   427,     0,     0,   428,     0,
     429,   430,     0,   431,   432,   433,     0,   434,   435,   436,
     437,     0,   164,   165,     0,   438,   439,   440,  1135,  1136,
       0,  1137,     0,     0,     0,     0,   441,   171,   442,   443,
     444,   445,   446,     0,   172,   447,     0,     0,   448,   449,
     450,   451,   452,   453,   454,   455,   456,   457,   458,   459,
     460,  1138,   179,  1139,   707,   461,   462,   463,   464,   181,
       0,   465,   466,     0,   467,     0,  1142,  1143,   468,   469,
       0,     0,   470,   708,     0,     0,     0,   472,     0,     0,
     186,   187,   188,  1145,   473,   474,   475,     0,  1146,   191,
     476,   477,     0,   478,   479,   480,   481,   482,   483,  1147,
     484,     0,   485,   486,   487,   488,   489,   490,   491,   492,
     493,   494,   495,   198,   496,  1148,   497,   498,   499,   500,
     501,   502,     0,     0,   503,   504,   505,  1149,   506,   204,
     507,   508,     0,   509,  1150,     0,   510,   511,   512,   513,
     514,   515,   516,   517,  1151,   518,     0,   519,   520,   521,
     522,     0,  1152,  1153,     0,   524,     0,   525,  1154,   526,
    1155,  1156,   527,   528,   529,   530,   531,     0,     0,   532,
     533,   534,   535,   536,  1158,     0,   537,   538,   539,  1159,
     540,   221,   541,     0,     0,     0,   542,   543,   544,   545,
     546,   547,     0,   222,    49,     0,   223,   548,     0,     0,
    1161,  1162,    52,  1163,    53,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1993,     0,     0,     0,  1169,   582,
      79,    80,    81,   353,     0,    83,    84,     0,    85,    86,
      87,   354,     0,   355,     0,    91,     0,    93,    94,    95,
      96,    97,    98,   583,    99,   100,   101,   356,   584,     0,
     103,   104,   105,   106,   585,   586,     0,   108,   109,   110,
       0,   111,   587,   588,     0,   357,   358,     0,     0,     0,
     359,   360,     0,     0,     0,     0,   361,     0,     0,     0,
       0,     0,     0,     0,     0,   362,     0,   363,     0,   364,
     365,     0,   366,   367,   368,   369,   370,   371,   372,     0,
     373,   374,     0,     0,     0,     0,  1114,     0,     0,   375,
     376,   377,   128,   378,   379,   380,     0,  1115,   132,  1116,
    1117,     0,   381,   382,     0,   383,  1118,  1119,   384,  1120,
    1121,   386,     0,   387,   388,   389,   390,  1122,     0,     0,
     391,   392,   393,     0,   394,   395,  1123,   396,     0,   397,
     398,   144,   399,  1124,  1125,  1126,  1127,   400,   401,   402,
     403,   404,  1128,  1129,   405,     0,   406,     0,   407,     0,
     408,   409,   410,     0,     0,     0,   411,  1130,   413,   414,
       0,   415,   416,     0,     0,     0,   418,   419,   420,  1131,
     421,     0,  1132,  1133,   422,   423,  1134,     0,   424,     0,
     425,   159,     0,   160,   426,     0,   427,     0,     0,   428,
       0,   429,   430,     0,   431,   432,   433,     0,   434,   435,
     436,   437,     0,   164,   165,     0,   438,   439,   440,  1135,
    1136,     0,  1137,     0,     0,     0,     0,   441,   171,   442,
     443,   444,   445,   446,     0,   172,   447,     0,     0,   448,
     449,   450,   451,   452,   453,   454,   455,   456,   457,   458,
     459,   460,  1138,   179,  1139,   707,   461,   462,   463,   464,
     181,     0,   465,   466,     0,   467,     0,  1142,  1143,   468,
     469,     0,     0,   470,   708,     0,     0,     0,   472,     0,
       0,   186,   187,   188,  1145,   473,   474,   475,     0,  1146,
     191,   476,   477,     0,   478,   479,   480,   481,   482,   483,
    1147,   484,     0,   485,   486,   487,   488,   489,   490,   491,
     492,   493,   494,   495,   198,   496,  1148,   497,   498,   499,
     500,   501,   502,     0,     0,   503,   504,   505,  1149,   506,
     204,   507,   508,     0,   509,  1150,     0,   510,   511,   512,
     513,   514,   515,   516,   517,  1151,   518,     0,   519,   520,
     521,   522,     0,  1152,  1153,     0,   524,     0,   525,  1154,
     526,  1155,  1156,   527,   528,   529,   530,   531,     0,     0,
     532,   533,   534,   535,   536,  1158,     0,   537,   538,   539,
    1159,   540,   221,   541,     0,     0,     0,   542,   543,   544,
     545,   546,   547,     0,   222,    49,     0,   223,   548,     0,
       0,  1161,  1162,    52,  1163,    53,     0,    79,    80,    81,
     353,     0,    83,    84,     0,    85,    86,    87,   354,  1169,
     355,     0,    91,     0,    93,    94,    95,    96,    97,    98,
       0,    99,   100,   101,   356,     0,     0,   103,   104,   105,
     106,     0,     0,     0,   108,   109,   110,     0,   111,     0,
       0,     0,   357,   358,     0,     0,     0,   359,   360,     0,
       0,     0,     0,   361,     0,     0,     0,     0,     0,     0,
       0,     0,   362,     0,   363,     0,   364,   365,     0,   366,
     367,   368,   369,   370,   371,   372,     0,   373,   374,     0,
       0,     0,     0,     0,  2700,     0,   375,   376,   377,     0,
     378,   379,   380,     0,   131,     0,   133,     0,     0,   381,
     382,     0,   383,     0,     0,   384,   385,   134,   386,     0,
     387,   388,   389,   390,   138,     0,     0,   391,   392,   393,
       0,   394,   395,   141,   396,     0,   397,   398,     0,   399,
       0,     0,     0,     0,   400,   401,   402,   403,   404,   147,
     148,   405,     0,   406,     0,   407,     0,   408,   409,   410,
       0,     0,     0,   411,   412,   413,   414,     0,   415,   416,
       0,   417,  -777,   418,   419,   420,   154,   421,     0,   156,
       0,   422,   423,   158,  -777,   424,     0,   425,     0,     0,
       0,   426,     0,   427,     0,     0,   428,     0,   429,   430,
       0,   431,   432,   433,     0,   434,   435,   436,   437,     0,
       0,   165,     0,   438,   439,   440,     0,   167,  -777,   168,
       0,     0,     0,     0,   441,     0,   442,   443,   444,   445,
     446,     0,     0,   447,     0,  -777,   448,   449,   450,   451,
     452,   453,   454,   455,   456,   457,   458,   459,   460,   178,
       0,   180,     0,   461,   462,   463,   464,   181,     0,   465,
     466,     0,   467,     0,   184,   185,   468,   469,     0,  -777,
     470,     0,     0,     0,   471,   472,     0,  -777,   186,     0,
       0,   189,   473,   474,   475,     0,   190,   191,   476,   477,
       0,   478,   479,   480,   481,   482,   483,   193,   484,     0,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,     0,   496,   200,   497,   498,   499,   500,   501,   502,
       0,     0,   503,   504,   505,     0,   506,   204,   507,   508,
       0,   509,   207,     0,   510,   511,   512,   513,   514,   515,
     516,   517,   209,   518,     0,   519,   520,   521,   522,     0,
     210,   211,     0,   524,     0,   525,   212,   526,   213,     0,
     527,   528,   529,   530,   531,  -777,     0,   532,   533,   534,
     535,   536,     0,     0,   537,   538,   539,   220,   540,     0,
     541,     0,     0,     4,   542,   543,   544,   545,   546,   547,
       0,   222,     0,     0,   223,     0,     0,     0,     5,     0,
       0,     0,     0,     0,     0,     0,     0,     6,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1245,     7,     8,
       0,     0,     0,     0,     0,     0,    10,    11,     0,     0,
       0,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,    35,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    36,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      37,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    38,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    39,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      40,     0,     0,    41,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    43,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    44,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    45,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    46,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    47,     0,     0,    48,    49,
       0,    50,     0,     0,     0,     0,     0,    52,     0,    53,
      54,     0,     0,     0,    55,    56,    57,    58,    59,     0,
       0,    60,    61,   932,    79,    80,    81,   353,     0,    83,
      84,     0,    85,    86,    87,   354,     0,   355,     0,    91,
       0,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,   356,     0,     0,   103,   104,   105,   106,     0,     0,
       0,   108,   109,   110,     0,   111,     0,     0,     0,   357,
     358,     0,     0,     0,   359,   360,     0,     0,     0,     0,
     361,     0,     0,     0,     0,     0,     0,     0,     0,   362,
       0,   363,     0,   364,   365,     0,   366,   367,   368,   369,
     370,   371,   372,     0,   373,   374,     0,     0,     0,     0,
       0,     0,     0,   375,   376,   377,   128,   378,   379,   380,
     130,   131,   132,   133,     0,     0,   381,   382,     0,   383,
       0,  1119,   384,   385,   134,   386,     0,   387,   388,   389,
     390,  1122,     0,     0,   391,   392,   393,     0,   394,   395,
    1123,   396,     0,   397,   398,   144,   399,  1124,  1125,  1126,
    1127,   400,   401,   402,   403,   404,   147,   148,   405,     0,
     406,     0,   407,     0,   408,   409,   410,     0,     0,     0,
     411,   412,   413,   414,     0,   415,   416,     0,   417,     0,
     418,   419,   420,   154,   421,     0,  1132,     0,   422,   423,
     158,     0,   424,     0,   425,   159,     0,   160,   426,     0,
     427,     0,     0,   428,     0,   429,   430,   163,   431,   432,
     433,     0,   434,   435,   436,   437,     0,   164,   165,     0,
     438,   439,   440,     0,   167,     0,   168,     0,     0,   169,
     170,   441,   171,   442,   443,   444,   445,   446,     0,   172,
     447,   173,     0,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   178,   179,   180,   707,
     461,   462,   463,   464,   181,     0,   465,   466,   183,   467,
       0,  1142,   185,   468,   469,     0,     0,   470,   708,     0,
     869,   471,   472,     0,     0,   186,   187,   188,  1145,   473,
     474,   475,     0,  1146,   191,   476,   477,     0,   478,   479,
     480,   481,   482,   483,   193,   484,     0,   485,   486,   487,
     488,   489,   490,   491,   492,   493,   494,   495,   198,   496,
     200,   497,   498,   499,   500,   501,   502,     0,   202,   503,
     504,   505,  1149,   506,   204,   507,   508,   206,   509,   207,
       0,   510,   511,   512,   513,   514,   515,   516,   517,  1151,
     518,     0,   519,   520,   521,   522,     0,   210,   211,     0,
     524,     0,   525,  1154,   526,  1155,     0,   527,   528,   529,
     530,   531,     0,     0,   532,   533,   534,   535,   536,  1158,
       0,   537,   538,   539,   220,   540,   221,   541,     0,     0,
       0,   542,   543,   544,   545,   546,   547,     0,   222,     0,
       0,   223,     0,     0,     0,     0,     0,    79,    80,    81,
     353,     0,    83,    84,     0,    85,    86,    87,   354,     0,
     355,     0,    91,  2426,    93,    94,    95,    96,    97,    98,
       0,    99,   100,   101,   356,     0,     0,   103,   104,   105,
     106,     0,     0,     0,   108,   109,   110,     0,   111,     0,
       0,     0,   357,   358,     0,     0,     0,   359,   360,     0,
       0,     0,     0,   361,     0,     0,     0,     0,     0,     0,
       0,     0,   362,     0,   363,     0,   364,   365,     0,   366,
     367,   368,   369,   370,   371,   372,     0,   373,   374,     0,
       0,     0,     0,     0,     0,     0,   375,   376,   377,   128,
     378,   379,   380,   130,   131,   132,   133,     0,     0,   381,
     382,     0,   383,     0,  1119,   384,   385,   134,   386,     0,
     387,   388,   389,   390,  1122,     0,     0,   391,   392,   393,
       0,   394,   395,  1123,   396,     0,   397,   398,   144,   399,
    1124,  1125,  1126,  1127,   400,   401,   402,   403,   404,   147,
     148,   405,     0,   406,     0,   407,     0,   408,   409,   410,
       0,     0,     0,   411,   412,   413,   414,     0,   415,   416,
       0,   417,     0,   418,   419,   420,   154,   421,     0,  1132,
       0,   422,   423,   158,     0,   424,     0,   425,   159,     0,
     160,   426,     0,   427,     0,     0,   428,     0,   429,   430,
     163,   431,   432,   433,     0,   434,   435,   436,   437,     0,
     164,   165,     0,   438,   439,   440,     0,   167,     0,   168,
       0,     0,   169,   170,   441,   171,   442,   443,   444,   445,
     446,     0,   172,   447,   173,     0,   448,   449,   450,   451,
     452,   453,   454,   455,   456,   457,   458,   459,   460,   178,
     179,   180,   707,   461,   462,   463,   464,   181,     0,   465,
     466,   183,   467,     0,  1142,   185,   468,   469,     0,     0,
     470,   708,     0,   869,   471,   472,     0,     0,   186,   187,
     188,  1145,   473,   474,   475,     0,  1146,   191,   476,   477,
       0,   478,   479,   480,   481,   482,   483,   193,   484,     0,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   198,   496,   200,   497,   498,   499,   500,   501,   502,
       0,     0,   503,   504,   505,  1149,   506,   204,   507,   508,
     206,   509,   207,     0,   510,   511,   512,   513,   514,   515,
     516,   517,  1151,   518,     0,   519,   520,   521,   522,     0,
     210,   211,     0,   524,     0,   525,  1154,   526,  1155,     0,
     527,   528,   529,   530,   531,     0,     0,   532,   533,   534,
     535,   536,  1158,     0,   537,   538,   539,   220,   540,   221,
     541,     0,     0,     0,   542,   543,   544,   545,   546,   547,
       0,   222,     0,     0,   223,     0,     0,     0,     0,     0,
      79,    80,    81,   353,     0,    83,    84,     0,    85,    86,
      87,   354,     0,   355,     0,    91,  2426,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,   356,     0,     0,
     103,   104,   105,   106,     0,     0,     0,   108,   109,   110,
       0,   111,     0,     0,     0,   357,   358,     0,     0,     0,
     359,   360,     0,     0,     0,     0,   361,     0,     0,     0,
       0,     0,     0,     0,     0,   362,     0,   363,     0,   364,
     365,     0,   366,   367,   368,   369,   370,   371,   372,     0,
     373,   374,     0,     0,     0,     0,     0,     0,     0,   375,
     376,   377,   128,   378,   379,   380,   130,   131,   132,   133,
       0,     0,   381,   382,     0,   383,     0,  1119,   384,   385,
     134,   386,     0,   387,   388,   389,   390,  1122,     0,     0,
     391,   392,   393,     0,   394,   395,  1123,   396,     0,   397,
     398,   144,   399,  1124,  1125,  1126,  1127,   400,   401,   402,
     403,   404,   147,   148,   405,     0,   406,     0,   407,     0,
     408,   409,   410,     0,     0,     0,   411,   412,   413,   414,
       0,   415,   416,     0,   417,     0,   418,   419,   420,   154,
     421,     0,  1132,     0,   422,   423,   158,     0,   424,     0,
     425,   159,     0,   160,   426,     0,   427,     0,     0,   428,
       0,   429,   430,   163,   431,   432,   433,     0,   434,   435,
     436,   437,     0,   164,   165,     0,   438,   439,   440,     0,
     167,     0,   168,     0,     0,   169,   170,   441,   171,   442,
     443,   444,   445,   446,     0,   172,   447,   173,     0,   448,
     449,   450,   451,   452,   453,   454,   455,   456,   457,   458,
     459,   460,   178,   179,   180,   707,   461,   462,   463,   464,
     181,     0,   465,   466,   183,   467,     0,  1142,   185,   468,
     469,     0,     0,   470,   708,     0,     0,   471,   472,     0,
       0,   186,   187,   188,  1145,   473,   474,   475,     0,  1146,
     191,   476,   477,     0,   478,   479,   480,   481,   482,   483,
     193,   484,     0,   485,   486,   487,   488,   489,   490,   491,
     492,   493,   494,   495,   198,   496,   200,   497,   498,   499,
     500,   501,   502,     0,     0,   503,   504,   505,  1149,   506,
     204,   507,   508,   206,   509,   207,     0,   510,   511,   512,
     513,   514,   515,   516,   517,  1151,   518,     0,   519,   520,
     521,   522,     0,   210,   211,     0,   524,     0,   525,  1154,
     526,  1155,     0,   527,   528,   529,   530,   531,     0,     0,
     532,   533,   534,   535,   536,  1158,     0,   537,   538,   539,
     220,   540,   221,   541,     0,     0,     0,   542,   543,   544,
     545,   546,   547,     0,   222,     0,     0,   223,     0,     0,
       0,     0,     0,    79,    80,    81,   353,     0,    83,    84,
       0,    85,    86,    87,   354,     0,   355,     0,    91,  2951,
      93,    94,    95,    96,    97,    98,     0,    99,   100,   101,
     356,     0,     0,   103,   104,   105,   106,     0,     0,     0,
     108,   109,   110,     0,   111,     0,     0,     0,   357,   358,
       0,     0,     0,   359,   360,     0,     0,     0,     0,   361,
       0,     0,     0,     0,     0,     0,     0,     0,   362,     0,
     363,     0,   364,   365,     0,   366,   367,   368,   369,   370,
     371,   372,     0,   373,   374,     0,     0,     0,     0,     0,
       0,     0,   375,   376,   377,     0,   378,   379,   380,     0,
     131,     0,   133,     0,     0,   381,   382,     0,   383,     0,
       0,   384,   385,   134,   386,     0,   387,   388,   389,   390,
     138,     0,     0,   391,   392,   393,     0,   394,   395,   141,
     396,     0,   397,   398,     0,   399,     0,     0,     0,     0,
     400,   401,   402,   403,   404,   147,   148,   405,     0,   406,
       0,   407,     0,   408,   409,   410,     0,     0,     0,   411,
     412,   413,   414,     0,   415,   416,     0,   417,     0,   418,
     419,   420,   154,   421,     0,   156,     0,   422,   423,   158,
       0,   424,     0,   425,     0,     0,     0,   426,     0,   427,
       0,     0,   428,     0,   429,   430,     0,   431,   432,   433,
       0,   434,   435,   436,   437,     0,     0,   165,     0,   438,
     439,   440,     0,   167,     0,   168,     0,     0,     0,     0,
     441,     0,   442,   443,   444,   445,   446,     0,     0,   447,
       0,     0,   448,   449,   450,   451,   452,   453,   454,   455,
     456,   457,   458,   459,   460,   178,     0,   180,     0,   461,
     462,   463,   464,   181,     0,   465,   466,     0,   467,     0,
     184,   185,   468,   469,     0,     0,   470,     0,     0,     0,
     471,   472,     0,     0,   186,     0,     0,   189,   473,   474,
     475,     0,   190,   191,   476,   477,     0,   478,   479,   480,
     481,   482,   483,   193,   484,     0,   485,   486,   487,   488,
     489,   490,   491,   492,   493,   494,   495,     0,   496,   200,
     497,   498,   499,   500,   501,   502,     0,     0,   503,   504,
     505,     0,   506,   204,   507,   508,     0,   509,   207,     0,
     510,   511,   512,   513,   514,   515,   516,   517,   209,   518,
       0,   519,   520,   521,   522,     0,   210,   211,     0,   524,
       0,   525,   212,   526,   213,     0,   527,   528,   529,   530,
     531,     0,     0,   532,   533,   534,   535,   536,     0,     0,
     537,   538,   539,   220,   540,     0,   541,     0,     0,     0,
     542,   543,   544,   545,   546,   547,     0,   222,    49,     0,
     223,   548,     0,     0,     0,     0,    52,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2230,  2231,    79,    80,    81,   353,     0,    83,    84,
       0,    85,    86,    87,   354,     0,   355,     0,    91,     0,
      93,    94,    95,    96,    97,    98,     0,    99,   100,   101,
     356,     0,     0,   103,   104,   105,   106,     0,     0,     0,
     108,   109,   110,     0,   111,     0,     0,     0,   357,   358,
       0,     0,     0,   359,   360,     0,     0,     0,     0,   361,
       0,     0,     0,     0,     0,     0,     0,     0,   362,     0,
     363,     0,   364,   365,     0,   366,   367,   368,   369,   370,
     371,   372,     0,   373,   374,     0,     0,     0,     0,     0,
       0,     0,   375,   376,   377,     0,   378,   379,   380,     0,
     131,     0,   133,     0,     0,   381,   382,     0,   383,     0,
       0,   384,   385,   134,   386,     0,   387,   388,   389,   390,
     138,     0,     0,   391,   392,   393,     0,   394,   395,   141,
     396,     0,   397,   398,     0,   399,     0,     0,     0,     0,
     400,   401,   402,   403,   404,   147,   148,   405,     0,   406,
       0,   407,     0,   408,   409,   410,     0,     0,     0,   411,
     412,   413,   414,     0,   415,   416,     0,   417,     0,   418,
     419,   420,   154,   421,     0,   156,     0,   422,   423,   158,
       0,   424,     0,   425,     0,     0,     0,   426,     0,   427,
       0,     0,   428,     0,   429,   430,     0,   431,   432,   433,
       0,   434,   435,   436,   437,     0,     0,   165,     0,   438,
     439,   440,     0,   167,     0,   168,     0,     0,     0,     0,
     441,     0,   442,   443,   444,   445,   446,     0,     0,   447,
       0,     0,   448,   449,   450,   451,   452,   453,   454,   455,
     456,   457,   458,   459,   460,   178,     0,   180,     0,   461,
     462,   463,   464,   181,     0,   465,   466,     0,   467,     0,
     184,   185,   468,   469,     0,     0,   470,     0,     0,     0,
     471,   472,     0,     0,   186,     0,     0,   189,   473,   474,
     475,     0,   190,   191,   476,   477,     0,   478,   479,   480,
     481,   482,   483,   193,   484,     0,   485,   486,   487,   488,
     489,   490,   491,   492,   493,   494,   495,     0,   496,   200,
     497,   498,   499,   500,   501,   502,     0,     0,   503,   504,
     505,     0,   506,   204,   507,   508,     0,   509,   207,     0,
     510,   511,   512,   513,   514,   515,   516,   517,   209,   518,
       0,   519,   520,   521,   522,     0,   210,   211,     0,   524,
       0,   525,   212,   526,   213,     0,   527,   528,   529,   530,
     531,     0,     0,   532,   533,   534,   535,   536,     0,     0,
     537,   538,   539,   220,   540,     0,   541,     0,     0,     0,
     542,   543,   544,   545,   546,   547,     0,   222,    49,     0,
     223,   548,     0,     0,     0,     0,    52,     0,    79,    80,
      81,   353,     0,    83,    84,     0,    85,    86,    87,   354,
       0,   355,  2231,    91,     0,    93,    94,    95,    96,    97,
      98,     0,    99,   100,   101,   356,     0,     0,   103,   104,
     105,   106,     0,     0,     0,   108,   109,   110,     0,   111,
       0,     0,     0,   357,   358,     0,     0,     0,   359,   360,
       0,     0,     0,     0,   361,     0,     0,     0,     0,     0,
       0,     0,     0,   362,     0,   363,     0,   364,   365,     0,
     366,   367,   368,   369,   370,   371,   372,     0,   373,   374,
       0,     0,     0,     0,     0,     0,     0,   375,   376,   377,
       0,   378,   379,   380,     0,   131,     0,   133,     0,     0,
     381,   382,     0,   383,     0,     0,   384,   385,   134,   386,
       0,   387,   388,   389,   390,   138,     0,     0,   391,   392,
     393,     0,   394,   395,   141,   396,     0,   397,   398,     0,
     399,     0,     0,     0,     0,   400,   401,   402,   403,   404,
     147,   148,   405,     0,   406,     0,   407,     0,   408,   409,
     410,     0,     0,     0,   411,   412,   413,   414,     0,   415,
     416,     0,   417,     0,   418,   419,   420,   154,   421,     0,
     156,     0,   422,   423,   158,     0,   424,     0,   425,     0,
       0,     0,   426,     0,   427,     0,     0,   428,     0,   429,
     430,     0,   431,   432,   433,     0,   434,   435,   436,   437,
       0,     0,   165,     0,   438,   439,   440,     0,   167,     0,
     168,     0,     0,     0,     0,   441,     0,   442,   443,   444,
     445,   446,     0,     0,   447,     0,     0,   448,   449,   450,
     451,   452,   453,   454,   455,   456,   457,   458,   459,   460,
     178,     0,   180,   707,   461,   462,   463,   464,   181,     0,
     465,   466,     0,   467,     0,   184,   185,   468,   469,     0,
       0,   470,   708,     0,     0,   471,   472,     0,     0,   186,
       0,     0,   189,   473,   474,   475,     0,   190,   191,   476,
     477,     0,   478,   479,   480,   481,   482,   483,   193,   484,
       0,   485,   486,   487,   488,   489,   490,   491,   492,   493,
     494,   495,     0,   496,   200,   497,   498,   499,   500,   501,
     502,     0,     0,   503,   504,   505,     0,   506,   204,   507,
     508,     0,   509,   207,     0,   510,   511,   512,   513,   514,
     515,   516,   517,   209,   518,     0,   519,   520,   521,   522,
       0,   210,   211,     0,   524,     0,   525,   212,   526,   213,
       0,   527,   528,   529,   530,   531,     0,     0,   532,   533,
     534,   535,   536,     0,     0,   537,   538,   539,   220,   540,
       0,   541,     0,     0,     0,   542,   543,   544,   545,   546,
     547,     0,   222,     0,     0,   223,     0,     0,     0,     0,
       0,    79,    80,    81,   353,     0,    83,    84,     0,    85,
      86,    87,   354,     0,   355,     0,    91,  1239,    93,    94,
      95,    96,    97,    98,     0,    99,   100,   101,   356,     0,
       0,   103,   104,   105,   106,     0,     0,     0,   108,   109,
     110,     0,   111,     0,     0,     0,   357,   358,     0,     0,
       0,   359,   360,     0,     0,     0,     0,   361,     0,     0,
       0,     0,     0,     0,     0,     0,   362,     0,   363,     0,
     364,   365,     0,   366,   367,   368,   369,   370,   371,   372,
       0,   373,   374,     0,     0,     0,     0,     0,     0,     0,
     375,   376,   377,     0,   378,   379,   380,     0,   131,     0,
     133,     0,     0,   381,   382,     0,   383,     0,     0,   384,
     385,   134,   386,     0,   387,   388,   389,   390,   138,     0,
       0,   391,   392,   393,     0,   394,   395,   141,   396,     0,
     397,   398,     0,   399,     0,     0,     0,     0,   400,   401,
     402,   403,   404,   147,   148,   405,     0,   406,     0,   407,
       0,   408,   409,   410,     0,     0,     0,   411,   412,   413,
     414,     0,   415,   416,     0,   417,     0,   418,   419,   420,
     154,   421,     0,   156,     0,   422,   423,   158,     0,   424,
       0,   425,     0,     0,     0,   426,     0,   427,     0,     0,
     428,     0,   429,   430,     0,   431,   432,   433,     0,   434,
     435,   436,   437,     0,     0,   165,     0,   438,   439,   440,
       0,   167,     0,   168,     0,     0,     0,     0,   441,     0,
     442,   443,   444,   445,   446,     0,     0,   447,     0,     0,
     448,   449,   450,   451,   452,   453,   454,   455,   456,   457,
     458,   459,   460,   178,     0,   180,     0,   461,   462,   463,
     464,   181,     0,   465,   466,     0,   467,     0,   184,   185,
     468,   469,     0,     0,   470,     0,     0,     0,   471,   472,
       0,     0,   186,     0,     0,   189,   473,   474,   475,     0,
     190,   191,   476,   477,     0,   478,   479,   480,   481,   482,
     483,   193,   484,     0,   485,   486,   487,   488,   489,   490,
     491,   492,   493,   494,   495,     0,   496,   200,   497,   498,
     499,   500,   501,   502,     0,   202,   503,   504,   505,     0,
     506,   204,   507,   508,     0,   509,   207,     0,   510,   511,
     512,   513,   514,   515,   516,   517,   209,   518,     0,   519,
     520,   521,   522,     0,   210,   211,     0,   524,     0,   525,
     212,   526,   213,     0,   527,   528,   529,   530,   531,     0,
       0,   532,   533,   534,   535,   536,     0,     0,   537,   538,
     539,   220,   540,     0,   541,     0,     0,     0,   542,   543,
     544,   545,   546,   547,     0,   222,     0,     0,   223,   548,
       0,     0,     0,     0,    79,    80,    81,   353,     0,    83,
      84,     0,    85,    86,    87,   354,     0,   355,     0,    91,
     224,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,   356,     0,     0,   103,   104,   105,   106,     0,     0,
       0,   108,   109,   110,     0,   111,     0,     0,     0,   357,
     358,     0,     0,     0,   359,   360,     0,     0,     0,     0,
     361,     0,     0,     0,     0,     0,     0,     0,     0,   362,
       0,   363,     0,   364,   365,     0,   366,   367,   368,   369,
     370,   371,   372,     0,   373,   374,     0,     0,     0,     0,
       0,     0,     0,   375,   376,   377,     0,   378,   379,   380,
       0,   131,     0,   133,     0,     0,   381,   382,     0,   383,
       0,     0,   384,   385,   134,   386,     0,   387,   388,   389,
     390,   138,     0,     0,   391,   392,   393,     0,   394,   395,
     141,   396,     0,   397,   398,     0,   399,     0,     0,     0,
       0,   400,   401,   402,   403,   404,   147,   148,   405,     0,
     406,     0,   407,     0,   408,   409,   410,     0,     0,     0,
     411,   412,   413,   414,     0,   415,   416,     0,   417,     0,
     418,   419,   420,   154,   421,     0,   156,     0,   422,   423,
     158,     0,   424,     0,   425,     0,     0,     0,   426,     0,
     427,     0,     0,   428,     0,   429,   430,     0,   431,   432,
     433,     0,   434,   435,   436,   437,     0,     0,   165,     0,
     438,   439,   440,     0,   167,     0,   168,     0,     0,     0,
       0,   441,     0,   442,   443,   444,   445,   446,     0,     0,
     447,     0,     0,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   178,     0,   180,     0,
     461,   462,   463,   464,   181,     0,   465,   466,     0,   467,
       0,   184,   185,   468,   469,     0,     0,   470,     0,     0,
       0,   471,   472,     0,     0,   186,     0,     0,   189,   473,
     474,   475,     0,   190,   191,   476,   477,     0,   478,   479,
     480,   481,   482,   483,   193,   484,     0,   485,   486,   487,
     488,   489,   490,   491,   492,   493,   494,   495,     0,   496,
     200,   497,   498,   499,   500,   501,   502,     0,   202,   503,
     504,   505,     0,   506,   204,   507,   508,     0,   509,   207,
       0,   510,   511,   512,   513,   514,   515,   516,   517,   209,
     518,     0,   519,   520,   521,   522,     0,   210,   211,     0,
     524,     0,   525,   212,   526,   213,     0,   527,   528,   529,
     530,   531,     0,     0,   532,   533,   534,   535,   536,     0,
       0,   537,   538,   539,   220,   540,     0,   541,     0,     0,
       0,   542,   543,   544,   545,   546,   547,     0,   222,     0,
       0,   223,     0,     0,     0,     0,     0,    79,    80,    81,
     353,     0,    83,    84,     0,    85,    86,    87,   354,     0,
     355,     0,    91,   224,    93,    94,    95,    96,    97,    98,
       0,    99,   100,   101,   356,     0,     0,   103,   104,   105,
     106,     0,     0,     0,   108,   109,   110,     0,   111,     0,
       0,     0,   357,   358,     0,     0,     0,   359,   360,     0,
       0,     0,     0,   361,     0,     0,     0,     0,     0,     0,
       0,     0,   362,     0,   363,     0,   364,   365,     0,   366,
     367,   368,   369,   370,   371,   372,     0,   373,   374,     0,
       0,     0,     0,     0,     0,     0,   375,   376,   377,     0,
     378,   379,   380,     0,   131,     0,   133,     0,     0,   381,
     382,     0,   383,     0,     0,   384,   385,   134,   386,     0,
     387,   388,   389,   390,   138,     0,     0,   391,   392,   393,
       0,   394,   395,   141,   396,     0,   397,   398,     0,   399,
       0,     0,     0,     0,   400,   401,   402,   403,   404,   147,
     148,   405,     0,   406,     0,   407,     0,   408,   409,   410,
       0,     0,     0,   411,   412,   413,   414,     0,   415,   416,
       0,   417,     0,   418,   419,   420,   154,   421,     0,   156,
       0,   422,   423,   158,     0,   424,     0,   425,     0,     0,
       0,   426,     0,   427,     0,     0,   428,     0,   429,   430,
       0,   431,   432,   433,     0,   434,   435,   436,   437,     0,
       0,   165,     0,   438,   439,   440,     0,   167,     0,   168,
       0,     0,     0,     0,   441,     0,   442,   443,   444,   445,
     446,     0,     0,   447,     0,     0,   448,   449,   450,   451,
     452,   453,   454,   455,   456,   457,   458,   459,   460,   178,
       0,   180,     0,   461,   462,   463,   464,   181,     0,   465,
     466,     0,   467,     0,   184,   185,   468,   469,     0,     0,
     470,     0,     0,     0,   471,   472,     0,     0,   186,     0,
       0,   189,   473,   474,   475,     0,   190,   191,   476,   477,
       0,   478,   479,   480,   481,   482,   483,   193,   484,     0,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,     0,   496,   200,   497,   498,   499,   500,   501,   502,
       0,     0,   503,   504,   505,     0,   506,   204,   507,   508,
       0,   509,   207,     0,   510,   511,   512,   513,   514,   515,
     516,   517,   209,   518,     0,   519,   520,   521,   522,     0,
     210,   211,     0,   524,     0,   525,   212,   526,   213,     0,
     527,   528,   529,   530,   531,     0,     0,   532,   533,   534,
     535,   536,     0,     0,   537,   538,   539,   220,   540,     0,
     541,     0,     0,     0,   542,   543,   544,   545,   546,   547,
       0,   222,     0,     0,   223,     0,     0,     0,     0,     0,
      79,    80,    81,   353,     0,    83,    84,     0,    85,    86,
      87,   354,     0,   355,     0,    91,  1675,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,   356,     0,     0,
     103,   104,   105,   106,     0,     0,     0,   108,   109,   110,
       0,   111,     0,     0,     0,   357,   358,     0,     0,     0,
     359,   360,     0,     0,     0,     0,   361,     0,     0,     0,
       0,     0,     0,     0,     0,   362,     0,   363,     0,   364,
     365,     0,   366,   367,   368,   369,   370,   371,   372,     0,
     373,   374,     0,     0,     0,     0,     0,     0,     0,   375,
     376,   377,     0,   378,   379,   380,     0,   131,     0,   133,
       0,     0,   381,   382,     0,   383,     0,     0,   384,   385,
     134,   386,     0,   387,   388,   389,   390,   138,     0,     0,
     391,   392,   393,     0,   394,   395,   141,   396,     0,   397,
     398,     0,   399,     0,     0,     0,     0,   400,   401,   402,
     403,   404,   147,   148,   405,     0,   406,     0,   407,     0,
     408,   409,   410,     0,     0,     0,   411,   412,   413,   414,
       0,   415,   416,     0,   417,     0,   418,   419,   420,   154,
     421,     0,   156,     0,   422,   423,   158,     0,   424,     0,
     425,     0,     0,     0,   426,     0,   427,     0,     0,   428,
       0,   429,   430,     0,   431,   432,   433,     0,   434,   435,
     436,   437,     0,     0,   165,     0,   438,   439,   440,     0,
     167,     0,   168,     0,     0,     0,     0,   441,     0,   442,
     443,   444,   445,   446,     0,     0,   447,     0,     0,   448,
     449,   450,   451,   452,   453,   454,   455,   456,   457,   458,
     459,   460,   178,     0,   180,     0,   461,   462,   463,   464,
     181,     0,   465,   466,     0,   467,     0,   184,   185,   468,
     469,     0,     0,   470,     0,     0,     0,   471,   472,     0,
       0,   186,     0,     0,   189,   473,   474,   475,     0,   190,
     191,   476,   477,     0,   478,   479,   480,   481,   482,   483,
     193,   484,     0,   485,   486,   487,   488,   489,   490,   491,
     492,   493,   494,   495,     0,   496,   200,   497,   498,   499,
     500,   501,   502,     0,     0,   503,   504,   505,     0,   506,
     204,   507,   508,     0,   509,   207,     0,   510,   511,   512,
     513,   514,   515,   516,   517,   209,   518,     0,   519,   520,
     521,   522,     0,   210,   211,     0,   524,     0,   525,   212,
     526,   213,     0,   527,   528,   529,   530,   531,     0,     0,
     532,   533,   534,   535,   536,     0,     0,   537,   538,   539,
     220,   540,     0,   541,     0,     0,     0,   542,   543,   544,
     545,   546,   547,     0,   222,     0,     0,   223,     0,     0,
       0,     0,   582,    79,    80,    81,   353,     0,    83,    84,
       0,    85,    86,    87,   354,     0,   355,     0,    91,  2881,
      93,    94,    95,    96,    97,    98,   583,    99,   100,   101,
     356,   584,     0,   103,   104,   105,   106,   585,   586,     0,
     108,   109,   110,     0,   111,   587,   588,     0,   357,   358,
       0,     0,     0,   359,   360,     0,     0,     0,     0,   361,
       0,     0,     0,     0,     0,     0,     0,     0,   362,     0,
     363,     0,   364,   365,     0,   366,   367,   368,   369,   370,
     371,   372,     0,   373,   374,     0,     0,     0,     0,     0,
       0,     0,   375,   376,   377,     0,   378,   379,   380,     0,
    1398,     0,  1399,  1117,     0,   381,   382,     0,   383,     0,
       0,   384,  1400,  1401,   386,     0,   387,   388,   389,   390,
       0,     0,     0,   391,   392,   393,     0,   394,   395,     0,
     396,     0,   397,   398,     0,   399,     0,     0,     0,     0,
     400,   401,   402,   403,   404,  1402,  1403,   405,     0,   406,
       0,   407,     0,   408,   409,   410,     0,     0,     0,   411,
    1130,   413,   414,     0,   415,   416,     0,   417,     0,   418,
     419,   420,     0,   421,     0,     0,     0,   422,   423,  1404,
       0,   424,     0,   425,     0,     0,     0,   426,     0,   427,
       0,     0,   428,     0,   429,   430,     0,   431,   432,   433,
       0,   434,   435,   436,   437,     0,     0,     0,     0,   438,
     439,   440,  1135,  1405,     0,  1406,     0,     0,     0,     0,
     441,     0,   442,   443,   444,   445,   446,     0,     0,   447,
       0,     0,   448,   449,   450,   451,   452,   453,   454,   455,
     456,   457,   458,   459,   460,  1407,     0,  1408,     0,   461,
     462,   463,   464,     0,     0,   465,   466,     0,   467,     0,
       0,  1409,   468,   469,     0,     0,   470,     0,     0,     0,
    2535,   472,     0,     0,     0,     0,     0,     0,   473,   474,
     475,     0,     0,     0,   476,   477,     0,   478,   479,   480,
     481,   482,   483,  1410,   484,     0,   485,   486,   487,   488,
     489,   490,   491,   492,   493,   494,   495,     0,   496,     0,
     497,   498,   499,   500,   501,   502,     0,     0,   503,   504,
     505,     0,   506,  1411,   507,   508,     0,   509,  1412,     0,
     510,   511,   512,   513,   514,   515,   516,   517,     0,   518,
       0,   519,   520,   521,   522,     0,  1413,  1414,     0,   524,
       0,   525,     0,   526,     0,     0,   527,   528,   529,   530,
     531,     0,     0,   532,   533,   534,   535,   536,     0,     0,
     537,   538,   539,  1415,   540,     0,   541,     0,     0,     0,
     542,   543,   544,   545,   546,   547,     0,   222,    49,   978,
     223,   548,     0,     0,     0,     0,    52,     0,    53,   979,
     980,   981,     0,   982,  2536,   984,   985,   986,   987,    79,
      80,    81,   353,     0,    83,    84,     0,    85,    86,    87,
     354,     0,   355,     0,    91,     0,    93,    94,    95,    96,
      97,    98,     0,    99,   100,   101,   356,     0,     0,   103,
     104,   105,   106,     0,     0,     0,   108,   109,   110,     0,
     111,     0,     0,     0,   357,   358,     0,     0,     0,   359,
     360,     0,     0,     0,     0,   361,     0,     0,     0,     0,
       0,     0,     0,     0,   362,     0,   363,     0,   364,   365,
       0,   366,   367,   368,   369,   370,   371,   372,     0,   373,
     374,     0,     0,     0,     0,     0,     0,     0,   375,   376,
     377,     0,   378,   379,   380,     0,   131,     0,   133,     0,
       0,   381,   382,     0,   383,     0,     0,   384,   385,   134,
     386,     0,   387,   977,   389,   390,   138,     0,     0,   391,
     392,   393,     0,   394,   395,   141,   396,     0,   397,   398,
       0,   399,     0,     0,     0,     0,   400,   401,   402,   403,
     404,   147,   148,   405,     0,   406,     0,   407,     0,   408,
     409,   410,     0,     0,     0,   411,   412,   413,   414,     0,
     415,   416,     0,   417,     0,   418,   419,   420,   154,   421,
       0,   156,     0,   422,   423,   158,     0,   424,     0,   425,
       0,     0,     0,   426,     0,   427,     0,     0,   428,     0,
     429,   430,     0,   431,   432,   433,     0,   434,   435,   436,
     437,     0,     0,   165,     0,   438,   439,   440,     0,   167,
       0,   168,     0,     0,     0,     0,   441,     0,   442,   443,
     444,   445,   446,     0,     0,   447,     0,     0,   448,   449,
     450,   451,   452,   453,   454,   455,   456,   457,   458,   459,
     460,   178,     0,   180,     0,   461,   462,   463,   464,   181,
       0,   465,   466,     0,   467,     0,   184,   185,   468,   469,
       0,     0,   470,     0,     0,     0,   471,   472,     0,     0,
     186,     0,     0,   189,   473,   474,   475,     0,   190,   191,
     476,   477,     0,   478,   479,   480,   481,   482,   483,   193,
     484,     0,   485,   486,   487,   488,   489,   490,   491,   492,
     493,   494,   495,     0,   496,   200,   497,   498,   499,   500,
     501,   502,     0,     0,   503,   504,   505,     0,   506,   204,
     507,   508,     0,   509,   207,     0,   510,   511,   512,   513,
     514,   515,   516,   517,   209,   518,     0,   519,   520,   521,
     522,     0,   210,   211,     0,   524,     0,   525,   212,   526,
     213,     0,   527,   528,   529,   530,   531,     0,     0,   532,
     533,   534,   535,   536,     0,     0,   537,   538,   539,   220,
     540,     0,   541,     0,     0,     0,   542,   543,   544,   545,
     546,   547,     0,   222,     0,   978,   223,     0,     0,     0,
       0,     0,     0,     0,     0,   979,   980,   981,     0,   982,
     983,   984,   985,   986,   987,    79,    80,    81,   353,     0,
      83,    84,     0,    85,    86,    87,   354,     0,   355,     0,
      91,     0,    93,    94,    95,    96,    97,    98,     0,    99,
     100,   101,   356,     0,     0,   103,   104,   105,   106,     0,
       0,     0,   108,   109,   110,     0,   111,     0,     0,     0,
     357,   358,     0,     0,     0,   359,   360,     0,     0,     0,
       0,   361,     0,     0,     0,     0,     0,     0,     0,     0,
     362,     0,   363,     0,   364,   365,     0,   366,   367,   368,
     369,   370,   371,   372,     0,   373,   374,     0,     0,     0,
       0,     0,     0,     0,   375,   376,   377,     0,   378,   379,
     380,     0,   131,     0,   133,     0,     0,   381,   382,     0,
     383,     0,     0,   384,   385,   134,   386,     0,   387,   388,
     389,   390,   138,     0,     0,   391,   392,   393,     0,   394,
     395,   141,   396,     0,   397,   398,     0,   399,     0,     0,
       0,     0,   400,   401,   402,   403,   404,   147,   148,   405,
       0,   406,     0,   407,     0,   408,   409,   410,     0,     0,
       0,   411,   412,   413,   414,     0,   415,   416,     0,   417,
       0,   418,   419,   420,   154,   421,     0,   156,     0,   422,
     423,   158,     0,   424,     0,   425,     0,     0,     0,   426,
       0,   427,     0,     0,   428,     0,   429,   430,     0,   431,
     432,   433,     0,   434,   435,   436,   437,     0,     0,   165,
       0,   438,   439,   440,     0,   167,     0,   168,     0,     0,
       0,     0,   441,     0,   442,   443,   444,   445,   446,     0,
       0,   447,     0,     0,   448,   449,   450,   451,   452,   453,
     454,   455,   456,   457,   458,   459,   460,   178,     0,   180,
       0,   461,   462,   463,   464,   181,     0,   465,   466,     0,
     467,     0,   184,   185,   468,   469,     0,     0,   470,     0,
       0,     0,   471,   472,     0,     0,   186,     0,     0,   189,
     473,   474,   475,     0,   190,   191,   476,   477,     0,   478,
     479,   480,   481,   482,   483,   193,   484,     0,   485,   486,
     487,   488,   489,   490,   491,   492,   493,   494,   495,     0,
     496,   200,   497,   498,   499,   500,   501,   502,     0,     0,
     503,   504,   505,     0,   506,   204,   507,   508,     0,   509,
     207,     0,   510,   511,   512,   513,   514,   515,   516,   517,
     209,   518,     0,   519,   520,   521,   522,     0,   210,   211,
       0,   524,     0,   525,   212,   526,   213,     0,   527,   528,
     529,   530,   531,     0,     0,   532,   533,   534,   535,   536,
       0,     0,   537,   538,   539,   220,   540,     0,   541,     0,
       0,     0,   542,   543,   544,   545,   546,   547,     0,   222,
       0,   978,   223,     0,     0,     0,     0,     0,     0,     0,
       0,   979,   980,   981,     0,   982,   983,   984,   985,   986,
     987,   582,    79,    80,    81,   353,     0,    83,    84,     0,
      85,    86,    87,   354,     0,   355,     0,    91,     0,    93,
      94,    95,    96,    97,    98,   583,    99,   100,   101,   356,
     584,     0,   103,   104,   105,   106,   585,   586,     0,   108,
     109,   110,     0,   111,   587,   588,     0,   357,   358,     0,
       0,     0,   359,   360,     0,     0,     0,     0,   361,     0,
       0,     0,     0,     0,     0,     0,     0,   362,     0,   363,
       0,   364,   365,     0,   366,   367,   368,   369,   370,   371,
     372,   589,   373,   374,   590,   591,   592,   593,   594,   595,
     596,   375,   376,   377,   128,   378,   379,   380,   130,   131,
     132,   133,     0,   597,   381,   382,     0,   383,   598,   599,
     384,   600,   134,   386,   601,   387,   388,   389,   390,   138,
     602,   603,   391,   392,   393,   604,   394,   395,   141,   396,
     605,   397,   398,   144,   399,   606,   607,   608,   609,   400,
     401,   402,   403,   404,   147,   148,   405,   610,   406,   611,
     407,     0,   408,   409,   410,   612,   613,   614,   411,   412,
     413,   414,   615,   415,   416,   616,   417,   617,   418,   419,
     420,   154,   421,     0,   156,   618,   422,   423,   158,   619,
     424,   620,   425,   159,   621,   160,   426,     0,   427,   622,
     623,   428,   624,   429,   430,   163,   431,   432,   433,   625,
     434,   435,   436,   437,   626,   164,   165,   627,   438,   439,
     440,   628,   167,   629,   168,   630,     0,   169,   170,   441,
     171,   442,   443,   444,   445,   446,   631,   172,   447,   173,
     632,   448,   449,   450,   451,   452,   453,   454,   455,   456,
     457,   458,   459,   460,   178,   179,   180,   633,   461,   462,
     463,   464,   181,   634,   465,   466,   183,   467,   635,   184,
     185,   468,   469,   636,   637,   470,   638,   639,   640,   471,
     472,   641,   642,   186,   187,   188,   189,   473,   474,   475,
       0,   190,   191,   476,   477,   643,   478,   479,   480,   481,
     482,   483,   193,   484,   644,   485,   486,   487,   488,   489,
     490,   491,   492,   493,   494,   495,   198,   496,   200,   497,
     498,   499,   500,   501,   502,     0,   645,   503,   504,   505,
     646,   506,   204,   507,   508,   206,   509,   207,   647,   510,
     511,   512,   513,   514,   515,   516,   517,   209,   518,   648,
     519,   520,   521,   522,   649,   210,   211,   650,   524,   651,
     525,   212,   526,   213,   652,   527,   528,   529,   530,   531,
     653,   654,   532,   533,   534,   535,   536,   655,   656,   537,
     538,   539,   220,   540,   221,   541,     0,   657,   658,   542,
     543,   544,   545,   546,   547,     0,   222,     0,     0,   223,
       0,   582,    79,    80,    81,   353,     0,    83,    84,     0,
      85,    86,    87,   354,  1746,   355,     0,    91,     0,    93,
      94,    95,    96,    97,    98,   583,    99,   100,   101,   356,
     584,     0,   103,   104,   105,   106,   585,   586,     0,   108,
     109,   110,     0,   111,   587,   588,     0,   357,   358,     0,
       0,     0,   359,   360,     0,     0,     0,     0,   361,     0,
       0,     0,     0,     0,     0,     0,     0,   362,     0,   363,
       0,   364,   365,     0,   366,   367,   368,   369,   370,   371,
     372,     0,   373,   374,     0,     0,     0,     0,     0,     0,
       0,   375,   376,   377,     0,   378,   379,   380,     0,  1398,
       0,  1399,  1117,     0,   381,   382,     0,   383,     0,     0,
     384,  1400,  1401,   386,     0,   387,   388,   389,   390,     0,
       0,     0,   391,   392,   393,     0,   394,   395,     0,   396,
       0,   397,   398,     0,   399,     0,     0,     0,     0,   400,
     401,   402,   403,   404,  1402,  1403,   405,     0,   406,     0,
     407,     0,   408,   409,   410,     0,     0,     0,   411,  1130,
     413,   414,     0,   415,   416,     0,   417,     0,   418,   419,
     420,     0,   421,     0,     0,     0,   422,   423,  1404,     0,
     424,     0,   425,     0,     0,     0,   426,     0,   427,     0,
       0,   428,     0,   429,   430,     0,   431,   432,   433,     0,
     434,   435,   436,   437,     0,     0,     0,     0,   438,   439,
     440,  1135,  1405,     0,  1406,     0,     0,     0,     0,   441,
       0,   442,   443,   444,   445,   446,     0,     0,   447,     0,
       0,   448,   449,   450,   451,   452,   453,   454,   455,   456,
     457,   458,   459,   460,  1407,     0,  1408,     0,   461,   462,
     463,   464,     0,     0,   465,   466,     0,   467,     0,     0,
    1409,   468,   469,     0,     0,   470,     0,     0,     0,   471,
     472,     0,     0,     0,     0,     0,     0,   473,   474,   475,
       0,     0,     0,   476,   477,     0,   478,   479,   480,   481,
     482,   483,  1410,   484,     0,   485,   486,   487,   488,   489,
     490,   491,   492,   493,   494,   495,     0,   496,     0,   497,
     498,   499,   500,   501,   502,     0,     0,   503,   504,   505,
       0,   506,  1411,   507,   508,     0,   509,  1412,     0,   510,
     511,   512,   513,   514,   515,   516,   517,     0,   518,     0,
     519,   520,   521,   522,     0,  1413,  1414,     0,   524,     0,
     525,     0,   526,     0,     0,   527,   528,   529,   530,   531,
       0,     0,   532,   533,   534,   535,   536,     0,     0,   537,
     538,   539,  1415,   540,     0,   541,     0,     0,     0,   542,
     543,   544,   545,   546,   547,     0,   222,     0,     0,   223,
      79,    80,    81,   353,     0,    83,    84,     0,    85,    86,
      87,   354,     0,   355,  1749,    91,     0,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,   356,     0,     0,
     103,   104,   105,   106,     0,     0,     0,   108,   109,   110,
       0,   111,     0,     0,     0,   357,   358,     0,     0,     0,
     359,   360,     0,     0,     0,     0,   361,     0,     0,     0,
       0,     0,     0,     0,     0,   362,     0,   363,     0,   364,
     365,     0,   366,   367,   368,   369,   370,   371,   372,     0,
     373,   374,     0,     0,     0,     0,     0,     0,     0,   375,
     376,   377,     0,   378,   379,   380,     0,   131,     0,   133,
       0,     0,   381,   382,     0,   383,     0,     0,   384,   385,
     134,   386,     0,   387,   388,   389,   390,   138,     0,     0,
     391,   392,   393,     0,   394,   395,   141,   396,     0,   397,
     398,     0,   399,     0,     0,     0,     0,   400,   401,   402,
     403,   404,   147,   148,   405,     0,   406,     0,   407,     0,
     408,   409,   410,     0,     0,     0,   411,   412,   413,   414,
       0,   415,   416,     0,   417,     0,   418,   419,   420,   154,
     421,     0,   156,     0,   422,   423,   158,     0,   424,     0,
     425,     0,     0,     0,   426,     0,   427,     0,     0,   428,
       0,   429,   430,     0,   431,   432,   433,     0,   434,   435,
     436,   437,     0,     0,   165,     0,   438,   439,   440,     0,
     167,     0,   168,     0,     0,     0,     0,   441,     0,   442,
     443,   444,   445,   446,     0,     0,   447,     0,     0,   448,
     449,   450,   451,   452,   453,   454,   455,   456,   457,   458,
     459,   460,   178,     0,   180,   707,   461,   462,   463,   464,
     181,     0,   465,   466,     0,   467,     0,   184,   185,   468,
     469,     0,     0,   470,   708,     0,     0,   471,   472,     0,
       0,   186,     0,     0,   189,   473,   474,   475,     0,   190,
     191,   476,   477,     0,   478,   479,   480,   481,   482,   483,
     193,   484,     0,   485,   486,   487,   488,   489,   490,   491,
     492,   493,   494,   495,     0,   496,   200,   497,   498,   499,
     500,   501,   502,     0,     0,   503,   504,   505,     0,   506,
     204,   507,   508,     0,   509,   207,     0,   510,   511,   512,
     513,   514,   515,   516,   517,   209,   518,     0,   519,   520,
     521,   522,     0,   210,   211,     0,   524,     0,   525,   212,
     526,   213,     0,   527,   528,   529,   530,   531,     0,     0,
     532,   533,   534,   535,   536,     0,     0,   537,   538,   539,
     220,   540,     0,   541,     0,     0,     0,   542,   543,   544,
     545,   546,   547,     0,   222,     0,     0,   223,    79,    80,
      81,   353,     0,    83,    84,     0,    85,    86,    87,   354,
       0,   355,   867,    91,     0,    93,    94,    95,    96,    97,
      98,     0,    99,   100,   101,   356,     0,     0,   103,   104,
     105,   106,     0,     0,     0,   108,   109,   110,     0,   111,
       0,     0,     0,   357,   358,     0,     0,     0,   359,   360,
       0,     0,     0,     0,   361,     0,     0,     0,     0,     0,
       0,     0,     0,   362,     0,   363,     0,   364,   365,     0,
     366,   367,   368,   369,   370,   371,   372,     0,   373,   374,
       0,     0,     0,     0,     0,     0,     0,   375,   376,   377,
       0,   378,   379,   380,     0,   131,     0,   133,     0,     0,
     381,   382,     0,   383,     0,     0,   384,   385,   134,   386,
       0,   387,   388,   389,   390,   138,     0,     0,   391,   392,
     393,     0,   394,   395,   141,   396,     0,   397,   398,     0,
     399,     0,     0,     0,     0,   400,   401,   402,   403,   404,
     147,   148,   405,  1659,   406,     0,   407,     0,   408,   409,
     410,     0,     0,     0,   411,   412,   413,   414,     0,   415,
     416,     0,   417,     0,   418,   419,   420,   154,   421,     0,
     156,  1660,   422,   423,   158,     0,   424,     0,   425,     0,
       0,     0,   426,     0,   427,     0,     0,   428,     0,   429,
     430,     0,   431,   432,   433,     0,   434,   435,   436,   437,
       0,     0,   165,     0,   438,   439,   440,     0,   167,     0,
     168,     0,     0,     0,     0,   441,     0,   442,   443,   444,
     445,   446,     0,     0,   447,     0,     0,   448,   449,   450,
     451,   452,   453,   454,   455,   456,   457,   458,   459,   460,
     178,     0,   180,     0,   461,   462,   463,   464,   181,     0,
     465,   466,     0,   467,     0,   184,   185,   468,   469,  1661,
       0,   470,     0,  1662,     0,   471,   472,     0,     0,   186,
       0,     0,   189,   473,   474,   475,     0,   190,   191,   476,
     477,     0,   478,   479,   480,   481,   482,   483,   193,   484,
       0,   485,   486,   487,   488,   489,   490,   491,   492,   493,
     494,   495,     0,   496,   200,   497,   498,   499,   500,   501,
     502,     0,     0,   503,   504,   505,     0,   506,   204,   507,
     508,     0,   509,   207,     0,   510,   511,   512,   513,   514,
     515,   516,   517,   209,   518,     0,   519,   520,   521,   522,
       0,   210,   211,     0,   524,     0,   525,   212,   526,   213,
    1663,   527,   528,   529,   530,   531,     0,     0,   532,   533,
     534,   535,   536,     0,     0,   537,   538,   539,   220,   540,
       0,   541,     0,     0,     0,   542,   543,   544,   545,   546,
     547,     0,   222,    49,     0,   223,   548,     0,     0,     0,
       0,    52,     0,    53,     0,    79,    80,    81,   353,  1274,
      83,    84,     0,    85,    86,    87,   354,     0,   355,     0,
      91,     0,    93,    94,    95,    96,    97,    98,     0,    99,
     100,   101,   356,     0,     0,   103,   104,   105,   106,     0,
       0,     0,   108,   109,   110,     0,   111,     0,     0,     0,
     357,   358,     0,     0,     0,   359,   360,     0,     0,     0,
       0,   361,     0,     0,     0,     0,     0,     0,     0,     0,
     362,     0,   363,     0,   364,   365,     0,   366,   367,   368,
     369,   370,   371,   372,     0,   373,   374,     0,     0,     0,
       0,     0,     0,     0,   375,   376,   377,     0,   378,   379,
     380,     0,   131,     0,   133,     0,     0,   381,   382,     0,
     383,     0,     0,   384,   385,   134,   386,     0,   387,   388,
     389,   390,   138,     0,     0,   391,   392,   393,     0,   394,
     395,   141,   396,     0,   397,   398,     0,   399,     0,     0,
       0,     0,   400,   401,   402,   403,   404,   147,   148,   405,
       0,   406,     0,   407,     0,   408,   409,   410,     0,     0,
       0,   411,   412,   413,   414,     0,   415,   416,     0,   417,
       0,   418,   419,   420,   154,   421,     0,   156,  1660,   422,
     423,   158,     0,   424,     0,   425,     0,     0,     0,   426,
       0,   427,     0,     0,   428,     0,   429,   430,     0,   431,
     432,   433,     0,   434,   435,   436,   437,     0,     0,   165,
       0,   438,   439,   440,     0,   167,     0,   168,     0,     0,
       0,     0,   441,     0,   442,   443,   444,   445,   446,     0,
       0,   447,     0,     0,   448,   449,   450,   451,   452,   453,
     454,   455,   456,   457,   458,   459,   460,   178,     0,   180,
       0,   461,   462,   463,   464,   181,     0,   465,   466,     0,
     467,     0,   184,   185,   468,   469,  1661,     0,   470,     0,
    1662,     0,   471,   472,     0,     0,   186,     0,     0,   189,
     473,   474,   475,     0,   190,   191,   476,   477,     0,   478,
     479,   480,   481,   482,   483,   193,   484,     0,   485,   486,
     487,   488,   489,   490,   491,   492,   493,   494,   495,     0,
     496,   200,   497,   498,   499,   500,   501,   502,     0,     0,
     503,   504,   505,     0,   506,   204,   507,   508,     0,   509,
     207,     0,   510,   511,   512,   513,   514,   515,   516,   517,
     209,   518,     0,   519,   520,   521,   522,     0,   210,   211,
       0,   524,     0,   525,   212,   526,   213,  1663,   527,   528,
     529,   530,   531,     0,     0,   532,   533,   534,   535,   536,
       0,     0,   537,   538,   539,   220,   540,     0,   541,     0,
       0,     0,   542,   543,   544,   545,   546,   547,     0,   222,
      49,     0,   223,   548,     0,     0,     0,     0,    52,     0,
      53,     0,    79,    80,    81,   353,  1274,    83,    84,     0,
      85,    86,    87,   354,     0,   355,     0,    91,     0,    93,
      94,    95,    96,    97,    98,     0,    99,   100,   101,   356,
       0,     0,   103,   104,   105,   106,     0,     0,     0,   108,
     109,   110,     0,   111,     0,     0,     0,   357,   358,     0,
       0,     0,   359,   360,     0,     0,     0,     0,   361,     0,
       0,     0,     0,     0,     0,     0,     0,   362,     0,   363,
       0,   364,   365,     0,   366,   780,   368,   369,   370,   371,
     372,   781,   373,   374,     0,     0,     0,     0,     0,     0,
       0,   375,   376,   377,     0,   782,   379,   380,     0,   131,
       0,   133,     0,     0,   381,   382,     0,   383,     0,     0,
     384,   385,   134,   386,     0,   387,   388,   389,   390,   138,
       0,     0,   391,   392,   393,     0,   394,   395,   141,   396,
       0,   397,   398,     0,   399,     0,     0,     0,     0,   400,
     401,   402,   403,   404,   147,   148,   405,     0,   406,     0,
     407,     0,   408,   409,   410,     0,     0,     0,   411,   412,
     413,   414,     0,   415,   416,     0,   417,     0,   418,   419,
     420,   154,   421,     0,   156,     0,   422,   783,   158,     0,
     424,     0,   784,     0,   785,     0,   426,     0,   427,     0,
       0,   428,     0,   429,   430,     0,   431,   432,   433,   786,
     434,   435,   436,   437,     0,     0,   165,     0,   438,   439,
     440,     0,   167,     0,   168,     0,     0,     0,     0,   441,
       0,   442,   443,   444,   445,   787,     0,     0,   447,     0,
       0,   448,   449,   450,   451,   452,   453,   454,   455,   456,
     457,   458,   459,   460,   178,     0,   180,     0,   788,   462,
     463,   464,   181,     0,   465,   466,     0,   467,     0,   184,
     185,   468,   469,     0,     0,   470,     0,     0,     0,   471,
     472,     0,     0,   186,     0,     0,   189,   473,   474,   475,
       0,   190,   191,   476,   477,     0,   789,   479,   480,   481,
     482,   483,   193,   484,     0,   485,   790,   487,   488,   489,
     490,   491,   492,   493,   494,   495,     0,   496,   200,   497,
     498,   499,   500,   501,   502,     0,     0,   503,   504,   505,
       0,   506,   204,   507,   508,     0,   509,   207,     0,   510,
     511,   512,   513,   514,   515,   516,   517,   209,   518,     0,
     519,   520,   521,   522,     0,   210,   211,     0,   524,     0,
     525,   212,   526,   213,     0,   527,   528,   529,   530,   531,
       0,     0,   532,   533,   534,   535,   536,     0,     0,   537,
     538,   539,   220,   540,     0,   541,     0,     0,     0,   542,
     543,   544,   545,   546,   547,     0,   222,     0,     0,   223,
     548,    79,    80,    81,   353,    52,    83,    84,     0,    85,
      86,    87,   354,   791,   355,     0,    91,     0,    93,    94,
      95,    96,    97,    98,     0,    99,   100,   101,   356,     0,
       0,   103,   104,   105,   106,     0,     0,     0,   108,   109,
     110,     0,   111,     0,     0,     0,   357,   358,     0,     0,
       0,   359,   360,     0,     0,     0,     0,   361,     0,     0,
       0,     0,     0,     0,     0,     0,   362,     0,   363,     0,
     364,   365,     0,   366,   780,   368,   369,   370,   371,   372,
     781,   373,   374,     0,     0,     0,     0,     0,     0,     0,
     375,   376,   377,     0,   782,   379,   380,     0,   131,     0,
     133,     0,     0,   381,   382,     0,   383,     0,     0,   384,
     385,   134,   386,     0,   387,   388,   389,   390,   138,     0,
       0,   391,   392,   393,     0,   394,   395,   141,   396,     0,
     397,   398,     0,   399,     0,     0,     0,     0,   400,   401,
     402,   403,   404,   147,   148,   405,     0,   406,     0,   407,
       0,   408,   409,   410,     0,     0,     0,   411,   412,   413,
     414,     0,   415,   416,     0,   417,     0,   418,   419,   420,
     154,   421,     0,   156,     0,   422,   783,   158,     0,   424,
       0,   784,     0,     0,     0,   426,     0,   427,     0,     0,
     428,     0,   429,   430,     0,   431,   432,   433,     0,   434,
     435,   436,   437,     0,     0,   165,     0,   438,   439,   440,
       0,   167,     0,   168,     0,     0,     0,     0,   441,     0,
     442,   443,   444,   445,   787,     0,     0,   447,     0,     0,
     448,   449,   450,   451,   452,   453,   454,   455,   456,   457,
     458,   459,   460,   178,     0,   180,     0,   788,   462,   463,
     464,   181,     0,   465,   466,     0,   467,     0,   184,   185,
     468,   469,     0,     0,   470,     0,     0,     0,   471,   472,
       0,     0,   186,     0,     0,   189,   473,   474,   475,     0,
     190,   191,   476,   477,     0,   789,   479,   480,   481,   482,
     483,   193,   484,     0,   485,   790,   487,   488,   489,   490,
     491,   492,   493,   494,   495,     0,   496,   200,   497,   498,
     499,   500,   501,   502,     0,     0,   503,   504,   505,     0,
     506,   204,   507,   508,     0,   509,   207,     0,   510,   511,
     512,   513,   514,   515,   516,   517,   209,   518,     0,   519,
     520,   521,   522,     0,   210,   211,     0,   524,     0,   525,
     212,   526,   213,     0,   527,   528,   529,   530,   531,     0,
       0,   532,   533,   534,   535,   536,     0,     0,   537,   538,
     539,   220,   540,     0,   541,     0,     0,     0,   542,   543,
     544,   545,   546,   547,     0,   222,     0,     0,   223,   548,
      79,    80,    81,   353,    52,    83,    84,     0,    85,    86,
      87,   354,   791,   355,     0,    91,     0,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,   356,     0,     0,
     103,   104,   105,   106,     0,     0,     0,   108,   109,   110,
       0,   111,     0,     0,     0,   357,   358,     0,     0,     0,
     359,   360,     0,     0,     0,     0,   361,     0,     0,     0,
       0,     0,     0,     0,     0,   362,     0,   363,     0,   364,
     365,     0,   366,   367,   368,   369,   370,   371,   372,     0,
     373,   374,     0,     0,     0,     0,     0,     0,     0,   375,
     376,   377,     0,   378,   379,   380,     0,   131,     0,   133,
       0,     0,   381,   382,     0,   383,     0,     0,   384,   385,
     134,   386,     0,   387,   388,   389,   390,   138,     0,     0,
     391,   392,   393,     0,   394,   395,   141,   396,     0,   397,
     398,     0,   399,     0,     0,     0,     0,   400,   401,   402,
     403,   404,   147,   148,   405,   571,   406,     0,   407,     0,
     408,   409,   410,     0,     0,     0,   411,   412,   413,   414,
       0,   415,   416,     0,   417,     0,   418,   419,   420,   154,
     421,     0,   156,     0,   422,   423,   158,     0,   424,     0,
     425,     0,     0,     0,   426,     0,   427,     0,     0,   428,
       0,   429,   430,     0,   431,   432,   433,     0,   434,   435,
     436,   437,     0,     0,   165,     0,   438,   439,   440,     0,
     167,     0,   168,     0,     0,     0,     0,   441,     0,   442,
     443,   444,   445,   446,     0,     0,   447,     0,     0,   448,
     449,   450,   451,   452,   453,   454,   455,   456,   457,   458,
     459,   460,   178,     0,   180,     0,   461,   462,   463,   464,
     181,     0,   465,   466,     0,   467,     0,   184,   185,   468,
     469,     0,     0,   470,     0,     0,     0,   471,   472,     0,
       0,   186,     0,     0,   189,   473,   474,   475,     0,   190,
     191,   476,   477,     0,   478,   479,   480,   481,   482,   483,
     193,   484,     0,   485,   486,   487,   488,   489,   490,   491,
     492,   493,   494,   495,     0,   496,   200,   497,   498,   499,
     500,   501,   502,     0,     0,   503,   504,   505,     0,   506,
     204,   507,   508,     0,   509,   207,     0,   510,   511,   512,
     513,   514,   515,   516,   517,   209,   518,     0,   519,   520,
     521,   522,     0,   210,   211,  1212,   524,     0,   525,   212,
     526,   213,     0,   527,   528,   529,   530,   531,     0,     0,
     532,   533,   534,   535,   536,     0,     0,   537,   538,   539,
     220,   540,     0,   541,     0,     0,     0,   542,   543,   544,
     545,   546,   547,     0,   222,    49,     0,   223,   548,    79,
      80,    81,   353,     0,    83,    84,  1213,    85,    86,    87,
     354,     0,   355,     0,    91,     0,    93,    94,    95,    96,
      97,    98,     0,    99,   100,   101,   356,     0,     0,   103,
     104,   105,   106,     0,     0,     0,   108,   109,   110,     0,
     111,     0,     0,     0,   357,   358,     0,     0,     0,   359,
     360,     0,     0,     0,     0,   361,     0,     0,     0,     0,
       0,     0,     0,     0,   362,     0,   363,     0,   364,   365,
       0,   366,   367,   368,   369,   370,   371,   372,     0,   373,
     374,     0,     0,     0,     0,     0,     0,     0,   375,   376,
     377,     0,   378,   379,   380,     0,   131,     0,   133,     0,
       0,   381,   382,     0,   383,     0,     0,   384,   385,   134,
     386,     0,   387,   388,   389,   390,   138,     0,     0,   391,
     392,   393,     0,   394,   395,   141,   396,     0,   397,   398,
       0,   399,     0,     0,     0,     0,   400,   401,   402,   403,
     404,   147,   148,   405,     0,   406,     0,   407,     0,   408,
     409,   410,     0,     0,     0,   411,   412,   413,   414,     0,
     415,   416,     0,   417,     0,   418,   419,   420,   154,   421,
       0,   156,     0,   422,   423,   158,     0,   424,     0,   425,
       0,     0,     0,   426,     0,   427,     0,     0,   428,     0,
     429,   430,     0,   431,   432,   433,     0,   434,   435,   436,
     437,     0,     0,   165,     0,   438,   439,   440,     0,   167,
       0,   168,     0,     0,     0,     0,   441,     0,   442,   443,
     444,   445,   446,     0,     0,   447,     0,     0,   448,   449,
     450,   451,   452,   453,   454,   455,   456,   457,   458,   459,
     460,   178,     0,   180,     0,   461,   462,   463,   464,   181,
       0,   465,   466,     0,   467,     0,   184,   185,   468,   469,
       0,     0,   470,     0,     0,     0,   471,   472,     0,     0,
     186,     0,     0,   189,   473,   474,   475,     0,   190,   191,
     476,   477,     0,   478,   479,   480,   481,   482,   483,   193,
     484,     0,   485,   486,   487,   488,   489,   490,   491,   492,
     493,   494,   495,     0,   496,   200,   497,   498,   499,   500,
     501,   502,     0,     0,   503,   504,   505,     0,   506,   204,
     507,   508,     0,   509,   207,     0,   510,   511,   512,   513,
     514,   515,   516,   517,   209,   518,     0,   519,   520,   521,
     522,     0,   210,   211,     0,   524,     0,   525,   212,   526,
     213,     0,   527,   528,   529,   530,   531,     0,     0,   532,
     533,   534,   535,   536,     0,     0,   537,   538,   539,   220,
     540,     0,   541,     0,     0,     0,   542,   543,   544,   545,
     546,   547,     0,   222,    49,     0,   223,   548,     0,     0,
    1161,  1162,    52,     0,    53,    79,    80,    81,   353,     0,
      83,    84,     0,    85,    86,    87,   354,     0,   355,     0,
      91,     0,    93,    94,    95,    96,    97,    98,     0,    99,
     100,   101,   356,     0,     0,   103,   104,   105,   106,     0,
       0,     0,   108,   109,   110,     0,   111,     0,     0,     0,
     357,   358,     0,     0,     0,   359,   360,     0,     0,     0,
       0,   361,     0,     0,     0,     0,     0,     0,     0,     0,
     362,     0,   363,     0,   364,   365,     0,   366,   367,   368,
     369,   370,   371,   372,     0,   373,   374,     0,     0,     0,
       0,     0,     0,     0,   375,   376,   377,     0,   378,   379,
     380,     0,   131,     0,   133,     0,     0,   381,   382,     0,
     383,     0,     0,   384,   385,   134,   386,     0,   387,   388,
     389,   390,   138,     0,     0,   391,   392,   393,     0,   394,
     395,   141,   396,     0,   397,   398,     0,   399,     0,     0,
       0,     0,   400,   401,   402,   403,   404,   147,   148,   405,
       0,   406,     0,   407,     0,   408,   409,   410,     0,     0,
       0,   411,   412,   413,   414,     0,   415,   416,     0,   417,
       0,   418,   419,   420,   154,   421,     0,   156,     0,   422,
     423,   158,     0,   424,     0,   425,     0,     0,     0,   426,
       0,   427,     0,     0,   428,     0,   429,   430,     0,   431,
     432,   433,     0,   434,   435,   436,   437,     0,     0,   165,
       0,   438,   439,   440,     0,   167,     0,   168,     0,     0,
       0,     0,   441,     0,   442,   443,   444,   445,   446,     0,
       0,   447,     0,     0,   448,   449,   450,   451,   452,   453,
     454,   455,   456,   457,   458,   459,   460,   178,     0,   180,
       0,   461,   462,   463,   464,   181,     0,   465,   466,     0,
     467,     0,   184,   185,   468,   469,     0,     0,   470,     0,
       0,     0,   471,   472,     0,     0,   186,     0,     0,   189,
     473,   474,   475,     0,   190,   191,   476,   477,     0,   478,
     479,   480,   481,   482,   483,   193,   484,     0,   485,   486,
     487,   488,   489,   490,   491,   492,   493,   494,   495,     0,
     496,   200,   497,   498,   499,   500,   501,   502,     0,     0,
     503,   504,   505,     0,   506,   204,   507,   508,     0,   509,
     207,     0,   510,   511,   512,   513,   514,   515,   516,   517,
     209,   518,     0,   519,   520,   521,   522,     0,   210,   211,
       0,   524,     0,   525,   212,   526,   213,     0,   527,   528,
     529,   530,   531,     0,     0,   532,   533,   534,   535,   536,
       0,     0,   537,   538,   539,   220,   540,     0,   541,     0,
       0,     0,   542,   543,   544,   545,   546,   547,     0,   222,
       0,     0,   223,     0,   846,  1293,    79,    80,    81,   353,
     847,    83,    84,     0,    85,    86,    87,   354,   848,   355,
       0,    91,     0,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   356,     0,     0,   103,   104,   105,   106,
       0,     0,     0,   108,   109,   110,     0,   111,     0,     0,
       0,   357,   358,     0,     0,     0,   359,   360,     0,     0,
       0,     0,   361,     0,     0,     0,     0,     0,     0,     0,
       0,   362,     0,   363,     0,   364,   365,     0,   366,   367,
     368,   369,   370,   371,   372,     0,   373,   374,     0,     0,
       0,     0,     0,     0,     0,   375,   376,   377,     0,   378,
     379,   380,     0,   131,     0,   133,     0,     0,   381,   382,
       0,   383,     0,     0,   384,   385,   134,   386,     0,   387,
     388,   389,   390,   138,     0,     0,   391,   392,   393,     0,
     849,   395,   141,   396,     0,   397,   398,     0,   399,     0,
       0,     0,     0,   400,   401,   402,   403,   404,   147,   148,
     405,     0,   406,     0,   407,     0,   408,   409,   410,     0,
       0,     0,   411,   412,   413,   414,     0,   415,   416,     0,
     417,     0,   418,   419,   420,   154,   421,     0,   156,     0,
     422,   423,   158,     0,   424,     0,   425,     0,     0,     0,
     426,     0,   427,     0,     0,   428,     0,   429,   430,     0,
     431,   432,   433,     0,   434,   435,   436,   437,     0,     0,
     165,     0,   438,   439,   440,     0,   167,     0,   168,     0,
       0,     0,     0,   441,     0,   442,   443,   444,   445,   446,
       0,     0,   447,     0,     0,   448,   449,   850,   451,   452,
     453,   454,   455,   456,   457,   458,   459,   851,   178,     0,
     180,     0,   461,   462,   463,   464,   181,     0,   465,   466,
       0,   467,     0,   184,   185,   468,   469,     0,     0,   470,
       0,     0,     0,   471,   472,     0,     0,   186,     0,     0,
     189,   473,   474,   475,     0,   190,   191,   476,   477,     0,
     478,   479,   480,   481,   482,   483,   193,   484,     0,   485,
     486,   487,   488,   489,   490,   491,   492,   493,   494,   495,
       0,   496,   200,   497,   498,   499,   500,   501,   502,     0,
       0,   503,   504,   852,     0,   506,   204,   507,   508,     0,
     509,   207,     0,   510,   511,   512,   513,   514,   515,   516,
     517,   209,   518,     0,   519,   520,   521,   522,     0,   853,
     211,     0,   524,     0,   854,   212,   526,   213,     0,   527,
     528,   529,   530,   531,     0,     0,   532,   533,   534,   535,
     536,     0,     0,   537,   538,   539,   220,   540,     0,   541,
       0,     0,     0,   542,   543,   544,   545,   546,   547,     0,
     222,     0,     0,   223,   582,    79,    80,    81,   353,     0,
      83,    84,     0,    85,    86,    87,   354,     0,   355,     0,
      91,     0,    93,    94,    95,    96,    97,    98,   583,    99,
     100,   101,   356,   584,     0,   103,   104,   105,   106,   585,
     586,     0,   108,   109,   110,     0,   111,   587,   588,     0,
     357,   358,     0,     0,     0,   359,   360,     0,     0,     0,
       0,   361,     0,     0,     0,     0,     0,     0,     0,     0,
     362,     0,   363,     0,   364,   365,     0,   366,   367,   368,
     369,   370,   371,   372,   589,   373,   374,   590,   591,   592,
     593,   594,   595,   596,   375,   376,   377,   128,   378,   379,
     380,   130,   131,   132,   133,     0,   597,   381,   382,     0,
     383,   598,   599,   384,   600,   134,   386,   601,   387,   388,
     389,   390,   138,   602,   603,   391,   392,   393,   604,   394,
     395,   141,   396,   605,   397,   398,   144,   399,   606,   607,
     608,   609,   400,   401,   402,   403,   404,   147,   148,   405,
     610,   406,   611,   407,     0,   408,   409,   410,   612,   613,
     614,   411,   412,   413,   414,   615,   415,   416,   616,   417,
     617,   418,   419,   420,   154,   421,     0,   156,   618,   422,
     423,   158,   619,   424,   620,   425,   159,   621,   160,   426,
       0,   427,   622,   623,   428,   624,   429,   430,   163,   431,
     432,   433,   625,   434,   435,   436,   437,   626,   164,   165,
     627,   438,   439,   440,   628,   167,   629,   168,   630,     0,
     169,   170,   441,   171,   442,   443,   444,   445,   446,   631,
     172,   447,   173,   632,   448,   449,   450,   451,   452,   453,
     454,   455,   456,   457,   458,   459,   460,   178,   179,   180,
     633,   461,   462,   463,   464,   181,   634,   465,   466,   183,
     467,   635,   184,   185,   468,   469,   636,   637,   470,   638,
     639,   640,   471,   472,   641,   642,   186,   187,   188,   189,
     473,   474,   475,     0,   190,   191,   476,   477,   643,   478,
     479,   480,   481,   482,   483,   193,   484,   644,   485,   486,
     487,   488,   489,   490,   491,   492,   493,   494,   495,   198,
     496,   200,   497,   498,   499,   500,   501,   502,     0,   645,
     503,   504,   505,   646,   506,   204,   507,   508,   206,   509,
     207,   647,   510,   511,   512,   513,   514,   515,   516,   517,
     209,   518,   648,   519,   520,   521,   522,   649,   210,   211,
     650,   524,   651,   525,   212,   526,   213,   652,   527,   528,
     529,   530,   531,   653,   654,   532,   533,   534,   535,   536,
     655,   656,   537,   538,   539,   220,   540,   221,   541,     0,
     657,   658,   542,   543,   544,   545,   546,   547,     0,   222,
       0,     0,   223,   582,    79,    80,    81,   353,     0,    83,
      84,     0,    85,    86,    87,   354,     0,   355,     0,    91,
       0,    93,    94,    95,    96,    97,    98,   583,    99,   100,
     101,   356,   584,     0,   103,   104,   105,   106,   585,   586,
       0,   108,   109,   110,     0,   111,   587,   588,     0,   357,
     358,     0,     0,     0,   359,   360,     0,     0,     0,     0,
     361,     0,     0,     0,     0,     0,     0,     0,     0,   362,
       0,   363,     0,   364,   365,     0,   366,   367,   368,   369,
     370,   371,   372,     0,   373,   374,     0,     0,     0,     0,
       0,     0,     0,   375,   376,   377,   128,   378,   379,   380,
     130,  1398,   132,  1399,  1117,     0,   381,   382,     0,   383,
       0,     0,   384,  1400,  1401,   386,     0,   387,   388,   389,
     390,     0,     0,     0,   391,   392,   393,     0,   394,   395,
       0,   396,     0,   397,   398,   144,   399,     0,     0,     0,
       0,   400,   401,   402,   403,   404,  1402,  1403,   405,     0,
     406,     0,   407,     0,   408,   409,   410,     0,     0,     0,
     411,  1130,   413,   414,     0,   415,   416,     0,   417,     0,
     418,   419,   420,     0,   421,     0,     0,     0,   422,   423,
    1404,     0,   424,     0,   425,   159,     0,   160,   426,     0,
     427,     0,     0,   428,     0,   429,   430,   163,   431,   432,
     433,     0,   434,   435,   436,   437,     0,   164,     0,     0,
     438,   439,   440,  1135,  1405,     0,  1406,     0,     0,   169,
     170,   441,   171,   442,   443,   444,   445,   446,     0,   172,
     447,   173,     0,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,  1407,   179,  1408,     0,
     461,   462,   463,   464,     0,     0,   465,   466,   183,   467,
       0,     0,  1409,   468,   469,     0,     0,   470,     0,     0,
       0,   471,   472,     0,     0,     0,   187,   188,     0,   473,
     474,   475,     0,     0,     0,   476,   477,     0,   478,   479,
     480,   481,   482,   483,  1410,   484,     0,   485,   486,   487,
     488,   489,   490,   491,   492,   493,   494,   495,   198,   496,
       0,   497,   498,   499,   500,   501,   502,     0,     0,   503,
     504,   505,     0,   506,  1411,   507,   508,   206,   509,  1412,
       0,   510,   511,   512,   513,   514,   515,   516,   517,     0,
     518,     0,   519,   520,   521,   522,     0,  1413,  1414,     0,
     524,     0,   525,     0,   526,     0,     0,   527,   528,   529,
     530,   531,     0,     0,   532,   533,   534,   535,   536,     0,
       0,   537,   538,   539,  1415,   540,   221,   541,     0,     0,
       0,   542,   543,   544,   545,   546,   547,     0,   222,     0,
       0,   223,    79,    80,    81,   353,     0,    83,    84,   569,
      85,    86,    87,   354,     0,   355,     0,    91,     0,    93,
      94,    95,    96,    97,    98,     0,    99,   100,   101,   356,
       0,     0,   103,   104,   105,   106,     0,     0,     0,   108,
     109,   110,     0,   111,     0,     0,     0,   357,   358,     0,
       0,     0,   359,   360,     0,     0,     0,     0,   361,     0,
       0,     0,     0,     0,     0,     0,     0,   362,     0,   363,
       0,   364,   365,     0,   366,   367,   368,   369,   370,   371,
     372,   570,   373,   374,     0,     0,     0,     0,     0,     0,
       0,   375,   376,   377,     0,   378,   379,   380,     0,   131,
       0,   133,     0,     0,   381,   382,     0,   383,     0,     0,
     384,   385,   134,   386,     0,   387,   388,   389,   390,   138,
       0,     0,   391,   392,   393,     0,   394,   395,   141,   396,
       0,   397,   398,     0,   399,     0,     0,     0,     0,   400,
     401,   402,   403,   404,   147,   148,   405,   571,   406,     0,
     407,     0,   408,   409,   410,     0,     0,     0,   411,   412,
     413,   414,     0,   415,   416,     0,   417,     0,   418,   419,
     420,   154,   421,     0,   156,     0,   422,   423,   158,     0,
     424,     0,   425,     0,     0,     0,   426,     0,   427,     0,
       0,   428,     0,   429,   430,     0,   431,   432,   433,     0,
     434,   435,   436,   437,     0,     0,   165,     0,   438,   439,
     440,     0,   167,     0,   168,     0,     0,     0,     0,   441,
       0,   442,   443,   444,   445,   446,     0,     0,   447,     0,
       0,   448,   449,   450,   451,   452,   453,   454,   455,   456,
     457,   458,   459,   460,   178,     0,   180,     0,   461,   462,
     463,   464,   181,     0,   465,   466,     0,   467,     0,   184,
     185,   468,   469,     0,     0,   470,     0,     0,     0,   471,
     472,     0,     0,   186,     0,     0,   189,   473,   474,   475,
       0,   190,   191,   476,   477,     0,   478,   479,   480,   481,
     482,   483,   193,   484,     0,   485,   486,   487,   488,   489,
     490,   491,   492,   493,   494,   495,     0,   496,   200,   497,
     498,   499,   500,   501,   502,     0,     0,   503,   504,   505,
       0,   506,   204,   507,   508,     0,   509,   207,     0,   510,
     511,   512,   513,   514,   515,   516,   517,   209,   518,     0,
     519,   520,   521,   522,     0,   210,   211,     0,   524,     0,
     525,   212,   526,   213,     0,   527,   528,   529,   530,   531,
       0,     0,   532,   533,   534,   535,   536,     0,     0,   537,
     538,   539,   220,   540,     0,   541,     0,     0,     0,   542,
     543,   544,   545,   546,   547,     0,   222,    49,     0,   223,
     548,    79,    80,    81,   353,     0,    83,    84,     0,    85,
      86,    87,   354,     0,   355,     0,    91,     0,    93,    94,
      95,    96,    97,    98,     0,    99,   100,   101,   356,     0,
       0,   103,   104,   105,   106,     0,     0,  1305,   108,   109,
     110,     0,   111,     0,     0,     0,   357,   358,     0,     0,
       0,   359,   360,     0,     0,     0,     0,   361,     0,     0,
       0,     0,     0,     0,     0,     0,   362,     0,   363,     0,
     364,   365,     0,   366,   367,   368,   369,   370,   371,   372,
       0,   373,   374,     0,     0,     0,     0,     0,     0,     0,
     375,   376,   377,     0,   378,   379,   380,     0,   131,     0,
     133,     0,     0,   381,   382,     0,   383,     0,     0,   384,
     385,   134,   386,     0,   387,   388,   389,   390,   138,     0,
       0,   391,   392,   393,     0,   394,   395,   141,   396,     0,
     397,   398,     0,   399,     0,     0,     0,     0,   400,   401,
     402,   403,   404,   147,   148,   405,     0,   406,     0,   407,
       0,   408,   409,   410,     0,     0,     0,   411,   412,   413,
     414,     0,   415,   416,     0,   417,     0,   418,   419,   420,
     154,   421,     0,   156,     0,   422,   423,   158,     0,   424,
       0,   425,     0,     0,     0,   426,     0,  2061,     0,     0,
     428,     0,   429,   430,     0,   431,   432,   433,     0,   434,
     435,   436,   437,     0,     0,   165,     0,   438,   439,   440,
       0,   167,     0,   168,     0,     0,     0,     0,   441,     0,
     442,   443,   444,   445,   446,     0,     0,   447,     0,     0,
     448,   449,  2062,   451,   452,   453,   454,   455,   456,   457,
     458,   459,   460,   178,     0,   180,   707,   461,   462,   463,
     464,   181,     0,   465,   466,     0,   467,     0,   184,   185,
     468,   469,     0,     0,   470,   708,     0,     0,   471,   472,
       0,     0,   186,     0,     0,   189,   473,   474,   475,     0,
     190,   191,   476,   477,     0,   478,   479,   480,   481,   482,
     483,   193,   484,     0,   485,   486,   487,   488,   489,   490,
     491,   492,   493,   494,   495,     0,   496,   200,   497,   498,
     499,   500,   501,   502,     0,     0,   503,   504,   505,     0,
     506,   204,   507,   508,     0,   509,   207,     0,   510,   511,
     512,   513,   514,   515,   516,   517,   209,   518,  2063,   519,
    2064,   521,  2065,     0,   210,   211,     0,   524,     0,   525,
     212,   526,   213,     0,   527,   528,   529,   530,   531,     0,
       0,   532,   533,   534,   535,   536,     0,     0,   537,   538,
     539,   220,   540,     0,   541,     0,     0,     0,   542,   543,
     544,   545,   546,   547,     0,   222,     0,     0,   223,   548,
      79,    80,    81,   353,     0,    83,    84,     0,    85,    86,
      87,   354,     0,   355,     0,    91,     0,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,   356,     0,     0,
     103,   104,   105,   106,     0,     0,     0,   108,   109,   110,
       0,   111,     0,     0,     0,   357,   358,     0,     0,     0,
     359,   360,     0,     0,     0,     0,   361,     0,     0,     0,
       0,     0,     0,     0,     0,   362,     0,   363,     0,   364,
     365,     0,   366,   367,   368,   369,   370,   371,   372,     0,
     373,   374,     0,     0,     0,     0,     0,     0,     0,   375,
     376,   377,     0,   378,   379,   380,     0,   131,     0,   133,
       0,     0,   381,   382,     0,   383,     0,     0,   384,   385,
     134,   386,     0,   387,   388,   389,   390,   138,     0,     0,
     391,   392,   393,     0,   394,   395,   141,   396,     0,   397,
     398,     0,   399,     0,     0,     0,     0,   400,   401,   402,
     403,   404,   147,   148,   405,     0,   406,     0,   407,     0,
     408,   409,   410,     0,     0,     0,   411,   412,   413,   414,
       0,   415,   416,     0,   417,     0,   418,   419,   420,   154,
     421,     0,   156,     0,   422,   423,   158,     0,   424,     0,
     425,     0,     0,     0,   426,     0,   427,     0,     0,   428,
       0,   429,   430,     0,   431,   432,   433,     0,   434,   435,
     436,   437,     0,     0,   165,     0,   438,   439,   440,     0,
     167,     0,   168,     0,     0,     0,     0,   441,     0,   442,
     443,   444,   445,   446,     0,     0,   447,     0,     0,   448,
     449,   450,   451,   452,   453,   454,   455,   456,   457,   458,
     459,   460,   178,     0,   180,     0,   461,   462,   463,   464,
     181,     0,   465,   466,     0,   467,     0,   184,   185,   468,
     469,     0,     0,   470,     0,     0,     0,   471,   472,     0,
       0,   186,     0,     0,   189,   473,   474,   475,     0,   190,
     191,   476,   477,     0,   478,   479,   480,   481,   482,   483,
     193,   484,     0,   485,   486,   487,   488,   489,   490,   491,
     492,   493,   494,   495,     0,   496,   200,   497,   498,   499,
     500,   501,   502,     0,     0,   503,   504,   505,     0,   506,
     204,   507,   508,     0,   509,   207,     0,   510,   511,   512,
     513,   514,   515,   516,   517,   209,   518,     0,   519,   520,
     521,   522,     0,   210,   211,   523,   524,     0,   525,   212,
     526,   213,     0,   527,   528,   529,   530,   531,     0,     0,
     532,   533,   534,   535,   536,     0,     0,   537,   538,   539,
     220,   540,     0,   541,     0,     0,     0,   542,   543,   544,
     545,   546,   547,     0,   222,    49,     0,   223,   548,    79,
      80,    81,   353,     0,    83,    84,     0,    85,    86,    87,
     354,     0,   355,     0,    91,     0,    93,    94,    95,    96,
      97,    98,     0,    99,   100,   101,   356,     0,     0,   103,
     104,   105,   106,     0,     0,     0,   108,   109,   110,     0,
     111,     0,     0,     0,   357,   358,     0,     0,     0,   359,
     360,     0,     0,     0,     0,   361,     0,     0,     0,     0,
       0,     0,     0,     0,   362,     0,   363,     0,   364,   365,
       0,   366,   367,   368,   369,   370,   371,   372,     0,   373,
     374,     0,     0,     0,     0,     0,     0,     0,   375,   376,
     377,     0,   378,   379,   380,     0,   131,     0,   133,     0,
       0,   381,   382,     0,   383,     0,     0,   384,   385,   134,
     386,     0,   387,   388,   389,   390,   138,     0,     0,   391,
     392,   393,     0,   394,   395,   141,   396,     0,   397,   398,
       0,   399,     0,     0,     0,     0,   400,   401,   402,   403,
     404,   147,   148,   405,   920,   406,     0,   407,     0,   408,
     409,   410,     0,     0,     0,   411,   412,   413,   414,     0,
     415,   416,     0,   417,     0,   418,   419,   420,   154,   421,
       0,   156,     0,   422,   423,   158,     0,   424,     0,   425,
       0,     0,     0,   426,     0,   427,     0,     0,   428,     0,
     429,   430,     0,   431,   432,   433,     0,   434,   435,   436,
     437,     0,     0,   165,     0,   438,   439,   440,     0,   167,
       0,   168,     0,     0,     0,     0,   441,     0,   442,   443,
     444,   445,   446,     0,     0,   447,     0,     0,   448,   449,
     450,   451,   452,   453,   454,   455,   456,   457,   458,   459,
     460,   178,     0,   180,     0,   461,   462,   463,   464,   181,
       0,   465,   466,     0,   467,     0,   184,   185,   468,   469,
       0,     0,   470,     0,     0,     0,   471,   472,     0,     0,
     186,     0,     0,   189,   473,   474,   475,     0,   190,   191,
     476,   477,     0,   478,   479,   480,   481,   482,   483,   193,
     484,     0,   485,   486,   487,   488,   489,   490,   491,   492,
     493,   494,   495,     0,   496,   200,   497,   498,   499,   500,
     501,   502,     0,     0,   503,   504,   505,     0,   506,   204,
     507,   508,     0,   509,   207,     0,   510,   511,   512,   513,
     514,   515,   516,   517,   209,   518,     0,   519,   520,   521,
     522,     0,   210,   211,     0,   524,     0,   525,   212,   526,
     213,     0,   527,   528,   529,   530,   531,     0,     0,   532,
     533,   534,   535,   536,     0,     0,   537,   538,   539,   220,
     540,     0,   541,     0,     0,     0,   542,   543,   544,   545,
     546,   547,     0,   222,    49,     0,   223,   548,    79,    80,
      81,   353,     0,    83,    84,     0,    85,    86,    87,   354,
       0,   355,     0,    91,     0,    93,    94,    95,    96,    97,
      98,     0,    99,   100,   101,   356,     0,     0,   103,   104,
     105,   106,     0,     0,     0,   108,   109,   110,     0,   111,
       0,     0,     0,   357,   358,     0,     0,     0,   359,   360,
       0,     0,     0,     0,   361,     0,     0,     0,     0,     0,
       0,     0,     0,   362,     0,   363,     0,   364,   365,     0,
     366,   367,   368,   369,   370,   371,   372,     0,   373,   374,
       0,     0,     0,     0,     0,     0,     0,   375,   376,   377,
       0,   378,   379,   380,     0,   131,     0,   133,     0,     0,
     381,   382,     0,   383,     0,     0,   384,   385,   134,   386,
       0,   387,   388,   389,   390,   138,     0,     0,   391,   392,
     393,     0,   394,   395,   141,   396,     0,   397,   398,     0,
     399,     0,     0,     0,     0,   400,   401,   402,   403,   404,
     147,   148,   405,   571,   406,     0,   407,     0,   408,   409,
     410,     0,     0,     0,   411,   412,   413,   414,     0,   415,
     416,     0,   417,     0,   418,   419,   420,   154,   421,     0,
     156,     0,   422,   423,   158,     0,   424,     0,   425,     0,
       0,     0,   426,     0,   427,     0,     0,   428,     0,   429,
     430,     0,   431,   432,   433,     0,   434,   435,   436,   437,
       0,     0,   165,     0,   438,   439,   440,     0,   167,     0,
     168,     0,     0,     0,     0,   441,     0,   442,   443,   444,
     445,   446,     0,     0,   447,     0,     0,   448,   449,   450,
     451,   452,   453,   454,   455,   456,   457,   458,   459,   460,
     178,     0,   180,     0,   461,   462,   463,   464,   181,     0,
     465,   466,     0,   467,     0,   184,   185,   468,   469,     0,
       0,   470,     0,     0,     0,   471,   472,     0,     0,   186,
       0,     0,   189,   473,   474,   475,     0,   190,   191,   476,
     477,     0,   478,   479,   480,   481,   482,   483,   193,   484,
       0,   485,   486,   487,   488,   489,   490,   491,   492,   493,
     494,   495,     0,   496,   200,   497,   498,   499,   500,   501,
     502,     0,     0,   503,   504,   505,     0,   506,   204,   507,
     508,     0,   509,   207,     0,   510,   511,   512,   513,   514,
     515,   516,   517,   209,   518,     0,   519,   520,   521,   522,
       0,   210,   211,     0,   524,     0,   525,   212,   526,   213,
       0,   527,   528,   529,   530,   531,     0,     0,   532,   533,
     534,   535,   536,     0,     0,   537,   538,   539,   220,   540,
       0,   541,     0,     0,     0,   542,   543,   544,   545,   546,
     547,     0,   222,    49,     0,   223,   548,    79,    80,    81,
     353,     0,    83,    84,     0,    85,    86,    87,   354,     0,
     355,     0,    91,     0,    93,    94,    95,    96,    97,    98,
       0,    99,   100,   101,   356,     0,     0,   103,   104,   105,
     106,     0,     0,     0,   108,   109,   110,     0,   111,     0,
       0,     0,   357,   358,     0,     0,     0,   359,   360,     0,
       0,     0,     0,   361,     0,     0,     0,     0,     0,     0,
       0,     0,   362,     0,   363,     0,   364,   365,     0,   366,
     367,   368,   369,   370,   371,   372,     0,   373,   374,     0,
       0,     0,     0,     0,     0,     0,   375,   376,   377,     0,
     378,   379,   380,     0,   131,     0,   133,     0,     0,   381,
     382,     0,   383,     0,     0,   384,   385,   134,   386,     0,
     387,   388,   389,   390,   138,     0,     0,   391,   392,   393,
       0,   394,   395,   141,   396,     0,   397,   398,     0,   399,
       0,     0,     0,     0,   400,   401,   402,   403,   404,   147,
     148,   405,  1648,   406,     0,   407,     0,   408,   409,   410,
       0,     0,     0,   411,   412,   413,   414,     0,   415,   416,
       0,   417,     0,   418,   419,   420,   154,   421,     0,   156,
       0,   422,   423,   158,     0,   424,     0,   425,     0,     0,
       0,   426,     0,   427,     0,     0,   428,     0,   429,   430,
       0,   431,   432,   433,     0,   434,   435,   436,   437,     0,
       0,   165,     0,   438,   439,   440,     0,   167,     0,   168,
       0,     0,     0,     0,   441,     0,   442,   443,   444,   445,
     446,     0,     0,   447,     0,     0,   448,   449,   450,   451,
     452,   453,   454,   455,   456,   457,   458,   459,   460,   178,
       0,   180,     0,   461,   462,   463,   464,   181,     0,   465,
     466,     0,   467,     0,   184,   185,   468,   469,     0,     0,
     470,     0,     0,     0,   471,   472,     0,     0,   186,     0,
       0,   189,   473,   474,   475,     0,   190,   191,   476,   477,
       0,   478,   479,   480,   481,   482,   483,   193,   484,     0,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,     0,   496,   200,   497,   498,   499,   500,   501,   502,
       0,     0,   503,   504,   505,     0,   506,   204,   507,   508,
       0,   509,   207,     0,   510,   511,   512,   513,   514,   515,
     516,   517,   209,   518,     0,   519,   520,   521,   522,     0,
     210,   211,     0,   524,     0,   525,   212,   526,   213,     0,
     527,   528,   529,   530,   531,     0,     0,   532,   533,   534,
     535,   536,     0,     0,   537,   538,   539,   220,   540,     0,
     541,     0,     0,     0,   542,   543,   544,   545,   546,   547,
       0,   222,    49,     0,   223,   548,    79,    80,    81,   353,
       0,    83,    84,     0,    85,    86,    87,   354,     0,   355,
       0,    91,     0,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   356,     0,     0,   103,   104,   105,   106,
       0,     0,     0,   108,   109,   110,     0,   111,     0,     0,
       0,   357,   358,     0,     0,     0,   359,   360,     0,     0,
       0,     0,   361,     0,     0,     0,     0,     0,     0,     0,
       0,   362,     0,   363,     0,   364,   365,     0,   366,   367,
     368,   369,   370,   371,   372,     0,   373,   374,     0,     0,
       0,     0,     0,     0,     0,   375,   376,   377,     0,   378,
     379,   380,     0,   131,     0,   133,     0,     0,   381,   382,
       0,   383,     0,     0,   384,   385,   134,   386,     0,   387,
     388,   389,   390,   138,     0,     0,   391,   392,   393,     0,
     394,   395,   141,   396,     0,   397,   398,     0,   399,     0,
       0,     0,     0,   400,   401,   402,   403,   404,   147,   148,
     405,     0,   406,     0,   407,     0,   408,   409,   410,     0,
       0,     0,   411,   412,   413,   414,     0,   415,   416,     0,
     417,     0,   418,   419,   420,   154,   421,     0,   156,     0,
     422,   423,   158,     0,   424,     0,   425,     0,     0,     0,
     426,     0,   427,     0,     0,   428,     0,   429,   430,     0,
     431,   432,   433,     0,   434,   435,   436,   437,     0,     0,
     165,     0,   438,   439,   440,     0,   167,     0,   168,     0,
       0,     0,     0,   441,     0,   442,   443,   444,   445,   446,
       0,     0,   447,     0,     0,   448,   449,   450,   451,   452,
     453,   454,   455,   456,   457,   458,   459,   460,   178,     0,
     180,     0,   461,   462,   463,   464,   181,     0,   465,   466,
       0,   467,     0,   184,   185,   468,   469,     0,     0,   470,
       0,     0,     0,   471,   472,     0,     0,   186,     0,     0,
     189,   473,   474,   475,     0,   190,   191,   476,   477,     0,
     478,   479,   480,   481,   482,   483,   193,   484,     0,   485,
     486,   487,   488,   489,   490,   491,   492,   493,   494,   495,
       0,   496,   200,   497,   498,   499,   500,   501,   502,     0,
       0,   503,   504,   505,     0,   506,   204,   507,   508,     0,
     509,   207,     0,   510,   511,   512,   513,   514,   515,   516,
     517,   209,   518,     0,   519,   520,   521,   522,     0,   210,
     211,     0,   524,     0,   525,   212,   526,   213,     0,   527,
     528,   529,   530,   531,     0,     0,   532,   533,   534,   535,
     536,     0,     0,   537,   538,   539,   220,   540,     0,   541,
       0,     0,     0,   542,   543,   544,   545,   546,   547,     0,
     222,    49,     0,   223,   548,    79,    80,    81,   353,     0,
      83,    84,     0,    85,    86,    87,   354,   745,   355,     0,
      91,     0,    93,    94,    95,    96,    97,    98,     0,    99,
     100,   101,   356,     0,     0,   103,   104,   105,   106,     0,
       0,     0,   108,   109,   110,     0,   111,     0,     0,     0,
     357,   358,     0,     0,     0,   359,   360,     0,     0,     0,
       0,   361,     0,     0,     0,     0,     0,     0,     0,     0,
     362,     0,   363,     0,   364,   365,     0,   366,   367,   368,
     369,   370,   371,   372,     0,   373,   374,     0,     0,     0,
       0,     0,     0,     0,   375,   376,   377,     0,   378,   379,
     380,     0,   131,     0,   133,     0,     0,   381,   382,     0,
     383,     0,     0,   384,   385,   134,   386,     0,   387,   388,
     389,   390,   138,     0,     0,   391,   392,   393,     0,   394,
     395,   141,   396,     0,   397,   398,     0,   399,     0,     0,
       0,     0,   400,   401,   402,   403,   404,   147,   148,   405,
       0,   406,     0,   407,     0,   408,   409,   410,     0,     0,
       0,   411,   412,   413,   414,     0,   415,   416,     0,   417,
       0,   418,   419,   420,   154,   421,     0,   156,     0,   422,
     423,   158,     0,   424,     0,   425,     0,     0,     0,   426,
       0,   427,     0,     0,   428,     0,   429,   430,     0,   431,
     432,   433,     0,   434,   435,   436,   437,     0,     0,   165,
       0,   438,   439,   440,     0,   167,     0,   168,     0,     0,
       0,     0,   441,     0,   442,   443,   444,   445,   446,     0,
       0,   447,     0,     0,   448,   449,   450,   451,   452,   453,
     454,   455,   456,   457,   458,   459,   460,   178,     0,   180,
       0,   461,   462,   463,   464,   181,     0,   465,   466,     0,
     467,     0,   184,   185,   468,   469,     0,     0,   470,     0,
       0,     0,   471,   472,     0,     0,   186,     0,     0,   189,
     473,   474,   475,     0,   190,   191,   476,   746,     0,   478,
     479,   480,   481,   482,   483,   193,   484,     0,   485,   486,
     487,   488,   489,   490,   491,   492,   493,   494,   495,     0,
     496,   200,   497,   498,   499,   500,   501,   502,     0,     0,
     503,   504,   505,     0,   506,   204,   507,   508,     0,   509,
     207,     0,   510,   511,   512,   513,   514,   515,   516,   517,
     209,   518,     0,   519,   520,   521,   522,     0,   210,   211,
       0,   524,     0,   525,   212,   526,   213,     0,   527,   528,
     529,   530,   531,     0,     0,   532,   533,   534,   535,   536,
       0,     0,   537,   538,   539,   220,   540,     0,   541,     0,
       0,     0,   542,   543,   544,   545,   546,   547,     0,   222,
       0,     0,   223,   548,    79,    80,    81,   353,     0,    83,
      84,     0,    85,    86,    87,   354,     0,   355,     0,    91,
       0,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,   356,     0,     0,   103,   104,   105,   106,     0,     0,
       0,   108,   109,   110,     0,   111,     0,     0,     0,   357,
     358,     0,     0,     0,   359,   360,     0,     0,     0,     0,
     361,     0,     0,     0,     0,     0,     0,     0,     0,   362,
       0,   363,     0,   364,   365,     0,   366,   367,   368,   369,
     370,   371,   372,     0,   373,   374,     0,     0,     0,     0,
       0,     0,     0,   375,   376,   377,     0,   378,   379,   380,
       0,   131,     0,   133,     0,     0,   381,   382,     0,   383,
       0,     0,   384,   385,   134,   386,     0,   387,   388,   389,
     390,   138,     0,     0,   391,   392,   393,     0,   394,   395,
     141,   396,     0,   397,   398,     0,   399,     0,     0,     0,
       0,   400,   401,   402,   403,   404,   147,   148,   405,     0,
     406,     0,   407,     0,   408,   409,   410,     0,     0,     0,
     411,   412,   413,   414,     0,   415,   416,     0,   417,     0,
     418,   419,   420,   154,   421,     0,   156,     0,   422,   423,
     158,     0,   424,     0,   425,     0,     0,     0,   426,     0,
     427,     0,     0,   428,     0,   429,   430,     0,   776,   432,
     433,     0,   434,   435,   436,   437,     0,     0,   165,     0,
     438,   439,   440,     0,   167,     0,   168,     0,     0,     0,
       0,   441,     0,   442,   443,   444,   445,   446,     0,     0,
     447,     0,     0,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   178,     0,   180,     0,
     461,   462,   463,   464,   181,     0,   465,   466,     0,   467,
       0,   184,   185,   468,   469,     0,     0,   470,     0,     0,
       0,   471,   472,     0,     0,   186,     0,     0,   189,   473,
     474,   475,     0,   190,   191,   476,   477,     0,   478,   479,
     480,   481,   482,   483,   193,   484,     0,   485,   486,   487,
     488,   489,   490,   491,   492,   493,   494,   495,     0,   496,
     200,   497,   498,   499,   500,   501,   502,     0,     0,   503,
     504,   505,     0,   506,   204,   507,   508,     0,   509,   207,
       0,   510,   511,   512,   513,   514,   515,   516,   517,   209,
     518,     0,   519,   520,   521,   522,     0,   210,   211,     0,
     524,     0,   525,   212,   526,   213,     0,   527,   528,   529,
     530,   531,     0,     0,   532,   533,   534,   535,   536,     0,
       0,   537,   538,   539,   220,   540,     0,   541,     0,     0,
       0,   542,   543,   544,   545,   546,   547,     0,   222,     0,
       0,   223,   548,    79,    80,    81,   353,     0,    83,    84,
       0,    85,    86,    87,   354,     0,   355,     0,    91,     0,
      93,    94,    95,    96,    97,    98,     0,    99,   100,   101,
     356,     0,     0,   103,   104,   105,   106,     0,     0,     0,
     108,   109,   110,     0,   111,     0,     0,     0,   357,   358,
       0,     0,     0,   359,   360,     0,     0,     0,     0,   361,
       0,     0,     0,     0,     0,     0,     0,     0,   362,     0,
     363,     0,   364,   365,     0,   366,   367,   368,   369,   370,
     371,   372,     0,   373,   374,     0,     0,     0,     0,     0,
       0,     0,   375,   376,   377,     0,   378,   379,   380,     0,
     131,     0,   133,     0,     0,   381,   382,     0,   383,     0,
       0,   384,   385,   134,   386,     0,   387,   388,   389,   390,
     138,     0,     0,   391,   392,   393,     0,   394,   395,   141,
     396,     0,   397,   398,     0,   399,     0,     0,     0,     0,
     400,   401,   402,   403,   404,   147,   148,   405,     0,   406,
       0,   407,     0,   408,   409,   410,     0,     0,     0,   411,
     412,   413,   414,     0,   415,   416,     0,   417,     0,   418,
     419,   420,   154,   421,     0,   156,     0,   422,   423,   158,
       0,   424,     0,   425,     0,     0,     0,   426,     0,   427,
       0,     0,   428,     0,   429,   430,     0,   431,   432,   433,
       0,   434,   435,   436,   437,     0,     0,   165,     0,   438,
     439,   440,     0,   167,     0,   168,     0,     0,     0,     0,
     441,     0,   442,   443,   444,   445,   446,     0,     0,   447,
       0,     0,   448,   449,   450,   451,   452,   453,   454,   455,
     456,   457,   458,   459,   460,   178,     0,   180,     0,   461,
     462,   463,   464,   181,     0,   465,   466,     0,   467,     0,
     184,   185,   468,   469,     0,     0,   470,     0,     0,     0,
     471,   472,     0,     0,   186,     0,     0,   189,   473,   474,
     475,     0,   190,   191,   476,   477,     0,   478,   479,   480,
     481,   482,   483,   193,   484,     0,   485,   486,   487,   488,
     489,   490,   491,   492,   493,   494,   495,     0,   496,   200,
     497,   498,   499,   500,   501,   502,     0,     0,   503,   504,
     505,     0,   506,   204,   507,   508,     0,   509,   207,     0,
     510,   511,   512,   513,   514,   515,   516,   517,   209,   518,
       0,   519,   520,   521,   522,     0,   210,   211,     0,   524,
       0,   525,   212,   526,   213,     0,   527,   528,   529,   530,
     531,     0,     0,   532,   533,   534,   535,   536,     0,     0,
     537,   538,   539,   220,   540,     0,   541,     0,     0,     0,
     542,   543,   544,   545,   546,   547,     0,   222,     0,     0,
     223,   548,   582,    79,    80,    81,   353,     0,    83,    84,
       0,    85,    86,    87,   354,     0,   355,     0,    91,     0,
      93,    94,    95,    96,    97,    98,   583,    99,   100,   101,
     356,   584,     0,   103,   104,   105,   106,   585,   586,     0,
     108,   109,   110,     0,   111,   587,   588,     0,   357,   358,
       0,     0,     0,   359,   360,     0,     0,     0,     0,   361,
       0,     0,     0,     0,     0,     0,     0,     0,   362,     0,
     363,     0,   364,   365,     0,   366,   367,   368,   369,   370,
     371,   372,     0,   373,   374,     0,     0,     0,     0,     0,
       0,     0,   375,   376,   377,     0,   378,   379,   380,     0,
    1398,     0,  1399,  1117,     0,   381,   382,     0,   383,     0,
       0,   384,  1400,  1401,   386,     0,   387,   388,   389,   390,
       0,     0,     0,   391,   392,   393,     0,   394,   395,     0,
     396,     0,   397,   398,     0,   399,     0,     0,     0,     0,
     400,   401,   402,   403,   404,  1402,  1403,   405,     0,   406,
       0,   407,     0,   408,   409,   410,     0,     0,     0,   411,
    1130,   413,   414,     0,   415,   416,     0,   417,     0,   418,
     419,   420,     0,   421,     0,     0,     0,   422,   423,  1404,
       0,   424,     0,   425,     0,     0,     0,   426,     0,   427,
       0,     0,   428,     0,   429,   430,     0,   431,   432,   433,
       0,   434,   435,   436,   437,     0,     0,     0,     0,   438,
     439,   440,  1135,  1405,     0,  1406,     0,     0,     0,     0,
     441,     0,   442,   443,   444,   445,   446,     0,     0,   447,
       0,     0,   448,   449,   450,   451,   452,   453,   454,   455,
     456,   457,   458,   459,   460,  1407,     0,  1408,     0,   461,
     462,   463,   464,  1788,     0,   465,   466,     0,   467,     0,
       0,  1409,   468,   469,     0,     0,   470,     0,     0,     0,
     471,   472,     0,     0,     0,     0,     0,     0,   473,   474,
     475,     0,     0,     0,   476,   477,     0,   478,   479,   480,
     481,   482,   483,  1410,   484,     0,   485,   486,   487,   488,
     489,   490,   491,   492,   493,   494,   495,     0,   496,     0,
     497,   498,   499,   500,   501,   502,     0,     0,   503,   504,
     505,     0,   506,  1411,   507,   508,     0,   509,  1412,     0,
     510,   511,   512,   513,   514,   515,   516,   517,     0,   518,
       0,   519,   520,   521,   522,     0,  1413,  1414,     0,   524,
       0,   525,     0,   526,     0,     0,   527,   528,   529,   530,
     531,     0,     0,   532,   533,   534,   535,   536,     0,     0,
     537,   538,   539,  1415,   540,     0,   541,     0,     0,     0,
     542,   543,   544,   545,   546,   547,     0,   222,     0,     0,
     223,   582,    79,    80,    81,   353,     0,    83,    84,     0,
      85,    86,    87,   354,     0,   355,     0,    91,     0,    93,
      94,    95,    96,    97,    98,   583,    99,   100,   101,   356,
     584,     0,   103,   104,   105,   106,   585,   586,     0,   108,
     109,   110,     0,   111,   587,   588,     0,   357,   358,     0,
       0,     0,   359,   360,     0,     0,     0,     0,   361,     0,
       0,     0,     0,     0,     0,     0,     0,   362,     0,   363,
       0,   364,   365,     0,   366,   367,   368,   369,   370,   371,
     372,     0,   373,   374,     0,     0,     0,     0,     0,     0,
       0,   375,   376,   377,     0,   378,   379,   380,     0,  1398,
       0,  1399,  1117,     0,   381,   382,     0,   383,     0,     0,
     384,  1400,  1401,   386,     0,   387,   388,   389,   390,     0,
       0,     0,   391,   392,   393,     0,   394,   395,     0,   396,
       0,   397,   398,     0,   399,     0,     0,     0,     0,   400,
     401,   402,   403,   404,  1402,  1403,   405,     0,   406,     0,
     407,     0,   408,   409,   410,     0,     0,     0,   411,  1130,
     413,   414,     0,   415,   416,     0,   417,     0,   418,   419,
     420,     0,   421,     0,     0,     0,   422,   423,  1404,     0,
     424,     0,   425,     0,     0,     0,   426,     0,   427,     0,
       0,   428,     0,   429,   430,     0,   431,   432,   433,     0,
     434,   435,   436,   437,     0,     0,     0,     0,   438,   439,
     440,  1135,  1405,     0,  1406,     0,     0,     0,     0,   441,
       0,   442,   443,   444,   445,   446,     0,     0,   447,     0,
       0,   448,   449,   450,   451,   452,   453,   454,   455,   456,
     457,   458,   459,   460,  1407,     0,  1408,     0,   461,   462,
     463,   464,  2506,     0,   465,   466,     0,   467,     0,     0,
    1409,   468,   469,     0,     0,   470,     0,     0,     0,   471,
     472,     0,     0,     0,     0,     0,     0,   473,   474,   475,
       0,     0,     0,   476,   477,     0,   478,   479,   480,   481,
     482,   483,  1410,   484,     0,   485,   486,   487,   488,   489,
     490,   491,   492,   493,   494,   495,     0,   496,     0,   497,
     498,   499,   500,   501,   502,     0,     0,   503,   504,   505,
       0,   506,  1411,   507,   508,     0,   509,  1412,     0,   510,
     511,   512,   513,   514,   515,   516,   517,     0,   518,     0,
     519,   520,   521,   522,     0,  1413,  1414,     0,   524,     0,
     525,     0,   526,     0,     0,   527,   528,   529,   530,   531,
       0,     0,   532,   533,   534,   535,   536,     0,     0,   537,
     538,   539,  1415,   540,     0,   541,     0,     0,     0,   542,
     543,   544,   545,   546,   547,     0,   222,     0,     0,   223,
     582,    79,    80,    81,   353,     0,    83,    84,     0,    85,
      86,    87,   354,     0,   355,     0,    91,     0,    93,    94,
      95,    96,    97,    98,   583,    99,   100,   101,   356,   584,
       0,   103,   104,   105,   106,   585,   586,     0,   108,   109,
     110,     0,   111,   587,   588,     0,   357,   358,     0,     0,
       0,   359,   360,     0,     0,     0,     0,   361,     0,     0,
       0,     0,     0,     0,     0,     0,   362,     0,   363,     0,
     364,   365,     0,   366,   367,   368,   369,   370,   371,   372,
       0,   373,   374,     0,     0,     0,     0,     0,     0,     0,
     375,   376,   377,     0,   378,   379,   380,     0,  1398,     0,
    1399,  1117,     0,   381,   382,     0,   383,     0,     0,   384,
    1400,  1401,   386,     0,   387,   388,   389,   390,     0,     0,
       0,   391,   392,   393,     0,   394,   395,     0,   396,     0,
     397,   398,     0,   399,     0,     0,     0,     0,   400,   401,
     402,   403,   404,  1402,  1403,   405,     0,   406,     0,   407,
       0,   408,   409,   410,     0,     0,     0,   411,  1130,   413,
     414,     0,   415,   416,     0,   417,     0,   418,   419,   420,
       0,   421,     0,     0,     0,   422,   423,  1404,     0,   424,
       0,   425,     0,     0,     0,   426,     0,   427,     0,     0,
     428,     0,   429,   430,     0,   431,   432,   433,     0,   434,
     435,   436,   437,     0,     0,     0,     0,   438,   439,   440,
    1135,  1405,     0,  1406,     0,     0,     0,     0,   441,     0,
     442,   443,   444,   445,   446,     0,     0,   447,     0,     0,
     448,   449,   450,   451,   452,   453,   454,   455,   456,   457,
     458,   459,   460,  1407,     0,  1408,     0,   461,   462,   463,
     464,     0,     0,   465,   466,     0,   467,     0,     0,  1409,
     468,   469,     0,     0,   470,     0,     0,     0,   471,   472,
       0,     0,     0,     0,     0,     0,   473,   474,   475,     0,
       0,     0,   476,   477,     0,   478,   479,   480,   481,   482,
     483,  1410,   484,     0,   485,   486,   487,   488,   489,   490,
     491,   492,   493,   494,   495,     0,   496,     0,   497,   498,
     499,   500,   501,   502,     0,     0,   503,   504,   505,     0,
     506,  1411,   507,   508,     0,   509,  1412,     0,   510,   511,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   519,
     520,   521,   522,     0,  1413,  1414,     0,   524,     0,   525,
       0,   526,     0,     0,   527,   528,   529,   530,   531,     0,
       0,   532,   533,   534,   535,   536,     0,     0,   537,   538,
     539,  1415,   540,     0,   541,     0,     0,     0,   542,   543,
     544,   545,   546,   547,     0,   222,     0,     0,   223,   582,
      79,    80,    81,   353,     0,    83,    84,     0,    85,    86,
      87,   354,     0,   355,     0,    91,     0,    93,    94,    95,
      96,    97,    98,   583,    99,   100,   101,   356,   584,     0,
     103,   104,   105,   106,   585,   586,     0,   108,   109,   110,
       0,   111,   587,   588,     0,   357,   358,     0,     0,     0,
     359,   360,     0,     0,     0,     0,   361,     0,     0,     0,
       0,     0,     0,     0,     0,   362,     0,   363,     0,   364,
     365,     0,   366,   367,   368,   369,   370,   371,   372,     0,
     373,   374,     0,     0,     0,     0,     0,     0,     0,   375,
     376,   377,     0,   378,   379,   380,     0,  1398,     0,  1399,
    1117,     0,   381,   382,     0,   383,     0,     0,   384,  1400,
    1401,   386,     0,   387,   388,   389,   390,     0,     0,     0,
     391,   392,   393,     0,   394,   395,     0,   396,     0,   397,
     398,     0,   399,     0,     0,     0,     0,   400,   401,   402,
     403,   404,  1402,  1403,   405,     0,   406,     0,   407,     0,
     408,   409,   410,     0,     0,     0,   411,  1130,   413,   414,
       0,   415,   416,     0,   417,     0,   418,   419,   420,     0,
     421,     0,     0,     0,   422,   423,  1404,     0,   424,     0,
     425,     0,     0,     0,   426,     0,   427,     0,     0,   428,
       0,   429,   430,     0,   431,   432,   433,     0,   434,   435,
     436,   437,     0,     0,     0,     0,   438,   439,   440,  1135,
    1405,     0,  1406,     0,     0,     0,     0,   441,     0,   442,
     443,   444,   445,   446,     0,     0,   447,     0,     0,   448,
     449,   450,   451,   452,   453,   454,   455,   456,   457,   458,
     459,   460,  1407,     0,  1408,     0,   461,   462,   463,   464,
       0,     0,   465,   466,     0,   467,     0,     0,  1409,   468,
     469,     0,     0,   470,     0,     0,     0,   471,   472,     0,
       0,     0,     0,     0,     0,   473,   474,   475,     0,     0,
       0,   476,   477,     0,   478,   479,   480,   481,   482,   483,
    1410,   484,     0,   485,   486,   487,   488,   489,   490,   491,
     492,   493,   494,   495,     0,   496,     0,   497,   498,   499,
     500,   501,   502,     0,     0,   503,   504,   505,     0,   506,
       0,   507,   508,     0,   509,  1412,     0,   510,   511,   512,
     513,   514,   515,   516,   517,     0,   518,     0,   519,   520,
     521,   522,     0,  1413,  1414,     0,   524,     0,   525,     0,
     526,     0,     0,   527,   528,   529,   530,   531,     0,     0,
     532,   533,   534,   535,   536,     0,     0,   537,   538,   539,
    1415,   540,     0,   541,     0,     0,     0,   542,   543,   544,
     545,   546,   547,     0,   222,     0,     0,   223,    79,    80,
      81,   353,     0,    83,    84,     0,    85,    86,    87,   354,
       0,   355,     0,    91,     0,    93,    94,    95,    96,    97,
      98,     0,    99,   100,   101,   356,     0,     0,   103,   104,
     105,   106,     0,     0,     0,   108,   109,   110,     0,   111,
       0,     0,     0,   357,   358,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     366,   367,   368,   369,   370,   371,   372,   589,   373,   374,
     590,   591,   592,   593,   594,   595,   596,   375,   376,   377,
     128,   378,   379,   380,   130,   131,   132,   133,     0,   597,
     381,   382,     0,   383,   598,   599,   384,     0,   134,   386,
     601,   387,   388,   389,   390,   138,   602,   603,   391,   392,
     393,   604,   394,   395,   141,   396,   605,   397,   398,   144,
     399,   606,   607,   608,   609,   400,   401,   402,     0,   404,
     147,   148,   405,   610,   406,   611,   407,     0,   408,   409,
     410,   612,   613,   614,   411,   412,   413,   414,   615,   415,
     416,   616,   417,   617,   418,   419,   420,   154,   421,     0,
     156,   618,   422,   423,   158,   619,   424,   620,   425,   159,
     621,   160,   426,     0,   427,   622,   623,   428,   624,   429,
       0,   163,   431,   432,   433,   625,   434,   435,   436,   437,
     626,   164,   165,     0,   438,   439,   440,     0,   167,   629,
     168,   630,     0,   169,   170,   441,   171,   442,   443,   444,
     445,   446,   631,   172,   447,   173,   632,   448,   449,   450,
     451,   452,   453,   454,     0,   456,   457,     0,   459,   460,
     178,   179,   180,   633,   461,   462,   463,   464,   181,   634,
     465,   466,   183,   467,   635,   184,   185,   468,   469,   636,
     637,   470,   638,   639,   640,   471,   472,   641,   642,   186,
     187,   188,   189,   473,   474,   475,     0,   190,   191,   476,
     477,   643,   478,   479,   480,   481,   482,   483,   193,   484,
     644,   485,   486,   487,   488,   489,   490,   491,   492,   493,
     494,   495,   198,   496,   200,   497,   498,   499,   500,   501,
       0,     0,   645,   503,   504,   505,   646,   506,   204,   507,
     508,   206,   509,   207,   647,   510,   511,   512,   513,   514,
     515,   516,   517,   209,   518,   648,   519,   520,   521,   522,
     649,   210,   211,     0,   524,   651,   525,   212,   526,   213,
     652,   527,   528,   529,   530,   531,     0,   654,   532,   533,
     534,   535,   536,   655,   656,   537,   538,   539,   220,   540,
     221,   541,     0,   657,   658,   542,   543,   544,   545,     0,
     547,     0,   222,     0,     0,   223,    79,    80,    81,   353,
       0,    83,    84,     0,    85,    86,    87,   354,     0,   355,
       0,    91,     0,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   356,     0,     0,   103,   104,   105,   106,
       0,     0,     0,   108,   109,   110,     0,   111,     0,     0,
       0,   357,   358,     0,     0,     0,   359,   360,     0,     0,
       0,     0,   361,     0,     0,     0,     0,     0,     0,     0,
       0,   362,     0,   363,     0,   364,   365,     0,   366,   367,
     368,   369,   370,   371,   372,     0,   373,   374,     0,     0,
       0,     0,     0,     0,     0,   375,   376,   377,   128,   378,
     379,   380,   130,   131,   132,   133,     0,     0,   381,   382,
       0,   383,     0,     0,   384,   385,   134,   386,     0,   387,
     388,   389,   390,   138,     0,     0,   391,   392,   393,     0,
     394,   395,   141,   396,     0,   397,   398,   144,   399,     0,
       0,     0,     0,   400,   401,   402,   403,   404,   147,   148,
     405,     0,   406,     0,   407,     0,   408,   409,   410,     0,
       0,     0,   411,   412,   413,   414,     0,   415,   416,     0,
     417,     0,   418,   419,   420,   154,   421,     0,   156,     0,
     422,   423,   158,     0,   424,     0,   425,   159,     0,   160,
     426,     0,   427,     0,     0,   428,     0,   429,   430,   163,
     431,   432,   433,     0,   434,   435,   436,   437,     0,   164,
     165,     0,   438,   439,   440,     0,   167,     0,   168,     0,
       0,   169,   170,   441,   171,   442,   443,   444,   445,   446,
       0,   172,   447,   173,     0,   448,   449,   450,   451,   452,
     453,   454,   455,   456,   457,   458,   459,   460,   178,   179,
     180,   707,   461,   462,   463,   464,   181,     0,   465,   466,
     183,   467,     0,   184,   185,   468,   469,     0,     0,   470,
     708,     0,     0,   471,   472,     0,     0,   186,   187,   188,
     189,   473,   474,   475,     0,   190,   191,   476,   477,     0,
     478,   479,   480,   481,   482,   483,   193,   484,     0,   485,
     486,   487,   488,   489,   490,   491,   492,   493,   494,   495,
     198,   496,   200,   497,   498,   499,   500,   501,   502,     0,
       0,   503,   504,   505,     0,   506,   204,   507,   508,   206,
     509,   207,     0,   510,   511,   512,   513,   514,   515,   516,
     517,   209,   518,     0,   519,   520,   521,   522,     0,   210,
     211,     0,   524,     0,   525,   212,   526,   213,     0,   527,
     528,   529,   530,   531,     0,     0,   532,   533,   534,   535,
     536,     0,     0,   537,   538,   539,   220,   540,   221,   541,
       0,     0,     0,   542,   543,   544,   545,   546,   547,     0,
     222,     0,     0,   223,    79,    80,    81,   353,     0,    83,
      84,     0,    85,    86,    87,   354,     0,   355,     0,    91,
       0,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,   356,     0,     0,   103,   104,   105,   106,     0,     0,
       0,   108,   109,   110,     0,   111,     0,     0,     0,   357,
     358,     0,     0,     0,   359,   360,     0,     0,     0,     0,
     361,     0,     0,     0,     0,     0,     0,     0,     0,   362,
       0,   363,     0,   364,   365,     0,   366,   367,   368,   369,
     370,   371,   372,     0,   373,   374,     0,     0,     0,     0,
       0,     0,     0,   375,   376,   377,     0,   378,   379,   380,
       0,   131,     0,   133,     0,     0,   381,   382,     0,   383,
       0,     0,   384,   385,   134,   386,  1757,   387,   388,   389,
     390,   138,     0,     0,   391,   392,   393,  1758,   394,   395,
     141,   396,     0,   397,   398,     0,   399,     0,     0,     0,
       0,   400,   401,   402,   403,   404,   147,   148,   405,     0,
     406,     0,   407,     0,   408,   409,   410,     0,     0,     0,
     411,   412,   413,   414,     0,   415,   416,     0,   417,     0,
     418,   419,   420,   154,   421,     0,   156,     0,   422,   423,
     158,     0,   424,  1759,   425,     0,     0,     0,   426,     0,
     427,     0,     0,   428,     0,   429,   430,     0,   431,   432,
     433,     0,   434,   435,   436,   437,     0,     0,   165,     0,
     438,   439,   440,     0,   167,     0,   168,     0,     0,     0,
       0,   441,     0,   442,   443,   444,   445,   446,     0,     0,
     447,  2267,     0,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   178,     0,   180,     0,
     461,   462,   463,   464,   181,     0,   465,   466,     0,   467,
       0,   184,   185,   468,   469,     0,     0,   470,     0,     0,
       0,   471,   472,     0,     0,   186,     0,     0,   189,   473,
     474,   475,     0,   190,   191,   476,   477,  1760,   478,   479,
     480,   481,   482,   483,   193,   484,     0,   485,   486,   487,
     488,   489,   490,   491,   492,   493,   494,   495,     0,   496,
     200,   497,   498,   499,   500,   501,   502,     0,     0,   503,
     504,   505,     0,   506,   204,   507,   508,     0,   509,   207,
       0,   510,   511,   512,   513,   514,   515,   516,   517,   209,
     518,     0,   519,   520,   521,   522,     0,   210,   211,     0,
     524,     0,   525,   212,   526,   213,     0,   527,   528,   529,
     530,   531,     0,  1761,   532,   533,   534,   535,   536,     0,
       0,   537,   538,   539,   220,   540,     0,   541,     0,     0,
       0,   542,   543,   544,   545,   546,   547,     0,   222,     0,
       0,   223,    79,    80,    81,   353,     0,    83,    84,     0,
      85,    86,    87,   354,     0,   355,     0,    91,     0,    93,
      94,    95,    96,    97,    98,     0,    99,   100,   101,   356,
       0,     0,   103,   104,   105,   106,     0,     0,     0,   108,
     109,   110,     0,   111,     0,     0,     0,   357,   358,     0,
       0,     0,   359,   360,     0,     0,     0,     0,   361,     0,
       0,     0,     0,     0,     0,     0,     0,   362,     0,   363,
       0,   364,   365,     0,   366,   367,   368,   369,   370,   371,
     372,     0,   373,   374,   125,   126,     0,     0,     0,     0,
       0,   375,   376,   377,     0,   378,   379,   380,     0,   131,
       0,   133,     0,     0,   381,   382,     0,   383,     0,     0,
     384,   385,   134,   386,     0,   387,   388,   389,   390,   138,
       0,     0,   391,   392,   393,     0,   394,   395,   141,   396,
       0,   397,   398,     0,   399,     0,     0,     0,     0,   400,
     401,   402,   403,   404,   147,   148,   405,     0,   406,     0,
     407,     0,   408,   409,   410,     0,     0,     0,   411,   412,
     413,   414,     0,   415,   416,     0,   417,     0,   418,   419,
     420,   154,   421,     0,   156,     0,   422,   423,   158,     0,
     424,     0,   425,     0,     0,     0,   426,     0,   427,     0,
       0,   428,     0,   429,   430,     0,   431,   432,   433,     0,
     434,   435,   436,   437,     0,     0,   165,     0,   438,   439,
     440,     0,   167,     0,   168,     0,     0,     0,     0,   441,
       0,   442,   443,   444,   445,   446,     0,     0,   447,     0,
       0,   448,   449,   450,   451,   452,   453,   454,   455,   456,
     457,   458,   459,   460,   178,     0,   180,   707,   461,   462,
     463,   464,   181,     0,   465,   466,     0,   467,     0,   184,
     185,   468,   469,     0,     0,   470,   708,     0,     0,   471,
     472,     0,     0,   186,     0,     0,   189,   473,   474,   475,
       0,   190,   191,   476,   477,     0,   478,   479,   480,   481,
     482,   483,   193,   484,     0,   485,   486,   487,   488,   489,
     490,   491,   492,   493,   494,   495,     0,   496,   200,   497,
     498,   499,   500,   501,   502,     0,     0,   503,   504,   505,
       0,   506,   204,   507,   508,     0,   509,   207,     0,   510,
     511,   512,   513,   514,   515,   516,   517,   209,   518,     0,
     519,   520,   521,   522,     0,   210,   211,     0,   524,     0,
     525,   212,   526,   213,     0,   527,   528,   529,   530,   531,
       0,     0,   532,   533,   534,   535,   536,     0,     0,   537,
     538,   539,   220,   540,     0,   541,     0,     0,     0,   542,
     543,   544,   545,   546,   547,     0,   222,     0,     0,   223,
      79,    80,    81,   353,     0,    83,    84,     0,    85,    86,
      87,   354,     0,   355,     0,    91,     0,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,   356,     0,     0,
     103,   104,   105,   106,     0,     0,     0,   108,   109,   110,
       0,   111,     0,     0,     0,   357,   358,     0,     0,     0,
     359,   360,     0,     0,     0,     0,   361,     0,     0,     0,
       0,     0,     0,     0,     0,   362,     0,   363,     0,   364,
     365,     0,   366,   367,   368,   369,   370,   371,   372,     0,
     373,   374,     0,     0,     0,     0,     0,     0,     0,   375,
     376,   377,     0,   378,   379,   380,     0,   131,     0,   133,
       0,     0,   381,   382,     0,   383,     0,     0,   384,   385,
     134,   386,     0,   387,   388,   389,   390,   138,     0,     0,
     391,   392,   393,     0,   394,   395,   141,   396,     0,   397,
     398,     0,   399,     0,     0,     0,     0,   400,   401,   402,
     403,   404,   147,   148,   405,     0,   406,     0,   407,     0,
     408,   409,   410,     0,     0,     0,   411,   412,   413,   414,
       0,   415,   416,     0,   417,     0,   418,   419,   420,   154,
     421,     0,   156,     0,   422,   423,   158,     0,   424,     0,
     425,     0,     0,     0,   426,     0,   427,     0,     0,   428,
       0,   429,   430,     0,   431,   432,   433,     0,   434,   435,
     436,   437,     0,     0,   165,     0,   438,   439,   440,     0,
     167,     0,   168,     0,     0,     0,     0,   441,     0,   442,
     443,   444,   445,   446,     0,     0,   447,     0,     0,   448,
     449,   450,   451,   452,   453,   454,   455,   456,   457,   458,
     459,   460,   178,     0,   180,   707,   461,   462,   463,   464,
     181,     0,   465,   466,     0,   467,     0,   184,   185,   468,
     469,     0,     0,   470,   708,     0,   869,   471,   472,     0,
       0,   186,     0,     0,   189,   473,   474,   475,     0,   190,
     191,   476,   477,     0,   478,   479,   480,   481,   482,   483,
     193,   484,     0,   485,   486,   487,   488,   489,   490,   491,
     492,   493,   494,   495,     0,   496,   200,   497,   498,   499,
     500,   501,   502,     0,     0,   503,   504,   505,     0,   506,
     204,   507,   508,     0,   509,   207,     0,   510,   511,   512,
     513,   514,   515,   516,   517,   209,   518,     0,   519,   520,
     521,   522,     0,   210,   211,     0,   524,     0,   525,   212,
     526,   213,     0,   527,   528,   529,   530,   531,     0,     0,
     532,   533,   534,   535,   536,     0,     0,   537,   538,   539,
     220,   540,     0,   541,     0,     0,     0,   542,   543,   544,
     545,   546,   547,     0,   222,     0,     0,   223,    79,    80,
      81,   353,     0,    83,    84,     0,    85,    86,    87,   354,
       0,   355,     0,    91,     0,    93,    94,    95,    96,    97,
      98,     0,    99,   100,   101,   356,     0,     0,   103,   104,
     105,   106,     0,     0,     0,   108,   109,   110,     0,   111,
       0,     0,     0,   357,   358,     0,     0,     0,   359,   360,
       0,     0,     0,     0,   361,     0,     0,     0,     0,     0,
       0,     0,     0,   362,     0,   363,     0,   364,   365,     0,
     366,   367,   368,   369,   370,   371,   372,     0,   373,   374,
       0,     0,     0,     0,     0,     0,     0,   375,   376,   377,
       0,   378,   379,   380,     0,   131,     0,   133,     0,     0,
     381,   382,     0,   383,     0,     0,   384,   385,   134,   386,
       0,   387,   388,   389,   390,   138,     0,     0,   391,   392,
     393,     0,   394,   395,   141,   396,     0,   397,   398,     0,
     399,     0,     0,     0,     0,   400,   401,  1503,   403,   404,
     147,   148,   405,     0,   406,     0,   407,     0,   408,   409,
     410,     0,     0,     0,   411,   412,   413,   414,     0,   415,
     416,     0,   417,     0,   418,   419,   420,   154,   421,     0,
     156,     0,   422,   423,   158,     0,   424,     0,   425,     0,
       0,     0,  1504,     0,   427,     0,     0,   428,     0,   429,
     430,     0,   431,   432,   433,     0,   434,   435,   436,   437,
       0,     0,   165,     0,   438,   439,   440,     0,   167,     0,
     168,     0,     0,     0,     0,   441,     0,   442,   443,  1505,
     445,   446,     0,     0,   447,     0,     0,   448,   449,   450,
     451,   452,   453,   454,   455,   456,   457,   458,   459,   460,
     178,     0,   180,   707,   461,   462,   463,   464,   181,     0,
     465,   466,     0,   467,     0,   184,   185,   468,   469,     0,
       0,   470,   708,     0,     0,   471,   472,     0,     0,   186,
       0,     0,   189,   473,   474,   475,     0,   190,   191,   476,
     477,     0,   478,   479,   480,   481,   482,   483,   193,   484,
       0,   485,   486,   487,   488,   489,   490,   491,   492,   493,
     494,   495,     0,   496,   200,   497,   498,   499,  1506,   501,
     502,     0,     0,   503,   504,   505,     0,   506,   204,   507,
     508,     0,   509,   207,     0,   510,   511,   512,   513,   514,
     515,   516,   517,   209,   518,  1507,  1508,   520,   521,   522,
       0,   210,   211,     0,   524,     0,   525,   212,   526,   213,
       0,   527,   528,   529,   530,   531,     0,     0,   532,   533,
     534,   535,   536,     0,     0,   537,   538,   539,   220,   540,
       0,   541,     0,     0,     0,   542,   543,   544,   545,   546,
     547,     0,   222,     0,     0,   223,    79,    80,    81,   353,
       0,    83,    84,     0,    85,    86,    87,   354,     0,   355,
       0,    91,     0,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   356,     0,     0,   103,   104,   105,   106,
       0,     0,     0,   108,   109,   110,     0,   111,     0,     0,
       0,   357,   358,     0,     0,     0,   359,   360,     0,     0,
       0,     0,   361,     0,     0,     0,     0,     0,     0,     0,
       0,   362,     0,   363,     0,   364,   365,     0,   366,   367,
     368,   369,   370,   371,   372,     0,   373,   374,     0,     0,
       0,     0,     0,     0,     0,   375,   376,   377,     0,   378,
     379,   380,     0,   131,     0,   133,     0,     0,   381,   382,
       0,   383,     0,     0,   384,   385,   134,   386,     0,   387,
     388,   389,   390,   138,     0,     0,   391,   392,   393,     0,
     394,   395,   141,   396,     0,   397,   398,     0,   399,     0,
       0,     0,     0,   400,   401,   402,   403,   404,   147,   148,
     405,     0,   406,     0,   407,     0,   408,   409,   410,     0,
       0,     0,   411,   412,   413,   414,     0,   415,   416,     0,
     417,     0,   418,   419,   420,   154,   421,     0,   156,     0,
     422,   423,   158,     0,   424,     0,   425,     0,     0,     0,
     426,     0,   427,     0,     0,   428,     0,   429,   430,     0,
     431,   432,   433,     0,   434,   435,   436,   437,     0,     0,
     165,     0,   438,   439,   440,     0,   167,     0,   168,     0,
       0,     0,     0,   441,     0,   442,   443,   444,   445,   446,
       0,     0,   447,     0,     0,   448,   449,   450,   451,   452,
     453,   454,   455,   456,   457,   458,   459,   460,   178,     0,
     180,   707,   461,   462,   463,   464,   181,     0,   465,   466,
       0,   467,     0,   184,   185,   468,   469,     0,     0,   470,
     708,     0,     0,   471,   472,     0,     0,   186,     0,     0,
     189,   473,   474,   475,     0,   190,   191,   476,   477,     0,
     478,   479,   480,   481,   482,   483,   193,   484,     0,   485,
     486,   487,   488,   489,   490,   491,   492,   493,   494,   495,
       0,   496,   200,   497,   498,   499,   500,   501,   502,     0,
       0,   503,   504,   505,     0,   506,   204,   507,   508,     0,
     509,   207,     0,   510,   511,   512,   513,   514,   515,   516,
     517,   209,   518,     0,   519,   520,   521,   522,     0,   210,
     211,     0,   524,     0,   525,   212,   526,   213,     0,   527,
     528,   529,   530,   531,     0,     0,   532,   533,   534,   535,
     536,     0,     0,   537,   538,   539,   220,   540,     0,   541,
       0,     0,     0,   542,   543,   544,   545,   546,   547,     0,
     222,     0,     0,   223,    79,    80,    81,   353,     0,    83,
      84,     0,    85,    86,    87,   354,     0,   355,     0,    91,
       0,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,   356,     0,     0,   103,   104,   105,   106,     0,     0,
       0,   108,   109,   110,     0,   111,     0,     0,     0,   357,
     358,     0,     0,     0,   359,   360,     0,     0,     0,     0,
     361,     0,     0,     0,     0,     0,     0,     0,     0,   362,
       0,   363,     0,   364,   365,     0,   366,   367,   368,   369,
     370,   371,   372,     0,   373,   374,     0,     0,     0,     0,
       0,     0,     0,   375,   376,   377,     0,   378,   379,   380,
       0,   131,     0,   133,     0,     0,   381,   382,     0,   383,
       0,     0,   384,   385,   134,   386,     0,   387,   388,   389,
     390,   138,     0,     0,   391,   392,   393,     0,   394,   395,
     141,   396,     0,   397,   398,     0,   399,     0,     0,     0,
       0,   400,   401,   402,   403,   404,   147,   148,   405,     0,
     406,     0,   407,     0,   408,   409,   410,     0,     0,     0,
     411,   412,   413,   414,     0,   415,   416,     0,   417,     0,
     418,   419,   420,   154,   421,     0,   156,     0,   422,   423,
     158,     0,   424,     0,   425,     0,   785,     0,   426,     0,
     427,     0,     0,   428,     0,   429,   430,     0,   431,   432,
     433,   786,   434,   435,   436,   437,     0,     0,   165,     0,
     438,   439,   440,     0,   167,     0,   168,     0,     0,     0,
       0,   441,     0,   442,   443,   444,   445,   446,     0,     0,
     447,     0,     0,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   178,     0,   180,     0,
     461,   462,   463,   464,   181,     0,   465,   466,     0,   467,
       0,   184,   185,   468,   469,     0,     0,   470,     0,     0,
       0,   471,   472,     0,     0,   186,     0,     0,   189,   473,
     474,   475,     0,   190,   191,   476,   477,     0,   478,   479,
     480,   481,   482,   483,   193,   484,     0,   485,   486,   487,
     488,   489,   490,   491,   492,   493,   494,   495,     0,   496,
     200,   497,   498,   499,   500,   501,   502,     0,     0,   503,
     504,   505,     0,   506,   204,   507,   508,     0,   509,   207,
       0,   510,   511,   512,   513,   514,   515,   516,   517,   209,
     518,     0,   519,   520,   521,   522,     0,   210,   211,     0,
     524,     0,   525,   212,   526,   213,     0,   527,   528,   529,
     530,   531,     0,     0,   532,   533,   534,   535,   536,     0,
       0,   537,   538,   539,   220,   540,     0,   541,     0,     0,
       0,   542,   543,   544,   545,   546,   547,     0,   222,     0,
       0,   223,    79,    80,    81,   353,     0,    83,    84,     0,
      85,    86,    87,   354,     0,   355,     0,    91,     0,    93,
      94,    95,    96,    97,    98,     0,    99,   100,   101,   356,
       0,     0,   103,   104,   105,   106,     0,     0,     0,   108,
     109,   110,     0,   111,     0,     0,     0,   357,   358,     0,
       0,     0,   359,   360,     0,     0,     0,     0,   361,     0,
       0,     0,     0,     0,     0,     0,     0,   362,     0,   363,
       0,   364,   365,     0,   366,   367,   368,   369,   370,   371,
     372,   834,   373,   374,     0,     0,     0,     0,     0,     0,
       0,   375,   376,   377,     0,   378,   379,   380,     0,   131,
       0,   133,     0,     0,   381,   382,     0,   383,     0,     0,
     384,   385,   134,   386,     0,   387,   388,   389,   390,   138,
       0,     0,   391,   392,   393,     0,   394,   395,   141,   396,
       0,   397,   398,     0,   399,     0,     0,     0,     0,   400,
     401,   402,   403,   404,   147,   148,   405,     0,   406,     0,
     407,     0,   408,   409,   410,     0,     0,     0,   411,   412,
     413,   414,     0,   415,   416,     0,   417,     0,   418,   419,
     420,   154,   421,     0,   156,     0,   422,   423,   158,     0,
     424,     0,   425,     0,     0,     0,   426,     0,   427,     0,
       0,   428,     0,   429,   430,     0,   431,   432,   433,     0,
     434,   435,   436,   437,     0,     0,   165,     0,   438,   439,
     440,     0,   167,     0,   168,     0,     0,     0,     0,   441,
       0,   442,   443,   444,   445,   446,     0,     0,   447,     0,
       0,   448,   449,   450,   451,   452,   453,   454,   455,   456,
     457,   458,   459,   460,   178,     0,   180,     0,   461,   462,
     463,   464,   181,     0,   465,   466,     0,   467,     0,   184,
     185,   468,   469,     0,     0,   470,     0,     0,     0,   471,
     472,     0,     0,   186,     0,     0,   189,   473,   474,   475,
       0,   190,   191,   476,   477,     0,   478,   479,   480,   481,
     482,   483,   193,   484,     0,   485,   486,   487,   488,   489,
     490,   491,   492,   493,   494,   495,     0,   496,   200,   497,
     498,   499,   500,   501,   502,     0,     0,   503,   504,   835,
       0,   506,   204,   507,   508,     0,   509,   207,     0,   510,
     511,   512,   513,   514,   515,   516,   517,   209,   518,     0,
     519,   520,   521,   522,     0,   836,   211,     0,   524,     0,
     837,   212,   526,   213,     0,   527,   528,   529,   530,   531,
       0,     0,   532,   533,   534,   535,   536,     0,     0,   537,
     538,   539,   220,   540,     0,   541,     0,     0,     0,   542,
     543,   544,   545,   546,   547,     0,   222,     0,     0,   223,
      79,    80,    81,   353,     0,    83,    84,     0,    85,    86,
      87,   354,     0,   355,     0,    91,     0,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,   356,     0,     0,
     103,   104,   105,   106,     0,     0,     0,   108,   109,   110,
       0,   111,     0,     0,     0,   357,   358,     0,     0,     0,
     359,   360,     0,     0,     0,     0,   361,     0,     0,     0,
       0,     0,     0,     0,     0,   362,     0,   363,     0,   364,
     365,     0,   366,   367,   368,   369,   370,   371,   372,   858,
     373,   374,     0,     0,     0,     0,     0,     0,     0,   375,
     376,   377,     0,   378,   379,   380,     0,   131,     0,   133,
       0,     0,   381,   382,     0,   383,     0,     0,   384,   385,
     134,   386,     0,   387,   388,   389,   390,   138,     0,     0,
     391,   392,   393,     0,   394,   395,   141,   396,     0,   397,
     398,     0,   399,     0,     0,     0,     0,   400,   401,   402,
     403,   404,   147,   148,   405,     0,   406,     0,   407,     0,
     408,   409,   410,     0,     0,     0,   411,   412,   413,   414,
       0,   415,   416,     0,   417,     0,   418,   419,   420,   154,
     421,     0,   156,     0,   422,   423,   158,     0,   424,     0,
     425,     0,     0,     0,   426,     0,   427,     0,     0,   428,
       0,   429,   430,     0,   431,   432,   433,     0,   434,   435,
     436,   437,     0,     0,   165,     0,   438,   439,   440,     0,
     167,     0,   168,     0,     0,     0,     0,   441,     0,   442,
     443,   444,   445,   446,     0,     0,   447,     0,     0,   448,
     449,   450,   451,   452,   453,   454,   455,   456,   457,   458,
     459,   460,   178,     0,   180,     0,   461,   462,   463,   464,
     181,     0,   465,   466,     0,   467,     0,   184,   185,   468,
     469,     0,     0,   470,     0,     0,     0,   471,   472,     0,
       0,   186,     0,     0,   189,   473,   474,   475,     0,   190,
     191,   476,   477,     0,   478,   479,   480,   481,   482,   483,
     193,   484,     0,   485,   486,   487,   488,   489,   490,   491,
     492,   493,   494,   495,     0,   496,   200,   497,   498,   499,
     500,   501,   502,     0,     0,   503,   504,   859,     0,   506,
     204,   507,   508,     0,   509,   207,     0,   510,   511,   512,
     513,   514,   515,   516,   517,   209,   518,     0,   519,   520,
     521,   522,     0,   860,   211,     0,   524,     0,   861,   212,
     526,   213,     0,   527,   528,   529,   530,   531,     0,     0,
     532,   533,   534,   535,   536,     0,     0,   537,   538,   539,
     220,   540,     0,   541,     0,     0,     0,   542,   543,   544,
     545,   546,   547,     0,   222,     0,     0,   223,    79,    80,
      81,   353,     0,    83,    84,     0,    85,    86,    87,   354,
       0,   355,     0,    91,     0,    93,    94,    95,    96,    97,
      98,     0,    99,   100,   101,   356,     0,     0,   103,   104,
     105,   106,     0,     0,     0,   108,   109,   110,     0,   111,
       0,     0,     0,   357,   358,     0,     0,     0,   359,   360,
       0,     0,     0,     0,   361,     0,     0,     0,     0,     0,
       0,     0,     0,   362,     0,   363,     0,   364,   365,     0,
     366,   367,   368,   369,   370,   371,   372,  1216,   373,   374,
       0,     0,     0,     0,     0,     0,     0,   375,   376,   377,
       0,   378,   379,   380,     0,   131,     0,   133,     0,     0,
     381,   382,     0,   383,     0,     0,   384,   385,   134,   386,
       0,   387,   388,   389,   390,   138,     0,     0,   391,   392,
     393,     0,   394,   395,   141,   396,     0,   397,   398,     0,
     399,     0,     0,     0,     0,   400,   401,   402,   403,   404,
     147,   148,   405,     0,   406,     0,   407,     0,   408,   409,
     410,     0,     0,     0,   411,   412,   413,   414,     0,   415,
     416,     0,   417,     0,   418,   419,   420,   154,   421,     0,
     156,     0,   422,   423,   158,     0,   424,     0,   425,     0,
       0,     0,   426,     0,   427,     0,     0,   428,     0,   429,
     430,     0,   431,   432,   433,     0,   434,   435,   436,   437,
       0,     0,   165,     0,   438,   439,   440,     0,   167,     0,
     168,     0,     0,     0,     0,   441,     0,   442,   443,   444,
     445,   446,     0,     0,   447,     0,     0,   448,   449,   450,
     451,   452,   453,   454,   455,   456,   457,   458,   459,   460,
     178,     0,   180,     0,   461,   462,   463,   464,   181,     0,
     465,   466,     0,   467,     0,   184,   185,   468,   469,     0,
       0,   470,     0,     0,     0,   471,   472,     0,     0,   186,
       0,     0,   189,   473,   474,   475,     0,   190,   191,   476,
     477,     0,   478,   479,   480,   481,   482,   483,   193,   484,
       0,   485,   486,   487,   488,   489,   490,   491,   492,   493,
     494,   495,     0,   496,   200,   497,   498,   499,   500,   501,
     502,     0,     0,   503,   504,   505,     0,   506,   204,   507,
     508,     0,   509,   207,     0,   510,   511,   512,   513,   514,
     515,   516,   517,   209,   518,     0,   519,   520,   521,   522,
       0,   210,   211,     0,   524,     0,   525,   212,   526,   213,
       0,   527,   528,   529,   530,   531,     0,     0,   532,   533,
     534,   535,   536,     0,     0,   537,   538,   539,   220,   540,
       0,   541,     0,     0,     0,   542,   543,   544,   545,   546,
     547,     0,   222,     0,     0,   223,    79,    80,    81,   353,
       0,    83,    84,     0,    85,    86,    87,   354,     0,   355,
       0,    91,     0,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   356,     0,     0,   103,   104,   105,   106,
       0,     0,     0,   108,   109,   110,     0,   111,     0,     0,
       0,   357,   358,     0,     0,     0,   359,   360,     0,     0,
       0,     0,   361,     0,     0,     0,     0,     0,     0,     0,
       0,   362,     0,   363,     0,   364,   365,     0,   366,   367,
     368,   369,   370,   371,   372,     0,   373,   374,     0,     0,
       0,     0,     0,     0,     0,   375,   376,   377,  1225,   378,
     379,   380,     0,   131,     0,   133,     0,     0,   381,   382,
       0,   383,     0,     0,   384,   385,   134,  1226,     0,   387,
     388,   389,   390,   138,     0,     0,   391,   392,   393,     0,
     394,   395,   141,   396,     0,   397,   398,     0,   399,     0,
       0,     0,     0,   400,   401,   402,   403,   404,   147,   148,
     405,     0,   406,     0,   407,     0,   408,   409,   410,     0,
       0,     0,   411,   412,   413,   414,     0,   415,   416,     0,
     417,     0,   418,   419,   420,   154,   421,     0,   156,     0,
     422,   423,   158,     0,   424,     0,   425,     0,     0,     0,
     426,     0,   427,     0,     0,   428,     0,   429,   430,     0,
     431,   432,   433,     0,   434,   435,   436,   437,     0,     0,
     165,     0,   438,   439,   440,     0,   167,     0,   168,     0,
       0,     0,     0,   441,     0,   442,   443,   444,   445,   446,
       0,     0,   447,     0,     0,   448,   449,   450,   451,   452,
     453,   454,   455,   456,   457,   458,   459,   851,   178,     0,
     180,     0,   461,   462,   463,   464,   181,     0,   465,   466,
       0,   467,     0,   184,   185,   468,   469,     0,     0,   470,
       0,     0,     0,   471,   472,     0,     0,   186,     0,     0,
     189,   473,   474,   475,     0,   190,   191,   476,   477,     0,
     478,   479,   480,   481,   482,   483,   193,   484,     0,   485,
     486,   487,   488,   489,   490,   491,   492,   493,   494,   495,
       0,   496,   200,   497,   498,   499,   500,   501,   502,     0,
       0,   503,   504,  1220,     0,   506,   204,   507,   508,     0,
     509,   207,     0,   510,   511,   512,   513,   514,   515,   516,
     517,   209,   518,     0,   519,   520,   521,   522,     0,   853,
     211,     0,   524,     0,   854,   212,   526,   213,     0,   527,
     528,   529,   530,   531,     0,     0,   532,   533,   534,   535,
     536,     0,     0,   537,   538,   539,   220,   540,     0,   541,
       0,     0,     0,   542,   543,   544,   545,   546,   547,     0,
     222,     0,     0,   223,    79,    80,    81,   353,     0,    83,
      84,     0,    85,    86,    87,   354,     0,   355,     0,    91,
       0,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,   356,     0,     0,   103,   104,   105,   106,     0,     0,
       0,   108,   109,   110,     0,   111,     0,     0,     0,   357,
     358,     0,     0,     0,   359,   360,     0,     0,     0,     0,
     361,     0,     0,     0,     0,     0,     0,     0,     0,   362,
       0,   363,     0,   364,   365,     0,   366,   367,   368,   369,
     370,   371,   372,     0,   373,   374,     0,     0,     0,     0,
       0,     0,     0,   375,   376,   377,     0,   378,   379,   380,
       0,   131,     0,   133,     0,     0,   381,   382,     0,   383,
       0,     0,   384,   385,   134,   386,     0,   387,   388,   389,
     390,   138,     0,     0,   391,   392,   393,     0,   394,   395,
     141,   396,     0,   397,   398,     0,   399,     0,     0,     0,
       0,   400,   401,   402,   403,   404,   147,   148,   405,     0,
     406,     0,   407,     0,   408,   409,   410,     0,     0,     0,
     411,   412,   413,   414,     0,   415,   416,     0,   417,     0,
     418,   419,   420,   154,   421,     0,   156,     0,   422,   423,
     158,     0,   424,     0,   425,     0,     0,     0,   426,     0,
     427,     0,  2309,   428,     0,   429,   430,     0,   431,   432,
     433,     0,   434,   435,   436,   437,     0,     0,   165,     0,
     438,   439,   440,     0,   167,     0,   168,     0,     0,     0,
       0,   441,     0,   442,   443,   444,   445,   446,     0,     0,
     447,     0,     0,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   178,     0,   180,     0,
     461,   462,   463,   464,   181,     0,   465,   466,     0,   467,
       0,   184,   185,   468,   469,     0,     0,   470,     0,     0,
       0,   471,   472,     0,     0,   186,     0,     0,   189,   473,
     474,   475,     0,   190,   191,   476,   477,     0,   478,   479,
     480,   481,   482,   483,   193,   484,     0,   485,   486,   487,
     488,   489,   490,   491,   492,   493,   494,   495,     0,   496,
     200,   497,   498,   499,   500,   501,   502,     0,     0,   503,
     504,   505,     0,   506,   204,   507,   508,     0,   509,   207,
       0,   510,   511,   512,   513,   514,   515,   516,   517,   209,
     518,     0,   519,   520,   521,   522,     0,   210,   211,     0,
     524,     0,   525,   212,   526,   213,     0,   527,   528,   529,
     530,   531,     0,     0,   532,   533,   534,   535,   536,     0,
       0,   537,   538,   539,   220,   540,     0,   541,     0,     0,
       0,   542,   543,   544,   545,   546,   547,     0,   222,     0,
       0,   223,    79,    80,    81,   353,     0,    83,    84,     0,
      85,    86,    87,   354,     0,   355,     0,    91,     0,    93,
      94,    95,    96,    97,    98,     0,    99,   100,   101,   356,
       0,     0,   103,   104,   105,   106,     0,     0,     0,   108,
     109,   110,     0,   111,     0,     0,     0,   357,   358,     0,
       0,     0,   359,   360,     0,     0,     0,     0,   361,     0,
       0,     0,     0,     0,     0,     0,     0,   362,     0,   363,
       0,   364,   365,     0,   366,   367,   368,   369,   370,   371,
     372,     0,   373,   374,     0,     0,     0,     0,     0,     0,
       0,   375,   376,   377,     0,   378,   379,   380,     0,   131,
       0,   133,     0,     0,   381,   382,     0,   383,     0,     0,
     384,   385,   134,   386,     0,   387,   388,   389,   390,   138,
       0,     0,   391,   392,   393,     0,   394,   395,   141,   396,
       0,   397,   398,     0,   399,     0,     0,     0,     0,   400,
     401,   402,   403,   404,   147,   148,   405,  2563,   406,     0,
     407,     0,   408,   409,   410,     0,     0,     0,   411,   412,
     413,   414,     0,   415,   416,     0,   417,     0,   418,   419,
     420,   154,   421,     0,   156,     0,   422,   423,   158,     0,
     424,     0,   425,     0,     0,     0,   426,     0,   427,     0,
       0,   428,     0,   429,   430,     0,   431,   432,   433,     0,
     434,   435,   436,   437,     0,     0,   165,     0,   438,   439,
     440,     0,   167,     0,   168,     0,     0,     0,     0,   441,
       0,   442,   443,   444,   445,   446,     0,     0,   447,     0,
       0,   448,   449,   450,   451,   452,   453,   454,   455,   456,
     457,   458,   459,   460,   178,     0,   180,     0,   461,   462,
     463,   464,   181,     0,   465,   466,     0,   467,     0,   184,
     185,   468,   469,     0,     0,   470,     0,     0,     0,   471,
     472,     0,     0,   186,     0,     0,   189,   473,   474,   475,
       0,   190,   191,   476,   477,     0,   478,   479,   480,   481,
     482,   483,   193,   484,     0,   485,   486,   487,   488,   489,
     490,   491,   492,   493,   494,   495,     0,   496,   200,   497,
     498,   499,   500,   501,   502,     0,     0,   503,   504,   505,
       0,   506,   204,   507,   508,     0,   509,   207,     0,   510,
     511,   512,   513,   514,   515,   516,   517,   209,   518,     0,
     519,   520,   521,   522,     0,   210,   211,     0,   524,     0,
     525,   212,   526,   213,     0,   527,   528,   529,   530,   531,
       0,     0,   532,   533,   534,   535,   536,     0,     0,   537,
     538,   539,   220,   540,     0,   541,     0,     0,     0,   542,
     543,   544,   545,   546,   547,     0,   222,     0,     0,   223,
      79,    80,    81,   353,     0,    83,    84,     0,    85,    86,
      87,   354,     0,   355,     0,    91,     0,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,   356,     0,     0,
     103,   104,   105,   106,     0,     0,     0,   108,   109,   110,
       0,   111,     0,     0,     0,   357,   358,     0,     0,     0,
     359,   360,     0,     0,     0,     0,   361,     0,     0,     0,
       0,     0,     0,     0,     0,   362,     0,   363,     0,   364,
     365,     0,   366,   367,   368,   369,   370,   371,   372,     0,
     373,   374,     0,     0,     0,     0,     0,     0,     0,   375,
     376,   377,     0,   378,   379,   380,     0,   131,     0,   133,
       0,     0,   381,   382,     0,   383,     0,     0,   384,   385,
     134,   386,     0,   387,   388,   389,   390,   138,     0,     0,
     391,   392,   393,     0,   394,   395,   141,   396,     0,   397,
     398,     0,   399,     0,     0,     0,     0,   400,   401,   402,
     403,   404,   147,   148,   405,  2565,   406,     0,   407,     0,
     408,   409,   410,     0,     0,     0,   411,   412,   413,   414,
       0,   415,   416,     0,   417,     0,   418,   419,   420,   154,
     421,     0,   156,     0,   422,   423,   158,     0,   424,     0,
     425,     0,     0,     0,   426,     0,   427,     0,     0,   428,
       0,   429,   430,     0,   431,   432,   433,     0,   434,   435,
     436,   437,     0,     0,   165,     0,   438,   439,   440,     0,
     167,     0,   168,     0,     0,     0,     0,   441,     0,   442,
     443,   444,   445,   446,     0,     0,   447,     0,     0,   448,
     449,   450,   451,   452,   453,   454,   455,   456,   457,   458,
     459,   460,   178,     0,   180,     0,   461,   462,   463,   464,
     181,     0,   465,   466,     0,   467,     0,   184,   185,   468,
     469,     0,     0,   470,     0,     0,     0,   471,   472,     0,
       0,   186,     0,     0,   189,   473,   474,   475,     0,   190,
     191,   476,   477,     0,   478,   479,   480,   481,   482,   483,
     193,   484,     0,   485,   486,   487,   488,   489,   490,   491,
     492,   493,   494,   495,     0,   496,   200,   497,   498,   499,
     500,   501,   502,     0,     0,   503,   504,   505,     0,   506,
     204,   507,   508,     0,   509,   207,     0,   510,   511,   512,
     513,   514,   515,   516,   517,   209,   518,     0,   519,   520,
     521,   522,     0,   210,   211,     0,   524,     0,   525,   212,
     526,   213,     0,   527,   528,   529,   530,   531,     0,     0,
     532,   533,   534,   535,   536,     0,     0,   537,   538,   539,
     220,   540,     0,   541,     0,     0,     0,   542,   543,   544,
     545,   546,   547,     0,   222,     0,     0,   223,    79,    80,
      81,   353,     0,    83,    84,     0,    85,    86,    87,   354,
       0,   355,     0,    91,     0,    93,    94,    95,    96,    97,
      98,     0,    99,   100,   101,   356,     0,     0,   103,   104,
     105,   106,     0,     0,     0,   108,   109,   110,     0,   111,
       0,     0,     0,   357,   358,     0,     0,     0,   359,   360,
       0,     0,     0,     0,   361,     0,     0,     0,     0,     0,
       0,     0,     0,   362,     0,   363,     0,   364,   365,     0,
     366,   367,   368,   369,   370,   371,   372,     0,   373,   374,
       0,     0,     0,     0,     0,     0,     0,   375,   376,   377,
       0,   378,   379,   380,     0,   131,     0,   133,     0,     0,
     381,   382,     0,   383,     0,     0,   384,   385,   134,   386,
       0,   387,   388,   389,   390,   138,     0,     0,   391,   392,
     393,     0,   394,   395,   141,   396,     0,   397,   398,     0,
     399,     0,     0,     0,     0,   400,   401,   402,   403,   404,
     147,   148,   405,  2567,   406,     0,   407,     0,   408,   409,
     410,     0,     0,     0,   411,   412,   413,   414,     0,   415,
     416,     0,   417,     0,   418,   419,   420,   154,   421,     0,
     156,     0,   422,   423,   158,     0,   424,     0,   425,     0,
       0,     0,   426,     0,   427,     0,     0,   428,     0,   429,
     430,     0,   431,   432,   433,     0,   434,   435,   436,   437,
       0,     0,   165,     0,   438,   439,   440,     0,   167,     0,
     168,     0,     0,     0,     0,   441,     0,   442,   443,   444,
     445,   446,     0,     0,   447,     0,     0,   448,   449,   450,
     451,   452,   453,   454,   455,   456,   457,   458,   459,   460,
     178,     0,   180,     0,   461,   462,   463,   464,   181,     0,
     465,   466,     0,   467,     0,   184,   185,   468,   469,     0,
       0,   470,     0,     0,     0,   471,   472,     0,     0,   186,
       0,     0,   189,   473,   474,   475,     0,   190,   191,   476,
     477,     0,   478,   479,   480,   481,   482,   483,   193,   484,
       0,   485,   486,   487,   488,   489,   490,   491,   492,   493,
     494,   495,     0,   496,   200,   497,   498,   499,   500,   501,
     502,     0,     0,   503,   504,   505,     0,   506,   204,   507,
     508,     0,   509,   207,     0,   510,   511,   512,   513,   514,
     515,   516,   517,   209,   518,     0,   519,   520,   521,   522,
       0,   210,   211,     0,   524,     0,   525,   212,   526,   213,
       0,   527,   528,   529,   530,   531,     0,     0,   532,   533,
     534,   535,   536,     0,     0,   537,   538,   539,   220,   540,
       0,   541,     0,     0,     0,   542,   543,   544,   545,   546,
     547,     0,   222,     0,     0,   223,    79,    80,    81,   353,
       0,    83,    84,     0,    85,    86,    87,   354,     0,   355,
       0,    91,     0,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   356,     0,     0,   103,   104,   105,   106,
       0,     0,     0,   108,   109,   110,     0,   111,     0,     0,
       0,   357,   358,     0,     0,     0,   359,   360,     0,     0,
       0,     0,   361,     0,     0,     0,     0,     0,     0,     0,
       0,   362,     0,   363,     0,   364,   365,     0,   366,   367,
     368,   369,   370,   371,   372,     0,   373,   374,     0,     0,
       0,     0,     0,  2700,     0,   375,   376,   377,     0,   378,
     379,   380,     0,   131,     0,   133,     0,     0,   381,   382,
       0,   383,     0,     0,   384,   385,   134,   386,     0,   387,
     388,   389,   390,   138,     0,     0,   391,   392,   393,     0,
     394,   395,   141,   396,     0,   397,   398,     0,   399,     0,
       0,     0,     0,   400,   401,   402,   403,   404,   147,   148,
     405,     0,   406,     0,   407,     0,   408,   409,   410,     0,
       0,     0,   411,   412,   413,   414,     0,   415,   416,     0,
     417,     0,   418,   419,   420,   154,   421,     0,   156,     0,
     422,   423,   158,     0,   424,     0,   425,     0,     0,     0,
     426,     0,   427,     0,     0,   428,     0,   429,   430,     0,
     431,   432,   433,     0,   434,   435,   436,   437,     0,     0,
     165,     0,   438,   439,   440,     0,   167,     0,   168,     0,
       0,     0,     0,   441,     0,   442,   443,   444,   445,   446,
       0,     0,   447,     0,     0,   448,   449,   450,   451,   452,
     453,   454,   455,   456,   457,   458,   459,   460,   178,     0,
     180,     0,   461,   462,   463,   464,   181,     0,   465,   466,
       0,   467,     0,   184,   185,   468,   469,     0,     0,   470,
       0,     0,     0,   471,   472,     0,     0,   186,     0,     0,
     189,   473,   474,   475,     0,   190,   191,   476,   477,     0,
     478,   479,   480,   481,   482,   483,   193,   484,     0,   485,
     486,   487,   488,   489,   490,   491,   492,   493,   494,   495,
       0,   496,   200,   497,   498,   499,   500,   501,   502,     0,
       0,   503,   504,   505,     0,   506,   204,   507,   508,     0,
     509,   207,     0,   510,   511,   512,   513,   514,   515,   516,
     517,   209,   518,     0,   519,   520,   521,   522,     0,   210,
     211,     0,   524,     0,   525,   212,   526,   213,     0,   527,
     528,   529,   530,   531,     0,     0,   532,   533,   534,   535,
     536,     0,     0,   537,   538,   539,   220,   540,     0,   541,
       0,     0,     0,   542,   543,   544,   545,   546,   547,     0,
     222,     0,     0,   223,    79,    80,    81,   353,     0,    83,
      84,     0,    85,    86,    87,   354,     0,   355,     0,    91,
       0,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,   356,     0,     0,   103,   104,   105,   106,     0,     0,
       0,   108,   109,   110,     0,   111,     0,     0,     0,   357,
     358,     0,     0,     0,   359,   360,     0,     0,     0,     0,
     361,     0,     0,     0,     0,     0,     0,     0,     0,   362,
       0,   363,     0,   364,   365,     0,   366,   367,   368,   369,
     370,   371,   372,     0,   373,   374,     0,     0,     0,     0,
       0,  2714,     0,   375,   376,   377,     0,   378,   379,   380,
       0,   131,     0,   133,     0,     0,   381,   382,     0,   383,
       0,     0,   384,   385,   134,   386,     0,   387,   388,   389,
     390,   138,     0,     0,   391,   392,   393,     0,   394,   395,
     141,   396,     0,   397,   398,     0,   399,     0,     0,     0,
       0,   400,   401,   402,   403,   404,   147,   148,   405,     0,
     406,     0,   407,     0,   408,   409,   410,     0,     0,     0,
     411,   412,   413,   414,     0,   415,   416,     0,   417,     0,
     418,   419,   420,   154,   421,     0,   156,     0,   422,   423,
     158,     0,   424,     0,   425,     0,     0,     0,   426,     0,
     427,     0,     0,   428,     0,   429,   430,     0,   431,   432,
     433,     0,   434,   435,   436,   437,     0,     0,   165,     0,
     438,   439,   440,     0,   167,     0,   168,     0,     0,     0,
       0,   441,     0,   442,   443,   444,   445,   446,     0,     0,
     447,     0,     0,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   178,     0,   180,     0,
     461,   462,   463,   464,   181,     0,   465,   466,     0,   467,
       0,   184,   185,   468,   469,     0,     0,   470,     0,     0,
       0,   471,   472,     0,     0,   186,     0,     0,   189,   473,
     474,   475,     0,   190,   191,   476,   477,     0,   478,   479,
     480,   481,   482,   483,   193,   484,     0,   485,   486,   487,
     488,   489,   490,   491,   492,   493,   494,   495,     0,   496,
     200,   497,   498,   499,   500,   501,   502,     0,     0,   503,
     504,   505,     0,   506,   204,   507,   508,     0,   509,   207,
       0,   510,   511,   512,   513,   514,   515,   516,   517,   209,
     518,     0,   519,   520,   521,   522,     0,   210,   211,     0,
     524,     0,   525,   212,   526,   213,     0,   527,   528,   529,
     530,   531,     0,     0,   532,   533,   534,   535,   536,     0,
       0,   537,   538,   539,   220,   540,     0,   541,     0,     0,
       0,   542,   543,   544,   545,   546,   547,     0,   222,     0,
       0,   223,    79,    80,    81,   353,     0,    83,    84,     0,
      85,    86,    87,   354,     0,   355,     0,    91,     0,    93,
      94,    95,    96,    97,    98,     0,    99,   100,   101,   356,
       0,     0,   103,   104,   105,   106,     0,     0,     0,   108,
     109,   110,     0,   111,     0,     0,     0,   357,   358,     0,
       0,     0,   359,   360,     0,     0,     0,     0,   361,     0,
       0,     0,     0,     0,     0,     0,     0,   362,     0,   363,
       0,   364,   365,     0,   366,   367,   368,   369,   370,   371,
     372,     0,   373,   374,     0,     0,     0,     0,     0,     0,
       0,   375,   376,   377,     0,   378,   379,   380,     0,   131,
       0,   133,     0,     0,   381,   382,     0,   383,     0,     0,
     384,   385,   134,   386,     0,   387,   388,   389,   390,   138,
       0,     0,   391,   392,   393,     0,   394,   395,   141,   396,
       0,   397,   398,     0,   399,     0,     0,     0,     0,   400,
     401,   402,   403,   404,   147,   148,   405,     0,   406,     0,
     407,     0,   408,   409,   410,     0,     0,     0,   411,   412,
     413,   414,     0,   415,   416,     0,   417,     0,   418,   419,
     420,   154,   421,     0,   156,     0,   422,   423,   158,     0,
     424,     0,   425,     0,     0,     0,   426,     0,   427,     0,
       0,   428,     0,   429,   430,     0,   431,   432,   433,     0,
     434,   435,   436,   437,     0,     0,   165,     0,   438,   439,
     440,     0,   167,     0,   168,     0,     0,     0,     0,   441,
       0,   442,   443,   444,   445,   446,     0,     0,   447,     0,
       0,   448,   449,   450,   451,   452,   453,   454,   455,   456,
     457,   458,   459,   460,   178,     0,   180,     0,   461,   462,
     463,   464,   181,     0,   465,   466,     0,   467,     0,   184,
     185,   468,   469,     0,     0,   470,     0,     0,     0,   471,
     472,     0,     0,   186,     0,     0,   189,   473,   474,   475,
       0,   190,   191,   476,   477,     0,   478,   479,   480,   481,
     482,   483,   193,   484,     0,   485,   486,   487,   488,   489,
     490,   491,   492,   493,   494,   495,     0,   496,   200,   497,
     498,   499,   500,   501,   502,     0,     0,   503,   504,   505,
       0,   506,   204,   507,   508,     0,   509,   207,     0,   510,
     511,   512,   513,   514,   515,   516,   517,   209,   518,     0,
     519,   520,   521,   522,     0,   210,   211,     0,   524,     0,
     525,   212,   526,   213,     0,   527,   528,   529,   530,   531,
       0,     0,   532,   533,   534,   535,   536,     0,  3037,   537,
     538,   539,   220,   540,     0,   541,     0,     0,     0,   542,
     543,   544,   545,   546,   547,     0,   222,     0,     0,   223,
      79,    80,    81,   353,     0,    83,    84,     0,    85,    86,
      87,   354,     0,   355,     0,    91,     0,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,   356,     0,     0,
     103,   104,   105,   106,     0,     0,     0,   108,   109,   110,
       0,   111,     0,     0,     0,   357,   358,     0,     0,     0,
     359,   360,     0,     0,     0,     0,   361,     0,     0,     0,
       0,     0,     0,     0,     0,   362,     0,   363,     0,   364,
     365,     0,   366,   367,   368,   369,   370,   371,   372,     0,
     373,   374,     0,     0,     0,     0,     0,     0,     0,   375,
     376,   377,     0,   378,   379,   380,     0,   131,     0,   133,
       0,     0,   381,   382,     0,   383,     0,     0,   384,   385,
     134,   386,     0,   387,   388,   389,   390,   138,     0,     0,
     391,   392,   393,     0,   394,   395,   141,   396,     0,   397,
     398,     0,   399,     0,     0,     0,     0,   400,   401,   402,
     403,   404,   147,   148,   405,     0,   406,     0,   407,     0,
     408,   409,   410,     0,     0,     0,   411,   412,   413,   414,
       0,   415,   416,     0,   417,     0,   418,   419,   420,   154,
     421,     0,   156,     0,   422,   423,   158,     0,   424,     0,
     425,     0,     0,     0,   426,     0,   427,     0,     0,   428,
       0,   429,   430,     0,   431,   432,   433,     0,   434,   435,
     436,   437,     0,     0,   165,     0,   438,   439,   440,     0,
     167,     0,   168,     0,     0,     0,     0,   441,     0,   442,
     443,   444,   445,   446,     0,     0,   447,     0,     0,   448,
     449,   450,   451,   452,   453,   454,   455,   456,   457,   458,
     459,   460,   178,     0,   180,     0,   461,   462,   463,   464,
     181,     0,   465,   466,     0,   467,     0,   184,   185,   468,
     469,     0,     0,   470,     0,     0,     0,   471,   472,     0,
       0,   186,     0,     0,   189,   473,   474,   475,     0,   190,
     191,   476,   477,     0,   478,   479,   480,   481,   482,   483,
     193,   484,     0,   485,   486,   487,   488,   489,   490,   491,
     492,   493,   494,   495,     0,   496,   200,   497,   498,   499,
     500,   501,   502,     0,     0,   503,   504,   505,     0,   506,
     204,   507,   508,     0,   509,   207,     0,   510,   511,   512,
     513,   514,   515,   516,   517,   209,   518,     0,   519,   520,
     521,   522,     0,   210,   211,     0,   524,     0,   525,   212,
     526,   213,     0,   527,   528,   529,   530,   531,     0,     0,
     532,   533,   534,   535,   536,     0,     0,   537,   538,   539,
     220,   540,     0,   541,     0,     0,     0,   542,   543,   544,
     545,   546,   547,     0,   222,     0,     0,   223,    79,    80,
      81,   353,     0,    83,    84,     0,    85,    86,    87,   354,
       0,   355,     0,    91,     0,    93,    94,    95,    96,    97,
      98,     0,    99,   100,   101,   356,     0,     0,   103,   104,
     105,   106,     0,     0,     0,   108,   109,   110,     0,   111,
       0,     0,     0,   357,   358,     0,     0,     0,   359,   360,
       0,     0,     0,     0,   361,     0,     0,     0,     0,     0,
       0,     0,     0,   362,     0,   363,     0,   364,   365,     0,
     366,   367,   368,   369,   370,   371,   372,     0,   373,   374,
       0,     0,     0,     0,     0,     0,     0,   375,   376,   377,
       0,   378,   379,   380,     0,   131,     0,   133,     0,     0,
     381,   382,     0,   383,     0,     0,   384,   385,   134,   386,
       0,   387,   388,   389,   390,   138,     0,     0,   391,   392,
     393,     0,   394,   395,   141,   396,     0,   397,   398,     0,
     399,     0,     0,     0,     0,   400,   401,   402,   403,   404,
     147,   148,   405,     0,   406,     0,   407,     0,   408,   409,
     410,     0,     0,     0,   411,   412,   413,   414,     0,   415,
     416,     0,   417,     0,   418,   419,   420,   154,   421,     0,
     156,     0,   422,   423,   158,     0,   424,     0,   425,     0,
       0,     0,   426,     0,   427,     0,     0,   428,     0,   429,
     430,     0,   431,   432,   433,     0,   434,   435,   436,   437,
       0,     0,   165,     0,   438,   439,   440,     0,   167,     0,
     168,     0,     0,     0,     0,   441,     0,   442,   443,   444,
     445,   446,     0,     0,   447,     0,     0,   448,   449,   450,
     451,   452,   453,   454,   455,   456,   457,   458,   459,   460,
     178,     0,   180,     0,   461,   462,   463,   464,   181,     0,
     465,   466,     0,   467,     0,   184,   185,   468,   469,     0,
       0,   470,     0,     0,     0,   471,   472,     0,     0,   186,
       0,     0,   189,   473,   474,   475,     0,   190,   191,   476,
     477,     0,   478,   479,   480,   481,   482,   483,   193,   484,
       0,   485,   486,   487,   488,   489,   490,   491,   492,   493,
     494,   495,     0,   496,   200,   497,   498,   499,   500,   501,
     502,     0,     0,   503,   504,   505,     0,   506,   204,   507,
     508,     0,   509,   207,     0,   510,   511,   750,   513,   514,
     515,   516,   517,   209,   518,     0,   519,   520,   521,   522,
       0,   210,   211,     0,   524,     0,   525,   212,   526,   213,
       0,   527,   528,   529,   530,   531,     0,     0,   532,   533,
     534,   535,   536,     0,     0,   537,   538,   539,   220,   540,
       0,   541,     0,     0,     0,   542,   543,   544,   545,   546,
     547,     0,   222,     0,     0,   223,    79,    80,    81,   353,
       0,    83,    84,     0,    85,    86,    87,   354,     0,   355,
       0,    91,     0,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   356,     0,     0,   103,   104,   105,   106,
       0,     0,     0,   108,   109,   110,     0,   111,     0,     0,
       0,   357,   358,     0,     0,     0,   359,   360,     0,     0,
       0,     0,   361,     0,     0,     0,     0,     0,     0,     0,
       0,   362,     0,   363,     0,   364,   365,     0,   366,   367,
     368,   369,   370,   371,   372,     0,   373,   374,     0,     0,
       0,     0,     0,     0,     0,   375,   376,   377,     0,   378,
     379,   380,     0,   131,     0,   133,     0,     0,   381,   382,
       0,   383,     0,     0,   384,   385,   134,   386,     0,   387,
     388,   389,   390,   138,     0,     0,   391,   392,   393,     0,
     394,   395,   141,   396,     0,   397,   398,     0,   399,     0,
       0,     0,     0,   400,   401,   402,   403,   404,   147,   148,
     405,     0,   406,     0,   407,     0,   408,   409,   410,     0,
       0,     0,   411,   412,   413,   414,     0,   415,   416,     0,
     417,     0,   418,   419,   420,   154,   421,     0,   156,     0,
     422,   423,   158,     0,   424,     0,   425,     0,     0,     0,
     426,     0,   427,     0,     0,   428,     0,   429,   430,     0,
     431,   432,   433,     0,   434,   435,   436,   437,     0,     0,
     165,     0,   438,   439,   440,     0,   167,     0,   168,     0,
       0,     0,     0,   441,     0,   442,   443,   444,   445,   446,
       0,     0,   447,     0,     0,   448,   449,   450,   451,   452,
     453,   454,   455,   456,   457,   458,   459,   460,   178,     0,
     180,     0,   461,   462,   463,   464,   181,     0,   465,   466,
       0,   467,     0,   184,   185,   468,   469,     0,     0,   470,
       0,     0,     0,   471,   472,     0,     0,   186,     0,     0,
     189,   473,   474,   475,     0,   190,   191,   476,   477,     0,
     478,   479,   480,   481,   482,   483,   193,   484,     0,   485,
     486,   487,   488,   489,   490,   491,   492,   493,   494,   495,
       0,   496,   200,   497,   498,   832,   500,   501,   502,     0,
       0,   503,   504,   505,     0,   506,   204,   507,   508,     0,
     509,   207,     0,   510,   511,   512,   513,   514,   515,   516,
     517,   209,   518,     0,   519,   520,   521,   522,     0,   210,
     211,     0,   524,     0,   525,   212,   526,   213,     0,   527,
     528,   529,   530,   531,     0,     0,   532,   533,   534,   535,
     536,     0,     0,   537,   538,   539,   220,   540,     0,   541,
       0,     0,     0,   542,   543,   544,   545,   546,   547,     0,
     222,     0,     0,   223,    79,    80,    81,   353,     0,    83,
      84,     0,    85,    86,    87,   354,     0,   355,     0,    91,
       0,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,   356,     0,     0,   103,   104,   105,   106,     0,     0,
       0,   108,   109,   110,     0,   111,     0,     0,     0,   357,
     358,     0,     0,     0,   359,   360,     0,     0,     0,     0,
     361,     0,     0,     0,     0,     0,     0,     0,     0,   362,
       0,   363,     0,   364,   365,     0,   366,   367,   368,   369,
     370,   371,   372,     0,   373,   374,     0,     0,     0,     0,
       0,     0,     0,   375,   376,   377,     0,   378,   379,   380,
       0,   131,     0,   133,     0,     0,   381,   382,     0,   383,
       0,     0,   384,   385,   134,   386,     0,   387,   388,   389,
     390,   138,     0,     0,   391,   392,   393,     0,   394,   395,
     141,   396,     0,   397,   398,     0,   399,     0,     0,     0,
       0,   400,   401,   402,   403,   404,   147,   148,   405,     0,
     406,     0,   407,     0,   408,   409,   410,     0,     0,     0,
     411,   412,   413,   414,     0,   415,   416,     0,   417,     0,
     418,   419,   420,   154,   421,     0,   156,     0,   422,   423,
     158,     0,   424,     0,   425,     0,     0,     0,   426,     0,
     427,     0,     0,   428,     0,   429,   430,     0,   431,   432,
     433,     0,   434,   435,   436,   437,     0,     0,   165,     0,
     438,   439,   440,     0,   167,     0,   168,     0,     0,     0,
       0,   441,     0,   442,   443,   444,   445,   446,     0,     0,
     447,     0,     0,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   851,   178,     0,   180,     0,
     461,   462,   463,   464,   181,     0,   465,   466,     0,   467,
       0,   184,   185,   468,   469,     0,     0,   470,     0,     0,
       0,   471,   472,     0,     0,   186,     0,     0,   189,   473,
     474,   475,     0,   190,   191,   476,   477,     0,   478,   479,
     480,   481,   482,   483,   193,   484,     0,   485,   486,   487,
     488,   489,   490,   491,   492,   493,   494,   495,     0,   496,
     200,   497,   498,   499,   500,   501,   502,     0,     0,   503,
     504,  1220,     0,   506,   204,   507,   508,     0,   509,   207,
       0,   510,   511,   512,   513,   514,   515,   516,   517,   209,
     518,     0,   519,   520,   521,   522,     0,   853,   211,     0,
     524,     0,   854,   212,   526,   213,     0,   527,   528,   529,
     530,   531,     0,     0,   532,   533,   534,   535,   536,     0,
       0,   537,   538,   539,   220,   540,     0,   541,     0,     0,
       0,   542,   543,   544,   545,   546,   547,     0,   222,     0,
       0,   223,  1318,    80,    81,   353,     0,    83,    84,     0,
      85,    86,    87,   354,     0,   355,     0,    91,     0,    93,
      94,    95,    96,    97,    98,     0,    99,   100,   101,   356,
       0,     0,   103,   104,   105,   106,     0,     0,     0,   108,
     109,   110,     0,   111,     0,     0,     0,   357,   358,     0,
       0,     0,   359,   360,     0,     0,     0,     0,   361,     0,
       0,     0,     0,     0,     0,     0,     0,   362,     0,   363,
       0,   364,   365,     0,   366,   367,   368,   369,   370,   371,
     372,     0,   373,   374,     0,     0,     0,     0,     0,     0,
       0,   375,   376,   377,     0,   378,   379,   380,     0,   131,
       0,   133,     0,     0,   381,   382,     0,   383,     0,     0,
     384,   385,   134,   386,     0,   387,   388,   389,   390,   138,
       0,     0,   391,   392,   393,     0,   394,   395,   141,   396,
       0,   397,   398,     0,   399,     0,     0,     0,     0,   400,
     401,   402,   403,   404,   147,   148,   405,     0,   406,     0,
     407,     0,   408,   409,   410,     0,     0,     0,   411,   412,
     413,   414,     0,   415,   416,     0,   417,     0,   418,   419,
     420,   154,   421,     0,   156,     0,   422,   423,   158,     0,
     424,     0,   425,     0,     0,     0,   426,     0,   427,     0,
       0,   428,     0,   429,   430,     0,   431,   432,   433,     0,
     434,   435,   436,   437,     0,     0,   165,     0,   438,   439,
     440,     0,   167,     0,   168,     0,     0,     0,     0,   441,
       0,   442,   443,   444,   445,   446,     0,     0,   447,     0,
       0,   448,   449,   450,   451,   452,   453,   454,   455,   456,
     457,   458,   459,   460,   178,     0,   180,     0,   461,   462,
     463,   464,   181,     0,   465,   466,     0,   467,     0,   184,
     185,   468,   469,     0,     0,   470,     0,     0,     0,   471,
     472,     0,     0,   186,     0,     0,   189,   473,   474,   475,
       0,   190,   191,   476,   477,     0,   478,   479,   480,   481,
     482,   483,   193,   484,     0,   485,   486,   487,   488,   489,
     490,   491,   492,   493,   494,   495,     0,   496,   200,   497,
     498,   499,   500,   501,   502,     0,     0,   503,   504,   505,
       0,   506,   204,   507,   508,     0,   509,   207,     0,   510,
     511,   512,   513,   514,   515,   516,   517,   209,   518,     0,
     519,   520,   521,   522,     0,   210,   211,     0,   524,     0,
     525,   212,   526,   213,     0,   527,   528,   529,   530,   531,
       0,     0,   532,   533,   534,   535,   536,     0,     0,   537,
     538,   539,   220,   540,     0,   541,     0,     0,     0,   542,
     543,   544,   545,   546,   547,     0,   222,     0,     0,   223,
      79,    80,    81,   353,     0,    83,    84,     0,    85,    86,
      87,   354,     0,   355,     0,    91,     0,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,   356,     0,     0,
     103,   104,   105,   106,     0,     0,     0,   108,   109,   110,
       0,   111,     0,     0,     0,   357,   358,     0,     0,     0,
     359,   360,     0,     0,     0,     0,   361,     0,     0,     0,
       0,     0,     0,     0,     0,   362,     0,   363,     0,   364,
     365,     0,   366,   367,   368,   369,   370,   371,   372,     0,
     373,   374,     0,     0,     0,     0,     0,     0,     0,   375,
     376,   377,     0,   378,   379,   380,     0,   131,     0,   133,
       0,     0,   381,   382,     0,   383,     0,     0,   384,   385,
     134,   386,     0,   387,   388,   389,   390,   138,     0,     0,
     391,   392,   393,     0,   394,   395,   141,   396,     0,   397,
     398,     0,   399,     0,     0,     0,     0,   400,   401,   402,
     403,   404,   147,   148,   405,     0,   406,     0,   407,     0,
     408,   409,   410,     0,     0,     0,   411,   412,   413,   414,
       0,   415,   416,     0,   417,     0,   418,   419,   420,   154,
     421,     0,   156,     0,   422,   423,   158,     0,   424,     0,
     425,     0,     0,     0,   426,     0,   427,     0,     0,   428,
       0,   429,   430,     0,   431,   432,   433,     0,   434,   435,
     436,   437,     0,     0,   165,     0,   438,   439,   440,     0,
     167,     0,   168,     0,     0,     0,     0,   441,     0,   442,
     443,   444,   445,   446,     0,     0,   447,     0,     0,   448,
     449,   450,   451,   452,   453,   454,   455,   456,   457,   458,
     459,   460,   178,     0,   180,     0,   461,   462,   463,   464,
     181,     0,   465,   466,     0,   467,     0,   184,   185,   468,
     469,     0,     0,   470,     0,     0,     0,   471,   472,     0,
       0,   186,     0,     0,   189,   473,   474,   475,     0,   190,
     191,   476,   477,     0,   478,   479,   480,   481,   482,   483,
     193,   484,     0,   485,   486,   487,   488,   489,   490,   491,
     492,   493,   494,   495,     0,   496,   200,   497,   498,  1528,
     500,   501,   502,     0,     0,   503,   504,   505,     0,   506,
     204,   507,   508,     0,   509,   207,     0,   510,   511,   512,
     513,   514,   515,   516,   517,   209,   518,     0,   519,   520,
     521,   522,     0,   210,   211,     0,   524,     0,   525,   212,
     526,   213,     0,   527,   528,   529,   530,   531,     0,     0,
     532,   533,   534,   535,   536,     0,     0,   537,   538,   539,
     220,   540,     0,   541,     0,     0,     0,   542,   543,   544,
     545,   546,   547,     0,   222,     0,     0,   223,    79,    80,
      81,     0,     0,    83,    84,     0,    85,    86,    87,     0,
       0,     0,    90,    91,     0,    93,    94,    95,    96,    97,
      98,     0,    99,   100,   101,     0,     0,     0,   103,   104,
     105,   106,     0,   107,     0,   108,   109,   110, -1298,   111,
     112,   113,     0,     0,     0,     0,     0,     0,   116,   117,
       0,     0,     0,     0,   118,     0,     0,     0,     0,     0,
       0,     0,     0,   119,     0,   120,     0,   121,   122,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     128,     0,     0,     0,   130,   131,   132,   133,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   134,     0,
       0,     0,     0,     0,     0,   138,     0,     0,     0,     0,
       0,     0,     0,     0,   141,     0,     0,     0,     0,   144,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     147,   148,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   154,     0,     0,
     156,     0,     0,     0,   158,     0,     0,     0,     0,   159,
       0,   160,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   163,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   164,   165,     0,     0,     0,     0,     0,   167,     0,
     168,     0,     0,   169,   170,     0,   171,     0,     0,     0,
       0,     0,     0,   172,     0,   173,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     178,   179,   180,     0,     0,     0,     0,     0,   181,     0,
       0,     0,   183,     0,     0,   184,   185,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   186,
     187,   188,   189,     0,     0,     0,     0,   190,   191,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   193,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   198,     0,   200,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   204,     0,
       0,   206,     0,   207,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   209,     0,     0,     0,     0,     0,     0,
       0,   210,   211,     0,     0,     0,     0,   212,     0,   213,
       0,     0,     0,     0,     0,     0,   216,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   220,     0,
     221,     0,     0,     0,     0,     0,     0,     0,    79,    80,
      81,     0,   222,    83,    84,   223,    85,    86,    87,     0,
       0,     0,    90,    91,     0,    93,    94,    95,    96,    97,
      98,     0,    99,   100,   101,     0,     0,     0,   103,   104,
     105,   106,     0,   107,     0,   108,   109,   110, -1299,   111,
     112,   113,     0,     0,     0,     0,     0,     0,   116,   117,
       0,     0,     0,     0,   118,     0,     0,     0,     0,     0,
       0,     0,     0,   119,     0,   120,     0,   121,   122,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     128,     0,     0,     0,   130,   131,   132,   133,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   134,     0,
       0,     0,     0,     0,     0,   138,     0,     0,     0,     0,
       0,     0,     0,     0,   141,     0,     0,     0,     0,   144,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     147,   148,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   154,     0,     0,
     156,     0,     0,     0,   158,     0,     0,     0,     0,   159,
       0,   160,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   163,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   164,   165,     0,     0,     0,     0,     0,   167,     0,
     168,     0,     0,   169,   170,     0,   171,     0,     0,     0,
       0,     0,     0,   172,     0,   173,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     178,   179,   180,     0,     0,     0,     0,     0,   181,     0,
       0,     0,   183,     0,     0,   184,   185,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   186,
     187,   188,   189,     0,     0,     0,     0,   190,   191,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   193,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   198,     0,   200,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   204,     0,
       0,   206,     0,   207,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   209,     0,     0,     0,     0,     0,     0,
       0,   210,   211,     0,     0,     0,     0,   212,     0,   213,
       0,     0,     0,     0,     0,     0,   216,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   220,     0,
     221,     0,     0,     0,     0,     0,     0,     0,    79,    80,
      81,     0,   222,    83,    84,   223,    85,    86,    87,     0,
       0,     0,    90,    91,     0,    93,    94,    95,    96,    97,
      98,     0,    99,   100,   101,     0,     0,     0,   103,   104,
     105,   106,     0,   107,     0,   108,   109,   110,     0,   111,
     112,   113,     0,     0,     0,     0,     0,     0,   116,   117,
       0,     0,     0,     0,   118,     0,     0,     0,     0,     0,
       0,     0,     0,   119,     0,   120,     0,   121,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     128,     0,     0,     0,   130,   131,   132,   133,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   134,     0,
       0,     0,     0,     0,     0,   138,     0,     0,     0,     0,
       0,     0,     0,     0,   141,     0,     0,     0,     0,   144,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     147,   148,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   154,     0,     0,
     156,     0,     0,     0,   158,     0,     0,     0,     0,   159,
       0,   160,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   163,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   164,   165,     0,     0,     0,     0,     0,   167,     0,
     168,     0,     0,   169,   170,     0,   171,     0,     0,     0,
       0,     0,     0,   172,     0,   173,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     178,   179,   180,     0,     0,     0,     0,     0,   181,     0,
       0,     0,   183,     0,     0,   184,   185,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   186,
     187,   188,   189,     0,     0,     0,     0,   190,   191,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   193,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   198,     0,   200,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   204,     0,
       0,   206,     0,   207,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   209,     0,     0,     0,     0,     0,     0,
       0,   210,   211,     0,     0,     0,     0,   212,     0,   213,
       0,     0,     0,     0,     0,     0,   216,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   220,     0,
     221,     0,     0,     0,     0,     0,     0,     0,    79,    80,
      81,     0,   222,    83,    84,   223,    85,    86,    87,     0,
       0,     0,    90,    91,     0,    93,    94,    95,    96,    97,
      98,     0,    99,   100,   101,     0,     0,     0,   103,   104,
     105,   106,     0,   107,     0,   108,   109,   110,     0,   111,
     112,   113,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     128,     0,     0,     0,   130,   131,   132,   133,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   134,     0,
       0,     0,     0,     0,     0,   138,     0,     0,     0,     0,
       0,     0,     0,     0,   141,     0,     0,     0,     0,   144,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     147,   148,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   154,     0,     0,
     156,     0,     0,     0,   158,     0,     0,     0,     0,   159,
       0,   160,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   163,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   164,   165,     0,     0,     0,     0,     0,   167,     0,
     168,     0,     0,   169,   170,     0,   171,     0,     0,     0,
       0,     0,     0,   172,     0,   173,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     178,   179,   180,     0,     0,     0,     0,     0,   181,     0,
       0,     0,   183,     0,     0,   184,   185,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   186,
     187,   188,   189,     0,     0,     0,     0,   190,   191,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   193,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   198,     0,   200,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   204,     0,
       0,   206,     0,   207,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   209,     0,     0,     0,     0,     0,     0,
       0,   210,   211,     0,     0,     0,     0,   212,     0,   213,
       0,     0,     0,     0,     0,     0,   216,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   220,     0,
     221,    79,    80,    81,     0,     0,    83,    84,     0,    85,
      86,    87,   222,     0,     0,   223,    91,     0,    93,    94,
      95,    96,    97,    98,     0,    99,   100,   101,     0,     0,
       0,   103,   104,   105,   106,     0,     0,     0,   108,   109,
     110,     0,   111,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   128,     0,     0,     0,   130,   131,   132,
     133,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   134,     0,     0,     0,     0,     0,     0,   138,     0,
       0,     0,     0,     0,     0,     0,     0,   141,     0,     0,
       0,     0,   144,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   147,   148,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     154,     0,     0,   156,     0,     0,     0,   158,     0,     0,
       0,     0,   159,     0,   160,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   163,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   164,   165,     0,     0,     0,     0,
       0,   167,     0,   168,     0,     0,   169,   170,     0,   171,
       0,     0,     0,     0,     0,     0,   172,     0,   173,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   178,   179,   180,     0,     0,     0,     0,
       0,   181,     0,     0,     0,   183,     0,     0,   184,   185,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   186,   187,   188,   189,     0,     0,     0,     0,
     190,   191,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   193,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   198,     0,   200,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   204,     0,     0,   206,     0,   207,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   209,     0,     0,     0,
       0,     0,     0,     0,   210,   211,     0,     0,     0,     0,
     212,     0,   213,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   220,     0,   221,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   222,     0,     0,   223
};

static const short yycheck[] =
{
       2,   224,    90,    74,  1065,    74,    90,    90,   687,   153,
    1040,   679,   691,   146,   849,  1473,  1046,  1003,  1323,   695,
     153,   968,   823,    74,   112,   972,  1352,   854,   112,   112,
    1455,    77,   218,  1427,    90,   959,  1304,  1881,   940,   718,
     137,    74,  1913,   689,   690,   214,    90,  1639,   192,    74,
    1531,  1153,   728,   940,  1169,    82,   112,    74,   688,   192,
     690,   157,    74,   692,   745,   137,  1883,  1566,   112,  2070,
    2262,   701,  2137,   702,   753,   907,   722,   174,   127,  1705,
     759,   177,  2307,   779,    74,   182,   762,    77,  1847,    25,
    2091,  1800,  1801,     2,   724,  1883,   145,   726,  1883,  1598,
      90,  1883,   174,  1883,  1883,  2426,   736,  1120,  1121,   738,
     182,   757,  1779,  1780,  1740,  2431,  2432,  1080,  1744,   800,
     217,  1776,   112,    26,    74,    42,  1139,    77,   216,    77,
    1678,   760,   216,   216,   850,  1469,   852,   935,   940,   915,
      90,    92,   771,   847,   774,   217,   218,    77,   175,   923,
     924,    92,    50,   224,   225,   157,   225,   111,   681,  1080,
     216,    98,   112,    92,  2788,    42,   111,   848,    74,  1090,
    1091,    77,   216,  1129,   134,   177,   116,    93,  2379,   659,
    2069,    77,   146,    85,    90,    85,    77,   150,   203,    91,
      82,    91,    80,  2929,   118,    77,  1471,   166,   156,  1593,
     225,    97,  1477,   134,   188,   129,   112,   151,   225,   188,
     171,  1878,   219,   225,    92,    97,   128,     8,   219,   352,
     125,    82,   111,    14,    15,    16,   216,   145,    93,    74,
    1856,  2955,    92,   193,   198,    26,    27,    28,  1564,    30,
      31,    32,   122,  1229,   272,    36,    37,    38,   156,    77,
     172,    85,   156,   266,   153,    43,   217,    45,   151,   310,
     164,   185,   193,   183,   151,    92,   216,   151,  1192,  1190,
     183,   144,   164,    85,   153,   295,    77,   310,   242,    91,
     223,   245,   320,   312,   172,  1371,   134,  2881,   206,  2883,
      82,   257,   155,   351,   116,    87,    97,   154,   349,    82,
     346,   792,   158,   164,    87,   213,   714,   342,    12,  1334,
     216,     0,  1414,   281,   234,   276,   349,   394,    29,   413,
     310,   234,   399,   417,  1385,    85,  1228,   421,   294,  1008,
     122,  1356,   740,   824,   302,  1014,   371,  1005,  2209,   122,
     369,  1017,   134,   200,   402,   193,    50,   977,   268,   369,
     219,   134,   295,   307,   318,   268,   346,   220,   386,   349,
     310,  3085,   307,   262,   219,   289,  1452,   351,   241,   219,
     243,   151,   164,   257,  1053,   262,   320,   415,   257,    77,
     225,   164,  2703,   287,  1842,   219,  2707,  1400,  1401,   269,
    2711,   354,  1378,   221,  2988,  1408,   346,  1945,  1459,   349,
     116,  1325,   415,   364,   310,   327,   421,   344,    77,  1039,
     302,   369,   381,  3149,   421,  1530,  1531,   418,   307,   151,
     221,  1051,   385,   387,   312,   343,  1541,  1542,  2493,  2494,
     332,   375,   332,  1380,   957,  2231,   372,  1067,  3062,   327,
     346,   365,   421,   349,  2645,   273,   351,  1403,  2207,  2208,
     362,   415,  1567,   933,  1569,   346,   416,  2216,   418,   219,
    2086,   369,   413,   411,   325,   416,   417,   421,  2016,   257,
     421,   415,   413,   409,   523,   415,   421,   394,   408,   409,
     410,   411,  1429,  1259,   413,   416,  1288,   418,  2080,   156,
    2145,   394,  1991,  1992,  1993,   286,   394,  1996,   391,   415,
      77,   394,  1300,  1837,   215,  1281,   399,   693,  1212,  1213,
     302,  1285,   698,  1628,   391,   411,   372,   394,   383,   384,
     332,  1484,   399,   221,   401,    77,   408,   409,   410,   411,
     407,  2198,   111,   325,   118,   413,   190,  2426,   416,   417,
    2039,  2089,   325,   421,  1557,  1558,   213,    77,  1244,   418,
    2871,  2867,   221,   413,  1386,  2876,   416,   417,   104,  2880,
     394,   421,  1483,   418,   392,   399,   752,    97,   418,   391,
     361,  1492,   394,   407,   402,   403,   404,   151,   406,   407,
     408,   409,   410,   411,   418,   399,   413,   401,   416,   416,
     417,   679,   259,   415,   421,   679,   679,   143,    29,   281,
     697,   185,   746,  2795,  2230,   406,   407,   408,   409,   410,
     411,   391,   745,   746,   394,   687,  1332,    98,   151,   691,
     717,   693,   219,   679,   172,   697,   698,   112,    34,   189,
     129,    29,   683,   219,   394,   679,   117,   268,   418,   399,
    1915,  1916,    40,   776,   221,   717,   718,   407,   146,   203,
     683,  2740,   151,   320,  1370,  1323,   210,   659,   418,   391,
     314,   377,   394,   102,  2985,    86,   212,   800,  1503,   221,
    1505,  1506,   281,  1508,   253,   391,  1352,    18,   394,   266,
     752,   753,   297,   257,   780,   969,   782,   759,   784,   679,
    2084,   221,   222,   683,   790,   791,   273,   154,  2787,   415,
     198,  2926,   369,  1627,   271,   289,  1507,   253,   406,   407,
     408,   409,   410,   411,   998,   848,   325,   115,  2044,   156,
     817,   273,   282,   277,   257,   379,   823,  1395,   307,   679,
     260,   216,  2603,   683,   831,   417,   190,   406,   407,   408,
     409,   410,   411,   200,   242,   817,   325,   146,   415,   223,
     659,   823,  2548,  2549,  2550,  2551,  2552,  1387,   257,   831,
     199,  1391,   336,   164,   203,   339,  2583,   864,   234,  2528,
    2529,   317,   869,   679,   262,   372,   213,   683,   780,   327,
     782,   365,   784,   880,   215,   150,   372,   160,   790,   791,
     421,   156,   864,   214,   233,  2583,   104,   869,  2583,   198,
     415,  2583,   268,  2583,  2583,   211,   179,   104,   880,   865,
     242,   416,  1441,  2902,  2703,   392,   421,   215,  2707,   273,
     318,   295,  2711,  2532,   851,  1504,   403,   404,   415,   406,
     407,   408,   409,   410,   411,   143,   351,  1739,   156,    85,
     392,   154,   118,   242,    18,  1680,   245,  1476,   213,   125,
    1480,  2332,  1739,   129,   406,   407,   408,   409,   410,   411,
     188,  2360,   416,  2138,  2363,  2364,  2365,  2366,  2367,  2368,
    2369,  2370,  2371,  2372,  1935,   865,   406,   407,   408,   409,
     410,   411,   120,   320,   257,   339,   318,   200,  1564,   262,
     329,  1723,   219,   266,  2009,   213,   923,   924,   242,  2398,
    2399,   245,   417,   391,   212,   907,   394,   422,   354,   185,
    1007,  2186,  2187,  2028,   160,   865,   179,  1005,   221,   318,
     343,  1005,  1005,  3117,   325,  2814,   193,  2553,  1596,   198,
     932,   933,   369,   935,   120,  1007,  1008,   153,   940,   385,
     258,   259,  1014,   146,   173,   253,  1169,   421,   160,  1005,
     321,  1048,  1049,   320,   155,   320,  2071,  2072,  1055,   865,
     361,  1005,  1794,  2354,  3158,  1797,  1798,   383,   271,   167,
    1103,   414,   343,   242,   318,   204,  1048,  1049,   421,   203,
     413,  1053,  2871,  1055,   417,   358,   210,  2876,   387,  2380,
    3184,  2880,   208,   366,  2753,   198,  2755,  2756,   907,   262,
    1097,  3066,   320,   266,   369,   421,   312,    82,   375,   317,
    1081,   321,  1081,   289,    89,  1005,   415,    92,  2293,   220,
    2295,  2296,   188,   932,   933,  1097,   935,   102,  1099,   335,
    1099,   940,  2008,   343,  2010,  2011,  3101,   203,   189,   242,
     238,   257,   245,  1114,   189,   257,  3047,  1074,   415,   318,
     415,   369,   127,   277,   266,  1005,  1081,  1738,   209,   123,
    1131,   136,   137,   416,  1081,  2936,   281,   295,   421,  1081,
     145,   146,  2571,   224,   149,   303,   140,   354,   153,   281,
     231,   302,   157,   281,   305,  3086,  1157,   302,   152,   365,
     135,   136,   281,    57,   322,   358,  2985,   415,  1169,  1005,
     302,   416,   177,   366,   325,   377,   421,    77,   281,  1755,
     325,    75,   281,   302,    77,   318,   305,   192,   281,   391,
     195,   196,   394,  1752,    83,  1754,   201,    97,   203,   302,
     205,  2723,   102,   302,    97,   199,   325,   418,  1598,   302,
    1769,   100,  1239,   415,  1171,   118,   344,  3036,   346,   419,
    1779,  1780,  1781,  1782,   392,  1182,  2915,   267,   203,   310,
    2554,   271,   383,  1792,   402,   403,   404,  1239,   406,   407,
     408,   409,   410,   411,   413,  1263,   415,     5,   151,  1250,
    1251,  1367,  1253,   378,   387,  2684,  1815,   281,  3032,  1818,
    1819,  3035,   414,   337,   338,   383,   384,   120,  1225,   421,
    1296,    29,  2149,    46,   383,   384,   392,  1263,   302,   254,
     255,  2479,    40,   418,  1844,  1845,   402,   403,   404,  1263,
     406,   407,   408,   409,   410,   411,  1228,   415,  1230,   391,
    1232,   402,   394,   203,  1283,  1323,   415,  3081,   283,  1323,
    1323,  1357,   413,  1924,  1360,  1361,   417,   391,   418,  1878,
     394,   221,   222,   383,   384,  2082,   125,   394,  1285,   151,
     129,   391,   399,  1314,   394,  1321,  2101,  1323,   391,    77,
     407,   394,  1274,  1263,  1264,  1265,  2391,   352,   392,  1323,
    2674,  1314,  2384,  2385,   257,   415,   345,   115,   347,   262,
     260,  1514,   415,   391,  1296,  1367,   394,   342,  1300,   416,
      88,    89,  1304,   273,   421,  1126,  1127,  1395,   408,   409,
     410,  1395,  1395,  1263,  1264,  1265,   289,   415,   423,  1228,
     109,  1230,  2224,  1232,  1314,   298,   218,   394,  1149,   374,
     413,  1321,   399,  1323,   417,   163,   394,  1158,  2613,  1395,
     413,  2173,   415,   391,   417,   237,   394,  2179,  2180,   416,
    2849,  1395,  2851,   393,   394,   144,  2631,  1263,  1264,  1265,
     390,   383,   384,   393,  1314,  1274,   419,   415,  2044,   391,
     416,  1321,   394,  1323,   372,   421,   391,  1474,  1475,   394,
     115,   116,   391,   391,  1386,   394,   394,   215,   345,    39,
     347,  1300,   365,   415,  2819,  1304,   391,   215,   391,   394,
     415,   394,  1474,  1475,  2730,  1395,   415,   415,  1314,   416,
    1507,    21,  2717,   221,   421,  1321,   205,  1323,   417,   416,
     415,  1518,   392,  2099,   421,   345,   391,   347,  1455,   394,
    1527,   418,  1504,   415,   421,  1507,   406,   407,   408,   409,
     410,   411,   345,  1514,   347,  1395,  1518,  1543,   523,  1545,
     415,   356,   241,  1549,   243,  1527,   416,   391,    93,  1555,
     394,   421,   271,   416,   253,   273,  1562,   391,   421,   392,
     394,   271,  2118,  2972,  2460,   110,  1572,  1386,  1574,   402,
     403,   404,   304,   406,   407,   408,   409,   410,   411,  1395,
     416,   415,   567,   568,  1590,   421,  1592,  1499,   390,   391,
    2894,   393,   394,  1869,  1870,  1871,  1872,   399,  1596,   401,
    2434,   391,  1596,  1596,   394,   407,   292,   306,   406,   407,
     408,   409,   410,   420,   421,  2154,  1623,  1554,   416,  1600,
     131,  1991,  1992,  1993,   171,   415,  1996,   420,   421,   416,
    1596,  1543,   177,  1545,   421,   334,   183,  1549,  2224,   394,
     206,  1623,  1596,  1555,   399,  2223,   401,   780,   416,   782,
    1562,   784,   407,   421,   415,   391,   201,   790,   394,  2198,
    1572,   391,  1574,   399,   394,   401,   383,   384,   416,  2039,
     217,   407,  1679,   421,   392,   227,  3005,  3006,  1590,  3008,
    1592,  3010,   227,   219,   402,   403,   404,   234,   406,   407,
     408,   409,   410,   411,   416,  1738,  1596,  1679,   416,   421,
     416,   416,   418,   688,   689,   690,   421,   692,   416,   694,
     695,   696,  1673,   421,   699,   700,   701,   702,  2307,  1656,
     416,   268,   418,   416,   291,   137,   416,  1639,   421,   276,
    1673,   421,   391,   416,   719,   394,  1596,   722,   421,   724,
     399,   726,   401,   271,  2601,   730,   731,    85,   407,   734,
    1706,   736,  1708,   738,     7,   882,   421,   884,    11,   416,
     745,   746,   416,   308,   421,    77,  2708,   421,  2710,   754,
      23,    24,   757,  1673,   319,   760,   416,   189,    90,   764,
    1596,   421,   416,   768,   769,    97,   771,   421,   333,   774,
     102,    44,  1729,   416,    47,   340,   134,   209,   421,   413,
    2340,   415,   188,   417,  3172,   416,  1706,   792,  1708,   794,
     421,  1723,   224,  1673,    98,   800,   416,   364,   156,   231,
     416,   421,  1828,   416,   388,   421,   223,  1739,   421,  1741,
     391,  1743,   274,   394,   416,   380,   174,   249,   383,   421,
     416,  2103,  2104,   828,   416,   421,  1706,   832,  1708,   421,
     351,   406,   407,   408,   409,   410,   271,  1673,  1864,   414,
    2885,    77,   847,   848,   849,   850,   388,   852,   416,   416,
      98,  1877,   416,   421,   416,   213,   388,   421,   223,   421,
     418,  1924,  1794,   421,   325,  1797,  1798,   199,  1895,   408,
    1706,   203,  1708,  1900,   187,  2028,  1250,  1251,   310,  1253,
     416,  3137,  1250,  1251,  1723,  1253,   416,   129,   161,   221,
     222,   418,   418,  1895,  1851,   421,  1828,    85,  1900,   108,
    1739,   233,  1741,   418,  1743,   408,   421,    93,   383,   384,
     383,   384,   383,   384,   925,   926,   215,   419,   923,   924,
     419,   351,   927,   351,   110,   257,   351,  1859,   260,   351,
     351,   169,  1864,    93,   108,  1961,   372,   423,   215,   221,
     298,   273,  1899,   948,   351,  1877,   951,   415,   415,   954,
     192,   415,   415,   281,   302,  1794,   314,   389,  1797,  1798,
     415,   415,   320,   415,   206,  2064,  2065,   203,   417,   271,
    2360,   281,   977,  2363,  2364,  2365,  2366,  2367,  2368,  2369,
    2370,  2371,  2372,   232,   418,   221,   415,   345,   227,   347,
     265,   177,   383,   118,   383,   237,   415,   329,   356,    77,
      93,   383,    98,   281,  2964,   383,   227,  2884,   382,  2399,
     415,   369,   370,  1018,   415,   201,   271,  1022,   271,    97,
     184,  1026,   421,   415,   102,   232,  1031,  2028,   183,  1961,
     271,   415,   104,   275,  1039,   415,  2063,   273,   415,   415,
    2041,   227,   415,   415,   415,   415,  1051,  1052,   415,  1054,
      93,   286,   415,   415,   415,   415,   415,  2083,   415,  2060,
     392,  2063,  1067,   415,   415,   421,   138,  2069,  2069,   232,
     402,   403,   404,  1030,   406,   407,   408,   409,   410,   411,
     221,   415,   183,   408,  1089,   157,   215,   318,   245,   150,
     421,   371,   170,    42,   417,    18,   415,  1102,   170,   118,
     421,   415,   371,   345,   415,   347,  1063,  1112,   351,   371,
     129,   351,   184,   421,   356,   344,   372,   351,   351,  2717,
     125,   199,   308,   365,  2730,   203,   351,   351,   351,   271,
     384,   351,   151,   319,   153,   351,   351,   379,   351,   415,
     352,   351,   421,   221,   222,   351,   351,   333,  2080,   351,
     415,  2083,   271,  2085,   340,   233,   392,    77,   221,   269,
     377,    93,    83,  3154,   146,   415,   402,   403,   404,   415,
     406,   407,   408,   409,   410,   411,  2735,   151,   415,   238,
     183,  2571,   260,  2742,   271,  2744,    93,   415,   415,   208,
     262,   317,    93,   372,   380,   273,   415,   269,    18,   402,
     351,   415,   375,  2229,   261,  2223,   381,  1212,  1213,  2223,
    2223,   349,   349,  2978,  2945,   416,   198,   421,  2292,   415,
    1225,   421,   294,  2988,   421,  1230,  1231,  1232,    77,  2292,
     421,   325,   349,   415,  2261,   415,  1241,  2223,   257,   351,
    2267,  2173,   188,   262,   421,   354,  2085,  2179,  2180,  2223,
     402,   329,   421,   217,   416,   421,   272,   266,   234,  2261,
     242,    39,    77,   245,  2417,  2267,   413,   416,   416,   409,
     289,   415,   225,  2426,   225,    90,   415,   262,  1283,   298,
    1285,   262,    97,   137,   351,  2242,   351,   102,  2289,  3054,
    2289,  2292,  2224,  2292,  2684,   416,   108,  2229,   421,  2231,
      77,   221,   343,  2223,   302,  2307,   421,   194,   391,  2241,
     368,  1316,   295,    90,   392,   221,  2317,  2926,  2317,  2345,
    2419,  2420,  2421,  2422,    77,  2351,    93,  1332,   406,   407,
     408,   409,   410,   411,  2173,   189,   318,    90,   221,   372,
    2179,  2180,   221,  2223,   413,   351,   365,  1352,   402,   351,
     402,   183,   344,   273,   271,   209,   275,   195,   308,    93,
     197,   197,   183,   416,    12,  1370,   416,   244,   416,  1326,
     224,   188,   421,   388,   416,   188,   416,   231,   416,   416,
     416,   416,  1387,   188,   199,  2224,  1391,  2223,   203,   421,
    2950,   416,   388,   416,   416,   249,   416,  2424,  2425,   416,
     388,    35,   416,   415,   351,   387,   221,   222,   390,   391,
     418,   393,   394,  2345,   415,   402,  2417,   271,   233,  2351,
     281,   416,  2424,  2425,  2426,  2426,   416,  1384,   421,   418,
     416,   415,   273,   351,   221,   415,  1441,  1442,   416,  1444,
    2397,   416,   257,   351,   221,   260,   416,   221,   413,   416,
    1455,   245,   271,   416,   415,   421,   310,   361,   273,  2849,
     275,  2851,   416,   269,   271,   269,   351,   372,   221,   421,
     172,  1476,   392,   416,   402,  1480,   172,  3037,   413,  1436,
    1485,   169,   402,   403,   404,   416,   406,   407,   408,   409,
     410,   411,    77,   188,   183,   116,   273,   421,  1503,   415,
    1505,  1506,   416,  1508,   416,   416,   421,   416,   194,  1514,
     402,   402,  1469,   416,   329,   415,   392,  2543,   372,   416,
     273,   351,   351,  1528,   410,   351,   351,  3136,  2555,   351,
     221,  3137,   158,   414,   221,   389,   221,   415,   372,  1030,
     379,   225,   183,   275,   207,    93,    93,  2479,   226,   415,
    2577,   392,   415,  2555,   193,   188,   416,   416,   416,  1564,
    3169,   402,   403,   404,   416,   406,   407,   408,   409,   410,
     411,   415,  1063,   266,   416,  2577,   416,   392,   224,   278,
     415,   224,  2972,   108,   415,   196,   361,   402,   403,   404,
     262,   406,   407,   408,   409,   410,   411,   415,  2599,   414,
    2599,   262,   372,   221,  2536,   208,   414,   153,   423,   190,
     190,  2543,   188,   206,   372,   392,  2548,  2549,  2550,  2551,
    2552,   165,   174,   416,  1629,   402,   403,   404,   152,   406,
     407,   408,   409,   410,   411,   152,   415,  1594,   188,   392,
    2479,  1646,   271,   319,   351,  2602,   262,   183,   416,   402,
     403,   404,   274,   406,   407,   408,   409,   410,   411,   415,
     415,   224,   298,   415,  2691,  2692,  2693,  2694,    93,   240,
    1675,   262,   269,   344,   293,  1680,   271,   269,   421,   262,
     415,   271,    96,   416,   183,   271,    93,   127,   211,  2691,
    2692,  2693,  2694,   262,   262,   165,   271,  2536,   271,  2717,
     415,  2703,  2703,  2717,  2717,  2707,  2707,   211,   161,  2711,
    2711,   421,   312,   369,   156,   421,   174,   313,    81,   313,
     297,   293,  2748,   415,  1729,   225,   416,  1732,  1437,  2251,
    2085,  2717,  1232,  1738,  1814,  1785,  2183,  1228,  2591,  2252,
    1805,  2511,  2781,  2717,  2134,  2594,  2608,  1752,  1753,  1754,
    1755,  3098,  3127,  1758,    82,  3077,  3076,  3107,  2942,  1764,
    3027,    89,  1453,  3158,  1769,  2792,  3184,  2724,  2766,  2596,
    1867,  2765,   134,  2223,  1779,  1780,  1781,  1782,  1783,  1784,
    3139,  1786,  1787,  1439,  3185,   177,  1098,  1792,  1793,   840,
    2792,  2723,  3036,  1527,  2327,  2252,  2144,  2717,  2622,   127,
    1805,  1806,  1807,  2760,  1809,  1810,  1811,  1812,  1030,   171,
    1815,  1816,  2814,  1818,  1819,  2284,  2748,   145,   146,  1776,
    2825,   183,  3012,  3148,  1105,   153,   188,  3183,  1873,   157,
    1679,   193,   194,   863,   196,  1326,   155,  2717,  2318,  1844,
    1845,  1063,  2616,  1922,  2096,  1258,  2105,   175,  1257,   177,
    1676,  1081,  2809,  2426,  1859,   217,  2986,  2589,  2815,  1411,
    1351,  2041,  2819,  1192,   192,  2709,  2396,  2224,    84,  2871,
    2871,  1624,   234,  1878,  2876,  2876,  2680,  1963,  2880,  2880,
    1837,  2717,  2727,  3060,  2723,  2090,  1891,  2840,  2625,  1732,
    1298,  1896,  1729,  1384,  1052,    74,   930,   113,  1903,  1265,
    1857,  2928,   311,   663,  1704,  1103,   268,  1739,  1913,   125,
    1930,   958,  2079,   926,   276,   131,  1931,  2617,  2945,  1924,
    1411,  2722,  2618,  1211,  2926,  1776,  2928,  2464,  1263,   145,
     345,  1743,  1925,   932,     2,  1940,    -1,  1498,    -1,    -1,
    2967,    -1,    -1,  2945,    -1,  1436,   162,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1911,    -1,    -1,  2889,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2967,    -1,  2968,    -1,  2968,
      -1,    84,  2999,    -1,   190,    -1,    -1,    -1,  1469,    -1,
      -1,   343,  1473,  2985,  2985,    -1,    -1,    -1,    -1,    -1,
     206,    -1,    -1,    -1,    -1,    -1,    -1,  2999,    -1,    -1,
      -1,    -1,   364,    -1,    -1,    -1,    -1,  3160,    -1,    -1,
      -1,    -1,   228,  2018,    -1,    -1,    -1,    -1,   131,    -1,
     382,    -1,    -1,    -1,   352,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   145,    -1,  3036,    -1,    -1,    -1,    -1,  2044,
      -1,    -1,    -1,    -1,    -1,    -1,    77,    -1,    -1,   162,
    2889,    -1,    -1,    -1,   416,   417,   418,   273,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    97,    -1,    -1,    -1,
      -1,   102,    -1,    -1,    -1,    -1,   292,   190,    -1,    -1,
    2085,   194,    -1,    -1,  3041,  2090,  3112,  3113,    -1,    -1,
      -1,    -1,    -1,   206,    -1,    -1,  2101,    -1,   314,    -1,
     316,    -1,    -1,  1594,  1326,   321,  3063,    -1,    -1,    -1,
    3067,    -1,    -1,  2118,   227,    -1,    -1,    -1,    -1,    -1,
    1030,    -1,    -1,    -1,    -1,    -1,    -1,   343,    -1,  1351,
      -1,    -1,  2137,    -1,  3136,    -1,    -1,    -1,    -1,   170,
     356,    -1,    -1,    -1,    -1,   361,    -1,  3148,    -1,  2154,
    2155,    77,    -1,  1063,    -1,    -1,    -1,    -1,    -1,  3160,
     273,    -1,  1384,   379,    90,    -1,    -1,  3169,   199,    -1,
      -1,    97,   203,    -1,    -1,    -1,   102,    -1,   134,    -1,
    3112,  3113,  3183,    -1,    -1,    -1,    -1,    -1,  2145,  1411,
     221,   222,    -1,  2198,    -1,   523,    -1,    -1,    -1,    -1,
     156,    -1,   233,   316,  2209,    -1,    -1,    -1,   321,  2166,
      -1,  2168,    -1,    -1,  1436,    -1,    -1,    -1,   174,    -1,
      -1,    -1,    -1,    -1,    -1,  2182,  2231,    -1,    -1,   260,
     343,   344,    -1,    -1,    -1,    -1,    -1,    -1,  2243,  2244,
    2245,    -1,   273,   356,    -1,    -1,    -1,  1469,   361,  2206,
      -1,  1473,    -1,   581,    -1,    -1,   134,   213,   371,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2224,    -1,    -1,
      -1,    -1,    -1,   199,    -1,    -1,  2281,   203,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1776,    -1,  2292,    -1,    -1,
      -1,    -1,    -1,   171,    -1,   221,   222,    -1,   329,    -1,
      -1,    -1,    -1,    -1,  2309,   183,    -1,   233,  2265,    -1,
     188,    -1,    -1,  2318,    -1,   193,   194,    -1,   196,  2276,
      -1,    -1,  2327,    -1,    -1,    -1,    -1,  2284,    -1,    -1,
      -1,   257,    -1,    -1,   260,  2340,    -1,    -1,    -1,   217,
      -1,    -1,   298,    -1,    -1,    -1,  1837,   273,    -1,   275,
      -1,  1842,    -1,    -1,    -1,    -1,   234,    -1,   314,    -1,
      -1,   392,    -1,    -1,   320,    -1,  1857,    -1,    -1,    -1,
      -1,    -1,  1594,    -1,    -1,   406,   407,   408,   409,   410,
     411,  2338,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   345,
     268,   347,    -1,    -1,    -1,    -1,    -1,    -1,   276,    -1,
     356,    -1,  2359,   329,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   369,   370,    -1,  1326,   745,   746,    -1,
    1911,    -1,  2427,    -1,    -1,    -1,  2431,  2432,    -1,  2386,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1351,    -1,    -1,    -1,    -1,    -1,    -1,   776,    -1,
      -1,  2408,   780,    -1,   782,    -1,   784,    -1,    -1,    -1,
      -1,    -1,   790,   791,    -1,   343,   392,    -1,    -1,    -1,
      -1,    -1,   800,    -1,  1384,    -1,   402,   403,   404,    -1,
     406,   407,   408,   409,   410,   411,   364,    -1,  2493,  2494,
      -1,    -1,    -1,    -1,    -1,   421,    -1,    -1,    -1,    -1,
      -1,  1411,    77,    -1,   382,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2518,  2519,    90,    -1,    -1,    -1,   847,
     848,    -1,    97,   851,    -1,    -1,  1436,   102,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   416,   417,
     418,    -1,    -1,  2548,  2549,  2550,  2551,  2552,    -1,    -1,
      -1,    -1,    -1,    -1,  1776,    -1,    -1,  2514,    -1,  1469,
      -1,    -1,    -1,  1473,    -1,  2570,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1030,    -1,    -1,    -1,   907,
      -1,    -1,    -1,    -1,  2589,    -1,  2591,    -1,    -1,  2594,
      -1,  2596,    -1,    -1,    -1,   923,   924,    -1,  2603,    -1,
      -1,    -1,    -1,  2608,    -1,    -1,    77,    -1,  1063,    -1,
      -1,    -1,    -1,    -1,    -1,  1837,    -1,  2622,    -1,    -1,
    1842,    -1,    -1,    -1,   199,  2582,    97,    -1,   203,    -1,
      -1,   102,    -1,    -1,    -1,  1857,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   221,   222,    -1,    -1,
      -1,    -1,    -1,    -1,  2145,    -1,    77,    -1,   233,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2166,    97,  2168,    -1,    -1,
      -1,   102,   257,    -1,  1594,   260,    -1,    -1,    -1,  1911,
      -1,  2182,  2697,    -1,    -1,  2700,    -1,    -1,   273,   170,
     275,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2714,
      -1,    -1,    -1,    -1,    -1,  2206,    -1,    -1,    -1,    -1,
      -1,    -1,  2727,  2680,    -1,  2730,    -1,  2732,   199,    -1,
    2735,  2736,   203,  2224,    -1,    -1,    -1,  2742,  2743,  2744,
      -1,    -1,    -1,    -1,  2749,    -1,  1074,    -1,    -1,   170,
     221,   222,    -1,    -1,   329,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   233,    -1,  1092,    -1,    -1,  1095,    -1,    -1,
      -1,    -1,    -1,    -1,  2265,  1103,    -1,    -1,   199,    -1,
      -1,    -1,   203,    -1,    -1,  2276,    -1,    -1,    -1,   260,
      -1,    -1,    -1,  2284,    -1,    -1,    -1,    -1,    -1,    -1,
     221,   222,   273,    -1,  1030,    -1,    -1,    -1,    -1,  2814,
      -1,    -1,   233,    -1,  2819,    -1,    -1,   392,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   402,   403,   404,
      -1,   406,   407,   408,   409,   410,   411,  1063,    -1,   260,
      -1,    -1,    -1,  1171,    -1,    -1,   421,  2338,    -1,    -1,
      -1,    -1,   273,    -1,  1182,    -1,    -1,    -1,   329,    -1,
      -1,    -1,  2867,    -1,  2869,    -1,  1776,    -1,  2359,    -1,
      -1,  1326,    -1,    -1,    -1,    -1,  2881,    -1,  2883,    -1,
    1208,    -1,    -1,    -1,  1212,  1213,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2386,  1351,  1225,    -1,  2856,
    1228,    -1,  1230,    -1,  1232,    -1,    -1,    -1,   329,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2408,    -1,    -1,
      -1,   392,    -1,  2145,    -1,    -1,    -1,  1837,    -1,  1384,
      -1,  2936,  1842,    -1,    -1,   406,   407,   408,   409,   410,
     411,    -1,    -1,    -1,  2166,  2950,  2168,  1857,    -1,  2954,
    2955,    -1,    -1,    -1,    -1,  1283,  1411,  1285,    -1,    -1,
    2182,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1296,    -1,
      -1,   392,    -1,  2978,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1436,    -1,  2988,  2206,   406,   407,   408,   409,   410,
     411,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1911,  2224,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1469,  3020,    -1,  3022,  1473,    -1,
      -1,  3026,    -1,  2514,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3036,  3037,  2990,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2265,    -1,    -1,    -1,    -1,    -1,  3054,
      -1,    -1,    74,    -1,  2276,    77,    -1,    -1,  1386,    -1,
      -1,  3066,  2284,    -1,    -1,    -1,    -1,    89,    90,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3085,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     112,  2582,    -1,    -1,    -1,    -1,  3101,    -1,    -1,    -1,
    1326,    -1,    -1,    -1,    -1,   127,    -1,    -1,    -1,    -1,
      77,    -1,  3117,    -1,    -1,    -1,  2338,    -1,    -1,    -1,
      -1,    -1,    -1,   145,    -1,  1351,    -1,  1455,    -1,    -1,
      97,    -1,  3137,    -1,    -1,   102,    -1,  2359,    -1,  1594,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3158,    -1,    -1,    -1,  3114,  1384,    -1,
      -1,    -1,    -1,    77,  2386,    -1,    -1,    -1,    -1,    -1,
    1498,  1499,    -1,    -1,    -1,    -1,    90,    -1,    -1,  3184,
      -1,    -1,    -1,    97,    -1,  1411,  2408,    -1,   102,  2680,
      -1,    -1,    -1,    -1,   216,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1436,    -1,    -1,    -1,    -1,  1543,    -1,  1545,    -1,    -1,
      -1,  1549,    -1,    -1,    -1,    -1,  1554,  1555,    77,    -1,
      -1,    -1,   199,    -1,  1562,  2145,   203,    -1,    -1,    -1,
      -1,    90,    -1,  1469,  1572,    -1,  1574,  1473,    97,    -1,
      -1,    -1,    -1,   102,   221,   222,  2166,    -1,  2168,    -1,
      -1,    -1,  1590,    -1,  1592,    -1,   233,    -1,    -1,    -1,
      -1,    -1,  2182,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   199,    -1,    -1,   310,   203,
     257,    -1,  2514,   260,    -1,  1623,  2206,    -1,    -1,    -1,
      -1,  1629,    -1,    -1,    -1,    -1,   273,   221,   222,    -1,
      -1,  1639,    -1,    -1,  2224,    -1,    -1,    -1,    -1,   233,
      -1,  1776,    -1,    -1,   346,    -1,    -1,   349,  1656,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   257,    -1,    -1,   260,    -1,    -1,    -1,
     199,    -1,    -1,    -1,   203,  2265,    -1,    -1,    -1,   273,
    2582,   275,   329,    -1,    -1,  2856,  2276,    -1,  1594,    -1,
      -1,    -1,   221,   222,  2284,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1837,    -1,   233,    -1,    -1,  1842,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1723,    -1,    -1,    -1,    -1,
      -1,  1729,  1857,    -1,    -1,    -1,    -1,    -1,   257,    -1,
    1738,   260,    -1,    -1,    -1,   329,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   273,   392,   275,    -1,  2338,    -1,
      -1,    -1,    -1,    -1,    -1,   402,   403,   404,    -1,   406,
     407,   408,   409,   410,   411,    -1,    -1,    77,    -1,  2359,
      -1,    -1,    -1,    -1,    -1,    -1,  1911,    -1,  2680,    -1,
      90,    -1,    -1,    -1,    -1,    -1,  1794,    97,    -1,  1797,
    1798,    -1,   102,    -1,    -1,    -1,  2386,    -1,   392,    -1,
     329,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   402,   403,
     404,    -1,   406,   407,   408,   409,   410,   411,  2408,  2990,
    1828,   523,   416,    -1,    -1,    -1,    -1,    -1,    -1,  1030,
      -1,    -1,    -1,    -1,    -1,  1843,    -1,    -1,    -1,  1847,
      -1,    -1,    -1,  1851,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1859,    -1,    -1,    -1,    -1,  1864,    -1,    -1,    -1,
      -1,    -1,  1063,   392,    -1,    -1,    -1,    -1,    -1,  1877,
    1776,    -1,    -1,   402,   403,   404,    -1,   406,   407,   408,
     409,   410,   411,    -1,    -1,    -1,    -1,   416,    -1,   199,
      -1,  1899,    -1,   203,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   221,   222,    -1,    -1,    -1,  1924,  1925,    -1,    -1,
    1928,    -1,  1930,   233,  2514,    -1,    -1,    -1,    -1,    -1,
      -1,  1837,    -1,    -1,    -1,    -1,  1842,    -1,    -1,    -1,
      -1,    -1,    -1,  3114,    -1,    -1,    -1,   257,    -1,    -1,
     260,  1857,    -1,  1961,  2856,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   273,    -1,   275,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   679,    -1,    -1,
      -1,   683,    -1,    -1,    -1,   687,    -1,    -1,    -1,   691,
      -1,    -1,  2582,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3172,    -1,    -1,    -1,  1911,    -1,    -1,    -1,    -1,
    2145,    -1,    -1,    -1,    -1,    -1,   718,    -1,    -1,   329,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2166,    -1,  2168,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2182,   750,    -1,
      -1,   753,    -1,    -1,    -1,    -1,    -1,   759,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2206,  2080,    -1,    -1,  2083,    -1,  2085,    -1,    -1,
      -1,    -1,   392,    -1,    -1,    -1,    -1,    -1,  2990,  2224,
    2680,    -1,   402,   403,   404,    -1,   406,   407,   408,   409,
     410,   411,    -1,    -1,    -1,    -1,   416,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1326,    84,    -1,    -1,    -1,
    2265,    -1,    -1,    -1,    -1,    -1,    -1,    95,    -1,    -1,
      -1,  2276,    -1,   845,    -1,   847,    -1,    -1,    -1,  2284,
    1351,    -1,    -1,    -1,    -1,   113,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   865,    -1,  2173,    77,    -1,    -1,    -1,
      -1,  2179,  2180,   131,    -1,    -1,    -1,    -1,    -1,    90,
      -1,    -1,    -1,  1384,    -1,    -1,    97,   145,    -1,    -1,
      -1,   102,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2207,
    2208,    -1,    -1,  2338,   162,    -1,    -1,    -1,  2216,    -1,
    1411,    -1,  3114,    -1,    -1,    -1,  2224,    -1,    -1,    -1,
      -1,  2229,    -1,  2231,  2359,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   190,  2241,  2242,  1436,   194,    -1,    -1,  2145,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   206,    -1,
      -1,  2386,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2166,    -1,  2168,    -1,    -1,    -1,  2856,    -1,  1469,    -1,
    3172,    -1,  1473,  2408,    -1,    -1,  2182,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2292,    -1,    -1,    -1,   199,    -1,
      -1,    -1,   203,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2206,    -1,    -1,  1005,    -1,    -1,  1008,    -1,    -1,    -1,
     221,   222,  1014,    -1,    -1,   273,    -1,    -1,  2224,    -1,
      -1,    -1,   233,    -1,    -1,    -1,    -1,    -1,  1030,    -1,
      -1,    -1,    77,    -1,   292,    -1,    -1,  2345,    -1,    -1,
      -1,    -1,    -1,  2351,    -1,    90,   257,    -1,    -1,   260,
      -1,  1053,    97,    -1,    -1,    -1,   314,   102,   316,  2265,
      -1,  1063,   273,   321,   275,    -1,    -1,    -1,    -1,    -1,
    2276,    -1,    -1,    -1,    -1,  1030,    -1,    -1,  2284,  2514,
      -1,    -1,    -1,    -1,    -1,   343,   344,    -1,    -1,  2397,
      -1,    -1,    -1,  1594,    -1,    -1,    -1,    -1,   356,    -1,
    2990,    -1,    -1,   361,    -1,    -1,    -1,    -1,  1063,    -1,
      -1,    -1,    -1,   371,    -1,    -1,  1118,    -1,   329,    -1,
      -1,   379,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2338,    -1,    -1,    -1,    -1,    -1,  1140,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2582,    -1,    -1,
      -1,    -1,    -1,  2359,   199,    -1,    -1,    -1,   203,    -1,
      -1,    -1,  1164,  1165,    -1,  1167,  1168,  1169,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   221,   222,    -1,    -1,
    2386,   392,    -1,    -1,    -1,  1187,    -1,    -1,   233,    -1,
      -1,   402,   403,   404,    -1,   406,   407,   408,   409,   410,
     411,    -1,  2408,    -1,    -1,   416,    -1,    -1,    -1,    -1,
    1212,  1213,   257,    -1,    -1,   260,    -1,    -1,    -1,    -1,
    2528,  2529,    -1,    -1,  3114,    -1,  1228,    -1,   273,    -1,
     275,    -1,    -1,    -1,    -1,  2543,    -1,    -1,    -1,    -1,
    2548,  2549,  2550,  2551,  2552,  2680,    -1,    -1,    -1,    -1,
    1252,    -1,    -1,  1255,  1256,    -1,    -1,    -1,    -1,    -1,
      -1,  1263,  1264,  1265,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1776,    -1,    -1,    -1,    -1,
      -1,  1283,  3172,    -1,   329,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2602,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2514,  2617,
      -1,    -1,  1314,    -1,    -1,    -1,    -1,    -1,    -1,  1321,
    1322,  1323,    -1,    -1,  1326,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1837,    -1,    -1,    -1,
      -1,  1842,    -1,    -1,    -1,    -1,    -1,   392,    -1,  1351,
      -1,    -1,    -1,    -1,    -1,    -1,  1857,   402,   403,   404,
      -1,   406,   407,   408,   409,   410,   411,    -1,    -1,   414,
      -1,  1326,    -1,    -1,    -1,    -1,  2582,    -1,    -1,    -1,
      -1,    -1,  1384,    -1,    -1,    -1,    77,    -1,    -1,    -1,
      -1,    -1,    -1,  1395,    -1,    -1,  1351,    -1,    -1,    90,
      -1,    -1,    -1,    -1,    -1,    -1,    97,    -1,    -1,  1411,
    1911,   102,    -1,    -1,    -1,  2723,  2724,    -1,    -1,    -1,
      -1,  2856,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1384,
      -1,    -1,    -1,    -1,  1436,    -1,    -1,    -1,    -1,    -1,
    2748,    -1,    -1,    -1,    -1,  2753,    -1,  2755,  2756,    -1,
      -1,    -1,  2760,    -1,    -1,    -1,  1411,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1467,    -1,  1469,    -1,    -1,
      -1,  1473,    -1,    -1,  2680,    -1,    -1,    -1,    -1,    -1,
      -1,  1436,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    77,    -1,    -1,
      -1,  2809,  1504,    -1,    -1,    -1,    -1,  2815,   199,    -1,
      90,  2819,   203,    -1,  1469,    -1,    -1,    97,  1473,    -1,
      -1,    -1,   102,    -1,    -1,    -1,    -1,    -1,  1530,  1531,
     221,   222,    -1,    -1,    -1,    -1,  1538,    -1,    -1,  1541,
    1542,    -1,   233,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1554,    -1,    -1,  2990,    -1,    -1,    -1,  1561,
      -1,    90,    -1,  1565,  1566,  1567,   257,  1569,    -1,   260,
      -1,    -1,    -1,    -1,  1576,  1577,    -1,    -1,    -1,    -1,
      -1,    -1,   273,   112,   275,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1594,  1595,  1596,    -1,  1598,  1599,    -1,    -1,
      -1,  1603,    -1,    -1,    -1,  1607,    -1,  2915,  1610,  1611,
    1612,  1613,  1614,  1615,  1616,  1617,  1618,    -1,  1620,   199,
      -1,    -1,  1624,   203,    -1,    -1,  1628,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   329,  1594,
      -1,   221,   222,    -1,  2145,    -1,    -1,    -1,    -1,    -1,
    2856,    -1,    -1,   233,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2166,    -1,  2168,    -1,    -1,
      -1,  1673,    -1,    -1,    -1,    -1,    -1,   257,    -1,  3114,
     260,  2182,    -1,    -1,    -1,    -1,    -1,   216,    -1,    -1,
      -1,    -1,    -1,   273,    -1,   275,    -1,    -1,    -1,    -1,
      -1,   392,    -1,    -1,  1706,  2206,  1708,    -1,    -1,    -1,
      -1,   402,   403,   404,    -1,   406,   407,   408,   409,   410,
     411,    77,    -1,  2224,    -1,   416,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3041,    90,    -1,    -1,  3172,    -1,    -1,
      -1,    97,    -1,    -1,    -1,    -1,   102,    -1,    -1,   329,
      -1,    -1,    -1,    -1,    -1,  3063,    -1,    -1,    -1,  3067,
      -1,    -1,    -1,    -1,  2265,  1767,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1776,  2276,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2284,  2990,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3112,  3113,    -1,    -1,    -1,  3117,
      -1,    -1,   392,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1776,   402,   403,   404,    -1,   406,   407,   408,   409,
     410,   411,    -1,    -1,    -1,  1837,   416,  2338,    -1,    77,
    1842,    -1,    -1,   199,    -1,    -1,    -1,   203,    -1,    -1,
    3158,    -1,    -1,  1855,    -1,  1857,    -1,    -1,  2359,    97,
      -1,    -1,    -1,    -1,   102,   221,   222,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3184,   233,    -1,    -1,
      -1,    -1,  1837,    -1,    -1,  2386,    -1,  1842,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     2,
      -1,   257,  1857,    -1,   260,    -1,    -1,  2408,  3114,  1911,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,    -1,   275,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   170,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1942,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1911,    -1,    -1,    -1,
    1962,   199,    -1,    -1,    -1,   203,  3172,    -1,    -1,    -1,
      -1,    -1,    -1,   329,    -1,    -1,    -1,    -1,    -1,    82,
      -1,    -1,    -1,   221,   222,    -1,    89,    -1,    -1,  1991,
    1992,  1993,    -1,    -1,  1996,   233,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2008,  2009,  2010,  2011,
      -1,    -1,    -1,  2514,    -1,  2017,    -1,    -1,    -1,    -1,
      -1,    -1,   260,    -1,   127,    -1,  2028,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   273,   392,  2039,  2040,    -1,
    2042,    -1,   145,    -1,  2046,    -1,   402,   403,   404,    -1,
     406,   407,   408,   409,   410,   411,    -1,    -1,    -1,    -1,
     416,    -1,    -1,    -1,    -1,    -1,    -1,  2069,    -1,  2071,
    2072,    -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2582,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   329,    -1,    -1,  2096,    -1,    -1,    -1,    -1,    -1,
      -1,  2103,  2104,  2105,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2127,    -1,    -1,    -1,    -1,
      -1,  2133,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2145,    -1,    -1,    -1,    -1,    -1,  1030,
     679,    -1,    -1,    -1,   392,    -1,    -1,    -1,   687,    -1,
      -1,    -1,   691,    -1,  2166,    -1,  2168,    -1,   406,   407,
     408,   409,   410,   411,    -1,    -1,    -1,    -1,    -1,  2680,
    2182,    -1,  1063,    -1,    -1,    -1,    -1,    -1,    -1,   718,
    2145,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2206,    -1,    -1,    -1,    -1,    -1,
      -1,  2166,    -1,  2168,    -1,    -1,    -1,    -1,    82,    -1,
      -1,  2223,  2224,    -1,   753,    -1,    -1,  2182,    -1,    -1,
     759,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2206,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2265,    -1,    -1,    -1,    -1,    -1,  2224,
      -1,    -1,    -1,    -1,  2276,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2284,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   157,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2307,    -1,    -1,    -1,    -1,
    2265,   175,    -1,   177,    -1,    -1,   845,    -1,    -1,    -1,
      -1,  2276,    -1,    -1,    -1,    -1,    -1,  2329,    -1,  2284,
      -1,    -1,    -1,  2335,    -1,    -1,  2338,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2347,    -1,  2349,    -1,    -1,
      -1,  2353,    -1,    -1,    -1,  2856,    -1,  2359,  2360,    -1,
      -1,  2363,  2364,  2365,  2366,  2367,  2368,  2369,  2370,  2371,
    2372,    -1,    -1,    -1,    -1,  2377,  2378,    -1,    -1,    -1,
      -1,    -1,    -1,  2338,  2386,    -1,    -1,    -1,    -1,  2391,
      -1,    -1,    -1,    -1,    -1,    -1,  2398,  2399,  2400,    -1,
    2402,    -1,    -1,    -1,  2359,    -1,  2408,  2409,    -1,    -1,
      -1,    -1,  2414,    -1,    -1,  2417,    -1,    -1,    -1,    -1,
     523,    -1,    -1,    -1,  2426,    -1,    -1,    -1,    -1,    -1,
      -1,  2386,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    77,    -1,    -1,    -1,  1326,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2408,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    97,    -1,    -1,    -1,    -1,   102,  2469,    -1,  1030,
    1351,    -1,    77,    -1,    -1,    -1,  1005,    -1,    -1,  1008,
      -1,    -1,    -1,    -1,    -1,  1014,    -1,    -1,    -1,  2990,
      -1,    -1,    97,    -1,    -1,    -1,    -1,   102,    -1,    -1,
      -1,  1030,  1063,  1384,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2514,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1053,    -1,    -1,    -1,    -1,    -1,
    1411,    -1,    -1,    -1,  1063,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1436,   659,    -1,    -1,  2514,
      -1,    -1,    -1,   199,    -1,    -1,    -1,   203,    -1,  2571,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2582,    -1,    -1,    -1,    -1,   221,   222,    -1,  1469,  1118,
      -1,    -1,  1473,    -1,   199,    -1,    -1,   233,   203,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1140,    -1,  3114,    -1,    -1,   221,   222,    -1,    -1,
      -1,    -1,    -1,  2625,   260,    -1,    -1,  2582,   233,    -1,
      -1,    -1,    -1,  2635,    -1,  1164,  1165,   273,  1167,  1168,
    1169,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   260,    -1,    -1,  1187,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,    -1,
      -1,  3172,    -1,    -1,    -1,    -1,    -1,    -1,  2680,    -1,
      -1,    -1,  2684,  2685,  2686,    -1,    -1,  2689,    -1,    -1,
      -1,    -1,    -1,   329,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2703,    -1,    -1,    -1,  2707,    -1,    -1,    -1,  2711,
      -1,    -1,    -1,  1594,    -1,  2717,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1252,   329,  2680,  1255,  1256,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   847,    -1,    -1,    -1,   851,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   392,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1326,   402,   403,   404,    -1,
     406,   407,   408,   409,   410,   411,    -1,    -1,  2780,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   392,    -1,    -1,
    1351,    -1,    -1,  1322,  1323,    -1,    -1,  1326,   403,   404,
      -1,   406,   407,   408,   409,   410,   411,    -1,    -1,    -1,
      -1,    -1,  2814,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     923,   924,  1351,  1384,    -1,    -1,    -1,    -1,    -1,   932,
     933,    -1,   935,    -1,    -1,    -1,    -1,   940,  2840,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2849,    -1,  2851,
    1411,    -1,    -1,    -1,  2856,  1384,    -1,    -1,  2860,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1395,    -1,    -1,  2871,
      -1,    -1,    -1,    -1,  2876,  1436,    -1,    -1,  2880,    -1,
      -1,    -1,  1411,  2885,  2886,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2895,    -1,  1776,    -1,    -1,    -1,    -1,
      -1,  2856,    -1,    -1,    -1,    -1,    -1,  1436,  1469,    -1,
    2912,    -1,  1473,    -1,    -1,    -1,   780,    -1,   782,    -1,
     784,    -1,    -1,    -1,  2926,    -1,   790,   791,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1467,    -1,
    1469,    -1,    -1,    -1,  1473,    -1,    -1,    -1,    -1,  2951,
      -1,    -1,    -1,    84,    -1,    -1,  1837,    -1,    -1,    -1,
      -1,  1842,    -1,    -1,    95,    -1,    -1,    -1,    -1,    -1,
    2972,  1074,    -1,    -1,    -1,  1504,  1857,    -1,    -1,  2981,
      -1,    -1,   113,  2985,    -1,    -1,    -1,   851,  2990,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   129,    -1,
     131,  1530,  1531,    -1,    -1,    -1,    -1,    -1,    -1,  1538,
      -1,    -1,  1541,  1542,   145,    -1,    -1,    -1,    -1,    -1,
     151,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1911,   162,  1561,  1594,  3036,  2990,  1565,  1566,  1567,    -1,
    1569,    -1,    -1,   907,    -1,    -1,    -1,  1576,  1577,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3060,   923,
     924,   192,    -1,   194,    -1,  1594,  1595,  1596,  1171,  1598,
    1599,    -1,    -1,    -1,  1603,   206,   940,    -1,  1607,  1182,
      -1,  1610,  1611,  1612,  1613,  1614,  1615,  1616,  1617,  1618,
      -1,  1620,    -1,    -1,    -1,  1624,   227,    -1,    -1,  1628,
      -1,    -1,    -1,    -1,    -1,    -1,   237,    -1,    -1,  1212,
    1213,    -1,  3114,    -1,    -1,    77,    -1,    -1,    -1,    -1,
      -1,    -1,  1225,    -1,    -1,  1228,    -1,  1230,    -1,  1232,
      -1,    -1,    -1,    -1,  3136,    97,    -1,    -1,    -1,    -1,
     102,    -1,   273,    -1,   275,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3114,
      -1,   292,    -1,    -1,    -1,    -1,    -1,  3169,    -1,    -1,
    3172,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1283,    -1,  1285,    -1,    -1,   316,    -1,    -1,    -1,    -1,
     321,    -1,    -1,    -1,    -1,    -1,    -1,  1300,    -1,    -1,
      -1,  1304,    -1,    -1,    -1,    -1,    -1,    -1,   170,    -1,
    1074,    -1,   343,   344,   345,  1776,   347,  3172,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   356,    -1,    -1,    -1,   360,
     361,    77,    -1,    -1,   365,    -1,    -1,   199,  1767,    -1,
     371,   203,    -1,    -1,    90,    -1,    -1,  1776,    -1,    -1,
      -1,    97,    -1,    -1,    -1,    -1,   102,    -1,    -1,   221,
     222,    -1,    -1,    -1,  2145,    -1,    -1,    -1,    -1,    -1,
      -1,   233,    -1,    -1,    -1,    -1,  1837,    -1,    -1,    -1,
      -1,  1842,    -1,    -1,    -1,  2166,    -1,  2168,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1857,    -1,   260,    -1,
      -1,  2182,    -1,    -1,    -1,    -1,    -1,  1171,  1837,    -1,
      -1,   273,    -1,  1842,    -1,    -1,    -1,    -1,  1182,    -1,
      -1,    -1,    -1,    -1,    -1,  2206,  1855,    -1,  1857,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    92,
      -1,    -1,    -1,  2224,    -1,    -1,    -1,    -1,    -1,   102,
    1911,    -1,  1455,   199,    -1,    -1,    -1,   203,    -1,    -1,
      -1,  1225,    -1,    -1,  1228,    -1,  1230,   329,  1232,    -1,
      -1,    -1,    -1,    -1,    -1,   221,   222,    -1,    -1,    -1,
      -1,    -1,  1911,   136,  2265,    -1,    -1,   233,    -1,    -1,
      -1,    -1,    -1,   146,    -1,  2276,   149,    -1,    -1,    -1,
     153,    -1,    -1,  2284,   157,    -1,    -1,    -1,    -1,    -1,
      -1,   257,    -1,  1942,   260,    -1,    -1,    -1,    -1,    -1,
      -1,  1285,    -1,    -1,   177,    -1,    -1,   273,    -1,   275,
     392,    -1,  1296,  1962,    -1,    -1,    -1,    -1,    -1,   192,
      -1,    -1,    -1,    -1,   406,   407,   408,   409,   410,   411,
      -1,  1554,    -1,    -1,    -1,    -1,    -1,  2338,    -1,    -1,
      -1,    -1,  1991,  1992,  1993,    -1,    -1,  1996,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2359,  2008,
    2009,  2010,  2011,   329,    -1,    -1,    -1,    -1,  2017,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2028,
      -1,    -1,    -1,    -1,    -1,  2386,    -1,    -1,    -1,    -1,
    2039,  2040,    -1,  2042,    -1,    -1,    -1,  2046,    -1,    -1,
      -1,    -1,  1386,    -1,    -1,    -1,    -1,  2408,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2069,    -1,  2071,  2072,    -1,    -1,   392,    -1,    -1,    -1,
      -1,    -1,    -1,  1656,    -1,    -1,   402,   403,   404,    -1,
     406,   407,   408,   409,   410,   411,    -1,  2096,    -1,    -1,
     416,    -1,    -1,    -1,  2103,  2104,  2105,    77,    -1,    -1,
      -1,    -1,    -1,    -1,  2145,    -1,    -1,    -1,    -1,    -1,
      90,  1455,    -1,    -1,    94,    -1,    -1,    97,  2127,   352,
      -1,    -1,   102,    -1,  2133,  2166,    -1,  2168,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2145,    -1,    -1,    -1,
      -1,  2182,    -1,    -1,    -1,    -1,  1729,    -1,    -1,    -1,
      -1,    -1,    -1,  2514,    -1,    -1,  1739,  2166,  1741,  2168,
    1743,    -1,    -1,    -1,    -1,  2206,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2182,    -1,    -1,    -1,    -1,    -1,   159,
      -1,    -1,    -1,  2224,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2206,    -1,  1543,
      -1,  1545,    -1,    -1,    -1,  1549,    -1,    -1,    -1,    -1,
    1554,  1555,    -1,    -1,  2223,  2224,    -1,    -1,  1562,   199,
      -1,  2582,    -1,   203,  2265,    -1,    -1,    -1,  1572,    -1,
    1574,    -1,    -1,    -1,    -1,  2276,    -1,    -1,    -1,    -1,
      -1,   221,   222,  2284,  1827,    -1,  1590,    -1,  1592,    -1,
      -1,    -1,    -1,   233,    -1,    -1,  2265,    -1,    -1,    -1,
    1843,    -1,    -1,    -1,  1847,    -1,    -1,  2276,  1851,    -1,
      -1,    -1,    -1,    -1,    -1,  2284,  1859,   257,    -1,    -1,
     260,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   273,    -1,   275,    -1,  2338,  2307,    -1,
      -1,    -1,  1885,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1656,    -1,    -1,    -1,  1899,    -1,  2359,  2680,
    2329,    -1,    -1,    -1,    -1,    -1,  2335,    -1,    -1,  2338,
      -1,    -1,    -1,    -1,   567,   568,    -1,    -1,  2347,    -1,
    2349,    -1,    -1,    -1,  2353,  2386,    -1,    -1,    -1,   329,
    2359,  2360,    -1,    -1,  2363,  2364,  2365,  2366,  2367,  2368,
    2369,  2370,  2371,  2372,    -1,    -1,    -1,  2408,  2377,  2378,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2386,    -1,  1723,
      -1,    -1,  2391,    -1,    -1,  1729,    -1,    -1,    -1,  2398,
    2399,  2400,   372,  2402,    -1,  1739,    -1,    -1,    -1,  2408,
    2409,    -1,    -1,    -1,    -1,  2414,    -1,    -1,  2417,    -1,
      -1,    -1,   392,    -1,    -1,    -1,    -1,  2426,    -1,    -1,
      -1,    -1,   402,   403,   404,    -1,   406,   407,   408,   409,
     410,   411,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1794,    -1,    -1,  1797,  1798,    -1,    -1,    -1,    -1,    -1,
    2469,   694,    -1,   696,    -1,    -1,   699,   700,    -1,    -1,
      -1,    -1,    -1,  2514,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1828,    -1,   719,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2856,    -1,    -1,   731,  1843,
      -1,   734,  2085,  1847,    -1,  2514,    -1,  1851,    -1,    -1,
      -1,    -1,   745,   746,    -1,  1859,    -1,    -1,    -1,    -1,
    1864,   754,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   764,    -1,  1877,    -1,   768,   769,    -1,    -1,    -1,
      -1,  2582,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1899,    -1,    -1,    -1,   792,
      -1,   794,  2571,    -1,    -1,    -1,    -1,   800,    -1,    -1,
      -1,    -1,    -1,  2582,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   828,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   848,  2625,  1961,  2201,    -1,
      -1,    -1,    -1,    -1,  2207,  2208,  2635,    -1,    -1,  2990,
      -1,    -1,    -1,  2216,    -1,    -1,    -1,    -1,    -1,  2680,
      -1,  2224,    -1,    -1,    -1,    -1,    -1,    -1,  2231,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2241,  2242,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2680,    -1,    -1,    -1,  2684,  2685,  2686,    -1,    -1,
    2689,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2703,    -1,    -1,    -1,  2707,    -1,
      -1,    -1,  2711,    -1,    -1,    -1,    -1,    -1,  2717,    -1,
      -1,    -1,    -1,    -1,    -1,   948,    -1,    -1,   951,    -1,
      -1,   954,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2083,
      -1,  2085,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3114,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2780,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1018,    -1,    -1,    -1,  1022,
      -1,    -1,    -1,  1026,    -1,    -1,    -1,    -1,  1031,    -1,
      -1,    -1,    -1,    -1,    -1,  2814,    -1,    -1,    -1,    -1,
      -1,  3172,    -1,    -1,  2397,  2856,    -1,    -1,    -1,    -1,
      -1,  1054,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2173,
      -1,  2840,    -1,    -1,    -1,  2179,  2180,    -1,    -1,    -1,
    2849,    -1,  2851,    -1,    -1,    -1,    -1,  2856,    -1,    -1,
      -1,  2860,    -1,    -1,    -1,    -1,  1089,    -1,    -1,    -1,
      -1,    -1,  2871,  2207,  2208,    -1,    -1,  2876,    -1,  1102,
      -1,  2880,  2216,    -1,    -1,    -1,  2885,  2886,    -1,    -1,
    2224,    -1,    -1,    -1,    -1,  2229,  2895,  2231,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2479,  2241,  2242,    -1,
      -1,    -1,    -1,  2912,    -1,    -1,    -1,    -1,   687,    -1,
      -1,    -1,   691,    -1,    -1,    77,    -1,  2926,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    90,    -1,
      -1,    -1,    -1,    -1,    -1,    97,    -1,    -1,    -1,   718,
     102,    -1,  2951,    -1,    -1,  2528,  2529,    -1,    -1,  2990,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2972,    -1,  2548,  2549,  2550,  2551,  2552,
      -1,    -1,  2981,    -1,   753,    -1,  2985,    -1,    -1,    -1,
     759,  2990,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2345,    -1,    -1,    -1,    -1,    -1,  2351,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2602,
      -1,   183,    -1,    -1,    -1,    -1,   188,  3036,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   199,    -1,    -1,
      -1,   203,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3060,    -1,  2397,    -1,    -1,    -1,    -1,    -1,   221,
     222,    -1,    -1,    -1,    -1,    -1,   845,    -1,    -1,    -1,
      -1,   233,    -1,  3114,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1316,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   257,    -1,    -1,   260,    -1,
      -1,    -1,    -1,    -1,    -1,  3114,    -1,    -1,    -1,    -1,
      -1,   273,    -1,   275,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3136,    -1,    -1,
      -1,  3172,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2723,  2724,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3169,    -1,    -1,  3172,    -1,    -1,    -1,   329,    -1,    -1,
    2753,    -1,  2755,  2756,    -1,    -1,    -1,  2760,    -1,    -1,
      -1,    -1,    -1,    -1,  2528,  2529,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2543,
      -1,    -1,    -1,    -1,  2548,  2549,  2550,  2551,  2552,  1442,
      -1,  1444,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2809,    -1,    -1,  1008,
     392,    -1,  2815,    -1,    -1,  1014,  2819,    -1,    -1,    -1,
     402,   403,   404,    -1,   406,   407,   408,   409,   410,   411,
      -1,  1030,  1485,    -1,    -1,    -1,    -1,     5,  2602,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    20,    -1,  1053,    -1,    -1,    -1,    -1,    -1,
      -1,    29,    -1,    -1,  1063,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    40,    41,    -1,    -1,    -1,    -1,    46,    -1,
      48,    49,    -1,    -1,    -1,    53,    54,    55,    56,    57,
      58,    59,    60,    61,    62,    63,    64,    65,    66,    67,
      68,    69,    70,    71,    72,    73,    74,    75,    76,    -1,
      -1,    -1,  2915,    -1,    -1,    -1,    -1,    -1,    -1,  1118,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1140,    -1,    -1,    -1,    -1,    -1,   115,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2724,    -1,    -1,    -1,    -1,  1164,  1165,    -1,  1167,  1168,
    1169,    -1,    -1,    -1,    -1,    -1,  1629,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2748,    -1,    -1,    -1,  1187,  2753,
      -1,  2755,  2756,  1646,    -1,    -1,  2760,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   182,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     198,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3041,    -1,
      -1,    -1,    -1,    -1,    -1,  2809,    -1,   215,    -1,    -1,
      -1,  2815,    -1,  1252,    -1,  2819,  1255,  1256,    -1,    -1,
    3063,  3064,    -1,    -1,  3067,  3068,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   242,    -1,    -1,   245,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1738,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   262,    -1,    -1,    -1,    -1,    -1,
    1753,    -1,    -1,    -1,    -1,  1758,    -1,    -1,    -1,    -1,
      -1,  1764,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1322,    -1,    -1,    -1,  1326,    -1,    -1,
    1783,  1784,    -1,  1786,    -1,    -1,    -1,    -1,    -1,    -1,
    1793,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     318,  2915,  1351,    -1,  1807,    -1,  1809,    -1,  1811,  1812,
      -1,    -1,    -1,  1816,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   351,    -1,  1384,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   364,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   376,    -1,
      -1,    -1,  1411,    -1,    -1,    -1,    -1,    -1,    -1,   387,
      -1,    -1,   390,   391,    -1,   393,    -1,   395,    -1,    -1,
      -1,   399,    -1,   401,   402,    -1,    -1,  1436,   406,   407,
     408,   409,   410,    -1,    -1,   413,   414,   415,   416,    -1,
     418,   419,   420,   421,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1467,    -1,
    1469,  1924,    -1,    -1,  1473,    -1,    -1,  3041,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3063,
      -1,    -1,    -1,  3067,     3,  1504,    -1,    -1,    -1,    -1,
       9,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      19,    -1,    -1,    22,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1530,  1531,    -1,    33,    -1,    -1,    -1,    -1,  1538,
      -1,    -1,  1541,  1542,    -1,    -1,    -1,    -1,  3112,  3113,
      -1,    -1,    51,    52,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1561,    -1,    -1,    -1,  1565,  1566,  1567,    -1,
    1569,    -1,    -1,    -1,    -1,    -1,    -1,  1576,  1577,    78,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    87,    88,
      89,    -1,    -1,    -1,    -1,  1594,  1595,    -1,    -1,  1598,
    1599,    -1,   101,    -1,  1603,    -1,    -1,    -1,  1607,    -1,
      -1,  1610,  1611,  1612,  1613,  1614,  1615,  1616,  1617,  1618,
     119,  1620,   121,   122,    -1,  1624,    -1,   126,   127,  1628,
      -1,    -1,    -1,    -1,   133,   134,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   145,    -1,   147,    -1,
      -1,   150,    -1,    77,    -1,    -1,    -1,   156,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   164,    90,    -1,    -1,    93,
     169,    -1,    -1,    97,    -1,   174,    -1,   176,   102,    -1,
      -1,   180,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2155,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   213,    -1,    -1,    -1,    -1,    77,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    90,    -1,    -1,    93,   235,   236,    -1,    97,
     239,    -1,   687,    -1,   102,    -1,   691,   246,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     259,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1767,    -1,
      -1,    -1,    -1,   718,    -1,   199,    -1,  1776,    -1,   203,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   288,
    2243,  2244,  2245,    -1,    -1,    -1,    -1,   221,   222,    -1,
     299,    -1,   301,    -1,    -1,    -1,   305,    -1,   753,   233,
     309,    -1,   311,    -1,   759,    -1,   315,    -1,    -1,    -1,
      -1,   320,    -1,    -1,    -1,    -1,   325,    -1,  2281,   328,
      -1,    -1,    -1,   257,    -1,   334,   260,    -1,  1837,  2292,
      -1,   199,    -1,  1842,    -1,   203,    -1,    -1,    -1,   273,
      -1,   275,    -1,    -1,    -1,    -1,  1855,    -1,  1857,    -1,
     359,    -1,   361,   221,   222,    -1,    -1,    -1,   367,    -1,
     369,    -1,    -1,    -1,   373,   233,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   257,
     845,    -1,   260,    -1,    -1,   329,    -1,    -1,    -1,    -1,
      -1,    -1,  1911,    -1,    -1,   273,   415,   275,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    77,  1942,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    90,    -1,    -1,    -1,    -1,
      -1,    -1,    97,  1962,    -1,    -1,    -1,   102,   392,    -1,
      -1,   329,    -1,    -1,    -1,    -1,    -1,    -1,   402,   403,
     404,    -1,   406,   407,   408,   409,   410,   411,    77,    -1,
      -1,    -1,  1991,  1992,  1993,    -1,    -1,  1996,    -1,    -1,
      -1,    90,    -1,    -1,    93,    -1,    -1,    -1,    97,  2008,
    2009,  2010,  2011,   102,    -1,    -1,    -1,    -1,  2017,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2028,
      -1,    -1,    -1,    -1,   392,    -1,    -1,    -1,    -1,    -1,
    2039,  2040,    -1,  2042,   402,   403,   404,  2046,   406,   407,
     408,   409,   410,   411,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1008,   199,  2518,  2519,    -1,   203,  1014,
    2069,    -1,  2071,  2072,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1030,   221,   222,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2096,   233,    -1,
      -1,    -1,    -1,    -1,  2103,  2104,  2105,    -1,  1053,    -1,
     199,    -1,    -1,    -1,   203,    -1,    -1,  2570,  1063,    -1,
      -1,    -1,   257,    -1,    -1,   260,    -1,    -1,  2127,    -1,
      -1,    -1,   221,   222,  2133,    -1,    -1,    -1,   273,    -1,
     275,    -1,    -1,    -1,   233,    -1,  2145,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2166,   257,  2168,
      -1,   260,    -1,  1118,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2182,   273,    -1,   275,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   329,  1140,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2206,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1164,
    1165,    -1,  1167,  1168,  1169,  2224,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   372,    -1,    -1,
     329,    -1,  1187,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   392,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2265,   402,   403,   404,
      -1,   406,   407,   408,   409,   410,   411,  2276,    -1,    -1,
      -1,    -1,    -1,  2736,    -1,  2284,    -1,    -1,    -1,    -1,
    2743,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   392,    -1,    -1,    -1,  1252,  2307,    -1,
    1255,  1256,    77,   402,   403,   404,    -1,   406,   407,   408,
     409,   410,   411,    -1,    -1,    90,    -1,    -1,    -1,    -1,
    2329,    -1,    97,    -1,    -1,    -1,  2335,   102,    -1,  2338,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2347,    -1,
    2349,    -1,    -1,    -1,  2353,    -1,    -1,    -1,    -1,    -1,
    2359,  2360,    -1,    -1,  2363,  2364,  2365,  2366,  2367,  2368,
    2369,  2370,  2371,  2372,    -1,    -1,    -1,  1322,  2377,  2378,
      -1,  1326,    -1,    -1,    -1,    -1,    -1,  2386,    -1,    -1,
      -1,    -1,  2391,    -1,    -1,    -1,    -1,    -1,    -1,  2398,
    2399,  2400,    -1,  2402,    -1,    -1,  1351,    -1,    -1,  2408,
    2409,    -1,    77,    -1,    -1,  2414,    -1,    -1,  2417,    -1,
      -1,    -1,    -1,    -1,    -1,    90,    -1,  2426,    -1,    -1,
      -1,    -1,    97,    -1,   199,    -1,    -1,   102,   203,  1384,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   221,   222,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1411,    -1,   233,    -1,
    2469,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1436,   257,    -1,    -1,   260,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,    -1,
     275,    -1,    -1,    -1,    -1,  2514,    -1,    -1,    -1,   284,
      -1,    -1,  1467,   188,  1469,    -1,    -1,    -1,  1473,    -1,
      -1,    -1,    -1,    77,   199,    -1,    -1,    -1,   203,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    90,    -1,    -1,    -1,
      -1,    -1,    -1,    97,    -1,    -1,   221,   222,   102,  1504,
      -1,    -1,    -1,    -1,   329,    -1,    -1,  3020,   233,    -1,
      -1,    -1,  2571,  3026,    77,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2582,    -1,  1530,  1531,    90,    -1,    -1,
      -1,    -1,   257,  1538,    97,   260,  1541,  1542,   845,   102,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,    -1,
     275,    -1,    -1,    -1,    -1,    -1,  1561,    -1,    -1,    -1,
    1565,  1566,  1567,    -1,  1569,    -1,  2625,   392,    -1,    -1,
      -1,  1576,  1577,    -1,    -1,    -1,  2635,   402,   403,   404,
      -1,   406,   407,   408,   409,   410,   411,    -1,    -1,  1594,
    1595,    -1,    -1,  1598,  1599,   199,    -1,    -1,  1603,   203,
      -1,    -1,  1607,    -1,   329,  1610,  1611,  1612,  1613,  1614,
    1615,  1616,  1617,  1618,    -1,  1620,    -1,   221,   222,  1624,
      -1,  2680,    -1,  1628,    -1,  2684,  2685,  2686,    -1,   233,
    2689,    -1,    -1,    -1,    -1,    -1,   199,    -1,    -1,    -1,
     203,    -1,    -1,    -1,  2703,    -1,    -1,    -1,  2707,    -1,
      -1,    -1,  2711,   257,    -1,    -1,   260,    -1,   221,   222,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   392,    -1,   273,
     233,   275,    -1,    -1,    -1,    -1,    -1,   402,   403,   404,
      -1,   406,   407,   408,   409,   410,   411,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   257,    -1,    -1,   260,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     273,    -1,   275,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2780,    -1,    -1,    -1,   329,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   348,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2814,    -1,    -1,    -1,    -1,
      -1,    -1,  1767,    -1,    -1,    -1,   329,    -1,    -1,    -1,
      -1,  1776,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2840,    -1,    -1,    -1,    -1,    -1,    -1,   392,    -1,
    2849,    -1,  2851,    -1,    -1,    -1,    -1,  2856,   402,   403,
     404,  2860,   406,   407,   408,   409,   410,   411,    -1,    -1,
      -1,  1118,  2871,    -1,    -1,    -1,    -1,  2876,    -1,    -1,
      -1,  2880,    -1,    -1,    -1,    -1,  2885,  2886,    -1,   392,
      -1,    -1,  1837,  1140,    -1,    -1,  2895,  1842,    -1,   402,
     403,   404,    -1,   406,   407,   408,   409,   410,   411,    -1,
    1855,    -1,  1857,  2912,    -1,    -1,    -1,  1164,  1165,    -1,
    1167,  1168,  1169,    -1,    -1,    -1,    -1,  2926,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1187,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2951,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1911,    -1,    -1,    -1,
      -1,    -1,    -1,  2972,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2981,    -1,    -1,    -1,  2985,    -1,    -1,    -1,
      -1,  2990,    -1,    -1,    -1,    -1,    -1,  1942,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1252,    -1,    -1,  1255,  1256,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1962,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3036,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1991,  1992,  1993,    -1,
      -1,  1996,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3060,    -1,  2008,  2009,  2010,  2011,    -1,    -1,    -1,
      -1,    -1,  2017,    -1,    -1,  1322,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2028,    -1,    -1,    -1,    -1,    -1,    -1,
    1183,    -1,    -1,    -1,  2039,  2040,    -1,  2042,    -1,    -1,
      -1,  2046,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3114,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2069,    -1,  2071,  2072,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3136,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2096,    -1,    -1,    -1,    -1,    -1,    -1,  2103,  2104,
    2105,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3169,    -1,    -1,  3172,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2127,    -1,    -1,    -1,    -1,    -1,  2133,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2145,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1467,  2166,    -1,  2168,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2182,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2206,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2224,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1538,    -1,    -1,    -1,  1542,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1561,    -1,    -1,    -1,  1565,    -1,
    2265,    -1,  1569,    -1,    -1,    -1,    -1,    -1,    -1,  1576,
    1577,  2276,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2284,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1595,    -1,
      -1,    -1,  1599,    -1,    -1,    -1,  1603,    -1,    -1,    -1,
    1607,    -1,  2307,  1610,  1611,  1612,  1613,  1614,  1615,  1616,
    1617,  1618,    -1,  1620,    -1,    -1,    -1,  1624,    -1,    -1,
      -1,    -1,    -1,    -1,  2329,    -1,    -1,    -1,    -1,    -1,
    2335,    -1,    -1,  2338,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2347,    -1,  2349,    -1,    -1,    -1,  2353,    -1,
      -1,    -1,    -1,    -1,  2359,  2360,    -1,    -1,  2363,  2364,
    2365,  2366,  2367,  2368,  2369,  2370,  2371,  2372,    -1,    -1,
      -1,    -1,  2377,  2378,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2386,    -1,  1536,    -1,    -1,  2391,    -1,    -1,    -1,
      -1,    -1,    -1,  2398,  2399,  2400,    -1,  2402,    -1,    -1,
      -1,    -1,    -1,  2408,  2409,    -1,    -1,  1560,    -1,  2414,
      -1,    -1,  2417,  1566,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2426,    -1,    -1,    -1,    -1,    -1,    -1,  1581,  1582,
    1583,  1584,    -1,  1586,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1598,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1767,    -1,    -1,    -1,  2469,    -1,    -1,    -1,    -1,  1622,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2514,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1688,    -1,    -1,    -1,    -1,
      -1,  1694,    -1,  1696,    -1,    -1,    -1,     5,  1855,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    20,    -1,    -1,    -1,  2571,    -1,    -1,    -1,
      -1,    29,    -1,    -1,    -1,    -1,    -1,  2582,    -1,    -1,
      -1,    -1,    40,    41,    -1,    -1,    -1,    -1,    -1,    -1,
      48,    49,  1745,    -1,    -1,    53,    54,    55,    56,    57,
      58,    59,    60,    61,    62,    63,    64,    65,    66,    67,
      68,    69,    70,    71,    72,    73,    74,    75,    76,    -1,
    2625,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2635,    -1,    -1,    -1,    -1,  1942,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1962,    -1,   115,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2680,    -1,    -1,    -1,  2684,
    2685,  2686,    -1,    -1,  2689,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2703,    -1,
      -1,  2008,  2707,  2010,  2011,    -1,  2711,    -1,    -1,    -1,
    2017,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   182,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2040,    -1,  2042,    -1,    -1,    -1,  2046,
     198,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1909,   215,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2780,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   242,    -1,    -1,   245,    -1,  2096,
      -1,    -1,    -1,    -1,    -1,    -1,  2103,  2104,  2105,    -1,
      -1,    -1,    -1,  1956,   262,    -1,    -1,    -1,    -1,  2814,
      -1,    -1,  1965,    -1,  1967,    -1,    -1,    -1,    -1,    -1,
    2127,    -1,    -1,    -1,    -1,    -1,  2133,    -1,    -1,    -1,
      -1,    -1,    -1,  1986,    -1,  2840,  1989,    -1,  1991,  1992,
    1993,  1994,    -1,  1996,  2849,    -1,  2851,  2000,    -1,    -1,
      -1,  2856,    -1,    -1,  2007,  2860,    -1,    -1,    -1,  2012,
     318,    -1,    -1,    -1,    -1,    -1,  2871,    -1,    -1,    -1,
    2023,  2876,    -1,  2026,  2027,  2880,    -1,    -1,    -1,    -1,
    2885,  2886,    -1,    -1,    -1,  2038,  2039,    -1,    -1,    -1,
    2895,    -1,  2045,   351,  2047,  2048,  2049,  2050,  2051,  2052,
    2053,  2054,  2055,  2056,    -1,    -1,   364,  2912,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   376,    -1,
      -1,  2926,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   387,
      -1,    -1,   390,   391,    -1,   393,    -1,    -1,    -1,    -1,
      -1,   399,    -1,   401,   402,    -1,  2951,    -1,   406,   407,
     408,   409,   410,    -1,    -1,   413,   414,   415,    -1,    -1,
      -1,   419,    -1,    -1,    -1,    -1,    -1,  2972,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2981,    -1,    -1,    -1,
    2985,    -1,    -1,    -1,    -1,  2990,    -1,  2140,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2329,    -1,    -1,    -1,    -1,    -1,  2335,    -1,
      -1,  3036,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2347,    -1,  2349,    -1,    -1,    -1,  2353,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3060,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2377,  2378,  2225,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2400,    -1,  2402,    -1,    -1,    -1,    -1,
      -1,    -1,  2409,    -1,    -1,    -1,    -1,  2414,    -1,  3114,
    2417,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3136,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2314,  2469,    -1,  3169,    -1,    -1,  3172,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2334,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2356,  2357,  2358,    -1,  2360,    -1,    -1,
    2363,  2364,  2365,  2366,  2367,  2368,  2369,  2370,  2371,  2372,
      -1,  2374,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     5,    -1,
      -1,  2394,    -1,    -1,    -1,    -1,  2399,    -1,    -1,    -1,
      -1,    -1,    -1,    20,    -1,    -1,    -1,  2410,  2411,    -1,
    2413,    -1,    29,  2416,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    40,    41,    -1,    -1,    -1,    -1,    -1,
      -1,    48,    49,    -1,    -1,    -1,    53,    54,    55,    56,
      57,    58,    59,    60,    61,    62,    63,    64,    65,    66,
      67,    68,    69,    70,    71,    72,    73,    74,    75,    76,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2625,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2635,    -1,
      -1,    -1,    -1,    -1,    -1,  2488,    -1,    -1,  2491,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   115,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2685,  2686,
      -1,    -1,  2689,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   182,    -1,    -1,  2571,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   198,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   215,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2780,    -1,   242,    -1,    -1,   245,  2632,
      -1,    -1,    -1,  2636,    -1,    -1,    -1,    -1,  2641,  2642,
      -1,  2644,    -1,    -1,  2647,   262,    -1,    -1,  2651,  2652,
    2653,  2654,  2655,  2656,  2657,  2658,  2659,  2660,  2661,  2662,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2676,  2677,    -1,  2679,    -1,    -1,    -1,
    2683,  2684,    -1,  2840,  2687,    -1,    -1,  2690,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   318,    -1,  2860,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2729,    -1,    -1,  2886,
      -1,    -1,    -1,    -1,   351,    -1,    -1,    -1,  2895,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   364,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2912,    -1,    -1,    -1,   376,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     387,    -1,    -1,   390,   391,    -1,   393,    -1,    -1,  2782,
      -1,    -1,   399,    -1,   401,   402,    -1,    -1,    -1,   406,
     407,   408,   409,   410,  2951,    -1,   413,   414,   415,   416,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2981,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2842,
      -1,    -1,    -1,    -1,    -1,    -1,  2849,    -1,  2851,    -1,
      -1,    -1,    -1,    -1,  2857,  2858,  2859,    -1,  2861,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3060,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2930,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2971,  2972,
    2973,    -1,    -1,  2976,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2992,
      -1,    -1,    -1,  2996,    -1,    -1,    -1,    -1,  3001,    -1,
      -1,     5,     6,     7,     8,     9,    -1,    11,    12,    -1,
      14,    15,    16,    17,    -1,    19,    -1,    21,    -1,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      34,  3034,    36,    37,    38,    39,    40,    41,    -1,    43,
      44,    45,    -1,    47,    48,    49,  3049,    51,    52,    -1,
    3053,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,
      -1,    75,    76,    -1,    78,    79,    80,    81,    82,    83,
      84,    85,    86,    87,    88,    89,    90,    91,    92,    93,
      94,    95,    96,    97,    98,    99,   100,   101,   102,   103,
     104,   105,    -1,   107,   108,   109,    -1,   111,   112,   113,
     114,   115,   116,   117,   118,   119,   120,   121,   122,   123,
     124,   125,   126,   127,   128,   129,   130,   131,   132,   133,
     134,   135,   136,   137,   138,   139,   140,   141,   142,   143,
     144,   145,   146,   147,   148,   149,   150,   151,   152,   153,
     154,    -1,   156,   157,   158,   159,   160,   161,   162,   163,
     164,   165,   166,   167,   168,   169,   170,   171,   172,   173,
     174,   175,   176,    -1,   178,   179,   180,   181,   182,   183,
     184,   185,   186,   187,   188,   189,   190,    -1,   192,   193,
     194,   195,   196,   197,   198,   199,   200,   201,   202,   203,
     204,   205,   206,   207,   208,   209,   210,   211,   212,   213,
     214,   215,   216,   217,   218,   219,    -1,   221,   222,   223,
     224,   225,   226,   227,   228,   229,   230,   231,   232,   233,
     234,   235,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   247,   248,   249,   250,   251,   252,   253,
     254,   255,   256,   257,   258,   259,   260,   261,   262,   263,
     264,   265,   266,   267,   268,   269,   270,   271,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
      -1,   285,   286,   287,   288,   289,   290,   291,   292,   293,
     294,   295,   296,   297,   298,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,   317,   318,    -1,   320,   321,   322,   323,
     324,   325,   326,   327,   328,   329,   330,   331,   332,   333,
     334,   335,   336,   337,   338,   339,   340,   341,   342,   343,
     344,   345,   346,   347,   348,   349,   350,   351,   352,   353,
     354,   355,   356,   357,   358,   359,   360,   361,   362,   363,
     364,   365,   366,   367,   368,   369,   370,   371,   372,   373,
     374,   375,   376,   377,   378,   379,    -1,   381,   382,   383,
     384,   385,   386,   387,   388,    -1,   390,    -1,    -1,   393,
      -1,    -1,     6,     7,     8,    -1,    -1,    11,    12,    -1,
      14,    15,    16,    -1,    -1,    -1,    20,    21,    -1,    23,
      24,    25,    26,    27,    28,   419,    30,    31,    32,    -1,
      -1,    -1,    36,    37,    38,    39,    -1,    41,    -1,    43,
      44,    45,    -1,    47,    48,    49,    -1,    -1,    -1,    -1,
      -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,
      -1,    75,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    98,    -1,    -1,    -1,   102,   103,
     104,   105,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   116,    -1,    -1,    -1,    -1,    -1,    -1,   123,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   132,    -1,
      -1,    -1,    -1,   137,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   148,   149,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   175,    -1,    -1,   178,    -1,    -1,    -1,   182,    -1,
      -1,    -1,    -1,   187,    -1,   189,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   199,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   209,   210,    -1,    -1,    -1,
      -1,    -1,   216,    -1,   218,    -1,    -1,   221,   222,    -1,
     224,    -1,    -1,    -1,    -1,    -1,    -1,   231,    -1,   233,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   248,   249,   250,    -1,    -1,    -1,
      -1,    -1,   256,    -1,    -1,    -1,   260,    -1,    -1,   263,
     264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   277,   278,   279,   280,    -1,    -1,    -1,
      -1,   285,   286,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   296,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   310,    -1,   312,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   326,    -1,    -1,   329,    -1,   331,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   341,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   349,   350,    -1,    -1,    -1,
      -1,   355,    -1,   357,    -1,    -1,    -1,    -1,    -1,    -1,
     364,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   376,    -1,   378,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,     6,     7,     8,    -1,   390,    11,    12,   393,
      14,    15,    16,    -1,    -1,    -1,    20,    21,    -1,    23,
      24,    25,    26,    27,    28,    -1,    30,    31,    32,    -1,
      -1,    -1,    36,    37,    38,    39,   420,    41,    -1,    43,
      44,    45,    -1,    47,    48,    49,    -1,    -1,    -1,    -1,
      -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,
      -1,    75,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    98,    -1,    -1,    -1,   102,   103,
     104,   105,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   116,    -1,    -1,    -1,    -1,    -1,    -1,   123,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   132,    -1,
      -1,    -1,    -1,   137,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   148,   149,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   175,    -1,    -1,   178,    -1,    -1,    -1,   182,    -1,
      -1,    -1,    -1,   187,    -1,   189,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   199,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   209,   210,    -1,    -1,    -1,
      -1,    -1,   216,    -1,   218,    -1,    -1,   221,   222,    -1,
     224,    -1,    -1,    -1,    -1,    -1,    -1,   231,    -1,   233,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   248,   249,   250,    -1,    -1,    -1,
      -1,    -1,   256,    -1,    -1,    -1,   260,    -1,    -1,   263,
     264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   277,   278,   279,   280,    -1,    -1,    -1,
      -1,   285,   286,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   296,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   310,    -1,   312,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   326,    -1,    -1,   329,    -1,   331,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   341,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   349,   350,    -1,    -1,    -1,
      -1,   355,    -1,   357,    -1,    -1,    -1,    -1,    -1,    -1,
     364,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   376,    -1,   378,    -1,    -1,    -1,    -1,     3,
      -1,    -1,     6,     7,     8,     9,   390,    11,    12,   393,
      14,    15,    16,    17,    -1,    19,    20,    21,    22,    23,
      24,    25,    26,    27,    28,    -1,    30,    31,    32,    33,
      -1,    -1,    36,    37,    38,    39,   420,    41,    -1,    43,
      44,    45,    -1,    47,    48,    49,    -1,    51,    52,    -1,
      -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,
      -1,    75,    76,    -1,    78,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    87,    88,    89,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    97,    98,    -1,    -1,   101,   102,   103,
     104,   105,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   116,    -1,    -1,   119,    -1,   121,   122,   123,
      -1,    -1,   126,   127,    -1,    -1,    -1,    -1,   132,   133,
     134,    -1,    -1,   137,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   145,    -1,   147,   148,   149,   150,    -1,    -1,    -1,
      -1,    -1,   156,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     164,    -1,    -1,    -1,    -1,   169,    -1,    -1,    -1,    -1,
     174,   175,   176,    -1,   178,    -1,   180,    -1,   182,    -1,
      -1,    -1,    -1,   187,    -1,   189,    -1,   191,    -1,   193,
      -1,    -1,    -1,    -1,    -1,   199,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   209,   210,    -1,    -1,   213,
      -1,    -1,   216,    -1,   218,    -1,    -1,   221,   222,    -1,
     224,    -1,    -1,    -1,    -1,    -1,    -1,   231,    -1,   233,
      -1,   235,   236,    -1,    -1,   239,    -1,    -1,    -1,    -1,
      -1,    -1,   246,    -1,   248,   249,   250,    -1,    -1,    -1,
      -1,    -1,   256,    -1,    -1,   259,   260,    -1,    -1,   263,
     264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   277,   278,   279,   280,    -1,    -1,    -1,
      -1,   285,   286,    -1,   288,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   296,    -1,    -1,   299,    -1,   301,    -1,    -1,
      -1,   305,    -1,    -1,    -1,   309,   310,   311,   312,    -1,
      -1,   315,    -1,    -1,    -1,    -1,   320,    -1,    -1,    -1,
      -1,   325,   326,    -1,   328,   329,    -1,   331,    -1,    -1,
     334,    -1,    -1,    -1,    -1,    -1,    -1,   341,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   349,   350,    -1,    -1,    -1,
      -1,   355,    -1,   357,    -1,   359,    -1,   361,    -1,    -1,
     364,    -1,    -1,   367,    -1,   369,    -1,    -1,    -1,   373,
      -1,    -1,   376,    -1,   378,    -1,    -1,    -1,    -1,    -1,
      -1,     5,     6,     7,     8,     9,   390,    11,    12,   393,
      14,    15,    16,    17,    -1,    19,    -1,    21,    -1,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      34,   415,    36,    37,    38,    39,    40,    41,    -1,    43,
      44,    45,    -1,    47,    48,    49,    -1,    51,    52,    -1,
      -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,
      -1,    75,    76,    -1,    78,    79,    80,    81,    82,    83,
      84,    85,    86,    87,    -1,    -1,    -1,    -1,    92,    -1,
      -1,    95,    96,    97,    98,    99,   100,   101,   102,   103,
     104,   105,   106,    -1,   108,   109,    -1,   111,   112,   113,
     114,   115,   116,   117,    -1,   119,   120,   121,   122,   123,
      -1,    -1,   126,   127,   128,    -1,   130,   131,   132,   133,
      -1,   135,   136,   137,   138,   139,   140,   141,   142,   143,
     144,   145,   146,   147,   148,   149,   150,    -1,   152,    -1,
     154,    -1,   156,   157,   158,    -1,   160,    -1,   162,   163,
     164,   165,    -1,   167,   168,    -1,   170,    -1,   172,   173,
     174,   175,   176,    -1,   178,   179,   180,   181,   182,    -1,
     184,    -1,   186,   187,    -1,   189,   190,    -1,   192,    -1,
      -1,   195,    -1,   197,   198,   199,   200,   201,   202,    -1,
     204,   205,   206,   207,    -1,   209,   210,    -1,   212,   213,
     214,   215,   216,    -1,   218,    -1,    -1,   221,   222,   223,
     224,   225,   226,   227,   228,   229,    -1,   231,   232,   233,
      -1,   235,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   247,   248,   249,   250,   251,   252,   253,
     254,   255,   256,   257,   258,   259,   260,   261,   262,   263,
     264,   265,   266,    -1,    -1,   269,   270,    -1,    -1,   273,
     274,    -1,    -1,   277,   278,   279,   280,   281,   282,   283,
      -1,   285,   286,   287,   288,    -1,   290,   291,   292,   293,
     294,   295,   296,   297,    -1,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,   317,   318,    -1,    -1,   321,   322,   323,
     324,   325,   326,   327,   328,   329,   330,   331,    -1,   333,
     334,   335,   336,   337,   338,   339,   340,   341,   342,    -1,
     344,   345,   346,   347,    -1,   349,   350,    -1,   352,    -1,
     354,   355,   356,   357,   358,   359,   360,   361,   362,   363,
      -1,   365,   366,   367,   368,   369,   370,   371,    -1,   373,
     374,   375,   376,   377,   378,   379,    -1,    -1,    -1,   383,
     384,   385,   386,   387,   388,    -1,   390,   391,   392,   393,
     394,    -1,    -1,   397,   398,   399,   400,   401,    -1,    -1,
      -1,    -1,   406,   407,   408,    -1,   410,   411,    -1,    -1,
      -1,   415,   416,     5,     6,     7,     8,     9,    -1,    11,
      12,    -1,    14,    15,    16,    17,    -1,    19,    -1,    21,
      -1,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,    33,    34,    -1,    36,    37,    38,    39,    40,    41,
      -1,    43,    44,    45,    -1,    47,    48,    49,    -1,    51,
      52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,
      62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,
      -1,    73,    -1,    75,    76,    -1,    78,    79,    80,    81,
      82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,
      92,    -1,    -1,    95,    96,    97,    98,    99,   100,   101,
     102,   103,   104,   105,   106,    -1,   108,   109,    -1,   111,
     112,   113,   114,   115,   116,   117,    -1,   119,   120,   121,
     122,   123,    -1,    -1,   126,   127,   128,    -1,   130,   131,
     132,   133,    -1,   135,   136,   137,   138,   139,   140,   141,
     142,   143,   144,   145,   146,   147,   148,   149,   150,    -1,
     152,    -1,   154,    -1,   156,   157,   158,    -1,    -1,    -1,
     162,   163,   164,   165,    -1,   167,   168,    -1,   170,    -1,
     172,   173,   174,   175,   176,    -1,   178,   179,   180,   181,
     182,    -1,   184,    -1,   186,   187,    -1,   189,   190,    -1,
     192,    -1,    -1,   195,    -1,   197,   198,   199,   200,   201,
     202,    -1,   204,   205,   206,   207,    -1,   209,   210,    -1,
     212,   213,   214,   215,   216,    -1,   218,    -1,    -1,   221,
     222,   223,   224,   225,   226,   227,   228,   229,    -1,   231,
     232,   233,    -1,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,   249,   250,   251,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,   263,   264,   265,   266,    -1,    -1,   269,   270,    -1,
      -1,   273,   274,    -1,    -1,   277,   278,   279,   280,   281,
     282,   283,    -1,   285,   286,   287,   288,    -1,   290,   291,
     292,   293,   294,   295,   296,   297,    -1,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,   317,   318,    -1,    -1,   321,
     322,   323,   324,   325,   326,   327,   328,   329,   330,   331,
      -1,   333,   334,   335,   336,   337,   338,   339,   340,   341,
     342,    -1,   344,   345,   346,   347,    -1,   349,   350,    -1,
     352,    -1,   354,   355,   356,   357,   358,   359,   360,   361,
     362,   363,    -1,   365,   366,   367,   368,   369,   370,   371,
      -1,   373,   374,   375,   376,   377,   378,   379,    -1,    -1,
      -1,   383,   384,   385,   386,   387,   388,    -1,   390,   391,
     392,   393,   394,    -1,    -1,   397,   398,   399,   400,   401,
      -1,    -1,    -1,    -1,   406,   407,    -1,    -1,   410,   411,
      -1,    -1,    -1,   415,   416,     6,     7,     8,     9,    -1,
      11,    12,    -1,    14,    15,    16,    17,    -1,    19,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    -1,    30,
      31,    32,    33,    -1,    -1,    36,    37,    38,    39,    -1,
      -1,    -1,    43,    44,    45,    -1,    47,    -1,    -1,    -1,
      51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,
      -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      71,    -1,    73,    -1,    75,    76,    -1,    78,    79,    80,
      81,    82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    96,    97,    -1,    99,   100,
     101,    -1,   103,    -1,   105,    -1,    -1,   108,   109,    -1,
     111,    -1,    -1,   114,   115,   116,   117,    -1,   119,   120,
     121,   122,   123,    -1,    -1,   126,   127,   128,    -1,   130,
     131,   132,   133,    -1,   135,   136,    -1,   138,    -1,    -1,
      -1,    -1,   143,   144,   145,   146,   147,   148,   149,   150,
      -1,   152,    -1,   154,    -1,   156,   157,   158,    -1,    -1,
      -1,   162,   163,   164,   165,    -1,   167,   168,    -1,   170,
      -1,   172,   173,   174,   175,   176,    -1,   178,    -1,   180,
     181,   182,    -1,   184,    -1,   186,    -1,    -1,    -1,   190,
      -1,   192,    -1,    -1,   195,    -1,   197,   198,    -1,   200,
     201,   202,    -1,   204,   205,   206,   207,    -1,    -1,   210,
      -1,   212,   213,   214,    -1,   216,    -1,   218,    -1,    -1,
      -1,    -1,   223,    -1,   225,   226,   227,   228,   229,    -1,
      -1,   232,    -1,    -1,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   248,    -1,   250,
      -1,   252,   253,   254,   255,   256,    -1,   258,   259,    -1,
     261,    -1,   263,   264,   265,   266,    -1,    -1,   269,    -1,
      -1,    -1,   273,   274,    -1,    -1,   277,    -1,    -1,   280,
     281,   282,   283,    -1,   285,   286,   287,   288,    -1,   290,
     291,   292,   293,   294,   295,   296,   297,    -1,   299,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,    -1,
     311,   312,   313,   314,   315,   316,   317,   318,    -1,    -1,
     321,   322,   323,    -1,   325,   326,   327,   328,    -1,   330,
     331,    -1,   333,   334,   335,   336,   337,   338,   339,   340,
     341,   342,    -1,   344,   345,   346,   347,    -1,   349,   350,
      -1,   352,    -1,   354,   355,   356,   357,    -1,   359,   360,
     361,   362,   363,    -1,    -1,   366,   367,   368,   369,   370,
      -1,   372,   373,   374,   375,   376,   377,    -1,   379,     5,
      -1,    -1,   383,   384,   385,   386,   387,   388,    -1,   390,
      -1,    -1,   393,    -1,    20,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    29,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   413,    -1,    40,    41,   417,    -1,    -1,    -1,
      -1,    -1,    48,    49,    -1,    -1,    -1,    53,    54,    55,
      56,    57,    58,    59,    60,    61,    62,    63,    64,    65,
      66,    67,    68,    69,    70,    71,    72,    73,    74,    75,
      76,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   115,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   182,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   198,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   215,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   242,    -1,    -1,   245,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   262,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   318,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   351,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   364,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     376,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   387,    -1,    -1,   390,   391,    -1,   393,    -1,    -1,
      -1,    -1,    -1,   399,    -1,   401,   402,    -1,    -1,    -1,
     406,   407,   408,   409,   410,    -1,    -1,   413,   414,   415,
     416,     5,     6,     7,     8,     9,    -1,    11,    12,    -1,
      14,    15,    16,    17,    -1,    19,    -1,    21,    -1,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      34,    -1,    36,    37,    38,    39,    40,    41,    -1,    43,
      44,    45,    -1,    47,    48,    49,    -1,    51,    52,    -1,
      -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,
      -1,    75,    76,    -1,    78,    79,    80,    81,    82,    83,
      84,    -1,    86,    87,    -1,    -1,    -1,    -1,    92,    -1,
      -1,    95,    96,    97,    98,    99,   100,   101,   102,   103,
     104,   105,   106,   107,   108,   109,    -1,   111,   112,   113,
     114,   115,   116,   117,    -1,   119,   120,   121,   122,   123,
      -1,    -1,   126,   127,   128,    -1,   130,   131,   132,   133,
      -1,   135,   136,   137,   138,   139,   140,   141,   142,   143,
     144,   145,   146,   147,   148,   149,   150,    -1,   152,    -1,
     154,    -1,   156,   157,   158,    -1,    -1,    -1,   162,   163,
     164,   165,    -1,   167,   168,    -1,   170,    -1,   172,   173,
     174,   175,   176,    -1,   178,   179,   180,   181,   182,    -1,
     184,    -1,   186,   187,   188,   189,   190,    -1,   192,    -1,
      -1,   195,    -1,   197,   198,   199,   200,   201,   202,    -1,
     204,   205,   206,   207,    -1,   209,   210,    -1,   212,   213,
     214,   215,   216,    -1,   218,    -1,    -1,   221,   222,   223,
     224,   225,   226,   227,   228,   229,   230,   231,   232,   233,
      -1,   235,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   247,   248,   249,   250,   251,   252,   253,
     254,   255,   256,   257,   258,   259,   260,   261,   262,   263,
     264,   265,   266,    -1,    -1,   269,   270,    -1,    -1,   273,
     274,    -1,    -1,   277,   278,   279,   280,   281,   282,   283,
      -1,   285,   286,   287,   288,    -1,   290,   291,   292,   293,
     294,   295,   296,   297,    -1,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,   317,   318,    -1,    -1,   321,   322,   323,
     324,   325,   326,   327,   328,   329,   330,   331,    -1,   333,
     334,   335,   336,   337,   338,   339,   340,   341,   342,    -1,
     344,   345,   346,   347,    -1,   349,   350,    -1,   352,   353,
     354,   355,   356,   357,   358,   359,   360,   361,   362,   363,
      -1,   365,   366,   367,   368,   369,   370,   371,    -1,   373,
     374,   375,   376,   377,   378,   379,    -1,    -1,    -1,   383,
     384,   385,   386,   387,   388,    -1,   390,   391,   392,   393,
     394,    -1,    -1,   397,   398,   399,   400,   401,    -1,    -1,
      -1,    -1,   406,   407,    -1,    -1,   410,   411,    -1,    -1,
      -1,   415,     5,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    -1,    36,    37,    38,    39,    40,    41,    -1,
      43,    44,    45,    -1,    47,    48,    49,    -1,    51,    52,
      -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,
      73,    -1,    75,    76,    -1,    78,    79,    80,    81,    82,
      83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,    92,
      -1,    -1,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,   106,    -1,   108,   109,    -1,   111,   112,
     113,   114,   115,   116,   117,    -1,   119,   120,   121,   122,
     123,    -1,    -1,   126,   127,   128,    -1,   130,   131,   132,
     133,    -1,   135,   136,   137,   138,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,   149,   150,    -1,   152,
      -1,   154,    -1,   156,   157,   158,    -1,    -1,    -1,   162,
     163,   164,   165,    -1,   167,   168,    -1,   170,    -1,   172,
     173,   174,   175,   176,    -1,   178,   179,   180,   181,   182,
      -1,   184,    -1,   186,   187,    -1,   189,   190,    -1,   192,
      -1,    -1,   195,    -1,   197,   198,   199,   200,   201,   202,
      -1,   204,   205,   206,   207,    -1,   209,   210,    -1,   212,
     213,   214,   215,   216,    -1,   218,    -1,    -1,   221,   222,
     223,   224,   225,   226,   227,   228,   229,    -1,   231,   232,
     233,    -1,   235,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   248,   249,   250,   251,   252,
     253,   254,   255,   256,   257,   258,   259,   260,   261,   262,
     263,   264,   265,   266,    -1,    -1,   269,   270,    -1,    -1,
     273,   274,    -1,    -1,   277,   278,   279,   280,   281,   282,
     283,    -1,   285,   286,   287,   288,    -1,   290,   291,   292,
     293,   294,   295,   296,   297,    -1,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,   317,   318,    -1,    -1,   321,   322,
     323,   324,   325,   326,   327,   328,   329,   330,   331,    -1,
     333,   334,   335,   336,   337,   338,   339,   340,   341,   342,
      -1,   344,   345,   346,   347,    -1,   349,   350,    -1,   352,
      -1,   354,   355,   356,   357,   358,   359,   360,   361,   362,
     363,    -1,   365,   366,   367,   368,   369,   370,   371,    -1,
     373,   374,   375,   376,   377,   378,   379,    -1,    -1,    -1,
     383,   384,   385,   386,   387,   388,    -1,   390,   391,   392,
     393,   394,    -1,    -1,   397,   398,   399,   400,   401,    -1,
      -1,    -1,    -1,   406,   407,   408,    -1,   410,   411,    -1,
      -1,    -1,   415,     5,     6,     7,     8,     9,    -1,    11,
      12,    -1,    14,    15,    16,    17,    -1,    19,    -1,    21,
      -1,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,    33,    34,    -1,    36,    37,    38,    39,    40,    41,
      -1,    43,    44,    45,    -1,    47,    48,    49,    -1,    51,
      52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,
      62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,
      -1,    73,    -1,    75,    76,    -1,    78,    79,    80,    81,
      82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,
      92,    -1,    -1,    95,    96,    97,    98,    99,   100,   101,
     102,   103,   104,   105,   106,    -1,   108,   109,    -1,   111,
     112,   113,   114,   115,   116,   117,    -1,   119,   120,   121,
     122,   123,    -1,    -1,   126,   127,   128,    -1,   130,   131,
     132,   133,    -1,   135,   136,   137,   138,   139,   140,   141,
     142,   143,   144,   145,   146,   147,   148,   149,   150,    -1,
     152,    -1,   154,    -1,   156,   157,   158,    -1,    -1,    -1,
     162,   163,   164,   165,    -1,   167,   168,    -1,   170,    -1,
     172,   173,   174,   175,   176,    -1,   178,   179,   180,   181,
     182,    -1,   184,    -1,   186,   187,    -1,   189,   190,    -1,
     192,    -1,    -1,   195,    -1,   197,   198,   199,   200,   201,
     202,    -1,   204,   205,   206,   207,    -1,   209,   210,    -1,
     212,   213,   214,   215,   216,    -1,   218,    -1,    -1,   221,
     222,   223,   224,   225,   226,   227,   228,   229,    -1,   231,
     232,   233,    -1,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,   249,   250,   251,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,   263,   264,   265,   266,    -1,    -1,   269,   270,    -1,
      -1,   273,   274,    -1,    -1,   277,   278,   279,   280,   281,
     282,   283,    -1,   285,   286,   287,   288,    -1,   290,   291,
     292,   293,   294,   295,   296,   297,    -1,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,   317,   318,    -1,   320,   321,
     322,   323,   324,   325,   326,   327,   328,   329,   330,   331,
      -1,   333,   334,   335,   336,   337,   338,   339,   340,   341,
     342,    -1,   344,   345,   346,   347,    -1,   349,   350,    -1,
     352,    -1,   354,   355,   356,   357,   358,   359,   360,   361,
     362,   363,    -1,   365,   366,   367,   368,   369,   370,   371,
      -1,   373,   374,   375,   376,   377,   378,   379,    -1,    -1,
      -1,   383,   384,   385,   386,   387,   388,    -1,   390,   391,
     392,   393,   394,    -1,    -1,   397,   398,   399,   400,   401,
      -1,    -1,    -1,    -1,   406,   407,    -1,    -1,   410,   411,
      -1,    -1,    -1,   415,     5,     6,     7,     8,     9,    -1,
      11,    12,    -1,    14,    15,    16,    17,    -1,    19,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,    -1,    36,    37,    38,    39,    40,
      41,    -1,    43,    44,    45,    -1,    47,    48,    49,    -1,
      51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,
      -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      71,    -1,    73,    -1,    75,    76,    -1,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    -1,    -1,    -1,
      -1,    92,    -1,    -1,    95,    96,    97,    98,    99,   100,
     101,   102,   103,   104,   105,   106,    -1,   108,   109,    -1,
     111,   112,   113,   114,   115,   116,   117,    -1,   119,   120,
     121,   122,   123,    -1,    -1,   126,   127,   128,    -1,   130,
     131,   132,   133,    -1,   135,   136,   137,   138,   139,   140,
     141,   142,   143,   144,   145,   146,   147,   148,   149,   150,
      -1,   152,    -1,   154,    -1,   156,   157,   158,    -1,    -1,
      -1,   162,   163,   164,   165,    -1,   167,   168,    -1,   170,
      -1,   172,   173,   174,   175,   176,    -1,   178,   179,   180,
     181,   182,    -1,   184,    -1,   186,   187,    -1,   189,   190,
      -1,   192,    -1,    -1,   195,    -1,   197,   198,   199,   200,
     201,   202,    -1,   204,   205,   206,   207,    -1,   209,   210,
      -1,   212,   213,   214,   215,   216,    -1,   218,    -1,    -1,
     221,   222,   223,   224,   225,   226,   227,   228,   229,    -1,
     231,   232,   233,    -1,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   248,   249,   250,
     251,   252,   253,   254,   255,   256,   257,   258,   259,   260,
     261,   262,   263,   264,   265,   266,    -1,    -1,   269,   270,
      -1,    -1,   273,   274,    -1,    -1,   277,   278,   279,   280,
     281,   282,   283,    -1,   285,   286,   287,   288,    -1,   290,
     291,   292,   293,   294,   295,   296,   297,    -1,   299,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,   317,   318,    -1,    -1,
     321,   322,   323,   324,   325,   326,   327,   328,   329,   330,
     331,    -1,   333,   334,   335,   336,   337,   338,   339,   340,
     341,   342,    -1,   344,   345,   346,   347,    -1,   349,   350,
      -1,   352,    -1,   354,   355,   356,   357,   358,   359,   360,
     361,   362,   363,    -1,   365,   366,   367,   368,   369,   370,
     371,    -1,   373,   374,   375,   376,   377,   378,   379,    -1,
      -1,    -1,   383,   384,   385,   386,   387,   388,    -1,   390,
     391,   392,   393,   394,    -1,    -1,   397,   398,   399,   400,
     401,    -1,    -1,    -1,    -1,   406,   407,    -1,    -1,   410,
     411,    -1,    -1,    -1,   415,     5,     6,     7,     8,     9,
      -1,    11,    12,    -1,    14,    15,    16,    17,    -1,    19,
      -1,    21,    -1,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    34,    -1,    36,    37,    38,    39,
      40,    41,    -1,    43,    44,    45,    -1,    47,    48,    49,
      -1,    51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,
      -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,    79,
      80,    81,    82,    83,    84,    -1,    86,    87,    -1,    -1,
      -1,    -1,    92,    -1,    -1,    95,    96,    97,    98,    99,
     100,   101,   102,   103,   104,   105,   106,    -1,   108,   109,
      -1,   111,   112,   113,   114,   115,   116,   117,    -1,   119,
     120,   121,   122,   123,    -1,    -1,   126,   127,   128,    -1,
     130,   131,   132,   133,    -1,   135,   136,   137,   138,   139,
     140,   141,   142,   143,   144,   145,   146,   147,   148,   149,
     150,    -1,   152,    -1,   154,    -1,   156,   157,   158,    -1,
      -1,    -1,   162,   163,   164,   165,    -1,   167,   168,    -1,
     170,    -1,   172,   173,   174,   175,   176,    -1,   178,   179,
     180,   181,   182,    -1,   184,    -1,   186,   187,    -1,   189,
     190,    -1,   192,    -1,    -1,   195,    -1,   197,   198,   199,
     200,   201,   202,    -1,   204,   205,   206,   207,    -1,   209,
     210,    -1,   212,   213,   214,   215,   216,    -1,   218,    -1,
      -1,   221,   222,   223,   224,   225,   226,   227,   228,   229,
      -1,   231,   232,   233,    -1,   235,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   247,   248,   249,
     250,   251,   252,   253,   254,   255,   256,   257,   258,   259,
     260,   261,   262,   263,   264,   265,   266,    -1,    -1,   269,
     270,    -1,    -1,   273,   274,    -1,    -1,   277,   278,   279,
     280,   281,   282,   283,    -1,   285,   286,   287,   288,    -1,
     290,   291,   292,   293,   294,   295,   296,   297,    -1,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,   317,   318,    -1,
      -1,   321,   322,   323,   324,   325,   326,   327,   328,   329,
     330,   331,    -1,   333,   334,   335,   336,   337,   338,   339,
     340,   341,   342,    -1,   344,   345,   346,   347,    -1,   349,
     350,    -1,   352,    -1,   354,   355,   356,   357,   358,   359,
     360,   361,   362,   363,    -1,   365,   366,   367,   368,   369,
     370,   371,    -1,   373,   374,   375,   376,   377,   378,   379,
      -1,    -1,    -1,   383,   384,   385,   386,   387,   388,    -1,
     390,   391,   392,   393,   394,    -1,    -1,   397,   398,   399,
     400,   401,    -1,    -1,    -1,    -1,   406,   407,    -1,    -1,
     410,   411,    -1,   413,    -1,   415,     5,     6,     7,     8,
       9,    -1,    11,    12,    -1,    14,    15,    16,    17,    -1,
      19,    -1,    21,    -1,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    34,    -1,    36,    37,    38,
      39,    40,    41,    -1,    43,    44,    45,    -1,    47,    48,
      49,    -1,    51,    52,    -1,    -1,    -1,    56,    57,    -1,
      -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,
      79,    80,    81,    82,    83,    84,    -1,    86,    87,    -1,
      -1,    -1,    -1,    92,    -1,    -1,    95,    96,    97,    98,
      99,   100,   101,   102,   103,   104,   105,   106,    -1,   108,
     109,    -1,   111,   112,   113,   114,   115,   116,   117,    -1,
     119,   120,   121,   122,   123,    -1,    -1,   126,   127,   128,
      -1,   130,   131,   132,   133,    -1,   135,   136,   137,   138,
     139,   140,   141,   142,   143,   144,   145,   146,   147,   148,
     149,   150,   151,   152,    -1,   154,    -1,   156,   157,   158,
      -1,    -1,    -1,   162,   163,   164,   165,    -1,   167,   168,
      -1,   170,    -1,   172,   173,   174,   175,   176,    -1,   178,
     179,   180,   181,   182,    -1,   184,    -1,   186,   187,    -1,
     189,   190,    -1,   192,    -1,    -1,   195,    -1,   197,   198,
     199,   200,   201,   202,    -1,   204,   205,   206,   207,    -1,
     209,   210,    -1,   212,   213,   214,   215,   216,    -1,   218,
      -1,    -1,   221,   222,   223,   224,   225,   226,   227,   228,
     229,    -1,   231,   232,   233,    -1,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   248,
     249,   250,   251,   252,   253,   254,   255,   256,   257,   258,
     259,   260,   261,   262,   263,   264,   265,   266,    -1,    -1,
     269,   270,    -1,    -1,   273,   274,    -1,    -1,   277,   278,
     279,   280,   281,   282,   283,    -1,   285,   286,   287,   288,
      -1,   290,   291,   292,   293,   294,   295,   296,   297,    -1,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,   317,   318,
      -1,    -1,   321,   322,   323,   324,   325,   326,   327,   328,
     329,   330,   331,    -1,   333,   334,   335,   336,   337,   338,
     339,   340,   341,   342,    -1,   344,   345,   346,   347,    -1,
     349,   350,    -1,   352,    -1,   354,   355,   356,   357,   358,
     359,   360,   361,   362,   363,    -1,   365,   366,   367,   368,
     369,   370,   371,    -1,   373,   374,   375,   376,   377,   378,
     379,    -1,    -1,    -1,   383,   384,   385,   386,   387,   388,
      -1,   390,   391,   392,   393,   394,    -1,    -1,   397,   398,
     399,   400,   401,    -1,    -1,    -1,    -1,   406,   407,    -1,
      -1,   410,   411,    -1,    -1,    -1,   415,     5,     6,     7,
       8,     9,    -1,    11,    12,    -1,    14,    15,    16,    17,
      -1,    19,    -1,    21,    -1,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    34,    -1,    36,    37,
      38,    39,    40,    41,    -1,    43,    44,    45,    -1,    47,
      48,    49,    -1,    51,    52,    -1,    -1,    -1,    56,    57,
      -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,
      78,    79,    80,    81,    82,    83,    84,    -1,    86,    87,
      -1,    -1,    -1,    -1,    92,    -1,    -1,    95,    96,    97,
      98,    99,   100,   101,   102,   103,   104,   105,   106,    -1,
     108,   109,    -1,   111,   112,   113,   114,   115,   116,   117,
      -1,   119,   120,   121,   122,   123,    -1,    -1,   126,   127,
     128,    -1,   130,   131,   132,   133,    -1,   135,   136,   137,
     138,   139,   140,   141,   142,   143,   144,   145,   146,   147,
     148,   149,   150,    -1,   152,    -1,   154,    -1,   156,   157,
     158,    -1,    -1,    -1,   162,   163,   164,   165,    -1,   167,
     168,    -1,   170,    -1,   172,   173,   174,   175,   176,    -1,
     178,   179,   180,   181,   182,    -1,   184,    -1,   186,   187,
     188,   189,   190,    -1,   192,    -1,    -1,   195,    -1,   197,
     198,   199,   200,   201,   202,    -1,   204,   205,   206,   207,
      -1,   209,   210,    -1,   212,   213,   214,   215,   216,    -1,
     218,    -1,    -1,   221,   222,   223,   224,   225,   226,   227,
     228,   229,    -1,   231,   232,   233,    -1,   235,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     248,   249,   250,   251,   252,   253,   254,   255,   256,   257,
     258,   259,   260,   261,   262,   263,   264,   265,   266,    -1,
      -1,   269,   270,    -1,    -1,   273,   274,    -1,    -1,   277,
     278,   279,   280,   281,   282,   283,    -1,   285,   286,   287,
     288,    -1,   290,   291,   292,   293,   294,   295,   296,   297,
      -1,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,   317,
     318,    -1,    -1,   321,   322,   323,   324,   325,   326,   327,
     328,   329,   330,   331,    -1,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,    -1,   344,   345,   346,   347,
      -1,   349,   350,    -1,   352,    -1,   354,   355,   356,   357,
     358,   359,   360,   361,   362,   363,    -1,   365,   366,   367,
     368,   369,   370,   371,    -1,   373,   374,   375,   376,   377,
     378,   379,    -1,    -1,    -1,   383,   384,   385,   386,   387,
     388,    -1,   390,   391,   392,   393,   394,    -1,    -1,   397,
     398,   399,   400,   401,    -1,    -1,    -1,    -1,   406,   407,
      -1,    -1,   410,   411,    -1,    -1,    -1,   415,     5,     6,
       7,     8,     9,    -1,    11,    12,    -1,    14,    15,    16,
      17,    -1,    19,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    34,    -1,    36,
      37,    38,    39,    40,    41,    -1,    43,    44,    45,    -1,
      47,    48,    49,    -1,    51,    52,    -1,    -1,    -1,    56,
      57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,
      -1,    78,    79,    80,    81,    82,    83,    84,    -1,    86,
      87,    -1,    -1,    -1,    -1,    92,    -1,    -1,    95,    96,
      97,    98,    99,   100,   101,   102,   103,   104,   105,   106,
      -1,   108,   109,    -1,   111,   112,   113,   114,   115,   116,
     117,    -1,   119,   120,   121,   122,   123,    -1,    -1,   126,
     127,   128,    -1,   130,   131,   132,   133,    -1,   135,   136,
     137,   138,   139,   140,   141,   142,   143,   144,   145,   146,
     147,   148,   149,   150,   151,   152,    -1,   154,    -1,   156,
     157,   158,    -1,    -1,    -1,   162,   163,   164,   165,    -1,
     167,   168,    -1,   170,    -1,   172,   173,   174,   175,   176,
      -1,   178,   179,   180,   181,   182,    -1,   184,    -1,   186,
     187,    -1,   189,   190,    -1,   192,    -1,    -1,   195,    -1,
     197,   198,   199,   200,   201,   202,    -1,   204,   205,   206,
     207,    -1,   209,   210,    -1,   212,   213,   214,   215,   216,
      -1,   218,    -1,    -1,   221,   222,   223,   224,   225,   226,
     227,   228,   229,    -1,   231,   232,   233,    -1,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,   253,   254,   255,   256,
     257,   258,   259,   260,   261,   262,   263,   264,   265,   266,
      -1,    -1,   269,   270,    -1,    -1,   273,   274,    -1,    -1,
     277,   278,   279,   280,   281,   282,   283,    -1,   285,   286,
     287,   288,    -1,   290,   291,   292,   293,   294,   295,   296,
     297,    -1,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
     317,   318,    -1,    -1,   321,   322,   323,   324,   325,   326,
     327,   328,   329,   330,   331,    -1,   333,   334,   335,   336,
     337,   338,   339,   340,   341,   342,    -1,   344,   345,   346,
     347,    -1,   349,   350,    -1,   352,    -1,   354,   355,   356,
     357,   358,   359,   360,   361,   362,   363,    -1,   365,   366,
     367,   368,   369,   370,   371,    -1,   373,   374,   375,   376,
     377,   378,   379,    -1,    -1,    -1,   383,   384,   385,   386,
     387,   388,    -1,   390,   391,   392,   393,   394,    -1,    -1,
     397,   398,   399,   400,   401,    -1,    -1,    -1,    -1,   406,
     407,    -1,    -1,   410,   411,    -1,    -1,    -1,   415,     5,
       6,     7,     8,     9,    -1,    11,    12,    -1,    14,    15,
      16,    17,    -1,    19,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    34,    -1,
      36,    37,    38,    39,    40,    41,    -1,    43,    44,    45,
      -1,    47,    48,    49,    -1,    51,    52,    -1,    -1,    -1,
      56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,
      76,    -1,    78,    79,    80,    81,    82,    83,    84,    -1,
      86,    87,    -1,    -1,    -1,    -1,    92,    -1,    -1,    95,
      96,    97,    98,    99,   100,   101,   102,   103,   104,   105,
     106,    -1,   108,   109,    -1,   111,   112,   113,   114,   115,
     116,   117,    -1,   119,   120,   121,   122,   123,    -1,    -1,
     126,   127,   128,    -1,   130,   131,   132,   133,    -1,   135,
     136,   137,   138,   139,   140,   141,   142,   143,   144,   145,
     146,   147,   148,   149,   150,    -1,   152,    -1,   154,    -1,
     156,   157,   158,    -1,    -1,    -1,   162,   163,   164,   165,
      -1,   167,   168,    -1,   170,    -1,   172,   173,   174,   175,
     176,    -1,   178,   179,   180,   181,   182,    -1,   184,    -1,
     186,   187,    -1,   189,   190,    -1,   192,    -1,    -1,   195,
      -1,   197,   198,   199,   200,   201,   202,    -1,   204,   205,
     206,   207,    -1,   209,   210,    -1,   212,   213,   214,   215,
     216,    -1,   218,    -1,    -1,   221,   222,   223,   224,   225,
     226,   227,   228,   229,    -1,   231,   232,   233,    -1,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   248,   249,   250,   251,   252,   253,   254,   255,
     256,   257,   258,   259,   260,   261,   262,   263,   264,   265,
     266,    -1,    -1,   269,   270,    -1,    -1,   273,   274,    -1,
      -1,   277,   278,   279,   280,   281,   282,   283,    -1,   285,
     286,   287,   288,    -1,   290,   291,   292,   293,   294,   295,
     296,   297,    -1,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,   317,   318,    -1,    -1,   321,   322,   323,   324,   325,
     326,   327,   328,   329,   330,   331,    -1,   333,   334,   335,
     336,   337,   338,   339,   340,   341,   342,    -1,   344,   345,
     346,   347,    -1,   349,   350,    -1,   352,    -1,   354,   355,
     356,   357,   358,   359,   360,   361,   362,   363,    -1,   365,
     366,   367,   368,   369,   370,   371,    -1,   373,   374,   375,
     376,   377,   378,   379,    -1,    -1,    -1,   383,   384,   385,
     386,   387,   388,    -1,   390,   391,   392,   393,   394,    -1,
      -1,   397,   398,   399,   400,   401,    -1,    -1,    -1,    -1,
     406,   407,    -1,    -1,   410,   411,    -1,    -1,    -1,   415,
       5,     6,     7,     8,     9,    -1,    11,    12,    -1,    14,
      15,    16,    17,    -1,    19,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      -1,    36,    37,    38,    39,    40,    41,    -1,    43,    44,
      45,    -1,    47,    48,    49,    -1,    51,    52,    -1,    -1,
      -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,
      75,    76,    -1,    78,    79,    80,    81,    82,    83,    84,
      -1,    86,    87,    -1,    -1,    -1,    -1,    92,    -1,    -1,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,    -1,   108,   109,    -1,   111,   112,   113,   114,
     115,   116,   117,    -1,   119,   120,   121,   122,   123,    -1,
      -1,   126,   127,   128,    -1,   130,   131,   132,   133,    -1,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,    -1,   152,    -1,   154,
      -1,   156,   157,   158,    -1,    -1,    -1,   162,   163,   164,
     165,    -1,   167,   168,    -1,   170,    -1,   172,   173,   174,
     175,   176,    -1,   178,   179,   180,   181,   182,    -1,   184,
      -1,   186,   187,    -1,   189,   190,    -1,   192,    -1,    -1,
     195,    -1,   197,   198,   199,   200,   201,   202,    -1,   204,
     205,   206,   207,    -1,   209,   210,    -1,   212,   213,   214,
     215,   216,    -1,   218,    -1,    -1,   221,   222,   223,   224,
     225,   226,   227,   228,   229,    -1,   231,   232,   233,    -1,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,    -1,   258,   259,   260,   261,   262,   263,   264,
     265,   266,    -1,    -1,   269,   270,    -1,    -1,   273,   274,
      -1,    -1,   277,   278,   279,   280,   281,   282,   283,    -1,
     285,   286,   287,   288,    -1,   290,   291,   292,   293,   294,
     295,   296,   297,    -1,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,    -1,    -1,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,    -1,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,    -1,   344,
     345,   346,   347,    -1,   349,   350,    -1,   352,    -1,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,    -1,
      -1,   366,   367,   368,   369,   370,   371,    -1,   373,   374,
     375,   376,   377,   378,   379,    -1,    -1,    -1,   383,   384,
     385,   386,   387,   388,    -1,   390,   391,   392,   393,   394,
      -1,    -1,   397,   398,   399,   400,   401,    -1,    -1,    -1,
      -1,    -1,   407,    -1,    -1,   410,   411,    -1,    -1,    -1,
     415,     5,     6,     7,     8,     9,    -1,    11,    12,    -1,
      14,    15,    16,    17,    -1,    19,    -1,    21,    -1,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      34,    -1,    36,    37,    38,    39,    40,    41,    -1,    43,
      44,    45,    -1,    47,    48,    49,    -1,    51,    52,    -1,
      -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,
      -1,    75,    76,    -1,    78,    79,    80,    81,    82,    83,
      84,    -1,    86,    87,    -1,    -1,    -1,    -1,    92,    -1,
      -1,    95,    96,    97,    98,    99,   100,   101,    -1,   103,
     104,   105,   106,    -1,   108,   109,    -1,   111,   112,   113,
     114,   115,   116,   117,    -1,   119,   120,   121,   122,   123,
      -1,    -1,   126,   127,   128,    -1,   130,   131,   132,   133,
      -1,   135,   136,   137,   138,   139,   140,   141,   142,   143,
     144,   145,   146,   147,   148,   149,   150,    -1,   152,    -1,
     154,    -1,   156,   157,   158,    -1,    -1,    -1,   162,   163,
     164,   165,    -1,   167,   168,    -1,    -1,    -1,   172,   173,
     174,   175,   176,    -1,   178,   179,   180,   181,   182,    -1,
     184,    -1,   186,   187,    -1,   189,   190,    -1,   192,    -1,
      -1,   195,    -1,   197,   198,    -1,   200,   201,   202,    -1,
     204,   205,   206,   207,    -1,   209,   210,    -1,   212,   213,
     214,   215,   216,    -1,   218,    -1,    -1,   221,   222,   223,
     224,   225,   226,   227,   228,   229,    -1,   231,   232,    -1,
      -1,   235,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   247,   248,   249,   250,   251,   252,   253,
     254,   255,   256,    -1,   258,   259,   260,   261,   262,   263,
     264,   265,   266,    -1,    -1,   269,   270,    -1,    -1,   273,
     274,    -1,    -1,   277,   278,   279,   280,   281,   282,   283,
      -1,   285,   286,   287,   288,    -1,   290,   291,   292,   293,
     294,   295,   296,   297,    -1,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,   317,   318,    -1,    -1,   321,   322,   323,
     324,   325,   326,   327,   328,    -1,   330,   331,    -1,   333,
     334,   335,   336,   337,   338,   339,   340,   341,   342,    -1,
     344,   345,   346,   347,    -1,   349,   350,    -1,   352,    -1,
     354,   355,   356,   357,   358,   359,   360,   361,   362,   363,
      -1,   365,   366,   367,   368,   369,   370,   371,    -1,   373,
     374,   375,   376,   377,   378,   379,    -1,    -1,    -1,   383,
     384,   385,   386,   387,   388,    -1,   390,   391,   392,   393,
     394,    -1,    -1,   397,   398,   399,   400,   401,    -1,    -1,
      -1,    -1,   406,   407,    -1,    -1,   410,   411,    -1,    -1,
      -1,   415,     5,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    -1,    36,    37,    38,    39,    40,    41,    -1,
      43,    44,    45,    -1,    47,    48,    49,    -1,    51,    52,
      -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,
      73,    -1,    75,    76,    -1,    78,    79,    80,    81,    82,
      83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,    92,
      -1,    -1,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,   106,    -1,   108,   109,    -1,   111,   112,
     113,   114,   115,   116,   117,    -1,   119,   120,   121,   122,
     123,    -1,    -1,   126,   127,   128,    -1,   130,   131,   132,
     133,    -1,   135,   136,   137,   138,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,   149,   150,    -1,   152,
      -1,   154,    -1,   156,   157,   158,    -1,    -1,    -1,   162,
     163,   164,   165,    -1,   167,   168,    -1,   170,    -1,   172,
     173,   174,   175,   176,    -1,   178,   179,   180,   181,   182,
      -1,   184,    -1,   186,   187,    -1,   189,   190,    -1,   192,
      -1,    -1,   195,    -1,   197,   198,   199,   200,   201,   202,
      -1,   204,   205,   206,   207,    -1,   209,   210,    -1,   212,
     213,   214,   215,   216,    -1,   218,    -1,    -1,   221,   222,
     223,   224,   225,   226,   227,   228,   229,    -1,   231,   232,
     233,    -1,   235,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   248,   249,   250,   251,   252,
     253,   254,   255,   256,    -1,   258,   259,   260,   261,   262,
     263,   264,   265,   266,    -1,    -1,   269,   270,    -1,    -1,
     273,   274,    -1,    -1,   277,   278,   279,   280,   281,   282,
     283,    -1,   285,   286,   287,   288,    -1,   290,   291,   292,
     293,   294,   295,   296,   297,    -1,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,   317,   318,    -1,    -1,   321,   322,
     323,   324,   325,   326,   327,   328,   329,   330,   331,    -1,
     333,   334,   335,   336,   337,   338,   339,   340,   341,   342,
      -1,   344,   345,   346,   347,    -1,   349,   350,    -1,   352,
      -1,   354,   355,   356,   357,   358,   359,   360,   361,   362,
     363,    -1,    -1,   366,   367,   368,   369,   370,   371,    -1,
     373,   374,   375,   376,   377,   378,   379,    -1,    -1,    -1,
     383,   384,   385,   386,   387,   388,    -1,   390,   391,    -1,
     393,   394,    -1,    -1,   397,   398,   399,   400,   401,     5,
       6,     7,     8,     9,    -1,    11,    12,    -1,    14,    15,
      16,    17,   415,    19,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    34,    -1,
      36,    37,    38,    39,    40,    41,    -1,    43,    44,    45,
      -1,    47,    48,    49,    -1,    51,    52,    -1,    -1,    -1,
      56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,
      76,    -1,    78,    79,    80,    81,    82,    83,    84,    -1,
      86,    87,    -1,    -1,    -1,    -1,    92,    -1,    -1,    95,
      96,    97,    98,    99,   100,   101,    -1,   103,   104,   105,
     106,    -1,   108,   109,    -1,   111,   112,   113,   114,   115,
     116,   117,    -1,   119,   120,   121,   122,   123,    -1,    -1,
     126,   127,   128,    -1,   130,   131,   132,   133,    -1,   135,
     136,   137,   138,   139,   140,   141,   142,   143,   144,   145,
     146,   147,   148,   149,   150,    -1,   152,    -1,   154,    -1,
     156,   157,   158,    -1,    -1,    -1,   162,   163,   164,   165,
      -1,   167,   168,    -1,    -1,    -1,   172,   173,   174,   175,
     176,    -1,   178,   179,   180,   181,   182,    -1,   184,    -1,
     186,   187,    -1,   189,   190,    -1,   192,    -1,    -1,   195,
      -1,   197,   198,    -1,   200,   201,   202,    -1,   204,   205,
     206,   207,    -1,   209,   210,    -1,   212,   213,   214,   215,
     216,    -1,   218,    -1,    -1,   221,   222,   223,   224,   225,
     226,   227,   228,   229,    -1,   231,   232,    -1,    -1,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   248,   249,   250,   251,   252,   253,   254,   255,
     256,    -1,   258,   259,   260,   261,   262,   263,   264,   265,
     266,    -1,    -1,   269,   270,    -1,    -1,    -1,   274,    -1,
      -1,   277,   278,   279,   280,   281,   282,   283,    -1,   285,
     286,   287,   288,    -1,   290,   291,   292,   293,   294,   295,
     296,   297,    -1,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,   317,   318,    -1,    -1,   321,   322,   323,   324,   325,
     326,   327,   328,    -1,   330,   331,    -1,   333,   334,   335,
     336,   337,   338,   339,   340,   341,   342,    -1,   344,   345,
     346,   347,    -1,   349,   350,    -1,   352,    -1,   354,   355,
     356,   357,   358,   359,   360,   361,   362,   363,    -1,    -1,
     366,   367,   368,   369,   370,   371,    -1,   373,   374,   375,
     376,   377,   378,   379,    -1,    -1,    -1,   383,   384,   385,
     386,   387,   388,    -1,   390,   391,    -1,   393,   394,    -1,
      -1,   397,   398,   399,   400,   401,    -1,    -1,    -1,    -1,
      -1,   407,    -1,    -1,   410,   411,    -1,    -1,    -1,   415,
       5,     6,     7,     8,     9,    -1,    11,    12,    -1,    14,
      15,    16,    17,    -1,    19,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      -1,    36,    37,    38,    39,    40,    41,    -1,    43,    44,
      45,    -1,    47,    48,    49,    -1,    51,    52,    -1,    -1,
      -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,
      75,    76,    -1,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    -1,    -1,    -1,    91,    92,    -1,    -1,
      95,    96,    97,    98,    99,   100,   101,    -1,   103,   104,
     105,   106,    -1,   108,   109,    -1,   111,   112,   113,   114,
     115,   116,   117,    -1,   119,   120,   121,   122,   123,    -1,
      -1,   126,   127,   128,    -1,   130,   131,   132,   133,    -1,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,    -1,   152,    -1,   154,
      -1,   156,   157,   158,    -1,    -1,    -1,   162,   163,   164,
     165,    -1,   167,   168,    -1,    -1,    -1,   172,   173,   174,
     175,   176,    -1,   178,   179,   180,   181,   182,    -1,   184,
      -1,   186,   187,    -1,   189,   190,    -1,   192,    -1,    -1,
     195,    -1,   197,   198,    -1,   200,   201,   202,    -1,   204,
     205,   206,   207,    -1,   209,   210,    -1,   212,   213,   214,
     215,   216,    -1,   218,    -1,    -1,    -1,    -1,   223,   224,
     225,   226,   227,   228,   229,    -1,   231,   232,    -1,    -1,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,    -1,   258,   259,    -1,   261,   262,   263,   264,
     265,   266,    -1,    -1,   269,   270,    -1,    -1,    -1,   274,
      -1,    -1,   277,   278,   279,   280,   281,   282,   283,    -1,
     285,   286,   287,   288,    -1,   290,   291,   292,   293,   294,
     295,   296,   297,    -1,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,    -1,    -1,   321,   322,   323,   324,
     325,   326,   327,   328,    -1,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,    -1,   344,
     345,   346,   347,    -1,   349,   350,    -1,   352,    -1,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,    -1,
     365,   366,   367,   368,   369,   370,   371,    -1,   373,   374,
     375,   376,   377,   378,   379,    -1,    -1,    -1,   383,   384,
     385,   386,   387,   388,    -1,   390,   391,    -1,   393,   394,
      -1,    -1,   397,   398,   399,   400,   401,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   411,    -1,    -1,    -1,
     415,     5,     6,     7,     8,     9,    -1,    11,    12,    -1,
      14,    15,    16,    17,    -1,    19,    -1,    21,    -1,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      34,    -1,    36,    37,    38,    39,    40,    41,    -1,    43,
      44,    45,    -1,    47,    48,    49,    -1,    51,    52,    -1,
      -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,
      -1,    75,    76,    -1,    78,    79,    80,    81,    82,    83,
      84,    85,    86,    87,    -1,    -1,    -1,    91,    92,    -1,
      -1,    95,    96,    97,    98,    99,   100,   101,    -1,   103,
     104,   105,   106,    -1,   108,   109,    -1,   111,   112,   113,
     114,   115,   116,   117,    -1,   119,   120,   121,   122,   123,
      -1,    -1,   126,   127,   128,    -1,   130,   131,   132,   133,
      -1,   135,   136,   137,   138,   139,   140,   141,   142,   143,
     144,   145,   146,   147,   148,   149,   150,    -1,   152,    -1,
     154,    -1,   156,   157,   158,    -1,    -1,    -1,   162,   163,
     164,   165,    -1,   167,   168,    -1,    -1,    -1,   172,   173,
     174,   175,   176,    -1,   178,   179,   180,   181,   182,    -1,
     184,    -1,   186,   187,    -1,   189,   190,    -1,   192,    -1,
      -1,   195,    -1,   197,   198,    -1,   200,   201,   202,    -1,
     204,   205,   206,   207,    -1,   209,   210,    -1,   212,   213,
     214,   215,   216,    -1,   218,    -1,    -1,    -1,    -1,   223,
     224,   225,   226,   227,   228,   229,    -1,   231,   232,    -1,
      -1,   235,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   247,   248,   249,   250,   251,   252,   253,
     254,   255,   256,    -1,   258,   259,    -1,   261,   262,   263,
     264,   265,   266,    -1,    -1,   269,   270,    -1,    -1,    -1,
     274,    -1,    -1,   277,   278,   279,   280,   281,   282,   283,
      -1,   285,   286,   287,   288,    -1,   290,   291,   292,   293,
     294,   295,   296,   297,    -1,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,   317,   318,    -1,    -1,   321,   322,   323,
     324,   325,   326,   327,   328,    -1,   330,   331,   332,   333,
     334,   335,   336,   337,   338,   339,   340,   341,   342,    -1,
     344,   345,   346,   347,    -1,   349,   350,    -1,   352,    -1,
     354,   355,   356,   357,   358,   359,   360,   361,   362,   363,
      -1,   365,   366,   367,   368,   369,   370,   371,    -1,   373,
     374,   375,   376,   377,   378,   379,    -1,    -1,    -1,   383,
     384,   385,   386,   387,   388,    -1,   390,   391,    -1,   393,
     394,    -1,    -1,   397,   398,   399,   400,   401,     5,     6,
       7,     8,     9,    -1,    11,    12,    -1,    14,    15,    16,
      17,   415,    19,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    34,    -1,    36,
      37,    38,    39,    40,    41,    -1,    43,    44,    45,    -1,
      47,    48,    49,    -1,    51,    52,    -1,    -1,    -1,    56,
      57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,
      -1,    78,    79,    80,    81,    82,    83,    84,    -1,    86,
      87,    -1,    -1,    -1,    -1,    92,    -1,    -1,    95,    96,
      97,    98,    99,   100,   101,    -1,   103,   104,   105,   106,
      -1,   108,   109,    -1,   111,   112,   113,   114,   115,   116,
     117,    -1,   119,   120,   121,   122,   123,    -1,    -1,   126,
     127,   128,    -1,   130,   131,   132,   133,    -1,   135,   136,
     137,   138,   139,   140,   141,   142,   143,   144,   145,   146,
     147,   148,   149,   150,    -1,   152,    -1,   154,    -1,   156,
     157,   158,    -1,    -1,    -1,   162,   163,   164,   165,    -1,
     167,   168,    -1,    -1,    -1,   172,   173,   174,   175,   176,
      -1,   178,   179,   180,   181,   182,    -1,   184,    -1,   186,
     187,    -1,   189,   190,    -1,   192,    -1,    -1,   195,    -1,
     197,   198,    -1,   200,   201,   202,    -1,   204,   205,   206,
     207,    -1,   209,   210,    -1,   212,   213,   214,   215,   216,
      -1,   218,    -1,    -1,    -1,    -1,   223,   224,   225,   226,
     227,   228,   229,    -1,   231,   232,    -1,    -1,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,   253,   254,   255,   256,
      -1,   258,   259,    -1,   261,    -1,   263,   264,   265,   266,
      -1,    -1,   269,   270,    -1,    -1,    -1,   274,    -1,    -1,
     277,   278,   279,   280,   281,   282,   283,    -1,   285,   286,
     287,   288,    -1,   290,   291,   292,   293,   294,   295,   296,
     297,    -1,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
     317,   318,    -1,    -1,   321,   322,   323,   324,   325,   326,
     327,   328,    -1,   330,   331,    -1,   333,   334,   335,   336,
     337,   338,   339,   340,   341,   342,    -1,   344,   345,   346,
     347,    -1,   349,   350,    -1,   352,    -1,   354,   355,   356,
     357,   358,   359,   360,   361,   362,   363,    -1,    -1,   366,
     367,   368,   369,   370,   371,    -1,   373,   374,   375,   376,
     377,   378,   379,    -1,    -1,    -1,   383,   384,   385,   386,
     387,   388,    -1,   390,   391,    -1,   393,   394,    -1,    -1,
     397,   398,   399,   400,   401,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   411,    -1,    -1,    -1,   415,     5,
       6,     7,     8,     9,    -1,    11,    12,    -1,    14,    15,
      16,    17,    -1,    19,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    34,    -1,
      36,    37,    38,    39,    40,    41,    -1,    43,    44,    45,
      -1,    47,    48,    49,    -1,    51,    52,    -1,    -1,    -1,
      56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,
      76,    -1,    78,    79,    80,    81,    82,    83,    84,    -1,
      86,    87,    -1,    -1,    -1,    -1,    92,    -1,    -1,    95,
      96,    97,    98,    99,   100,   101,    -1,   103,   104,   105,
     106,    -1,   108,   109,    -1,   111,   112,   113,   114,   115,
     116,   117,    -1,   119,   120,   121,   122,   123,    -1,    -1,
     126,   127,   128,    -1,   130,   131,   132,   133,    -1,   135,
     136,   137,   138,   139,   140,   141,   142,   143,   144,   145,
     146,   147,   148,   149,   150,    -1,   152,    -1,   154,    -1,
     156,   157,   158,    -1,    -1,    -1,   162,   163,   164,   165,
      -1,   167,   168,    -1,    -1,    -1,   172,   173,   174,   175,
     176,    -1,   178,   179,   180,   181,   182,    -1,   184,    -1,
     186,   187,    -1,   189,   190,    -1,   192,    -1,    -1,   195,
      -1,   197,   198,    -1,   200,   201,   202,    -1,   204,   205,
     206,   207,    -1,   209,   210,    -1,   212,   213,   214,   215,
     216,    -1,   218,    -1,    -1,    -1,    -1,   223,   224,   225,
     226,   227,   228,   229,    -1,   231,   232,    -1,    -1,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   248,   249,   250,   251,   252,   253,   254,   255,
     256,    -1,   258,   259,    -1,   261,    -1,   263,   264,   265,
     266,    -1,    -1,   269,   270,    -1,    -1,    -1,   274,    -1,
      -1,   277,   278,   279,   280,   281,   282,   283,    -1,   285,
     286,   287,   288,    -1,   290,   291,   292,   293,   294,   295,
     296,   297,    -1,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,   317,   318,    -1,    -1,   321,   322,   323,   324,   325,
     326,   327,   328,    -1,   330,   331,    -1,   333,   334,   335,
     336,   337,   338,   339,   340,   341,   342,    -1,   344,   345,
     346,   347,    -1,   349,   350,    -1,   352,    -1,   354,   355,
     356,   357,   358,   359,   360,   361,   362,   363,    -1,    -1,
     366,   367,   368,   369,   370,   371,    -1,   373,   374,   375,
     376,   377,   378,   379,    -1,    -1,    -1,   383,   384,   385,
     386,   387,   388,    -1,   390,   391,    -1,   393,   394,    -1,
      -1,   397,   398,   399,   400,   401,    -1,     6,     7,     8,
       9,    -1,    11,    12,    -1,    14,    15,    16,    17,   415,
      19,    -1,    21,    -1,    23,    24,    25,    26,    27,    28,
      -1,    30,    31,    32,    33,    -1,    -1,    36,    37,    38,
      39,    -1,    -1,    -1,    43,    44,    45,    -1,    47,    -1,
      -1,    -1,    51,    52,    -1,    -1,    -1,    56,    57,    -1,
      -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,
      79,    80,    81,    82,    83,    84,    -1,    86,    87,    -1,
      -1,    -1,    -1,    -1,    93,    -1,    95,    96,    97,    -1,
      99,   100,   101,    -1,   103,    -1,   105,    -1,    -1,   108,
     109,    -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,
     119,   120,   121,   122,   123,    -1,    -1,   126,   127,   128,
      -1,   130,   131,   132,   133,    -1,   135,   136,    -1,   138,
      -1,    -1,    -1,    -1,   143,   144,   145,   146,   147,   148,
     149,   150,    -1,   152,    -1,   154,    -1,   156,   157,   158,
      -1,    -1,    -1,   162,   163,   164,   165,    -1,   167,   168,
      -1,   170,   171,   172,   173,   174,   175,   176,    -1,   178,
      -1,   180,   181,   182,   183,   184,    -1,   186,    -1,    -1,
      -1,   190,    -1,   192,    -1,    -1,   195,    -1,   197,   198,
      -1,   200,   201,   202,    -1,   204,   205,   206,   207,    -1,
      -1,   210,    -1,   212,   213,   214,    -1,   216,   217,   218,
      -1,    -1,    -1,    -1,   223,    -1,   225,   226,   227,   228,
     229,    -1,    -1,   232,    -1,   234,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   248,
      -1,   250,    -1,   252,   253,   254,   255,   256,    -1,   258,
     259,    -1,   261,    -1,   263,   264,   265,   266,    -1,   268,
     269,    -1,    -1,    -1,   273,   274,    -1,   276,   277,    -1,
      -1,   280,   281,   282,   283,    -1,   285,   286,   287,   288,
      -1,   290,   291,   292,   293,   294,   295,   296,   297,    -1,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,    -1,   311,   312,   313,   314,   315,   316,   317,   318,
      -1,    -1,   321,   322,   323,    -1,   325,   326,   327,   328,
      -1,   330,   331,    -1,   333,   334,   335,   336,   337,   338,
     339,   340,   341,   342,    -1,   344,   345,   346,   347,    -1,
     349,   350,    -1,   352,    -1,   354,   355,   356,   357,    -1,
     359,   360,   361,   362,   363,   364,    -1,   366,   367,   368,
     369,   370,    -1,    -1,   373,   374,   375,   376,   377,    -1,
     379,    -1,    -1,     5,   383,   384,   385,   386,   387,   388,
      -1,   390,    -1,    -1,   393,    -1,    -1,    -1,    20,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    29,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   416,    40,    41,
      -1,    -1,    -1,    -1,    -1,    -1,    48,    49,    -1,    -1,
      -1,    53,    54,    55,    56,    57,    58,    59,    60,    61,
      62,    63,    64,    65,    66,    67,    68,    69,    70,    71,
      72,    73,    74,    75,    76,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   115,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     182,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   198,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   215,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     242,    -1,    -1,   245,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     262,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   318,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   364,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   376,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   387,    -1,    -1,   390,   391,
      -1,   393,    -1,    -1,    -1,    -1,    -1,   399,    -1,   401,
     402,    -1,    -1,    -1,   406,   407,   408,   409,   410,    -1,
      -1,   413,   414,   415,     6,     7,     8,     9,    -1,    11,
      12,    -1,    14,    15,    16,    17,    -1,    19,    -1,    21,
      -1,    23,    24,    25,    26,    27,    28,    -1,    30,    31,
      32,    33,    -1,    -1,    36,    37,    38,    39,    -1,    -1,
      -1,    43,    44,    45,    -1,    47,    -1,    -1,    -1,    51,
      52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,
      62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,
      -1,    73,    -1,    75,    76,    -1,    78,    79,    80,    81,
      82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    96,    97,    98,    99,   100,   101,
     102,   103,   104,   105,    -1,    -1,   108,   109,    -1,   111,
      -1,   113,   114,   115,   116,   117,    -1,   119,   120,   121,
     122,   123,    -1,    -1,   126,   127,   128,    -1,   130,   131,
     132,   133,    -1,   135,   136,   137,   138,   139,   140,   141,
     142,   143,   144,   145,   146,   147,   148,   149,   150,    -1,
     152,    -1,   154,    -1,   156,   157,   158,    -1,    -1,    -1,
     162,   163,   164,   165,    -1,   167,   168,    -1,   170,    -1,
     172,   173,   174,   175,   176,    -1,   178,    -1,   180,   181,
     182,    -1,   184,    -1,   186,   187,    -1,   189,   190,    -1,
     192,    -1,    -1,   195,    -1,   197,   198,   199,   200,   201,
     202,    -1,   204,   205,   206,   207,    -1,   209,   210,    -1,
     212,   213,   214,    -1,   216,    -1,   218,    -1,    -1,   221,
     222,   223,   224,   225,   226,   227,   228,   229,    -1,   231,
     232,   233,    -1,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,   249,   250,   251,
     252,   253,   254,   255,   256,    -1,   258,   259,   260,   261,
      -1,   263,   264,   265,   266,    -1,    -1,   269,   270,    -1,
     272,   273,   274,    -1,    -1,   277,   278,   279,   280,   281,
     282,   283,    -1,   285,   286,   287,   288,    -1,   290,   291,
     292,   293,   294,   295,   296,   297,    -1,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,   317,   318,    -1,   320,   321,
     322,   323,   324,   325,   326,   327,   328,   329,   330,   331,
      -1,   333,   334,   335,   336,   337,   338,   339,   340,   341,
     342,    -1,   344,   345,   346,   347,    -1,   349,   350,    -1,
     352,    -1,   354,   355,   356,   357,    -1,   359,   360,   361,
     362,   363,    -1,    -1,   366,   367,   368,   369,   370,   371,
      -1,   373,   374,   375,   376,   377,   378,   379,    -1,    -1,
      -1,   383,   384,   385,   386,   387,   388,    -1,   390,    -1,
      -1,   393,    -1,    -1,    -1,    -1,    -1,     6,     7,     8,
       9,    -1,    11,    12,    -1,    14,    15,    16,    17,    -1,
      19,    -1,    21,   415,    23,    24,    25,    26,    27,    28,
      -1,    30,    31,    32,    33,    -1,    -1,    36,    37,    38,
      39,    -1,    -1,    -1,    43,    44,    45,    -1,    47,    -1,
      -1,    -1,    51,    52,    -1,    -1,    -1,    56,    57,    -1,
      -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,
      79,    80,    81,    82,    83,    84,    -1,    86,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,    98,
      99,   100,   101,   102,   103,   104,   105,    -1,    -1,   108,
     109,    -1,   111,    -1,   113,   114,   115,   116,   117,    -1,
     119,   120,   121,   122,   123,    -1,    -1,   126,   127,   128,
      -1,   130,   131,   132,   133,    -1,   135,   136,   137,   138,
     139,   140,   141,   142,   143,   144,   145,   146,   147,   148,
     149,   150,    -1,   152,    -1,   154,    -1,   156,   157,   158,
      -1,    -1,    -1,   162,   163,   164,   165,    -1,   167,   168,
      -1,   170,    -1,   172,   173,   174,   175,   176,    -1,   178,
      -1,   180,   181,   182,    -1,   184,    -1,   186,   187,    -1,
     189,   190,    -1,   192,    -1,    -1,   195,    -1,   197,   198,
     199,   200,   201,   202,    -1,   204,   205,   206,   207,    -1,
     209,   210,    -1,   212,   213,   214,    -1,   216,    -1,   218,
      -1,    -1,   221,   222,   223,   224,   225,   226,   227,   228,
     229,    -1,   231,   232,   233,    -1,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   248,
     249,   250,   251,   252,   253,   254,   255,   256,    -1,   258,
     259,   260,   261,    -1,   263,   264,   265,   266,    -1,    -1,
     269,   270,    -1,   272,   273,   274,    -1,    -1,   277,   278,
     279,   280,   281,   282,   283,    -1,   285,   286,   287,   288,
      -1,   290,   291,   292,   293,   294,   295,   296,   297,    -1,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,   317,   318,
      -1,    -1,   321,   322,   323,   324,   325,   326,   327,   328,
     329,   330,   331,    -1,   333,   334,   335,   336,   337,   338,
     339,   340,   341,   342,    -1,   344,   345,   346,   347,    -1,
     349,   350,    -1,   352,    -1,   354,   355,   356,   357,    -1,
     359,   360,   361,   362,   363,    -1,    -1,   366,   367,   368,
     369,   370,   371,    -1,   373,   374,   375,   376,   377,   378,
     379,    -1,    -1,    -1,   383,   384,   385,   386,   387,   388,
      -1,   390,    -1,    -1,   393,    -1,    -1,    -1,    -1,    -1,
       6,     7,     8,     9,    -1,    11,    12,    -1,    14,    15,
      16,    17,    -1,    19,    -1,    21,   415,    23,    24,    25,
      26,    27,    28,    -1,    30,    31,    32,    33,    -1,    -1,
      36,    37,    38,    39,    -1,    -1,    -1,    43,    44,    45,
      -1,    47,    -1,    -1,    -1,    51,    52,    -1,    -1,    -1,
      56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,
      76,    -1,    78,    79,    80,    81,    82,    83,    84,    -1,
      86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      96,    97,    98,    99,   100,   101,   102,   103,   104,   105,
      -1,    -1,   108,   109,    -1,   111,    -1,   113,   114,   115,
     116,   117,    -1,   119,   120,   121,   122,   123,    -1,    -1,
     126,   127,   128,    -1,   130,   131,   132,   133,    -1,   135,
     136,   137,   138,   139,   140,   141,   142,   143,   144,   145,
     146,   147,   148,   149,   150,    -1,   152,    -1,   154,    -1,
     156,   157,   158,    -1,    -1,    -1,   162,   163,   164,   165,
      -1,   167,   168,    -1,   170,    -1,   172,   173,   174,   175,
     176,    -1,   178,    -1,   180,   181,   182,    -1,   184,    -1,
     186,   187,    -1,   189,   190,    -1,   192,    -1,    -1,   195,
      -1,   197,   198,   199,   200,   201,   202,    -1,   204,   205,
     206,   207,    -1,   209,   210,    -1,   212,   213,   214,    -1,
     216,    -1,   218,    -1,    -1,   221,   222,   223,   224,   225,
     226,   227,   228,   229,    -1,   231,   232,   233,    -1,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   248,   249,   250,   251,   252,   253,   254,   255,
     256,    -1,   258,   259,   260,   261,    -1,   263,   264,   265,
     266,    -1,    -1,   269,   270,    -1,    -1,   273,   274,    -1,
      -1,   277,   278,   279,   280,   281,   282,   283,    -1,   285,
     286,   287,   288,    -1,   290,   291,   292,   293,   294,   295,
     296,   297,    -1,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,   317,   318,    -1,    -1,   321,   322,   323,   324,   325,
     326,   327,   328,   329,   330,   331,    -1,   333,   334,   335,
     336,   337,   338,   339,   340,   341,   342,    -1,   344,   345,
     346,   347,    -1,   349,   350,    -1,   352,    -1,   354,   355,
     356,   357,    -1,   359,   360,   361,   362,   363,    -1,    -1,
     366,   367,   368,   369,   370,   371,    -1,   373,   374,   375,
     376,   377,   378,   379,    -1,    -1,    -1,   383,   384,   385,
     386,   387,   388,    -1,   390,    -1,    -1,   393,    -1,    -1,
      -1,    -1,    -1,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    -1,    21,   415,
      23,    24,    25,    26,    27,    28,    -1,    30,    31,    32,
      33,    -1,    -1,    36,    37,    38,    39,    -1,    -1,    -1,
      43,    44,    45,    -1,    47,    -1,    -1,    -1,    51,    52,
      -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,
      73,    -1,    75,    76,    -1,    78,    79,    80,    81,    82,
      83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    95,    96,    97,    -1,    99,   100,   101,    -1,
     103,    -1,   105,    -1,    -1,   108,   109,    -1,   111,    -1,
      -1,   114,   115,   116,   117,    -1,   119,   120,   121,   122,
     123,    -1,    -1,   126,   127,   128,    -1,   130,   131,   132,
     133,    -1,   135,   136,    -1,   138,    -1,    -1,    -1,    -1,
     143,   144,   145,   146,   147,   148,   149,   150,    -1,   152,
      -1,   154,    -1,   156,   157,   158,    -1,    -1,    -1,   162,
     163,   164,   165,    -1,   167,   168,    -1,   170,    -1,   172,
     173,   174,   175,   176,    -1,   178,    -1,   180,   181,   182,
      -1,   184,    -1,   186,    -1,    -1,    -1,   190,    -1,   192,
      -1,    -1,   195,    -1,   197,   198,    -1,   200,   201,   202,
      -1,   204,   205,   206,   207,    -1,    -1,   210,    -1,   212,
     213,   214,    -1,   216,    -1,   218,    -1,    -1,    -1,    -1,
     223,    -1,   225,   226,   227,   228,   229,    -1,    -1,   232,
      -1,    -1,   235,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   248,    -1,   250,    -1,   252,
     253,   254,   255,   256,    -1,   258,   259,    -1,   261,    -1,
     263,   264,   265,   266,    -1,    -1,   269,    -1,    -1,    -1,
     273,   274,    -1,    -1,   277,    -1,    -1,   280,   281,   282,
     283,    -1,   285,   286,   287,   288,    -1,   290,   291,   292,
     293,   294,   295,   296,   297,    -1,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,    -1,   311,   312,
     313,   314,   315,   316,   317,   318,    -1,    -1,   321,   322,
     323,    -1,   325,   326,   327,   328,    -1,   330,   331,    -1,
     333,   334,   335,   336,   337,   338,   339,   340,   341,   342,
      -1,   344,   345,   346,   347,    -1,   349,   350,    -1,   352,
      -1,   354,   355,   356,   357,    -1,   359,   360,   361,   362,
     363,    -1,    -1,   366,   367,   368,   369,   370,    -1,    -1,
     373,   374,   375,   376,   377,    -1,   379,    -1,    -1,    -1,
     383,   384,   385,   386,   387,   388,    -1,   390,   391,    -1,
     393,   394,    -1,    -1,    -1,    -1,   399,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   414,   415,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    -1,    30,    31,    32,
      33,    -1,    -1,    36,    37,    38,    39,    -1,    -1,    -1,
      43,    44,    45,    -1,    47,    -1,    -1,    -1,    51,    52,
      -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,
      73,    -1,    75,    76,    -1,    78,    79,    80,    81,    82,
      83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    95,    96,    97,    -1,    99,   100,   101,    -1,
     103,    -1,   105,    -1,    -1,   108,   109,    -1,   111,    -1,
      -1,   114,   115,   116,   117,    -1,   119,   120,   121,   122,
     123,    -1,    -1,   126,   127,   128,    -1,   130,   131,   132,
     133,    -1,   135,   136,    -1,   138,    -1,    -1,    -1,    -1,
     143,   144,   145,   146,   147,   148,   149,   150,    -1,   152,
      -1,   154,    -1,   156,   157,   158,    -1,    -1,    -1,   162,
     163,   164,   165,    -1,   167,   168,    -1,   170,    -1,   172,
     173,   174,   175,   176,    -1,   178,    -1,   180,   181,   182,
      -1,   184,    -1,   186,    -1,    -1,    -1,   190,    -1,   192,
      -1,    -1,   195,    -1,   197,   198,    -1,   200,   201,   202,
      -1,   204,   205,   206,   207,    -1,    -1,   210,    -1,   212,
     213,   214,    -1,   216,    -1,   218,    -1,    -1,    -1,    -1,
     223,    -1,   225,   226,   227,   228,   229,    -1,    -1,   232,
      -1,    -1,   235,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   248,    -1,   250,    -1,   252,
     253,   254,   255,   256,    -1,   258,   259,    -1,   261,    -1,
     263,   264,   265,   266,    -1,    -1,   269,    -1,    -1,    -1,
     273,   274,    -1,    -1,   277,    -1,    -1,   280,   281,   282,
     283,    -1,   285,   286,   287,   288,    -1,   290,   291,   292,
     293,   294,   295,   296,   297,    -1,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,    -1,   311,   312,
     313,   314,   315,   316,   317,   318,    -1,    -1,   321,   322,
     323,    -1,   325,   326,   327,   328,    -1,   330,   331,    -1,
     333,   334,   335,   336,   337,   338,   339,   340,   341,   342,
      -1,   344,   345,   346,   347,    -1,   349,   350,    -1,   352,
      -1,   354,   355,   356,   357,    -1,   359,   360,   361,   362,
     363,    -1,    -1,   366,   367,   368,   369,   370,    -1,    -1,
     373,   374,   375,   376,   377,    -1,   379,    -1,    -1,    -1,
     383,   384,   385,   386,   387,   388,    -1,   390,   391,    -1,
     393,   394,    -1,    -1,    -1,    -1,   399,    -1,     6,     7,
       8,     9,    -1,    11,    12,    -1,    14,    15,    16,    17,
      -1,    19,   415,    21,    -1,    23,    24,    25,    26,    27,
      28,    -1,    30,    31,    32,    33,    -1,    -1,    36,    37,
      38,    39,    -1,    -1,    -1,    43,    44,    45,    -1,    47,
      -1,    -1,    -1,    51,    52,    -1,    -1,    -1,    56,    57,
      -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,
      78,    79,    80,    81,    82,    83,    84,    -1,    86,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,
      -1,    99,   100,   101,    -1,   103,    -1,   105,    -1,    -1,
     108,   109,    -1,   111,    -1,    -1,   114,   115,   116,   117,
      -1,   119,   120,   121,   122,   123,    -1,    -1,   126,   127,
     128,    -1,   130,   131,   132,   133,    -1,   135,   136,    -1,
     138,    -1,    -1,    -1,    -1,   143,   144,   145,   146,   147,
     148,   149,   150,    -1,   152,    -1,   154,    -1,   156,   157,
     158,    -1,    -1,    -1,   162,   163,   164,   165,    -1,   167,
     168,    -1,   170,    -1,   172,   173,   174,   175,   176,    -1,
     178,    -1,   180,   181,   182,    -1,   184,    -1,   186,    -1,
      -1,    -1,   190,    -1,   192,    -1,    -1,   195,    -1,   197,
     198,    -1,   200,   201,   202,    -1,   204,   205,   206,   207,
      -1,    -1,   210,    -1,   212,   213,   214,    -1,   216,    -1,
     218,    -1,    -1,    -1,    -1,   223,    -1,   225,   226,   227,
     228,   229,    -1,    -1,   232,    -1,    -1,   235,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     248,    -1,   250,   251,   252,   253,   254,   255,   256,    -1,
     258,   259,    -1,   261,    -1,   263,   264,   265,   266,    -1,
      -1,   269,   270,    -1,    -1,   273,   274,    -1,    -1,   277,
      -1,    -1,   280,   281,   282,   283,    -1,   285,   286,   287,
     288,    -1,   290,   291,   292,   293,   294,   295,   296,   297,
      -1,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,    -1,   311,   312,   313,   314,   315,   316,   317,
     318,    -1,    -1,   321,   322,   323,    -1,   325,   326,   327,
     328,    -1,   330,   331,    -1,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,    -1,   344,   345,   346,   347,
      -1,   349,   350,    -1,   352,    -1,   354,   355,   356,   357,
      -1,   359,   360,   361,   362,   363,    -1,    -1,   366,   367,
     368,   369,   370,    -1,    -1,   373,   374,   375,   376,   377,
      -1,   379,    -1,    -1,    -1,   383,   384,   385,   386,   387,
     388,    -1,   390,    -1,    -1,   393,    -1,    -1,    -1,    -1,
      -1,     6,     7,     8,     9,    -1,    11,    12,    -1,    14,
      15,    16,    17,    -1,    19,    -1,    21,   415,    23,    24,
      25,    26,    27,    28,    -1,    30,    31,    32,    33,    -1,
      -1,    36,    37,    38,    39,    -1,    -1,    -1,    43,    44,
      45,    -1,    47,    -1,    -1,    -1,    51,    52,    -1,    -1,
      -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,
      75,    76,    -1,    78,    79,    80,    81,    82,    83,    84,
      -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    96,    97,    -1,    99,   100,   101,    -1,   103,    -1,
     105,    -1,    -1,   108,   109,    -1,   111,    -1,    -1,   114,
     115,   116,   117,    -1,   119,   120,   121,   122,   123,    -1,
      -1,   126,   127,   128,    -1,   130,   131,   132,   133,    -1,
     135,   136,    -1,   138,    -1,    -1,    -1,    -1,   143,   144,
     145,   146,   147,   148,   149,   150,    -1,   152,    -1,   154,
      -1,   156,   157,   158,    -1,    -1,    -1,   162,   163,   164,
     165,    -1,   167,   168,    -1,   170,    -1,   172,   173,   174,
     175,   176,    -1,   178,    -1,   180,   181,   182,    -1,   184,
      -1,   186,    -1,    -1,    -1,   190,    -1,   192,    -1,    -1,
     195,    -1,   197,   198,    -1,   200,   201,   202,    -1,   204,
     205,   206,   207,    -1,    -1,   210,    -1,   212,   213,   214,
      -1,   216,    -1,   218,    -1,    -1,    -1,    -1,   223,    -1,
     225,   226,   227,   228,   229,    -1,    -1,   232,    -1,    -1,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,    -1,   250,    -1,   252,   253,   254,
     255,   256,    -1,   258,   259,    -1,   261,    -1,   263,   264,
     265,   266,    -1,    -1,   269,    -1,    -1,    -1,   273,   274,
      -1,    -1,   277,    -1,    -1,   280,   281,   282,   283,    -1,
     285,   286,   287,   288,    -1,   290,   291,   292,   293,   294,
     295,   296,   297,    -1,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,    -1,   311,   312,   313,   314,
     315,   316,   317,   318,    -1,   320,   321,   322,   323,    -1,
     325,   326,   327,   328,    -1,   330,   331,    -1,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,    -1,   344,
     345,   346,   347,    -1,   349,   350,    -1,   352,    -1,   354,
     355,   356,   357,    -1,   359,   360,   361,   362,   363,    -1,
      -1,   366,   367,   368,   369,   370,    -1,    -1,   373,   374,
     375,   376,   377,    -1,   379,    -1,    -1,    -1,   383,   384,
     385,   386,   387,   388,    -1,   390,    -1,    -1,   393,   394,
      -1,    -1,    -1,    -1,     6,     7,     8,     9,    -1,    11,
      12,    -1,    14,    15,    16,    17,    -1,    19,    -1,    21,
     415,    23,    24,    25,    26,    27,    28,    -1,    30,    31,
      32,    33,    -1,    -1,    36,    37,    38,    39,    -1,    -1,
      -1,    43,    44,    45,    -1,    47,    -1,    -1,    -1,    51,
      52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,
      62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,
      -1,    73,    -1,    75,    76,    -1,    78,    79,    80,    81,
      82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    96,    97,    -1,    99,   100,   101,
      -1,   103,    -1,   105,    -1,    -1,   108,   109,    -1,   111,
      -1,    -1,   114,   115,   116,   117,    -1,   119,   120,   121,
     122,   123,    -1,    -1,   126,   127,   128,    -1,   130,   131,
     132,   133,    -1,   135,   136,    -1,   138,    -1,    -1,    -1,
      -1,   143,   144,   145,   146,   147,   148,   149,   150,    -1,
     152,    -1,   154,    -1,   156,   157,   158,    -1,    -1,    -1,
     162,   163,   164,   165,    -1,   167,   168,    -1,   170,    -1,
     172,   173,   174,   175,   176,    -1,   178,    -1,   180,   181,
     182,    -1,   184,    -1,   186,    -1,    -1,    -1,   190,    -1,
     192,    -1,    -1,   195,    -1,   197,   198,    -1,   200,   201,
     202,    -1,   204,   205,   206,   207,    -1,    -1,   210,    -1,
     212,   213,   214,    -1,   216,    -1,   218,    -1,    -1,    -1,
      -1,   223,    -1,   225,   226,   227,   228,   229,    -1,    -1,
     232,    -1,    -1,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,    -1,   250,    -1,
     252,   253,   254,   255,   256,    -1,   258,   259,    -1,   261,
      -1,   263,   264,   265,   266,    -1,    -1,   269,    -1,    -1,
      -1,   273,   274,    -1,    -1,   277,    -1,    -1,   280,   281,
     282,   283,    -1,   285,   286,   287,   288,    -1,   290,   291,
     292,   293,   294,   295,   296,   297,    -1,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,    -1,   311,
     312,   313,   314,   315,   316,   317,   318,    -1,   320,   321,
     322,   323,    -1,   325,   326,   327,   328,    -1,   330,   331,
      -1,   333,   334,   335,   336,   337,   338,   339,   340,   341,
     342,    -1,   344,   345,   346,   347,    -1,   349,   350,    -1,
     352,    -1,   354,   355,   356,   357,    -1,   359,   360,   361,
     362,   363,    -1,    -1,   366,   367,   368,   369,   370,    -1,
      -1,   373,   374,   375,   376,   377,    -1,   379,    -1,    -1,
      -1,   383,   384,   385,   386,   387,   388,    -1,   390,    -1,
      -1,   393,    -1,    -1,    -1,    -1,    -1,     6,     7,     8,
       9,    -1,    11,    12,    -1,    14,    15,    16,    17,    -1,
      19,    -1,    21,   415,    23,    24,    25,    26,    27,    28,
      -1,    30,    31,    32,    33,    -1,    -1,    36,    37,    38,
      39,    -1,    -1,    -1,    43,    44,    45,    -1,    47,    -1,
      -1,    -1,    51,    52,    -1,    -1,    -1,    56,    57,    -1,
      -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,
      79,    80,    81,    82,    83,    84,    -1,    86,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,    -1,
      99,   100,   101,    -1,   103,    -1,   105,    -1,    -1,   108,
     109,    -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,
     119,   120,   121,   122,   123,    -1,    -1,   126,   127,   128,
      -1,   130,   131,   132,   133,    -1,   135,   136,    -1,   138,
      -1,    -1,    -1,    -1,   143,   144,   145,   146,   147,   148,
     149,   150,    -1,   152,    -1,   154,    -1,   156,   157,   158,
      -1,    -1,    -1,   162,   163,   164,   165,    -1,   167,   168,
      -1,   170,    -1,   172,   173,   174,   175,   176,    -1,   178,
      -1,   180,   181,   182,    -1,   184,    -1,   186,    -1,    -1,
      -1,   190,    -1,   192,    -1,    -1,   195,    -1,   197,   198,
      -1,   200,   201,   202,    -1,   204,   205,   206,   207,    -1,
      -1,   210,    -1,   212,   213,   214,    -1,   216,    -1,   218,
      -1,    -1,    -1,    -1,   223,    -1,   225,   226,   227,   228,
     229,    -1,    -1,   232,    -1,    -1,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   248,
      -1,   250,    -1,   252,   253,   254,   255,   256,    -1,   258,
     259,    -1,   261,    -1,   263,   264,   265,   266,    -1,    -1,
     269,    -1,    -1,    -1,   273,   274,    -1,    -1,   277,    -1,
      -1,   280,   281,   282,   283,    -1,   285,   286,   287,   288,
      -1,   290,   291,   292,   293,   294,   295,   296,   297,    -1,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,    -1,   311,   312,   313,   314,   315,   316,   317,   318,
      -1,    -1,   321,   322,   323,    -1,   325,   326,   327,   328,
      -1,   330,   331,    -1,   333,   334,   335,   336,   337,   338,
     339,   340,   341,   342,    -1,   344,   345,   346,   347,    -1,
     349,   350,    -1,   352,    -1,   354,   355,   356,   357,    -1,
     359,   360,   361,   362,   363,    -1,    -1,   366,   367,   368,
     369,   370,    -1,    -1,   373,   374,   375,   376,   377,    -1,
     379,    -1,    -1,    -1,   383,   384,   385,   386,   387,   388,
      -1,   390,    -1,    -1,   393,    -1,    -1,    -1,    -1,    -1,
       6,     7,     8,     9,    -1,    11,    12,    -1,    14,    15,
      16,    17,    -1,    19,    -1,    21,   415,    23,    24,    25,
      26,    27,    28,    -1,    30,    31,    32,    33,    -1,    -1,
      36,    37,    38,    39,    -1,    -1,    -1,    43,    44,    45,
      -1,    47,    -1,    -1,    -1,    51,    52,    -1,    -1,    -1,
      56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,
      76,    -1,    78,    79,    80,    81,    82,    83,    84,    -1,
      86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      96,    97,    -1,    99,   100,   101,    -1,   103,    -1,   105,
      -1,    -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,
     116,   117,    -1,   119,   120,   121,   122,   123,    -1,    -1,
     126,   127,   128,    -1,   130,   131,   132,   133,    -1,   135,
     136,    -1,   138,    -1,    -1,    -1,    -1,   143,   144,   145,
     146,   147,   148,   149,   150,    -1,   152,    -1,   154,    -1,
     156,   157,   158,    -1,    -1,    -1,   162,   163,   164,   165,
      -1,   167,   168,    -1,   170,    -1,   172,   173,   174,   175,
     176,    -1,   178,    -1,   180,   181,   182,    -1,   184,    -1,
     186,    -1,    -1,    -1,   190,    -1,   192,    -1,    -1,   195,
      -1,   197,   198,    -1,   200,   201,   202,    -1,   204,   205,
     206,   207,    -1,    -1,   210,    -1,   212,   213,   214,    -1,
     216,    -1,   218,    -1,    -1,    -1,    -1,   223,    -1,   225,
     226,   227,   228,   229,    -1,    -1,   232,    -1,    -1,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   248,    -1,   250,    -1,   252,   253,   254,   255,
     256,    -1,   258,   259,    -1,   261,    -1,   263,   264,   265,
     266,    -1,    -1,   269,    -1,    -1,    -1,   273,   274,    -1,
      -1,   277,    -1,    -1,   280,   281,   282,   283,    -1,   285,
     286,   287,   288,    -1,   290,   291,   292,   293,   294,   295,
     296,   297,    -1,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,    -1,   311,   312,   313,   314,   315,
     316,   317,   318,    -1,    -1,   321,   322,   323,    -1,   325,
     326,   327,   328,    -1,   330,   331,    -1,   333,   334,   335,
     336,   337,   338,   339,   340,   341,   342,    -1,   344,   345,
     346,   347,    -1,   349,   350,    -1,   352,    -1,   354,   355,
     356,   357,    -1,   359,   360,   361,   362,   363,    -1,    -1,
     366,   367,   368,   369,   370,    -1,    -1,   373,   374,   375,
     376,   377,    -1,   379,    -1,    -1,    -1,   383,   384,   385,
     386,   387,   388,    -1,   390,    -1,    -1,   393,    -1,    -1,
      -1,    -1,     5,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    -1,    21,   415,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    -1,    36,    37,    38,    39,    40,    41,    -1,
      43,    44,    45,    -1,    47,    48,    49,    -1,    51,    52,
      -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,
      73,    -1,    75,    76,    -1,    78,    79,    80,    81,    82,
      83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    95,    96,    97,    -1,    99,   100,   101,    -1,
     103,    -1,   105,   106,    -1,   108,   109,    -1,   111,    -1,
      -1,   114,   115,   116,   117,    -1,   119,   120,   121,   122,
      -1,    -1,    -1,   126,   127,   128,    -1,   130,   131,    -1,
     133,    -1,   135,   136,    -1,   138,    -1,    -1,    -1,    -1,
     143,   144,   145,   146,   147,   148,   149,   150,    -1,   152,
      -1,   154,    -1,   156,   157,   158,    -1,    -1,    -1,   162,
     163,   164,   165,    -1,   167,   168,    -1,   170,    -1,   172,
     173,   174,    -1,   176,    -1,    -1,    -1,   180,   181,   182,
      -1,   184,    -1,   186,    -1,    -1,    -1,   190,    -1,   192,
      -1,    -1,   195,    -1,   197,   198,    -1,   200,   201,   202,
      -1,   204,   205,   206,   207,    -1,    -1,    -1,    -1,   212,
     213,   214,   215,   216,    -1,   218,    -1,    -1,    -1,    -1,
     223,    -1,   225,   226,   227,   228,   229,    -1,    -1,   232,
      -1,    -1,   235,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   248,    -1,   250,    -1,   252,
     253,   254,   255,    -1,    -1,   258,   259,    -1,   261,    -1,
      -1,   264,   265,   266,    -1,    -1,   269,    -1,    -1,    -1,
     273,   274,    -1,    -1,    -1,    -1,    -1,    -1,   281,   282,
     283,    -1,    -1,    -1,   287,   288,    -1,   290,   291,   292,
     293,   294,   295,   296,   297,    -1,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,    -1,   311,    -1,
     313,   314,   315,   316,   317,   318,    -1,    -1,   321,   322,
     323,    -1,   325,   326,   327,   328,    -1,   330,   331,    -1,
     333,   334,   335,   336,   337,   338,   339,   340,    -1,   342,
      -1,   344,   345,   346,   347,    -1,   349,   350,    -1,   352,
      -1,   354,    -1,   356,    -1,    -1,   359,   360,   361,   362,
     363,    -1,    -1,   366,   367,   368,   369,   370,    -1,    -1,
     373,   374,   375,   376,   377,    -1,   379,    -1,    -1,    -1,
     383,   384,   385,   386,   387,   388,    -1,   390,   391,   392,
     393,   394,    -1,    -1,    -1,    -1,   399,    -1,   401,   402,
     403,   404,    -1,   406,   407,   408,   409,   410,   411,     6,
       7,     8,     9,    -1,    11,    12,    -1,    14,    15,    16,
      17,    -1,    19,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    -1,    30,    31,    32,    33,    -1,    -1,    36,
      37,    38,    39,    -1,    -1,    -1,    43,    44,    45,    -1,
      47,    -1,    -1,    -1,    51,    52,    -1,    -1,    -1,    56,
      57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,
      -1,    78,    79,    80,    81,    82,    83,    84,    -1,    86,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,
      97,    -1,    99,   100,   101,    -1,   103,    -1,   105,    -1,
      -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,   116,
     117,    -1,   119,   120,   121,   122,   123,    -1,    -1,   126,
     127,   128,    -1,   130,   131,   132,   133,    -1,   135,   136,
      -1,   138,    -1,    -1,    -1,    -1,   143,   144,   145,   146,
     147,   148,   149,   150,    -1,   152,    -1,   154,    -1,   156,
     157,   158,    -1,    -1,    -1,   162,   163,   164,   165,    -1,
     167,   168,    -1,   170,    -1,   172,   173,   174,   175,   176,
      -1,   178,    -1,   180,   181,   182,    -1,   184,    -1,   186,
      -1,    -1,    -1,   190,    -1,   192,    -1,    -1,   195,    -1,
     197,   198,    -1,   200,   201,   202,    -1,   204,   205,   206,
     207,    -1,    -1,   210,    -1,   212,   213,   214,    -1,   216,
      -1,   218,    -1,    -1,    -1,    -1,   223,    -1,   225,   226,
     227,   228,   229,    -1,    -1,   232,    -1,    -1,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,    -1,   250,    -1,   252,   253,   254,   255,   256,
      -1,   258,   259,    -1,   261,    -1,   263,   264,   265,   266,
      -1,    -1,   269,    -1,    -1,    -1,   273,   274,    -1,    -1,
     277,    -1,    -1,   280,   281,   282,   283,    -1,   285,   286,
     287,   288,    -1,   290,   291,   292,   293,   294,   295,   296,
     297,    -1,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,    -1,   311,   312,   313,   314,   315,   316,
     317,   318,    -1,    -1,   321,   322,   323,    -1,   325,   326,
     327,   328,    -1,   330,   331,    -1,   333,   334,   335,   336,
     337,   338,   339,   340,   341,   342,    -1,   344,   345,   346,
     347,    -1,   349,   350,    -1,   352,    -1,   354,   355,   356,
     357,    -1,   359,   360,   361,   362,   363,    -1,    -1,   366,
     367,   368,   369,   370,    -1,    -1,   373,   374,   375,   376,
     377,    -1,   379,    -1,    -1,    -1,   383,   384,   385,   386,
     387,   388,    -1,   390,    -1,   392,   393,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   402,   403,   404,    -1,   406,
     407,   408,   409,   410,   411,     6,     7,     8,     9,    -1,
      11,    12,    -1,    14,    15,    16,    17,    -1,    19,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    -1,    30,
      31,    32,    33,    -1,    -1,    36,    37,    38,    39,    -1,
      -1,    -1,    43,    44,    45,    -1,    47,    -1,    -1,    -1,
      51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,
      -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      71,    -1,    73,    -1,    75,    76,    -1,    78,    79,    80,
      81,    82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    96,    97,    -1,    99,   100,
     101,    -1,   103,    -1,   105,    -1,    -1,   108,   109,    -1,
     111,    -1,    -1,   114,   115,   116,   117,    -1,   119,   120,
     121,   122,   123,    -1,    -1,   126,   127,   128,    -1,   130,
     131,   132,   133,    -1,   135,   136,    -1,   138,    -1,    -1,
      -1,    -1,   143,   144,   145,   146,   147,   148,   149,   150,
      -1,   152,    -1,   154,    -1,   156,   157,   158,    -1,    -1,
      -1,   162,   163,   164,   165,    -1,   167,   168,    -1,   170,
      -1,   172,   173,   174,   175,   176,    -1,   178,    -1,   180,
     181,   182,    -1,   184,    -1,   186,    -1,    -1,    -1,   190,
      -1,   192,    -1,    -1,   195,    -1,   197,   198,    -1,   200,
     201,   202,    -1,   204,   205,   206,   207,    -1,    -1,   210,
      -1,   212,   213,   214,    -1,   216,    -1,   218,    -1,    -1,
      -1,    -1,   223,    -1,   225,   226,   227,   228,   229,    -1,
      -1,   232,    -1,    -1,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   248,    -1,   250,
      -1,   252,   253,   254,   255,   256,    -1,   258,   259,    -1,
     261,    -1,   263,   264,   265,   266,    -1,    -1,   269,    -1,
      -1,    -1,   273,   274,    -1,    -1,   277,    -1,    -1,   280,
     281,   282,   283,    -1,   285,   286,   287,   288,    -1,   290,
     291,   292,   293,   294,   295,   296,   297,    -1,   299,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,    -1,
     311,   312,   313,   314,   315,   316,   317,   318,    -1,    -1,
     321,   322,   323,    -1,   325,   326,   327,   328,    -1,   330,
     331,    -1,   333,   334,   335,   336,   337,   338,   339,   340,
     341,   342,    -1,   344,   345,   346,   347,    -1,   349,   350,
      -1,   352,    -1,   354,   355,   356,   357,    -1,   359,   360,
     361,   362,   363,    -1,    -1,   366,   367,   368,   369,   370,
      -1,    -1,   373,   374,   375,   376,   377,    -1,   379,    -1,
      -1,    -1,   383,   384,   385,   386,   387,   388,    -1,   390,
      -1,   392,   393,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   402,   403,   404,    -1,   406,   407,   408,   409,   410,
     411,     5,     6,     7,     8,     9,    -1,    11,    12,    -1,
      14,    15,    16,    17,    -1,    19,    -1,    21,    -1,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      34,    -1,    36,    37,    38,    39,    40,    41,    -1,    43,
      44,    45,    -1,    47,    48,    49,    -1,    51,    52,    -1,
      -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,
      -1,    75,    76,    -1,    78,    79,    80,    81,    82,    83,
      84,    85,    86,    87,    88,    89,    90,    91,    92,    93,
      94,    95,    96,    97,    98,    99,   100,   101,   102,   103,
     104,   105,    -1,   107,   108,   109,    -1,   111,   112,   113,
     114,   115,   116,   117,   118,   119,   120,   121,   122,   123,
     124,   125,   126,   127,   128,   129,   130,   131,   132,   133,
     134,   135,   136,   137,   138,   139,   140,   141,   142,   143,
     144,   145,   146,   147,   148,   149,   150,   151,   152,   153,
     154,    -1,   156,   157,   158,   159,   160,   161,   162,   163,
     164,   165,   166,   167,   168,   169,   170,   171,   172,   173,
     174,   175,   176,    -1,   178,   179,   180,   181,   182,   183,
     184,   185,   186,   187,   188,   189,   190,    -1,   192,   193,
     194,   195,   196,   197,   198,   199,   200,   201,   202,   203,
     204,   205,   206,   207,   208,   209,   210,   211,   212,   213,
     214,   215,   216,   217,   218,   219,    -1,   221,   222,   223,
     224,   225,   226,   227,   228,   229,   230,   231,   232,   233,
     234,   235,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   247,   248,   249,   250,   251,   252,   253,
     254,   255,   256,   257,   258,   259,   260,   261,   262,   263,
     264,   265,   266,   267,   268,   269,   270,   271,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
      -1,   285,   286,   287,   288,   289,   290,   291,   292,   293,
     294,   295,   296,   297,   298,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,   317,   318,    -1,   320,   321,   322,   323,
     324,   325,   326,   327,   328,   329,   330,   331,   332,   333,
     334,   335,   336,   337,   338,   339,   340,   341,   342,   343,
     344,   345,   346,   347,   348,   349,   350,   351,   352,   353,
     354,   355,   356,   357,   358,   359,   360,   361,   362,   363,
     364,   365,   366,   367,   368,   369,   370,   371,   372,   373,
     374,   375,   376,   377,   378,   379,    -1,   381,   382,   383,
     384,   385,   386,   387,   388,    -1,   390,    -1,    -1,   393,
      -1,     5,     6,     7,     8,     9,    -1,    11,    12,    -1,
      14,    15,    16,    17,   408,    19,    -1,    21,    -1,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      34,    -1,    36,    37,    38,    39,    40,    41,    -1,    43,
      44,    45,    -1,    47,    48,    49,    -1,    51,    52,    -1,
      -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,
      -1,    75,    76,    -1,    78,    79,    80,    81,    82,    83,
      84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    95,    96,    97,    -1,    99,   100,   101,    -1,   103,
      -1,   105,   106,    -1,   108,   109,    -1,   111,    -1,    -1,
     114,   115,   116,   117,    -1,   119,   120,   121,   122,    -1,
      -1,    -1,   126,   127,   128,    -1,   130,   131,    -1,   133,
      -1,   135,   136,    -1,   138,    -1,    -1,    -1,    -1,   143,
     144,   145,   146,   147,   148,   149,   150,    -1,   152,    -1,
     154,    -1,   156,   157,   158,    -1,    -1,    -1,   162,   163,
     164,   165,    -1,   167,   168,    -1,   170,    -1,   172,   173,
     174,    -1,   176,    -1,    -1,    -1,   180,   181,   182,    -1,
     184,    -1,   186,    -1,    -1,    -1,   190,    -1,   192,    -1,
      -1,   195,    -1,   197,   198,    -1,   200,   201,   202,    -1,
     204,   205,   206,   207,    -1,    -1,    -1,    -1,   212,   213,
     214,   215,   216,    -1,   218,    -1,    -1,    -1,    -1,   223,
      -1,   225,   226,   227,   228,   229,    -1,    -1,   232,    -1,
      -1,   235,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   247,   248,    -1,   250,    -1,   252,   253,
     254,   255,    -1,    -1,   258,   259,    -1,   261,    -1,    -1,
     264,   265,   266,    -1,    -1,   269,    -1,    -1,    -1,   273,
     274,    -1,    -1,    -1,    -1,    -1,    -1,   281,   282,   283,
      -1,    -1,    -1,   287,   288,    -1,   290,   291,   292,   293,
     294,   295,   296,   297,    -1,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,    -1,   311,    -1,   313,
     314,   315,   316,   317,   318,    -1,    -1,   321,   322,   323,
      -1,   325,   326,   327,   328,    -1,   330,   331,    -1,   333,
     334,   335,   336,   337,   338,   339,   340,    -1,   342,    -1,
     344,   345,   346,   347,    -1,   349,   350,    -1,   352,    -1,
     354,    -1,   356,    -1,    -1,   359,   360,   361,   362,   363,
      -1,    -1,   366,   367,   368,   369,   370,    -1,    -1,   373,
     374,   375,   376,   377,    -1,   379,    -1,    -1,    -1,   383,
     384,   385,   386,   387,   388,    -1,   390,    -1,    -1,   393,
       6,     7,     8,     9,    -1,    11,    12,    -1,    14,    15,
      16,    17,    -1,    19,   408,    21,    -1,    23,    24,    25,
      26,    27,    28,    -1,    30,    31,    32,    33,    -1,    -1,
      36,    37,    38,    39,    -1,    -1,    -1,    43,    44,    45,
      -1,    47,    -1,    -1,    -1,    51,    52,    -1,    -1,    -1,
      56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,
      76,    -1,    78,    79,    80,    81,    82,    83,    84,    -1,
      86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      96,    97,    -1,    99,   100,   101,    -1,   103,    -1,   105,
      -1,    -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,
     116,   117,    -1,   119,   120,   121,   122,   123,    -1,    -1,
     126,   127,   128,    -1,   130,   131,   132,   133,    -1,   135,
     136,    -1,   138,    -1,    -1,    -1,    -1,   143,   144,   145,
     146,   147,   148,   149,   150,    -1,   152,    -1,   154,    -1,
     156,   157,   158,    -1,    -1,    -1,   162,   163,   164,   165,
      -1,   167,   168,    -1,   170,    -1,   172,   173,   174,   175,
     176,    -1,   178,    -1,   180,   181,   182,    -1,   184,    -1,
     186,    -1,    -1,    -1,   190,    -1,   192,    -1,    -1,   195,
      -1,   197,   198,    -1,   200,   201,   202,    -1,   204,   205,
     206,   207,    -1,    -1,   210,    -1,   212,   213,   214,    -1,
     216,    -1,   218,    -1,    -1,    -1,    -1,   223,    -1,   225,
     226,   227,   228,   229,    -1,    -1,   232,    -1,    -1,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   248,    -1,   250,   251,   252,   253,   254,   255,
     256,    -1,   258,   259,    -1,   261,    -1,   263,   264,   265,
     266,    -1,    -1,   269,   270,    -1,    -1,   273,   274,    -1,
      -1,   277,    -1,    -1,   280,   281,   282,   283,    -1,   285,
     286,   287,   288,    -1,   290,   291,   292,   293,   294,   295,
     296,   297,    -1,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,    -1,   311,   312,   313,   314,   315,
     316,   317,   318,    -1,    -1,   321,   322,   323,    -1,   325,
     326,   327,   328,    -1,   330,   331,    -1,   333,   334,   335,
     336,   337,   338,   339,   340,   341,   342,    -1,   344,   345,
     346,   347,    -1,   349,   350,    -1,   352,    -1,   354,   355,
     356,   357,    -1,   359,   360,   361,   362,   363,    -1,    -1,
     366,   367,   368,   369,   370,    -1,    -1,   373,   374,   375,
     376,   377,    -1,   379,    -1,    -1,    -1,   383,   384,   385,
     386,   387,   388,    -1,   390,    -1,    -1,   393,     6,     7,
       8,     9,    -1,    11,    12,    -1,    14,    15,    16,    17,
      -1,    19,   408,    21,    -1,    23,    24,    25,    26,    27,
      28,    -1,    30,    31,    32,    33,    -1,    -1,    36,    37,
      38,    39,    -1,    -1,    -1,    43,    44,    45,    -1,    47,
      -1,    -1,    -1,    51,    52,    -1,    -1,    -1,    56,    57,
      -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,
      78,    79,    80,    81,    82,    83,    84,    -1,    86,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,
      -1,    99,   100,   101,    -1,   103,    -1,   105,    -1,    -1,
     108,   109,    -1,   111,    -1,    -1,   114,   115,   116,   117,
      -1,   119,   120,   121,   122,   123,    -1,    -1,   126,   127,
     128,    -1,   130,   131,   132,   133,    -1,   135,   136,    -1,
     138,    -1,    -1,    -1,    -1,   143,   144,   145,   146,   147,
     148,   149,   150,   151,   152,    -1,   154,    -1,   156,   157,
     158,    -1,    -1,    -1,   162,   163,   164,   165,    -1,   167,
     168,    -1,   170,    -1,   172,   173,   174,   175,   176,    -1,
     178,   179,   180,   181,   182,    -1,   184,    -1,   186,    -1,
      -1,    -1,   190,    -1,   192,    -1,    -1,   195,    -1,   197,
     198,    -1,   200,   201,   202,    -1,   204,   205,   206,   207,
      -1,    -1,   210,    -1,   212,   213,   214,    -1,   216,    -1,
     218,    -1,    -1,    -1,    -1,   223,    -1,   225,   226,   227,
     228,   229,    -1,    -1,   232,    -1,    -1,   235,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     248,    -1,   250,    -1,   252,   253,   254,   255,   256,    -1,
     258,   259,    -1,   261,    -1,   263,   264,   265,   266,   267,
      -1,   269,    -1,   271,    -1,   273,   274,    -1,    -1,   277,
      -1,    -1,   280,   281,   282,   283,    -1,   285,   286,   287,
     288,    -1,   290,   291,   292,   293,   294,   295,   296,   297,
      -1,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,    -1,   311,   312,   313,   314,   315,   316,   317,
     318,    -1,    -1,   321,   322,   323,    -1,   325,   326,   327,
     328,    -1,   330,   331,    -1,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,    -1,   344,   345,   346,   347,
      -1,   349,   350,    -1,   352,    -1,   354,   355,   356,   357,
     358,   359,   360,   361,   362,   363,    -1,    -1,   366,   367,
     368,   369,   370,    -1,    -1,   373,   374,   375,   376,   377,
      -1,   379,    -1,    -1,    -1,   383,   384,   385,   386,   387,
     388,    -1,   390,   391,    -1,   393,   394,    -1,    -1,    -1,
      -1,   399,    -1,   401,    -1,     6,     7,     8,     9,   407,
      11,    12,    -1,    14,    15,    16,    17,    -1,    19,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    -1,    30,
      31,    32,    33,    -1,    -1,    36,    37,    38,    39,    -1,
      -1,    -1,    43,    44,    45,    -1,    47,    -1,    -1,    -1,
      51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,
      -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      71,    -1,    73,    -1,    75,    76,    -1,    78,    79,    80,
      81,    82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    96,    97,    -1,    99,   100,
     101,    -1,   103,    -1,   105,    -1,    -1,   108,   109,    -1,
     111,    -1,    -1,   114,   115,   116,   117,    -1,   119,   120,
     121,   122,   123,    -1,    -1,   126,   127,   128,    -1,   130,
     131,   132,   133,    -1,   135,   136,    -1,   138,    -1,    -1,
      -1,    -1,   143,   144,   145,   146,   147,   148,   149,   150,
      -1,   152,    -1,   154,    -1,   156,   157,   158,    -1,    -1,
      -1,   162,   163,   164,   165,    -1,   167,   168,    -1,   170,
      -1,   172,   173,   174,   175,   176,    -1,   178,   179,   180,
     181,   182,    -1,   184,    -1,   186,    -1,    -1,    -1,   190,
      -1,   192,    -1,    -1,   195,    -1,   197,   198,    -1,   200,
     201,   202,    -1,   204,   205,   206,   207,    -1,    -1,   210,
      -1,   212,   213,   214,    -1,   216,    -1,   218,    -1,    -1,
      -1,    -1,   223,    -1,   225,   226,   227,   228,   229,    -1,
      -1,   232,    -1,    -1,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   248,    -1,   250,
      -1,   252,   253,   254,   255,   256,    -1,   258,   259,    -1,
     261,    -1,   263,   264,   265,   266,   267,    -1,   269,    -1,
     271,    -1,   273,   274,    -1,    -1,   277,    -1,    -1,   280,
     281,   282,   283,    -1,   285,   286,   287,   288,    -1,   290,
     291,   292,   293,   294,   295,   296,   297,    -1,   299,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,    -1,
     311,   312,   313,   314,   315,   316,   317,   318,    -1,    -1,
     321,   322,   323,    -1,   325,   326,   327,   328,    -1,   330,
     331,    -1,   333,   334,   335,   336,   337,   338,   339,   340,
     341,   342,    -1,   344,   345,   346,   347,    -1,   349,   350,
      -1,   352,    -1,   354,   355,   356,   357,   358,   359,   360,
     361,   362,   363,    -1,    -1,   366,   367,   368,   369,   370,
      -1,    -1,   373,   374,   375,   376,   377,    -1,   379,    -1,
      -1,    -1,   383,   384,   385,   386,   387,   388,    -1,   390,
     391,    -1,   393,   394,    -1,    -1,    -1,    -1,   399,    -1,
     401,    -1,     6,     7,     8,     9,   407,    11,    12,    -1,
      14,    15,    16,    17,    -1,    19,    -1,    21,    -1,    23,
      24,    25,    26,    27,    28,    -1,    30,    31,    32,    33,
      -1,    -1,    36,    37,    38,    39,    -1,    -1,    -1,    43,
      44,    45,    -1,    47,    -1,    -1,    -1,    51,    52,    -1,
      -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,
      -1,    75,    76,    -1,    78,    79,    80,    81,    82,    83,
      84,    85,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    95,    96,    97,    -1,    99,   100,   101,    -1,   103,
      -1,   105,    -1,    -1,   108,   109,    -1,   111,    -1,    -1,
     114,   115,   116,   117,    -1,   119,   120,   121,   122,   123,
      -1,    -1,   126,   127,   128,    -1,   130,   131,   132,   133,
      -1,   135,   136,    -1,   138,    -1,    -1,    -1,    -1,   143,
     144,   145,   146,   147,   148,   149,   150,    -1,   152,    -1,
     154,    -1,   156,   157,   158,    -1,    -1,    -1,   162,   163,
     164,   165,    -1,   167,   168,    -1,   170,    -1,   172,   173,
     174,   175,   176,    -1,   178,    -1,   180,   181,   182,    -1,
     184,    -1,   186,    -1,   188,    -1,   190,    -1,   192,    -1,
      -1,   195,    -1,   197,   198,    -1,   200,   201,   202,   203,
     204,   205,   206,   207,    -1,    -1,   210,    -1,   212,   213,
     214,    -1,   216,    -1,   218,    -1,    -1,    -1,    -1,   223,
      -1,   225,   226,   227,   228,   229,    -1,    -1,   232,    -1,
      -1,   235,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   247,   248,    -1,   250,    -1,   252,   253,
     254,   255,   256,    -1,   258,   259,    -1,   261,    -1,   263,
     264,   265,   266,    -1,    -1,   269,    -1,    -1,    -1,   273,
     274,    -1,    -1,   277,    -1,    -1,   280,   281,   282,   283,
      -1,   285,   286,   287,   288,    -1,   290,   291,   292,   293,
     294,   295,   296,   297,    -1,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,    -1,   311,   312,   313,
     314,   315,   316,   317,   318,    -1,    -1,   321,   322,   323,
      -1,   325,   326,   327,   328,    -1,   330,   331,    -1,   333,
     334,   335,   336,   337,   338,   339,   340,   341,   342,    -1,
     344,   345,   346,   347,    -1,   349,   350,    -1,   352,    -1,
     354,   355,   356,   357,    -1,   359,   360,   361,   362,   363,
      -1,    -1,   366,   367,   368,   369,   370,    -1,    -1,   373,
     374,   375,   376,   377,    -1,   379,    -1,    -1,    -1,   383,
     384,   385,   386,   387,   388,    -1,   390,    -1,    -1,   393,
     394,     6,     7,     8,     9,   399,    11,    12,    -1,    14,
      15,    16,    17,   407,    19,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    -1,    30,    31,    32,    33,    -1,
      -1,    36,    37,    38,    39,    -1,    -1,    -1,    43,    44,
      45,    -1,    47,    -1,    -1,    -1,    51,    52,    -1,    -1,
      -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,
      75,    76,    -1,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    96,    97,    -1,    99,   100,   101,    -1,   103,    -1,
     105,    -1,    -1,   108,   109,    -1,   111,    -1,    -1,   114,
     115,   116,   117,    -1,   119,   120,   121,   122,   123,    -1,
      -1,   126,   127,   128,    -1,   130,   131,   132,   133,    -1,
     135,   136,    -1,   138,    -1,    -1,    -1,    -1,   143,   144,
     145,   146,   147,   148,   149,   150,    -1,   152,    -1,   154,
      -1,   156,   157,   158,    -1,    -1,    -1,   162,   163,   164,
     165,    -1,   167,   168,    -1,   170,    -1,   172,   173,   174,
     175,   176,    -1,   178,    -1,   180,   181,   182,    -1,   184,
      -1,   186,    -1,    -1,    -1,   190,    -1,   192,    -1,    -1,
     195,    -1,   197,   198,    -1,   200,   201,   202,    -1,   204,
     205,   206,   207,    -1,    -1,   210,    -1,   212,   213,   214,
      -1,   216,    -1,   218,    -1,    -1,    -1,    -1,   223,    -1,
     225,   226,   227,   228,   229,    -1,    -1,   232,    -1,    -1,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,    -1,   250,    -1,   252,   253,   254,
     255,   256,    -1,   258,   259,    -1,   261,    -1,   263,   264,
     265,   266,    -1,    -1,   269,    -1,    -1,    -1,   273,   274,
      -1,    -1,   277,    -1,    -1,   280,   281,   282,   283,    -1,
     285,   286,   287,   288,    -1,   290,   291,   292,   293,   294,
     295,   296,   297,    -1,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,    -1,   311,   312,   313,   314,
     315,   316,   317,   318,    -1,    -1,   321,   322,   323,    -1,
     325,   326,   327,   328,    -1,   330,   331,    -1,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,    -1,   344,
     345,   346,   347,    -1,   349,   350,    -1,   352,    -1,   354,
     355,   356,   357,    -1,   359,   360,   361,   362,   363,    -1,
      -1,   366,   367,   368,   369,   370,    -1,    -1,   373,   374,
     375,   376,   377,    -1,   379,    -1,    -1,    -1,   383,   384,
     385,   386,   387,   388,    -1,   390,    -1,    -1,   393,   394,
       6,     7,     8,     9,   399,    11,    12,    -1,    14,    15,
      16,    17,   407,    19,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    -1,    30,    31,    32,    33,    -1,    -1,
      36,    37,    38,    39,    -1,    -1,    -1,    43,    44,    45,
      -1,    47,    -1,    -1,    -1,    51,    52,    -1,    -1,    -1,
      56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,
      76,    -1,    78,    79,    80,    81,    82,    83,    84,    -1,
      86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      96,    97,    -1,    99,   100,   101,    -1,   103,    -1,   105,
      -1,    -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,
     116,   117,    -1,   119,   120,   121,   122,   123,    -1,    -1,
     126,   127,   128,    -1,   130,   131,   132,   133,    -1,   135,
     136,    -1,   138,    -1,    -1,    -1,    -1,   143,   144,   145,
     146,   147,   148,   149,   150,   151,   152,    -1,   154,    -1,
     156,   157,   158,    -1,    -1,    -1,   162,   163,   164,   165,
      -1,   167,   168,    -1,   170,    -1,   172,   173,   174,   175,
     176,    -1,   178,    -1,   180,   181,   182,    -1,   184,    -1,
     186,    -1,    -1,    -1,   190,    -1,   192,    -1,    -1,   195,
      -1,   197,   198,    -1,   200,   201,   202,    -1,   204,   205,
     206,   207,    -1,    -1,   210,    -1,   212,   213,   214,    -1,
     216,    -1,   218,    -1,    -1,    -1,    -1,   223,    -1,   225,
     226,   227,   228,   229,    -1,    -1,   232,    -1,    -1,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   248,    -1,   250,    -1,   252,   253,   254,   255,
     256,    -1,   258,   259,    -1,   261,    -1,   263,   264,   265,
     266,    -1,    -1,   269,    -1,    -1,    -1,   273,   274,    -1,
      -1,   277,    -1,    -1,   280,   281,   282,   283,    -1,   285,
     286,   287,   288,    -1,   290,   291,   292,   293,   294,   295,
     296,   297,    -1,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,    -1,   311,   312,   313,   314,   315,
     316,   317,   318,    -1,    -1,   321,   322,   323,    -1,   325,
     326,   327,   328,    -1,   330,   331,    -1,   333,   334,   335,
     336,   337,   338,   339,   340,   341,   342,    -1,   344,   345,
     346,   347,    -1,   349,   350,   351,   352,    -1,   354,   355,
     356,   357,    -1,   359,   360,   361,   362,   363,    -1,    -1,
     366,   367,   368,   369,   370,    -1,    -1,   373,   374,   375,
     376,   377,    -1,   379,    -1,    -1,    -1,   383,   384,   385,
     386,   387,   388,    -1,   390,   391,    -1,   393,   394,     6,
       7,     8,     9,    -1,    11,    12,   402,    14,    15,    16,
      17,    -1,    19,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    -1,    30,    31,    32,    33,    -1,    -1,    36,
      37,    38,    39,    -1,    -1,    -1,    43,    44,    45,    -1,
      47,    -1,    -1,    -1,    51,    52,    -1,    -1,    -1,    56,
      57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,
      -1,    78,    79,    80,    81,    82,    83,    84,    -1,    86,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,
      97,    -1,    99,   100,   101,    -1,   103,    -1,   105,    -1,
      -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,   116,
     117,    -1,   119,   120,   121,   122,   123,    -1,    -1,   126,
     127,   128,    -1,   130,   131,   132,   133,    -1,   135,   136,
      -1,   138,    -1,    -1,    -1,    -1,   143,   144,   145,   146,
     147,   148,   149,   150,    -1,   152,    -1,   154,    -1,   156,
     157,   158,    -1,    -1,    -1,   162,   163,   164,   165,    -1,
     167,   168,    -1,   170,    -1,   172,   173,   174,   175,   176,
      -1,   178,    -1,   180,   181,   182,    -1,   184,    -1,   186,
      -1,    -1,    -1,   190,    -1,   192,    -1,    -1,   195,    -1,
     197,   198,    -1,   200,   201,   202,    -1,   204,   205,   206,
     207,    -1,    -1,   210,    -1,   212,   213,   214,    -1,   216,
      -1,   218,    -1,    -1,    -1,    -1,   223,    -1,   225,   226,
     227,   228,   229,    -1,    -1,   232,    -1,    -1,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,    -1,   250,    -1,   252,   253,   254,   255,   256,
      -1,   258,   259,    -1,   261,    -1,   263,   264,   265,   266,
      -1,    -1,   269,    -1,    -1,    -1,   273,   274,    -1,    -1,
     277,    -1,    -1,   280,   281,   282,   283,    -1,   285,   286,
     287,   288,    -1,   290,   291,   292,   293,   294,   295,   296,
     297,    -1,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,    -1,   311,   312,   313,   314,   315,   316,
     317,   318,    -1,    -1,   321,   322,   323,    -1,   325,   326,
     327,   328,    -1,   330,   331,    -1,   333,   334,   335,   336,
     337,   338,   339,   340,   341,   342,    -1,   344,   345,   346,
     347,    -1,   349,   350,    -1,   352,    -1,   354,   355,   356,
     357,    -1,   359,   360,   361,   362,   363,    -1,    -1,   366,
     367,   368,   369,   370,    -1,    -1,   373,   374,   375,   376,
     377,    -1,   379,    -1,    -1,    -1,   383,   384,   385,   386,
     387,   388,    -1,   390,   391,    -1,   393,   394,    -1,    -1,
     397,   398,   399,    -1,   401,     6,     7,     8,     9,    -1,
      11,    12,    -1,    14,    15,    16,    17,    -1,    19,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    -1,    30,
      31,    32,    33,    -1,    -1,    36,    37,    38,    39,    -1,
      -1,    -1,    43,    44,    45,    -1,    47,    -1,    -1,    -1,
      51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,
      -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      71,    -1,    73,    -1,    75,    76,    -1,    78,    79,    80,
      81,    82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    96,    97,    -1,    99,   100,
     101,    -1,   103,    -1,   105,    -1,    -1,   108,   109,    -1,
     111,    -1,    -1,   114,   115,   116,   117,    -1,   119,   120,
     121,   122,   123,    -1,    -1,   126,   127,   128,    -1,   130,
     131,   132,   133,    -1,   135,   136,    -1,   138,    -1,    -1,
      -1,    -1,   143,   144,   145,   146,   147,   148,   149,   150,
      -1,   152,    -1,   154,    -1,   156,   157,   158,    -1,    -1,
      -1,   162,   163,   164,   165,    -1,   167,   168,    -1,   170,
      -1,   172,   173,   174,   175,   176,    -1,   178,    -1,   180,
     181,   182,    -1,   184,    -1,   186,    -1,    -1,    -1,   190,
      -1,   192,    -1,    -1,   195,    -1,   197,   198,    -1,   200,
     201,   202,    -1,   204,   205,   206,   207,    -1,    -1,   210,
      -1,   212,   213,   214,    -1,   216,    -1,   218,    -1,    -1,
      -1,    -1,   223,    -1,   225,   226,   227,   228,   229,    -1,
      -1,   232,    -1,    -1,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   248,    -1,   250,
      -1,   252,   253,   254,   255,   256,    -1,   258,   259,    -1,
     261,    -1,   263,   264,   265,   266,    -1,    -1,   269,    -1,
      -1,    -1,   273,   274,    -1,    -1,   277,    -1,    -1,   280,
     281,   282,   283,    -1,   285,   286,   287,   288,    -1,   290,
     291,   292,   293,   294,   295,   296,   297,    -1,   299,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,    -1,
     311,   312,   313,   314,   315,   316,   317,   318,    -1,    -1,
     321,   322,   323,    -1,   325,   326,   327,   328,    -1,   330,
     331,    -1,   333,   334,   335,   336,   337,   338,   339,   340,
     341,   342,    -1,   344,   345,   346,   347,    -1,   349,   350,
      -1,   352,    -1,   354,   355,   356,   357,    -1,   359,   360,
     361,   362,   363,    -1,    -1,   366,   367,   368,   369,   370,
      -1,    -1,   373,   374,   375,   376,   377,    -1,   379,    -1,
      -1,    -1,   383,   384,   385,   386,   387,   388,    -1,   390,
      -1,    -1,   393,    -1,     4,   396,     6,     7,     8,     9,
      10,    11,    12,    -1,    14,    15,    16,    17,    18,    19,
      -1,    21,    -1,    23,    24,    25,    26,    27,    28,    -1,
      30,    31,    32,    33,    -1,    -1,    36,    37,    38,    39,
      -1,    -1,    -1,    43,    44,    45,    -1,    47,    -1,    -1,
      -1,    51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,
      -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,    79,
      80,    81,    82,    83,    84,    -1,    86,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    96,    97,    -1,    99,
     100,   101,    -1,   103,    -1,   105,    -1,    -1,   108,   109,
      -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,   119,
     120,   121,   122,   123,    -1,    -1,   126,   127,   128,    -1,
     130,   131,   132,   133,    -1,   135,   136,    -1,   138,    -1,
      -1,    -1,    -1,   143,   144,   145,   146,   147,   148,   149,
     150,    -1,   152,    -1,   154,    -1,   156,   157,   158,    -1,
      -1,    -1,   162,   163,   164,   165,    -1,   167,   168,    -1,
     170,    -1,   172,   173,   174,   175,   176,    -1,   178,    -1,
     180,   181,   182,    -1,   184,    -1,   186,    -1,    -1,    -1,
     190,    -1,   192,    -1,    -1,   195,    -1,   197,   198,    -1,
     200,   201,   202,    -1,   204,   205,   206,   207,    -1,    -1,
     210,    -1,   212,   213,   214,    -1,   216,    -1,   218,    -1,
      -1,    -1,    -1,   223,    -1,   225,   226,   227,   228,   229,
      -1,    -1,   232,    -1,    -1,   235,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   247,   248,    -1,
     250,    -1,   252,   253,   254,   255,   256,    -1,   258,   259,
      -1,   261,    -1,   263,   264,   265,   266,    -1,    -1,   269,
      -1,    -1,    -1,   273,   274,    -1,    -1,   277,    -1,    -1,
     280,   281,   282,   283,    -1,   285,   286,   287,   288,    -1,
     290,   291,   292,   293,   294,   295,   296,   297,    -1,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
      -1,   311,   312,   313,   314,   315,   316,   317,   318,    -1,
      -1,   321,   322,   323,    -1,   325,   326,   327,   328,    -1,
     330,   331,    -1,   333,   334,   335,   336,   337,   338,   339,
     340,   341,   342,    -1,   344,   345,   346,   347,    -1,   349,
     350,    -1,   352,    -1,   354,   355,   356,   357,    -1,   359,
     360,   361,   362,   363,    -1,    -1,   366,   367,   368,   369,
     370,    -1,    -1,   373,   374,   375,   376,   377,    -1,   379,
      -1,    -1,    -1,   383,   384,   385,   386,   387,   388,    -1,
     390,    -1,    -1,   393,     5,     6,     7,     8,     9,    -1,
      11,    12,    -1,    14,    15,    16,    17,    -1,    19,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,    -1,    36,    37,    38,    39,    40,
      41,    -1,    43,    44,    45,    -1,    47,    48,    49,    -1,
      51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,
      -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      71,    -1,    73,    -1,    75,    76,    -1,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    88,    89,    90,
      91,    92,    93,    94,    95,    96,    97,    98,    99,   100,
     101,   102,   103,   104,   105,    -1,   107,   108,   109,    -1,
     111,   112,   113,   114,   115,   116,   117,   118,   119,   120,
     121,   122,   123,   124,   125,   126,   127,   128,   129,   130,
     131,   132,   133,   134,   135,   136,   137,   138,   139,   140,
     141,   142,   143,   144,   145,   146,   147,   148,   149,   150,
     151,   152,   153,   154,    -1,   156,   157,   158,   159,   160,
     161,   162,   163,   164,   165,   166,   167,   168,   169,   170,
     171,   172,   173,   174,   175,   176,    -1,   178,   179,   180,
     181,   182,   183,   184,   185,   186,   187,   188,   189,   190,
      -1,   192,   193,   194,   195,   196,   197,   198,   199,   200,
     201,   202,   203,   204,   205,   206,   207,   208,   209,   210,
     211,   212,   213,   214,   215,   216,   217,   218,   219,    -1,
     221,   222,   223,   224,   225,   226,   227,   228,   229,   230,
     231,   232,   233,   234,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   248,   249,   250,
     251,   252,   253,   254,   255,   256,   257,   258,   259,   260,
     261,   262,   263,   264,   265,   266,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,    -1,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,   317,   318,    -1,   320,
     321,   322,   323,   324,   325,   326,   327,   328,   329,   330,
     331,   332,   333,   334,   335,   336,   337,   338,   339,   340,
     341,   342,   343,   344,   345,   346,   347,   348,   349,   350,
     351,   352,   353,   354,   355,   356,   357,   358,   359,   360,
     361,   362,   363,   364,   365,   366,   367,   368,   369,   370,
     371,   372,   373,   374,   375,   376,   377,   378,   379,    -1,
     381,   382,   383,   384,   385,   386,   387,   388,    -1,   390,
      -1,    -1,   393,     5,     6,     7,     8,     9,    -1,    11,
      12,    -1,    14,    15,    16,    17,    -1,    19,    -1,    21,
      -1,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,    33,    34,    -1,    36,    37,    38,    39,    40,    41,
      -1,    43,    44,    45,    -1,    47,    48,    49,    -1,    51,
      52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,
      62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,
      -1,    73,    -1,    75,    76,    -1,    78,    79,    80,    81,
      82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    96,    97,    98,    99,   100,   101,
     102,   103,   104,   105,   106,    -1,   108,   109,    -1,   111,
      -1,    -1,   114,   115,   116,   117,    -1,   119,   120,   121,
     122,    -1,    -1,    -1,   126,   127,   128,    -1,   130,   131,
      -1,   133,    -1,   135,   136,   137,   138,    -1,    -1,    -1,
      -1,   143,   144,   145,   146,   147,   148,   149,   150,    -1,
     152,    -1,   154,    -1,   156,   157,   158,    -1,    -1,    -1,
     162,   163,   164,   165,    -1,   167,   168,    -1,   170,    -1,
     172,   173,   174,    -1,   176,    -1,    -1,    -1,   180,   181,
     182,    -1,   184,    -1,   186,   187,    -1,   189,   190,    -1,
     192,    -1,    -1,   195,    -1,   197,   198,   199,   200,   201,
     202,    -1,   204,   205,   206,   207,    -1,   209,    -1,    -1,
     212,   213,   214,   215,   216,    -1,   218,    -1,    -1,   221,
     222,   223,   224,   225,   226,   227,   228,   229,    -1,   231,
     232,   233,    -1,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,   249,   250,    -1,
     252,   253,   254,   255,    -1,    -1,   258,   259,   260,   261,
      -1,    -1,   264,   265,   266,    -1,    -1,   269,    -1,    -1,
      -1,   273,   274,    -1,    -1,    -1,   278,   279,    -1,   281,
     282,   283,    -1,    -1,    -1,   287,   288,    -1,   290,   291,
     292,   293,   294,   295,   296,   297,    -1,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
      -1,   313,   314,   315,   316,   317,   318,    -1,    -1,   321,
     322,   323,    -1,   325,   326,   327,   328,   329,   330,   331,
      -1,   333,   334,   335,   336,   337,   338,   339,   340,    -1,
     342,    -1,   344,   345,   346,   347,    -1,   349,   350,    -1,
     352,    -1,   354,    -1,   356,    -1,    -1,   359,   360,   361,
     362,   363,    -1,    -1,   366,   367,   368,   369,   370,    -1,
      -1,   373,   374,   375,   376,   377,   378,   379,    -1,    -1,
      -1,   383,   384,   385,   386,   387,   388,    -1,   390,    -1,
      -1,   393,     6,     7,     8,     9,    -1,    11,    12,    13,
      14,    15,    16,    17,    -1,    19,    -1,    21,    -1,    23,
      24,    25,    26,    27,    28,    -1,    30,    31,    32,    33,
      -1,    -1,    36,    37,    38,    39,    -1,    -1,    -1,    43,
      44,    45,    -1,    47,    -1,    -1,    -1,    51,    52,    -1,
      -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,
      -1,    75,    76,    -1,    78,    79,    80,    81,    82,    83,
      84,    85,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    95,    96,    97,    -1,    99,   100,   101,    -1,   103,
      -1,   105,    -1,    -1,   108,   109,    -1,   111,    -1,    -1,
     114,   115,   116,   117,    -1,   119,   120,   121,   122,   123,
      -1,    -1,   126,   127,   128,    -1,   130,   131,   132,   133,
      -1,   135,   136,    -1,   138,    -1,    -1,    -1,    -1,   143,
     144,   145,   146,   147,   148,   149,   150,   151,   152,    -1,
     154,    -1,   156,   157,   158,    -1,    -1,    -1,   162,   163,
     164,   165,    -1,   167,   168,    -1,   170,    -1,   172,   173,
     174,   175,   176,    -1,   178,    -1,   180,   181,   182,    -1,
     184,    -1,   186,    -1,    -1,    -1,   190,    -1,   192,    -1,
      -1,   195,    -1,   197,   198,    -1,   200,   201,   202,    -1,
     204,   205,   206,   207,    -1,    -1,   210,    -1,   212,   213,
     214,    -1,   216,    -1,   218,    -1,    -1,    -1,    -1,   223,
      -1,   225,   226,   227,   228,   229,    -1,    -1,   232,    -1,
      -1,   235,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   247,   248,    -1,   250,    -1,   252,   253,
     254,   255,   256,    -1,   258,   259,    -1,   261,    -1,   263,
     264,   265,   266,    -1,    -1,   269,    -1,    -1,    -1,   273,
     274,    -1,    -1,   277,    -1,    -1,   280,   281,   282,   283,
      -1,   285,   286,   287,   288,    -1,   290,   291,   292,   293,
     294,   295,   296,   297,    -1,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,    -1,   311,   312,   313,
     314,   315,   316,   317,   318,    -1,    -1,   321,   322,   323,
      -1,   325,   326,   327,   328,    -1,   330,   331,    -1,   333,
     334,   335,   336,   337,   338,   339,   340,   341,   342,    -1,
     344,   345,   346,   347,    -1,   349,   350,    -1,   352,    -1,
     354,   355,   356,   357,    -1,   359,   360,   361,   362,   363,
      -1,    -1,   366,   367,   368,   369,   370,    -1,    -1,   373,
     374,   375,   376,   377,    -1,   379,    -1,    -1,    -1,   383,
     384,   385,   386,   387,   388,    -1,   390,   391,    -1,   393,
     394,     6,     7,     8,     9,    -1,    11,    12,    -1,    14,
      15,    16,    17,    -1,    19,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    -1,    30,    31,    32,    33,    -1,
      -1,    36,    37,    38,    39,    -1,    -1,    42,    43,    44,
      45,    -1,    47,    -1,    -1,    -1,    51,    52,    -1,    -1,
      -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,
      75,    76,    -1,    78,    79,    80,    81,    82,    83,    84,
      -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    96,    97,    -1,    99,   100,   101,    -1,   103,    -1,
     105,    -1,    -1,   108,   109,    -1,   111,    -1,    -1,   114,
     115,   116,   117,    -1,   119,   120,   121,   122,   123,    -1,
      -1,   126,   127,   128,    -1,   130,   131,   132,   133,    -1,
     135,   136,    -1,   138,    -1,    -1,    -1,    -1,   143,   144,
     145,   146,   147,   148,   149,   150,    -1,   152,    -1,   154,
      -1,   156,   157,   158,    -1,    -1,    -1,   162,   163,   164,
     165,    -1,   167,   168,    -1,   170,    -1,   172,   173,   174,
     175,   176,    -1,   178,    -1,   180,   181,   182,    -1,   184,
      -1,   186,    -1,    -1,    -1,   190,    -1,   192,    -1,    -1,
     195,    -1,   197,   198,    -1,   200,   201,   202,    -1,   204,
     205,   206,   207,    -1,    -1,   210,    -1,   212,   213,   214,
      -1,   216,    -1,   218,    -1,    -1,    -1,    -1,   223,    -1,
     225,   226,   227,   228,   229,    -1,    -1,   232,    -1,    -1,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,    -1,   250,   251,   252,   253,   254,
     255,   256,    -1,   258,   259,    -1,   261,    -1,   263,   264,
     265,   266,    -1,    -1,   269,   270,    -1,    -1,   273,   274,
      -1,    -1,   277,    -1,    -1,   280,   281,   282,   283,    -1,
     285,   286,   287,   288,    -1,   290,   291,   292,   293,   294,
     295,   296,   297,    -1,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,    -1,   311,   312,   313,   314,
     315,   316,   317,   318,    -1,    -1,   321,   322,   323,    -1,
     325,   326,   327,   328,    -1,   330,   331,    -1,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,    -1,   349,   350,    -1,   352,    -1,   354,
     355,   356,   357,    -1,   359,   360,   361,   362,   363,    -1,
      -1,   366,   367,   368,   369,   370,    -1,    -1,   373,   374,
     375,   376,   377,    -1,   379,    -1,    -1,    -1,   383,   384,
     385,   386,   387,   388,    -1,   390,    -1,    -1,   393,   394,
       6,     7,     8,     9,    -1,    11,    12,    -1,    14,    15,
      16,    17,    -1,    19,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    -1,    30,    31,    32,    33,    -1,    -1,
      36,    37,    38,    39,    -1,    -1,    -1,    43,    44,    45,
      -1,    47,    -1,    -1,    -1,    51,    52,    -1,    -1,    -1,
      56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,
      76,    -1,    78,    79,    80,    81,    82,    83,    84,    -1,
      86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      96,    97,    -1,    99,   100,   101,    -1,   103,    -1,   105,
      -1,    -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,
     116,   117,    -1,   119,   120,   121,   122,   123,    -1,    -1,
     126,   127,   128,    -1,   130,   131,   132,   133,    -1,   135,
     136,    -1,   138,    -1,    -1,    -1,    -1,   143,   144,   145,
     146,   147,   148,   149,   150,    -1,   152,    -1,   154,    -1,
     156,   157,   158,    -1,    -1,    -1,   162,   163,   164,   165,
      -1,   167,   168,    -1,   170,    -1,   172,   173,   174,   175,
     176,    -1,   178,    -1,   180,   181,   182,    -1,   184,    -1,
     186,    -1,    -1,    -1,   190,    -1,   192,    -1,    -1,   195,
      -1,   197,   198,    -1,   200,   201,   202,    -1,   204,   205,
     206,   207,    -1,    -1,   210,    -1,   212,   213,   214,    -1,
     216,    -1,   218,    -1,    -1,    -1,    -1,   223,    -1,   225,
     226,   227,   228,   229,    -1,    -1,   232,    -1,    -1,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   248,    -1,   250,    -1,   252,   253,   254,   255,
     256,    -1,   258,   259,    -1,   261,    -1,   263,   264,   265,
     266,    -1,    -1,   269,    -1,    -1,    -1,   273,   274,    -1,
      -1,   277,    -1,    -1,   280,   281,   282,   283,    -1,   285,
     286,   287,   288,    -1,   290,   291,   292,   293,   294,   295,
     296,   297,    -1,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,    -1,   311,   312,   313,   314,   315,
     316,   317,   318,    -1,    -1,   321,   322,   323,    -1,   325,
     326,   327,   328,    -1,   330,   331,    -1,   333,   334,   335,
     336,   337,   338,   339,   340,   341,   342,    -1,   344,   345,
     346,   347,    -1,   349,   350,   351,   352,    -1,   354,   355,
     356,   357,    -1,   359,   360,   361,   362,   363,    -1,    -1,
     366,   367,   368,   369,   370,    -1,    -1,   373,   374,   375,
     376,   377,    -1,   379,    -1,    -1,    -1,   383,   384,   385,
     386,   387,   388,    -1,   390,   391,    -1,   393,   394,     6,
       7,     8,     9,    -1,    11,    12,    -1,    14,    15,    16,
      17,    -1,    19,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    -1,    30,    31,    32,    33,    -1,    -1,    36,
      37,    38,    39,    -1,    -1,    -1,    43,    44,    45,    -1,
      47,    -1,    -1,    -1,    51,    52,    -1,    -1,    -1,    56,
      57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,
      -1,    78,    79,    80,    81,    82,    83,    84,    -1,    86,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,
      97,    -1,    99,   100,   101,    -1,   103,    -1,   105,    -1,
      -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,   116,
     117,    -1,   119,   120,   121,   122,   123,    -1,    -1,   126,
     127,   128,    -1,   130,   131,   132,   133,    -1,   135,   136,
      -1,   138,    -1,    -1,    -1,    -1,   143,   144,   145,   146,
     147,   148,   149,   150,   151,   152,    -1,   154,    -1,   156,
     157,   158,    -1,    -1,    -1,   162,   163,   164,   165,    -1,
     167,   168,    -1,   170,    -1,   172,   173,   174,   175,   176,
      -1,   178,    -1,   180,   181,   182,    -1,   184,    -1,   186,
      -1,    -1,    -1,   190,    -1,   192,    -1,    -1,   195,    -1,
     197,   198,    -1,   200,   201,   202,    -1,   204,   205,   206,
     207,    -1,    -1,   210,    -1,   212,   213,   214,    -1,   216,
      -1,   218,    -1,    -1,    -1,    -1,   223,    -1,   225,   226,
     227,   228,   229,    -1,    -1,   232,    -1,    -1,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,    -1,   250,    -1,   252,   253,   254,   255,   256,
      -1,   258,   259,    -1,   261,    -1,   263,   264,   265,   266,
      -1,    -1,   269,    -1,    -1,    -1,   273,   274,    -1,    -1,
     277,    -1,    -1,   280,   281,   282,   283,    -1,   285,   286,
     287,   288,    -1,   290,   291,   292,   293,   294,   295,   296,
     297,    -1,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,    -1,   311,   312,   313,   314,   315,   316,
     317,   318,    -1,    -1,   321,   322,   323,    -1,   325,   326,
     327,   328,    -1,   330,   331,    -1,   333,   334,   335,   336,
     337,   338,   339,   340,   341,   342,    -1,   344,   345,   346,
     347,    -1,   349,   350,    -1,   352,    -1,   354,   355,   356,
     357,    -1,   359,   360,   361,   362,   363,    -1,    -1,   366,
     367,   368,   369,   370,    -1,    -1,   373,   374,   375,   376,
     377,    -1,   379,    -1,    -1,    -1,   383,   384,   385,   386,
     387,   388,    -1,   390,   391,    -1,   393,   394,     6,     7,
       8,     9,    -1,    11,    12,    -1,    14,    15,    16,    17,
      -1,    19,    -1,    21,    -1,    23,    24,    25,    26,    27,
      28,    -1,    30,    31,    32,    33,    -1,    -1,    36,    37,
      38,    39,    -1,    -1,    -1,    43,    44,    45,    -1,    47,
      -1,    -1,    -1,    51,    52,    -1,    -1,    -1,    56,    57,
      -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,
      78,    79,    80,    81,    82,    83,    84,    -1,    86,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,
      -1,    99,   100,   101,    -1,   103,    -1,   105,    -1,    -1,
     108,   109,    -1,   111,    -1,    -1,   114,   115,   116,   117,
      -1,   119,   120,   121,   122,   123,    -1,    -1,   126,   127,
     128,    -1,   130,   131,   132,   133,    -1,   135,   136,    -1,
     138,    -1,    -1,    -1,    -1,   143,   144,   145,   146,   147,
     148,   149,   150,   151,   152,    -1,   154,    -1,   156,   157,
     158,    -1,    -1,    -1,   162,   163,   164,   165,    -1,   167,
     168,    -1,   170,    -1,   172,   173,   174,   175,   176,    -1,
     178,    -1,   180,   181,   182,    -1,   184,    -1,   186,    -1,
      -1,    -1,   190,    -1,   192,    -1,    -1,   195,    -1,   197,
     198,    -1,   200,   201,   202,    -1,   204,   205,   206,   207,
      -1,    -1,   210,    -1,   212,   213,   214,    -1,   216,    -1,
     218,    -1,    -1,    -1,    -1,   223,    -1,   225,   226,   227,
     228,   229,    -1,    -1,   232,    -1,    -1,   235,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     248,    -1,   250,    -1,   252,   253,   254,   255,   256,    -1,
     258,   259,    -1,   261,    -1,   263,   264,   265,   266,    -1,
      -1,   269,    -1,    -1,    -1,   273,   274,    -1,    -1,   277,
      -1,    -1,   280,   281,   282,   283,    -1,   285,   286,   287,
     288,    -1,   290,   291,   292,   293,   294,   295,   296,   297,
      -1,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,    -1,   311,   312,   313,   314,   315,   316,   317,
     318,    -1,    -1,   321,   322,   323,    -1,   325,   326,   327,
     328,    -1,   330,   331,    -1,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,    -1,   344,   345,   346,   347,
      -1,   349,   350,    -1,   352,    -1,   354,   355,   356,   357,
      -1,   359,   360,   361,   362,   363,    -1,    -1,   366,   367,
     368,   369,   370,    -1,    -1,   373,   374,   375,   376,   377,
      -1,   379,    -1,    -1,    -1,   383,   384,   385,   386,   387,
     388,    -1,   390,   391,    -1,   393,   394,     6,     7,     8,
       9,    -1,    11,    12,    -1,    14,    15,    16,    17,    -1,
      19,    -1,    21,    -1,    23,    24,    25,    26,    27,    28,
      -1,    30,    31,    32,    33,    -1,    -1,    36,    37,    38,
      39,    -1,    -1,    -1,    43,    44,    45,    -1,    47,    -1,
      -1,    -1,    51,    52,    -1,    -1,    -1,    56,    57,    -1,
      -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,
      79,    80,    81,    82,    83,    84,    -1,    86,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,    -1,
      99,   100,   101,    -1,   103,    -1,   105,    -1,    -1,   108,
     109,    -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,
     119,   120,   121,   122,   123,    -1,    -1,   126,   127,   128,
      -1,   130,   131,   132,   133,    -1,   135,   136,    -1,   138,
      -1,    -1,    -1,    -1,   143,   144,   145,   146,   147,   148,
     149,   150,   151,   152,    -1,   154,    -1,   156,   157,   158,
      -1,    -1,    -1,   162,   163,   164,   165,    -1,   167,   168,
      -1,   170,    -1,   172,   173,   174,   175,   176,    -1,   178,
      -1,   180,   181,   182,    -1,   184,    -1,   186,    -1,    -1,
      -1,   190,    -1,   192,    -1,    -1,   195,    -1,   197,   198,
      -1,   200,   201,   202,    -1,   204,   205,   206,   207,    -1,
      -1,   210,    -1,   212,   213,   214,    -1,   216,    -1,   218,
      -1,    -1,    -1,    -1,   223,    -1,   225,   226,   227,   228,
     229,    -1,    -1,   232,    -1,    -1,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   248,
      -1,   250,    -1,   252,   253,   254,   255,   256,    -1,   258,
     259,    -1,   261,    -1,   263,   264,   265,   266,    -1,    -1,
     269,    -1,    -1,    -1,   273,   274,    -1,    -1,   277,    -1,
      -1,   280,   281,   282,   283,    -1,   285,   286,   287,   288,
      -1,   290,   291,   292,   293,   294,   295,   296,   297,    -1,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,    -1,   311,   312,   313,   314,   315,   316,   317,   318,
      -1,    -1,   321,   322,   323,    -1,   325,   326,   327,   328,
      -1,   330,   331,    -1,   333,   334,   335,   336,   337,   338,
     339,   340,   341,   342,    -1,   344,   345,   346,   347,    -1,
     349,   350,    -1,   352,    -1,   354,   355,   356,   357,    -1,
     359,   360,   361,   362,   363,    -1,    -1,   366,   367,   368,
     369,   370,    -1,    -1,   373,   374,   375,   376,   377,    -1,
     379,    -1,    -1,    -1,   383,   384,   385,   386,   387,   388,
      -1,   390,   391,    -1,   393,   394,     6,     7,     8,     9,
      -1,    11,    12,    -1,    14,    15,    16,    17,    -1,    19,
      -1,    21,    -1,    23,    24,    25,    26,    27,    28,    -1,
      30,    31,    32,    33,    -1,    -1,    36,    37,    38,    39,
      -1,    -1,    -1,    43,    44,    45,    -1,    47,    -1,    -1,
      -1,    51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,
      -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,    79,
      80,    81,    82,    83,    84,    -1,    86,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    96,    97,    -1,    99,
     100,   101,    -1,   103,    -1,   105,    -1,    -1,   108,   109,
      -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,   119,
     120,   121,   122,   123,    -1,    -1,   126,   127,   128,    -1,
     130,   131,   132,   133,    -1,   135,   136,    -1,   138,    -1,
      -1,    -1,    -1,   143,   144,   145,   146,   147,   148,   149,
     150,    -1,   152,    -1,   154,    -1,   156,   157,   158,    -1,
      -1,    -1,   162,   163,   164,   165,    -1,   167,   168,    -1,
     170,    -1,   172,   173,   174,   175,   176,    -1,   178,    -1,
     180,   181,   182,    -1,   184,    -1,   186,    -1,    -1,    -1,
     190,    -1,   192,    -1,    -1,   195,    -1,   197,   198,    -1,
     200,   201,   202,    -1,   204,   205,   206,   207,    -1,    -1,
     210,    -1,   212,   213,   214,    -1,   216,    -1,   218,    -1,
      -1,    -1,    -1,   223,    -1,   225,   226,   227,   228,   229,
      -1,    -1,   232,    -1,    -1,   235,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   247,   248,    -1,
     250,    -1,   252,   253,   254,   255,   256,    -1,   258,   259,
      -1,   261,    -1,   263,   264,   265,   266,    -1,    -1,   269,
      -1,    -1,    -1,   273,   274,    -1,    -1,   277,    -1,    -1,
     280,   281,   282,   283,    -1,   285,   286,   287,   288,    -1,
     290,   291,   292,   293,   294,   295,   296,   297,    -1,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
      -1,   311,   312,   313,   314,   315,   316,   317,   318,    -1,
      -1,   321,   322,   323,    -1,   325,   326,   327,   328,    -1,
     330,   331,    -1,   333,   334,   335,   336,   337,   338,   339,
     340,   341,   342,    -1,   344,   345,   346,   347,    -1,   349,
     350,    -1,   352,    -1,   354,   355,   356,   357,    -1,   359,
     360,   361,   362,   363,    -1,    -1,   366,   367,   368,   369,
     370,    -1,    -1,   373,   374,   375,   376,   377,    -1,   379,
      -1,    -1,    -1,   383,   384,   385,   386,   387,   388,    -1,
     390,   391,    -1,   393,   394,     6,     7,     8,     9,    -1,
      11,    12,    -1,    14,    15,    16,    17,    18,    19,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    -1,    30,
      31,    32,    33,    -1,    -1,    36,    37,    38,    39,    -1,
      -1,    -1,    43,    44,    45,    -1,    47,    -1,    -1,    -1,
      51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,
      -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      71,    -1,    73,    -1,    75,    76,    -1,    78,    79,    80,
      81,    82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    96,    97,    -1,    99,   100,
     101,    -1,   103,    -1,   105,    -1,    -1,   108,   109,    -1,
     111,    -1,    -1,   114,   115,   116,   117,    -1,   119,   120,
     121,   122,   123,    -1,    -1,   126,   127,   128,    -1,   130,
     131,   132,   133,    -1,   135,   136,    -1,   138,    -1,    -1,
      -1,    -1,   143,   144,   145,   146,   147,   148,   149,   150,
      -1,   152,    -1,   154,    -1,   156,   157,   158,    -1,    -1,
      -1,   162,   163,   164,   165,    -1,   167,   168,    -1,   170,
      -1,   172,   173,   174,   175,   176,    -1,   178,    -1,   180,
     181,   182,    -1,   184,    -1,   186,    -1,    -1,    -1,   190,
      -1,   192,    -1,    -1,   195,    -1,   197,   198,    -1,   200,
     201,   202,    -1,   204,   205,   206,   207,    -1,    -1,   210,
      -1,   212,   213,   214,    -1,   216,    -1,   218,    -1,    -1,
      -1,    -1,   223,    -1,   225,   226,   227,   228,   229,    -1,
      -1,   232,    -1,    -1,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   248,    -1,   250,
      -1,   252,   253,   254,   255,   256,    -1,   258,   259,    -1,
     261,    -1,   263,   264,   265,   266,    -1,    -1,   269,    -1,
      -1,    -1,   273,   274,    -1,    -1,   277,    -1,    -1,   280,
     281,   282,   283,    -1,   285,   286,   287,   288,    -1,   290,
     291,   292,   293,   294,   295,   296,   297,    -1,   299,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,    -1,
     311,   312,   313,   314,   315,   316,   317,   318,    -1,    -1,
     321,   322,   323,    -1,   325,   326,   327,   328,    -1,   330,
     331,    -1,   333,   334,   335,   336,   337,   338,   339,   340,
     341,   342,    -1,   344,   345,   346,   347,    -1,   349,   350,
      -1,   352,    -1,   354,   355,   356,   357,    -1,   359,   360,
     361,   362,   363,    -1,    -1,   366,   367,   368,   369,   370,
      -1,    -1,   373,   374,   375,   376,   377,    -1,   379,    -1,
      -1,    -1,   383,   384,   385,   386,   387,   388,    -1,   390,
      -1,    -1,   393,   394,     6,     7,     8,     9,    -1,    11,
      12,    -1,    14,    15,    16,    17,    -1,    19,    -1,    21,
      -1,    23,    24,    25,    26,    27,    28,    -1,    30,    31,
      32,    33,    -1,    -1,    36,    37,    38,    39,    -1,    -1,
      -1,    43,    44,    45,    -1,    47,    -1,    -1,    -1,    51,
      52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,
      62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,
      -1,    73,    -1,    75,    76,    -1,    78,    79,    80,    81,
      82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    96,    97,    -1,    99,   100,   101,
      -1,   103,    -1,   105,    -1,    -1,   108,   109,    -1,   111,
      -1,    -1,   114,   115,   116,   117,    -1,   119,   120,   121,
     122,   123,    -1,    -1,   126,   127,   128,    -1,   130,   131,
     132,   133,    -1,   135,   136,    -1,   138,    -1,    -1,    -1,
      -1,   143,   144,   145,   146,   147,   148,   149,   150,    -1,
     152,    -1,   154,    -1,   156,   157,   158,    -1,    -1,    -1,
     162,   163,   164,   165,    -1,   167,   168,    -1,   170,    -1,
     172,   173,   174,   175,   176,    -1,   178,    -1,   180,   181,
     182,    -1,   184,    -1,   186,    -1,    -1,    -1,   190,    -1,
     192,    -1,    -1,   195,    -1,   197,   198,    -1,   200,   201,
     202,    -1,   204,   205,   206,   207,    -1,    -1,   210,    -1,
     212,   213,   214,    -1,   216,    -1,   218,    -1,    -1,    -1,
      -1,   223,    -1,   225,   226,   227,   228,   229,    -1,    -1,
     232,    -1,    -1,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,    -1,   250,    -1,
     252,   253,   254,   255,   256,    -1,   258,   259,    -1,   261,
      -1,   263,   264,   265,   266,    -1,    -1,   269,    -1,    -1,
      -1,   273,   274,    -1,    -1,   277,    -1,    -1,   280,   281,
     282,   283,    -1,   285,   286,   287,   288,    -1,   290,   291,
     292,   293,   294,   295,   296,   297,    -1,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,    -1,   311,
     312,   313,   314,   315,   316,   317,   318,    -1,    -1,   321,
     322,   323,    -1,   325,   326,   327,   328,    -1,   330,   331,
      -1,   333,   334,   335,   336,   337,   338,   339,   340,   341,
     342,    -1,   344,   345,   346,   347,    -1,   349,   350,    -1,
     352,    -1,   354,   355,   356,   357,    -1,   359,   360,   361,
     362,   363,    -1,    -1,   366,   367,   368,   369,   370,    -1,
      -1,   373,   374,   375,   376,   377,    -1,   379,    -1,    -1,
      -1,   383,   384,   385,   386,   387,   388,    -1,   390,    -1,
      -1,   393,   394,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    -1,    30,    31,    32,
      33,    -1,    -1,    36,    37,    38,    39,    -1,    -1,    -1,
      43,    44,    45,    -1,    47,    -1,    -1,    -1,    51,    52,
      -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,
      73,    -1,    75,    76,    -1,    78,    79,    80,    81,    82,
      83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    95,    96,    97,    -1,    99,   100,   101,    -1,
     103,    -1,   105,    -1,    -1,   108,   109,    -1,   111,    -1,
      -1,   114,   115,   116,   117,    -1,   119,   120,   121,   122,
     123,    -1,    -1,   126,   127,   128,    -1,   130,   131,   132,
     133,    -1,   135,   136,    -1,   138,    -1,    -1,    -1,    -1,
     143,   144,   145,   146,   147,   148,   149,   150,    -1,   152,
      -1,   154,    -1,   156,   157,   158,    -1,    -1,    -1,   162,
     163,   164,   165,    -1,   167,   168,    -1,   170,    -1,   172,
     173,   174,   175,   176,    -1,   178,    -1,   180,   181,   182,
      -1,   184,    -1,   186,    -1,    -1,    -1,   190,    -1,   192,
      -1,    -1,   195,    -1,   197,   198,    -1,   200,   201,   202,
      -1,   204,   205,   206,   207,    -1,    -1,   210,    -1,   212,
     213,   214,    -1,   216,    -1,   218,    -1,    -1,    -1,    -1,
     223,    -1,   225,   226,   227,   228,   229,    -1,    -1,   232,
      -1,    -1,   235,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   248,    -1,   250,    -1,   252,
     253,   254,   255,   256,    -1,   258,   259,    -1,   261,    -1,
     263,   264,   265,   266,    -1,    -1,   269,    -1,    -1,    -1,
     273,   274,    -1,    -1,   277,    -1,    -1,   280,   281,   282,
     283,    -1,   285,   286,   287,   288,    -1,   290,   291,   292,
     293,   294,   295,   296,   297,    -1,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,    -1,   311,   312,
     313,   314,   315,   316,   317,   318,    -1,    -1,   321,   322,
     323,    -1,   325,   326,   327,   328,    -1,   330,   331,    -1,
     333,   334,   335,   336,   337,   338,   339,   340,   341,   342,
      -1,   344,   345,   346,   347,    -1,   349,   350,    -1,   352,
      -1,   354,   355,   356,   357,    -1,   359,   360,   361,   362,
     363,    -1,    -1,   366,   367,   368,   369,   370,    -1,    -1,
     373,   374,   375,   376,   377,    -1,   379,    -1,    -1,    -1,
     383,   384,   385,   386,   387,   388,    -1,   390,    -1,    -1,
     393,   394,     5,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    -1,    36,    37,    38,    39,    40,    41,    -1,
      43,    44,    45,    -1,    47,    48,    49,    -1,    51,    52,
      -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,
      73,    -1,    75,    76,    -1,    78,    79,    80,    81,    82,
      83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    95,    96,    97,    -1,    99,   100,   101,    -1,
     103,    -1,   105,   106,    -1,   108,   109,    -1,   111,    -1,
      -1,   114,   115,   116,   117,    -1,   119,   120,   121,   122,
      -1,    -1,    -1,   126,   127,   128,    -1,   130,   131,    -1,
     133,    -1,   135,   136,    -1,   138,    -1,    -1,    -1,    -1,
     143,   144,   145,   146,   147,   148,   149,   150,    -1,   152,
      -1,   154,    -1,   156,   157,   158,    -1,    -1,    -1,   162,
     163,   164,   165,    -1,   167,   168,    -1,   170,    -1,   172,
     173,   174,    -1,   176,    -1,    -1,    -1,   180,   181,   182,
      -1,   184,    -1,   186,    -1,    -1,    -1,   190,    -1,   192,
      -1,    -1,   195,    -1,   197,   198,    -1,   200,   201,   202,
      -1,   204,   205,   206,   207,    -1,    -1,    -1,    -1,   212,
     213,   214,   215,   216,    -1,   218,    -1,    -1,    -1,    -1,
     223,    -1,   225,   226,   227,   228,   229,    -1,    -1,   232,
      -1,    -1,   235,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   248,    -1,   250,    -1,   252,
     253,   254,   255,   256,    -1,   258,   259,    -1,   261,    -1,
      -1,   264,   265,   266,    -1,    -1,   269,    -1,    -1,    -1,
     273,   274,    -1,    -1,    -1,    -1,    -1,    -1,   281,   282,
     283,    -1,    -1,    -1,   287,   288,    -1,   290,   291,   292,
     293,   294,   295,   296,   297,    -1,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,    -1,   311,    -1,
     313,   314,   315,   316,   317,   318,    -1,    -1,   321,   322,
     323,    -1,   325,   326,   327,   328,    -1,   330,   331,    -1,
     333,   334,   335,   336,   337,   338,   339,   340,    -1,   342,
      -1,   344,   345,   346,   347,    -1,   349,   350,    -1,   352,
      -1,   354,    -1,   356,    -1,    -1,   359,   360,   361,   362,
     363,    -1,    -1,   366,   367,   368,   369,   370,    -1,    -1,
     373,   374,   375,   376,   377,    -1,   379,    -1,    -1,    -1,
     383,   384,   385,   386,   387,   388,    -1,   390,    -1,    -1,
     393,     5,     6,     7,     8,     9,    -1,    11,    12,    -1,
      14,    15,    16,    17,    -1,    19,    -1,    21,    -1,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      34,    -1,    36,    37,    38,    39,    40,    41,    -1,    43,
      44,    45,    -1,    47,    48,    49,    -1,    51,    52,    -1,
      -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,
      -1,    75,    76,    -1,    78,    79,    80,    81,    82,    83,
      84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    95,    96,    97,    -1,    99,   100,   101,    -1,   103,
      -1,   105,   106,    -1,   108,   109,    -1,   111,    -1,    -1,
     114,   115,   116,   117,    -1,   119,   120,   121,   122,    -1,
      -1,    -1,   126,   127,   128,    -1,   130,   131,    -1,   133,
      -1,   135,   136,    -1,   138,    -1,    -1,    -1,    -1,   143,
     144,   145,   146,   147,   148,   149,   150,    -1,   152,    -1,
     154,    -1,   156,   157,   158,    -1,    -1,    -1,   162,   163,
     164,   165,    -1,   167,   168,    -1,   170,    -1,   172,   173,
     174,    -1,   176,    -1,    -1,    -1,   180,   181,   182,    -1,
     184,    -1,   186,    -1,    -1,    -1,   190,    -1,   192,    -1,
      -1,   195,    -1,   197,   198,    -1,   200,   201,   202,    -1,
     204,   205,   206,   207,    -1,    -1,    -1,    -1,   212,   213,
     214,   215,   216,    -1,   218,    -1,    -1,    -1,    -1,   223,
      -1,   225,   226,   227,   228,   229,    -1,    -1,   232,    -1,
      -1,   235,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   247,   248,    -1,   250,    -1,   252,   253,
     254,   255,   256,    -1,   258,   259,    -1,   261,    -1,    -1,
     264,   265,   266,    -1,    -1,   269,    -1,    -1,    -1,   273,
     274,    -1,    -1,    -1,    -1,    -1,    -1,   281,   282,   283,
      -1,    -1,    -1,   287,   288,    -1,   290,   291,   292,   293,
     294,   295,   296,   297,    -1,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,    -1,   311,    -1,   313,
     314,   315,   316,   317,   318,    -1,    -1,   321,   322,   323,
      -1,   325,   326,   327,   328,    -1,   330,   331,    -1,   333,
     334,   335,   336,   337,   338,   339,   340,    -1,   342,    -1,
     344,   345,   346,   347,    -1,   349,   350,    -1,   352,    -1,
     354,    -1,   356,    -1,    -1,   359,   360,   361,   362,   363,
      -1,    -1,   366,   367,   368,   369,   370,    -1,    -1,   373,
     374,   375,   376,   377,    -1,   379,    -1,    -1,    -1,   383,
     384,   385,   386,   387,   388,    -1,   390,    -1,    -1,   393,
       5,     6,     7,     8,     9,    -1,    11,    12,    -1,    14,
      15,    16,    17,    -1,    19,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      -1,    36,    37,    38,    39,    40,    41,    -1,    43,    44,
      45,    -1,    47,    48,    49,    -1,    51,    52,    -1,    -1,
      -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,
      75,    76,    -1,    78,    79,    80,    81,    82,    83,    84,
      -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    96,    97,    -1,    99,   100,   101,    -1,   103,    -1,
     105,   106,    -1,   108,   109,    -1,   111,    -1,    -1,   114,
     115,   116,   117,    -1,   119,   120,   121,   122,    -1,    -1,
      -1,   126,   127,   128,    -1,   130,   131,    -1,   133,    -1,
     135,   136,    -1,   138,    -1,    -1,    -1,    -1,   143,   144,
     145,   146,   147,   148,   149,   150,    -1,   152,    -1,   154,
      -1,   156,   157,   158,    -1,    -1,    -1,   162,   163,   164,
     165,    -1,   167,   168,    -1,   170,    -1,   172,   173,   174,
      -1,   176,    -1,    -1,    -1,   180,   181,   182,    -1,   184,
      -1,   186,    -1,    -1,    -1,   190,    -1,   192,    -1,    -1,
     195,    -1,   197,   198,    -1,   200,   201,   202,    -1,   204,
     205,   206,   207,    -1,    -1,    -1,    -1,   212,   213,   214,
     215,   216,    -1,   218,    -1,    -1,    -1,    -1,   223,    -1,
     225,   226,   227,   228,   229,    -1,    -1,   232,    -1,    -1,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,    -1,   250,    -1,   252,   253,   254,
     255,    -1,    -1,   258,   259,    -1,   261,    -1,    -1,   264,
     265,   266,    -1,    -1,   269,    -1,    -1,    -1,   273,   274,
      -1,    -1,    -1,    -1,    -1,    -1,   281,   282,   283,    -1,
      -1,    -1,   287,   288,    -1,   290,   291,   292,   293,   294,
     295,   296,   297,    -1,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,    -1,   311,    -1,   313,   314,
     315,   316,   317,   318,    -1,    -1,   321,   322,   323,    -1,
     325,   326,   327,   328,    -1,   330,   331,    -1,   333,   334,
     335,   336,   337,   338,   339,   340,    -1,   342,    -1,   344,
     345,   346,   347,    -1,   349,   350,    -1,   352,    -1,   354,
      -1,   356,    -1,    -1,   359,   360,   361,   362,   363,    -1,
      -1,   366,   367,   368,   369,   370,    -1,    -1,   373,   374,
     375,   376,   377,    -1,   379,    -1,    -1,    -1,   383,   384,
     385,   386,   387,   388,    -1,   390,    -1,    -1,   393,     5,
       6,     7,     8,     9,    -1,    11,    12,    -1,    14,    15,
      16,    17,    -1,    19,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    34,    -1,
      36,    37,    38,    39,    40,    41,    -1,    43,    44,    45,
      -1,    47,    48,    49,    -1,    51,    52,    -1,    -1,    -1,
      56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,
      76,    -1,    78,    79,    80,    81,    82,    83,    84,    -1,
      86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      96,    97,    -1,    99,   100,   101,    -1,   103,    -1,   105,
     106,    -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,
     116,   117,    -1,   119,   120,   121,   122,    -1,    -1,    -1,
     126,   127,   128,    -1,   130,   131,    -1,   133,    -1,   135,
     136,    -1,   138,    -1,    -1,    -1,    -1,   143,   144,   145,
     146,   147,   148,   149,   150,    -1,   152,    -1,   154,    -1,
     156,   157,   158,    -1,    -1,    -1,   162,   163,   164,   165,
      -1,   167,   168,    -1,   170,    -1,   172,   173,   174,    -1,
     176,    -1,    -1,    -1,   180,   181,   182,    -1,   184,    -1,
     186,    -1,    -1,    -1,   190,    -1,   192,    -1,    -1,   195,
      -1,   197,   198,    -1,   200,   201,   202,    -1,   204,   205,
     206,   207,    -1,    -1,    -1,    -1,   212,   213,   214,   215,
     216,    -1,   218,    -1,    -1,    -1,    -1,   223,    -1,   225,
     226,   227,   228,   229,    -1,    -1,   232,    -1,    -1,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   248,    -1,   250,    -1,   252,   253,   254,   255,
      -1,    -1,   258,   259,    -1,   261,    -1,    -1,   264,   265,
     266,    -1,    -1,   269,    -1,    -1,    -1,   273,   274,    -1,
      -1,    -1,    -1,    -1,    -1,   281,   282,   283,    -1,    -1,
      -1,   287,   288,    -1,   290,   291,   292,   293,   294,   295,
     296,   297,    -1,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,    -1,   311,    -1,   313,   314,   315,
     316,   317,   318,    -1,    -1,   321,   322,   323,    -1,   325,
      -1,   327,   328,    -1,   330,   331,    -1,   333,   334,   335,
     336,   337,   338,   339,   340,    -1,   342,    -1,   344,   345,
     346,   347,    -1,   349,   350,    -1,   352,    -1,   354,    -1,
     356,    -1,    -1,   359,   360,   361,   362,   363,    -1,    -1,
     366,   367,   368,   369,   370,    -1,    -1,   373,   374,   375,
     376,   377,    -1,   379,    -1,    -1,    -1,   383,   384,   385,
     386,   387,   388,    -1,   390,    -1,    -1,   393,     6,     7,
       8,     9,    -1,    11,    12,    -1,    14,    15,    16,    17,
      -1,    19,    -1,    21,    -1,    23,    24,    25,    26,    27,
      28,    -1,    30,    31,    32,    33,    -1,    -1,    36,    37,
      38,    39,    -1,    -1,    -1,    43,    44,    45,    -1,    47,
      -1,    -1,    -1,    51,    52,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      78,    79,    80,    81,    82,    83,    84,    85,    86,    87,
      88,    89,    90,    91,    92,    93,    94,    95,    96,    97,
      98,    99,   100,   101,   102,   103,   104,   105,    -1,   107,
     108,   109,    -1,   111,   112,   113,   114,    -1,   116,   117,
     118,   119,   120,   121,   122,   123,   124,   125,   126,   127,
     128,   129,   130,   131,   132,   133,   134,   135,   136,   137,
     138,   139,   140,   141,   142,   143,   144,   145,    -1,   147,
     148,   149,   150,   151,   152,   153,   154,    -1,   156,   157,
     158,   159,   160,   161,   162,   163,   164,   165,   166,   167,
     168,   169,   170,   171,   172,   173,   174,   175,   176,    -1,
     178,   179,   180,   181,   182,   183,   184,   185,   186,   187,
     188,   189,   190,    -1,   192,   193,   194,   195,   196,   197,
      -1,   199,   200,   201,   202,   203,   204,   205,   206,   207,
     208,   209,   210,    -1,   212,   213,   214,    -1,   216,   217,
     218,   219,    -1,   221,   222,   223,   224,   225,   226,   227,
     228,   229,   230,   231,   232,   233,   234,   235,   236,   237,
     238,   239,   240,   241,    -1,   243,   244,    -1,   246,   247,
     248,   249,   250,   251,   252,   253,   254,   255,   256,   257,
     258,   259,   260,   261,   262,   263,   264,   265,   266,   267,
     268,   269,   270,   271,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,   282,   283,    -1,   285,   286,   287,
     288,   289,   290,   291,   292,   293,   294,   295,   296,   297,
     298,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,   317,
      -1,    -1,   320,   321,   322,   323,   324,   325,   326,   327,
     328,   329,   330,   331,   332,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,   343,   344,   345,   346,   347,
     348,   349,   350,    -1,   352,   353,   354,   355,   356,   357,
     358,   359,   360,   361,   362,   363,    -1,   365,   366,   367,
     368,   369,   370,   371,   372,   373,   374,   375,   376,   377,
     378,   379,    -1,   381,   382,   383,   384,   385,   386,    -1,
     388,    -1,   390,    -1,    -1,   393,     6,     7,     8,     9,
      -1,    11,    12,    -1,    14,    15,    16,    17,    -1,    19,
      -1,    21,    -1,    23,    24,    25,    26,    27,    28,    -1,
      30,    31,    32,    33,    -1,    -1,    36,    37,    38,    39,
      -1,    -1,    -1,    43,    44,    45,    -1,    47,    -1,    -1,
      -1,    51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,
      -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,    79,
      80,    81,    82,    83,    84,    -1,    86,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    96,    97,    98,    99,
     100,   101,   102,   103,   104,   105,    -1,    -1,   108,   109,
      -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,   119,
     120,   121,   122,   123,    -1,    -1,   126,   127,   128,    -1,
     130,   131,   132,   133,    -1,   135,   136,   137,   138,    -1,
      -1,    -1,    -1,   143,   144,   145,   146,   147,   148,   149,
     150,    -1,   152,    -1,   154,    -1,   156,   157,   158,    -1,
      -1,    -1,   162,   163,   164,   165,    -1,   167,   168,    -1,
     170,    -1,   172,   173,   174,   175,   176,    -1,   178,    -1,
     180,   181,   182,    -1,   184,    -1,   186,   187,    -1,   189,
     190,    -1,   192,    -1,    -1,   195,    -1,   197,   198,   199,
     200,   201,   202,    -1,   204,   205,   206,   207,    -1,   209,
     210,    -1,   212,   213,   214,    -1,   216,    -1,   218,    -1,
      -1,   221,   222,   223,   224,   225,   226,   227,   228,   229,
      -1,   231,   232,   233,    -1,   235,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   247,   248,   249,
     250,   251,   252,   253,   254,   255,   256,    -1,   258,   259,
     260,   261,    -1,   263,   264,   265,   266,    -1,    -1,   269,
     270,    -1,    -1,   273,   274,    -1,    -1,   277,   278,   279,
     280,   281,   282,   283,    -1,   285,   286,   287,   288,    -1,
     290,   291,   292,   293,   294,   295,   296,   297,    -1,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,   317,   318,    -1,
      -1,   321,   322,   323,    -1,   325,   326,   327,   328,   329,
     330,   331,    -1,   333,   334,   335,   336,   337,   338,   339,
     340,   341,   342,    -1,   344,   345,   346,   347,    -1,   349,
     350,    -1,   352,    -1,   354,   355,   356,   357,    -1,   359,
     360,   361,   362,   363,    -1,    -1,   366,   367,   368,   369,
     370,    -1,    -1,   373,   374,   375,   376,   377,   378,   379,
      -1,    -1,    -1,   383,   384,   385,   386,   387,   388,    -1,
     390,    -1,    -1,   393,     6,     7,     8,     9,    -1,    11,
      12,    -1,    14,    15,    16,    17,    -1,    19,    -1,    21,
      -1,    23,    24,    25,    26,    27,    28,    -1,    30,    31,
      32,    33,    -1,    -1,    36,    37,    38,    39,    -1,    -1,
      -1,    43,    44,    45,    -1,    47,    -1,    -1,    -1,    51,
      52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,
      62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,
      -1,    73,    -1,    75,    76,    -1,    78,    79,    80,    81,
      82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    96,    97,    -1,    99,   100,   101,
      -1,   103,    -1,   105,    -1,    -1,   108,   109,    -1,   111,
      -1,    -1,   114,   115,   116,   117,   118,   119,   120,   121,
     122,   123,    -1,    -1,   126,   127,   128,   129,   130,   131,
     132,   133,    -1,   135,   136,    -1,   138,    -1,    -1,    -1,
      -1,   143,   144,   145,   146,   147,   148,   149,   150,    -1,
     152,    -1,   154,    -1,   156,   157,   158,    -1,    -1,    -1,
     162,   163,   164,   165,    -1,   167,   168,    -1,   170,    -1,
     172,   173,   174,   175,   176,    -1,   178,    -1,   180,   181,
     182,    -1,   184,   185,   186,    -1,    -1,    -1,   190,    -1,
     192,    -1,    -1,   195,    -1,   197,   198,    -1,   200,   201,
     202,    -1,   204,   205,   206,   207,    -1,    -1,   210,    -1,
     212,   213,   214,    -1,   216,    -1,   218,    -1,    -1,    -1,
      -1,   223,    -1,   225,   226,   227,   228,   229,    -1,    -1,
     232,   233,    -1,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,    -1,   250,    -1,
     252,   253,   254,   255,   256,    -1,   258,   259,    -1,   261,
      -1,   263,   264,   265,   266,    -1,    -1,   269,    -1,    -1,
      -1,   273,   274,    -1,    -1,   277,    -1,    -1,   280,   281,
     282,   283,    -1,   285,   286,   287,   288,   289,   290,   291,
     292,   293,   294,   295,   296,   297,    -1,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,    -1,   311,
     312,   313,   314,   315,   316,   317,   318,    -1,    -1,   321,
     322,   323,    -1,   325,   326,   327,   328,    -1,   330,   331,
      -1,   333,   334,   335,   336,   337,   338,   339,   340,   341,
     342,    -1,   344,   345,   346,   347,    -1,   349,   350,    -1,
     352,    -1,   354,   355,   356,   357,    -1,   359,   360,   361,
     362,   363,    -1,   365,   366,   367,   368,   369,   370,    -1,
      -1,   373,   374,   375,   376,   377,    -1,   379,    -1,    -1,
      -1,   383,   384,   385,   386,   387,   388,    -1,   390,    -1,
      -1,   393,     6,     7,     8,     9,    -1,    11,    12,    -1,
      14,    15,    16,    17,    -1,    19,    -1,    21,    -1,    23,
      24,    25,    26,    27,    28,    -1,    30,    31,    32,    33,
      -1,    -1,    36,    37,    38,    39,    -1,    -1,    -1,    43,
      44,    45,    -1,    47,    -1,    -1,    -1,    51,    52,    -1,
      -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,
      -1,    75,    76,    -1,    78,    79,    80,    81,    82,    83,
      84,    -1,    86,    87,    88,    89,    -1,    -1,    -1,    -1,
      -1,    95,    96,    97,    -1,    99,   100,   101,    -1,   103,
      -1,   105,    -1,    -1,   108,   109,    -1,   111,    -1,    -1,
     114,   115,   116,   117,    -1,   119,   120,   121,   122,   123,
      -1,    -1,   126,   127,   128,    -1,   130,   131,   132,   133,
      -1,   135,   136,    -1,   138,    -1,    -1,    -1,    -1,   143,
     144,   145,   146,   147,   148,   149,   150,    -1,   152,    -1,
     154,    -1,   156,   157,   158,    -1,    -1,    -1,   162,   163,
     164,   165,    -1,   167,   168,    -1,   170,    -1,   172,   173,
     174,   175,   176,    -1,   178,    -1,   180,   181,   182,    -1,
     184,    -1,   186,    -1,    -1,    -1,   190,    -1,   192,    -1,
      -1,   195,    -1,   197,   198,    -1,   200,   201,   202,    -1,
     204,   205,   206,   207,    -1,    -1,   210,    -1,   212,   213,
     214,    -1,   216,    -1,   218,    -1,    -1,    -1,    -1,   223,
      -1,   225,   226,   227,   228,   229,    -1,    -1,   232,    -1,
      -1,   235,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   247,   248,    -1,   250,   251,   252,   253,
     254,   255,   256,    -1,   258,   259,    -1,   261,    -1,   263,
     264,   265,   266,    -1,    -1,   269,   270,    -1,    -1,   273,
     274,    -1,    -1,   277,    -1,    -1,   280,   281,   282,   283,
      -1,   285,   286,   287,   288,    -1,   290,   291,   292,   293,
     294,   295,   296,   297,    -1,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,    -1,   311,   312,   313,
     314,   315,   316,   317,   318,    -1,    -1,   321,   322,   323,
      -1,   325,   326,   327,   328,    -1,   330,   331,    -1,   333,
     334,   335,   336,   337,   338,   339,   340,   341,   342,    -1,
     344,   345,   346,   347,    -1,   349,   350,    -1,   352,    -1,
     354,   355,   356,   357,    -1,   359,   360,   361,   362,   363,
      -1,    -1,   366,   367,   368,   369,   370,    -1,    -1,   373,
     374,   375,   376,   377,    -1,   379,    -1,    -1,    -1,   383,
     384,   385,   386,   387,   388,    -1,   390,    -1,    -1,   393,
       6,     7,     8,     9,    -1,    11,    12,    -1,    14,    15,
      16,    17,    -1,    19,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    -1,    30,    31,    32,    33,    -1,    -1,
      36,    37,    38,    39,    -1,    -1,    -1,    43,    44,    45,
      -1,    47,    -1,    -1,    -1,    51,    52,    -1,    -1,    -1,
      56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,
      76,    -1,    78,    79,    80,    81,    82,    83,    84,    -1,
      86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      96,    97,    -1,    99,   100,   101,    -1,   103,    -1,   105,
      -1,    -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,
     116,   117,    -1,   119,   120,   121,   122,   123,    -1,    -1,
     126,   127,   128,    -1,   130,   131,   132,   133,    -1,   135,
     136,    -1,   138,    -1,    -1,    -1,    -1,   143,   144,   145,
     146,   147,   148,   149,   150,    -1,   152,    -1,   154,    -1,
     156,   157,   158,    -1,    -1,    -1,   162,   163,   164,   165,
      -1,   167,   168,    -1,   170,    -1,   172,   173,   174,   175,
     176,    -1,   178,    -1,   180,   181,   182,    -1,   184,    -1,
     186,    -1,    -1,    -1,   190,    -1,   192,    -1,    -1,   195,
      -1,   197,   198,    -1,   200,   201,   202,    -1,   204,   205,
     206,   207,    -1,    -1,   210,    -1,   212,   213,   214,    -1,
     216,    -1,   218,    -1,    -1,    -1,    -1,   223,    -1,   225,
     226,   227,   228,   229,    -1,    -1,   232,    -1,    -1,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   248,    -1,   250,   251,   252,   253,   254,   255,
     256,    -1,   258,   259,    -1,   261,    -1,   263,   264,   265,
     266,    -1,    -1,   269,   270,    -1,   272,   273,   274,    -1,
      -1,   277,    -1,    -1,   280,   281,   282,   283,    -1,   285,
     286,   287,   288,    -1,   290,   291,   292,   293,   294,   295,
     296,   297,    -1,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,    -1,   311,   312,   313,   314,   315,
     316,   317,   318,    -1,    -1,   321,   322,   323,    -1,   325,
     326,   327,   328,    -1,   330,   331,    -1,   333,   334,   335,
     336,   337,   338,   339,   340,   341,   342,    -1,   344,   345,
     346,   347,    -1,   349,   350,    -1,   352,    -1,   354,   355,
     356,   357,    -1,   359,   360,   361,   362,   363,    -1,    -1,
     366,   367,   368,   369,   370,    -1,    -1,   373,   374,   375,
     376,   377,    -1,   379,    -1,    -1,    -1,   383,   384,   385,
     386,   387,   388,    -1,   390,    -1,    -1,   393,     6,     7,
       8,     9,    -1,    11,    12,    -1,    14,    15,    16,    17,
      -1,    19,    -1,    21,    -1,    23,    24,    25,    26,    27,
      28,    -1,    30,    31,    32,    33,    -1,    -1,    36,    37,
      38,    39,    -1,    -1,    -1,    43,    44,    45,    -1,    47,
      -1,    -1,    -1,    51,    52,    -1,    -1,    -1,    56,    57,
      -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,
      78,    79,    80,    81,    82,    83,    84,    -1,    86,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,
      -1,    99,   100,   101,    -1,   103,    -1,   105,    -1,    -1,
     108,   109,    -1,   111,    -1,    -1,   114,   115,   116,   117,
      -1,   119,   120,   121,   122,   123,    -1,    -1,   126,   127,
     128,    -1,   130,   131,   132,   133,    -1,   135,   136,    -1,
     138,    -1,    -1,    -1,    -1,   143,   144,   145,   146,   147,
     148,   149,   150,    -1,   152,    -1,   154,    -1,   156,   157,
     158,    -1,    -1,    -1,   162,   163,   164,   165,    -1,   167,
     168,    -1,   170,    -1,   172,   173,   174,   175,   176,    -1,
     178,    -1,   180,   181,   182,    -1,   184,    -1,   186,    -1,
      -1,    -1,   190,    -1,   192,    -1,    -1,   195,    -1,   197,
     198,    -1,   200,   201,   202,    -1,   204,   205,   206,   207,
      -1,    -1,   210,    -1,   212,   213,   214,    -1,   216,    -1,
     218,    -1,    -1,    -1,    -1,   223,    -1,   225,   226,   227,
     228,   229,    -1,    -1,   232,    -1,    -1,   235,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     248,    -1,   250,   251,   252,   253,   254,   255,   256,    -1,
     258,   259,    -1,   261,    -1,   263,   264,   265,   266,    -1,
      -1,   269,   270,    -1,    -1,   273,   274,    -1,    -1,   277,
      -1,    -1,   280,   281,   282,   283,    -1,   285,   286,   287,
     288,    -1,   290,   291,   292,   293,   294,   295,   296,   297,
      -1,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,    -1,   311,   312,   313,   314,   315,   316,   317,
     318,    -1,    -1,   321,   322,   323,    -1,   325,   326,   327,
     328,    -1,   330,   331,    -1,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,   343,   344,   345,   346,   347,
      -1,   349,   350,    -1,   352,    -1,   354,   355,   356,   357,
      -1,   359,   360,   361,   362,   363,    -1,    -1,   366,   367,
     368,   369,   370,    -1,    -1,   373,   374,   375,   376,   377,
      -1,   379,    -1,    -1,    -1,   383,   384,   385,   386,   387,
     388,    -1,   390,    -1,    -1,   393,     6,     7,     8,     9,
      -1,    11,    12,    -1,    14,    15,    16,    17,    -1,    19,
      -1,    21,    -1,    23,    24,    25,    26,    27,    28,    -1,
      30,    31,    32,    33,    -1,    -1,    36,    37,    38,    39,
      -1,    -1,    -1,    43,    44,    45,    -1,    47,    -1,    -1,
      -1,    51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,
      -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,    79,
      80,    81,    82,    83,    84,    -1,    86,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    96,    97,    -1,    99,
     100,   101,    -1,   103,    -1,   105,    -1,    -1,   108,   109,
      -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,   119,
     120,   121,   122,   123,    -1,    -1,   126,   127,   128,    -1,
     130,   131,   132,   133,    -1,   135,   136,    -1,   138,    -1,
      -1,    -1,    -1,   143,   144,   145,   146,   147,   148,   149,
     150,    -1,   152,    -1,   154,    -1,   156,   157,   158,    -1,
      -1,    -1,   162,   163,   164,   165,    -1,   167,   168,    -1,
     170,    -1,   172,   173,   174,   175,   176,    -1,   178,    -1,
     180,   181,   182,    -1,   184,    -1,   186,    -1,    -1,    -1,
     190,    -1,   192,    -1,    -1,   195,    -1,   197,   198,    -1,
     200,   201,   202,    -1,   204,   205,   206,   207,    -1,    -1,
     210,    -1,   212,   213,   214,    -1,   216,    -1,   218,    -1,
      -1,    -1,    -1,   223,    -1,   225,   226,   227,   228,   229,
      -1,    -1,   232,    -1,    -1,   235,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   247,   248,    -1,
     250,   251,   252,   253,   254,   255,   256,    -1,   258,   259,
      -1,   261,    -1,   263,   264,   265,   266,    -1,    -1,   269,
     270,    -1,    -1,   273,   274,    -1,    -1,   277,    -1,    -1,
     280,   281,   282,   283,    -1,   285,   286,   287,   288,    -1,
     290,   291,   292,   293,   294,   295,   296,   297,    -1,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
      -1,   311,   312,   313,   314,   315,   316,   317,   318,    -1,
      -1,   321,   322,   323,    -1,   325,   326,   327,   328,    -1,
     330,   331,    -1,   333,   334,   335,   336,   337,   338,   339,
     340,   341,   342,    -1,   344,   345,   346,   347,    -1,   349,
     350,    -1,   352,    -1,   354,   355,   356,   357,    -1,   359,
     360,   361,   362,   363,    -1,    -1,   366,   367,   368,   369,
     370,    -1,    -1,   373,   374,   375,   376,   377,    -1,   379,
      -1,    -1,    -1,   383,   384,   385,   386,   387,   388,    -1,
     390,    -1,    -1,   393,     6,     7,     8,     9,    -1,    11,
      12,    -1,    14,    15,    16,    17,    -1,    19,    -1,    21,
      -1,    23,    24,    25,    26,    27,    28,    -1,    30,    31,
      32,    33,    -1,    -1,    36,    37,    38,    39,    -1,    -1,
      -1,    43,    44,    45,    -1,    47,    -1,    -1,    -1,    51,
      52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,
      62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,
      -1,    73,    -1,    75,    76,    -1,    78,    79,    80,    81,
      82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    96,    97,    -1,    99,   100,   101,
      -1,   103,    -1,   105,    -1,    -1,   108,   109,    -1,   111,
      -1,    -1,   114,   115,   116,   117,    -1,   119,   120,   121,
     122,   123,    -1,    -1,   126,   127,   128,    -1,   130,   131,
     132,   133,    -1,   135,   136,    -1,   138,    -1,    -1,    -1,
      -1,   143,   144,   145,   146,   147,   148,   149,   150,    -1,
     152,    -1,   154,    -1,   156,   157,   158,    -1,    -1,    -1,
     162,   163,   164,   165,    -1,   167,   168,    -1,   170,    -1,
     172,   173,   174,   175,   176,    -1,   178,    -1,   180,   181,
     182,    -1,   184,    -1,   186,    -1,   188,    -1,   190,    -1,
     192,    -1,    -1,   195,    -1,   197,   198,    -1,   200,   201,
     202,   203,   204,   205,   206,   207,    -1,    -1,   210,    -1,
     212,   213,   214,    -1,   216,    -1,   218,    -1,    -1,    -1,
      -1,   223,    -1,   225,   226,   227,   228,   229,    -1,    -1,
     232,    -1,    -1,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,    -1,   250,    -1,
     252,   253,   254,   255,   256,    -1,   258,   259,    -1,   261,
      -1,   263,   264,   265,   266,    -1,    -1,   269,    -1,    -1,
      -1,   273,   274,    -1,    -1,   277,    -1,    -1,   280,   281,
     282,   283,    -1,   285,   286,   287,   288,    -1,   290,   291,
     292,   293,   294,   295,   296,   297,    -1,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,    -1,   311,
     312,   313,   314,   315,   316,   317,   318,    -1,    -1,   321,
     322,   323,    -1,   325,   326,   327,   328,    -1,   330,   331,
      -1,   333,   334,   335,   336,   337,   338,   339,   340,   341,
     342,    -1,   344,   345,   346,   347,    -1,   349,   350,    -1,
     352,    -1,   354,   355,   356,   357,    -1,   359,   360,   361,
     362,   363,    -1,    -1,   366,   367,   368,   369,   370,    -1,
      -1,   373,   374,   375,   376,   377,    -1,   379,    -1,    -1,
      -1,   383,   384,   385,   386,   387,   388,    -1,   390,    -1,
      -1,   393,     6,     7,     8,     9,    -1,    11,    12,    -1,
      14,    15,    16,    17,    -1,    19,    -1,    21,    -1,    23,
      24,    25,    26,    27,    28,    -1,    30,    31,    32,    33,
      -1,    -1,    36,    37,    38,    39,    -1,    -1,    -1,    43,
      44,    45,    -1,    47,    -1,    -1,    -1,    51,    52,    -1,
      -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,
      -1,    75,    76,    -1,    78,    79,    80,    81,    82,    83,
      84,    85,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    95,    96,    97,    -1,    99,   100,   101,    -1,   103,
      -1,   105,    -1,    -1,   108,   109,    -1,   111,    -1,    -1,
     114,   115,   116,   117,    -1,   119,   120,   121,   122,   123,
      -1,    -1,   126,   127,   128,    -1,   130,   131,   132,   133,
      -1,   135,   136,    -1,   138,    -1,    -1,    -1,    -1,   143,
     144,   145,   146,   147,   148,   149,   150,    -1,   152,    -1,
     154,    -1,   156,   157,   158,    -1,    -1,    -1,   162,   163,
     164,   165,    -1,   167,   168,    -1,   170,    -1,   172,   173,
     174,   175,   176,    -1,   178,    -1,   180,   181,   182,    -1,
     184,    -1,   186,    -1,    -1,    -1,   190,    -1,   192,    -1,
      -1,   195,    -1,   197,   198,    -1,   200,   201,   202,    -1,
     204,   205,   206,   207,    -1,    -1,   210,    -1,   212,   213,
     214,    -1,   216,    -1,   218,    -1,    -1,    -1,    -1,   223,
      -1,   225,   226,   227,   228,   229,    -1,    -1,   232,    -1,
      -1,   235,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   247,   248,    -1,   250,    -1,   252,   253,
     254,   255,   256,    -1,   258,   259,    -1,   261,    -1,   263,
     264,   265,   266,    -1,    -1,   269,    -1,    -1,    -1,   273,
     274,    -1,    -1,   277,    -1,    -1,   280,   281,   282,   283,
      -1,   285,   286,   287,   288,    -1,   290,   291,   292,   293,
     294,   295,   296,   297,    -1,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,    -1,   311,   312,   313,
     314,   315,   316,   317,   318,    -1,    -1,   321,   322,   323,
      -1,   325,   326,   327,   328,    -1,   330,   331,    -1,   333,
     334,   335,   336,   337,   338,   339,   340,   341,   342,    -1,
     344,   345,   346,   347,    -1,   349,   350,    -1,   352,    -1,
     354,   355,   356,   357,    -1,   359,   360,   361,   362,   363,
      -1,    -1,   366,   367,   368,   369,   370,    -1,    -1,   373,
     374,   375,   376,   377,    -1,   379,    -1,    -1,    -1,   383,
     384,   385,   386,   387,   388,    -1,   390,    -1,    -1,   393,
       6,     7,     8,     9,    -1,    11,    12,    -1,    14,    15,
      16,    17,    -1,    19,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    -1,    30,    31,    32,    33,    -1,    -1,
      36,    37,    38,    39,    -1,    -1,    -1,    43,    44,    45,
      -1,    47,    -1,    -1,    -1,    51,    52,    -1,    -1,    -1,
      56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,
      76,    -1,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      96,    97,    -1,    99,   100,   101,    -1,   103,    -1,   105,
      -1,    -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,
     116,   117,    -1,   119,   120,   121,   122,   123,    -1,    -1,
     126,   127,   128,    -1,   130,   131,   132,   133,    -1,   135,
     136,    -1,   138,    -1,    -1,    -1,    -1,   143,   144,   145,
     146,   147,   148,   149,   150,    -1,   152,    -1,   154,    -1,
     156,   157,   158,    -1,    -1,    -1,   162,   163,   164,   165,
      -1,   167,   168,    -1,   170,    -1,   172,   173,   174,   175,
     176,    -1,   178,    -1,   180,   181,   182,    -1,   184,    -1,
     186,    -1,    -1,    -1,   190,    -1,   192,    -1,    -1,   195,
      -1,   197,   198,    -1,   200,   201,   202,    -1,   204,   205,
     206,   207,    -1,    -1,   210,    -1,   212,   213,   214,    -1,
     216,    -1,   218,    -1,    -1,    -1,    -1,   223,    -1,   225,
     226,   227,   228,   229,    -1,    -1,   232,    -1,    -1,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   248,    -1,   250,    -1,   252,   253,   254,   255,
     256,    -1,   258,   259,    -1,   261,    -1,   263,   264,   265,
     266,    -1,    -1,   269,    -1,    -1,    -1,   273,   274,    -1,
      -1,   277,    -1,    -1,   280,   281,   282,   283,    -1,   285,
     286,   287,   288,    -1,   290,   291,   292,   293,   294,   295,
     296,   297,    -1,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,    -1,   311,   312,   313,   314,   315,
     316,   317,   318,    -1,    -1,   321,   322,   323,    -1,   325,
     326,   327,   328,    -1,   330,   331,    -1,   333,   334,   335,
     336,   337,   338,   339,   340,   341,   342,    -1,   344,   345,
     346,   347,    -1,   349,   350,    -1,   352,    -1,   354,   355,
     356,   357,    -1,   359,   360,   361,   362,   363,    -1,    -1,
     366,   367,   368,   369,   370,    -1,    -1,   373,   374,   375,
     376,   377,    -1,   379,    -1,    -1,    -1,   383,   384,   385,
     386,   387,   388,    -1,   390,    -1,    -1,   393,     6,     7,
       8,     9,    -1,    11,    12,    -1,    14,    15,    16,    17,
      -1,    19,    -1,    21,    -1,    23,    24,    25,    26,    27,
      28,    -1,    30,    31,    32,    33,    -1,    -1,    36,    37,
      38,    39,    -1,    -1,    -1,    43,    44,    45,    -1,    47,
      -1,    -1,    -1,    51,    52,    -1,    -1,    -1,    56,    57,
      -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,
      78,    79,    80,    81,    82,    83,    84,    85,    86,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,
      -1,    99,   100,   101,    -1,   103,    -1,   105,    -1,    -1,
     108,   109,    -1,   111,    -1,    -1,   114,   115,   116,   117,
      -1,   119,   120,   121,   122,   123,    -1,    -1,   126,   127,
     128,    -1,   130,   131,   132,   133,    -1,   135,   136,    -1,
     138,    -1,    -1,    -1,    -1,   143,   144,   145,   146,   147,
     148,   149,   150,    -1,   152,    -1,   154,    -1,   156,   157,
     158,    -1,    -1,    -1,   162,   163,   164,   165,    -1,   167,
     168,    -1,   170,    -1,   172,   173,   174,   175,   176,    -1,
     178,    -1,   180,   181,   182,    -1,   184,    -1,   186,    -1,
      -1,    -1,   190,    -1,   192,    -1,    -1,   195,    -1,   197,
     198,    -1,   200,   201,   202,    -1,   204,   205,   206,   207,
      -1,    -1,   210,    -1,   212,   213,   214,    -1,   216,    -1,
     218,    -1,    -1,    -1,    -1,   223,    -1,   225,   226,   227,
     228,   229,    -1,    -1,   232,    -1,    -1,   235,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     248,    -1,   250,    -1,   252,   253,   254,   255,   256,    -1,
     258,   259,    -1,   261,    -1,   263,   264,   265,   266,    -1,
      -1,   269,    -1,    -1,    -1,   273,   274,    -1,    -1,   277,
      -1,    -1,   280,   281,   282,   283,    -1,   285,   286,   287,
     288,    -1,   290,   291,   292,   293,   294,   295,   296,   297,
      -1,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,    -1,   311,   312,   313,   314,   315,   316,   317,
     318,    -1,    -1,   321,   322,   323,    -1,   325,   326,   327,
     328,    -1,   330,   331,    -1,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,    -1,   344,   345,   346,   347,
      -1,   349,   350,    -1,   352,    -1,   354,   355,   356,   357,
      -1,   359,   360,   361,   362,   363,    -1,    -1,   366,   367,
     368,   369,   370,    -1,    -1,   373,   374,   375,   376,   377,
      -1,   379,    -1,    -1,    -1,   383,   384,   385,   386,   387,
     388,    -1,   390,    -1,    -1,   393,     6,     7,     8,     9,
      -1,    11,    12,    -1,    14,    15,    16,    17,    -1,    19,
      -1,    21,    -1,    23,    24,    25,    26,    27,    28,    -1,
      30,    31,    32,    33,    -1,    -1,    36,    37,    38,    39,
      -1,    -1,    -1,    43,    44,    45,    -1,    47,    -1,    -1,
      -1,    51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,
      -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,    79,
      80,    81,    82,    83,    84,    -1,    86,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    96,    97,    98,    99,
     100,   101,    -1,   103,    -1,   105,    -1,    -1,   108,   109,
      -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,   119,
     120,   121,   122,   123,    -1,    -1,   126,   127,   128,    -1,
     130,   131,   132,   133,    -1,   135,   136,    -1,   138,    -1,
      -1,    -1,    -1,   143,   144,   145,   146,   147,   148,   149,
     150,    -1,   152,    -1,   154,    -1,   156,   157,   158,    -1,
      -1,    -1,   162,   163,   164,   165,    -1,   167,   168,    -1,
     170,    -1,   172,   173,   174,   175,   176,    -1,   178,    -1,
     180,   181,   182,    -1,   184,    -1,   186,    -1,    -1,    -1,
     190,    -1,   192,    -1,    -1,   195,    -1,   197,   198,    -1,
     200,   201,   202,    -1,   204,   205,   206,   207,    -1,    -1,
     210,    -1,   212,   213,   214,    -1,   216,    -1,   218,    -1,
      -1,    -1,    -1,   223,    -1,   225,   226,   227,   228,   229,
      -1,    -1,   232,    -1,    -1,   235,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   247,   248,    -1,
     250,    -1,   252,   253,   254,   255,   256,    -1,   258,   259,
      -1,   261,    -1,   263,   264,   265,   266,    -1,    -1,   269,
      -1,    -1,    -1,   273,   274,    -1,    -1,   277,    -1,    -1,
     280,   281,   282,   283,    -1,   285,   286,   287,   288,    -1,
     290,   291,   292,   293,   294,   295,   296,   297,    -1,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
      -1,   311,   312,   313,   314,   315,   316,   317,   318,    -1,
      -1,   321,   322,   323,    -1,   325,   326,   327,   328,    -1,
     330,   331,    -1,   333,   334,   335,   336,   337,   338,   339,
     340,   341,   342,    -1,   344,   345,   346,   347,    -1,   349,
     350,    -1,   352,    -1,   354,   355,   356,   357,    -1,   359,
     360,   361,   362,   363,    -1,    -1,   366,   367,   368,   369,
     370,    -1,    -1,   373,   374,   375,   376,   377,    -1,   379,
      -1,    -1,    -1,   383,   384,   385,   386,   387,   388,    -1,
     390,    -1,    -1,   393,     6,     7,     8,     9,    -1,    11,
      12,    -1,    14,    15,    16,    17,    -1,    19,    -1,    21,
      -1,    23,    24,    25,    26,    27,    28,    -1,    30,    31,
      32,    33,    -1,    -1,    36,    37,    38,    39,    -1,    -1,
      -1,    43,    44,    45,    -1,    47,    -1,    -1,    -1,    51,
      52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,
      62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,
      -1,    73,    -1,    75,    76,    -1,    78,    79,    80,    81,
      82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    96,    97,    -1,    99,   100,   101,
      -1,   103,    -1,   105,    -1,    -1,   108,   109,    -1,   111,
      -1,    -1,   114,   115,   116,   117,    -1,   119,   120,   121,
     122,   123,    -1,    -1,   126,   127,   128,    -1,   130,   131,
     132,   133,    -1,   135,   136,    -1,   138,    -1,    -1,    -1,
      -1,   143,   144,   145,   146,   147,   148,   149,   150,    -1,
     152,    -1,   154,    -1,   156,   157,   158,    -1,    -1,    -1,
     162,   163,   164,   165,    -1,   167,   168,    -1,   170,    -1,
     172,   173,   174,   175,   176,    -1,   178,    -1,   180,   181,
     182,    -1,   184,    -1,   186,    -1,    -1,    -1,   190,    -1,
     192,    -1,   194,   195,    -1,   197,   198,    -1,   200,   201,
     202,    -1,   204,   205,   206,   207,    -1,    -1,   210,    -1,
     212,   213,   214,    -1,   216,    -1,   218,    -1,    -1,    -1,
      -1,   223,    -1,   225,   226,   227,   228,   229,    -1,    -1,
     232,    -1,    -1,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,    -1,   250,    -1,
     252,   253,   254,   255,   256,    -1,   258,   259,    -1,   261,
      -1,   263,   264,   265,   266,    -1,    -1,   269,    -1,    -1,
      -1,   273,   274,    -1,    -1,   277,    -1,    -1,   280,   281,
     282,   283,    -1,   285,   286,   287,   288,    -1,   290,   291,
     292,   293,   294,   295,   296,   297,    -1,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,    -1,   311,
     312,   313,   314,   315,   316,   317,   318,    -1,    -1,   321,
     322,   323,    -1,   325,   326,   327,   328,    -1,   330,   331,
      -1,   333,   334,   335,   336,   337,   338,   339,   340,   341,
     342,    -1,   344,   345,   346,   347,    -1,   349,   350,    -1,
     352,    -1,   354,   355,   356,   357,    -1,   359,   360,   361,
     362,   363,    -1,    -1,   366,   367,   368,   369,   370,    -1,
      -1,   373,   374,   375,   376,   377,    -1,   379,    -1,    -1,
      -1,   383,   384,   385,   386,   387,   388,    -1,   390,    -1,
      -1,   393,     6,     7,     8,     9,    -1,    11,    12,    -1,
      14,    15,    16,    17,    -1,    19,    -1,    21,    -1,    23,
      24,    25,    26,    27,    28,    -1,    30,    31,    32,    33,
      -1,    -1,    36,    37,    38,    39,    -1,    -1,    -1,    43,
      44,    45,    -1,    47,    -1,    -1,    -1,    51,    52,    -1,
      -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,
      -1,    75,    76,    -1,    78,    79,    80,    81,    82,    83,
      84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    95,    96,    97,    -1,    99,   100,   101,    -1,   103,
      -1,   105,    -1,    -1,   108,   109,    -1,   111,    -1,    -1,
     114,   115,   116,   117,    -1,   119,   120,   121,   122,   123,
      -1,    -1,   126,   127,   128,    -1,   130,   131,   132,   133,
      -1,   135,   136,    -1,   138,    -1,    -1,    -1,    -1,   143,
     144,   145,   146,   147,   148,   149,   150,   151,   152,    -1,
     154,    -1,   156,   157,   158,    -1,    -1,    -1,   162,   163,
     164,   165,    -1,   167,   168,    -1,   170,    -1,   172,   173,
     174,   175,   176,    -1,   178,    -1,   180,   181,   182,    -1,
     184,    -1,   186,    -1,    -1,    -1,   190,    -1,   192,    -1,
      -1,   195,    -1,   197,   198,    -1,   200,   201,   202,    -1,
     204,   205,   206,   207,    -1,    -1,   210,    -1,   212,   213,
     214,    -1,   216,    -1,   218,    -1,    -1,    -1,    -1,   223,
      -1,   225,   226,   227,   228,   229,    -1,    -1,   232,    -1,
      -1,   235,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   247,   248,    -1,   250,    -1,   252,   253,
     254,   255,   256,    -1,   258,   259,    -1,   261,    -1,   263,
     264,   265,   266,    -1,    -1,   269,    -1,    -1,    -1,   273,
     274,    -1,    -1,   277,    -1,    -1,   280,   281,   282,   283,
      -1,   285,   286,   287,   288,    -1,   290,   291,   292,   293,
     294,   295,   296,   297,    -1,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,    -1,   311,   312,   313,
     314,   315,   316,   317,   318,    -1,    -1,   321,   322,   323,
      -1,   325,   326,   327,   328,    -1,   330,   331,    -1,   333,
     334,   335,   336,   337,   338,   339,   340,   341,   342,    -1,
     344,   345,   346,   347,    -1,   349,   350,    -1,   352,    -1,
     354,   355,   356,   357,    -1,   359,   360,   361,   362,   363,
      -1,    -1,   366,   367,   368,   369,   370,    -1,    -1,   373,
     374,   375,   376,   377,    -1,   379,    -1,    -1,    -1,   383,
     384,   385,   386,   387,   388,    -1,   390,    -1,    -1,   393,
       6,     7,     8,     9,    -1,    11,    12,    -1,    14,    15,
      16,    17,    -1,    19,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    -1,    30,    31,    32,    33,    -1,    -1,
      36,    37,    38,    39,    -1,    -1,    -1,    43,    44,    45,
      -1,    47,    -1,    -1,    -1,    51,    52,    -1,    -1,    -1,
      56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,
      76,    -1,    78,    79,    80,    81,    82,    83,    84,    -1,
      86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      96,    97,    -1,    99,   100,   101,    -1,   103,    -1,   105,
      -1,    -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,
     116,   117,    -1,   119,   120,   121,   122,   123,    -1,    -1,
     126,   127,   128,    -1,   130,   131,   132,   133,    -1,   135,
     136,    -1,   138,    -1,    -1,    -1,    -1,   143,   144,   145,
     146,   147,   148,   149,   150,   151,   152,    -1,   154,    -1,
     156,   157,   158,    -1,    -1,    -1,   162,   163,   164,   165,
      -1,   167,   168,    -1,   170,    -1,   172,   173,   174,   175,
     176,    -1,   178,    -1,   180,   181,   182,    -1,   184,    -1,
     186,    -1,    -1,    -1,   190,    -1,   192,    -1,    -1,   195,
      -1,   197,   198,    -1,   200,   201,   202,    -1,   204,   205,
     206,   207,    -1,    -1,   210,    -1,   212,   213,   214,    -1,
     216,    -1,   218,    -1,    -1,    -1,    -1,   223,    -1,   225,
     226,   227,   228,   229,    -1,    -1,   232,    -1,    -1,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   248,    -1,   250,    -1,   252,   253,   254,   255,
     256,    -1,   258,   259,    -1,   261,    -1,   263,   264,   265,
     266,    -1,    -1,   269,    -1,    -1,    -1,   273,   274,    -1,
      -1,   277,    -1,    -1,   280,   281,   282,   283,    -1,   285,
     286,   287,   288,    -1,   290,   291,   292,   293,   294,   295,
     296,   297,    -1,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,    -1,   311,   312,   313,   314,   315,
     316,   317,   318,    -1,    -1,   321,   322,   323,    -1,   325,
     326,   327,   328,    -1,   330,   331,    -1,   333,   334,   335,
     336,   337,   338,   339,   340,   341,   342,    -1,   344,   345,
     346,   347,    -1,   349,   350,    -1,   352,    -1,   354,   355,
     356,   357,    -1,   359,   360,   361,   362,   363,    -1,    -1,
     366,   367,   368,   369,   370,    -1,    -1,   373,   374,   375,
     376,   377,    -1,   379,    -1,    -1,    -1,   383,   384,   385,
     386,   387,   388,    -1,   390,    -1,    -1,   393,     6,     7,
       8,     9,    -1,    11,    12,    -1,    14,    15,    16,    17,
      -1,    19,    -1,    21,    -1,    23,    24,    25,    26,    27,
      28,    -1,    30,    31,    32,    33,    -1,    -1,    36,    37,
      38,    39,    -1,    -1,    -1,    43,    44,    45,    -1,    47,
      -1,    -1,    -1,    51,    52,    -1,    -1,    -1,    56,    57,
      -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,
      78,    79,    80,    81,    82,    83,    84,    -1,    86,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,
      -1,    99,   100,   101,    -1,   103,    -1,   105,    -1,    -1,
     108,   109,    -1,   111,    -1,    -1,   114,   115,   116,   117,
      -1,   119,   120,   121,   122,   123,    -1,    -1,   126,   127,
     128,    -1,   130,   131,   132,   133,    -1,   135,   136,    -1,
     138,    -1,    -1,    -1,    -1,   143,   144,   145,   146,   147,
     148,   149,   150,   151,   152,    -1,   154,    -1,   156,   157,
     158,    -1,    -1,    -1,   162,   163,   164,   165,    -1,   167,
     168,    -1,   170,    -1,   172,   173,   174,   175,   176,    -1,
     178,    -1,   180,   181,   182,    -1,   184,    -1,   186,    -1,
      -1,    -1,   190,    -1,   192,    -1,    -1,   195,    -1,   197,
     198,    -1,   200,   201,   202,    -1,   204,   205,   206,   207,
      -1,    -1,   210,    -1,   212,   213,   214,    -1,   216,    -1,
     218,    -1,    -1,    -1,    -1,   223,    -1,   225,   226,   227,
     228,   229,    -1,    -1,   232,    -1,    -1,   235,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     248,    -1,   250,    -1,   252,   253,   254,   255,   256,    -1,
     258,   259,    -1,   261,    -1,   263,   264,   265,   266,    -1,
      -1,   269,    -1,    -1,    -1,   273,   274,    -1,    -1,   277,
      -1,    -1,   280,   281,   282,   283,    -1,   285,   286,   287,
     288,    -1,   290,   291,   292,   293,   294,   295,   296,   297,
      -1,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,    -1,   311,   312,   313,   314,   315,   316,   317,
     318,    -1,    -1,   321,   322,   323,    -1,   325,   326,   327,
     328,    -1,   330,   331,    -1,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,    -1,   344,   345,   346,   347,
      -1,   349,   350,    -1,   352,    -1,   354,   355,   356,   357,
      -1,   359,   360,   361,   362,   363,    -1,    -1,   366,   367,
     368,   369,   370,    -1,    -1,   373,   374,   375,   376,   377,
      -1,   379,    -1,    -1,    -1,   383,   384,   385,   386,   387,
     388,    -1,   390,    -1,    -1,   393,     6,     7,     8,     9,
      -1,    11,    12,    -1,    14,    15,    16,    17,    -1,    19,
      -1,    21,    -1,    23,    24,    25,    26,    27,    28,    -1,
      30,    31,    32,    33,    -1,    -1,    36,    37,    38,    39,
      -1,    -1,    -1,    43,    44,    45,    -1,    47,    -1,    -1,
      -1,    51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,
      -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,    79,
      80,    81,    82,    83,    84,    -1,    86,    87,    -1,    -1,
      -1,    -1,    -1,    93,    -1,    95,    96,    97,    -1,    99,
     100,   101,    -1,   103,    -1,   105,    -1,    -1,   108,   109,
      -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,   119,
     120,   121,   122,   123,    -1,    -1,   126,   127,   128,    -1,
     130,   131,   132,   133,    -1,   135,   136,    -1,   138,    -1,
      -1,    -1,    -1,   143,   144,   145,   146,   147,   148,   149,
     150,    -1,   152,    -1,   154,    -1,   156,   157,   158,    -1,
      -1,    -1,   162,   163,   164,   165,    -1,   167,   168,    -1,
     170,    -1,   172,   173,   174,   175,   176,    -1,   178,    -1,
     180,   181,   182,    -1,   184,    -1,   186,    -1,    -1,    -1,
     190,    -1,   192,    -1,    -1,   195,    -1,   197,   198,    -1,
     200,   201,   202,    -1,   204,   205,   206,   207,    -1,    -1,
     210,    -1,   212,   213,   214,    -1,   216,    -1,   218,    -1,
      -1,    -1,    -1,   223,    -1,   225,   226,   227,   228,   229,
      -1,    -1,   232,    -1,    -1,   235,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   247,   248,    -1,
     250,    -1,   252,   253,   254,   255,   256,    -1,   258,   259,
      -1,   261,    -1,   263,   264,   265,   266,    -1,    -1,   269,
      -1,    -1,    -1,   273,   274,    -1,    -1,   277,    -1,    -1,
     280,   281,   282,   283,    -1,   285,   286,   287,   288,    -1,
     290,   291,   292,   293,   294,   295,   296,   297,    -1,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
      -1,   311,   312,   313,   314,   315,   316,   317,   318,    -1,
      -1,   321,   322,   323,    -1,   325,   326,   327,   328,    -1,
     330,   331,    -1,   333,   334,   335,   336,   337,   338,   339,
     340,   341,   342,    -1,   344,   345,   346,   347,    -1,   349,
     350,    -1,   352,    -1,   354,   355,   356,   357,    -1,   359,
     360,   361,   362,   363,    -1,    -1,   366,   367,   368,   369,
     370,    -1,    -1,   373,   374,   375,   376,   377,    -1,   379,
      -1,    -1,    -1,   383,   384,   385,   386,   387,   388,    -1,
     390,    -1,    -1,   393,     6,     7,     8,     9,    -1,    11,
      12,    -1,    14,    15,    16,    17,    -1,    19,    -1,    21,
      -1,    23,    24,    25,    26,    27,    28,    -1,    30,    31,
      32,    33,    -1,    -1,    36,    37,    38,    39,    -1,    -1,
      -1,    43,    44,    45,    -1,    47,    -1,    -1,    -1,    51,
      52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,
      62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,
      -1,    73,    -1,    75,    76,    -1,    78,    79,    80,    81,
      82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,
      -1,    93,    -1,    95,    96,    97,    -1,    99,   100,   101,
      -1,   103,    -1,   105,    -1,    -1,   108,   109,    -1,   111,
      -1,    -1,   114,   115,   116,   117,    -1,   119,   120,   121,
     122,   123,    -1,    -1,   126,   127,   128,    -1,   130,   131,
     132,   133,    -1,   135,   136,    -1,   138,    -1,    -1,    -1,
      -1,   143,   144,   145,   146,   147,   148,   149,   150,    -1,
     152,    -1,   154,    -1,   156,   157,   158,    -1,    -1,    -1,
     162,   163,   164,   165,    -1,   167,   168,    -1,   170,    -1,
     172,   173,   174,   175,   176,    -1,   178,    -1,   180,   181,
     182,    -1,   184,    -1,   186,    -1,    -1,    -1,   190,    -1,
     192,    -1,    -1,   195,    -1,   197,   198,    -1,   200,   201,
     202,    -1,   204,   205,   206,   207,    -1,    -1,   210,    -1,
     212,   213,   214,    -1,   216,    -1,   218,    -1,    -1,    -1,
      -1,   223,    -1,   225,   226,   227,   228,   229,    -1,    -1,
     232,    -1,    -1,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,    -1,   250,    -1,
     252,   253,   254,   255,   256,    -1,   258,   259,    -1,   261,
      -1,   263,   264,   265,   266,    -1,    -1,   269,    -1,    -1,
      -1,   273,   274,    -1,    -1,   277,    -1,    -1,   280,   281,
     282,   283,    -1,   285,   286,   287,   288,    -1,   290,   291,
     292,   293,   294,   295,   296,   297,    -1,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,    -1,   311,
     312,   313,   314,   315,   316,   317,   318,    -1,    -1,   321,
     322,   323,    -1,   325,   326,   327,   328,    -1,   330,   331,
      -1,   333,   334,   335,   336,   337,   338,   339,   340,   341,
     342,    -1,   344,   345,   346,   347,    -1,   349,   350,    -1,
     352,    -1,   354,   355,   356,   357,    -1,   359,   360,   361,
     362,   363,    -1,    -1,   366,   367,   368,   369,   370,    -1,
      -1,   373,   374,   375,   376,   377,    -1,   379,    -1,    -1,
      -1,   383,   384,   385,   386,   387,   388,    -1,   390,    -1,
      -1,   393,     6,     7,     8,     9,    -1,    11,    12,    -1,
      14,    15,    16,    17,    -1,    19,    -1,    21,    -1,    23,
      24,    25,    26,    27,    28,    -1,    30,    31,    32,    33,
      -1,    -1,    36,    37,    38,    39,    -1,    -1,    -1,    43,
      44,    45,    -1,    47,    -1,    -1,    -1,    51,    52,    -1,
      -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,
      -1,    75,    76,    -1,    78,    79,    80,    81,    82,    83,
      84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    95,    96,    97,    -1,    99,   100,   101,    -1,   103,
      -1,   105,    -1,    -1,   108,   109,    -1,   111,    -1,    -1,
     114,   115,   116,   117,    -1,   119,   120,   121,   122,   123,
      -1,    -1,   126,   127,   128,    -1,   130,   131,   132,   133,
      -1,   135,   136,    -1,   138,    -1,    -1,    -1,    -1,   143,
     144,   145,   146,   147,   148,   149,   150,    -1,   152,    -1,
     154,    -1,   156,   157,   158,    -1,    -1,    -1,   162,   163,
     164,   165,    -1,   167,   168,    -1,   170,    -1,   172,   173,
     174,   175,   176,    -1,   178,    -1,   180,   181,   182,    -1,
     184,    -1,   186,    -1,    -1,    -1,   190,    -1,   192,    -1,
      -1,   195,    -1,   197,   198,    -1,   200,   201,   202,    -1,
     204,   205,   206,   207,    -1,    -1,   210,    -1,   212,   213,
     214,    -1,   216,    -1,   218,    -1,    -1,    -1,    -1,   223,
      -1,   225,   226,   227,   228,   229,    -1,    -1,   232,    -1,
      -1,   235,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   247,   248,    -1,   250,    -1,   252,   253,
     254,   255,   256,    -1,   258,   259,    -1,   261,    -1,   263,
     264,   265,   266,    -1,    -1,   269,    -1,    -1,    -1,   273,
     274,    -1,    -1,   277,    -1,    -1,   280,   281,   282,   283,
      -1,   285,   286,   287,   288,    -1,   290,   291,   292,   293,
     294,   295,   296,   297,    -1,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,    -1,   311,   312,   313,
     314,   315,   316,   317,   318,    -1,    -1,   321,   322,   323,
      -1,   325,   326,   327,   328,    -1,   330,   331,    -1,   333,
     334,   335,   336,   337,   338,   339,   340,   341,   342,    -1,
     344,   345,   346,   347,    -1,   349,   350,    -1,   352,    -1,
     354,   355,   356,   357,    -1,   359,   360,   361,   362,   363,
      -1,    -1,   366,   367,   368,   369,   370,    -1,   372,   373,
     374,   375,   376,   377,    -1,   379,    -1,    -1,    -1,   383,
     384,   385,   386,   387,   388,    -1,   390,    -1,    -1,   393,
       6,     7,     8,     9,    -1,    11,    12,    -1,    14,    15,
      16,    17,    -1,    19,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    -1,    30,    31,    32,    33,    -1,    -1,
      36,    37,    38,    39,    -1,    -1,    -1,    43,    44,    45,
      -1,    47,    -1,    -1,    -1,    51,    52,    -1,    -1,    -1,
      56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,
      76,    -1,    78,    79,    80,    81,    82,    83,    84,    -1,
      86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      96,    97,    -1,    99,   100,   101,    -1,   103,    -1,   105,
      -1,    -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,
     116,   117,    -1,   119,   120,   121,   122,   123,    -1,    -1,
     126,   127,   128,    -1,   130,   131,   132,   133,    -1,   135,
     136,    -1,   138,    -1,    -1,    -1,    -1,   143,   144,   145,
     146,   147,   148,   149,   150,    -1,   152,    -1,   154,    -1,
     156,   157,   158,    -1,    -1,    -1,   162,   163,   164,   165,
      -1,   167,   168,    -1,   170,    -1,   172,   173,   174,   175,
     176,    -1,   178,    -1,   180,   181,   182,    -1,   184,    -1,
     186,    -1,    -1,    -1,   190,    -1,   192,    -1,    -1,   195,
      -1,   197,   198,    -1,   200,   201,   202,    -1,   204,   205,
     206,   207,    -1,    -1,   210,    -1,   212,   213,   214,    -1,
     216,    -1,   218,    -1,    -1,    -1,    -1,   223,    -1,   225,
     226,   227,   228,   229,    -1,    -1,   232,    -1,    -1,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   248,    -1,   250,    -1,   252,   253,   254,   255,
     256,    -1,   258,   259,    -1,   261,    -1,   263,   264,   265,
     266,    -1,    -1,   269,    -1,    -1,    -1,   273,   274,    -1,
      -1,   277,    -1,    -1,   280,   281,   282,   283,    -1,   285,
     286,   287,   288,    -1,   290,   291,   292,   293,   294,   295,
     296,   297,    -1,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,    -1,   311,   312,   313,   314,   315,
     316,   317,   318,    -1,    -1,   321,   322,   323,    -1,   325,
     326,   327,   328,    -1,   330,   331,    -1,   333,   334,   335,
     336,   337,   338,   339,   340,   341,   342,    -1,   344,   345,
     346,   347,    -1,   349,   350,    -1,   352,    -1,   354,   355,
     356,   357,    -1,   359,   360,   361,   362,   363,    -1,    -1,
     366,   367,   368,   369,   370,    -1,    -1,   373,   374,   375,
     376,   377,    -1,   379,    -1,    -1,    -1,   383,   384,   385,
     386,   387,   388,    -1,   390,    -1,    -1,   393,     6,     7,
       8,     9,    -1,    11,    12,    -1,    14,    15,    16,    17,
      -1,    19,    -1,    21,    -1,    23,    24,    25,    26,    27,
      28,    -1,    30,    31,    32,    33,    -1,    -1,    36,    37,
      38,    39,    -1,    -1,    -1,    43,    44,    45,    -1,    47,
      -1,    -1,    -1,    51,    52,    -1,    -1,    -1,    56,    57,
      -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,
      78,    79,    80,    81,    82,    83,    84,    -1,    86,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,
      -1,    99,   100,   101,    -1,   103,    -1,   105,    -1,    -1,
     108,   109,    -1,   111,    -1,    -1,   114,   115,   116,   117,
      -1,   119,   120,   121,   122,   123,    -1,    -1,   126,   127,
     128,    -1,   130,   131,   132,   133,    -1,   135,   136,    -1,
     138,    -1,    -1,    -1,    -1,   143,   144,   145,   146,   147,
     148,   149,   150,    -1,   152,    -1,   154,    -1,   156,   157,
     158,    -1,    -1,    -1,   162,   163,   164,   165,    -1,   167,
     168,    -1,   170,    -1,   172,   173,   174,   175,   176,    -1,
     178,    -1,   180,   181,   182,    -1,   184,    -1,   186,    -1,
      -1,    -1,   190,    -1,   192,    -1,    -1,   195,    -1,   197,
     198,    -1,   200,   201,   202,    -1,   204,   205,   206,   207,
      -1,    -1,   210,    -1,   212,   213,   214,    -1,   216,    -1,
     218,    -1,    -1,    -1,    -1,   223,    -1,   225,   226,   227,
     228,   229,    -1,    -1,   232,    -1,    -1,   235,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     248,    -1,   250,    -1,   252,   253,   254,   255,   256,    -1,
     258,   259,    -1,   261,    -1,   263,   264,   265,   266,    -1,
      -1,   269,    -1,    -1,    -1,   273,   274,    -1,    -1,   277,
      -1,    -1,   280,   281,   282,   283,    -1,   285,   286,   287,
     288,    -1,   290,   291,   292,   293,   294,   295,   296,   297,
      -1,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,    -1,   311,   312,   313,   314,   315,   316,   317,
     318,    -1,    -1,   321,   322,   323,    -1,   325,   326,   327,
     328,    -1,   330,   331,    -1,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,    -1,   344,   345,   346,   347,
      -1,   349,   350,    -1,   352,    -1,   354,   355,   356,   357,
      -1,   359,   360,   361,   362,   363,    -1,    -1,   366,   367,
     368,   369,   370,    -1,    -1,   373,   374,   375,   376,   377,
      -1,   379,    -1,    -1,    -1,   383,   384,   385,   386,   387,
     388,    -1,   390,    -1,    -1,   393,     6,     7,     8,     9,
      -1,    11,    12,    -1,    14,    15,    16,    17,    -1,    19,
      -1,    21,    -1,    23,    24,    25,    26,    27,    28,    -1,
      30,    31,    32,    33,    -1,    -1,    36,    37,    38,    39,
      -1,    -1,    -1,    43,    44,    45,    -1,    47,    -1,    -1,
      -1,    51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,
      -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,    79,
      80,    81,    82,    83,    84,    -1,    86,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    96,    97,    -1,    99,
     100,   101,    -1,   103,    -1,   105,    -1,    -1,   108,   109,
      -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,   119,
     120,   121,   122,   123,    -1,    -1,   126,   127,   128,    -1,
     130,   131,   132,   133,    -1,   135,   136,    -1,   138,    -1,
      -1,    -1,    -1,   143,   144,   145,   146,   147,   148,   149,
     150,    -1,   152,    -1,   154,    -1,   156,   157,   158,    -1,
      -1,    -1,   162,   163,   164,   165,    -1,   167,   168,    -1,
     170,    -1,   172,   173,   174,   175,   176,    -1,   178,    -1,
     180,   181,   182,    -1,   184,    -1,   186,    -1,    -1,    -1,
     190,    -1,   192,    -1,    -1,   195,    -1,   197,   198,    -1,
     200,   201,   202,    -1,   204,   205,   206,   207,    -1,    -1,
     210,    -1,   212,   213,   214,    -1,   216,    -1,   218,    -1,
      -1,    -1,    -1,   223,    -1,   225,   226,   227,   228,   229,
      -1,    -1,   232,    -1,    -1,   235,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   247,   248,    -1,
     250,    -1,   252,   253,   254,   255,   256,    -1,   258,   259,
      -1,   261,    -1,   263,   264,   265,   266,    -1,    -1,   269,
      -1,    -1,    -1,   273,   274,    -1,    -1,   277,    -1,    -1,
     280,   281,   282,   283,    -1,   285,   286,   287,   288,    -1,
     290,   291,   292,   293,   294,   295,   296,   297,    -1,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
      -1,   311,   312,   313,   314,   315,   316,   317,   318,    -1,
      -1,   321,   322,   323,    -1,   325,   326,   327,   328,    -1,
     330,   331,    -1,   333,   334,   335,   336,   337,   338,   339,
     340,   341,   342,    -1,   344,   345,   346,   347,    -1,   349,
     350,    -1,   352,    -1,   354,   355,   356,   357,    -1,   359,
     360,   361,   362,   363,    -1,    -1,   366,   367,   368,   369,
     370,    -1,    -1,   373,   374,   375,   376,   377,    -1,   379,
      -1,    -1,    -1,   383,   384,   385,   386,   387,   388,    -1,
     390,    -1,    -1,   393,     6,     7,     8,     9,    -1,    11,
      12,    -1,    14,    15,    16,    17,    -1,    19,    -1,    21,
      -1,    23,    24,    25,    26,    27,    28,    -1,    30,    31,
      32,    33,    -1,    -1,    36,    37,    38,    39,    -1,    -1,
      -1,    43,    44,    45,    -1,    47,    -1,    -1,    -1,    51,
      52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,
      62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,
      -1,    73,    -1,    75,    76,    -1,    78,    79,    80,    81,
      82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    96,    97,    -1,    99,   100,   101,
      -1,   103,    -1,   105,    -1,    -1,   108,   109,    -1,   111,
      -1,    -1,   114,   115,   116,   117,    -1,   119,   120,   121,
     122,   123,    -1,    -1,   126,   127,   128,    -1,   130,   131,
     132,   133,    -1,   135,   136,    -1,   138,    -1,    -1,    -1,
      -1,   143,   144,   145,   146,   147,   148,   149,   150,    -1,
     152,    -1,   154,    -1,   156,   157,   158,    -1,    -1,    -1,
     162,   163,   164,   165,    -1,   167,   168,    -1,   170,    -1,
     172,   173,   174,   175,   176,    -1,   178,    -1,   180,   181,
     182,    -1,   184,    -1,   186,    -1,    -1,    -1,   190,    -1,
     192,    -1,    -1,   195,    -1,   197,   198,    -1,   200,   201,
     202,    -1,   204,   205,   206,   207,    -1,    -1,   210,    -1,
     212,   213,   214,    -1,   216,    -1,   218,    -1,    -1,    -1,
      -1,   223,    -1,   225,   226,   227,   228,   229,    -1,    -1,
     232,    -1,    -1,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,    -1,   250,    -1,
     252,   253,   254,   255,   256,    -1,   258,   259,    -1,   261,
      -1,   263,   264,   265,   266,    -1,    -1,   269,    -1,    -1,
      -1,   273,   274,    -1,    -1,   277,    -1,    -1,   280,   281,
     282,   283,    -1,   285,   286,   287,   288,    -1,   290,   291,
     292,   293,   294,   295,   296,   297,    -1,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,    -1,   311,
     312,   313,   314,   315,   316,   317,   318,    -1,    -1,   321,
     322,   323,    -1,   325,   326,   327,   328,    -1,   330,   331,
      -1,   333,   334,   335,   336,   337,   338,   339,   340,   341,
     342,    -1,   344,   345,   346,   347,    -1,   349,   350,    -1,
     352,    -1,   354,   355,   356,   357,    -1,   359,   360,   361,
     362,   363,    -1,    -1,   366,   367,   368,   369,   370,    -1,
      -1,   373,   374,   375,   376,   377,    -1,   379,    -1,    -1,
      -1,   383,   384,   385,   386,   387,   388,    -1,   390,    -1,
      -1,   393,     6,     7,     8,     9,    -1,    11,    12,    -1,
      14,    15,    16,    17,    -1,    19,    -1,    21,    -1,    23,
      24,    25,    26,    27,    28,    -1,    30,    31,    32,    33,
      -1,    -1,    36,    37,    38,    39,    -1,    -1,    -1,    43,
      44,    45,    -1,    47,    -1,    -1,    -1,    51,    52,    -1,
      -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,
      -1,    75,    76,    -1,    78,    79,    80,    81,    82,    83,
      84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    95,    96,    97,    -1,    99,   100,   101,    -1,   103,
      -1,   105,    -1,    -1,   108,   109,    -1,   111,    -1,    -1,
     114,   115,   116,   117,    -1,   119,   120,   121,   122,   123,
      -1,    -1,   126,   127,   128,    -1,   130,   131,   132,   133,
      -1,   135,   136,    -1,   138,    -1,    -1,    -1,    -1,   143,
     144,   145,   146,   147,   148,   149,   150,    -1,   152,    -1,
     154,    -1,   156,   157,   158,    -1,    -1,    -1,   162,   163,
     164,   165,    -1,   167,   168,    -1,   170,    -1,   172,   173,
     174,   175,   176,    -1,   178,    -1,   180,   181,   182,    -1,
     184,    -1,   186,    -1,    -1,    -1,   190,    -1,   192,    -1,
      -1,   195,    -1,   197,   198,    -1,   200,   201,   202,    -1,
     204,   205,   206,   207,    -1,    -1,   210,    -1,   212,   213,
     214,    -1,   216,    -1,   218,    -1,    -1,    -1,    -1,   223,
      -1,   225,   226,   227,   228,   229,    -1,    -1,   232,    -1,
      -1,   235,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   247,   248,    -1,   250,    -1,   252,   253,
     254,   255,   256,    -1,   258,   259,    -1,   261,    -1,   263,
     264,   265,   266,    -1,    -1,   269,    -1,    -1,    -1,   273,
     274,    -1,    -1,   277,    -1,    -1,   280,   281,   282,   283,
      -1,   285,   286,   287,   288,    -1,   290,   291,   292,   293,
     294,   295,   296,   297,    -1,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,    -1,   311,   312,   313,
     314,   315,   316,   317,   318,    -1,    -1,   321,   322,   323,
      -1,   325,   326,   327,   328,    -1,   330,   331,    -1,   333,
     334,   335,   336,   337,   338,   339,   340,   341,   342,    -1,
     344,   345,   346,   347,    -1,   349,   350,    -1,   352,    -1,
     354,   355,   356,   357,    -1,   359,   360,   361,   362,   363,
      -1,    -1,   366,   367,   368,   369,   370,    -1,    -1,   373,
     374,   375,   376,   377,    -1,   379,    -1,    -1,    -1,   383,
     384,   385,   386,   387,   388,    -1,   390,    -1,    -1,   393,
       6,     7,     8,     9,    -1,    11,    12,    -1,    14,    15,
      16,    17,    -1,    19,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    -1,    30,    31,    32,    33,    -1,    -1,
      36,    37,    38,    39,    -1,    -1,    -1,    43,    44,    45,
      -1,    47,    -1,    -1,    -1,    51,    52,    -1,    -1,    -1,
      56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,
      76,    -1,    78,    79,    80,    81,    82,    83,    84,    -1,
      86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      96,    97,    -1,    99,   100,   101,    -1,   103,    -1,   105,
      -1,    -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,
     116,   117,    -1,   119,   120,   121,   122,   123,    -1,    -1,
     126,   127,   128,    -1,   130,   131,   132,   133,    -1,   135,
     136,    -1,   138,    -1,    -1,    -1,    -1,   143,   144,   145,
     146,   147,   148,   149,   150,    -1,   152,    -1,   154,    -1,
     156,   157,   158,    -1,    -1,    -1,   162,   163,   164,   165,
      -1,   167,   168,    -1,   170,    -1,   172,   173,   174,   175,
     176,    -1,   178,    -1,   180,   181,   182,    -1,   184,    -1,
     186,    -1,    -1,    -1,   190,    -1,   192,    -1,    -1,   195,
      -1,   197,   198,    -1,   200,   201,   202,    -1,   204,   205,
     206,   207,    -1,    -1,   210,    -1,   212,   213,   214,    -1,
     216,    -1,   218,    -1,    -1,    -1,    -1,   223,    -1,   225,
     226,   227,   228,   229,    -1,    -1,   232,    -1,    -1,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   248,    -1,   250,    -1,   252,   253,   254,   255,
     256,    -1,   258,   259,    -1,   261,    -1,   263,   264,   265,
     266,    -1,    -1,   269,    -1,    -1,    -1,   273,   274,    -1,
      -1,   277,    -1,    -1,   280,   281,   282,   283,    -1,   285,
     286,   287,   288,    -1,   290,   291,   292,   293,   294,   295,
     296,   297,    -1,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,    -1,   311,   312,   313,   314,   315,
     316,   317,   318,    -1,    -1,   321,   322,   323,    -1,   325,
     326,   327,   328,    -1,   330,   331,    -1,   333,   334,   335,
     336,   337,   338,   339,   340,   341,   342,    -1,   344,   345,
     346,   347,    -1,   349,   350,    -1,   352,    -1,   354,   355,
     356,   357,    -1,   359,   360,   361,   362,   363,    -1,    -1,
     366,   367,   368,   369,   370,    -1,    -1,   373,   374,   375,
     376,   377,    -1,   379,    -1,    -1,    -1,   383,   384,   385,
     386,   387,   388,    -1,   390,    -1,    -1,   393,     6,     7,
       8,    -1,    -1,    11,    12,    -1,    14,    15,    16,    -1,
      -1,    -1,    20,    21,    -1,    23,    24,    25,    26,    27,
      28,    -1,    30,    31,    32,    -1,    -1,    -1,    36,    37,
      38,    39,    -1,    41,    -1,    43,    44,    45,    46,    47,
      48,    49,    -1,    -1,    -1,    -1,    -1,    -1,    56,    57,
      -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      98,    -1,    -1,    -1,   102,   103,   104,   105,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   116,    -1,
      -1,    -1,    -1,    -1,    -1,   123,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   132,    -1,    -1,    -1,    -1,   137,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     148,   149,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   175,    -1,    -1,
     178,    -1,    -1,    -1,   182,    -1,    -1,    -1,    -1,   187,
      -1,   189,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   199,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   209,   210,    -1,    -1,    -1,    -1,    -1,   216,    -1,
     218,    -1,    -1,   221,   222,    -1,   224,    -1,    -1,    -1,
      -1,    -1,    -1,   231,    -1,   233,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     248,   249,   250,    -1,    -1,    -1,    -1,    -1,   256,    -1,
      -1,    -1,   260,    -1,    -1,   263,   264,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   277,
     278,   279,   280,    -1,    -1,    -1,    -1,   285,   286,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   296,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   310,    -1,   312,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   326,    -1,
      -1,   329,    -1,   331,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   341,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   349,   350,    -1,    -1,    -1,    -1,   355,    -1,   357,
      -1,    -1,    -1,    -1,    -1,    -1,   364,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   376,    -1,
     378,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     6,     7,
       8,    -1,   390,    11,    12,   393,    14,    15,    16,    -1,
      -1,    -1,    20,    21,    -1,    23,    24,    25,    26,    27,
      28,    -1,    30,    31,    32,    -1,    -1,    -1,    36,    37,
      38,    39,    -1,    41,    -1,    43,    44,    45,    46,    47,
      48,    49,    -1,    -1,    -1,    -1,    -1,    -1,    56,    57,
      -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      98,    -1,    -1,    -1,   102,   103,   104,   105,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   116,    -1,
      -1,    -1,    -1,    -1,    -1,   123,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   132,    -1,    -1,    -1,    -1,   137,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     148,   149,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   175,    -1,    -1,
     178,    -1,    -1,    -1,   182,    -1,    -1,    -1,    -1,   187,
      -1,   189,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   199,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   209,   210,    -1,    -1,    -1,    -1,    -1,   216,    -1,
     218,    -1,    -1,   221,   222,    -1,   224,    -1,    -1,    -1,
      -1,    -1,    -1,   231,    -1,   233,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     248,   249,   250,    -1,    -1,    -1,    -1,    -1,   256,    -1,
      -1,    -1,   260,    -1,    -1,   263,   264,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   277,
     278,   279,   280,    -1,    -1,    -1,    -1,   285,   286,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   296,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   310,    -1,   312,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   326,    -1,
      -1,   329,    -1,   331,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   341,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   349,   350,    -1,    -1,    -1,    -1,   355,    -1,   357,
      -1,    -1,    -1,    -1,    -1,    -1,   364,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   376,    -1,
     378,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     6,     7,
       8,    -1,   390,    11,    12,   393,    14,    15,    16,    -1,
      -1,    -1,    20,    21,    -1,    23,    24,    25,    26,    27,
      28,    -1,    30,    31,    32,    -1,    -1,    -1,    36,    37,
      38,    39,    -1,    41,    -1,    43,    44,    45,    -1,    47,
      48,    49,    -1,    -1,    -1,    -1,    -1,    -1,    56,    57,
      -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    71,    -1,    73,    -1,    75,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      98,    -1,    -1,    -1,   102,   103,   104,   105,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   116,    -1,
      -1,    -1,    -1,    -1,    -1,   123,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   132,    -1,    -1,    -1,    -1,   137,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     148,   149,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   175,    -1,    -1,
     178,    -1,    -1,    -1,   182,    -1,    -1,    -1,    -1,   187,
      -1,   189,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   199,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   209,   210,    -1,    -1,    -1,    -1,    -1,   216,    -1,
     218,    -1,    -1,   221,   222,    -1,   224,    -1,    -1,    -1,
      -1,    -1,    -1,   231,    -1,   233,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     248,   249,   250,    -1,    -1,    -1,    -1,    -1,   256,    -1,
      -1,    -1,   260,    -1,    -1,   263,   264,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   277,
     278,   279,   280,    -1,    -1,    -1,    -1,   285,   286,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   296,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   310,    -1,   312,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   326,    -1,
      -1,   329,    -1,   331,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   341,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   349,   350,    -1,    -1,    -1,    -1,   355,    -1,   357,
      -1,    -1,    -1,    -1,    -1,    -1,   364,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   376,    -1,
     378,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     6,     7,
       8,    -1,   390,    11,    12,   393,    14,    15,    16,    -1,
      -1,    -1,    20,    21,    -1,    23,    24,    25,    26,    27,
      28,    -1,    30,    31,    32,    -1,    -1,    -1,    36,    37,
      38,    39,    -1,    41,    -1,    43,    44,    45,    -1,    47,
      48,    49,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      98,    -1,    -1,    -1,   102,   103,   104,   105,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   116,    -1,
      -1,    -1,    -1,    -1,    -1,   123,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   132,    -1,    -1,    -1,    -1,   137,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     148,   149,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   175,    -1,    -1,
     178,    -1,    -1,    -1,   182,    -1,    -1,    -1,    -1,   187,
      -1,   189,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   199,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   209,   210,    -1,    -1,    -1,    -1,    -1,   216,    -1,
     218,    -1,    -1,   221,   222,    -1,   224,    -1,    -1,    -1,
      -1,    -1,    -1,   231,    -1,   233,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     248,   249,   250,    -1,    -1,    -1,    -1,    -1,   256,    -1,
      -1,    -1,   260,    -1,    -1,   263,   264,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   277,
     278,   279,   280,    -1,    -1,    -1,    -1,   285,   286,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   296,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   310,    -1,   312,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   326,    -1,
      -1,   329,    -1,   331,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   341,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   349,   350,    -1,    -1,    -1,    -1,   355,    -1,   357,
      -1,    -1,    -1,    -1,    -1,    -1,   364,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   376,    -1,
     378,     6,     7,     8,    -1,    -1,    11,    12,    -1,    14,
      15,    16,   390,    -1,    -1,   393,    21,    -1,    23,    24,
      25,    26,    27,    28,    -1,    30,    31,    32,    -1,    -1,
      -1,    36,    37,    38,    39,    -1,    -1,    -1,    43,    44,
      45,    -1,    47,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    98,    -1,    -1,    -1,   102,   103,   104,
     105,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   116,    -1,    -1,    -1,    -1,    -1,    -1,   123,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   132,    -1,    -1,
      -1,    -1,   137,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   148,   149,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     175,    -1,    -1,   178,    -1,    -1,    -1,   182,    -1,    -1,
      -1,    -1,   187,    -1,   189,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   199,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   209,   210,    -1,    -1,    -1,    -1,
      -1,   216,    -1,   218,    -1,    -1,   221,   222,    -1,   224,
      -1,    -1,    -1,    -1,    -1,    -1,   231,    -1,   233,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   248,   249,   250,    -1,    -1,    -1,    -1,
      -1,   256,    -1,    -1,    -1,   260,    -1,    -1,   263,   264,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   277,   278,   279,   280,    -1,    -1,    -1,    -1,
     285,   286,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   296,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   310,    -1,   312,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   326,    -1,    -1,   329,    -1,   331,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   341,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   349,   350,    -1,    -1,    -1,    -1,
     355,    -1,   357,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   376,    -1,   378,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   390,    -1,    -1,   393
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const unsigned short yystos[] =
{
       0,   425,   426,     0,     5,    20,    29,    40,    41,    46,
      48,    49,    53,    54,    55,    56,    57,    58,    59,    60,
      61,    62,    63,    64,    65,    66,    67,    68,    69,    70,
      71,    72,    73,    74,    75,    76,   115,   182,   198,   215,
     242,   245,   262,   318,   351,   364,   376,   387,   390,   391,
     393,   395,   399,   401,   402,   406,   407,   408,   409,   410,
     413,   414,   415,   416,   418,   419,   420,   421,   427,   785,
     786,   789,   824,   826,   923,   936,   937,   825,     3,     6,
       7,     8,     9,    11,    12,    14,    15,    16,    17,    19,
      20,    21,    22,    23,    24,    25,    26,    27,    28,    30,
      31,    32,    33,    36,    37,    38,    39,    41,    43,    44,
      45,    47,    48,    49,    51,    52,    56,    57,    62,    71,
      73,    75,    76,    78,    87,    88,    89,    97,    98,   101,
     102,   103,   104,   105,   116,   119,   121,   122,   123,   126,
     127,   132,   133,   134,   137,   145,   147,   148,   149,   150,
     156,   164,   169,   174,   175,   176,   178,   180,   182,   187,
     189,   191,   193,   199,   209,   210,   213,   216,   218,   221,
     222,   224,   231,   233,   235,   236,   239,   246,   248,   249,
     250,   256,   259,   260,   263,   264,   277,   278,   279,   280,
     285,   286,   288,   296,   299,   301,   305,   309,   310,   311,
     312,   315,   320,   325,   326,   328,   329,   331,   334,   341,
     349,   350,   355,   357,   359,   361,   364,   367,   369,   373,
     376,   378,   390,   393,   415,   428,   429,   430,   432,   433,
     434,   438,   441,   442,   443,   447,   458,   459,   460,   463,
     464,   472,   473,   482,   509,   515,   516,   520,   524,   526,
     528,   529,   542,   543,   544,   545,   551,   556,   557,   562,
     563,   567,   570,   571,   582,   588,   601,   602,   604,   607,
     609,   610,   613,   615,   616,   624,   625,   626,   627,   628,
     633,   634,   635,   639,   640,   641,   642,   644,   645,   646,
     647,   648,   653,   656,   660,   661,   665,   666,   669,   670,
     671,   672,   673,   801,   814,   815,   816,   817,   818,   831,
     836,   837,   838,   839,   840,   842,   844,   846,   847,   848,
     849,   851,   856,   857,   860,   865,   866,   875,   876,   878,
     879,   880,   883,   887,   890,   894,   896,   897,   900,   902,
     905,   913,   919,   920,   930,   828,   829,   831,   833,   836,
     839,   842,    18,     9,    17,    19,    33,    51,    52,    56,
      57,    62,    71,    73,    75,    76,    78,    79,    80,    81,
      82,    83,    84,    86,    87,    95,    96,    97,    99,   100,
     101,   108,   109,   111,   114,   115,   117,   119,   120,   121,
     122,   126,   127,   128,   130,   131,   133,   135,   136,   138,
     143,   144,   145,   146,   147,   150,   152,   154,   156,   157,
     158,   162,   163,   164,   165,   167,   168,   170,   172,   173,
     174,   176,   180,   181,   184,   186,   190,   192,   195,   197,
     198,   200,   201,   202,   204,   205,   206,   207,   212,   213,
     214,   223,   225,   226,   227,   228,   229,   232,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   252,   253,   254,   255,   258,   259,   261,   265,   266,
     269,   273,   274,   281,   282,   283,   287,   288,   290,   291,
     292,   293,   294,   295,   297,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   311,   313,   314,   315,
     316,   317,   318,   321,   322,   323,   325,   327,   328,   330,
     333,   334,   335,   336,   337,   338,   339,   340,   342,   344,
     345,   346,   347,   351,   352,   354,   356,   359,   360,   361,
     362,   363,   366,   367,   368,   369,   370,   373,   374,   375,
     377,   379,   383,   384,   385,   386,   387,   388,   394,   789,
     794,   799,   810,   811,   904,   905,   906,   909,   915,   916,
     917,   918,   919,   927,   929,   930,    34,   211,   877,    13,
      85,   151,   778,   789,   802,   803,   812,   858,   859,   909,
     929,   930,     5,    29,    34,    40,    41,    48,    49,    85,
      88,    89,    90,    91,    92,    93,    94,   107,   112,   113,
     115,   118,   124,   125,   129,   134,   139,   140,   141,   142,
     151,   153,   159,   160,   161,   166,   169,   171,   179,   183,
     185,   188,   193,   194,   196,   203,   208,   211,   215,   217,
     219,   230,   234,   251,   257,   262,   267,   268,   270,   271,
     272,   275,   276,   289,   298,   320,   324,   332,   343,   348,
     351,   353,   358,   364,   365,   371,   372,   381,   382,   419,
     841,   906,   907,   908,   912,   913,   914,   915,   917,   918,
     921,   777,   909,   777,   908,    29,    40,   115,   215,   901,
      43,    45,   257,   832,   354,   385,   629,    84,   131,   145,
     162,   190,   194,   206,   227,   273,   316,   321,   343,   344,
     356,   361,   371,   802,   150,   629,   777,   251,   270,   773,
     775,   781,   800,   909,   271,   629,   104,   478,    84,    95,
     113,   129,   145,   151,   162,   192,   194,   237,   273,   275,
     316,   344,   345,   347,   356,   360,   361,   365,   371,   483,
     521,   554,   583,   589,   802,    18,   288,   777,   812,   864,
     335,   777,   188,    84,    95,   113,   131,   145,   162,   190,
     194,   206,   273,   292,   314,   316,   321,   343,   344,   356,
     361,   371,   379,   525,   558,   629,   200,   864,   648,   655,
      79,    85,    99,   181,   186,   188,   203,   229,   252,   290,
     300,   407,   564,   565,   566,   777,   785,   790,   791,   927,
      18,    85,   134,   156,   174,   213,   298,   314,   320,   345,
     347,   356,   369,   370,   572,   573,   574,   219,   775,   909,
     782,   794,   343,   676,   564,   777,   775,   864,   145,   206,
     343,   611,   315,   909,    85,   323,   349,   354,   909,   193,
     579,   629,   909,    85,   160,   678,     4,    10,    18,   130,
     237,   247,   323,   349,   354,   448,   449,   909,    85,   323,
     349,   354,   909,   354,   676,   898,   908,   408,   775,   272,
     700,   775,   189,   650,   670,   671,   101,   429,   418,   378,
     649,   171,   217,   276,   364,   679,   680,   839,   842,   838,
     820,   418,   843,   845,     5,    29,    40,   115,   163,   215,
     850,   146,   198,   242,   245,   318,   387,   415,   729,   823,
     827,   923,   831,   833,   839,   835,   418,   777,   812,   931,
     151,   802,    25,   372,   409,   777,   777,   392,   804,   805,
     423,   929,   415,   419,   932,   933,   934,   935,   937,   841,
     372,   867,   868,   869,    29,   215,   215,   912,     7,    11,
      23,    24,    44,    47,   161,   903,   903,    21,   839,   773,
     783,   904,   911,   915,   916,   920,   930,   560,   909,   778,
     560,   778,   909,   783,   799,   700,   777,   120,   392,   402,
     403,   404,   406,   407,   408,   409,   410,   411,   606,   736,
     737,   909,   777,   775,   700,   777,   777,   560,   799,    39,
     223,   295,   630,   631,   632,   417,   561,   271,    84,   113,
     125,   131,   145,   162,   190,   206,   228,   273,   314,   316,
     321,   343,   356,   361,   379,   525,   568,   775,   783,   777,
     415,   356,   778,   560,   345,   347,   799,   345,   347,   120,
     736,   304,   444,   909,   777,   777,   560,   799,   321,   343,
     525,   131,   206,   190,   314,   379,   931,   864,   930,   667,
     700,   783,   777,   415,   778,   783,   799,   120,   736,   777,
     777,   777,   437,   799,   227,   559,   560,   393,   812,   863,
     861,   649,   565,    85,   565,    85,   565,   565,   790,   566,
     777,   777,   219,   870,   872,   931,   291,   271,   421,   775,
     774,   775,   566,   188,   777,   775,   909,    98,   388,   223,
     274,   572,   351,   271,    92,   103,   105,   106,   112,   113,
     115,   116,   123,   132,   139,   140,   141,   142,   148,   149,
     163,   175,   178,   179,   182,   215,   216,   218,   248,   250,
     257,   262,   263,   264,   273,   280,   285,   296,   312,   324,
     331,   341,   349,   350,   355,   357,   358,   365,   371,   376,
     392,   397,   398,   400,   406,   407,   408,   410,   411,   415,
     670,   709,   710,   711,   716,   717,   718,   720,   721,   722,
     723,   726,   727,   730,   732,   733,   734,   738,   755,   760,
     765,   766,   773,   783,   784,   785,   786,   787,   788,   789,
     798,   904,   907,   910,   915,   916,   926,   927,   929,   930,
     351,   402,   351,   402,   859,   931,    85,   461,   776,   777,
     323,   448,   151,   456,   794,    98,   117,   448,   388,   631,
     351,   417,   422,    98,   388,   223,   632,   775,   913,   415,
     775,   325,   408,   187,   651,   416,   416,   418,   775,    85,
     677,   677,   108,   677,   183,   234,   268,   683,   689,   819,
     408,   852,   853,   855,   419,   419,    29,   215,   215,   351,
     351,   351,   351,   351,   407,   785,   786,   796,   821,   927,
     169,   834,   852,    93,   808,   108,   811,   811,   372,   869,
     219,   869,   870,   396,   806,   909,   423,   807,   804,   416,
     933,   934,   932,   420,   421,    42,   789,   796,   797,   871,
     873,   874,   926,   215,   221,   777,   351,   777,     6,   777,
     903,   855,   413,   417,   761,   762,   415,   281,   302,   561,
     281,   302,   325,   459,    82,   164,   325,   469,   281,   415,
     590,    82,   164,   302,   281,   302,   325,   467,   468,   302,
     560,   415,   417,   281,   302,   517,    82,    87,   122,   134,
     164,   302,   325,   465,   466,   281,   302,   271,   281,   302,
     325,   383,   435,   459,   418,   232,   272,   386,   421,   630,
     780,   912,   775,   783,   415,   783,   265,   120,   736,   777,
     777,   227,   777,   383,   479,   415,   547,   118,   103,   105,
     115,   116,   148,   149,   182,   216,   218,   248,   250,   264,
     296,   326,   331,   349,   350,   376,   705,   708,   710,   711,
     715,   717,   718,   719,   721,   722,   726,   727,   904,   910,
     915,   916,   930,   777,   383,    93,   643,   383,   439,   560,
     547,    98,   344,   507,   281,   527,    83,   100,   530,    93,
     547,   383,   431,   775,   775,   227,   560,   781,   909,   783,
     777,   775,   104,   143,   212,   253,   317,   382,   702,   415,
     705,   590,   560,   415,   271,   271,   421,   794,   111,   307,
     421,   470,   862,   868,   872,   150,   654,   656,   660,   665,
     666,   669,   777,   872,   872,   871,   922,   925,   929,    50,
     881,   882,   929,   145,   190,   227,   316,   343,   344,   575,
     774,   574,   151,   375,   415,   657,   669,   203,   421,   662,
     777,   863,   184,   612,   612,   232,   183,   271,   315,   909,
     415,   413,   670,   745,   377,   724,   730,   759,   415,   724,
     724,   415,   415,   415,   764,   415,   764,   415,   764,   415,
     714,   714,   286,   670,   415,   415,   712,   115,   116,   724,
     730,   415,   415,   713,   415,   415,   415,   415,   764,   415,
     383,   384,   415,   728,   415,   728,   415,   415,   670,   764,
     763,   730,   730,   730,   730,   670,   730,   741,   794,   116,
     415,   725,   415,   794,    77,    90,    93,    97,   102,   199,
     203,   221,   222,   233,   257,   260,   273,   275,   329,   392,
     402,   403,   404,   406,   407,   408,   409,   410,   411,   736,
     738,   740,   730,   219,   421,   674,   872,   762,   415,    26,
     928,   929,   267,   271,   895,   895,   859,   859,    12,    50,
     884,   885,   886,   154,   200,   462,   421,   117,   151,   457,
     794,   909,    93,   151,   237,   455,   727,   797,   930,   151,
     179,   267,   271,   358,   450,   451,   453,   454,   797,   909,
     909,   450,   232,   221,   775,   415,   767,   770,   909,   649,
     415,   652,   670,   672,   673,   672,   681,   682,   730,   672,
     295,   369,    85,   685,   730,   686,   730,   689,   690,   683,
     684,   852,   408,   418,   421,   914,   830,   833,   830,   215,
     146,   198,   242,   318,   242,   318,   318,   245,   242,   245,
     318,   785,   786,   421,   822,   150,   852,   418,   802,   371,
     809,   811,   417,   790,   807,   416,   420,   935,    18,   421,
     839,   415,   777,   415,   913,   730,   408,   780,   761,   408,
     603,   705,   351,   351,   351,   351,   448,   118,   129,   185,
     289,   365,   494,   495,   129,   151,   257,   151,   257,   351,
     203,   210,   277,   416,   591,   592,   593,   281,   302,   371,
     371,   351,   351,   351,   344,   421,   351,   372,   256,   605,
     705,   606,   351,   351,   109,   144,   205,   241,   243,   253,
     306,   334,   518,   125,   494,   614,   614,   271,   352,   129,
     614,   351,   614,   384,   421,   351,   351,   700,   351,   351,
     448,   435,   135,   136,   203,   254,   255,   283,   342,   374,
     436,   295,   303,   322,   452,   630,   561,   415,   705,   590,
     796,   560,   415,   221,   271,   271,   560,   221,   269,   188,
     351,   474,   548,   549,   912,   415,   708,    93,    92,   413,
     706,   146,   245,   387,   415,   729,   561,    83,   167,   238,
     281,   344,   346,   636,   637,   705,   439,   342,   371,   440,
     554,   799,   777,   445,   777,   238,   156,   213,   369,   531,
     532,   415,   546,   435,   517,   266,   415,   512,   457,   183,
     271,   590,    93,   415,   496,   383,   384,   668,   317,   730,
     603,    93,   470,   372,   605,   775,   775,   799,   470,   560,
     872,   868,   777,   872,    18,   421,   928,   785,   792,   929,
     421,   402,   776,   580,   581,   783,   776,   776,   774,   776,
     351,   375,   415,   658,   659,   909,    80,   172,   312,   327,
     663,   775,   261,   664,   575,   909,   730,   741,   741,   744,
     745,   415,   381,   756,   757,   730,   741,   730,   741,   416,
     790,   790,   790,   146,   198,   242,   245,   318,   387,   742,
     746,   794,   930,   790,   724,   724,   730,   790,   606,   730,
     747,   407,   410,   411,   731,   732,   738,   749,   416,   741,
     730,   741,   750,   349,   349,   790,   790,   730,   107,   188,
     230,   353,   730,   741,   753,   761,   416,   421,   325,   790,
     790,   729,   705,   730,   912,   349,   731,   730,   415,   670,
     754,   160,   179,   257,   262,   266,   358,   366,   730,   102,
     199,   203,   233,   329,   415,   730,   351,   730,   730,   730,
     730,   730,   730,   730,   730,   730,   730,    85,    91,   332,
     735,   192,   237,   343,   345,   347,   675,   775,   766,   188,
     692,    85,   160,   408,   416,   741,   777,   929,   792,   421,
     402,   777,   354,   415,   794,   421,   839,   416,   768,   909,
     421,   692,   763,   647,   775,   776,   421,    94,   159,   372,
     272,   266,   691,   268,   421,   234,   418,   853,   706,   420,
     833,   420,   796,   416,    39,   418,   810,   806,   409,   931,
     873,   706,   924,   934,   924,   706,   414,   423,   416,   799,
     777,   799,   778,   415,   777,   225,   225,   415,   777,   262,
     730,   262,   799,   416,   421,   595,   597,   705,   904,   910,
     911,   915,   916,   930,   351,   351,   437,   437,   799,   799,
     777,   777,   468,   777,   779,   909,   421,   416,   421,   799,
     777,   796,   108,   519,   796,   796,   144,   241,   243,   431,
     431,   487,   909,   909,   777,   343,   777,   909,   777,   777,
     122,   269,   466,   799,   777,   302,   799,   799,   194,   789,
     790,   368,   128,   362,   295,   603,    93,   221,   221,   372,
     605,   262,   569,   794,   560,   560,   221,   569,   337,   338,
     475,   794,   416,   421,   402,   730,    92,   706,   705,   413,
     414,   415,   707,   789,   790,   909,   351,   351,   790,   531,
     402,   638,   638,   638,   638,   638,   637,   488,   790,   437,
     183,   507,   134,   446,   482,   515,   529,   570,   582,   633,
     789,   271,   275,   703,   704,   909,   775,   233,   484,   485,
     486,   487,   492,   494,   513,   514,   909,    93,   383,   384,
     511,   195,   794,   775,   308,   617,   497,   498,   909,    93,
     197,   197,   183,   416,   705,   779,   416,   470,   470,   667,
     931,   925,   888,   889,   929,   882,   886,   421,   590,   194,
     576,   577,   909,   151,   730,   771,   772,   416,   421,   763,
     172,   327,   172,   327,   312,   369,   244,   188,   416,   421,
     414,   414,   421,   790,   730,   166,   757,   758,    93,   416,
     372,   416,   416,   416,   416,   421,   416,   188,   416,   421,
     416,   421,   416,   284,   748,   416,   731,   731,   731,    77,
     203,   221,   273,   392,   402,   403,   404,   406,   407,   408,
     409,   410,   411,   738,   731,   416,   416,   183,   188,   751,
     752,   416,   388,   388,   416,   416,    93,   753,   741,   753,
     753,   188,   416,   763,   730,   909,   416,   416,   388,    90,
     170,   741,   188,   179,   262,   266,   358,   366,   415,   170,
     731,   730,   754,   730,   351,   606,   730,   415,   670,   345,
     347,   345,   347,   775,   676,   676,   415,   670,   693,   694,
     695,   700,   701,   733,   773,   702,   741,   741,   416,   416,
       8,    14,    15,    16,    26,    27,    28,    30,    31,    32,
      36,    37,    38,   286,   361,   891,   892,   893,   885,   792,
     631,   790,   729,   453,   706,   416,   763,   770,   702,   402,
     416,   682,   273,   736,   739,   776,   686,   686,   685,   402,
     854,   418,   778,    35,   899,   416,   416,   418,   730,   281,
     302,   730,   495,   415,   415,   497,   470,   592,   597,   561,
     799,   777,   281,   302,   705,   281,   256,   705,   796,   796,
     796,   705,   164,   325,   361,   469,   470,   470,   351,   351,
     437,   789,   416,   705,   569,   569,   779,   416,   221,   221,
     569,   372,   480,   481,   549,   273,   407,   550,   596,   597,
     739,   797,   416,   413,   416,   790,   706,   707,   406,   407,
     408,   409,   410,   414,   416,   271,   151,   785,   789,   795,
     927,   151,   794,   151,   777,   151,   777,   151,   777,   118,
     129,   151,   153,   208,   257,   262,   289,   298,   365,   489,
     490,   491,   361,   445,   483,   589,   775,   532,   416,   421,
     705,   415,   775,   416,   421,   416,   421,   269,   269,   510,
     522,   777,   351,   372,   584,   596,   271,   416,   421,   669,
     669,   864,   470,   416,   470,   470,   143,   421,   402,   581,
     909,   383,   421,   578,   416,   421,   375,   669,   659,   172,
     172,   576,   730,   745,   416,   348,   730,   169,   705,   560,
     790,   730,   730,   790,   730,   751,   705,   731,   160,   257,
     266,   731,   731,   731,   731,   731,   731,   731,   731,   731,
     731,   730,   730,   752,   751,   728,   728,   705,   416,   416,
     416,   741,   416,   725,   794,   732,   731,   730,   416,   730,
     415,   705,   743,   730,    90,   170,   170,   730,   416,   170,
     730,   676,   676,   676,   676,   775,   775,   670,   694,   695,
      93,   696,   909,   421,   137,   189,   209,   224,   231,   249,
     310,   389,   697,   696,    93,   696,   909,   417,   194,   687,
     416,   416,   421,   402,   416,   899,   402,   421,   151,   730,
     415,   935,   392,   813,   414,   351,   351,   416,   497,   497,
     416,   410,   351,   351,   351,   488,   257,   257,   336,   339,
     705,   777,   777,   221,   416,   221,   221,   569,   569,   431,
     158,   153,   208,   257,   539,   540,   541,   790,   383,   384,
     414,   416,   707,   707,   707,   707,   707,   706,   729,   775,
     415,   777,   731,   154,   200,   153,   262,   225,   775,   372,
     508,   705,   343,   183,   533,   275,   704,   484,   173,   204,
     493,   207,   504,   486,   514,   909,    93,    93,   669,   226,
     523,   561,   794,   779,   415,    93,   110,   177,   201,   227,
     308,   319,   333,   340,   380,   598,   599,   156,   213,   320,
     369,   622,   498,   470,   668,   889,   893,   193,   577,   772,
     415,   470,   730,   416,   416,   416,   416,   416,   752,   188,
     266,   415,   416,   729,   743,   416,   421,   731,   730,   730,
     170,   730,   416,   775,   775,   775,   775,   416,   909,   415,
     694,   224,   278,   698,   694,   698,   224,   697,   698,   694,
     224,   415,   909,   415,   780,   108,   196,   688,   892,   407,
     786,   789,   792,   793,   794,   415,   768,   606,   909,   799,
     777,   416,   416,   508,   361,   799,   777,   799,   262,   262,
     790,   909,   372,   471,   569,   221,   569,   569,   476,   794,
     154,   200,   153,   541,   540,   414,   190,   190,   188,   538,
     730,   257,   490,   508,   496,   206,   372,   775,   165,   534,
     174,   532,   416,   152,   152,   415,   383,   384,   505,   794,
     188,   415,   585,   586,   733,   909,   594,   794,   271,   319,
     457,   262,   155,   220,   383,   599,   600,   351,   183,   274,
     771,   731,   415,   731,   416,   705,   730,   696,   415,   776,
     694,   271,   372,   699,   694,   224,   694,   703,   415,   703,
     909,   741,   730,   785,   786,   729,   730,   769,   416,   298,
     508,   730,   569,   104,   138,   157,   170,   184,   262,   269,
     294,   477,   581,    93,   608,   775,   539,   416,   240,   499,
     344,   779,   415,   312,   335,   535,   293,   505,   774,   269,
     269,   271,   506,   560,   730,   416,   421,   372,   560,   587,
     587,   421,   262,   155,   220,   271,   547,   775,   416,   731,
     416,   776,   416,   730,   415,   694,   699,   416,   703,   416,
     421,   416,   775,   643,   643,   257,   294,   643,   643,   608,
      96,   183,   189,   282,   271,   500,   501,   502,   777,    93,
     777,   506,   416,   127,   507,   416,   507,   586,   560,   794,
     211,   262,   702,   416,   416,   776,   416,   769,   496,   794,
     789,   262,   497,   794,   789,   165,   156,   369,   271,   502,
     271,   501,   190,   273,   339,   552,   553,   415,   507,   156,
     164,   287,   587,   702,   211,   161,   416,   499,   497,   312,
     111,   253,   307,   325,   503,   503,   790,   790,   705,   421,
     536,   537,   798,   909,   313,   313,    86,   214,   623,   500,
     174,    81,   151,   262,   783,   606,   553,   416,   421,   258,
     415,   618,   620,   625,   656,   660,   665,   669,   539,   293,
     590,   297,   415,   555,   537,   619,   620,   621,   670,   671,
     783,   605,   416,   418,   415,   416,   621,   536,   555,   416
};

#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# if defined (__STDC__) || defined (__cplusplus)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# endif
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrlab1

/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { 								\
      yyerror ("syntax error: cannot back up");\
      YYERROR;							\
    }								\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

/* YYLLOC_DEFAULT -- Compute the default location (before the actions
   are run).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)         \
  Current.first_line   = Rhs[1].first_line;      \
  Current.first_column = Rhs[1].first_column;    \
  Current.last_line    = Rhs[N].last_line;       \
  Current.last_column  = Rhs[N].last_column;
#endif

/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (YYLEX_PARAM)
#else
# define YYLEX yylex ()
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (0)

# define YYDSYMPRINT(Args)			\
do {						\
  if (yydebug)					\
    yysymprint Args;				\
} while (0)

# define YYDSYMPRINTF(Title, Token, Value, Location)		\
do {								\
  if (yydebug)							\
    {								\
      YYFPRINTF (stderr, "%s ", Title);				\
      yysymprint (stderr, 					\
                  Token, Value);	\
      YYFPRINTF (stderr, "\n");					\
    }								\
} while (0)

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (cinluded).                                                   |
`------------------------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_stack_print (short *bottom, short *top)
#else
static void
yy_stack_print (bottom, top)
    short *bottom;
    short *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (/* Nothing. */; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_reduce_print (int yyrule)
#else
static void
yy_reduce_print (yyrule)
    int yyrule;
#endif
{
  int yyi;
  unsigned int yylineno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %u), ",
             yyrule - 1, yylineno);
  /* Print the symbols being reduced, and their result.  */
  for (yyi = yyprhs[yyrule]; 0 <= yyrhs[yyi]; yyi++)
    YYFPRINTF (stderr, "%s ", yytname [yyrhs[yyi]]);
  YYFPRINTF (stderr, "-> %s\n", yytname [yyr1[yyrule]]);
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (Rule);		\
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YYDSYMPRINT(Args)
# define YYDSYMPRINTF(Title, Token, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   SIZE_MAX < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#if YYMAXDEPTH == 0
# undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
yystrlen (const char *yystr)
#   else
yystrlen (yystr)
     const char *yystr;
#   endif
{
  register const char *yys = yystr;

  while (*yys++ != '\0')
    continue;

  return yys - yystr - 1;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
yystpcpy (char *yydest, const char *yysrc)
#   else
yystpcpy (yydest, yysrc)
     char *yydest;
     const char *yysrc;
#   endif
{
  register char *yyd = yydest;
  register const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

#endif /* !YYERROR_VERBOSE */



#if YYDEBUG
/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yysymprint (FILE *yyoutput, int yytype, YYSTYPE *yyvaluep)
#else
static void
yysymprint (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (yytype < YYNTOKENS)
    {
      YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
# ifdef YYPRINT
      YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
    }
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  switch (yytype)
    {
      default:
        break;
    }
  YYFPRINTF (yyoutput, ")");
}

#endif /* ! YYDEBUG */
/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yydestruct (int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yytype, yyvaluep)
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  switch (yytype)
    {

      default:
        break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM);
# else
int yyparse ();
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */



/* The lookahead symbol.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;



/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM)
# else
int yyparse (YYPARSE_PARAM)
  void *YYPARSE_PARAM;
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
  
  register int yystate;
  register int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken = 0;

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  short	yyssa[YYINITDEPTH];
  short *yyss = yyssa;
  register short *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  register YYSTYPE *yyvsp;



#define YYPOPSTACK   (yyvsp--, yyssp--)

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;


  /* When reducing, the number of symbols on the RHS of the reduced
     rule.  */
  int yylen;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	short *yyss1 = yyss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow ("parser stack overflow",
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),

		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyoverflowlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyoverflowlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	short *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyoverflowlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);

#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YYDSYMPRINTF ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */
  YYDPRINTF ((stderr, "Shifting token %s, ", yytname[yytoken]));

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;


  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  yystate = yyn;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 5:
#line 591 "preproc.y"
    { connection = NULL; }
    break;

  case 7:
#line 594 "preproc.y"
    {
			fprintf(yyout, "%s", yyvsp[0].str);
                        free(yyvsp[0].str);
			output_line_number();
		}
    break;

  case 9:
#line 600 "preproc.y"
    { fprintf(yyout, "%s", yyvsp[0].str); free(yyvsp[0].str); }
    break;

  case 10:
#line 601 "preproc.y"
    { fprintf(yyout, "%s", yyvsp[0].str); free(yyvsp[0].str); }
    break;

  case 11:
#line 602 "preproc.y"
    { braces_open++; fputs("{", yyout); }
    break;

  case 12:
#line 603 "preproc.y"
    { remove_typedefs(braces_open); remove_variables(braces_open--); fputs("}", yyout); }
    break;

  case 13:
#line 607 "preproc.y"
    {
			connection = yyvsp[0].str;
			/*
			 *	Do we have a variable as connection target?
			 *	Remove the variable from the variable
			 *	list or else it will be used twice
			 */
			if (argsinsert != NULL)
				argsinsert = NULL;
		}
    break;

  case 14:
#line 618 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 15:
#line 619 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 16:
#line 620 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 17:
#line 621 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 18:
#line 622 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 19:
#line 623 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 20:
#line 624 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 21:
#line 625 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 22:
#line 626 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 23:
#line 627 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 24:
#line 629 "preproc.y"
    {
			if (INFORMIX_MODE)
			{
				/* Informix also has a CLOSE DATABASE command that
				   essantially works like a DISCONNECT CURRENT 
				   as far as I know. */
				if (pg_strcasecmp(yyvsp[0].str+strlen("close "), "database") == 0)
				{
					if (connection)
		                                mmerror(PARSE_ERROR, ET_ERROR, "no at option for close database statement.\n");
								
					fprintf(yyout, "{ ECPGdisconnect(__LINE__, \"CURRENT\");");
		                        whenever_action(2);
		                        free(yyvsp[0].str);
				}
				else
					output_statement(yyvsp[0].str, 0, connection);
			}
			else
				output_statement(yyvsp[0].str, 0, connection);
		}
    break;

  case 25:
#line 650 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 26:
#line 651 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 27:
#line 652 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 28:
#line 653 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 29:
#line 654 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 30:
#line 655 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 31:
#line 656 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 32:
#line 657 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 33:
#line 658 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 34:
#line 659 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 35:
#line 660 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 36:
#line 661 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 37:
#line 662 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 38:
#line 663 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 39:
#line 664 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 40:
#line 665 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 41:
#line 666 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 42:
#line 667 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 43:
#line 668 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 44:
#line 669 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 45:
#line 671 "preproc.y"
    { output_simple_statement(yyvsp[0].str); }
    break;

  case 46:
#line 672 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 47:
#line 673 "preproc.y"
    { output_statement(yyvsp[0].str, 1, connection); }
    break;

  case 48:
#line 674 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 49:
#line 675 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 50:
#line 676 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 51:
#line 677 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 52:
#line 678 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 53:
#line 679 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 54:
#line 680 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 55:
#line 681 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 56:
#line 682 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 57:
#line 683 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 58:
#line 684 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 59:
#line 685 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 60:
#line 687 "preproc.y"
    { output_statement(yyvsp[0].str, 1, connection); }
    break;

  case 61:
#line 688 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 62:
#line 689 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 63:
#line 690 "preproc.y"
    { output_statement(yyvsp[0].str, 1, connection); }
    break;

  case 64:
#line 691 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 65:
#line 692 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 66:
#line 693 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 67:
#line 694 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 68:
#line 696 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 69:
#line 697 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 70:
#line 698 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 71:
#line 699 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 72:
#line 700 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 73:
#line 701 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 74:
#line 702 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 75:
#line 703 "preproc.y"
    { output_statement(yyvsp[0].str, 1, connection); }
    break;

  case 76:
#line 705 "preproc.y"
    {
			fprintf(yyout, "{ ECPGtrans(__LINE__, %s, \"%s\");", connection ? connection : "NULL", yyvsp[0].str);
			whenever_action(2);
			free(yyvsp[0].str);
		}
    break;

  case 77:
#line 710 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 78:
#line 711 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 79:
#line 712 "preproc.y"
    { output_statement(yyvsp[0].str, 1, connection); }
    break;

  case 80:
#line 713 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 81:
#line 714 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 82:
#line 715 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 83:
#line 716 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 84:
#line 717 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 85:
#line 719 "preproc.y"
    {
			fprintf(yyout,"ECPGallocate_desc(__LINE__, %s);",yyvsp[0].str);
			whenever_action(0);
			free(yyvsp[0].str);
		}
    break;

  case 86:
#line 725 "preproc.y"
    {
			if (connection)
				mmerror(PARSE_ERROR, ET_ERROR, "no at option for connect statement.\n");

			fprintf(yyout, "{ ECPGconnect(__LINE__, %d, %s, %d); ", compat, yyvsp[0].str, autocommit);
			reset_variables();
			whenever_action(2);
			free(yyvsp[0].str);
		}
    break;

  case 87:
#line 735 "preproc.y"
    {
			output_simple_statement(yyvsp[0].str);
		}
    break;

  case 88:
#line 739 "preproc.y"
    {
			if (connection)
				mmerror(PARSE_ERROR, ET_ERROR, "no at option for deallocate statement.\n");
			fprintf(yyout, "{ ECPGdeallocate(__LINE__, %d, %s);", compat, yyvsp[0].str);
			whenever_action(2);
			free(yyvsp[0].str);
		}
    break;

  case 89:
#line 747 "preproc.y"
    {
			if (connection)
				mmerror(PARSE_ERROR, ET_ERROR, "no at option for deallocate statement.\n");
			fprintf(yyout,"ECPGdeallocate_desc(__LINE__, %s);",yyvsp[0].str);
			whenever_action(0);
			free(yyvsp[0].str);
		}
    break;

  case 90:
#line 755 "preproc.y"
    {
			output_simple_statement(yyvsp[0].str);
		}
    break;

  case 91:
#line 759 "preproc.y"
    {
			fprintf(yyout, "{ ECPGdescribe(__LINE__, %s,", yyvsp[0].str);
			dump_variables(argsresult, 1);
			fputs("ECPGt_EORT);", yyout);
			fprintf(yyout, "}");
			output_line_number();
				
			/* whenever_action(2); */
			free(yyvsp[0].str);
		}
    break;

  case 92:
#line 770 "preproc.y"
    {
			if (connection)
				mmerror(PARSE_ERROR, ET_ERROR, "no at option for disconnect statement.\n");

			fprintf(yyout, "{ ECPGdisconnect(__LINE__, %s);",
					yyvsp[0].str ? yyvsp[0].str : "\"CURRENT\"");
			whenever_action(2);
			free(yyvsp[0].str);
		}
    break;

  case 93:
#line 780 "preproc.y"
    {
			output_statement(yyvsp[0].str, 0, connection);
		}
    break;

  case 94:
#line 784 "preproc.y"
    {
			fprintf(yyout, "{ ECPGdeallocate(__LINE__, %d, \"%s\");", compat, yyvsp[0].str);

			whenever_action(2);
			free(yyvsp[0].str);
		}
    break;

  case 95:
#line 791 "preproc.y"
    {
			lookup_descriptor(yyvsp[0].descriptor.name, connection);
			output_get_descr(yyvsp[0].descriptor.name, yyvsp[0].descriptor.str);
			free(yyvsp[0].descriptor.name);
			free(yyvsp[0].descriptor.str);
		}
    break;

  case 96:
#line 798 "preproc.y"
    {
			lookup_descriptor(yyvsp[0].str, connection);
			output_get_descr_header(yyvsp[0].str);
			free(yyvsp[0].str);
		}
    break;

  case 97:
#line 804 "preproc.y"
    {
			struct cursor *ptr;

			if ((ptr = add_additional_variables(yyvsp[0].str, true)) != NULL)
				output_statement(mm_strdup(ptr->command), 0, ptr->connection ? mm_strdup(ptr->connection) : NULL);
			ptr->opened = true;
		}
    break;

  case 98:
#line 812 "preproc.y"
    {
			if (connection)
				mmerror(PARSE_ERROR, ET_ERROR, "no at option for prepare statement.\n");

			fprintf(yyout, "{ ECPGprepare(__LINE__, %s);", yyvsp[0].str);
			whenever_action(2);
			free(yyvsp[0].str);
		}
    break;

  case 99:
#line 822 "preproc.y"
    {
			fprintf(yyout, "{ ECPGsetcommit(__LINE__, \"%s\", %s);", yyvsp[0].str, connection ? connection : "NULL");
			whenever_action(2);
			free(yyvsp[0].str);
		}
    break;

  case 100:
#line 828 "preproc.y"
    {
			if (connection)
				mmerror(PARSE_ERROR, ET_ERROR, "no at option for set connection statement.\n");

			fprintf(yyout, "{ ECPGsetconn(__LINE__, %s);", yyvsp[0].str);
			whenever_action(2);
			free(yyvsp[0].str);
		}
    break;

  case 101:
#line 837 "preproc.y"
    {
			lookup_descriptor(yyvsp[0].descriptor.name, connection);
			output_set_descr(yyvsp[0].descriptor.name, yyvsp[0].descriptor.str);
			free(yyvsp[0].descriptor.name);
			free(yyvsp[0].descriptor.str);
		}
    break;

  case 102:
#line 844 "preproc.y"
    {
			lookup_descriptor(yyvsp[0].str, connection);
			output_set_descr_header(yyvsp[0].str);
			free(yyvsp[0].str);
		}
    break;

  case 103:
#line 850 "preproc.y"
    {
			if (connection)
				mmerror(PARSE_ERROR, ET_ERROR, "no at option for typedef statement.\n");

			fprintf(yyout, "%s", yyvsp[0].str);
			free(yyvsp[0].str);
			output_line_number();
		}
    break;

  case 104:
#line 859 "preproc.y"
    {
			if (connection)
				mmerror(PARSE_ERROR, ET_ERROR, "no at option for var statement.\n");

			output_simple_statement(yyvsp[0].str);
		}
    break;

  case 105:
#line 866 "preproc.y"
    {
			if (connection)
				mmerror(PARSE_ERROR, ET_ERROR, "no at option for whenever statement.\n");

			output_simple_statement(yyvsp[0].str);
		}
    break;

  case 106:
#line 887 "preproc.y"
    { yyval.str = cat_str(4, make_str("create user"), yyvsp[-2].str, make_str("with"), yyvsp[0].str); }
    break;

  case 107:
#line 890 "preproc.y"
    { yyval.str = make_str("with"); }
    break;

  case 108:
#line 891 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 109:
#line 903 "preproc.y"
    { yyval.str = cat_str(3, make_str("alter user"), yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 110:
#line 905 "preproc.y"
    { yyval.str = cat_str(4, make_str("alter user"), yyvsp[-2].str, make_str("with"), yyvsp[0].str); }
    break;

  case 111:
#line 909 "preproc.y"
    { yyval.str = cat_str(4, make_str("alter user"), yyvsp[-2].str, make_str("set"), yyvsp[0].str); }
    break;

  case 112:
#line 911 "preproc.y"
    { yyval.str = cat_str(3, make_str("alter user"), yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 113:
#line 921 "preproc.y"
    { yyval.str = cat2_str(make_str("drop user"), yyvsp[0].str);}
    break;

  case 114:
#line 927 "preproc.y"
    { yyval.str = cat2_str(yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 115:
#line 928 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 116:
#line 932 "preproc.y"
    { yyval.str = cat2_str(make_str("password"), yyvsp[0].str); }
    break;

  case 117:
#line 934 "preproc.y"
    { yyval.str = cat2_str(make_str("sysid"), yyvsp[0].str); }
    break;

  case 118:
#line 936 "preproc.y"
    { yyval.str = make_str("createdb"); }
    break;

  case 119:
#line 938 "preproc.y"
    { yyval.str = make_str("nocreatedb"); }
    break;

  case 120:
#line 940 "preproc.y"
    { yyval.str = make_str("createuser"); }
    break;

  case 121:
#line 942 "preproc.y"
    { yyval.str = make_str("nocreateuser"); }
    break;

  case 122:
#line 944 "preproc.y"
    { yyval.str = cat2_str(make_str("in group"), yyvsp[0].str); }
    break;

  case 123:
#line 946 "preproc.y"
    { yyval.str = cat2_str(make_str("valid until"), yyvsp[0].str); }
    break;

  case 124:
#line 950 "preproc.y"
    { yyval.str = cat_str(3, yyvsp[-2].str, make