.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "DROP OPERATOR FAMILY" "" "2007-12-02" "SQL - Language Statements" "SQL Commands"
.SH NAME
DROP OPERATOR FAMILY \- remove an operator family

.SH SYNOPSIS
.sp
.nf
DROP OPERATOR FAMILY [ IF EXISTS ] \fIname\fR USING \fIindex_method\fR [ CASCADE | RESTRICT ]
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBDROP OPERATOR FAMILY\fR drops an existing operator family.
To execute this command you must be the owner of the operator family.
.PP
\fBDROP OPERATOR FAMILY\fR includes dropping any operator
classes contained in the family, but it does not drop any of the operators
or functions referenced by the family. If there are any indexes depending
on operator classes within the family, you will need to specify
CASCADE for the drop to complete.
.SH "PARAMETERS"
.TP
\fBIF EXISTS\fR
Do not throw an error if the operator family does not exist.
A notice is issued in this case.
.TP
\fB\fIname\fB\fR
The name (optionally schema-qualified) of an existing operator family.
.TP
\fB\fIindex_method\fB\fR
The name of the index access method the operator family is for.
.TP
\fBCASCADE\fR
Automatically drop objects that depend on the operator family.
.TP
\fBRESTRICT\fR
Refuse to drop the operator family if any objects depend on it.
This is the default.
.SH "EXAMPLES"
.PP
Remove the B-tree operator family float_ops:
.sp
.nf
DROP OPERATOR FAMILY float_ops USING btree;
.sp
.fi
This command will not succeed if there are any existing indexes
that use operator classes within the family. Add CASCADE to
drop such indexes along with the operator family.
.SH "COMPATIBILITY"
.PP
There is no \fBDROP OPERATOR FAMILY\fR statement in the
SQL standard.
.SH "SEE ALSO"
ALTER OPERATOR FAMILY [\fBalter_operator_family\fR(l)], CREATE OPERATOR FAMILY [\fBcreate_operator_family\fR(l)], ALTER OPERATOR CLASS [\fBalter_operator_class\fR(l)], CREATE OPERATOR CLASS [\fBcreate_operator_class\fR(l)], DROP OPERATOR CLASS [\fBdrop_operator_class\fR(l)]
