/*
 * "streamable kanji code filter and converter"
 *
 * Copyright (c) 1998,1999 HappySize, Inc. All rights reserved.
 *
 * ѵ
 *
 * ΥեȥϳҥϥåԡˤäƳȯޤҥϥ
 * ԡϡˡˤꡢΥեȥ˴
 * 뤹٤Ƥθαݤ븢˹ԻȤޤҥϥåԡ
 * ϰʲ˽äơΥեȥѤ¾ŪǤϤʤ
 * 򤪵ͤ˵ޤͤȤ⡢ʲξȿƤΥեȥ
 * 뤳ȤϤǤޤ
 *
 * ΥեȥGNU Lesser General Public License (Version 2.1, February
 * 1999)פ˼줿ǻѤ뤳ȤƤ˵ޤGNU Lesser
 * General Public LicenseפʤѤˤϡҥϥåԡ
 * ˤɬפޤ
 *
 * GNU Lesser General Public LicenseפʸϰʲΥ֥ڡǤ
 * ޤGNU Lesser General Public LicenseפȤϡޤLibrary General
 * Public LicenseȸƤФƤΤǤ
 *     http://www.gnu.org/ --- GNU֥
 *     http://www.gnu.org/copyleft/lesser.html --- 饤ʸ
 * Υ饤󥹤Ƥ狼ʤʤˤϻѤޤ
 *
 * ʤ顢ҤGNUץȤȤδط򼨺ޤϼĥΤ
 * Ϥޤ
 *
 * ݾƢ
 *
 * ΥեȥϡԤ줿ưǽǽĤȤɸȤ߷פ
 * ȯƤޤݾڤΤǤϤޤ󡣤Υեȥϡ֤
 * Τޤޡפξ֤󶡤ƤꡢȤФΥեȥͭʤ
 * Ū˹פ뤳ȤȤä餫ݾƤ줿ۤ˼Ƥ
 * ǤäƤ⡢ݾڤ̵ǤΥեȥѤ̤ʤ
 * Ѥʤä̤ˤäơľܤ뤤ϴܤ˼Ūʽ⻺»
 * ǡ»뤤Ϥ¾Ƥ»ˤĤƤϡ»βǽѼ
 * Ҥ뤤軰ԤˤäƷٹ𤵤ƤǤäƤ⡢ҤϤ»
 * ŶԤޤ󡣤ε¾ƤΡ̾ޤϽ̵̤ݾڡ
 * 󡦵ͥ褷ޤ
 *
 * ԤϢ褪ӻѾˤĤƤ䤤碌袡
 *
 * 112-0004ʸ1-1-13ӥ7F
 * ҥϥåԡ
 * Phone: 03-5803-2964, Fax: 03-5803-2965
 * http://www.happysize.co.jp/ mailto:info@happysize.co.jp
 *
 * Ԣ
 *
 * ܡ <sgk@happysize.co.jp>
 *
 * 
 *
 * 1998/11/10 sgk implementation in C++
 * 1999/4/25  sgk Cǽ񤭤ʤ
 * 1999/4/26  sgk ϥե륿ɤꤷʤե륿ɲá
 * 1999/6/??      Ĥˤ롢Unicodeݡȡ
 * 1999/6/22  sgk 饤󥹤LGPLѹĤλѤߡ
 *
 */

/*
 *
 * streamable kanji code filter and converter
 *
 */

#ifndef	HAPPYSIZE_KANJI_CONVERSION_KANJI_H
#define	HAPPYSIZE_KANJI_CONVERSION_KANJI_H

/* mbfl : Multi Byte FiLter Liblary */

enum mbfl_no_language {
	mbfl_no_language_unknown   = 0,
	mbfl_no_language_universal = 1,
	mbfl_no_language_en_us     = 2,
	mbfl_no_language_ja_jp     = 3
};

typedef struct {
	enum mbfl_no_language no_language;
	const char *name;
	const char *(*aliases)[];
} mbfl_language;

typedef mbfl_language* mbfl_language_ptr;

enum mbfl_no_encoding {
	mbfl_no_encoding_auto   = 0,
	mbfl_no_encoding_pass   = 1,
	mbfl_no_encoding_wchar  = 2,
	mbfl_no_encoding_base64 = 3,
	mbfl_no_encoding_qprint = 4,
	mbfl_no_encoding_utf8   = 5,
	mbfl_no_encoding_ucs    = 6,
	mbfl_no_encoding_en_us_ascii = 7,
	mbfl_no_encoding_ja_jp_euc   = 8,
	mbfl_no_encoding_ja_jp_sjis  = 9,
	mbfl_no_encoding_ja_jp_jis   = 10
};

typedef struct {
	enum mbfl_no_encoding no_encoding;
	const char *name;
	const char *(*aliases)[];
	const char *mime_name;
	mbfl_language_ptr planguage;
} mbfl_encoding;

typedef mbfl_encoding* mbfl_encoding_ptr;

/*
 * string to pointer to encoding description structure
 */
mbfl_encoding_ptr
mbfl_name2encoding(const char *name);

/*
 * int to pointer to encoding description structure
 */
mbfl_encoding_ptr
mbfl_no2encoding(int no_encoding);


/*
 * ˽Ϥoutput_function
 */
extern int memory_device_output(int c, void* data);
extern int wchar_device_output(int c, void* data);

#define MBFL_MEMORY_DEVICE_ALLOC_SIZE	64

struct memory_device {
	char* buffer;	/* (char*)0˽ɬפ롣 */
	int length;		/* 0˽ɬפ롣 */
	int pos;		/* 0˽ɬפ롣 */
};

struct wchar_device {
	int* buffer;	/* (int*)0˽ɬפ롣 */
	int length;		/* 0˽ɬפ롣 */
	int pos;		/* 0˽ɬפ롣 */
};

extern int memory_device_cat(struct memory_device *pd, const char *psrc);
extern int memory_device_ncat(struct memory_device *pd, const char *psrc, int len);

/*
 *
 * output filter
 *
 */
struct mbfl_output_filter;	/* forward declaration */

struct mbfl_output_filter* mbfl_output_filter_new(
    enum mbfl_no_encoding from,		/* current encoding */
    enum mbfl_no_encoding to,		/* new encoding */
    int (*output_function)(int, void*),	/* output function */
    int (*flush_function)(void*),	/* can be NULL */
    void* data);			/* argument for *_function() */
    /*
     * ե륿֥Ȥ롣ե륿ѤߤʸϤ٤оݤδؿ
     * output_function˻ꤹ롣оݤХåե󥰤ԤäƤϡ
     * flush_function˥եåΤδؿꤹ롣NULLꤹ
     * եåϹԤʤ嵭ĤδؿˤϡdataͿͤϤ롣
     * ͤƤˤĤƤϥե륿ϴΤʤ
     *
     * int (*output_function)(int c, void* data)
     *     ʸc񤭽Ф顼λϥޥʥ֤ͤȡʤУʾ塣
     *
     * int (*flush_function)(void*)
     *     եå夹롣顼λϥޥʥ֤ͤȡʤУʾ塣
     *
     */

void mbfl_output_filter_delete(struct mbfl_output_filter* filter);
    /*
     * ե륿֥Ȥ롣
     * flush_functionNULLǤʤХեå夵롣
     */

int mbfl_output_filter_feed(struct mbfl_output_filter* filter, int c);
    /*
     * ե륿Фƣʸꤳࡣ
     * c0-255Ǥɬפ롣charĥդ뤳ȡ
     * cͤϰϤɤȤˤĤƤϴΤƤʤ
     * ƤӽФ¦ǤĤȡʤη̤ꡣ
     * cƱ֤ͤ롣
     */

int mbfl_output_filter_flush(struct mbfl_output_filter* filter);
    /*
     * եå夹롣ͤ(*flush_function)()͡
     */

enum mbfl_no_encoding mbfl_output_filter_encoding(
    struct mbfl_output_filter* filter);
    /*
     * ߤΥ󥳡ǥ󥰡¦ˤ롣
     * fromunknownȤ˻ȤΤŪ
     */

void
mbfl_output_filter_reset(
    struct mbfl_output_filter* filter,
    enum mbfl_no_encoding from,
    enum mbfl_no_encoding to);
    /*
     * ϤΥ󥳡ǥ󥰤ڤؤ롣
     */

void
mbfl_output_filter_copy(
    struct mbfl_output_filter* src,
    struct mbfl_output_filter* dist);
    /*
     * filterСѿΥԡ
     */

int
mbfl_output_filter_unknown_default(
    struct mbfl_output_filter* filter,
    enum mbfl_no_encoding dfl);
    /*
     * filter  from  auto ξǡ
     * ϤΥ󥳡ǥ󥰤ꤷʤ
     * ǥեȤꤹ롣
     * ǻꤷʤ pass ˤʤΤ
     * ʸûʤɤǥ󥳡ǥ󥰤
     * Ƚ꤬ԳξѴԤʤ
     */


/*
 *
 * input filter
 *
 */
struct mbfl_input_filter;	/* forward */

struct mbfl_input_filter* mbfl_input_filter_new(
    enum mbfl_no_encoding from,		/* current encoding */
    enum mbfl_no_encoding to,		/* new encoding */
    int (*input_function)(void*),	/* input function */
    void* data);			/* argument for *_function() */
    /*
     * int (*input_function)(void* data)
     *     should return a char or -1 on EOF.
     */

void mbfl_input_filter_delete(struct mbfl_input_filter* filter);
    /*
     * ե륿֥Ȥ롣
     */

int mbfl_input_filter_retrieve(struct mbfl_input_filter* filter);
    /*
     * returns a char, or -1 on EOF.
     */

enum mbfl_no_encoding mbfl_input_filter_encoding(
    struct mbfl_input_filter* filter);
    /*
     * ߤΥ󥳡ǥ󥰡¦ˤ롣
     * fromunknownȤ˻ȤΤŪ
     */

/*
 *
 * ˽Ϥե륿
 *
 * newdeleteϼfeedflushoutput_filterΤȤ
 *
 */
struct mbfl_output_filter* mbfl_output_to_memory_new(
    enum mbfl_no_encoding from,
    enum mbfl_no_encoding to);

void mbfl_output_to_memory_delete(struct mbfl_output_filter* filter);

char* mbfl_output_to_memory_result(struct mbfl_output_filter* filter);
    /*
     * Ǥη̤롣
     * malloc줿ΰ褬֤롣freeϸƤӽФ¦Ǥ
     * ¦Ȥ硢λǿꤵ롣
     */

/*
 *
 * kanji converter
 *
 */
char* mbfl_encoding_convert(
    enum mbfl_no_encoding from,
    enum mbfl_no_encoding to,
    const char* s);
    /*
     * Ϳʸ򥳡Ѵ롣malloc줿ΰ֤
     * ΰϡƤӽФ¦Ǥäfreeɬפ롣
     */

/*
 *
 * identify kanji code
 *
 */
enum mbfl_no_encoding mbfl_identify_encoding(const char* s);

/*
 *
 * ޥХʸбstrlen
 *
 */
int
mbfl_strlen(
    const char* s,
    enum mbfl_no_encoding code);

/*
 *
 * ޥХʸбstrpos
 *
 */
int
mbfl_strpos(
    const char* haystack,
    const char* needle,
    int offset,
    enum mbfl_no_encoding code,
    int reverse);

/*
 *
 * ޥХʸбsubstr
 *
 */
char*
mbfl_substr(
    const char* s,
    int from,
    int length,
    enum mbfl_no_encoding code);

/*
 *
 * strcut
 *
 */
char*
mbfl_strcut(
    const char* s,
    int from,
    int length,
    enum mbfl_no_encoding code);

/*
 *
 * MIME header encode
 *
 */
struct mime_header_encoder_data;	/* forward declaration */

struct mime_header_encoder_data*
mime_header_encoder_new(
    enum mbfl_no_encoding incode,
    enum mbfl_no_encoding outcode,
    enum mbfl_no_encoding encoding);
    /*
     * 󥳡롣
     * incode : Ϥʸ
     * outcode : 󥳡ǥ󥰥֥åݤʸ
     * encoding : mbfl_no_encoding_base64ޤmbfl_no_encoding_qprint
     */

void
mime_header_encoder_delete(struct mime_header_encoder_data *pe);
    /*
     * 󥳡롣
     */

int
mime_header_encoder_feed(int c, struct mime_header_encoder_data *pe);
    /*
     * 󥳡˰ʸ롣
     */

char*
mime_header_encoder_result(struct mime_header_encoder_data *pe);
    /*
     * Ǥη̤롣
     * malloc줿ΰ褬֤롣freeϸƤӽФ¦Ǥ
     */

char*
mbfl_mime_header_encode(
    enum mbfl_no_encoding incode,
    enum mbfl_no_encoding outcode,
    enum mbfl_no_encoding encoding,
    const char *s,
    const char *linefeed);
    /*
     * ͿʸMIMEإå󥳡ɤ롣malloc줿ΰ֤
     * ΰϡƤӽФ¦Ǥäfreeɬפ롣
     * incode : sʸ
     * outcode : 󥳡ǥ󥰥֥åݤʸ
     * encoding : mbfl_no_encoding_base64ޤmbfl_no_encoding_qprint
     * s : 󥳡ɤʸ
     * linefeed : ԥɡNULLξϥǥե"\r\n"
     */

/*
 *
 * MIME header decode
 *
 */
struct mime_header_decoder_data;	/* forward declaration */

struct mime_header_decoder_data*
mime_header_decoder_new(enum mbfl_no_encoding outcode);
    /*
     * ǥ롣
     * outcode : ǥɷ̤Ϥ˻Ȥʸ
     */

void
mime_header_decoder_delete(struct mime_header_decoder_data *pd);
    /*
     * ǥ롣
     */

int
mime_header_decoder_feed(int c, struct mime_header_decoder_data *pd);
    /*
     * ǥ˰ʸ롣
     */

char*
mime_header_decoder_result(struct mime_header_decoder_data *pd);
    /*
     * Ǥη̤롣
     * malloc줿ΰ褬֤롣freeϸƤӽФ¦Ǥ
     */

char*
mbfl_mime_header_decode(
    enum mbfl_no_encoding outcode,
    const char *s);
    /*
     * ͿʸMIMEإå󥳡ɥ֥åǥɤ롣
     * malloc줿ΰ֤
     * ΰϡƤӽФ¦Ǥäfreeɬפ롣
     * outcode : Ϥʸ
     * s : ǥɤʸ
     */

/*
 *
 * ȾѤѤѴ
 *
 */
char* mbfl_ja_jp_hantozen(
    const char* s,
    int mode,
    enum mbfl_no_encoding code);

#endif	/* HAPPYSIZE_KANJI_CONVERSION_KANJI_H */
