/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc2;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Map;
import java.util.Vector;
import org.postgresql.Driver;
import org.postgresql.core.BaseConnection;
import org.postgresql.core.BaseStatement;
import org.postgresql.core.Field;
import org.postgresql.core.ParameterList;
import org.postgresql.core.Query;
import org.postgresql.core.ResultCursor;
import org.postgresql.core.ResultHandler;
import org.postgresql.core.types.PGBigDecimal;
import org.postgresql.core.types.PGBoolean;
import org.postgresql.core.types.PGByte;
import org.postgresql.core.types.PGDouble;
import org.postgresql.core.types.PGFloat;
import org.postgresql.core.types.PGInteger;
import org.postgresql.core.types.PGLong;
import org.postgresql.core.types.PGNumber;
import org.postgresql.core.types.PGShort;
import org.postgresql.core.types.PGType;
import org.postgresql.core.types.PGUnknown;
import org.postgresql.jdbc2.AbstractJdbc2Connection;
import org.postgresql.jdbc2.EscapedFunctions;
import org.postgresql.jdbc2.ResultWrapper;
import org.postgresql.largeobject.LargeObject;
import org.postgresql.largeobject.LargeObjectManager;
import org.postgresql.util.GT;
import org.postgresql.util.PGobject;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public abstract class AbstractJdbc2Statement
implements BaseStatement {
    protected ArrayList batchStatements = null;
    protected ArrayList batchParameters = null;
    protected final int resultsettype;
    protected final int concurrency;
    protected int fetchdirection = 1000;
    protected boolean wantsGeneratedKeysOnce = false;
    public boolean wantsGeneratedKeysAlways = false;
    protected BaseConnection connection;
    protected SQLWarning warnings = null;
    protected int maxrows = 0;
    protected int fetchSize = 0;
    protected int timeout = 0;
    protected boolean replaceProcessingEnabled = true;
    protected ResultWrapper result = null;
    protected ResultWrapper firstUnclosedResult = null;
    protected ResultWrapper generatedKeys = null;
    protected boolean adjustIndex = false;
    protected boolean outParmBeforeFunc = false;
    private static final short IN_SQLCODE = 0;
    private static final short IN_STRING = 1;
    private static final short IN_IDENTIFIER = 6;
    private static final short BACKSLASH = 2;
    private static final short ESC_TIMEDATE = 3;
    private static final short ESC_FUNCTION = 4;
    private static final short ESC_OUTERJOIN = 5;
    private static final short ESC_ESCAPECHAR = 7;
    protected final Query preparedQuery;
    protected final ParameterList preparedParameters;
    protected Query lastSimpleQuery;
    protected int m_prepareThreshold;
    protected int m_useCount = 0;
    private boolean isFunction;
    private int[] functionReturnType;
    private int[] testReturn;
    private boolean returnTypeSet;
    protected Object[] callResult;
    protected int maxfieldSize = 0;
    protected boolean isClosed = false;
    private int lastIndex = 0;

    public ResultSet createDriverResultSet(Field[] fields, Vector tuples) throws SQLException {
        return this.createResultSet(null, fields, tuples, null);
    }

    public AbstractJdbc2Statement(AbstractJdbc2Connection c, int rsType, int rsConcurrency) throws SQLException {
        this.connection = c;
        this.preparedQuery = null;
        this.preparedParameters = null;
        this.lastSimpleQuery = null;
        this.resultsettype = rsType;
        this.concurrency = rsConcurrency;
    }

    public AbstractJdbc2Statement(AbstractJdbc2Connection connection, String sql, boolean isCallable, int rsType, int rsConcurrency) throws SQLException {
        this.connection = connection;
        this.lastSimpleQuery = null;
        String parsed_sql = this.replaceProcessing(sql);
        if (isCallable) {
            parsed_sql = this.modifyJdbcCall(parsed_sql);
        }
        this.preparedQuery = connection.getQueryExecutor().createParameterizedQuery(parsed_sql);
        this.preparedParameters = this.preparedQuery.createParameterList();
        int inParamCount = this.preparedParameters.getInParameterCount() + 1;
        this.testReturn = new int[inParamCount];
        this.functionReturnType = new int[inParamCount];
        this.resultsettype = rsType;
        this.concurrency = rsConcurrency;
    }

    public abstract ResultSet createResultSet(Query var1, Field[] var2, Vector var3, ResultCursor var4) throws SQLException;

    public BaseConnection getPGConnection() {
        return this.connection;
    }

    public String getFetchingCursorName() {
        return null;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    protected boolean wantsScrollableResultSet() {
        return this.resultsettype != 1003;
    }

    protected boolean wantsHoldableResultSet() {
        return false;
    }

    public ResultSet executeQuery(String p_sql) throws SQLException {
        if (this.preparedQuery != null) {
            throw new PSQLException(GT.tr("Can''t use query methods that take a query string on a PreparedStatement."), PSQLState.WRONG_OBJECT_TYPE);
        }
        if (!this.executeWithFlags(p_sql, 0)) {
            throw new PSQLException(GT.tr("No results were returned by the query."), PSQLState.NO_DATA);
        }
        if (this.result.getNext() != null) {
            throw new PSQLException(GT.tr("Multiple ResultSets were returned by the query."), PSQLState.TOO_MANY_RESULTS);
        }
        return this.result.getResultSet();
    }

    public ResultSet executeQuery() throws SQLException {
        if (!this.executeWithFlags(0)) {
            throw new PSQLException(GT.tr("No results were returned by the query."), PSQLState.NO_DATA);
        }
        if (this.result.getNext() != null) {
            throw new PSQLException(GT.tr("Multiple ResultSets were returned by the query."), PSQLState.TOO_MANY_RESULTS);
        }
        return this.result.getResultSet();
    }

    public int executeUpdate(String p_sql) throws SQLException {
        if (this.preparedQuery != null) {
            throw new PSQLException(GT.tr("Can''t use query methods that take a query string on a PreparedStatement."), PSQLState.WRONG_OBJECT_TYPE);
        }
        if (this.isFunction) {
            this.executeWithFlags(p_sql, 0);
            return 0;
        }
        if (this.executeWithFlags(p_sql, 4)) {
            throw new PSQLException(GT.tr("A result was returned when none was expected."), PSQLState.TOO_MANY_RESULTS);
        }
        return this.getUpdateCount();
    }

    public int executeUpdate() throws SQLException {
        if (this.isFunction) {
            this.executeWithFlags(0);
            return 0;
        }
        if (this.executeWithFlags(4)) {
            throw new PSQLException(GT.tr("A result was returned when none was expected."), PSQLState.TOO_MANY_RESULTS);
        }
        return this.getUpdateCount();
    }

    public boolean execute(String p_sql) throws SQLException {
        if (this.preparedQuery != null) {
            throw new PSQLException(GT.tr("Can''t use query methods that take a query string on a PreparedStatement."), PSQLState.WRONG_OBJECT_TYPE);
        }
        return this.executeWithFlags(p_sql, 0);
    }

    public boolean executeWithFlags(String p_sql, int flags) throws SQLException {
        this.checkClosed();
        p_sql = this.replaceProcessing(p_sql);
        Query simpleQuery = this.connection.getQueryExecutor().createSimpleQuery(p_sql);
        this.execute(simpleQuery, null, 1 | flags);
        this.lastSimpleQuery = simpleQuery;
        return this.result != null && this.result.getResultSet() != null;
    }

    public boolean execute() throws SQLException {
        return this.executeWithFlags(0);
    }

    public boolean executeWithFlags(int flags) throws SQLException {
        this.checkClosed();
        this.execute(this.preparedQuery, this.preparedParameters, flags);
        if (this.isFunction && this.returnTypeSet) {
            int outParameterCount;
            if (this.result == null || this.result.getResultSet() == null) {
                throw new PSQLException(GT.tr("A CallableStatement was executed with nothing returned."), PSQLState.NO_DATA);
            }
            ResultSet rs = this.result.getResultSet();
            if (!rs.next()) {
                throw new PSQLException(GT.tr("A CallableStatement was executed with nothing returned."), PSQLState.NO_DATA);
            }
            int cols = rs.getMetaData().getColumnCount();
            if (cols != (outParameterCount = this.preparedParameters.getOutParameterCount())) {
                throw new PSQLException(GT.tr("A CallableStatement was executed with an invalid number of parameters"), PSQLState.SYNTAX_ERROR);
            }
            this.lastIndex = 0;
            this.callResult = new Object[this.preparedParameters.getParameterCount() + 1];
            int i = 0;
            int j = 0;
            while (i < cols) {
                while (j < this.functionReturnType.length && this.functionReturnType[j] == 0) {
                    ++j;
                }
                this.callResult[j] = rs.getObject(i + 1);
                int columnType = rs.getMetaData().getColumnType(i + 1);
                if (columnType != this.functionReturnType[j]) {
                    if (columnType == 8 && this.functionReturnType[j] == 7) {
                        if (this.callResult[j] != null) {
                            this.callResult[j] = new Float(((Double)this.callResult[j]).floatValue());
                        }
                    } else {
                        throw new PSQLException(GT.tr("A CallableStatement function was executed and the out parameter {0} was of type {1} however type {2} was registered.", new Object[]{new Integer(i + 1), "java.sql.Types=" + columnType, "java.sql.Types=" + this.functionReturnType[j]}), PSQLState.DATA_TYPE_MISMATCH);
                    }
                }
                ++i;
                ++j;
            }
            rs.close();
            this.result = null;
            return false;
        }
        return this.result != null && this.result.getResultSet() != null;
    }

    protected void execute(Query queryToExecute, ParameterList queryParameters, int flags) throws SQLException {
        this.clearWarnings();
        while (this.firstUnclosedResult != null) {
            if (this.firstUnclosedResult.getResultSet() != null) {
                this.firstUnclosedResult.getResultSet().close();
            }
            this.firstUnclosedResult = this.firstUnclosedResult.getNext();
        }
        if (this.lastSimpleQuery != null) {
            this.lastSimpleQuery.close();
            this.lastSimpleQuery = null;
        }
        if (!(this.fetchSize <= 0 || this.wantsScrollableResultSet() || this.connection.getAutoCommit() || this.wantsHoldableResultSet())) {
            flags |= 8;
        }
        if ((this.wantsGeneratedKeysOnce || this.wantsGeneratedKeysAlways) && ((flags |= 0x40) & 4) != 0) {
            flags &= 0xFFFFFFFB;
        }
        if (this.preparedQuery != null) {
            ++this.m_useCount;
            if (this.m_prepareThreshold == 0 || this.m_useCount < this.m_prepareThreshold) {
                flags |= 1;
            }
        }
        if (this.connection.getAutoCommit()) {
            flags |= 0x10;
        }
        StatementResultHandler handler = new StatementResultHandler();
        this.result = null;
        this.connection.getQueryExecutor().execute(queryToExecute, queryParameters, (ResultHandler)handler, this.maxrows, this.fetchSize, flags);
        this.result = this.firstUnclosedResult = handler.getResults();
        if (this.wantsGeneratedKeysOnce || this.wantsGeneratedKeysAlways) {
            this.generatedKeys = this.result;
            this.result = this.result.getNext();
            if (this.wantsGeneratedKeysOnce) {
                this.wantsGeneratedKeysOnce = false;
            }
        }
    }

    public void setCursorName(String name) throws SQLException {
        this.checkClosed();
    }

    public int getUpdateCount() throws SQLException {
        this.checkClosed();
        if (this.result == null || this.result.getResultSet() != null) {
            return -1;
        }
        return this.result.getUpdateCount();
    }

    public boolean getMoreResults() throws SQLException {
        if (this.result == null) {
            return false;
        }
        this.result = this.result.getNext();
        while (this.firstUnclosedResult != this.result) {
            if (this.firstUnclosedResult.getResultSet() != null) {
                this.firstUnclosedResult.getResultSet().close();
            }
            this.firstUnclosedResult = this.firstUnclosedResult.getNext();
        }
        return this.result != null && this.result.getResultSet() != null;
    }

    public int getMaxRows() throws SQLException {
        this.checkClosed();
        return this.maxrows;
    }

    public void setMaxRows(int max) throws SQLException {
        this.checkClosed();
        if (max < 0) {
            throw new PSQLException(GT.tr("Maximum number of rows must be a value grater than or equal to 0."), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.maxrows = max;
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.checkClosed();
        this.replaceProcessingEnabled = enable;
    }

    public int getQueryTimeout() throws SQLException {
        this.checkClosed();
        return this.timeout;
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        this.checkClosed();
        if (seconds < 0) {
            throw new PSQLException(GT.tr("Query timeout must be a value greater than or equals to 0."), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (seconds > 0) {
            throw Driver.notImplemented(this.getClass(), "setQueryTimeout(int)");
        }
        this.timeout = seconds;
    }

    public void addWarning(SQLWarning warn) {
        if (this.warnings != null) {
            this.warnings.setNextWarning(warn);
        } else {
            this.warnings = warn;
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return this.warnings;
    }

    public int getMaxFieldSize() throws SQLException {
        return this.maxfieldSize;
    }

    public void setMaxFieldSize(int max) throws SQLException {
        this.checkClosed();
        if (max < 0) {
            throw new PSQLException(GT.tr("The maximum field size must be a value greater than or equal to 0."), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.maxfieldSize = max;
    }

    public void clearWarnings() throws SQLException {
        this.warnings = null;
    }

    public ResultSet getResultSet() throws SQLException {
        this.checkClosed();
        if (this.result == null) {
            return null;
        }
        return this.result.getResultSet();
    }

    public void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        while (this.firstUnclosedResult != null) {
            if (this.firstUnclosedResult.getResultSet() != null) {
                this.firstUnclosedResult.getResultSet().close();
            }
            this.firstUnclosedResult = this.firstUnclosedResult.getNext();
        }
        if (this.lastSimpleQuery != null) {
            this.lastSimpleQuery.close();
        }
        if (this.preparedQuery != null) {
            this.preparedQuery.close();
        }
        this.firstUnclosedResult = null;
        this.result = null;
        this.isClosed = true;
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected String replaceProcessing(String p_sql) throws SQLException {
        if (this.replaceProcessingEnabled) {
            int len = p_sql.length();
            StringBuffer newsql = new StringBuffer(len);
            int i = 0;
            while (i < len) {
                if ((i = AbstractJdbc2Statement.parseSql(p_sql, i, newsql, false, this.connection.getStandardConformingStrings())) >= len) continue;
                newsql.append(p_sql.charAt(i));
                ++i;
            }
            return newsql.toString();
        }
        return p_sql;
    }

    protected static int parseSql(String p_sql, int i, StringBuffer newsql, boolean stopOnComma, boolean stdStrings) throws SQLException {
        int state = 0;
        int len = p_sql.length();
        int nestedParenthesis = 0;
        boolean endOfNested = false;
        --i;
        while (!endOfNested && ++i < len) {
            char c = p_sql.charAt(i);
            switch (state) {
                case 0: {
                    if (c == '\'') {
                        state = 1;
                    } else if (c == '\"') {
                        state = 6;
                    } else if (c == '(') {
                        ++nestedParenthesis;
                    } else if (c == ')') {
                        if (--nestedParenthesis < 0) {
                            endOfNested = true;
                            break;
                        }
                    } else {
                        if (stopOnComma && c == ',' && nestedParenthesis == 0) {
                            endOfNested = true;
                            break;
                        }
                        if (c == '{' && i + 1 < len) {
                            char nextnext;
                            char next = p_sql.charAt(i + 1);
                            char c2 = nextnext = i + 2 < len ? p_sql.charAt(i + 2) : (char)'\u0000';
                            if (next == 'd' || next == 'D') {
                                state = 3;
                                ++i;
                                newsql.append("DATE ");
                                break;
                            }
                            if (next == 't' || next == 'T') {
                                state = 3;
                                if (nextnext == 's' || nextnext == 'S') {
                                    i += 2;
                                    newsql.append("TIMESTAMP ");
                                    break;
                                }
                                ++i;
                                newsql.append("TIME ");
                                break;
                            }
                            if (next == 'f' || next == 'F') {
                                state = 4;
                                i += nextnext == 'n' || nextnext == 'N' ? 2 : 1;
                                break;
                            }
                            if (next == 'o' || next == 'O') {
                                state = 5;
                                i += nextnext == 'j' || nextnext == 'J' ? 2 : 1;
                                break;
                            }
                            if (next == 'e' || next == 'E') {
                                state = 7;
                                break;
                            }
                        }
                    }
                    newsql.append(c);
                    break;
                }
                case 1: {
                    if (c == '\'') {
                        state = 0;
                    } else if (c == '\\' && !stdStrings) {
                        state = 2;
                    }
                    newsql.append(c);
                    break;
                }
                case 6: {
                    if (c == '\"') {
                        state = 0;
                    }
                    newsql.append(c);
                    break;
                }
                case 2: {
                    state = 1;
                    newsql.append(c);
                    break;
                }
                case 4: {
                    int posArgs = p_sql.indexOf(40, i);
                    if (posArgs != -1) {
                        String functionName = p_sql.substring(i, posArgs).trim();
                        i = posArgs + 1;
                        StringBuffer args = new StringBuffer();
                        i = AbstractJdbc2Statement.parseSql(p_sql, i, args, false, stdStrings);
                        newsql.append(AbstractJdbc2Statement.escapeFunction(functionName, args.toString(), stdStrings));
                    }
                    ++i;
                    while (i < len && p_sql.charAt(i) != '}') {
                        newsql.append(p_sql.charAt(i++));
                    }
                    state = 0;
                    break;
                }
                case 3: 
                case 5: 
                case 7: {
                    if (c == '}') {
                        state = 0;
                        break;
                    }
                    newsql.append(c);
                }
            }
        }
        return i;
    }

    protected static String escapeFunction(String functionName, String args, boolean stdStrings) throws SQLException {
        int len = args.length();
        ArrayList<StringBuffer> parsedArgs = new ArrayList<StringBuffer>();
        for (int i = 0; i < len; ++i) {
            int lastPos = i;
            StringBuffer arg = new StringBuffer();
            if (lastPos == (i = AbstractJdbc2Statement.parseSql(args, i, arg, true, stdStrings))) continue;
            parsedArgs.add(arg);
        }
        try {
            Method escapeMethod = EscapedFunctions.getFunction(functionName);
            return (String)escapeMethod.invoke(null, parsedArgs);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof SQLException) {
                throw (SQLException)e.getTargetException();
            }
            throw new PSQLException(e.getTargetException().getMessage(), PSQLState.SYSTEM_ERROR);
        }
        catch (Exception e) {
            StringBuffer buf = new StringBuffer();
            buf.append(functionName).append('(');
            for (int iArg = 0; iArg < parsedArgs.size(); ++iArg) {
                buf.append(parsedArgs.get(iArg));
                if (iArg == parsedArgs.size() - 1) continue;
                buf.append(',');
            }
            buf.append(')');
            return buf.toString();
        }
    }

    public int getInsertedOID() throws SQLException {
        this.checkClosed();
        if (this.result == null) {
            return 0;
        }
        return (int)this.result.getInsertOID();
    }

    public long getLastOID() throws SQLException {
        this.checkClosed();
        if (this.result == null) {
            return 0L;
        }
        return this.result.getInsertOID();
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        int oid;
        this.checkClosed();
        switch (sqlType) {
            case 4: {
                oid = 23;
                break;
            }
            case -6: 
            case 5: {
                oid = 21;
                break;
            }
            case -5: {
                oid = 20;
                break;
            }
            case 7: {
                oid = 700;
                break;
            }
            case 6: 
            case 8: {
                oid = 701;
                break;
            }
            case 2: 
            case 3: {
                oid = 1700;
                break;
            }
            case 1: {
                oid = 1042;
                break;
            }
            case -1: 
            case 12: {
                oid = 1043;
                break;
            }
            case 91: {
                oid = 1082;
                break;
            }
            case 92: {
                oid = 1083;
                break;
            }
            case 93: {
                oid = 1184;
                break;
            }
            case -7: {
                oid = 16;
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                if (this.connection.haveMinimumCompatibleVersion("7.2")) {
                    oid = 17;
                    break;
                }
                oid = 26;
                break;
            }
            case 2004: 
            case 2005: {
                oid = 26;
                break;
            }
            case 0: 
            case 1111: 
            case 2001: 
            case 2002: 
            case 2003: {
                oid = 0;
                break;
            }
            default: {
                throw new PSQLException(GT.tr("Unknown Types value."), PSQLState.INVALID_PARAMETER_TYPE);
            }
        }
        if (this.adjustIndex) {
            --parameterIndex;
        }
        this.preparedParameters.setNull(parameterIndex, oid);
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.checkClosed();
        this.bindString(parameterIndex, x ? "1" : "0", 16);
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.checkClosed();
        this.bindLiteral(parameterIndex, Integer.toString(x), 21);
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        this.checkClosed();
        this.bindLiteral(parameterIndex, Integer.toString(x), 21);
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        this.checkClosed();
        this.bindLiteral(parameterIndex, Integer.toString(x), 23);
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        this.checkClosed();
        this.bindLiteral(parameterIndex, Long.toString(x), 20);
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.checkClosed();
        this.bindLiteral(parameterIndex, Float.toString(x), 701);
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.checkClosed();
        this.bindLiteral(parameterIndex, Double.toString(x), 701);
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.checkClosed();
        if (x == null) {
            this.setNull(parameterIndex, 3);
        } else {
            this.bindLiteral(parameterIndex, x.toString(), 1700);
        }
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        this.checkClosed();
        this.setString(parameterIndex, x, this.connection.getStringVarcharFlag() ? 1043 : 0);
    }

    protected void setString(int parameterIndex, String x, int oid) throws SQLException {
        this.checkClosed();
        if (x == null) {
            if (this.adjustIndex) {
                --parameterIndex;
            }
            this.preparedParameters.setNull(parameterIndex, oid);
        } else {
            this.bindString(parameterIndex, x, oid);
        }
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.checkClosed();
        if (null == x) {
            this.setNull(parameterIndex, -3);
            return;
        }
        if (this.connection.haveMinimumCompatibleVersion("7.2")) {
            byte[] copy = new byte[x.length];
            System.arraycopy(x, 0, copy, 0, x.length);
            this.preparedParameters.setBytea(parameterIndex, copy, 0, x.length);
        } else {
            LargeObjectManager lom = this.connection.getLargeObjectAPI();
            long oid = lom.createLO();
            LargeObject lob = lom.open(oid);
            lob.write(x);
            lob.close();
            this.setLong(parameterIndex, oid);
        }
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.setDate(parameterIndex, x, null);
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.setTime(parameterIndex, x, null);
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.setTimestamp(parameterIndex, x, null);
    }

    private void setCharacterStreamPost71(int parameterIndex, InputStream x, int length, String encoding) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 12);
            return;
        }
        if (length < 0) {
            throw new PSQLException(GT.tr("Invalid stream length {0}.", new Integer(length)), PSQLState.INVALID_PARAMETER_VALUE);
        }
        try {
            int n;
            InputStreamReader l_inStream = new InputStreamReader(x, encoding);
            char[] l_chars = new char[length];
            int l_charsRead = 0;
            while ((n = l_inStream.read(l_chars, l_charsRead, length - l_charsRead)) != -1 && (l_charsRead += n) != length) {
            }
            this.setString(parameterIndex, new String(l_chars, 0, l_charsRead), 1043);
        }
        catch (UnsupportedEncodingException l_uee) {
            throw new PSQLException(GT.tr("The JVM claims not to support the {0} encoding.", encoding), PSQLState.UNEXPECTED_ERROR, (Throwable)l_uee);
        }
        catch (IOException l_ioe) {
            throw new PSQLException(GT.tr("Provided InputStream failed."), PSQLState.UNEXPECTED_ERROR, (Throwable)l_ioe);
        }
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkClosed();
        if (this.connection.haveMinimumCompatibleVersion("7.2")) {
            this.setCharacterStreamPost71(parameterIndex, x, length, "ASCII");
        } else {
            this.setBinaryStream(parameterIndex, x, length);
        }
    }

    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkClosed();
        if (this.connection.haveMinimumCompatibleVersion("7.2")) {
            this.setCharacterStreamPost71(parameterIndex, x, length, "UTF-8");
        } else {
            this.setBinaryStream(parameterIndex, x, length);
        }
    }

    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkClosed();
        if (x == null) {
            this.setNull(parameterIndex, -3);
            return;
        }
        if (length < 0) {
            throw new PSQLException(GT.tr("Invalid stream length {0}.", new Integer(length)), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (this.connection.haveMinimumCompatibleVersion("7.2")) {
            this.preparedParameters.setBytea(parameterIndex, x, length);
        } else {
            LargeObjectManager lom = this.connection.getLargeObjectAPI();
            long oid = lom.createLO();
            LargeObject lob = lom.open(oid);
            OutputStream los = lob.getOutputStream();
            try {
                int c = x.read();
                for (int p = 0; c > -1 && p < length; ++p) {
                    los.write(c);
                    c = x.read();
                }
                los.close();
            }
            catch (IOException se) {
                throw new PSQLException(GT.tr("Provided InputStream failed."), PSQLState.UNEXPECTED_ERROR, (Throwable)se);
            }
            this.setLong(parameterIndex, oid);
        }
    }

    public void clearParameters() throws SQLException {
        this.preparedParameters.clear();
    }

    private PGType createInternalType(Object x, int targetType) throws PSQLException {
        if (x instanceof Byte) {
            return PGByte.castToServerType((Byte)x, targetType);
        }
        if (x instanceof Short) {
            return PGShort.castToServerType((Short)x, targetType);
        }
        if (x instanceof Integer) {
            return PGInteger.castToServerType((Integer)x, targetType);
        }
        if (x instanceof Long) {
            return PGLong.castToServerType((Long)x, targetType);
        }
        if (x instanceof Double) {
            return PGDouble.castToServerType((Double)x, targetType);
        }
        if (x instanceof Float) {
            return PGFloat.castToServerType((Float)x, targetType);
        }
        if (x instanceof BigDecimal) {
            return PGBigDecimal.castToServerType((BigDecimal)x, targetType);
        }
        if (x instanceof Number) {
            return PGNumber.castToServerType((Number)x, targetType);
        }
        if (x instanceof Boolean) {
            return PGBoolean.castToServerType((Boolean)x, targetType);
        }
        return new PGUnknown(x);
    }

    private void setPGobject(int parameterIndex, PGobject x) throws SQLException {
        String typename = x.getType();
        int oid = this.connection.getTypeInfo().getPGType(typename);
        if (oid == 0) {
            throw new PSQLException(GT.tr("Unknown type {0}.", typename), PSQLState.INVALID_PARAMETER_TYPE);
        }
        this.setString(parameterIndex, x.getValue(), oid);
    }

    public void setObject(int parameterIndex, Object in, int targetSqlType, int scale) throws SQLException {
        this.checkClosed();
        if (in == null) {
            this.setNull(parameterIndex, targetSqlType);
            return;
        }
        PGType pgType = this.createInternalType(in, targetSqlType);
        switch (targetSqlType) {
            case 4: {
                this.bindLiteral(parameterIndex, ((Object)pgType).toString(), 23);
                break;
            }
            case -6: 
            case 5: {
                this.bindLiteral(parameterIndex, ((Object)pgType).toString(), 21);
                break;
            }
            case -5: {
                this.bindLiteral(parameterIndex, ((Object)pgType).toString(), 20);
                break;
            }
            case 7: {
                this.bindLiteral(parameterIndex, ((Object)pgType).toString(), 700);
                break;
            }
            case 6: 
            case 8: {
                this.bindLiteral(parameterIndex, ((Object)pgType).toString(), 701);
                break;
            }
            case 2: 
            case 3: {
                this.bindLiteral(parameterIndex, ((Object)pgType).toString(), 1700);
                break;
            }
            case 1: {
                this.setString(parameterIndex, ((Object)pgType).toString(), 1042);
                break;
            }
            case -1: 
            case 12: {
                this.setString(parameterIndex, ((Object)pgType).toString(), 1043);
                break;
            }
            case 91: {
                if (in instanceof Date) {
                    this.setDate(parameterIndex, (Date)in);
                    break;
                }
                Date tmpd = in instanceof java.util.Date ? new Date(((java.util.Date)in).getTime()) : this.connection.getTimestampUtils().toDate(null, in.toString());
                this.setDate(parameterIndex, tmpd);
                break;
            }
            case 92: {
                if (in instanceof Time) {
                    this.setTime(parameterIndex, (Time)in);
                    break;
                }
                Time tmpt = in instanceof java.util.Date ? new Time(((java.util.Date)in).getTime()) : this.connection.getTimestampUtils().toTime(null, in.toString());
                this.setTime(parameterIndex, tmpt);
                break;
            }
            case 93: {
                if (in instanceof Timestamp) {
                    this.setTimestamp(parameterIndex, (Timestamp)in);
                    break;
                }
                Timestamp tmpts = in instanceof java.util.Date ? new Timestamp(((java.util.Date)in).getTime()) : this.connection.getTimestampUtils().toTimestamp(null, in.toString());
                this.setTimestamp(parameterIndex, tmpts);
                break;
            }
            case -7: {
                this.bindLiteral(parameterIndex, ((Object)pgType).toString(), 16);
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                this.setObject(parameterIndex, in);
                break;
            }
            case 2004: {
                if (in instanceof Blob) {
                    this.setBlob(parameterIndex, (Blob)in);
                    break;
                }
                throw new PSQLException(GT.tr("Cannot cast an instance of {0} to type {1}", new Object[]{in.getClass().getName(), "Types.BLOB"}), PSQLState.INVALID_PARAMETER_TYPE);
            }
            case 2005: {
                if (in instanceof Clob) {
                    this.setClob(parameterIndex, (Clob)in);
                    break;
                }
                throw new PSQLException(GT.tr("Cannot cast an instance of {0} to type {1}", new Object[]{in.getClass().getName(), "Types.CLOB"}), PSQLState.INVALID_PARAMETER_TYPE);
            }
            case 2003: {
                if (in instanceof Array) {
                    this.setArray(parameterIndex, (Array)in);
                    break;
                }
                throw new PSQLException(GT.tr("Cannot cast an instance of {0} to type {1}", new Object[]{in.getClass().getName(), "Types.ARRAY"}), PSQLState.INVALID_PARAMETER_TYPE);
            }
            case 1111: {
                if (in instanceof PGobject) {
                    this.setPGobject(parameterIndex, (PGobject)in);
                    break;
                }
                this.bindString(parameterIndex, in.toString(), 0);
                break;
            }
            default: {
                throw new PSQLException(GT.tr("Unsupported Types value: {0}", new Integer(targetSqlType)), PSQLState.INVALID_PARAMETER_TYPE);
            }
        }
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.setObject(parameterIndex, x, targetSqlType, 0);
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.checkClosed();
        if (x == null) {
            this.setNull(parameterIndex, 1111);
        } else if (x instanceof String) {
            this.setString(parameterIndex, (String)x);
        } else if (x instanceof BigDecimal) {
            this.setBigDecimal(parameterIndex, (BigDecimal)x);
        } else if (x instanceof Short) {
            this.setShort(parameterIndex, (Short)x);
        } else if (x instanceof Integer) {
            this.setInt(parameterIndex, (Integer)x);
        } else if (x instanceof Long) {
            this.setLong(parameterIndex, (Long)x);
        } else if (x instanceof Float) {
            this.setFloat(parameterIndex, ((Float)x).floatValue());
        } else if (x instanceof Double) {
            this.setDouble(parameterIndex, (Double)x);
        } else if (x instanceof byte[]) {
            this.setBytes(parameterIndex, (byte[])x);
        } else if (x instanceof Date) {
            this.setDate(parameterIndex, (Date)x);
        } else if (x instanceof Time) {
            this.setTime(parameterIndex, (Time)x);
        } else if (x instanceof Timestamp) {
            this.setTimestamp(parameterIndex, (Timestamp)x);
        } else if (x instanceof Boolean) {
            this.setBoolean(parameterIndex, (Boolean)x);
        } else if (x instanceof Byte) {
            this.setByte(parameterIndex, (Byte)x);
        } else if (x instanceof Blob) {
            this.setBlob(parameterIndex, (Blob)x);
        } else if (x instanceof Clob) {
            this.setClob(parameterIndex, (Clob)x);
        } else if (x instanceof Array) {
            this.setArray(parameterIndex, (Array)x);
        } else if (x instanceof PGobject) {
            this.setPGobject(parameterIndex, (PGobject)x);
        } else {
            throw new PSQLException(GT.tr("Can''t infer the SQL type to use for an instance of {0}. Use setObject() with an explicit Types value to specify the type to use.", x.getClass().getName()), PSQLState.INVALID_PARAMETER_TYPE);
        }
    }

    public void registerOutParameter(int parameterIndex, int sqlType, boolean setPreparedParameters) throws SQLException {
        this.checkClosed();
        switch (sqlType) {
            case -6: {
                sqlType = 5;
                break;
            }
            case -1: {
                sqlType = 12;
                break;
            }
            case 3: {
                sqlType = 2;
                break;
            }
            case 6: {
                sqlType = 8;
                break;
            }
            case -4: 
            case -3: {
                sqlType = -2;
                break;
            }
        }
        if (!this.isFunction) {
            throw new PSQLException(GT.tr("This statement does not declare an OUT parameter.  Use '{' ?= call ... '}' to declare one."), PSQLState.STATEMENT_NOT_ALLOWED_IN_FUNCTION_CALL);
        }
        this.checkIndex(parameterIndex, false);
        if (setPreparedParameters) {
            this.preparedParameters.registerOutParameter(parameterIndex, sqlType);
        }
        this.functionReturnType[parameterIndex - 1] = sqlType;
        this.testReturn[parameterIndex - 1] = sqlType;
        if (this.functionReturnType[parameterIndex - 1] == 1 || this.functionReturnType[parameterIndex - 1] == -1) {
            this.testReturn[parameterIndex - 1] = 12;
        } else if (this.functionReturnType[parameterIndex - 1] == 6) {
            this.testReturn[parameterIndex - 1] = 7;
        }
        this.returnTypeSet = true;
    }

    public void registerOutParameter(int parameterIndex, int sqlType, int scale, boolean setPreparedParameters) throws SQLException {
        this.registerOutParameter(parameterIndex, sqlType, setPreparedParameters);
    }

    public boolean wasNull() throws SQLException {
        if (this.lastIndex == 0) {
            throw new PSQLException(GT.tr("wasNull cannot be call before fetching a result."), PSQLState.OBJECT_NOT_IN_STATE);
        }
        return this.callResult[this.lastIndex - 1] == null;
    }

    public String getString(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 12, "String");
        return (String)this.callResult[parameterIndex - 1];
    }

    public boolean getBoolean(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, -7, "Boolean");
        if (this.callResult[parameterIndex - 1] == null) {
            return false;
        }
        return (Boolean)this.callResult[parameterIndex - 1];
    }

    public byte getByte(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 5, "Byte");
        if (this.callResult[parameterIndex - 1] == null) {
            return 0;
        }
        return ((Integer)this.callResult[parameterIndex - 1]).byteValue();
    }

    public short getShort(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 5, "Short");
        if (this.callResult[parameterIndex - 1] == null) {
            return 0;
        }
        return ((Integer)this.callResult[parameterIndex - 1]).shortValue();
    }

    public int getInt(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 4, "Int");
        if (this.callResult[parameterIndex - 1] == null) {
            return 0;
        }
        return (Integer)this.callResult[parameterIndex - 1];
    }

    public long getLong(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, -5, "Long");
        if (this.callResult[parameterIndex - 1] == null) {
            return 0L;
        }
        return (Long)this.callResult[parameterIndex - 1];
    }

    public float getFloat(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 7, "Float");
        if (this.callResult[parameterIndex - 1] == null) {
            return 0.0f;
        }
        return ((Float)this.callResult[parameterIndex - 1]).floatValue();
    }

    public double getDouble(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 8, "Double");
        if (this.callResult[parameterIndex - 1] == null) {
            return 0.0;
        }
        return (Double)this.callResult[parameterIndex - 1];
    }

    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 2, "BigDecimal");
        return (BigDecimal)this.callResult[parameterIndex - 1];
    }

    public byte[] getBytes(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, -3, -2, "Bytes");
        return (byte[])this.callResult[parameterIndex - 1];
    }

    public Date getDate(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 91, "Date");
        return (Date)this.callResult[parameterIndex - 1];
    }

    public Time getTime(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 92, "Time");
        return (Time)this.callResult[parameterIndex - 1];
    }

    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 93, "Timestamp");
        return (Timestamp)this.callResult[parameterIndex - 1];
    }

    public Object getObject(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex);
        return this.callResult[parameterIndex - 1];
    }

    public String toString() {
        if (this.preparedQuery == null) {
            return super.toString();
        }
        return this.preparedQuery.toString(this.preparedParameters);
    }

    protected void bindLiteral(int paramIndex, String s, int oid) throws SQLException {
        if (this.adjustIndex) {
            --paramIndex;
        }
        this.preparedParameters.setLiteralParameter(paramIndex, s, oid);
    }

    private void bindString(int paramIndex, String s, int oid) throws SQLException {
        if (this.adjustIndex) {
            --paramIndex;
        }
        this.preparedParameters.setStringParameter(paramIndex, s, oid);
    }

    private String modifyJdbcCall(String p_sql) throws SQLException {
        this.checkClosed();
        this.isFunction = false;
        boolean stdStrings = this.connection.getStandardConformingStrings();
        int len = p_sql.length();
        int state = 1;
        boolean inQuotes = false;
        boolean inEscape = false;
        this.outParmBeforeFunc = false;
        int startIndex = -1;
        int endIndex = -1;
        boolean syntaxError = false;
        int i = 0;
        block10: while (i < len && !syntaxError) {
            char ch = p_sql.charAt(i);
            switch (state) {
                case 1: {
                    if (ch == '{') {
                        ++i;
                        ++state;
                        continue block10;
                    }
                    if (Character.isWhitespace(ch)) {
                        ++i;
                        continue block10;
                    }
                    i = len;
                    continue block10;
                }
                case 2: {
                    if (ch == '?') {
                        this.isFunction = true;
                        this.outParmBeforeFunc = true;
                        ++i;
                        ++state;
                        continue block10;
                    }
                    if (ch == 'c') {
                        state += 3;
                        continue block10;
                    }
                    if (Character.isWhitespace(ch)) {
                        ++i;
                        continue block10;
                    }
                    syntaxError = true;
                    continue block10;
                }
                case 3: {
                    if (ch == '=') {
                        ++i;
                        ++state;
                        continue block10;
                    }
                    if (Character.isWhitespace(ch)) {
                        ++i;
                        continue block10;
                    }
                    syntaxError = true;
                    continue block10;
                }
                case 4: {
                    if (ch == 'c' || ch == 'C') {
                        ++state;
                        continue block10;
                    }
                    if (Character.isWhitespace(ch)) {
                        ++i;
                        continue block10;
                    }
                    syntaxError = true;
                    continue block10;
                }
                case 5: {
                    if ((ch == 'c' || ch == 'C') && i + 4 <= len && p_sql.substring(i, i + 4).equalsIgnoreCase("call")) {
                        this.isFunction = true;
                        i += 4;
                        ++state;
                        continue block10;
                    }
                    if (Character.isWhitespace(ch)) {
                        ++i;
                        continue block10;
                    }
                    syntaxError = true;
                    continue block10;
                }
                case 6: {
                    if (Character.isWhitespace(ch)) {
                        ++state;
                        startIndex = ++i;
                        continue block10;
                    }
                    syntaxError = true;
                    continue block10;
                }
                case 7: {
                    if (ch == '\'') {
                        inQuotes = !inQuotes;
                        ++i;
                        continue block10;
                    }
                    if (inQuotes && ch == '\\' && !stdStrings) {
                        i += 2;
                        continue block10;
                    }
                    if (!inQuotes && ch == '{') {
                        inEscape = !inEscape;
                        ++i;
                        continue block10;
                    }
                    if (!inQuotes && ch == '}') {
                        if (!inEscape) {
                            endIndex = i++;
                            ++state;
                            continue block10;
                        }
                        inEscape = false;
                        continue block10;
                    }
                    if (!inQuotes && ch == ';') {
                        syntaxError = true;
                        continue block10;
                    }
                    ++i;
                    continue block10;
                }
                case 8: {
                    if (Character.isWhitespace(ch)) {
                        ++i;
                        continue block10;
                    }
                    syntaxError = true;
                    continue block10;
                }
            }
            throw new IllegalStateException("somehow got into bad state " + state);
        }
        if (i == len && !syntaxError) {
            if (state == 1) {
                return p_sql;
            }
            if (state != 8) {
                syntaxError = true;
            }
        }
        if (syntaxError) {
            throw new PSQLException(GT.tr("Malformed function or procedure escape syntax at offset {0}.", new Integer(i)), PSQLState.STATEMENT_NOT_ALLOWED_IN_FUNCTION_CALL);
        }
        if (this.connection.haveMinimumServerVersion("8.1") && ((AbstractJdbc2Connection)this.connection).getProtocolVersion() == 3) {
            String s = p_sql.substring(startIndex, endIndex);
            StringBuffer sb = new StringBuffer(s);
            if (this.outParmBeforeFunc) {
                boolean needComma = false;
                int opening = s.indexOf(40) + 1;
                int closing = s.indexOf(41);
                for (int j = opening; j < closing; ++j) {
                    if (Character.isWhitespace(sb.charAt(j))) continue;
                    needComma = true;
                    break;
                }
                if (needComma) {
                    sb.insert(opening, "?,");
                } else {
                    sb.insert(opening, "?");
                }
            }
            return "select * from " + sb.toString() + " as result";
        }
        return "select " + p_sql.substring(startIndex, endIndex) + " as result";
    }

    protected void checkIndex(int parameterIndex, int type1, int type2, String getName) throws SQLException {
        this.checkIndex(parameterIndex);
        if (type1 != this.testReturn[parameterIndex - 1] && type2 != this.testReturn[parameterIndex - 1]) {
            throw new PSQLException(GT.tr("Parameter of type {0} was registered, but call to get{1} (sqltype={2}) was made.", new Object[]{"java.sql.Types=" + this.testReturn[parameterIndex - 1], getName, "java.sql.Types=" + type1}), PSQLState.MOST_SPECIFIC_TYPE_DOES_NOT_MATCH);
        }
    }

    protected void checkIndex(int parameterIndex, int type, String getName) throws SQLException {
        this.checkIndex(parameterIndex);
        if (type != this.testReturn[parameterIndex - 1]) {
            throw new PSQLException(GT.tr("Parameter of type {0} was registered, but call to get{1} (sqltype={2}) was made.", new Object[]{"java.sql.Types=" + this.testReturn[parameterIndex - 1], getName, "java.sql.Types=" + type}), PSQLState.MOST_SPECIFIC_TYPE_DOES_NOT_MATCH);
        }
    }

    private void checkIndex(int parameterIndex) throws SQLException {
        this.checkIndex(parameterIndex, true);
    }

    private void checkIndex(int parameterIndex, boolean fetchingData) throws SQLException {
        if (!this.isFunction) {
            throw new PSQLException(GT.tr("A CallableStatement was declared, but no call to registerOutParameter(1, <some type>) was made."), PSQLState.STATEMENT_NOT_ALLOWED_IN_FUNCTION_CALL);
        }
        if (fetchingData) {
            if (!this.returnTypeSet) {
                throw new PSQLException(GT.tr("No function outputs were registered."), PSQLState.OBJECT_NOT_IN_STATE);
            }
            if (this.callResult == null) {
                throw new PSQLException(GT.tr("Results cannot be retrieved from a CallableStatement before it is executed."), PSQLState.NO_DATA);
            }
            this.lastIndex = parameterIndex;
        }
    }

    public void setPrepareThreshold(int newThreshold) throws SQLException {
        this.checkClosed();
        if (newThreshold < 0) {
            newThreshold = 0;
        }
        this.m_prepareThreshold = newThreshold;
    }

    public int getPrepareThreshold() {
        return this.m_prepareThreshold;
    }

    public void setUseServerPrepare(boolean flag) throws SQLException {
        this.setPrepareThreshold(flag ? 1 : 0);
    }

    public boolean isUseServerPrepare() {
        return this.preparedQuery != null && this.m_prepareThreshold != 0 && this.m_useCount + 1 >= this.m_prepareThreshold;
    }

    protected void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw new PSQLException(GT.tr("This statement has been closed."), PSQLState.OBJECT_NOT_IN_STATE);
        }
    }

    public void addBatch(String p_sql) throws SQLException {
        this.checkClosed();
        if (this.preparedQuery != null) {
            throw new PSQLException(GT.tr("Can''t use query methods that take a query string on a PreparedStatement."), PSQLState.WRONG_OBJECT_TYPE);
        }
        if (this.batchStatements == null) {
            this.batchStatements = new ArrayList();
            this.batchParameters = new ArrayList();
        }
        p_sql = this.replaceProcessing(p_sql);
        this.batchStatements.add(this.connection.getQueryExecutor().createSimpleQuery(p_sql));
        this.batchParameters.add(null);
    }

    public void clearBatch() throws SQLException {
        if (this.batchStatements != null) {
            this.batchStatements.clear();
            this.batchParameters.clear();
        }
    }

    public int[] executeBatch() throws SQLException {
        this.checkClosed();
        this.clearWarnings();
        if (this.batchStatements == null || this.batchStatements.isEmpty()) {
            return new int[0];
        }
        int size = this.batchStatements.size();
        int[] updateCounts = new int[size];
        Query[] queries = this.batchStatements.toArray(new Query[this.batchStatements.size()]);
        ParameterList[] parameterLists = this.batchParameters.toArray(new ParameterList[this.batchParameters.size()]);
        this.batchStatements.clear();
        this.batchParameters.clear();
        while (this.firstUnclosedResult != null) {
            if (this.firstUnclosedResult.getResultSet() != null) {
                this.firstUnclosedResult.getResultSet().close();
            }
            this.firstUnclosedResult = this.firstUnclosedResult.getNext();
        }
        if (this.lastSimpleQuery != null) {
            this.lastSimpleQuery.close();
            this.lastSimpleQuery = null;
        }
        int flags = 4;
        if (this.preparedQuery != null) {
            this.m_useCount += queries.length;
        }
        if (this.m_prepareThreshold == 0 || this.m_useCount < this.m_prepareThreshold) {
            flags |= 1;
        }
        if (this.connection.getAutoCommit()) {
            flags |= 0x10;
        }
        this.result = null;
        ResultHandler handler = this.isFunction ? new CallableBatchResultHandler(queries, parameterLists, updateCounts) : new BatchResultHandler(queries, parameterLists, updateCounts);
        this.connection.getQueryExecutor().execute(queries, parameterLists, handler, this.maxrows, this.fetchSize, flags);
        return updateCounts;
    }

    public void cancel() throws SQLException {
        this.connection.cancelQuery();
    }

    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    public int getFetchDirection() {
        return this.fetchdirection;
    }

    public int getResultSetConcurrency() {
        return this.concurrency;
    }

    public int getResultSetType() {
        return this.resultsettype;
    }

    public void setFetchDirection(int direction) throws SQLException {
        switch (direction) {
            case 1000: 
            case 1001: 
            case 1002: {
                this.fetchdirection = direction;
                break;
            }
            default: {
                throw new PSQLException(GT.tr("Invalid fetch direction constant: {0}.", new Integer(direction)), PSQLState.INVALID_PARAMETER_VALUE);
            }
        }
    }

    public void setFetchSize(int rows) throws SQLException {
        this.checkClosed();
        if (rows < 0) {
            throw new PSQLException(GT.tr("Fetch size must be a value greater to or equal to 0."), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.fetchSize = rows;
    }

    public void addBatch() throws SQLException {
        this.checkClosed();
        if (this.batchStatements == null) {
            this.batchStatements = new ArrayList();
            this.batchParameters = new ArrayList();
        }
        this.batchStatements.add(this.preparedQuery);
        this.batchParameters.add(this.preparedParameters.copy());
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkClosed();
        ResultSet rs = this.getResultSet();
        if (rs == null) {
            int flags = 49;
            StatementResultHandler handler = new StatementResultHandler();
            this.connection.getQueryExecutor().execute(this.preparedQuery, this.preparedParameters, (ResultHandler)handler, 0, 0, flags);
            ResultWrapper wrapper = handler.getResults();
            if (wrapper != null) {
                rs = wrapper.getResultSet();
            }
        }
        if (rs != null) {
            return rs.getMetaData();
        }
        return null;
    }

    public void setArray(int i, Array x) throws SQLException {
        this.checkClosed();
        if (null == x) {
            this.setNull(i, 2003);
            return;
        }
        String typename = "_" + x.getBaseTypeName();
        int oid = this.connection.getTypeInfo().getPGType(typename);
        if (oid == 0) {
            throw new PSQLException(GT.tr("Unknown type {0}.", typename), PSQLState.INVALID_PARAMETER_TYPE);
        }
        this.setString(i, x.toString(), oid);
    }

    public void setBlob(int i, Blob x) throws SQLException {
        this.checkClosed();
        if (x == null) {
            this.setNull(i, 2004);
            return;
        }
        InputStream l_inStream = x.getBinaryStream();
        LargeObjectManager lom = this.connection.getLargeObjectAPI();
        long oid = lom.createLO();
        LargeObject lob = lom.open(oid);
        OutputStream los = lob.getOutputStream();
        byte[] buf = new byte[4096];
        try {
            int bytesRemaining = (int)x.length();
            int numRead = l_inStream.read(buf, 0, Math.min(buf.length, bytesRemaining));
            while (numRead != -1 && bytesRemaining > 0) {
                bytesRemaining -= numRead;
                if (numRead == buf.length) {
                    los.write(buf);
                } else {
                    los.write(buf, 0, numRead);
                }
                numRead = l_inStream.read(buf, 0, Math.min(buf.length, bytesRemaining));
            }
        }
        catch (IOException se) {
            throw new PSQLException(GT.tr("Unexpected error writing large object to database."), PSQLState.UNEXPECTED_ERROR, (Throwable)se);
        }
        finally {
            try {
                los.close();
                l_inStream.close();
            }
            catch (Exception e) {}
        }
        this.setLong(i, oid);
    }

    public void setCharacterStream(int i, Reader x, int length) throws SQLException {
        this.checkClosed();
        if (x == null) {
            if (this.connection.haveMinimumServerVersion("7.2")) {
                this.setNull(i, 12);
            } else {
                this.setNull(i, 2005);
            }
            return;
        }
        if (length < 0) {
            throw new PSQLException(GT.tr("Invalid stream length {0}.", new Integer(length)), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (this.connection.haveMinimumCompatibleVersion("7.2")) {
            char[] l_chars = new char[length];
            int l_charsRead = 0;
            try {
                int n;
                while ((n = x.read(l_chars, l_charsRead, length - l_charsRead)) != -1 && (l_charsRead += n) != length) {
                }
            }
            catch (IOException l_ioe) {
                throw new PSQLException(GT.tr("Provided Reader failed."), PSQLState.UNEXPECTED_ERROR, (Throwable)l_ioe);
            }
            this.setString(i, new String(l_chars, 0, l_charsRead));
        } else {
            LargeObjectManager lom = this.connection.getLargeObjectAPI();
            long oid = lom.createLO();
            LargeObject lob = lom.open(oid);
            OutputStream los = lob.getOutputStream();
            try {
                int c = x.read();
                for (int p = 0; c > -1 && p < length; ++p) {
                    los.write(c);
                    c = x.read();
                }
                los.close();
            }
            catch (IOException se) {
                throw new PSQLException(GT.tr("Unexpected error writing large object to database."), PSQLState.UNEXPECTED_ERROR, (Throwable)se);
            }
            this.setLong(i, oid);
        }
    }

    public void setClob(int i, Clob x) throws SQLException {
        this.checkClosed();
        if (x == null) {
            this.setNull(i, 2005);
            return;
        }
        InputStream l_inStream = x.getAsciiStream();
        int l_length = (int)x.length();
        LargeObjectManager lom = this.connection.getLargeObjectAPI();
        long oid = lom.createLO();
        LargeObject lob = lom.open(oid);
        OutputStream los = lob.getOutputStream();
        try {
            int c = l_inStream.read();
            for (int p = 0; c > -1 && p < l_length; ++p) {
                los.write(c);
                c = l_inStream.read();
            }
            los.close();
        }
        catch (IOException se) {
            throw new PSQLException(GT.tr("Unexpected error writing large object to database."), PSQLState.UNEXPECTED_ERROR, (Throwable)se);
        }
        this.setLong(i, oid);
    }

    public void setNull(int i, int t, String s) throws SQLException {
        this.checkClosed();
        this.setNull(i, t);
    }

    public void setRef(int i, Ref x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setRef(int,Ref)");
    }

    public void setDate(int i, Date d, Calendar cal) throws SQLException {
        this.checkClosed();
        if (d == null) {
            this.setNull(i, 91);
            return;
        }
        if (cal != null) {
            cal = (Calendar)cal.clone();
        }
        this.bindString(i, this.connection.getTimestampUtils().toString(cal, d), 0);
    }

    public void setTime(int i, Time t, Calendar cal) throws SQLException {
        this.checkClosed();
        if (t == null) {
            this.setNull(i, 92);
            return;
        }
        if (cal != null) {
            cal = (Calendar)cal.clone();
        }
        this.bindString(i, this.connection.getTimestampUtils().toString(cal, t), 0);
    }

    public void setTimestamp(int i, Timestamp t, Calendar cal) throws SQLException {
        this.checkClosed();
        if (t == null) {
            this.setNull(i, 93);
            return;
        }
        if (cal != null) {
            cal = (Calendar)cal.clone();
        }
        this.bindString(i, this.connection.getTimestampUtils().toString(cal, t), 0);
    }

    public Array getArray(int i) throws SQLException {
        this.checkClosed();
        this.checkIndex(i, 2003, "Array");
        return (Array)this.callResult[i - 1];
    }

    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 2, "BigDecimal");
        return (BigDecimal)this.callResult[parameterIndex - 1];
    }

    public Blob getBlob(int i) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getBlob(int)");
    }

    public Clob getClob(int i) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getClob(int)");
    }

    public Object getObjectImpl(int i, Map map) throws SQLException {
        if (map == null || map.isEmpty()) {
            return this.getObject(i);
        }
        throw Driver.notImplemented(this.getClass(), "getObjectImpl(int,Map)");
    }

    public Ref getRef(int i) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getRef(int)");
    }

    public Date getDate(int i, Calendar cal) throws SQLException {
        this.checkClosed();
        this.checkIndex(i, 91, "Date");
        if (this.callResult[i - 1] == null) {
            return null;
        }
        if (cal != null) {
            cal = (Calendar)cal.clone();
        }
        String value = this.callResult[i - 1].toString();
        return this.connection.getTimestampUtils().toDate(cal, value);
    }

    public Time getTime(int i, Calendar cal) throws SQLException {
        this.checkClosed();
        this.checkIndex(i, 92, "Time");
        if (this.callResult[i - 1] == null) {
            return null;
        }
        if (cal != null) {
            cal = (Calendar)cal.clone();
        }
        String value = this.callResult[i - 1].toString();
        return this.connection.getTimestampUtils().toTime(cal, value);
    }

    public Timestamp getTimestamp(int i, Calendar cal) throws SQLException {
        this.checkClosed();
        this.checkIndex(i, 93, "Timestamp");
        if (this.callResult[i - 1] == null) {
            return null;
        }
        if (cal != null) {
            cal = (Calendar)cal.clone();
        }
        String value = this.callResult[i - 1].toString();
        return this.connection.getTimestampUtils().toTimestamp(cal, value);
    }

    public void registerOutParameter(int parameterIndex, int sqlType, String typeName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "registerOutParameter(int,int,String)");
    }

    private class CallableBatchResultHandler
    implements ResultHandler {
        private BatchUpdateException batchException = null;
        private int resultIndex = 0;
        private final Query[] queries;
        private final ParameterList[] parameterLists;
        private final int[] updateCounts;

        CallableBatchResultHandler(Query[] queries, ParameterList[] parameterLists, int[] updateCounts) {
            this.queries = queries;
            this.parameterLists = parameterLists;
            this.updateCounts = updateCounts;
        }

        public void handleResultRows(Query fromQuery, Field[] fields, Vector tuples, ResultCursor cursor) {
        }

        public void handleCommandStatus(String status, int updateCount, long insertOID) {
            if (this.resultIndex >= this.updateCounts.length) {
                this.handleError(new PSQLException(GT.tr("Too many update results were returned."), PSQLState.TOO_MANY_RESULTS));
                return;
            }
            this.updateCounts[this.resultIndex++] = updateCount;
        }

        public void handleWarning(SQLWarning warning) {
            AbstractJdbc2Statement.this.addWarning(warning);
        }

        public void handleError(SQLException newError) {
            if (this.batchException == null) {
                int[] successCounts;
                if (this.resultIndex >= this.updateCounts.length) {
                    successCounts = this.updateCounts;
                } else {
                    successCounts = new int[this.resultIndex];
                    System.arraycopy(this.updateCounts, 0, successCounts, 0, this.resultIndex);
                }
                String queryString = "<unknown>";
                if (this.resultIndex < this.queries.length) {
                    queryString = this.queries[this.resultIndex].toString(this.parameterLists[this.resultIndex]);
                }
                this.batchException = new BatchUpdateException(GT.tr("Batch entry {0} {1} was aborted.  Call getNextException to see the cause.", new Object[]{new Integer(this.resultIndex), queryString}), newError.getSQLState(), successCounts);
            }
            this.batchException.setNextException(newError);
        }

        public void handleCompletion() throws SQLException {
            if (this.batchException != null) {
                throw this.batchException;
            }
        }
    }

    private class BatchResultHandler
    implements ResultHandler {
        private BatchUpdateException batchException = null;
        private int resultIndex = 0;
        private final Query[] queries;
        private final ParameterList[] parameterLists;
        private final int[] updateCounts;

        BatchResultHandler(Query[] queries, ParameterList[] parameterLists, int[] updateCounts) {
            this.queries = queries;
            this.parameterLists = parameterLists;
            this.updateCounts = updateCounts;
        }

        public void handleResultRows(Query fromQuery, Field[] fields, Vector tuples, ResultCursor cursor) {
            this.handleError(new PSQLException(GT.tr("A result was returned when none was expected."), PSQLState.TOO_MANY_RESULTS));
        }

        public void handleCommandStatus(String status, int updateCount, long insertOID) {
            if (this.resultIndex >= this.updateCounts.length) {
                this.handleError(new PSQLException(GT.tr("Too many update results were returned."), PSQLState.TOO_MANY_RESULTS));
                return;
            }
            this.updateCounts[this.resultIndex++] = updateCount;
        }

        public void handleWarning(SQLWarning warning) {
            AbstractJdbc2Statement.this.addWarning(warning);
        }

        public void handleError(SQLException newError) {
            if (this.batchException == null) {
                int[] successCounts;
                if (this.resultIndex >= this.updateCounts.length) {
                    successCounts = this.updateCounts;
                } else {
                    successCounts = new int[this.resultIndex];
                    System.arraycopy(this.updateCounts, 0, successCounts, 0, this.resultIndex);
                }
                String queryString = "<unknown>";
                if (this.resultIndex < this.queries.length) {
                    queryString = this.queries[this.resultIndex].toString(this.parameterLists[this.resultIndex]);
                }
                this.batchException = new BatchUpdateException(GT.tr("Batch entry {0} {1} was aborted.  Call getNextException to see the cause.", new Object[]{new Integer(this.resultIndex), queryString}), newError.getSQLState(), successCounts);
            }
            this.batchException.setNextException(newError);
        }

        public void handleCompletion() throws SQLException {
            if (this.batchException != null) {
                throw this.batchException;
            }
        }
    }

    public class StatementResultHandler
    implements ResultHandler {
        private SQLException error;
        private ResultWrapper results;

        ResultWrapper getResults() {
            return this.results;
        }

        private void append(ResultWrapper newResult) {
            if (this.results == null) {
                this.results = newResult;
            } else {
                this.results.append(newResult);
            }
        }

        public void handleResultRows(Query fromQuery, Field[] fields, Vector tuples, ResultCursor cursor) {
            try {
                ResultSet rs = AbstractJdbc2Statement.this.createResultSet(fromQuery, fields, tuples, cursor);
                this.append(new ResultWrapper(rs));
            }
            catch (SQLException e) {
                this.handleError(e);
            }
        }

        public void handleCommandStatus(String status, int updateCount, long insertOID) {
            this.append(new ResultWrapper(updateCount, insertOID));
        }

        public void handleWarning(SQLWarning warning) {
            AbstractJdbc2Statement.this.addWarning(warning);
        }

        public void handleError(SQLException newError) {
            if (this.error == null) {
                this.error = newError;
            } else {
                this.error.setNextException(newError);
            }
        }

        public void handleCompletion() throws SQLException {
            if (this.error != null) {
                throw this.error;
            }
        }
    }
}

