/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core.v2;

import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.sql.SQLException;
import java.util.Arrays;
import org.postgresql.core.ParameterList;
import org.postgresql.core.Utils;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;
import org.postgresql.util.StreamWrapper;

class SimpleParameterList
implements ParameterList {
    private final Object[] paramValues;
    private final boolean useEStringSyntax;
    private static final String NULL_OBJECT = new String("NULL");

    SimpleParameterList(int paramCount, boolean useEStringSyntax) {
        this.paramValues = new Object[paramCount];
        this.useEStringSyntax = useEStringSyntax;
    }

    @Override
    public void registerOutParameter(int index, int sqlType) {
    }

    public void registerOutParameter(int index, int sqlType, int precision) {
    }

    @Override
    public int getInParameterCount() {
        return this.paramValues.length;
    }

    @Override
    public int getParameterCount() {
        return this.paramValues.length;
    }

    @Override
    public int getOutParameterCount() {
        return 1;
    }

    @Override
    public int[] getTypeOIDs() {
        return null;
    }

    @Override
    public void setIntParameter(int index, int value) throws SQLException {
        this.setLiteralParameter(index, "" + value, 23);
    }

    @Override
    public void setLiteralParameter(int index, String value, int oid) throws SQLException {
        if (index < 1 || index > this.paramValues.length) {
            throw new PSQLException(GT.tr("The column index is out of range: {0}, number of columns: {1}.", new Object[]{new Integer(index), new Integer(this.paramValues.length)}), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.paramValues[index - 1] = value;
    }

    @Override
    public void setStringParameter(int index, String value, int oid) throws SQLException {
        StringBuffer sbuf = new StringBuffer(2 + value.length() * 11 / 10);
        if (this.useEStringSyntax) {
            sbuf.append(' ').append('E');
        }
        sbuf.append('\'');
        Utils.appendEscapedLiteral(sbuf, value, false);
        sbuf.append('\'');
        this.setLiteralParameter(index, sbuf.toString(), oid);
    }

    @Override
    public void setBytea(int index, byte[] data, int offset, int length) throws SQLException {
        if (index < 1 || index > this.paramValues.length) {
            throw new PSQLException(GT.tr("The column index is out of range: {0}, number of columns: {1}.", new Object[]{new Integer(index), new Integer(this.paramValues.length)}), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.paramValues[index - 1] = new StreamWrapper(data, offset, length);
    }

    @Override
    public void setBytea(int index, InputStream stream, int length) throws SQLException {
        if (index < 1 || index > this.paramValues.length) {
            throw new PSQLException(GT.tr("The column index is out of range: {0}, number of columns: {1}.", new Object[]{new Integer(index), new Integer(this.paramValues.length)}), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.paramValues[index - 1] = new StreamWrapper(stream, length);
    }

    @Override
    public void setNull(int index, int oid) throws SQLException {
        if (index < 1 || index > this.paramValues.length) {
            throw new PSQLException(GT.tr("The column index is out of range: {0}, number of columns: {1}.", new Object[]{new Integer(index), new Integer(this.paramValues.length)}), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.paramValues[index - 1] = NULL_OBJECT;
    }

    @Override
    public String toString(int index) {
        if (index < 1 || index > this.paramValues.length) {
            throw new IllegalArgumentException("Parameter index " + index + " out of range");
        }
        if (this.paramValues[index - 1] == null) {
            return "?";
        }
        if (this.paramValues[index - 1] == NULL_OBJECT) {
            return "NULL";
        }
        return this.paramValues[index - 1].toString();
    }

    private void streamBytea(StreamWrapper param, Writer encodingWriter) throws IOException {
        InputStream stream = param.getStream();
        char[] buffer = new char[]{'\\', '\\', '\u0000', '\u0000', '\u0000'};
        if (this.useEStringSyntax) {
            encodingWriter.write(32);
            encodingWriter.write(69);
        }
        encodingWriter.write(39);
        for (int remaining = param.getLength(); remaining > 0; --remaining) {
            int nextByte = stream.read();
            buffer[2] = (char)(48 + (nextByte >> 6 & 3));
            buffer[3] = (char)(48 + (nextByte >> 3 & 7));
            buffer[4] = (char)(48 + (nextByte & 7));
            encodingWriter.write(buffer, 0, 5);
        }
        encodingWriter.write(39);
    }

    void writeV2Value(int index, Writer encodingWriter) throws IOException {
        if (this.paramValues[index - 1] instanceof StreamWrapper) {
            this.streamBytea((StreamWrapper)this.paramValues[index - 1], encodingWriter);
        } else {
            encodingWriter.write((String)this.paramValues[index - 1]);
        }
    }

    void checkAllParametersSet() throws SQLException {
        for (int i = 0; i < this.paramValues.length; ++i) {
            if (this.paramValues[i] != null) continue;
            throw new PSQLException(GT.tr("No value specified for parameter {0}.", new Integer(i + 1)), PSQLState.INVALID_PARAMETER_VALUE);
        }
    }

    @Override
    public ParameterList copy() {
        SimpleParameterList newCopy = new SimpleParameterList(this.paramValues.length, this.useEStringSyntax);
        System.arraycopy(this.paramValues, 0, newCopy.paramValues, 0, this.paramValues.length);
        return newCopy;
    }

    @Override
    public void clear() {
        Arrays.fill(this.paramValues, null);
    }
}

