-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
--
-- $Id: rtpostgis_upgrade.sql.in.c 8448 2011-12-16 22:07:26Z dustymugs $
--
-- PostGIS Raster - Raster Type for PostGIS
-- http://trac.osgeo.org/postgis/wiki/WKTRaster
--
-- Copyright (c) 2011 Regina Obe <lr@pcorp.us>
-- Copyright (C) 2011 Regents of the University of California
--   <bkpark@ucdavis.edu>
--
-- This program is free software; you can redistribute it and/or
-- modify it under the terms of the GNU General Public License
-- as published by the Free Software Foundation; either version 2
-- of the License, or (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software Foundation,
-- Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
--
-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
--
-- WARNING: Any change in this file must be evaluated for compatibility.
--
-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
--
-- This section is take add / drop things like CASTS, TYPES etc. that have changed
-- Since these are normally excluded from sed upgrade generator
-- they must be explicitly added
-- So that they can immediately be recreated. 
-- It is not run thru the sed processor to prevent it from being stripped
-- Note: We put these in separate file from drop since the extension module has
-- to add additional logic to drop them from the extension as well
--
-- TODO: tag each item with the version in which it was changed
--














-- drop st_bytea
DROP CAST IF EXISTS (raster AS bytea);
DROP FUNCTION IF EXISTS st_bytea(raster);

CREATE OR REPLACE FUNCTION bytea(raster)
    RETURNS bytea
    AS '$libdir/rtpostgis-2.1', 'RASTER_to_bytea'
    LANGUAGE 'c' IMMUTABLE STRICT;
CREATE CAST (raster AS bytea)
    WITH FUNCTION bytea(raster) AS ASSIGNMENT;

-- drop box2d
DROP CAST IF EXISTS (raster AS box2d);
DROP FUNCTION IF EXISTS box2d(raster);

-- If we are running 9.0+ we can use DO plpgsql to check
-- and only create if not exists so no need to force a drop
-- that way if people are using it, we will not mess them up
DO language 'plpgsql' $$
BEGIN
	-- create raster box3d cast if it does not exist
	IF NOT EXISTS(SELECT  cs.typname AS source
		FROM pg_cast AS ca 
        	INNER JOIN pg_type AS cs ON ca.castsource = cs.oid
        	INNER JOIN pg_type AS ct ON ca.casttarget = ct.oid
        	WHERE cs.typname = 'raster' AND ct.typname = 'box3d') THEN
		CREATE OR REPLACE FUNCTION box3d(raster)
		RETURNS box3d
		AS 'SELECT box3d(st_convexhull($1))'
		LANGUAGE 'sql' IMMUTABLE STRICT;
		CREATE CAST (raster AS box3d)
			WITH FUNCTION box3d(raster) AS ASSIGNMENT;
    END IF;
    
    -- create addbandarg type if it does not exist
	IF NOT EXISTS(SELECT typname
		FROM pg_type 
        	WHERE typname = 'addbandarg') THEN
		CREATE TYPE addbandarg AS (
			index int,
			pixeltype text,
			initialvalue float8,
			nodataval float8
		);
    END IF;
    
    -- create agg_samealignment type if it does not exist
	IF NOT EXISTS(SELECT typname 
		FROM pg_type 
        	WHERE typname = 'agg_samealignment') THEN
			CREATE TYPE agg_samealignment AS (
				refraster raster,
				aligned boolean
			);
    END IF;
    
    -- create unionarg type if it does not exist
	IF NOT EXISTS(SELECT typname
		FROM pg_type 
        	WHERE typname = 'unionarg') THEN
			CREATE TYPE unionarg AS
			   (nband integer,
				uniontype text);
    END IF;

    -- create rastbandarg type if it does not exist
	IF NOT EXISTS(SELECT typname
		FROM pg_type 
        	WHERE typname = 'rastbandarg') THEN
			CREATE TYPE rastbandarg AS (
				rast raster,
				nband integer
			);
    END IF;

END$$;	

-- make geometry cast ASSIGNMENT
DROP CAST IF EXISTS (raster AS geometry);
CREATE CAST (raster AS geometry)
	WITH FUNCTION st_convexhull(raster) AS ASSIGNMENT;

-- add missing OPERATORs
DO LANGUAGE 'plpgsql' $$
BEGIN
	IF NOT EXISTS (
			SELECT
				proname
			FROM pg_proc f
			JOIN pg_type r
				ON r.typname = 'raster'
					AND (f.proargtypes::oid[])[0] = r.oid
			JOIN pg_type g
				ON g.typname = 'geometry'
					AND (f.proargtypes::oid[])[1] = g.oid
			WHERE proname = 'raster_contained_by_geometry'
		) THEN
		CREATE OR REPLACE FUNCTION raster_contained_by_geometry(raster, geometry)
			RETURNS bool
	    AS 'select $1::geometry @ $2'
	    LANGUAGE 'sql' IMMUTABLE STRICT;
		CREATE OPERATOR @ (
			LEFTARG = raster, RIGHTARG = geometry, PROCEDURE = raster_contained_by_geometry,
	    COMMUTATOR = '~',
		  RESTRICT = contsel, JOIN = contjoinsel
		);
	END IF;

	IF NOT EXISTS (
			SELECT
				proname
			FROM pg_proc f
			JOIN pg_type r
				ON r.typname = 'raster'
					AND (f.proargtypes::oid[])[1] = r.oid
			JOIN pg_type g
				ON g.typname = 'geometry'
					AND (f.proargtypes::oid[])[0] = g.oid
			WHERE proname = 'geometry_contained_by_raster'
		) THEN
		CREATE OR REPLACE FUNCTION geometry_contained_by_raster(geometry, raster)
	    RETURNS bool
		  AS 'select $1 @ $2::geometry'
	    LANGUAGE 'sql' IMMUTABLE STRICT;
		CREATE OPERATOR @ (
	    LEFTARG = geometry, RIGHTARG = raster, PROCEDURE = geometry_contained_by_raster,
		  COMMUTATOR = '~',
			RESTRICT = contsel, JOIN = contjoinsel
    );
	END IF;
END;
$$;

-- raster_columns and raster_overviews tables are deprecated
DO LANGUAGE 'plpgsql' $$
	DECLARE
		cnt int;
	BEGIN
		SELECT count(*) INTO cnt
		FROM pg_class c
		JOIN pg_namespace n
			ON c.relnamespace = n.oid
		WHERE c.relname = 'raster_columns'
			AND c.relkind = 'r'::char
			AND NOT pg_is_other_temp_schema(c.relnamespace);

		IF cnt > 0 THEN
			EXECUTE 'ALTER TABLE raster_columns RENAME TO deprecated_raster_columns';
		END IF;

		SELECT count(*) INTO cnt
		FROM pg_class c
		JOIN pg_namespace n
			ON c.relnamespace = n.oid
		WHERE c.relname = 'raster_overviews'
			AND c.relkind = 'r'::char
			AND NOT pg_is_other_temp_schema(c.relnamespace);

		IF cnt > 0 THEN
			EXECUTE 'ALTER TABLE raster_overviews RENAME TO deprecated_raster_overviews';
		END IF;

	END;
	$$;

-- inserted new column into view
DROP VIEW IF EXISTS raster_columns;

-- Changed return type
DROP FUNCTION IF EXISTS _st_summarystats(raster,int, boolean, double precision);
DROP FUNCTION IF EXISTS st_summarystats(raster,int, boolean);
DROP FUNCTION IF EXISTS st_summarystats(raster, boolean);
DROP FUNCTION IF EXISTS st_approxsummarystats(raster,int, boolean, double precision);
DROP FUNCTION IF EXISTS st_approxsummarystats(raster,int, double precision);
DROP FUNCTION IF EXISTS st_approxsummarystats(raster, boolean, double precision);
DROP FUNCTION IF EXISTS st_approxsummarystats(raster, double precision);
DROP FUNCTION IF EXISTS _st_summarystats(text, text,integer, boolean, double precision);
DROP FUNCTION IF EXISTS st_summarystats(text, text,integer, boolean);
DROP FUNCTION IF EXISTS st_summarystats(text, text, boolean);
DROP FUNCTION IF EXISTS st_approxsummarystats(text, text,integer, boolean, double precision);
DROP FUNCTION IF EXISTS st_approxsummarystats(text, text,integer, double precision);
DROP FUNCTION IF EXISTS st_approxsummarystats(text, text, boolean);
DROP FUNCTION IF EXISTS st_approxsummarystats(text, text, double precision);
DROP FUNCTION IF EXISTS _st_histogram( raster, int, boolean, double precision, int, double precision[], boolean, double precision, double precision);
DROP FUNCTION IF EXISTS st_histogram(raster, int, boolean, int, double precision[], boolean);
DROP FUNCTION IF EXISTS st_histogram(raster, int, boolean, int, boolean);
DROP FUNCTION IF EXISTS st_histogram(raster, int, int, double precision[], boolean);
DROP FUNCTION IF EXISTS st_histogram(raster, int, int, boolean);
DROP FUNCTION IF EXISTS st_approxhistogram( raster, int, boolean, double precision, int, double precision[], boolean);
DROP FUNCTION IF EXISTS st_approxhistogram(raster, int, boolean, double precision, int, boolean);
DROP FUNCTION IF EXISTS st_approxhistogram(raster, int, double precision);
DROP FUNCTION IF EXISTS st_approxhistogram(raster, double precision);
DROP FUNCTION IF EXISTS st_approxhistogram(raster, int, double precision, int, double precision[], boolean);
DROP FUNCTION IF EXISTS st_approxhistogram(raster, int, double precision, int, boolean);
DROP FUNCTION IF EXISTS st_histogram(text, text, int, boolean, int, double precision[], boolean);
DROP FUNCTION IF EXISTS st_histogram(text, text, int, boolean, int, boolean);
DROP FUNCTION IF EXISTS st_histogram(text, text, int, int, double precision[], boolean);
DROP FUNCTION IF EXISTS st_histogram(text, text, int, int, boolean);
DROP FUNCTION IF EXISTS st_approxhistogram( text, text, int, boolean, double precision, int, double precision[], boolean);
DROP FUNCTION IF EXISTS st_approxhistogram(text, text, int, boolean, double precision, int, boolean);
DROP FUNCTION IF EXISTS st_approxhistogram(text, text, int, double precision);
DROP FUNCTION IF EXISTS st_approxhistogram(text, text, double precision);
DROP FUNCTION IF EXISTS st_approxhistogram(text, text, int, double precision, int, double precision[], boolean);
DROP FUNCTION IF EXISTS st_approxhistogram(text, text, int, double precision, int, boolean);
DROP FUNCTION IF EXISTS _st_histogram( text, text, int, boolean, double precision, int, double precision[], boolean);
DROP FUNCTION IF EXISTS st_quantile(raster, int, boolean, double precision[]);
DROP FUNCTION IF EXISTS st_quantile(raster, int, double precision[]);
DROP FUNCTION IF EXISTS st_quantile(raster, double precision[]);
DROP FUNCTION IF EXISTS st_approxquantile(raster, int, boolean, double precision, double precision[]);
DROP FUNCTION IF EXISTS st_approxquantile(raster, int, double precision, double precision[]);
DROP FUNCTION IF EXISTS st_approxquantile(raster, double precision, double precision[]);
DROP FUNCTION IF EXISTS st_approxquantile(raster, double precision[]);
DROP FUNCTION IF EXISTS st_quantile(text, text, int, boolean, double precision[]);
DROP FUNCTION IF EXISTS st_quantile(text, text, int, double precision[]);
DROP FUNCTION IF EXISTS st_quantile(text, text, double precision[]);
DROP FUNCTION IF EXISTS st_approxquantile(text, text, int, boolean, double precision, double precision[]);
DROP FUNCTION IF EXISTS st_approxquantile(text, text, int, double precision, double precision[]);
DROP FUNCTION IF EXISTS st_approxquantile(text, text, double precision, double precision[]);
DROP FUNCTION IF EXISTS st_approxquantile(text, text, double precision[]);
DROP FUNCTION IF EXISTS _st_quantile(raster, int, boolean, double precision, double precision[]);
DROP FUNCTION IF EXISTS _st_quantile(text, text, int, boolean, double precision, double precision[]);
DROP FUNCTION IF EXISTS st_valuecount(text, text, integer, double precision, double precision);
DROP FUNCTION IF EXISTS st_valuecount(text, text, integer, boolean, double precision[], double precision);
DROP FUNCTION IF EXISTS st_valuecount(text, text, double precision[], double precision);
DROP FUNCTION IF EXISTS st_valuecount(text, text, integer, double precision[], double precision);
DROP FUNCTION IF EXISTS st_valuecount(text, text, integer, boolean, double precision, double precision);
DROP FUNCTION IF EXISTS st_valuecount(text, text, double precision, double precision);
DROP FUNCTION IF EXISTS st_valuecount(raster, integer, boolean, double precision[], double precision);
DROP FUNCTION IF EXISTS st_valuecount(raster, integer, double precision[], double precision);
DROP FUNCTION IF EXISTS st_valuecount(raster, double precision[], double precision);
DROP FUNCTION IF EXISTS _st_valuecount(text, text, integer, boolean, double precision[], double precision);
DROP FUNCTION IF EXISTS _st_valuecount(raster, integer, boolean, double precision[], double precision);

-- Incompatible signature change
DROP FUNCTION IF EXISTS st_value(raster, integer, integer, integer);
DROP FUNCTION IF EXISTS st_value(raster, integer, integer);
DROP FUNCTION IF EXISTS st_value(raster, integer, geometry);
DROP FUNCTION IF EXISTS st_value(raster, geometry);
DROP FUNCTION IF EXISTS st_value(raster, integer, integer, integer, boolean);
DROP FUNCTION IF EXISTS st_value(raster, integer, integer, boolean);
DROP FUNCTION IF EXISTS st_value(raster, integer, geometry, boolean);
DROP FUNCTION IF EXISTS st_value(raster, geometry, boolean);
DROP FUNCTION IF EXISTS st_value(raster, integer, geometry, double precision);
DROP FUNCTION IF EXISTS st_value(raster, geometry, double precision);
DROP FUNCTION IF EXISTS st_setvalue(raster, integer, geometry, double precision);
DROP FUNCTION IF EXISTS st_setvalue(raster, geometry, double precision);
DROP FUNCTION IF EXISTS st_intersection(raster, int, geometry, text, regprocedure);
DROP FUNCTION IF EXISTS st_intersection(raster, int, geometry, regprocedure);
DROP FUNCTION IF EXISTS st_intersection(raster, geometry, text, regprocedure);
DROP FUNCTION IF EXISTS st_intersection(raster, geometry, regprocedure);
DROP FUNCTION IF EXISTS st_clip(raster, integer, geometry, boolean);
DROP FUNCTION IF EXISTS st_clip(raster, geometry, float8, boolean);
DROP FUNCTION IF EXISTS st_clip(raster, geometry, boolean);
DROP FUNCTION IF EXISTS st_clip(raster, int, geometry, float8, boolean);
DROP FUNCTION IF EXISTS st_clip(raster, geometry, float8[], boolean);
DROP FUNCTION IF EXISTS st_clip(raster, integer, geometry, float8[], boolean);
DROP FUNCTION IF EXISTS st_addband(raster, text, float8, float8);
DROP FUNCTION IF EXISTS st_addband(raster, int, text, float8, float8);
DROP FUNCTION IF EXISTS st_addband(raster, raster, int, int);
DROP FUNCTION IF EXISTS st_bandisnodata(raster, integer, boolean);
DROP FUNCTION IF EXISTS st_bandpath(raster, integer);
DROP FUNCTION IF EXISTS st_bandpixeltype(raster, integer);
DROP FUNCTION IF EXISTS st_georeference(raster, text);
DROP FUNCTION IF EXISTS st_bandmetadata(raster, VARIADIC int[]);
DROP FUNCTION IF EXISTS st_makeemptyraster(int, int, float8, float8, float8, float8, float8, float8, int4);
DROP FUNCTION IF EXISTS st_polygon(raster, integer);
DROP FUNCTION IF EXISTS st_addband(raster, raster[], integer);
DROP FUNCTION IF EXISTS st_slope(raster, integer, text, text, double precision, boolean);
DROP FUNCTION IF EXISTS st_slope(raster, integer, text, boolean);
DROP FUNCTION IF EXISTS st_slope(raster, integer, text);
DROP FUNCTION IF EXISTS st_aspect(raster, integer, text, text, boolean);
DROP FUNCTION IF EXISTS st_aspect(raster, integer, text, boolean);
DROP FUNCTION IF EXISTS st_aspect(raster, integer, text);
DROP FUNCTION IF EXISTS st_hillshade(raster, integer, text, double precision, double precision, double precision, double precision, boolean);
DROP FUNCTION IF EXISTS st_hillshade(raster, integer, text, float, float, float, float, boolean);
DROP FUNCTION IF EXISTS st_hillshade(raster, integer, text, float, float, float, float);
DROP FUNCTION IF EXISTS st_resample(raster, integer, double precision, double precision, double precision, double precision, double precision, double precision, text, double precision);
DROP FUNCTION IF EXISTS st_resample(raster, integer, integer, integer, double precision, double precision, double precision, double precision, text, double precision);
DROP FUNCTION IF EXISTS _st_tile(raster, integer, integer, int[]);
DROP FUNCTION IF EXISTS st_tile(raster, integer[], integer, integer);
DROP FUNCTION IF EXISTS st_tile(raster, integer, integer, integer);
DROP FUNCTION IF EXISTS st_tile(raster, integer, integer);
DROP FUNCTION IF EXISTS ST_PixelAsPolygons(raster); 
DROP FUNCTION IF EXISTS ST_PixelAsPolygons(raster,integer);
DROP FUNCTION IF EXISTS st_asbinary(raster);
DROP FUNCTION IF EXISTS _st_aspect4ma(float8[], text, text[]);
DROP FUNCTION IF EXISTS _st_hillshade4ma(float8[], text, text[]);
DROP FUNCTION IF EXISTS _st_slope4ma(float8[], text, text[]);
DROP FUNCTION IF EXISTS ST_MapAlgebraExpr(raster, integer, text, text, text);
DROP FUNCTION IF EXISTS ST_MapAlgebraExpr(raster, text, text, text);
DROP FUNCTION IF EXISTS ST_MapalgebraFct(raster, regprocedure);
DROP FUNCTION IF EXISTS ST_MapAlgebraFct(raster, text, regprocedure, VARIADIC text[]); 
DROP FUNCTION IF EXISTS ST_MapAlgebraFct(raster, text, regprocedure); 
DROP FUNCTION IF EXISTS ST_MapAlgebraFct(raster, regprocedure, VARIADIC text[]);
DROP FUNCTION IF EXISTS ST_MapAlgebraFct(raster, integer, regprocedure, variadic text[]);
DROP FUNCTION IF EXISTS ST_MapAlgebraFct(raster, integer, text, regprocedure, VARIADIC text[]); 
DROP FUNCTION IF EXISTS ST_MapAlgebraFct(raster, integer, text, regprocedure); 
DROP FUNCTION IF EXISTS ST_MapAlgebraFct(raster, integer, regprocedure, variadic text[]);
DROP FUNCTION IF EXISTS ST_MapalgebraFct(raster, integer, regprocedure);
DROP FUNCTION IF EXISTS ST_MapAlgebraFct(raster, raster, regprocedure, text, text, VARIADIC text[]);
DROP FUNCTION IF EXISTS ST_MapAlgebraFct(raster, integer, raster, integer, regprocedure, text, text, VARIADIC text[]);
DROP FUNCTION IF EXISTS ST_MapAlgebraFctNgb(raster, integer, text, integer, integer, regprocedure, text,  VARIADIC text[]);
DROP FUNCTION IF EXISTS ST_BandMetaData(raster, integer); --out param 
DROP FUNCTION IF EXISTS ST_BandNoDataValue(raster, integer); -- out param 
DROP FUNCTION IF EXISTS ST_HasNoBand(raster); -- default param
DROP FUNCTION IF EXISTS ST_Resample(raster, raster, text, double precision);
DROP FUNCTION IF EXISTS ST_Intersects(raster,boolean,geometry);
DROP FUNCTION IF EXISTS ST_Intersects(geometry,raster,boolean);
DROP FUNCTION IF EXISTS ST_Intersects(raster,geometry);
DROP FUNCTION IF EXISTS ST_Intersects(geometry,raster);
DROP FUNCTION IF EXISTS ST_Intersects(raster, integer, boolean  , geometry);
DROP FUNCTION IF EXISTS ST_Intersects(geometry , raster, integer , boolean);
DROP FUNCTION IF EXISTS ST_Intersection(raster,raster, integer, integer);
DROP FUNCTION IF EXISTS ST_Intersection(geometry,raster);
DROP FUNCTION IF EXISTS ST_Intersection(raster, geometry);
DROP FUNCTION IF EXISTS ST_Intersection(raster, integer, geometry);
DROP FUNCTION IF EXISTS _st_intersects(raster, integer, raster, integer);
DROP FUNCTION IF EXISTS st_intersects(raster, integer, raster, integer);
DROP FUNCTION IF EXISTS st_intersects(raster, raster);
DROP FUNCTION IF EXISTS st_intersection(raster, integer, geometry);
DROP FUNCTION IF EXISTS st_intersection(raster, geometry);

--added extra parameter 
DROP FUNCTION IF EXISTS ST_AsRaster(geometry , integer , integer , double precision , double precision , text , double precision , double precision , double precision , double precision );
DROP FUNCTION IF EXISTS ST_AsRaster(geometry , integer , integer , text[] , double precision[] , double precision[] , double precision , double precision , double precision , double precision );
DROP FUNCTION IF EXISTS ST_AsRaster(geometry , integer , integer , text , double precision , double precision , double precision , double precision , double precision , double precision );
DROP FUNCTION IF EXISTS ST_AsRaster(geometry , integer , integer , double precision , double precision , text[] , double precision[] , double precision[] , double precision , double precision );
DROP FUNCTION IF EXISTS ST_AsRaster(geometry , integer , integer , double precision , double precision , text[] , double precision[] , double precision[] , double precision , double precision );
DROP FUNCTION IF EXISTS ST_AsRaster(geometry , double precision , double precision , text , double precision , double precision , double precision , double precision , double precision , double precision );
DROP FUNCTION IF EXISTS ST_AsRaster(geometry , raster , text , double precision , double precision );
DROP FUNCTION IF EXISTS _ST_AsRaster(geometry,double precision , double precision, integer , integer,text[] , double precision[] ,double precision[] ,  double precision,  double precision, double precision,double precision, double precision, double precision,touched boolean);

-- arg names changed
DROP FUNCTION IF EXISTS _ST_Resample(raster, text, double precision, integer, double precision, double precision, double precision, double precision, double precision, double precision);
DROP FUNCTION IF EXISTS ST_SetGeoReference(raster, text, text);
DROP FUNCTION IF EXISTS st_setbandisnodata(raster, integer);
DROP FUNCTION IF EXISTS st_setbandnodatavalue(raster, integer, double precision, boolean);
DROP FUNCTION IF EXISTS st_dumpaspolygons(raster, integer);
-- function parameter names changed
DROP FUNCTION IF EXISTS st_nearestvalue(raster, integer, integer, integer, boolean);
DROP FUNCTION IF EXISTS st_nearestvalue(raster, integer, integer, boolean);
DROP FUNCTION IF EXISTS st_neighborhood(raster, integer, integer, integer, integer, boolean);
DROP FUNCTION IF EXISTS st_neighborhood(raster, integer, integer, integer, boolean);
DROP FUNCTION IF EXISTS st_neighborhood(raster, integer, geometry, integer, boolean);
DROP FUNCTION IF EXISTS st_neighborhood(raster, geometry, integer, boolean);

-- function no longer exist or refactored (check which is which!)
DROP FUNCTION IF EXISTS st_intersects(raster, integer, geometry);
DROP FUNCTION IF EXISTS st_intersects(raster, geometry, integer);
DROP FUNCTION IF EXISTS st_intersects(geometry, raster, integer);
DROP FUNCTION IF EXISTS _st_intersects(raster, geometry, integer);
DROP FUNCTION IF EXISTS _st_intersects(geometry, raster, integer);

