#!/usr/bin/env python

""" 
   Copyright (C) 2001 PimenTech SARL (http://www.pimentech.net)

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
"""

from log import *
from xmldb import *
import getopt
import sys

def main():
	"""
	xml2db output db schema

	usage: xml2db -f <xml file> -u <dbuser> [ -p <dbpassword> ] -d <target db> -l <log file> [-h] 
	-h : this help
	-f : xml file
	-u : db user
	-p : db password
	-d : dbname@dbhost
	-l : log file
	-i : id name
	
	"""
	
	try:
		opts, args = getopt.getopt(sys.argv[1:], 'f:hu:p:d:tl:i:')
	except getopt.error, msg:
		usage(msg)

	targetDb = ''
	debug = PYTHONDEBUG
	xmlFilename = ''
	logFilename = 'xml2db.log'
	DBNAME, DBHOST, DBPORT, DBUSER, DBPWD = '', '', 5432, '', ''
	uidName= None
	
	for o, a in opts:
		if o == '-f': xmlFilename = a
		if o == '-h': usage(main.__doc__)
		if o == '-t': debug = 1
		if o == '-u': DBUSER = a
		if o == '-p': DBPWD = a
		if o == '-d': targetDb = a
		if o == '-l': logFilename = a
		if o == '-i': uidName = a

	if not xmlFilename: usage(main.__doc__,'error : missing xml file')
	if not targetDb: usage(main.__doc__,'error : missing target db')
	if not DBUSER: usage(main.__doc__,'error : missing db user')
	
	l = split(targetDb, '@')
	if len(l) == 1:
		DBNAME = l[0]
		DBHOST = 'localhost'
	elif len(l) == 2:
		DBNAME, DBHOST = l
		
	x = XmlDb(DBNAME, DBHOST, DBPORT, DBUSER, DBPWD, LOG(logFilename), 'XmlDb', debug, uidName);
	x.read(xmlFilename);
	
if __name__ == '__main__':
	main()
