#! /bin/bash

case $DEBUG in
  1) set -x
     ;;
  *)
     ;;
esac

error() { # juste pour usage
		echo $1 1>&2
}

usage() {
		error "usage : drop-user.sh [-h] -H <host> -u <user to drop> -U <user> -P <password> -l <log file>"
		error "example : drop-user.sh -H bonnie -u pimentech -U postgres  -P pass -l drop-user.log"
}

while true
do
  case $1 in
	-H) host="$2"
		shift 2
		;;
    -U)	user="$2"
        shift 2
        ;;
    -u)	usertodel="$2"
        shift 2
        ;;
    -P) password="$2"
        shift 2
        ;;
	-l) logfile="$2"
		shift 2
		;;
    -h) usage
		exit 0
		;;
     *)
		break
		;;
  esac
done

if [ -z "$host" -o -z "$user" -o -z "$logfile" ] 
then
		usage
		exit 1
fi

date=`date '+%d-%m-%Y'`
error() {
		echo "ERROR:drop-user.sh:$date: $1" 1>&2
		echo "ERROR:drop-user.sh:$date: $1" >> $logfile
}

expect -- <<EOC

#	exp_internal -f $logfile 0

 	log_user 0

	spawn -noecho dropuser -h $host $usertodel -U $user -W

	expect {
		"Password: " { send -- "$password\r" }
		timeout { send_error -- "timeout detected on login\n" }
	}

	expect { 
		"\nDROP USER" { send_user -- "DROP USER\n" }
		-re "\n(ERROR.*)\r" { send_error -- "\$expect_out(1,string)\n" }
		-re "\n(psql: Password authentication failed for user.*)\r" { send_error -- "\$expect_out(1,string)\n" }
	}

    exit [ lindex [ wait ] 3 ]

EOC

err=$?

if [ $err -ne 0 ]
then
	error "cannot drop $usertodel@$host"
fi

exit $err
