#! /bin/bash

case $DEBUG in
  1) set -x
     ;;
  *)
     ;;
esac

error() { # juste pour usage
    echo $1 1>&2
}

usage() {
    error "usage : dump-db.sh [-h] [-c] -H <host> -d <dbname> -u <user> -p <password> -l <log file>"
	error "    -c : compact dump"
    error "example : dump-db.sh -H bonnie -d barbie -u pimentech -p \"\" -l dump-db.log"
}

PGOPTIONS="-d -i -D"

while true
do
    case $1 in
	-H) host="$2"
	    shift 2
	;;
	-u)	user="$2"
	    shift 2
        ;;
	-p) password="$2"
	    shift 2
        ;;
	-d) dbname="$2"
	    shift 2
	;;
	-c) PGOPTIONS="-i"
		shift 1
	;;
	-l) logfile="$2"
	    shift 2
	;;
	-h) usage
	    exit 0
	;;
	*)
	    break
	;;
  esac
done

if [ -z "$dbname" -o -z "$host" -o -z "$user" -o -z "$logfile" ] 
then
    usage
    exit 1
fi

date=`date '+%d-%m-%Y'`
error() {
    echo "ERROR:dump-db.sh:$date: $1" 1>&2
    echo "ERROR:dump-db.sh:$date: $1" >> $logfile
}

PGVERSION=`pg_dump --version  | grep pg_dump | awk '{ print $3 }' | awk -F'.' '{ print $1$2 }'`
if [ $PGVERSION -ge 72 ]
then
	PGOPTIONS="-U $user -W $PGOPTIONS"
else
	PGOPTIONS="-u $PGOPTIONS"
fi

expect -- <<EOC

#	exp_internal -f $logfile 0

 	log_user 0

	spawn -noecho pg_dump $PGOPTIONS -h $host $dbname

	if { $PGVERSION < 72 } {
		expect {
			"Username: " { send -- "$user\r" }
			timeout { send_error -- "timeout detected on login\n" }	
		}
	}

	expect {
		"Password: " { send -- "$password\r" }
		timeout { send_error -- "timeout detected on login\n" }
	}
	
	expect "\r\n\r\n"

	set timeout -1

	expect {
		-re "(.*)\r\n" { 
			send_user -- "\$expect_out(1,string)\n" 
			exp_continue
		}
		-re "(.+)" { 
			send_user -- "\$expect_out(1,string)" 
			exp_continue
		}
	}

	exit [ lindex [ wait ] 3 ]
	
EOC

err=$?

if [ $err -ne 0 ]
then
    error "cannot dump $dbname@$host"
fi

exit $err
