/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.ExecuteOn;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.SourceFileScanner;

public class Transform
extends ExecuteOn {
    protected Commandline.Marker targetFilePos = null;
    protected Mapper mapperElement = null;
    protected FileNameMapper mapper = null;
    protected File destDir = null;
    protected boolean srcIsFirst = true;

    public void setDest(File destDir) {
        this.destDir = destDir;
    }

    public Commandline.Marker createTargetfile() {
        if (this.targetFilePos != null) {
            throw new BuildException(this.taskType + " doesn't support multiple targetfile elements.", this.location);
        }
        this.targetFilePos = this.cmdl.createMarker();
        this.srcIsFirst = this.srcFilePos != null;
        return this.targetFilePos;
    }

    public Mapper createMapper() throws BuildException {
        if (this.mapperElement != null) {
            throw new BuildException("Cannot define more than one mapper", this.location);
        }
        this.mapperElement = new Mapper(this.project);
        return this.mapperElement;
    }

    protected void checkConfiguration() {
        super.checkConfiguration();
        if (this.mapperElement == null) {
            throw new BuildException("no mapper specified", this.location);
        }
        if (this.destDir == null) {
            throw new BuildException("no dest attribute specified", this.location);
        }
        this.mapper = this.mapperElement.getImplementation();
    }

    protected String[] getFiles(File baseDir, DirectoryScanner ds) {
        SourceFileScanner sfs = new SourceFileScanner(this);
        return sfs.restrict(ds.getIncludedFiles(), baseDir, this.destDir, this.mapper);
    }

    protected String[] getDirs(File baseDir, DirectoryScanner ds) {
        SourceFileScanner sfs = new SourceFileScanner(this);
        return sfs.restrict(ds.getIncludedDirectories(), baseDir, this.destDir, this.mapper);
    }

    protected String[] getCommandline(String[] srcFiles, File baseDir) {
        int targetIndex;
        if (this.targetFilePos == null) {
            return super.getCommandline(srcFiles, baseDir);
        }
        Vector<String> targets = new Vector<String>();
        Hashtable<String, String> addedFiles = new Hashtable<String, String>();
        int i = 0;
        while (i < srcFiles.length) {
            String[] subTargets = this.mapper.mapFileName(srcFiles[i]);
            if (subTargets != null) {
                int j = 0;
                while (j < subTargets.length) {
                    String name = new File(this.destDir, subTargets[j]).getAbsolutePath();
                    if (!addedFiles.contains(name)) {
                        targets.addElement(name);
                        addedFiles.put(name, name);
                    }
                    ++j;
                }
            }
            ++i;
        }
        Object[] targetFiles = new String[targets.size()];
        targets.copyInto(targetFiles);
        String[] orig = this.cmdl.getCommandline();
        String[] result = new String[orig.length + srcFiles.length + targetFiles.length];
        int srcIndex = orig.length;
        if (this.srcFilePos != null) {
            srcIndex = this.srcFilePos.getPosition();
        }
        if (srcIndex < (targetIndex = this.targetFilePos.getPosition()) || srcIndex == targetIndex && this.srcIsFirst) {
            System.arraycopy(orig, 0, result, 0, srcIndex);
            System.arraycopy(orig, srcIndex, result, srcIndex + srcFiles.length, targetIndex - srcIndex);
            System.arraycopy(targetFiles, 0, result, targetIndex + srcFiles.length, targetFiles.length);
            System.arraycopy(orig, targetIndex, result, targetIndex + srcFiles.length + targetFiles.length, orig.length - targetIndex);
        } else {
            System.arraycopy(orig, 0, result, 0, targetIndex);
            System.arraycopy(targetFiles, 0, result, targetIndex, targetFiles.length);
            System.arraycopy(orig, targetIndex, result, targetIndex + targetFiles.length, srcIndex - targetIndex);
            System.arraycopy(orig, srcIndex, result, srcIndex + srcFiles.length + targetFiles.length, orig.length - srcIndex);
            srcIndex += targetFiles.length;
        }
        int i2 = 0;
        while (i2 < srcFiles.length) {
            result[srcIndex + i2] = new File(baseDir, srcFiles[i2]).getAbsolutePath();
            ++i2;
        }
        return result;
    }

    protected String[] getCommandline(String srcFile, File baseDir) {
        return this.getCommandline(new String[]{srcFile}, baseDir);
    }
}

