/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.geometric;

import java.io.Serializable;
import java.sql.SQLException;
import org.postgresql.geometric.PGpoint;
import org.postgresql.util.PGobject;
import org.postgresql.util.PGtokenizer;
import org.postgresql.util.PSQLException;

public class PGcircle
extends PGobject
implements Serializable,
Cloneable {
    public PGpoint center;
    double radius;

    public PGcircle() {
        this.setType("circle");
    }

    public PGcircle(double x, double y, double r) {
        this(new PGpoint(x, y), r);
    }

    public PGcircle(String s) throws SQLException {
        this();
        this.setValue(s);
    }

    public PGcircle(PGpoint c, double r) {
        this();
        this.center = c;
        this.radius = r;
    }

    public Object clone() {
        return new PGcircle((PGpoint)this.center.clone(), this.radius);
    }

    public boolean equals(Object obj) {
        if (obj instanceof PGcircle) {
            PGcircle p = (PGcircle)obj;
            return p.center.equals(this.center) && p.radius == this.radius;
        }
        return false;
    }

    public String getValue() {
        return "<" + this.center + "," + this.radius + ">";
    }

    public void setValue(String s) throws SQLException {
        PGtokenizer t = new PGtokenizer(PGtokenizer.removeAngle(s), ',');
        if (t.getSize() != 2) {
            throw new PSQLException("postgresql.geo.circle", (Object)s);
        }
        try {
            this.center = new PGpoint(t.getToken(0));
            this.radius = Double.valueOf(t.getToken(1));
        }
        catch (NumberFormatException e) {
            throw new PSQLException("postgresql.geo.circle", (Object)e);
        }
    }
}

