/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.dotnet;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.taskdefs.optional.dotnet.NetCommand;
import org.apache.tools.ant.types.Path;

public class CSharp
extends MatchingTask {
    protected static final String csc_exe_name = "csc";
    protected static final String csc_file_ext = "cs";
    protected static final String csc_file_pattern = "**/*.cs";
    protected static final String DEFAULT_REFERENCE_LIST = "System.dll;System.Drawing.dll;System.Data.dll;System.Diagnostics.dll;System.DirectoryServices.dll;System.IO.dll;System.Management.dll;System.Messaging.dll;System.Net.dll;System.Runtime.Remoting.dll;System.Runtime.Serialization.Formatters.Soap.dll;System.Security.dll;System.ServiceProcess.dll;System.Text.RegularExpressions.dll;System.Timers.dll;System.Web.dll;System.Web.Services.dll;System.WinForms.dll;System.XML.dll;System.XML.Serialization.dll;Microsoft.ComServices.dll;";
    protected String _references;
    protected Path _referenceFiles;
    protected boolean _includeDefaultReferences;
    protected boolean _optimize;
    protected boolean _incremental;
    protected boolean _debug;
    protected File _docFile;
    private int _warnLevel;
    protected boolean _unsafe;
    protected String _mainClass;
    protected String _extraOptions;
    private File _srcDir;
    private File _destDir;
    protected String _targetType;
    protected File _win32icon;
    String _definitions;
    String _additionalModules;
    protected String _outputFile;
    protected boolean _failOnError;

    public void setReferences(String s) {
        this._references = s;
    }

    protected String getReferencesParameter() {
        if (this.notEmpty(this._references)) {
            return "/reference:" + this._references;
        }
        return null;
    }

    public void setReferenceFiles(Path path) {
        if (this._referenceFiles == null) {
            this._referenceFiles = new Path(((Task)this).project);
        }
        this._referenceFiles.append(path);
    }

    protected String getReferenceFilesParameter() {
        if (this._references == null) {
            return null;
        }
        String refpath = this._references.toString();
        if (refpath.length() == 0) {
            return null;
        }
        StringBuffer s = new StringBuffer("/reference:");
        s.append(refpath);
        return new String(s);
    }

    protected String getDefaultReferenceParameter() {
        if (this._includeDefaultReferences) {
            StringBuffer s = new StringBuffer("/reference:");
            s.append(DEFAULT_REFERENCE_LIST);
            return new String(s);
        }
        return null;
    }

    public void setIncludeDefaultReferences(boolean f) {
        this._includeDefaultReferences = f;
    }

    public boolean getIncludeDefaultReferences() {
        return this._includeDefaultReferences;
    }

    protected String getIncludeDefaultReferencesParameter() {
        return "/nostdlib" + (this._includeDefaultReferences ? "-" : "+");
    }

    public void setOptimize(boolean f) {
        this._optimize = f;
    }

    public boolean getOptimize() {
        return this._optimize;
    }

    protected String getOptimizeParameter() {
        return "/optimize" + (this._optimize ? "+" : "-");
    }

    public void setIncremental(boolean f) {
        this._incremental = f;
    }

    public boolean getIncremental() {
        return this._incremental;
    }

    protected String getIncrementalParameter() {
        return "/incremental" + (this._incremental ? "+" : "-");
    }

    public void setDebug(boolean f) {
        this._debug = f;
    }

    public boolean getDebug() {
        return this._debug;
    }

    protected String getDebugParameter() {
        return "/debug" + (this._debug ? "+" : "-");
    }

    public void setDocFile(String f) {
        this._docFile = ((Task)this).project.resolveFile(f);
    }

    protected String getDocFileParameter() {
        if (this._docFile != null) {
            return "/doc:" + this._docFile.toString();
        }
        return null;
    }

    public void setWarnLevel(int warnLevel) {
        this._warnLevel = warnLevel;
    }

    public int getWarnLevel() {
        return this._warnLevel;
    }

    protected String getWarnLevelParameter() {
        return "/warn:" + this._warnLevel;
    }

    public void setUnsafe(boolean unsafe) {
        this._unsafe = unsafe;
    }

    public boolean getUnsafe() {
        return this._unsafe;
    }

    protected String getUnsafeParameter() {
        return this._unsafe ? "/unsafe" : null;
    }

    public void setMainClass(String mainClass) {
        this._mainClass = mainClass;
    }

    public String getMainClass() {
        return this._mainClass;
    }

    protected String getMainClassParameter() {
        if (this._mainClass != null && this._mainClass.length() != 0) {
            return "/main:" + this._mainClass;
        }
        return null;
    }

    public void setExtraOptions(String extraOptions) {
        this._extraOptions = extraOptions;
    }

    public String getExtraOptions() {
        return this._extraOptions;
    }

    protected String getExtraOptionsParameter() {
        if (this._extraOptions != null && this._extraOptions.length() != 0) {
            return this._extraOptions;
        }
        return null;
    }

    public void setSrcDir(String srcDirName) {
        this._srcDir = ((Task)this).project.resolveFile(srcDirName);
    }

    public void setDestDir(String dirName) {
        this._destDir = ((Task)this).project.resolveFile(dirName);
    }

    public void setTargetType(String targetType) throws BuildException {
        if (!((targetType = targetType.toLowerCase()).equals("exe") || targetType.equals("library") || targetType.equals("module") || targetType.equals("winexe"))) {
            throw new BuildException("targetType " + targetType + " is not a valid type");
        }
        this._targetType = targetType;
    }

    public String getTargetType() {
        return this._targetType;
    }

    protected String getTargetTypeParameter() {
        if (this.notEmpty(this._targetType)) {
            return "/target:" + this._targetType;
        }
        return null;
    }

    public void setWin32Icon(String fileName) {
        this._win32icon = ((Task)this).project.resolveFile(fileName);
    }

    protected String getWin32IconParameter() {
        if (this._win32icon != null) {
            return "/win32icon:" + this._win32icon.toString();
        }
        return null;
    }

    public void setDefinitions(String params) {
        this._definitions = params;
    }

    protected String getDefinitionsParameter() {
        if (this.notEmpty(this._definitions)) {
            return "/define:" + this._definitions;
        }
        return null;
    }

    public void setAdditionalModules(String params) {
        this._additionalModules = params;
    }

    protected String getAdditionalModulesParameter() {
        if (this.notEmpty(this._additionalModules)) {
            return "/addmodule:" + this._additionalModules;
        }
        return null;
    }

    public void setOutputFile(String params) {
        this._outputFile = params;
    }

    protected String getOutputFileParameter() {
        if (this.notEmpty(this._outputFile)) {
            File f = ((Task)this).project.resolveFile(this._outputFile);
            return "/out:" + f.toString();
        }
        return null;
    }

    public void setFailOnError(boolean b) {
        this._failOnError = b;
    }

    public boolean getFailFailOnError() {
        return this._failOnError;
    }

    public void Clear() {
        this._targetType = null;
        this._win32icon = null;
        this._srcDir = null;
        this._destDir = null;
        this._mainClass = null;
        this._unsafe = false;
        this._warnLevel = 3;
        this._docFile = null;
        this._incremental = false;
        this._optimize = false;
        this._debug = true;
        this._references = null;
        this._failOnError = true;
        this._definitions = null;
        this._additionalModules = null;
        this._includeDefaultReferences = true;
        this._extraOptions = null;
    }

    protected boolean notEmpty(String s) {
        return s != null && s.length() != 0;
    }

    public void execute() throws BuildException {
        if (this._srcDir == null) {
            this._srcDir = ((Task)this).project.resolveFile(".");
        }
        NetCommand command = new NetCommand((Task)this, "CSC", csc_exe_name);
        command.setFailOnError(this.getFailFailOnError());
        command.setTraceCommandLine(true);
        command.addArgument("/nologo");
        command.addArgument(this.getAdditionalModulesParameter());
        command.addArgument(this.getDefinitionsParameter());
        command.addArgument(this.getDebugParameter());
        command.addArgument(this.getDocFileParameter());
        command.addArgument(this.getIncrementalParameter());
        command.addArgument(this.getMainClassParameter());
        command.addArgument(this.getOptimizeParameter());
        command.addArgument(this.getReferencesParameter());
        command.addArgument(this.getTargetTypeParameter());
        command.addArgument(this.getUnsafeParameter());
        command.addArgument(this.getWarnLevelParameter());
        command.addArgument(this.getWin32IconParameter());
        command.addArgument(this.getOutputFileParameter());
        command.addArgument(this.getIncludeDefaultReferencesParameter());
        command.addArgument(this.getDefaultReferenceParameter());
        command.addArgument(this.getExtraOptionsParameter());
        DirectoryScanner scanner = super.getDirectoryScanner(this._srcDir);
        String[] dependencies = scanner.getIncludedFiles();
        this.log("compiling " + dependencies.length + " file" + (dependencies.length == 1 ? "" : "s"));
        String baseDir = scanner.getBasedir().toString();
        int i = 0;
        while (i < dependencies.length) {
            String targetFile = dependencies[i];
            targetFile = baseDir + File.separator + targetFile;
            command.addArgument(targetFile);
            ++i;
        }
        command.runCommand();
    }

    public CSharp() {
        this.Clear();
        this.setIncludes(csc_file_pattern);
    }
}

