/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.javacc;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.Path;

public class JavaCC
extends Task {
    private static final String LOOKAHEAD = "LOOKAHEAD";
    private static final String CHOICE_AMBIGUITY_CHECK = "CHOICE_AMBIGUITY_CHECK";
    private static final String OTHER_AMBIGUITY_CHECK = "OTHER_AMBIGUITY_CHECK";
    private static final String STATIC = "STATIC";
    private static final String DEBUG_PARSER = "DEBUG_PARSER";
    private static final String DEBUG_LOOKAHEAD = "DEBUG_LOOKAHEAD";
    private static final String DEBUG_TOKEN_MANAGER = "DEBUG_TOKEN_MANAGER";
    private static final String OPTIMIZE_TOKEN_MANAGER = "OPTIMIZE_TOKEN_MANAGER";
    private static final String ERROR_REPORTING = "ERROR_REPORTING";
    private static final String JAVA_UNICODE_ESCAPE = "JAVA_UNICODE_ESCAPE";
    private static final String UNICODE_INPUT = "UNICODE_INPUT";
    private static final String IGNORE_CASE = "IGNORE_CASE";
    private static final String COMMON_TOKEN_ACTION = "COMMON_TOKEN_ACTION";
    private static final String USER_TOKEN_MANAGER = "USER_TOKEN_MANAGER";
    private static final String USER_CHAR_STREAM = "USER_CHAR_STREAM";
    private static final String BUILD_PARSER = "BUILD_PARSER";
    private static final String BUILD_TOKEN_MANAGER = "BUILD_TOKEN_MANAGER";
    private static final String SANITY_CHECK = "SANITY_CHECK";
    private static final String FORCE_LA_CHECK = "FORCE_LA_CHECK";
    private static final String CACHE_TOKENS = "CACHE_TOKENS";
    private final Hashtable optionalAttrs = new Hashtable();
    private File outputDirectory = null;
    private File target = null;
    private File javaccHome = null;
    private CommandlineJava cmdl = new CommandlineJava();

    public void setLookahead(int lookahead) {
        this.optionalAttrs.put(LOOKAHEAD, new Integer(lookahead));
    }

    public void setChoiceambiguitycheck(int choiceAmbiguityCheck) {
        this.optionalAttrs.put(CHOICE_AMBIGUITY_CHECK, new Integer(choiceAmbiguityCheck));
    }

    public void setOtherambiguityCheck(int otherAmbiguityCheck) {
        this.optionalAttrs.put(OTHER_AMBIGUITY_CHECK, new Integer(otherAmbiguityCheck));
    }

    public void setStatic(boolean staticParser) {
        this.optionalAttrs.put(STATIC, new Boolean(staticParser));
    }

    public void setDebugparser(boolean debugParser) {
        this.optionalAttrs.put(DEBUG_PARSER, new Boolean(debugParser));
    }

    public void setDebuglookahead(boolean debugLookahead) {
        this.optionalAttrs.put(DEBUG_LOOKAHEAD, new Boolean(debugLookahead));
    }

    public void setDebugtokenmanager(boolean debugTokenManager) {
        this.optionalAttrs.put(DEBUG_TOKEN_MANAGER, new Boolean(debugTokenManager));
    }

    public void setOptimizetokenmanager(boolean optimizeTokenManager) {
        this.optionalAttrs.put(OPTIMIZE_TOKEN_MANAGER, new Boolean(optimizeTokenManager));
    }

    public void setErrorreporting(boolean errorReporting) {
        this.optionalAttrs.put(ERROR_REPORTING, new Boolean(errorReporting));
    }

    public void setJavaunicodeescape(boolean javaUnicodeEscape) {
        this.optionalAttrs.put(JAVA_UNICODE_ESCAPE, new Boolean(javaUnicodeEscape));
    }

    public void setUnicodeinput(boolean unicodeInput) {
        this.optionalAttrs.put(UNICODE_INPUT, new Boolean(unicodeInput));
    }

    public void setIgnorecase(boolean ignoreCase) {
        this.optionalAttrs.put(IGNORE_CASE, new Boolean(ignoreCase));
    }

    public void setCommontokenaction(boolean commonTokenAction) {
        this.optionalAttrs.put(COMMON_TOKEN_ACTION, new Boolean(commonTokenAction));
    }

    public void setUsertokenmanager(boolean userTokenManager) {
        this.optionalAttrs.put(USER_TOKEN_MANAGER, new Boolean(userTokenManager));
    }

    public void setUsercharstream(boolean userCharStream) {
        this.optionalAttrs.put(USER_CHAR_STREAM, new Boolean(userCharStream));
    }

    public void setBuildparser(boolean buildParser) {
        this.optionalAttrs.put(BUILD_PARSER, new Boolean(buildParser));
    }

    public void setBuildtokenmanager(boolean buildTokenManager) {
        this.optionalAttrs.put(BUILD_TOKEN_MANAGER, new Boolean(buildTokenManager));
    }

    public void setSanitycheck(boolean sanityCheck) {
        this.optionalAttrs.put(SANITY_CHECK, new Boolean(sanityCheck));
    }

    public void setForcelacheck(boolean forceLACheck) {
        this.optionalAttrs.put(FORCE_LA_CHECK, new Boolean(forceLACheck));
    }

    public void setCachetokens(boolean cacheTokens) {
        this.optionalAttrs.put(CACHE_TOKENS, new Boolean(cacheTokens));
    }

    public void setOutputdirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void setTarget(File target) {
        this.target = target;
    }

    public void setJavacchome(File javaccHome) {
        this.javaccHome = javaccHome;
    }

    public void execute() throws BuildException {
        Enumeration iter = this.optionalAttrs.keys();
        while (iter.hasMoreElements()) {
            String name = (String)iter.nextElement();
            Object value = this.optionalAttrs.get(name);
            this.cmdl.createArgument().setValue("-" + name + ":" + value.toString());
        }
        if (this.target == null || !this.target.isFile()) {
            throw new BuildException("Invalid target: " + this.target);
        }
        if (this.outputDirectory == null) {
            this.outputDirectory = new File(this.target.getParent());
        } else if (!this.outputDirectory.isDirectory()) {
            throw new BuildException("Outputdir not a directory.");
        }
        this.cmdl.createArgument().setValue("-OUTPUT_DIRECTORY:" + this.outputDirectory.getAbsolutePath());
        File javaFile = this.getOutputJavaFile(this.outputDirectory, this.target);
        if (javaFile.exists() && this.target.lastModified() < javaFile.lastModified()) {
            this.log("Target is already built - skipping (" + this.target + ")", 3);
            return;
        }
        this.cmdl.createArgument().setValue(this.target.getAbsolutePath());
        if (this.javaccHome == null || !this.javaccHome.isDirectory()) {
            throw new BuildException("Javacchome not set.");
        }
        Path classpath = this.cmdl.createClasspath(this.project);
        classpath.createPathElement().setPath(this.javaccHome.getAbsolutePath() + "/JavaCC.zip");
        Commandline.Argument arg = this.cmdl.createVmArgument();
        arg.setValue("-mx140M");
        arg.setValue("-Dinstall.root=" + this.javaccHome.getAbsolutePath());
        Execute.runCommand((Task)this, (String[])this.cmdl.getCommandline());
    }

    private File getOutputJavaFile(File outputdir, File srcfile) {
        int startExtn;
        String path = srcfile.getPath();
        int startBasename = path.lastIndexOf(File.separator);
        if (startBasename != -1) {
            path = path.substring(startBasename + 1);
        }
        path = (startExtn = path.lastIndexOf(46)) != -1 ? path.substring(0, startExtn) + ".java" : path + ".java";
        if (outputdir != null) {
            path = outputdir + File.separator + path;
        }
        return new File(path);
    }

    public JavaCC() {
        this.cmdl.setVm("java");
        this.cmdl.setClassname("COM.sun.labs.javacc.Main");
    }
}

