/*
	agent.cpp

	The Agent class is a base for both class MasterAgent and class DbAgent.
	It implements common agent functionality. All members, including the
	constructor, are protected. This class is not supposed to be instantiated
	directly. Since this class does not implement any thread-related functionality,
	it does not derive from class Thread. That means MasterAgent and DbAgent must
	derive from class Agent as well as from class Thread.

	Project: pgjobs
	Author: Zlatko Michailov
	Created: 13-Oct-2003
	Updated:

	This file is provided as is, with no warranty. Use at your own risk.

	Copyright (c) 2003, Zlatko Michailov

*/



//--------------------------------------------------------------------------------

#include "agent.h"

using namespace std;




//--------------------------------------------------------------------------------
// Construct static members

Log Agent::SharedLog;



//--------------------------------------------------------------------------------
// Class Agent implements common (protected) functionality for specific pgjobs
// agent classes.

Agent::Agent( const char* agentName, int logLevel )
{
	AgentName		= agentName;
	Status			= StatusStartup;
	LogLevel		= logLevel;
	IsReadyToRun	= false;
}



bool Agent::InitLog()
{
	return SharedLog.InitAgent( AgentName.c_str() );
}



bool Agent::Record( const char* text, int messageLevel )
{
	bool ok = true;

	if ( messageLevel <= LogLevel )
	{
		ok = SharedLog.Record( AgentName.c_str(), Status, text );
	}

	return ok;
}


