/*
	defs.h

	Common definitions for oroject pgjobs.

	Project: pgjobs
	Author: Zlatko Michailov
	Created:  1-Oct-2003
	Updated:  2-Oct-2003
	Updated:  6-Oct-2003
	Updated: 14-Oct-2003
	Updated: 16-Oct-2003
	Updated: 28-Oct-2003
	Updated: 29-Oct-2003
	Updated:  7-May-2004
	Updated: 26-May-2004
	Updated: 27-May-2004

	This file is provided as is, with no warranty. Use at your own risk.

	Copyright (c) 2003-2004, Zlatko Michailov

*/



#ifndef __DEFS_H__
#define __DEFS_H__



//--------------------------------------------------------------------------------
// Constants

// Config file row
const int	MaxLineLen			= 1024;
const char	RowMainChar			= '=';
const char	RowColChar			= '|';
const char	RowCommentChar		= '#';


// Log timestamp
const int	TMYearBase			= 1900;
const int	TMMonthBase			= 1;



enum LogLevel
{
	LogLevelError			= 0,
	LogLevelSystemInfo		= 1,
	LogLevelSystemVerbose	= 2,

	//LogLevelUndefined3	= 3,
	//LogLevelUndefined4	= 4,

	LogLevelDebug			= 5
};



enum MessageCommand
{
	CmdUnknown,

	// Log
	CmdLogInitAgent,
	CmdLogMessage
};



//--------------------------------------------------------------------------------
// Resources

// Installation
extern const char	InstallRoot[];


// Config
extern const char	ConfigFilePath[];
extern const char	BackupExt[];
extern const char	Default[];
extern const char	None[];
extern const char	Master[];
extern const char	System[];
extern const char	Postgres[];


// Log
extern const char	LogRoot[];
extern const char	LogExt[];
extern const char	DatePattern[];
extern const char	TimePattern[];


// Status
extern const char	StatusStartup[];
extern const char	StatusRunning[];
extern const char	StatusShutdown[];


// Log Level
extern const char	LogLevelDefault[];


// Config manipulation
extern const char	Indent[];
extern const char*	SchemaSystem[];
extern const char*	SchemaMaster[];
extern const char*	SchemaDb[];

extern const int SizeOfSchemaSystem;
extern const int SizeOfSchemaMaster;
extern const int SizeOfSchemaDb;


// File system
extern const char	NullDevice[];
extern const char	TempFileTemplate[];



//--------------------------------------------------------------------------------
// Utility functions

extern int mkdirhier( const char* path, int mode );
extern int setename( const char* name );



//--------------------------------------------------------------------------------



#endif	// __DEFS_H__


