/*
	log-test.cpp

	The Log class implements all the functionality  for logging messages
	to text file.

	This is testing code for class Log.

	Project: pgjobs
	Author: Zlatko Michailov
	Created:  2-Oct-2003
	Updated:  5-May-2004

	This file is provided as is, with no warranty. Use at your own risk.

	Copyright (c) 2003-2004, Zlatko Michailov

*/



//--------------------------------------------------------------------------------

#include <unistd.h>
#include <iostream>
#include "log.h"



//--------------------------------------------------------------------------------
// Self test

#ifdef _DEBUG

void Log::SelfTest( ostream& out )
{
	bool ok;
	
	Start();
	
	ok = InitAgent( Master );
	ok = Record( Master, StatusStartup, "one" );
	ok = Record( Master, StatusRunning, "two" );
	ok = Record( Master, StatusRunning, 0 );
	ok = Record( Master, StatusRunning, "" );
	ok = Record( Master, StatusShutdown, "five" );

	sleep( 5 );

	Stop();
	WaitUntilFinished();
}



#else

void Log::SelfTest( ostream& )
{
}

#endif



