/*
	masteragent.h

	The MasterAgent class reads config entries, creates DbAgent instances, 
	and runs them.

	Project: pgjobs
	Author: Zlatko Michailov
	Created: 13-Oct-2003
	Updated:  5-May-2004

	This file is provided as is, with no warranty. Use at your own risk.

	Copyright (c) 2003-2004, Zlatko Michailov

*/



#ifndef __MASTERAGENT_H__
#define __MASTERAGENT_H__



//--------------------------------------------------------------------------------

#include <vector>
#include "../../../msdk/include/msdk.h"
#include "dbagent.h"


using namespace std;
using namespace msdk;



//--------------------------------------------------------------------------------
// Class MasterAgent

class MasterAgent : public Agent, public Thread
{
// Data members
protected:
	vector<DbAgent*>	DbAgents;


// Construction
public:
	MasterAgent();


// Overridables
protected:
	void Startup();
	void Shutdown();
	void Run();
	

// Internal support
protected:
	bool ReadMasterConfig();
	bool SpawnDbAgents();
};



#endif	// __MASTERAGENT_H__


