/* Written by Morgoth DBMA, morgothdbma@o2.pl
 This is part of PgXexplorer software, Open Source
 on BSD licence, Libraries(interaces) used:
 GNU GCC, AS (all stuff needed to compile C source into executable binary)
 LibPQ-FE from PostgreSQL, GTK (GIMP Toolkit)
 written in VIM editor, ctags used, CVS used
 Currently only one author: MOrgoth DBMA
 FILE: query.c */
#include "common.h"
#include "consoleout.h"
#include "query.h"
#include "signals.h"
/*FIXME dodac obsluge debug, error ==> DlgWindow*/
/* THERE WOULDN'T BE ANY DEBUG LOG TO FILE ETC. */
int ping_conn;
extern int timeout;



int connAlive(PGconn* c)
{
 PGresult* r;
 int stat;
 debug("%s:%d connAlive", __FILE__,__LINE__);
 ping_conn=1;
 alarm_clock(timeout);
 r= PQexec(c, "SELECT datname FROM pg_database");
 alarm_stop();
 if (!r)
   {
    debug("PQresult is NULL %s\n", PQerrorMessage(c));
    return 0;
   }
 stat = PQresultStatus(r);
 if (stat!=PGRES_COMMAND_OK && stat!=PGRES_TUPLES_OK)
   {
    debug("PQexec error: %s %s",PQcmdStatus(r),PQresultErrorMessage(r));
    return 0;
   }
 return ping_conn;
}


void disconnect_db(PGconn** c)
{
 debug("%s:%d disconnect_db", __FILE__,__LINE__);
 if (*c) PQfinish(*c);
 else warn("connect is null: %s:%d", __FILE__,__LINE__);
 *c = NULL;
}


PGconn* connect_db(char* arg, char* pass)
{
 PGconn* conn;
 char* strarg;
 conn=0;
 debug("%s:%d connect_db", __FILE__,__LINE__);
 strarg = (char*)malloc(strlen(arg)+64+(pass?strlen(pass):1));
 debug("\nconnect to database %s\n", arg);
 if (!pass) sprintf(strarg,"dbname=template1");
 else	     sprintf(strarg,"dbname=template1 password='%s'", pass);
 alarm_clock(timeout);
 conn = PQconnectdb(strarg);
 alarm_stop();
 if (!conn) { error("cannot connect to template1 DB"); free(strarg); return NULL; }
 if (PQstatus(conn)==CONNECTION_BAD) {  error("cannot connect to template1 DB"); free(strarg); return NULL; }
 disconnect_db(&conn);
 if (!pass) sprintf(strarg,"dbname=%s", arg);
 else sprintf(strarg,"dbname=%s password='%s'", arg,pass);
 alarm_clock(timeout);
 conn = PQconnectdb(strarg);
 alarm_stop();
 if (!conn) { free(strarg); error("connection is NULL %s:%d", __FILE__,__LINE__); return NULL; }
 if (PQstatus(conn) == CONNECTION_BAD)
   {
    error("\nCannot connect to DB:%s\n", arg);
    ERR
    free(strarg);
    return NULL;
   }
 free(strarg);
 return conn;
}


PGconn* gtk_connect_db(char* arg, char* pass, char* errstr)
{
 PGconn* conn;
 char* strarg;
 conn=0;
 debug("%s:%d gtk_connect_db", __FILE__,__LINE__);
 strarg = (char*)malloc(strlen(arg)+64+(pass?strlen(pass):1));
 if (!pass) sprintf(strarg,"dbname=template1");
 else       sprintf(strarg,"dbname=template1 password='%s'", pass);
 alarm_clock(timeout);
 conn = PQconnectdb(strarg);
 alarm_stop();
 if (!conn) { sprintf(errstr,"cannot connect to template1 DB"); free(strarg); return NULL; }
 if (PQstatus(conn)==CONNECTION_BAD) {  sprintf(errstr,"cannot connect to template1 DB"); free(strarg); return NULL; }
 disconnect_db(&conn);
 if (!pass) sprintf(strarg,"dbname=%s",arg);
 else       sprintf(strarg,"dbname=%s password='%s'", arg, pass);
 alarm_clock(timeout);
 conn = PQconnectdb(strarg);
 alarm_stop();
 if (!conn) { error("connection is NULL %s:%d", __FILE__,__LINE__); free(strarg); return NULL; }
 if (PQstatus(conn) == CONNECTION_BAD)
  {
   sprintf(errstr, "Connection string:\ndbname=%s failed.", arg);
   free(strarg);
   return NULL;
  }
 free(strarg);
 return conn;
}


void clear_result(PGresult** r)
{
 debug("%s:%d clear_result", __FILE__,__LINE__);
 if (*r) PQclear(*r);
 *r=0;
}


PGresult* execute_silent_query(PGconn* c,  char* query)
{
 PGresult* r;
 int stat;
 debug("%s:%d execute_silent_query", __FILE__,__LINE__);
 debug("SQLquery: \"%s\"\n", query);
 if (!connAlive(c)) { debug("connection dead!\n"); return NULL; }
 if (!query)
   {
    debug("NULL query passed\n");
    return NULL;
   }
 if (!c) { error("no connection"); return NULL; }
 r= PQexec(c, query);
 if (!r)
   {
    debug("PQresult is NULL %s\n", PQerrorMessage(c));
    return NULL;
   }
 stat = PQresultStatus(r);
 if (stat!=PGRES_COMMAND_OK && stat!=PGRES_TUPLES_OK)
   {
    debug("PQexec error: %s %s",PQcmdStatus(r),PQresultErrorMessage(r));
    debug("Failed query was: \"%s\"\n", query);
    return NULL;
   }
 return r;
}


char*** p3c_execute_printf(PGconn* c,int* row, int* col, char* errstr, int want_meta, char* fmt,...)
{
 va_list ap;
 char*** ret;
 char msg[MAX_QUERY_LENGTH*2];
 debug("%s:%d p3c_execute_printf", __FILE__,__LINE__);
 if (!c) { error("no connection"); return NULL; }
 va_start(ap, fmt);
 vsprintf(msg,fmt,ap);
 va_end(ap);
 execute_printf(c, &ret, row, col, errstr, want_meta, msg);
 return ret;
}

char*** dmp3c_execute_printf(PGconn* c,int* row, int* col, char* errstr, int want_meta, char* file, int line, char* fmt,...)
{
 va_list ap;
 char*** ret;
 char msg[MAX_QUERY_LENGTH*2];
 debug("%s:%d dmp3c_execute_printf called from %s:%d", __FILE__,__LINE__,file,line);
 if (!c) { error("no connection"); return NULL; }
 va_start(ap, fmt);
 vsprintf(msg,fmt,ap);
 va_end(ap);
 dmexecute_printf(c, &ret, row, col, errstr, want_meta, HERE, msg);
 return ret;
}

char*** dmem_p3c_execute_printf(struct dmem_list** mem, PGconn* c,int* row, int* col, char* errstr, int want_meta, char* file, int line, char* fmt,...)
{
 va_list ap;
 char*** ret;
 char msg[MAX_QUERY_LENGTH*2];
 debug("%s:%d dmem_p3c_execute_printf called from %s:%d", __FILE__,__LINE__,file,line);
 if (!c) { error("no connection"); return NULL; }
 va_start(ap, fmt);
 vsprintf(msg,fmt,ap);
 va_end(ap);
 dmem_execute_printf(mem, c, &ret, row, col, errstr, want_meta, HERE, msg);
 return ret;
}

char*** mp3c_execute_printf(PGconn* c,int* row, int* col, char* errstr, int want_meta, char* fmt,...)
{
 va_list ap;
 char*** ret;
 char msg[MAX_QUERY_LENGTH*2];
 debug("%s:%d mp3c_execute_printf", __FILE__,__LINE__);
 if (!c) { error("no connection"); return NULL; }
 va_start(ap, fmt);
 vsprintf(msg,fmt,ap);
 va_end(ap);
 mexecute_printf(c, &ret, row, col, errstr, want_meta, msg);
 return ret;
}

char*** mem_p3c_execute_printf(struct mem_list** mem, PGconn* c,int* row, int* col, char* errstr, int want_meta, char* fmt,...)
{
 va_list ap;
 char*** ret;
 char msg[MAX_QUERY_LENGTH*2];
 debug("%s:%d mem_p3c_execute_printf", __FILE__,__LINE__);
 if (!c) { error("no connection"); return NULL; }
 va_start(ap, fmt);
 vsprintf(msg,fmt,ap);
 va_end(ap);
 mem_execute_printf(mem, c, &ret, row, col, errstr, want_meta, msg);
 return ret;
}

void dmem_execute_printf(struct dmem_list** mem, PGconn* c, char**** res, int* row, int* col, char* errstr, int want_meta, char* file, int line, char* fmt,...)
{
 int stat;
 va_list ap;
 char query[MAX_QUERY_LENGTH*2];
 PGresult* r;
 debug("%s:%d mem_execute_printf called from %s:%d", __FILE__,__LINE__,file,line);
 va_start(ap, fmt);
 vsprintf(query,fmt,ap);
 va_end(ap);
 r=NULL;
 if (!c)
   {
    *res = NULL;
    *row = *col = -1;
    strcpy(errstr, "Not connected to DB");
    return;
   }
 if (!query)
   {
    *res = NULL;
    *row = *col = -1;
    strcpy(errstr, "NULL query passed to DB");
    return;
   }
 if (!connAlive(c)) { sprintf(errstr,"connection dead!\n"); return ; }
 r= PQexec(c, query);
 if (!r)
   {
    sprintf(errstr,"PQresult is NULL %s\nQuery was:\n%s\n", PQerrorMessage(c), query);
    *res = NULL;
    *row = *col = -1;
    return ;
   }
 stat = PQresultStatus(r);
 if (stat!=PGRES_COMMAND_OK && stat!=PGRES_TUPLES_OK)
   {
    sprintf(errstr,"PQexec:\n%s\n%s\nQuery was:\n%s",PQcmdStatus(r),PQresultErrorMessage(r), query);
    *res = NULL;
    *row = *col = -1;
    clear_result(&r);
    return;
   }
 *res = dmem_pgres2pc3(mem, r, row, col, want_meta, HERE);
 clear_result(&r);
}

void mem_execute_printf(struct mem_list** mem, PGconn* c, char**** res, int* row, int* col, char* errstr, int want_meta, char* fmt,...)
{
 int stat;
 va_list ap;
 char query[MAX_QUERY_LENGTH*2];
 PGresult* r;
 debug("%s:%d mem_execute_printf", __FILE__,__LINE__);
 va_start(ap, fmt);
 vsprintf(query,fmt,ap);
 va_end(ap);
 r=NULL;
 if (!c)
   {
    *res = NULL;
    *row = *col = -1;
    strcpy(errstr, "Not connected to DB");
    return;
   }
 if (!query)
   {
    *res = NULL;
    *row = *col = -1;
    strcpy(errstr, "NULL query passed to DB");
    return;
   }
 if (!connAlive(c)) { sprintf(errstr,"connection dead!\n"); return ; }
 r= PQexec(c, query);
 if (!r)
   {
    sprintf(errstr,"PQresult is NULL %s\nQuery was:\n%s\n", PQerrorMessage(c), query);
    *res = NULL;
    *row = *col = -1;
    return ;
   }
 stat = PQresultStatus(r);
 if (stat!=PGRES_COMMAND_OK && stat!=PGRES_TUPLES_OK)
   {
    sprintf(errstr,"PQexec:\n%s\n%s\nQuery was:\n%s",PQcmdStatus(r),PQresultErrorMessage(r), query);
    *res = NULL;
    *row = *col = -1;
    clear_result(&r);
    return;
   }
 *res = mem_pgres2pc3(mem, r, row, col, want_meta);
 clear_result(&r);
}

void dmexecute_printf(PGconn* c, char**** res, int* row, int* col, char* errstr, int want_meta, char* file, int line, char* fmt,...)
{
 int stat;
 va_list ap;
 char query[MAX_QUERY_LENGTH*2];
 PGresult* r;
 debug("%s:%d dmexecute_printf called from %s:%d", __FILE__,__LINE__,file,line);
 va_start(ap, fmt);
 vsprintf(query,fmt,ap);
 va_end(ap);
 r=NULL;
 if (!c)
   {
    *res = NULL;
    *row = *col = -1;
    strcpy(errstr, "Not connected to DB");
    return;
   }
 if (!query)
   {
    *res = NULL;
    *row = *col = -1;
    strcpy(errstr, "NULL query passed to DB");
    return;
   }
 if (!connAlive(c)) { sprintf(errstr,"connection dead!\n"); return ; }
 r= PQexec(c, query);
 if (!r)
   {
    sprintf(errstr,"PQresult is NULL %s\nQuery was:\n%s\n", PQerrorMessage(c), query);
    *res = NULL;
    *row = *col = -1;
    return ;
   }
 stat = PQresultStatus(r);
 if (stat!=PGRES_COMMAND_OK && stat!=PGRES_TUPLES_OK)
   {
    sprintf(errstr,"PQexec:\n%s\n%s\nQuery was:\n%s",PQcmdStatus(r),PQresultErrorMessage(r), query);
    *res = NULL;
    *row = *col = -1;
    clear_result(&r);
    return;
   }
 *res = dmpgres2pc3(r, row, col, want_meta, HERE);
 clear_result(&r);
}

void mexecute_printf(PGconn* c, char**** res, int* row, int* col, char* errstr, int want_meta, char* fmt,...)
{
 int stat;
 va_list ap;
 char query[MAX_QUERY_LENGTH*2];
 PGresult* r;
 debug("%s:%d mexecute_printf", __FILE__,__LINE__);
 va_start(ap, fmt);
 vsprintf(query,fmt,ap);
 va_end(ap);
 r=NULL;
 if (!c)
   {
    *res = NULL;
    *row = *col = -1;
    strcpy(errstr, "Not connected to DB");
    return;
   }
 if (!query)
   {
    *res = NULL;
    *row = *col = -1;
    strcpy(errstr, "NULL query passed to DB");
    return;
   }
 if (!connAlive(c)) { sprintf(errstr,"connection dead!\n"); return ; }
 r= PQexec(c, query);
 if (!r)
   {
    sprintf(errstr,"PQresult is NULL %s\nQuery was:\n%s\n", PQerrorMessage(c), query);
    *res = NULL;
    *row = *col = -1;
    return ;
   }
 stat = PQresultStatus(r);
 if (stat!=PGRES_COMMAND_OK && stat!=PGRES_TUPLES_OK)
   {
    sprintf(errstr,"PQexec:\n%s\n%s\nQuery was:\n%s",PQcmdStatus(r),PQresultErrorMessage(r), query);
    *res = NULL;
    *row = *col = -1;
    clear_result(&r);
    return;
   }
 *res = mpgres2pc3(r, row, col, want_meta);
 clear_result(&r);
}

void execute_printf(PGconn* c, char**** res, int* row, int* col, char* errstr, int want_meta, char* fmt,...)
{
 int stat;
 va_list ap;
 char query[MAX_QUERY_LENGTH*2];
 PGresult* r;
 debug("%s:%d execute_printf", __FILE__,__LINE__);
 va_start(ap, fmt);
 vsprintf(query,fmt,ap);
 va_end(ap);
 r=NULL;
 if (!c)
   {
    *res = NULL;
    *row = *col = -1;
    strcpy(errstr, "Not connected to DB");
    return;
   }
 if (!query)
   {
    *res = NULL;
    *row = *col = -1;
    strcpy(errstr, "NULL query passed to DB");
    return;
   }
 if (!connAlive(c)) { sprintf(errstr,"connection dead!\n"); return ; }
 r= PQexec(c, query);
 if (!r)
   {
    sprintf(errstr,"PQresult is NULL %s\nQuery was:\n%s\n", PQerrorMessage(c), query);
    *res = NULL;
    *row = *col = -1;
    return ;
   }
 stat = PQresultStatus(r);
 if (stat!=PGRES_COMMAND_OK && stat!=PGRES_TUPLES_OK)
   {
    sprintf(errstr,"PQexec:\n%s\n%s\nQuery was:\n%s",PQcmdStatus(r),PQresultErrorMessage(r), query);
    *res = NULL;
    *row = *col = -1;
    clear_result(&r);
    return;
   }
 *res = pgres2pc3(r, row, col, want_meta);
 clear_result(&r);
}


void execute_printf_query(PGconn* c,PGresult** r, char* errstr, char* fmt,...)
{
 int stat;
 va_list ap;
 char query[MAX_QUERY_LENGTH*2];
 debug("%s:%d execute_printf_query", __FILE__,__LINE__);
 va_start(ap, fmt);
 vsprintf(query,fmt,ap);
 va_end(ap);
 if (!c)
   {
    *r = NULL;
    strcpy(errstr, "Not connected to DB");
    return;
   }
 if (!query)
   {
    *r = NULL;
    strcpy(errstr, "NULL query passed to DB");
    return;
   }
 if (!connAlive(c)) { sprintf(errstr,"connection dead!\n"); return ; }
 *r= PQexec(c, query);
 if (!*r)
   {
    sprintf(errstr,"PQresult is NULL %s\nQuery was:\n%s\n", PQerrorMessage(c), query);
    return ;
   }
 stat = PQresultStatus(*r);
 if (stat!=PGRES_COMMAND_OK && stat!=PGRES_TUPLES_OK)
   {
    sprintf(errstr,"PQexec:\n%s\n%s\nQuery was:\n%s",PQcmdStatus(*r),PQresultErrorMessage(*r), query);
    clear_result(r);
    *r = NULL;
    return;
   }
}

int get_db_tables(PGconn* c, char*** dat, int* ntabs, int want_all_elems)
{
 char*** res;
 char** data;
 int row,col,i;
 char errstr[MAX_QUERY_LENGTH+100];
 data = *dat;
 debug("%s:%d get_db_tables", __FILE__,__LINE__);
 if (!want_all_elems)
 execute_printf(c, &res, &row, &col, errstr, 0,
		 "SELECT tablename from pg_tables WHERE tablename NOT LIKE 'pg_%%' AND tablename NOT LIKE 'sql_%%' ORDER BY tablename");
 else
 execute_printf(c, &res, &row, &col, errstr, 0,
		 "SELECT tablename from pg_tables ORDER BY tablename");
 if (!res) { *dat=NULL; ntabs=0; warn("empty result get_db_tables: %s:%d", __FILE__,__LINE__); return 0; }
 if (col<0 || row<0) { printf("errstr=%s\n", errstr); (*dat) = NULL; *ntabs=-1; return 0; }
 *ntabs = row;
 data = (char**)malloc(row<<2);
 for (i=0;i<row;i++) 
   { 
    data[i] = malloc(strlen(res[i][0])+1); 
    strcpy(data[i], res[i][0]); 
   }
 free_p3c(&res, row, col);		/* FIXME CHECK IT */
 *dat = data;
 return 1;
}

int dmget_db_tables(PGconn* c, char*** dat, int* ntabs, int want_all_elems, char* file, int line)
{
 char*** res;
 char** data;
 int row,col,i;
 char errstr[MAX_QUERY_LENGTH+100];
 data = *dat;
 debug("%s:%d mget_db_tables called from %s:%d", __FILE__,__LINE__,file,line);
 if (!want_all_elems)
 dmexecute_printf(c, &res, &row, &col, errstr, 0,HERE,
		 "SELECT tablename from pg_tables WHERE tablename NOT LIKE 'pg_%%' AND tablename NOT LIKE 'sql_%%' ORDER BY tablename");
 else
 dmexecute_printf(c, &res, &row, &col, errstr, 0, HERE,
		 "SELECT tablename from pg_tables ORDER BY tablename");
 if (!res) { *dat=NULL; ntabs=0; warn("empty result get_db_tables: %s:%d", __FILE__,__LINE__); return 0; }
 if (col<0 || row<0) { printf("errstr=%s\n", errstr); (*dat) = NULL; *ntabs=-1; return 0; }
 *ntabs = row;
 data = (char**)dmmalloc(row<<2, HERE);
 for (i=0;i<row;i++) 
   { 
    data[i] = dmmalloc(strlen(res[i][0])+1, HERE); 
    strcpy(data[i], res[i][0]); 
   }
 dmfree_p3c(&res, row, col, HERE);		/* FIXME CHECK IT */
 *dat = data;
 return 1;
}

int mget_db_tables(PGconn* c, char*** dat, int* ntabs, int want_all_elems)
{
 char*** res;
 char** data;
 int row,col,i;
 char errstr[MAX_QUERY_LENGTH+100];
 data = *dat;
 debug("%s:%d mget_db_tables", __FILE__,__LINE__);
 if (!want_all_elems)
 execute_printf(c, &res, &row, &col, errstr, 0,
		 "SELECT tablename from pg_tables WHERE tablename NOT LIKE 'pg_%%' AND tablename NOT LIKE 'sql_%%' ORDER BY tablename");
 else
 execute_printf(c, &res, &row, &col, errstr, 0,
		 "SELECT tablename from pg_tables ORDER BY tablename");
 if (!res) { *dat=NULL; ntabs=0; warn("empty result get_db_tables: %s:%d", __FILE__,__LINE__); return 0; }
 if (col<0 || row<0) { printf("errstr=%s\n", errstr); (*dat) = NULL; *ntabs=-1; return 0; }
 *ntabs = row;
 data = (char**)mmalloc(row<<2);
 for (i=0;i<row;i++) 
   { 
    data[i] = mmalloc(strlen(res[i][0])+1); 
    strcpy(data[i], res[i][0]); 
   }
 mfree_p3c(&res, row, col);		/* FIXME CHECK IT */
 *dat = data;
 return 1;
}

int mem_get_db_tables(struct mem_list** mem, PGconn* c, char*** dat, int* ntabs, int want_all_elems)
{
 char*** res;
 char** data;
 int row,col,i;
 char errstr[MAX_QUERY_LENGTH+100];
 data = *dat;
 debug("%s:%d mem_get_db_tables", __FILE__,__LINE__);
 if (!want_all_elems)
 mem_execute_printf(mem,c, &res, &row, &col, errstr, 0,
		 "SELECT tablename from pg_tables WHERE tablename NOT LIKE 'pg_%%' AND tablename NOT LIKE 'sql_%%' ORDER BY tablename");
 else
 mem_execute_printf(mem,c, &res, &row, &col, errstr, 0,
		 "SELECT tablename from pg_tables ORDER BY tablename");
 if (!res) { *dat=NULL; ntabs=0; warn("empty result get_db_tables: %s:%d", __FILE__,__LINE__); return 0; }
 if (col<0 || row<0) { debug("errstr=%s\n", errstr); (*dat) = NULL; *ntabs=-1; return 0; }
 *ntabs = row;
 data = (char**)smalloc(mem, row<<2);
 for (i=0;i<row;i++) 
   { 
    data[i] = smalloc(mem, strlen(res[i][0])+1); 
    strcpy(data[i], res[i][0]); 
   }
 mem_free_p3c(mem, &res, row, col);
 *dat = data;
 return 1;
}

int dmem_get_db_tables(struct dmem_list** mem, PGconn* c, char*** dat, int* ntabs, int want_all_elems,char* file, int line)
{
 char*** res;
 char** data;
 int row,col,i;
 char errstr[MAX_QUERY_LENGTH+100];
 data = *dat;
 debug("%s:%d mem_get_db_tables called from %s:%d", __FILE__,__LINE__,file,line);
 if (!want_all_elems)
 dmem_execute_printf(mem,c, &res, &row, &col, errstr, 0,HERE,
		 "SELECT tablename from pg_tables WHERE tablename NOT LIKE 'pg_%%' AND tablename NOT LIKE 'sql_%%' ORDER BY tablename");
 else
 dmem_execute_printf(mem,c, &res, &row, &col, errstr, 0,HERE,
		 "SELECT tablename from pg_tables ORDER BY tablename");
 if (!res) { *dat=NULL; ntabs=0; warn("empty result get_db_tables: %s:%d", __FILE__,__LINE__); return 0; }
 if (col<0 || row<0) { debug("errstr=%s\n", errstr); (*dat) = NULL; *ntabs=-1; return 0; }
 *ntabs = row;
 data = (char**)dsmalloc(mem, row<<2, HERE);
 for (i=0;i<row;i++) 
   { 
    data[i] = dsmalloc(mem, strlen(res[i][0])+1, HERE); 
    strcpy(data[i], res[i][0]); 
   }
 dmem_free_p3c(mem, &res, row, col, HERE);
 *dat = data;
 return 1;
}


PGresult* execute_query(PGconn* c,  char* query)
{
 PGresult* r;
 int stat;
 debug("%s:%d execute_query", __FILE__,__LINE__);
 debug("SQLquery: \"%s\"\n", query);
 if (!query)
   {
    ERR error("NULL query passed\n");
    return NULL;
   }
 if (!c) return NULL;
 if (!connAlive(c)) { debug("connection dead!\n"); return NULL; }
 r= PQexec(c, query);
 if (!r)
   {
    ERR error("PQresult is NULL %s\n", PQerrorMessage(c));
    return NULL;
   }
 stat = PQresultStatus(r);
 if (stat!=PGRES_COMMAND_OK && stat!=PGRES_TUPLES_OK)
   {
    ERR error("PQexec: %s %s",PQcmdStatus(r),PQresultErrorMessage(r));
    error("Failed query was: \"%s\"\n", query);
    return NULL;
   }
 return r;
}

char*** dmem_pgres2pc3(struct dmem_list** mem, const PGresult* r, int* a, int* b, int want_meta, char* file, int line)
{
 char*** result;
 char* tmp;
 int i,j;
 debug("%s:%d dmem_pgres2pc3 called from %s:%d", __FILE__,__LINE__,file,line);
 debug("mem_pgres2pc3: %p\n", (void*)r);
 if (!r) return 0;
 i=j=0;
 *a = PQntuples(r);
 *b = PQnfields(r);
 if (!(*a) || !(*b)) 
   { 
    warn("no cols or no rows (%s:%d)", __FILE__,__LINE__); 
    return NULL; 
   }
 /*printf("ntuples=%d,%d\n", *a,*b);*/
 /*if (!(*a) || !(*b)) { warn("no cols or no rows (%s:%d)", __FILE__,__LINE__); return NULL; }*/
 if (!want_meta)
 {
 result = (char***)dsmalloc(mem, (*a)<<2, HERE);
 if (!result) { ERR error("smalloc error\n"); return NULL; }
 for (i=0;i<*a;i++)
   {
    result[i] = (char**)dsmalloc(mem, (*b)<<2, HERE);
    if (!result[i])
      {
       for (j=0;j<i;j++) dsfree(mem, (void**)(&result[i]), HERE);
       ERR error("smalloc_i error!\n");
       return NULL;
      }
   }
 for (i=0;i<*a;i++)
 for (j=0;j<*b;j++)
   {
    result[i][j] = (char*)dsmalloc(mem, PQgetlength(r,i,j)+1, HERE);
    if (!result[i][j])
      {
       dmem_free_p3c(mem, &result,*a,*b, HERE);
       ERR error("malloc_ij error\n");
       return NULL;
      }
    strcpy(result[i][j], (char*)PQgetvalue(r,i,j));
   }
/*#ifdef DEBUG
  debug("char*** result is (%d:%d):\n",i,j);
  for (i=0;i<*a;i++)
    {
     for (j=0;j<*b;j++) debug("%-15s ", result[i][j]);
     ln();
    }
#endif*/
 return result;
 }
 else
 {
  if ((*b)<=0) return NULL;		/*FIXME is it OK? */
 (*a)++;
 result = (char***)dsmalloc(mem, (*a)<<2, HERE);
 if (!result) { ERR error("smalloc error\n"); return NULL; }
 for (i=0;i<*a;i++)
   {
    result[i] = (char**)dsmalloc(mem, (*b)<<2, HERE);
    if (!result[i])
      {
       for (j=0;j<i;j++) dsfree(mem, (void**)(&result[i]), HERE);
       ERR error("smalloc_i error!\n");
       return NULL;
      }
   }
 for (i=0;i<*b;i++)
   {
    tmp = PQfname(r,i);
    result[0][i] = (char*)dsmalloc(mem, strlen(tmp)+1, HERE);
    if (!result[0][i]) { ERR error("smalloc_namej error"); return NULL; }
    strcpy(result[0][i], tmp);
   }
 for (i=1;i<*a;i++)
 for (j=0;j<*b;j++)
   {
    result[i][j] = (char*)dsmalloc(mem, PQgetlength(r,i-1,j)+1, HERE);
    if (!result[i][j])
      {
       dmem_free_p3c(mem, &result,*a,*b, HERE);
       ERR error("malloc_ij error\n");
       return NULL;
      }
    strcpy(result[i][j], (char*)PQgetvalue(r,i-1,j));
   }
  return result;
 }
}

char*** mem_pgres2pc3(struct mem_list** mem, const PGresult* r, int* a, int* b, int want_meta)
{
 char*** result;
 char* tmp;
 int i,j;
 debug("%s:%d mem_pgres2pc3", __FILE__,__LINE__);
 debug("mem_pgres2pc3: %p\n", (void*)r);
 if (!r) return 0;
 i=j=0;
 *a = PQntuples(r);
 *b = PQnfields(r);
 if (!(*a) || !(*b)) 
   { 
    warn("no cols or no rows (%s:%d)", __FILE__,__LINE__); 
    return NULL; 
   }
 /*printf("ntuples=%d,%d\n", *a,*b);*/
 /*if (!(*a) || !(*b)) { warn("no cols or no rows (%s:%d)", __FILE__,__LINE__); return NULL; }*/
 if (!want_meta)
 {
 result = (char***)smalloc(mem, (*a)<<2);
 if (!result) { ERR error("smalloc error\n"); return NULL; }
 for (i=0;i<*a;i++)
   {
    result[i] = (char**)smalloc(mem, (*b)<<2);
    if (!result[i])
      {
       for (j=0;j<i;j++) sfree(mem, (void**)(&result[i]));
       ERR error("smalloc_i error!\n");
       return NULL;
      }
   }
 for (i=0;i<*a;i++)
 for (j=0;j<*b;j++)
   {
    result[i][j] = (char*)smalloc(mem, PQgetlength(r,i,j)+1);
    if (!result[i][j])
      {
       mem_free_p3c(mem, &result,*a,*b);
       ERR error("malloc_ij error\n");
       return NULL;
      }
    strcpy(result[i][j], (char*)PQgetvalue(r,i,j));
   }
/*#ifdef DEBUG
  debug("char*** result is (%d:%d):\n",i,j);
  for (i=0;i<*a;i++)
    {
     for (j=0;j<*b;j++) debug("%-15s ", result[i][j]);
     ln();
    }
#endif*/
 return result;
 }
 else
 {
  if ((*b)<=0) return NULL;		/*FIXME is it OK? */
 (*a)++;
 result = (char***)smalloc(mem, (*a)<<2);
 if (!result) { ERR error("smalloc error\n"); return NULL; }
 for (i=0;i<*a;i++)
   {
    result[i] = (char**)smalloc(mem, (*b)<<2);
    if (!result[i])
      {
       for (j=0;j<i;j++) sfree(mem, (void**)(&result[i]));
       ERR error("smalloc_i error!\n");
       return NULL;
      }
   }
 for (i=0;i<*b;i++)
   {
    tmp = PQfname(r,i);
    result[0][i] = (char*)smalloc(mem, strlen(tmp)+1);
    if (!result[0][i]) { ERR error("smalloc_namej error"); return NULL; }
    strcpy(result[0][i], tmp);
   }
 for (i=1;i<*a;i++)
 for (j=0;j<*b;j++)
   {
    result[i][j] = (char*)smalloc(mem, PQgetlength(r,i-1,j)+1);
    if (!result[i][j])
      {
       mem_free_p3c(mem, &result,*a,*b);
       ERR error("malloc_ij error\n");
       return NULL;
      }
    strcpy(result[i][j], (char*)PQgetvalue(r,i-1,j));
   }
  return result;
 }
}

char*** dmpgres2pc3(const PGresult* r, int* a, int* b, int want_meta, char* file, int line)
{
 char*** result;
 char* tmp;
 int i,j;
 debug("%s:%d dmpgres2pc3 called from %s:%d", __FILE__,__LINE__,file,line);
 debug("dmpgres2pc3: %p\n", (void*)r);
 if (!r) return 0;
 i=j=0;
 *a = PQntuples(r);
 *b = PQnfields(r);
 /*if (!(*a) || !(*b)) { warn("no cols or no rows (%s:%d)", __FILE__,__LINE__); return NULL; }*/
 if (!(*a) || !(*b)) 
   { 
    warn("no cols or no rows (%s:%d)", __FILE__,__LINE__); 
    return NULL; 
   }
 /*printf("ntuples=%d,%d\n", *a,*b);*/
 if (!want_meta)
 {
 result = (char***)dmmalloc((*a)<<2, HERE);
 if (!result) { ERR error("mmalloc error\n"); return NULL; }
 for (i=0;i<*a;i++)
  {
    result[i] = (char**)dmmalloc((*b)<<2, HERE);
    if (!result[i])
      {
       for (j=0;j<i;j++) 
       {
	 dmfree((void**)(&result[i]), HERE);
       }
       ERR error("mmalloc_i error!\n");
       return NULL;
      }
   }
 for (i=0;i<*a;i++)
 for (j=0;j<*b;j++)
   {
    result[i][j] = (char*)dmmalloc(PQgetlength(r,i,j)+1, HERE);
    if (!result[i][j])
      {
       dmfree_p3c(&result,*a,*b, HERE);
       ERR error("mmalloc_ij error\n");
       return NULL;
      }
    strcpy(result[i][j], (char*)PQgetvalue(r,i,j));
   }
/*#ifdef DEBUG
  debug("char*** result is (%d:%d):\n",i,j);
  for (i=0;i<*a;i++)
    {
     for (j=0;j<*b;j++) debug("%-15s ", result[i][j]);
     ln();
    }
#endif*/
 return result;
 }
 else
 {
  if ((*b)<=0) return NULL;		/*FIXME is it OK? */
 (*a)++;
 result = (char***)dmmalloc((*a)<<2, HERE);
 if (!result) { ERR error("mmalloc error\n"); return NULL; }
 for (i=0;i<*a;i++)
   {
    result[i] = (char**)dmmalloc((*b)<<2, HERE);
    if (!result[i])
      {
       for (j=0;j<i;j++) 
         {
	  dmfree((void**)(&result[i]), HERE);
	 }
       ERR error("mmalloc_i error!\n");
       return NULL;
      }
   }
 for (i=0;i<*b;i++)
   {
    tmp = PQfname(r,i);
    result[0][i] = (char*)dmmalloc(strlen(tmp)+1, HERE);
    if (!result[0][i]) { ERR error("mmalloc_namej error"); return NULL; }
    strcpy(result[0][i], tmp);
   }
 for (i=1;i<*a;i++)
 for (j=0;j<*b;j++)
   {
    result[i][j] = (char*)dmmalloc(PQgetlength(r,i-1,j)+1, HERE);
    if (!result[i][j])
      {
       dmfree_p3c(&result,*a,*b, HERE);
       ERR error("mmalloc_ij error\n");
       return NULL;
      }
    strcpy(result[i][j], (char*)PQgetvalue(r,i-1,j));
   }
  return result;
 }
}

char*** mpgres2pc3(const PGresult* r, int* a, int* b, int want_meta)
{
 char*** result;
 char* tmp;
 int i,j;
 debug("%s:%d mpgres2pc3", __FILE__,__LINE__);
 debug("mpgres2pc3: %p\n", (void*)r);
 if (!r) return 0;
 i=j=0;
 *a = PQntuples(r);
 *b = PQnfields(r);
 /*if (!(*a) || !(*b)) { warn("no cols or no rows (%s:%d)", __FILE__,__LINE__); return NULL; }*/
 if (!(*a) || !(*b)) 
   { 
    warn("no cols or no rows (%s:%d)", __FILE__,__LINE__); 
    return NULL; 
   }
 /*printf("ntuples=%d,%d\n", *a,*b);*/
 if (!want_meta)
 {
 result = (char***)mmalloc((*a)<<2);
 if (!result) { ERR error("mmalloc error\n"); return NULL; }
 for (i=0;i<*a;i++)
  {
    result[i] = (char**)mmalloc((*b)<<2);
    if (!result[i])
      {
       for (j=0;j<i;j++) 
       {
	 mfree((void**)(&result[i]));
       }
       ERR error("mmalloc_i error!\n");
       return NULL;
      }
   }
 for (i=0;i<*a;i++)
 for (j=0;j<*b;j++)
   {
    result[i][j] = (char*)mmalloc(PQgetlength(r,i,j)+1);
    if (!result[i][j])
      {
       mfree_p3c(&result,*a,*b);
       ERR error("mmalloc_ij error\n");
       return NULL;
      }
    strcpy(result[i][j], (char*)PQgetvalue(r,i,j));
   }
/*#ifdef DEBUG
  debug("char*** result is (%d:%d):\n",i,j);
  for (i=0;i<*a;i++)
    {
     for (j=0;j<*b;j++) debug("%-15s ", result[i][j]);
     ln();
    }
#endif*/
 return result;
 }
 else
 {
  if ((*b)<=0) return NULL;		/*FIXME is it OK? */
 (*a)++;
 result = (char***)mmalloc((*a)<<2);
 if (!result) { ERR error("mmalloc error\n"); return NULL; }
 for (i=0;i<*a;i++)
   {
    result[i] = (char**)mmalloc((*b)<<2);
    if (!result[i])
      {
       for (j=0;j<i;j++) 
         {
	  mfree((void**)(&result[i]));
	 }
       ERR error("mmalloc_i error!\n");
       return NULL;
      }
   }
 for (i=0;i<*b;i++)
   {
    tmp = PQfname(r,i);
    result[0][i] = (char*)mmalloc(strlen(tmp)+1);
    if (!result[0][i]) { ERR error("mmalloc_namej error"); return NULL; }
    strcpy(result[0][i], tmp);
   }
 for (i=1;i<*a;i++)
 for (j=0;j<*b;j++)
   {
    result[i][j] = (char*)mmalloc(PQgetlength(r,i-1,j)+1);
    if (!result[i][j])
      {
       mfree_p3c(&result,*a,*b);
       ERR error("mmalloc_ij error\n");
       return NULL;
      }
    strcpy(result[i][j], (char*)PQgetvalue(r,i-1,j));
   }
  return result;
 }
}

char*** pgres2pc3(const PGresult* r, int* a, int* b, int want_meta)
{
 char*** result;
 char* tmp;
 int i,j;
 debug("%s:%d pgres2pc3", __FILE__,__LINE__);
 debug("pgres2pc3: %p\n", (void*)r);
 if (!r) return 0;
 i=j=0;
 *a = PQntuples(r);
 *b = PQnfields(r);
 if (!(*a) || !(*b)) 
   { 
    warn("no cols or no rows (%s:%d)", __FILE__,__LINE__); 
    return NULL; 
   }
 /*printf("ntuples=%d,%d\n", *a,*b);*/
 if (!want_meta)
 {
 result = (char***)malloc((*a)<<2);
 if (!result) { ERR error("malloc error\n"); return NULL; }
 for (i=0;i<*a;i++)
   {
    result[i] = (char**)malloc((*b)<<2);
    if (!result[i])
      {
       for (j=0;j<i;j++) free(result[i]);
       ERR error("malloc_i error!\n");
       return NULL;
      }
   }
 for (i=0;i<*a;i++)
 for (j=0;j<*b;j++)
   {
    result[i][j] = (char*)malloc(PQgetlength(r,i,j)+1);
    if (!result[i][j])
      {
       free_p3c(&result,*a,*b);
       ERR error("malloc_ij error\n");
       return NULL;
      }
    strcpy(result[i][j], (char*)PQgetvalue(r,i,j));
   }
/*#ifdef DEBUG
  debug("char*** result is (%d:%d):\n",i,j);
  for (i=0;i<*a;i++)
    {
     for (j=0;j<*b;j++) debug("%-15s ", result[i][j]);
     ln();
    }
#endif*/
 return result;
 }
 else
 {
  if ((*b)<=0) return NULL;		/*FIXME is it OK? */
 (*a)++;
 result = (char***)malloc((*a)<<2);
 if (!result) { ERR error("malloc error\n"); return NULL; }
 for (i=0;i<*a;i++)
   {
    result[i] = (char**)malloc((*b)<<2);
    if (!result[i])
      {
       for (j=0;j<i;j++) free(result[i]);
       ERR error("malloc_i error!\n");
       return NULL;
      }
   }
 for (i=0;i<*b;i++)
   {
    tmp = PQfname(r,i);
    result[0][i] = (char*)malloc(strlen(tmp)+1);
    if (!result[0][i]) { ERR error("malloc_namej error"); return NULL; }
    strcpy(result[0][i], tmp);
   }
 for (i=1;i<*a;i++)
 for (j=0;j<*b;j++)
   {
    result[i][j] = (char*)malloc(PQgetlength(r,i-1,j)+1);
    if (!result[i][j])
      {
       free_p3c(&result,*a,*b);
       ERR error("malloc_ij error\n");
       return NULL;
      }
    strcpy(result[i][j], (char*)PQgetvalue(r,i-1,j));
   }
  return result;
 }
}

void mem_free_p3c(struct mem_list** mem, char**** p, int a, int b)
{
 int i,j;
 debug("%s:%d mem_free_p3c", __FILE__,__LINE__);
 debug("mem_free_p3c: ****p=%p, a=%d, b=%d\n",(void*)p,a,b);
 if (!(*p)) return ;
 for (i=0;i<a;i++) if (!(*p)[i]) return ;
 for (i=0;i<a;i++)
 for (j=0;j<b;j++) if ((*p)[i][j]) sfree(mem, (void**)(&(*p)[i][j]));
 for (i=0;i<a;i++) if ((*p)[i])    sfree(mem, (void**)(&(*p)[i]));
 sfree(mem, (void**)(&(*p)));
}

void dmem_free_p3c(struct dmem_list** mem, char**** p, int a, int b, char* file, int line)
{
 int i,j;
 debug("%s:%d dmem_free_p3c called from %s:%d", __FILE__,__LINE__,file,line);
 debug("dmem_free_p3c: ****p=%p, a=%d, b=%d\n",(void*)p,a,b);
 if (!(*p)) return ;
 for (i=0;i<a;i++) if (!(*p)[i]) return ;
 for (i=0;i<a;i++)
 for (j=0;j<b;j++) if ((*p)[i][j]) dsfree(mem, (void**)(&(*p)[i][j]), HERE);
 for (i=0;i<a;i++) if ((*p)[i])    dsfree(mem, (void**)(&(*p)[i]), HERE);
 dsfree(mem, (void**)(&(*p)), HERE);
}

void mfree_p3c(char**** p, int a, int b)
{
 int i,j;
 debug("%s:%d mfree_p3c", __FILE__,__LINE__);
 debug("mfree_p3c: ****p=%p, a=%d, b=%d\n",(void*)p,a,b);
 if (!(*p)) return ;
 for (i=0;i<a;i++) if (!(*p)[i]) return ;
 for (i=0;i<a;i++)
 for (j=0;j<b;j++) if ((*p)[i][j]) mfree((void**)(&(*p)[i][j]));
 for (i=0;i<a;i++) if ((*p)[i])    mfree((void**)(&(*p)[i]));
 mfree((void**)(&(*p)));
}

void dmfree_p3c(char**** p, int a, int b, char* file, int line)
{
 int i,j;
 debug("%s:%d dmfree_p3c called from: %s:%d", __FILE__,__LINE__,file,line);
 debug("dmfree_p3c: ****p=%p, a=%d, b=%d\n",(void*)p,a,b);
 if (!(*p)) return ;
 for (i=0;i<a;i++) if (!(*p)[i]) return ;
 for (i=0;i<a;i++)
 for (j=0;j<b;j++) if ((*p)[i][j]) dmfree((void**)(&(*p)[i][j]), HERE);
 for (i=0;i<a;i++) if ((*p)[i])    dmfree((void**)(&(*p)[i]), HERE);
 dmfree((void**)(&(*p)), HERE);
}

void free_p3c(char**** p, int a, int b)
{
 int i,j;
 debug("%s:%d free_p3c", __FILE__,__LINE__);
 debug("free_p3c: ****p=%p, a=%d, b=%d\n",(void*)p,a,b);
 if (!(*p)) return ;
 for (i=0;i<a;i++) if (!(*p)[i]) return ;
 for (i=0;i<a;i++)
 for (j=0;j<b;j++) if ((*p)[i][j]) free((*p)[i][j]);
 for (i=0;i<a;i++) if ((*p)[i])    free((*p)[i]);
 free(*p);
}

