<?php 
//	File:		tbl_form.inc.php
//	Purpose:		Display the form for editing/inserting/selecting from a table
//	Author:		Dan Wilson
//	Date:		19 Feb 2000

$sql_get_fields = "
	SELECT 
		a.attnum,
		a.attname AS field, 
		t.typname AS type, 
		a.attlen AS length,
		a.atttypmod AS lengthvar,
		a.attnotnull AS notnull,
		a.atthasdef as hasdefault
	FROM 
		pg_class c, 
		pg_attribute a, 
		pg_type t
	WHERE 
		c.relname = '$table'
		and a.attnum > 0
		and a.attrelid = c.oid
		and a.atttypid = t.oid
";

if ($cfgDoOrder) {
	$sql_get_fields .= "
		ORDER BY
			attname
	";
} else {
	$sql_get_fields .= "
		ORDER BY
			attnum
	";
}

$table_def = pg_exec($link, $sql_get_fields);
if (!empty($primary_key)) {
	$primary_key = stripslashes($primary_key);
	$result = @pg_exec($link, "SELECT * FROM $cfgQuotes$table$cfgQuotes WHERE " . urldecode($primary_key)) or pg_die(pg_errormessage($link));
	$row = @pg_fetch_array($result, 0);
} else {
	$result = @pg_exec($link, "SELECT * FROM $cfgQuotes$table$cfgQuotes LIMIT 1") or pg_die(pg_errormessage());
}
if (!$table_def) {
	pg_die(pg_errormessage());
} else {

	if (isset($primary_key)) {
		echo '<input type="hidden" name="primary_key" value="' . htmlspecialchars($primary_key) . '">' . "\n";
	}
?>
	<table border="<?php echo $cfgBorder;?>">
	<tr>
	<th><?php echo $strField; ?></th>
	<th><?php echo $strType; ?></th>
	<th><?php echo $strFunction; ?></th>
	<th><?php echo $strValue; ?></th>
	</tr>
<?php

	for ($i = 0; $i < pg_numrows($table_def); $i++) {
	
		$row_table_def = pg_fetch_array($table_def, $i);
		$field = $row_table_def["field"];
		if (($row_table_def["type"]  == "timestamp") && (empty($row[$field])) && ($show_defaults)) {
			$row[$field] = date("Y-m-d H:i:s", time());
		}
		if (($row_table_def["type"]  == "date") && (empty($row[$field])) && ($show_defaults)) {
			$row[$field] = date("Y-m-d", time());
		}
		if ($row_table_def["lengthvar"] > 0) {
			$len = $row_table_def["lengthvar"] - 4;
		} else if ($row_table_def["length"] > 0) {
			$len = $row_table_def["length"];
		} else {
			unset($len);
		}

		unset($selected_func);
		unset($funcs);

		if (!$edit && $row_table_def["hasdefault"] == "t"  && ($show_defaults)) {
			$sql_get_default = "
				SELECT d.adsrc AS \"default_val\"
				FROM pg_attrdef d, pg_class c 
				WHERE 
					c.relname = '$table' AND 
					c.oid = d.adrelid AND
					d.adnum = $row_table_def[attnum]
			";
			// echo "<p>", $sql_get_default, "<p>";
			if (!$def_res = @pg_exec($link, $sql_get_default)) {
				pg_die(pg_errormessage(), $sql_get_default);
				unset($row[$field]);
			} else {
				if (pg_numrows($def_res) > 0) {
					$row[$field] = @pg_result($def_res, 0, "default_val");
					if (eregi("(nextval|curval)", $row[$field], $func_type)) {
						eregi("'([A-Za-z_]+)'", $row[$field], $vals);
						$selected_func = $func_type[1];
						$row[$field] = $vals[1];
					}
				} else {
					unset($row[$field]);
				}
			}
			$row[$field] = ereg_replace("^'|'$", "", $row[$field]);
		}


		$bgcolor = $cfgBgcolorOne;
		$i % 2  ? 0: $bgcolor = $cfgBgcolorTwo;
		echo "<tr bgcolor=".$bgcolor.">\n";
		echo "<td valign=\"top\">$field</td>\n";       
		echo "<td valign=\"top\">$row_table_def[type] <input type=hidden name=field_type[$field] value=\"$row_table_def[type]\"></td>\n";
		echo "<td valign=\"top\"><select name=funcs[$field]><option>\n";
		for ($j = 0; $j < count($cfgFunctions); $j++) {
			if (trim(strtoupper($cfgFunctions[$j])) == trim(strtoupper($selected_func))) {
				echo "<option selected>$cfgFunctions[$j]\n";
			} else {
				echo "<option>$cfgFunctions[$j]\n";
			}
		}
		echo "</select></td>\n";
		
		if (isset($row) && isset($row[$field]))
			$special_chars = htmlspecialchars($row[$field]);
		else
			unset($special_chars);
			
		if (strstr($row_table_def["type"], "text")) {
			echo "<td><textarea name=fields[$field] style=\"width:$cfgMaxInputsize;\" rows=5>$special_chars</textarea></td>\n";
		} else if (strstr($row_table_def["type"], "varchar") && $len > 50) {
			echo "<td><textarea name=fields[$field] style=\"width:$cfgMaxInputsize;\" rows=5>$special_chars</textarea></td>\n";
		} else if (strstr($row_table_def["type"], "bool")) {
			echo "<td><select name=fields[$field]>";
			if ($special_chars == "'t'" || $special_chars == "t") {
				echo "<option value=\"t\" selected>$strYes";
				echo "<option value=\"f\">$strNo";
			} else if ($special_chars == "'f'" || $special_chars == "f"){
				echo "<option value=\"t\">$strYes";
				echo "<option value=\"f\" selected>$strNo";
			} else {
				echo "<option value=\"\">";
				echo "<option value=\"t\">$strYes";
				echo "<option value=\"f\">$strNo";
			}
			echo "</select></td>\n";
		} else {
			if (ereg("char", $row_table_def["type"])) {
				$maxlen = $len;
			} else {
				unset($maxlen);
			}
			echo "<td><input type=text name=fields[$field] value=\"".$special_chars."\" style=\"width:$cfgMaxInputsize;\" maxlength=$maxlen></td>";
		}
		echo "</tr>\n";
	}
echo "</table>";
}
?>
