<?php // $Id: banner-edit.php,v 1.12 2001/05/12 14:13:22 ciaccia Exp $ - #phpAdsNew Revision: 1.15 #

/************************************************************************/
/* phpPgAds                                                             */
/* ========                                                             */
/*                                                                      */
/* Copyright (c) 2001 by Matteo Beccati                                 */
/* http://www.greatbridge.org/project/phppgads/                         */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/

// Include required files
require ("config.php");
require ("lib-statistics.inc.php");
require ("lib-storage.inc.php");


// Security check
phpAds_checkAccess(phpAds_Admin+phpAds_Client);



/*********************************************************/
/* Client interface security                             */
/*********************************************************/

if (phpAds_isUser(phpAds_Client))
{
	$result = db_query("
		SELECT
			clientID
		FROM
			$phpAds_tbl_banners
		WHERE
			bannerID = $bannerID
		") or pg_die();
	$row = pg_fetch_array($result, 0);
	
	if($row["clientid"] != phpAds_clientID())
	{
		phpAds_PageHeader($strModifyBanner);
		phpAds_ShowNav("2.4");
		php_die ($strAccessDenied, $strNotAdmin);
	}
	else
	{
		$clientID = phpAds_clientID();
	}
}




/*********************************************************/
/* Process submitted form                                */
/*********************************************************/

if (isset($submit))
{
	// Clean up old webserver stored banner
	if (isset($web_banner_cleanup) && $web_banner_cleanup != "")
	{
		if (($bannertype == "web" && !empty($web_banner) && $web_banner != "none") OR ($bannertype != "web"))
		{
			phpAds_Cleanup($web_banner_cleanup);
		}
	}

	// Do all this in a transaction to avoid misalignements between 
	// large objects and tables
	db_query("BEGIN");
	
	switch($bannertype) 
	{
		case "pgsql":
			if (!empty($pgsql_banner) && $pgsql_banner != "none")
			{
				$size = GetImageSize($pgsql_banner);
				$final["width"] = $size[0];
				$final["height"] = $size[1];
				$ext = substr($pgsql_banner_name, strrpos($pgsql_banner_name, ".")+1);
				switch (strtoupper($ext)) 
				{
					case "JPEG":
						$final["format"] = "jpeg";
						break;
					case "JPG":
						$final["format"] = "jpeg";
						break;
					case "HTML":
						$final["format"] = "html";
						break;
					case "PNG":
						$final["format"] = "png";
						break;
					case "GIF":
						$final["format"] = "gif";
						break;
				}
				
				$oid = pg_loimport($pgsql_banner, $link);
				$final["banner"] = $oid ? "oid:$oid" : "";
				
			}
			$final["alt"] = addslashes($pgsql_alt);
			$final["bannertext"] = addslashes($pgsql_bannertext);
			$final["url"] = $pgsql_url;
			break;
		case "web":
			if (!empty($web_banner) && $web_banner != "none")
			{
				$size = GetImageSize($web_banner);
				$final["width"] = $size[0];
				$final["height"] = $size[1];
				
				// upload $web_banner file to location
				// set banner to web location
				$final["banner"] = phpAds_Store($web_banner, basename($web_banner_name));
			}
			$final["format"] = "web";
			$final["alt"] = addslashes($web_alt);
			$final["bannertext"] = addslashes($web_bannertext);
			$final["url"] = $web_url;
			break;
		case "url":
			$final["width"] = $url_width;
			$final["height"] = $url_height;
			$final["format"] = "url";
			$final["banner"] = $url_banner;
			$final["alt"] = addslashes($url_alt);
			$final["bannertext"] = addslashes($url_bannertext);
			$final["url"] = $url_url;
			break;
		case "html";
			$final["width"] = $html_width;
			$final["height"] = $html_height;
			$final["format"] = "html";
			$final["banner"] = addslashes($html_banner);
			$final["alt"] = "";
			$final["bannertext"] = "";
			$final["url"] = $html_url;
			break;
	}
	$final["clientid"] = $clientID;
// modified by Tudor Barbarosie
	if (!empty($bannerID)) $final["bannerid"] = $bannerID;
// end modified by Tudor Barbarosie	
	
	if (phpAds_isUser(phpAds_Admin)) 
	{
		$final["active"] = "t";
		$final["keyword"] = $keyword;
		$final["description"] = addslashes($description);
		$final["weight"] = $weight;
	}
	
	// Don't add an empty banner
	if (empty($final["banner"]) || $final["banner"] == "none")
		unset($final["banner"]);
	
	$message = $bannerID=='' ? $strBannerAdded : $strBannerModified;
	
	// Construct appropiate SQL query
	// If bannerID==null, then this is an INSERT, else it's an UPDATE
	if ($final["bannerid"] == '')
	{ 
		// INSERT
		$values_fields = "";
		$values = "";
		while (list($name, $value) = each($final))
		{
			if ($name == "bannerid") continue;
			$values_fields .= "$name, ";
			$values .= "'$value', ";
		}
		
		// Cut trailing commas
		$values_fields = ereg_replace(", $", "", $values_fields);
		$values = ereg_replace(", $", "", $values);
   		
		// Execute query
		$sql_query = "
			INSERT INTO
				$phpAds_tbl_banners
				($values_fields)
			VALUES
			($values)";
		$res = db_query($sql_query) or pg_die();     
	}
	else 
	{
		// UPDATE
		$set = "";
		while (list($name, $value) = each($final))
		{
			$set .= "$name = '$value', ";
		}
		
		// Cut trailing commas
		$set = ereg_replace(", $", "", $set);

		// Check if banner was previously storeid in a Postres large object
		$res = @db_query("SELECT banner FROM $phpAds_tbl_banners".
			" WHERE bannerID = ".$final['bannerid']) or pg_die();
				
		if (ereg("^oid:([0-9]+)$", pg_result($res, 0, 0), $match))
			{
			// If so discards the old banner
			pg_lounlink($link, $match[1]);
			}
		
		// Execute query
		$sql_query = "
			UPDATE
				$phpAds_tbl_banners
			SET
				$set
			WHERE
				bannerID = ".$final['bannerid'];
		$res = @db_query($sql_query) or pg_die();     
		
	}
	
	db_query("END");

	if (phpAds_isUser(phpAds_Client))
	{
		Header("Location: stats-client.php?clientID=$clientID");
		session_register("message");
	}
	else
	{
		Header("Location: banner-client.php?clientID=$clientID");
		session_register("message");
	}
	
	exit;
}



/*********************************************************/
/* HTML framework                                        */
/*********************************************************/

if ($bannerID != '')
{
	phpAds_PageHeader("$strModifyBanner");
	
	$extra = '';
	
	$res = db_query("
	SELECT
		*
	FROM
		$phpAds_tbl_banners
	WHERE
		clientID = ".$GLOBALS['clientID']."
	") or pg_die();

	$extra = "";	
	for ($pgc = 0; $row = @pg_fetch_array($res, $pgc); $pgc++)
	{
		if ($bannerID == $row['bannerid'])
			$extra .= "&nbsp;&nbsp;&nbsp;<img src='images/box-1.gif'>&nbsp;";
		else
			$extra .= "&nbsp;&nbsp;&nbsp;<img src='images/box-0.gif'>&nbsp;";
		
		$extra .= "<a href='banner-edit.php?clientID=$clientID&bannerID=".$row['bannerid']."'>";
		$extra .= phpAds_buildBannerName ($row['bannerid'], $row['description'], $row['alt']);		
		$extra .= "</a>";
		$extra .= "<br>"; 
	}
	$extra .= "<img src='images/break.gif' height='1' width='160' vspace='4'><br>";

	if (phpAds_isUser(phpAds_Admin))
	{
		$extra .= "<br><br><br><br><br>";
		$extra .= "<b>$strShortcuts</b><br>";
		$extra .= "<img src='images/break.gif' height='1' width='160' vspace='4'><br>";
		$extra .= "<img src='images/caret-rs.gif'>&nbsp;<a href=client-edit.php?clientID=$clientID>$strModifyClient</a><br>";
		$extra .= "<img src='images/break.gif' height='1' width='160' vspace='4'><br>";
		$extra .= "<img src='images/caret-rs.gif'>&nbsp;<a href=stats-client.php?clientID=$clientID>$strStats</a><br>";
		$extra .= "&nbsp;&nbsp;&nbsp;<img src='images/caret-rs.gif'>&nbsp;<a href=stats-details.php?clientID=$clientID&bannerID=$bannerID>$strDetailStats</a><br>";
		$extra .= "&nbsp;&nbsp;&nbsp;<img src='images/caret-rs.gif'>&nbsp;<a href=stats-weekly.php?clientID=$clientID>$strWeeklyStats</a><br>";
		$extra .= "<img src='images/break.gif' height='1' width='160' vspace='4'><br>";
		
		phpAds_ShowNav("1.3.2", $extra);
	}
	else
	{
		phpAds_ShowNav("2.4", $extra);
	}
	
	
	$res = db_query("
		SELECT
			*
		FROM
			$phpAds_tbl_banners
		WHERE
			bannerID = $bannerID
		") or pg_die();
	$row = pg_fetch_array($res, 0);
	
	if (ereg("gif|png|jpeg", $row["format"]))
		$type = "pgsql";
	else
		$type = $row["format"];
}
else
{
	phpAds_PageHeader("$strAddBanner");
	phpAds_ShowNav("1.3.1");   

	$row['alt'] = "";
	$row['bannertext'] = "";
	$row['url'] = "";
}



/*********************************************************/
/* Main code                                             */
/*********************************************************/

// Determine if the browser supports DHTML

if (!ereg ("Mozilla/4", $HTTP_USER_AGENT) || ereg ("IE", $HTTP_USER_AGENT))
	$dhtml = true;
else
	$dhtml = false;

// Determine which bannertypes to show
$show_sql  = $phpAds_type_sql_allow;
$show_web  = $phpAds_type_web_allow;
$show_url  = $phpAds_type_url_allow;
$show_html = $phpAds_type_html_allow;
if ($type == "pgsql") $show_sql  = true;
if ($type == "web")   $show_web  = true;
if ($type == "url")   $show_url  = true;
if ($type == "html")  $show_html = true;

// If adding a new banner or used storing type is disabled
// determine which bannertype to show as default

$show_type = "show_$type";

if (!isset($type) || !$$show_type)
{
	if ($show_html) $type = "html"; 
	if ($show_url)  $type = "url"; 
	if ($show_web)  $type = "web"; 
	if ($show_sql)  $type = "pgsql"; 
}
?>


<script language='Javascript'>
<!--
    function show(n)
    {
		pgsqlObject = findObj ('pgsqlForm');
		htmlObject = findObj ('htmlForm');
		urlObject = findObj ('urlForm');
		webObject = findObj ('webForm');
	
        ss="none"; sh="none"; su="none"; sw="none"
        if (n=='pgsql') {
          ss="";
        } else if (n=='web') {
          sw="";
        } else if (n=='url') {
          su="";
        } else {
          sh="";
        }
	
		if (pgsqlObject) pgsqlObject.style.display=ss;
		if (htmlObject) htmlObject.style.display=sh;
		if (urlObject) urlObject.style.display=su;
		if (webObject) webObject.style.display=sw;

    }
//-->
</script>
    



<table width='100%' border="0" align="center" cellspacing="0" cellpadding="0">
  <tr><td height='25' colspan='4'>
  <? 
	if ($bannerID != '')
		echo "<b>$strBanner: ".phpAds_getBannerName($bannerID)."</b> <img src='images/caret-rs.gif'> ";
		echo $strClientName.': '.phpAds_getClientName($clientID);
  ?>
  </td></tr>
  <tr height='1'><td colspan='4' bgcolor='#888888'><img src='images/break.gif' height='1' width='100%'></td></tr>
  <?
	if ($bannerID != '')
		echo "<tr><td colspan='4' align='left'><br>".phpAds_getBannerCode($bannerID)."<br><br></td></tr>";
  ?>
</table>

<br><br>

<form action="<?echo basename($PHP_SELF);?>" method="POST" enctype="multipart/form-data">
<input type="hidden" name="clientID" value="<? echo ($clientID) ?>">
<input type="hidden" name="bannerID" value="<? echo ($bannerID) ?>">

<? if ($dhtml) { ?>
<table border='0' width='100%' cellpadding='0' cellspacing='0'>
	<tr><td height='25' colspan='3'><b><?echo $strChooseBanner;?></b></td></tr>
	<tr><td height='1' colspan='3' bgcolor='#888888'><img src='images/break.gif' height='1' width='100%'></td></tr>
	<tr>
		<td height='35'>
			<select name='bannertype' onChange='show(this.options[this.selectedIndex].value);'>
				<?if ($show_sql) { ?><option value='pgsql'<?if ($type == "pgsql") echo " selected";?>><?echo $strPgSQLBanner;?></option><? } ?>
				<?if ($show_web) { ?><option value='web'<?if ($type == "web") echo " selected";?>><?echo $strWebBanner;?></option><? } ?>
				<?if ($show_url) { ?><option value='url'<?if ($type == "url") echo " selected";?>><?echo $strURLBanner;?></option><? } ?>
				<?if ($show_html) { ?><option value='html'<?if ($type == "html") echo " selected";?>><?echo $strHTMLBanner;?></option><? } ?>
			</select>
		</td>
	</tr>	
</table>
<br><br>
<? }?>	


<?if ($show_sql) {?>
<?if ($dhtml) {?><div id="pgsqlForm" <?if (isset($type) && $type != "pgsql") echo 'style="display:none"';?>><?}?>
<table border='0' width='100%' cellpadding='0' cellspacing='0' bgcolor='#F6F6F6'>
	<?if ($dhtml) {?>
		<tr><td height='25' colspan='3' bgcolor='#FFFFFF'><b><?echo $strPgSQLBanner;?></b></td></tr>
	<?} else {?>
		<tr><td height='25' colspan='3' bgcolor='#FFFFFF'>
		<input type='radio' name='bannertype' value='pgsql'<? if ($type == "pgsql") echo " checked";?>>
		<b><?echo $strPgSQLBanner;?></b></td></tr>
	<?}?>
	<tr><td height='1' colspan='3' bgcolor='#888888'><img src='images/break.gif' height='1' width='100%'></td></tr>
	<tr><td height='10' colspan='3'>&nbsp;</td></tr>

	<tr>
		<td width='30'>&nbsp;</td>
		<td width='200'><?echo $strNewBannerFile;?></td>
		<td><input size="26" type="file" name="pgsql_banner" style="width:350px;"></td>
	</tr>
	<tr>
		<td><img src='images/spacer.gif' height='1' width='100%'></td>
		<td colspan='2'><img src='images/break-l.gif' height='1' width='200' vspace='6'></td>
	</tr>
	<tr>
		<td width='30'>&nbsp;</td>
		<td width='200'><?echo $strURL;?></td>
    	<td><input size="35" type="text" name="pgsql_url" style="width:350px;" value="<?if (isset($type) && $type == "pgsql") echo $row["url"];?>"></td>
	</tr>
	<tr>
		<td><img src='images/spacer.gif' height='1' width='100%'></td>
		<td colspan='2'><img src='images/break-l.gif' height='1' width='200' vspace='6'></td>
	</tr>
	<tr>
		<td width='30'>&nbsp;</td>
		<td width='200'><?echo $strAlt;?></td>
		<td><input size="35" type="text" name="pgsql_alt" style="width:350px;" value="<?if (isset($type) && $type == "pgsql") echo $row["alt"];?>"></td>
	</tr>
	<tr>
		<td><img src='images/spacer.gif' height='1' width='100%'></td>
		<td colspan='2'><img src='images/break-l.gif' height='1' width='200' vspace='6'></td>
	</tr>
	<tr>
		<td width='30'>&nbsp;</td>
		<td width='200'><?echo $strTextBelow;?></td>
		<td><input size="35" type="text" name="pgsql_bannertext" style="width:350px;" value="<?if (isset($type) && $type == "pgsql") echo $row["bannertext"];?>"></td>
	</tr>

	<tr><td height='20' colspan='3'>&nbsp;</td></tr>
	<tr><td height='1' colspan='3' bgcolor='#888888'><img src='images/break.gif' height='1' width='100%'></td></tr>
</table>
<?if ($dhtml) {?></div><?} else {?><br><br><?}?>
<?}?>


<?if ($show_web) {?>
<?if ($dhtml) {?><div id="webForm" <?if (isset($type) && $type != "web") echo 'style="display:none"';?>><?}?>
<table border='0' width='100%' cellpadding='0' cellspacing='0' bgcolor='#F6F6F6'>
	<?if ($dhtml) {?>
		<tr><td height='25' colspan='3' bgcolor='#FFFFFF'><b><?echo $strWebBanner;?></b></td></tr>
	<?} else {?>
		<tr><td height='25' colspan='3' bgcolor='#FFFFFF'>
		<input type='radio' name='bannertype' value='web'<?if ($type == "web") echo " checked";?>>
		<b>Banner stored on the webserver</b></td></tr>
	<?}?>
	<tr><td height='1' colspan='3' bgcolor='#888888'><img src='images/break.gif' height='1' width='100%'></td></tr>
	<tr><td height='10' colspan='3'>&nbsp;</td></tr>

	<tr>
		<td width='30'>&nbsp;</td>
		<td width='200'><?echo $strNewBannerFile;?></td>
		<td><input size="26" type="file" name="web_banner" style="width:350px;">
			<input type="hidden" name="web_banner_cleanup" value="<?if (isset($type) && $type == "web") echo basename($row["banner"]);?>"></td>
	</tr>
	<tr>
		<td><img src='images/spacer.gif' height='1' width='100%'></td>
		<td colspan='2'><img src='images/break-l.gif' height='1' width='200' vspace='6'></td>
	</tr>
	<tr>
		<td width='30'>&nbsp;</td>
		<td width='200'><?echo $strURL;?></td>
    	<td><input size="35" type="text" name="web_url" style="width:350px;" value="<?if (isset($type) && $type == "web") echo $row["url"];?>"></td>
	</tr>
	<tr>
		<td><img src='images/spacer.gif' height='1' width='100%'></td>
		<td colspan='2'><img src='images/break-l.gif' height='1' width='200' vspace='6'></td>
	</tr>
	<tr>
		<td width='30'>&nbsp;</td>
		<td width='200'><?echo $strAlt;?></td>
		<td><input size="35" type="text" name="web_alt" style="width:350px;" value="<?if (isset($type) && $type == "web") echo $row["alt"];?>"></td>
	</tr>
	<tr>
		<td><img src='images/spacer.gif' height='1' width='100%'></td>
		<td colspan='2'><img src='images/break-l.gif' height='1' width='200' vspace='6'></td>
	</tr>
	<tr>
		<td width='30'>&nbsp;</td>
		<td width='200'><?echo $strTextBelow;?></td>
		<td><input size="35" type="text" name="web_bannertext" style="width:350px;" value="<?if (isset($type) && $type == "web") echo $row["bannertext"];?>"></td>
	</tr>

	<tr><td height='20' colspan='3'>&nbsp;</td></tr>
	<tr><td height='1' colspan='3' bgcolor='#888888'><img src='images/break.gif' height='1' width='100%'></td></tr>
</table>
<?if ($dhtml) {?></div><?} else {?><br><br><?}?>
<?}?>


<?if ($show_url) {?>
<?if ($dhtml) {?><div id="urlForm" <?if (!isset($type) || $type != "url") echo 'style="display:none"';?>><?}?>
<table border='0' width='100%' cellpadding='0' cellspacing='0' bgcolor='#F6F6F6'>
	<?if ($dhtml) {?>
		<tr><td height='25' colspan='3' bgcolor='#FFFFFF'><b><?echo $strURLBanner;?></b></td></tr>
	<?} else {?>
		<tr><td height='25' colspan='3' bgcolor='#FFFFFF'>
		<input type='radio' name='bannertype' value='url'<?if ($type == "url") echo " checked";?>>
		<b><?echo $strURLBanner;?></b></td></tr>
	<?}?>
	<tr><td height='1' colspan='3' bgcolor='#888888'><img src='images/break.gif' height='1' width='100%'></td></tr>
	<tr><td height='10' colspan='3'>&nbsp;</td></tr>

	<tr>
		<td width='30'>&nbsp;</td>
		<td width='200'><?echo $strNewBannerURL;?></td>
		<td><input size="35" type="text" name="url_banner" style="width:350px;" value="<?if (isset($type) && $type == "url") echo $row["banner"];?>"></td>
	</tr>
	<tr>
		<td><img src='images/spacer.gif' height='1' width='100%'></td>
		<td colspan='2'><img src='images/break-l.gif' height='1' width='200' vspace='6'></td>
	</tr>
	<tr>
		<td width='30'>&nbsp;</td>
		<td width='200'><?echo $strURL;?></td>
		<td><input size="35" type="text" name="url_url" style="width:350px;" value="<?if (isset($type) && $type == "url") echo $row["url"];?>"></td>
	</tr>
	<tr>
		<td><img src='images/spacer.gif' height='1' width='100%'></td>
		<td colspan='2'><img src='images/break-l.gif' height='1' width='200' vspace='6'></td>
	</tr>
	<tr>
		<td width='30'>&nbsp;</td>
		<td width='200'><?echo $strAlt;?></td>
		<td><input size="35" type="text" name="url_alt" style="width:350px;" value="<?if (isset($type) && $type == "url") echo $row["alt"];?>"></td>
	</tr>
	<tr>
		<td><img src='images/spacer.gif' height='1' width='100%'></td>
		<td colspan='2'><img src='images/break-l.gif' height='1' width='200' vspace='6'></td>
	</tr>
	<tr>
		<td width='30'>&nbsp;</td>
		<td width='200'><?echo $strTextBelow;?></td>
		<td><input size="35" type="text" name="url_bannertext" style="width:350px;" value="<?if (isset($type) && $type == "url") echo $row["bannertext"];?>"></td>
	</tr>
	<tr>
		<td><img src='images/spacer.gif' height='1' width='100%'></td>
		<td colspan='2'><img src='images/break-l.gif' height='1' width='200' vspace='6'></td>
	</tr>
	<tr>
		<td width='30'>&nbsp;</td>	
		<td width='200'><?echo $strSize;?></td>
		<td>
			<?echo $strWidth;?>: <input size="5" type="text" name="url_width" value="<?if (isset($type) && $type == "url") echo $row["width"];?>">
			&nbsp;&nbsp;&nbsp;
			<?echo $strHeight;?>: <input size="5" type="text" name="url_height" value="<?if (isset($type) && $type == "url") echo $row["height"];?>">
		</td>
	</tr>

	<tr><td height='20' colspan='3'>&nbsp;</td></tr>
	<tr><td height='1' colspan='3' bgcolor='#888888'><img src='images/break.gif' height='1' width='100%'></td></tr>
</table>
<?if($dhtml) {?></div><?} else {?><br><br><?}?>
<?}?>


<?if ($show_html) {?>
<?if ($dhtml) {?><div id="htmlForm" <?if (!isset($type) || $type != "html") echo 'style="display:none"';?>><?}?>
<table border='0' width='100%' cellpadding='0' cellspacing='0' bgcolor='#F6F6F6'>
	<?if ($dhtml) {?>
		<tr><td height='25' colspan='3' bgcolor='#FFFFFF'><b><?echo $strHTMLBanner;?></b></td></tr>
	<?} else {?>
		<tr><td height='25' colspan='3' bgcolor='#FFFFFF'>
		<input type='radio' name='bannertype' value='html'<?if ($type == "html") echo " checked";?>>
		<b><?echo $strHTMLBanner;?></b></td></tr>
	<?}?>
	<tr><td height='1' colspan='3' bgcolor='#888888'><img src='images/break.gif' height='1' width='100%'></td></tr>
	<tr><td height='10' colspan='3'>&nbsp;</td></tr>
	
	<tr>
		<td width='30'>&nbsp;</td>
		<td width='200' valign='top'><?echo $strHTML;?></td>
		<td><textarea cols="35" rows="8" name="html_banner" style="width:350px;"><?if (isset($type) && $type == "html") echo stripslashes($row["banner"]);?></textarea></td>
	</tr>
	<tr>
		<td><img src='images/spacer.gif' height='1' width='100%'></td>
		<td colspan='2'><img src='images/break-l.gif' height='1' width='200' vspace='6'></td>
	</tr>
	<tr>
		<td width='30'>&nbsp;</td>	
		<td width='200'><?echo $strURL;?></td>
    	<td><input size="35" type="text" name="html_url" style="width:350px;" value="<?if (isset($type) && $type == "html") echo $row["url"];?>"></td>
	</tr>
	<tr>
		<td><img src='images/spacer.gif' height='1' width='100%'></td>
		<td colspan='2'><img src='images/break-l.gif' height='1' width='200' vspace='6'></td>
	</tr>
	<tr>
		<td width='30'>&nbsp;</td>	
		<td width='200'><?echo $strSize;?></td>
		<td>
			<?echo $strWidth;?>: <input size="5" type="text" name="html_width" value="<?if (isset($type) && $type == "html") echo $row["width"];?>">
			&nbsp;&nbsp;&nbsp;
			<?echo $strHeight;?>: <input size="5" type="text" name="html_height" value="<?if (isset($type) && $type == "html") echo $row["height"];?>">
		</td>
	</tr>

	<tr><td height='20' colspan='3'>&nbsp;</td></tr>
	<tr><td height='1' colspan='3' bgcolor='#888888'><img src='images/break.gif' height='1' width='100%'></td></tr>
</table>
<?if ($dhtml) {?></div><?} else {?><br><br><?}?>
<?}?>


<table border='0' width='100%' cellpadding='0' cellspacing='0'>
<?if (phpAds_isUser(phpAds_Admin)) {?>
<?if (!$dhtml) {?>
	<tr><td height='25' colspan='3' bgcolor='#FFFFFF'><b><?echo $strGeneralSettings;?></b></td></tr>
	<tr><td height='1' colspan='3' bgcolor='#888888'><img src='images/break.gif' height='1' width='100%'></td></tr>
<?}?>
	<tr><td height='10' colspan='3'>&nbsp;</td></tr>
	<tr>
		<td width='30'>&nbsp;</td>	
		<td width='200'><?echo $strKeyword;?></td>
    	<td><input size="35" type="text" name="keyword" style="width:350px;" value="<?if(isset($row["keyword"]))echo $row["keyword"];?>"></td>
	</tr>
	<tr>
		<td><img src='images/spacer.gif' height='1' width='100%'></td>
		<td colspan='2'><img src='images/break-l.gif' height='1' width='200' vspace='6'></td>
	</tr>
	<tr>
		<td width='30'>&nbsp;</td>	
		<td width='200'><?echo $strDescription;?></td>
    	<td><input size="35" type="text" name="description" style="width:350px;" value="<?if(isset($row["description"]))echo $row["description"];?>"></td>
	</tr>
	<tr>
		<td><img src='images/spacer.gif' height='1' width='100%'></td>
		<td colspan='2'><img src='images/break-l.gif' height='1' width='200' vspace='6'></td>
	</tr>
	<tr>
		<td width='30'>&nbsp;</td>	
		<td width='200'><?echo $strWeight;?></td>
    	<td><input size="6" type="text" name="weight" value="<?if(isset($row["weight"])){echo $row["weight"];}else{print "1";}?>"></td>
	</tr>
	<tr><td height='10' colspan='3'>&nbsp;</td></tr>
	<tr><td height='1' colspan='3' bgcolor='#888888'><img src='images/break.gif' height='1' width='100%'></td></tr>
	
</table>
<br><br>
<?}?>

<table border='0' width='100%' cellpadding='0' cellspacing='0'>
	<tr>
		<td height='35' colspan='3'><input type="submit" name="submit" value="<?echo $strSubmit;?>"></td>
	</tr>
</table>
</form>

	
<br><br>
<br><br>	

	
<?

/*********************************************************/
/* HTML framework                                        */
/*********************************************************/

phpAds_PageFooter();

?>
