/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.jdbc;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import org.postgresql.pljava.jdbc.AbstractResultSet;
import org.postgresql.pljava.jdbc.BlobValue;
import org.postgresql.pljava.jdbc.ClobValue;
import org.postgresql.pljava.jdbc.UnsupportedFeatureException;

public abstract class ObjectResultSet
extends AbstractResultSet {
    private boolean m_wasNull;

    private /* synthetic */ void finit$() {
        this.m_wasNull = false;
    }

    public void clearWarnings() throws SQLException {
    }

    public Array getArray(int n) throws SQLException {
        return (Array)this.getValue(n, ObjectResultSet.class$("java.sql.Array"));
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        Clob clob = this.getClob(n);
        if (clob == null) {
            return null;
        }
        return clob.getAsciiStream();
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        return (BigDecimal)this.getValue(n, ObjectResultSet.class$("java.math.BigDecimal"));
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        throw new UnsupportedFeatureException("getBigDecimal(int, int)");
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        Blob blob = this.getBlob(n);
        if (blob == null) {
            return null;
        }
        return blob.getBinaryStream();
    }

    public Blob getBlob(int n) throws SQLException {
        byte[] byArray = this.getBytes(n);
        if (byArray != null) {
            return new BlobValue(byArray);
        }
        return null;
    }

    public boolean getBoolean(int n) throws SQLException {
        Boolean bl = (Boolean)this.getValue(n, ObjectResultSet.class$("java.lang.Boolean"));
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public byte getByte(int n) throws SQLException {
        Number number = this.getNumber(n);
        if (number != null) {
            return number.byteValue();
        }
        return 0;
    }

    public byte[] getBytes(int n) throws SQLException {
        return (byte[])this.getValue(n, ObjectResultSet.class$("[B"));
    }

    public Reader getCharacterStream(int n) throws SQLException {
        Clob clob = this.getClob(n);
        if (clob == null) {
            return null;
        }
        return clob.getCharacterStream();
    }

    public Clob getClob(int n) throws SQLException {
        String string = this.getString(n);
        if (string != null) {
            return new ClobValue(string);
        }
        return null;
    }

    public Date getDate(int n) throws SQLException {
        return (Date)this.getValue(n, ObjectResultSet.class$("java.sql.Date"));
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        return (Date)this.getValue(n, ObjectResultSet.class$("java.sql.Date"), calendar);
    }

    public double getDouble(int n) throws SQLException {
        Number number = this.getNumber(n);
        if (number == null) {
            return 0.0;
        }
        return number.doubleValue();
    }

    public float getFloat(int n) throws SQLException {
        Number number = this.getNumber(n);
        if (number == null) {
            return 0.0f;
        }
        return number.floatValue();
    }

    public int getInt(int n) throws SQLException {
        Number number = this.getNumber(n);
        if (number == null) {
            return 0;
        }
        return number.intValue();
    }

    public long getLong(int n) throws SQLException {
        Number number = this.getNumber(n);
        if (number == null) {
            return 0L;
        }
        return number.longValue();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        throw new UnsupportedFeatureException("ResultSet meta data is not yet implemented");
    }

    public final Object getObject(int n) throws SQLException {
        Object object = this.getObjectValue(n);
        this.m_wasNull = object == null;
        return object;
    }

    public final Object getObject(int n, Map map) throws SQLException {
        Object object = this.getObjectValue(n, map);
        this.m_wasNull = object == null;
        return object;
    }

    public Ref getRef(int n) throws SQLException {
        return (Ref)this.getValue(n, ObjectResultSet.class$("java.sql.Ref"));
    }

    public short getShort(int n) throws SQLException {
        Number number = this.getNumber(n);
        if (number != null) {
            return number.shortValue();
        }
        return 0;
    }

    public String getString(int n) throws SQLException {
        return (String)this.getValue(n, ObjectResultSet.class$("java.lang.String"));
    }

    public Time getTime(int n) throws SQLException {
        return (Time)this.getValue(n, ObjectResultSet.class$("java.sql.Time"));
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        return (Time)this.getValue(n, ObjectResultSet.class$("java.sql.Time"), calendar);
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        return (Timestamp)this.getValue(n, ObjectResultSet.class$("java.sql.Timestamp"));
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        return (Timestamp)this.getValue(n, ObjectResultSet.class$("java.sql.Timestamp"), calendar);
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        throw new UnsupportedFeatureException("ResultSet.getUnicodeStream");
    }

    public URL getURL(int n) throws SQLException {
        return (URL)this.getValue(n, ObjectResultSet.class$("java.net.URL"));
    }

    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public void refreshRow() throws SQLException {
        throw new UnsupportedFeatureException("Refresh row");
    }

    public void updateArray(int n, Array array) throws SQLException {
        this.updateObject(n, (Object)array);
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        try {
            this.updateObject(n, (Object)new ClobValue(new InputStreamReader(inputStream, "US-ASCII"), n2));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SQLException("US-ASCII encoding is not supported by this JVM");
        }
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.updateObject(n, (Object)bigDecimal);
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.updateBlob(n, (Blob)new BlobValue(inputStream, n2));
    }

    public void updateBlob(int n, Blob blob) throws SQLException {
        this.updateObject(n, (Object)blob);
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        this.updateObject(n, (Object)(bl ? Boolean.TRUE : Boolean.FALSE));
    }

    public void updateByte(int n, byte by) throws SQLException {
        this.updateObject(n, (Object)new Byte(by));
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        this.updateObject(n, (Object)byArray);
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.updateClob(n, (Clob)new ClobValue(reader, n2));
    }

    public void updateClob(int n, Clob clob) throws SQLException {
        this.updateObject(n, (Object)clob);
    }

    public void updateDate(int n, Date date) throws SQLException {
        this.updateObject(n, (Object)date);
    }

    public void updateDouble(int n, double d) throws SQLException {
        this.updateObject(n, (Object)new Double(d));
    }

    public void updateFloat(int n, float f) throws SQLException {
        this.updateObject(n, (Object)new Float(f));
    }

    public void updateInt(int n, int n2) throws SQLException {
        this.updateObject(n, (Object)new Integer(n2));
    }

    public void updateLong(int n, long l) throws SQLException {
        this.updateObject(n, (Object)new Long(l));
    }

    public void updateNull(int n) throws SQLException {
        this.updateObject(n, null);
    }

    public void updateRef(int n, Ref ref) throws SQLException {
        this.updateObject(n, (Object)ref);
    }

    public void updateShort(int n, short s) throws SQLException {
        this.updateObject(n, (Object)new Short(s));
    }

    public void updateString(int n, String string) throws SQLException {
        this.updateObject(n, (Object)string);
    }

    public void updateTime(int n, Time time) throws SQLException {
        this.updateObject(n, (Object)time);
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.updateObject(n, (Object)timestamp);
    }

    public boolean wasNull() {
        return this.m_wasNull;
    }

    protected final Number getNumber(int n) throws SQLException {
        Object object = this.getObjectValue(n);
        boolean bl = this.m_wasNull = object == null;
        if (this.m_wasNull || object instanceof Number) {
            return (Number)object;
        }
        throw new SQLException("Cannot derive a Number from an object of class " + object.getClass().getName());
    }

    protected final Object getValue(int n, Class clazz) throws SQLException {
        Object object = this.getObject(n);
        if (object == null || clazz.isInstance(object)) {
            return object;
        }
        throw new SQLException("Cannot derive a value of class " + clazz.getName() + " from an object of class " + object.getClass().getName());
    }

    protected Object getValue(int n, Class clazz, Calendar calendar) throws SQLException {
        if (calendar == null || calendar == Calendar.getInstance()) {
            return this.getValue(n, clazz);
        }
        throw new UnsupportedFeatureException("Obtaining date, time, or timestamp using explicit Calendar");
    }

    protected Object getObjectValue(int n, Map map) throws SQLException {
        if (map == null) {
            return this.getObjectValue(n);
        }
        throw new UnsupportedFeatureException("Obtaining values using explicit Map");
    }

    protected abstract Object getObjectValue(int var1) throws SQLException;

    public ObjectResultSet() {
        this.finit$();
    }
}

