/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.internal;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.postgresql.pljava.internal.Backend;
import org.postgresql.pljava.internal.NativeStruct;
import org.postgresql.pljava.internal.Relation;
import org.postgresql.pljava.internal.Tuple;
import org.postgresql.pljava.jdbc.TriggerResultSet;

public class TriggerData
extends NativeStruct
implements org.postgresql.pljava.TriggerData {
    private Relation m_relation;
    private TriggerResultSet m_old = null;
    private TriggerResultSet m_new = null;

    public ResultSet getNew() throws SQLException {
        if (this.m_new != null) {
            return this.m_new;
        }
        if (this.isFiredByDelete() || this.isFiredForStatement()) {
            return null;
        }
        Tuple tuple = this.isFiredByInsert() ? this.getTriggerTuple() : this.getNewTuple();
        this.m_new = new TriggerResultSet(this.relation().getTupleDesc(), tuple, this.isFiredAfter());
        return this.m_new;
    }

    public ResultSet getOld() throws SQLException {
        if (this.m_old != null) {
            return this.m_old;
        }
        if (this.isFiredByInsert() || this.isFiredForStatement()) {
            return null;
        }
        this.m_old = new TriggerResultSet(this.relation().getTupleDesc(), this.getTriggerTuple(), true);
        return this.m_old;
    }

    public Tuple getTriggerReturnTuple() throws SQLException {
        Object[] objectArray;
        if (this.isFiredForStatement() || this.isFiredAfter()) {
            return null;
        }
        if (this.m_new != null && (objectArray = this.m_new.getChangeIndexesAndValues()) != null) {
            Tuple tuple = (Tuple)objectArray[0];
            int[] nArray = (int[])objectArray[1];
            Object[] objectArray2 = (Object[])objectArray[2];
            return this.relation().modifyTuple(tuple, nArray, objectArray2);
        }
        return this.isFiredByUpdate() ? this.getNewTuple() : this.getTriggerTuple();
    }

    public String getTableName() throws SQLException {
        return this.relation().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Relation getRelation() throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            return this._getRelation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tuple getTriggerTuple() throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            return this._getTriggerTuple();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tuple getNewTuple() throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            return this._getNewTuple();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getArguments() throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            return this._getArguments();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            return this._getName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFiredAfter() throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            return this._isFiredAfter();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFiredBefore() throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            return this._isFiredBefore();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFiredForEachRow() throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            return this._isFiredForEachRow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFiredForStatement() throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            return this._isFiredForStatement();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFiredByDelete() throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            return this._isFiredByDelete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFiredByInsert() throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            return this._isFiredByInsert();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFiredByUpdate() throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            return this._isFiredByUpdate();
        }
    }

    private final Relation relation() throws SQLException {
        if (this.m_relation == null) {
            this.m_relation = this.getRelation();
        }
        return this.m_relation;
    }

    private native Relation _getRelation() throws SQLException;

    private native Tuple _getTriggerTuple() throws SQLException;

    private native Tuple _getNewTuple() throws SQLException;

    private native String[] _getArguments() throws SQLException;

    private native String _getName() throws SQLException;

    private native boolean _isFiredAfter() throws SQLException;

    private native boolean _isFiredBefore() throws SQLException;

    private native boolean _isFiredForEachRow() throws SQLException;

    private native boolean _isFiredForStatement() throws SQLException;

    private native boolean _isFiredByDelete() throws SQLException;

    private native boolean _isFiredByInsert() throws SQLException;

    private native boolean _isFiredByUpdate() throws SQLException;
}

