/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import org.postgresql.pljava.internal.ExecutionPlan;
import org.postgresql.pljava.internal.Portal;
import org.postgresql.pljava.internal.SPI;
import org.postgresql.pljava.internal.SPIException;
import org.postgresql.pljava.jdbc.SPIConnection;
import org.postgresql.pljava.jdbc.SPIResultSet;
import org.postgresql.pljava.jdbc.StatementClosedException;
import org.postgresql.pljava.jdbc.UnsupportedFeatureException;

public class SPIStatement
implements Statement {
    private final SPIConnection m_connection;
    private String m_cursorName = null;
    private int m_fetchSize = 100;
    private int m_maxRows = 0;
    private ResultSet m_resultSet = null;
    private int m_updateCount = 0;
    private ArrayList m_batch = null;
    private boolean m_closed = false;

    public SPIStatement(SPIConnection sPIConnection) {
        this.m_connection = sPIConnection;
    }

    public void addBatch(String string) throws SQLException {
        this.internalAddBatch(string);
    }

    public void cancel() throws SQLException {
    }

    public void clearBatch() throws SQLException {
        this.m_batch = null;
    }

    public void clearWarnings() throws SQLException {
    }

    public void close() throws SQLException {
        if (this.m_resultSet != null) {
            this.m_resultSet.close();
        }
        this.m_updateCount = -1;
        this.m_cursorName = null;
        this.m_batch = null;
        this.m_closed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String string) throws SQLException {
        ExecutionPlan executionPlan = ExecutionPlan.prepare(this.m_connection.nativeSQL(string), null);
        int n = SPI.getResult();
        if (executionPlan == null) {
            throw new SPIException(n);
        }
        try {
            boolean bl = this.executePlan(executionPlan, null);
            return bl;
        }
        finally {
            try {
                executionPlan.close();
            }
            catch (Exception exception) {}
        }
    }

    protected boolean executePlan(ExecutionPlan executionPlan, Object[] objectArray) throws SQLException {
        this.m_updateCount = -1;
        this.m_resultSet = null;
        boolean bl = executionPlan.isCursorPlan();
        if (bl) {
            Portal portal = executionPlan.cursorOpen(this.m_cursorName, objectArray);
            this.m_resultSet = new SPIResultSet(this, portal, this.m_maxRows);
        } else {
            executionPlan.execute(objectArray, this.m_maxRows);
            this.m_updateCount = SPI.getProcessed();
        }
        return bl;
    }

    public boolean execute(String string, int n) throws SQLException {
        throw new UnsupportedFeatureException("Statement.execute(String,int)");
    }

    public boolean execute(String string, int[] nArray) throws SQLException {
        throw new UnsupportedFeatureException("Statement.execute(String,int[])");
    }

    public boolean execute(String string, String[] stringArray) throws SQLException {
        throw new UnsupportedFeatureException("Statement.execute(String,String[])");
    }

    public int[] executeBatch() throws SQLException {
        int n = this.m_batch == null ? 0 : this.m_batch.size();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.executeBatchEntry(this.m_batch.get(i));
        }
        return nArray;
    }

    public ResultSet executeQuery(String string) throws SQLException {
        this.execute(string);
        return this.getResultSet();
    }

    public int executeUpdate(String string) throws SQLException {
        this.execute(string);
        return this.getUpdateCount();
    }

    public int executeUpdate(String string, int n) throws SQLException {
        throw new UnsupportedFeatureException("Auto generated key support not yet implemented");
    }

    public int executeUpdate(String string, int[] nArray) throws SQLException {
        throw new UnsupportedFeatureException("Auto generated key support not yet implemented");
    }

    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        throw new UnsupportedFeatureException("Auto generated key support not yet implemented");
    }

    public Connection getConnection() throws SQLException {
        if (this.m_connection == null) {
            throw new StatementClosedException();
        }
        return this.m_connection;
    }

    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    public int getFetchSize() throws SQLException {
        return this.m_fetchSize;
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        throw new SQLException("JDK 1.4 functionality not yet implemented");
    }

    public int getMaxFieldSize() throws SQLException {
        return Integer.MAX_VALUE;
    }

    public int getMaxRows() throws SQLException {
        return this.m_maxRows;
    }

    public boolean getMoreResults() throws SQLException {
        return false;
    }

    public boolean getMoreResults(int n) throws SQLException {
        return false;
    }

    public int getQueryTimeout() throws SQLException {
        return 0;
    }

    public ResultSet getResultSet() throws SQLException {
        return this.m_resultSet;
    }

    public int getResultSetConcurrency() {
        return 1007;
    }

    public int getResultSetHoldability() throws SQLException {
        throw new SQLException("JDK 1.4 functionality not yet implemented");
    }

    public int getResultSetType() {
        return 1003;
    }

    public int getUpdateCount() throws SQLException {
        return this.m_updateCount;
    }

    public SQLWarning getWarnings() throws SQLException {
        if (this.m_closed) {
            throw new SQLException("getWarnings: Statement is closed");
        }
        return null;
    }

    public void setCursorName(String string) throws SQLException {
        this.m_cursorName = string;
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        throw new UnsupportedFeatureException("Statement.setEscapeProcessing");
    }

    public void setFetchDirection(int n) throws SQLException {
        if (n != 1000) {
            throw new UnsupportedFeatureException("Non forward fetch direction");
        }
    }

    public void setFetchSize(int n) throws SQLException {
        this.m_fetchSize = n;
    }

    public void setMaxFieldSize(int n) throws SQLException {
        throw new UnsupportedFeatureException("Statement.setMaxFieldSize");
    }

    public void setMaxRows(int n) throws SQLException {
        this.m_maxRows = n;
    }

    public void setQueryTimeout(int n) throws SQLException {
        throw new UnsupportedFeatureException("Statement.setQueryTimeout");
    }

    protected void internalAddBatch(Object object) throws SQLException {
        if (this.m_batch == null) {
            this.m_batch = new ArrayList();
        }
        this.m_batch.add(object);
    }

    protected int executeBatchEntry(Object object) throws SQLException {
        int n = -2;
        if (this.execute(this.m_connection.nativeSQL((String)object))) {
            this.getResultSet().close();
        } else if (this.m_updateCount >= 0) {
            n = this.m_updateCount;
        }
        return n;
    }

    void resultSetClosed(ResultSet resultSet) {
        if (resultSet == this.m_resultSet) {
            this.m_resultSet = null;
        }
    }
}

