#ifndef _CONTROLS_H_INCLUDED
#define _CONTROLS_H_INCLUDED
//------------------------------------------------------------------------------
#define	__FLAG_READY 	1
#define	__FLAG_SHUTDOWN	2
//------------------------------------------------------------------------------
class SimpleControl
{
protected:
	HWND _hWnd;

public:
	SimpleControl (HWND hwndParent, int id, BOOL initialState=TRUE)
		: _hWnd (GetDlgItem (hwndParent, id))
		{ if (initialState == FALSE) Disable();	}
	virtual	void Hide () { ::ShowWindow(_hWnd , SW_HIDE); }
	virtual	void Show () { ::ShowWindow(_hWnd , SW_SHOW); }
	virtual	BOOL IsVisible() { return(::IsWindowVisible(_hWnd )); }
	virtual	void SetFocus () { ::SetFocus (_hWnd); }
	virtual	void Enable() { ::EnableWindow(_hWnd , TRUE); }
	virtual	void Disable() { ::EnableWindow(_hWnd , FALSE); }
	virtual	HWND Hwnd () const { return _hWnd; }
	void SetName( char const * newName ) { SendMessage(_hWnd, WM_SETTEXT, 0, (LPARAM)newName ); }
};
//------------------------------------------------------------------------------
class Button : public SimpleControl
{
public:
	Button(HWND hwndParent, int id, BOOL initialState=TRUE)
		: SimpleControl(hwndParent, id, initialState) {}
};
//------------------------------------------------------------------------------
class StateButton : public SimpleControl
{
public:
	StateButton(HWND hwndParent, int id, BOOL initialState=TRUE)
		: SimpleControl(hwndParent, id, initialState) {}
	virtual BOOL IsSelected() { return( SendMessage(_hWnd, BM_GETCHECK, 0, 0) == BST_CHECKED ); }
	virtual void Select() { SendMessage( _hWnd, BM_SETCHECK, (WPARAM) BST_CHECKED, 0); }
	virtual void UnSelect() { SendMessage( _hWnd, BM_SETCHECK, (WPARAM) BST_UNCHECKED, 0); }
	virtual void SetSelect(BOOL fSelect);

};
//------------------------------------------------------------------------------
class CheckBox : public StateButton
{
public:
	CheckBox (HWND hwndParent, int id, BOOL initialState=TRUE)
		: StateButton(hwndParent, id, initialState)	{}
};
//------------------------------------------------------------------------------
class RadioButton: public StateButton
{
public:
	RadioButton (HWND hwndParent, int id, BOOL initialState=TRUE)
		: StateButton(hwndParent, id, initialState) {}
};
//------------------------------------------------------------------------------
class Edit: public SimpleControl
{
public:
	Edit (HWND hwndParent, int id, BOOL initialState=TRUE)
		: SimpleControl (hwndParent, id, initialState) {}

	virtual	void SetString (LPCTSTR buf) {SendMessage (_hWnd, WM_SETTEXT, 0, (LPARAM) buf); }
	static BOOL IsChanged (int code) { return code == EN_CHANGE; }
	virtual	int GetLength () { return (int)(SendMessage (_hWnd, WM_GETTEXTLENGTH, 0, 0));}
	virtual	void GetString (char* buf, int len) { SendMessage (_hWnd, WM_GETTEXT, (WPARAM) len, (LPARAM) buf);}
	virtual	void Select () { SendMessage (_hWnd, EM_SETSEL, 0, -1); }
	virtual	void ClearSelection () { SendMessage (_hWnd, WM_SETTEXT, 0, (LPARAM) ""); }
	virtual	void AppendString (char* buf);
};
//------------------------------------------------------------------------------
class EditOutput: public Edit
{
protected:
	int		m_maxlen;
	int		m_len;
	char	m_buffer[8192];
	char *	FifoAdd(char *str);

public:
	EditOutput (HWND hwndParent, int id, BOOL initialState=TRUE);
	int AppendStringCheck (char* buf);
	void AppendString (char* buf);
};
//------------------------------------------------------------------------------
#endif // ifndef _CONTROLS_H_INCLUDED
