#include "main.h"
static ControllerOpt* controlopt = 0;
//------------------------------------------------------------------------------
ControllerOpt::ControllerOpt(HWND hwnd)
	:	_ok				(hwnd, IDB_OK ),
    	_cancel			(hwnd, IDB_CANCEL ),
    	_command		(hwnd, IDE_COMMAND ),
    	_kill			(hwnd, IDE_KILL ),
    	_pidfile		(hwnd, IDE_PIDFILE ),
    	_prerun			(hwnd, IDE_PRERUN ),
    	_bindir			(hwnd, IDE_BINDIR ),
		_title			(hwnd, IDE_TITLE),
		_ready			(hwnd, IDE_READY),
		_shutdown		(hwnd, IDE_SHUTDOWN),
		_stopquit		(hwnd, IDC_STOPQUIT),
		_logfile		(hwnd, IDE_LOGFILE),
		_logout			(hwnd, IDC_LOGOUT)
{
	_command.SetString( Prf.m_command );
	_kill.SetString( Prf.m_kill );
    _pidfile.SetString( Prf.m_pidfile );
    _prerun.SetString( Prf.m_prerun );
    _bindir.SetString( Prf.m_bindir );
	_title.SetString(Prf.m_title);
	_ready.SetString(Prf.m_ready);
	_shutdown.SetString(Prf.m_shutdown);
	_stopquit.SetSelect(Prf.m_stopquit);
	_logfile.SetString(Prf.m_logfile);
	_logout.SetSelect(Prf.m_logout);
}
//------------------------------------------------------------------------------
void ControllerOpt::Command (HWND hwnd, int controlID, int command)
{
    switch (controlID)
    {
        case IDB_OK:
        	_command.GetString( Prf.m_command, sizeof(Prf.m_command));
        	_kill.GetString( Prf.m_kill, sizeof(Prf.m_kill));
        	_pidfile.GetString( Prf.m_pidfile, sizeof(Prf.m_prerun));
        	_prerun.GetString( Prf.m_prerun, sizeof(Prf.m_prerun));
        	_bindir.GetString( Prf.m_bindir, sizeof(Prf.m_bindir));
			_title.GetString(Prf.m_title, sizeof(Prf.m_title));
			_ready.GetString(Prf.m_ready, sizeof(Prf.m_ready));
			_shutdown.GetString(Prf.m_shutdown, sizeof(Prf.m_shutdown));
			_logfile.GetString(Prf.m_logfile, sizeof(Prf.m_logfile));
			Prf.m_stopquit = _stopquit.IsSelected();
			Prf.m_logout = _logout.IsSelected();

        	if( Prf.SetValues() )
        		EndDialog( hwnd, OPT_DLG_OK );
            break;
        case IDB_CANCEL:
        	EndDialog( hwnd, OPT_DLG_CANCEL );
            break;
		case IDC_STOPQUIT:
			Prf.m_stopquit = (Prf.m_stopquit) ? FALSE : TRUE;
			_stopquit.SetSelect(Prf.m_stopquit);
			break;
		case IDC_LOGOUT:
			Prf.m_logout = (Prf.m_logout) ? FALSE : TRUE;
			_logout.SetSelect(Prf.m_logout);
			break;
    }
}
//------------------------------------------------------------------------------
BOOL CALLBACK DialogProcOpt (HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    switch (message)
    {
	    case WM_INITDIALOG:
	        try
	        {
	            controlopt = new ControllerOpt (hwnd);
	        }
	        catch (WinException e)
	        {
	            MessageBox (0, e.GetMessage (), MSG_EXCEPTION, MB_ICONEXCLAMATION | MB_OK);
	        }
	        catch (...)
	        {
	            MessageBox (0, MSG_UNKNOWN, MSG_EXCEPTION, MB_ICONEXCLAMATION | MB_OK);
	            return -1;
	        }
	        return TRUE;

	    case WM_COMMAND:
	        controlopt->Command(hwnd, LOWORD(wParam), HIWORD (wParam));
	        return TRUE;
    }
    return FALSE;
}
//------------------------------------------------------------------------------
