#!/usr/sbin/dtrace -qs

/*
 * Usage      : txn_count.d <pid>
 * Description: Count all started, committed, and aborted transactions and
 *              the total processing time
 * Author     : Robert Lor
 */

BEGIN
{

	endtime = timestamp + (5 * 1000000000ull);
}

postgresql$1:::transaction-start
{
	@start["Start"] = count();
	self->ts  = timestamp;
}

postgresql$1:::transaction-abort
{
	@abort["Abort"] = count();
}

postgresql$1:::transaction-commit
/self->ts/
{
	@commit["Commit"] = count();
	@time["Total time (ns)"] = sum(timestamp - self->ts);
	self->ts=0;
}

END
{
        printf("\n%20s %15s\n","Tx Type", "COUNT");
        printa("%20s %@15d\n",@start);
        printa("%20s %@15d\n",@commit);
        printa("%20s %@15d\n",@abort);
        printa("\n%20s %@15d\n",@time);
}

/*
 * Run the script for ~10 secs and exit. Since there is processing time
 * before the probes are enabled and after they are disabled, endtime will be
 * be longer than the specified time, so adjust it accordingly.
 */
tick-1sec
/timestamp >= endtime/
{
        exit(0);
}

