#=====================================================================
# SQL-Ledger Accounting
# Copyright (c) 2001
#
#  Author: Dieter Simader
#   Email: dsimader@sql-ledger.org
#     Web: http://www.sql-ledger.org
#
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#======================================================================
#
# Accounts Payables
#
#======================================================================


use SL::AP;
use SL::IR;
$form->{rowcount}=50;

1;
# end of main


# this is for our long dates
# $locale->text('January')
# $locale->text('February')
# $locale->text('March')
# $locale->text('April')
# $locale->text('May ')
# $locale->text('June')
# $locale->text('July')
# $locale->text('August')
# $locale->text('September')
# $locale->text('October')
# $locale->text('November')
# $locale->text('December')

# this is for our short month
# $locale->text('Jan')
# $locale->text('Feb')
# $locale->text('Mar')
# $locale->text('Apr')
# $locale->text('May')
# $locale->text('Jun')
# $locale->text('Jul')
# $locale->text('Aug')
# $locale->text('Sep')
# $locale->text('Oct')
# $locale->text('Nov')
# $locale->text('Dec')


sub add {

  $form->{title} = "Add";
  $form->{callback} = "$form->{script}?action=add&path=$form->{path}&login=$form->{login}&sessionid=$form->{sessionid}";

if($form->{transdate}){
 $lastbatch = $form->{batch};
 $lastdate = $form->{transdate};
 $accno2=$form->{accno2};
 $accno3=$form->{accno3};
 

 }

  &create_links;
if($lastdate){
 $form->{transdate}=$lastdate;
$form->{batch}=$lastbatch;
$form->{accno2}=$accno2;
$form->{accno3}=$accno3;
}
  # lock the exchangerate field
  $form->{forex} = 1;
  $form->{"forex_1"} = 1;
  
  &display_form;
  
}


sub edit {
  
  $form->{title} = "Edit";

  &create_links;
  &display_form;

}


sub display_form {
  
  &form_header;
  &form_footer;

}


sub create_links {
  
  $form->create_links("AP", \%myconfig, "vendor");

  $taxincluded = $form->{taxincluded};
  
  # build the popup menus

  # currencies
  @curr = split /:/, $form->{currencies};
  chomp $curr[0];
  $form->{defaultcurrency} = $curr[0];

  map { $form->{selectcurrency} .= "<option>$_\n" } @curr;
  
  # vendors
  foreach $ref (@{ $form->{all_vendor} }) {
    if ($ref->{id} == $form->{vendor_id}) {
      $form->{vendor} = "$ref->{name}--$ref->{id}";
         $form->{AP1} = "$ref->{vendornumber}--$ref->{name}";
      $duedate = $form->{duedate};         # save duedate, we are using IR
      IR->get_vendor(\%myconfig, \%$form);
      $form->{duedate} = $duedate;           # work-around
    }
    $form->{selectvendor} .= "<option>$ref->{name}--$ref->{id}\n";
  }

  # forex
  $form->{forex} = $form->{exchangerate};
  
  foreach $key (keys %{ $form->{AP_links} }) {
    
    foreach $ref (@{ $form->{AP_links}{$key} }) {
      if ($key eq "AP_tax") {
	$form->{"selectAP_tax_$ref->{accno}"} = "<option>$ref->{accno}--$ref->{description}\n";
	next;
      }
      $form->{"select$key"} .= "<option value='$ref->{accno}--$ref->{description}'>$ref->{accno}--$ref->{description}\n";
    }
	
    # if there is a value we have an old entry
    # $i is only used for paid
    for $i (1 .. scalar @{ $form->{acc_trans}{$key} }) {

      if ($key eq "AP_paid") {
	$form->{"AP_paid_$i"} = "$form->{acc_trans}{$key}->[$i-1]->{accno}--$form->{acc_trans}{$key}->[$i-1]->{description}";
	$form->{"paid_$i"} = $form->{acc_trans}{$key}->[$i-1]->{amount};
	$form->{"datepaid_$i"} = $form->{acc_trans}{$key}->[$i-1]->{transdate};
	$form->{"source_$i"} = $form->{acc_trans}{$key}->[$i-1]->{source};

	if ($form->{"exchangerate_$i"} = $form->{acc_trans}{$key}->[$i-1]->{exchangerate}) {
	  $form->{"forex_$i"} = 1;
	} else {
	  $form->{"exchangerate_$i"} = 1;
	}
	
	$form->{paidaccounts}++;
      } else {

        $akey = $key;
        $akey =~ s/AP_//;

	if ($key eq "AP_tax") {
	  $form->{"${key}_$form->{acc_trans}{$key}->[$i-1]->{accno}"} = "$form->{acc_trans}{$key}->[$i-1]->{accno}--$form->{acc_trans}{$key}->[$i-1]->{description}";
	  $form->{"${akey}_$form->{acc_trans}{$key}->[$i-1]->{accno}"} = $form->round_amount($form->{acc_trans}{$key}->[$i-1]->{amount} / $form->{exchangerate} * -1, 2);
	  $totaltax += $form->{"${akey}_$form->{acc_trans}{$key}->[$i-1]->{accno}"};
	} else {
	  $form->{$akey} = $form->round_amount($form->{acc_trans}{$key}->[0]->{amount} / $form->{exchangerate}, 2);
	  $form->{$key} = "$form->{acc_trans}{$key}->[0]->{accno}--$form->{acc_trans}{$key}->[0]->{description}";
	}
      }
    }
  }

  $form->{taxincluded} = $taxincluded if ($form->{id});
  $form->{paidaccounts} = 1 if not defined $form->{paidaccounts};

  $form->{amount} *= -1;
  $form->{invtotal} = $form->{amount} + $totaltax;

  if ($form->{taxincluded}) {
    $form->{amount} += $totaltax;
  }

  $form->{locked} = ($form->datetonum($form->{transdate}, \%myconfig) <= $form->datetonum($form->{closedto}, \%myconfig));
  
}


sub form_header {

  $title = $form->{title};
  $form->{title} = $locale->text("$title Accounts Payables");

  $form->{taxincluded} = ($form->{taxincluded}) ? "checked" : "";

# type=submit $locale->text('Add Accounts Payables')
# type=submit $locale->text('Edit Accounts Payables')
$form->{AP}=$form->{AP1};
#$form->dberror($form->{AP}); 
  # set option selected
  foreach $item (qw(AP AP_amount vendor currency)) {
	  $form->{"$item"} =~ s/\(/;brak/g;
$form->{"select$item"} =~ s/\(/;brak/g;

$form->{"$item"} =~ s/\)/;2brak/g;
$form->{"select$item"} =~ s/\)/;2brak/g;

$form->{"$item"} =~ s/\[/;brek/g;
$form->{"select$item"} =~ s/\[/;brek/g;

$form->{"$item"} =~ s/\]/;2brek/g;
$form->{"select$item"} =~ s/\]/;2brek/g;

$form->{"select$item"} =~ s/ selected//;
    $form->{"select$item"} =~ s/option value='$form->{$item}'>\Q$form->{$item}\E/option selected value='$form->{$item}'>$form->{$item}/;
    
       $form->{"$item"} =~ s/;brak/\(/g;
$form->{"select$item"} =~ s/;brak/\(/g;

$form->{"$item"} =~ s/;2brak/\)/g;
$form->{"select$item"} =~ s/;2brak/\)/g;

   $form->{"$item"} =~ s/;brek/\[/g;
$form->{"select$item"} =~ s/;brek/\[/g;

$form->{"$item"} =~ s/;2brek/\]/g;
$form->{"select$item"} =~ s/;2brek/\]/g;
  }

  # format amounts
  $form->{amount} = $form->format_amount(\%myconfig, $form->{amount}, 2);
  $form->{exchangerate} = $form->format_amount(\%myconfig, $form->{exchangerate});

  $exchangerate = qq|&nbsp;|;
  if ($form->{currency} ne $form->{defaultcurrency}) {
    if ($form->{forex}) {
      $exchangerate = qq|<input type=hidden name=exchangerate value=$form->{exchangerate}>$form->{exchangerate}|;
    } else {
      $exchangerate = qq|<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=exchangerate size=10 value=$form->{exchangerate}>|;
    }
  }
  $exchangerate .= qq|
<input type=hidden name=forex value=$form->{forex}>
|;


  if (($rows = $form->numtextrows($form->{notes}, 50)) < 2) {
    $rows = 2;
  }
  $notes = qq|<textarea name=notes rows=$rows cols=50 wrap=soft>$form->{notes}</textarea>|;

if(!$form->{nextfocus}){
	$form->{nextfocus}="transtype";
}
  $form->{title1}=qq|$form->{title} [ Inv No : $form->{invnumber}, Customer : $form->{AP}, Date : $form->{transdate} ]|;

  $form->header;
  print qq|
<script>
<!--

function autoComplete (field, select, property, forcematch) {
	var found = false;

	for (var i = 0; i < select.options.length; i++) {
	if (select.options[i][property].toUpperCase().indexOf(field.value.toUpperCase()) == 0) {
		found=true; break;
		}
	}
	if (found) { select.selectedIndex = i; }
	else { select.selectedIndex = -1; }
	if (field.createTextRange) {
		if (forcematch && !found) {
			field.value=field.value.substring(0,field.value.length-1); 
			return;
			}
		var cursorKeys ="8;46;37;38;39;40;33;34;35;36;45;";
		if (cursorKeys.indexOf(event.keyCode+";") == -1) {
			var r1 = field.createTextRange();
			var oldValue = r1.text;
			var newValue = found ? select.options[i][property] : oldValue;
			if (newValue != field.value) {
				field.value = newValue;
				var rNew = field.createTextRange();
				rNew.moveStart('character', oldValue.length) ;
				rNew.select();
				}
			}
		}
	}

function stb(){document.myform.$form->{nextfocus}.focus();parent.document.title ="$form->{title1}";}

	// -->
</script>

<body bgcolor=ffffff onLoad=stb()>

<form method=post action=$form->{script} name=myform>

<input type=hidden name=id value=$form->{id}>
<input type=hidden name=sort value=$form->{sort}>
<input type=hidden name=closedto value=$form->{closedto}>
<input type=hidden name=locked value=$form->{locked}>
<input type=hidden name=title value="$title">
<input type=hidden name=nextfocus value=$form->{nextfocus}>
<input type=hidden name=keys>

<table border=1>
<tr class=listtop bgcolor=000000><th>
<font color=ffffff>$form->{title}</font></th></tr>

<tr valign=top>
<td>

<table>
<tr>
  <th align=right>|.$locale->text('Trans No.').qq|</th>
  <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=transtype  size=4 value="$form->{transtype}">-<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=batch size=6 value="$form->{batch}">-<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=transno  size=4 value="$form->{transno}"><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=subtransno  size=2 value="$form->{subtransno}"> </td>

</tr>

<tr>
  <th align=right>|.$locale->text('Sub No.').qq|</th>
  <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=subb  size=4 value="$form->{subb}"></td>
</tr>

<tr>
  <th align=right>|.$locale->text('Project No.').qq|</th>
  <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=project  size=4 value="$form->{project}"></td>
</tr>

<tr>

  <th align=right>|.$locale->text('Vendor').qq|</th>
  <td colspan=3><select  onkeypress="selectKeyPress();" onkeydown="setsubmit(this);selectKeyDown();" onblur="clr();" onfocus="clr();"  name=AP onChange="this.form.accno2.value=this.options[this.selectedIndex].value">$form->{selectAP}</select></td>

  <input type=hidden name=selectAP value="$form->{selectAP}">
</tr>

<tr>


  <input type=hidden name=selectvendor value="$form->{selectvendor}">
  <input type=hidden name=oldvendor value="$form->{vendor_id}">
  <input type=hidden name=terms value=$form->{terms}>
</tr>
|;

  if ($form->{taxaccounts}) {
    print qq|
<tr>

  <th align=right>|.$locale->text('Tax Included').qq|</th>
  <td colspan=3><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=taxincluded class=checkbox type=checkbox value=1 $form->{taxincluded}></td>

</tr>|;
  }
  
  print qq|
<tr>

  <th align=right>|.$locale->text('Invoice Number').qq|</th>
  <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=invnumber size=20 value="$form->{invnumber}"></td>
  <th align=right>|.$locale->text('Order Number').qq|</th>
  <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=ordnumber size=20 value="$form->{ordnumber}"></td>

</tr>

<tr>

  <th align=right>|.$locale->text('Invoice Date').qq|<br>($myconfig{'dateformat'})</th>
  <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=transdate size=11 value=$form->{transdate}>
           <link rel="stylesheet" media="screen" href="javascript/dynCalendar.css" />
<script language="javascript" type="text/javascript" src="javascript/browserSniffer.js"></script>
<script language="javascript" type="text/javascript" src="javascript/dynCalendar.js"></script>
 
   <script language="JavaScript" type="text/javascript">
    <!--
        /**
        * Example callback function
        */
        function calendar1Callback(date, month, year)
        {
            document.forms['myform'].transdate.value = formatDate(new Date(getDateFromFormat(year + '-' + month + '-' + date,'yyyy-M-d')),'$myconfig{dateformat}');
        }

        calendar1 = new dynCalendar('calendar1', 'calendar1Callback', 'javascript/images/');
    //-->
    </script>
    
  </td>
  <th align=right>|.$locale->text('Due Date').qq|<br>($myconfig{'dateformat'})</th>
  <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=duedate size=11 value=$form->{duedate}></td>

</tr>

<tr>

  <th align=right>|.$locale->text('Currency').qq|</th>
  <td><select  onkeypress="selectKeyPress();" onkeydown="setsubmit(this);selectKeyDown();" onblur="clr();" onfocus="clr();"  name=currency>$form->{selectcurrency}</select></td>
  <th align=right>|.$locale->text('Exchangerate').qq|</th>
  <td>$exchangerate</td>

  <input type=hidden name=selectcurrency value="$form->{selectcurrency}">
  <input type=hidden name=defaultcurrency value=$form->{defaultcurrency}>
  <input type=hidden name=fxgain_accno value=$form->{fxgain_accno}>
  <input type=hidden name=fxloss_accno value=$form->{fxloss_accno}>
</tr>

<tr>

  <th align=right>|.$locale->text('Amount').qq|</th>
  <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=amount size=10 value=$form->{amount}></td>
  <td colspan=2><select  onkeypress="selectKeyPress();" onkeydown="setsubmit(this);selectKeyDown();" onblur="clr();" onfocus="clr();"  name=AP_amount onChange="this.form.accno3.value=this.options[this.selectedIndex].value">$form->{selectAP_amount}</select></td>

  <input type=hidden name=selectAP_amount value="$form->{selectAP_amount}">
</tr>

<input type=hidden name=taxaccounts value="$form->{taxaccounts}">
|;


  $taxlabel = ($form->{taxincluded}) ? $locale->text('Tax Included') : $locale->text('Tax');
  
  foreach $item (split / /, $form->{taxaccounts}) {

    # format and reverse tax
    $form->{"tax_$item"} = $form->format_amount(\%myconfig, $form->{"tax_$item"}, 2); 
      $form->{"selectAP_tax_$item"} = qq|<option>$item--$form->{"${item}_description"}|;

    print qq|
<tr>

  <th align=right>${taxlabel}</th>
  <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="tax_$item" size=9 value=$form->{"tax_$item"}></td>
  <td colspan=2><select  onkeypress="selectKeyPress();" onkeydown="setsubmit(this);selectKeyDown();" onblur="clr();" onfocus="clr();"  name=AP_tax_$item>$form->{"selectAP_tax_$item"}</select></td>

</tr>
 
<input type=hidden name="${item}_rate" value="$form->{"${item}_rate"}">
<input type=hidden name="${item}_description" value="$form->{"${item}_description"}">
<input type=hidden name="selectAP_tax_$item" value="$form->{"selectAP_tax_$item"}">
|;
  }
   
  $form->{invtotal} = $form->format_amount(\%myconfig, $form->{invtotal}, 2);

  #########for max
#   print qq|
#   <tr>
#   <td colspan=4>
#   <table>
#  <tr>
#  	<th>|.$locale->text('Description').qq|</th>
#  	<th>|.$locale->text('Qty').qq|</th>
#  	<th>|.$locale->text('Amount').qq|</th>
 # 	<th>|.$locale->text('Total').qq|</th>
#  </tr>
#  <tr>
#  	<td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="desc_1" size=30 value=$form->{"desc_1"}></td>
#  	<td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="qty_1" size=10 value=$form->{"qty_1"}></td>
#  	<td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="amount_1" size=10 value=$form->{"amount_1"}></td>
#  	<td>$form->{"total_1"}</td>
#  </tr>
 # <tr>
#  	<td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="desc_2" size=30 value=$form->{"desc_2"}></td>
 # 	<td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="qty_2" size=10 value=$form->{"qty_2"}></td>
 # 	<td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="amount_2" size=10 value=$form->{"amount_2"}></td>
 ## 	<td>$form->{"total_2"}</td>
 # </tr>
 #   <tr>
#  	<td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="desc_3" size=30 value=$form->{"desc_3"}></td>
#  	<td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="qty_3" size=10 value=$form->{"qty_3"}></td>
 # 	<td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="amount_3" size=10 value=$form->{"amount_3"}></td>
#  	<td>$form->{"total_3"}</td>
#  </tr>
#    <tr>
#  	<td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="desc_4" size=30 value=$form->{"desc_4"}></td>
 # 	<td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="qty_4" size=10 value=$form->{"qty_4"}></td>
 # 	<td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="amount_4" size=10 value=$form->{"amount_4"}></td>
 # 	<td>$form->{"total_4"}</td>
 # </tr>
 #   <tr>
  #	<td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="desc_5" size=30 value=$form->{"desc_5"}></td>
 # 	<td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="qty_5" size=10 value=$form->{"qty_5"}></td>
 # 	<td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="amount_5" size=10 value=$form->{"amount_5"}></td>
#  	<td>$form->{"total_5"}</td>
#  </tr>
#    </table>
#    </td>
#    </tr>
    
#  |;
#####end for max
  
  
  
  print qq|
<tr>

  <th align=right>|.$locale->text('Total').qq|</th>
  <td colspan=3>$form->{invtotal}</td>

</tr>

<tr>

  <th align=right>|.$locale->text('Notes').qq|</th>
  <td colspan=3>$notes</td>

</tr>

<tr>
  <td colspan=4>
    <table width=100%>
    <tr class=listheading><th colspan=5><font color=ffffff>|.$locale->text('Payments').qq|</font></th></tr>
|;


  @column_index = qw(datepaid paid exchangerate AP_paid source);

  $column_data{datepaid} = "<th>".$locale->text('Date')."<br>($myconfig{dateformat})</th>";
  $column_data{paid} = "<th>".$locale->text('Amount')."</th>";
  $column_data{exchangerate} = "<th>".$locale->text('Exch')."</th>";
  $column_data{AP_paid} = "<th>".$locale->text('Account')."</th>";
  $column_data{source} = "<th>".$locale->text('Source')."</th>";

  print "<tr>";
  map { print "$column_data{$_}\n" } @column_index;
  print "</tr>";

  $form->{paidaccounts}++ if ($form->{"paid_$form->{paidaccounts}"});
  for $i (1 .. $form->{paidaccounts}) {
    print "<tr>\n";

    $form->{"selectAP_paid_$i"} = $form->{selectAP_paid};
    #$form->{"selectAP_paid_$i"} =~ s/option>\Q$form->{"AP_paid_$i"}\E/option selected>$form->{"AP_paid_$i"}/;
  	    $form->{"selectAP_paid_$i"} =~ s/option value='$form->{"AP_paid_$i"}'>\Q$form->{"AP_paid_$i"}\E/option selected  value='$form->{"AP_paid_$i"}'>$form->{"AP_paid_$i"}/;

    # format amounts
    $form->{"paid_$i"} = $form->format_amount(\%myconfig, $form->{"paid_$i"}, 2);
    $form->{"exchangerate_$i"} = $form->format_amount(\%myconfig, $form->{"exchangerate_$i"});
    
    $exchangerate = qq|&nbsp;|;
    if ($form->{currency} ne $form->{defaultcurrency}) {
      if ($form->{"forex_$i"}) {
	$exchangerate = qq|<input type=hidden name="exchangerate_$i" value=$form->{"exchangerate_$i"}>$form->{"exchangerate_$i"}|;
      } else {
	$exchangerate = qq|<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="exchangerate_$i" size=10 value=$form->{"exchangerate_$i"}>|;
      }
    }

    $exchangerate .= qq|
<input type=hidden name="forex_$i" value=$form->{"forex_$i"}>
|;

    $column_data{"paid_$i"} = qq|<td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="paid_$i" size=10 value=$form->{"paid_$i"}></td>|;
    $column_data{"AP_paid_$i"} = qq|<td><select  onkeypress="selectKeyPress();" onkeydown="setsubmit(this);selectKeyDown();" onblur="clr();" onfocus="clr();"  name="AP_paid_$i">$form->{"selectAP_paid_$i"}</select></td>|;
    $column_data{"exchangerate_$i"} = qq|<td>$exchangerate</td>|;
    $column_data{"datepaid_$i"} = qq|<td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="datepaid_$i" size=11 value=$form->{"datepaid_$i"}></td>|;
    $column_data{"source_$i"} = qq|<td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="source_$i" size=10 value="$form->{"source_$i"}"></td>|;

    map { print qq|$column_data{"${_}_$i"}\n| } @column_index;

    print "</tr>\n";
  }

  print qq|
    <input type=hidden name=paidaccounts value=$form->{paidaccounts}>
    <input type=hidden name=selectAP_paid value="$form->{selectAP_paid}">
    
    </table>
  </td>

</tr>
|;


  
    print qq|

  </table>

</td>
</tr>

|;
}


sub form_footer {

  print qq|

<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=callback type=hidden value="$form->{callback}">

<input type=hidden name=path value=$form->{path}>
<input type=hidden name=login value=$form->{login}>
<input type=hidden name=sessionid value=$form->{sessionid}>
<input type=hidden name=action value='Update Form'>

</table>

<br>
|;

  $transdate = $form->datetonum($form->{transdate}, \%myconfig);
  $closedto = $form->datetonum($form->{closedto}, \%myconfig);
  
  if (!$form->{readonly}){
  if ($form->{id}) {
    print qq|<input class=submit type=submit name=action value="|.$locale->text('Update').qq|">
|;

    if (!$form->{revtrans}) {
      if (!$form->{locked}) {
	print qq|
	<input class=submit type=submit name=action value="|.$locale->text('Save').qq|">
	<input class=submit type=submit name=action value="|.$locale->text('Delete').qq|">
|;
      }
    }

    if ($transdate > $closedto) {
      print qq|<input class=submit type=submit name=action value="|.$locale->text('Post As New Transaction').qq|">
|;
    }

  } else {
    if ($transdate > $closedto) {
      print qq|<input class=submit type=submit name=action value="|.$locale->text('Update').qq|">
      <input class=submit type=submit name=action value="|.$locale->text('Save').qq|">|;
    }
  }
}

  print "</form>

</body>
</html>
";

}

sub save{
	&post_transaction;	
}

sub delete{
	&delete_transaction;	
}



sub update{
	&update_form;	
}


sub update_form {

  # split vendor
  #($null, $form->{vendor_id}) = split /--/, $form->{vendor};
    $form->{AP1}=$form->{AP};
 $taxincluded=$form->{taxincluded};
 
   ($form->{AP}) = split /--/, $form->{AP};
  IR->get_vendorid(\%myconfig, \%$form);

  # recalculate form
 # if ($form->{oldvendor} != $form->{vendor_id}) {
    IR->get_vendor(\%myconfig, \%$form);
 # }
      $form->{AP}=$form->{AP1};
 $form->{taxincluded}=$taxincluded;

  $form->{exchangerate} = $exchangerate if ($form->{forex} = ($exchangerate = $form->check_exchangerate(\%myconfig, $form->{currency}, $form->{transdate}, 'sell')));

  # recalculate due date
  $form->{duedate} = $form->current_date(\%myconfig, $form->{transdate}, $form->{terms});
  
  map { $form->{$_} = $form->parse_amount(\%myconfig, $form->{$_}) } qw(amount exchangerate);

  # recalculate taxes
  if ($form->{taxincluded}) {
    $taxrate = 0;

    map { $taxrate += $form->{"${_}_rate"} } split / /, $form->{taxaccounts};

    foreach $item (split / /, $form->{taxaccounts}) {
     # $form->{"tax_$item"} = $form->round_amount($form->{amount} * (1 - 1 / (1 + $taxrate)) * $form->{"${item}_rate"} / $taxrate, 2);
       $form->{"tax_$item"} = $form->{amount} * $form->{"${item}_rate"};
     $form->{"selectAP_tax_$item"} = qq|<option>$item--$form->{"${item}_description"}|;
  #    $totaltax += $form->{"tax_$item"};
    }
  } else {
    foreach $item (split / /, $form->{taxaccounts}) {
      $form->{"tax_$item"} = $form->{amount} * $form->{"${item}_rate"};
      $form->{"selectAP_tax_$item"} = qq|<option>$item--$form->{"${item}_description"}|;
      $totaltax += $form->{"tax_$item"};
    }
  }

  $form->{invtotal} = ($form->{taxincluded}) ? $form->{amount} : $form->{amount} + $totaltax;
  
  for $i (1 .. $form->{paidaccounts}) {
    if ($form->{"paid_$i"}) {
      map { $form->{"${_}_$i"} = $form->parse_amount(\%myconfig, $form->{"${_}_$i"}) } qw(paid exchangerate);
      
      $form->{"exchangerate_$i"} = $exchangerate if ($form->{"forex_$i"} = ($exchangerate = $form->check_exchangerate(\%myconfig, $form->{currency}, $form->{"datepaid_$i"}, 'sell')));
    }
  }

  ###for max
 # for $i (1 .. 5) {
 # $form->{"total_$i"}=$form->{"qty_$i"}*$form->{"amount_$i"};
 # $form->{"total_$i"}=$form->format_amount(\%myconfig, $form->{"total_$i"}, 2, "&nbsp;");
 # $form->{"amount_$i"}=$form->format_amount(\%myconfig, $form->{"amount_$i"}, 2, "&nbsp;");
 # }
  ### end for max
  &display_form;

}
 
 
sub post_transaction {

  # check if there is an invoice number, invoice and due date
  $form->isblank("invnumber", $locale->text("Invoice Number missing!"));
  $form->isblank("transdate", $locale->text("Invoice Date missing!"));
  $form->isblank("duedate", $locale->text("Due Date missing!"));

  $closedto = $form->datetonum($form->{closedto}, \%myconfig);
  $transdate = $form->datetonum($form->{transdate}, \%myconfig);

  $form->error($locale->text('Cannot post transaction for a closed period!')) if ($transdate <= $closedto);

  $form->isblank("exchangerate", $locale->text('Exchangerate missing!')) if ($form->{currency} ne $form->{defaultcurrency});

  for $i (1 .. $form->{paidaccounts}) {
    if ($form->{"paid_$i"}) {
      $datepaid = $form->datetonum($form->{"datepaid_$i"}, \%myconfig);

      $form->isblank("datepaid_$i", $locale->text('Payment date missing!'));

      $form->error($locale->text('Cannot post payment for a closed period!')) if ($datepaid <= $closedto);

      if ($form->{currency} ne $form->{defaultcurrency}) {
	$form->{"exchangerate_$i"} = $form->{exchangerate} if ($transdate == $datepaid);
	$form->isblank("exchangerate_$i", $locale->text('Exchangerate for payment missing!'));
      }

    }
  }


  # split vendor
#  ($null, $form->{vendor_id}) = split /--/, $form->{vendor};
    $taxincluded=$form->{taxincluded};

    ($form->{AP}) = split /--/, $form->{AP};
  IR->get_vendorid(\%myconfig, \%$form);
  # $form->{vendor_id}=$form->{vendor_id2};

  # if the vendor changed get new vendor
 # if ($form->{oldvendor} != $form->{vendor_id}) {
    IR->get_vendor(\%myconfig, \%$form);
 # }
   $form->{taxincluded}=$taxincluded;

  #$form->dberror($form->{vendor_id});
  $form->isposted(AP->post_transaction(\%myconfig, \%$form));

}


sub post_as_new_transaction {

  $form->{id} = 0;
  &post_transaction;

}


sub delete_transaction {

  $form->{title} = $locale->text('Confirm!');

  $form->header;

  print qq|
<body bgcolor=ffffff>

<form method=post action=$form->{script}>
|;

  foreach $key (keys %$form) {
    print qq|<input type=hidden name=$key value="$form->{$key}">\n|;
  }

  print qq|
<h2><font color=blue>$form->{title}</font></h2>

<b>|.$locale->text('Are you sure you want to delete Transaction').qq| $form->{invnumber}</b>
<p>

<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=action class=submit type=submit value="|.$locale->text('Yes Delete Transaction').qq|">
</form>

</body>
</html>
|;

}



sub yes_delete_transaction {

  $form->isdeleted(AP->delete_transaction(\%myconfig, \%$form));

}


sub search {
$form->{transdatefrom} =$form->first_day_current_Date(\%myconfig) if $form->{currentdate};
  # setup vendor selection
  $form->all_vc(\%myconfig, "vendor",$form->{group});

  my $selection = "<option selected>" . $locale->text('All Vendors') ."\n" if !$form->{group};

  foreach $ref (@{ $form->{all_vendor} }) {
    $selection .= "<option>$ref->{vendornumber}::$ref->{name}--$ref->{id}\n";
  }

  if ($form->{nextsub} eq "payments") {
    $form->{title} = $locale->text('Process Payments');
    $listopen = qq|
    <input type=hidden name=sort value=invnumber>
    <input type=hidden name=open value=Y>|;
  }
  


  $listopen = qq|
<input type=hidden name=sort value=transdate>
<tr>
<td colspan=3>
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_option" class=checkbox type=checkbox value=Y  $form->{l_option}>&nbsp;|.$locale->text('Show Search Criteria').qq|
</td>
</tr>
<tr>

  <th align=right>|.$locale->text('Include in Report').qq|</th>
  <td colspan=3>
  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=open class=checkbox type=checkbox value=Y $form->{open}>&nbsp;|.$locale->text('Open').qq|
  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=closed class=checkbox type=checkbox value=Y $form->{closed}>&nbsp;|.$locale->text('Closed').qq|

  <br>

   <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_sr" class=checkbox type=checkbox value=Y $form->{l_sr}>&nbsp;|.$locale->text('SR').qq|
  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_id" class=checkbox type=checkbox value=Y $form->{l_id}>&nbsp;|.$locale->text('ID').qq|
  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_transtype" class=checkbox type=checkbox value=Y $form->{l_transtype}>&nbsp;|.$locale->text('Trans no.').qq|
  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_subb" class=checkbox type=checkbox value=Y $form->{l_subb}>&nbsp;|.$locale->text('Sub no.').qq|
  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_project" class=checkbox type=checkbox value=Y $form->{l_project}>&nbsp;|.$locale->text('Project').qq|
  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_invnumber" class=checkbox type=checkbox value=Y $form->{l_invnumber}>&nbsp;|.$locale->text('Invoice').qq|
  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_ordnumber" class=checkbox type=checkbox value=Y $form->{l_ordnumber}>&nbsp;|.$locale->text('Order Number').qq|<br>
  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_vendornumber" class=checkbox type=checkbox value=Y $form->{l_vendornumber}>&nbsp;|.$locale->text('Vendor Number').qq|
  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_name" class=checkbox type=checkbox value=Y $form->{l_name}>&nbsp;|.$locale->text('Vendor').qq|
  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_transdate" class=checkbox type=checkbox value=Y $form->{l_transdate}>&nbsp;|.$locale->text('Invoice Date').qq|
  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_netamount" class=checkbox type=checkbox value=Y $form->{l_netamount}>&nbsp;|.$locale->text('Amount').qq|
  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_tax" class=checkbox type=checkbox value=Y $form->{l_tax}>&nbsp;|.$locale->text('Tax').qq|
  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_rowcount" class=checkbox type=checkbox value=Y $form->{l_rowcount}>&nbsp;|.$locale->text('Total Rows').qq|<br>
  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_amount" class=checkbox type=checkbox value=Y $form->{l_amount}>&nbsp;|.$locale->text('Total').qq|
  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_datepaid" class=checkbox type=checkbox value=Y $form->{l_datepaid}>&nbsp;|.$locale->text('Date Paid').qq|
  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_paid" class=checkbox type=checkbox value=Y $form->{l_paid}>&nbsp;|.$locale->text('Paid').qq|
  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_duedate" class=checkbox type=checkbox value=Y $form->{l_duedate}>&nbsp;|.$locale->text('Due Date').qq|
  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_due" class=checkbox type=checkbox value=Y $form->{l_due}>&nbsp;|.$locale->text('Due').qq|
  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_terms" class=checkbox type=checkbox value=Y $form->{l_terms}>&nbsp;|.$locale->text('Terms').qq|
  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_notes" class=checkbox type=checkbox value=Y $form->{l_notes}>&nbsp;|.$locale->text('Notes').qq|<br>
  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_subtotal" class=checkbox type=checkbox value=Y $form->{l_subtotal}>&nbsp;|.$locale->text('Subtotal').qq|
  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_login" class=checkbox type=checkbox value=Y $form->{l_login}>&nbsp;|.$locale->text('Employee').qq|

  
   <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_all" class=checkbox type=checkbox value=Y $form->{l_all}>&nbsp;|.$locale->text('All Items').qq|

  </td>

</tr>
|;
  $form->header;

  print qq|
  <script>
<!--
function stb(){parent.document.title ="$form->{title}";}

	// -->
</script>

<body bgcolor=ffffff  onLoad=stb()>
<form method=post action=$form->{script} name=myform>

<table border=1>
<tr><th class=listtop bgcolor=000000><font color=ffffff>$form->{title}</font></th></tr>

<tr><td>

<table>

<tr>

<th align=right>|.$locale->text('Vendor').qq|</th>
<td colspan=3><select  onkeypress="selectKeyPress();" onkeydown="setsubmit(this);selectKeyDown();" onblur="clr();" onfocus="clr();"  name=vendor >$selection</select></td>

</tr>
<tr>

  <th align=right>|.$locale->text('Trans No.').qq|</th>
  <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=transtypeno  size=4 value="$form->{transtypeno}" onkeypress="javascript:nextFocusWithMaxLength(this.form,this,event,3)">-<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=batchno size=6 value="$form->{batchno}">-<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=transnono  size=4 value="$form->{transnono}"><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=subtransno  size=2 value="$form->{subtransnono}"></td>

</tr>
<tr>

<th align=right>|.$locale->text('Project Number').qq|</th>
<td ><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=project  value="$form->{project}" size=20></td>
<th align=right>|.$locale->text('Sub Number').qq|</th>
<td ><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=subb  value="$form->{subb}" size=20></td>

</tr>

<tr>

<th align=right>|.$locale->text('Invoice Number').qq|</th>
<td colspan=3><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=invnumber  value="$form->{invnumber}" size=20></td>

</tr>

<tr>

<th align=right>|.$locale->text('Order Number').qq|</th>
<td colspan=3><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=ordnumber  value="$form->{ordnumber}" size=20></td>

</tr>

<tr>

<th align=right>|.$locale->text('Notes').qq|</th>
<td colspan=3><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=notes  value="$form->{notes}" size=50></td>

</tr>

<tr>

<th align=right>|.$locale->text('From').qq|</th>
<td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=transdatefrom size=11  value="$form->{transdatefrom}" title=$myconfig{dateformat}>
<link rel="stylesheet" media="screen" href="javascript/dynCalendar.css" />
<script language="javascript" type="text/javascript" src="javascript/browserSniffer.js"></script>
<script language="javascript" type="text/javascript" src="javascript/dynCalendar.js"></script>

   <script language="JavaScript" type="text/javascript">
    <!--
        /**
        * Example callback function
        */
        function calendar1Callback(date, month, year)
        {
            document.forms['myform'].transdatefrom.value = formatDate(new Date(getDateFromFormat(year + '-' + month + '-' + date,'yyyy-M-d')),'$myconfig{dateformat}');
        }

        calendar1 = new dynCalendar('calendar1', 'calendar1Callback', 'javascript/images/');
    //-->
    </script>
    

</td>


<th align=right>|.$locale->text('To').qq|</th>
<td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=transdateto size=11  value="$form->{transdateto}" title=$myconfig{dateformat}>

   <script language="JavaScript" type="text/javascript">
    <!--
        /**
        * Example callback function
        */
        function calendar1Callback2(date, month, year)
        {
            document.forms['myform'].transdateto.value = formatDate(new Date(getDateFromFormat(year + '-' + month + '-' + date,'yyyy-M-d')),'$myconfig{dateformat}');
        }

        calendar2 = new dynCalendar('calendar2', 'calendar1Callback2', 'javascript/images/');
    //-->
    </script>
    

</td>

</tr>

$listopen

</table>

</td></tr>
</table>

<p>
<input type=hidden name=readonly value=$form->{readonly}>
<input type=hidden name=nextsub value=$form->{nextsub}>
<input type=hidden name=path value=$form->{path}>
<input type=hidden name=login value=$form->{login}>
<input type=hidden name=sessionid value=$form->{sessionid}>
<input type=hidden name=rowcount value=$form->{rowcount}>
<input type=hidden name=pagebreak value=$form->{pagebreak}>
<input type=hidden name=nextfocus value='$form->{nextfocus}'>
<input type=hidden name=printtitle value='$form->{printtitle}'>
<input type=hidden name=title value='$form->{title}'>
<input type=hidden name=sort value='$form->{sort}'>
<input type=hidden name=keys >
<input class=submit type=submit name=action value="|.$locale->text('Continue').qq|">
<input class=submit type=submit name=action value="|.$locale->text('Print').qq|">
</form>

<p>|.$locale->text('To display all transactions, leave fields blank')

.qq|

</body>
</html>
|;

}


sub search_short {
$form->{transdatefrom} =$form->first_day_current_Date(\%myconfig) if $form->{currentdate};
  # setup vendor selection
  $form->all_vc(\%myconfig, "vendor",$form->{group});

  my $selection = "<option selected>" . $locale->text('All Vendors') ."\n" if !$form->{group};

  foreach $ref (@{ $form->{all_vendor} }) {
    $selection .= "<option>$ref->{vendornumber}::$ref->{name}--$ref->{id}\n";
  }

  if ($form->{nextsub} eq "payments") {
    $form->{title} = $locale->text('Process Payments');
    $listopen = qq|
    <input type=hidden name=sort value=invnumber>
    <input type=hidden name=open value=Y>|;
  }
  


  $listopen = qq|
<input type=hidden name=sort value=transdate>
<tr>
<td colspan=3>
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_option" class=checkbox type=checkbox value=Y  $form->{l_option}>&nbsp;|.$locale->text('Show Search Criteria').qq|
</td>
</tr>
<tr>

  <th align=right nowrap>|.$locale->text('Include in Report').qq|</th>
  <td colspan=3>
  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=open class=checkbox type=checkbox value=Y $form->{open}>&nbsp;|.$locale->text('Open').qq|
  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=closed class=checkbox type=checkbox value=Y $form->{closed}>&nbsp;|.$locale->text('Closed').qq|

  <br>


  </td>

</tr>
|;
  $form->header;

  print qq|
  <script>
<!--
function stb(){parent.document.title ="$form->{title}";}

	// -->
</script>

<body bgcolor=ffffff  onLoad=stb()>
<form method=post action=$form->{script} name=myform>

<table border=1>
<tr><th class=listtop bgcolor=000000><font color=ffffff>$form->{title}</font></th></tr>

<tr><td>

<table>

<tr>

<th align=right>|.$locale->text('Vendor').qq|</th>
<td colspan=3><select  onkeypress="selectKeyPress();" onkeydown="setsubmit(this);selectKeyDown();" onblur="clr();" onfocus="clr();"  name=vendor >$selection</select></td>

</tr>


<tr>

<th align=right>|.$locale->text('Invoice Number').qq|</th>
<td colspan=3><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=invnumber  value="$form->{invnumber}" size=20></td>

</tr>

<tr>

<th align=right>|.$locale->text('Order Number').qq|</th>
<td colspan=3><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=ordnumber  value="$form->{ordnumber}" size=20></td>

</tr>

<tr>

<th align=right>|.$locale->text('Notes').qq|</th>
<td colspan=3><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=notes  value="$form->{notes}" size=50></td>

</tr>

<tr>

<th align=right>|.$locale->text('From').qq|</th>
<td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=transdatefrom size=11  value="$form->{transdatefrom}" title=$myconfig{dateformat}>
<link rel="stylesheet" media="screen" href="javascript/dynCalendar.css" />
<script language="javascript" type="text/javascript" src="javascript/browserSniffer.js"></script>
<script language="javascript" type="text/javascript" src="javascript/dynCalendar.js"></script>

   <script language="JavaScript" type="text/javascript">
    <!--
        /**
        * Example callback function
        */
        function calendar1Callback(date, month, year)
        {
            document.forms['myform'].transdatefrom.value = formatDate(new Date(getDateFromFormat(year + '-' + month + '-' + date,'yyyy-M-d')),'$myconfig{dateformat}');
        }

        calendar1 = new dynCalendar('calendar1', 'calendar1Callback', 'javascript/images/');
    //-->
    </script>
    

</td>


<th align=right>|.$locale->text('To').qq|</th>
<td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=transdateto size=11  value="$form->{transdateto}" title=$myconfig{dateformat}>

   <script language="JavaScript" type="text/javascript">
    <!--
        /**
        * Example callback function
        */
        function calendar1Callback2(date, month, year)
        {
            document.forms['myform'].transdateto.value = formatDate(new Date(getDateFromFormat(year + '-' + month + '-' + date,'yyyy-M-d')),'$myconfig{dateformat}');
        }

        calendar2 = new dynCalendar('calendar2', 'calendar1Callback2', 'javascript/images/');
    //-->
    </script>
    

</td>

</tr>

$listopen

</table>

</td></tr>
</table>
|;

print qq|   <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_sr" class=checkbox type=hidden value=Y $>&nbsp;| if $form->{l_sr};
print qq|  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_id" class=checkbox type=hidden value=Y >&nbsp;| if $form->{l_id};
print qq|  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_transtype" class=checkbox type=hidden value=Y >&nbsp;| if $form->{l_transtype};
print qq|  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_subb" class=checkbox type=hidden value=Y>&nbsp;| if $form->{l_subb};
print qq|  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_project" class=checkbox type=hidden value=Y >&nbsp;| if $form->{l_project};
 print qq| <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_invnumber" class=checkbox type=hidden value=Y >&nbsp;| if $form->{l_invnumber};
print qq|  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_ordnumber" class=checkbox type=hidden value=Y >&nbsp;| if $form->{l_ordnumber};
print qq|  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_vendornumber" class=checkbox type=hidden value=Y >&nbsp;| if $form->{l_vendornumber};
print qq|  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_name" class=checkbox type=hidden value=Y >&nbsp;| if $form->{l_name};
print qq|  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_transdate" class=checkbox type=hidden value=Y >&nbsp;| if $form->{l_transdate};
 print qq| <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_netamount" class=checkbox type=hidden value=Y >&nbsp;| if $form->{l_netamount};
 print qq| <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_tax" class=checkbox type=hidden value=Y >&nbsp;| if $form->{l_tax};
 print qq| <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_rowcount" class=checkbox type=hidden value=Y >&nbsp;| if $form->{l_rowcount};
 print qq| <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_amount" class=checkbox type=hidden value=Y >&nbsp;| if $form->{l_amount};
 print qq| <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_datepaid" class=checkbox type=hidden value=Y>&nbsp;| if $form->{l_datepaid};
 print qq| <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_paid" class=checkbox type=hidden value=Y >&nbsp;| if $form->{l_l_paid};
 print qq| <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_duedate" class=checkbox type=hidden value=Y >&nbsp;| if $form->{l_duedate};
print qq|  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_due" class=checkbox type=hidden value=Y >&nbsp;| if $form->{l_due};
print qq|  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_terms" class=checkbox type=hidden value=Y >&nbsp;| if $form->{l_terms};
print qq|  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_notes" class=checkbox type=hidden value=Y >&nbsp;| if $form->{l_notes};
 print qq| <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_subtotal" class=checkbox type=chechidden value=Y >&nbsp;| if $form->{l_subtotal};
print qq|  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_login" class=checkbox type=hidden value=Y >&nbsp;| if $form->{l_login};

  

print qq|
<p>
<input type=hidden name=transtypeno value="$form->{transtypeno}">
<input type=hidden name=batchno value="$form->{batchno}">
<input type=hidden name=transnono value="$form->{transnono}">
<input type=hidden name=subtransno value="$form->{subtransno}">

<input type=hidden name=readonly value=$form->{readonly}>
<input type=hidden name=nextsub value=$form->{nextsub}>
<input type=hidden name=path value=$form->{path}>
<input type=hidden name=login value=$form->{login}>
<input type=hidden name=sessionid value=$form->{sessionid}>
<input type=hidden name=rowcount value=$form->{rowcount}>
<input type=hidden name=pagebreak value=$form->{pagebreak}>
<input type=hidden name=nextfocus value='$form->{nextfocus}'>
<input type=hidden name=printtitle value='$form->{printtitle}'>
<input type=hidden name=title value='$form->{title}'>
<input type=hidden name=sort value='$form->{sort}'>
<input type=hidden name=keys >
<input class=submit type=submit name=action value="|.$locale->text('Continue').qq|">
<input class=submit type=submit name=action value="|.$locale->text('More').qq|">
<input class=submit type=submit name=action value="|.$locale->text('Print').qq|">
</form>

<p>|.$locale->text('To display all transactions, leave fields blank')

.qq|

</body>
</html>
|;

}

sub more{
  @columns = qw(sr transtype subb project transdate  id invnumber ordnumber vendornumber name terms  duedate rowcount netamount tax  amount paid datepaid due   notes login);
    map { $form->{"l_$_"} = "checked" if $form->{"l_$_"} eq "Y" } @columns;
$form->{"open"} = "checked" if $form->{"open"} eq "Y" ;
$form->{"closed"} = "checked" if $form->{"closed"} eq "Y" ;

 &search;
}

sub continue {
  
  &{ $form->{nextsub} };

}

sub purchase_book_report {
$invoice =$locale->text('Bill No.');
 $order= $locale->text('Order');
 &ap_transactions1
}
sub cash_purchase {
$invoice =$locale->text('Ref No.');
$order= $locale->text('P/O NO.');
  &ap_transactions1
}

sub ap_transactions {
$invoice =$locale->text('Invoice');
$order= $locale->text('Order');
  &ap_transactions1

}


##NEW ADDED
sub ap_transaction_print {
  $form->{print}="true";
 &ap_transactions1;


}
sub print {
  
 &ap_transaction_print;


}
sub pagetableheader {

print qq|
<tr $listheading >|;

if($form->{l_sr}){
	print "<th $listprint>$line".$locale->text('SR')."$line</th>";
}
  map { print "\n$column_header{$_}" } @column_index;

  print qq|
  </tr>
|;


}

sub sortheading {
 	print qq|<tr>
	<td $listprint colspan=$colspan><br><b>$column_title{"$form->{sort}"} :</b>$ap->{"$form->{sort}"}
|;
if($form->{sort} eq "vendornumber"){
 	  print qq|
	  	&nbsp;&nbsp;&nbsp;&nbsp;<b>$column_title{name} :</b>$ap->{name}|;
  }
 	print qq|
	</td>
	</tr>
|;

	
}
sub ap_transactions1 {
  map { $form->{$_} = $myconfig{$_} } (qw(company address businessnumber nativecurr fy));
 if(!$form->{print}){
    $listheading="class=listheading";
    $listheadingcolor="color=ffffff";
    $listtop="class=listtop";
    $listrow="class=listrow";
    $listtotal="class=listtotal";
    $listsubtotal="class=listsubtotal";
    $lastline=$locale->text('Click on table headers to sort table')."<br>".$locale->text('Click on invoice number to edit transaction');
    $mouseaction[0]=" onmouseover=\"this.className = 'listover';\" onmouseout=\"this.className = 'listrow0';\"";
    $mouseaction[1]=" onmouseover=\"this.className = 'listover';\" onmouseout=\"this.className = 'listrow1';\"";
    
  }else{
    $line = "<hr size=2 noshade>";
    $fontsize="size=-1";
   $listprint="class=print";
   $listheading="class=print";
    $listtop="class=print";
    $listrow="class=print";
    $listsubtotal="class=print";
 }


  # split vendor
  ($vendor, $form->{vendor_id}) = split(/--/, $form->{vendor});

  # $form->{vendor_id} is needed in AP->ap_transactions
  AP->ap_transactions(\%myconfig, \%$form);

  # construct href
  $href = "$form->{script}?action=ap_transactions&print=$form->{print}&nextsub=$form->{nextsub}&nextfocus=transtype&path=$form->{path}&login=$form->{login}&sessionid=$form->{sessionid}&transdatefrom=$form->{transdatefrom}&transdateto=$form->{transdateto}&open=$form->{open}&closed=$form->{closed}&invnumber=".$form->escape($form->{invnumber})."&ordnumber=".$form->escape($form->{ordnumber})."&notes=".$form->escape($form->{notes})."&vendor=".$form->escape($form->{vendor})."&title=".$form->escape($form->{title});
   

   
    #	$form->{title} = $locale->text('AP Transactions');
 $invoice=$locale->text('Invoice');

  # construct callback
  $vendor = $form->{vendor};
  $vendor =~ s/&/_/g;
  $vendor =~ s/ /%20/g;
  $callback = "$form->{script}?action=ap_transactions&print=$form->{print}&pagebreak=$form->{pagebreak}&nextsub=$form->{nextsub}&nextfocus=transtype&path=$form->{path}&login=$form->{login}&sessionid=$form->{sessionid}&transdatefrom=$form->{transdatefrom}&transdateto=$form->{transdateto}&open=$form->{open}&closed=$form->{closed}&invnumber=$form->{invnumber}&ordnumber=$form->{ordnumber}&notes=$form->{notes}&vendor=$vendor"."&title=".$form->escape($form->{title});
  $href .= "&print=$form->{print}&rowcount=$form->{rowcount}";
  

   #for max
#  @columns = $form->sort_columns(qw(trans subb project transdate  id invnumber ordnumber vendornumber name terms  duedate netamount tax  amount paid datepaid due   notes desc_1 qty_1 amount_1 desc_2 qty_2 amount_2 desc_3 qty_3 amount_3 desc_4 qty_4 amount_4 desc_5 qty_5 amount_5));
  @columns = $form->sort_columns(qw(transtype subb project transdate  id invnumber ordnumber vendornumber name terms  duedate rowcount netamount tax  amount paid datepaid due   notes login));

  foreach $item (@columns) {
    if ($form->{"l_$item"} eq "Y") {
      push @column_index, $item;

      # add column to href and callback
      $callback .= "&l_$item=Y";
      $href .= "&l_$item=Y";
    }
  }

  if ($form->{l_subtotal} eq 'Y') {
    $callback .= "&l_subtotal=Y";
    $href .= "&l_subtotal=Y";
  }

    if ($form->{l_sr} eq 'Y') {
    $callback .= "&l_sr=Y";
    $href .= "&l_sr=Y";
  }
  
     if ($form->{l_description} eq 'Y') {
   	$description =$locale->text('Account Name & Description');
  }else{
    	$description =$locale->text('Account Name');

  }
  
  
       ##for max
   for $i (1 .. 5){
    if ($form->{"l_all"} eq "Y") {
  #    push @column_index,"desc_$i";
  #    push @column_index, "qty_$i";
  #    push @column_index, "amount_$i";
  $column_header{"desc_$i"} = qq|<th $listprint>|.$locale->text('Desc '.$i).qq|$line</th>|;
  $column_header{"qty_$i"} = qq|<th $listprint>|.$locale->text('Qty '.$i).qq|$line</th>|;
  $column_header{"amount_$i"} = qq|<th $listprint>|.$locale->text('Amount '.$i).qq|$line</th>|;
    $callback .= "&l_all=Y";
      }
   }
   
   
   
  
  #   if ($form->{nextsub} eq "ap_transaction") {
 #	$form->{title} = $locale->text('AP Transactions');
#}

   if ($form->{nextsub} eq "purchase_book_report") {
 	$form->{title} = $locale->text('PURCHASE BOOK');
    $lastline2 = 'Y';
    $invoice=$locale->text('Bill No.');
 }

     if ($form->{nextsub} eq "cash_purchase") {
 	$form->{title} = $locale->text('CASH PURCHASE');
    $lastline2 = 'Y';
    $invoice=$locale->text('P/O No.');
  }
  
  
  

($vendor) = split /--/, $form->{vendor};
  if ($form->{vendor_id}) {
    $option .= $vendor;
  }

   if ($form->{transtypeno}) {
   $callback .= "&transtypeno=$form->{transtypeno}";
   $href .= "&transtypeno=$form->{transtypeno}";
    $option .= "\n<br>" if ($option);
    $option .= $locale->text('Trans type')." : $form->{transtypeno}";
  }
  if ($form->{batchno}) {
   $callback .= "&batchno=$form->{batchno}";
   $href .= "&batchno=$form->{batchno}";
    $option .= "\n<br>" if ($option);
    $option .= $locale->text('Batch')." : $form->{batchno}";
  }
  if ($form->{transnono}) {
   $callback .= "&transnono=$form->{transnono}";
   $href .= "&transnono=$form->{transnono}";
    $option .= "\n<br>" if ($option);
    $option .= $locale->text('Trans no')." : $form->{transnono}";
  }
  if ($form->{subtransnono}) {
   $callback .= "&subtransnono=$form->{subtransnono}";
   $href .= "&subtransnono=$form->{subtransnono}";
    $option .= "\n<br>" if ($option);
    $option .= $locale->text('Sub Trans no')." : $form->{subtransnono}";
  }

  if ($form->{invnumber}) {
   $callback .= "&invnumber=$form->{invnumber}";
    $option .= "\n<br>" if ($option);
    $option .= $locale->text('Invoice Number')." : $form->{invnumber}";
  }
  if ($form->{ordnumber}) {
    $option .= "\n<br>" if ($option);
    $option .= $locale->text('Order Number')." : $form->{ordnumber}";
  }
  if ($form->{notes}) {
    $option .= "\n<br>" if ($option);
    $option .= $locale->text('Notes')." : $form->{notes}";
  }
  if ($form->{transdatefrom}) {
    $option .= "\n<br>" if ($option);
    $option .= $locale->text('From')." ".$locale->date(\%myconfig, $form->{transdatefrom}, 1);
  }
  if ($form->{transdateto}) {
    $option .= "\n<br>" if ($option);
    $option .= $locale->text('To')." ".$locale->date(\%myconfig, $form->{transdateto}, 1);
  }
  if ($form->{open}) {
    $option .= "\n<br>" if ($option);
    $option .= $locale->text('Open');
  }
  if ($form->{closed}) {
    $option .= "\n<br>" if ($option);
    $option .= $locale->text('Closed');
  }
   if ($form->{l_subtotal} eq 'Y') {

  @column_index = grep !/$form->{sort}/, @column_index;
  
    if($form->{sort} eq "vendornumber"){
  @column_index = grep !/name/, @column_index;	  
  }
    }
    
    
  
 $column_title{id} = $locale->text('ID');
   $column_title{transtype} = $locale->text('Trans No.');
   $column_title{subb} = $locale->text('Sub No.');
   $column_title{project} = $locale->text('Project No.');
  $column_title{transdate} = $locale->text('Date');
  $column_title{duedate} = $locale->text('Due');
  $column_title{due} = $locale->text('Due');
  $column_title{terms} =$locale->text('Terms');
  $column_title{invnumber} = $invoice;
  $column_title{ordnumber} = $order;
  $column_title{vendornumber} = $locale->text('Account');
  $column_title{name} = $description;
  $column_title{netamount} = $locale->text('Amount');
  $column_title{tax} =$locale->text('Tax');
  $column_title{rowcount} = $locale->text('Total Rows');
  $column_title{amount} = $locale->text('Total');
  $column_title{paid} = $locale->text('Paid');
  $column_title{datepaid} = $locale->text('Date Paid');
  $column_title{notes} =$locale->text('Notes');
  $column_title{login} =$locale->text('Employee');

  $column_header{id} = qq|<th $listprint><a $listheading href=$href&sort=id>$line $column_title{id}</a>$line</th>|;
   $column_header{transtype} = "<th $listprint><a $listprint href=$href&sort=transtype>$line $column_title{transtype}$line</th>";
   $column_header{subb} = "<th $listprint><a $listprint href=$href&sort=subb> $line$column_title{subb}$line</th>";
   $column_header{project} = "<th $listprint><a $listprint href=$href&sort=project>$line $column_title{project}$line</th>";
  $column_header{transdate} = qq|<th $listprint><a $listprint href=$href&sort=transdate>$line $column_title{transdate}</a>$line</th>|;
  $column_header{duedate} = qq|<th $listprint><a $listprint href=$href&sort=duedate>$line $column_title{duedate}</a>$line</th>|;
  $column_header{due} = qq|<th $listprint> $line$column_title{due}$line</th>|;
  $column_header{terms} = qq|<th $listprint> $line$column_title{terms}$line</th>|;
  $column_header{invnumber} = qq|<th $listprint><a $listprint href=$href&sort=invnumber> $line$column_title{invnumber}</a>$line</th>|;
  $column_header{ordnumber} = qq|<th $listprint><a $listprint href=$href&sort=ordnumber> $line$column_title{ordnumber}</a>$line</th>|;
  $column_header{vendornumber} = qq|<th $listprint><a $listprint href=$href&sort=vendornumber> $line$column_title{vendornumber}</a>$line</th>|;
  $column_header{name} = qq|<th $listprint><a $listprint href=$href&sort=name> $line$column_title{name}</a>$line</th>|;
  $column_header{netamount} = qq|<th $listprint>$line $column_title{netamount}$line</th>|;
  $column_header{tax} = qq|<th $listprint>$line$column_title{tax}$line</th>|;
  $column_header{rowcount} = qq|<th $listprint> $line$column_title{rowcount}$line</th>|;
  $column_header{amount} = qq|<th $listprint> $line$column_title{amount}$line</th>|;
  $column_header{paid} = qq|<th $listprint>$line $column_title{paid}$line</th>|;
  $column_header{datepaid} = qq|<th $listprint><a $listprint href=$href&sort=datepaid>$line $column_title{datepaid}</a>$line</th>|;
  $column_header{notes} = qq|<th $listprint><a $listprint> $line$column_title{notes}$line</th>|;
  $column_header{login} = qq|<th $listprint><a $listprint> $line$column_title{login}$line</th>|;


  $colspan = $#column_index + 1;

  $form->header;
 $option ='' if(!$form->{l_option})  ;
  print qq|
<body $listprint>
<p>F/Y : $form->{fy}</p>
<H1 align=center  $listprint>$form->{company}<br>$form->{title}</h1>
$option
<table  $listprint border=0 width=100%>

|;

  # add sort and escape callback
  $callback = $form->escape("$callback&sort=$form->{sort}");

  if (@{ $form->{AP} }) {
    $sameitem = $form->{AP}->[0]->{$form->{sort}};
  }
		&pagetableheader;

  # sums and tax on reports by Antonio Gallardo
  #
  foreach $ap (@{ $form->{AP} }) {
	  if(!$stopprintheading){
		  if ($form->{l_subtotal} eq 'Y') {
				 &sortheading;
		  }
		$stopprintheading="true";
	  }

    if ($form->{l_subtotal} eq 'Y') {
      if ($sameitem ne $ap->{$form->{sort}}) {
	&ap_subtotal;
	$sameitem = $ap->{$form->{sort}};
		  if ($form->{l_subtotal} eq 'Y') {
				 &sortheading;
		  }

      #   &pagetableheader;
         $r+=3;
      }
    }
      

   #for max
  #  for $i (1 .. 5){
  # $callback .="&desc_$i=".$form->escape($ap->{"desc_$i"});
  # $callback .="&qty_$i=".$ap->{"qty_$i"};
  # $callback .="&amount_$i=".$ap->{"amount_$i"};
	
  #  $column_data{"desc_$i"} = "<td  $listprint align=left>". $ap->{"desc_$i"} ."</td>";
  # $column_data{"qty_$i"} = "<td  $listprint align=right>".$form->format_amount(\%myconfig, $ap->{"qty_$i"}, 2, "&nbsp;")."</td>";
 #  $column_data{"amount_$i"} = "<td  $listprint align=right>".$form->format_amount(\%myconfig, $ap->{"amount_$i"} , 2, "&nbsp;")."</td>";

 #  }
   
    $column_data{netamount} = "<td  $listprint align=right>".$form->format_amount(\%myconfig, $ap->{netamount}, 2, "&nbsp;")."</td>";
    $column_data{tax} = "<td  $listprint align=right>".$form->format_amount(\%myconfig, $ap->{amount} - $ap->{netamount}, 2, "&nbsp;") . "</td>";
    $column_data{rowcount} = "<td  $listprint align=right>". $ap->{rowcount} . "</td>";
    $column_data{amount} = "<td  $listprint align=right>".$form->format_amount(\%myconfig, $ap->{amount}, 2, "&nbsp;") . "</td>";
    $column_data{paid} = "<td  $listprint align=right>".$form->format_amount(\%myconfig, $ap->{paid}, 2, "&nbsp;")."</td>";
    $column_data{due} = "<td  $listprint align=right>".$form->format_amount(\%myconfig, $ap->{amount} - $ap->{paid}, 2, "&nbsp;")."</td>";
    $column_data{terms} = "<td  $listprint align=left>". $ap->{terms} ."</td>";

    $totalnetamount += $ap->{netamount};
    $totalamount += $ap->{amount};
    $totalpaid += $ap->{paid};
    $totaldue += ($ap->{amount} - $ap->{paid});

    $subtotalnetamount += $ap->{netamount};
    $subtotalamount += $ap->{amount};
    $subtotalpaid += $ap->{paid};
    $subtotaldue += ($ap->{amount} - $ap->{paid});

    $pagetotalnetamount += $ap->{netamount};
    $pagetotalamount += $ap->{amount};
    $pagetotalpaid += $ap->{paid};
    $pagetotaldue += ($ap->{amount} - $ap->{paid});

    $column_data{transdate} = "<td $listprint >$ap->{transdate}&nbsp;</td>";
    $column_data{duedate} = "<td $listprint >$ap->{duedate}&nbsp;</td>";
    $column_data{datepaid} = "<td $listprint >$ap->{datepaid}&nbsp;</td>";

    $module = ($ap->{invoice}) ? "ir.pl" : $form->{script};

   $column_data{invnumber} = "<td  $listprint ><a href=$module?pagebreak=$form->{pagebreak}&must_select_item=$form->{must_select_item}&show_all_price=$form->{show_all_price}&readonly=$form->{readonly}&print_invoice_mod=$form->{print_invoice_mod}&print_pl_mod=$form->{print_pl_mod}&nextsub=$form->{nextsub}&nextfocus=transtype&subtype=$form->{subtype}&action=edit&id=$ap->{id}&path=$form->{path}&login=$form->{login}&sessionid=$form->{sessionid}&callback=$callback>$ap->{invnumber}</a></td>";
   # $column_data{invnumber} = qq|<td $listprint ><a   $listprint href="$module?print=$form->{print}&pagebreak=$form->{pagebreak}&readonly=$form->{readonly}&action=edit&nextfocus=transtype&path=$form->{path}&id=$ap->{id}&login=$form->{login}&sessionid=$form->{sessionid}&callback=$callback">$ap->{invnumber}</a></td>|;
    $column_data{id} = "<td $listprint >$ap->{id}</td>";
    $column_data{ordnumber} = "<td $listprint >$ap->{ordnumber}&nbsp;</td>";
    $column_data{vendornumber} = "<td $listprint >$ap->{vendornumber}</td>";
    $column_data{name} = "<td  $listprint width=40%>$ap->{name}</td>";
    $column_data{subb} = "<td $listprint >$ap->{subb}</td>";
    $column_data{project} = "<td $listprint >$ap->{project}</td>";
     $column_data{transtype} = "<td $listprint >$ap->{transtype}-$ap->{batch}-$ap->{transno}$ap->{subtransno}</td>";
    $ap->{notes} =~ s/^M/<br>/g;
    $column_data{notes} = "<td $listprint >$ap->{notes}&nbsp;</td>";
    $column_data{login} = "<td $listprint >$ap->{login}&nbsp;</td>";



    $i++;
    $i %= 2;
    $j++;
    $r++;
    
    print "<tr $listrow$i   $mouseaction[$i]>";
        if($form->{l_sr}){

    	print "<td $listprint >$j</td>";
    }
    map { print "\n$column_data{$_}" } @column_index;

    print qq|
    </tr>
|;
#pagebreak printing
#$pagenum=1;
if($form->{rowcount} && $form->{print} && $form->{rowcount} <= $r){
$pagenum++;
    print "<tr $listrow$i  $mouseaction[$i] >";
if($form->{l_sr}){
	print "<th $listprint >$line&nbsp;</th>";
}
	
	  map { $column_data{$_} = "<th $listprint >$line&nbsp;</th>" } @column_index;
if($form->{sort} ne "vendornumber"){
     $column_data{name} = "<th $listprint align=right>$line SubTotal C/F for Page $pagenum</th>";
}else{
     $column_data{invnumber} = "<th $listprint align=right>$line SubTotal C/F for Page $pagenum</th>";
}
if($form->{l_subtotal}){
	$column_data{netamount} = "<th  $listprint align=right>$line".$form->format_amount(\%myconfig, $subtotalnetamount, 2, "&nbsp;")."</th>";
    $column_data{tax} = "<th  $listprint align=right>$line".$form->format_amount(\%myconfig, $subtotalamount - $subtotalnetamount, 2, "&nbsp;") . "</th>";
    $column_data{amount} = "<th  $listprint align=right>$line".$form->format_amount(\%myconfig, $subtotalamount, 2, "&nbsp;") . "</th>";
    $column_data{paid} = "<th  $listprint align=right>$line".$form->format_amount(\%myconfig, $subtotalpaid, 2, "&nbsp;")."</th>";
    $column_data{due} = "<th  $listprint align=right>$line".$form->format_amount(\%myconfig, $subtotalamount - $subtotalpaid, 2, "&nbsp;")."</th>";

}else{
$column_data{netamount} = "<th  $listprint align=right>$line".$form->format_amount(\%myconfig, $pagetotalnetamount, 2, "&nbsp;")."</th>";
    $column_data{tax} = "<th  $listprint align=right>$line".$form->format_amount(\%myconfig, $pagetotalamount - $pagetotalnetamount, 2, "&nbsp;") . "</th>";
    $column_data{amount} = "<th  $listprint align=right>$line".$form->format_amount(\%myconfig, $pagetotalamount, 2, "&nbsp;") . "</th>";
    $column_data{paid} = "<th  $listprint align=right>$line".$form->format_amount(\%myconfig, $pagetotalpaid, 2, "&nbsp;")."</th>";
    $column_data{due} = "<th  $listprint align=right>$line".$form->format_amount(\%myconfig, $pagetotalamount - $pagetotalpaid, 2, "&nbsp;")."</th>";
}
     map { print "\n$column_data{$_}" } @column_index;

     print qq|
     </tr>
</table>

 <p style="page-break-before: always">F/Y : $form->{fy}</p>
<H1  $listprint align=center >$form->{company}<br>$form->{title}</h1>
<table  $listprint border=0 width=100%>

|;
		  if ($form->{l_subtotal} eq 'Y') {
				 &sortheading;
		  }

&pagetableheader;
		  if ($form->{l_subtotal} eq 'Y') {
				 &sortheading;
		  }
		  
if($form->{l_sr}){
	print "<td $listprint >&nbsp;</td>";
}

 	  map { $column_data{$_} = "<td $listprint >&nbsp;</td>" } @column_index;
	  
	  if($form->{l_subtotal}){
	  $column_data{netamount} = "<td  $listprint align=right>".$form->format_amount(\%myconfig, $subtotalnetamount, 2, "&nbsp;")."</td>";
    $column_data{tax} = "<td  $listprint align=right>".$form->format_amount(\%myconfig, $subtotalamount - $subtotalnetamount, 2, "&nbsp;") . "</td>";
    $column_data{amount} = "<td  $listprint align=right>".$form->format_amount(\%myconfig, $subtotalamount, 2, "&nbsp;") . "</td>";
    $column_data{paid} = "<td  $listprint align=right>".$form->format_amount(\%myconfig, $subtotalpaid, 2, "&nbsp;")."</td>";
    $column_data{due} = "<td  $listprint align=right>".$form->format_amount(\%myconfig, $subtotalamount - $subtotalpaid, 2, "&nbsp;")."</td>";
	    
	  }else{
   $column_data{netamount} = "<td  $listprint align=right>".$form->format_amount(\%myconfig, $pagetotalnetamount, 2, "&nbsp;")."</td>";
    $column_data{tax} = "<td  $listprint align=right>".$form->format_amount(\%myconfig, $pagetotalamount - $pagetotalnetamount, 2, "&nbsp;") . "</td>";
    $column_data{amount} = "<td  $listprint align=right>".$form->format_amount(\%myconfig, $pagetotalamount, 2, "&nbsp;") . "</td>";
    $column_data{paid} = "<td  $listprint align=right>".$form->format_amount(\%myconfig, $pagetotalpaid, 2, "&nbsp;")."</td>";
    $column_data{due} = "<td  $listprint align=right>".$form->format_amount(\%myconfig, $pagetotalamount - $pagetotalpaid, 2, "&nbsp;")."</td>";
	  }
	  
if($form->{sort} ne "vendornumber"){
     $column_data{name} = "<td $listprint >**Subtotal B/F for Page $pagenum </td>";
}else{
     $column_data{invnumber} = "<td $listprint >**Subtotal B/F for Page $pagenum </td>";
	
}    map { print "\n$column_data{$_}" } @column_index;
print qq|
</tr>
|;
$r=0;

}

  }
  
  if ($form->{l_subtotal} eq 'Y') {
    &ap_subtotal;
  }
  
  # print totals
  print qq|<tr $listtotal >|;
   if($form->{l_sr}){

    	print "<td $listprint>&nbsp;</td>";
    }
  map { $column_data{$_} = "<td $listprint>&nbsp;</td>" } @column_index;

  $column_data{name} = "<th $listprint  align=right>$line".$locale->text('Grand Total')."$line</th>";
  $column_data{netamount} = "<th $listprint  align=right>$line".$form->format_amount(\%myconfig, $totalnetamount, 2, "&nbsp;")."$line</th>";
  $column_data{tax} = "<th  $listprint align=right>$line".$form->format_amount(\%myconfig, $totalamount - $totalnetamount, 2, "&nbsp;")."$line</th>";
  $column_data{amount} = "<th $listprint  align=right>$line".$form->format_amount(\%myconfig, $totalamount, 2, "&nbsp;")."$line</th>";
  $column_data{paid} = "<th $listprint  align=right>$line".$form->format_amount(\%myconfig, $totalpaid, 2, "&nbsp;")."$line</th>";
  $column_data{due} = "<th $listprint  align=right>$line".$form->format_amount(\%myconfig, $totaldue, 2, "&nbsp;")."$line</th>";

  map { print "$column_data{$_}\n" } @column_index;

  if($lastline2 eq 'Y' ){
	$lastline = "<p  $listprint align=right>".$locale->text('Total for ').$form->{transtypeno}."-".$form->{batchno}."&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; ".$form->format_amount(\%myconfig, $totalnetamount, 2, "&nbsp;")."</p><br>".$lastline;
  }

  print qq|</tr>

</table>

<p>$lastline

</body>
</html>
|;

}


sub ap_subtotal {

  map { $column_data{$_} = "<td $listprint>&nbsp;</td>" } @column_index;

  $column_data{name} = "<th $listprint align=right>$line SubTotal</th>";
  $column_data{netamount} = "<th $listprint align=right>$line".$form->format_amount(\%myconfig, $subtotalnetamount, 2, "&nbsp;")."</th>";
  $column_data{tax} = "<th  $listprint align=right>$line".$form->format_amount(\%myconfig, $subtotalamount - $subtotalnetamount, 2, "&nbsp;")."</th>";
  $column_data{amount} = "<th  $listprint align=right>$line".$form->format_amount(\%myconfig, $subtotalamount, 2, "&nbsp;")."</th>";
  $column_data{paid} = "<th $listprint  align=right>$line".$form->format_amount(\%myconfig, $subtotalpaid, 2, "&nbsp;")."</th>";
  $column_data{due} = "<th  $listprint align=right>$line".$form->format_amount(\%myconfig, $subtotaldue, 2, "&nbsp;")."</th>";

  $subtotalnetamount = 0;
  $subtotalamount = 0;
  $subtotalpaid = 0;
  $subtotaldue = 0;

  print "<tr $listsubtotal>";
     if($form->{l_sr}){

    	print "<th $listprint>&nbsp;</td>";
    }
  map { print "\n$column_data{$_}" } @column_index;

  print qq|
  </tr>
|;

}


sub payments {

  # split vendor
  ($vendor, $form->{vendor_id}) = split(/--/, $form->{vendor});
  
  AP->payments(\%myconfig, \%$form);

  # construct href
  $href = "$form->{script}?action=payments&path=$form->{path}&login=$form->{login}&sessionid=$form->{sessionid}&transdatefrom=$form->{transdatefrom}&transdateto=$form->{transdateto}&open=$form->{open}&invnumber=" . $form->escape($form->{invnumber}) . "&ordnumber=" . $form->escape($form->{ordnumber}) . "&vendor=" . $form->escape($form->{vendor});


  @column_index = $form->sort_columns(qw(invnumber transdate ordnumber name amount currency exchangerate source));

  $column_header{transdate} = qq|<th><a class=listheading href=$href&sort=transdate><font color=ffffff>|.$locale->text('Date').qq|</font></a></th>|;
  $column_header{invnumber} = qq|<th><a class=listheading href=$href&sort=invnumber><font color=ffffff>|.$locale->text('Invoice').qq|</font></a></th>|;
  $column_header{ordnumber} = qq|<th><a class=listheading href=$href&sort=ordnumber><font color=ffffff>|.$locale->text('Order').qq|</font></a></th>|;
  $column_header{name} = qq|<th><a class=listheading href=$href&sort=name><font color=ffffff>|.$locale->text('Vendor').qq|</font></a></th>|;
  $column_header{amount} = qq|<th><font color=ffffff>|.$locale->text('Amount').qq|</font></th>|;
  $column_header{source} = "<th><font color=ffffff>".$locale->text('Source')."</font></th>";
  $column_header{currency} = "<th><font color=ffffff>".$locale->text('Curr')."</font></th>";
  $column_header{exchangerate} = "<th><font color=ffffff>".$locale->text('Exchangerate')."</font></th>";
  

  $form->{title} = $locale->text('Process Payments');
  $colspan = $#column_index + 1;

  $form->header;
    
  print qq|
<body bgcolor=ffffff>

<form method=post action=$form->{script}>

<input type=hidden name=defaultcurrency value=$form->{defaultcurrency}>
<input type=hidden name=fxgain_accno value=$form->{fxgain_accno}>
<input type=hidden name=fxloss_accno value=$form->{fxloss_accno}>

<input type=hidden name=closedto value=$form->{closedto}>

<table border=0>
<tr><th class=listtop bgcolor=000000 colspan=$colspan><font color=ffffff>$form->{title}</font></th></tr>

<tr class=listheading bgcolor=336666>|;

map { print "\n$column_header{$_}" } @column_index;

  print qq|
</tr>
|;

  # construct and escape callback
  $vendor = $form->{vendor};
  $vendor =~ s/&/_/g;
  $callback = $form->escape("$form->{script}?action=payments&path=$form->{path}&login=$form->{login}&sessionid=$form->{sessionid}&transdatefrom=$form->{transdatefrom}&transdateto=$form->{transdateto}&open=$form->{open}&sort=$form->{sort}&vendor=$vendor&invnumber=$form->{invnumber}&ordnumber=$form->{ordnumber}");
  

  # build the popup menu for the accounts
  foreach $key (sort keys %{$form->{paidaccount}}) {
    $paidaccounts .= qq|<option>$form->{paidaccount}{$key}{accno}--$form->{paidaccount}{$key}{description}\n|;
  }

  foreach $ap (@{ $form->{AP} }) {
    $i++;

    $j++; $j %= 2;
    print "<tr class=listrow$j>";
    
    $column_data{transdate} = qq|<td><input type=hidden name="transdate_$i" value=$ap->{transdate}>$ap->{transdate}</td>|;

    $module = ($ap->{invoice}) ? "ir.pl" : $form->{script};
    $column_data{invnumber} = "<td><a href=$module?action=edit&id=$ap->{id}&path=$form->{path}&login=$form->{login}&sessionid=$form->{sessionid}&callback=$callback>$ap->{invnumber}</a></td>";

    $amount = $form->format_amount(\%myconfig, $ap->{amount} / $ap->{exchangerate}, 2, "&nbsp;");

    $column_data{ordnumber} = "<td>$ap->{ordnumber}&nbsp;</td>";
    $column_data{name} = "<td>$ap->{name}</td>";
    $column_data{amount} = "<td align=right>$amount</td>";
    $column_data{currency} = "<td>$ap->{currency}&nbsp;</td>";
    $column_data{exchangerate} = ($ap->{currency} eq $form->{defaultcurrency}) ? "<td>&nbsp;</td>" : "<td>$ap->{exchangerate}</td>";
    $column_data{source} = "<td>&nbsp;</td>";
    
    map { print "$column_data{$_}\n" } @column_index;

    print qq|
</tr>
<tr>
|;
  
    
    # list all the payments
    $totalpaid = 0;
    $column_data{invnumber} = qq|<th>|.$locale->text('Payments').qq|</th>|;
    $column_data{ordnumber} = qq|<td>&nbsp;</td>|;
    
    foreach $ref (@{ $ap->{payments} }) {
      $j++; $j %= 2;

      print "<tr class=listrow$j>";

      $column_data{transdate} = qq|<td>$ref->{transdate}</td>|;
      $column_data{name} = qq|<td>$form->{paidaccount}{$ref->{accno}}{description}</td>|;
      $column_data{amount} = qq|<td align=right>|.$form->format_amount(\%myconfig, $ref->{amount}, 2, "&nbsp;").qq|</td>|;
      $column_data{currency} = qq|<td>$ap->{currency}</td>|;
      $column_data{exchangerate} = ($ap->{currency} eq $form->{defaultcurrency}) ? "<td>&nbsp;</td>" : "<td>$ref->{exchangerate}</td>";
      $column_data{source} = qq|<td>$ref->{source}&nbsp;</td>|;
      
      map { print "\n$column_data{$_}" } @column_index;

      print qq|</tr>\n|;

      $column_data{invnumber} = qq|<td>&nbsp;</td>|;

      $totalpaid += $ref->{amount};
    }
    
    print "</tr><tr>\n";

# arrange data for payment input
    $column_data{transdate} = qq|<td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="datepaid_$i" size=11></td>|;

    $column_data{name} = qq|<td><select  onkeypress="selectKeyPress();" onkeydown="setsubmit(this);selectKeyDown();" onblur="clr();" onfocus="clr();"  name="accno_$i">$paidaccounts</select></td>|;

    $column_data{amount} = qq|<td align=right><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="paid_$i" size=9></td>|;

    $column_data{source} = qq|<td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="source_$i" size=10></td>|;

    $column_data{exchangerate} = ($ap->{currency} eq $form->{defaultcurrency}) ? qq|<td>&nbsp;</td>| : qq|<td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="exchangerate_$i" size=10></td>|;

    map { print "\n$column_data{$_}" } @column_index;

    print qq|
</tr>

<input type=hidden name="currency_$i" value=$ap->{currency}>
<input type=hidden name="iexch_$i" value=$ap->{exchangerate}>
<input type=hidden name="totalpaid_$i" value=$totalpaid>
<input type=hidden name="id_$i" value=$ap->{id}>
<input type=hidden name="AP_$i" value=$ap->{AP_account}>

<tr><td colspan=7><hr size=3 noshade></td></tr>
|;

  }
  
  print qq|
</table>

<input type=hidden name=rowcount value=$i>

<input type=hidden name=path value=$form->{path}>
<input type=hidden name=login value=$form->{login}>
<input type=hidden name=sessionid value=$form->{sessionid}>

<p>
<input class=submit type=submit name=action value="|.$locale->text('Process Payments').qq|">

</form>

<p>|.$locale->text('Click on table headers to sort table').qq|
<br>|.$locale->text('Click on invoice number to edit transaction')

.qq|

</body>
</html>
|;

}


sub process_payments {

  $closedto = $form->datetonum($form->{closedto}, \%myconfig);

  $msg = $locale->text('Cannot post transaction for a closed period!');
   
  # check closedto
  for $i (1 .. $form->{rowcount}) {
    if ($form->{"datepaid_$i"}) {
      $datepaid = $form->datetonum($form->{"datepaid_$i"}, \%myconfig);
      $form->error($msg) if ($datepaid <= $closedto);
    }
  }


  # construct callback
  $form->{callback} = "$form->{script}?action=search&nextsub=payments&path=$form->{path}&login=$form->{login}&sessionid=$form->{sessionid}";

  AP->process_payments(\%myconfig, \%$form);
  $form->redirect;
 
}

sub purchase_report {
 map { $form->{$_} = $myconfig{$_} } (qw(company address businessnumber nativecurr fy));
 if(!$form->{print}){
    $listheading="class=listheading";
    $listheadingcolor="color=ffffff";
    $listtop="class=listtop";
    $listrow="class=listrow";
    $listtotal="class=listtotal";
    $listsubtotal="class=listsubtotal";
  #  $lastline=$locale->text('Click on table headers to sort table')."<br>".$locale->text('Click on invoice number to edit transaction');
  }else{
    $line = "<hr size=2 noshade>";
    $fontsize="size=1";
  $listprint="class=print";
   $listheading="class=print";
    $listtop="class=print";
    $listrow="class=print";
    $listsubtotal="class=print";
  }

  # split customer
  ($customer, $form->{customer_id}) = split(/--/, $form->{customer});

  AP->purchase_report(\%myconfig, \%$form);
   $invoice=$locale->text('Invoice');

  # construct href
  $href = "$form->{script}?action=purchase_report&nextsub=$form->{nextsub}&subtype=$form->{subtype}&invnumber=".$form->escape($form->{invnumber})."&ordnumber=".$form->escape($form->{ordnumber})."&notes=".$form->escape($form->{notes})."&transdatefrom=$form->{transdatefrom}&transdateto=$form->{transdateto}&open=$form->{open}&closed=$form->{closed}&customer=".$form->escape($form->{customer})."&login=$form->{login}&sessionid=$form->{sessionid}&path=$form->{path}&printinvoicerowcount=$form->{printinvoicerowcount}";

  # construct callback
  $vendor = $form->{vendor};
  $vendor =~ s/&/_/g;
  $callback = "$form->{script}?action=purchase_report&nextsub=$form->{nextsub}&subtype=$form->{subtype}&transdatefrom=$form->{transdatefrom}&transdateto=$form->{transdateto}&open=$form->{open}&closed=$form->{closed}&login=$form->{login}&sessionid=$form->{sessionid}&path=$form->{path}&invnumber=$form->{invnumber}&ordnumber=$form->{ordnumber}&notes=$form->{notes}&customer=$customer&printinvoicerowcount=$form->{printinvoicerowcount}";

  @columns = $form->sort_columns(qw(vendornumber name terms   amount  ));

  foreach $item (@columns) {
    if ($form->{"l_$item"} eq "Y") {
      push @column_index, $item;

      # add column to href and callback
      $callback .= "&l_$item=Y";
      $href .= "&l_$item=Y";
    }
  }

  if ($form->{l_subtotal} eq 'Y') {
    $callback .= "&l_subtotal=Y";
    $href .= "&l_subtotal=Y";
  }



    if ($form->{l_sr} eq 'Y') {
    $callback .= "&l_sr=Y";
    $href .= "&l_sr=Y";
  }
  



  $form->{title} = $locale->text('Purchase Report');
 
  
  $column_header{vendornumber} = "<th $listprint><a $listheading href=$href&sort=vendornumber>".$locale->text('Account')."</font></a>$line</th>";
  $column_header{name} = "<th $listprint><a $listheading href=$href&sort=vendornumber,name>".$locale->text('Customer')."</font></a>$line</th>";
  $column_header{amount} = "<th $listprint>" . $locale->text('Total') . "</font>$line</th>";



  ($vendor) = split /--/, $form->{vendor};
  if ($form->{vendor_id}) {
    $option .= $vendor;
  }
 
  if ($form->{transdatefrom}) {
    $option .= "\n<br>" if ($option);
    $option .= $locale->text('From')."&nbsp;".$locale->date(\%myconfig, $form->{transdatefrom}, 1);
  }
  if ($form->{transdateto}) {
    $option .= "\n<br>" if ($option);
    $option .= $locale->text('To')."&nbsp;".$locale->date(\%myconfig, $form->{transdateto}, 1);
  }


  $colspan = $#column_index + 1;


  $form->header;

  print qq|
<body bgcolor=ffffff>
<p >F/Y : $form->{fy}</p>
<H1  $listprint align=center >$form->{company}<br>$form->{title}</h1>

<table $listprint border=0 width=100%>

<tr $listheading >|;
if($form->{l_sr}){
	print "<th $listprint>".$locale->text('SR')."$line</th>";
}
  map { print "\n$column_header{$_}" } @column_index;

  print qq|
  </tr>
|;


  # add sort and escape callback
  $callback = $form->escape("$callback&sort=$form->{sort}");

  if (@{ $form->{AR} }) {
    $sameitem = $form->{AR}->[0]->{$form->{sort}};
  }

  # sums and tax on reports by Antonio Gallardo
  #
  foreach $ar (@{ $form->{AR} }) {

    if ($form->{l_subtotal} eq 'Y') {
      if ($sameitem ne $ar->{$form->{sort}}) {
	&ar_subtotal;
      }
    }



     $column_data{amount} = "<td   $listprint align=right>".$form->format_amount(\%myconfig, $ar->{amount}, 2, "&nbsp;")."</td>";
  
    $subtotalamount += $ar->{amount};
 
    $totalamount += $ar->{amount};
 
    $pagetotalamount += $ar->{amount};
 
    $column_data{terms} = "<td  $listprint >$ar->{terms}&nbsp;</td>";

    $module = ($ar->{invoice}) ? "is.pl" : $form->{script};
    

     $column_data{vendornumber} = "<td  $listprint >$ar->{vendornumber}&nbsp;</td>";
    $column_data{name} = "<td   $listprint width=40%>$ar->{name}</td>";

    $i++; $i %= 2;
     $j++;
         $r++;

     print "<tr $listrow$i  $mouseaction[$i]>";
    if($form->{l_sr}){

    	print "<td  $listprint >$j</td>";
    }

    map { print "\n$column_data{$_}" } @column_index;

    print qq|
</tr>
|;

#pagebreak printing
if($form->{printrowcount} && $form->{print} && $form->{printrowcount} <= $r){
$pagenum++;
    print "<tr $listrow$i   $mouseaction[$i]>";
if($form->{l_sr}){
	print "<td $listprint >$line&nbsp;</td>";
}
	
	  map { $column_data{$_} = "<td $listprint >$line&nbsp;</td>" } @column_index;
#     $column_data{name} = "<td $listprint >$line SubTotal</td>";
 #   $column_data{amount} = "<td  $listprint align=right>$line".$form->format_amount(\%myconfig, $pagetotalamount, 2, "&nbsp;") . "</td>";
     map { print "\n$column_data{$_}" } @column_index;

     print qq|
     </tr>
</table>

 <p style="page-break-before: always">F/Y : $form->{fy}</p>
<H1  $listprint align=center >$form->{company}<br>$form->{title}</h1>
<table  $listprint border=0 width=100%>

<tr $listheading>|;
if($form->{l_sr}){
	print "<th $listprint >".$locale->text('SR')."$line</font></th>";
}
map { print "\n$column_header{$_}" } @column_index;

print qq|
</tr><tr>
|;
if($form->{l_sr}){
	print "<td $listprint >&nbsp;</td>";
}

 	  map { $column_data{$_} = "<td $listprint >&nbsp;</td>" } @column_index;
#    $column_data{amount} = "<td  $listprint align=right>".$form->format_amount(\%myconfig, $pagetotalamount, 2, "&nbsp;") . "</td>";
#     $column_data{name} = "<td $listprint >**Subtotal B/F for Page $pagenum </td>";
    map { print "\n$column_data{$_}" } @column_index;
print qq|
</tr>
|;
$r=0;

}

  }

  if ($form->{l_subtotal} eq 'Y') {
    &ar_subtotal;
  }

  # print totals
  print qq|<tr $listtotal>|;
   if($form->{l_sr}){

    	print "<td  $listprint >&nbsp;</td>";
    }

  map { $column_data{$_} = "<td  $listprint >&nbsp;</td>" } @column_index;

 # $column_data{netamount} = "<th   $listprint align=right>$line".$form->format_amount(\%myconfig, $totalnetamount, 2, "&nbsp;")."</font>$line</th>";
 # $column_data{tax} = "<th   $listprint align=right>$line".$form->format_amount(\%myconfig, $totalamount - $totalnetamount, 2, "&nbsp;")."</font>$line</th>";
 # $column_data{amount} = "<th  $listprint  align=right>$line".$form->format_amount(\%myconfig, $totalamount, 2, "&nbsp;")."</font>$line</th>";
 # $column_data{paid} = "<th   $listprint align=right>$line".$form->format_amount(\%myconfig, $totalpaid, 2, "&nbsp;")."</font>$line</th>";
 # $column_data{due} = "<th   $listprint align=right>$line".$form->format_amount(\%myconfig, $totaldue, 2, "&nbsp;")."</font>$line</th>";

  map { print "\n$column_data{$_}" } @column_index;
  
  if($lastline2 eq 'Y' ){
	$lastline = "<p align=right>".$locale->text('Total for ').$form->{transtypeno}."-".$form->{batchno}."&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; ".$form->format_amount(\%myconfig, $totalnetamount, 2, "&nbsp;")."</p><br>".$lastline;
  }

  print qq|
  </tr>

</table>

<p>$lastline

</body>
</html>
|;

}

sub search2 {
   $form->{transdatefrom} =$form->first_day_current_Date(\%myconfig) if $form->{currentdate};


  $form->{title} = $locale->text('Purchase Summary')." ".$locale->text('Reports');

  $form->header;



  print qq|
  <script>
<!--
function stb(){parent.document.title ="$form->{title}";}

	// -->
</script>

<body bgcolor=ffffff  onLoad=stb()>
<form method=post action=$form->{script} name=search>

<input type=hidden name=sort value=vendornumber>
<input type=hidden name=add value=1>

<table border=1>
<tr><th class=listtop bgcolor=000000><font color=ffffff>$form->{title}</font></th></tr>

<tr valign=top>
<td>
<table>



<tr>

<th align=right>|.$locale->text('From').qq|</th>
<td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=transdatefrom size=11 value=$form->{transdatefrom}  title="($myconfig{dateformat})">
<link rel="stylesheet" media="screen" href="javascript/dynCalendar.css" />
<script language="javascript" type="text/javascript" src="javascript/browserSniffer.js"></script>
<script language="javascript" type="text/javascript" src="javascript/dynCalendar.js"></script>
 
   <script language="JavaScript" type="text/javascript">
    <!--
        /**
        * Example callback function
        */
        function calendar1Callback(date, month, year)
        {
            document.forms['search'].transdatefrom.value = formatDate(new Date(getDateFromFormat(year + '-' + month + '-' + date,'yyyy-M-d')),'$myconfig{dateformat}');
        }

        calendar1 = new dynCalendar('calendar1', 'calendar1Callback', 'javascript/images/');
    //-->
    </script>
    
</td>
<th align=right>|.$locale->text('To').qq|</th>
<td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=transdateto size=11  title="($myconfig{dateformat})">
  <script language="JavaScript" type="text/javascript">
    <!--
        /**
        * Example callback function
        */
        function calendar2Callback(date, month, year)
        {
            document.forms['search'].transdateto.value = formatDate(new Date(getDateFromFormat(year + '-' + month + '-' + date,'yyyy-M-d')),'$myconfig{dateformat}');
        }

        calendar2 = new dynCalendar('calendar2', 'calendar2Callback', 'javascript/images/');
    //-->
    </script>
</td>

</tr>

<tr>
<td>
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_option" class=checkbox type=checkbox value=Y checked>&nbsp;|.$locale->text('Show Search Criteria').qq|
</td>
</tr>
  <th align=right>|.$locale->text('Include in Report').qq|</th>
  <td colspan=3>

    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_sr" class=checkbox type=checkbox value=Y checked>&nbsp;|.$locale->text('SR').qq|
     <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_vendornumber" class=checkbox type=checkbox value=Y checked>&nbsp;|.$locale->text('Vendor no.').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_name" class=checkbox type=checkbox value=Y checked>&nbsp;|.$locale->text('Vendor name').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_amount" class=checkbox type=checkbox value=Y checked>&nbsp;|.$locale->text('Amount').qq|

    </td>

  </tr>


</table>
</td>

</tr>
</table>

<input type=hidden name=nextsub value=purchase_report>
<input type=hidden name=path value=$form->{path}>
<input type=hidden name=login value=$form->{login}>
<input type=hidden name=sessionid value=$form->{sessionid}>

<br>
<input class=submit type=submit name=action value="|.$locale->text('Continue').qq|">
<input class=submit type=submit name=action value="|.$locale->text('Print').qq|">
</form>

<p>
|.$locale->text('To display all transactions, leave fields blank')

  .qq|

</body>
</html>
|;
}
sub generate_report {
 &{$form->{nextsub}}(\%myconfig, \%$form);
}
sub generate_report_print {
 $form->{print}="true";
 &{$form->{nextsub}}(\%myconfig, \%$form);
}
